/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class IntMap {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private Entry[] _table;
    private int _size;
    private int _threshold;
    private float _loadFactor;
    private volatile int _modCount;
    private Entry _entryCache;

    public IntMap(int n, float f) {
        int n2;
        if (n > 0x40000000) {
            n = 0x40000000;
        }
        for (n2 = 1; n2 < n; n2 <<= 1) {
        }
        this._loadFactor = f;
        this._threshold = (int)((float)n2 * f);
        this._table = new Entry[n2];
    }

    public IntMap(int n) {
        this(n, 0.75f);
    }

    public IntMap() {
        this._loadFactor = 0.75f;
        this._threshold = 16;
        this._table = new Entry[16];
    }

    public int size() {
        return this._size;
    }

    public boolean isEmpty() {
        return this._size == 0;
    }

    public Object get(int n) {
        int n2 = IntMap.indexFor(n, this._table.length);
        Entry entry = this._table[n2];
        while (entry != null) {
            if (n == entry.key) {
                return entry.value;
            }
            entry = entry.next;
        }
        return entry;
    }

    public boolean containsKey(int n) {
        int n2 = IntMap.indexFor(n, this._table.length);
        Entry entry = this._table[n2];
        while (entry != null) {
            if (n == entry.key) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public Object put(int n, Object object) {
        int n2 = IntMap.indexFor(n, this._table.length);
        Entry entry = this._table[n2];
        while (entry != null) {
            if (n == entry.key) {
                Object object2 = entry.value;
                entry.value = object;
                return object2;
            }
            entry = entry.next;
        }
        ++this._modCount;
        this.addEntry(n, object, n2);
        return null;
    }

    public Object remove(int n) {
        Entry entry;
        int n2 = IntMap.indexFor(n, this._table.length);
        Entry entry2 = entry = this._table[n2];
        while (entry2 != null) {
            Entry entry3 = entry2.next;
            if (n == entry2.key) {
                ++this._modCount;
                --this._size;
                if (entry == entry2) {
                    this._table[n2] = entry3;
                } else {
                    entry.next = entry3;
                }
                entry2.next = this._entryCache;
                this._entryCache = entry2;
                return entry2.value;
            }
            entry = entry2;
            entry2 = entry3;
        }
        if (entry2 != null) {
            return entry2.value;
        }
        return entry2;
    }

    public void clear() {
        ++this._modCount;
        Entry[] entryArray = this._table;
        for (int i = 0; i < entryArray.length; ++i) {
            entryArray[i] = null;
        }
        this._size = 0;
    }

    public Enumeration elements() {
        return new EntryIterator();
    }

    private static int indexFor(int n, int n2) {
        return n & n2 - 1;
    }

    private void addEntry(int n, Object object, int n2) {
        Entry entry;
        if (this._entryCache != null) {
            entry = this._entryCache;
            this._entryCache = this._entryCache.next;
            entry.key = n;
            entry.value = object;
            entry.next = this._table[n2];
        } else {
            entry = new Entry(n, object, this._table[n2]);
        }
        this._table[n2] = entry;
        if (this._size++ >= this._threshold) {
            this.resize(2 * this._table.length);
        }
    }

    private void resize(int n) {
        Entry[] entryArray = this._table;
        int n2 = entryArray.length;
        if (this._size < this._threshold || n2 > n) {
            return;
        }
        Entry[] entryArray2 = new Entry[n];
        this.transfer(entryArray2);
        this._table = entryArray2;
        this._threshold = (int)((float)n * this._loadFactor);
    }

    private void transfer(Entry[] entryArray) {
        Entry[] entryArray2 = this._table;
        int n = entryArray.length;
        for (int i = 0; i < entryArray2.length; ++i) {
            Entry entry;
            Entry entry2 = entryArray2[i];
            if (entry2 == null) continue;
            entryArray2[i] = null;
            do {
                entry = entry2.next;
                int n2 = IntMap.indexFor(entry2.key, n);
                entry2.next = entryArray[n2];
                entryArray[n2] = entry2;
            } while ((entry2 = entry) != null);
        }
    }

    private class EntryIterator
    implements Enumeration {
        private Entry _next;
        private int _expectedModCount;
        private int _index;
        private Entry _current;

        EntryIterator() {
            this._expectedModCount = IntMap.this._modCount;
            Entry[] entryArray = IntMap.this._table;
            int n = entryArray.length;
            Entry entry = null;
            if (IntMap.this._size != 0) {
                while (n > 0 && (entry = entryArray[--n]) == null) {
                }
            }
            this._next = entry;
            this._index = n;
        }

        public boolean hasMoreElements() {
            return this._next != null;
        }

        public Object nextElement() {
            Entry entry = this._next;
            if (entry == null) {
                throw new NoSuchElementException();
            }
            Entry entry2 = entry.next;
            Entry[] entryArray = IntMap.this._table;
            int n = this._index;
            while (entry2 == null && n > 0) {
                entry2 = entryArray[--n];
            }
            this._index = n;
            this._next = entry2;
            this._current = entry;
            return this._current;
        }

        public void remove() {
            if (this._current == null) {
                throw new IllegalStateException();
            }
            int n = this._current.key;
            this._current = null;
            IntMap.this.remove(n);
            this._expectedModCount = IntMap.this._modCount;
        }
    }

    public static final class Entry {
        int key;
        Object value;
        Entry next;

        Entry(int n, Object object, Entry entry) {
            this.key = n;
            this.value = object;
            this.next = entry;
        }

        public int getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            Object object2 = this.value;
            this.value = object;
            return object2;
        }
    }
}

