#!/usr/bin/python
# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
# Copyright 2009 Didier Roche
#
# This file is part of Quickly ubuntu-application template
#
#This program is free software: you can redistribute it and/or modify it 
#under the terms of the GNU General Public License version 3, as published 
#by the Free Software Foundation.

#This program is distributed in the hope that it will be useful, but 
#WITHOUT ANY WARRANTY; without even the implied warranties of 
#MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
#PURPOSE.  See the GNU General Public License for more details.

#You should have received a copy of the GNU General Public License along 
#with this program.  If not, see <http://www.gnu.org/licenses/>.

import sys
import os
import shutil
import subprocess

from quickly import configurationhandler
from quickly import templatetools

import gettext
from gettext import gettext as _
# set domain text
gettext.textdomain('quickly')



def usage():
    templatetools.print_usage(_('sudo quickly install'))
def help():
    print _("""This will install your lens description file into
 /usr/share/unity/leneses/ and restart Unity so that your lens will be available
  for testing""")
templatetools.handle_additional_parameters(sys.argv, help, usage=usage)

if os.getuid() > 0:
    print _("Only root can install lens files")
    sys.exit(1)

# if config not already loaded
if not configurationhandler.project_config:
    configurationhandler.loadConfig()

project_name = configurationhandler.project_config['project']
# String trailing -lens from project name, we'll add it back in as necessary
lens_name = project_name
if lens_name[:6] == 'unity-':
    lens_name = lens_name[6:]
if lens_name[-5:] == '-lens':
    lens_name = lens_name[:-5]
elif lens_name[:5] == 'lens-':
    lens_name = lens_name[5:]

# install lens config file
if not os.path.exists('/usr/share/unity/lenses/%s' % lens_name):
    os.mkdir('/usr/share/unity/lenses/%s' % lens_name)
shutil.copy('./%s.lens' % lens_name, '/usr/share/unity/lenses/%s' % lens_name)
shutil.copy('./unity-lens-%s.svg' % lens_name, '/usr/share/unity/lenses/%s' % lens_name)

# restart unity
os.system('sudo -u %s unity --replace &' % os.environ.get('SUDO_USER', 'root'))

print _("Congrats, your new lens has been installed.")


sys.exit(0)
