<?xml version='1.0'?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version='1.0'>

<!--#######################################################################
    		XSLT Stylesheet DocBook -> LaTeX 
		modifications for QTIPLOT manual
    ####################################################################### -->

<xsl:variable name="latex.book.preamblestart">
  <xsl:text>% -----------------------------------------  &#10;</xsl:text>
  <xsl:text>% Autogenerated LaTeX file from XML DocBook  &#10;</xsl:text>
  <xsl:text>% Modified (Roger GADIOU, 2007) for Qtiplot  &#10;</xsl:text>
  <xsl:text>% -----------------------------------------  &#10;</xsl:text>
  <xsl:text>\documentclass</xsl:text>
  <xsl:if test="$latex.class.options!=''">
    <xsl:text>[</xsl:text>
    <xsl:value-of select="$latex.class.options"/>
    <xsl:text>]</xsl:text>
  </xsl:if>
  <xsl:text>{</xsl:text>
  <xsl:value-of select="$latex.class.book"/>
  <xsl:text>}&#10;</xsl:text>
  <xsl:text>\usepackage[T1]{fontenc}&#10;</xsl:text>
  <xsl:text>\usepackage[latin1]{inputenc}&#10;</xsl:text>
<!-- debut modification QTIPLOT 
	1st solution: use of a4wide package

  <xsl:text>\usepackage{a4wide}&#10;</xsl:text>

	2nd solution: use of package geometry
-->
  <xsl:text>\usepackage{geometry}&#10;</xsl:text>
  <xsl:text>\geometry{verbose,a4paper,tmargin=2cm,bmargin=1.5cm,lmargin=1cm,rmargin=1cm}&#10;</xsl:text>
<!-- fin modification QTIPLOT   -->
  <xsl:text>\setcounter{secnumdepth}{5}&#10;</xsl:text>
  <xsl:text>\usepackage{fancybox}&#10;</xsl:text>
  <xsl:text>\usepackage{makeidx}&#10;</xsl:text>
<!-- debut modification QTIPLOT -->
  <xsl:text>\usepackage{fancyhdr}&#10;</xsl:text>
<!-- fin modification QTIPLOT   -->
</xsl:variable>


<xsl:variable name="latex.book.begindocument">
  <xsl:text>\begin{document}&#10;</xsl:text>
  <xsl:text>\pagestyle{fancy}&#10;</xsl:text>
  <xsl:text>\renewcommand{\headrulewidth}{0.4pt}&#10;</xsl:text>
</xsl:variable>

</xsl:stylesheet>
