/*
    VLDocking Framework 2.1
    Copyright VLSOLUTIONS, 2004-2006

    email : info@vlsolutions.com
------------------------------------------------------------------------
This software is distributed under the CeCILL license, a GNU GPL-compatible
license adapted to french law.
French and English license headers are provided at the begining of
the source files of this software application.
------------------------------------------------------------------------
LICENCE CeCILL (FRENCH VERSION).
------------------------------------------------------------------------
Ce logiciel est un programme informatique servant  amliorer les interfaces
homme-machine d'applications Java bases sur Swing, en leur apportant un
ensemble de fonctions relatives au dockage des composants.

Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA
sur le site "http://www.cecill.info".

En contrepartie de l'accessibilit au code source et des droits de copie,
de modification et de redistribution accords par cette licence, il n'est
offert aux utilisateurs qu'une garantie limite.  Pour les mmes raisons,
seule une responsabilit restreinte pse sur l'auteur du programme,  le
titulaire des droits patrimoniaux et les concdants successifs.

A cet gard  l'attention de l'utilisateur est attire sur les risques
associs au chargement,   l'utilisation,   la modification et/ou au
dveloppement et  la reproduction du logiciel par l'utilisateur tant
donn sa spcificit de logiciel libre, qui peut le rendre complexe 
manipuler et qui le rserve donc  des dveloppeurs et des professionnels
avertis possdant  des  connaissances  informatiques approfondies.  Les
utilisateurs sont donc invits  charger  et  tester  l'adquation  du
logiciel  leurs besoins dans des conditions permettant d'assurer la
scurit de leurs systmes et ou de leurs donnes et, plus gnralement,
 l'utiliser et l'exploiter dans les mmes conditions de scurit.

Le fait que vous puissiez accder  cet en-tte signifie que vous avez
pris connaissance de la licence CeCILL, et que vous en avez accept les
termes.

------------------------------------------------------------------------
CeCILL License (ENGLISH VERSION)
------------------------------------------------------------------------

This software is a computer program whose purpose is to enhance Human-Computer
Interfaces written in Java with the Swing framework, providing them a set of
functions related to component docking.

This software is governed by the CeCILL  license under French law and
abiding by the rules of distribution of free software.  You can  use,
modify and/ or redistribute the software under the terms of the CeCILL
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info".

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability.

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or
data to be ensured and,  more generally, to use and operate it in the
same conditions as regards security.

The fact that you are presently reading this means that you have had
knowledge of the CeCILL license and that you accept its terms.

*/


package com.vlsolutions.swing.docking;

import java.awt.*;

/** General information about the current state of a dockable component.
 * <p>
 * This class is a simple record of a dockable and its current display state.
 * <p> It is used together with DockableStateChangeEvents (and listeners) to
 * track changes of Dockable visibility.
 *
 *
 * @author Lilian Chamontin, vlsolutions.
 * @version 1.0
 *
 * @update 2005/10/07 Lilian Chamontin : added getStateName(int state) method
 */
public class DockableState implements Comparable {
  private Dockable dockable;
  
  private static final String [] stateNames = {"CLOSED", "DOCKED", "HIDDEN", "MAXIMIZED", "FLOATING"};

  /** A constant describing a Dockable that is not visible.
   *
   */
  public static final int STATE_CLOSED = 0; // only registered

  /** A constant describing a Dockable that is visible (displayed in a DockableContainer) */
  public static final int STATE_DOCKED = 1;

  /** A constant describing a Dockable that is in auto-hide mode (reduced to a button) */
  public static final int STATE_HIDDEN = 2;

  /** A constant describing a Dockable that is currently maximized */
  public static final int STATE_MAXIMIZED = 3;

  /** A constant describing a Dockable that is currently floating (detached from the desktop) */
  public static final int STATE_FLOATING = 4;
  
  private int state ;

  /** Relative position for hidden/closed dockable show-again */
  private RelativeDockablePosition position;

  /** Desktop currently using this dockable */
  private DockingDesktop desktop;


  public DockableState() {
    position = new RelativeDockablePosition();
  }

  public DockableState(DockingDesktop desktop, Dockable dockable, int state) {
    this.desktop = desktop;
    this.dockable = dockable;
    this.state = state;
    position = new RelativeDockablePosition();
  }

  public DockableState(DockingDesktop desktop, Dockable dockable, int state, RelativeDockablePosition position) {
    this.desktop = desktop;
    this.dockable = dockable;
    this.state = state;
    this.position = position;
  }
  
  /** Creates a dockable state based on an existing state, with another relative positionning */
  public DockableState(DockableState copy, RelativeDockablePosition position) {
    this.desktop = copy.desktop;
    this.dockable = copy.dockable;
    this.state = copy.state;
    this.position = position;
  }

  /** Comparable interface, used to sort components by name order.
   * */
  public int compareTo(Object object) {
    if (object instanceof DockableState){
      return dockable.getDockKey().getName().compareTo( ( (DockableState)
          object).dockable.getDockKey().getName());
    } else {
      return -1;
    }
  }

  /** Returns the dockable this state is for */
  public Dockable getDockable() {
    return dockable;
  }

  /** Convenience method returning wether the dockable is in the DOCKED state */
  public boolean isDocked(){
    return state == STATE_DOCKED;
  }

  /** Convenience method returning wether the dockable is in the HIDDEN state */
  public boolean isHidden(){
    return state == STATE_HIDDEN;
  }
  
  /** Convenience method returning wether the dockable is in the CLOSED state */
  public boolean isClosed(){
    return state == STATE_CLOSED;
  }
  
  /** Convenience method returning wether the dockable is in the FLOATING state */
  public boolean isFloating(){
    return state == STATE_FLOATING;
  }
  
  /** Convenience method returning wether the dockable is in the MAXIMIZED state */
  public boolean isMaximized(){
    return state == STATE_MAXIMIZED;
  }

  /** Returns the current state of the dockable (CLOSED, DOCKED, HIDDEN...).
   */
  public int getState() {
    return state;
  }

  /** Returns the relative restore position of the dockable when it is not shown (auto-hide
   * or closed).
   * <P>
   * Please note that this position is meaningless for visible components
   * (as it is not automatically calculated at every move / resize of the dockable ).
   *
   * */
  public RelativeDockablePosition getPosition(){
    return position;
  }

  public String toString(){
    return "DockableState [" + dockable.getDockKey() + ", state=" + stateNames[state] + ", position="
        + position;
  }
  
  /** Returns a litteral representation of the given state 
   *@since 2.0.1
   */
  public static String getStateName(int state){ //2005/10/07
    return stateNames[state];
  }

  /** Returns the desktop currently using this dockable, or null if none 
   *
   * @since 2.1
   */
  public DockingDesktop getDesktop() {
    return desktop;
  }

  /** Updates the desktop field (desktop using this dockable)
   * @since 2.1
   */
  public void setDesktop(DockingDesktop desktop) {
    this.desktop = desktop;
  }
  
  

}
