/*
 * Decompiled with CFR 0.152.
 */
package org.boehn.kmlframework.utils;

public class Ellipsoid {
    private static double a = 6378137.0;
    private static double f = 298.257223563;
    private static double fInverted = 1.0 / f;
    private static double eps2 = fInverted * (2.0 - fInverted);
    private static double k1 = Math.toRadians(a * (1.0 - eps2));
    private static double k2 = Math.toRadians(a);

    public static final double meterToLongitude(double latitude) {
        return 1.0 / Ellipsoid.longitudeToMeter(latitude);
    }

    public static final double meterToLatitude(double latitude) {
        return 1.0 / Ellipsoid.latitudeToMeter(latitude);
    }

    public static final double longitudeToMeter(double latitude) {
        return Math.cos(Math.toRadians(latitude)) * k2 / Math.sqrt(Ellipsoid.getDiv0(latitude));
    }

    public static final double latitudeToMeter(double latitude) {
        return k1 / Math.sqrt(Math.pow(Ellipsoid.getDiv0(latitude), 3.0));
    }

    private static final double getDiv0(double latitude) {
        return 1.0 - eps2 * Math.pow(Math.sin(Math.toRadians(latitude)), 2.0);
    }
}

