//start of PreLh5Decoder.java
//TEXT_STYLE:CODE=Shift_JIS(Japanese):RET_CODE=CRLF

/**
 * PreLh5Decoder.java
 * 
 * Copyright (C) 2001-2002  Michel Ishizuka  All rights reserved.
 * 
 * ȉ̏ɓӂȂ΃\[XƃoCi`̍ĔzzƎgp
 * ύX̗Lɂ炸B
 * 
 * PD\[XR[h̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐ێȂĂ͂ȂȂB
 * 
 * QDoCi`̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐gp ̑̔zz
 *     ܂ގɋLqȂ΂ȂȂB
 * 
 * ̃\tgEFA͐Β˔ڂɂĖۏ؂Œ񋟂A̖
 * IBłƂۏ؁AilLƂۏ؂ɂƂǂ܂炸A
 * Ȃ閾IшÎIȕۏ؂ȂB
 * Β˔ڂ ̃\tgEFA̎gpɂ钼ړIAԐړIA
 * IAȁAT^IȁA邢͕KRIȑQ(gpɂf[^
 * AƖ̒f〈܂Ăv̈⎸A֐i
 * T[rX̓l邪AĂꂾɌ肳Ȃ
 * Q)ɑ΂āAȂ鎖Ԃ̌ƂȂƂĂA_̐
 * C△ߎӔC܂ ȂӔC낤ƂAƂꂪs
 * ŝׂ߂łƂĂA܂͂̂悤ȑQ̉\
 * ĂƂĂ؂̐ӔC𕉂Ȃ̂ƂB
 */

package jp.gr.java_conf.dangan.util.lha;

//import classes and interfaces
import java.io.InputStream;
import java.lang.Math;
import jp.gr.java_conf.dangan.io.Bits;
import jp.gr.java_conf.dangan.util.lha.CompressMethod;
import jp.gr.java_conf.dangan.util.lha.StaticHuffman;
import jp.gr.java_conf.dangan.util.lha.PreLzssDecoder;

//import exceptions
import java.io.IOException;
import java.io.EOFException;
import java.lang.NullPointerException;
import java.lang.IllegalArgumentException;
import jp.gr.java_conf.dangan.io.BitDataBrokenException;
import jp.gr.java_conf.dangan.io.NotEnoughBitsException;
import jp.gr.java_conf.dangan.util.lha.BadHuffmanTableException;


/**
 * -lh4-, -lh5-, -lh6-, -lh7- 𓀗p PreLzssDecoderB<br>
 * 
 * <pre>
 * -- revision history --
 * $Log: PreLh5Decoder.java,v $
 * Revision 1.3  2002/12/08 00:00:00  dangan
 * [bug fix]
 *     readCode Ńnt}ǂݍݓr
 *     EndOfStream ɒBꍇ EOFException 𓊂ĂȂB
 *
 * Revision 1.2  2002/12/08 00:00:00  dangan
 * [change]
 *     NX  PreLh5DecoderFast  PreLh5Decoder ɕύXB
 *
 * Revision 1.1  2002/12/06 00:00:00  dangan
 * [maintenance]
 *     \[X
 *
 * Revision 1.0  2002/08/05 00:00:00  dangan
 * add to version control
 * [maintenance]
 *     ŐV BitInputStream  PreLh5Decoder \[X荞ށB
 *     \[X
 *     ^up~
 *     CZX̏C
 *
 * </pre>
 * 
 * @author  $Author: dangan $
 * @version $Revision: 1.3 $
 */
public class PreLh5Decoder implements PreLzssDecoder{


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  source
    //------------------------------------------------------------------
    //  private InputStream in
    //------------------------------------------------------------------
    /**
     * ڑꂽ̓Xg[
     */
    private InputStream in;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  staff of BitInputStream
    //------------------------------------------------------------------
    //  cache
    //------------------------------------------------------------------
    //  private byte[] cache
    //  private int    cacheLimit
    //  private int    cachePosition
    //------------------------------------------------------------------
    /**
     * xቺ}~poCgz
     */
    private byte[] cache;

    /**
     * cache ̗LoCg
     */
    private int    cacheLimit;

    /**
     * cache ̌ݏʒu
     */
    private int    cachePosition;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  staff of BitInputStream
    //------------------------------------------------------------------
    //  bit buffer
    //------------------------------------------------------------------
    //  private int    bitBuffer
    //  private int    bitCount
    //------------------------------------------------------------------
    /**
     * rbgobt@
     */
    private int    bitBuffer;

    /**
     * bitBuffer  Lrbg
     */
    private int    bitCount;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  huffman decoder
    //------------------------------------------------------------------
    //  private int blockSize
    //  private int[] codeLen
    //  private short[] codeTable
    //  private int codeTableBits
    //  private short[][] codeTree
    //  private short[] offLenTable
    //  private int offLenTableBits
    //  private short[][] offLenTree
    //------------------------------------------------------------------
    /**
     * ݏ̃ubN̎cTCYB
     */
    private int blockSize;

    /**
     * code ̃nt}̕\
     */
    private int[] codeLen;

    /**
     * code p̃e[u
     * ̏ꍇ codeTree indexB
     * ̏ꍇ code Srbg]́B 
     */
    private short[] codeTable;

    /**
     * codeTable ߂ɕKvbitB
     */
    private int codeTableBits;

    /**
     * codeTable Ɏ܂肫Ȃf[^̕p̖
     * ̏ꍇ codeTree indexB
     * ̏ꍇ code Srbg]́B 
     */
    private short[][] codeTree;

    /**
     * offLen ̃nt}̕\
     */
    private int[] offLenLen;

    /**
     * offLen p̃e[u
     * ̏ꍇ offLenTree indexB
     * ̏ꍇ offLen Srbg]́B 
     */
    private short[] offLenTable;

    /**
     * offLenTable ߂ɕKvbitB
     */
    private int offLenTableBits;

    /**
     * offLenTable Ɏ܂肫Ȃf[^̕p̖
     * ̏ꍇ offLenTree indexB
     * ̏ꍇ offLen Srbg]́B 
     */
    private short[][] offLenTree;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  LZSS parameter
    //------------------------------------------------------------------
    //  private int DictionarySize
    //  private int MaxMatch
    //  private int Threshold
    //------------------------------------------------------------------
    /**
     * LZSS TCY
     */
    private int DictionarySize;

    /**
     * LZSS Œv
     */
    private int MaxMatch;

    /**
     * LZSS k/񈳏k臒l
     */
    private int Threshold;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  backup for mark/reset
    //------------------------------------------------------------------
    //  private boolean markPositionIsInCache
    //  private byte[]    markCache
    //  private int       markCacheLimit
    //  private int       markCachePosition
    //  private int       markBitBuffer
    //  private int       markBitCount
    //  private int       markBlockSize
    //  private int[]     markCodeLen
    //  private short[]   markCodeTable
    //  private short[][] markCodeTree
    //  private int[]     markOffLenLen
    //  private short[]   markOffLenTable
    //  private short[][] markOffLenTree
    //------------------------------------------------------------------
    /** 
     * markʒuLbV͈͓̔ɂ邩B
     * markꂽƂ true ɐݒ肳A
     *  in  LbVւ̓ǂݍ݂
     * sꂽƂ false ɐݒ肳B
     */
    private boolean markPositionIsInCache;

    /** cache  obNAbvp */
    private byte[]    markCache;
    /** cacheAvailable ̃obNAbvp */
    private int       markCacheLimit;
    /** cachePosition ̃obNAbvp */
    private int       markCachePosition;
    /** bitBuffer ̃obNAbvp */
    private int       markBitBuffer;
    /** bitCount ̃obNAbvp */
    private int       markBitCount;
    /** blockSizẽobNAbvp */
    private int       markBlockSize;
    /** codeLen ̃obNAbvp */
    private int[]     markCodeLen;
    /** codeTable ̃obNAbvp */
    private short[]   markCodeTable;
    /** codeTree ̃obNAbvp */
    private short[][] markCodeTree;
    /** offLenLen ̃obNAbvp */
    private int[]     markOffLenLen;
    /** offLenTable ̃obNAbvp */
    private short[]   markOffLenTable;
    /** offLenTree ̃obNAbvp */
    private short[][] markOffLenTree;


    //------------------------------------------------------------------
    //  constructor
    //------------------------------------------------------------------
    //  private PreLh5Decoder()
    //  public PreLh5Decoder( InputStream in )
    //  public PreLh5Decoder( InputStream in, String CompressMethod )
    //  public PreLh5Decoder( InputStream in, String CompressMethod, 
    //                            int CodeTableBits, int OffLenTableBits )
    //------------------------------------------------------------------
    /**
     * ftHgRXgN^B
     * gpsB
     */
    private PreLh5Decoder(){    }

    /**
     * -lh5- 𓀗p PreLzssDecoder \zB<br>
     * e[uTCY̓ftHglgpB
     * 
     * @param in -lh5-`̈kf[^̓Xg[
     */
    public PreLh5Decoder( InputStream in ){
        this( in, CompressMethod.LH5, 12, 8 );
    }

    /**
     * -lh4-,-lh5-,-lh6-,-lh7- 𓀗p PreLzssDecoder \zB<br>
     * e[uTCYɂ ftHglgpB
     * 
     * @param in      kf[^̓Xg[
     * @param method  k@ʎq<br>
     *  &emsp;&emsp; CompressMethod.LH4 <br>
     *  &emsp;&emsp; CompressMethod.LH5 <br>
     *  &emsp;&emsp; CompressMethod.LH6 <br>
     *  &emsp;&emsp; CompressMethod.LH7 <br>
     *  &emsp;&emsp; ̉ꂩw肷B
     * 
     * @exception IllegalArgumentException 
     *               method LȊȌꍇ
     */
    public PreLh5Decoder( InputStream in,
                              String      method ){

        this( in, method, 12, 8 );
    }

    /**
     * -lh4-,-lh5-,-lh6-,-lh7- 𓀗p PreLzssDecoder \zB
     * 
     * @param in              kf[^̓Xg[
     * @param method          k@ʎq<br>
     *           &emsp;&emsp; CompressMethod.LH4 <br>
     *           &emsp;&emsp; CompressMethod.LH5 <br>
     *           &emsp;&emsp; CompressMethod.LH6 <br>
     *           &emsp;&emsp; CompressMethod.LH7 <br>
     *           &emsp;&emsp; ̉ꂩw肷B
     * @param CodeTableBits   code 𕜍邽߂Ɏgp
     *                        e[ũTCYrbgŎw肷B 
     *                        12 w肷 4096 ̃bNAbve[u𐶐B 
     * @param OffLenTableBits offLen 𕜍邽߂Ɏgp
     *                        e[ũTCYrbgŎw肷B
     *                        8 w肷 256 ̃bNAbve[u𐶐B 
     * 
     * @exception IllegalArgumentException <br>
     *           &emsp;&emsp; (1) method LȊȌꍇ<br>
     *           &emsp;&emsp; (2) CodeTableBits  
     *                            OffLenTableBits  0ȉ̏ꍇ<br>
     *           &emsp;&emsp; ̉ꂩ
     */
    public PreLh5Decoder( InputStream in,
                              String      method,
                              int         CodeTableBits,
                              int         OffLenTableBits ){
        if( CompressMethod.LH4.equals( method )
         || CompressMethod.LH5.equals( method )
         || CompressMethod.LH6.equals( method )
         || CompressMethod.LH7.equals( method ) ){

            this.DictionarySize = CompressMethod.toDictionarySize( method );
            this.MaxMatch       = CompressMethod.toMaxMatch( method );
            this.Threshold      = CompressMethod.toThreshold( method );

            if( in != null
             && 0 < CodeTableBits
             && 0 < OffLenTableBits ){
                this.in              = in;
                this.cache           = new byte[ 1024 ];
                this.cacheLimit      = 0;
                this.cachePosition   = 0;
                this.bitBuffer       = 0;
                this.bitCount        = 0;
                this.blockSize       = 0;
                this.codeTableBits   = CodeTableBits;
                this.offLenTableBits = OffLenTableBits;

                this.markPositionIsInCache = false;
                this.markCache             = null;
                this.markCacheLimit        = 0;
                this.markCachePosition     = 0;
                this.markBitBuffer         = 0;
                this.markBitCount          = 0;

            }else if( in == null ){
                throw new NullPointerException( "in" );
            }else if( CodeTableBits <= 0 ){
                throw new IllegalArgumentException( "CodeTableBits too small. CodeTableBits must be larger than 1." );
            }else{
                throw new IllegalArgumentException( "OffHiTableBits too small. OffHiTableBits must be larger than 1." );
            }
        }else if( null == method ){
            throw new NullPointerException( "method" );
        }else{
            throw new IllegalArgumentException( "Unknown compress method " + method );
        }
    }


    //------------------------------------------------------------------
    //  method of jp.gr.java_conf.dangan.util.lha.PreLzssDecoder
    //------------------------------------------------------------------
    //  read
    //------------------------------------------------------------------
    //  public int readCode()
    //  public int readOffset()
    //------------------------------------------------------------------
    /**
     * -lh5- n̈k@ňkꂽ 
     * 1byte LZSSk̃f[^A
     * ͈kR[ĥvǂݍށB<br>
     * 
     * @return 1byte  k̃f[^A
     *         ͈kꂽkR[ĥv
     * 
     * @exception IOException  o̓G[ꍇ
     * @exception EOFException EndOfStreamɒBꍇ
     * @exception BadHuffmanTableException
     *                         nt}؂\邽߂
     *                         nt}̕\słꍇ
     */
    public int readCode() throws IOException {
        if( this.blockSize <= 0 ){
            this.readBlockHead();
        }
        this.blockSize--;

        if( this.bitCount < 16 ){
            if( 2 <= this.cacheLimit - this.cachePosition ){
                this.bitBuffer |=   ( ( this.cache[ this.cachePosition++ ] & 0xFF ) << ( 24 - this.bitCount ) )
                                  | ( ( this.cache[ this.cachePosition++ ] & 0xFF ) << ( 16 - this.bitCount ) );
                this.bitCount  += 16;
            }else{
                this.fillBitBuffer();

                int node = this.codeTable[ this.bitBuffer >>> ( 32 - this.codeTableBits ) ];
                if( 0 <= node ){
                    int bits = this.bitBuffer << this.codeTableBits;
                    do{
                        node = this.codeTree[ bits >>> 31 ][ node ];
                        bits <<= 1;
                    }while( 0 <= node );
                }
                int len = this.codeLen[ ~node ];
                if( len <= this.bitCount ){
                    this.bitBuffer <<= len;
                    this.bitCount   -= len;

                    return ~node;
                }else{
                    this.bitCount  = 0;
                    this.bitBuffer = 0;
                    throw new EOFException();
                }
            }
        }

        int node = this.codeTable[ this.bitBuffer >>> ( 32 - this.codeTableBits ) ];
        if( 0 <= node ){
            int bits = this.bitBuffer << this.codeTableBits;
            do{
                node = this.codeTree[ bits >>> 31 ][ node ];
                bits <<= 1;
            }while( 0 <= node );
        }
        int len = this.codeLen[ ~node ];
        this.bitBuffer <<= len;
        this.bitCount   -= len;

        return ~node;
    }

    /**
     * -lh5- n̈k@ňkꂽ
     * LZSSkR[ĥvʒuǂݍށB<br>
     * 
     * @return -lh5- nňkꂽkR[ĥvʒu
     * 
     * @exception IOException o̓G[ꍇ
     */
    public int readOffset() throws IOException {
        if( this.bitCount < 16 ){
            if( 2 <= this.cacheLimit - this.cachePosition ){
                this.bitBuffer |=   ( ( this.cache[ this.cachePosition++ ] & 0xFF ) << ( 24 - this.bitCount ) )
                                  | ( ( this.cache[ this.cachePosition++ ] & 0xFF ) << ( 16 - this.bitCount ) );
                this.bitCount  += 16;
            }else{
                this.fillBitBuffer();
            }
        }

        int node = this.offLenTable[ this.bitBuffer >>> ( 32 - this.offLenTableBits ) ];
        if( 0 <= node ){
            int bits = this.bitBuffer << this.offLenTableBits;
            do{
                node = this.offLenTree[ bits >>> 31 ][ node ];
                bits <<= 1;
            }while( 0 <= node );
        }
        int offlen = ~node;
        int len = this.offLenLen[ offlen ];
        this.bitBuffer <<= len;
        this.bitCount   -= len;

        offlen--;
        if( 0 <= offlen ){
            return ( 1 << offlen ) | this.readBits( offlen );
        }else{
            return 0;
        }
    }


    //------------------------------------------------------------------
    //  method of jp.gr.java_conf.dangan.util.lha.PreLzssDecoder
    //------------------------------------------------------------------
    //  mark/reset
    //------------------------------------------------------------------
    //  public void mark( int readLimit )
    //  public void reset()
    //  public boolean markSupported()
    //------------------------------------------------------------------
    /**
     * ڑꂽ̓Xg[݈̌ʒuɃ}[Nݒ肵A
     * reset() \bhŃ}[N_ ǂݍ݈ʒu
     * ߂悤ɂB<br>
     * InputStream  mark() ƈႢAreadLimit Őݒ肵
     * EoCgOɃ}[NʒuɂȂ\
     * 鎖ɒӂ邱ƁB<br>
     * 
     * @param readLimit }[Nʒuɖ߂ẼoCgB
     *                  ̃oCg𒴂ăf[^ǂ
     *                  񂾏ꍇ reset()łȂȂ
     *                  \B<br>
     * 
     * @see PreLzssDecoder#mark(int)
     */
    public void mark( int readLimit ){

        //------------------------------------------------------------------
        //  nt}ōň̏ꍇl readLimit vZ
        if( this.blockSize < readLimit ){
            readLimit = readLimit * StaticHuffman.LimitLen / 8;
            readLimit += 272; //block head
        }else{
            readLimit = readLimit * StaticHuffman.LimitLen / 8;
        }

        //------------------------------------------------------------------
        //  BitInputStream pLbV readLimit vZB
        readLimit -= this.cacheLimit - this.cachePosition;
        readLimit -= this.bitCount / 8;
        readLimit += 4;
        readLimit  = ( readLimit + this.cache.length - 1 ) / this.cache.length 
                                                           * this.cache.length;

        //------------------------------------------------------------------
        //  mark 
        this.in.mark( readLimit );

        if( this.markCache == null ){
            this.markCache = (byte[])this.cache.clone();
        }else{
            System.arraycopy( this.cache, 0, 
                              this.markCache, 0, 
                              this.cacheLimit );
        }
        this.markCacheLimit        = this.cacheLimit;
        this.markCachePosition     = this.cachePosition;
        this.markBitBuffer         = this.bitBuffer;
        this.markBitCount          = this.bitCount;
        this.markPositionIsInCache = true;

        this.markBlockSize   = this.blockSize;
        this.markCodeLen     = this.codeLen;
        this.markCodeTable   = this.codeTable;
        this.markCodeTree    = this.codeTree;
        this.markOffLenLen   = this.offLenLen;
        this.markOffLenTable = this.offLenTable;
        this.markOffLenTree  = this.offLenTree;
    }

    /**
     * ڑꂽ̓Xg[̓ǂݍ݈ʒuŌ
     * mark() \bhĂяoꂽƂ̈ʒuɐݒ肷B<br>
     * 
     * @exception IOException <br>
     * &emsp;&emsp; (1) mark()  reset() 悤ƂꍇB<br>
     * &emsp;&emsp; (2) ڑꂽ̓Xg[ markSupported()
     *                  false ԂꍇB<br>
     * &emsp;&emsp; (3) ڑꂽ̓Xg[
     *                  o̓G[ꍇB<br>
     * &emsp;&emsp; ̉ꂩB
     */
    public void reset() throws IOException {
        if( this.markPositionIsInCache ){
            this.cachePosition = this.markCachePosition;
            this.bitBuffer     = this.markBitBuffer;
            this.bitCount      = this.markBitCount;

            this.blockSize     = this.markBlockSize;
            this.codeLen       = this.markCodeLen;
            this.codeTable     = this.markCodeTable;
            this.codeTree      = this.markCodeTree;
            this.offLenLen     = this.markOffLenLen;
            this.offLenTable   = this.markOffLenTable;
            this.offLenTree    = this.markOffLenTree;
        }else if( !this.in.markSupported() ){
            throw new IOException( "not support mark()/reset()." );
        }else if( this.markCache == null ){ //͖̏Ƀ}[NĂȂƂBRXgN^ markCache  null ɐݒ肳̂𗘗pB 
            throw new IOException( "not marked." );
        }else{
            //in  reset() łȂꍇ
            //ŏ̍s this.in.reset() 
            //IOException 𓊂邱Ƃ҂ĂB
            this.in.reset();                                                    //throws IOException
            System.arraycopy( this.markCache, 0, 
                              this.cache, 0, 
                              this.markCacheLimit );
            this.cacheLimit    = this.markCacheLimit;
            this.cachePosition = this.markCachePosition;
            this.bitBuffer     = this.markBitBuffer;
            this.bitCount      = this.markBitCount;

            this.blockSize     = this.markBlockSize;
            this.codeLen       = this.markCodeLen;
            this.codeTable     = this.markCodeTable;
            this.codeTree      = this.markCodeTree;
            this.offLenLen     = this.markOffLenLen;
            this.offLenTable   = this.markOffLenTable;
            this.offLenTree    = this.markOffLenTree;
        }
    }

    /**
     * ڑꂽ̓Xg[ mark()  reset() 
     * T|[g邩𓾂B<br>
     * 
     * @return Xg[ mark()  reset() 
     *         T|[gꍇ trueB<br>
     *         T|[gȂꍇ falseB<br>
     */
    public boolean markSupported(){
        return this.in.markSupported();
    }


    //------------------------------------------------------------------
    //  method of jp.gr.java_conf.dangan.util.lha.PreLzssDecoder
    //------------------------------------------------------------------
    //  other
    //------------------------------------------------------------------
    //  public int available()
    //  public void close()
    //------------------------------------------------------------------
    /**
     * ubNɓǂݏoƂ̏oŒoCg𓾂B<br>
     * InputStream  available() ƈႢA
     * ̍ŒoCg͕KۏႳĂȂɒӂ邱ƁB<br>
     * 
     * @return ubNȂœǂݏoŒoCgB<br>
     * 
     * @exception IOException o̓G[ꍇ
     * 
     * @see PreLzssDecoder#available()
     */
    public int available() throws IOException {
        int avail = ( ( this.cacheLimit - this.cachePosition )
                    + this.in.available() / this.cache.length * this.cache.length );//throws IOException
        avail += this.bitCount - 32;
        avail = avail / StaticHuffman.LimitLen;
        if( this.blockSize < avail ){
            avail -= 272;
        }
        return Math.max( avail, 0 );
    }

    /**
     * ̃Xg[AgpĂSĂ̎B
     * 
     * @exception IOException o̓G[ꍇ
     */
    public void close() throws IOException {
        this.in.close();                                                        //throws IOException
        this.in                    = null;

        this.cache                 = null;
        this.cacheLimit            = 0;
        this.cachePosition         = 0;
        this.bitBuffer             = 0;
        this.bitCount              = 0;

        this.markCache             = null;
        this.markCacheLimit        = 0;
        this.markCachePosition     = 0;
        this.markBitBuffer         = 0;
        this.markBitCount          = 0;
        this.markPositionIsInCache = false;

        this.blockSize       = 0;
        this.codeLen         = null;
        this.codeTable       = null;
        this.codeTree        = null;
        this.offLenLen       = null;
        this.offLenTable     = null;
        this.offLenTree      = null;

        this.markBlockSize   = 0;
        this.markCodeLen     = null;
        this.markCodeTable   = null;
        this.markCodeTree    = null;
        this.markOffLenLen   = null;
        this.markOffLenTable = null;
        this.markOffLenTree  = null;
    }


    //------------------------------------------------------------------
    //  method of jp.gr.java_conf.dangan.util.lha.PreLzssDecoder
    //------------------------------------------------------------------
    //  get LZSS parameter
    //------------------------------------------------------------------
    //  public int getDictionarySize()
    //  public int getMaxMatch()
    //  public int getThreshold()
    //------------------------------------------------------------------
    /**
     *  PreLh5Decoder LZSS̃TCY𓾂B
     * 
     * @return  PreLh5Decoder LZSS̃TCY
     */
    public int getDictionarySize(){
        return this.DictionarySize;
    }

    /**
     *  PreLh5Decoder LZSS̍őv𓾂B
     * 
     * @return  PreLh5Decoder LZSS̍őv
     */
    public int getMaxMatch(){
        return this.MaxMatch;
    }

    /**
     *  PreLh5Decoder kA񈳏k臒l𓾂B
     * 
     * @return  PreLh5Decoder kA񈳏k臒l
     */
    public int getThreshold(){
        return this.Threshold;
    }


    //------------------------------------------------------------------
    //  local method
    //------------------------------------------------------------------
    //  read block head
    //------------------------------------------------------------------
    //  private void readBlockHead()
    //  private int[] readCodeLenLenList()
    //  private int[] readCodeLenList( HuffmanDecoder decoder )
    //  private int[] readOffLenLenList()
    //------------------------------------------------------------------
    /**
     * nt}ubN̐擪ɂ
     * ubNTCYnt}̃XgǂݍށB
     * 
     * @exception IOException  o̓G[ꍇ
     * @exception EOFException EndOfStreamɒBꍇ
     * @exception BadHuffmanTableException
     *                         nt}؂\邽߂
     *                         nt}̕\sȂ߁A
     *                         nt}킪łȂꍇ
     * @exception BitDataBrokenException
     *                         \ʌŃf[^ǂ݂݂
     *                         fꂽߗvꂽrbg
     *                         ̃f[^Ȃꍇ
     * @exception NotEnoughBitsException
     *                         \ʌŃf[^ǂ݂݂
     *                         fꂽߗvꂽrbg
     *                         ̃f[^Ȃꍇ
     */
    private void readBlockHead() throws IOException {
        //ubNTCYǂݍ
        //ȃf[^̏ꍇA̕ EndOfStream ɓBB
        try{
            this.blockSize = this.readBits( 16 );                               //throws BitDataBrokenException, EOFException, IOException
        }catch( BitDataBrokenException exception ){
            if( exception.getCause() instanceof EOFException ){
                throw (EOFException)exception.getCause();
            }else{
                throw exception;
            }
        }

        //codeLen ̏
        int[] codeLenLen = this.readCodeLenLen();                               //throws BitDataBrokenException, EOFException, IOException
        short[] codeLenTable;
        if( null != codeLenLen ){
            codeLenTable = StaticHuffman.createTable( codeLenLen );             //throws BadHuffmanTableException
        }else{
            codeLenTable = new short[]{ (short)this.readBits( 5 ) };            //throws BitDataBrokenException EOFException IOException
            codeLenLen   = new int[ codeLenTable[0] + 1 ];
        }

        //code ̏
        this.codeLen = this.readCodeLen( codeLenTable, codeLenLen );            //throws BitDataBrokenException NotEnoughBitsException EOFException IOException
        if( null != this.codeLen ){
            short[][] tableAndTree = 
                StaticHuffman.createTableAndTree( this.codeLen, this.codeTableBits );//throws BadHuffmanTableException
            this.codeTable = tableAndTree[0];
            this.codeTree  = new short[][]{ tableAndTree[1], tableAndTree[2] };
        }else{
            int code = this.readBits( 9 );                                      //throws BitDataBrokenException EOFException IOException
            this.codeLen   = new int[ 256 + this.MaxMatch - this.Threshold + 1 ];
            this.codeTable = new short[ 1 << this.codeTableBits ];
            for( int i = 0 ; i < this.codeTable.length ; i++ ){
                this.codeTable[i] = ((short)~code);
            }
            this.codeTree = new short[][]{ new short[0], new short[0] };
        }

        //offLen ̏
        this.offLenLen = this.readOffLenLen();                                  //throws BitDataBrokenException EOFException IOException
        if( null != this.offLenLen ){
            short[][] tableAndTree = 
                StaticHuffman.createTableAndTree( this.offLenLen, this.offLenTableBits );//throws BadHuffmanTableException
            this.offLenTable = tableAndTree[0];
            this.offLenTree  = new short[][]{ tableAndTree[1], tableAndTree[2] };
        }else{
            int offLen = this.readBits( Bits.len( Bits.len( this.DictionarySize ) ) );//throws BitDataBrokenException EOFException IOException
            this.offLenLen   = new int[ Bits.len( this.DictionarySize ) ];
            this.offLenTable = new short[ 1 << this.offLenTableBits ];
            for( int i = 0 ; i < this.offLenTable.length ; i++ ){
                this.offLenTable[i] = ((short)~offLen);
            }
            this.offLenTree = new short[][]{ new short[0], new short[0] };
        }
    }

    /**
     * Codẽnt}̃Xg
     * nt}𕜍邽߂
     * nt}̃Xgǂ݂ށB
     * 
     * @return nt}̃XgB
     *         ̃Xgꍇ null
     * 
     * @exception IOException  o̓G[ꍇ
     * @exception EOFException EndOfStreamɒBꍇ
     * @exception BitDataBrokenException
     *                         \ʌŃf[^ǂ݂݂
     *                         fꂽߗvꂽrbg
     *                         ̃f[^Ȃꍇ
     */
    private int[] readCodeLenLen() throws IOException {
        int listlen = this.readBits( 5 );                                       //throws BitDataBrokenException, EOFException, IOException
        if( 0 < listlen ){
            int[] codeLenLen = new int[listlen];
            int   index = 0;

            while( index < listlen ){
                int codelenlen = this.readBits( 3 );                            //throws BitDataBrokenException, EOFException, IOException
                if( codelenlen == 0x07 ){
                    while( this.readBoolean() ) codelenlen++;                   //throws EOFException, IOException
                }
                codeLenLen[index++] = codelenlen;

                if( index == 3 ){
                    index += this.readBits( 2 );                                //throws BitDataBrokenException, EOFException, IOException
                }
            }
            return codeLenLen;
        }else{
            return null;
        }
    }

    /**
     * Codẽnt}̃Xg𕜍Ȃǂ݂
     * 
     * @return nt}̃XgB
     *         ̃Xgꍇ null
     * 
     * @exception IOException  o̓G[ꍇ
     * @exception EOFException EndOfStreamɒBꍇ
     * @exception BitDataBrokenException
     *                         \ʌŃf[^ǂ݂݂
     *                         fꂽߗvꂽrbg
     *                         ̃f[^Ȃꍇ
     * @exception NotEnouthBitsException
     *                         \ʌŃf[^ǂ݂݂
     *                         fꂽߗvꂽrbg
     *                         ̃f[^Ȃꍇ
     */
    private int[] readCodeLen( short[] codeLenTable, int[] codeLenLen ) 
                                                            throws IOException {

        final int codeLenTableBits = Bits.len( codeLenTable.length - 1 );

        int listlen = this.readBits( 9 );                                       //throws BitDataBrokenException, EOFException, IOException
        if( 0 < listlen ){
            int[] codeLen = new int[listlen];
            int   index = 0;

            while( index < listlen ){
                this.fillBitBuffer();
                int bits = ( 0 < codeLenTableBits
                           ? this.bitBuffer >>> ( 32 - codeLenTableBits )
                           : 0 );
                int codelen = codeLenTable[ bits ];
                int len = codeLenLen[ codelen ];
                this.bitBuffer <<= len;
                this.bitCount   -= len;

                if( codelen == 0 )      index++;
                else if( codelen == 1 ) index += this.readBits( 4 ) + 3;        //throws BitDataBrokenException, EOFException, IOException
                else if( codelen == 2 ) index += this.readBits( 9 ) + 20;       //throws BitDataBrokenException, EOFException, IOException
                else                    codeLen[index++] = codelen - 2;
            }
            return codeLen;
        }else{
            return null;
        }
    }

    /**
     * offLen ̃nt}̃Xgǂ݂
     * 
     * @return nt}̃XgB
     *         ̃Xgꍇ null
     * 
     * @exception IOException  o̓G[ꍇ
     * @exception EOFException EndOfStreamɒBꍇ
     * @exception BitDataBrokenException
     *                         \ʌŃf[^ǂ݂݂
     *                         fꂽߗvꂽrbg
     *                         ̃f[^Ȃꍇ
     */
    private int[] readOffLenLen() throws IOException {
        int listlen = this.readBits( Bits.len( Bits.len( this.DictionarySize ) ) );//throws BitDataBrokenException, EOFException, IOException
        if( 0 < listlen ){
            int[] offLenLen = new int[listlen];
            int   index = 0;

            while( index < listlen ){
                int offlenlen = this.readBits( 3 );                             //throws BitDataBrokenException, EOFException, IOException
                if( offlenlen == 0x07 ){
                    while( this.readBoolean() ) offlenlen++;                    //throws EOFException, IOException
                }
                offLenLen[index++] = offlenlen;
            }
            return offLenLen;
        }else{
            return null;
        }
    }


    //------------------------------------------------------------------
    //  staff of BitInputStream
    //------------------------------------------------------------------
    //  bit read
    //------------------------------------------------------------------
    //  private boolean readBoolean()
    //  private int readBits( int count )
    //  private int cachedBits()
    //------------------------------------------------------------------
    /**
     * ڑꂽ̓Xg[ 1rbg̃f[^
     * ^UlƂēǂݍށB<br>
     * 
     * @return ǂݍ܂ꂽ1rbg̃f[^ 
     *         1ł trueA0ł false ԂB<br>
     * 
     * @exception EOFException EndOfStreamɒBĂꍇ
     * @exception IOException  ڑꂽ̓Xg[
     *                         o̓G[ꍇ
     */
    private boolean readBoolean() throws IOException {
        if( 0 < this.bitCount ){
            boolean bool = ( this.bitBuffer < 0 );
            this.bitBuffer <<= 1;
            this.bitCount   -= 1;
            return bool;
        }else{
            this.fillBitBuffer();
            boolean bool = ( this.bitBuffer < 0 );
            this.bitBuffer <<= 1;
            this.bitCount   -= 1;
            return bool;
        }
    }

    /**
     * ڑꂽ̓Xg[ count rbg̃f[^
     * ǂݍށB ߂l intlł鎖悤
     * ǂݍނƂ̂ł őLrbg 32rbg
     * 邪Acount 32ȏ̒lݒ肵Ă`FbN
     * 󂯂Ȃ ȏ̒lݒ肵ꍇ rbg
     * f[^ǂݎ̂ĂB<br>
     * Ƃ readBits( 33 ) ƂƂ ܂1rbg
     * f[^ǂݎ̂āǍ 32rbg̃f[^ԂB<br>
     * ܂ count  0ȉ̐ݒ肵ČĂяoꍇA
     * f[^ǂݍޓ𔺂Ȃ ߂l 0A
     * EndOfStream ɒBĂĂ EOFException 
     * Ȃ_ɒӂ邱ƁB<br>
     * 
     * @param count  ǂݍރf[^̃rbg
     * 
     * @return ǂݍ܂ꂽrbgf[^B<br>
     * 
     * @exception IOException 
     *               ڑꂽ̓Xg[
     *               o̓G[ꍇ
     * @exception EOFException 
     *               EndOfStreamɒBĂꍇ
     * @exception BitDataBrokenException 
     *               ǂݍݓr EndOfStreamɒB
     *               vꂽrbg̃f[^̓ǂݍ
     *               ɎsꍇB<br>
     */
    private int readBits( int count ) throws IOException {
        if( 0 < count ){
            if( count <= this.bitCount ){
                int bits = this.bitBuffer >>> ( 32 - count );
                this.bitBuffer <<= count;
                this.bitCount   -= count;
                return bits;
            }else{
                final int requested = count;
                int bits = 0;
                try{
                    this.fillBitBuffer();                                       //throws LocalEOFException IOException
                    while( this.bitCount < count ){
                        count -= this.bitCount;
                        if( count < 32 ){
                            bits |= ( this.bitBuffer >>> ( 32 - this.bitCount ) ) << count;
                        }
                        this.bitBuffer = 0;
                        this.bitCount  = 0;
                        this.fillBitBuffer();                                   //throws LocalEOFException IOException
                    }
                    bits |= this.bitBuffer >>> ( 32 - count );
                    this.bitBuffer <<= count;
                    this.bitCount   -= count;
                    return bits;
                }catch( LocalEOFException exception ){
                    if( exception.thrownBy( this ) && count < requested ){
                        throw new BitDataBrokenException( exception, bits >>> count, requested - count );
                    }else{
                        throw exception;
                    }
                }
            }
        }else{
            return 0;
        }
    }

    /**
     *  BitInputStream ɒ~Ărbg𓾂B<br>
     * 
     * @return  BitInputStream ɒ~ĂrbgB<br>
     */
    private int cachedBits(){
        return this.bitCount + ( ( this.cacheLimit - this.cachePosition ) << 3 );
    }


    //------------------------------------------------------------------
    //  staff of BitInputSteram
    //------------------------------------------------------------------
    //  fill
    //------------------------------------------------------------------
    //  private void fillBitBuffer()
    //  private void fillCache()
    //------------------------------------------------------------------
    /**
     * bitBuffer Ƀf[^𖞂B
     * EndOfStream t߂ bitBuffer ɂ
     * 25bit ̃f[^mۂ邱ƂۏႷB
     * 
     * @exception IOException       o̓G[ꍇ
     * @exception LocalEOFException bitBuffer ̏Ԃ EndOfStream ɒBꍇ
     */
    private void fillBitBuffer() throws IOException {
        if( 32 <= this.cachedBits() ){
            if( this.bitCount <= 24 ){
                if( this.bitCount <= 16 ){
                    if( this.bitCount <= 8 ){
                        if( this.bitCount <= 0 ){
                            this.bitBuffer = this.cache[this.cachePosition++] << 24;
                            this.bitCount  = 8;
                        }
                        this.bitBuffer |= ( this.cache[this.cachePosition++] & 0xFF )
                                                            << ( 24 - this.bitCount );
                        this.bitCount  += 8;
                    }
                    this.bitBuffer |= ( this.cache[this.cachePosition++] & 0xFF )
                                                        << ( 24 - this.bitCount );
                    this.bitCount  += 8;
                }
                this.bitBuffer |= ( this.cache[this.cachePosition++] & 0xFF )
                                                    << ( 24 - this.bitCount );
                this.bitCount  += 8;
            }
        }else if( this.bitCount < 25 ){
            if( this.bitCount == 0 ){
                this.bitBuffer = 0;
            }

            int count = Math.min( ( 32 - this.bitCount ) >> 3, 
                                  this.cacheLimit - this.cachePosition );
            while( 0 < count-- ){
                this.bitBuffer |= ( this.cache[this.cachePosition++] & 0xFF )
                                                    << ( 24 - this.bitCount );
                this.bitCount  += 8;
            }
            this.fillCache();                                                   //throws IOException
            if( this.cachePosition < this.cacheLimit ){
                count = Math.min( ( 32 - this.bitCount ) >> 3, 
                                  this.cacheLimit - this.cachePosition );
                while( 0 < count-- ){
                    this.bitBuffer |= ( this.cache[this.cachePosition++] & 0xFF )
                                                        << ( 24 - this.bitCount );
                    this.bitCount  += 8;
                }
            }else if( this.bitCount <= 0 ){
                throw new LocalEOFException( this );
            }
        }
    }

    /**
     * cache ɂȂ cache Ƀf[^ǂݍށB
     * 
     * @exception IOException o̓G[ꍇ
     */
    private void fillCache() throws IOException {
        this.markPositionIsInCache = false;
        this.cacheLimit            = 0;
        this.cachePosition         = 0;

        //cache Ƀf[^ǂݍ
        int read = 0;
        while( 0 <= read && this.cacheLimit < this.cache.length ){
            read = this.in.read( this.cache,
                                 this.cacheLimit, 
                                 this.cache.length - this.cacheLimit );         //throws IOException

            if( 0 < read ) this.cacheLimit += read;
        }
    }


    //------------------------------------------------------------------
    //  inner classes
    //------------------------------------------------------------------
    //  private static class LocalEOFException
    //------------------------------------------------------------------
    /**
     * BitInputStream  EndOfStream ̌o
     * EOFException gp̂͏X肪̂
     * [J EOFException `B
     */
    private static class LocalEOFException extends EOFException {

        //------------------------------------------------------------------
        //  instance field
        //------------------------------------------------------------------
        //  private Object owner
        //------------------------------------------------------------------
        /**
         * ̗O𓊂IuWFNg
         */
        private Object owner;

        //------------------------------------------------------------------
        //  constructor
        //------------------------------------------------------------------
        //  public LocalEOFException()
        //  public LocalEOFException( String message )
        //------------------------------------------------------------------
        /**
         * RXgN^B
         * 
         * @param object ̗O𓊂IuWFNg
         */
        public LocalEOFException( Object object ){
            super();
            this.owner = object;
        }

        //------------------------------------------------------------------
        //  original method
        //------------------------------------------------------------------
        //  public boolean thrownBy( Object object )
        //------------------------------------------------------------------
        /**
         * ̗O object ɂēꂽǂ𓾂B<br>
         * 
         * @param object IuWFNg
         * 
         * @return ̗O objectɂ
         *         ꂽOł true<br>
         *         Ⴆ false<br>
         */
        public boolean thrownBy( Object object ){
            return this.owner == object;
        }
    }
}
//end of PreLh5Decoder.java
