/* This file is part of libhud-qt
 * Copyright 2013 Canonical Ltd.
 *
 * libhud-qt is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * libhud-qt is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef UBUNTU_HUD_FULLSCREEN_ACTION
#define UBUNTU_HUD_FULLSCREEN_ACTION

#include "predefined-action.h"

namespace Ubuntu {
namespace HUD {
    class FullscreenAction;
}
}

class Ubuntu::HUD::FullscreenAction : public Ubuntu::HUD::PredefinedAction
{
    Q_OBJECT
    Q_DISABLE_COPY(FullscreenAction)

    class Private;

public:
    FullscreenAction(QObject *parent = 0);

    virtual void setEnabled(bool value);

private:
    Private *d;
};

#endif // UBUNTU_HUD_FULLSCREEN_ACTION
