/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.exml;

/**
 * A collection of numerical events returned by the XML parsers.  These
 * are done as bit flags, so they can be OR'd and AND'd together.
 * @see XmlSParser
 * @see XmlScanner
 */
public interface XmlEvent
{
	/** No event */
	int NONE = 0;
	/** Start tag event */
	int STAG = 1<<0;
	/** End tag event */
	int ETAG = 1<<1;
	/** Character data event */
	int CHARDATA = 1<<2;
	/** Character data section event */
	int CDSECT = 1<<3;
	/** Reference event */
	int REFERENCE = 1<<4;
	/** Event composed of the OR'ing of CHARDATA, CDSECT, and REFERENCE */
	int TEXT = CHARDATA | CDSECT | REFERENCE;
	/** Document type declaration event */
	int DOCTYPE_DECL = 1<<5;
	/** XML Declaration event */
	int XML_DECL = 1<<6;
	/** Processing instruction event */ 
	int PI = 1<<7;
	/** Comment event */ 
	int COMMENT = 1<<8;
	/** End Of Document or Stream event */ 
	int EOD = 1<<9;

	/** Element declaration event */
	int ELEMENT_DECL = 1<<10;
	/** Attribute declaration event */
	int ATTLIST_DECL = 1<<11;
	/** Entity declaration event */
	int ENTITY_DECL = 1<<12;
	/** Conditional section event */
	int CONDITIONAL_SECT = 1<<13;
	/** Notation declaration event */
	int NOTATATION_DECL = 1<<14;
	/** Parameter entity reference event */
	int PE_REFERENCE = 1<<15;

	/** All events */
	int ALL_EVENTS = 0xEFFFFFFF;
}
