#Module-Specific definitions
%define apache_version 2.0.54
%define mod_name mod_watchcat
%define mod_conf 55_%{mod_name}.conf
%define mod_so %{mod_name}.so

Summary:	    Mod_watchcat is a DSO module for the apache web server.
Name:		    apache-%{mod_name}
Version:	    1.0
Release:	    %mkrel 2
Group:		    System/Servers
Source0:	    %{mod_name}-%{version}.tar.bz2
Source1:	    %{mod_conf}.bz2
Requires(pre):	    rpm-helper
Requires(postun):   rpm-helper
Requires(pre):	    apache-conf >= %{apache_version}
Requires(pre):	    apache >= %{apache_version}
Requires:	    libwcat1
Requires:	    apache-conf >= %{apache_version}
Requires:	    apache >= %{apache_version}
BuildRequires:	    libwcat1
BuildRequires:	    apache-devel >= %{apache_version}
Provides:	    apache2-%{mod_name}
Obsoletes:	    apache2-%{mod_name}
License:	    GPL
URL:		    http://oss.digirati.com.br/mod_watchcat/
BuildRoot:	    %{_tmppath}/%{name}-%{version}-buildroot

%description
mod_watchcat allows the Apache webserver to register its processes
with the watchcatd daemon.

%prep

%setup -q -n %{mod_name}-%{version}

%build
%{_sbindir}/apxs -c mod_watchcat.c -lwcat

%install
[ "%{buildroot}" != "/" ] && rm -rf %{buildroot}

install -d %{buildroot}%{_libdir}/apache-extramodules
install -d %{buildroot}%{_sysconfdir}/httpd/modules.d

install -m0755 .libs/*.so %{buildroot}%{_libdir}/apache-extramodules/
bzcat %{SOURCE1} > %{buildroot}%{_sysconfdir}/httpd/modules.d/%{mod_conf}

install -d %{buildroot}%{_var}/www/html/addon-modules
ln -s ../../../..%{_docdir}/%{name}-%{version} %{buildroot}%{_var}/www/html/addon-modules/%{name}-%{version}

%post
if [ -f %{_var}/lock/subsys/httpd ]; then
  %{_initrddir}/httpd restart 1>&2;
fi

%postun
if [ "$1" = "0" ]; then
  if [ -f %{_var}/lock/subsys/httpd ]; then
    %{_initrddir}/httpd restart 1>&2
  fi
fi

%clean
[ "%{buildroot}" != "/" ] && rm -rf %{buildroot}

%files
%doc COPYRIGHT
%defattr(-,root,root)
%attr(0644,root,root) %config(noreplace) %{_sysconfdir}/httpd/modules.d/%{mod_conf}
%attr(0755,root,root) %{_libdir}/apache-extramodules/%{mod_so}
%{_var}/www/html/addon-modules/*

%changelog
* Fri Nov 03 2006 Andre Nathan <andre@digirati.com.br> 2.0.54_1.0-2mdk
- Adapt to new Mandriva style.
* Fri Feb 05 2003 Andre Nathan <andre@digirati.com.br> 2.0.48_1.0-1mdk
- Adapt to Mandrake style.
* Thu Feb 05 2003 Andre Nathan <andre@digirati.com.br> 2.0.48_1.0-1mdk
- First version.
