#!/bin/sh
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2021 Antoine Le Gonidec <vv221@dotslahsplay.it>
set -o errexit

###
# Giana Sisters Twisted Dreams
# send your bug reports to contact@dotslashplay.it
###

script_version=20240517.1

PLAYIT_COMPATIBILITY_LEVEL='2.28'

GAME_ID='giana-sisters-twisted-dreams'
GAME_NAME='Giana Sisters: Twisted Dreams'

ARCHIVE_BASE_1_NAME='setup_giana_sisters_twisted_dreams_1.2.1_(19142).exe'
ARCHIVE_BASE_1_MD5='e5605f4890984375192bd37545e51ff8'
ARCHIVE_BASE_1_TYPE='innosetup'
ARCHIVE_BASE_1_SIZE='2800000'
ARCHIVE_BASE_1_VERSION='1.2.1-gog19142'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/giana_sisters_twisted_dreams'

ARCHIVE_BASE_0_NAME='setup_giana_sisters_twisted_dreams_2.2.0.16.exe'
ARCHIVE_BASE_0_MD5='31b2a0431cfd764198834faec314f0b2'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='2900000'
ARCHIVE_BASE_0_VERSION='1.0-gog2.2.0.16'

CONTENT_PATH_DEFAULT='.'
CONTENT_PATH_DEFAULT_0='app'
CONTENT_GAME_BIN_FILES='
*.dll
*.exe
launcher'
CONTENT_GAME_DATA_FILES='
bundles
added_content
data_common'
CONTENT_GAME0_DATA_PATH='__support/app'
CONTENT_GAME0_DATA_FILES='
data_common'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/Documents/Giana Sisters - Twisted Dreams'
## TODO: Check if these winetricks verbs are still required with current WINE builds.
WINE_WINETRICKS_VERBS='xact wmp9'

APP_MAIN_EXE='gsgameexe.exe'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
