#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Creaks
# send your bug reports to contact@dotslashplay.it
###

script_version=20230406.1

GAME_ID='creaks'
GAME_NAME='Creaks'

ARCHIVE_BASE_0='setup_creaks_1.0.9_(46052).exe'
ARCHIVE_BASE_0_MD5='53c45d5337970ae4f3cd33ac846a4b34'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1='setup_creaks_1.0.9_(46052)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='a6dd1d513945b49753918f7031936a1d'
ARCHIVE_BASE_0_SIZE='4300000'
ARCHIVE_BASE_0_VERSION='1.0.9-gog46052'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/creaks'

UNITY3D_NAME='creaks'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES="
${UNITY3D_NAME}_data/plugins
${UNITY3D_NAME}.exe
monobleedingedge
unitycrashhandler64.exe
galaxy64.dll
galaxycsharpglue.dll
unityplayer.dll
winpixeventruntime.dll"
CONTENT_GAME_DATA_FILES="
${UNITY3D_NAME}_data"

APP_WINE_LINK_DIRS='
userdata:users/${USER}/AppData/LocalLow/Amanita Design/Creaks'
USER_PERSISTENT_DIRECTORIES='
userdata'

APP_MAIN_EXE="${UNITY3D_NAME}.exe"

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID"

# Load common functions

target_version='2.22'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game icons

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build packages

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
