#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2018 BetaRays
# SPDX-FileCopyrightText: © 2018 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Broken Sword: Shadow of the Templars
# send your bug reports to contact@dotslashplay.it
###

script_version=20240822.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='broken-sword-1'
GAME_NAME='Broken Sword: Shadow of the Templars'

ARCHIVE_BASE_GOG_0_NAME='gog_broken_sword_director_s_cut_2.0.0.2.sh'
ARCHIVE_BASE_GOG_0_MD5='8f7cd1b6742946e111aa83fdfac0bcad'
ARCHIVE_BASE_GOG_0_SIZE='1400000'
ARCHIVE_BASE_GOG_0_VERSION='1.0.8-gog2.0.0.2'
ARCHIVE_BASE_GOG_0_URL='https://www.gog.com/game/broken_sword_directors_cut'

ARCHIVE_BASE_HUMBLE_0_NAME='BrokenSword1DirectorsCut_v1.0.800_Linux_1372464772.tar.gz'
ARCHIVE_BASE_HUMBLE_0_MD5='f4867d26cda9d8b06b617abcdd8bb1b7'
ARCHIVE_BASE_HUMBLE_0_SIZE='1400000'
ARCHIVE_BASE_HUMBLE_0_VERSION='1.0.8-humble.2013.07.01'
ARCHIVE_BASE_HUMBLE_0_URL='https://www.humblebundle.com/store/broken-sword-shadow-of-the-templars-the-directors-cut'

CONTENT_PATH_DEFAULT_HUMBLE='bs1dc_linux_v1.0.800'
CONTENT_PATH_DEFAULT_GOG='data/noarch/game'
## TODO: Improve the integration of shipped libraries
## TODO: Check if some shipped libraries could be dropped
CONTENT_GAME_BIN64_FILES='
x86_64'
CONTENT_GAME_BIN32_FILES='
i386'
CONTENT_GAME_DATA_FILES='
*.dat
font
icon.bmp
movies
music'
CONTENT_DOC_DATA_FILES='
legal.txt'

APP_MAIN_EXE_BIN64='x86_64/bs1dc_x86_64'
APP_MAIN_EXE_BIN32='i386/bs1dc_i386'
APP_MAIN_ICON='icon.bmp'

PACKAGES_LIST='
PKG_BIN64
PKG_BIN32
PKG_DATA'

PKG_BIN64_ARCH='64'
PKG_BIN32_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN64_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN32_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
## TODO: Complete the list of required native libraries
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libopenal.so.1
libSDL-1.2.so.0'
PKG_BIN64_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"
PKG_BIN32_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN64'
launchers_generation 'PKG_BIN32'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
