/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module;

import edu.harvard.hul.ois.jhove.Agent;
import edu.harvard.hul.ois.jhove.AgentType;
import edu.harvard.hul.ois.jhove.Checksum;
import edu.harvard.hul.ois.jhove.ChecksumInputStream;
import edu.harvard.hul.ois.jhove.ChecksumType;
import edu.harvard.hul.ois.jhove.Checksummer;
import edu.harvard.hul.ois.jhove.Document;
import edu.harvard.hul.ois.jhove.DocumentType;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Identifier;
import edu.harvard.hul.ois.jhove.IdentifierType;
import edu.harvard.hul.ois.jhove.InfoMessage;
import edu.harvard.hul.ois.jhove.JhoveBase;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.Module;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.TextMDMetadata;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class AsciiModule
extends ModuleBase {
    private static final String NAME = "ASCII-hul";
    private static final String RELEASE = "1.3";
    private static final int[] DATE = new int[]{2006, 9, 5};
    private static final String[] FORMAT = new String[]{"ASCII", "US-ASCII", "ANSI X3.4", "ISO 646"};
    private static final String COVERAGE = null;
    private static final String[] MIMETYPE = new String[]{"text/plain; charset=US-ASCII"};
    private static final String WELLFORMED = "An ASCII object is well-formed if each byte is between 0x00 and 0x7F";
    private static final String VALIDITY = null;
    private static final String REPINFO = "Additional representation information includes: line ending and control characters";
    private static final String NOTE = null;
    private static final String RIGHTS = "Copyright 2003-2007 by JSTOR and the President and Fellows of Harvard College. Released under the GNU Lesser General Public License.";
    private static final int CR = 13;
    private static final int LF = 10;
    private static final String[] controlCharMnemonics = new String[]{"NUL (0x00)", "SOH (0x01)", "STX (0x02)", "ETX (0x03)", "EOT (0x04)", "ENQ (0x05)", "ACK (0x06)", "BEL (0x07)", "BS (0x08)", "TAB (0x09)", "LF (0x0A)", "VT (0x0B)", "FF (0x0C)", "CR (0x0D)", "SO (0x0E)", "SI (0x0F)", "DLE (0x10)", "DC1 (0x11)", "DC2 (0x12)", "DC3 (0x13)", "DC4 (0x14)", "NAK (0x15)", "SYN (0x16)", "ETB (0x17)", "CAN (0x18)", "EM (0x19)", "SUB (0x1A)", "ESC (0x1B)", "FS (0x1C)", "GS (0x1D)", "RS (0x1E)", "US (0x1F)"};
    protected ChecksumInputStream _cstream;
    protected DataInputStream _dstream;
    protected boolean _lineEndCR;
    protected boolean _lineEndLF;
    protected boolean _lineEndCRLF;
    protected int _prevChar;
    protected Map _controlCharMap;
    protected boolean _withTextMD = false;
    protected TextMDMetadata _textMD;

    public AsciiModule() {
        super(NAME, RELEASE, DATE, FORMAT, COVERAGE, MIMETYPE, WELLFORMED, VALIDITY, REPINFO, NOTE, RIGHTS, false);
        Agent agent = new Agent("Harvard University Library", AgentType.EDUCATIONAL);
        agent.setAddress("Office for Information Systems, 90 Mt. Auburn St., Cambridge, MA 02138");
        agent.setTelephone("+1 (617) 495-3724");
        agent.setEmail("jhove-support@hulmail.harvard.edu");
        this._vendor = agent;
        Document document = new Document("Information technology -- ISO 7-bit coded character set for information interchange", DocumentType.STANDARD);
        agent = new Agent("ISO", AgentType.STANDARD);
        agent.setAddress("1, rue de Varembe, Casa postale 56, CH-1211, Geneva 20, Switzerland");
        agent.setTelephone("+41 22 749 01 11");
        agent.setFax("+41 22 733 34 30");
        agent.setEmail("iso@iso.ch");
        agent.setWeb("http://www.iso.org/");
        document.setPublisher(agent);
        document.setDate("1991");
        document.setIdentifier(new Identifier("ISO/IEC 646:1991", IdentifierType.ISO));
        this._specification.add(document);
        document = new Document("Information Systems -- Coded Character Sets 7-Bit American National Standard Code for Information Interchange (7-Bit ASCII)", DocumentType.STANDARD);
        agent = new Agent("ANSI", AgentType.STANDARD);
        agent.setAddress("1819 L Street, NW, Washington, DC 20036");
        agent.setTelephone("+1 (202) 293-8020");
        agent.setFax("+1 (202) 293-9287");
        agent.setEmail("info@ansi.org");
        agent.setWeb("http://www.ansi.org/");
        document.setPublisher(agent);
        document.setDate("1986-12-30");
        document.setIdentifier(new Identifier("ANSI X3.4-1986", IdentifierType.ANSI));
        this._specification.add(document);
        document = new Document("7-Bit coded Character Set", DocumentType.STANDARD);
        document.setEdition("6th");
        document.setDate("1991-12");
        agent = new Agent("ECMA", AgentType.STANDARD);
        agent.setAddress("114 Rue du Rhone, CH-1204 Geneva, Switzerland");
        agent.setTelephone("+41 22 849.60.00");
        agent.setFax("+41 22 849.60.01");
        agent.setEmail("helpdesk@ecma.ch");
        agent.setWeb("http://www.ecma-international.org/");
        document.setPublisher(agent);
        document.setIdentifier(new Identifier("ECMA-6", IdentifierType.ECMA));
        document.setIdentifier(new Identifier("http://www.ecma-international.org/publications/files/ecma-st/Ecma-006.pdf", IdentifierType.URL));
        this._specification.add(document);
    }

    public final int parse(InputStream inputStream, RepInfo repInfo, int n) throws IOException {
        Object object;
        AbstractList abstractList;
        String string2;
        if (this._defaultParams != null) {
            for (String string2 : this._defaultParams) {
                if (!string2.toLowerCase().equals("withtextmd=true")) continue;
                this._withTextMD = true;
            }
        }
        this.initParse();
        repInfo.setModule((Module)this);
        this._lineEndCR = false;
        this._lineEndLF = false;
        this._lineEndCRLF = false;
        this._prevChar = 0;
        this._controlCharMap = new HashMap();
        this._textMD = new TextMDMetadata();
        boolean bl = false;
        repInfo.setFormat(this._format[0]);
        repInfo.setMimeType(this._mimeType[0]);
        string2 = null;
        if (this._je != null && this._je.getChecksumFlag() && repInfo.getChecksum().size() == 0) {
            string2 = new Checksummer();
            this._cstream = new ChecksumInputStream(inputStream, (Checksummer)string2);
            this._dstream = AsciiModule.getBufferedDataStream((InputStream)this._cstream, (int)(this._je != null ? this._je.getBufferSize() : 0));
        } else {
            this._dstream = AsciiModule.getBufferedDataStream((InputStream)inputStream, (int)(this._je != null ? this._je.getBufferSize() : 0));
        }
        boolean bl2 = false;
        this._nByte = 0L;
        while (!bl2) {
            try {
                int n2 = AsciiModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
                if (n2 > 127) {
                    ErrorMessage errorMessage = new ErrorMessage("Invalid character", "Character = " + (char)n2 + " (0x" + Integer.toHexString(n2) + ")", this._nByte - 1L);
                    repInfo.setMessage((Message)errorMessage);
                    repInfo.setWellFormed(0);
                    return 0;
                }
                if (n2 < 32 && n2 != 13 && n2 != 10) {
                    this._controlCharMap.put(new Integer(n2), controlCharMnemonics[n2]);
                } else if (n2 == 127) {
                    this._controlCharMap.put(new Integer(n2), "DEL (0x7F)");
                }
                this.checkLineEnd(n2);
                if (32 <= n2 && n2 <= 126) {
                    bl = true;
                }
                this._prevChar = n2;
            }
            catch (EOFException eOFException) {
                bl2 = true;
                this.checkLineEnd(0);
            }
        }
        if (string2 != null) {
            repInfo.setSize(this._cstream.getNBytes());
            repInfo.setChecksum(new Checksum(string2.getCRC32(), ChecksumType.CRC32));
            String string3 = string2.getMD5();
            if (string3 != null) {
                repInfo.setChecksum(new Checksum(string3, ChecksumType.MD5));
            }
            if ((string3 = string2.getSHA1()) != null) {
                repInfo.setChecksum(new Checksum(string3, ChecksumType.SHA1));
            }
        }
        if (this._nByte == 0L) {
            repInfo.setMessage((Message)new ErrorMessage("Zero-length file"));
            repInfo.setWellFormed(0);
            return 0;
        }
        this._textMD.setCharset("US-ASCII");
        this._textMD.setByte_order(this._bigEndian ? 0 : 1);
        this._textMD.setByte_size("8");
        this._textMD.setCharacter_size("1");
        ArrayList<Object> arrayList = new ArrayList<Object>(2);
        if (this._lineEndCR || this._lineEndLF || this._lineEndCRLF) {
            abstractList = new ArrayList<String>(3);
            if (this._lineEndCR) {
                ((ArrayList)abstractList).add("CR");
                this._textMD.setLinebreak(0);
            }
            if (this._lineEndLF) {
                ((ArrayList)abstractList).add("LF");
                this._textMD.setLinebreak(1);
            }
            if (this._lineEndCRLF) {
                ((ArrayList)abstractList).add("CRLF");
                this._textMD.setLinebreak(2);
            }
            object = new Property("LineEndings", PropertyType.STRING, PropertyArity.LIST, (Object)abstractList);
            arrayList.add(object);
        }
        if (!this._controlCharMap.isEmpty()) {
            abstractList = new LinkedList();
            for (int i = 0; i < 32; ++i) {
                object = (String)this._controlCharMap.get(new Integer(i));
                if (object == null) continue;
                ((LinkedList)abstractList).add(object);
            }
            object = (String)this._controlCharMap.get(new Integer(127));
            if (object != null) {
                ((LinkedList)abstractList).add(object);
            }
            Property property = new Property("ControlCharacters", PropertyType.STRING, PropertyArity.LIST, (Object)abstractList);
            arrayList.add(property);
        }
        if (this._withTextMD) {
            abstractList = new Property("TextMDMetadata", PropertyType.TEXTMDMETADATA, PropertyArity.SCALAR, (Object)this._textMD);
            arrayList.add(abstractList);
        }
        if (arrayList.size() > 0) {
            repInfo.setProperty(new Property("ASCIIMetadata", PropertyType.PROPERTY, PropertyArity.LIST, arrayList));
        }
        if (!bl) {
            repInfo.setMessage((Message)new InfoMessage("No printable characters"));
        }
        return 0;
    }

    public void checkSignatures(File file, InputStream inputStream, RepInfo repInfo) throws IOException {
        repInfo.setFormat(this._format[0]);
        repInfo.setMimeType(this._mimeType[0]);
        repInfo.setModule((Module)this);
        JhoveBase jhoveBase = this.getBase();
        int n = jhoveBase.getSigBytes();
        int n2 = 0;
        boolean bl = false;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        while (!bl && n2 < n) {
            try {
                int n3 = AsciiModule.readUnsignedByte((DataInputStream)dataInputStream, (ModuleBase)this);
                ++n2;
                if (n3 <= 127) continue;
                repInfo.setWellFormed(false);
                return;
            }
            catch (EOFException eOFException) {
                bl = true;
            }
        }
        if (n2 == 0) {
            repInfo.setWellFormed(false);
            return;
        }
        repInfo.setSigMatch(this._name);
    }

    protected void checkLineEnd(int n) {
        if (n == 10) {
            if (this._prevChar == 13) {
                this._lineEndCRLF = true;
            } else {
                this._lineEndLF = true;
            }
        } else if (this._prevChar == 13) {
            this._lineEndCR = true;
        }
    }
}

