/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.samtools.util.BlockCompressedInputStream;
import org.broad.tribble.AbstractFeatureReader;
import org.broad.tribble.AsciiFeatureCodec;
import org.broad.tribble.CloseableTribbleIterator;
import org.broad.tribble.Feature;
import org.broad.tribble.TribbleException;
import org.broad.tribble.readers.AsciiLineReader;
import org.broad.tribble.readers.LineReader;
import org.broad.tribble.readers.PositionalBufferedStream;
import org.broad.tribble.readers.TabixIteratorLineReader;
import org.broad.tribble.readers.TabixReader;
import org.broad.tribble.util.ParsingUtils;

public class TabixFeatureReader
extends AbstractFeatureReader {
    TabixReader tabixReader;
    List<String> sequenceNames;

    public TabixFeatureReader(String featureFile, AsciiFeatureCodec codec) throws IOException {
        super(featureFile, codec);
        this.tabixReader = new TabixReader(featureFile);
        this.sequenceNames = new ArrayList<String>(this.tabixReader.mChr2tid.keySet());
        this.readHeader();
    }

    private void readHeader() throws IOException {
        PositionalBufferedStream is = null;
        try {
            is = new PositionalBufferedStream((InputStream)new BlockCompressedInputStream(ParsingUtils.openInputStream(this.path)));
            this.header = this.codec.readHeader(is);
        }
        catch (Exception e) {
            throw new TribbleException.MalformedFeatureFile("Unable to parse header with error: " + e.getMessage(), this.path, e);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    @Override
    public List<String> getSequenceNames() {
        return this.sequenceNames;
    }

    @Override
    public CloseableTribbleIterator query(String chr, int start, int end) throws IOException {
        List<String> mp = this.getSequenceNames();
        if (mp == null) {
            throw new TribbleException.TabixReaderFailure("Unable to find sequence named " + chr + " in the tabix index. ", this.path);
        }
        if (!mp.contains(chr)) {
            return new AbstractFeatureReader.EmptyIterator();
        }
        TabixIteratorLineReader lineReader = new TabixIteratorLineReader(this.tabixReader.query(this.tabixReader.mChr2tid.get(chr), start - 1, end));
        return new FeatureIterator(lineReader, start - 1, end);
    }

    @Override
    public CloseableTribbleIterator iterator() throws IOException {
        BlockCompressedInputStream is = new BlockCompressedInputStream(ParsingUtils.openInputStream(this.path));
        PositionalBufferedStream stream = new PositionalBufferedStream((InputStream)is);
        AsciiLineReader reader = new AsciiLineReader(stream);
        return new FeatureIterator(reader, 0, Integer.MAX_VALUE);
    }

    @Override
    public void close() throws IOException {
    }

    class FeatureIterator<T extends Feature>
    implements CloseableTribbleIterator {
        private T currentRecord;
        private LineReader lineReader;
        private int start;
        private int end;

        public FeatureIterator(LineReader lineReader, int start, int end) throws IOException {
            this.lineReader = lineReader;
            this.start = start;
            this.end = end;
            this.readNextRecord();
        }

        protected void readNextRecord() throws IOException {
            String nextLine;
            this.currentRecord = null;
            while (this.currentRecord == null && (nextLine = this.lineReader.readLine()) != null) {
                Feature f = null;
                try {
                    f = (Feature)((AsciiFeatureCodec)TabixFeatureReader.this.codec).decode(nextLine);
                    if (f == null) continue;
                    if (f.getStart() > this.end) {
                        return;
                    }
                    if (f.getEnd() <= this.start) continue;
                    this.currentRecord = f;
                }
                catch (TribbleException e) {
                    e.setSource(TabixFeatureReader.this.path);
                    throw e;
                }
                catch (NumberFormatException e) {
                    String error = "Error parsing line: " + nextLine;
                    throw new TribbleException.MalformedFeatureFile(error, TabixFeatureReader.this.path, e);
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.currentRecord != null;
        }

        @Override
        public T next() {
            T ret = this.currentRecord;
            try {
                this.readNextRecord();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read the next record, the last record was at " + ret.getChr() + ":" + ret.getStart() + "-" + ret.getEnd(), e);
            }
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported in Iterators");
        }

        @Override
        public void close() {
            this.lineReader.close();
        }

        @Override
        public Iterator<T> iterator() {
            return this;
        }
    }
}

