/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.attributeparsers;

import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.uibinder.attributeparsers.CssNameConverter;
import com.google.gwt.uibinder.rebind.FieldManager;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FieldReferenceConverter {
    private static final Pattern BRACES = Pattern.compile("[{]([^}]*)[}]");
    private static final Pattern LEGAL_FIRST_CHAR = Pattern.compile("^[$_a-zA-Z].*");
    private final CssNameConverter cssConverter = new CssNameConverter();
    private final FieldManager fieldManager;

    public static boolean hasFieldReferences(String string) {
        Telltale telltale = new Telltale();
        new FieldReferenceConverter(null).convert(string, telltale);
        return telltale.hasComputed();
    }

    FieldReferenceConverter(FieldManager fieldManager) {
        this.fieldManager = fieldManager;
    }

    public String convert(String in, Delegate delegate) {
        StringBuilder b = new StringBuilder();
        int nextFindStart = 0;
        int lastMatchEnd = 0;
        Matcher m = BRACES.matcher(in);
        while (m.find(nextFindStart)) {
            String fieldReference = m.group(1);
            if (!this.legalFirstCharacter(fieldReference)) {
                nextFindStart = m.start() + 2;
                continue;
            }
            String precedingFragment = in.substring(lastMatchEnd, m.start());
            precedingFragment = this.handleFragment(precedingFragment, delegate);
            b.append(precedingFragment);
            if (this.fieldManager != null) {
                this.fieldManager.registerFieldReference(fieldReference, delegate.getType());
            }
            fieldReference = this.expandDots(fieldReference);
            b.append(delegate.handleReference(fieldReference));
            nextFindStart = lastMatchEnd = m.end();
        }
        b.append(this.handleFragment(in.substring(lastMatchEnd), delegate));
        return b.toString();
    }

    private String expandDots(String value) {
        String[] segments;
        StringBuilder b = new StringBuilder();
        for (String segment : segments = value.split("[.]")) {
            segment = this.cssConverter.convertName(segment);
            if (b.length() == 0) {
                b.append(segment);
                continue;
            }
            b.append(".").append(segment).append("()");
        }
        return b.toString();
    }

    private String handleFragment(String fragment, Delegate delegate) {
        fragment = fragment.replace("{{", "{");
        return delegate.handleFragment(fragment);
    }

    private boolean legalFirstCharacter(String fieldReference) {
        return LEGAL_FIRST_CHAR.matcher(fieldReference).matches();
    }

    private static final class Telltale
    implements Delegate {
        boolean hasComputed = false;

        private Telltale() {
        }

        public JType getType() {
            return null;
        }

        public String handleFragment(String fragment) {
            return fragment;
        }

        public String handleReference(String reference) {
            this.hasComputed = true;
            return reference;
        }

        public boolean hasComputed() {
            return this.hasComputed;
        }
    }

    static interface Delegate {
        public JType getType();

        public String handleFragment(String var1) throws IllegalFieldReferenceException;

        public String handleReference(String var1) throws IllegalFieldReferenceException;
    }

    public static class IllegalFieldReferenceException
    extends RuntimeException {
    }
}

