/* valainterface.c generated by valac, the Vala compiler
 * generated from valainterface.vala, do not modify */

/* valainterface.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>


#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;
typedef struct _ValaCodeNodePrivate ValaCodeNodePrivate;

#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;

#define VALA_TYPE_CODE_CONTEXT (vala_code_context_get_type ())
#define VALA_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContext))
#define VALA_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))
#define VALA_IS_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_CONTEXT))
#define VALA_IS_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_CONTEXT))
#define VALA_CODE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))

typedef struct _ValaCodeContext ValaCodeContext;
typedef struct _ValaCodeContextClass ValaCodeContextClass;

#define VALA_TYPE_CODE_GENERATOR (vala_code_generator_get_type ())
#define VALA_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGenerator))
#define VALA_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))
#define VALA_IS_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_GENERATOR))
#define VALA_IS_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_GENERATOR))
#define VALA_CODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))

typedef struct _ValaCodeGenerator ValaCodeGenerator;
typedef struct _ValaCodeGeneratorClass ValaCodeGeneratorClass;

#define VALA_TYPE_DATA_TYPE (vala_data_type_get_type ())
#define VALA_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DATA_TYPE, ValaDataType))
#define VALA_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))
#define VALA_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DATA_TYPE))
#define VALA_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DATA_TYPE))
#define VALA_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))

typedef struct _ValaDataType ValaDataType;
typedef struct _ValaDataTypeClass ValaDataTypeClass;

#define VALA_TYPE_EXPRESSION (vala_expression_get_type ())
#define VALA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION, ValaExpression))
#define VALA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION, ValaExpressionClass))
#define VALA_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION))
#define VALA_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION))
#define VALA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION, ValaExpressionClass))

typedef struct _ValaExpression ValaExpression;
typedef struct _ValaExpressionClass ValaExpressionClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;

#define VALA_TYPE_VARIABLE (vala_variable_get_type ())
#define VALA_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VARIABLE, ValaVariable))
#define VALA_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VARIABLE, ValaVariableClass))
#define VALA_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VARIABLE))
#define VALA_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VARIABLE))
#define VALA_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VARIABLE, ValaVariableClass))

typedef struct _ValaVariable ValaVariable;
typedef struct _ValaVariableClass ValaVariableClass;

#define VALA_TYPE_ATTRIBUTE (vala_attribute_get_type ())
#define VALA_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ATTRIBUTE, ValaAttribute))
#define VALA_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))
#define VALA_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ATTRIBUTE))
#define VALA_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ATTRIBUTE))
#define VALA_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))

typedef struct _ValaAttribute ValaAttribute;
typedef struct _ValaAttributeClass ValaAttributeClass;
typedef struct _ValaSymbolPrivate ValaSymbolPrivate;

#define VALA_TYPE_NAMESPACE (vala_namespace_get_type ())
#define VALA_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NAMESPACE, ValaNamespace))
#define VALA_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NAMESPACE, ValaNamespaceClass))
#define VALA_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NAMESPACE))
#define VALA_IS_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NAMESPACE))
#define VALA_NAMESPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NAMESPACE, ValaNamespaceClass))

typedef struct _ValaNamespace ValaNamespace;
typedef struct _ValaNamespaceClass ValaNamespaceClass;

#define VALA_TYPE_TYPESYMBOL (vala_typesymbol_get_type ())
#define VALA_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))
#define VALA_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))
#define VALA_IS_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPESYMBOL))
#define VALA_IS_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPESYMBOL))
#define VALA_TYPESYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))

typedef struct _ValaTypeSymbol ValaTypeSymbol;
typedef struct _ValaTypeSymbolClass ValaTypeSymbolClass;

#define VALA_TYPE_OBJECT_TYPE_SYMBOL (vala_object_type_symbol_get_type ())
#define VALA_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol))
#define VALA_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))
#define VALA_IS_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_IS_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_OBJECT_TYPE_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))

typedef struct _ValaObjectTypeSymbol ValaObjectTypeSymbol;
typedef struct _ValaObjectTypeSymbolClass ValaObjectTypeSymbolClass;

#define VALA_TYPE_CLASS (vala_class_get_type ())
#define VALA_CLASS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CLASS, ValaClass))
#define VALA_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CLASS, ValaClassClass))
#define VALA_IS_CLASS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CLASS))
#define VALA_IS_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CLASS))
#define VALA_CLASS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CLASS, ValaClassClass))

typedef struct _ValaClass ValaClass;
typedef struct _ValaClassClass ValaClassClass;

#define VALA_TYPE_INTERFACE (vala_interface_get_type ())
#define VALA_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTERFACE, ValaInterface))
#define VALA_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTERFACE, ValaInterfaceClass))
#define VALA_IS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTERFACE))
#define VALA_IS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTERFACE))
#define VALA_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTERFACE, ValaInterfaceClass))

typedef struct _ValaInterface ValaInterface;
typedef struct _ValaInterfaceClass ValaInterfaceClass;

#define VALA_TYPE_STRUCT (vala_struct_get_type ())
#define VALA_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRUCT, ValaStruct))
#define VALA_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRUCT, ValaStructClass))
#define VALA_IS_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRUCT))
#define VALA_IS_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRUCT))
#define VALA_STRUCT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRUCT, ValaStructClass))

typedef struct _ValaStruct ValaStruct;
typedef struct _ValaStructClass ValaStructClass;

#define VALA_TYPE_ENUM (vala_enum_get_type ())
#define VALA_ENUM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ENUM, ValaEnum))
#define VALA_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ENUM, ValaEnumClass))
#define VALA_IS_ENUM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ENUM))
#define VALA_IS_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ENUM))
#define VALA_ENUM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ENUM, ValaEnumClass))

typedef struct _ValaEnum ValaEnum;
typedef struct _ValaEnumClass ValaEnumClass;

#define VALA_TYPE_ERROR_DOMAIN (vala_error_domain_get_type ())
#define VALA_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain))
#define VALA_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))
#define VALA_IS_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ERROR_DOMAIN))
#define VALA_IS_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ERROR_DOMAIN))
#define VALA_ERROR_DOMAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))

typedef struct _ValaErrorDomain ValaErrorDomain;
typedef struct _ValaErrorDomainClass ValaErrorDomainClass;

#define VALA_TYPE_DELEGATE (vala_delegate_get_type ())
#define VALA_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DELEGATE, ValaDelegate))
#define VALA_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DELEGATE, ValaDelegateClass))
#define VALA_IS_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DELEGATE))
#define VALA_IS_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DELEGATE))
#define VALA_DELEGATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DELEGATE, ValaDelegateClass))

typedef struct _ValaDelegate ValaDelegate;
typedef struct _ValaDelegateClass ValaDelegateClass;

#define VALA_TYPE_CONSTANT (vala_constant_get_type ())
#define VALA_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTANT, ValaConstant))
#define VALA_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTANT, ValaConstantClass))
#define VALA_IS_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTANT))
#define VALA_IS_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTANT))
#define VALA_CONSTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTANT, ValaConstantClass))

typedef struct _ValaConstant ValaConstant;
typedef struct _ValaConstantClass ValaConstantClass;

#define VALA_TYPE_FIELD (vala_field_get_type ())
#define VALA_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FIELD, ValaField))
#define VALA_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FIELD, ValaFieldClass))
#define VALA_IS_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FIELD))
#define VALA_IS_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FIELD))
#define VALA_FIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FIELD, ValaFieldClass))

typedef struct _ValaField ValaField;
typedef struct _ValaFieldClass ValaFieldClass;

#define VALA_TYPE_SUBROUTINE (vala_subroutine_get_type ())
#define VALA_SUBROUTINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SUBROUTINE, ValaSubroutine))
#define VALA_SUBROUTINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SUBROUTINE, ValaSubroutineClass))
#define VALA_IS_SUBROUTINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SUBROUTINE))
#define VALA_IS_SUBROUTINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SUBROUTINE))
#define VALA_SUBROUTINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SUBROUTINE, ValaSubroutineClass))

typedef struct _ValaSubroutine ValaSubroutine;
typedef struct _ValaSubroutineClass ValaSubroutineClass;

#define VALA_TYPE_METHOD (vala_method_get_type ())
#define VALA_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD, ValaMethod))
#define VALA_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD, ValaMethodClass))
#define VALA_IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD))
#define VALA_IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD))
#define VALA_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD, ValaMethodClass))

typedef struct _ValaMethod ValaMethod;
typedef struct _ValaMethodClass ValaMethodClass;

#define VALA_TYPE_PROPERTY (vala_property_get_type ())
#define VALA_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PROPERTY, ValaProperty))
#define VALA_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PROPERTY, ValaPropertyClass))
#define VALA_IS_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PROPERTY))
#define VALA_IS_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PROPERTY))
#define VALA_PROPERTY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PROPERTY, ValaPropertyClass))

typedef struct _ValaProperty ValaProperty;
typedef struct _ValaPropertyClass ValaPropertyClass;

#define VALA_TYPE_SIGNAL (vala_signal_get_type ())
#define VALA_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SIGNAL, ValaSignal))
#define VALA_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SIGNAL, ValaSignalClass))
#define VALA_IS_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SIGNAL))
#define VALA_IS_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SIGNAL))
#define VALA_SIGNAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SIGNAL, ValaSignalClass))

typedef struct _ValaSignal ValaSignal;
typedef struct _ValaSignalClass ValaSignalClass;

#define VALA_TYPE_CONSTRUCTOR (vala_constructor_get_type ())
#define VALA_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructor))
#define VALA_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))
#define VALA_IS_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTRUCTOR))
#define VALA_IS_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTRUCTOR))
#define VALA_CONSTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))

typedef struct _ValaConstructor ValaConstructor;
typedef struct _ValaConstructorClass ValaConstructorClass;

#define VALA_TYPE_DESTRUCTOR (vala_destructor_get_type ())
#define VALA_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructor))
#define VALA_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))
#define VALA_IS_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DESTRUCTOR))
#define VALA_IS_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DESTRUCTOR))
#define VALA_DESTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))

typedef struct _ValaDestructor ValaDestructor;
typedef struct _ValaDestructorClass ValaDestructorClass;
typedef struct _ValaTypeSymbolPrivate ValaTypeSymbolPrivate;
typedef struct _ValaObjectTypeSymbolPrivate ValaObjectTypeSymbolPrivate;
typedef struct _ValaInterfacePrivate ValaInterfacePrivate;
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;

#define VALA_TYPE_COMMENT (vala_comment_get_type ())
#define VALA_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMMENT, ValaComment))
#define VALA_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMMENT, ValaCommentClass))
#define VALA_IS_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMMENT))
#define VALA_IS_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMMENT))
#define VALA_COMMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMMENT, ValaCommentClass))

typedef struct _ValaComment ValaComment;
typedef struct _ValaCommentClass ValaCommentClass;

#define VALA_TYPE_CREATION_METHOD (vala_creation_method_get_type ())
#define VALA_CREATION_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CREATION_METHOD, ValaCreationMethod))
#define VALA_CREATION_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CREATION_METHOD, ValaCreationMethodClass))
#define VALA_IS_CREATION_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CREATION_METHOD))
#define VALA_IS_CREATION_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CREATION_METHOD))
#define VALA_CREATION_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CREATION_METHOD, ValaCreationMethodClass))

typedef struct _ValaCreationMethod ValaCreationMethod;
typedef struct _ValaCreationMethodClass ValaCreationMethodClass;

#define VALA_TYPE_MEMBER_BINDING (vala_member_binding_get_type ())

#define VALA_TYPE_REFERENCE_TYPE (vala_reference_type_get_type ())
#define VALA_REFERENCE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_REFERENCE_TYPE, ValaReferenceType))
#define VALA_REFERENCE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_REFERENCE_TYPE, ValaReferenceTypeClass))
#define VALA_IS_REFERENCE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_REFERENCE_TYPE))
#define VALA_IS_REFERENCE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_REFERENCE_TYPE))
#define VALA_REFERENCE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_REFERENCE_TYPE, ValaReferenceTypeClass))

typedef struct _ValaReferenceType ValaReferenceType;
typedef struct _ValaReferenceTypeClass ValaReferenceTypeClass;

#define VALA_TYPE_OBJECT_TYPE (vala_object_type_get_type ())
#define VALA_OBJECT_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_OBJECT_TYPE, ValaObjectType))
#define VALA_OBJECT_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_OBJECT_TYPE, ValaObjectTypeClass))
#define VALA_IS_OBJECT_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_OBJECT_TYPE))
#define VALA_IS_OBJECT_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_OBJECT_TYPE))
#define VALA_OBJECT_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_OBJECT_TYPE, ValaObjectTypeClass))

typedef struct _ValaObjectType ValaObjectType;
typedef struct _ValaObjectTypeClass ValaObjectTypeClass;

#define VALA_TYPE_PARAMETER (vala_parameter_get_type ())
#define VALA_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PARAMETER, ValaParameter))
#define VALA_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PARAMETER, ValaParameterClass))
#define VALA_IS_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PARAMETER))
#define VALA_IS_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PARAMETER))
#define VALA_PARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PARAMETER, ValaParameterClass))

typedef struct _ValaParameter ValaParameter;
typedef struct _ValaParameterClass ValaParameterClass;
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

#define VALA_TYPE_SCOPE (vala_scope_get_type ())
#define VALA_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SCOPE, ValaScope))
#define VALA_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SCOPE, ValaScopeClass))
#define VALA_IS_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SCOPE))
#define VALA_IS_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SCOPE))
#define VALA_SCOPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SCOPE, ValaScopeClass))

typedef struct _ValaScope ValaScope;
typedef struct _ValaScopeClass ValaScopeClass;

#define VALA_TYPE_VOID_TYPE (vala_void_type_get_type ())
#define VALA_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VOID_TYPE, ValaVoidType))
#define VALA_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))
#define VALA_IS_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VOID_TYPE))
#define VALA_IS_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VOID_TYPE))
#define VALA_VOID_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))

typedef struct _ValaVoidType ValaVoidType;
typedef struct _ValaVoidTypeClass ValaVoidTypeClass;

#define VALA_TYPE_LOCAL_VARIABLE (vala_local_variable_get_type ())
#define VALA_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable))
#define VALA_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))
#define VALA_IS_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_IS_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_LOCAL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))

typedef struct _ValaLocalVariable ValaLocalVariable;
typedef struct _ValaLocalVariableClass ValaLocalVariableClass;

#define VALA_TYPE_TYPEPARAMETER (vala_typeparameter_get_type ())
#define VALA_TYPEPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPEPARAMETER, ValaTypeParameter))
#define VALA_TYPEPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPEPARAMETER, ValaTypeParameterClass))
#define VALA_IS_TYPEPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPEPARAMETER))
#define VALA_IS_TYPEPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPEPARAMETER))
#define VALA_TYPEPARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPEPARAMETER, ValaTypeParameterClass))

typedef struct _ValaTypeParameter ValaTypeParameter;
typedef struct _ValaTypeParameterClass ValaTypeParameterClass;

#define VALA_TYPE_SOURCE_FILE (vala_source_file_get_type ())
#define VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFile))
#define VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))
#define VALA_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE))
#define VALA_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE))
#define VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))

typedef struct _ValaSourceFile ValaSourceFile;
typedef struct _ValaSourceFileClass ValaSourceFileClass;

#define VALA_TYPE_SEMANTIC_ANALYZER (vala_semantic_analyzer_get_type ())
#define VALA_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzer))
#define VALA_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))
#define VALA_IS_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_IS_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_SEMANTIC_ANALYZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))

typedef struct _ValaSemanticAnalyzer ValaSemanticAnalyzer;
typedef struct _ValaSemanticAnalyzerClass ValaSemanticAnalyzerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))

struct _ValaCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeNodePrivate * priv;
	GList* attributes;
};

struct _ValaCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeNode *self);
	void (*accept) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	void (*accept_children) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	gboolean (*check) (ValaCodeNode* self, ValaCodeContext* context);
	void (*emit) (ValaCodeNode* self, ValaCodeGenerator* codegen);
	void (*replace_type) (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type);
	void (*replace_expression) (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
	gchar* (*to_string) (ValaCodeNode* self);
	void (*get_defined_variables) (ValaCodeNode* self, ValaCollection* collection);
	void (*get_used_variables) (ValaCodeNode* self, ValaCollection* collection);
};

struct _ValaSymbol {
	ValaCodeNode parent_instance;
	ValaSymbolPrivate * priv;
};

struct _ValaSymbolClass {
	ValaCodeNodeClass parent_class;
	gboolean (*is_instance_member) (ValaSymbol* self);
	gboolean (*is_class_member) (ValaSymbol* self);
	void (*add_namespace) (ValaSymbol* self, ValaNamespace* ns);
	void (*add_class) (ValaSymbol* self, ValaClass* cl);
	void (*add_interface) (ValaSymbol* self, ValaInterface* iface);
	void (*add_struct) (ValaSymbol* self, ValaStruct* st);
	void (*add_enum) (ValaSymbol* self, ValaEnum* en);
	void (*add_error_domain) (ValaSymbol* self, ValaErrorDomain* edomain);
	void (*add_delegate) (ValaSymbol* self, ValaDelegate* d);
	void (*add_constant) (ValaSymbol* self, ValaConstant* constant);
	void (*add_field) (ValaSymbol* self, ValaField* f);
	void (*add_method) (ValaSymbol* self, ValaMethod* m);
	void (*add_property) (ValaSymbol* self, ValaProperty* prop);
	void (*add_signal) (ValaSymbol* self, ValaSignal* sig);
	void (*add_constructor) (ValaSymbol* self, ValaConstructor* c);
	void (*add_destructor) (ValaSymbol* self, ValaDestructor* d);
};

struct _ValaTypeSymbol {
	ValaSymbol parent_instance;
	ValaTypeSymbolPrivate * priv;
};

struct _ValaTypeSymbolClass {
	ValaSymbolClass parent_class;
	gboolean (*is_reference_type) (ValaTypeSymbol* self);
	gboolean (*is_subtype_of) (ValaTypeSymbol* self, ValaTypeSymbol* t);
	gint (*get_type_parameter_index) (ValaTypeSymbol* self, const gchar* name);
};

struct _ValaObjectTypeSymbol {
	ValaTypeSymbol parent_instance;
	ValaObjectTypeSymbolPrivate * priv;
};

struct _ValaObjectTypeSymbolClass {
	ValaTypeSymbolClass parent_class;
	ValaList* (*get_methods) (ValaObjectTypeSymbol* self);
	ValaList* (*get_signals) (ValaObjectTypeSymbol* self);
	ValaList* (*get_properties) (ValaObjectTypeSymbol* self);
};

struct _ValaInterface {
	ValaObjectTypeSymbol parent_instance;
	ValaInterfacePrivate * priv;
};

struct _ValaInterfaceClass {
	ValaObjectTypeSymbolClass parent_class;
	ValaList* (*get_virtuals) (ValaInterface* self);
};

struct _ValaInterfacePrivate {
	ValaList* prerequisites;
	ValaList* methods;
	ValaList* fields;
	ValaList* constants;
	ValaList* properties;
	ValaList* signals;
	ValaList* virtuals;
	ValaList* classes;
	ValaList* structs;
	ValaList* enums;
	ValaList* delegates;
};

typedef enum  {
	VALA_MEMBER_BINDING_INSTANCE,
	VALA_MEMBER_BINDING_CLASS,
	VALA_MEMBER_BINDING_STATIC
} ValaMemberBinding;


static gpointer vala_interface_parent_class = NULL;

gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
void vala_value_take_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void) G_GNUC_CONST;
gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
void vala_value_take_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void) G_GNUC_CONST;
gpointer vala_code_context_ref (gpointer instance);
void vala_code_context_unref (gpointer instance);
GParamSpec* vala_param_spec_code_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_context (GValue* value, gpointer v_object);
void vala_value_take_code_context (GValue* value, gpointer v_object);
gpointer vala_value_get_code_context (const GValue* value);
GType vala_code_context_get_type (void) G_GNUC_CONST;
GType vala_code_generator_get_type (void) G_GNUC_CONST;
GType vala_data_type_get_type (void) G_GNUC_CONST;
GType vala_expression_get_type (void) G_GNUC_CONST;
GType vala_symbol_get_type (void) G_GNUC_CONST;
GType vala_variable_get_type (void) G_GNUC_CONST;
GType vala_attribute_get_type (void) G_GNUC_CONST;
GType vala_namespace_get_type (void) G_GNUC_CONST;
GType vala_typesymbol_get_type (void) G_GNUC_CONST;
GType vala_object_type_symbol_get_type (void) G_GNUC_CONST;
GType vala_class_get_type (void) G_GNUC_CONST;
GType vala_interface_get_type (void) G_GNUC_CONST;
GType vala_struct_get_type (void) G_GNUC_CONST;
GType vala_enum_get_type (void) G_GNUC_CONST;
GType vala_error_domain_get_type (void) G_GNUC_CONST;
GType vala_delegate_get_type (void) G_GNUC_CONST;
GType vala_constant_get_type (void) G_GNUC_CONST;
GType vala_field_get_type (void) G_GNUC_CONST;
GType vala_subroutine_get_type (void) G_GNUC_CONST;
GType vala_method_get_type (void) G_GNUC_CONST;
GType vala_property_get_type (void) G_GNUC_CONST;
GType vala_signal_get_type (void) G_GNUC_CONST;
GType vala_constructor_get_type (void) G_GNUC_CONST;
GType vala_destructor_get_type (void) G_GNUC_CONST;
#define VALA_INTERFACE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_INTERFACE, ValaInterfacePrivate))
enum  {
	VALA_INTERFACE_DUMMY_PROPERTY
};
ValaList* vala_interface_get_classes (ValaInterface* self);
ValaList* vala_interface_get_structs (ValaInterface* self);
ValaList* vala_interface_get_enums (ValaInterface* self);
ValaList* vala_interface_get_delegates (ValaInterface* self);
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
void vala_value_take_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void) G_GNUC_CONST;
gpointer vala_comment_ref (gpointer instance);
void vala_comment_unref (gpointer instance);
GParamSpec* vala_param_spec_comment (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_comment (GValue* value, gpointer v_object);
void vala_value_take_comment (GValue* value, gpointer v_object);
gpointer vala_value_get_comment (const GValue* value);
GType vala_comment_get_type (void) G_GNUC_CONST;
ValaInterface* vala_interface_new (const gchar* name, ValaSourceReference* source_reference, ValaComment* comment);
ValaInterface* vala_interface_construct (GType object_type, const gchar* name, ValaSourceReference* source_reference, ValaComment* comment);
ValaObjectTypeSymbol* vala_object_type_symbol_construct (GType object_type, const gchar* name, ValaSourceReference* source_reference, ValaComment* comment);
void vala_interface_add_prerequisite (ValaInterface* self, ValaDataType* type);
void vala_code_node_set_parent_node (ValaCodeNode* self, ValaCodeNode* value);
void vala_interface_prepend_prerequisite (ValaInterface* self, ValaDataType* type);
ValaList* vala_interface_get_prerequisites (ValaInterface* self);
static void vala_interface_real_add_method (ValaSymbol* base, ValaMethod* m);
GType vala_creation_method_get_type (void) G_GNUC_CONST;
void vala_report_error (ValaSourceReference* source, const gchar* message);
ValaSourceReference* vala_code_node_get_source_reference (ValaCodeNode* self);
void vala_code_node_set_error (ValaCodeNode* self, gboolean value);
GType vala_member_binding_get_type (void) G_GNUC_CONST;
ValaMemberBinding vala_method_get_binding (ValaMethod* self);
GType vala_reference_type_get_type (void) G_GNUC_CONST;
GType vala_object_type_get_type (void) G_GNUC_CONST;
ValaObjectType* vala_object_type_symbol_get_this_type (ValaObjectTypeSymbol* self);
ValaParameter* vala_parameter_new (const gchar* name, ValaDataType* variable_type, ValaSourceReference* source_reference);
ValaParameter* vala_parameter_construct (GType object_type, const gchar* name, ValaDataType* variable_type, ValaSourceReference* source_reference);
GType vala_parameter_get_type (void) G_GNUC_CONST;
void vala_method_set_this_parameter (ValaMethod* self, ValaParameter* value);
gpointer vala_scope_ref (gpointer instance);
void vala_scope_unref (gpointer instance);
GParamSpec* vala_param_spec_scope (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_scope (GValue* value, gpointer v_object);
void vala_value_take_scope (GValue* value, gpointer v_object);
gpointer vala_value_get_scope (const GValue* value);
GType vala_scope_get_type (void) G_GNUC_CONST;
ValaScope* vala_symbol_get_scope (ValaSymbol* self);
void vala_scope_add (ValaScope* self, const gchar* name, ValaSymbol* sym);
ValaParameter* vala_method_get_this_parameter (ValaMethod* self);
const gchar* vala_symbol_get_name (ValaSymbol* self);
ValaDataType* vala_method_get_return_type (ValaMethod* self);
GType vala_void_type_get_type (void) G_GNUC_CONST;
ValaList* vala_method_get_postconditions (ValaMethod* self);
ValaDataType* vala_data_type_copy (ValaDataType* self);
ValaLocalVariable* vala_local_variable_new (ValaDataType* variable_type, const gchar* name, ValaExpression* initializer, ValaSourceReference* source_reference);
ValaLocalVariable* vala_local_variable_construct (GType object_type, ValaDataType* variable_type, const gchar* name, ValaExpression* initializer, ValaSourceReference* source_reference);
GType vala_local_variable_get_type (void) G_GNUC_CONST;
void vala_subroutine_set_result_var (ValaSubroutine* self, ValaLocalVariable* value);
ValaLocalVariable* vala_subroutine_get_result_var (ValaSubroutine* self);
void vala_local_variable_set_is_result (ValaLocalVariable* self, gboolean value);
static ValaList* vala_interface_real_get_methods (ValaObjectTypeSymbol* base);
static void vala_interface_real_add_field (ValaSymbol* base, ValaField* f);
ValaList* vala_interface_get_fields (ValaInterface* self);
static void vala_interface_real_add_constant (ValaSymbol* base, ValaConstant* c);
ValaList* vala_interface_get_constants (ValaInterface* self);
static void vala_interface_real_add_property (ValaSymbol* base, ValaProperty* prop);
ValaObjectType* vala_object_type_new (ValaObjectTypeSymbol* type_symbol);
ValaObjectType* vala_object_type_construct (GType object_type, ValaObjectTypeSymbol* type_symbol);
void vala_property_set_this_parameter (ValaProperty* self, ValaParameter* value);
ValaParameter* vala_property_get_this_parameter (ValaProperty* self);
static ValaList* vala_interface_real_get_properties (ValaObjectTypeSymbol* base);
static void vala_interface_real_add_signal (ValaSymbol* base, ValaSignal* sig);
static ValaList* vala_interface_real_get_signals (ValaObjectTypeSymbol* base);
ValaList* vala_interface_get_virtuals (ValaInterface* self);
static ValaList* vala_interface_real_get_virtuals (ValaInterface* self);
static void vala_interface_real_add_class (ValaSymbol* base, ValaClass* cl);
static void vala_interface_real_add_struct (ValaSymbol* base, ValaStruct* st);
static void vala_interface_real_add_enum (ValaSymbol* base, ValaEnum* en);
static void vala_interface_real_add_delegate (ValaSymbol* base, ValaDelegate* d);
static void vala_interface_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
void vala_code_visitor_visit_interface (ValaCodeVisitor* self, ValaInterface* iface);
static void vala_interface_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
void vala_code_node_accept (ValaCodeNode* self, ValaCodeVisitor* visitor);
GType vala_typeparameter_get_type (void) G_GNUC_CONST;
ValaList* vala_object_type_symbol_get_type_parameters (ValaObjectTypeSymbol* self);
static gboolean vala_interface_real_is_reference_type (ValaTypeSymbol* base);
static gboolean vala_interface_real_is_subtype_of (ValaTypeSymbol* base, ValaTypeSymbol* t);
ValaTypeSymbol* vala_data_type_get_data_type (ValaDataType* self);
gboolean vala_typesymbol_is_subtype_of (ValaTypeSymbol* self, ValaTypeSymbol* t);
static void vala_interface_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
static gboolean vala_interface_real_check (ValaCodeNode* base, ValaCodeContext* context);
gboolean vala_code_node_get_checked (ValaCodeNode* self);
gboolean vala_code_node_get_error (ValaCodeNode* self);
void vala_code_node_set_checked (ValaCodeNode* self, gboolean value);
gpointer vala_source_file_ref (gpointer instance);
void vala_source_file_unref (gpointer instance);
GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_file (GValue* value, gpointer v_object);
void vala_value_take_source_file (GValue* value, gpointer v_object);
gpointer vala_value_get_source_file (const GValue* value);
GType vala_source_file_get_type (void) G_GNUC_CONST;
GType vala_semantic_analyzer_get_type (void) G_GNUC_CONST;
ValaSemanticAnalyzer* vala_code_context_get_analyzer (ValaCodeContext* self);
ValaSourceFile* vala_semantic_analyzer_get_current_source_file (ValaSemanticAnalyzer* self);
ValaSymbol* vala_semantic_analyzer_get_current_symbol (ValaSemanticAnalyzer* self);
ValaSourceFile* vala_source_reference_get_file (ValaSourceReference* self);
void vala_semantic_analyzer_set_current_source_file (ValaSemanticAnalyzer* self, ValaSourceFile* value);
void vala_semantic_analyzer_set_current_symbol (ValaSemanticAnalyzer* self, ValaSymbol* value);
gboolean vala_semantic_analyzer_is_type_accessible (ValaSemanticAnalyzer* self, ValaSymbol* sym, ValaDataType* type);
gchar* vala_code_node_to_string (ValaCodeNode* self);
gchar* vala_symbol_get_full_name (ValaSymbol* self);
gboolean vala_code_node_check (ValaCodeNode* self, ValaCodeContext* context);
gboolean vala_method_get_is_virtual (ValaMethod* self);
gboolean vala_method_get_is_abstract (ValaMethod* self);
gboolean vala_signal_get_is_virtual (ValaSignal* self);
gboolean vala_property_get_is_virtual (ValaProperty* self);
gboolean vala_property_get_is_abstract (ValaProperty* self);
gint vala_code_node_get_attribute_integer (ValaCodeNode* self, const gchar* attribute, const gchar* argument, gint default_value);
static void vala_interface_finalize (ValaCodeNode* obj);


/**
 * Returns a copy of the list of classes.
 *
 * @return list of classes
 */
static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList* vala_interface_get_classes (ValaInterface* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_ = NULL;
	ValaList* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->classes;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns a copy of the list of structs.
 *
 * @return list of structs
 */
ValaList* vala_interface_get_structs (ValaInterface* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_ = NULL;
	ValaList* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->structs;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns a copy of the list of enums.
 *
 * @return list of enums
 */
ValaList* vala_interface_get_enums (ValaInterface* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_ = NULL;
	ValaList* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->enums;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns a copy of the list of delegates.
 *
 * @return list of delegates
 */
ValaList* vala_interface_get_delegates (ValaInterface* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_ = NULL;
	ValaList* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->delegates;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Creates a new interface.
 *
 * @param name   type name
 * @param source reference to source code
 * @return       newly created interface
 */
ValaInterface* vala_interface_construct (GType object_type, const gchar* name, ValaSourceReference* source_reference, ValaComment* comment) {
	ValaInterface* self = NULL;
	const gchar* _tmp0_ = NULL;
	ValaSourceReference* _tmp1_ = NULL;
	ValaComment* _tmp2_ = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = source_reference;
	_tmp2_ = comment;
	self = (ValaInterface*) vala_object_type_symbol_construct (object_type, _tmp0_, _tmp1_, _tmp2_);
	return self;
}


ValaInterface* vala_interface_new (const gchar* name, ValaSourceReference* source_reference, ValaComment* comment) {
	return vala_interface_construct (VALA_TYPE_INTERFACE, name, source_reference, comment);
}


/**
 * Adds the specified interface or class to the list of prerequisites of
 * this interface.
 *
 * @param type an interface or class reference
 */
void vala_interface_add_prerequisite (ValaInterface* self, ValaDataType* type) {
	ValaList* _tmp0_ = NULL;
	ValaDataType* _tmp1_ = NULL;
	ValaDataType* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = self->priv->prerequisites;
	_tmp1_ = type;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp2_ = type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
}


/**
 * Prepends the specified interface or class to the list of
 * prerequisites of this interface.
 *
 * @param type an interface or class reference
 */
void vala_interface_prepend_prerequisite (ValaInterface* self, ValaDataType* type) {
	ValaList* _tmp0_ = NULL;
	ValaDataType* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = self->priv->prerequisites;
	_tmp1_ = type;
	vala_list_insert (_tmp0_, 0, _tmp1_);
}


/**
 * Returns a copy of the base type list.
 *
 * @return list of base types
 */
ValaList* vala_interface_get_prerequisites (ValaInterface* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_ = NULL;
	ValaList* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->prerequisites;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Adds the specified method as a member to this interface.
 *
 * @param m a method
 */
static void vala_interface_real_add_method (ValaSymbol* base, ValaMethod* m) {
	ValaInterface * self;
	ValaMethod* _tmp0_ = NULL;
	ValaMethod* _tmp5_ = NULL;
	ValaMemberBinding _tmp6_ = 0;
	ValaMemberBinding _tmp7_ = 0;
	gboolean _tmp24_ = FALSE;
	ValaMethod* _tmp25_ = NULL;
	ValaDataType* _tmp26_ = NULL;
	ValaDataType* _tmp27_ = NULL;
	gboolean _tmp33_ = FALSE;
	ValaList* _tmp47_ = NULL;
	ValaMethod* _tmp48_ = NULL;
	ValaScope* _tmp49_ = NULL;
	ValaScope* _tmp50_ = NULL;
	ValaMethod* _tmp51_ = NULL;
	const gchar* _tmp52_ = NULL;
	const gchar* _tmp53_ = NULL;
	ValaMethod* _tmp54_ = NULL;
	self = (ValaInterface*) base;
	g_return_if_fail (m != NULL);
	_tmp0_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp1_ = NULL;
		ValaSourceReference* _tmp2_ = NULL;
		ValaSourceReference* _tmp3_ = NULL;
		ValaMethod* _tmp4_ = NULL;
		_tmp1_ = m;
		_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1_);
		_tmp3_ = _tmp2_;
		vala_report_error (_tmp3_, "construction methods may only be declared within classes and structs");
		_tmp4_ = m;
		vala_code_node_set_error ((ValaCodeNode*) _tmp4_, TRUE);
		return;
	}
	_tmp5_ = m;
	_tmp6_ = vala_method_get_binding (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaMethod* _tmp8_ = NULL;
		ValaObjectType* _tmp9_ = NULL;
		ValaObjectType* _tmp10_ = NULL;
		ValaParameter* _tmp11_ = NULL;
		ValaParameter* _tmp12_ = NULL;
		ValaMethod* _tmp13_ = NULL;
		ValaScope* _tmp14_ = NULL;
		ValaScope* _tmp15_ = NULL;
		ValaMethod* _tmp16_ = NULL;
		ValaParameter* _tmp17_ = NULL;
		ValaParameter* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		ValaMethod* _tmp21_ = NULL;
		ValaParameter* _tmp22_ = NULL;
		ValaParameter* _tmp23_ = NULL;
		_tmp8_ = m;
		_tmp9_ = vala_object_type_symbol_get_this_type ((ValaObjectTypeSymbol*) self);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_parameter_new ("this", (ValaDataType*) _tmp10_, NULL);
		_tmp12_ = _tmp11_;
		vala_method_set_this_parameter (_tmp8_, _tmp12_);
		_vala_code_node_unref0 (_tmp12_);
		_vala_code_node_unref0 (_tmp10_);
		_tmp13_ = m;
		_tmp14_ = vala_symbol_get_scope ((ValaSymbol*) _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = m;
		_tmp17_ = vala_method_get_this_parameter (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_symbol_get_name ((ValaSymbol*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = m;
		_tmp22_ = vala_method_get_this_parameter (_tmp21_);
		_tmp23_ = _tmp22_;
		vala_scope_add (_tmp15_, _tmp20_, (ValaSymbol*) _tmp23_);
	}
	_tmp25_ = m;
	_tmp26_ = vala_method_get_return_type (_tmp25_);
	_tmp27_ = _tmp26_;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, VALA_TYPE_VOID_TYPE)) {
		ValaMethod* _tmp28_ = NULL;
		ValaList* _tmp29_ = NULL;
		ValaList* _tmp30_ = NULL;
		gint _tmp31_ = 0;
		gint _tmp32_ = 0;
		_tmp28_ = m;
		_tmp29_ = vala_method_get_postconditions (_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = vala_collection_get_size ((ValaCollection*) _tmp30_);
		_tmp32_ = _tmp31_;
		_tmp24_ = _tmp32_ > 0;
		_vala_iterable_unref0 (_tmp30_);
	} else {
		_tmp24_ = FALSE;
	}
	_tmp33_ = _tmp24_;
	if (_tmp33_) {
		ValaMethod* _tmp34_ = NULL;
		ValaMethod* _tmp35_ = NULL;
		ValaDataType* _tmp36_ = NULL;
		ValaDataType* _tmp37_ = NULL;
		ValaDataType* _tmp38_ = NULL;
		ValaDataType* _tmp39_ = NULL;
		ValaSourceReference* _tmp40_ = NULL;
		ValaSourceReference* _tmp41_ = NULL;
		ValaLocalVariable* _tmp42_ = NULL;
		ValaLocalVariable* _tmp43_ = NULL;
		ValaMethod* _tmp44_ = NULL;
		ValaLocalVariable* _tmp45_ = NULL;
		ValaLocalVariable* _tmp46_ = NULL;
		_tmp34_ = m;
		_tmp35_ = m;
		_tmp36_ = vala_method_get_return_type (_tmp35_);
		_tmp37_ = _tmp36_;
		_tmp38_ = vala_data_type_copy (_tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_local_variable_new (_tmp39_, "result", NULL, _tmp41_);
		_tmp43_ = _tmp42_;
		vala_subroutine_set_result_var ((ValaSubroutine*) _tmp34_, _tmp43_);
		_vala_code_node_unref0 (_tmp43_);
		_vala_code_node_unref0 (_tmp39_);
		_tmp44_ = m;
		_tmp45_ = vala_subroutine_get_result_var ((ValaSubroutine*) _tmp44_);
		_tmp46_ = _tmp45_;
		vala_local_variable_set_is_result (_tmp46_, TRUE);
	}
	_tmp47_ = self->priv->methods;
	_tmp48_ = m;
	vala_collection_add ((ValaCollection*) _tmp47_, _tmp48_);
	_tmp49_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp50_ = _tmp49_;
	_tmp51_ = m;
	_tmp52_ = vala_symbol_get_name ((ValaSymbol*) _tmp51_);
	_tmp53_ = _tmp52_;
	_tmp54_ = m;
	vala_scope_add (_tmp50_, _tmp53_, (ValaSymbol*) _tmp54_);
}


/**
 * Returns a copy of the list of methods.
 *
 * @return list of methods
 */
static ValaList* vala_interface_real_get_methods (ValaObjectTypeSymbol* base) {
	ValaInterface * self;
	ValaList* result = NULL;
	ValaList* _tmp0_ = NULL;
	ValaList* _tmp1_ = NULL;
	self = (ValaInterface*) base;
	_tmp0_ = self->priv->methods;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Adds the specified field as a member to this interface. The field
 * must be private and static.
 *
 * @param f a field
 */
static void vala_interface_real_add_field (ValaSymbol* base, ValaField* f) {
	ValaInterface * self;
	ValaList* _tmp0_ = NULL;
	ValaField* _tmp1_ = NULL;
	ValaScope* _tmp2_ = NULL;
	ValaScope* _tmp3_ = NULL;
	ValaField* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	ValaField* _tmp7_ = NULL;
	self = (ValaInterface*) base;
	g_return_if_fail (f != NULL);
	_tmp0_ = self->priv->fields;
	_tmp1_ = f;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = f;
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = f;
	vala_scope_add (_tmp3_, _tmp6_, (ValaSymbol*) _tmp7_);
}


/**
 * Returns a copy of the list of fields.
 *
 * @return list of fields
 */
ValaList* vala_interface_get_fields (ValaInterface* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_ = NULL;
	ValaList* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->fields;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Adds the specified constant as a member to this interface.
 *
 * @param c a constant
 */
static void vala_interface_real_add_constant (ValaSymbol* base, ValaConstant* c) {
	ValaInterface * self;
	ValaList* _tmp0_ = NULL;
	ValaConstant* _tmp1_ = NULL;
	ValaScope* _tmp2_ = NULL;
	ValaScope* _tmp3_ = NULL;
	ValaConstant* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	ValaConstant* _tmp7_ = NULL;
	self = (ValaInterface*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = self->priv->constants;
	_tmp1_ = c;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = c;
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = c;
	vala_scope_add (_tmp3_, _tmp6_, (ValaSymbol*) _tmp7_);
}


/**
 * Returns a copy of the list of constants.
 *
 * @return list of constants
 */
ValaList* vala_interface_get_constants (ValaInterface* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_ = NULL;
	ValaList* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->constants;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Adds the specified property as a member to this interface.
 *
 * @param prop a property
 */
static void vala_interface_real_add_property (ValaSymbol* base, ValaProperty* prop) {
	ValaInterface * self;
	ValaList* _tmp0_ = NULL;
	ValaProperty* _tmp1_ = NULL;
	ValaScope* _tmp2_ = NULL;
	ValaScope* _tmp3_ = NULL;
	ValaProperty* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	ValaProperty* _tmp7_ = NULL;
	ValaProperty* _tmp8_ = NULL;
	ValaObjectType* _tmp9_ = NULL;
	ValaObjectType* _tmp10_ = NULL;
	ValaParameter* _tmp11_ = NULL;
	ValaParameter* _tmp12_ = NULL;
	ValaProperty* _tmp13_ = NULL;
	ValaScope* _tmp14_ = NULL;
	ValaScope* _tmp15_ = NULL;
	ValaProperty* _tmp16_ = NULL;
	ValaParameter* _tmp17_ = NULL;
	ValaParameter* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	ValaProperty* _tmp21_ = NULL;
	ValaParameter* _tmp22_ = NULL;
	ValaParameter* _tmp23_ = NULL;
	self = (ValaInterface*) base;
	g_return_if_fail (prop != NULL);
	_tmp0_ = self->priv->properties;
	_tmp1_ = prop;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = prop;
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = prop;
	vala_scope_add (_tmp3_, _tmp6_, (ValaSymbol*) _tmp7_);
	_tmp8_ = prop;
	_tmp9_ = vala_object_type_new ((ValaObjectTypeSymbol*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_parameter_new ("this", (ValaDataType*) _tmp10_, NULL);
	_tmp12_ = _tmp11_;
	vala_property_set_this_parameter (_tmp8_, _tmp12_);
	_vala_code_node_unref0 (_tmp12_);
	_vala_code_node_unref0 (_tmp10_);
	_tmp13_ = prop;
	_tmp14_ = vala_symbol_get_scope ((ValaSymbol*) _tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = prop;
	_tmp17_ = vala_property_get_this_parameter (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = vala_symbol_get_name ((ValaSymbol*) _tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = prop;
	_tmp22_ = vala_property_get_this_parameter (_tmp21_);
	_tmp23_ = _tmp22_;
	vala_scope_add (_tmp15_, _tmp20_, (ValaSymbol*) _tmp23_);
}


/**
 * Returns a copy of the list of properties.
 *
 * @return list of properties
 */
static ValaList* vala_interface_real_get_properties (ValaObjectTypeSymbol* base) {
	ValaInterface * self;
	ValaList* result = NULL;
	ValaList* _tmp0_ = NULL;
	ValaList* _tmp1_ = NULL;
	self = (ValaInterface*) base;
	_tmp0_ = self->priv->properties;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Adds the specified signal as a member to this interface.
 *
 * @param sig a signal
 */
static void vala_interface_real_add_signal (ValaSymbol* base, ValaSignal* sig) {
	ValaInterface * self;
	ValaList* _tmp0_ = NULL;
	ValaSignal* _tmp1_ = NULL;
	ValaScope* _tmp2_ = NULL;
	ValaScope* _tmp3_ = NULL;
	ValaSignal* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	ValaSignal* _tmp7_ = NULL;
	self = (ValaInterface*) base;
	g_return_if_fail (sig != NULL);
	_tmp0_ = self->priv->signals;
	_tmp1_ = sig;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = sig;
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = sig;
	vala_scope_add (_tmp3_, _tmp6_, (ValaSymbol*) _tmp7_);
}


/**
 * Returns a copy of the list of signals.
 *
 * @return list of signals
 */
static ValaList* vala_interface_real_get_signals (ValaObjectTypeSymbol* base) {
	ValaInterface * self;
	ValaList* result = NULL;
	ValaList* _tmp0_ = NULL;
	ValaList* _tmp1_ = NULL;
	self = (ValaInterface*) base;
	_tmp0_ = self->priv->signals;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static ValaList* vala_interface_real_get_virtuals (ValaInterface* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_ = NULL;
	ValaList* _tmp1_ = NULL;
	_tmp0_ = self->priv->virtuals;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


ValaList* vala_interface_get_virtuals (ValaInterface* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_INTERFACE_GET_CLASS (self)->get_virtuals (self);
}


/**
 * Adds the specified class as an inner class.
 *
 * @param cl a class
 */
static void vala_interface_real_add_class (ValaSymbol* base, ValaClass* cl) {
	ValaInterface * self;
	ValaList* _tmp0_ = NULL;
	ValaClass* _tmp1_ = NULL;
	ValaScope* _tmp2_ = NULL;
	ValaScope* _tmp3_ = NULL;
	ValaClass* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	ValaClass* _tmp7_ = NULL;
	self = (ValaInterface*) base;
	g_return_if_fail (cl != NULL);
	_tmp0_ = self->priv->classes;
	_tmp1_ = cl;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = cl;
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = cl;
	vala_scope_add (_tmp3_, _tmp6_, (ValaSymbol*) _tmp7_);
}


/**
 * Adds the specified struct as an inner struct.
 *
 * @param st a struct
 */
static void vala_interface_real_add_struct (ValaSymbol* base, ValaStruct* st) {
	ValaInterface * self;
	ValaList* _tmp0_ = NULL;
	ValaStruct* _tmp1_ = NULL;
	ValaScope* _tmp2_ = NULL;
	ValaScope* _tmp3_ = NULL;
	ValaStruct* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	ValaStruct* _tmp7_ = NULL;
	self = (ValaInterface*) base;
	g_return_if_fail (st != NULL);
	_tmp0_ = self->priv->structs;
	_tmp1_ = st;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = st;
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = st;
	vala_scope_add (_tmp3_, _tmp6_, (ValaSymbol*) _tmp7_);
}


/**
 * Adds the specified enum as an inner enum.
 *
 * @param en an enum
 */
static void vala_interface_real_add_enum (ValaSymbol* base, ValaEnum* en) {
	ValaInterface * self;
	ValaList* _tmp0_ = NULL;
	ValaEnum* _tmp1_ = NULL;
	ValaScope* _tmp2_ = NULL;
	ValaScope* _tmp3_ = NULL;
	ValaEnum* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	ValaEnum* _tmp7_ = NULL;
	self = (ValaInterface*) base;
	g_return_if_fail (en != NULL);
	_tmp0_ = self->priv->enums;
	_tmp1_ = en;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = en;
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = en;
	vala_scope_add (_tmp3_, _tmp6_, (ValaSymbol*) _tmp7_);
}


/**
 * Adds the specified delegate as an inner delegate.
 *
 * @param d a delegate
 */
static void vala_interface_real_add_delegate (ValaSymbol* base, ValaDelegate* d) {
	ValaInterface * self;
	ValaList* _tmp0_ = NULL;
	ValaDelegate* _tmp1_ = NULL;
	ValaScope* _tmp2_ = NULL;
	ValaScope* _tmp3_ = NULL;
	ValaDelegate* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	ValaDelegate* _tmp7_ = NULL;
	self = (ValaInterface*) base;
	g_return_if_fail (d != NULL);
	_tmp0_ = self->priv->delegates;
	_tmp1_ = d;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = d;
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = d;
	vala_scope_add (_tmp3_, _tmp6_, (ValaSymbol*) _tmp7_);
}


static void vala_interface_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaInterface * self;
	ValaCodeVisitor* _tmp0_ = NULL;
	self = (ValaInterface*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_interface (_tmp0_, self);
}


static void vala_interface_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaInterface * self;
	self = (ValaInterface*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp0_ = NULL;
		ValaList* _tmp1_ = NULL;
		gint _type_size = 0;
		ValaList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _type_index = 0;
		_tmp0_ = self->priv->prerequisites;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_type_list = _tmp1_;
		_tmp2_ = _type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_type_size = _tmp4_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			ValaDataType* type = NULL;
			ValaList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			ValaDataType* _tmp11_ = NULL;
			ValaCodeVisitor* _tmp12_ = NULL;
			_tmp5_ = _type_index;
			_type_index = _tmp5_ + 1;
			_tmp6_ = _type_index;
			_tmp7_ = _type_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _type_list;
			_tmp9_ = _type_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			type = (ValaDataType*) _tmp10_;
			_tmp11_ = type;
			_tmp12_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp11_, _tmp12_);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp13_ = NULL;
		gint _p_size = 0;
		ValaList* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		gint _p_index = 0;
		_tmp13_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_p_list = _tmp13_;
		_tmp14_ = _p_list;
		_tmp15_ = vala_collection_get_size ((ValaCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		_p_size = _tmp16_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp17_ = 0;
			gint _tmp18_ = 0;
			gint _tmp19_ = 0;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp20_ = NULL;
			gint _tmp21_ = 0;
			gpointer _tmp22_ = NULL;
			ValaTypeParameter* _tmp23_ = NULL;
			ValaCodeVisitor* _tmp24_ = NULL;
			_tmp17_ = _p_index;
			_p_index = _tmp17_ + 1;
			_tmp18_ = _p_index;
			_tmp19_ = _p_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _p_list;
			_tmp21_ = _p_index;
			_tmp22_ = vala_list_get (_tmp20_, _tmp21_);
			p = (ValaTypeParameter*) _tmp22_;
			_tmp23_ = p;
			_tmp24_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp23_, _tmp24_);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp25_ = NULL;
		ValaList* _tmp26_ = NULL;
		gint _en_size = 0;
		ValaList* _tmp27_ = NULL;
		gint _tmp28_ = 0;
		gint _tmp29_ = 0;
		gint _en_index = 0;
		_tmp25_ = self->priv->enums;
		_tmp26_ = _vala_iterable_ref0 (_tmp25_);
		_en_list = _tmp26_;
		_tmp27_ = _en_list;
		_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
		_tmp29_ = _tmp28_;
		_en_size = _tmp29_;
		_en_index = -1;
		while (TRUE) {
			gint _tmp30_ = 0;
			gint _tmp31_ = 0;
			gint _tmp32_ = 0;
			ValaEnum* en = NULL;
			ValaList* _tmp33_ = NULL;
			gint _tmp34_ = 0;
			gpointer _tmp35_ = NULL;
			ValaEnum* _tmp36_ = NULL;
			ValaCodeVisitor* _tmp37_ = NULL;
			_tmp30_ = _en_index;
			_en_index = _tmp30_ + 1;
			_tmp31_ = _en_index;
			_tmp32_ = _en_size;
			if (!(_tmp31_ < _tmp32_)) {
				break;
			}
			_tmp33_ = _en_list;
			_tmp34_ = _en_index;
			_tmp35_ = vala_list_get (_tmp33_, _tmp34_);
			en = (ValaEnum*) _tmp35_;
			_tmp36_ = en;
			_tmp37_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp36_, _tmp37_);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp38_ = NULL;
		ValaList* _tmp39_ = NULL;
		gint _m_size = 0;
		ValaList* _tmp40_ = NULL;
		gint _tmp41_ = 0;
		gint _tmp42_ = 0;
		gint _m_index = 0;
		_tmp38_ = self->priv->methods;
		_tmp39_ = _vala_iterable_ref0 (_tmp38_);
		_m_list = _tmp39_;
		_tmp40_ = _m_list;
		_tmp41_ = vala_collection_get_size ((ValaCollection*) _tmp40_);
		_tmp42_ = _tmp41_;
		_m_size = _tmp42_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp43_ = 0;
			gint _tmp44_ = 0;
			gint _tmp45_ = 0;
			ValaMethod* m = NULL;
			ValaList* _tmp46_ = NULL;
			gint _tmp47_ = 0;
			gpointer _tmp48_ = NULL;
			ValaMethod* _tmp49_ = NULL;
			ValaCodeVisitor* _tmp50_ = NULL;
			_tmp43_ = _m_index;
			_m_index = _tmp43_ + 1;
			_tmp44_ = _m_index;
			_tmp45_ = _m_size;
			if (!(_tmp44_ < _tmp45_)) {
				break;
			}
			_tmp46_ = _m_list;
			_tmp47_ = _m_index;
			_tmp48_ = vala_list_get (_tmp46_, _tmp47_);
			m = (ValaMethod*) _tmp48_;
			_tmp49_ = m;
			_tmp50_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp49_, _tmp50_);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp51_ = NULL;
		ValaList* _tmp52_ = NULL;
		gint _f_size = 0;
		ValaList* _tmp53_ = NULL;
		gint _tmp54_ = 0;
		gint _tmp55_ = 0;
		gint _f_index = 0;
		_tmp51_ = self->priv->fields;
		_tmp52_ = _vala_iterable_ref0 (_tmp51_);
		_f_list = _tmp52_;
		_tmp53_ = _f_list;
		_tmp54_ = vala_collection_get_size ((ValaCollection*) _tmp53_);
		_tmp55_ = _tmp54_;
		_f_size = _tmp55_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp56_ = 0;
			gint _tmp57_ = 0;
			gint _tmp58_ = 0;
			ValaField* f = NULL;
			ValaList* _tmp59_ = NULL;
			gint _tmp60_ = 0;
			gpointer _tmp61_ = NULL;
			ValaField* _tmp62_ = NULL;
			ValaCodeVisitor* _tmp63_ = NULL;
			_tmp56_ = _f_index;
			_f_index = _tmp56_ + 1;
			_tmp57_ = _f_index;
			_tmp58_ = _f_size;
			if (!(_tmp57_ < _tmp58_)) {
				break;
			}
			_tmp59_ = _f_list;
			_tmp60_ = _f_index;
			_tmp61_ = vala_list_get (_tmp59_, _tmp60_);
			f = (ValaField*) _tmp61_;
			_tmp62_ = f;
			_tmp63_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp62_, _tmp63_);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp64_ = NULL;
		ValaList* _tmp65_ = NULL;
		gint _c_size = 0;
		ValaList* _tmp66_ = NULL;
		gint _tmp67_ = 0;
		gint _tmp68_ = 0;
		gint _c_index = 0;
		_tmp64_ = self->priv->constants;
		_tmp65_ = _vala_iterable_ref0 (_tmp64_);
		_c_list = _tmp65_;
		_tmp66_ = _c_list;
		_tmp67_ = vala_collection_get_size ((ValaCollection*) _tmp66_);
		_tmp68_ = _tmp67_;
		_c_size = _tmp68_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp69_ = 0;
			gint _tmp70_ = 0;
			gint _tmp71_ = 0;
			ValaConstant* c = NULL;
			ValaList* _tmp72_ = NULL;
			gint _tmp73_ = 0;
			gpointer _tmp74_ = NULL;
			ValaConstant* _tmp75_ = NULL;
			ValaCodeVisitor* _tmp76_ = NULL;
			_tmp69_ = _c_index;
			_c_index = _tmp69_ + 1;
			_tmp70_ = _c_index;
			_tmp71_ = _c_size;
			if (!(_tmp70_ < _tmp71_)) {
				break;
			}
			_tmp72_ = _c_list;
			_tmp73_ = _c_index;
			_tmp74_ = vala_list_get (_tmp72_, _tmp73_);
			c = (ValaConstant*) _tmp74_;
			_tmp75_ = c;
			_tmp76_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp75_, _tmp76_);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp77_ = NULL;
		ValaList* _tmp78_ = NULL;
		gint _prop_size = 0;
		ValaList* _tmp79_ = NULL;
		gint _tmp80_ = 0;
		gint _tmp81_ = 0;
		gint _prop_index = 0;
		_tmp77_ = self->priv->properties;
		_tmp78_ = _vala_iterable_ref0 (_tmp77_);
		_prop_list = _tmp78_;
		_tmp79_ = _prop_list;
		_tmp80_ = vala_collection_get_size ((ValaCollection*) _tmp79_);
		_tmp81_ = _tmp80_;
		_prop_size = _tmp81_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp82_ = 0;
			gint _tmp83_ = 0;
			gint _tmp84_ = 0;
			ValaProperty* prop = NULL;
			ValaList* _tmp85_ = NULL;
			gint _tmp86_ = 0;
			gpointer _tmp87_ = NULL;
			ValaProperty* _tmp88_ = NULL;
			ValaCodeVisitor* _tmp89_ = NULL;
			_tmp82_ = _prop_index;
			_prop_index = _tmp82_ + 1;
			_tmp83_ = _prop_index;
			_tmp84_ = _prop_size;
			if (!(_tmp83_ < _tmp84_)) {
				break;
			}
			_tmp85_ = _prop_list;
			_tmp86_ = _prop_index;
			_tmp87_ = vala_list_get (_tmp85_, _tmp86_);
			prop = (ValaProperty*) _tmp87_;
			_tmp88_ = prop;
			_tmp89_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp88_, _tmp89_);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	{
		ValaList* _sig_list = NULL;
		ValaList* _tmp90_ = NULL;
		ValaList* _tmp91_ = NULL;
		gint _sig_size = 0;
		ValaList* _tmp92_ = NULL;
		gint _tmp93_ = 0;
		gint _tmp94_ = 0;
		gint _sig_index = 0;
		_tmp90_ = self->priv->signals;
		_tmp91_ = _vala_iterable_ref0 (_tmp90_);
		_sig_list = _tmp91_;
		_tmp92_ = _sig_list;
		_tmp93_ = vala_collection_get_size ((ValaCollection*) _tmp92_);
		_tmp94_ = _tmp93_;
		_sig_size = _tmp94_;
		_sig_index = -1;
		while (TRUE) {
			gint _tmp95_ = 0;
			gint _tmp96_ = 0;
			gint _tmp97_ = 0;
			ValaSignal* sig = NULL;
			ValaList* _tmp98_ = NULL;
			gint _tmp99_ = 0;
			gpointer _tmp100_ = NULL;
			ValaSignal* _tmp101_ = NULL;
			ValaCodeVisitor* _tmp102_ = NULL;
			_tmp95_ = _sig_index;
			_sig_index = _tmp95_ + 1;
			_tmp96_ = _sig_index;
			_tmp97_ = _sig_size;
			if (!(_tmp96_ < _tmp97_)) {
				break;
			}
			_tmp98_ = _sig_list;
			_tmp99_ = _sig_index;
			_tmp100_ = vala_list_get (_tmp98_, _tmp99_);
			sig = (ValaSignal*) _tmp100_;
			_tmp101_ = sig;
			_tmp102_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp101_, _tmp102_);
			_vala_code_node_unref0 (sig);
		}
		_vala_iterable_unref0 (_sig_list);
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp103_ = NULL;
		ValaList* _tmp104_ = NULL;
		gint _cl_size = 0;
		ValaList* _tmp105_ = NULL;
		gint _tmp106_ = 0;
		gint _tmp107_ = 0;
		gint _cl_index = 0;
		_tmp103_ = self->priv->classes;
		_tmp104_ = _vala_iterable_ref0 (_tmp103_);
		_cl_list = _tmp104_;
		_tmp105_ = _cl_list;
		_tmp106_ = vala_collection_get_size ((ValaCollection*) _tmp105_);
		_tmp107_ = _tmp106_;
		_cl_size = _tmp107_;
		_cl_index = -1;
		while (TRUE) {
			gint _tmp108_ = 0;
			gint _tmp109_ = 0;
			gint _tmp110_ = 0;
			ValaClass* cl = NULL;
			ValaList* _tmp111_ = NULL;
			gint _tmp112_ = 0;
			gpointer _tmp113_ = NULL;
			ValaClass* _tmp114_ = NULL;
			ValaCodeVisitor* _tmp115_ = NULL;
			_tmp108_ = _cl_index;
			_cl_index = _tmp108_ + 1;
			_tmp109_ = _cl_index;
			_tmp110_ = _cl_size;
			if (!(_tmp109_ < _tmp110_)) {
				break;
			}
			_tmp111_ = _cl_list;
			_tmp112_ = _cl_index;
			_tmp113_ = vala_list_get (_tmp111_, _tmp112_);
			cl = (ValaClass*) _tmp113_;
			_tmp114_ = cl;
			_tmp115_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp114_, _tmp115_);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp116_ = NULL;
		ValaList* _tmp117_ = NULL;
		gint _st_size = 0;
		ValaList* _tmp118_ = NULL;
		gint _tmp119_ = 0;
		gint _tmp120_ = 0;
		gint _st_index = 0;
		_tmp116_ = self->priv->structs;
		_tmp117_ = _vala_iterable_ref0 (_tmp116_);
		_st_list = _tmp117_;
		_tmp118_ = _st_list;
		_tmp119_ = vala_collection_get_size ((ValaCollection*) _tmp118_);
		_tmp120_ = _tmp119_;
		_st_size = _tmp120_;
		_st_index = -1;
		while (TRUE) {
			gint _tmp121_ = 0;
			gint _tmp122_ = 0;
			gint _tmp123_ = 0;
			ValaStruct* st = NULL;
			ValaList* _tmp124_ = NULL;
			gint _tmp125_ = 0;
			gpointer _tmp126_ = NULL;
			ValaStruct* _tmp127_ = NULL;
			ValaCodeVisitor* _tmp128_ = NULL;
			_tmp121_ = _st_index;
			_st_index = _tmp121_ + 1;
			_tmp122_ = _st_index;
			_tmp123_ = _st_size;
			if (!(_tmp122_ < _tmp123_)) {
				break;
			}
			_tmp124_ = _st_list;
			_tmp125_ = _st_index;
			_tmp126_ = vala_list_get (_tmp124_, _tmp125_);
			st = (ValaStruct*) _tmp126_;
			_tmp127_ = st;
			_tmp128_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp127_, _tmp128_);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp129_ = NULL;
		ValaList* _tmp130_ = NULL;
		gint _d_size = 0;
		ValaList* _tmp131_ = NULL;
		gint _tmp132_ = 0;
		gint _tmp133_ = 0;
		gint _d_index = 0;
		_tmp129_ = self->priv->delegates;
		_tmp130_ = _vala_iterable_ref0 (_tmp129_);
		_d_list = _tmp130_;
		_tmp131_ = _d_list;
		_tmp132_ = vala_collection_get_size ((ValaCollection*) _tmp131_);
		_tmp133_ = _tmp132_;
		_d_size = _tmp133_;
		_d_index = -1;
		while (TRUE) {
			gint _tmp134_ = 0;
			gint _tmp135_ = 0;
			gint _tmp136_ = 0;
			ValaDelegate* d = NULL;
			ValaList* _tmp137_ = NULL;
			gint _tmp138_ = 0;
			gpointer _tmp139_ = NULL;
			ValaDelegate* _tmp140_ = NULL;
			ValaCodeVisitor* _tmp141_ = NULL;
			_tmp134_ = _d_index;
			_d_index = _tmp134_ + 1;
			_tmp135_ = _d_index;
			_tmp136_ = _d_size;
			if (!(_tmp135_ < _tmp136_)) {
				break;
			}
			_tmp137_ = _d_list;
			_tmp138_ = _d_index;
			_tmp139_ = vala_list_get (_tmp137_, _tmp138_);
			d = (ValaDelegate*) _tmp139_;
			_tmp140_ = d;
			_tmp141_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp140_, _tmp141_);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
}


static gboolean vala_interface_real_is_reference_type (ValaTypeSymbol* base) {
	ValaInterface * self;
	gboolean result = FALSE;
	self = (ValaInterface*) base;
	result = TRUE;
	return result;
}


static gboolean vala_interface_real_is_subtype_of (ValaTypeSymbol* base, ValaTypeSymbol* t) {
	ValaInterface * self;
	gboolean result = FALSE;
	ValaTypeSymbol* _tmp0_ = NULL;
	self = (ValaInterface*) base;
	g_return_val_if_fail (t != NULL, FALSE);
	_tmp0_ = t;
	if (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol) == _tmp0_) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _prerequisite_list = NULL;
		ValaList* _tmp1_ = NULL;
		ValaList* _tmp2_ = NULL;
		gint _prerequisite_size = 0;
		ValaList* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _prerequisite_index = 0;
		_tmp1_ = self->priv->prerequisites;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		_prerequisite_list = _tmp2_;
		_tmp3_ = _prerequisite_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_prerequisite_size = _tmp5_;
		_prerequisite_index = -1;
		while (TRUE) {
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			ValaDataType* prerequisite = NULL;
			ValaList* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			gpointer _tmp11_ = NULL;
			gboolean _tmp12_ = FALSE;
			ValaDataType* _tmp13_ = NULL;
			ValaTypeSymbol* _tmp14_ = NULL;
			ValaTypeSymbol* _tmp15_ = NULL;
			gboolean _tmp21_ = FALSE;
			_tmp6_ = _prerequisite_index;
			_prerequisite_index = _tmp6_ + 1;
			_tmp7_ = _prerequisite_index;
			_tmp8_ = _prerequisite_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _prerequisite_list;
			_tmp10_ = _prerequisite_index;
			_tmp11_ = vala_list_get (_tmp9_, _tmp10_);
			prerequisite = (ValaDataType*) _tmp11_;
			_tmp13_ = prerequisite;
			_tmp14_ = vala_data_type_get_data_type (_tmp13_);
			_tmp15_ = _tmp14_;
			if (_tmp15_ != NULL) {
				ValaDataType* _tmp16_ = NULL;
				ValaTypeSymbol* _tmp17_ = NULL;
				ValaTypeSymbol* _tmp18_ = NULL;
				ValaTypeSymbol* _tmp19_ = NULL;
				gboolean _tmp20_ = FALSE;
				_tmp16_ = prerequisite;
				_tmp17_ = vala_data_type_get_data_type (_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = t;
				_tmp20_ = vala_typesymbol_is_subtype_of (_tmp18_, _tmp19_);
				_tmp12_ = _tmp20_;
			} else {
				_tmp12_ = FALSE;
			}
			_tmp21_ = _tmp12_;
			if (_tmp21_) {
				result = TRUE;
				_vala_code_node_unref0 (prerequisite);
				_vala_iterable_unref0 (_prerequisite_list);
				return result;
			}
			_vala_code_node_unref0 (prerequisite);
		}
		_vala_iterable_unref0 (_prerequisite_list);
	}
	result = FALSE;
	return result;
}


static void vala_interface_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaInterface * self;
	self = (ValaInterface*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				ValaList* _tmp4_ = NULL;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				ValaList* _tmp7_ = NULL;
				gint _tmp8_ = 0;
				gpointer _tmp9_ = NULL;
				ValaDataType* _tmp10_ = NULL;
				ValaDataType* _tmp11_ = NULL;
				gboolean _tmp12_ = FALSE;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = self->priv->prerequisites;
				_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
				_tmp6_ = _tmp5_;
				if (!(_tmp3_ < _tmp6_)) {
					break;
				}
				_tmp7_ = self->priv->prerequisites;
				_tmp8_ = i;
				_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
				_tmp10_ = (ValaDataType*) _tmp9_;
				_tmp11_ = old_type;
				_tmp12_ = _tmp10_ == _tmp11_;
				_vala_code_node_unref0 (_tmp10_);
				if (_tmp12_) {
					ValaList* _tmp13_ = NULL;
					gint _tmp14_ = 0;
					ValaDataType* _tmp15_ = NULL;
					_tmp13_ = self->priv->prerequisites;
					_tmp14_ = i;
					_tmp15_ = new_type;
					vala_list_set (_tmp13_, _tmp14_, _tmp15_);
					return;
				}
			}
		}
	}
}


static gpointer _vala_source_file_ref0 (gpointer self) {
	return self ? vala_source_file_ref (self) : NULL;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean vala_interface_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaInterface * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaSourceFile* old_source_file = NULL;
	ValaCodeContext* _tmp4_ = NULL;
	ValaSemanticAnalyzer* _tmp5_ = NULL;
	ValaSemanticAnalyzer* _tmp6_ = NULL;
	ValaSourceFile* _tmp7_ = NULL;
	ValaSourceFile* _tmp8_ = NULL;
	ValaSourceFile* _tmp9_ = NULL;
	ValaSymbol* old_symbol = NULL;
	ValaCodeContext* _tmp10_ = NULL;
	ValaSemanticAnalyzer* _tmp11_ = NULL;
	ValaSemanticAnalyzer* _tmp12_ = NULL;
	ValaSymbol* _tmp13_ = NULL;
	ValaSymbol* _tmp14_ = NULL;
	ValaSymbol* _tmp15_ = NULL;
	ValaSourceReference* _tmp16_ = NULL;
	ValaSourceReference* _tmp17_ = NULL;
	ValaCodeContext* _tmp25_ = NULL;
	ValaSemanticAnalyzer* _tmp26_ = NULL;
	ValaSemanticAnalyzer* _tmp27_ = NULL;
	ValaClass* prereq_class = NULL;
	ValaMap* positions = NULL;
	GHashFunc _tmp260_ = NULL;
	GEqualFunc _tmp261_ = NULL;
	GEqualFunc _tmp262_ = NULL;
	ValaHashMap* _tmp263_ = NULL;
	gboolean ordered_seen = FALSE;
	gboolean unordered_seen = FALSE;
	gboolean _tmp348_ = FALSE;
	ValaCodeContext* _tmp372_ = NULL;
	ValaSemanticAnalyzer* _tmp373_ = NULL;
	ValaSemanticAnalyzer* _tmp374_ = NULL;
	ValaSourceFile* _tmp375_ = NULL;
	ValaCodeContext* _tmp376_ = NULL;
	ValaSemanticAnalyzer* _tmp377_ = NULL;
	ValaSemanticAnalyzer* _tmp378_ = NULL;
	ValaSymbol* _tmp379_ = NULL;
	gboolean _tmp380_ = FALSE;
	gboolean _tmp381_ = FALSE;
	self = (ValaInterface*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = context;
	_tmp5_ = vala_code_context_get_analyzer (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_semantic_analyzer_get_current_source_file (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _vala_source_file_ref0 (_tmp8_);
	old_source_file = _tmp9_;
	_tmp10_ = context;
	_tmp11_ = vala_code_context_get_analyzer (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = vala_semantic_analyzer_get_current_symbol (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = _vala_code_node_ref0 (_tmp14_);
	old_symbol = _tmp15_;
	_tmp16_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp17_ = _tmp16_;
	if (_tmp17_ != NULL) {
		ValaCodeContext* _tmp18_ = NULL;
		ValaSemanticAnalyzer* _tmp19_ = NULL;
		ValaSemanticAnalyzer* _tmp20_ = NULL;
		ValaSourceReference* _tmp21_ = NULL;
		ValaSourceReference* _tmp22_ = NULL;
		ValaSourceFile* _tmp23_ = NULL;
		ValaSourceFile* _tmp24_ = NULL;
		_tmp18_ = context;
		_tmp19_ = vala_code_context_get_analyzer (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp22_ = _tmp21_;
		_tmp23_ = vala_source_reference_get_file (_tmp22_);
		_tmp24_ = _tmp23_;
		vala_semantic_analyzer_set_current_source_file (_tmp20_, _tmp24_);
	}
	_tmp25_ = context;
	_tmp26_ = vala_code_context_get_analyzer (_tmp25_);
	_tmp27_ = _tmp26_;
	vala_semantic_analyzer_set_current_symbol (_tmp27_, (ValaSymbol*) self);
	{
		ValaList* _prerequisite_reference_list = NULL;
		ValaList* _tmp28_ = NULL;
		gint _prerequisite_reference_size = 0;
		ValaList* _tmp29_ = NULL;
		gint _tmp30_ = 0;
		gint _tmp31_ = 0;
		gint _prerequisite_reference_index = 0;
		_tmp28_ = vala_interface_get_prerequisites (self);
		_prerequisite_reference_list = _tmp28_;
		_tmp29_ = _prerequisite_reference_list;
		_tmp30_ = vala_collection_get_size ((ValaCollection*) _tmp29_);
		_tmp31_ = _tmp30_;
		_prerequisite_reference_size = _tmp31_;
		_prerequisite_reference_index = -1;
		while (TRUE) {
			gint _tmp32_ = 0;
			gint _tmp33_ = 0;
			gint _tmp34_ = 0;
			ValaDataType* prerequisite_reference = NULL;
			ValaList* _tmp35_ = NULL;
			gint _tmp36_ = 0;
			gpointer _tmp37_ = NULL;
			ValaCodeContext* _tmp38_ = NULL;
			ValaSemanticAnalyzer* _tmp39_ = NULL;
			ValaSemanticAnalyzer* _tmp40_ = NULL;
			ValaDataType* _tmp41_ = NULL;
			gboolean _tmp42_ = FALSE;
			_tmp32_ = _prerequisite_reference_index;
			_prerequisite_reference_index = _tmp32_ + 1;
			_tmp33_ = _prerequisite_reference_index;
			_tmp34_ = _prerequisite_reference_size;
			if (!(_tmp33_ < _tmp34_)) {
				break;
			}
			_tmp35_ = _prerequisite_reference_list;
			_tmp36_ = _prerequisite_reference_index;
			_tmp37_ = vala_list_get (_tmp35_, _tmp36_);
			prerequisite_reference = (ValaDataType*) _tmp37_;
			_tmp38_ = context;
			_tmp39_ = vala_code_context_get_analyzer (_tmp38_);
			_tmp40_ = _tmp39_;
			_tmp41_ = prerequisite_reference;
			_tmp42_ = vala_semantic_analyzer_is_type_accessible (_tmp40_, (ValaSymbol*) self, _tmp41_);
			if (!_tmp42_) {
				ValaSourceReference* _tmp43_ = NULL;
				ValaSourceReference* _tmp44_ = NULL;
				ValaDataType* _tmp45_ = NULL;
				gchar* _tmp46_ = NULL;
				gchar* _tmp47_ = NULL;
				gchar* _tmp48_ = NULL;
				gchar* _tmp49_ = NULL;
				gchar* _tmp50_ = NULL;
				gchar* _tmp51_ = NULL;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp43_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp44_ = _tmp43_;
				_tmp45_ = prerequisite_reference;
				_tmp46_ = vala_code_node_to_string ((ValaCodeNode*) _tmp45_);
				_tmp47_ = _tmp46_;
				_tmp48_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp49_ = _tmp48_;
				_tmp50_ = g_strdup_printf ("prerequisite `%s` is less accessible than interface `%s`", _tmp47_, _tmp49_);
				_tmp51_ = _tmp50_;
				vala_report_error (_tmp44_, _tmp51_);
				_g_free0 (_tmp51_);
				_g_free0 (_tmp49_);
				_g_free0 (_tmp47_);
				result = FALSE;
				_vala_code_node_unref0 (prerequisite_reference);
				_vala_iterable_unref0 (_prerequisite_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (prerequisite_reference);
		}
		_vala_iterable_unref0 (_prerequisite_reference_list);
	}
	prereq_class = NULL;
	{
		ValaList* _prereq_list = NULL;
		ValaList* _tmp52_ = NULL;
		gint _prereq_size = 0;
		ValaList* _tmp53_ = NULL;
		gint _tmp54_ = 0;
		gint _tmp55_ = 0;
		gint _prereq_index = 0;
		_tmp52_ = vala_interface_get_prerequisites (self);
		_prereq_list = _tmp52_;
		_tmp53_ = _prereq_list;
		_tmp54_ = vala_collection_get_size ((ValaCollection*) _tmp53_);
		_tmp55_ = _tmp54_;
		_prereq_size = _tmp55_;
		_prereq_index = -1;
		while (TRUE) {
			gint _tmp56_ = 0;
			gint _tmp57_ = 0;
			gint _tmp58_ = 0;
			ValaDataType* prereq = NULL;
			ValaList* _tmp59_ = NULL;
			gint _tmp60_ = 0;
			gpointer _tmp61_ = NULL;
			ValaTypeSymbol* class_or_interface = NULL;
			ValaDataType* _tmp62_ = NULL;
			ValaTypeSymbol* _tmp63_ = NULL;
			ValaTypeSymbol* _tmp64_ = NULL;
			ValaTypeSymbol* _tmp65_ = NULL;
			ValaTypeSymbol* _tmp66_ = NULL;
			ValaTypeSymbol* _tmp67_ = NULL;
			ValaTypeSymbol* _tmp77_ = NULL;
			_tmp56_ = _prereq_index;
			_prereq_index = _tmp56_ + 1;
			_tmp57_ = _prereq_index;
			_tmp58_ = _prereq_size;
			if (!(_tmp57_ < _tmp58_)) {
				break;
			}
			_tmp59_ = _prereq_list;
			_tmp60_ = _prereq_index;
			_tmp61_ = vala_list_get (_tmp59_, _tmp60_);
			prereq = (ValaDataType*) _tmp61_;
			_tmp62_ = prereq;
			_tmp63_ = vala_data_type_get_data_type (_tmp62_);
			_tmp64_ = _tmp63_;
			_tmp65_ = _vala_code_node_ref0 (_tmp64_);
			class_or_interface = _tmp65_;
			_tmp66_ = class_or_interface;
			if (_tmp66_ == NULL) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_vala_code_node_unref0 (class_or_interface);
				_vala_code_node_unref0 (prereq);
				continue;
			}
			_tmp67_ = class_or_interface;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp67_, VALA_TYPE_OBJECT_TYPE_SYMBOL)) {
				ValaSourceReference* _tmp68_ = NULL;
				ValaSourceReference* _tmp69_ = NULL;
				gchar* _tmp70_ = NULL;
				gchar* _tmp71_ = NULL;
				ValaTypeSymbol* _tmp72_ = NULL;
				gchar* _tmp73_ = NULL;
				gchar* _tmp74_ = NULL;
				gchar* _tmp75_ = NULL;
				gchar* _tmp76_ = NULL;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp68_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp69_ = _tmp68_;
				_tmp70_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp71_ = _tmp70_;
				_tmp72_ = class_or_interface;
				_tmp73_ = vala_code_node_to_string ((ValaCodeNode*) _tmp72_);
				_tmp74_ = _tmp73_;
				_tmp75_ = g_strdup_printf ("Prerequisite `%s` of interface `%s` is not a class or interface", _tmp71_, _tmp74_);
				_tmp76_ = _tmp75_;
				vala_report_error (_tmp69_, _tmp76_);
				_g_free0 (_tmp76_);
				_g_free0 (_tmp74_);
				_g_free0 (_tmp71_);
				result = FALSE;
				_vala_code_node_unref0 (class_or_interface);
				_vala_code_node_unref0 (prereq);
				_vala_iterable_unref0 (_prereq_list);
				_vala_code_node_unref0 (prereq_class);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp77_ = class_or_interface;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp77_, VALA_TYPE_CLASS)) {
				ValaClass* _tmp78_ = NULL;
				ValaTypeSymbol* _tmp91_ = NULL;
				ValaClass* _tmp92_ = NULL;
				_tmp78_ = prereq_class;
				if (_tmp78_ != NULL) {
					ValaSourceReference* _tmp79_ = NULL;
					ValaSourceReference* _tmp80_ = NULL;
					gchar* _tmp81_ = NULL;
					gchar* _tmp82_ = NULL;
					ValaTypeSymbol* _tmp83_ = NULL;
					gchar* _tmp84_ = NULL;
					gchar* _tmp85_ = NULL;
					ValaClass* _tmp86_ = NULL;
					gchar* _tmp87_ = NULL;
					gchar* _tmp88_ = NULL;
					gchar* _tmp89_ = NULL;
					gchar* _tmp90_ = NULL;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp79_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp80_ = _tmp79_;
					_tmp81_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp82_ = _tmp81_;
					_tmp83_ = class_or_interface;
					_tmp84_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp83_);
					_tmp85_ = _tmp84_;
					_tmp86_ = prereq_class;
					_tmp87_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp86_);
					_tmp88_ = _tmp87_;
					_tmp89_ = g_strdup_printf ("%s: Interfaces cannot have multiple instantiable prerequisites (`%s' a" \
"nd `%s')", _tmp82_, _tmp85_, _tmp88_);
					_tmp90_ = _tmp89_;
					vala_report_error (_tmp80_, _tmp90_);
					_g_free0 (_tmp90_);
					_g_free0 (_tmp88_);
					_g_free0 (_tmp85_);
					_g_free0 (_tmp82_);
					result = FALSE;
					_vala_code_node_unref0 (class_or_interface);
					_vala_code_node_unref0 (prereq);
					_vala_iterable_unref0 (_prereq_list);
					_vala_code_node_unref0 (prereq_class);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
				_tmp91_ = class_or_interface;
				_tmp92_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp91_, VALA_TYPE_CLASS, ValaClass));
				_vala_code_node_unref0 (prereq_class);
				prereq_class = _tmp92_;
			}
			_vala_code_node_unref0 (class_or_interface);
			_vala_code_node_unref0 (prereq);
		}
		_vala_iterable_unref0 (_prereq_list);
	}
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp93_ = NULL;
		ValaList* _tmp94_ = NULL;
		gint _type_size = 0;
		ValaList* _tmp95_ = NULL;
		gint _tmp96_ = 0;
		gint _tmp97_ = 0;
		gint _type_index = 0;
		_tmp93_ = self->priv->prerequisites;
		_tmp94_ = _vala_iterable_ref0 (_tmp93_);
		_type_list = _tmp94_;
		_tmp95_ = _type_list;
		_tmp96_ = vala_collection_get_size ((ValaCollection*) _tmp95_);
		_tmp97_ = _tmp96_;
		_type_size = _tmp97_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp98_ = 0;
			gint _tmp99_ = 0;
			gint _tmp100_ = 0;
			ValaDataType* type = NULL;
			ValaList* _tmp101_ = NULL;
			gint _tmp102_ = 0;
			gpointer _tmp103_ = NULL;
			ValaDataType* _tmp104_ = NULL;
			ValaCodeContext* _tmp105_ = NULL;
			_tmp98_ = _type_index;
			_type_index = _tmp98_ + 1;
			_tmp99_ = _type_index;
			_tmp100_ = _type_size;
			if (!(_tmp99_ < _tmp100_)) {
				break;
			}
			_tmp101_ = _type_list;
			_tmp102_ = _type_index;
			_tmp103_ = vala_list_get (_tmp101_, _tmp102_);
			type = (ValaDataType*) _tmp103_;
			_tmp104_ = type;
			_tmp105_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp104_, _tmp105_);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp106_ = NULL;
		gint _p_size = 0;
		ValaList* _tmp107_ = NULL;
		gint _tmp108_ = 0;
		gint _tmp109_ = 0;
		gint _p_index = 0;
		_tmp106_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_p_list = _tmp106_;
		_tmp107_ = _p_list;
		_tmp108_ = vala_collection_get_size ((ValaCollection*) _tmp107_);
		_tmp109_ = _tmp108_;
		_p_size = _tmp109_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp110_ = 0;
			gint _tmp111_ = 0;
			gint _tmp112_ = 0;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp113_ = NULL;
			gint _tmp114_ = 0;
			gpointer _tmp115_ = NULL;
			ValaTypeParameter* _tmp116_ = NULL;
			ValaCodeContext* _tmp117_ = NULL;
			_tmp110_ = _p_index;
			_p_index = _tmp110_ + 1;
			_tmp111_ = _p_index;
			_tmp112_ = _p_size;
			if (!(_tmp111_ < _tmp112_)) {
				break;
			}
			_tmp113_ = _p_list;
			_tmp114_ = _p_index;
			_tmp115_ = vala_list_get (_tmp113_, _tmp114_);
			p = (ValaTypeParameter*) _tmp115_;
			_tmp116_ = p;
			_tmp117_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp116_, _tmp117_);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp118_ = NULL;
		ValaList* _tmp119_ = NULL;
		gint _en_size = 0;
		ValaList* _tmp120_ = NULL;
		gint _tmp121_ = 0;
		gint _tmp122_ = 0;
		gint _en_index = 0;
		_tmp118_ = self->priv->enums;
		_tmp119_ = _vala_iterable_ref0 (_tmp118_);
		_en_list = _tmp119_;
		_tmp120_ = _en_list;
		_tmp121_ = vala_collection_get_size ((ValaCollection*) _tmp120_);
		_tmp122_ = _tmp121_;
		_en_size = _tmp122_;
		_en_index = -1;
		while (TRUE) {
			gint _tmp123_ = 0;
			gint _tmp124_ = 0;
			gint _tmp125_ = 0;
			ValaEnum* en = NULL;
			ValaList* _tmp126_ = NULL;
			gint _tmp127_ = 0;
			gpointer _tmp128_ = NULL;
			ValaEnum* _tmp129_ = NULL;
			ValaCodeContext* _tmp130_ = NULL;
			_tmp123_ = _en_index;
			_en_index = _tmp123_ + 1;
			_tmp124_ = _en_index;
			_tmp125_ = _en_size;
			if (!(_tmp124_ < _tmp125_)) {
				break;
			}
			_tmp126_ = _en_list;
			_tmp127_ = _en_index;
			_tmp128_ = vala_list_get (_tmp126_, _tmp127_);
			en = (ValaEnum*) _tmp128_;
			_tmp129_ = en;
			_tmp130_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp129_, _tmp130_);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp131_ = NULL;
		ValaList* _tmp132_ = NULL;
		gint _m_size = 0;
		ValaList* _tmp133_ = NULL;
		gint _tmp134_ = 0;
		gint _tmp135_ = 0;
		gint _m_index = 0;
		_tmp131_ = self->priv->methods;
		_tmp132_ = _vala_iterable_ref0 (_tmp131_);
		_m_list = _tmp132_;
		_tmp133_ = _m_list;
		_tmp134_ = vala_collection_get_size ((ValaCollection*) _tmp133_);
		_tmp135_ = _tmp134_;
		_m_size = _tmp135_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp136_ = 0;
			gint _tmp137_ = 0;
			gint _tmp138_ = 0;
			ValaMethod* m = NULL;
			ValaList* _tmp139_ = NULL;
			gint _tmp140_ = 0;
			gpointer _tmp141_ = NULL;
			ValaMethod* _tmp142_ = NULL;
			ValaCodeContext* _tmp143_ = NULL;
			gboolean _tmp144_ = FALSE;
			ValaMethod* _tmp145_ = NULL;
			gboolean _tmp146_ = FALSE;
			gboolean _tmp147_ = FALSE;
			gboolean _tmp151_ = FALSE;
			_tmp136_ = _m_index;
			_m_index = _tmp136_ + 1;
			_tmp137_ = _m_index;
			_tmp138_ = _m_size;
			if (!(_tmp137_ < _tmp138_)) {
				break;
			}
			_tmp139_ = _m_list;
			_tmp140_ = _m_index;
			_tmp141_ = vala_list_get (_tmp139_, _tmp140_);
			m = (ValaMethod*) _tmp141_;
			_tmp142_ = m;
			_tmp143_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp142_, _tmp143_);
			_tmp145_ = m;
			_tmp146_ = vala_method_get_is_virtual (_tmp145_);
			_tmp147_ = _tmp146_;
			if (_tmp147_) {
				_tmp144_ = TRUE;
			} else {
				ValaMethod* _tmp148_ = NULL;
				gboolean _tmp149_ = FALSE;
				gboolean _tmp150_ = FALSE;
				_tmp148_ = m;
				_tmp149_ = vala_method_get_is_abstract (_tmp148_);
				_tmp150_ = _tmp149_;
				_tmp144_ = _tmp150_;
			}
			_tmp151_ = _tmp144_;
			if (_tmp151_) {
				ValaList* _tmp152_ = NULL;
				ValaMethod* _tmp153_ = NULL;
				_tmp152_ = self->priv->virtuals;
				_tmp153_ = m;
				vala_collection_add ((ValaCollection*) _tmp152_, (ValaSymbol*) _tmp153_);
			}
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp154_ = NULL;
		ValaList* _tmp155_ = NULL;
		gint _f_size = 0;
		ValaList* _tmp156_ = NULL;
		gint _tmp157_ = 0;
		gint _tmp158_ = 0;
		gint _f_index = 0;
		_tmp154_ = self->priv->fields;
		_tmp155_ = _vala_iterable_ref0 (_tmp154_);
		_f_list = _tmp155_;
		_tmp156_ = _f_list;
		_tmp157_ = vala_collection_get_size ((ValaCollection*) _tmp156_);
		_tmp158_ = _tmp157_;
		_f_size = _tmp158_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp159_ = 0;
			gint _tmp160_ = 0;
			gint _tmp161_ = 0;
			ValaField* f = NULL;
			ValaList* _tmp162_ = NULL;
			gint _tmp163_ = 0;
			gpointer _tmp164_ = NULL;
			ValaField* _tmp165_ = NULL;
			ValaCodeContext* _tmp166_ = NULL;
			_tmp159_ = _f_index;
			_f_index = _tmp159_ + 1;
			_tmp160_ = _f_index;
			_tmp161_ = _f_size;
			if (!(_tmp160_ < _tmp161_)) {
				break;
			}
			_tmp162_ = _f_list;
			_tmp163_ = _f_index;
			_tmp164_ = vala_list_get (_tmp162_, _tmp163_);
			f = (ValaField*) _tmp164_;
			_tmp165_ = f;
			_tmp166_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp165_, _tmp166_);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp167_ = NULL;
		ValaList* _tmp168_ = NULL;
		gint _c_size = 0;
		ValaList* _tmp169_ = NULL;
		gint _tmp170_ = 0;
		gint _tmp171_ = 0;
		gint _c_index = 0;
		_tmp167_ = self->priv->constants;
		_tmp168_ = _vala_iterable_ref0 (_tmp167_);
		_c_list = _tmp168_;
		_tmp169_ = _c_list;
		_tmp170_ = vala_collection_get_size ((ValaCollection*) _tmp169_);
		_tmp171_ = _tmp170_;
		_c_size = _tmp171_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp172_ = 0;
			gint _tmp173_ = 0;
			gint _tmp174_ = 0;
			ValaConstant* c = NULL;
			ValaList* _tmp175_ = NULL;
			gint _tmp176_ = 0;
			gpointer _tmp177_ = NULL;
			ValaConstant* _tmp178_ = NULL;
			ValaCodeContext* _tmp179_ = NULL;
			_tmp172_ = _c_index;
			_c_index = _tmp172_ + 1;
			_tmp173_ = _c_index;
			_tmp174_ = _c_size;
			if (!(_tmp173_ < _tmp174_)) {
				break;
			}
			_tmp175_ = _c_list;
			_tmp176_ = _c_index;
			_tmp177_ = vala_list_get (_tmp175_, _tmp176_);
			c = (ValaConstant*) _tmp177_;
			_tmp178_ = c;
			_tmp179_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp178_, _tmp179_);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _sig_list = NULL;
		ValaList* _tmp180_ = NULL;
		ValaList* _tmp181_ = NULL;
		gint _sig_size = 0;
		ValaList* _tmp182_ = NULL;
		gint _tmp183_ = 0;
		gint _tmp184_ = 0;
		gint _sig_index = 0;
		_tmp180_ = self->priv->signals;
		_tmp181_ = _vala_iterable_ref0 (_tmp180_);
		_sig_list = _tmp181_;
		_tmp182_ = _sig_list;
		_tmp183_ = vala_collection_get_size ((ValaCollection*) _tmp182_);
		_tmp184_ = _tmp183_;
		_sig_size = _tmp184_;
		_sig_index = -1;
		while (TRUE) {
			gint _tmp185_ = 0;
			gint _tmp186_ = 0;
			gint _tmp187_ = 0;
			ValaSignal* sig = NULL;
			ValaList* _tmp188_ = NULL;
			gint _tmp189_ = 0;
			gpointer _tmp190_ = NULL;
			ValaSignal* _tmp191_ = NULL;
			ValaCodeContext* _tmp192_ = NULL;
			ValaSignal* _tmp193_ = NULL;
			gboolean _tmp194_ = FALSE;
			gboolean _tmp195_ = FALSE;
			_tmp185_ = _sig_index;
			_sig_index = _tmp185_ + 1;
			_tmp186_ = _sig_index;
			_tmp187_ = _sig_size;
			if (!(_tmp186_ < _tmp187_)) {
				break;
			}
			_tmp188_ = _sig_list;
			_tmp189_ = _sig_index;
			_tmp190_ = vala_list_get (_tmp188_, _tmp189_);
			sig = (ValaSignal*) _tmp190_;
			_tmp191_ = sig;
			_tmp192_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp191_, _tmp192_);
			_tmp193_ = sig;
			_tmp194_ = vala_signal_get_is_virtual (_tmp193_);
			_tmp195_ = _tmp194_;
			if (_tmp195_) {
				ValaList* _tmp196_ = NULL;
				ValaSignal* _tmp197_ = NULL;
				_tmp196_ = self->priv->virtuals;
				_tmp197_ = sig;
				vala_collection_add ((ValaCollection*) _tmp196_, (ValaSymbol*) _tmp197_);
			}
			_vala_code_node_unref0 (sig);
		}
		_vala_iterable_unref0 (_sig_list);
	}
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp198_ = NULL;
		ValaList* _tmp199_ = NULL;
		gint _prop_size = 0;
		ValaList* _tmp200_ = NULL;
		gint _tmp201_ = 0;
		gint _tmp202_ = 0;
		gint _prop_index = 0;
		_tmp198_ = self->priv->properties;
		_tmp199_ = _vala_iterable_ref0 (_tmp198_);
		_prop_list = _tmp199_;
		_tmp200_ = _prop_list;
		_tmp201_ = vala_collection_get_size ((ValaCollection*) _tmp200_);
		_tmp202_ = _tmp201_;
		_prop_size = _tmp202_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp203_ = 0;
			gint _tmp204_ = 0;
			gint _tmp205_ = 0;
			ValaProperty* prop = NULL;
			ValaList* _tmp206_ = NULL;
			gint _tmp207_ = 0;
			gpointer _tmp208_ = NULL;
			ValaProperty* _tmp209_ = NULL;
			ValaCodeContext* _tmp210_ = NULL;
			gboolean _tmp211_ = FALSE;
			ValaProperty* _tmp212_ = NULL;
			gboolean _tmp213_ = FALSE;
			gboolean _tmp214_ = FALSE;
			gboolean _tmp218_ = FALSE;
			_tmp203_ = _prop_index;
			_prop_index = _tmp203_ + 1;
			_tmp204_ = _prop_index;
			_tmp205_ = _prop_size;
			if (!(_tmp204_ < _tmp205_)) {
				break;
			}
			_tmp206_ = _prop_list;
			_tmp207_ = _prop_index;
			_tmp208_ = vala_list_get (_tmp206_, _tmp207_);
			prop = (ValaProperty*) _tmp208_;
			_tmp209_ = prop;
			_tmp210_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp209_, _tmp210_);
			_tmp212_ = prop;
			_tmp213_ = vala_property_get_is_virtual (_tmp212_);
			_tmp214_ = _tmp213_;
			if (_tmp214_) {
				_tmp211_ = TRUE;
			} else {
				ValaProperty* _tmp215_ = NULL;
				gboolean _tmp216_ = FALSE;
				gboolean _tmp217_ = FALSE;
				_tmp215_ = prop;
				_tmp216_ = vala_property_get_is_abstract (_tmp215_);
				_tmp217_ = _tmp216_;
				_tmp211_ = _tmp217_;
			}
			_tmp218_ = _tmp211_;
			if (_tmp218_) {
				ValaList* _tmp219_ = NULL;
				ValaProperty* _tmp220_ = NULL;
				_tmp219_ = self->priv->virtuals;
				_tmp220_ = prop;
				vala_collection_add ((ValaCollection*) _tmp219_, (ValaSymbol*) _tmp220_);
			}
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp221_ = NULL;
		ValaList* _tmp222_ = NULL;
		gint _cl_size = 0;
		ValaList* _tmp223_ = NULL;
		gint _tmp224_ = 0;
		gint _tmp225_ = 0;
		gint _cl_index = 0;
		_tmp221_ = self->priv->classes;
		_tmp222_ = _vala_iterable_ref0 (_tmp221_);
		_cl_list = _tmp222_;
		_tmp223_ = _cl_list;
		_tmp224_ = vala_collection_get_size ((ValaCollection*) _tmp223_);
		_tmp225_ = _tmp224_;
		_cl_size = _tmp225_;
		_cl_index = -1;
		while (TRUE) {
			gint _tmp226_ = 0;
			gint _tmp227_ = 0;
			gint _tmp228_ = 0;
			ValaClass* cl = NULL;
			ValaList* _tmp229_ = NULL;
			gint _tmp230_ = 0;
			gpointer _tmp231_ = NULL;
			ValaClass* _tmp232_ = NULL;
			ValaCodeContext* _tmp233_ = NULL;
			_tmp226_ = _cl_index;
			_cl_index = _tmp226_ + 1;
			_tmp227_ = _cl_index;
			_tmp228_ = _cl_size;
			if (!(_tmp227_ < _tmp228_)) {
				break;
			}
			_tmp229_ = _cl_list;
			_tmp230_ = _cl_index;
			_tmp231_ = vala_list_get (_tmp229_, _tmp230_);
			cl = (ValaClass*) _tmp231_;
			_tmp232_ = cl;
			_tmp233_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp232_, _tmp233_);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp234_ = NULL;
		ValaList* _tmp235_ = NULL;
		gint _st_size = 0;
		ValaList* _tmp236_ = NULL;
		gint _tmp237_ = 0;
		gint _tmp238_ = 0;
		gint _st_index = 0;
		_tmp234_ = self->priv->structs;
		_tmp235_ = _vala_iterable_ref0 (_tmp234_);
		_st_list = _tmp235_;
		_tmp236_ = _st_list;
		_tmp237_ = vala_collection_get_size ((ValaCollection*) _tmp236_);
		_tmp238_ = _tmp237_;
		_st_size = _tmp238_;
		_st_index = -1;
		while (TRUE) {
			gint _tmp239_ = 0;
			gint _tmp240_ = 0;
			gint _tmp241_ = 0;
			ValaStruct* st = NULL;
			ValaList* _tmp242_ = NULL;
			gint _tmp243_ = 0;
			gpointer _tmp244_ = NULL;
			ValaStruct* _tmp245_ = NULL;
			ValaCodeContext* _tmp246_ = NULL;
			_tmp239_ = _st_index;
			_st_index = _tmp239_ + 1;
			_tmp240_ = _st_index;
			_tmp241_ = _st_size;
			if (!(_tmp240_ < _tmp241_)) {
				break;
			}
			_tmp242_ = _st_list;
			_tmp243_ = _st_index;
			_tmp244_ = vala_list_get (_tmp242_, _tmp243_);
			st = (ValaStruct*) _tmp244_;
			_tmp245_ = st;
			_tmp246_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp245_, _tmp246_);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp247_ = NULL;
		ValaList* _tmp248_ = NULL;
		gint _d_size = 0;
		ValaList* _tmp249_ = NULL;
		gint _tmp250_ = 0;
		gint _tmp251_ = 0;
		gint _d_index = 0;
		_tmp247_ = self->priv->delegates;
		_tmp248_ = _vala_iterable_ref0 (_tmp247_);
		_d_list = _tmp248_;
		_tmp249_ = _d_list;
		_tmp250_ = vala_collection_get_size ((ValaCollection*) _tmp249_);
		_tmp251_ = _tmp250_;
		_d_size = _tmp251_;
		_d_index = -1;
		while (TRUE) {
			gint _tmp252_ = 0;
			gint _tmp253_ = 0;
			gint _tmp254_ = 0;
			ValaDelegate* d = NULL;
			ValaList* _tmp255_ = NULL;
			gint _tmp256_ = 0;
			gpointer _tmp257_ = NULL;
			ValaDelegate* _tmp258_ = NULL;
			ValaCodeContext* _tmp259_ = NULL;
			_tmp252_ = _d_index;
			_d_index = _tmp252_ + 1;
			_tmp253_ = _d_index;
			_tmp254_ = _d_size;
			if (!(_tmp253_ < _tmp254_)) {
				break;
			}
			_tmp255_ = _d_list;
			_tmp256_ = _d_index;
			_tmp257_ = vala_list_get (_tmp255_, _tmp256_);
			d = (ValaDelegate*) _tmp257_;
			_tmp258_ = d;
			_tmp259_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp258_, _tmp259_);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
	_tmp260_ = g_direct_hash;
	_tmp261_ = g_direct_equal;
	_tmp262_ = g_direct_equal;
	_tmp263_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, _tmp260_, _tmp261_, _tmp262_);
	positions = (ValaMap*) _tmp263_;
	ordered_seen = FALSE;
	unordered_seen = FALSE;
	{
		ValaList* _sym_list = NULL;
		ValaList* _tmp264_ = NULL;
		ValaList* _tmp265_ = NULL;
		gint _sym_size = 0;
		ValaList* _tmp266_ = NULL;
		gint _tmp267_ = 0;
		gint _tmp268_ = 0;
		gint _sym_index = 0;
		_tmp264_ = self->priv->virtuals;
		_tmp265_ = _vala_iterable_ref0 (_tmp264_);
		_sym_list = _tmp265_;
		_tmp266_ = _sym_list;
		_tmp267_ = vala_collection_get_size ((ValaCollection*) _tmp266_);
		_tmp268_ = _tmp267_;
		_sym_size = _tmp268_;
		_sym_index = -1;
		while (TRUE) {
			gint _tmp269_ = 0;
			gint _tmp270_ = 0;
			gint _tmp271_ = 0;
			ValaSymbol* sym = NULL;
			ValaList* _tmp272_ = NULL;
			gint _tmp273_ = 0;
			gpointer _tmp274_ = NULL;
			gint ordering = 0;
			ValaSymbol* _tmp275_ = NULL;
			gint _tmp276_ = 0;
			gint _tmp277_ = 0;
			gboolean ordered = FALSE;
			gint _tmp286_ = 0;
			gboolean _tmp287_ = FALSE;
			gboolean _tmp288_ = FALSE;
			gboolean _tmp289_ = FALSE;
			gboolean _tmp291_ = FALSE;
			gboolean _tmp293_ = FALSE;
			gboolean _tmp302_ = FALSE;
			gboolean _tmp303_ = FALSE;
			gboolean _tmp305_ = FALSE;
			gboolean _tmp306_ = FALSE;
			gboolean _tmp307_ = FALSE;
			gboolean _tmp308_ = FALSE;
			gboolean _tmp310_ = FALSE;
			gboolean _tmp312_ = FALSE;
			gboolean _tmp321_ = FALSE;
			gboolean _tmp322_ = FALSE;
			gboolean _tmp324_ = FALSE;
			gboolean _tmp325_ = FALSE;
			gboolean _tmp326_ = FALSE;
			gboolean _tmp328_ = FALSE;
			_tmp269_ = _sym_index;
			_sym_index = _tmp269_ + 1;
			_tmp270_ = _sym_index;
			_tmp271_ = _sym_size;
			if (!(_tmp270_ < _tmp271_)) {
				break;
			}
			_tmp272_ = _sym_list;
			_tmp273_ = _sym_index;
			_tmp274_ = vala_list_get (_tmp272_, _tmp273_);
			sym = (ValaSymbol*) _tmp274_;
			_tmp275_ = sym;
			_tmp276_ = vala_code_node_get_attribute_integer ((ValaCodeNode*) _tmp275_, "CCode", "ordering", -1);
			ordering = _tmp276_;
			_tmp277_ = ordering;
			if (_tmp277_ < (-1)) {
				ValaSymbol* _tmp278_ = NULL;
				ValaSourceReference* _tmp279_ = NULL;
				ValaSourceReference* _tmp280_ = NULL;
				ValaSymbol* _tmp281_ = NULL;
				gchar* _tmp282_ = NULL;
				gchar* _tmp283_ = NULL;
				gchar* _tmp284_ = NULL;
				gchar* _tmp285_ = NULL;
				_tmp278_ = sym;
				_tmp279_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp278_);
				_tmp280_ = _tmp279_;
				_tmp281_ = sym;
				_tmp282_ = vala_symbol_get_full_name (_tmp281_);
				_tmp283_ = _tmp282_;
				_tmp284_ = g_strdup_printf ("%s: Invalid ordering", _tmp283_);
				_tmp285_ = _tmp284_;
				vala_report_error (_tmp280_, _tmp285_);
				_g_free0 (_tmp285_);
				_g_free0 (_tmp283_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				ordered_seen = TRUE;
				unordered_seen = TRUE;
				_vala_code_node_unref0 (sym);
				continue;
			}
			_tmp286_ = ordering;
			ordered = _tmp286_ != (-1);
			_tmp289_ = ordered;
			if (_tmp289_) {
				gboolean _tmp290_ = FALSE;
				_tmp290_ = unordered_seen;
				_tmp288_ = _tmp290_;
			} else {
				_tmp288_ = FALSE;
			}
			_tmp291_ = _tmp288_;
			if (_tmp291_) {
				gboolean _tmp292_ = FALSE;
				_tmp292_ = ordered_seen;
				_tmp287_ = !_tmp292_;
			} else {
				_tmp287_ = FALSE;
			}
			_tmp293_ = _tmp287_;
			if (_tmp293_) {
				ValaSymbol* _tmp294_ = NULL;
				ValaSourceReference* _tmp295_ = NULL;
				ValaSourceReference* _tmp296_ = NULL;
				ValaSymbol* _tmp297_ = NULL;
				gchar* _tmp298_ = NULL;
				gchar* _tmp299_ = NULL;
				gchar* _tmp300_ = NULL;
				gchar* _tmp301_ = NULL;
				_tmp294_ = sym;
				_tmp295_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp294_);
				_tmp296_ = _tmp295_;
				_tmp297_ = sym;
				_tmp298_ = vala_symbol_get_full_name (_tmp297_);
				_tmp299_ = _tmp298_;
				_tmp300_ = g_strdup_printf ("%s: Cannot mix ordered and unordered virtuals", _tmp299_);
				_tmp301_ = _tmp300_;
				vala_report_error (_tmp296_, _tmp301_);
				_g_free0 (_tmp301_);
				_g_free0 (_tmp299_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			_tmp303_ = ordered_seen;
			if (_tmp303_) {
				_tmp302_ = TRUE;
			} else {
				gboolean _tmp304_ = FALSE;
				_tmp304_ = ordered;
				_tmp302_ = _tmp304_;
			}
			_tmp305_ = _tmp302_;
			ordered_seen = _tmp305_;
			_tmp308_ = ordered;
			if (!_tmp308_) {
				gboolean _tmp309_ = FALSE;
				_tmp309_ = unordered_seen;
				_tmp307_ = !_tmp309_;
			} else {
				_tmp307_ = FALSE;
			}
			_tmp310_ = _tmp307_;
			if (_tmp310_) {
				gboolean _tmp311_ = FALSE;
				_tmp311_ = ordered_seen;
				_tmp306_ = _tmp311_;
			} else {
				_tmp306_ = FALSE;
			}
			_tmp312_ = _tmp306_;
			if (_tmp312_) {
				ValaSymbol* _tmp313_ = NULL;
				ValaSourceReference* _tmp314_ = NULL;
				ValaSourceReference* _tmp315_ = NULL;
				ValaSymbol* _tmp316_ = NULL;
				gchar* _tmp317_ = NULL;
				gchar* _tmp318_ = NULL;
				gchar* _tmp319_ = NULL;
				gchar* _tmp320_ = NULL;
				_tmp313_ = sym;
				_tmp314_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp313_);
				_tmp315_ = _tmp314_;
				_tmp316_ = sym;
				_tmp317_ = vala_symbol_get_full_name (_tmp316_);
				_tmp318_ = _tmp317_;
				_tmp319_ = g_strdup_printf ("%s: Cannot mix ordered and unordered virtuals", _tmp318_);
				_tmp320_ = _tmp319_;
				vala_report_error (_tmp315_, _tmp320_);
				_g_free0 (_tmp320_);
				_g_free0 (_tmp318_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			_tmp322_ = unordered_seen;
			if (_tmp322_) {
				_tmp321_ = TRUE;
			} else {
				gboolean _tmp323_ = FALSE;
				_tmp323_ = ordered;
				_tmp321_ = !_tmp323_;
			}
			_tmp324_ = _tmp321_;
			unordered_seen = _tmp324_;
			_tmp326_ = ordered_seen;
			if (!_tmp326_) {
				_tmp325_ = TRUE;
			} else {
				gboolean _tmp327_ = FALSE;
				_tmp327_ = unordered_seen;
				_tmp325_ = !_tmp327_;
			}
			_tmp328_ = _tmp325_;
			if (_tmp328_) {
				gboolean _tmp329_ = FALSE;
				_tmp329_ = ordered;
				if (_tmp329_) {
					ValaSymbol* prev = NULL;
					ValaMap* _tmp330_ = NULL;
					gint _tmp331_ = 0;
					gpointer _tmp332_ = NULL;
					ValaSymbol* _tmp333_ = NULL;
					ValaMap* _tmp345_ = NULL;
					gint _tmp346_ = 0;
					ValaSymbol* _tmp347_ = NULL;
					_tmp330_ = positions;
					_tmp331_ = ordering;
					_tmp332_ = vala_map_get (_tmp330_, (gpointer) ((gintptr) _tmp331_));
					prev = (ValaSymbol*) _tmp332_;
					_tmp333_ = prev;
					if (_tmp333_ != NULL) {
						ValaSymbol* _tmp334_ = NULL;
						ValaSourceReference* _tmp335_ = NULL;
						ValaSourceReference* _tmp336_ = NULL;
						ValaSymbol* _tmp337_ = NULL;
						gchar* _tmp338_ = NULL;
						gchar* _tmp339_ = NULL;
						ValaSymbol* _tmp340_ = NULL;
						const gchar* _tmp341_ = NULL;
						const gchar* _tmp342_ = NULL;
						gchar* _tmp343_ = NULL;
						gchar* _tmp344_ = NULL;
						_tmp334_ = sym;
						_tmp335_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp334_);
						_tmp336_ = _tmp335_;
						_tmp337_ = sym;
						_tmp338_ = vala_symbol_get_full_name (_tmp337_);
						_tmp339_ = _tmp338_;
						_tmp340_ = prev;
						_tmp341_ = vala_symbol_get_name (_tmp340_);
						_tmp342_ = _tmp341_;
						_tmp343_ = g_strdup_printf ("%s: Duplicate ordering (previous virtual with the same position is %s)", _tmp339_, _tmp342_);
						_tmp344_ = _tmp343_;
						vala_report_error (_tmp336_, _tmp344_);
						_g_free0 (_tmp344_);
						_g_free0 (_tmp339_);
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
					_tmp345_ = positions;
					_tmp346_ = ordering;
					_tmp347_ = sym;
					vala_map_set (_tmp345_, (gpointer) ((gintptr) _tmp346_), _tmp347_);
					_vala_code_node_unref0 (prev);
				}
			}
			_vala_code_node_unref0 (sym);
		}
		_vala_iterable_unref0 (_sym_list);
	}
	_tmp348_ = ordered_seen;
	if (_tmp348_) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp349_ = FALSE;
				_tmp349_ = TRUE;
				while (TRUE) {
					gboolean _tmp350_ = FALSE;
					gint _tmp352_ = 0;
					ValaList* _tmp353_ = NULL;
					gint _tmp354_ = 0;
					gint _tmp355_ = 0;
					ValaSymbol* sym = NULL;
					ValaMap* _tmp356_ = NULL;
					gint _tmp357_ = 0;
					gpointer _tmp358_ = NULL;
					ValaSymbol* _tmp359_ = NULL;
					gboolean _tmp367_ = FALSE;
					gboolean _tmp368_ = FALSE;
					_tmp350_ = _tmp349_;
					if (!_tmp350_) {
						gint _tmp351_ = 0;
						_tmp351_ = i;
						i = _tmp351_ + 1;
					}
					_tmp349_ = FALSE;
					_tmp352_ = i;
					_tmp353_ = self->priv->virtuals;
					_tmp354_ = vala_collection_get_size ((ValaCollection*) _tmp353_);
					_tmp355_ = _tmp354_;
					if (!(_tmp352_ < _tmp355_)) {
						break;
					}
					_tmp356_ = positions;
					_tmp357_ = i;
					_tmp358_ = vala_map_get (_tmp356_, (gpointer) ((gintptr) _tmp357_));
					sym = (ValaSymbol*) _tmp358_;
					_tmp359_ = sym;
					if (_tmp359_ == NULL) {
						ValaSourceReference* _tmp360_ = NULL;
						ValaSourceReference* _tmp361_ = NULL;
						gchar* _tmp362_ = NULL;
						gchar* _tmp363_ = NULL;
						gint _tmp364_ = 0;
						gchar* _tmp365_ = NULL;
						gchar* _tmp366_ = NULL;
						_tmp360_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp361_ = _tmp360_;
						_tmp362_ = vala_symbol_get_full_name ((ValaSymbol*) self);
						_tmp363_ = _tmp362_;
						_tmp364_ = i;
						_tmp365_ = g_strdup_printf ("%s: Gap in ordering in position %d", _tmp363_, _tmp364_);
						_tmp366_ = _tmp365_;
						vala_report_error (_tmp361_, _tmp366_);
						_g_free0 (_tmp366_);
						_g_free0 (_tmp363_);
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
					_tmp367_ = vala_code_node_get_error ((ValaCodeNode*) self);
					_tmp368_ = _tmp367_;
					if (!_tmp368_) {
						ValaList* _tmp369_ = NULL;
						gint _tmp370_ = 0;
						ValaSymbol* _tmp371_ = NULL;
						_tmp369_ = self->priv->virtuals;
						_tmp370_ = i;
						_tmp371_ = sym;
						vala_list_set (_tmp369_, _tmp370_, _tmp371_);
					}
					_vala_code_node_unref0 (sym);
				}
			}
		}
	}
	_tmp372_ = context;
	_tmp373_ = vala_code_context_get_analyzer (_tmp372_);
	_tmp374_ = _tmp373_;
	_tmp375_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp374_, _tmp375_);
	_tmp376_ = context;
	_tmp377_ = vala_code_context_get_analyzer (_tmp376_);
	_tmp378_ = _tmp377_;
	_tmp379_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp378_, _tmp379_);
	_tmp380_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp381_ = _tmp380_;
	result = !_tmp381_;
	_vala_map_unref0 (positions);
	_vala_code_node_unref0 (prereq_class);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}


static void vala_interface_class_init (ValaInterfaceClass * klass) {
	vala_interface_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_interface_finalize;
	g_type_class_add_private (klass, sizeof (ValaInterfacePrivate));
	VALA_SYMBOL_CLASS (klass)->add_method = vala_interface_real_add_method;
	VALA_OBJECT_TYPE_SYMBOL_CLASS (klass)->get_methods = vala_interface_real_get_methods;
	VALA_SYMBOL_CLASS (klass)->add_field = vala_interface_real_add_field;
	VALA_SYMBOL_CLASS (klass)->add_constant = vala_interface_real_add_constant;
	VALA_SYMBOL_CLASS (klass)->add_property = vala_interface_real_add_property;
	VALA_OBJECT_TYPE_SYMBOL_CLASS (klass)->get_properties = vala_interface_real_get_properties;
	VALA_SYMBOL_CLASS (klass)->add_signal = vala_interface_real_add_signal;
	VALA_OBJECT_TYPE_SYMBOL_CLASS (klass)->get_signals = vala_interface_real_get_signals;
	VALA_INTERFACE_CLASS (klass)->get_virtuals = vala_interface_real_get_virtuals;
	VALA_SYMBOL_CLASS (klass)->add_class = vala_interface_real_add_class;
	VALA_SYMBOL_CLASS (klass)->add_struct = vala_interface_real_add_struct;
	VALA_SYMBOL_CLASS (klass)->add_enum = vala_interface_real_add_enum;
	VALA_SYMBOL_CLASS (klass)->add_delegate = vala_interface_real_add_delegate;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_interface_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_interface_real_accept_children;
	VALA_TYPESYMBOL_CLASS (klass)->is_reference_type = vala_interface_real_is_reference_type;
	VALA_TYPESYMBOL_CLASS (klass)->is_subtype_of = vala_interface_real_is_subtype_of;
	VALA_CODE_NODE_CLASS (klass)->replace_type = vala_interface_real_replace_type;
	VALA_CODE_NODE_CLASS (klass)->check = vala_interface_real_check;
}


static void vala_interface_instance_init (ValaInterface * self) {
	GEqualFunc _tmp0_ = NULL;
	ValaArrayList* _tmp1_ = NULL;
	GEqualFunc _tmp2_ = NULL;
	ValaArrayList* _tmp3_ = NULL;
	GEqualFunc _tmp4_ = NULL;
	ValaArrayList* _tmp5_ = NULL;
	GEqualFunc _tmp6_ = NULL;
	ValaArrayList* _tmp7_ = NULL;
	GEqualFunc _tmp8_ = NULL;
	ValaArrayList* _tmp9_ = NULL;
	GEqualFunc _tmp10_ = NULL;
	ValaArrayList* _tmp11_ = NULL;
	GEqualFunc _tmp12_ = NULL;
	ValaArrayList* _tmp13_ = NULL;
	GEqualFunc _tmp14_ = NULL;
	ValaArrayList* _tmp15_ = NULL;
	GEqualFunc _tmp16_ = NULL;
	ValaArrayList* _tmp17_ = NULL;
	GEqualFunc _tmp18_ = NULL;
	ValaArrayList* _tmp19_ = NULL;
	GEqualFunc _tmp20_ = NULL;
	ValaArrayList* _tmp21_ = NULL;
	self->priv = VALA_INTERFACE_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, _tmp0_);
	self->priv->prerequisites = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, _tmp2_);
	self->priv->methods = (ValaList*) _tmp3_;
	_tmp4_ = g_direct_equal;
	_tmp5_ = vala_array_list_new (VALA_TYPE_FIELD, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, _tmp4_);
	self->priv->fields = (ValaList*) _tmp5_;
	_tmp6_ = g_direct_equal;
	_tmp7_ = vala_array_list_new (VALA_TYPE_CONSTANT, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, _tmp6_);
	self->priv->constants = (ValaList*) _tmp7_;
	_tmp8_ = g_direct_equal;
	_tmp9_ = vala_array_list_new (VALA_TYPE_PROPERTY, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, _tmp8_);
	self->priv->properties = (ValaList*) _tmp9_;
	_tmp10_ = g_direct_equal;
	_tmp11_ = vala_array_list_new (VALA_TYPE_SIGNAL, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, _tmp10_);
	self->priv->signals = (ValaList*) _tmp11_;
	_tmp12_ = g_direct_equal;
	_tmp13_ = vala_array_list_new (VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, _tmp12_);
	self->priv->virtuals = (ValaList*) _tmp13_;
	_tmp14_ = g_direct_equal;
	_tmp15_ = vala_array_list_new (VALA_TYPE_CLASS, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, _tmp14_);
	self->priv->classes = (ValaList*) _tmp15_;
	_tmp16_ = g_direct_equal;
	_tmp17_ = vala_array_list_new (VALA_TYPE_STRUCT, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, _tmp16_);
	self->priv->structs = (ValaList*) _tmp17_;
	_tmp18_ = g_direct_equal;
	_tmp19_ = vala_array_list_new (VALA_TYPE_ENUM, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, _tmp18_);
	self->priv->enums = (ValaList*) _tmp19_;
	_tmp20_ = g_direct_equal;
	_tmp21_ = vala_array_list_new (VALA_TYPE_DELEGATE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, _tmp20_);
	self->priv->delegates = (ValaList*) _tmp21_;
}


static void vala_interface_finalize (ValaCodeNode* obj) {
	ValaInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_INTERFACE, ValaInterface);
	_vala_iterable_unref0 (self->priv->prerequisites);
	_vala_iterable_unref0 (self->priv->methods);
	_vala_iterable_unref0 (self->priv->fields);
	_vala_iterable_unref0 (self->priv->constants);
	_vala_iterable_unref0 (self->priv->properties);
	_vala_iterable_unref0 (self->priv->signals);
	_vala_iterable_unref0 (self->priv->virtuals);
	_vala_iterable_unref0 (self->priv->classes);
	_vala_iterable_unref0 (self->priv->structs);
	_vala_iterable_unref0 (self->priv->enums);
	_vala_iterable_unref0 (self->priv->delegates);
	VALA_CODE_NODE_CLASS (vala_interface_parent_class)->finalize (obj);
}


/**
 * Represents a class declaration in the source code.
 */
GType vala_interface_get_type (void) {
	static volatile gsize vala_interface_type_id__volatile = 0;
	if (g_once_init_enter (&vala_interface_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaInterface), 0, (GInstanceInitFunc) vala_interface_instance_init, NULL };
		GType vala_interface_type_id;
		vala_interface_type_id = g_type_register_static (VALA_TYPE_OBJECT_TYPE_SYMBOL, "ValaInterface", &g_define_type_info, 0);
		g_once_init_leave (&vala_interface_type_id__volatile, vala_interface_type_id);
	}
	return vala_interface_type_id__volatile;
}



