/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/*
 * This file is part of the libe-book project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#ifndef TDPARSER_H_INCLUDED
#define TDPARSER_H_INCLUDED

#include <vector>

#include "PDXParser.h"


namespace libebook
{

class EBOOKCharsetConverter;

class TDTextParser;

class TDParser : public PDXParser
{
  // disable copying
  TDParser(const TDParser &);
  TDParser &operator=(const TDParser &);

public:
  explicit TDParser(librevenge::RVNGInputStream *input, librevenge::RVNGTextInterface *document = 0);
  virtual ~TDParser();

  static bool checkType(unsigned type, unsigned creator);

private:
  virtual void readAppInfoRecord(librevenge::RVNGInputStream *record);
  virtual void readSortInfoRecord(librevenge::RVNGInputStream *record);
  virtual void readIndexRecord(librevenge::RVNGInputStream *record);
  virtual void readDataRecord(librevenge::RVNGInputStream *record, bool last);

  void createConverter(const std::vector<char> &text);

  void openDocument();
  void closeDocument();

private:
  bool m_compressed;
  unsigned m_textLength;
  unsigned m_recordCount;
  unsigned m_recordSize;
  unsigned m_read;

  bool m_openedDocument;

  EBOOKCharsetConverter *m_converter;
  TDTextParser *m_textParser;
};

}

#endif // TDPARSER_H_INCLUDED

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
