/*
 * Qt wrapper for libindicate
 *
 * Copyright 2009 Canonical Ltd.
 *
 * Authors:
 * - Aurélien Gâteau <aurelien.gateau@canonical.com>
 *
 * License: LGPL v2.1 or LGPL v3
 */
// Self
#include "listenertest.h"

// Qt
#include <QMetaType>
#include <QtTest>

// Local
#include <qindicateindicator.h>
#include <qindicatelistener.h>
#include <qindicateserver.h>

const QString SERVER_TYPE = "message";

QTEST_MAIN(ListenerTest)

void ListenerTest::initTestCase()
{
    qRegisterMetaType<QIndicate::Listener::Server*>("QIndicate::Listener::Server*");
    qRegisterMetaType<QIndicate::Listener::Indicator*>("QIndicate::Listener::Indicator*");
}

void ListenerTest::testServerAddedRemoved()
{
    QIndicate::Listener* listener = QIndicate::Listener::defaultInstance();

    QSignalSpy addedSpy(listener, SIGNAL(serverAdded(QIndicate::Listener::Server*, const QString&)));
    QSignalSpy removedSpy(listener, SIGNAL(serverRemoved(QIndicate::Listener::Server*, const QString&)));

    QIndicate::Server* server = QIndicate::Server::defaultInstance();
    server->setType(SERVER_TYPE);

    QCOMPARE(addedSpy.count(), 0);
    server->show();
    QTest::qWait(500);
    QCOMPARE(addedSpy.count(), 1);
    QCOMPARE(addedSpy.takeFirst()[1].toString(), SERVER_TYPE);

    // Quoting ted:
    // "the server hide doesn't work as there's a bug in dbus-glib that doesn't
    // really remove things off of the bus :("
    #if 0
    server->hide();
    QTest::qWait(500);
    QCOMPARE(removedSpy.count(), 1);
    #endif
}

void ListenerTest::testIndicatorAddedRemoved()
{
    QIndicate::Listener* listener = QIndicate::Listener::defaultInstance();

    QSignalSpy addedSpy(listener, SIGNAL(indicatorAdded(QIndicate::Listener::Server*, QIndicate::Listener::Indicator*)));
    QSignalSpy removedSpy(listener, SIGNAL(indicatorRemoved(QIndicate::Listener::Server*, QIndicate::Listener::Indicator*)));

    QIndicate::Server* server = QIndicate::Server::defaultInstance();
    server->setType(SERVER_TYPE);

    QIndicate::Indicator* indicator = new QIndicate::Indicator(server);
    indicator->show();
    QTest::qWait(500);

    QCOMPARE(addedSpy.count(), 1);

    indicator->hide();
    QTest::qWait(500);
    QCOMPARE(removedSpy.count(), 1);
}

#include "listenertest.moc"
