



<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8" >
  <meta name="viewport" content="width=device-width,minimum-scale=1,initial-scale=1,shrink-to-fit=no" >
  <title>MagickCore, C API: Transform an Image @ ImageMagick</title>
  <meta name="application-name" content="ImageMagick">
  <meta name="description" content="Use ImageMagick® to create, edit, compose, convert bitmap images. With ImageMagick you can resize your image, crop it, change its shades and colors, add captions, among other operations.">
  <meta name="application-url" content="https://imagemagick.org">
  <meta name="generator" content="PHP">
  <meta name="keywords" content="magickcore, c, api:, transform, an, image, ImageMagick, PerlMagick, image processing, image, photo, software, Magick++, OpenMP, convert">
  <meta name="rating" content="GENERAL">
  <meta name="robots" content="INDEX, FOLLOW">
  <meta name="generator" content="ImageMagick Studio LLC">
  <meta name="author" content="ImageMagick Studio LLC">
  <meta name="revisit-after" content="2 DAYS">
  <meta name="resource-type" content="document">
  <meta name="copyright" content="Copyright (c) 1999-2017 ImageMagick Studio LLC">
  <meta name="distribution" content="Global">
  <meta name="magick-serial" content="P131-S030410-R485315270133-P82224-A6668-G1245-1">
  <meta name="google-site-verification" content="_bMOCDpkx9ZAzBwb2kF3PRHbfUUdFj2uO8Jd1AXArz4">
  <link href="https://imagemagick.org/api/transform.php" rel="canonical">
  <link href="../image/wand.png" rel="icon">
  <link href="../image/wand.ico" rel="shortcut icon">
  <link href="../assets/magick-css.php" rel="stylesheet">
</head>
<body>
  <header>
  <nav class="navbar navbar-expand-md navbar-dark bg-dark fixed-top">
    <a class="navbar-brand" href="../index.html"><img class="d-block" id="wand" alt="ImageMagick" width="32" height="32" src="../image/wand.ico"/></a>
    <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarsExampleDefault" aria-controls="navbarsExampleDefault" aria-expanded="false" aria-label="Toggle navigation">
      <span class="navbar-toggler-icon"></span>
    </button>

    <div class="navbar-collapse collapse" id="navbarsExampleDefault" style="">
    <ul class="navbar-nav mr-auto">
      <li class="nav-item ">
        <a class="nav-link" href="../index.php">Home <span class="sr-only">(current)</span></a>
      </li>
      <li class="nav-item ">
        <a class="nav-link" href="../script/download.php">Download</a>
      </li>
      <li class="nav-item ">
        <a class="nav-link" href="../script/command-line-tools.php">Tools</a>
      </li>
      <li class="nav-item ">
        <a class="nav-link" href="../script/command-line-processing.php">Command-line</a>
      </li>
      <li class="nav-item ">
        <a class="nav-link" href="../script/resources.php">Resources</a>
      </li>
      <li class="nav-item ">
        <a class="nav-link" href="../script/develop.php">Develop</a>
      </li>
      <li class="nav-item">
        <a class="nav-link" target="_blank" href="https://imagemagick.org/discourse-server/">Community</a>
      </li>
    </ul>
    <form class="form-inline my-2 my-lg-0" action="../script/search.php">
      <input class="form-control mr-sm-2" type="text" name="q" placeholder="Search" aria-label="Search">
      <button class="btn btn-outline-success my-2 my-sm-0" type="submit" name="sa">Search</button>
    </form>
    </div>
  </nav>
  <div class="container">
   <script async="async" src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>    <ins class="adsbygoogle"
         style="display:block"
         data-ad-client="ca-pub-3129977114552745"
         data-ad-slot="6345125851"
         data-ad-format="auto"></ins>
    <script>
      (adsbygoogle = window.adsbygoogle || []).push({});
    </script>
  </div>
  </header>
  <main class="container">
    <div class="magick-template">
<div class="magick-header">
<p class="text-center"><a href="transform.php#AutoOrientImage">AutoOrientImage</a> &bull; <a href="transform.php#ChopImage">ChopImage</a> &bull; <a href="transform.php#CropImage">CropImage</a> &bull; <a href="transform.php#CropImageToTiles">CropImageToTiles</a> &bull; <a href="transform.php#ExcerptImage">ExcerptImage</a> &bull; <a href="transform.php#ExtentImage">ExtentImage</a> &bull; <a href="transform.php#FlipImage">FlipImage</a> &bull; <a href="transform.php#FlopImage">FlopImage</a> &bull; <a href="transform.php#RollImage">RollImage</a> &bull; <a href="transform.php#ShaveImage">ShaveImage</a> &bull; <a href="transform.php#SpliceImage">SpliceImage</a> &bull; <a href="transform.php#TransformImage">TransformImage</a> &bull; <a href="transform.php#to CropImageToTiles">to CropImageToTiles</a> &bull; <a href="transform.php#TransformImages">TransformImages</a> &bull; <a href="transform.php#TransposeImage">TransposeImage</a> &bull; <a href="transform.php#TransverseImage">TransverseImage</a> &bull; <a href="transform.php#TrimImage">TrimImage</a></p>

<h2><a href="https://imagemagick.org/api/MagickCore/transform_8c.html" id="AutoOrientImage">AutoOrientImage</a></h2>

<p>AutoOrientImage() adjusts an image so that its orientation is suitable for viewing (i.e. top-left orientation).</p>

<p>The format of the AutoOrientImage method is:</p>

<pre class="text">
Image *AutoOrientImage(const Image *image,
  const OrientationType orientation,ExceptionInfo *exception)
</pre>

<p>A description of each parameter follows:</p>

<dd>
</dd>

<dd> </dd>
<dl class="dl-horizontal">
<dt>image</dt>
<dd>The image. </dd>

<dd> </dd>
<dt>orientation</dt>
<dd>Current image orientation. </dd>

<dd> </dd>
<dt>exception</dt>
<dd>Return any errors or warnings in this structure. </dd>

<dd>  </dd>
</dl>
<h2><a href="https://imagemagick.org/api/MagickCore/transform_8c.html" id="ChopImage">ChopImage</a></h2>

<p>ChopImage() removes a region of an image and collapses the image to occupy the removed portion.</p>

<p>The format of the ChopImage method is:</p>

<pre class="text">
Image *ChopImage(const Image *image,const RectangleInfo *chop_info)
  ExceptionInfo *exception)
</pre>

<p>A description of each parameter follows:</p>

<dd>
</dd>

<dd> </dd>
<dl class="dl-horizontal">
<dt>image</dt>
<dd>the image. </dd>

<dd> </dd>
<dt>chop_info</dt>
<dd>Define the region of the image to chop. </dd>

<dd> </dd>
<dt>exception</dt>
<dd>return any errors or warnings in this structure. </dd>

<dd>  </dd>
</dl>
<h2><a href="https://imagemagick.org/api/MagickCore/transform_8c.html" id="CropImage">CropImage</a></h2>

<p>CropImage() extracts a region of the image starting at the offset defined by geometry.  Region must be fully defined, and no special handling of geometry flags is performed.</p>

<p>The format of the CropImage method is:</p>

<pre class="text">
Image *CropImage(const Image *image,const RectangleInfo *geometry,
  ExceptionInfo *exception)
</pre>

<p>A description of each parameter follows:</p>

<dd>
</dd>

<dd> </dd>
<dl class="dl-horizontal">
<dt>image</dt>
<dd>the image. </dd>

<dd> </dd>
<dt>geometry</dt>
<dd>Define the region of the image to crop with members x, y, width, and height. </dd>

<dd> </dd>
<dt>exception</dt>
<dd>return any errors or warnings in this structure. </dd>

<dd>  </dd>
</dl>
<h2><a href="https://imagemagick.org/api/MagickCore/transform_8c.html" id="CropImageToTiles">CropImageToTiles</a></h2>

<p>CropImageToTiles() crops a single image, into a possible list of tiles. This may include a single sub-region of the image.  This basically applies all the normal geometry flags for Crop.</p>

<p>Image *CropImageToTiles(const Image *image, const RectangleInfo *crop_geometry, ExceptionInfo *exception)</p>

<p>A description of each parameter follows:</p>

<dd>
</dd>

<dd> </dd>
<dl class="dl-horizontal">
<dt>image</dt>
<dd>the image The transformed image is returned as this parameter. </dd>

<dd> </dd>
<dt>crop_geometry</dt>
<dd>A crop geometry string. </dd>

<dd> </dd>
<dt>exception</dt>
<dd>return any errors or warnings in this structure. </dd>

<dd>  </dd>
</dl>
<h2><a href="https://imagemagick.org/api/MagickCore/transform_8c.html" id="ExcerptImage">ExcerptImage</a></h2>

<p>ExcerptImage() returns a excerpt of the image as defined by the geometry.</p>

<p>The format of the ExcerptImage method is:</p>

<pre class="text">
Image *ExcerptImage(const Image *image,const RectangleInfo *geometry,
  ExceptionInfo *exception)
</pre>

<p>A description of each parameter follows:</p>

<dd>
</dd>

<dd> </dd>
<dl class="dl-horizontal">
<dt>image</dt>
<dd>the image. </dd>

<dd> </dd>
<dt>geometry</dt>
<dd>Define the region of the image to extend with members x, y, width, and height. </dd>

<dd> </dd>
<dt>exception</dt>
<dd>return any errors or warnings in this structure. </dd>

<dd>  </dd>
</dl>
<h2><a href="https://imagemagick.org/api/MagickCore/transform_8c.html" id="ExtentImage">ExtentImage</a></h2>

<p>ExtentImage() extends the image as defined by the geometry, gravity, and image background color.  Set the (x,y) offset of the geometry to move the original image relative to the extended image.</p>

<p>The format of the ExtentImage method is:</p>

<pre class="text">
Image *ExtentImage(const Image *image,const RectangleInfo *geometry,
  ExceptionInfo *exception)
</pre>

<p>A description of each parameter follows:</p>

<dd>
</dd>

<dd> </dd>
<dl class="dl-horizontal">
<dt>image</dt>
<dd>the image. </dd>

<dd> </dd>
<dt>geometry</dt>
<dd>Define the region of the image to extend with members x, y, width, and height. </dd>

<dd> </dd>
<dt>exception</dt>
<dd>return any errors or warnings in this structure. </dd>

<dd>  </dd>
</dl>
<h2><a href="https://imagemagick.org/api/MagickCore/transform_8c.html" id="FlipImage">FlipImage</a></h2>

<p>FlipImage() creates a vertical mirror image by reflecting the pixels around the central x-axis.</p>

<p>The format of the FlipImage method is:</p>

<pre class="text">
Image *FlipImage(const Image *image,ExceptionInfo *exception)
</pre>

<p>A description of each parameter follows:</p>

<dd>
</dd>

<dd> </dd>
<dl class="dl-horizontal">
<dt>image</dt>
<dd>the image. </dd>

<dd> </dd>
<dt>exception</dt>
<dd>return any errors or warnings in this structure. </dd>

<dd>  </dd>
</dl>
<h2><a href="https://imagemagick.org/api/MagickCore/transform_8c.html" id="FlopImage">FlopImage</a></h2>

<p>FlopImage() creates a horizontal mirror image by reflecting the pixels around the central y-axis.</p>

<p>The format of the FlopImage method is:</p>

<pre class="text">
Image *FlopImage(const Image *image,ExceptionInfo *exception)
</pre>

<p>A description of each parameter follows:</p>

<dd>
</dd>

<dd> </dd>
<dl class="dl-horizontal">
<dt>image</dt>
<dd>the image. </dd>

<dd> </dd>
<dt>exception</dt>
<dd>return any errors or warnings in this structure. </dd>

<dd>  </dd>
</dl>
<h2><a href="https://imagemagick.org/api/MagickCore/transform_8c.html" id="RollImage">RollImage</a></h2>

<p>RollImage() offsets an image as defined by x_offset and y_offset.</p>

<p>The format of the RollImage method is:</p>

<pre class="text">
Image *RollImage(const Image *image,const ssize_t x_offset,
  const ssize_t y_offset,ExceptionInfo *exception)
</pre>

<p>A description of each parameter follows:</p>

<dd>
</dd>

<dd> </dd>
<dl class="dl-horizontal">
<dt>image</dt>
<dd>the image. </dd>

<dd> </dd>
<dt>x_offset</dt>
<dd>the number of columns to roll in the horizontal direction. </dd>

<dd> </dd>
<dt>y_offset</dt>
<dd>the number of rows to roll in the vertical direction. </dd>

<dd> </dd>
<dt>exception</dt>
<dd>return any errors or warnings in this structure. </dd>

<dd>  </dd>
</dl>
<h2><a href="https://imagemagick.org/api/MagickCore/transform_8c.html" id="ShaveImage">ShaveImage</a></h2>

<p>ShaveImage() shaves pixels from the image edges.  It allocates the memory necessary for the new Image structure and returns a pointer to the new image.</p>

<p>The format of the ShaveImage method is:</p>

<pre class="text">
Image *ShaveImage(const Image *image,const RectangleInfo *shave_info,
  ExceptionInfo *exception)
</pre>

<p>A description of each parameter follows:</p>

<dd>
</dd>

<dd> </dd>
<dl class="dl-horizontal">
<dt>shave_image</dt>
<dd>Method ShaveImage returns a pointer to the shaved image.  A null image is returned if there is a memory shortage or if the image width or height is zero. </dd>

<dd> </dd>
<dt>image</dt>
<dd>the image. </dd>

<dd> </dd>
<dt>shave_info</dt>
<dd>Specifies a pointer to a RectangleInfo which defines the region of the image to crop. </dd>

<dd> </dd>
<dt>exception</dt>
<dd>return any errors or warnings in this structure. </dd>

<dd>  </dd>
</dl>
<h2><a href="https://imagemagick.org/api/MagickCore/transform_8c.html" id="SpliceImage">SpliceImage</a></h2>

<p>SpliceImage() splices a solid color into the image as defined by the geometry.</p>

<p>The format of the SpliceImage method is:</p>

<pre class="text">
Image *SpliceImage(const Image *image,const RectangleInfo *geometry,
  ExceptionInfo *exception)
</pre>

<p>A description of each parameter follows:</p>

<dd>
</dd>

<dd> </dd>
<dl class="dl-horizontal">
<dt>image</dt>
<dd>the image. </dd>

<dd> </dd>
<dt>geometry</dt>
<dd>Define the region of the image to splice with members x, y, width, and height. </dd>

<dd> </dd>
<dt>exception</dt>
<dd>return any errors or warnings in this structure. </dd>

<dd>  </dd>
</dl>
<h2><a href="https://imagemagick.org/api/MagickCore/transform_8c.html" id="TransformImage">TransformImage</a></h2>

<p>TransformImage() is a convenience method that behaves like ResizeImage() or CropImage() but accepts scaling and/or cropping information as a region geometry specification.  If the operation fails, the original image handle is left as is.</p>

<p>This should only be used for single images.</p>

<p>The format of the TransformImage method is:</p>

<pre class="text">
MagickBooleanType TransformImage(Image **image,const char *crop_geometry,
  const char *image_geometry)
</pre>

<p>A description of each parameter follows:</p>

<dd>
</dd>

<dd> </dd>
<dl class="dl-horizontal">
<dt>image</dt>
<dd>the image The transformed image is returned as this parameter. </dd>

<dd> </dd>
<dt>crop_geometry</dt>
<dd>A crop geometry string.  This geometry defines a subregion of the image to crop. </dd>

<dd> </dd>
<dt>image_geometry</dt>
<dd>An image geometry string.  This geometry defines the final size of the image. </dd>

<dd>  </dd>
</dl>
<h2><a href="https://imagemagick.org/api/MagickCore/transform_8c.html" id="to_CropImageToTiles">to CropImageToTiles</a></h2>

<p>to CropImageToTiles() or ResizeImage(), as appropriate.</p>

<h2><a href="https://imagemagick.org/api/MagickCore/transform_8c.html" id="TransformImages">TransformImages</a></h2>

<p>TransformImages() calls TransformImage() on each image of a sequence.</p>

<p>The format of the TransformImage method is:</p>

<pre class="text">
MagickBooleanType TransformImages(Image **image,
  const char *crop_geometry,const char *image_geometry)
</pre>

<p>A description of each parameter follows:</p>

<dd>
</dd>

<dd> </dd>
<dl class="dl-horizontal">
<dt>image</dt>
<dd>the image The transformed image is returned as this parameter. </dd>

<dd> </dd>
<dt>crop_geometry</dt>
<dd>A crop geometry string.  This geometry defines a subregion of the image to crop. </dd>

<dd> </dd>
<dt>image_geometry</dt>
<dd>An image geometry string.  This geometry defines the final size of the image. </dd>

<dd>  </dd>
</dl>
<h2><a href="https://imagemagick.org/api/MagickCore/transform_8c.html" id="TransposeImage">TransposeImage</a></h2>

<p>TransposeImage() creates a horizontal mirror image by reflecting the pixels around the central y-axis while rotating them by 90 degrees.</p>

<p>The format of the TransposeImage method is:</p>

<pre class="text">
Image *TransposeImage(const Image *image,ExceptionInfo *exception)
</pre>

<p>A description of each parameter follows:</p>

<dd>
</dd>

<dd> </dd>
<dl class="dl-horizontal">
<dt>image</dt>
<dd>the image. </dd>

<dd> </dd>
<dt>exception</dt>
<dd>return any errors or warnings in this structure. </dd>

<dd>  </dd>
</dl>
<h2><a href="https://imagemagick.org/api/MagickCore/transform_8c.html" id="TransverseImage">TransverseImage</a></h2>

<p>TransverseImage() creates a vertical mirror image by reflecting the pixels around the central x-axis while rotating them by 270 degrees.</p>

<p>The format of the TransverseImage method is:</p>

<pre class="text">
Image *TransverseImage(const Image *image,ExceptionInfo *exception)
</pre>

<p>A description of each parameter follows:</p>

<dd>
</dd>

<dd> </dd>
<dl class="dl-horizontal">
<dt>image</dt>
<dd>the image. </dd>

<dd> </dd>
<dt>exception</dt>
<dd>return any errors or warnings in this structure. </dd>

<dd>  </dd>
</dl>
<h2><a href="https://imagemagick.org/api/MagickCore/transform_8c.html" id="TrimImage">TrimImage</a></h2>

<p>TrimImage() trims pixels from the image edges.  It allocates the memory necessary for the new Image structure and returns a pointer to the new image.</p>

<p>The format of the TrimImage method is:</p>

<pre class="text">
Image *TrimImage(const Image *image,ExceptionInfo *exception)
</pre>

<p>A description of each parameter follows:</p>

<dd>
</dd>

<dd> </dd>
<dl class="dl-horizontal">
<dt>image</dt>
<dd>the image. </dd>

<dd> </dd>
<dt>exception</dt>
<dd>return any errors or warnings in this structure. </dd>

<dd>  </dd>
</dl>
</div>
    </div>
  </main><!-- /.container -->
  <footer class="magick-footer">
    <p><a href="../script/security-policy.php">Security</a> •
    <a href="../script/architecture.php">Architecture</a> •
    <a href="../script/links.php">Related</a> •
     <a href="../script/sitemap.php">Sitemap</a>
    &nbsp; &nbsp;
    <a href="transform.php#"><img class="d-inline" id="wand" alt="And Now a Touch of Magick" width="16" height="16" src="../image/wand.ico"/></a>
    &nbsp; &nbsp;
    <a href="http://pgp.mit.edu/pks/lookup?op=get&amp;search=0x89AB63D48277377A">Public Key</a> •
    <a href="../script/support.php">Donate</a> •
    <a href="../script/contact.php">Contact Us</a>
    <br/>
        <small>© 1999-2019 ImageMagick Studio LLC</small></p>
  </footer>

  <!-- Javascript assets -->
  <script src="../assets/magick-js.php" crossorigin="anonymous"></script>
  <script>window.jQuery || document.write('<script src="../assets/jquery.min.js"><\/script>')</script>
</body>
</html>
