// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{Path, PathPoint};
use glib::translate::*;

glib::wrapper! {
    #[derive(Debug, PartialEq, Eq, PartialOrd, Ord, Hash)]
    pub struct PathMeasure(Shared<ffi::GskPathMeasure>);

    match fn {
        ref => |ptr| ffi::gsk_path_measure_ref(ptr),
        unref => |ptr| ffi::gsk_path_measure_unref(ptr),
        type_ => || ffi::gsk_path_measure_get_type(),
    }
}

impl PathMeasure {
    #[doc(alias = "gsk_path_measure_new")]
    pub fn new(path: &Path) -> PathMeasure {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::gsk_path_measure_new(path.to_glib_none().0)) }
    }

    #[doc(alias = "gsk_path_measure_new_with_tolerance")]
    #[doc(alias = "new_with_tolerance")]
    pub fn with_tolerance(path: &Path, tolerance: f32) -> PathMeasure {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::gsk_path_measure_new_with_tolerance(
                path.to_glib_none().0,
                tolerance,
            ))
        }
    }

    #[doc(alias = "gsk_path_measure_get_length")]
    #[doc(alias = "get_length")]
    pub fn length(&self) -> f32 {
        unsafe { ffi::gsk_path_measure_get_length(self.to_glib_none().0) }
    }

    #[doc(alias = "gsk_path_measure_get_path")]
    #[doc(alias = "get_path")]
    pub fn path(&self) -> Path {
        unsafe { from_glib_none(ffi::gsk_path_measure_get_path(self.to_glib_none().0)) }
    }

    #[doc(alias = "gsk_path_measure_get_point")]
    #[doc(alias = "get_point")]
    pub fn point(&self, distance: f32) -> Option<PathPoint> {
        unsafe {
            let mut result = PathPoint::uninitialized();
            let ret = from_glib(ffi::gsk_path_measure_get_point(
                self.to_glib_none().0,
                distance,
                result.to_glib_none_mut().0,
            ));
            if ret {
                Some(result)
            } else {
                None
            }
        }
    }

    #[doc(alias = "gsk_path_measure_get_tolerance")]
    #[doc(alias = "get_tolerance")]
    pub fn tolerance(&self) -> f32 {
        unsafe { ffi::gsk_path_measure_get_tolerance(self.to_glib_none().0) }
    }
}
