package Pod::Trial::LinkImg;

use warnings;
use strict;

our $VERSION = '0.005';

# ------------------------------------------------------------------------------
# ------------------------------------------------------------------------------
1;

__END__


=head1 NAME

Pod::Trial::LinkImg - Test image display in pod docs.

=head1 VERSION

Version 0.005

=head1 SYNOPSIS

Trial demonstration of image display in pod documentation.

=head1 DESCRIPTION

This module actually does nothing.

=head2 Motivation

=over 4

I<A picture is worth a thousand words.>

=back

or so says some sage. Way back in the dinasaur age of December 1977 Ken Thompson
used graphics when he wrote a manuscript on the I<UNIX Implementation> as found
in B<Bell System Technical Journal, Jul/Aug 1978, Vol. 57, No. 6, Part 2>. (Yes
I have a copy and for the young folks, there was only one phone company back
then.)

My calander has flipped to 2009 and yet I find no graphics
displayed in any documentation as displayed at
L<http://search.cpan.org>.

This is 32 years!!!

I find this a major step backwards - and most especially as we continue to push
the levels of complexity. If a module writer really wants to provide better
documentation with graphics, then there should be some method for it to be
displayed at L<http://search.cpan.org>.

This do-nothing module is to test this out.

=head2 Demonstration

The following snippet would be nice. If you are formatting in html, then you
get an image, and if in text, then a note that there was an image. In pod, I
do not believe that there is an C<if{}else{}> type clause, which would be nice,
ie C<if(html){do this}else{do that}>. Hence the C<text> "block".

    =begin html
    
    <br/ >Idea Figure<br /><IMG SRC="LinkImg/BrightIdea.png" /><br />
    
    =end html
    
    =begin text
    
    =over 4
    
    Image of 'Bright Idea', see C<BrightIdea.png>.
    
    =back
    
    =end text

Below this line is the above code vvvvvv.

=begin html

<br/ >Idea Figure<br /><IMG SRC="LinkImg/BrightIdea.png" /><br />

=end html

=begin text

=over 4

Image of 'Bright Idea', see C<BrightIdea.png>.

=back

=end text

Above this line is the above code ^^^^^^.

As you can see, neither shows up under L<http://search.cpan.org>.

What will show? The following should provide a link which can be clicked
to fetch the image.
L<http://search.cpan.org/src/OTTO/Pod-Trial-LinkImg-0.005/lib/Pod/Trial/LinkImg/BrightIdea.png>

So one could be reading the documentation and right click on a link and bring
up an image say either in another tab or window.

Presently I have found out that embedding images has been prohibited due
to people XSS (cross-site-scripting) and inappropriate image display.

Security is important, so prohibiting random html is good. However others have
addressed this issue.

Inappropriate images, can this not be censored appropriately in some manner.

Presently the censorship is full - disallow all images. Can we not come up with
something more appropriate than that?

Other issues need also to be addressed, such as correct links for the html
that is generated by such groups like ActiveState's ppm mechanism.

First lets try to get good docs with images.

=head1 AUTHOR

Otto Hirr, C<< <otto.hirr at olabinc.com> >>

=head1 BUGS and SUPPORT

Please report any bugs or feature requests to C<bug-pod-trial-linkimg at
rt.cpan.org>, or through the web interface at
L<http://rt.cpan.org/NoAuth/ReportBug.html?Queue=Pod-Trial-LinkImg>. I will be
notified, and then you'll automatically be notified of progress on your bug as I
make changes.

=head1 COPYRIGHT & LICENSE

Copyright 2008 Otto Hirr, all rights reserved.

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=cut
