#!/usr/bin/perl

package eBay::API::XML::DataType::BuyerRoleMetricsType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. BuyerRoleMetricsType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::BuyerRoleMetricsType

=head1 DESCRIPTION

Specifies 1 year feedback metrics as buyer.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::BuyerRoleMetricsType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");



my @gaProperties = ( [ 'FeedbackLeftPercent', 'xs:float', '', '', '' ]
	, [ 'NegativeFeedbackLeftCount', 'xs:int', '', '', '' ]
	, [ 'NeutralFeedbackLeftCount', 'xs:int', '', '', '' ]
	, [ 'PositiveFeedbackLeftCount', 'xs:int', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setFeedbackLeftPercent()

Percentage of leaving feedback as a buyer.

#    Argument: 'xs:float'

=cut

sub setFeedbackLeftPercent {
  my $self = shift;
  $self->{'FeedbackLeftPercent'} = shift
}

=head2 getFeedbackLeftPercent()

  Calls: GetFeedback
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

#    Returns: 'xs:float'

=cut

sub getFeedbackLeftPercent {
  my $self = shift;
  return $self->{'FeedbackLeftPercent'};
}


=head2 setNegativeFeedbackLeftCount()

Count of negative feedback entries given as a buyer.

#    Argument: 'xs:int'

=cut

sub setNegativeFeedbackLeftCount {
  my $self = shift;
  $self->{'NegativeFeedbackLeftCount'} = shift
}

=head2 getNegativeFeedbackLeftCount()

  Calls: GetFeedback
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

#    Returns: 'xs:int'

=cut

sub getNegativeFeedbackLeftCount {
  my $self = shift;
  return $self->{'NegativeFeedbackLeftCount'};
}


=head2 setNeutralFeedbackLeftCount()

Count of neutral feedback entries given as a buyer.

#    Argument: 'xs:int'

=cut

sub setNeutralFeedbackLeftCount {
  my $self = shift;
  $self->{'NeutralFeedbackLeftCount'} = shift
}

=head2 getNeutralFeedbackLeftCount()

  Calls: GetFeedback
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

#    Returns: 'xs:int'

=cut

sub getNeutralFeedbackLeftCount {
  my $self = shift;
  return $self->{'NeutralFeedbackLeftCount'};
}


=head2 setPositiveFeedbackLeftCount()

Count of positive feedback entries given as a buyer.

#    Argument: 'xs:int'

=cut

sub setPositiveFeedbackLeftCount {
  my $self = shift;
  $self->{'PositiveFeedbackLeftCount'} = shift
}

=head2 getPositiveFeedbackLeftCount()

  Calls: GetFeedback
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

#    Returns: 'xs:int'

=cut

sub getPositiveFeedbackLeftCount {
  my $self = shift;
  return $self->{'PositiveFeedbackLeftCount'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
