# Generated by default/object.tt
package Paws::SageMaker::ModelPackageGroupSummary;
  use Moose;
  has CreationTime => (is => 'ro', isa => 'Str', required => 1);
  has ModelPackageGroupArn => (is => 'ro', isa => 'Str', required => 1);
  has ModelPackageGroupDescription => (is => 'ro', isa => 'Str');
  has ModelPackageGroupName => (is => 'ro', isa => 'Str', required => 1);
  has ModelPackageGroupStatus => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::ModelPackageGroupSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::ModelPackageGroupSummary object:

  $service_obj->Method(Att1 => { CreationTime => $value, ..., ModelPackageGroupStatus => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::ModelPackageGroupSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->CreationTime

=head1 DESCRIPTION

Summary information about a model group.

=head1 ATTRIBUTES


=head2 B<REQUIRED> CreationTime => Str

The time that the model group was created.


=head2 B<REQUIRED> ModelPackageGroupArn => Str

The Amazon Resource Name (ARN) of the model group.


=head2 ModelPackageGroupDescription => Str

A description of the model group.


=head2 B<REQUIRED> ModelPackageGroupName => Str

The name of the model group.


=head2 B<REQUIRED> ModelPackageGroupStatus => Str

The status of the model group.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

