/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.event;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.html.DomDocumentFragment;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClasses;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import com.gargoylesoftware.htmlunit.javascript.host.event.EventListenersContainer;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import java.io.IOException;
import java.util.ArrayList;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;

@JsxClasses(value={@JsxClass(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.EDGE}), @JsxClass(isJSObject=false, value={SupportedBrowser.IE})})
public class EventTarget
extends SimpleScriptable {
    private EventListenersContainer eventListenersContainer_;

    @JsxConstructor
    public EventTarget() {
    }

    @JsxFunction
    public void addEventListener(String type, Scriptable listener, boolean useCapture) {
        this.getEventListenersContainer().addEventListener(type, listener, useCapture);
    }

    public final EventListenersContainer getEventListenersContainer() {
        if (this.eventListenersContainer_ == null) {
            this.eventListenersContainer_ = new EventListenersContainer(this);
        }
        return this.eventListenersContainer_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScriptResult executeEventLocally(Event event) {
        EventListenersContainer eventListenersContainer = this.getEventListenersContainer();
        if (eventListenersContainer != null) {
            Object[] args;
            Window window = this.getWindow();
            Object[] propHandlerArgs = args = new Object[]{event};
            Event previousEvent = window.getCurrentEvent();
            window.setCurrentEvent(event);
            try {
                ScriptResult scriptResult = eventListenersContainer.executeListeners(event, args, propHandlerArgs);
                return scriptResult;
            }
            finally {
                window.setCurrentEvent(previousEvent);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScriptResult fireEvent(Event event) {
        Window window = this.getWindow();
        Object[] args = new Object[]{event};
        event.startFire();
        ScriptResult result = null;
        Event previousEvent = window.getCurrentEvent();
        window.setCurrentEvent(event);
        try {
            ScriptResult r;
            EventListenersContainer elc;
            EventTarget jsNode;
            Object node;
            EventListenersContainer windowsListeners = window.getEventListenersContainer();
            event.setEventPhase((short)1);
            boolean windowEventIfDetached = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_EVENT_WINDOW_EXECUTE_IF_DITACHED);
            boolean isAttached = false;
            for (node = this.getDomNodeOrNull(); node != null; node = ((DomNode)node).getParentNode()) {
                if (!(node instanceof Document) && !(node instanceof DomDocumentFragment)) continue;
                isAttached = true;
                break;
            }
            if (isAttached || windowEventIfDetached) {
                result = windowsListeners.executeCapturingListeners(event, args);
                if (event.isPropagationStopped()) {
                    node = result;
                    return node;
                }
            }
            ArrayList<EventTarget> eventTargetList = new ArrayList<EventTarget>();
            EventTarget eventTarget = this;
            while (eventTarget != null) {
                if (isAttached) {
                    eventTargetList.add(eventTarget);
                }
                DomNode domNode = eventTarget.getDomNodeOrNull();
                eventTarget = null;
                if (domNode == null || domNode.getParentNode() == null) continue;
                eventTarget = (EventTarget)domNode.getParentNode().getScriptableObject();
            }
            boolean ie = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_CALL_RESULT_IS_LAST_RETURN_VALUE);
            for (int i = eventTargetList.size() - 1; i >= 0; --i) {
                jsNode = (EventTarget)eventTargetList.get(i);
                elc = jsNode.eventListenersContainer_;
                if (elc == null || !isAttached) continue;
                r = elc.executeCapturingListeners(event, args);
                result = ScriptResult.combine(r, result, ie);
                if (!event.isPropagationStopped()) continue;
                ScriptResult scriptResult = result;
                return scriptResult;
            }
            Object[] propHandlerArgs = args;
            event.setEventPhase((short)2);
            eventTarget = this;
            while (eventTarget != null) {
                jsNode = eventTarget;
                elc = jsNode.eventListenersContainer_;
                if (!(elc == null || jsNode instanceof Window || !isAttached && jsNode instanceof HTMLElement)) {
                    r = elc.executeBubblingListeners(event, args, propHandlerArgs);
                    result = ScriptResult.combine(r, result, ie);
                    if (event.isPropagationStopped()) {
                        ScriptResult scriptResult = result;
                        return scriptResult;
                    }
                }
                DomNode domNode = eventTarget.getDomNodeOrNull();
                eventTarget = null;
                if (domNode != null && domNode.getParentNode() != null) {
                    eventTarget = (EventTarget)domNode.getParentNode().getScriptableObject();
                }
                event.setEventPhase((short)3);
            }
            if (isAttached || windowEventIfDetached) {
                ScriptResult r2 = windowsListeners.executeBubblingListeners(event, args, propHandlerArgs);
                result = ScriptResult.combine(r2, result, ie);
            }
        }
        finally {
            event.endFire();
            window.setCurrentEvent(previousEvent);
        }
        return result;
    }

    public boolean hasEventHandlers(String eventName) {
        if (this.eventListenersContainer_ == null) {
            return false;
        }
        return this.eventListenersContainer_.hasEventListeners(StringUtils.substring(eventName, 2));
    }

    public Function getEventHandler(String eventType) {
        return this.getEventListenersContainer().getEventHandler(eventType);
    }

    @JsxFunction
    public boolean dispatchEvent(Event event) {
        event.setTarget(this);
        DomElement element = (DomElement)this.getDomNodeOrNull();
        ScriptResult result = null;
        if (event.getType().equals("click")) {
            try {
                element.click(event, true);
            }
            catch (IOException e) {
                throw Context.reportRuntimeError("Error calling click(): " + e.getMessage());
            }
        } else {
            result = this.fireEvent(event);
        }
        return !event.isAborted(result);
    }

    @JsxFunction
    public void removeEventListener(String type, Scriptable listener, boolean useCapture) {
        this.getEventListenersContainer().removeEventListener(type, listener, useCapture);
    }

    public void setEventHandler(String eventName, Object value) {
        EventListenersContainer container = this.isEventHandlerOnWindow() ? this.getWindow().getEventListenersContainer() : this.getEventListenersContainer();
        container.setEventHandler(eventName, value);
    }

    protected boolean isEventHandlerOnWindow() {
        return false;
    }

    protected void clearEventListenersContainer() {
        this.eventListenersContainer_ = null;
    }
}

