#!/usr/bin/env perl

use strict;
use warnings;

use 5.10.0;

use Getopt::Long ();

my %opts;

Getopt::Long::GetOptions(\%opts, "header") || die("GetOptions failed!");

my $mod = shift(@ARGV) || 'all';

require EFL;
EFL->import(":$mod");

my @api;

foreach (keys(%::)) {
    push(@api, $_) if defined(&{$_});
}

if ($opts{'header'}) {
print(<<"EOH");
Note: this list is autogenerated from F<misc/supported-api.pl>.

EOH
}

say($_) for (sort(@api));
