######################################################################
#
# 1167_utf8jp_by_utf8.t
#
# Copyright (c) 2018 INABA Hitoshi <ina@cpan.org> in a CPAN
######################################################################

use strict;
use FindBin;
use lib "$FindBin::Bin/../lib";

BEGIN {
    use vars qw(@test);
    @test = (
        ["\x00",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x80"],
        ["\x01",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x81"],
        ["\x02",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x82"],
        ["\x03",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x83"],
        ["\x04",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x84"],
        ["\x05",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x85"],
        ["\x06",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x86"],
        ["\x07",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x87"],
        ["\x08",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x88"],
        ["\x09",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x89"],
        ["\x0A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x8A"],
        ["\x0B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x8B"],
        ["\x0C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x8C"],
        ["\x0D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x8D"],
        ["\x0E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x8E"],
        ["\x0F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x8F"],
        ["\x10",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x90"],
        ["\x11",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x91"],
        ["\x12",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x92"],
        ["\x13",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x93"],
        ["\x14",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x94"],
        ["\x15",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x95"],
        ["\x16",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x96"],
        ["\x17",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x97"],
        ["\x18",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x98"],
        ["\x19",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x99"],
        ["\x1A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x9A"],
        ["\x1B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x9B"],
        ["\x1C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x9C"],
        ["\x1D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x9D"],
        ["\x1E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x9E"],
        ["\x1F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x9F"],
        ["\x20",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xA0"],
        ["\x21",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xA1"],
        ["\x22",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xA2"],
        ["\x23",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xA3"],
        ["\x24",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xA4"],
        ["\x25",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xA5"],
        ["\x26",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xA6"],
        ["\x27",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xA7"],
        ["\x28",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xA8"],
        ["\x29",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xA9"],
        ["\x2A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xAA"],
        ["\x2B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xAB"],
        ["\x2C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xAC"],
        ["\x2D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xAD"],
        ["\x2E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xAE"],
        ["\x2F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xAF"],
        ["\x30",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xB0"],
        ["\x31",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xB1"],
        ["\x32",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xB2"],
        ["\x33",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xB3"],
        ["\x34",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xB4"],
        ["\x35",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xB5"],
        ["\x36",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xB6"],
        ["\x37",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xB7"],
        ["\x38",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xB8"],
        ["\x39",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xB9"],
        ["\x3A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xBA"],
        ["\x3B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xBB"],
        ["\x3C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xBC"],
        ["\x3D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xBD"],
        ["\x3E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xBE"],
        ["\x3F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xBF"],
        ["\x40",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x80"],
        ["\x41",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x81"],
        ["\x42",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x82"],
        ["\x43",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x83"],
        ["\x44",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x84"],
        ["\x45",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x85"],
        ["\x46",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x86"],
        ["\x47",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x87"],
        ["\x48",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x88"],
        ["\x49",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x89"],
        ["\x4A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x8A"],
        ["\x4B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x8B"],
        ["\x4C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x8C"],
        ["\x4D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x8D"],
        ["\x4E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x8E"],
        ["\x4F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x8F"],
        ["\x50",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x90"],
        ["\x51",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x91"],
        ["\x52",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x92"],
        ["\x53",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x93"],
        ["\x54",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x94"],
        ["\x55",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x95"],
        ["\x56",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x96"],
        ["\x57",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x97"],
        ["\x58",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x98"],
        ["\x59",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x99"],
        ["\x5A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x9A"],
        ["\x5B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x9B"],
        ["\x5C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x9C"],
        ["\x5D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x9D"],
        ["\x5E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x9E"],
        ["\x5F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x9F"],
        ["\x60",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xA0"],
        ["\x61",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xA1"],
        ["\x62",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xA2"],
        ["\x63",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xA3"],
        ["\x64",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xA4"],
        ["\x65",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xA5"],
        ["\x66",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xA6"],
        ["\x67",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xA7"],
        ["\x68",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xA8"],
        ["\x69",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xA9"],
        ["\x6A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xAA"],
        ["\x6B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xAB"],
        ["\x6C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xAC"],
        ["\x6D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xAD"],
        ["\x6E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xAE"],
        ["\x6F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xAF"],
        ["\x70",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xB0"],
        ["\x71",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xB1"],
        ["\x72",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xB2"],
        ["\x73",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xB3"],
        ["\x74",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xB4"],
        ["\x75",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xB5"],
        ["\x76",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xB6"],
        ["\x77",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xB7"],
        ["\x78",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xB8"],
        ["\x79",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xB9"],
        ["\x7A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xBA"],
        ["\x7B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xBB"],
        ["\x7C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xBC"],
        ["\x7D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xBD"],
        ["\x7E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xBE"],
        ["\x7F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xBF"],
        ["\xEF\xBD\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x82\xA1"],
        ["\xEF\xBD\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x82\xA2"],
        ["\xEF\xBD\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x82\xA3"],
        ["\xEF\xBD\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x82\xA4"],
        ["\xEF\xBD\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x82\xA5"],
        ["\xEF\xBD\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x82\xA6"],
        ["\xEF\xBD\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x82\xA7"],
        ["\xEF\xBD\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x82\xA8"],
        ["\xEF\xBD\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x82\xA9"],
        ["\xEF\xBD\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x82\xAA"],
        ["\xEF\xBD\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x82\xAB"],
        ["\xEF\xBD\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x82\xAC"],
        ["\xEF\xBD\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x82\xAD"],
        ["\xEF\xBD\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x82\xAE"],
        ["\xEF\xBD\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x82\xAF"],
        ["\xEF\xBD\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x82\xB0"],
        ["\xEF\xBD\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x82\xB1"],
        ["\xEF\xBD\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x82\xB2"],
        ["\xEF\xBD\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x82\xB3"],
        ["\xEF\xBD\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x82\xB4"],
        ["\xEF\xBD\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x82\xB5"],
        ["\xEF\xBD\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x82\xB6"],
        ["\xEF\xBD\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x82\xB7"],
        ["\xEF\xBD\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x82\xB8"],
        ["\xEF\xBD\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x82\xB9"],
        ["\xEF\xBD\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x82\xBA"],
        ["\xEF\xBD\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x82\xBB"],
        ["\xEF\xBD\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x82\xBC"],
        ["\xEF\xBD\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x82\xBD"],
        ["\xEF\xBD\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x82\xBE"],
        ["\xEF\xBD\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x82\xBF"],
        ["\xEF\xBE\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x83\x80"],
        ["\xEF\xBE\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x83\x81"],
        ["\xEF\xBE\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x83\x82"],
        ["\xEF\xBE\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x83\x83"],
        ["\xEF\xBE\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x83\x84"],
        ["\xEF\xBE\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x83\x85"],
        ["\xEF\xBE\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x83\x86"],
        ["\xEF\xBE\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x83\x87"],
        ["\xEF\xBE\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x83\x88"],
        ["\xEF\xBE\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x83\x89"],
        ["\xEF\xBE\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x83\x8A"],
        ["\xEF\xBE\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x83\x8B"],
        ["\xEF\xBE\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x83\x8C"],
        ["\xEF\xBE\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x83\x8D"],
        ["\xEF\xBE\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x83\x8E"],
        ["\xEF\xBE\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x83\x8F"],
        ["\xEF\xBE\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x83\x90"],
        ["\xEF\xBE\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x83\x91"],
        ["\xEF\xBE\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x83\x92"],
        ["\xEF\xBE\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x83\x93"],
        ["\xEF\xBE\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x83\x94"],
        ["\xEF\xBE\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x83\x95"],
        ["\xEF\xBE\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x83\x96"],
        ["\xEF\xBE\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x83\x97"],
        ["\xEF\xBE\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x83\x98"],
        ["\xEF\xBE\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x83\x99"],
        ["\xEF\xBE\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x83\x9A"],
        ["\xEF\xBE\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x83\x9B"],
        ["\xEF\xBE\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x83\x9C"],
        ["\xEF\xBE\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x83\x9D"],
        ["\xEF\xBE\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x83\x9E"],
        ["\xEF\xBE\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x83\x9F"],
        ["\xE3\x80\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x80"],
        ["\xE3\x80\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x81"],
        ["\xE3\x80\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x82"],
        ["\xEF\xBC\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x83"],
        ["\xEF\xBC\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x84"],
        ["\xE3\x83\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x85"],
        ["\xEF\xBC\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x86"],
        ["\xEF\xBC\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x87"],
        ["\xEF\xBC\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x88"],
        ["\xEF\xBC\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x89"],
        ["\xE3\x82\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x8A"],
        ["\xE3\x82\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x8B"],
        ["\xC2\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x8C"],
        ["\xEF\xBD\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x8D"],
        ["\xC2\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x8E"],
        ["\xEF\xBC\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x8F"],
        ["\xEF\xBF\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x90"],
        ["\xEF\xBC\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x91"],
        ["\xE3\x83\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x92"],
        ["\xE3\x83\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x93"],
        ["\xE3\x82\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x94"],
        ["\xE3\x82\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x95"],
        ["\xE3\x80\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x96"],
        ["\xE4\xBB\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x97"],
        ["\xE3\x80\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x98"],
        ["\xE3\x80\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x99"],
        ["\xE3\x80\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x9A"],
        ["\xE3\x83\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x9B"],
        ["\xE2\x80\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x9C"],
        ["\xE2\x80\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x9D"],
        ["\xEF\xBC\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x9E"],
        ["\xEF\xBC\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x9F"],
        ["\xE3\x80\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA0"],
        ["\xE2\x88\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA1"],
        ["\xEF\xBD\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA2"],
        ["\xE2\x80\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA3"],
        ["\xE2\x80\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA4"],
        ["\xE2\x80\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA5"],
        ["\xE2\x80\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA6"],
        ["\xE2\x80\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA7"],
        ["\xE2\x80\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA8"],
        ["\xEF\xBC\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA9"],
        ["\xEF\xBC\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xAA"],
        ["\xE3\x80\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xAB"],
        ["\xE3\x80\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xAC"],
        ["\xEF\xBC\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xAD"],
        ["\xEF\xBC\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xAE"],
        ["\xEF\xBD\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xAF"],
        ["\xEF\xBD\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB0"],
        ["\xE3\x80\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB1"],
        ["\xE3\x80\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB2"],
        ["\xE3\x80\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB3"],
        ["\xE3\x80\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB4"],
        ["\xE3\x80\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB5"],
        ["\xE3\x80\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB6"],
        ["\xE3\x80\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB7"],
        ["\xE3\x80\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB8"],
        ["\xE3\x80\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB9"],
        ["\xE3\x80\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xBA"],
        ["\xEF\xBC\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xBB"],
        ["\xEF\xBC\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xBC"],
        ["\xC2\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xBD"],
        ["\xC3\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xBE"],
        ["\xC3\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xBF"],
        ["\xEF\xBC\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x80"],
        ["\xE2\x89\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x81"],
        ["\xEF\xBC\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x82"],
        ["\xEF\xBC\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x83"],
        ["\xE2\x89\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x84"],
        ["\xE2\x89\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x85"],
        ["\xE2\x88\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x86"],
        ["\xE2\x88\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x87"],
        ["\xE2\x99\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x88"],
        ["\xE2\x99\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x89"],
        ["\xC2\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x8A"],
        ["\xE2\x80\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x8B"],
        ["\xE2\x80\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x8C"],
        ["\xE2\x84\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x8D"],
        ["\xEF\xBF\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x8E"],
        ["\xEF\xBC\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x8F"],
        ["\xEF\xBF\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x90"],
        ["\xEF\xBF\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x91"],
        ["\xEF\xBC\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x92"],
        ["\xEF\xBC\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x93"],
        ["\xEF\xBC\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x94"],
        ["\xEF\xBC\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x95"],
        ["\xEF\xBC\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x96"],
        ["\xC2\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x97"],
        ["\xE2\x98\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x98"],
        ["\xE2\x98\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x99"],
        ["\xE2\x97\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x9A"],
        ["\xE2\x97\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x9B"],
        ["\xE2\x97\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x9C"],
        ["\xE2\x97\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x9D"],
        ["\xE2\x97\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x9E"],
        ["\xE2\x96\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x9F"],
        ["\xE2\x96\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA0"],
        ["\xE2\x96\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA1"],
        ["\xE2\x96\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA2"],
        ["\xE2\x96\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA3"],
        ["\xE2\x96\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA4"],
        ["\xE2\x80\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA5"],
        ["\xE3\x80\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA6"],
        ["\xE2\x86\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA7"],
        ["\xE2\x86\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA8"],
        ["\xE2\x86\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA9"],
        ["\xE2\x86\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xAA"],
        ["\xE3\x80\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xAB"],
        ["\xE2\x88\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xB7"],
        ["\xE2\x88\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xB8"],
        ["\xE2\x8A\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xB9"],
        ["\xE2\x8A\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xBA"],
        ["\xE2\x8A\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xBB"],
        ["\xE2\x8A\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xBC"],
        ["\xE2\x88\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xBD"],
        ["\xE2\x88\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xBE"],
        ["\xE2\x88\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x87"],
        ["\xE2\x88\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x88"],
        ["\xEF\xBF\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x89"],
        ["\xE2\x87\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x8A"],
        ["\xE2\x87\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x8B"],
        ["\xE2\x88\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x8C"],
        ["\xE2\x88\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x8D"],
        ["\xE2\x88\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x99"],
        ["\xE2\x8A\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x9A"],
        ["\xE2\x8C\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x9B"],
        ["\xE2\x88\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x9C"],
        ["\xE2\x88\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x9D"],
        ["\xE2\x89\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x9E"],
        ["\xE2\x89\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x9F"],
        ["\xE2\x89\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA0"],
        ["\xE2\x89\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA1"],
        ["\xE2\x88\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA2"],
        ["\xE2\x88\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA3"],
        ["\xE2\x88\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA4"],
        ["\xE2\x88\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA5"],
        ["\xE2\x88\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA6"],
        ["\xE2\x88\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA7"],
        ["\xE2\x84\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xAF"],
        ["\xE2\x80\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB0"],
        ["\xE2\x99\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB1"],
        ["\xE2\x99\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB2"],
        ["\xE2\x99\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB3"],
        ["\xE2\x80\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB4"],
        ["\xE2\x80\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB5"],
        ["\xC2\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB6"],
        ["\xE2\x97\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xBB"],
        ["\xEF\xBC\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x8B"],
        ["\xEF\xBC\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x8C"],
        ["\xEF\xBC\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x8D"],
        ["\xEF\xBC\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x8E"],
        ["\xEF\xBC\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x8F"],
        ["\xEF\xBC\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x90"],
        ["\xEF\xBC\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x91"],
        ["\xEF\xBC\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x92"],
        ["\xEF\xBC\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x93"],
        ["\xEF\xBC\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x94"],
        ["\xEF\xBC\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x9C"],
        ["\xEF\xBC\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x9D"],
        ["\xEF\xBC\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x9E"],
        ["\xEF\xBC\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x9F"],
        ["\xEF\xBC\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA0"],
        ["\xEF\xBC\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA1"],
        ["\xEF\xBC\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA2"],
        ["\xEF\xBC\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA3"],
        ["\xEF\xBC\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA4"],
        ["\xEF\xBC\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA5"],
        ["\xEF\xBC\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA6"],
        ["\xEF\xBC\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA7"],
        ["\xEF\xBC\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA8"],
        ["\xEF\xBC\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA9"],
        ["\xEF\xBC\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xAA"],
        ["\xEF\xBC\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xAB"],
        ["\xEF\xBC\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xAC"],
        ["\xEF\xBC\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xAD"],
        ["\xEF\xBC\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xAE"],
        ["\xEF\xBC\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xAF"],
        ["\xEF\xBC\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xB0"],
        ["\xEF\xBC\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xB1"],
        ["\xEF\xBC\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xB2"],
        ["\xEF\xBC\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xB3"],
        ["\xEF\xBC\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xB4"],
        ["\xEF\xBC\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xB5"],
        ["\xEF\xBD\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xBC"],
        ["\xEF\xBD\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xBD"],
        ["\xEF\xBD\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xBE"],
        ["\xEF\xBD\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xBF"],
        ["\xEF\xBD\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x80"],
        ["\xEF\xBD\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x81"],
        ["\xEF\xBD\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x82"],
        ["\xEF\xBD\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x83"],
        ["\xEF\xBD\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x84"],
        ["\xEF\xBD\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x85"],
        ["\xEF\xBD\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x86"],
        ["\xEF\xBD\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x87"],
        ["\xEF\xBD\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x88"],
        ["\xEF\xBD\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x89"],
        ["\xEF\xBD\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x8A"],
        ["\xEF\xBD\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x8B"],
        ["\xEF\xBD\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x8C"],
        ["\xEF\xBD\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x8D"],
        ["\xEF\xBD\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x8E"],
        ["\xEF\xBD\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x8F"],
        ["\xEF\xBD\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x90"],
        ["\xEF\xBD\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x91"],
        ["\xEF\xBD\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x92"],
        ["\xEF\xBD\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x93"],
        ["\xEF\xBD\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x94"],
        ["\xEF\xBD\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x95"],
        ["\xE3\x81\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x9A"],
        ["\xE3\x81\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x9B"],
        ["\xE3\x81\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x9C"],
        ["\xE3\x81\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x9D"],
        ["\xE3\x81\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x9E"],
        ["\xE3\x81\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x9F"],
        ["\xE3\x81\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA0"],
        ["\xE3\x81\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA1"],
        ["\xE3\x81\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA2"],
        ["\xE3\x81\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA3"],
        ["\xE3\x81\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA4"],
        ["\xE3\x81\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA5"],
        ["\xE3\x81\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA6"],
        ["\xE3\x81\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA7"],
        ["\xE3\x81\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA8"],
        ["\xE3\x81\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA9"],
        ["\xE3\x81\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xAA"],
        ["\xE3\x81\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xAB"],
        ["\xE3\x81\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xAC"],
        ["\xE3\x81\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xAD"],
        ["\xE3\x81\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xAE"],
        ["\xE3\x81\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xAF"],
        ["\xE3\x81\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB0"],
        ["\xE3\x81\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB1"],
        ["\xE3\x81\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB2"],
        ["\xE3\x81\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB3"],
        ["\xE3\x81\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB4"],
        ["\xE3\x81\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB5"],
        ["\xE3\x81\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB6"],
        ["\xE3\x81\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB7"],
        ["\xE3\x81\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB8"],
        ["\xE3\x81\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB9"],
        ["\xE3\x81\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xBA"],
        ["\xE3\x81\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xBB"],
        ["\xE3\x81\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xBC"],
        ["\xE3\x81\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xBD"],
        ["\xE3\x81\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xBE"],
        ["\xE3\x81\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xBF"],
        ["\xE3\x81\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x80"],
        ["\xE3\x81\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x81"],
        ["\xE3\x81\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x82"],
        ["\xE3\x81\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x83"],
        ["\xE3\x81\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x84"],
        ["\xE3\x81\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x85"],
        ["\xE3\x81\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x86"],
        ["\xE3\x81\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x87"],
        ["\xE3\x81\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x88"],
        ["\xE3\x81\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x89"],
        ["\xE3\x81\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x8A"],
        ["\xE3\x81\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x8B"],
        ["\xE3\x81\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x8C"],
        ["\xE3\x81\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x8D"],
        ["\xE3\x81\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x8E"],
        ["\xE3\x81\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x8F"],
        ["\xE3\x81\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x90"],
        ["\xE3\x81\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x91"],
        ["\xE3\x81\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x92"],
        ["\xE3\x81\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x93"],
        ["\xE3\x81\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x94"],
        ["\xE3\x81\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x95"],
        ["\xE3\x81\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x96"],
        ["\xE3\x81\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x97"],
        ["\xE3\x81\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x98"],
        ["\xE3\x82\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x99"],
        ["\xE3\x82\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x9A"],
        ["\xE3\x82\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x9B"],
        ["\xE3\x82\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x9C"],
        ["\xE3\x82\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x9D"],
        ["\xE3\x82\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x9E"],
        ["\xE3\x82\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x9F"],
        ["\xE3\x82\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA0"],
        ["\xE3\x82\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA1"],
        ["\xE3\x82\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA2"],
        ["\xE3\x82\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA3"],
        ["\xE3\x82\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA4"],
        ["\xE3\x82\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA5"],
        ["\xE3\x82\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA6"],
        ["\xE3\x82\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA7"],
        ["\xE3\x82\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA8"],
        ["\xE3\x82\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA9"],
        ["\xE3\x82\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xAA"],
        ["\xE3\x82\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xAB"],
        ["\xE3\x82\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xAC"],
        ["\xE3\x82\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xB8"],
        ["\xE3\x82\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xB9"],
        ["\xE3\x82\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xBA"],
        ["\xE3\x82\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xBB"],
        ["\xE3\x82\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xBC"],
        ["\xE3\x82\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xBD"],
        ["\xE3\x82\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xBE"],
        ["\xE3\x82\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xBF"],
        ["\xE3\x82\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x80"],
        ["\xE3\x82\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x81"],
        ["\xE3\x82\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x82"],
        ["\xE3\x82\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x83"],
        ["\xE3\x82\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x84"],
        ["\xE3\x82\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x85"],
        ["\xE3\x82\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x86"],
        ["\xE3\x82\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x87"],
        ["\xE3\x82\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x88"],
        ["\xE3\x82\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x89"],
        ["\xE3\x82\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x8A"],
        ["\xE3\x82\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x8B"],
        ["\xE3\x82\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x8C"],
        ["\xE3\x82\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x8D"],
        ["\xE3\x82\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x8E"],
        ["\xE3\x82\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x8F"],
        ["\xE3\x82\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x90"],
        ["\xE3\x82\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x91"],
        ["\xE3\x82\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x92"],
        ["\xE3\x82\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x93"],
        ["\xE3\x82\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x94"],
        ["\xE3\x82\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x95"],
        ["\xE3\x82\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x96"],
        ["\xE3\x83\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x97"],
        ["\xE3\x83\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x98"],
        ["\xE3\x83\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x99"],
        ["\xE3\x83\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x9A"],
        ["\xE3\x83\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x9B"],
        ["\xE3\x83\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x9C"],
        ["\xE3\x83\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x9D"],
        ["\xE3\x83\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x9E"],
        ["\xE3\x83\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x9F"],
        ["\xE3\x83\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA0"],
        ["\xE3\x83\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA1"],
        ["\xE3\x83\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA2"],
        ["\xE3\x83\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA3"],
        ["\xE3\x83\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA4"],
        ["\xE3\x83\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA5"],
        ["\xE3\x83\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA6"],
        ["\xE3\x83\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA7"],
        ["\xE3\x83\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA8"],
        ["\xE3\x83\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA9"],
        ["\xE3\x83\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xAA"],
        ["\xE3\x83\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xAB"],
        ["\xE3\x83\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xAC"],
        ["\xE3\x83\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xAD"],
        ["\xE3\x83\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xAE"],
        ["\xE3\x83\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xAF"],
        ["\xE3\x83\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB0"],
        ["\xE3\x83\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB1"],
        ["\xE3\x83\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB2"],
        ["\xE3\x83\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB3"],
        ["\xE3\x83\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB4"],
        ["\xE3\x83\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB5"],
        ["\xE3\x83\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB6"],
        ["\xE3\x83\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB7"],
        ["\xE3\x83\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB8"],
        ["\xE3\x83\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB9"],
        ["\xE3\x83\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xBA"],
        ["\xE3\x83\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xBB"],
        ["\xE3\x83\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xBC"],
        ["\xE3\x83\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xBD"],
        ["\xE3\x83\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xBE"],
        ["\xE3\x83\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xBF"],
        ["\xE3\x83\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x80"],
        ["\xE3\x83\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x81"],
        ["\xE3\x83\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x82"],
        ["\xE3\x83\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x83"],
        ["\xE3\x83\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x84"],
        ["\xE3\x83\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x85"],
        ["\xE3\x83\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x86"],
        ["\xE3\x83\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x87"],
        ["\xE3\x83\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x88"],
        ["\xE3\x83\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x89"],
        ["\xE3\x83\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x8A"],
        ["\xE3\x83\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x8B"],
        ["\xE3\x83\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x8C"],
        ["\xE3\x83\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x8D"],
        ["\xCE\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x96"],
        ["\xCE\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x97"],
        ["\xCE\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x98"],
        ["\xCE\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x99"],
        ["\xCE\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x9A"],
        ["\xCE\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x9B"],
        ["\xCE\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x9C"],
        ["\xCE\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x9D"],
        ["\xCE\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x9E"],
        ["\xCE\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x9F"],
        ["\xCE\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA0"],
        ["\xCE\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA1"],
        ["\xCE\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA2"],
        ["\xCE\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA3"],
        ["\xCE\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA4"],
        ["\xCE\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA5"],
        ["\xCE\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA6"],
        ["\xCE\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA7"],
        ["\xCE\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA8"],
        ["\xCE\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA9"],
        ["\xCE\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xAA"],
        ["\xCE\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xAB"],
        ["\xCE\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xAC"],
        ["\xCE\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xAD"],
        ["\xCE\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xB6"],
        ["\xCE\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xB7"],
        ["\xCE\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xB8"],
        ["\xCE\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xB9"],
        ["\xCE\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xBA"],
        ["\xCE\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xBB"],
        ["\xCE\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xBC"],
        ["\xCE\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xBD"],
        ["\xCE\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xBE"],
        ["\xCE\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xBF"],
        ["\xCE\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x80"],
        ["\xCE\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x81"],
        ["\xCE\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x82"],
        ["\xCE\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x83"],
        ["\xCE\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x84"],
        ["\xCF\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x85"],
        ["\xCF\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x86"],
        ["\xCF\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x87"],
        ["\xCF\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x88"],
        ["\xCF\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x89"],
        ["\xCF\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x8A"],
        ["\xCF\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x8B"],
        ["\xCF\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x8C"],
        ["\xCF\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x8D"],
        ["\xD0\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xB4"],
        ["\xD0\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xB5"],
        ["\xD0\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xB6"],
        ["\xD0\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xB7"],
        ["\xD0\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xB8"],
        ["\xD0\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xB9"],
        ["\xD0\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xBA"],
        ["\xD0\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xBB"],
        ["\xD0\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xBC"],
        ["\xD0\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xBD"],
        ["\xD0\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xBE"],
        ["\xD0\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xBF"],
        ["\xD0\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x80"],
        ["\xD0\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x81"],
        ["\xD0\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x82"],
        ["\xD0\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x83"],
        ["\xD0\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x84"],
        ["\xD0\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x85"],
        ["\xD0\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x86"],
        ["\xD0\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x87"],
        ["\xD0\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x88"],
        ["\xD0\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x89"],
        ["\xD0\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x8A"],
        ["\xD0\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x8B"],
        ["\xD0\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x8C"],
        ["\xD0\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x8D"],
        ["\xD0\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x8E"],
        ["\xD0\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x8F"],
        ["\xD0\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x90"],
        ["\xD0\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x91"],
        ["\xD0\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x92"],
        ["\xD0\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x93"],
        ["\xD0\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x94"],
        ["\xD0\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xA4"],
        ["\xD0\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xA5"],
        ["\xD0\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xA6"],
        ["\xD0\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xA7"],
        ["\xD0\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xA8"],
        ["\xD0\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xA9"],
        ["\xD1\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xAA"],
        ["\xD0\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xAB"],
        ["\xD0\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xAC"],
        ["\xD0\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xAD"],
        ["\xD0\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xAE"],
        ["\xD0\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xAF"],
        ["\xD0\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB0"],
        ["\xD0\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB1"],
        ["\xD0\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB2"],
        ["\xD0\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB3"],
        ["\xD0\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB4"],
        ["\xD1\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB5"],
        ["\xD1\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB6"],
        ["\xD1\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB7"],
        ["\xD1\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB8"],
        ["\xD1\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB9"],
        ["\xD1\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xBA"],
        ["\xD1\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xBB"],
        ["\xD1\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xBC"],
        ["\xD1\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xBD"],
        ["\xD1\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xBE"],
        ["\xD1\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xBF"],
        ["\xD1\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x80"],
        ["\xD1\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x81"],
        ["\xD1\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x82"],
        ["\xD1\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x83"],
        ["\xD1\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x84"],
        ["\xE2\x94\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x92"],
        ["\xE2\x94\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x93"],
        ["\xE2\x94\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x94"],
        ["\xE2\x94\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x95"],
        ["\xE2\x94\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x96"],
        ["\xE2\x94\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x97"],
        ["\xE2\x94\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x98"],
        ["\xE2\x94\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x99"],
        ["\xE2\x94\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x9A"],
        ["\xE2\x94\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x9B"],
        ["\xE2\x94\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x9C"],
        ["\xE2\x94\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x9D"],
        ["\xE2\x94\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x9E"],
        ["\xE2\x94\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x9F"],
        ["\xE2\x94\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA0"],
        ["\xE2\x94\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA1"],
        ["\xE2\x94\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA2"],
        ["\xE2\x94\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA3"],
        ["\xE2\x94\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA4"],
        ["\xE2\x94\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA5"],
        ["\xE2\x94\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA6"],
        ["\xE2\x95\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA7"],
        ["\xE2\x94\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA8"],
        ["\xE2\x94\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA9"],
        ["\xE2\x94\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xAA"],
        ["\xE2\x94\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xAB"],
        ["\xE2\x94\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xAC"],
        ["\xE2\x94\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xAD"],
        ["\xE2\x94\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xAE"],
        ["\xE2\x94\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xAF"],
        ["\xE2\x94\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xB0"],
        ["\xE2\x95\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xB1"],
        ["\xE2\x91\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xA8"],
        ["\xE2\x91\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xA9"],
        ["\xE2\x91\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xAA"],
        ["\xE2\x91\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xAB"],
        ["\xE2\x91\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xAC"],
        ["\xE2\x91\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xAD"],
        ["\xE2\x91\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xAE"],
        ["\xE2\x91\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xAF"],
        ["\xE2\x91\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB0"],
        ["\xE2\x91\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB1"],
        ["\xE2\x91\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB2"],
        ["\xE2\x91\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB3"],
        ["\xE2\x91\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB4"],
        ["\xE2\x91\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB5"],
        ["\xE2\x91\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB6"],
        ["\xE2\x91\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB7"],
        ["\xE2\x91\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB8"],
        ["\xE2\x91\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB9"],
        ["\xE2\x91\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xBA"],
        ["\xE2\x91\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xBB"],
        ["\xE2\x85\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xBC"],
        ["\xE2\x85\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xBD"],
        ["\xE2\x85\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xBE"],
        ["\xE2\x85\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xBF"],
        ["\xE2\x85\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x80"],
        ["\xE2\x85\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x81"],
        ["\xE2\x85\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x82"],
        ["\xE2\x85\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x83"],
        ["\xE2\x85\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x84"],
        ["\xE2\x85\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x85"],
        ["\xE3\x8D\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x87"],
        ["\xE3\x8C\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x88"],
        ["\xE3\x8C\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x89"],
        ["\xE3\x8D\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x8A"],
        ["\xE3\x8C\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x8B"],
        ["\xE3\x8C\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x8C"],
        ["\xE3\x8C\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x8D"],
        ["\xE3\x8C\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x8E"],
        ["\xE3\x8D\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x8F"],
        ["\xE3\x8D\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x90"],
        ["\xE3\x8C\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x91"],
        ["\xE3\x8C\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x92"],
        ["\xE3\x8C\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x93"],
        ["\xE3\x8C\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x94"],
        ["\xE3\x8D\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x95"],
        ["\xE3\x8C\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x96"],
        ["\xE3\x8E\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x97"],
        ["\xE3\x8E\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x98"],
        ["\xE3\x8E\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x99"],
        ["\xE3\x8E\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x9A"],
        ["\xE3\x8E\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x9B"],
        ["\xE3\x8F\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x9C"],
        ["\xE3\x8E\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x9D"],
        ["\xE3\x8D\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xA6"],
        ["\xE3\x80\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xA7"],
        ["\xE3\x80\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xA8"],
        ["\xE2\x84\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xA9"],
        ["\xE3\x8F\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xAA"],
        ["\xE2\x84\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xAB"],
        ["\xE3\x8A\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xAC"],
        ["\xE3\x8A\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xAD"],
        ["\xE3\x8A\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xAE"],
        ["\xE3\x8A\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xAF"],
        ["\xE3\x8A\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB0"],
        ["\xE3\x88\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB1"],
        ["\xE3\x88\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB2"],
        ["\xE3\x88\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB3"],
        ["\xE3\x8D\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB4"],
        ["\xE3\x8D\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB5"],
        ["\xE3\x8D\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB6"],
        ["\xE2\x88\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xBA"],
        ["\xE2\x88\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xBB"],
        ["\xE2\x88\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xBF"],
        ["\xE2\x8A\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x97\x80"],
        ["\xE4\xBA\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x82"],
        ["\xE5\x94\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x83"],
        ["\xE5\xA8\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x84"],
        ["\xE9\x98\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x85"],
        ["\xE5\x93\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x86"],
        ["\xE6\x84\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x87"],
        ["\xE6\x8C\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x88"],
        ["\xE5\xA7\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x89"],
        ["\xE9\x80\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x8A"],
        ["\xE8\x91\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x8B"],
        ["\xE8\x8C\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x8C"],
        ["\xE7\xA9\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x8D"],
        ["\xE6\x82\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x8E"],
        ["\xE6\x8F\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x8F"],
        ["\xE6\xB8\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x90"],
        ["\xE6\x97\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x91"],
        ["\xE8\x91\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x92"],
        ["\xE8\x8A\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x93"],
        ["\xE9\xAF\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x94"],
        ["\xE6\xA2\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x95"],
        ["\xE5\x9C\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x96"],
        ["\xE6\x96\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x97"],
        ["\xE6\x89\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x98"],
        ["\xE5\xAE\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x99"],
        ["\xE5\xA7\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x9A"],
        ["\xE8\x99\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x9B"],
        ["\xE9\xA3\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x9C"],
        ["\xE7\xB5\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x9D"],
        ["\xE7\xB6\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x9E"],
        ["\xE9\xAE\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x9F"],
        ["\xE6\x88\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA0"],
        ["\xE7\xB2\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA1"],
        ["\xE8\xA2\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA2"],
        ["\xE5\xAE\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA3"],
        ["\xE5\xBA\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA4"],
        ["\xE6\x8C\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA5"],
        ["\xE6\x9A\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA6"],
        ["\xE6\xA1\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA7"],
        ["\xE9\x97\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA8"],
        ["\xE9\x9E\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA9"],
        ["\xE6\x9D\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xAA"],
        ["\xE4\xBB\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xAB"],
        ["\xE4\xBC\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xAC"],
        ["\xE4\xBD\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xAD"],
        ["\xE4\xBE\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xAE"],
        ["\xE5\x81\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xAF"],
        ["\xE5\x9B\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB0"],
        ["\xE5\xA4\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB1"],
        ["\xE5\xA7\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB2"],
        ["\xE5\xA8\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB3"],
        ["\xE5\xB0\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB4"],
        ["\xE6\x83\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB5"],
        ["\xE6\x84\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB6"],
        ["\xE6\x85\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB7"],
        ["\xE6\x98\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB8"],
        ["\xE6\xA4\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB9"],
        ["\xE7\x82\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xBA"],
        ["\xE7\x95\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xBB"],
        ["\xE7\x95\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xBC"],
        ["\xE7\xA7\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xBD"],
        ["\xE7\xB6\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xBE"],
        ["\xE7\xB7\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xBF"],
        ["\xE8\x83\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x80"],
        ["\xE8\x90\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x81"],
        ["\xE8\xA1\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x82"],
        ["\xE8\xAC\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x83"],
        ["\xE9\x81\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x84"],
        ["\xE9\x81\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x85"],
        ["\xE5\x8C\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x86"],
        ["\xE4\xBA\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x87"],
        ["\xE4\xBA\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x88"],
        ["\xE5\x9F\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x89"],
        ["\xE8\x82\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x8A"],
        ["\xE9\x83\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x8B"],
        ["\xE7\xA3\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x8C"],
        ["\xE4\xB8\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x8D"],
        ["\xE5\xA3\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x8E"],
        ["\xE6\xBA\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x8F"],
        ["\xE9\x80\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x90"],
        ["\xE7\xA8\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x91"],
        ["\xE8\x8C\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x92"],
        ["\xE8\x8A\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x93"],
        ["\xE9\xB0\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x94"],
        ["\xE5\x85\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x95"],
        ["\xE5\x8D\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x96"],
        ["\xE5\x92\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x97"],
        ["\xE5\x93\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x98"],
        ["\xE5\x9B\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x99"],
        ["\xE5\xA7\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x9A"],
        ["\xE5\xBC\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x9B"],
        ["\xE9\xA3\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x9C"],
        ["\xE6\xB7\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x9D"],
        ["\xE8\x83\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x9E"],
        ["\xE8\x94\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x9F"],
        ["\xE9\x99\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA0"],
        ["\xE9\x99\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA1"],
        ["\xE9\x9A\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA2"],
        ["\xE9\x9F\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA3"],
        ["\xE5\x90\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA4"],
        ["\xE5\x8F\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA5"],
        ["\xE5\xAE\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA6"],
        ["\xE7\x83\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA7"],
        ["\xE7\xBE\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA8"],
        ["\xE8\xBF\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA9"],
        ["\xE9\x9B\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xAA"],
        ["\xE5\x8D\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xAB"],
        ["\xE9\xB5\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xAC"],
        ["\xE7\xAA\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xAD"],
        ["\xE4\xB8\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xAE"],
        ["\xE7\xA2\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xAF"],
        ["\xE8\x87\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB0"],
        ["\xE6\xB8\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB1"],
        ["\xE5\x98\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB2"],
        ["\xE5\x94\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB3"],
        ["\xE6\xAC\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB4"],
        ["\xE8\x94\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB5"],
        ["\xE9\xB0\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB6"],
        ["\xE5\xA7\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB7"],
        ["\xE5\x8E\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB8"],
        ["\xE6\xB5\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB9"],
        ["\xE7\x93\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xBA"],
        ["\xE9\x96\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xBB"],
        ["\xE5\x99\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xBC"],
        ["\xE4\xBA\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xBD"],
        ["\xE9\x81\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xBE"],
        ["\xE9\x9B\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xBF"],
        ["\xE8\x8D\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x80"],
        ["\xE9\xA4\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x81"],
        ["\xE5\x8F\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x82"],
        ["\xE5\x96\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x83"],
        ["\xE5\xAC\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x84"],
        ["\xE5\xBD\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x85"],
        ["\xE6\x98\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x86"],
        ["\xE6\x9B\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x87"],
        ["\xE6\xA0\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x88"],
        ["\xE6\xB0\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x89"],
        ["\xE6\xB3\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x8A"],
        ["\xE6\xB4\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x8B"],
        ["\xE7\x91\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x8C"],
        ["\xE7\x9B\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x8D"],
        ["\xE7\xA9\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x8E"],
        ["\xE9\xA0\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x8F"],
        ["\xE8\x8B\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x90"],
        ["\xE8\xA1\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x91"],
        ["\xE8\xA9\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x92"],
        ["\xE9\x8B\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x93"],
        ["\xE6\xB6\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x94"],
        ["\xE7\x96\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x95"],
        ["\xE7\x9B\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x96"],
        ["\xE9\xA7\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x97"],
        ["\xE6\x82\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x98"],
        ["\xE8\xAC\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x99"],
        ["\xE8\xB6\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x9A"],
        ["\xE9\x96\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x9B"],
        ["\xE6\xA6\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x9C"],
        ["\xE5\x8E\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x9D"],
        ["\xE5\x86\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x9E"],
        ["\xE5\x9C\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x9F"],
        ["\xE5\xA0\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA0"],
        ["\xE5\xA5\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA1"],
        ["\xE5\xAE\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA2"],
        ["\xE5\xBB\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA3"],
        ["\xE6\x80\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA4"],
        ["\xE6\x8E\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA5"],
        ["\xE6\x8F\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA6"],
        ["\xE6\xB2\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA7"],
        ["\xE6\xBC\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA8"],
        ["\xE7\x82\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA9"],
        ["\xE7\x84\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xAA"],
        ["\xE7\x85\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xAB"],
        ["\xE7\x87\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xAC"],
        ["\xE7\x8C\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xAD"],
        ["\xE7\xB8\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xAE"],
        ["\xE8\x89\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xAF"],
        ["\xE8\x8B\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB0"],
        ["\xE8\x96\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB1"],
        ["\xE9\x81\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB2"],
        ["\xE9\x89\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB3"],
        ["\xE9\xB4\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB4"],
        ["\xE5\xA1\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB5"],
        ["\xE6\x96\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB6"],
        ["\xE6\xB1\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB7"],
        ["\xE7\x94\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB8"],
        ["\xE5\x87\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB9"],
        ["\xE5\xA4\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xBA"],
        ["\xE5\xA5\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xBB"],
        ["\xE5\xBE\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xBC"],
        ["\xE5\xBF\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xBD"],
        ["\xE6\x8A\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xBE"],
        ["\xE6\x97\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xBF"],
        ["\xE6\xA8\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x80"],
        ["\xE6\xAC\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x81"],
        ["\xE6\xAE\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x82"],
        ["\xE7\x8E\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x83"],
        ["\xE7\xBF\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x84"],
        ["\xE8\xA5\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x85"],
        ["\xE9\xB4\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x86"],
        ["\xE9\xB4\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x87"],
        ["\xE9\xBB\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x88"],
        ["\xE5\xB2\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x89"],
        ["\xE6\xB2\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x8A"],
        ["\xE8\x8D\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x8B"],
        ["\xE5\x84\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x8C"],
        ["\xE5\xB1\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x8D"],
        ["\xE6\x86\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x8E"],
        ["\xE8\x87\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x8F"],
        ["\xE6\xA1\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x90"],
        ["\xE7\x89\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x91"],
        ["\xE4\xB9\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x92"],
        ["\xE4\xBF\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x93"],
        ["\xE5\x8D\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x94"],
        ["\xE6\x81\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x95"],
        ["\xE6\xB8\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x96"],
        ["\xE7\xA9\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x97"],
        ["\xE9\x9F\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x98"],
        ["\xE4\xB8\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x99"],
        ["\xE5\x8C\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x9A"],
        ["\xE4\xBB\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x9B"],
        ["\xE4\xBD\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x9C"],
        ["\xE4\xBC\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x9D"],
        ["\xE4\xBE\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x9E"],
        ["\xE4\xBD\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x9F"],
        ["\xE5\x8A\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA0"],
        ["\xE5\x8F\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA1"],
        ["\xE5\x98\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA2"],
        ["\xE5\xA4\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA3"],
        ["\xE5\xAB\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA4"],
        ["\xE5\xAE\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA5"],
        ["\xE5\xAF\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA6"],
        ["\xE7\xA7\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA7"],
        ["\xE6\x9A\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA8"],
        ["\xE6\x9E\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA9"],
        ["\xE6\x9E\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xAA"],
        ["\xE6\xAD\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xAB"],
        ["\xE6\xB2\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xAC"],
        ["\xE7\x81\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xAD"],
        ["\xE7\x8F\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xAE"],
        ["\xE7\xA6\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xAF"],
        ["\xE7\xA6\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB0"],
        ["\xE7\xA8\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB1"],
        ["\xE7\xAE\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB2"],
        ["\xE8\x8A\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB3"],
        ["\xE8\x8B\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB4"],
        ["\xE8\x8C\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB5"],
        ["\xE8\x8D\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB6"],
        ["\xE8\x8F\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB7"],
        ["\xE8\x8F\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB8"],
        ["\xE8\x9D\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB9"],
        ["\xE8\xAA\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xBA"],
        ["\xE5\x98\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xBB"],
        ["\xE8\xB2\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xBC"],
        ["\xE8\xBF\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xBD"],
        ["\xE9\x81\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xBE"],
        ["\xE9\x9C\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xBF"],
        ["\xE8\x9A\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x80"],
        ["\xE4\xBF\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x81"],
        ["\xE5\xB3\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x82"],
        ["\xE6\x88\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x83"],
        ["\xE7\x89\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x84"],
        ["\xE7\x94\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x85"],
        ["\xE8\x87\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x86"],
        ["\xE8\x8A\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x87"],
        ["\xE8\x9B\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x88"],
        ["\xE8\xB3\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x89"],
        ["\xE9\x9B\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x8A"],
        ["\xE9\xA4\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x8B"],
        ["\xE9\xA7\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x8C"],
        ["\xE4\xBB\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x8D"],
        ["\xE4\xBC\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x8E"],
        ["\xE8\xA7\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x8F"],
        ["\xE5\x9B\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x90"],
        ["\xE5\xA1\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x91"],
        ["\xE5\xA3\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x92"],
        ["\xE5\xBB\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x93"],
        ["\xE5\xBF\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x94"],
        ["\xE6\x80\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x95"],
        ["\xE6\x82\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x96"],
        ["\xE6\x81\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x97"],
        ["\xE6\x87\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x98"],
        ["\xE6\x88\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x99"],
        ["\xE6\x8B\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x9A"],
        ["\xE6\x94\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x9B"],
        ["\xE9\xAD\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x9C"],
        ["\xE6\x99\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x9D"],
        ["\xE6\xA2\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x9E"],
        ["\xE6\xB5\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x9F"],
        ["\xE7\x81\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA0"],
        ["\xE7\x95\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA1"],
        ["\xE7\x9A\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA2"],
        ["\xE7\xB5\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA3"],
        ["\xE8\x8A\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA4"],
        ["\xE8\x9F\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA5"],
        ["\xE9\x96\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA6"],
        ["\xE9\x9A\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA7"],
        ["\xE8\xB2\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA8"],
        ["\xE5\x87\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA9"],
        ["\xE5\x8A\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xAA"],
        ["\xE5\xA4\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xAB"],
        ["\xE5\x92\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xAC"],
        ["\xE5\xAE\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xAD"],
        ["\xE5\xB4\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xAE"],
        ["\xE6\x85\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xAF"],
        ["\xE6\xA6\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB0"],
        ["\xE6\xB6\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB1"],
        ["\xE7\xA2\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB2"],
        ["\xE8\x93\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB3"],
        ["\xE8\xA1\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB4"],
        ["\xE8\xA9\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB5"],
        ["\xE9\x8E\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB6"],
        ["\xE9\xAA\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB7"],
        ["\xE6\xB5\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB8"],
        ["\xE9\xA6\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB9"],
        ["\xE8\x9B\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xBA"],
        ["\xE5\x9E\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xBB"],
        ["\xE6\x9F\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xBC"],
        ["\xE8\x9B\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xBD"],
        ["\xE9\x88\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xBE"],
        ["\xE5\x8A\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xBF"],
        ["\xE5\x9A\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x80"],
        ["\xE5\x90\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x81"],
        ["\xE5\xBB\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x82"],
        ["\xE6\x8B\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x83"],
        ["\xE6\x92\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x84"],
        ["\xE6\xA0\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x85"],
        ["\xE6\xA0\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x86"],
        ["\xE6\xAE\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x87"],
        ["\xE7\x8D\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x88"],
        ["\xE7\xA2\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x89"],
        ["\xE7\xA9\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x8A"],
        ["\xE8\xA6\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x8B"],
        ["\xE8\xA7\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x8C"],
        ["\xE8\xB5\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x8D"],
        ["\xE8\xBC\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x8E"],
        ["\xE9\x83\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x8F"],
        ["\xE9\x96\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x90"],
        ["\xE9\x9A\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x91"],
        ["\xE9\x9D\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x92"],
        ["\xE5\xAD\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x93"],
        ["\xE5\xB2\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x94"],
        ["\xE6\xA5\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x95"],
        ["\xE9\xA1\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x96"],
        ["\xE9\xA1\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x97"],
        ["\xE6\x8E\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x98"],
        ["\xE7\xAC\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x99"],
        ["\xE6\xA8\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x9A"],
        ["\xE6\xA9\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x9B"],
        ["\xE6\xA2\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x9C"],
        ["\xE9\xB0\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x9D"],
        ["\xE6\xBD\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x9E"],
        ["\xE5\x89\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x9F"],
        ["\xE5\x96\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA0"],
        ["\xE6\x81\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA1"],
        ["\xE6\x8B\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA2"],
        ["\xE6\xB4\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA3"],
        ["\xE6\xB8\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA4"],
        ["\xE6\xBB\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA5"],
        ["\xE8\x91\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA6"],
        ["\xE8\xA4\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA7"],
        ["\xE8\xBD\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA8"],
        ["\xE4\xB8\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA9"],
        ["\xE9\xB0\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xAA"],
        ["\xE5\x8F\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xAB"],
        ["\xE6\xA4\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xAC"],
        ["\xE6\xA8\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xAD"],
        ["\xE9\x9E\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xAE"],
        ["\xE6\xA0\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xAF"],
        ["\xE5\x85\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB0"],
        ["\xE7\xAB\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB1"],
        ["\xE8\x92\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB2"],
        ["\xE9\x87\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB3"],
        ["\xE9\x8E\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB4"],
        ["\xE5\x99\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB5"],
        ["\xE9\xB4\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB6"],
        ["\xE6\xA0\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB7"],
        ["\xE8\x8C\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB8"],
        ["\xE8\x90\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB9"],
        ["\xE7\xB2\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xBA"],
        ["\xE5\x88\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xBB"],
        ["\xE8\x8B\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xBC"],
        ["\xE7\x93\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xBD"],
        ["\xE4\xB9\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xBE"],
        ["\xE4\xBE\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xBF"],
        ["\xE5\x86\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x80"],
        ["\xE5\xAF\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x81"],
        ["\xE5\x88\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x82"],
        ["\xE5\x8B\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x83"],
        ["\xE5\x8B\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x84"],
        ["\xE5\xB7\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x85"],
        ["\xE5\x96\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x86"],
        ["\xE5\xA0\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x87"],
        ["\xE5\xA7\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x88"],
        ["\xE5\xAE\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x89"],
        ["\xE5\xAE\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x8A"],
        ["\xE5\xAF\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x8B"],
        ["\xE5\xB9\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x8C"],
        ["\xE5\xB9\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x8D"],
        ["\xE6\x82\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x8E"],
        ["\xE6\x84\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x8F"],
        ["\xE6\x85\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x90"],
        ["\xE6\x86\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x91"],
        ["\xE6\x8F\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x92"],
        ["\xE6\x95\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x93"],
        ["\xE6\x9F\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x94"],
        ["\xE6\xA1\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x95"],
        ["\xE6\xA3\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x96"],
        ["\xE6\xAC\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x97"],
        ["\xE6\xAD\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x98"],
        ["\xE6\xB1\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x99"],
        ["\xE6\xBC\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x9A"],
        ["\xE6\xBE\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x9B"],
        ["\xE6\xBD\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x9C"],
        ["\xE7\x92\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x9D"],
        ["\xE7\x94\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x9E"],
        ["\xE7\x9B\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x9F"],
        ["\xE7\x9C\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA0"],
        ["\xE7\xAB\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA1"],
        ["\xE7\xAE\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA2"],
        ["\xE7\xB0\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA3"],
        ["\xE7\xB7\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA4"],
        ["\xE7\xBC\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA5"],
        ["\xE7\xBF\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA6"],
        ["\xE8\x82\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA7"],
        ["\xE8\x89\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA8"],
        ["\xE8\x8E\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA9"],
        ["\xE8\xA6\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xAA"],
        ["\xE8\xAB\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xAB"],
        ["\xE8\xB2\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xAC"],
        ["\xE9\x82\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xAD"],
        ["\xE9\x91\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xAE"],
        ["\xE9\x96\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xAF"],
        ["\xE9\x96\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB0"],
        ["\xE9\x96\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB1"],
        ["\xE9\x99\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB2"],
        ["\xE9\x9F\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB3"],
        ["\xE9\xA4\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB4"],
        ["\xE8\x88\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB5"],
        ["\xE4\xB8\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB6"],
        ["\xE5\x90\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB7"],
        ["\xE5\xB2\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB8"],
        ["\xE5\xB7\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB9"],
        ["\xE7\x8E\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xBA"],
        ["\xE7\x99\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xBB"],
        ["\xE7\x9C\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xBC"],
        ["\xE5\xB2\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xBD"],
        ["\xE7\xBF\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xBE"],
        ["\xE8\xB4\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xBF"],
        ["\xE9\x9B\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x80"],
        ["\xE9\xA0\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x81"],
        ["\xE9\xA1\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x82"],
        ["\xE9\xA1\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x83"],
        ["\xE4\xBC\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x84"],
        ["\xE4\xBC\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x85"],
        ["\xE5\x8D\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x86"],
        ["\xE5\x96\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x87"],
        ["\xE5\x99\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x88"],
        ["\xE5\x9F\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x89"],
        ["\xE5\xA5\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x8A"],
        ["\xE5\xAC\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x8B"],
        ["\xE5\xAF\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x8C"],
        ["\xE5\xB2\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x8D"],
        ["\xE5\xB8\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x8E"],
        ["\xE5\xB9\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x8F"],
        ["\xE5\xBF\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x90"],
        ["\xE6\x8F\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x91"],
        ["\xE6\x9C\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x92"],
        ["\xE6\x97\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x93"],
        ["\xE6\x97\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x94"],
        ["\xE6\x9C\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x95"],
        ["\xE6\xA3\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x96"],
        ["\xE6\xA3\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x97"],
        ["\xE6\xA9\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x98"],
        ["\xE5\xB8\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x99"],
        ["\xE6\xAF\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x9A"],
        ["\xE6\xB0\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x9B"],
        ["\xE6\xB1\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x9C"],
        ["\xE7\x95\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x9D"],
        ["\xE7\xA5\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x9E"],
        ["\xE5\xAD\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x9F"],
        ["\xE7\xA8\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA0"],
        ["\xE7\xB4\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA1"],
        ["\xE5\xBE\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA2"],
        ["\xE8\xA6\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA3"],
        ["\xE8\xA8\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA4"],
        ["\xE8\xB2\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA5"],
        ["\xE8\xB5\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA6"],
        ["\xE8\xBB\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA7"],
        ["\xE8\xBC\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA8"],
        ["\xE9\xA3\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA9"],
        ["\xE9\xA8\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xAA"],
        ["\xE9\xAC\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xAB"],
        ["\xE4\xBA\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xAC"],
        ["\xE5\x81\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xAD"],
        ["\xE5\x84\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xAE"],
        ["\xE5\xA6\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xAF"],
        ["\xE5\xAE\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB0"],
        ["\xE6\x88\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB1"],
        ["\xE6\x8A\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB2"],
        ["\xE6\x93\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB3"],
        ["\xE6\xAC\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB4"],
        ["\xE7\x8A\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB5"],
        ["\xE7\x96\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB6"],
        ["\xE7\xA5\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB7"],
        ["\xE7\xBE\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB8"],
        ["\xE8\x9F\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB9"],
        ["\xE8\xAA\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xBA"],
        ["\xE8\xAD\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xBB"],
        ["\xE6\x8E\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xBC"],
        ["\xE8\x8F\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xBD"],
        ["\xE9\x9E\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xBE"],
        ["\xE5\x90\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xBF"],
        ["\xE5\x90\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x80"],
        ["\xE5\x96\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x81"],
        ["\xE6\xA1\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x82"],
        ["\xE6\xA9\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x83"],
        ["\xE8\xA9\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x84"],
        ["\xE7\xA0\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x85"],
        ["\xE6\x9D\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x86"],
        ["\xE9\xBB\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x87"],
        ["\xE5\x8D\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x88"],
        ["\xE5\xAE\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x89"],
        ["\xE8\x84\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x8A"],
        ["\xE8\x99\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x8B"],
        ["\xE9\x80\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x8C"],
        ["\xE4\xB8\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x8D"],
        ["\xE4\xB9\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x8E"],
        ["\xE4\xBB\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x8F"],
        ["\xE4\xBC\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x90"],
        ["\xE5\x8F\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x91"],
        ["\xE5\x90\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x92"],
        ["\xE5\xAE\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x93"],
        ["\xE5\xBC\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x94"],
        ["\xE6\x80\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x95"],
        ["\xE6\x95\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x96"],
        ["\xE6\x9C\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x97"],
        ["\xE6\xB1\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x98"],
        ["\xE6\xB1\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x99"],
        ["\xE6\xB3\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x9A"],
        ["\xE7\x81\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x9B"],
        ["\xE7\x90\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x9C"],
        ["\xE7\xA9\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x9D"],
        ["\xE7\xAA\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x9E"],
        ["\xE7\xAC\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x9F"],
        ["\xE7\xB4\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA0"],
        ["\xE7\xB3\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA1"],
        ["\xE7\xB5\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA2"],
        ["\xE6\x97\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA3"],
        ["\xE7\x89\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA4"],
        ["\xE5\x8E\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA5"],
        ["\xE5\xB1\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA6"],
        ["\xE5\xB7\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA7"],
        ["\xE6\x8B\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA8"],
        ["\xE6\x8B\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA9"],
        ["\xE6\x8C\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xAA"],
        ["\xE6\xB8\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xAB"],
        ["\xE8\x99\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xAC"],
        ["\xE8\xA8\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xAD"],
        ["\xE8\xB7\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xAE"],
        ["\xE9\x8B\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xAF"],
        ["\xE6\xBC\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB0"],
        ["\xE7\xA6\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB1"],
        ["\xE9\xAD\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB2"],
        ["\xE4\xBA\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB3"],
        ["\xE4\xBA\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB4"],
        ["\xE4\xBA\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB5"],
        ["\xE4\xBE\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB6"],
        ["\xE4\xBE\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB7"],
        ["\xE5\x83\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB8"],
        ["\xE5\x85\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB9"],
        ["\xE7\xAB\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xBA"],
        ["\xE5\x85\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xBB"],
        ["\xE5\x87\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xBC"],
        ["\xE5\x8D\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xBD"],
        ["\xE5\x8C\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xBE"],
        ["\xE5\x8D\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xBF"],
        ["\xE5\x8F\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x80"],
        ["\xE5\x96\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x81"],
        ["\xE5\xA2\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x82"],
        ["\xE5\xB3\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x83"],
        ["\xE5\xBC\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x84"],
        ["\xE5\xBD\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x85"],
        ["\xE6\x80\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x86"],
        ["\xE6\x81\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x87"],
        ["\xE6\x81\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x88"],
        ["\xE6\x8C\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x89"],
        ["\xE6\x95\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x8A"],
        ["\xE6\xA9\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x8B"],
        ["\xE6\xB3\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x8C"],
        ["\xE7\x8B\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x8D"],
        ["\xE7\x8B\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x8E"],
        ["\xE7\x9F\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x8F"],
        ["\xE8\x83\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x90"],
        ["\xE8\x84\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x91"],
        ["\xE8\x88\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x92"],
        ["\xE8\x95\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x93"],
        ["\xE9\x83\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x94"],
        ["\xE9\x8F\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x95"],
        ["\xE9\x9F\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x96"],
        ["\xE9\xA5\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x97"],
        ["\xE9\xA9\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x98"],
        ["\xE4\xBB\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x99"],
        ["\xE5\x87\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x9A"],
        ["\xE5\xB0\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x9B"],
        ["\xE6\x9A\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x9C"],
        ["\xE6\xA5\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x9D"],
        ["\xE5\xB1\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x9E"],
        ["\xE6\x9B\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x9F"],
        ["\xE6\xA5\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA0"],
        ["\xE7\x8E\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA1"],
        ["\xE6\xA1\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA2"],
        ["\xE7\xB2\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA3"],
        ["\xE5\x83\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA4"],
        ["\xE5\x8B\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA5"],
        ["\xE5\x9D\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA6"],
        ["\xE5\xB7\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA7"],
        ["\xE9\x8C\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA8"],
        ["\xE6\x96\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA9"],
        ["\xE6\xAC\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xAA"],
        ["\xE6\xAC\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xAB"],
        ["\xE7\x90\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xAC"],
        ["\xE7\xA6\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xAD"],
        ["\xE7\xA6\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xAE"],
        ["\xE7\xAD\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xAF"],
        ["\xE7\xB7\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB0"],
        ["\xE8\x8A\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB1"],
        ["\xE8\x8F\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB2"],
        ["\xE8\xA1\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB3"],
        ["\xE8\xA5\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB4"],
        ["\xE8\xAC\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB5"],
        ["\xE8\xBF\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB6"],
        ["\xE9\x87\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB7"],
        ["\xE5\x90\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB8"],
        ["\xE9\x8A\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB9"],
        ["\xE4\xB9\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xBA"],
        ["\xE5\x80\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xBB"],
        ["\xE5\x8F\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xBC"],
        ["\xE5\x8C\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xBD"],
        ["\xE7\x8B\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xBE"],
        ["\xE7\x8E\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xBF"],
        ["\xE7\x9F\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x80"],
        ["\xE8\x8B\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x81"],
        ["\xE8\xBA\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x82"],
        ["\xE9\xA7\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x83"],
        ["\xE9\xA7\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x84"],
        ["\xE9\xA7\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x85"],
        ["\xE5\x85\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x86"],
        ["\xE6\x84\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x87"],
        ["\xE8\x99\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x88"],
        ["\xE5\x96\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x89"],
        ["\xE7\xA9\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x8A"],
        ["\xE5\x81\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x8B"],
        ["\xE5\xAF\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x8C"],
        ["\xE9\x81\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x8D"],
        ["\xE9\x9A\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x8E"],
        ["\xE4\xB8\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x8F"],
        ["\xE6\xAB\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x90"],
        ["\xE9\x87\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x91"],
        ["\xE5\xB1\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x92"],
        ["\xE5\xB1\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x93"],
        ["\xE6\x8E\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x94"],
        ["\xE7\xAA\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x95"],
        ["\xE6\xB2\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x96"],
        ["\xE9\x9D\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x97"],
        ["\xE8\xBD\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x98"],
        ["\xE7\xAA\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x99"],
        ["\xE7\x86\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x9A"],
        ["\xE9\x9A\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x9B"],
        ["\xE7\xB2\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x9C"],
        ["\xE6\xA0\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x9D"],
        ["\xE7\xB9\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x9E"],
        ["\xE6\xA1\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x9F"],
        ["\xE9\x8D\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA0"],
        ["\xE5\x8B\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA1"],
        ["\xE5\x90\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA2"],
        ["\xE8\x96\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA3"],
        ["\xE8\xA8\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA4"],
        ["\xE7\xBE\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA5"],
        ["\xE8\xBB\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA6"],
        ["\xE9\x83\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA7"],
        ["\xE5\x8D\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA8"],
        ["\xE8\xA2\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA9"],
        ["\xE7\xA5\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xAA"],
        ["\xE4\xBF\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xAB"],
        ["\xE5\x82\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xAC"],
        ["\xE5\x88\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xAD"],
        ["\xE5\x85\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xAE"],
        ["\xE5\x95\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xAF"],
        ["\xE5\x9C\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB0"],
        ["\xE7\x8F\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB1"],
        ["\xE5\x9E\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB2"],
        ["\xE5\xA5\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB3"],
        ["\xE5\xBD\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB4"],
        ["\xE5\xBE\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB5"],
        ["\xE6\x81\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB6"],
        ["\xE6\x85\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB7"],
        ["\xE6\x85\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB8"],
        ["\xE6\x86\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB9"],
        ["\xE6\x8E\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xBA"],
        ["\xE6\x90\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xBB"],
        ["\xE6\x95\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xBC"],
        ["\xE6\x99\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xBD"],
        ["\xE6\xA1\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xBE"],
        ["\xE6\xB8\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xBF"],
        ["\xE7\x95\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x80"],
        ["\xE7\xA8\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x81"],
        ["\xE7\xB3\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x82"],
        ["\xE7\xB5\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x83"],
        ["\xE7\xB6\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x84"],
        ["\xE7\xB9\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x85"],
        ["\xE7\xBD\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x86"],
        ["\xE8\x8C\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x87"],
        ["\xE8\x8D\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x88"],
        ["\xE8\x9B\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x89"],
        ["\xE8\xA8\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x8A"],
        ["\xE8\xA9\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x8B"],
        ["\xE8\xAD\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x8C"],
        ["\xE8\xBB\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x8D"],
        ["\xE9\xA0\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x8E"],
        ["\xE9\xB6\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x8F"],
        ["\xE8\x8A\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x90"],
        ["\xE8\xBF\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x91"],
        ["\xE9\xAF\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x92"],
        ["\xE5\x8A\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x93"],
        ["\xE6\x88\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x94"],
        ["\xE6\x92\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x95"],
        ["\xE6\xBF\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x96"],
        ["\xE9\x9A\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x97"],
        ["\xE6\xA1\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x98"],
        ["\xE5\x82\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x99"],
        ["\xE6\xAC\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x9A"],
        ["\xE6\xB1\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x9B"],
        ["\xE6\xBD\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x9C"],
        ["\xE7\xA9\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x9D"],
        ["\xE7\xB5\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x9E"],
        ["\xE8\xA1\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x9F"],
        ["\xE8\xA8\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA0"],
        ["\xE6\x9C\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA1"],
        ["\xE4\xBB\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA2"],
        ["\xE5\x80\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA3"],
        ["\xE5\x80\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA4"],
        ["\xE5\x81\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA5"],
        ["\xE5\x85\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA6"],
        ["\xE5\x88\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA7"],
        ["\xE5\x89\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA8"],
        ["\xE5\x96\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA9"],
        ["\xE5\x9C\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xAA"],
        ["\xE5\xA0\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xAB"],
        ["\xE5\xAB\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xAC"],
        ["\xE5\xBB\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xAD"],
        ["\xE6\x86\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xAE"],
        ["\xE6\x87\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xAF"],
        ["\xE6\x8B\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB0"],
        ["\xE6\x8D\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB1"],
        ["\xE6\xA4\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB2"],
        ["\xE6\xA8\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB3"],
        ["\xE7\x89\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB4"],
        ["\xE7\x8A\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB5"],
        ["\xE7\x8C\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB6"],
        ["\xE7\xA0\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB7"],
        ["\xE7\xA1\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB8"],
        ["\xE7\xB5\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB9"],
        ["\xE7\x9C\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xBA"],
        ["\xE8\x82\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xBB"],
        ["\xE8\xA6\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xBC"],
        ["\xE8\xAC\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xBD"],
        ["\xE8\xB3\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xBE"],
        ["\xE8\xBB\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xBF"],
        ["\xE9\x81\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x80"],
        ["\xE9\x8D\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x81"],
        ["\xE9\x99\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x82"],
        ["\xE9\xA1\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x83"],
        ["\xE9\xA8\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x84"],
        ["\xE9\xB9\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x85"],
        ["\xE5\x85\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x86"],
        ["\xE5\x8E\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x87"],
        ["\xE5\x8E\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x88"],
        ["\xE5\xB9\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x89"],
        ["\xE5\xBC\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x8A"],
        ["\xE6\xB8\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x8B"],
        ["\xE6\xBA\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x8C"],
        ["\xE7\x8E\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x8D"],
        ["\xE7\x8F\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x8E"],
        ["\xE7\xB5\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x8F"],
        ["\xE8\x88\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x90"],
        ["\xE8\xA8\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x91"],
        ["\xE8\xAB\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x92"],
        ["\xE9\x99\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x93"],
        ["\xE4\xB9\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x94"],
        ["\xE5\x80\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x95"],
        ["\xE5\x8F\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x96"],
        ["\xE5\x91\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x97"],
        ["\xE5\x9B\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x98"],
        ["\xE5\xA7\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x99"],
        ["\xE5\xAD\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x9A"],
        ["\xE5\xB7\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x9B"],
        ["\xE5\xBA\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x9C"],
        ["\xE5\xBC\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x9D"],
        ["\xE6\x88\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x9E"],
        ["\xE6\x95\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x9F"],
        ["\xE6\x9E\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA0"],
        ["\xE6\xB9\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA1"],
        ["\xE7\x8B\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA2"],
        ["\xE7\xB3\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA3"],
        ["\xE8\xA2\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA4"],
        ["\xE8\x82\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA5"],
        ["\xE8\x83\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA6"],
        ["\xE8\x8F\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA7"],
        ["\xE8\x99\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA8"],
        ["\xE8\xAA\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA9"],
        ["\xE8\xB7\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xAA"],
        ["\xE9\x88\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xAB"],
        ["\xE9\x9B\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xAC"],
        ["\xE9\xA1\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xAD"],
        ["\xE9\xBC\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xAE"],
        ["\xE4\xBA\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xAF"],
        ["\xE4\xBA\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB0"],
        ["\xE4\xBC\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB1"],
        ["\xE5\x8D\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB2"],
        ["\xE5\x91\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB3"],
        ["\xE5\x90\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB4"],
        ["\xE5\xA8\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB5"],
        ["\xE5\xBE\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB6"],
        ["\xE5\xBE\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB7"],
        ["\xE6\x82\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB8"],
        ["\xE6\xA2\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB9"],
        ["\xE6\xAA\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xBA"],
        ["\xE7\x91\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xBB"],
        ["\xE7\xA2\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xBC"],
        ["\xE8\xAA\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xBD"],
        ["\xE8\xAA\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xBE"],
        ["\xE8\xAD\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xBF"],
        ["\xE9\x86\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x80"],
        ["\xE4\xB9\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x81"],
        ["\xE9\xAF\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x82"],
        ["\xE4\xBA\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x83"],
        ["\xE4\xBD\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x84"],
        ["\xE4\xBE\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x85"],
        ["\xE5\x80\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x86"],
        ["\xE5\x80\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x87"],
        ["\xE5\x85\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x88"],
        ["\xE5\x85\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x89"],
        ["\xE5\x8A\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x8A"],
        ["\xE5\x8A\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x8B"],
        ["\xE5\x8B\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x8C"],
        ["\xE5\x8E\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x8D"],
        ["\xE5\x8F\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x8E"],
        ["\xE5\x90\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x8F"],
        ["\xE5\x90\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x90"],
        ["\xE5\x96\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x91"],
        ["\xE5\x9D\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x92"],
        ["\xE5\x9E\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x93"],
        ["\xE5\xA5\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x94"],
        ["\xE5\xAD\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x95"],
        ["\xE5\xAD\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x96"],
        ["\xE5\xAE\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x97"],
        ["\xE5\xB7\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x98"],
        ["\xE5\xB7\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x99"],
        ["\xE5\xB7\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x9A"],
        ["\xE5\xB9\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x9B"],
        ["\xE5\xBA\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x9C"],
        ["\xE5\xBA\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x9D"],
        ["\xE5\xBA\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x9E"],
        ["\xE5\xBC\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x9F"],
        ["\xE6\x81\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA0"],
        ["\xE6\x85\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA1"],
        ["\xE6\x8A\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA2"],
        ["\xE6\x8B\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA3"],
        ["\xE6\x8E\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA4"],
        ["\xE6\x94\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA5"],
        ["\xE6\x98\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA6"],
        ["\xE6\x99\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA7"],
        ["\xE6\x9B\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA8"],
        ["\xE6\x9D\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA9"],
        ["\xE6\xA0\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xAA"],
        ["\xE6\xA2\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xAB"],
        ["\xE6\xA7\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xAC"],
        ["\xE6\xB1\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xAD"],
        ["\xE6\xB4\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xAE"],
        ["\xE6\xB5\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xAF"],
        ["\xE6\xB8\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB0"],
        ["\xE6\xBA\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB1"],
        ["\xE7\x94\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB2"],
        ["\xE7\x9A\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB3"],
        ["\xE7\xA1\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB4"],
        ["\xE7\xA8\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB5"],
        ["\xE7\xB3\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB6"],
        ["\xE7\xB4\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB7"],
        ["\xE7\xB4\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB8"],
        ["\xE7\xB5\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB9"],
        ["\xE7\xB6\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xBA"],
        ["\xE8\x80\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xBB"],
        ["\xE8\x80\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xBC"],
        ["\xE8\x82\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xBD"],
        ["\xE8\x82\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xBE"],
        ["\xE8\x85\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xBF"],
        ["\xE8\x86\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x80"],
        ["\xE8\x88\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x81"],
        ["\xE8\x8D\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x82"],
        ["\xE8\xA1\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x83"],
        ["\xE8\xA1\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x84"],
        ["\xE8\xAC\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x85"],
        ["\xE8\xB2\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x86"],
        ["\xE8\xB3\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x87"],
        ["\xE9\x83\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x88"],
        ["\xE9\x85\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x89"],
        ["\xE9\x89\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x8A"],
        ["\xE7\xA0\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x8B"],
        ["\xE9\x8B\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x8C"],
        ["\xE9\x96\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x8D"],
        ["\xE9\x99\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x8E"],
        ["\xE9\xA0\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x8F"],
        ["\xE9\xA6\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x90"],
        ["\xE9\xAB\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x91"],
        ["\xE9\xB4\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x92"],
        ["\xE5\x89\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x93"],
        ["\xE5\x8A\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x94"],
        ["\xE5\x8F\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x95"],
        ["\xE5\x90\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x96"],
        ["\xE5\xA3\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x97"],
        ["\xE6\x8B\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x98"],
        ["\xE6\xBF\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x99"],
        ["\xE8\xB1\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x9A"],
        ["\xE8\xBD\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x9B"],
        ["\xE9\xBA\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x9C"],
        ["\xE5\x85\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x9D"],
        ["\xE5\x88\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x9E"],
        ["\xE5\x91\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x9F"],
        ["\xE5\x9B\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA0"],
        ["\xE7\xA9\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA1"],
        ["\xE9\x85\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA2"],
        ["\xE9\xB5\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA3"],
        ["\xE9\xBB\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA4"],
        ["\xE7\x8D\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA5"],
        ["\xE6\xBC\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA6"],
        ["\xE8\x85\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA7"],
        ["\xE7\x94\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA8"],
        ["\xE5\xBF\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA9"],
        ["\xE6\x83\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xAA"],
        ["\xE9\xAA\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xAB"],
        ["\xE7\x8B\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xAC"],
        ["\xE8\xBE\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xAD"],
        ["\xE6\xAD\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xAE"],
        ["\xE9\xA0\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xAF"],
        ["\xE4\xBB\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB0"],
        ["\xE5\x9B\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB1"],
        ["\xE5\x9D\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB2"],
        ["\xE5\xA2\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB3"],
        ["\xE5\xA9\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB4"],
        ["\xE6\x81\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB5"],
        ["\xE6\x87\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB6"],
        ["\xE6\x98\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB7"],
        ["\xE6\x98\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB8"],
        ["\xE6\xA0\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB9"],
        ["\xE6\xA2\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xBA"],
        ["\xE6\xB7\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xBB"],
        ["\xE7\x97\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xBC"],
        ["\xE7\xB4\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xBD"],
        ["\xE8\x89\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xBE"],
        ["\xE9\xAD\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xBF"],
        ["\xE4\xBA\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x80"],
        ["\xE4\xBD\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x81"],
        ["\xE5\x8F\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x82"],
        ["\xE5\x94\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x83"],
        ["\xE5\xB5\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x84"],
        ["\xE5\xB7\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x85"],
        ["\xE5\xB7\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x86"],
        ["\xE6\x9F\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x87"],
        ["\xE6\xB2\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x88"],
        ["\xE7\x91\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x89"],
        ["\xE7\xA0\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x8A"],
        ["\xE8\xA9\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x8B"],
        ["\xE9\x8E\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x8C"],
        ["\xE8\xA3\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x8D"],
        ["\xE5\x9D\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x8E"],
        ["\xE5\xBA\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x8F"],
        ["\xE6\x8C\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x90"],
        ["\xE5\x82\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x91"],
        ["\xE5\x82\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x92"],
        ["\xE5\x86\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x93"],
        ["\xE6\x9C\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x94"],
        ["\xE5\x93\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x95"],
        ["\xE5\xA1\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x96"],
        ["\xE5\xA6\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x97"],
        ["\xE5\xAE\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x98"],
        ["\xE5\xBD\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x99"],
        ["\xE6\x89\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x9A"],
        ["\xE6\x8E\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x9B"],
        ["\xE6\xA0\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x9C"],
        ["\xE6\xAD\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x9D"],
        ["\xE6\xB8\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x9E"],
        ["\xE7\x81\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x9F"],
        ["\xE9\x87\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA0"],
        ["\xE7\x8A\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA1"],
        ["\xE7\xA0\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA2"],
        ["\xE7\xA0\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA3"],
        ["\xE7\xA5\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA4"],
        ["\xE6\x96\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA5"],
        ["\xE7\xB4\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA6"],
        ["\xE8\x8F\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA7"],
        ["\xE8\xA3\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA8"],
        ["\xE8\xBC\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA9"],
        ["\xE9\x9A\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xAA"],
        ["\xE5\x89\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xAB"],
        ["\xE5\x9C\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xAC"],
        ["\xE6\x9D\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xAD"],
        ["\xE7\xBD\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xAE"],
        ["\xE8\xB2\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xAF"],
        ["\xE5\x86\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB0"],
        ["\xE5\x9D\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB1"],
        ["\xE9\x98\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB2"],
        ["\xE5\xA0\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB3"],
        ["\xE6\xA6\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB4"],
        ["\xE8\x82\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB5"],
        ["\xE5\x92\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB6"],
        ["\xE5\xB4\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB7"],
        ["\xE5\x9F\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB8"],
        ["\xE7\xA2\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB9"],
        ["\xE9\xB7\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xBA"],
        ["\xE4\xBD\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xBB"],
        ["\xE5\x89\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xBC"],
        ["\xE5\x92\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xBD"],
        ["\xE6\x90\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xBE"],
        ["\xE6\x98\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xBF"],
        ["\xE6\x9C\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x80"],
        ["\xE6\x9F\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x81"],
        ["\xE7\xAA\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x82"],
        ["\xE7\xAD\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x83"],
        ["\xE7\xB4\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x84"],
        ["\xE9\x8C\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x85"],
        ["\xE6\xA1\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x86"],
        ["\xE9\xAE\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x87"],
        ["\xE7\xAC\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x88"],
        ["\xE5\x8C\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x89"],
        ["\xE5\x86\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x8A"],
        ["\xE5\x88\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x8B"],
        ["\xE5\xAF\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x8C"],
        ["\xE6\x8B\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x8D"],
        ["\xE6\x92\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x8E"],
        ["\xE6\x93\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x8F"],
        ["\xE6\x9C\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x90"],
        ["\xE6\xAE\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x91"],
        ["\xE8\x96\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x92"],
        ["\xE9\x9B\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x93"],
        ["\xE7\x9A\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x94"],
        ["\xE9\xAF\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x95"],
        ["\xE6\x8D\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x96"],
        ["\xE9\x8C\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x97"],
        ["\xE9\xAE\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x98"],
        ["\xE7\x9A\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x99"],
        ["\xE6\x99\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x9A"],
        ["\xE4\xB8\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x9B"],
        ["\xE5\x82\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x9C"],
        ["\xE5\x8F\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x9D"],
        ["\xE5\xB1\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x9E"],
        ["\xE6\x83\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x9F"],
        ["\xE6\x92\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA0"],
        ["\xE6\x95\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA1"],
        ["\xE6\xA1\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA2"],
        ["\xE7\x87\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA3"],
        ["\xE7\x8F\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA4"],
        ["\xE7\x94\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA5"],
        ["\xE7\xAE\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA6"],
        ["\xE7\xBA\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA7"],
        ["\xE8\x9A\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA8"],
        ["\xE8\xAE\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA9"],
        ["\xE8\xB3\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xAA"],
        ["\xE9\x85\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xAB"],
        ["\xE9\xA4\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xAC"],
        ["\xE6\x96\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xAD"],
        ["\xE6\x9A\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xAE"],
        ["\xE6\xAE\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xAF"],
        ["\xE4\xBB\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB0"],
        ["\xE4\xBB\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB1"],
        ["\xE4\xBC\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB2"],
        ["\xE4\xBD\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB3"],
        ["\xE5\x88\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB4"],
        ["\xE5\x8F\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB5"],
        ["\xE5\x8F\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB6"],
        ["\xE5\x97\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB7"],
        ["\xE5\x9B\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB8"],
        ["\xE5\xA3\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB9"],
        ["\xE5\xA7\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xBA"],
        ["\xE5\xA7\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xBB"],
        ["\xE5\xA7\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xBC"],
        ["\xE5\xAD\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xBD"],
        ["\xE5\xB1\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xBE"],
        ["\xE5\xB8\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xBF"],
        ["\xE5\xB8\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x80"],
        ["\xE5\xBF\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x81"],
        ["\xE6\x80\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x82"],
        ["\xE6\x8C\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x83"],
        ["\xE6\x94\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x84"],
        ["\xE5\xAD\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x85"],
        ["\xE6\x96\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x86"],
        ["\xE6\x96\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x87"],
        ["\xE6\x97\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x88"],
        ["\xE6\x9E\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x89"],
        ["\xE6\xAD\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x8A"],
        ["\xE6\xAD\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x8B"],
        ["\xE6\xB0\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x8C"],
        ["\xE7\x8D\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x8D"],
        ["\xE7\xA5\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x8E"],
        ["\xE7\xA7\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x8F"],
        ["\xE7\xB3\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x90"],
        ["\xE7\xB4\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x91"],
        ["\xE7\xB4\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x92"],
        ["\xE8\x82\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x93"],
        ["\xE8\x84\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x94"],
        ["\xE8\x87\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x95"],
        ["\xE8\xA6\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x96"],
        ["\xE8\xA9\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x97"],
        ["\xE8\xA9\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x98"],
        ["\xE8\xA9\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x99"],
        ["\xE8\xAA\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x9A"],
        ["\xE8\xAB\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x9B"],
        ["\xE8\xB3\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x9C"],
        ["\xE8\xB3\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x9D"],
        ["\xE9\x9B\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x9E"],
        ["\xE9\xA3\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x9F"],
        ["\xE6\xAD\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA0"],
        ["\xE4\xBA\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA1"],
        ["\xE4\xBC\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA2"],
        ["\xE4\xBE\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA3"],
        ["\xE5\x85\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA4"],
        ["\xE5\xAD\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA5"],
        ["\xE5\xAF\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA6"],
        ["\xE6\x85\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA7"],
        ["\xE6\x8C\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA8"],
        ["\xE6\x99\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA9"],
        ["\xE6\xAC\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xAA"],
        ["\xE6\xBB\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xAB"],
        ["\xE6\xB2\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xAC"],
        ["\xE7\x88\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xAD"],
        ["\xE7\x92\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xAE"],
        ["\xE7\x97\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xAF"],
        ["\xE7\xA3\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB0"],
        ["\xE7\xA4\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB1"],
        ["\xE8\x80\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB2"],
        ["\xE8\x80\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB3"],
        ["\xE8\x87\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB4"],
        ["\xE8\x92\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB5"],
        ["\xE8\xBE\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB6"],
        ["\xE6\xB1\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB7"],
        ["\xE9\xB9\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB8"],
        ["\xE5\xBC\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB9"],
        ["\xE8\xAD\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xBA"],
        ["\xE9\xB4\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xBB"],
        ["\xE7\xAB\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xBC"],
        ["\xE8\xBB\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xBD"],
        ["\xE5\xAE\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xBE"],
        ["\xE9\x9B\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xBF"],
        ["\xE4\xB8\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x80"],
        ["\xE5\x8F\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x81"],
        ["\xE5\x9F\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x82"],
        ["\xE5\xA4\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x83"],
        ["\xE5\xAB\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x84"],
        ["\xE5\xAE\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x85"],
        ["\xE6\x82\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x86"],
        ["\xE6\xB9\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x87"],
        ["\xE6\xBC\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x88"],
        ["\xE7\x96\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x89"],
        ["\xE8\xB3\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x8A"],
        ["\xE5\xAE\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x8B"],
        ["\xE8\x94\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x8C"],
        ["\xE7\xAF\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x8D"],
        ["\xE5\x81\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x8E"],
        ["\xE6\x9F\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x8F"],
        ["\xE8\x8A\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x90"],
        ["\xE5\xB1\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x91"],
        ["\xE8\x95\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x92"],
        ["\xE7\xB8\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x93"],
        ["\xE8\x88\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x94"],
        ["\xE5\x86\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x95"],
        ["\xE5\xB0\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x96"],
        ["\xE6\x8D\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x97"],
        ["\xE8\xB5\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x98"],
        ["\xE6\x96\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x99"],
        ["\xE7\x85\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x9A"],
        ["\xE7\xA4\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x9B"],
        ["\xE7\xB4\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x9C"],
        ["\xE8\x80\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x9D"],
        ["\xE8\xAC\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x9E"],
        ["\xE8\xBB\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x9F"],
        ["\xE9\x81\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA0"],
        ["\xE8\x9B\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA1"],
        ["\xE9\x82\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA2"],
        ["\xE5\x80\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA3"],
        ["\xE5\x8B\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA4"],
        ["\xE5\xB0\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA5"],
        ["\xE6\x9D\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA6"],
        ["\xE7\x81\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA7"],
        ["\xE7\x88\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA8"],
        ["\xE9\x85\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA9"],
        ["\xE9\x87\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xAA"],
        ["\xE9\x8C\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xAB"],
        ["\xE8\x8B\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xAC"],
        ["\xE5\xAF\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xAD"],
        ["\xE5\xBC\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xAE"],
        ["\xE6\x83\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xAF"],
        ["\xE4\xB8\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB0"],
        ["\xE5\x8F\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB1"],
        ["\xE5\xAE\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB2"],
        ["\xE6\x89\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB3"],
        ["\xE6\x9C\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB4"],
        ["\xE6\xAE\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB5"],
        ["\xE7\x8B\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB6"],
        ["\xE7\x8F\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB7"],
        ["\xE7\xA8\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB8"],
        ["\xE8\x85\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB9"],
        ["\xE8\xB6\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xBA"],
        ["\xE9\x85\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xBB"],
        ["\xE9\xA6\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xBC"],
        ["\xE5\x84\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xBD"],
        ["\xE5\x8F\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xBE"],
        ["\xE5\x91\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xBF"],
        ["\xE5\xAF\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x80"],
        ["\xE6\x8E\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x81"],
        ["\xE6\xA8\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x82"],
        ["\xE7\xB6\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x83"],
        ["\xE9\x9C\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x84"],
        ["\xE5\x9B\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x85"],
        ["\xE5\x8F\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x86"],
        ["\xE5\x91\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x87"],
        ["\xE5\xAE\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x88"],
        ["\xE5\xB0\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x89"],
        ["\xE5\xB7\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x8A"],
        ["\xE4\xBF\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x8B"],
        ["\xE6\x84\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x8C"],
        ["\xE6\x8B\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x8D"],
        ["\xE6\xB4\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x8E"],
        ["\xE7\xA7\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x8F"],
        ["\xE7\xA7\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x90"],
        ["\xE7\xB5\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x91"],
        ["\xE7\xB9\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x92"],
        ["\xE7\xBF\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x93"],
        ["\xE8\x87\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x94"],
        ["\xE8\x88\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x95"],
        ["\xE8\x92\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x96"],
        ["\xE8\xA1\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x97"],
        ["\xE8\xA5\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x98"],
        ["\xE8\xAE\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x99"],
        ["\xE8\xB9\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x9A"],
        ["\xE8\xBC\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x9B"],
        ["\xE9\x80\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x9C"],
        ["\xE9\x85\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x9D"],
        ["\xE9\x85\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x9E"],
        ["\xE9\x9B\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x9F"],
        ["\xE9\x86\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA0"],
        ["\xE4\xBB\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA1"],
        ["\xE4\xBD\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA2"],
        ["\xE5\x85\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA3"],
        ["\xE5\x8D\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA4"],
        ["\xE5\xBE\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA5"],
        ["\xE6\x88\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA6"],
        ["\xE6\x9F\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA7"],
        ["\xE6\xB1\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA8"],
        ["\xE6\xB8\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA9"],
        ["\xE7\x8D\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xAA"],
        ["\xE7\xB8\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xAB"],
        ["\xE9\x87\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xAC"],
        ["\xE9\x8A\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xAD"],
        ["\xE5\x8F\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xAE"],
        ["\xE5\xA4\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xAF"],
        ["\xE5\xAE\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB0"],
        ["\xE6\xB7\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB1"],
        ["\xE7\xA5\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB2"],
        ["\xE7\xB8\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB3"],
        ["\xE7\xB2\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB4"],
        ["\xE5\xA1\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB5"],
        ["\xE7\x86\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB6"],
        ["\xE5\x87\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB7"],
        ["\xE8\xA1\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB8"],
        ["\xE8\xBF\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB9"],
        ["\xE4\xBF\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xBA"],
        ["\xE5\xB3\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xBB"],
        ["\xE6\x98\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xBC"],
        ["\xE7\x9E\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xBD"],
        ["\xE7\xAB\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xBE"],
        ["\xE8\x88\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xBF"],
        ["\xE9\xA7\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x80"],
        ["\xE5\x87\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x81"],
        ["\xE5\xBE\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x82"],
        ["\xE6\x97\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x83"],
        ["\xE6\xA5\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x84"],
        ["\xE6\xAE\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x85"],
        ["\xE6\xB7\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x86"],
        ["\xE6\xBA\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x87"],
        ["\xE6\xBD\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x88"],
        ["\xE7\x9B\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x89"],
        ["\xE7\xB4\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x8A"],
        ["\xE5\xB7\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x8B"],
        ["\xE9\x81\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x8C"],
        ["\xE9\x86\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x8D"],
        ["\xE9\xA0\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x8E"],
        ["\xE5\x87\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x8F"],
        ["\xE5\x88\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x90"],
        ["\xE6\x89\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x91"],
        ["\xE6\x9A\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x92"],
        ["\xE6\x9B\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x93"],
        ["\xE6\xB8\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x94"],
        ["\xE5\xBA\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x95"],
        ["\xE7\xB7\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x96"],
        ["\xE7\xBD\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x97"],
        ["\xE6\x9B\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x98"],
        ["\xE8\x96\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x99"],
        ["\xE8\x97\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x9A"],
        ["\xE8\xAB\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x9B"],
        ["\xE5\x8A\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x9C"],
        ["\xE5\x8F\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x9D"],
        ["\xE5\xA5\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x9E"],
        ["\xE5\xBA\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x9F"],
        ["\xE5\xBE\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA0"],
        ["\xE6\x81\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA1"],
        ["\xE9\x8B\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA2"],
        ["\xE9\x99\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA3"],
        ["\xE5\x82\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA4"],
        ["\xE5\x84\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA5"],
        ["\xE5\x8B\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA6"],
        ["\xE5\x8C\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA7"],
        ["\xE5\x8D\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA8"],
        ["\xE5\x8F\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA9"],
        ["\xE5\x93\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xAA"],
        ["\xE5\x95\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xAB"],
        ["\xE5\x94\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xAC"],
        ["\xE5\x98\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xAD"],
        ["\xE5\xA5\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xAE"],
        ["\xE5\xA6\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xAF"],
        ["\xE5\xA8\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB0"],
        ["\xE5\xAE\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB1"],
        ["\xE5\xB0\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB2"],
        ["\xE5\xB0\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB3"],
        ["\xE5\xB0\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB4"],
        ["\xE5\xB0\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB5"],
        ["\xE5\xBA\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB6"],
        ["\xE5\xBA\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB7"],
        ["\xE5\xBB\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB8"],
        ["\xE5\xBD\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB9"],
        ["\xE6\x89\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xBA"],
        ["\xE6\x8A\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xBB"],
        ["\xE6\x8B\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xBC"],
        ["\xE6\x8E\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xBD"],
        ["\xE6\x8D\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xBE"],
        ["\xE6\x98\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xBF"],
        ["\xE6\x98\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x80"],
        ["\xE6\x98\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x81"],
        ["\xE6\x99\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x82"],
        ["\xE6\x9D\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x83"],
        ["\xE6\xA2\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x84"],
        ["\xE6\xA8\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x85"],
        ["\xE6\xA8\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x86"],
        ["\xE6\xB2\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x87"],
        ["\xE6\xB6\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x88"],
        ["\xE6\xB8\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x89"],
        ["\xE6\xB9\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x8A"],
        ["\xE7\x84\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x8B"],
        ["\xE7\x84\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x8C"],
        ["\xE7\x85\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x8D"],
        ["\xE7\x97\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x8E"],
        ["\xE7\x9C\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x8F"],
        ["\xE7\xA1\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x90"],
        ["\xE7\xA4\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x91"],
        ["\xE7\xA5\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x92"],
        ["\xE7\xA7\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x93"],
        ["\xE7\xAB\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x94"],
        ["\xE7\xAC\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x95"],
        ["\xE7\xB2\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x96"],
        ["\xE7\xB4\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x97"],
        ["\xE8\x82\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x98"],
        ["\xE8\x8F\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x99"],
        ["\xE8\x92\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x9A"],
        ["\xE8\x95\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x9B"],
        ["\xE8\xA1\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x9C"],
        ["\xE8\xA3\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x9D"],
        ["\xE8\xA8\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x9E"],
        ["\xE8\xA8\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x9F"],
        ["\xE8\xA9\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA0"],
        ["\xE8\xA9\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA1"],
        ["\xE8\xB1\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA2"],
        ["\xE8\xB3\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA3"],
        ["\xE9\x86\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA4"],
        ["\xE9\x89\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA5"],
        ["\xE9\x8D\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA6"],
        ["\xE9\x90\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA7"],
        ["\xE9\x9A\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA8"],
        ["\xE9\x9E\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA9"],
        ["\xE4\xB8\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xAA"],
        ["\xE4\xB8\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xAB"],
        ["\xE4\xB8\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xAC"],
        ["\xE4\xB9\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xAD"],
        ["\xE5\x86\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xAE"],
        ["\xE5\x89\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xAF"],
        ["\xE5\x9F\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB0"],
        ["\xE5\xA0\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB1"],
        ["\xE5\xA3\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB2"],
        ["\xE5\xAC\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB3"],
        ["\xE5\xB8\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB4"],
        ["\xE6\x83\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB5"],
        ["\xE6\x93\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB6"],
        ["\xE6\x9D\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB7"],
        ["\xE6\x9D\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB8"],
        ["\xE6\xB5\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB9"],
        ["\xE7\x8A\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xBA"],
        ["\xE7\x95\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xBB"],
        ["\xE7\xA9\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xBC"],
        ["\xE8\x92\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xBD"],
        ["\xE8\xAD\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xBE"],
        ["\xE9\x86\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xBF"],
        ["\xE9\x8C\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x80"],
        ["\xE5\x98\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x81"],
        ["\xE5\x9F\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x82"],
        ["\xE9\xA3\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x83"],
        ["\xE6\x8B\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x84"],
        ["\xE6\xA4\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x85"],
        ["\xE6\xAE\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x86"],
        ["\xE7\x87\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x87"],
        ["\xE7\xB9\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x88"],
        ["\xE8\x81\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x89"],
        ["\xE8\x89\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x8A"],
        ["\xE8\xA7\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x8B"],
        ["\xE9\xA3\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x8C"],
        ["\xE8\x9D\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x8D"],
        ["\xE8\xBE\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x8E"],
        ["\xE5\xB0\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x8F"],
        ["\xE4\xBC\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x90"],
        ["\xE4\xBF\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x91"],
        ["\xE4\xBE\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x92"],
        ["\xE5\x94\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x93"],
        ["\xE5\xA8\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x94"],
        ["\xE5\xAF\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x95"],
        ["\xE5\xAF\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x96"],
        ["\xE5\xBF\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x97"],
        ["\xE6\x85\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x98"],
        ["\xE6\x8C\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x99"],
        ["\xE6\x96\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x9A"],
        ["\xE6\x99\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x9B"],
        ["\xE6\xA3\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x9C"],
        ["\xE6\xA6\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x9D"],
        ["\xE6\xB5\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x9E"],
        ["\xE6\xB7\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x9F"],
        ["\xE7\x94\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA0"],
        ["\xE7\x96\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA1"],
        ["\xE7\x9C\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA2"],
        ["\xE7\xA5\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA3"],
        ["\xE7\xA7\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA4"],
        ["\xE7\xB4\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA5"],
        ["\xE8\x87\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA6"],
        ["\xE8\x8A\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA7"],
        ["\xE8\x96\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA8"],
        ["\xE8\xA6\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA9"],
        ["\xE8\xA8\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xAA"],
        ["\xE8\xBA\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xAB"],
        ["\xE8\xBE\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xAC"],
        ["\xE9\x80\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xAD"],
        ["\xE9\x87\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xAE"],
        ["\xE9\x9C\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xAF"],
        ["\xE4\xBA\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB0"],
        ["\xE4\xBB\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB1"],
        ["\xE5\x88\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB2"],
        ["\xE5\xA1\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB3"],
        ["\xE5\xA3\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB4"],
        ["\xE5\xB0\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB5"],
        ["\xE7\x94\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB6"],
        ["\xE5\xB0\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB7"],
        ["\xE8\x85\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB8"],
        ["\xE8\xA8\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB9"],
        ["\xE8\xBF\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xBA"],
        ["\xE9\x99\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xBB"],
        ["\xE9\x9D\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xBC"],
        ["\xE7\xAC\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xBD"],
        ["\xE8\xAB\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xBE"],
        ["\xE9\xA0\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xBF"],
        ["\xE9\x85\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x80"],
        ["\xE5\x9B\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x81"],
        ["\xE5\x8E\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x82"],
        ["\xE9\x80\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x83"],
        ["\xE5\x90\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x84"],
        ["\xE5\x9E\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x85"],
        ["\xE5\xB8\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x86"],
        ["\xE6\x8E\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x87"],
        ["\xE6\xB0\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x88"],
        ["\xE7\x82\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x89"],
        ["\xE7\x9D\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x8A"],
        ["\xE7\xB2\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x8B"],
        ["\xE7\xBF\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x8C"],
        ["\xE8\xA1\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x8D"],
        ["\xE9\x81\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x8E"],
        ["\xE9\x85\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x8F"],
        ["\xE9\x8C\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x90"],
        ["\xE9\x8C\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x91"],
        ["\xE9\x9A\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x92"],
        ["\xE7\x91\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x93"],
        ["\xE9\xAB\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x94"],
        ["\xE5\xB4\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x95"],
        ["\xE5\xB5\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x96"],
        ["\xE6\x95\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x97"],
        ["\xE6\x9E\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x98"],
        ["\xE8\xB6\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x99"],
        ["\xE9\x9B\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x9A"],
        ["\xE6\x8D\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x9B"],
        ["\xE6\x9D\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x9C"],
        ["\xE6\xA4\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x9D"],
        ["\xE8\x8F\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x9E"],
        ["\xE9\xA0\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x9F"],
        ["\xE9\x9B\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA0"],
        ["\xE8\xA3\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA1"],
        ["\xE6\xBE\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA2"],
        ["\xE6\x91\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA3"],
        ["\xE5\xAF\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA4"],
        ["\xE4\xB8\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA5"],
        ["\xE7\x80\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA6"],
        ["\xE7\x95\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA7"],
        ["\xE6\x98\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA8"],
        ["\xE5\x87\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA9"],
        ["\xE5\x88\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xAA"],
        ["\xE5\x8B\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xAB"],
        ["\xE5\xA7\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xAC"],
        ["\xE5\xBE\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xAD"],
        ["\xE6\x80\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xAE"],
        ["\xE6\x88\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xAF"],
        ["\xE6\x94\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB0"],
        ["\xE6\x95\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB1"],
        ["\xE6\x98\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB2"],
        ["\xE6\x99\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB3"],
        ["\xE6\xA3\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB4"],
        ["\xE6\xA0\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB5"],
        ["\xE6\xAD\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB6"],
        ["\xE6\xB8\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB7"],
        ["\xE7\x89\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB8"],
        ["\xE7\x94\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB9"],
        ["\xE7\x9B\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xBA"],
        ["\xE7\xB2\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xBB"],
        ["\xE8\x81\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xBC"],
        ["\xE5\xA3\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xBD"],
        ["\xE8\xA3\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xBE"],
        ["\xE8\xA5\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xBF"],
        ["\xE8\xAA\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x80"],
        ["\xE8\xAA\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x81"],
        ["\xE8\xAB\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x82"],
        ["\xE9\x80\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x83"],
        ["\xE9\x86\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x84"],
        ["\xE9\x9D\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x85"],
        ["\xE9\x9D\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x86"],
        ["\xE6\x96\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x87"],
        ["\xE7\xA8\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x88"],
        ["\xE8\x84\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x89"],
        ["\xE9\x9A\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x8A"],
        ["\xE5\xB8\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x8B"],
        ["\xE6\x83\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x8C"],
        ["\xE6\x88\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x8D"],
        ["\xE6\x96\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x8E"],
        ["\xE6\x98\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x8F"],
        ["\xE6\x9E\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x90"],
        ["\xE7\x9F\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x91"],
        ["\xE7\xA9\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x92"],
        ["\xE7\xB1\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x93"],
        ["\xE7\xB8\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x94"],
        ["\xE8\x84\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x95"],
        ["\xE8\xB2\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x96"],
        ["\xE8\xB5\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x97"],
        ["\xE8\xB7\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x98"],
        ["\xE8\xB9\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x99"],
        ["\xE7\xA2\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x9A"],
        ["\xE5\x88\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x9B"],
        ["\xE6\x8B\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x9C"],
        ["\xE6\x8E\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x9D"],
        ["\xE6\x91\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x9E"],
        ["\xE6\x8A\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x9F"],
        ["\xE8\xA8\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA0"],
        ["\xE7\xAA\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA1"],
        ["\xE7\xAF\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA2"],
        ["\xE8\xAA\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA3"],
        ["\xE9\x9B\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA4"],
        ["\xE7\xB5\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA5"],
        ["\xE8\x88\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA6"],
        ["\xE8\x9D\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA7"],
        ["\xE4\xBB\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA8"],
        ["\xE5\x85\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA9"],
        ["\xE5\x8D\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xAA"],
        ["\xE5\x8D\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xAB"],
        ["\xE5\xAE\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xAC"],
        ["\xE5\xB0\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xAD"],
        ["\xE5\xB0\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xAE"],
        ["\xE5\xB7\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xAF"],
        ["\xE6\x88\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB0"],
        ["\xE6\x89\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB1"],
        ["\xE6\x92\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB2"],
        ["\xE6\xA0\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB3"],
        ["\xE6\xA0\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB4"],
        ["\xE6\xB3\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB5"],
        ["\xE6\xB5\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB6"],
        ["\xE6\xB4\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB7"],
        ["\xE6\x9F\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB8"],
        ["\xE6\xBD\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB9"],
        ["\xE7\x85\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xBA"],
        ["\xE7\x85\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xBB"],
        ["\xE6\x97\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xBC"],
        ["\xE7\xA9\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xBD"],
        ["\xE7\xAE\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xBE"],
        ["\xE7\xB7\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xBF"],
        ["\xE7\xB9\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x80"],
        ["\xE7\xBE\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x81"],
        ["\xE8\x85\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x82"],
        ["\xE8\x88\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x83"],
        ["\xE8\x88\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x84"],
        ["\xE8\x96\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x85"],
        ["\xE8\xA9\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x86"],
        ["\xE8\xB3\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x87"],
        ["\xE8\xB7\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x88"],
        ["\xE9\x81\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x89"],
        ["\xE9\x81\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x8A"],
        ["\xE9\x8A\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x8B"],
        ["\xE9\x8A\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x8C"],
        ["\xE9\x96\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x8D"],
        ["\xE9\xAE\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x8E"],
        ["\xE5\x89\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x8F"],
        ["\xE5\x96\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x90"],
        ["\xE6\xBC\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x91"],
        ["\xE7\x84\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x92"],
        ["\xE5\x85\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x93"],
        ["\xE7\xA6\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x94"],
        ["\xE7\xB9\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x95"],
        ["\xE8\x86\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x96"],
        ["\xE7\xB3\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x97"],
        ["\xE5\x99\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x98"],
        ["\xE5\xA1\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x99"],
        ["\xE5\xB2\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x9A"],
        ["\xE6\x8E\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x9B"],
        ["\xE6\x9B\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x9C"],
        ["\xE6\x9B\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x9D"],
        ["\xE6\xA5\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x9E"],
        ["\xE7\x8B\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x9F"],
        ["\xE7\x96\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA0"],
        ["\xE7\x96\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA1"],
        ["\xE7\xA4\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA2"],
        ["\xE7\xA5\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA3"],
        ["\xE7\xA7\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA4"],
        ["\xE7\xB2\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA5"],
        ["\xE7\xB4\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA6"],
        ["\xE7\xB5\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA7"],
        ["\xE8\x98\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA8"],
        ["\xE8\xA8\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA9"],
        ["\xE9\x98\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xAA"],
        ["\xE9\x81\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xAB"],
        ["\xE9\xBC\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xAC"],
        ["\xE5\x83\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xAD"],
        ["\xE5\x89\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xAE"],
        ["\xE5\x8F\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xAF"],
        ["\xE5\x8F\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB0"],
        ["\xE5\x80\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB1"],
        ["\xE5\x96\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB2"],
        ["\xE5\xA3\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB3"],
        ["\xE5\xA5\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB4"],
        ["\xE7\x88\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB5"],
        ["\xE5\xAE\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB6"],
        ["\xE5\xB1\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB7"],
        ["\xE5\x8C\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB8"],
        ["\xE6\x83\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB9"],
        ["\xE6\x83\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xBA"],
        ["\xE6\x8D\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xBB"],
        ["\xE6\x8E\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xBC"],
        ["\xE6\x8C\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xBD"],
        ["\xE6\x8E\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xBE"],
        ["\xE6\x93\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xBF"],
        ["\xE6\x97\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x80"],
        ["\xE6\x9B\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x81"],
        ["\xE5\xB7\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x82"],
        ["\xE6\xA7\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x83"],
        ["\xE6\xA7\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x84"],
        ["\xE6\xBC\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x85"],
        ["\xE7\x87\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x86"],
        ["\xE4\xBA\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x87"],
        ["\xE7\x97\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x88"],
        ["\xE7\x9B\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x89"],
        ["\xE7\xAA\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x8A"],
        ["\xE7\xB3\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x8B"],
        ["\xE7\xB7\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x8C"],
        ["\xE7\xB6\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x8D"],
        ["\xE8\x81\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x8E"],
        ["\xE8\x8D\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x8F"],
        ["\xE8\x8D\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x90"],
        ["\xE8\x91\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x91"],
        ["\xE8\x92\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x92"],
        ["\xE8\x97\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x93"],
        ["\xE8\xA3\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x94"],
        ["\xE8\xB5\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x95"],
        ["\xE9\x80\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x96"],
        ["\xE9\x81\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x97"],
        ["\xE9\x8E\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x98"],
        ["\xE9\x9C\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x99"],
        ["\xE9\xA8\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x9A"],
        ["\xE5\x83\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x9B"],
        ["\xE5\xA2\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x9C"],
        ["\xE6\x86\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x9D"],
        ["\xE8\x87\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x9E"],
        ["\xE8\x94\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x9F"],
        ["\xE8\xB4\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA0"],
        ["\xE9\x80\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA1"],
        ["\xE4\xBF\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA2"],
        ["\xE5\x81\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA3"],
        ["\xE5\x89\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA4"],
        ["\xE5\x8D\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA5"],
        ["\xE6\x81\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA6"],
        ["\xE6\x8D\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA7"],
        ["\xE6\x9D\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA8"],
        ["\xE6\xB8\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA9"],
        ["\xE8\xB6\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xAA"],
        ["\xE9\x80\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xAB"],
        ["\xE4\xBF\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xAC"],
        ["\xE5\xB1\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xAD"],
        ["\xE8\xB3\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xAE"],
        ["\xE6\x97\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xAF"],
        ["\xE7\xB6\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB0"],
        ["\xE5\x8D\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB1"],
        ["\xE8\xA2\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB2"],
        ["\xE5\x85\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB3"],
        ["\xE6\x8F\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB4"],
        ["\xE5\xAD\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB5"],
        ["\xE5\xAD\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB6"],
        ["\xE5\xB0\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB7"],
        ["\xE6\x90\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB8"],
        ["\xE6\x9D\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB9"],
        ["\xE9\x81\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xBA"],
        ["\xE4\xBB\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xBB"],
        ["\xE5\xA4\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xBC"],
        ["\xE5\xA4\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xBD"],
        ["\xE6\xB1\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xBE"],
        ["\xE8\xA9\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xBF"],
        ["\xE5\x94\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x80"],
        ["\xE5\xA0\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x81"],
        ["\xE5\xA6\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x82"],
        ["\xE6\x83\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x83"],
        ["\xE6\x89\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x84"],
        ["\xE6\x9F\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x85"],
        ["\xE8\x88\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x86"],
        ["\xE6\xA5\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x87"],
        ["\xE9\x99\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x88"],
        ["\xE9\xA7\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x89"],
        ["\xE9\xA8\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x8A"],
        ["\xE4\xBD\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x8B"],
        ["\xE5\xA0\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x8C"],
        ["\xE5\xAF\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x8D"],
        ["\xE8\x80\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x8E"],
        ["\xE5\xB2\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x8F"],
        ["\xE5\xB8\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x90"],
        ["\xE5\xBE\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x91"],
        ["\xE6\x80\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x92"],
        ["\xE6\x85\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x93"],
        ["\xE6\x88\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x94"],
        ["\xE6\x9B\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x95"],
        ["\xE6\xB3\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x96"],
        ["\xE6\xBB\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x97"],
        ["\xE8\x83\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x98"],
        ["\xE8\x85\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x99"],
        ["\xE8\x8B\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x9A"],
        ["\xE8\xA2\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x9B"],
        ["\xE8\xB2\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x9C"],
        ["\xE9\x80\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x9D"],
        ["\xE9\x80\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x9E"],
        ["\xE9\x9A\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x9F"],
        ["\xE9\xBB\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA0"],
        ["\xE9\xAF\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA1"],
        ["\xE4\xBB\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA2"],
        ["\xE5\x8F\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA3"],
        ["\xE5\xA4\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA4"],
        ["\xE7\xAC\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA5"],
        ["\xE9\x86\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA6"],
        ["\xE9\xA1\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA7"],
        ["\xE9\xB7\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA8"],
        ["\xE6\xBB\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA9"],
        ["\xE7\x80\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xAA"],
        ["\xE5\x8D\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xAB"],
        ["\xE5\x95\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xAC"],
        ["\xE5\xAE\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xAD"],
        ["\xE6\x89\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xAE"],
        ["\xE6\x8A\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xAF"],
        ["\xE6\x8B\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB0"],
        ["\xE6\xB2\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB1"],
        ["\xE6\xBF\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB2"],
        ["\xE7\x90\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB3"],
        ["\xE8\xA8\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB4"],
        ["\xE9\x90\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB5"],
        ["\xE6\xBF\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB6"],
        ["\xE8\xAB\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB7"],
        ["\xE8\x8C\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB8"],
        ["\xE5\x87\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB9"],
        ["\xE8\x9B\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xBA"],
        ["\xE5\x8F\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xBB"],
        ["\xE5\x8F\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xBC"],
        ["\xE4\xBD\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xBD"],
        ["\xE9\x81\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xBE"],
        ["\xE8\xBE\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xBF"],
        ["\xE5\xA5\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x80"],
        ["\xE8\x84\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x81"],
        ["\xE5\xB7\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x82"],
        ["\xE7\xAB\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x83"],
        ["\xE8\xBE\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x84"],
        ["\xE6\xA3\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x85"],
        ["\xE8\xB0\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x86"],
        ["\xE7\x8B\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x87"],
        ["\xE9\xB1\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x88"],
        ["\xE6\xA8\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x89"],
        ["\xE8\xAA\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x8A"],
        ["\xE4\xB8\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x8B"],
        ["\xE5\x8D\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x8C"],
        ["\xE5\x98\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x8D"],
        ["\xE5\x9D\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x8E"],
        ["\xE6\x8B\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x8F"],
        ["\xE6\x8E\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x90"],
        ["\xE6\x97\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x91"],
        ["\xE6\xAD\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x92"],
        ["\xE6\xB7\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x93"],
        ["\xE6\xB9\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x94"],
        ["\xE7\x82\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x95"],
        ["\xE7\x9F\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x96"],
        ["\xE7\xAB\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x97"],
        ["\xE7\xAE\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x98"],
        ["\xE7\xB6\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x99"],
        ["\xE8\x80\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x9A"],
        ["\xE8\x83\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x9B"],
        ["\xE8\x9B\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x9C"],
        ["\xE8\xAA\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x9D"],
        ["\xE9\x8D\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x9E"],
        ["\xE5\x9B\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x9F"],
        ["\xE5\xA3\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA0"],
        ["\xE5\xBC\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA1"],
        ["\xE6\x96\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA2"],
        ["\xE6\x9A\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA3"],
        ["\xE6\xAA\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA4"],
        ["\xE6\xAE\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA5"],
        ["\xE7\x94\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA6"],
        ["\xE8\xAB\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA7"],
        ["\xE5\x80\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA8"],
        ["\xE7\x9F\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA9"],
        ["\xE5\x9C\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xAA"],
        ["\xE5\xBC\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xAB"],
        ["\xE6\x81\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xAC"],
        ["\xE6\x99\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xAD"],
        ["\xE6\xB1\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xAE"],
        ["\xE7\x97\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xAF"],
        ["\xE7\xA8\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB0"],
        ["\xE7\xBD\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB1"],
        ["\xE8\x87\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB2"],
        ["\xE8\x9C\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB3"],
        ["\xE9\x81\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB4"],
        ["\xE9\xA6\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB5"],
        ["\xE7\xAF\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB6"],
        ["\xE7\x95\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB7"],
        ["\xE7\xAB\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB8"],
        ["\xE7\xAD\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB9"],
        ["\xE8\x93\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xBA"],
        ["\xE9\x80\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xBB"],
        ["\xE7\xA7\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xBC"],
        ["\xE7\xAA\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xBD"],
        ["\xE8\x8C\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xBE"],
        ["\xE5\xAB\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xBF"],
        ["\xE7\x9D\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x80"],
        ["\xE4\xB8\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x81"],
        ["\xE4\xBB\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x82"],
        ["\xE5\xAE\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x83"],
        ["\xE5\xBF\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x84"],
        ["\xE6\x8A\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x85"],
        ["\xE6\x98\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x86"],
        ["\xE6\x9F\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x87"],
        ["\xE6\xB3\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x88"],
        ["\xE8\x99\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x89"],
        ["\xE8\xA1\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x8A"],
        ["\xE8\xA8\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x8B"],
        ["\xE9\x85\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x8C"],
        ["\xE9\x8B\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x8D"],
        ["\xE9\xA7\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x8E"],
        ["\xE6\xA8\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x8F"],
        ["\xE7\x80\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x90"],
        ["\xE7\x8C\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x91"],
        ["\xE8\x8B\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x92"],
        ["\xE8\x91\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x93"],
        ["\xE8\xB2\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x94"],
        ["\xE4\xB8\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x95"],
        ["\xE5\x85\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x96"],
        ["\xE5\x87\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x97"],
        ["\xE5\x96\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x98"],
        ["\xE5\xAF\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x99"],
        ["\xE5\xB8\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x9A"],
        ["\xE5\xB8\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x9B"],
        ["\xE5\xBA\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x9C"],
        ["\xE5\xBC\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x9D"],
        ["\xE5\xBC\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x9E"],
        ["\xE5\xBD\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x9F"],
        ["\xE5\xBE\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA0"],
        ["\xE6\x87\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA1"],
        ["\xE6\x8C\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA2"],
        ["\xE6\x9A\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA3"],
        ["\xE6\x9C\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA4"],
        ["\xE6\xBD\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA5"],
        ["\xE7\x89\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA6"],
        ["\xE7\x94\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA7"],
        ["\xE7\x9C\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA8"],
        ["\xE8\x81\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA9"],
        ["\xE8\x84\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xAA"],
        ["\xE8\x85\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xAB"],
        ["\xE8\x9D\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xAC"],
        ["\xE8\xAA\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xAD"],
        ["\xE8\xAB\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xAE"],
        ["\xE8\xB6\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xAF"],
        ["\xE8\xB7\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB0"],
        ["\xE9\x8A\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB1"],
        ["\xE9\x95\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB2"],
        ["\xE9\xA0\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB3"],
        ["\xE9\xB3\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB4"],
        ["\xE5\x8B\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB5"],
        ["\xE6\x8D\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB6"],
        ["\xE7\x9B\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB7"],
        ["\xE6\x9C\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB8"],
        ["\xE6\xB2\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB9"],
        ["\xE7\x8F\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xBA"],
        ["\xE8\xB3\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xBB"],
        ["\xE9\x8E\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xBC"],
        ["\xE9\x99\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xBD"],
        ["\xE6\xB4\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xBE"],
        ["\xE5\xA2\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xBF"],
        ["\xE6\xA4\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x80"],
        ["\xE6\xA7\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x81"],
        ["\xE8\xBF\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x82"],
        ["\xE9\x8E\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x83"],
        ["\xE7\x97\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x84"],
        ["\xE9\x80\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x85"],
        ["\xE5\xA1\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x86"],
        ["\xE6\xA0\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x87"],
        ["\xE6\x8E\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x88"],
        ["\xE6\xA7\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x89"],
        ["\xE4\xBD\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x8A"],
        ["\xE6\xBC\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x8B"],
        ["\xE6\x9F\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x8C"],
        ["\xE8\xBE\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x8D"],
        ["\xE8\x94\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x8E"],
        ["\xE7\xB6\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x8F"],
        ["\xE9\x8D\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x90"],
        ["\xE6\xA4\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x91"],
        ["\xE6\xBD\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x92"],
        ["\xE5\x9D\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x93"],
        ["\xE5\xA3\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x94"],
        ["\xE5\xAC\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x95"],
        ["\xE7\xB4\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x96"],
        ["\xE7\x88\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x97"],
        ["\xE5\x90\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x98"],
        ["\xE9\x87\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x99"],
        ["\xE9\xB6\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x9A"],
        ["\xE4\xBA\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x9B"],
        ["\xE4\xBD\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x9C"],
        ["\xE5\x81\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x9D"],
        ["\xE5\x81\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x9E"],
        ["\xE5\x89\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x9F"],
        ["\xE8\xB2\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA0"],
        ["\xE5\x91\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA1"],
        ["\xE5\xA0\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA2"],
        ["\xE5\xAE\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA3"],
        ["\xE5\xB8\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA4"],
        ["\xE5\xBA\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA5"],
        ["\xE5\xBA\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA6"],
        ["\xE5\xBB\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA7"],
        ["\xE5\xBC\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA8"],
        ["\xE6\x82\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA9"],
        ["\xE6\x8A\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xAA"],
        ["\xE6\x8C\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xAB"],
        ["\xE6\x8F\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xAC"],
        ["\xE6\xA2\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xAD"],
        ["\xE6\xB1\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xAE"],
        ["\xE7\xA2\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xAF"],
        ["\xE7\xA6\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB0"],
        ["\xE7\xA8\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB1"],
        ["\xE7\xB7\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB2"],
        ["\xE8\x89\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB3"],
        ["\xE8\xA8\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB4"],
        ["\xE8\xAB\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB5"],
        ["\xE8\xB9\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB6"],
        ["\xE9\x80\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB7"],
        ["\xE9\x82\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB8"],
        ["\xE9\x84\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB9"],
        ["\xE9\x87\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xBA"],
        ["\xE9\xBC\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xBB"],
        ["\xE6\xB3\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xBC"],
        ["\xE6\x91\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xBD"],
        ["\xE6\x93\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xBE"],
        ["\xE6\x95\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xBF"],
        ["\xE6\xBB\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x80"],
        ["\xE7\x9A\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x81"],
        ["\xE7\xAC\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x82"],
        ["\xE9\x81\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x83"],
        ["\xE9\x8F\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x84"],
        ["\xE6\xBA\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x85"],
        ["\xE5\x93\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x86"],
        ["\xE5\xBE\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x87"],
        ["\xE6\x92\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x88"],
        ["\xE8\xBD\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x89"],
        ["\xE8\xBF\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x8A"],
        ["\xE9\x89\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x8B"],
        ["\xE5\x85\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x8C"],
        ["\xE5\xA1\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x8D"],
        ["\xE5\xA4\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x8E"],
        ["\xE5\xB1\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x8F"],
        ["\xE5\xBA\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x90"],
        ["\xE6\xB7\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x91"],
        ["\xE7\xBA\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x92"],
        ["\xE7\x94\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x93"],
        ["\xE8\xB2\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x94"],
        ["\xE8\xBB\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x95"],
        ["\xE9\xA1\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x96"],
        ["\xE7\x82\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x97"],
        ["\xE4\xBC\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x98"],
        ["\xE6\xAE\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x99"],
        ["\xE6\xBE\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x9A"],
        ["\xE7\x94\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x9B"],
        ["\xE9\x9B\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x9C"],
        ["\xE5\x85\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x9D"],
        ["\xE5\x90\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x9E"],
        ["\xE5\xA0\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x9F"],
        ["\xE5\xA1\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA0"],
        ["\xE5\xA6\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA1"],
        ["\xE5\xB1\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA2"],
        ["\xE5\xBE\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA3"],
        ["\xE6\x96\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA4"],
        ["\xE6\x9D\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA5"],
        ["\xE6\xB8\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA6"],
        ["\xE7\x99\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA7"],
        ["\xE8\x8F\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA8"],
        ["\xE8\xB3\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA9"],
        ["\xE9\x80\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xAA"],
        ["\xE9\x83\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xAB"],
        ["\xE9\x8D\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xAC"],
        ["\xE7\xA0\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xAD"],
        ["\xE7\xA0\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xAE"],
        ["\xE5\x8A\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xAF"],
        ["\xE5\xBA\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB0"],
        ["\xE5\x9C\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB1"],
        ["\xE5\xA5\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB2"],
        ["\xE6\x80\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB3"],
        ["\xE5\x80\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB4"],
        ["\xE5\x85\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB5"],
        ["\xE5\x86\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB6"],
        ["\xE5\x87\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB7"],
        ["\xE5\x88\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB8"],
        ["\xE5\x94\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB9"],
        ["\xE5\xA1\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xBA"],
        ["\xE5\xA1\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xBB"],
        ["\xE5\xA5\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xBC"],
        ["\xE5\xAE\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xBD"],
        ["\xE5\xB3\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xBE"],
        ["\xE5\xB6\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xBF"],
        ["\xE6\x82\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x80"],
        ["\xE6\x8A\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x81"],
        ["\xE6\x90\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x82"],
        ["\xE6\x9D\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x83"],
        ["\xE6\xA1\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x84"],
        ["\xE6\xA2\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x85"],
        ["\xE6\xA3\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x86"],
        ["\xE7\x9B\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x87"],
        ["\xE6\xB7\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x88"],
        ["\xE6\xB9\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x89"],
        ["\xE6\xB6\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x8A"],
        ["\xE7\x81\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x8B"],
        ["\xE7\x87\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x8C"],
        ["\xE5\xBD\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x8D"],
        ["\xE7\x97\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x8E"],
        ["\xE7\xA5\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x8F"],
        ["\xE7\xAD\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x90"],
        ["\xE7\xAD\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x91"],
        ["\xE7\xAD\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x92"],
        ["\xE7\xB3\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x93"],
        ["\xE7\xB5\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x94"],
        ["\xE5\x88\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x95"],
        ["\xE8\x91\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x96"],
        ["\xE8\x95\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x97"],
        ["\xE8\x97\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x98"],
        ["\xE8\xA8\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x99"],
        ["\xE8\xAC\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x9A"],
        ["\xE8\xB1\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x9B"],
        ["\xE8\xB8\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x9C"],
        ["\xE9\x80\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x9D"],
        ["\xE9\x80\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x9E"],
        ["\xE9\x90\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x9F"],
        ["\xE9\x99\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA0"],
        ["\xE9\xA0\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA1"],
        ["\xE9\xA8\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA2"],
        ["\xE9\x97\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA3"],
        ["\xE5\x83\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA4"],
        ["\xE5\x8B\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA5"],
        ["\xE5\x90\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA6"],
        ["\xE5\xA0\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA7"],
        ["\xE5\xB0\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA8"],
        ["\xE6\x86\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA9"],
        ["\xE6\x92\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xAA"],
        ["\xE6\xB4\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xAB"],
        ["\xE7\x9E\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xAC"],
        ["\xE7\xAB\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xAD"],
        ["\xE8\x83\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xAE"],
        ["\xE8\x90\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xAF"],
        ["\xE9\x81\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB0"],
        ["\xE9\x8A\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB1"],
        ["\xE5\xB3\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB2"],
        ["\xE9\xB4\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB3"],
        ["\xE5\x8C\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB4"],
        ["\xE5\xBE\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB5"],
        ["\xE5\xBE\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB6"],
        ["\xE6\xB6\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB7"],
        ["\xE7\x89\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB8"],
        ["\xE7\x9D\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB9"],
        ["\xE7\xA6\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xBA"],
        ["\xE7\xAF\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xBB"],
        ["\xE6\xAF\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xBC"],
        ["\xE7\x8B\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xBD"],
        ["\xE8\xAA\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xBE"],
        ["\xE6\xA0\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xBF"],
        ["\xE6\xA9\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x80"],
        ["\xE5\x87\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x81"],
        ["\xE7\xAA\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x82"],
        ["\xE6\xA4\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x83"],
        ["\xE5\xB1\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x84"],
        ["\xE9\xB3\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x85"],
        ["\xE8\x8B\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x86"],
        ["\xE5\xAF\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x87"],
        ["\xE9\x85\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x88"],
        ["\xE7\x80\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x89"],
        ["\xE5\x99\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x8A"],
        ["\xE5\xB1\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x8B"],
        ["\xE6\x83\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x8C"],
        ["\xE6\x95\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x8D"],
        ["\xE6\xB2\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x8E"],
        ["\xE8\xB1\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x8F"],
        ["\xE9\x81\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x90"],
        ["\xE9\xA0\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x91"],
        ["\xE5\x91\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x92"],
        ["\xE6\x9B\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x93"],
        ["\xE9\x88\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x94"],
        ["\xE5\xA5\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x95"],
        ["\xE9\x82\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x96"],
        ["\xE5\x86\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x97"],
        ["\xE4\xB9\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x98"],
        ["\xE5\x87\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x99"],
        ["\xE8\x96\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x9A"],
        ["\xE8\xAC\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x9B"],
        ["\xE7\x81\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x9C"],
        ["\xE6\x8D\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x9D"],
        ["\xE9\x8D\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x9E"],
        ["\xE6\xA5\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x9F"],
        ["\xE9\xA6\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA0"],
        ["\xE7\xB8\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA1"],
        ["\xE7\x95\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA2"],
        ["\xE5\x8D\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA3"],
        ["\xE6\xA5\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA4"],
        ["\xE8\xBB\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA5"],
        ["\xE9\x9B\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA6"],
        ["\xE6\xB1\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA7"],
        ["\xE4\xBA\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA8"],
        ["\xE5\xB0\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA9"],
        ["\xE5\xBC\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xAA"],
        ["\xE8\xBF\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xAB"],
        ["\xE5\x8C\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xAC"],
        ["\xE8\xB3\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xAD"],
        ["\xE8\x82\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xAE"],
        ["\xE8\x99\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xAF"],
        ["\xE5\xBB\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB0"],
        ["\xE6\x97\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB1"],
        ["\xE4\xB9\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB2"],
        ["\xE5\x85\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB3"],
        ["\xE5\xA6\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB4"],
        ["\xE5\xB0\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB5"],
        ["\xE9\x9F\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB6"],
        ["\xE4\xBB\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB7"],
        ["\xE5\xA6\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB8"],
        ["\xE5\xBF\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB9"],
        ["\xE8\xAA\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xBA"],
        ["\xE6\xBF\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xBB"],
        ["\xE7\xA6\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xBC"],
        ["\xE7\xA5\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xBD"],
        ["\xE5\xAF\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xBE"],
        ["\xE8\x91\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xBF"],
        ["\xE7\x8C\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x80"],
        ["\xE7\x86\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x81"],
        ["\xE5\xB9\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x82"],
        ["\xE5\xBF\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x83"],
        ["\xE6\x8D\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x84"],
        ["\xE6\x92\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x85"],
        ["\xE7\x87\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x86"],
        ["\xE7\xB2\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x87"],
        ["\xE4\xB9\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x88"],
        ["\xE5\xBB\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x89"],
        ["\xE4\xB9\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x8A"],
        ["\xE5\x9F\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x8B"],
        ["\xE5\x9A\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x8C"],
        ["\xE6\x82\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x8D"],
        ["\xE6\xBF\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x8E"],
        ["\xE7\xB4\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x8F"],
        ["\xE8\x83\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x90"],
        ["\xE8\x84\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x91"],
        ["\xE8\x86\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x92"],
        ["\xE8\xBE\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x93"],
        ["\xE8\xA6\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x94"],
        ["\xE8\x9A\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x95"],
        ["\xE5\xB7\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x96"],
        ["\xE6\x8A\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x97"],
        ["\xE6\x92\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x98"],
        ["\xE8\xA6\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x99"],
        ["\xE6\x9D\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x9A"],
        ["\xE6\xB3\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x9B"],
        ["\xE6\xB4\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x9C"],
        ["\xE7\x90\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x9D"],
        ["\xE7\xA0\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x9E"],
        ["\xE5\xA9\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x9F"],
        ["\xE7\xBD\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA0"],
        ["\xE8\x8A\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA1"],
        ["\xE9\xA6\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA2"],
        ["\xE4\xBF\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA3"],
        ["\xE5\xBB\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA4"],
        ["\xE6\x8B\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA5"],
        ["\xE6\x8E\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA6"],
        ["\xE6\x95\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA7"],
        ["\xE6\x9D\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA8"],
        ["\xE7\x9B\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA9"],
        ["\xE7\x89\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xAA"],
        ["\xE8\x83\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xAB"],
        ["\xE8\x82\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xAC"],
        ["\xE8\xBC\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xAD"],
        ["\xE9\x85\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xAE"],
        ["\xE5\x80\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xAF"],
        ["\xE5\x9F\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB0"],
        ["\xE5\xAA\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB1"],
        ["\xE6\xA2\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB2"],
        ["\xE6\xA5\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB3"],
        ["\xE7\x85\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB4"],
        ["\xE7\x8B\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB5"],
        ["\xE8\xB2\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB6"],
        ["\xE5\xA3\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB7"],
        ["\xE8\xB3\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB8"],
        ["\xE9\x99\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB9"],
        ["\xE9\x80\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xBA"],
        ["\xE8\x9D\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xBB"],
        ["\xE7\xA7\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xBC"],
        ["\xE7\x9F\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xBD"],
        ["\xE8\x90\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xBE"],
        ["\xE4\xBC\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xBF"],
        ["\xE5\x89\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x80"],
        ["\xE5\x8D\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x81"],
        ["\xE6\x8B\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x82"],
        ["\xE6\x9F\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x83"],
        ["\xE6\xB3\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x84"],
        ["\xE7\x99\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x85"],
        ["\xE7\xAE\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x86"],
        ["\xE7\xB2\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x87"],
        ["\xE8\x88\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x88"],
        ["\xE8\x96\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x89"],
        ["\xE8\xBF\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x8A"],
        ["\xE6\x9B\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x8B"],
        ["\xE6\xBC\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x8C"],
        ["\xE7\x88\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x8D"],
        ["\xE7\xB8\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x8E"],
        ["\xE8\x8E\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x8F"],
        ["\xE9\xA7\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x90"],
        ["\xE9\xBA\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x91"],
        ["\xE5\x87\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x92"],
        ["\xE7\xAE\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x93"],
        ["\xE7\xA1\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x94"],
        ["\xE7\xAE\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x95"],
        ["\xE8\x82\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x96"],
        ["\xE7\xAD\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x97"],
        ["\xE6\xAB\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x98"],
        ["\xE5\xB9\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x99"],
        ["\xE8\x82\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x9A"],
        ["\xE7\x95\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x9B"],
        ["\xE7\x95\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x9C"],
        ["\xE5\x85\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x9D"],
        ["\xE9\x89\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x9E"],
        ["\xE6\xBA\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x9F"],
        ["\xE7\x99\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA0"],
        ["\xE9\x86\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA1"],
        ["\xE9\xAB\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA2"],
        ["\xE4\xBC\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA3"],
        ["\xE7\xBD\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA4"],
        ["\xE6\x8A\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA5"],
        ["\xE7\xAD\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA6"],
        ["\xE9\x96\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA7"],
        ["\xE9\xB3\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA8"],
        ["\xE5\x99\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA9"],
        ["\xE5\xA1\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xAA"],
        ["\xE8\x9B\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xAB"],
        ["\xE9\x9A\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xAC"],
        ["\xE4\xBC\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xAD"],
        ["\xE5\x88\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xAE"],
        ["\xE5\x8D\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xAF"],
        ["\xE5\x8F\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB0"],
        ["\xE5\x8F\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB1"],
        ["\xE5\xB8\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB2"],
        ["\xE6\x90\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB3"],
        ["\xE6\x96\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB4"],
        ["\xE6\x9D\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB5"],
        ["\xE6\xB0\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB6"],
        ["\xE6\xB1\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB7"],
        ["\xE7\x89\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB8"],
        ["\xE7\x8A\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB9"],
        ["\xE7\x8F\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xBA"],
        ["\xE7\x95\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xBB"],
        ["\xE7\xB9\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xBC"],
        ["\xE8\x88\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xBD"],
        ["\xE8\x97\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xBE"],
        ["\xE8\xB2\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xBF"],
        ["\xE7\xAF\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x80"],
        ["\xE9\x87\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x81"],
        ["\xE7\x85\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x82"],
        ["\xE9\xA0\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x83"],
        ["\xE9\xA3\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x84"],
        ["\xE6\x8C\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x85"],
        ["\xE6\x99\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x86"],
        ["\xE7\x95\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x87"],
        ["\xE7\x9B\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x88"],
        ["\xE7\xA3\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x89"],
        ["\xE8\x95\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x8A"],
        ["\xE8\x9B\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x8B"],
        ["\xE5\x8C\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x8C"],
        ["\xE5\x8D\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x8D"],
        ["\xE5\x90\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x8E"],
        ["\xE5\xA6\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x8F"],
        ["\xE5\xBA\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x90"],
        ["\xE5\xBD\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x91"],
        ["\xE6\x82\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x92"],
        ["\xE6\x89\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x93"],
        ["\xE6\x89\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x94"],
        ["\xE6\x8A\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x95"],
        ["\xE6\x96\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x96"],
        ["\xE6\xAF\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x97"],
        ["\xE6\xB3\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x98"],
        ["\xE7\x96\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x99"],
        ["\xE7\x9A\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x9A"],
        ["\xE7\xA2\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x9B"],
        ["\xE7\xA7\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x9C"],
        ["\xE7\xB7\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x9D"],
        ["\xE7\xBD\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x9E"],
        ["\xE8\x82\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x9F"],
        ["\xE8\xA2\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA0"],
        ["\xE8\xAA\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA1"],
        ["\xE8\xB2\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA2"],
        ["\xE9\x81\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA3"],
        ["\xE9\x9D\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA4"],
        ["\xE9\xA3\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA5"],
        ["\xE6\xA8\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA6"],
        ["\xE7\xB0\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA7"],
        ["\xE5\x82\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA8"],
        ["\xE5\xB0\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA9"],
        ["\xE5\xBE\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xAA"],
        ["\xE6\x9E\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xAB"],
        ["\xE6\xAF\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xAC"],
        ["\xE7\x90\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xAD"],
        ["\xE7\x9C\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xAE"],
        ["\xE7\xBE\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xAF"],
        ["\xE9\xBC\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB0"],
        ["\xE6\x9F\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB1"],
        ["\xE7\xA8\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB2"],
        ["\xE5\x8C\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB3"],
        ["\xE7\x96\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB4"],
        ["\xE9\xAB\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB5"],
        ["\xE5\xBD\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB6"],
        ["\xE8\x86\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB7"],
        ["\xE8\x8F\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB8"],
        ["\xE8\x82\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB9"],
        ["\xE5\xBC\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xBA"],
        ["\xE5\xBF\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xBB"],
        ["\xE7\x95\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xBC"],
        ["\xE7\xAD\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xBD"],
        ["\xE9\x80\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xBE"],
        ["\xE6\xA1\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xBF"],
        ["\xE5\xA7\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x80"],
        ["\xE5\xAA\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x81"],
        ["\xE7\xB4\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x82"],
        ["\xE7\x99\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x83"],
        ["\xE8\xAC\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x84"],
        ["\xE4\xBF\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x85"],
        ["\xE5\xBD\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x86"],
        ["\xE6\xA8\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x87"],
        ["\xE6\xB0\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x88"],
        ["\xE6\xBC\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x89"],
        ["\xE7\x93\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x8A"],
        ["\xE7\xA5\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x8B"],
        ["\xE8\xA1\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x8C"],
        ["\xE8\xA9\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x8D"],
        ["\xE8\xB1\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x8E"],
        ["\xE5\xBB\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x8F"],
        ["\xE6\x8F\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x90"],
        ["\xE7\x97\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x91"],
        ["\xE7\xA7\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x92"],
        ["\xE8\x8B\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x93"],
        ["\xE9\x8C\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x94"],
        ["\xE9\x8B\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x95"],
        ["\xE8\x92\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x96"],
        ["\xE8\x9B\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x97"],
        ["\xE9\xB0\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x98"],
        ["\xE5\x93\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x99"],
        ["\xE5\xBD\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x9A"],
        ["\xE6\x96\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x9B"],
        ["\xE6\xB5\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x9C"],
        ["\xE7\x80\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x9D"],
        ["\xE8\xB2\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x9E"],
        ["\xE8\xB3\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x9F"],
        ["\xE9\xA0\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA0"],
        ["\xE6\x95\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA1"],
        ["\xE7\x93\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA2"],
        ["\xE4\xB8\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA3"],
        ["\xE4\xBB\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA4"],
        ["\xE5\x9F\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA5"],
        ["\xE5\xA4\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA6"],
        ["\xE5\xA9\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA7"],
        ["\xE5\xAF\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA8"],
        ["\xE5\x86\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA9"],
        ["\xE5\xB8\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xAA"],
        ["\xE5\xBA\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xAB"],
        ["\xE6\x80\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xAC"],
        ["\xE6\x89\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xAD"],
        ["\xE6\x95\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xAE"],
        ["\xE6\x96\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xAF"],
        ["\xE6\x99\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB0"],
        ["\xE6\xB5\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB1"],
        ["\xE7\x88\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB2"],
        ["\xE7\xAC\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB3"],
        ["\xE8\x85\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB4"],
        ["\xE8\x86\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB5"],
        ["\xE8\x8A\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB6"],
        ["\xE8\xAD\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB7"],
        ["\xE8\xB2\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB8"],
        ["\xE8\xB3\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB9"],
        ["\xE8\xB5\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xBA"],
        ["\xE9\x98\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xBB"],
        ["\xE9\x99\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xBC"],
        ["\xE4\xBE\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xBD"],
        ["\xE6\x92\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xBE"],
        ["\xE6\xAD\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xBF"],
        ["\xE8\x88\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x80"],
        ["\xE8\x91\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x81"],
        ["\xE8\x95\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x82"],
        ["\xE9\x83\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x83"],
        ["\xE5\xB0\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x84"],
        ["\xE6\xA5\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x85"],
        ["\xE9\xA2\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x86"],
        ["\xE8\x91\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x87"],
        ["\xE8\x95\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x88"],
        ["\xE4\xBC\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x89"],
        ["\xE5\x89\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x8A"],
        ["\xE5\xBE\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x8B"],
        ["\xE5\xB9\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x8C"],
        ["\xE6\x9C\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x8D"],
        ["\xE7\xA6\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x8E"],
        ["\xE8\x85\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x8F"],
        ["\xE8\xA4\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x90"],
        ["\xE8\xA6\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x91"],
        ["\xE6\xB7\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x92"],
        ["\xE5\xBC\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x93"],
        ["\xE6\x89\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x94"],
        ["\xE6\xB2\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x95"],
        ["\xE4\xBB\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x96"],
        ["\xE7\x89\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x97"],
        ["\xE9\xAE\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x98"],
        ["\xE5\x88\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x99"],
        ["\xE5\x90\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x9A"],
        ["\xE5\x99\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x9B"],
        ["\xE5\xA2\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x9C"],
        ["\xE6\x86\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x9D"],
        ["\xE6\x89\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x9E"],
        ["\xE7\x84\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x9F"],
        ["\xE5\xA5\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA0"],
        ["\xE7\xB2\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA1"],
        ["\xE7\xB3\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA2"],
        ["\xE7\xB4\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA3"],
        ["\xE9\x9B\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA4"],
        ["\xE6\x96\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA5"],
        ["\xE8\x81\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA6"],
        ["\xE4\xB8\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA7"],
        ["\xE4\xBD\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA8"],
        ["\xE5\x85\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA9"],
        ["\xE5\xA1\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xAA"],
        ["\xE5\xB9\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xAB"],
        ["\xE5\xB9\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xAC"],
        ["\xE5\xBC\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xAD"],
        ["\xE6\x9F\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xAE"],
        ["\xE4\xB8\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xAF"],
        ["\xE8\x94\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB0"],
        ["\xE9\x96\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB1"],
        ["\xE9\x99\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB2"],
        ["\xE7\xB1\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB3"],
        ["\xE9\xA0\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB4"],
        ["\xE5\x83\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB5"],
        ["\xE5\xA3\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB6"],
        ["\xE7\x99\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB7"],
        ["\xE7\xA2\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB8"],
        ["\xE5\x88\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB9"],
        ["\xE7\x9E\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xBA"],
        ["\xE8\x94\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xBB"],
        ["\xE7\xAE\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xBC"],
        ["\xE5\x81\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xBD"],
        ["\xE5\xA4\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xBE"],
        ["\xE7\x89\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xBF"],
        ["\xE7\xAF\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x80"],
        ["\xE7\xB7\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x81"],
        ["\xE8\xBE\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x82"],
        ["\xE8\xBF\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x83"],
        ["\xE9\x81\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x84"],
        ["\xE4\xBE\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x85"],
        ["\xE5\x8B\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x86"],
        ["\xE5\xA8\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x87"],
        ["\xE5\xBC\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x88"],
        ["\xE9\x9E\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x89"],
        ["\xE4\xBF\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x8A"],
        ["\xE8\x88\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x8B"],
        ["\xE9\x8B\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x8C"],
        ["\xE5\x9C\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x8D"],
        ["\xE6\x8D\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x8E"],
        ["\xE6\xAD\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x8F"],
        ["\xE7\x94\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x90"],
        ["\xE8\xA3\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x91"],
        ["\xE8\xBC\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x92"],
        ["\xE7\xA9\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x93"],
        ["\xE5\x8B\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x94"],
        ["\xE5\xA2\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x95"],
        ["\xE6\x85\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x96"],
        ["\xE6\x88\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x97"],
        ["\xE6\x9A\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x98"],
        ["\xE6\xAF\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x99"],
        ["\xE7\xB0\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x9A"],
        ["\xE8\x8F\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x9B"],
        ["\xE5\x80\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x9C"],
        ["\xE4\xBF\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x9D"],
        ["\xE5\x8C\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x9E"],
        ["\xE5\x91\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x9F"],
        ["\xE5\xA0\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA0"],
        ["\xE5\xA5\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA1"],
        ["\xE5\xAE\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA2"],
        ["\xE5\xB3\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA3"],
        ["\xE5\xB3\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA4"],
        ["\xE5\xB4\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA5"],
        ["\xE5\xBA\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA6"],
        ["\xE6\x8A\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA7"],
        ["\xE6\x8D\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA8"],
        ["\xE6\x94\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA9"],
        ["\xE6\x96\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xAA"],
        ["\xE6\x9C\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xAB"],
        ["\xE6\xB3\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xAC"],
        ["\xE6\xB3\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xAD"],
        ["\xE7\x83\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xAE"],
        ["\xE7\xA0\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xAF"],
        ["\xE7\xB8\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB0"],
        ["\xE8\x83\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB1"],
        ["\xE8\x8A\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB2"],
        ["\xE8\x90\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB3"],
        ["\xE8\x93\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB4"],
        ["\xE8\x9C\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB5"],
        ["\xE8\xA4\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB6"],
        ["\xE8\xA8\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB7"],
        ["\xE8\xB1\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB8"],
        ["\xE9\x82\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB9"],
        ["\xE9\x8B\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xBA"],
        ["\xE9\xA3\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xBB"],
        ["\xE9\xB3\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xBC"],
        ["\xE9\xB5\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xBD"],
        ["\xE4\xB9\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xBE"],
        ["\xE4\xBA\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xBF"],
        ["\xE5\x82\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x80"],
        ["\xE5\x89\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x81"],
        ["\xE5\x9D\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x82"],
        ["\xE5\xA6\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x83"],
        ["\xE5\xB8\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x84"],
        ["\xE5\xBF\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x85"],
        ["\xE5\xBF\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x86"],
        ["\xE6\x88\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x87"],
        ["\xE6\x9A\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x88"],
        ["\xE6\x9C\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x89"],
        ["\xE6\x9F\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x8A"],
        ["\xE6\xA3\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x8B"],
        ["\xE5\x86\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x8C"],
        ["\xE7\xB4\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x8D"],
        ["\xE8\x82\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x8E"],
        ["\xE8\x86\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x8F"],
        ["\xE8\xAC\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x90"],
        ["\xE8\xB2\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x91"],
        ["\xE8\xB2\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x92"],
        ["\xE9\x89\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x93"],
        ["\xE9\x98\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x94"],
        ["\xE5\x90\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x95"],
        ["\xE9\xA0\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x96"],
        ["\xE5\x8C\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x97"],
        ["\xE5\x83\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x98"],
        ["\xE5\x8D\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x99"],
        ["\xE5\xA2\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x9A"],
        ["\xE6\x92\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x9B"],
        ["\xE6\x9C\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x9C"],
        ["\xE7\x89\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x9D"],
        ["\xE7\x9D\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x9E"],
        ["\xE7\xA9\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x9F"],
        ["\xE9\x87\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA0"],
        ["\xE5\x8B\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA1"],
        ["\xE6\xB2\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA2"],
        ["\xE6\xAE\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA3"],
        ["\xE5\xA0\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA4"],
        ["\xE5\xB9\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA5"],
        ["\xE5\xA5\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA6"],
        ["\xE6\x9C\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA7"],
        ["\xE7\xBF\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA8"],
        ["\xE5\x87\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA9"],
        ["\xE7\x9B\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xAA"],
        ["\xE6\x91\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xAB"],
        ["\xE7\xA3\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xAC"],
        ["\xE9\xAD\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xAD"],
        ["\xE9\xBA\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xAE"],
        ["\xE5\x9F\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xAF"],
        ["\xE5\xA6\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB0"],
        ["\xE6\x98\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB1"],
        ["\xE6\x9E\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB2"],
        ["\xE6\xAF\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB3"],
        ["\xE5\x93\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB4"],
        ["\xE6\xA7\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB5"],
        ["\xE5\xB9\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB6"],
        ["\xE8\x86\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB7"],
        ["\xE6\x9E\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB8"],
        ["\xE9\xAE\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB9"],
        ["\xE6\x9F\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xBA"],
        ["\xE9\xB1\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xBB"],
        ["\xE6\xA1\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xBC"],
        ["\xE4\xBA\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xBD"],
        ["\xE4\xBF\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xBE"],
        ["\xE5\x8F\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xBF"],
        ["\xE6\x8A\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x80"],
        ["\xE6\x9C\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x81"],
        ["\xE6\xB2\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x82"],
        ["\xE8\xBF\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x83"],
        ["\xE4\xBE\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x84"],
        ["\xE7\xB9\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x85"],
        ["\xE9\xBA\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x86"],
        ["\xE4\xB8\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x87"],
        ["\xE6\x85\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x88"],
        ["\xE6\xBA\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x89"],
        ["\xE6\xBC\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x8A"],
        ["\xE8\x94\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x8B"],
        ["\xE5\x91\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x8C"],
        ["\xE6\x9C\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x8D"],
        ["\xE9\xAD\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x8E"],
        ["\xE5\xB7\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x8F"],
        ["\xE7\xAE\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x90"],
        ["\xE5\xB2\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x91"],
        ["\xE5\xAF\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x92"],
        ["\xE8\x9C\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x93"],
        ["\xE6\xB9\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x94"],
        ["\xE8\x93\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x95"],
        ["\xE7\xA8\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x96"],
        ["\xE8\x84\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x97"],
        ["\xE5\xA6\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x98"],
        ["\xE7\xB2\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x99"],
        ["\xE6\xB0\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x9A"],
        ["\xE7\x9C\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x9B"],
        ["\xE5\x8B\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x9C"],
        ["\xE5\xA4\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x9D"],
        ["\xE7\x84\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x9E"],
        ["\xE7\x89\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x9F"],
        ["\xE7\x9F\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA0"],
        ["\xE9\x9C\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA1"],
        ["\xE9\xB5\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA2"],
        ["\xE6\xA4\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA3"],
        ["\xE5\xA9\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA4"],
        ["\xE5\xA8\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA5"],
        ["\xE5\x86\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA6"],
        ["\xE5\x90\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA7"],
        ["\xE5\x91\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA8"],
        ["\xE6\x98\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA9"],
        ["\xE7\x9B\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xAA"],
        ["\xE8\xBF\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xAB"],
        ["\xE9\x8A\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xAC"],
        ["\xE9\xB3\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xAD"],
        ["\xE5\xA7\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xAE"],
        ["\xE7\x89\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xAF"],
        ["\xE6\xBB\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB0"],
        ["\xE5\x85\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB1"],
        ["\xE6\xA3\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB2"],
        ["\xE7\xB6\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB3"],
        ["\xE7\xB7\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB4"],
        ["\xE9\x9D\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB5"],
        ["\xE9\xBA\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB6"],
        ["\xE6\x91\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB7"],
        ["\xE6\xA8\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB8"],
        ["\xE8\x8C\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB9"],
        ["\xE5\xA6\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xBA"],
        ["\xE5\xAD\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xBB"],
        ["\xE6\xAF\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xBC"],
        ["\xE7\x8C\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xBD"],
        ["\xE7\x9B\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xBE"],
        ["\xE7\xB6\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xBF"],
        ["\xE8\x80\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x80"],
        ["\xE8\x92\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x81"],
        ["\xE5\x84\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x82"],
        ["\xE6\x9C\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x83"],
        ["\xE9\xBB\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x84"],
        ["\xE7\x9B\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x85"],
        ["\xE6\x9D\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x86"],
        ["\xE5\x8B\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x87"],
        ["\xE9\xA4\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x88"],
        ["\xE5\xB0\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x89"],
        ["\xE6\x88\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x8A"],
        ["\xE7\xB1\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x8B"],
        ["\xE8\xB2\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x8C"],
        ["\xE5\x95\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x8D"],
        ["\xE6\x82\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x8E"],
        ["\xE7\xB4\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x8F"],
        ["\xE9\x96\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x90"],
        ["\xE5\x8C\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x91"],
        ["\xE4\xB9\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x92"],
        ["\xE5\x86\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x93"],
        ["\xE5\xA4\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x94"],
        ["\xE7\x88\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x95"],
        ["\xE8\x80\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x96"],
        ["\xE9\x87\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x97"],
        ["\xE5\xBC\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x98"],
        ["\xE7\x9F\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x99"],
        ["\xE5\x8E\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x9A"],
        ["\xE5\xBD\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x9B"],
        ["\xE7\xB4\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x9C"],
        ["\xE8\x96\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x9D"],
        ["\xE8\xA8\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x9E"],
        ["\xE8\xBA\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x9F"],
        ["\xE9\x9D\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA0"],
        ["\xE6\x9F\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA1"],
        ["\xE8\x96\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA2"],
        ["\xE9\x91\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA3"],
        ["\xE6\x84\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA4"],
        ["\xE6\x84\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA5"],
        ["\xE6\xB2\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA6"],
        ["\xE7\x99\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA7"],
        ["\xE8\xAB\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA8"],
        ["\xE8\xBC\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA9"],
        ["\xE5\x94\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xAA"],
        ["\xE4\xBD\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xAB"],
        ["\xE5\x84\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xAC"],
        ["\xE5\x8B\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xAD"],
        ["\xE5\x8F\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xAE"],
        ["\xE5\xAE\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xAF"],
        ["\xE5\xB9\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB0"],
        ["\xE6\x82\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB1"],
        ["\xE6\x86\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB2"],
        ["\xE6\x8F\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB3"],
        ["\xE6\x9C\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB4"],
        ["\xE6\x9F\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB5"],
        ["\xE6\xB9\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB6"],
        ["\xE6\xB6\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB7"],
        ["\xE7\x8C\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB8"],
        ["\xE7\x8C\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB9"],
        ["\xE7\x94\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xBA"],
        ["\xE7\xA5\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xBB"],
        ["\xE8\xA3\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xBC"],
        ["\xE8\xAA\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xBD"],
        ["\xE9\x81\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xBE"],
        ["\xE9\x82\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xBF"],
        ["\xE9\x83\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x80"],
        ["\xE9\x9B\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x81"],
        ["\xE8\x9E\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x82"],
        ["\xE5\xA4\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x83"],
        ["\xE4\xBA\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x84"],
        ["\xE4\xBD\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x85"],
        ["\xE4\xB8\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x86"],
        ["\xE8\xAA\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x87"],
        ["\xE8\xBC\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x88"],
        ["\xE9\xA0\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x89"],
        ["\xE5\x82\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x8A"],
        ["\xE5\xB9\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x8B"],
        ["\xE5\xA6\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x8C"],
        ["\xE5\xAE\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x8D"],
        ["\xE5\xBA\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x8E"],
        ["\xE6\x8F\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x8F"],
        ["\xE6\x8F\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x90"],
        ["\xE6\x93\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x91"],
        ["\xE6\x9B\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x92"],
        ["\xE6\xA5\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x93"],
        ["\xE6\xA7\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x94"],
        ["\xE6\xB4\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x95"],
        ["\xE6\xBA\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x96"],
        ["\xE7\x86\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x97"],
        ["\xE7\x94\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x98"],
        ["\xE7\xAA\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x99"],
        ["\xE7\xBE\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x9A"],
        ["\xE8\x80\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x9B"],
        ["\xE8\x91\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x9C"],
        ["\xE8\x93\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x9D"],
        ["\xE8\xA6\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x9E"],
        ["\xE8\xAC\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x9F"],
        ["\xE8\xB8\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA0"],
        ["\xE9\x81\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA1"],
        ["\xE9\x99\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA2"],
        ["\xE9\xA4\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA3"],
        ["\xE6\x85\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA4"],
        ["\xE6\x8A\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA5"],
        ["\xE6\xAC\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA6"],
        ["\xE6\xB2\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA7"],
        ["\xE6\xB5\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA8"],
        ["\xE7\xBF\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA9"],
        ["\xE7\xBF\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xAA"],
        ["\xE6\xB7\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xAB"],
        ["\xE7\xBE\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xAC"],
        ["\xE8\x9E\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xAD"],
        ["\xE8\xA3\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xAE"],
        ["\xE6\x9D\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xAF"],
        ["\xE8\x8E\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB0"],
        ["\xE9\xA0\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB1"],
        ["\xE9\x9B\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB2"],
        ["\xE6\xB4\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB3"],
        ["\xE7\xB5\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB4"],
        ["\xE8\x90\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB5"],
        ["\xE9\x85\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB6"],
        ["\xE4\xB9\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB7"],
        ["\xE5\x8D\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB8"],
        ["\xE5\xB5\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB9"],
        ["\xE6\xAC\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xBA"],
        ["\xE6\xBF\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xBB"],
        ["\xE8\x97\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xBC"],
        ["\xE8\x98\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xBD"],
        ["\xE8\xA6\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xBE"],
        ["\xE5\x88\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xBF"],
        ["\xE5\x90\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x80"],
        ["\xE5\xB1\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x81"],
        ["\xE6\x9D\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x82"],
        ["\xE6\xA2\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x83"],
        ["\xE7\x90\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x84"],
        ["\xE7\x92\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x85"],
        ["\xE7\x97\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x86"],
        ["\xE8\xA3\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x87"],
        ["\xE8\xA3\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x88"],
        ["\xE9\x87\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x89"],
        ["\xE9\x9B\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x8A"],
        ["\xE9\x99\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x8B"],
        ["\xE5\xBE\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x8C"],
        ["\xE7\x8E\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x8D"],
        ["\xE7\xAB\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x8E"],
        ["\xE8\x91\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x8F"],
        ["\xE6\x8E\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x90"],
        ["\xE7\x95\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x91"],
        ["\xE5\x8A\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x92"],
        ["\xE6\xB5\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x93"],
        ["\xE6\xBA\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x94"],
        ["\xE7\x90\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x95"],
        ["\xE7\x95\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x96"],
        ["\xE7\xA1\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x97"],
        ["\xE7\xB2\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x98"],
        ["\xE9\x9A\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x99"],
        ["\xE7\xAB\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x9A"],
        ["\xE9\xBE\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x9B"],
        ["\xE4\xBE\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x9C"],
        ["\xE6\x85\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x9D"],
        ["\xE6\x97\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x9E"],
        ["\xE8\x99\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x9F"],
        ["\xE4\xBA\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA0"],
        ["\xE4\xBA\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA1"],
        ["\xE5\x83\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA2"],
        ["\xE4\xB8\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA3"],
        ["\xE5\x87\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA4"],
        ["\xE5\xAF\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA5"],
        ["\xE6\x96\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA6"],
        ["\xE6\xA2\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA7"],
        ["\xE6\xB6\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA8"],
        ["\xE7\x8C\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA9"],
        ["\xE7\x99\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xAA"],
        ["\xE7\x9E\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xAB"],
        ["\xE7\xA8\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xAC"],
        ["\xE7\xB3\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xAD"],
        ["\xE8\x89\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xAE"],
        ["\xE8\xAB\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xAF"],
        ["\xE9\x81\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB0"],
        ["\xE9\x87\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB1"],
        ["\xE9\x99\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB2"],
        ["\xE9\xA0\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB3"],
        ["\xE5\x8A\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB4"],
        ["\xE7\xB7\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB5"],
        ["\xE5\x80\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB6"],
        ["\xE5\x8E\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB7"],
        ["\xE6\x9E\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB8"],
        ["\xE6\xB7\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB9"],
        ["\xE7\x87\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xBA"],
        ["\xE7\x90\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xBB"],
        ["\xE8\x87\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xBC"],
        ["\xE8\xBC\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xBD"],
        ["\xE9\x9A\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xBE"],
        ["\xE9\xB1\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xBF"],
        ["\xE9\xBA\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x80"],
        ["\xE7\x91\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x81"],
        ["\xE5\xA1\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x82"],
        ["\xE6\xB6\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x83"],
        ["\xE7\xB4\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x84"],
        ["\xE9\xA1\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x85"],
        ["\xE4\xBB\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x86"],
        ["\xE4\xBC\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x87"],
        ["\xE4\xBE\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x88"],
        ["\xE5\x86\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x89"],
        ["\xE5\x8A\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x8A"],
        ["\xE5\xB6\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x8B"],
        ["\xE6\x80\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x8C"],
        ["\xE7\x8E\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x8D"],
        ["\xE7\xA4\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x8E"],
        ["\xE8\x8B\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x8F"],
        ["\xE9\x88\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x90"],
        ["\xE9\x9A\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x91"],
        ["\xE9\x9B\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x92"],
        ["\xE9\x9C\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x93"],
        ["\xE9\xBA\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x94"],
        ["\xE9\xBD\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x95"],
        ["\xE6\x9A\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x96"],
        ["\xE6\xAD\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x97"],
        ["\xE5\x88\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x98"],
        ["\xE5\x8A\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x99"],
        ["\xE7\x83\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x9A"],
        ["\xE8\xA3\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x9B"],
        ["\xE5\xBB\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x9C"],
        ["\xE6\x81\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x9D"],
        ["\xE6\x86\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x9E"],
        ["\xE6\xBC\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x9F"],
        ["\xE7\x85\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA0"],
        ["\xE7\xB0\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA1"],
        ["\xE7\xB7\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA2"],
        ["\xE8\x81\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA3"],
        ["\xE8\x93\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA4"],
        ["\xE9\x80\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA5"],
        ["\xE9\x8C\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA6"],
        ["\xE5\x91\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA7"],
        ["\xE9\xAD\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA8"],
        ["\xE6\xAB\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA9"],
        ["\xE7\x82\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xAA"],
        ["\xE8\xB3\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xAB"],
        ["\xE8\xB7\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xAC"],
        ["\xE9\x9C\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xAD"],
        ["\xE5\x8A\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xAE"],
        ["\xE5\xA9\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xAF"],
        ["\xE5\xBB\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB0"],
        ["\xE5\xBC\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB1"],
        ["\xE6\x9C\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB2"],
        ["\xE6\xA5\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB3"],
        ["\xE6\xA6\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB4"],
        ["\xE6\xB5\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB5"],
        ["\xE6\xBC\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB6"],
        ["\xE7\x89\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB7"],
        ["\xE7\x8B\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB8"],
        ["\xE7\xAF\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB9"],
        ["\xE8\x80\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xBA"],
        ["\xE8\x81\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xBB"],
        ["\xE8\x9D\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xBC"],
        ["\xE9\x83\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xBD"],
        ["\xE5\x85\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xBE"],
        ["\xE9\xBA\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xBF"],
        ["\xE7\xA6\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x80"],
        ["\xE8\x82\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x81"],
        ["\xE9\x8C\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x82"],
        ["\xE8\xAB\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x83"],
        ["\xE5\x80\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x84"],
        ["\xE5\x92\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x85"],
        ["\xE8\xA9\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x86"],
        ["\xE6\xAD\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x87"],
        ["\xE8\xB3\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x88"],
        ["\xE8\x84\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x89"],
        ["\xE6\x83\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x8A"],
        ["\xE6\x9E\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x8B"],
        ["\xE9\xB7\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x8C"],
        ["\xE4\xBA\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x8D"],
        ["\xE4\xBA\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x8E"],
        ["\xE9\xB0\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x8F"],
        ["\xE8\xA9\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x90"],
        ["\xE8\x97\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x91"],
        ["\xE8\x95\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x92"],
        ["\xE6\xA4\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x93"],
        ["\xE6\xB9\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x94"],
        ["\xE7\xA2\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x95"],
        ["\xE8\x85\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x96"],
        ["\xE5\xBC\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x82"],
        ["\xE4\xB8\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x83"],
        ["\xE4\xB8\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x84"],
        ["\xE4\xB8\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x85"],
        ["\xE4\xB8\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x86"],
        ["\xE4\xB8\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x87"],
        ["\xE4\xB8\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x88"],
        ["\xE4\xB8\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x89"],
        ["\xE4\xB9\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x8A"],
        ["\xE4\xB9\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x8B"],
        ["\xE4\xB9\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x8C"],
        ["\xE4\xBA\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x8D"],
        ["\xE4\xBA\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x8E"],
        ["\xE8\xB1\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x8F"],
        ["\xE4\xBA\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x90"],
        ["\xE8\x88\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x91"],
        ["\xE5\xBC\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x92"],
        ["\xE4\xBA\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x93"],
        ["\xE4\xBA\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x94"],
        ["\xE4\xBA\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x95"],
        ["\xE4\xBA\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x96"],
        ["\xE4\xBA\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x97"],
        ["\xE4\xBA\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x98"],
        ["\xE4\xBA\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x99"],
        ["\xE4\xBA\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x9A"],
        ["\xE4\xBB\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x9B"],
        ["\xE4\xBB\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x9C"],
        ["\xE4\xBB\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x9D"],
        ["\xE4\xBB\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x9E"],
        ["\xE4\xBB\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x9F"],
        ["\xE4\xBB\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA0"],
        ["\xE4\xBB\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA1"],
        ["\xE4\xBB\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA2"],
        ["\xE4\xBB\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA3"],
        ["\xE4\xBB\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA4"],
        ["\xE4\xBC\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA5"],
        ["\xE4\xBD\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA6"],
        ["\xE4\xBC\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA7"],
        ["\xE4\xBD\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA8"],
        ["\xE4\xBD\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA9"],
        ["\xE4\xBD\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xAA"],
        ["\xE4\xBD\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xAB"],
        ["\xE4\xBD\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xAC"],
        ["\xE4\xBE\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xAD"],
        ["\xE4\xBE\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xAE"],
        ["\xE4\xBE\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xAF"],
        ["\xE4\xBD\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB0"],
        ["\xE4\xBD\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB1"],
        ["\xE4\xBD\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB2"],
        ["\xE4\xBE\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB3"],
        ["\xE4\xBD\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB4"],
        ["\xE4\xBE\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB5"],
        ["\xE4\xBE\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB6"],
        ["\xE5\x84\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB7"],
        ["\xE4\xBF\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB8"],
        ["\xE4\xBF\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB9"],
        ["\xE4\xBF\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xBA"],
        ["\xE4\xBF\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xBB"],
        ["\xE4\xBF\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xBC"],
        ["\xE4\xBF\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xBD"],
        ["\xE4\xBF\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xBE"],
        ["\xE4\xBF\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xBF"],
        ["\xE4\xBF\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x80"],
        ["\xE4\xBF\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x81"],
        ["\xE5\x80\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x82"],
        ["\xE5\x80\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x83"],
        ["\xE5\x80\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x84"],
        ["\xE5\x80\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x85"],
        ["\xE5\x80\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x86"],
        ["\xE5\x80\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x87"],
        ["\xE4\xBC\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x88"],
        ["\xE4\xBF\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x89"],
        ["\xE5\x80\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x8A"],
        ["\xE5\x80\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x8B"],
        ["\xE5\x80\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x8C"],
        ["\xE4\xBF\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x8D"],
        ["\xE4\xBF\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x8E"],
        ["\xE5\x80\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x8F"],
        ["\xE5\x80\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x90"],
        ["\xE5\x81\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x91"],
        ["\xE5\x81\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x92"],
        ["\xE6\x9C\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x93"],
        ["\xE5\x81\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x94"],
        ["\xE5\x81\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x95"],
        ["\xE5\x81\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x96"],
        ["\xE5\x81\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x97"],
        ["\xE5\x81\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x98"],
        ["\xE5\x81\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x99"],
        ["\xE5\x81\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x9A"],
        ["\xE5\x82\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x9B"],
        ["\xE5\x82\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x9C"],
        ["\xE5\x82\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x9D"],
        ["\xE5\x82\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x9E"],
        ["\xE5\x82\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x9F"],
        ["\xE5\x83\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA0"],
        ["\xE5\x83\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA1"],
        ["\xE5\x82\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA2"],
        ["\xE5\x83\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA3"],
        ["\xE5\x83\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA4"],
        ["\xE5\x83\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA5"],
        ["\xE5\x83\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA6"],
        ["\xE5\x83\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA7"],
        ["\xE5\x83\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA8"],
        ["\xE5\x83\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA9"],
        ["\xE5\x83\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xAA"],
        ["\xE5\x83\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xAB"],
        ["\xE5\x84\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xAC"],
        ["\xE5\x84\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xAD"],
        ["\xE5\x84\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xAE"],
        ["\xE5\x84\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xAF"],
        ["\xE5\x84\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB0"],
        ["\xE5\x84\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB1"],
        ["\xE5\x84\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB2"],
        ["\xE5\x84\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB3"],
        ["\xE5\x84\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB4"],
        ["\xE5\x84\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB5"],
        ["\xE5\x84\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB6"],
        ["\xE5\x84\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB7"],
        ["\xE5\x84\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB8"],
        ["\xE5\x85\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB9"],
        ["\xE5\x85\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xBA"],
        ["\xE5\x85\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xBB"],
        ["\xE5\x85\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xBC"],
        ["\xE5\x85\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xBD"],
        ["\xE7\xAB\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xBE"],
        ["\xE5\x85\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xBF"],
        ["\xE5\x85\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x80"],
        ["\xE5\x85\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x81"],
        ["\xE5\x86\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x82"],
        ["\xE5\x86\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x83"],
        ["\xE5\x9B\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x84"],
        ["\xE5\x86\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x85"],
        ["\xE5\x86\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x86"],
        ["\xE5\x86\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x87"],
        ["\xE5\x86\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x88"],
        ["\xE5\x86\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x89"],
        ["\xE5\x86\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x8A"],
        ["\xE5\x86\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x8B"],
        ["\xE5\x86\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x8C"],
        ["\xE5\x86\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x8D"],
        ["\xE5\x86\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x8E"],
        ["\xE5\x86\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x8F"],
        ["\xE5\x86\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x90"],
        ["\xE5\x86\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x91"],
        ["\xE5\x86\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x92"],
        ["\xE5\x86\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x93"],
        ["\xE5\x86\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x94"],
        ["\xE5\x86\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x95"],
        ["\xE5\x86\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x96"],
        ["\xE5\x86\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x97"],
        ["\xE5\x87\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x98"],
        ["\xE5\x87\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x99"],
        ["\xE5\x87\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x9A"],
        ["\xE5\x87\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x9B"],
        ["\xE8\x99\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x9C"],
        ["\xE5\x87\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x9D"],
        ["\xE5\x87\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x9E"],
        ["\xE5\x87\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x9F"],
        ["\xE5\x87\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA0"],
        ["\xE5\x87\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA1"],
        ["\xE5\x88\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA2"],
        ["\xE5\x88\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA3"],
        ["\xE5\x88\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA4"],
        ["\xE5\x88\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA5"],
        ["\xE5\x88\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA6"],
        ["\xE5\x88\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA7"],
        ["\xE5\x88\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA8"],
        ["\xE5\x88\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA9"],
        ["\xE5\x88\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xAA"],
        ["\xE5\x89\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xAB"],
        ["\xE5\x89\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xAC"],
        ["\xE5\x89\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xAD"],
        ["\xE5\x89\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xAE"],
        ["\xE5\x89\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xAF"],
        ["\xE5\x89\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB0"],
        ["\xE5\x89\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB1"],
        ["\xE5\x89\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB2"],
        ["\xE5\x89\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB3"],
        ["\xE5\x89\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB4"],
        ["\xE5\x89\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB5"],
        ["\xE5\x89\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB6"],
        ["\xE5\x8A\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB7"],
        ["\xE5\x8A\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB8"],
        ["\xE5\x8A\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB9"],
        ["\xE5\x89\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xBA"],
        ["\xE5\x8A\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xBB"],
        ["\xE5\x8A\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xBC"],
        ["\xE8\xBE\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xBD"],
        ["\xE8\xBE\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xBE"],
        ["\xE5\x8A\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xBF"],
        ["\xE5\x8A\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x80"],
        ["\xE5\x8A\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x81"],
        ["\xE5\x8A\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x82"],
        ["\xE5\x8B\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x83"],
        ["\xE5\x8B\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x84"],
        ["\xE5\x8B\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x85"],
        ["\xE5\x8B\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x86"],
        ["\xE5\x8B\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x87"],
        ["\xE5\x8B\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x88"],
        ["\xE9\xA3\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x89"],
        ["\xE5\x8B\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x8A"],
        ["\xE5\x8B\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x8B"],
        ["\xE5\x8B\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x8C"],
        ["\xE5\x8B\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x8D"],
        ["\xE5\x8B\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x8E"],
        ["\xE5\x8C\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x8F"],
        ["\xE5\x8C\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x90"],
        ["\xE7\x94\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x91"],
        ["\xE5\x8C\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x92"],
        ["\xE5\x8C\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x93"],
        ["\xE5\x8C\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x94"],
        ["\xE5\x8C\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x95"],
        ["\xE5\x8C\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x96"],
        ["\xE5\x8C\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x97"],
        ["\xE5\x8C\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x98"],
        ["\xE5\x8C\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x99"],
        ["\xE5\x8C\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x9A"],
        ["\xE5\x8C\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x9B"],
        ["\xE5\x8D\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x9C"],
        ["\xE5\x8D\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x9D"],
        ["\xE5\x8D\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x9E"],
        ["\xE4\xB8\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x9F"],
        ["\xE5\x8D\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA0"],
        ["\xE5\x8D\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA1"],
        ["\xE5\x87\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA2"],
        ["\xE5\x8D\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA3"],
        ["\xE5\x8D\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA4"],
        ["\xE5\x8D\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA5"],
        ["\xE5\xA4\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA6"],
        ["\xE5\x8D\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA7"],
        ["\xE5\x8D\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA8"],
        ["\xE5\x8E\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA9"],
        ["\xE5\x8E\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xAA"],
        ["\xE5\x8E\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xAB"],
        ["\xE5\x8E\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xAC"],
        ["\xE5\x8E\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xAD"],
        ["\xE5\x8E\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xAE"],
        ["\xE5\x8E\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xAF"],
        ["\xE5\x8E\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB0"],
        ["\xE5\x8F\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB1"],
        ["\xE7\xB0\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB2"],
        ["\xE9\x9B\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB3"],
        ["\xE5\x8F\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB4"],
        ["\xE6\x9B\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB5"],
        ["\xE7\x87\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB6"],
        ["\xE5\x8F\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB7"],
        ["\xE5\x8F\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB8"],
        ["\xE5\x8F\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB9"],
        ["\xE5\x8F\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xBA"],
        ["\xE5\x90\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xBB"],
        ["\xE5\x90\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xBC"],
        ["\xE5\x91\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xBD"],
        ["\xE5\x90\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xBE"],
        ["\xE5\x90\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xBF"],
        ["\xE5\x90\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x80"],
        ["\xE5\x90\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x81"],
        ["\xE5\x90\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x82"],
        ["\xE5\x90\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x83"],
        ["\xE5\x90\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x84"],
        ["\xE5\x91\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x85"],
        ["\xE5\x92\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x86"],
        ["\xE5\x91\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x87"],
        ["\xE5\x92\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x88"],
        ["\xE5\x91\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x89"],
        ["\xE5\x91\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x8A"],
        ["\xE5\x91\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x8B"],
        ["\xE5\x91\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x8C"],
        ["\xE5\x92\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x8D"],
        ["\xE5\x91\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x8E"],
        ["\xE5\x92\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x8F"],
        ["\xE5\x91\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x90"],
        ["\xE5\x92\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x91"],
        ["\xE5\x92\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x92"],
        ["\xE5\x92\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x93"],
        ["\xE5\x93\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x94"],
        ["\xE5\x92\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x95"],
        ["\xE5\x92\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x96"],
        ["\xE5\x92\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x97"],
        ["\xE5\x92\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x98"],
        ["\xE5\x93\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x99"],
        ["\xE5\x93\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x9A"],
        ["\xE5\x92\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x9B"],
        ["\xE5\x92\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x9C"],
        ["\xE5\x93\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x9D"],
        ["\xE5\x92\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x9E"],
        ["\xE5\x92\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x9F"],
        ["\xE5\x92\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA0"],
        ["\xE5\x93\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA1"],
        ["\xE5\x93\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA2"],
        ["\xE5\x93\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA3"],
        ["\xE5\x94\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA4"],
        ["\xE5\x94\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA5"],
        ["\xE5\x93\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA6"],
        ["\xE5\x93\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA7"],
        ["\xE5\x93\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA8"],
        ["\xE5\x93\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA9"],
        ["\xE5\x93\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xAA"],
        ["\xE5\x94\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xAB"],
        ["\xE5\x95\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xAC"],
        ["\xE5\x95\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xAD"],
        ["\xE5\x95\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xAE"],
        ["\xE5\x94\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xAF"],
        ["\xE5\x95\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB0"],
        ["\xE5\x95\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB1"],
        ["\xE5\x95\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB2"],
        ["\xE5\x95\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB3"],
        ["\xE5\x94\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB4"],
        ["\xE5\x94\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB5"],
        ["\xE5\x95\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB6"],
        ["\xE5\x96\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB7"],
        ["\xE5\x96\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB8"],
        ["\xE5\x92\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB9"],
        ["\xE5\x96\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xBA"],
        ["\xE5\x96\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xBB"],
        ["\xE5\x95\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xBC"],
        ["\xE5\x95\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xBD"],
        ["\xE5\x96\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xBE"],
        ["\xE5\x96\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xBF"],
        ["\xE5\x96\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x80"],
        ["\xE5\x95\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x81"],
        ["\xE5\x96\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x82"],
        ["\xE5\x96\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x83"],
        ["\xE5\x96\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x84"],
        ["\xE5\x96\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x85"],
        ["\xE5\x97\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x86"],
        ["\xE5\x97\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x87"],
        ["\xE5\x97\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x88"],
        ["\xE5\x97\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x89"],
        ["\xE5\x97\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x8A"],
        ["\xE5\x97\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x8B"],
        ["\xE5\x97\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x8C"],
        ["\xE5\x98\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x8D"],
        ["\xE5\x97\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x8E"],
        ["\xE5\x98\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x8F"],
        ["\xE5\x97\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x90"],
        ["\xE5\x97\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x91"],
        ["\xE5\x98\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x92"],
        ["\xE5\x97\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x93"],
        ["\xE5\x99\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x94"],
        ["\xE5\x99\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x95"],
        ["\xE7\x87\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x96"],
        ["\xE5\x98\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x97"],
        ["\xE5\x98\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x98"],
        ["\xE5\x98\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x99"],
        ["\xE5\x98\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x9A"],
        ["\xE5\x99\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x9B"],
        ["\xE5\x99\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x9C"],
        ["\xE5\x98\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x9D"],
        ["\xE5\x99\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x9E"],
        ["\xE5\x99\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x9F"],
        ["\xE5\x9A\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA0"],
        ["\xE5\x9A\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA1"],
        ["\xE5\x9A\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA2"],
        ["\xE5\x9A\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA3"],
        ["\xE5\x9A\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA4"],
        ["\xE5\x9A\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA5"],
        ["\xE5\x9A\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA6"],
        ["\xE5\x9A\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA7"],
        ["\xE5\x9A\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA8"],
        ["\xE5\x9A\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA9"],
        ["\xE5\x9B\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xAA"],
        ["\xE5\x9A\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xAB"],
        ["\xE5\x9B\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xAC"],
        ["\xE5\x9B\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xAD"],
        ["\xE5\x9B\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xAE"],
        ["\xE5\x9B\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xAF"],
        ["\xE5\x9B\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB0"],
        ["\xE5\x9B\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB1"],
        ["\xE5\x9B\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB2"],
        ["\xE5\x9B\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB3"],
        ["\xE5\x9B\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB4"],
        ["\xE5\x9B\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB5"],
        ["\xE5\x9C\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB6"],
        ["\xE5\x9B\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB7"],
        ["\xE5\x9C\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB8"],
        ["\xE5\x9C\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB9"],
        ["\xE5\x9C\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xBA"],
        ["\xE5\x9C\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xBB"],
        ["\xE5\x9C\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xBC"],
        ["\xE5\x9C\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xBD"],
        ["\xE5\x9C\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xBE"],
        ["\xE5\x9C\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xBF"],
        ["\xE5\x97\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x80"],
        ["\xE5\x9C\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x81"],
        ["\xE5\x9C\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x82"],
        ["\xE5\x9C\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x83"],
        ["\xE5\x9C\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x84"],
        ["\xE5\x9D\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x85"],
        ["\xE5\x9C\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x86"],
        ["\xE5\x9D\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x87"],
        ["\xE5\x9D\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x88"],
        ["\xE5\x9D\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x89"],
        ["\xE5\x9F\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x8A"],
        ["\xE5\x9E\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x8B"],
        ["\xE5\x9D\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x8C"],
        ["\xE5\x9D\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x8D"],
        ["\xE5\x9E\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x8E"],
        ["\xE5\x9E\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x8F"],
        ["\xE5\x9E\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x90"],
        ["\xE5\x9E\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x91"],
        ["\xE5\x9E\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x92"],
        ["\xE5\x9E\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x93"],
        ["\xE5\x9E\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x94"],
        ["\xE5\x9F\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x95"],
        ["\xE5\x9F\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x96"],
        ["\xE5\x9F\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x97"],
        ["\xE5\x9F\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x98"],
        ["\xE5\x9F\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x99"],
        ["\xE5\xA0\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x9A"],
        ["\xE5\x9F\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x9B"],
        ["\xE5\x9F\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x9C"],
        ["\xE5\xA0\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x9D"],
        ["\xE5\xA0\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x9E"],
        ["\xE5\xA0\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x9F"],
        ["\xE5\xA1\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA0"],
        ["\xE5\xA0\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA1"],
        ["\xE5\xA1\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA2"],
        ["\xE5\xA1\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA3"],
        ["\xE5\xA1\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA4"],
        ["\xE6\xAF\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA5"],
        ["\xE5\xA1\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA6"],
        ["\xE5\xA0\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA7"],
        ["\xE5\xA1\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA8"],
        ["\xE5\xA2\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA9"],
        ["\xE5\xA2\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xAA"],
        ["\xE5\xA2\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xAB"],
        ["\xE5\xA2\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xAC"],
        ["\xE5\xA2\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xAD"],
        ["\xE5\xA3\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xAE"],
        ["\xE5\xA2\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xAF"],
        ["\xE5\xA2\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB0"],
        ["\xE5\xA2\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB1"],
        ["\xE5\xA3\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB2"],
        ["\xE5\xA3\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB3"],
        ["\xE5\xA3\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB4"],
        ["\xE5\xA3\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB5"],
        ["\xE5\xA3\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB6"],
        ["\xE5\xA3\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB7"],
        ["\xE5\xA3\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB8"],
        ["\xE5\xA3\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB9"],
        ["\xE5\xA3\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xBA"],
        ["\xE5\xA3\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xBB"],
        ["\xE5\xA3\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xBC"],
        ["\xE5\xA3\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xBD"],
        ["\xE5\xA3\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xBE"],
        ["\xE5\xA3\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xBF"],
        ["\xE5\xA3\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x80"],
        ["\xE5\xA3\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x81"],
        ["\xE5\xA4\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x82"],
        ["\xE5\xA4\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x83"],
        ["\xE5\xA4\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x84"],
        ["\xE5\xA4\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x85"],
        ["\xE6\xA2\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x86"],
        ["\xE5\xA4\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x87"],
        ["\xE5\xA4\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x88"],
        ["\xE5\xA4\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x89"],
        ["\xE5\xA4\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x8A"],
        ["\xE5\xA4\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x8B"],
        ["\xE5\xA4\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x8C"],
        ["\xE7\xAB\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x8D"],
        ["\xE5\xA5\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x8E"],
        ["\xE5\xA5\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x8F"],
        ["\xE5\xA5\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x90"],
        ["\xE5\xA5\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x91"],
        ["\xE5\xA5\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x92"],
        ["\xE5\xA5\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x93"],
        ["\xE5\xA5\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x94"],
        ["\xE5\xA5\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x95"],
        ["\xE5\xA5\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x96"],
        ["\xE5\xA5\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x97"],
        ["\xE5\xA5\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x98"],
        ["\xE5\xA6\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x99"],
        ["\xE5\xA6\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x9A"],
        ["\xE4\xBD\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x9B"],
        ["\xE4\xBE\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x9C"],
        ["\xE5\xA6\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x9D"],
        ["\xE5\xA6\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x9E"],
        ["\xE5\xA7\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x9F"],
        ["\xE5\xA7\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA0"],
        ["\xE5\xA7\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA1"],
        ["\xE5\xA6\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA2"],
        ["\xE5\xA7\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA3"],
        ["\xE5\xA7\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA4"],
        ["\xE5\xA8\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA5"],
        ["\xE5\xA8\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA6"],
        ["\xE5\xA8\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA7"],
        ["\xE5\xA8\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA8"],
        ["\xE5\xA8\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA9"],
        ["\xE5\xA8\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xAA"],
        ["\xE5\xA9\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xAB"],
        ["\xE5\xA9\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xAC"],
        ["\xE5\xA9\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xAD"],
        ["\xE5\xA8\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xAE"],
        ["\xE5\xA8\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xAF"],
        ["\xE5\xA9\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB0"],
        ["\xE5\xA9\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB1"],
        ["\xE5\xAA\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB2"],
        ["\xE5\xAA\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB3"],
        ["\xE5\xAA\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB4"],
        ["\xE5\xAB\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB5"],
        ["\xE5\xAB\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB6"],
        ["\xE5\xAA\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB7"],
        ["\xE5\xAB\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB8"],
        ["\xE5\xAB\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB9"],
        ["\xE5\xAB\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xBA"],
        ["\xE5\xAB\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xBB"],
        ["\xE5\xAB\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xBC"],
        ["\xE5\xAB\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xBD"],
        ["\xE5\xAB\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xBE"],
        ["\xE5\xAC\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xBF"],
        ["\xE5\xAC\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x80"],
        ["\xE5\xAC\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x81"],
        ["\xE5\xAC\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x82"],
        ["\xE5\xAB\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x83"],
        ["\xE5\xAC\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x84"],
        ["\xE5\xAC\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x85"],
        ["\xE5\xAC\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x86"],
        ["\xE5\xAD\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x87"],
        ["\xE5\xAD\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x88"],
        ["\xE5\xAD\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x89"],
        ["\xE5\xAD\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x8A"],
        ["\xE5\xAD\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x8B"],
        ["\xE5\xAD\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x8C"],
        ["\xE5\xAD\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x8D"],
        ["\xE5\xAD\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x8E"],
        ["\xE5\xAD\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x8F"],
        ["\xE5\xAD\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x90"],
        ["\xE5\xAD\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x91"],
        ["\xE5\xAD\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x92"],
        ["\xE5\xAD\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x93"],
        ["\xE6\x96\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x94"],
        ["\xE5\xAD\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x95"],
        ["\xE5\xAE\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x96"],
        ["\xE5\xAE\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x97"],
        ["\xE5\xAE\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x98"],
        ["\xE5\xAE\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x99"],
        ["\xE5\xAF\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x9A"],
        ["\xE5\xAF\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x9B"],
        ["\xE5\xAF\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x9C"],
        ["\xE5\xAF\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x9D"],
        ["\xE5\xAF\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x9E"],
        ["\xE5\xAF\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x9F"],
        ["\xE5\xAF\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA0"],
        ["\xE5\xAF\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA1"],
        ["\xE5\xAF\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA2"],
        ["\xE5\xAF\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA3"],
        ["\xE5\xAF\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA4"],
        ["\xE5\xAF\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA5"],
        ["\xE5\xAF\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA6"],
        ["\xE5\xAF\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA7"],
        ["\xE5\xB0\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA8"],
        ["\xE5\xB0\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA9"],
        ["\xE5\xB0\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xAA"],
        ["\xE5\xB0\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xAB"],
        ["\xE5\xB0\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xAC"],
        ["\xE5\xB0\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xAD"],
        ["\xE5\xB0\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xAE"],
        ["\xE5\xB0\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xAF"],
        ["\xE5\xB0\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB0"],
        ["\xE5\xB0\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB1"],
        ["\xE5\xB1\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB2"],
        ["\xE5\xB1\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB3"],
        ["\xE5\xB1\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB4"],
        ["\xE5\xB1\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB5"],
        ["\xE5\xB1\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB6"],
        ["\xE5\xB1\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB7"],
        ["\xE5\xAD\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB8"],
        ["\xE5\xB1\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB9"],
        ["\xE5\xB1\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xBA"],
        ["\xE4\xB9\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xBB"],
        ["\xE5\xB1\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xBC"],
        ["\xE5\xB1\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xBD"],
        ["\xE5\xB2\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xBE"],
        ["\xE5\xB2\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xBF"],
        ["\xE5\xB2\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x80"],
        ["\xE5\xA6\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x81"],
        ["\xE5\xB2\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x82"],
        ["\xE5\xB2\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x83"],
        ["\xE5\xB2\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x84"],
        ["\xE5\xB2\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x85"],
        ["\xE5\xB2\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x86"],
        ["\xE5\xB3\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x87"],
        ["\xE5\xB2\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x88"],
        ["\xE5\xB3\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x89"],
        ["\xE5\xB3\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x8A"],
        ["\xE5\xB3\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x8B"],
        ["\xE5\xB3\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x8C"],
        ["\xE5\xB3\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x8D"],
        ["\xE5\xB3\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x8E"],
        ["\xE5\xB6\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x8F"],
        ["\xE5\xB3\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x90"],
        ["\xE5\xB4\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x91"],
        ["\xE5\xB4\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x92"],
        ["\xE5\xB4\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x93"],
        ["\xE5\xB5\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x94"],
        ["\xE5\xB4\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x95"],
        ["\xE5\xB4\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x96"],
        ["\xE5\xB4\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x97"],
        ["\xE5\xB4\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x98"],
        ["\xE5\xB4\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x99"],
        ["\xE5\xB4\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x9A"],
        ["\xE5\xB4\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x9B"],
        ["\xE5\xB4\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x9C"],
        ["\xE5\xB5\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x9D"],
        ["\xE5\xB5\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x9E"],
        ["\xE5\xB5\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x9F"],
        ["\xE5\xB5\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA0"],
        ["\xE5\xB5\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA1"],
        ["\xE5\xB5\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA2"],
        ["\xE5\xB5\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA3"],
        ["\xE5\xB6\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA4"],
        ["\xE5\xB6\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA5"],
        ["\xE5\xB6\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA6"],
        ["\xE5\xB6\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA7"],
        ["\xE5\xB6\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA8"],
        ["\xE5\xB6\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA9"],
        ["\xE5\xB6\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xAA"],
        ["\xE5\xB6\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xAB"],
        ["\xE5\xB6\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xAC"],
        ["\xE5\xB6\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xAD"],
        ["\xE5\xB6\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xAE"],
        ["\xE5\xB7\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xAF"],
        ["\xE5\xB7\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB0"],
        ["\xE5\xB7\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB1"],
        ["\xE5\xB7\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB2"],
        ["\xE5\xB7\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB3"],
        ["\xE5\xB7\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB4"],
        ["\xE5\xB7\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB5"],
        ["\xE5\xB7\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB6"],
        ["\xE5\xB7\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB7"],
        ["\xE5\xB8\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB8"],
        ["\xE5\xB8\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB9"],
        ["\xE5\xB8\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xBA"],
        ["\xE5\xB8\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xBB"],
        ["\xE5\xB8\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xBC"],
        ["\xE5\xB8\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xBD"],
        ["\xE5\xB8\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xBE"],
        ["\xE5\xB9\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xBF"],
        ["\xE5\xB9\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x80"],
        ["\xE5\xB9\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x81"],
        ["\xE5\xB9\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x82"],
        ["\xE5\xB9\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x83"],
        ["\xE5\xB9\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x84"],
        ["\xE5\xB9\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x85"],
        ["\xE5\xB9\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x86"],
        ["\xE5\xB9\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x87"],
        ["\xE5\xB9\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x88"],
        ["\xE5\xB9\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x89"],
        ["\xE5\xB9\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x8A"],
        ["\xE5\xB9\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x8B"],
        ["\xE9\xBA\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x8C"],
        ["\xE5\xB9\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x8D"],
        ["\xE5\xBA\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x8E"],
        ["\xE5\xBB\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x8F"],
        ["\xE5\xBB\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x90"],
        ["\xE5\xBB\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x91"],
        ["\xE5\xBB\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x92"],
        ["\xE5\xBB\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x93"],
        ["\xE5\xBB\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x94"],
        ["\xE5\xBB\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x95"],
        ["\xE5\xBB\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x96"],
        ["\xE5\xBB\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x97"],
        ["\xE5\xBB\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x98"],
        ["\xE5\xBB\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x99"],
        ["\xE5\xBB\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x9A"],
        ["\xE5\xBB\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x9B"],
        ["\xE5\xBB\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x9C"],
        ["\xE5\xBB\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x9D"],
        ["\xE5\xBB\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x9E"],
        ["\xE5\xBB\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x9F"],
        ["\xE5\xBB\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA0"],
        ["\xE5\xBB\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA1"],
        ["\xE5\xBB\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA2"],
        ["\xE5\xBB\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA3"],
        ["\xE5\xBC\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA4"],
        ["\xE5\xBC\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA5"],
        ["\xE5\xBD\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA6"],
        ["\xE5\xBD\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA7"],
        ["\xE5\xBC\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA8"],
        ["\xE5\xBC\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA9"],
        ["\xE5\xBC\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xAA"],
        ["\xE5\xBC\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xAB"],
        ["\xE5\xBC\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xAC"],
        ["\xE5\xBC\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xAD"],
        ["\xE5\xBD\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xAF"],
        ["\xE5\xBD\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB0"],
        ["\xE5\xBD\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB1"],
        ["\xE5\xBC\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB2"],
        ["\xE5\xBD\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB3"],
        ["\xE5\xBD\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB4"],
        ["\xE5\xBD\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB5"],
        ["\xE5\xBD\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB6"],
        ["\xE5\xBD\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB7"],
        ["\xE5\xBD\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB8"],
        ["\xE5\xBD\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB9"],
        ["\xE5\xBD\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xBA"],
        ["\xE5\xBE\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xBB"],
        ["\xE5\xBE\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xBC"],
        ["\xE5\xBD\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xBD"],
        ["\xE5\xBE\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xBE"],
        ["\xE5\xBE\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xBF"],
        ["\xE5\xBE\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x80"],
        ["\xE5\xBE\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x81"],
        ["\xE5\xBE\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x82"],
        ["\xE5\xBE\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x83"],
        ["\xE5\xBE\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x84"],
        ["\xE5\xBE\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x85"],
        ["\xE5\xBE\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x86"],
        ["\xE5\xBE\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x87"],
        ["\xE5\xBE\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x88"],
        ["\xE5\xBF\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x89"],
        ["\xE5\xBF\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x8A"],
        ["\xE5\xBF\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x8B"],
        ["\xE5\xBF\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x8C"],
        ["\xE5\xBF\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x8D"],
        ["\xE5\xBF\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x8E"],
        ["\xE6\x82\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x8F"],
        ["\xE5\xBF\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x90"],
        ["\xE6\x80\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x91"],
        ["\xE6\x81\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x92"],
        ["\xE6\x80\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x93"],
        ["\xE6\x80\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x94"],
        ["\xE6\x80\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x95"],
        ["\xE6\x80\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x96"],
        ["\xE6\x80\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x97"],
        ["\xE6\x80\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x98"],
        ["\xE6\x80\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x99"],
        ["\xE6\x80\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x9A"],
        ["\xE6\x80\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x9B"],
        ["\xE6\x80\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x9C"],
        ["\xE6\x80\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x9D"],
        ["\xE6\x81\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x9E"],
        ["\xE6\x81\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x9F"],
        ["\xE6\x81\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA0"],
        ["\xE6\x81\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA1"],
        ["\xE6\x81\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA2"],
        ["\xE6\x81\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA3"],
        ["\xE6\x81\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA4"],
        ["\xE6\x81\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA5"],
        ["\xE6\x81\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA6"],
        ["\xE6\x81\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA7"],
        ["\xE6\x81\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA8"],
        ["\xE6\x81\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA9"],
        ["\xE6\x81\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xAA"],
        ["\xE6\x81\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xAB"],
        ["\xE6\x81\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xAC"],
        ["\xE6\x82\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xAD"],
        ["\xE6\x82\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xAE"],
        ["\xE6\x83\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xAF"],
        ["\xE6\x82\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB0"],
        ["\xE6\x82\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB1"],
        ["\xE6\x82\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB2"],
        ["\xE6\x82\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB3"],
        ["\xE6\x82\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB4"],
        ["\xE6\x82\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB5"],
        ["\xE6\x82\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB6"],
        ["\xE6\x82\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB7"],
        ["\xE6\x82\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB8"],
        ["\xE6\x83\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB9"],
        ["\xE6\x82\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xBA"],
        ["\xE6\x83\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xBB"],
        ["\xE6\x83\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xBC"],
        ["\xE6\x82\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xBD"],
        ["\xE5\xBF\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xBE"],
        ["\xE6\x82\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xBF"],
        ["\xE6\x83\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x80"],
        ["\xE6\x82\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x81"],
        ["\xE6\x83\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x82"],
        ["\xE6\x85\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x83"],
        ["\xE6\x84\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x84"],
        ["\xE6\x84\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x85"],
        ["\xE6\x83\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x86"],
        ["\xE6\x83\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x87"],
        ["\xE6\x84\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x88"],
        ["\xE6\x83\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x89"],
        ["\xE6\x83\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x8A"],
        ["\xE6\x84\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x8B"],
        ["\xE6\x84\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x8C"],
        ["\xE6\x83\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x8D"],
        ["\xE6\x83\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x8E"],
        ["\xE6\x84\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x8F"],
        ["\xE6\x84\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x90"],
        ["\xE6\x85\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x91"],
        ["\xE6\x84\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x92"],
        ["\xE6\x84\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x93"],
        ["\xE6\x84\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x94"],
        ["\xE6\x85\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x95"],
        ["\xE6\x84\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x96"],
        ["\xE6\x84\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x97"],
        ["\xE6\x84\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x98"],
        ["\xE6\x84\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x99"],
        ["\xE6\x84\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x9A"],
        ["\xE6\x85\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x9B"],
        ["\xE6\x85\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x9C"],
        ["\xE6\x85\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x9D"],
        ["\xE6\x85\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x9E"],
        ["\xE6\x85\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x9F"],
        ["\xE6\x85\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA0"],
        ["\xE6\x85\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA1"],
        ["\xE6\x85\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA2"],
        ["\xE6\x85\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA3"],
        ["\xE6\x85\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA4"],
        ["\xE6\x85\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA5"],
        ["\xE6\x85\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA6"],
        ["\xE6\x85\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA7"],
        ["\xE6\x85\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA8"],
        ["\xE6\x85\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA9"],
        ["\xE6\x85\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xAA"],
        ["\xE6\x86\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xAB"],
        ["\xE6\x86\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xAC"],
        ["\xE6\x86\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xAD"],
        ["\xE6\x86\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xAE"],
        ["\xE6\x86\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xAF"],
        ["\xE6\x86\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB0"],
        ["\xE6\x86\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB1"],
        ["\xE6\x86\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB2"],
        ["\xE6\x86\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB3"],
        ["\xE6\x86\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB4"],
        ["\xE6\x87\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB5"],
        ["\xE6\x87\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB6"],
        ["\xE6\x87\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB7"],
        ["\xE6\x87\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB8"],
        ["\xE6\x87\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB9"],
        ["\xE6\x87\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xBA"],
        ["\xE6\x87\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xBB"],
        ["\xE6\x86\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xBC"],
        ["\xE6\x87\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xBD"],
        ["\xE7\xBD\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xBE"],
        ["\xE6\x87\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xBF"],
        ["\xE6\x87\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x80"],
        ["\xE6\x87\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x81"],
        ["\xE6\x87\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x82"],
        ["\xE6\x87\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x83"],
        ["\xE6\x87\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x84"],
        ["\xE6\x87\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x85"],
        ["\xE6\x87\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x86"],
        ["\xE6\x87\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x87"],
        ["\xE6\x87\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x88"],
        ["\xE6\x88\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x89"],
        ["\xE6\x88\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x8A"],
        ["\xE6\x88\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x8B"],
        ["\xE6\x88\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x8C"],
        ["\xE6\x88\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x8D"],
        ["\xE6\x88\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x8E"],
        ["\xE6\x88\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x8F"],
        ["\xE6\x88\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x90"],
        ["\xE6\x88\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x91"],
        ["\xE6\x88\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x92"],
        ["\xE6\x88\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x93"],
        ["\xE6\x88\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x94"],
        ["\xE6\x88\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x95"],
        ["\xE6\x88\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x96"],
        ["\xE6\x89\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x97"],
        ["\xE6\x89\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x98"],
        ["\xE6\x89\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x99"],
        ["\xE6\x89\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x9A"],
        ["\xE6\x89\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x9B"],
        ["\xE6\x89\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x9C"],
        ["\xE6\x89\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x9D"],
        ["\xE6\x89\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x9E"],
        ["\xE6\x8A\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x9F"],
        ["\xE6\x8A\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA0"],
        ["\xE6\x89\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA1"],
        ["\xE6\x8A\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA2"],
        ["\xE6\x8A\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA3"],
        ["\xE6\x8A\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA4"],
        ["\xE6\x8B\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA5"],
        ["\xE6\x8A\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA6"],
        ["\xE6\x8A\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA7"],
        ["\xE6\x8B\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA8"],
        ["\xE6\x8B\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA9"],
        ["\xE6\x8A\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xAA"],
        ["\xE6\x8B\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xAB"],
        ["\xE6\x8B\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xAC"],
        ["\xE6\x8B\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xAD"],
        ["\xE6\x93\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xAE"],
        ["\xE6\x8B\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xAF"],
        ["\xE6\x8B\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB0"],
        ["\xE6\x8B\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB1"],
        ["\xE6\x8B\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB2"],
        ["\xE6\x8B\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB3"],
        ["\xE6\x8B\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB4"],
        ["\xE6\x8A\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB5"],
        ["\xE6\x8B\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB6"],
        ["\xE6\x8C\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB7"],
        ["\xE6\x8B\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB8"],
        ["\xE6\x8B\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB9"],
        ["\xE6\x8C\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xBA"],
        ["\xE6\x8C\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xBB"],
        ["\xE6\x8C\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xBC"],
        ["\xE6\x8B\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xBD"],
        ["\xE6\x8B\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xBE"],
        ["\xE6\x8D\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xBF"],
        ["\xE6\x8C\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x80"],
        ["\xE6\x8D\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x81"],
        ["\xE6\x90\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x82"],
        ["\xE6\x8D\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x83"],
        ["\xE6\x8E\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x84"],
        ["\xE6\x8E\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x85"],
        ["\xE6\x8E\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x86"],
        ["\xE6\x8E\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x87"],
        ["\xE6\x8D\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x88"],
        ["\xE6\x8E\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x89"],
        ["\xE6\x8E\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x8A"],
        ["\xE6\x8E\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x8B"],
        ["\xE6\x8E\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x8C"],
        ["\xE6\x8E\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x8D"],
        ["\xE6\x8D\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x8E"],
        ["\xE6\x8D\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x8F"],
        ["\xE6\x8E\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x90"],
        ["\xE6\x8F\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x91"],
        ["\xE6\x8F\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x92"],
        ["\xE6\x8F\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x93"],
        ["\xE6\x8F\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x94"],
        ["\xE6\x8F\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x95"],
        ["\xE6\x8F\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x96"],
        ["\xE6\x8F\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x97"],
        ["\xE6\x8F\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x98"],
        ["\xE6\x90\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x99"],
        ["\xE6\x90\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x9A"],
        ["\xE6\x90\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x9B"],
        ["\xE6\x90\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x9C"],
        ["\xE6\x90\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x9D"],
        ["\xE6\x90\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x9E"],
        ["\xE6\x94\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x9F"],
        ["\xE6\x90\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA0"],
        ["\xE6\x90\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA1"],
        ["\xE6\x90\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA2"],
        ["\xE6\x91\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA3"],
        ["\xE6\x91\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA4"],
        ["\xE6\x91\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA5"],
        ["\xE6\x91\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA6"],
        ["\xE6\x94\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA7"],
        ["\xE6\x92\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA8"],
        ["\xE6\x92\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA9"],
        ["\xE6\x92\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xAA"],
        ["\xE6\x92\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xAB"],
        ["\xE6\x92\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xAC"],
        ["\xE6\x92\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xAD"],
        ["\xE6\x93\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xAE"],
        ["\xE6\x93\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xAF"],
        ["\xE6\x93\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB0"],
        ["\xE6\x93\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB1"],
        ["\xE6\x92\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB2"],
        ["\xE6\x93\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB3"],
        ["\xE6\x93\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB4"],
        ["\xE6\x93\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB5"],
        ["\xE6\x93\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB6"],
        ["\xE8\x88\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB7"],
        ["\xE6\x93\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB8"],
        ["\xE6\x93\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB9"],
        ["\xE6\x8A\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xBA"],
        ["\xE6\x93\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xBB"],
        ["\xE6\x93\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xBC"],
        ["\xE6\x94\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xBD"],
        ["\xE6\x93\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xBE"],
        ["\xE6\x93\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xBF"],
        ["\xE6\x93\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x80"],
        ["\xE6\x93\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x81"],
        ["\xE6\x94\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x82"],
        ["\xE6\x93\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x83"],
        ["\xE6\x94\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x84"],
        ["\xE6\x94\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x85"],
        ["\xE6\x94\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x86"],
        ["\xE6\x94\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x87"],
        ["\xE6\x94\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x88"],
        ["\xE6\x94\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x89"],
        ["\xE6\x94\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x8A"],
        ["\xE6\x94\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x8B"],
        ["\xE6\x94\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x8C"],
        ["\xE6\x94\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x8D"],
        ["\xE6\x94\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x8E"],
        ["\xE7\x95\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x8F"],
        ["\xE6\x95\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x90"],
        ["\xE6\x95\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x91"],
        ["\xE6\x95\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x92"],
        ["\xE6\x95\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x93"],
        ["\xE6\x95\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x94"],
        ["\xE6\x95\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x95"],
        ["\xE6\x95\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x96"],
        ["\xE6\x95\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x97"],
        ["\xE6\x95\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x98"],
        ["\xE6\x96\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x99"],
        ["\xE6\x96\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x9A"],
        ["\xE8\xAE\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x9B"],
        ["\xE6\x96\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x9C"],
        ["\xE6\x96\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x9D"],
        ["\xE6\x96\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x9E"],
        ["\xE6\x96\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x9F"],
        ["\xE6\x97\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA0"],
        ["\xE6\x97\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA1"],
        ["\xE6\x97\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA2"],
        ["\xE6\x97\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA3"],
        ["\xE6\x97\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA4"],
        ["\xE6\x97\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA5"],
        ["\xE6\x97\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA6"],
        ["\xE6\x97\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA7"],
        ["\xE6\x97\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA8"],
        ["\xE6\x97\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA9"],
        ["\xE6\x97\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xAA"],
        ["\xE6\x9D\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xAB"],
        ["\xE6\x98\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xAC"],
        ["\xE6\x98\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xAD"],
        ["\xE6\x97\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xAE"],
        ["\xE6\x9D\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xAF"],
        ["\xE6\x98\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB0"],
        ["\xE6\x98\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB1"],
        ["\xE6\x98\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB2"],
        ["\xE6\x98\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB3"],
        ["\xE6\x99\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB4"],
        ["\xE6\x99\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB5"],
        ["\xE6\x99\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB6"],
        ["\xE6\x99\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB7"],
        ["\xE6\x99\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB8"],
        ["\xE6\x99\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB9"],
        ["\xE6\x99\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xBA"],
        ["\xE6\x99\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xBB"],
        ["\xE6\x99\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xBC"],
        ["\xE6\x99\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xBD"],
        ["\xE6\x99\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xBE"],
        ["\xE6\x99\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xBF"],
        ["\xE6\x9A\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x80"],
        ["\xE6\x9A\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x81"],
        ["\xE6\x9A\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x82"],
        ["\xE6\x9A\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x83"],
        ["\xE6\x9A\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x84"],
        ["\xE6\x9A\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x85"],
        ["\xE6\x9A\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x86"],
        ["\xE6\x9B\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x87"],
        ["\xE6\x9A\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x88"],
        ["\xE6\x9B\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x89"],
        ["\xE6\x9A\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x8A"],
        ["\xE6\x9A\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x8B"],
        ["\xE6\x9B\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x8C"],
        ["\xE6\x9A\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x8D"],
        ["\xE6\x9B\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x8E"],
        ["\xE6\x9B\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x8F"],
        ["\xE6\x9B\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x90"],
        ["\xE6\x98\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x91"],
        ["\xE6\x9B\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x92"],
        ["\xE6\x9B\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x93"],
        ["\xE6\x9B\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x94"],
        ["\xE6\x9B\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x95"],
        ["\xE6\x9B\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x96"],
        ["\xE6\x9C\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x97"],
        ["\xE6\x9C\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x98"],
        ["\xE6\x9C\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x99"],
        ["\xE6\x9C\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x9A"],
        ["\xE6\x9C\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x9B"],
        ["\xE9\x9C\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x9C"],
        ["\xE6\x9C\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x9D"],
        ["\xE6\x9C\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x9E"],
        ["\xE6\x9C\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x9F"],
        ["\xE6\x9D\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA0"],
        ["\xE6\x9C\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA1"],
        ["\xE6\x9C\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA2"],
        ["\xE6\x9D\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA3"],
        ["\xE6\x9D\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA4"],
        ["\xE6\x9D\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA5"],
        ["\xE6\x9D\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA6"],
        ["\xE6\x9D\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA7"],
        ["\xE6\x9D\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA8"],
        ["\xE6\x9E\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA9"],
        ["\xE6\x9D\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xAA"],
        ["\xE6\x9E\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xAB"],
        ["\xE6\x9D\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xAC"],
        ["\xE6\x9D\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xAD"],
        ["\xE6\x9E\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xAE"],
        ["\xE6\x9E\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xAF"],
        ["\xE6\x9E\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB0"],
        ["\xE6\x9E\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB1"],
        ["\xE6\x9E\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB2"],
        ["\xE6\x9E\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB3"],
        ["\xE6\x9F\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB4"],
        ["\xE6\x9E\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB5"],
        ["\xE6\x9F\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB6"],
        ["\xE6\x9E\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB7"],
        ["\xE6\x9F\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB8"],
        ["\xE6\x9E\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB9"],
        ["\xE6\x9F\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xBA"],
        ["\xE6\x9F\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xBB"],
        ["\xE6\x9F\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xBC"],
        ["\xE6\x9F\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xBD"],
        ["\xE6\x9F\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xBE"],
        ["\xE6\x9E\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xBF"],
        ["\xE6\x9F\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x80"],
        ["\xE6\x9F\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x81"],
        ["\xE6\x9F\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x82"],
        ["\xE6\xAA\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x83"],
        ["\xE6\xA0\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x84"],
        ["\xE6\xA1\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x85"],
        ["\xE6\xA0\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x86"],
        ["\xE6\xA1\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x87"],
        ["\xE6\xA1\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x88"],
        ["\xE6\xA0\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x89"],
        ["\xE6\xA1\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x8A"],
        ["\xE6\xA2\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x8B"],
        ["\xE6\xA0\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x8C"],
        ["\xE6\xA1\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x8D"],
        ["\xE6\xA1\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x8E"],
        ["\xE6\xA1\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x8F"],
        ["\xE6\xA1\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x90"],
        ["\xE6\xA2\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x91"],
        ["\xE6\xA2\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x92"],
        ["\xE6\xA2\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x93"],
        ["\xE6\xA2\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x94"],
        ["\xE6\xA2\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x95"],
        ["\xE6\xA2\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x96"],
        ["\xE6\xA2\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x97"],
        ["\xE6\xAA\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x98"],
        ["\xE6\xA2\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x99"],
        ["\xE6\xA1\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x9A"],
        ["\xE6\xA2\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x9B"],
        ["\xE6\xA2\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x9C"],
        ["\xE6\xA2\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x9D"],
        ["\xE6\xA4\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x9E"],
        ["\xE6\xA2\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x9F"],
        ["\xE6\xA1\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA0"],
        ["\xE6\xA4\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA1"],
        ["\xE6\xA3\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA2"],
        ["\xE6\xA4\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA3"],
        ["\xE6\xA3\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA4"],
        ["\xE6\xA4\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA5"],
        ["\xE6\xA4\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA6"],
        ["\xE6\xA3\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA7"],
        ["\xE6\xA4\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA8"],
        ["\xE6\xA3\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA9"],
        ["\xE6\xA3\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xAA"],
        ["\xE6\xA3\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xAB"],
        ["\xE6\xA3\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xAC"],
        ["\xE6\xA4\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xAD"],
        ["\xE6\xA4\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xAE"],
        ["\xE6\xA4\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xAF"],
        ["\xE6\xA3\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB0"],
        ["\xE6\xA3\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB1"],
        ["\xE6\xA4\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB2"],
        ["\xE6\xA3\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB3"],
        ["\xE6\xA3\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB4"],
        ["\xE6\xA3\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB5"],
        ["\xE6\xA4\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB6"],
        ["\xE6\xA4\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB7"],
        ["\xE6\xA4\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB8"],
        ["\xE6\xA4\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB9"],
        ["\xE6\xA4\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xBA"],
        ["\xE6\xA3\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xBB"],
        ["\xE6\xA5\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xBC"],
        ["\xE6\xA5\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xBD"],
        ["\xE6\xA5\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xBE"],
        ["\xE6\xA5\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xBF"],
        ["\xE6\xA5\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x80"],
        ["\xE6\xA5\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x81"],
        ["\xE6\xA5\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x82"],
        ["\xE6\xA5\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x83"],
        ["\xE6\xA4\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x84"],
        ["\xE6\xA5\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x85"],
        ["\xE6\xA4\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x86"],
        ["\xE6\xA5\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x87"],
        ["\xE6\xA4\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x88"],
        ["\xE6\xA5\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x89"],
        ["\xE6\xA5\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x8A"],
        ["\xE6\xA5\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x8B"],
        ["\xE6\xA6\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x8C"],
        ["\xE6\xA5\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x8D"],
        ["\xE6\xA6\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x8E"],
        ["\xE6\xA6\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x8F"],
        ["\xE6\xA7\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x90"],
        ["\xE6\xA6\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x91"],
        ["\xE6\xA7\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x92"],
        ["\xE6\xA7\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x93"],
        ["\xE6\xA6\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x94"],
        ["\xE6\xA7\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x95"],
        ["\xE5\xAF\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x96"],
        ["\xE6\xA7\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x97"],
        ["\xE6\xA7\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x98"],
        ["\xE6\xA6\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x99"],
        ["\xE6\xA7\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x9A"],
        ["\xE6\xA6\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x9B"],
        ["\xE6\xA8\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x9C"],
        ["\xE6\xA6\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x9D"],
        ["\xE6\xA6\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x9E"],
        ["\xE6\xA6\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x9F"],
        ["\xE6\xA6\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA0"],
        ["\xE6\xA6\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA1"],
        ["\xE6\xA7\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA2"],
        ["\xE6\xA7\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA3"],
        ["\xE6\xA8\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA4"],
        ["\xE6\xA8\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA5"],
        ["\xE6\xA7\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA6"],
        ["\xE6\xAC\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA7"],
        ["\xE6\xA7\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA8"],
        ["\xE6\xA7\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA9"],
        ["\xE6\xA7\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xAA"],
        ["\xE6\xA8\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xAB"],
        ["\xE6\xA6\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xAC"],
        ["\xE6\xA8\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xAD"],
        ["\xE6\xA7\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xAE"],
        ["\xE6\xA8\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xAF"],
        ["\xE6\xA7\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB0"],
        ["\xE6\xA8\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB1"],
        ["\xE6\xA8\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB2"],
        ["\xE6\xAB\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB3"],
        ["\xE6\xA8\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB4"],
        ["\xE6\xA8\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB5"],
        ["\xE6\xA9\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB6"],
        ["\xE6\xA8\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB7"],
        ["\xE6\xA9\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB8"],
        ["\xE6\xA8\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB9"],
        ["\xE6\xA9\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xBA"],
        ["\xE6\xA9\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xBB"],
        ["\xE6\xA9\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xBC"],
        ["\xE6\xA9\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xBD"],
        ["\xE6\xA9\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xBE"],
        ["\xE6\xA9\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xBF"],
        ["\xE6\xA8\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x80"],
        ["\xE6\xA8\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x81"],
        ["\xE6\xAA\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x82"],
        ["\xE6\xAA\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x83"],
        ["\xE6\xAA\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x84"],
        ["\xE6\xAA\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x85"],
        ["\xE6\xAA\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x86"],
        ["\xE6\xAA\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x87"],
        ["\xE6\xAA\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x88"],
        ["\xE8\x98\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x89"],
        ["\xE6\xAA\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x8A"],
        ["\xE6\xAB\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x8B"],
        ["\xE6\xAB\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x8C"],
        ["\xE6\xAA\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x8D"],
        ["\xE6\xAA\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x8E"],
        ["\xE6\xAA\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x8F"],
        ["\xE6\xAB\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x90"],
        ["\xE6\xAB\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x91"],
        ["\xE6\xAB\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x92"],
        ["\xE6\xAA\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x93"],
        ["\xE6\xAB\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x94"],
        ["\xE6\xAB\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x95"],
        ["\xE6\xAB\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x96"],
        ["\xE6\xAC\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x97"],
        ["\xE8\x98\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x98"],
        ["\xE6\xAB\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x99"],
        ["\xE6\xAC\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x9A"],
        ["\xE6\xAC\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x9B"],
        ["\xE9\xAC\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x9C"],
        ["\xE6\xAC\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x9D"],
        ["\xE6\xAC\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x9E"],
        ["\xE6\xAC\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x9F"],
        ["\xE7\x9B\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA0"],
        ["\xE6\xAC\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA1"],
        ["\xE9\xA3\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA2"],
        ["\xE6\xAD\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA3"],
        ["\xE6\xAD\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA4"],
        ["\xE6\xAD\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA5"],
        ["\xE6\xAD\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA6"],
        ["\xE6\xAD\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA7"],
        ["\xE6\xAD\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA8"],
        ["\xE6\xAD\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA9"],
        ["\xE6\xAD\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xAA"],
        ["\xE6\xAD\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xAB"],
        ["\xE6\xAD\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xAC"],
        ["\xE6\xAD\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xAD"],
        ["\xE6\xAD\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xAE"],
        ["\xE6\xAE\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xAF"],
        ["\xE6\xAE\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB0"],
        ["\xE6\xAE\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB1"],
        ["\xE6\xAE\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB2"],
        ["\xE6\xAE\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB3"],
        ["\xE6\xAE\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB4"],
        ["\xE6\xAE\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB5"],
        ["\xE6\xAE\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB6"],
        ["\xE6\xAE\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB7"],
        ["\xE6\xAE\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB8"],
        ["\xE6\xAE\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB9"],
        ["\xE6\xAE\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xBA"],
        ["\xE6\xAE\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xBB"],
        ["\xE6\xAE\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xBC"],
        ["\xE6\xAE\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xBD"],
        ["\xE6\xAE\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xBE"],
        ["\xE6\xAF\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xBF"],
        ["\xE6\xAF\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x80"],
        ["\xE6\xAF\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x81"],
        ["\xE6\xAF\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x82"],
        ["\xE6\xAF\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x83"],
        ["\xE6\xAF\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x84"],
        ["\xE6\xAF\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x85"],
        ["\xE6\xAF\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x86"],
        ["\xE9\xBA\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x87"],
        ["\xE6\xB0\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x88"],
        ["\xE6\xB0\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x89"],
        ["\xE6\xB0\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x8A"],
        ["\xE6\xB0\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x8B"],
        ["\xE6\xB0\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x8C"],
        ["\xE6\xB0\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x8D"],
        ["\xE6\xB1\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x8E"],
        ["\xE6\xB1\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x8F"],
        ["\xE6\xB1\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x90"],
        ["\xE6\xB1\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x91"],
        ["\xE6\xB2\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x92"],
        ["\xE6\xB2\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x93"],
        ["\xE6\xB2\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x94"],
        ["\xE6\xB2\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x95"],
        ["\xE6\xB2\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x96"],
        ["\xE6\xB1\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x97"],
        ["\xE6\xB1\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x98"],
        ["\xE6\xB1\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x99"],
        ["\xE6\xB2\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x9A"],
        ["\xE6\xB2\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x9B"],
        ["\xE6\xB3\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x9C"],
        ["\xE6\xB3\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x9D"],
        ["\xE6\xB3\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x9E"],
        ["\xE6\xB2\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x9F"],
        ["\xE6\xB3\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA0"],
        ["\xE6\xB3\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA1"],
        ["\xE6\xB3\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA2"],
        ["\xE6\xB2\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA3"],
        ["\xE6\xB2\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA4"],
        ["\xE6\xB2\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA5"],
        ["\xE6\xB2\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA6"],
        ["\xE6\xB3\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA7"],
        ["\xE6\xB3\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA8"],
        ["\xE6\xB3\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA9"],
        ["\xE6\xB3\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xAA"],
        ["\xE6\xB4\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xAB"],
        ["\xE8\xA1\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xAC"],
        ["\xE6\xB4\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xAD"],
        ["\xE6\xB4\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xAE"],
        ["\xE6\xB4\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xAF"],
        ["\xE6\xB4\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB0"],
        ["\xE6\xB4\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB1"],
        ["\xE6\xB4\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB2"],
        ["\xE6\xB4\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB3"],
        ["\xE6\xB4\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB4"],
        ["\xE6\xB4\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB5"],
        ["\xE6\xB5\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB6"],
        ["\xE6\xB6\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB7"],
        ["\xE6\xB5\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB8"],
        ["\xE6\xB5\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB9"],
        ["\xE6\xB5\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xBA"],
        ["\xE6\xB5\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xBB"],
        ["\xE6\xB6\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xBC"],
        ["\xE6\xB6\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xBD"],
        ["\xE6\xBF\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xBE"],
        ["\xE6\xB6\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xBF"],
        ["\xE6\xB7\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x80"],
        ["\xE6\xB8\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x81"],
        ["\xE6\xB8\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x82"],
        ["\xE6\xB6\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x83"],
        ["\xE6\xB7\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x84"],
        ["\xE6\xB7\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x85"],
        ["\xE6\xB6\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x86"],
        ["\xE6\xB7\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x87"],
        ["\xE6\xB7\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x88"],
        ["\xE6\xB7\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x89"],
        ["\xE6\xB7\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x8A"],
        ["\xE6\xB7\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x8B"],
        ["\xE6\xB7\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x8C"],
        ["\xE6\xB7\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x8D"],
        ["\xE6\xB7\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x8E"],
        ["\xE6\xB7\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x8F"],
        ["\xE6\xB7\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x90"],
        ["\xE6\xB7\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x91"],
        ["\xE6\xB7\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x92"],
        ["\xE6\xB7\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x93"],
        ["\xE6\xB8\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x94"],
        ["\xE6\xB9\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x95"],
        ["\xE6\xB8\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x96"],
        ["\xE6\xB8\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x97"],
        ["\xE6\xB9\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x98"],
        ["\xE6\xB9\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x99"],
        ["\xE6\xB8\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x9A"],
        ["\xE6\xB8\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x9B"],
        ["\xE6\xB9\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x9C"],
        ["\xE6\xB8\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x9D"],
        ["\xE6\xB9\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x9E"],
        ["\xE6\xB9\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x9F"],
        ["\xE6\xB8\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA0"],
        ["\xE6\xB9\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA1"],
        ["\xE6\xB8\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA2"],
        ["\xE6\xB9\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA3"],
        ["\xE6\xB8\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA4"],
        ["\xE6\xBB\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA5"],
        ["\xE6\xB8\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA6"],
        ["\xE6\xB8\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA7"],
        ["\xE6\xBA\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA8"],
        ["\xE6\xBA\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA9"],
        ["\xE6\xBA\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xAA"],
        ["\xE6\xBB\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xAB"],
        ["\xE6\xBA\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xAC"],
        ["\xE6\xBB\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xAD"],
        ["\xE6\xBA\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xAE"],
        ["\xE6\xBA\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xAF"],
        ["\xE6\xBB\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB0"],
        ["\xE6\xBA\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB1"],
        ["\xE6\xBB\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB2"],
        ["\xE6\xBB\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB3"],
        ["\xE6\xBA\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB4"],
        ["\xE6\xBA\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB5"],
        ["\xE6\xBB\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB6"],
        ["\xE6\xBA\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB7"],
        ["\xE6\xBD\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB8"],
        ["\xE6\xBC\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB9"],
        ["\xE7\x81\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xBA"],
        ["\xE6\xBB\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xBB"],
        ["\xE6\xBB\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xBC"],
        ["\xE6\xBB\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xBD"],
        ["\xE6\xBC\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xBE"],
        ["\xE6\xBB\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xBF"],
        ["\xE6\xBC\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x80"],
        ["\xE6\xBB\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x81"],
        ["\xE6\xBC\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x82"],
        ["\xE6\xBB\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x83"],
        ["\xE6\xBC\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x84"],
        ["\xE6\xBC\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x85"],
        ["\xE6\xBB\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x86"],
        ["\xE6\xBE\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x87"],
        ["\xE6\xBD\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x88"],
        ["\xE6\xBD\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x89"],
        ["\xE6\xBE\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x8A"],
        ["\xE6\xBE\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x8B"],
        ["\xE6\xBD\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x8C"],
        ["\xE6\xBD\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x8D"],
        ["\xE6\xBF\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x8E"],
        ["\xE6\xBD\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x8F"],
        ["\xE6\xBE\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x90"],
        ["\xE6\xBD\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x91"],
        ["\xE6\xBD\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x92"],
        ["\xE6\xBE\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x93"],
        ["\xE6\xBE\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x94"],
        ["\xE6\xBF\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x95"],
        ["\xE6\xBD\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x96"],
        ["\xE6\xBE\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x97"],
        ["\xE6\xBE\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x98"],
        ["\xE6\xBE\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x99"],
        ["\xE6\xBE\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x9A"],
        ["\xE6\xBE\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x9B"],
        ["\xE6\xBF\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x9C"],
        ["\xE6\xBE\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x9D"],
        ["\xE6\xBF\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x9E"],
        ["\xE6\xBF\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x9F"],
        ["\xE6\xBF\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA0"],
        ["\xE6\xBF\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA1"],
        ["\xE6\xBF\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA2"],
        ["\xE6\xBF\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA3"],
        ["\xE6\xBF\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA4"],
        ["\xE6\xBF\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA5"],
        ["\xE7\x80\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA6"],
        ["\xE7\x80\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA7"],
        ["\xE6\xBF\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA8"],
        ["\xE7\x80\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA9"],
        ["\xE7\x80\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xAA"],
        ["\xE7\x80\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xAB"],
        ["\xE6\xBF\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xAC"],
        ["\xE7\x80\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xAD"],
        ["\xE7\x80\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xAE"],
        ["\xE6\xBD\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xAF"],
        ["\xE7\x80\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB0"],
        ["\xE7\x80\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB1"],
        ["\xE7\x80\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB2"],
        ["\xE7\x80\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB3"],
        ["\xE7\x80\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB4"],
        ["\xE7\x80\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB5"],
        ["\xE7\x81\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB6"],
        ["\xE7\x81\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB7"],
        ["\xE7\x82\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB8"],
        ["\xE7\x82\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB9"],
        ["\xE7\x82\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xBA"],
        ["\xE7\x83\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xBB"],
        ["\xE7\x82\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xBC"],
        ["\xE7\x82\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xBD"],
        ["\xE7\x82\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xBE"],
        ["\xE7\x82\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xBF"],
        ["\xE7\x83\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x80"],
        ["\xE7\x83\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x81"],
        ["\xE7\x83\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x82"],
        ["\xE7\x83\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x83"],
        ["\xE7\x84\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x84"],
        ["\xE7\x83\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x85"],
        ["\xE7\x84\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x86"],
        ["\xE7\x84\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x87"],
        ["\xE7\x85\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x88"],
        ["\xE7\x85\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x89"],
        ["\xE7\x86\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x8A"],
        ["\xE7\x85\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x8B"],
        ["\xE7\x85\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x8C"],
        ["\xE7\x85\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x8D"],
        ["\xE7\x85\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x8E"],
        ["\xE7\x85\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x8F"],
        ["\xE7\x86\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x90"],
        ["\xE7\x87\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x91"],
        ["\xE7\x86\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x92"],
        ["\xE7\x86\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x93"],
        ["\xE7\x86\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x94"],
        ["\xE7\x86\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x95"],
        ["\xE7\x87\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x96"],
        ["\xE7\x86\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x97"],
        ["\xE7\x86\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x98"],
        ["\xE7\x87\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x99"],
        ["\xE7\x87\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x9A"],
        ["\xE7\x87\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x9B"],
        ["\xE7\x87\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x9C"],
        ["\xE7\x87\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x9D"],
        ["\xE7\x87\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x9E"],
        ["\xE7\x87\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x9F"],
        ["\xE7\x87\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA0"],
        ["\xE7\x87\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA1"],
        ["\xE7\x87\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA2"],
        ["\xE7\x87\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA3"],
        ["\xE7\x88\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA4"],
        ["\xE7\x88\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA5"],
        ["\xE7\x88\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA6"],
        ["\xE7\x88\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA7"],
        ["\xE7\x88\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA8"],
        ["\xE7\x88\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA9"],
        ["\xE7\x88\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xAA"],
        ["\xE7\x88\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xAB"],
        ["\xE7\x88\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xAC"],
        ["\xE7\x88\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xAD"],
        ["\xE7\x88\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xAE"],
        ["\xE7\x89\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xAF"],
        ["\xE7\x89\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB0"],
        ["\xE7\x89\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB1"],
        ["\xE7\x89\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB2"],
        ["\xE7\x89\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB3"],
        ["\xE7\x89\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB4"],
        ["\xE7\x8A\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB5"],
        ["\xE7\x8A\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB6"],
        ["\xE7\x8A\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB7"],
        ["\xE7\x8A\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB8"],
        ["\xE7\x8A\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB9"],
        ["\xE7\x8A\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xBA"],
        ["\xE7\x8A\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xBB"],
        ["\xE7\x8A\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xBC"],
        ["\xE7\x8A\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xBD"],
        ["\xE7\x8B\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xBE"],
        ["\xE7\x8B\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xBF"],
        ["\xE7\x8B\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x80"],
        ["\xE7\x8B\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x81"],
        ["\xE7\x8B\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x82"],
        ["\xE7\x8B\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x83"],
        ["\xE7\x8B\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x84"],
        ["\xE7\x8B\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x85"],
        ["\xE7\x8B\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x86"],
        ["\xE7\x8B\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x87"],
        ["\xE5\x80\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x88"],
        ["\xE7\x8C\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x89"],
        ["\xE7\x8C\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x8A"],
        ["\xE7\x8C\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x8B"],
        ["\xE7\x8C\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x8C"],
        ["\xE7\x8C\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x8D"],
        ["\xE7\x8C\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x8E"],
        ["\xE7\x8C\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x8F"],
        ["\xE7\x8C\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x90"],
        ["\xE7\x8C\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x91"],
        ["\xE7\x8C\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x92"],
        ["\xE7\x8D\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x93"],
        ["\xE7\x8D\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x94"],
        ["\xE9\xBB\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x95"],
        ["\xE7\x8D\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x96"],
        ["\xE7\x8D\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x97"],
        ["\xE7\x8D\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x98"],
        ["\xE7\x8D\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x99"],
        ["\xE7\x8D\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x9A"],
        ["\xE7\x8D\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x9B"],
        ["\xE7\x8D\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x9C"],
        ["\xE7\x8D\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x9D"],
        ["\xE7\x8F\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x9E"],
        ["\xE7\x8E\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x9F"],
        ["\xE7\x8F\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA0"],
        ["\xE7\x8E\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA1"],
        ["\xE7\x8F\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA2"],
        ["\xE7\x8F\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA3"],
        ["\xE7\x8F\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA4"],
        ["\xE7\x8F\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA5"],
        ["\xE7\x92\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA6"],
        ["\xE7\x90\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA7"],
        ["\xE7\x91\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA8"],
        ["\xE7\x90\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA9"],
        ["\xE7\x8F\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xAA"],
        ["\xE7\x90\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xAB"],
        ["\xE7\x90\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xAC"],
        ["\xE7\x91\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xAD"],
        ["\xE7\x90\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xAE"],
        ["\xE7\x91\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xAF"],
        ["\xE7\x91\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB0"],
        ["\xE7\x91\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB1"],
        ["\xE7\x91\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB2"],
        ["\xE7\x91\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB3"],
        ["\xE7\x91\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB4"],
        ["\xE7\x91\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB5"],
        ["\xE7\x91\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB6"],
        ["\xE7\x91\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB7"],
        ["\xE7\x91\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB8"],
        ["\xE7\x92\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB9"],
        ["\xE7\x92\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xBA"],
        ["\xE7\x92\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xBB"],
        ["\xE7\x93\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xBC"],
        ["\xE7\x93\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xBD"],
        ["\xE7\x93\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xBE"],
        ["\xE7\x8F\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xBF"],
        ["\xE7\x93\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x80"],
        ["\xE7\x93\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x81"],
        ["\xE7\x93\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x82"],
        ["\xE7\x93\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x83"],
        ["\xE7\x93\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x84"],
        ["\xE7\x93\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x85"],
        ["\xE7\x93\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x86"],
        ["\xE7\x93\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x87"],
        ["\xE7\x93\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x88"],
        ["\xE7\x93\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x89"],
        ["\xE7\x94\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x8A"],
        ["\xE7\x94\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x8B"],
        ["\xE7\x94\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x8C"],
        ["\xE7\x94\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x8D"],
        ["\xE7\x94\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x8E"],
        ["\xE7\x94\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x8F"],
        ["\xE7\x94\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x90"],
        ["\xE7\x94\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x91"],
        ["\xE7\x94\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x92"],
        ["\xE7\x94\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x93"],
        ["\xE7\x94\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x94"],
        ["\xE7\x94\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x95"],
        ["\xE7\x95\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x96"],
        ["\xE7\x95\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x97"],
        ["\xE7\x95\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x98"],
        ["\xE7\x95\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x99"],
        ["\xE7\x95\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x9A"],
        ["\xE7\x95\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x9B"],
        ["\xE7\x95\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x9C"],
        ["\xE7\x95\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x9D"],
        ["\xE7\x95\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x9E"],
        ["\xE7\x95\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x9F"],
        ["\xE7\x95\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA0"],
        ["\xE7\x95\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA1"],
        ["\xE7\x95\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA2"],
        ["\xE7\x95\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA3"],
        ["\xE7\x96\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA4"],
        ["\xE7\x96\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA5"],
        ["\xE7\x95\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA6"],
        ["\xE7\x96\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA7"],
        ["\xE7\x96\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA8"],
        ["\xE7\x96\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA9"],
        ["\xE7\x96\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xAA"],
        ["\xE7\x96\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xAB"],
        ["\xE7\x96\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xAC"],
        ["\xE7\x96\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xAD"],
        ["\xE7\x96\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xAE"],
        ["\xE7\x97\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xAF"],
        ["\xE7\x96\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB0"],
        ["\xE7\x97\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB1"],
        ["\xE7\x96\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB2"],
        ["\xE7\x96\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB3"],
        ["\xE7\x96\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB4"],
        ["\xE7\x96\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB5"],
        ["\xE7\x96\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB6"],
        ["\xE7\x97\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB7"],
        ["\xE7\x97\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB8"],
        ["\xE7\x97\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB9"],
        ["\xE7\x97\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xBA"],
        ["\xE7\x97\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xBB"],
        ["\xE7\x97\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xBC"],
        ["\xE7\x97\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xBD"],
        ["\xE7\x97\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xBE"],
        ["\xE7\x97\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xBF"],
        ["\xE7\x98\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x80"],
        ["\xE7\x97\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x81"],
        ["\xE7\x97\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x82"],
        ["\xE7\x97\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x83"],
        ["\xE7\x97\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x84"],
        ["\xE7\x98\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x85"],
        ["\xE7\x98\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x86"],
        ["\xE7\x98\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x87"],
        ["\xE7\x98\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x88"],
        ["\xE7\x98\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x89"],
        ["\xE7\x98\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x8A"],
        ["\xE7\x98\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x8B"],
        ["\xE7\x98\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x8C"],
        ["\xE7\x98\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x8D"],
        ["\xE7\x98\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x8E"],
        ["\xE7\x98\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x8F"],
        ["\xE7\x98\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x90"],
        ["\xE7\x99\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x91"],
        ["\xE7\x99\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x92"],
        ["\xE7\x99\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x93"],
        ["\xE7\x99\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x94"],
        ["\xE7\x99\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x95"],
        ["\xE7\x99\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x96"],
        ["\xE7\x99\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x97"],
        ["\xE7\x99\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x98"],
        ["\xE7\x99\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x99"],
        ["\xE7\x99\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x9A"],
        ["\xE7\x99\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x9B"],
        ["\xE7\x99\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x9C"],
        ["\xE7\x99\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x9D"],
        ["\xE7\x99\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x9E"],
        ["\xE7\x99\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x9F"],
        ["\xE7\x99\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA0"],
        ["\xE7\x99\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA1"],
        ["\xE7\x9A\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA2"],
        ["\xE7\x9A\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA3"],
        ["\xE7\x9A\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA4"],
        ["\xE7\x9A\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA5"],
        ["\xE7\x9A\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA6"],
        ["\xE7\x9A\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA7"],
        ["\xE7\x9A\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA8"],
        ["\xE7\x9A\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA9"],
        ["\xE7\x9A\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xAA"],
        ["\xE7\x9A\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xAB"],
        ["\xE7\x9A\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xAC"],
        ["\xE7\x9A\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xAD"],
        ["\xE7\x9A\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xAE"],
        ["\xE7\x9A\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xAF"],
        ["\xE7\x9B\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB0"],
        ["\xE7\x9B\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB1"],
        ["\xE7\x9B\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB2"],
        ["\xE7\x9B\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB3"],
        ["\xE7\x9B\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB4"],
        ["\xE7\x9B\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB5"],
        ["\xE7\x9B\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB6"],
        ["\xE7\x9B\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB7"],
        ["\xE7\x9B\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB8"],
        ["\xE8\x98\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB9"],
        ["\xE7\x9B\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xBA"],
        ["\xE7\x9C\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xBB"],
        ["\xE7\x9C\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xBC"],
        ["\xE7\x9C\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xBD"],
        ["\xE7\x9C\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xBE"],
        ["\xE7\x9C\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xBF"],
        ["\xE7\x9C\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x80"],
        ["\xE7\x9C\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x81"],
        ["\xE7\x9C\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x82"],
        ["\xE7\x9C\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x83"],
        ["\xE7\x9C\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x84"],
        ["\xE7\x9C\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x85"],
        ["\xE7\x9D\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x86"],
        ["\xE7\x9D\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x87"],
        ["\xE7\x9D\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x88"],
        ["\xE7\x9D\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x89"],
        ["\xE7\x9D\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x8A"],
        ["\xE7\x9D\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x8B"],
        ["\xE7\x9D\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x8C"],
        ["\xE7\x9D\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x8D"],
        ["\xE7\x9D\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x8E"],
        ["\xE7\x9E\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x8F"],
        ["\xE7\x9E\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x90"],
        ["\xE7\x9E\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x91"],
        ["\xE7\x9E\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x92"],
        ["\xE7\x9E\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x93"],
        ["\xE7\x9E\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x94"],
        ["\xE7\x9E\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x95"],
        ["\xE7\x9E\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x96"],
        ["\xE7\x9E\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x97"],
        ["\xE7\x9E\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x98"],
        ["\xE7\x9E\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x99"],
        ["\xE7\x9E\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x9A"],
        ["\xE7\x9F\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x9B"],
        ["\xE7\x9F\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x9C"],
        ["\xE7\x9F\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x9D"],
        ["\xE7\x9F\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x9E"],
        ["\xE7\x9F\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x9F"],
        ["\xE7\x9F\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA0"],
        ["\xE7\x9F\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA1"],
        ["\xE7\x9F\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA2"],
        ["\xE7\xA0\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA3"],
        ["\xE7\xA0\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA4"],
        ["\xE7\xA4\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA5"],
        ["\xE7\xA0\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA6"],
        ["\xE7\xA4\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA7"],
        ["\xE7\xA1\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA8"],
        ["\xE7\xA2\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA9"],
        ["\xE7\xA1\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xAA"],
        ["\xE7\xA2\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xAB"],
        ["\xE7\xA1\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xAC"],
        ["\xE7\xA2\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xAD"],
        ["\xE7\xA2\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xAE"],
        ["\xE7\xA2\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xAF"],
        ["\xE7\xA2\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB0"],
        ["\xE7\xA2\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB1"],
        ["\xE7\xA2\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB2"],
        ["\xE7\xA3\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB3"],
        ["\xE7\xA3\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB4"],
        ["\xE7\xA3\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB5"],
        ["\xE7\xA3\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB6"],
        ["\xE7\xA2\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB7"],
        ["\xE7\xA2\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB8"],
        ["\xE7\xA3\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB9"],
        ["\xE7\xA3\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xBA"],
        ["\xE7\xA3\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xBB"],
        ["\xE7\xA3\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xBC"],
        ["\xE7\xA3\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xBD"],
        ["\xE7\xA3\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xBE"],
        ["\xE7\xA3\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xBF"],
        ["\xE7\xA4\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x80"],
        ["\xE7\xA4\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x81"],
        ["\xE7\xA4\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x82"],
        ["\xE7\xA4\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x83"],
        ["\xE7\xA4\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x84"],
        ["\xE7\xA4\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x85"],
        ["\xE7\xA5\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x86"],
        ["\xE7\xA5\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x87"],
        ["\xE7\xA5\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x88"],
        ["\xE7\xA5\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x89"],
        ["\xE7\xA5\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x8A"],
        ["\xE7\xA5\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x8B"],
        ["\xE7\xA5\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x8C"],
        ["\xE7\xA5\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x8D"],
        ["\xE7\xA5\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x8E"],
        ["\xE7\xA6\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x8F"],
        ["\xE7\xA6\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x90"],
        ["\xE7\xA6\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x91"],
        ["\xE9\xBD\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x92"],
        ["\xE7\xA6\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x93"],
        ["\xE7\xA6\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x94"],
        ["\xE7\xA6\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x95"],
        ["\xE7\xA6\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x96"],
        ["\xE7\xA6\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x97"],
        ["\xE7\xA7\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x98"],
        ["\xE7\xA7\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x99"],
        ["\xE7\xA7\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x9A"],
        ["\xE7\xA7\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x9B"],
        ["\xE7\xA7\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x9C"],
        ["\xE7\xA7\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x9D"],
        ["\xE7\xA8\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x9E"],
        ["\xE7\xA8\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x9F"],
        ["\xE7\xA8\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA0"],
        ["\xE7\xA8\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA1"],
        ["\xE7\xA8\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA2"],
        ["\xE7\xA8\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA3"],
        ["\xE7\xA6\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA4"],
        ["\xE7\xA8\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA5"],
        ["\xE7\xA8\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA6"],
        ["\xE7\xA8\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA7"],
        ["\xE7\xA8\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA8"],
        ["\xE7\xA9\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA9"],
        ["\xE7\xA9\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xAA"],
        ["\xE7\xA9\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xAB"],
        ["\xE7\xA9\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xAC"],
        ["\xE7\xA9\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xAD"],
        ["\xE7\xA9\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xAE"],
        ["\xE9\xBE\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xAF"],
        ["\xE7\xA9\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB0"],
        ["\xE7\xA9\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB1"],
        ["\xE7\xA9\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB2"],
        ["\xE7\xAA\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB3"],
        ["\xE7\xAA\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB4"],
        ["\xE7\xAA\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB5"],
        ["\xE7\xAA\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB6"],
        ["\xE7\xAA\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB7"],
        ["\xE7\xAA\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB8"],
        ["\xE7\xAB\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB9"],
        ["\xE7\xAA\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xBA"],
        ["\xE7\xAA\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xBB"],
        ["\xE7\xAB\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xBC"],
        ["\xE7\xAB\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xBD"],
        ["\xE7\xAA\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xBE"],
        ["\xE9\x82\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xBF"],
        ["\xE7\xAB\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x80"],
        ["\xE7\xAB\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x81"],
        ["\xE7\xAB\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x82"],
        ["\xE7\xAB\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x83"],
        ["\xE7\xAB\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x84"],
        ["\xE7\xAB\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x85"],
        ["\xE7\xAB\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x86"],
        ["\xE7\xAB\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x87"],
        ["\xE7\xAB\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x88"],
        ["\xE7\xAB\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x89"],
        ["\xE7\xAB\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x8A"],
        ["\xE7\xAB\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x8B"],
        ["\xE7\xAB\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x8C"],
        ["\xE7\xAB\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x8D"],
        ["\xE7\xAC\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x8E"],
        ["\xE7\xAC\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x8F"],
        ["\xE7\xAC\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x90"],
        ["\xE7\xAC\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x91"],
        ["\xE7\xAC\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x92"],
        ["\xE7\xAC\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x93"],
        ["\xE7\xAC\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x94"],
        ["\xE7\xAC\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x95"],
        ["\xE7\xAC\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x96"],
        ["\xE7\xAC\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x97"],
        ["\xE7\xAC\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x98"],
        ["\xE7\xAD\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x99"],
        ["\xE7\xAD\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x9A"],
        ["\xE7\xAC\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x9B"],
        ["\xE7\xAD\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x9C"],
        ["\xE7\xAC\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x9D"],
        ["\xE7\xAD\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x9E"],
        ["\xE7\xAD\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x9F"],
        ["\xE7\xAD\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA0"],
        ["\xE7\xAD\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA1"],
        ["\xE7\xAD\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA2"],
        ["\xE7\xAD\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA3"],
        ["\xE7\xAD\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA4"],
        ["\xE7\xAD\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA5"],
        ["\xE7\xAD\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA6"],
        ["\xE7\xAD\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA7"],
        ["\xE7\xAE\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA8"],
        ["\xE7\xAE\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA9"],
        ["\xE7\xAE\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xAA"],
        ["\xE7\xAE\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xAB"],
        ["\xE7\xAE\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xAC"],
        ["\xE7\xAE\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xAD"],
        ["\xE7\xAE\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xAE"],
        ["\xE7\xAE\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xAF"],
        ["\xE7\xAE\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB0"],
        ["\xE7\xAD\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB1"],
        ["\xE7\xAE\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB2"],
        ["\xE7\xAF\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB3"],
        ["\xE7\xAF\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB4"],
        ["\xE7\xAF\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB5"],
        ["\xE7\xAF\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB6"],
        ["\xE7\xAE\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB7"],
        ["\xE7\xAF\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB8"],
        ["\xE7\xAF\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB9"],
        ["\xE7\xAF\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xBA"],
        ["\xE7\xB0\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xBB"],
        ["\xE7\xB0\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xBC"],
        ["\xE7\xAF\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xBD"],
        ["\xE7\xAF\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xBE"],
        ["\xE7\xB1\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xBF"],
        ["\xE7\xB0\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x80"],
        ["\xE7\xB0\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x81"],
        ["\xE7\xB0\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x82"],
        ["\xE7\xAF\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x83"],
        ["\xE7\xAF\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x84"],
        ["\xE7\xB0\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x85"],
        ["\xE7\xB0\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x86"],
        ["\xE7\xAF\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x87"],
        ["\xE7\xB0\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x88"],
        ["\xE7\xB0\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x89"],
        ["\xE7\xB0\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x8A"],
        ["\xE7\xB0\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x8B"],
        ["\xE7\xB0\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x8C"],
        ["\xE7\xB0\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x8D"],
        ["\xE7\xB0\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x8E"],
        ["\xE7\xB1\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x8F"],
        ["\xE7\xB1\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x90"],
        ["\xE7\xB1\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x91"],
        ["\xE7\xB1\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x92"],
        ["\xE7\xB1\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x93"],
        ["\xE7\xB1\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x94"],
        ["\xE7\xB1\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x95"],
        ["\xE7\xB1\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x96"],
        ["\xE7\xB1\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x97"],
        ["\xE7\xB1\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x98"],
        ["\xE7\xB1\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x99"],
        ["\xE7\xB1\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x9A"],
        ["\xE7\xB1\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x9B"],
        ["\xE7\xB2\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x9C"],
        ["\xE7\xB2\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x9D"],
        ["\xE7\xB2\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x9E"],
        ["\xE7\xB2\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x9F"],
        ["\xE7\xB2\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA0"],
        ["\xE7\xB2\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA1"],
        ["\xE7\xB2\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA2"],
        ["\xE7\xB2\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA3"],
        ["\xE7\xB2\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA4"],
        ["\xE7\xB2\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA5"],
        ["\xE7\xB2\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA6"],
        ["\xE7\xB2\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA7"],
        ["\xE7\xB2\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA8"],
        ["\xE7\xB2\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA9"],
        ["\xE7\xB3\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xAA"],
        ["\xE7\xB3\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xAB"],
        ["\xE7\xB3\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xAC"],
        ["\xE7\xB3\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xAD"],
        ["\xE7\xB3\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xAE"],
        ["\xE7\xB3\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xAF"],
        ["\xE7\xB3\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB0"],
        ["\xE9\xAC\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB1"],
        ["\xE7\xB3\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB2"],
        ["\xE7\xB3\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB3"],
        ["\xE7\xB3\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB4"],
        ["\xE7\xB3\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB5"],
        ["\xE7\xB3\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB6"],
        ["\xE7\xB4\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB7"],
        ["\xE7\xB4\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB8"],
        ["\xE7\xB4\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB9"],
        ["\xE7\xB4\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xBA"],
        ["\xE7\xB4\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xBB"],
        ["\xE7\xB5\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xBC"],
        ["\xE7\xB5\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xBD"],
        ["\xE7\xB4\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xBE"],
        ["\xE7\xB4\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xBF"],
        ["\xE7\xB4\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x80"],
        ["\xE7\xB4\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x81"],
        ["\xE7\xB5\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x82"],
        ["\xE7\xB5\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x83"],
        ["\xE7\xB5\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x84"],
        ["\xE7\xB5\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x85"],
        ["\xE7\xB5\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x86"],
        ["\xE7\xB5\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x87"],
        ["\xE7\xB5\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x88"],
        ["\xE7\xB5\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x89"],
        ["\xE7\xB5\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x8A"],
        ["\xE7\xB6\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x8B"],
        ["\xE7\xB6\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x8C"],
        ["\xE7\xB5\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x8D"],
        ["\xE7\xB6\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x8E"],
        ["\xE7\xB5\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x8F"],
        ["\xE7\xB6\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x90"],
        ["\xE7\xB6\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x91"],
        ["\xE7\xB6\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x92"],
        ["\xE7\xB6\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x93"],
        ["\xE7\xB6\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x94"],
        ["\xE7\xB7\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x95"],
        ["\xE7\xB6\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x96"],
        ["\xE7\xB6\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x97"],
        ["\xE7\xB8\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x98"],
        ["\xE7\xB6\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x99"],
        ["\xE7\xB6\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x9A"],
        ["\xE7\xB7\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x9B"],
        ["\xE7\xB6\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x9C"],
        ["\xE7\xB6\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x9D"],
        ["\xE7\xB6\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x9E"],
        ["\xE7\xB7\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x9F"],
        ["\xE7\xB7\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA0"],
        ["\xE7\xB7\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA1"],
        ["\xE7\xB7\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA2"],
        ["\xE7\xB7\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA3"],
        ["\xE7\xB7\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA4"],
        ["\xE7\xB7\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA5"],
        ["\xE7\xB8\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA6"],
        ["\xE7\xB8\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA7"],
        ["\xE7\xB8\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA8"],
        ["\xE7\xB8\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA9"],
        ["\xE7\xB8\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xAA"],
        ["\xE7\xB8\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xAB"],
        ["\xE7\xB8\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xAC"],
        ["\xE7\xB8\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xAD"],
        ["\xE7\xB8\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xAE"],
        ["\xE7\xB8\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xAF"],
        ["\xE7\xB9\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB0"],
        ["\xE7\xB9\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB1"],
        ["\xE7\xB8\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB2"],
        ["\xE7\xB8\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB3"],
        ["\xE7\xB8\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB4"],
        ["\xE7\xB9\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB5"],
        ["\xE7\xB8\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB6"],
        ["\xE7\xB8\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB7"],
        ["\xE7\xB8\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB8"],
        ["\xE7\xB9\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB9"],
        ["\xE7\xB9\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xBA"],
        ["\xE7\xB9\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xBB"],
        ["\xE7\xB9\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xBC"],
        ["\xE7\xB9\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xBD"],
        ["\xE7\xB9\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xBE"],
        ["\xE7\xB9\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xBF"],
        ["\xE7\xB9\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x80"],
        ["\xE7\xB9\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x81"],
        ["\xE7\xB9\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x82"],
        ["\xE7\xB9\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x83"],
        ["\xE7\xBA\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x84"],
        ["\xE7\xB7\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x85"],
        ["\xE7\xB9\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x86"],
        ["\xE8\xBE\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x87"],
        ["\xE7\xB9\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x88"],
        ["\xE7\xBA\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x89"],
        ["\xE7\xBA\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x8A"],
        ["\xE7\xBA\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x8B"],
        ["\xE7\xBA\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x8C"],
        ["\xE7\xBA\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x8D"],
        ["\xE7\xBA\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x8E"],
        ["\xE7\xBA\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x8F"],
        ["\xE7\xBA\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x90"],
        ["\xE7\xBA\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x91"],
        ["\xE7\xBA\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x92"],
        ["\xE7\xBA\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x93"],
        ["\xE7\xBC\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x94"],
        ["\xE7\xBC\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x95"],
        ["\xE7\xBD\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x96"],
        ["\xE7\xBD\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x97"],
        ["\xE7\xBD\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x98"],
        ["\xE7\xBD\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x99"],
        ["\xE7\xBD\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x9A"],
        ["\xE7\xBD\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x9B"],
        ["\xE7\xBD\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x9C"],
        ["\xE7\xBD\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x9D"],
        ["\xE7\xBD\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x9E"],
        ["\xE7\xBD\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x9F"],
        ["\xE7\xBD\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA0"],
        ["\xE7\xBD\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA1"],
        ["\xE7\xBD\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA2"],
        ["\xE7\xBD\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA3"],
        ["\xE7\xBD\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA4"],
        ["\xE7\xBE\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA5"],
        ["\xE7\xBE\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA6"],
        ["\xE7\xBE\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA7"],
        ["\xE7\xBE\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA8"],
        ["\xE7\xBE\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA9"],
        ["\xE7\xBE\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xAA"],
        ["\xE7\xBE\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xAB"],
        ["\xE7\xBE\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xAC"],
        ["\xE7\xBE\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xAD"],
        ["\xE7\xBE\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xAE"],
        ["\xE7\xBE\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xAF"],
        ["\xE7\xBE\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB0"],
        ["\xE7\xBE\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB1"],
        ["\xE7\xBE\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB2"],
        ["\xE7\xBE\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB3"],
        ["\xE7\xBE\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB4"],
        ["\xE7\xBE\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB5"],
        ["\xE8\xAD\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB6"],
        ["\xE7\xBF\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB7"],
        ["\xE7\xBF\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB8"],
        ["\xE7\xBF\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB9"],
        ["\xE7\xBF\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xBA"],
        ["\xE7\xBF\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xBB"],
        ["\xE7\xBF\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xBC"],
        ["\xE7\xBF\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xBD"],
        ["\xE7\xBF\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xBE"],
        ["\xE7\xBF\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xBF"],
        ["\xE7\xBF\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x80"],
        ["\xE9\xA3\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x81"],
        ["\xE8\x80\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x82"],
        ["\xE8\x80\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x83"],
        ["\xE8\x80\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x84"],
        ["\xE8\x80\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x85"],
        ["\xE8\x80\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x86"],
        ["\xE8\x80\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x87"],
        ["\xE8\x80\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x88"],
        ["\xE8\x80\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x89"],
        ["\xE8\x80\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x8A"],
        ["\xE8\x80\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x8B"],
        ["\xE8\x80\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x8C"],
        ["\xE8\x81\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x8D"],
        ["\xE8\x81\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x8E"],
        ["\xE8\x81\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x8F"],
        ["\xE8\x81\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x90"],
        ["\xE8\x81\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x91"],
        ["\xE8\x81\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x92"],
        ["\xE8\x81\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x93"],
        ["\xE8\x81\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x94"],
        ["\xE8\x81\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x95"],
        ["\xE8\x81\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x96"],
        ["\xE8\x81\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x97"],
        ["\xE8\x81\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x98"],
        ["\xE8\x81\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x99"],
        ["\xE8\x81\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x9A"],
        ["\xE8\x81\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x9B"],
        ["\xE8\x82\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x9C"],
        ["\xE8\x82\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x9D"],
        ["\xE8\x82\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x9E"],
        ["\xE8\x82\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x9F"],
        ["\xE8\x82\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA0"],
        ["\xE8\x82\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA1"],
        ["\xE8\x82\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA2"],
        ["\xE5\x86\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA3"],
        ["\xE8\x82\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA4"],
        ["\xE8\x83\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA5"],
        ["\xE8\x83\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA6"],
        ["\xE8\x83\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA7"],
        ["\xE8\x83\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA8"],
        ["\xE8\x83\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA9"],
        ["\xE8\x83\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xAA"],
        ["\xE8\x83\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xAB"],
        ["\xE8\x84\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xAC"],
        ["\xE8\x83\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xAD"],
        ["\xE8\x83\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xAE"],
        ["\xE8\x84\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xAF"],
        ["\xE8\x84\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB0"],
        ["\xE8\x84\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB1"],
        ["\xE8\x84\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB2"],
        ["\xE8\x85\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB3"],
        ["\xE9\x9A\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB4"],
        ["\xE8\x85\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB5"],
        ["\xE8\x84\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB6"],
        ["\xE8\x85\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB7"],
        ["\xE8\x85\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB8"],
        ["\xE8\x83\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB9"],
        ["\xE8\x85\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xBA"],
        ["\xE8\x85\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xBB"],
        ["\xE8\x85\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xBC"],
        ["\xE8\x85\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xBD"],
        ["\xE8\x85\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xBE"],
        ["\xE8\x86\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xBF"],
        ["\xE8\x86\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x80"],
        ["\xE8\x86\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x81"],
        ["\xE8\x86\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x82"],
        ["\xE8\x86\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x83"],
        ["\xE8\x86\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x84"],
        ["\xE8\x86\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x85"],
        ["\xE8\x86\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x86"],
        ["\xE8\x86\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x87"],
        ["\xE8\x85\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x88"],
        ["\xE8\x86\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x89"],
        ["\xE8\x86\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x8A"],
        ["\xE8\x86\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x8B"],
        ["\xE8\x86\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x8C"],
        ["\xE8\x86\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x8D"],
        ["\xE8\x86\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x8E"],
        ["\xE8\x86\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x8F"],
        ["\xE8\x87\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x90"],
        ["\xE8\x87\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x91"],
        ["\xE8\x86\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x92"],
        ["\xE8\x87\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x93"],
        ["\xE8\x87\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x94"],
        ["\xE8\x87\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x95"],
        ["\xE8\x87\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x96"],
        ["\xE8\x87\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x97"],
        ["\xE8\x87\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x98"],
        ["\xE8\x87\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x99"],
        ["\xE8\x87\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x9A"],
        ["\xE8\x87\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x9B"],
        ["\xE8\x87\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x9C"],
        ["\xE8\x87\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x9D"],
        ["\xE8\x87\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x9E"],
        ["\xE8\x87\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x9F"],
        ["\xE8\x88\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA0"],
        ["\xE8\x88\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA1"],
        ["\xE8\x88\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA2"],
        ["\xE8\x88\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA3"],
        ["\xE8\x88\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA4"],
        ["\xE8\x88\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA5"],
        ["\xE8\x88\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA6"],
        ["\xE8\x88\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA7"],
        ["\xE8\x88\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA8"],
        ["\xE8\x88\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA9"],
        ["\xE8\x88\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xAA"],
        ["\xE8\x88\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xAB"],
        ["\xE8\x89\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xAC"],
        ["\xE8\x89\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xAD"],
        ["\xE8\x89\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xAE"],
        ["\xE8\x89\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xAF"],
        ["\xE8\x89\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB0"],
        ["\xE8\x89\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB1"],
        ["\xE8\x89\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB2"],
        ["\xE8\x89\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB3"],
        ["\xE8\x89\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB4"],
        ["\xE8\x89\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB5"],
        ["\xE8\x89\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB6"],
        ["\xE8\x88\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB7"],
        ["\xE8\x89\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB8"],
        ["\xE8\x89\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB9"],
        ["\xE8\x89\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xBA"],
        ["\xE8\x89\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xBB"],
        ["\xE8\x8A\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xBC"],
        ["\xE8\x8A\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xBD"],
        ["\xE8\x8A\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xBE"],
        ["\xE8\x8A\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xBF"],
        ["\xE8\x8A\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x80"],
        ["\xE8\x8A\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x81"],
        ["\xE8\x8B\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x82"],
        ["\xE8\x8B\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x83"],
        ["\xE8\x8B\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x84"],
        ["\xE8\x8B\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x85"],
        ["\xE8\x8B\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x86"],
        ["\xE8\x8B\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x87"],
        ["\xE8\x8B\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x88"],
        ["\xE8\x8E\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x89"],
        ["\xE8\x8C\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x8A"],
        ["\xE8\x8B\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x8B"],
        ["\xE8\x8B\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x8C"],
        ["\xE8\x8B\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x8D"],
        ["\xE8\x8C\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x8E"],
        ["\xE8\x8B\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x8F"],
        ["\xE8\x8C\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x90"],
        ["\xE8\x8B\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x91"],
        ["\xE8\x8C\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x92"],
        ["\xE8\x8C\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x93"],
        ["\xE8\x8C\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x94"],
        ["\xE8\x8C\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x95"],
        ["\xE8\x8C\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x96"],
        ["\xE8\x8D\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x97"],
        ["\xE8\x8C\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x98"],
        ["\xE8\x8D\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x99"],
        ["\xE8\x8D\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x9A"],
        ["\xE8\x8C\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x9B"],
        ["\xE8\x8C\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x9C"],
        ["\xE8\x8C\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x9D"],
        ["\xE8\x8C\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x9E"],
        ["\xE8\x8E\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x9F"],
        ["\xE8\x8E\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA0"],
        ["\xE8\x8E\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA1"],
        ["\xE8\x8E\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA2"],
        ["\xE8\x8E\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA3"],
        ["\xE8\x8E\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA4"],
        ["\xE8\x8C\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA5"],
        ["\xE8\x8E\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA6"],
        ["\xE8\x8E\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA7"],
        ["\xE8\x8E\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA8"],
        ["\xE8\x8D\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA9"],
        ["\xE8\x8E\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xAA"],
        ["\xE8\x8D\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xAB"],
        ["\xE8\x8D\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xAC"],
        ["\xE8\x8E\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xAD"],
        ["\xE8\x8E\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xAE"],
        ["\xE8\x8E\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xAF"],
        ["\xE8\x8F\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB0"],
        ["\xE8\x90\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB1"],
        ["\xE8\x8F\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB2"],
        ["\xE8\x8F\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB3"],
        ["\xE8\x8F\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB4"],
        ["\xE8\x90\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB5"],
        ["\xE8\x8F\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB6"],
        ["\xE8\x90\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB7"],
        ["\xE8\x8F\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB8"],
        ["\xE8\x8F\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB9"],
        ["\xE8\x90\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xBA"],
        ["\xE8\x8F\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xBB"],
        ["\xE8\x8F\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xBC"],
        ["\xE8\x90\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xBD"],
        ["\xE8\x90\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xBE"],
        ["\xE8\x90\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xBF"],
        ["\xE8\x8E\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x80"],
        ["\xE8\x90\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x81"],
        ["\xE8\x94\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x82"],
        ["\xE8\x8F\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x83"],
        ["\xE8\x91\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x84"],
        ["\xE8\x90\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x85"],
        ["\xE8\x90\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x86"],
        ["\xE8\x95\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x87"],
        ["\xE8\x92\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x88"],
        ["\xE8\x91\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x89"],
        ["\xE8\x91\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x8A"],
        ["\xE8\x92\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x8B"],
        ["\xE8\x91\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x8C"],
        ["\xE8\x92\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x8D"],
        ["\xE8\x91\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x8E"],
        ["\xE8\x91\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x8F"],
        ["\xE8\x90\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x90"],
        ["\xE8\x91\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x91"],
        ["\xE8\x91\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x92"],
        ["\xE8\x90\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x93"],
        ["\xE8\x93\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x94"],
        ["\xE8\x91\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x95"],
        ["\xE8\x92\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x96"],
        ["\xE8\x92\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x97"],
        ["\xE8\x92\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x98"],
        ["\xE8\x93\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x99"],
        ["\xE8\x93\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x9A"],
        ["\xE8\x92\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x9B"],
        ["\xE8\x93\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x9C"],
        ["\xE8\x93\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x9D"],
        ["\xE8\x93\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x9E"],
        ["\xE8\x93\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x9F"],
        ["\xE8\x93\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA0"],
        ["\xE8\x92\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA1"],
        ["\xE8\x94\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA2"],
        ["\xE8\x93\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA3"],
        ["\xE8\x93\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA4"],
        ["\xE8\x94\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA5"],
        ["\xE8\x94\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA6"],
        ["\xE8\x94\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA7"],
        ["\xE8\x94\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA8"],
        ["\xE8\x94\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA9"],
        ["\xE8\x94\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xAA"],
        ["\xE8\x93\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xAB"],
        ["\xE8\x95\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xAC"],
        ["\xE8\x95\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xAD"],
        ["\xE8\x95\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xAE"],
        ["\xE8\x95\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xAF"],
        ["\xE8\x95\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB0"],
        ["\xE8\x98\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB1"],
        ["\xE8\x95\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB2"],
        ["\xE8\x95\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB3"],
        ["\xE8\x96\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB4"],
        ["\xE8\x96\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB5"],
        ["\xE8\x96\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB6"],
        ["\xE8\x96\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB7"],
        ["\xE8\x96\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB8"],
        ["\xE8\x96\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB9"],
        ["\xE8\x95\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xBA"],
        ["\xE8\x96\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xBB"],
        ["\xE8\x96\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xBC"],
        ["\xE8\x97\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xBD"],
        ["\xE8\x96\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xBE"],
        ["\xE8\x96\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xBF"],
        ["\xE8\x95\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x80"],
        ["\xE8\x95\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x81"],
        ["\xE8\x96\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x82"],
        ["\xE8\x97\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x83"],
        ["\xE8\x96\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x84"],
        ["\xE8\x97\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x85"],
        ["\xE8\x96\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x86"],
        ["\xE8\x97\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x87"],
        ["\xE8\x97\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x88"],
        ["\xE8\x97\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x89"],
        ["\xE8\x97\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x8A"],
        ["\xE8\x97\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x8B"],
        ["\xE8\x97\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x8C"],
        ["\xE8\x98\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x8D"],
        ["\xE8\x98\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x8E"],
        ["\xE8\x98\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x8F"],
        ["\xE8\x97\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x90"],
        ["\xE8\x97\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x91"],
        ["\xE8\x98\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x92"],
        ["\xE8\x98\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x93"],
        ["\xE8\x98\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x94"],
        ["\xE8\x98\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x95"],
        ["\xE8\x98\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x96"],
        ["\xE8\x99\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x97"],
        ["\xE4\xB9\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x98"],
        ["\xE8\x99\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x99"],
        ["\xE8\x99\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x9A"],
        ["\xE8\x99\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x9B"],
        ["\xE8\x99\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x9C"],
        ["\xE8\x9A\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x9D"],
        ["\xE8\x9A\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x9E"],
        ["\xE8\x9A\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x9F"],
        ["\xE8\x9A\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA0"],
        ["\xE8\x9A\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA1"],
        ["\xE8\x9A\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA2"],
        ["\xE8\x9A\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA3"],
        ["\xE8\x9A\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA4"],
        ["\xE8\x9B\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA5"],
        ["\xE8\x9B\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA6"],
        ["\xE8\x9A\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA7"],
        ["\xE8\x9B\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA8"],
        ["\xE8\xA0\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA9"],
        ["\xE8\x9A\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xAA"],
        ["\xE8\x9B\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xAB"],
        ["\xE8\x9B\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xAC"],
        ["\xE8\x9B\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xAD"],
        ["\xE8\x9B\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xAE"],
        ["\xE8\x9B\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xAF"],
        ["\xE8\x9B\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB0"],
        ["\xE8\x9B\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB1"],
        ["\xE8\x9C\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB2"],
        ["\xE8\x9C\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB3"],
        ["\xE8\x9C\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB4"],
        ["\xE8\x9C\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB5"],
        ["\xE8\x9C\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB6"],
        ["\xE8\x9B\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB7"],
        ["\xE8\x9C\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB8"],
        ["\xE8\x9C\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB9"],
        ["\xE8\x9C\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xBA"],
        ["\xE8\x9B\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xBB"],
        ["\xE8\x9C\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xBC"],
        ["\xE8\x9C\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xBD"],
        ["\xE8\x9C\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xBE"],
        ["\xE8\x9C\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xBF"],
        ["\xE8\x9C\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x80"],
        ["\xE8\x9C\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x81"],
        ["\xE8\x9C\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x82"],
        ["\xE8\x9C\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x83"],
        ["\xE8\x9D\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x84"],
        ["\xE8\x9D\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x85"],
        ["\xE8\x9D\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x86"],
        ["\xE8\x9D\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x87"],
        ["\xE8\x9D\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x88"],
        ["\xE8\x9D\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x89"],
        ["\xE8\x9D\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x8A"],
        ["\xE8\x9D\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x8B"],
        ["\xE8\x9D\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x8C"],
        ["\xE8\x9D\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x8D"],
        ["\xE8\x9D\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x8E"],
        ["\xE8\x9D\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x8F"],
        ["\xE8\x9D\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x90"],
        ["\xE8\xA0\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x91"],
        ["\xE8\x9E\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x92"],
        ["\xE8\x9E\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x93"],
        ["\xE8\x9E\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x94"],
        ["\xE8\x9E\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x95"],
        ["\xE8\x9F\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x96"],
        ["\xE8\x9E\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x97"],
        ["\xE8\x9F\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x98"],
        ["\xE8\x9F\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x99"],
        ["\xE9\x9B\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x9A"],
        ["\xE8\x9E\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x9B"],
        ["\xE8\x9F\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x9C"],
        ["\xE8\x9E\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x9D"],
        ["\xE8\x9F\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x9E"],
        ["\xE8\x9F\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x9F"],
        ["\xE8\x9E\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA0"],
        ["\xE8\x9F\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA1"],
        ["\xE8\x9F\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA2"],
        ["\xE8\x9F\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA3"],
        ["\xE8\xA0\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA4"],
        ["\xE8\xA0\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA5"],
        ["\xE8\x9F\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA6"],
        ["\xE8\x9F\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA7"],
        ["\xE8\x9F\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA8"],
        ["\xE8\xA0\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA9"],
        ["\xE8\x9F\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xAA"],
        ["\xE8\xA0\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xAB"],
        ["\xE8\xA0\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xAC"],
        ["\xE8\xA0\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xAD"],
        ["\xE8\xA0\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xAE"],
        ["\xE8\xA0\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xAF"],
        ["\xE8\xA0\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB0"],
        ["\xE8\xA0\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB1"],
        ["\xE8\xA0\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB2"],
        ["\xE8\xA0\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB3"],
        ["\xE8\xA0\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB4"],
        ["\xE8\xA1\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB5"],
        ["\xE8\xA1\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB6"],
        ["\xE8\xA1\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB7"],
        ["\xE8\xA1\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB8"],
        ["\xE8\xA1\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB9"],
        ["\xE8\xA1\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xBA"],
        ["\xE8\xA1\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xBB"],
        ["\xE8\xA2\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xBC"],
        ["\xE8\xA1\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xBD"],
        ["\xE8\xA2\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xBE"],
        ["\xE8\xA1\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xBF"],
        ["\xE8\xA1\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x80"],
        ["\xE8\xA2\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x81"],
        ["\xE8\xA1\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x82"],
        ["\xE8\xA2\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x83"],
        ["\xE8\xA2\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x84"],
        ["\xE8\xA2\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x85"],
        ["\xE8\xA2\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x86"],
        ["\xE8\xA2\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x87"],
        ["\xE8\xA2\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x88"],
        ["\xE8\xA2\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x89"],
        ["\xE8\xA2\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x8A"],
        ["\xE8\xA2\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x8B"],
        ["\xE8\xA2\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x8C"],
        ["\xE8\xA2\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x8D"],
        ["\xE8\xA3\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x8E"],
        ["\xE8\xA3\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x8F"],
        ["\xE8\xA3\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x90"],
        ["\xE8\xA3\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x91"],
        ["\xE8\xA3\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x92"],
        ["\xE8\xA3\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x93"],
        ["\xE8\xA3\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x94"],
        ["\xE8\xA4\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x95"],
        ["\xE8\xA3\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x96"],
        ["\xE8\xA3\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x97"],
        ["\xE8\xA3\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x98"],
        ["\xE8\xA3\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x99"],
        ["\xE8\xA4\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x9A"],
        ["\xE8\xA4\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x9B"],
        ["\xE8\xA4\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x9C"],
        ["\xE8\xA4\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x9D"],
        ["\xE8\xA5\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x9E"],
        ["\xE8\xA4\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x9F"],
        ["\xE8\xA4\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA0"],
        ["\xE8\xA4\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA1"],
        ["\xE8\xA4\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA2"],
        ["\xE8\xA5\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA3"],
        ["\xE8\xA5\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA4"],
        ["\xE8\xA4\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA5"],
        ["\xE8\xA4\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA6"],
        ["\xE8\xA4\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA7"],
        ["\xE8\xA5\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA8"],
        ["\xE8\xA4\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA9"],
        ["\xE8\xA5\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xAA"],
        ["\xE8\xA5\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xAB"],
        ["\xE8\xA5\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xAC"],
        ["\xE8\xA5\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xAD"],
        ["\xE8\xA5\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xAE"],
        ["\xE8\xA5\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xAF"],
        ["\xE8\xA5\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB0"],
        ["\xE8\xA5\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB1"],
        ["\xE8\xA5\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB2"],
        ["\xE8\xA5\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB3"],
        ["\xE8\xA6\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB4"],
        ["\xE8\xA6\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB5"],
        ["\xE8\xA6\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB6"],
        ["\xE8\xA6\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB7"],
        ["\xE8\xA6\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB8"],
        ["\xE8\xA6\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB9"],
        ["\xE8\xA6\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xBA"],
        ["\xE8\xA6\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xBB"],
        ["\xE8\xA6\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xBC"],
        ["\xE8\xA6\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xBD"],
        ["\xE8\xA6\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xBE"],
        ["\xE8\xA6\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xBF"],
        ["\xE8\xA6\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x80"],
        ["\xE8\xA6\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x81"],
        ["\xE8\xA7\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x82"],
        ["\xE8\xA7\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x83"],
        ["\xE8\xA7\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x84"],
        ["\xE8\xA7\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x85"],
        ["\xE8\xA7\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x86"],
        ["\xE8\xA7\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x87"],
        ["\xE8\xA7\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x88"],
        ["\xE8\xA8\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x89"],
        ["\xE8\xA8\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x8A"],
        ["\xE8\xA8\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x8B"],
        ["\xE8\xA8\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x8C"],
        ["\xE8\xA8\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x8D"],
        ["\xE8\xA8\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x8E"],
        ["\xE8\xA8\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x8F"],
        ["\xE8\xA8\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x90"],
        ["\xE8\xA9\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x91"],
        ["\xE8\xA9\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x92"],
        ["\xE8\xA9\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x93"],
        ["\xE8\xA9\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x94"],
        ["\xE8\xA9\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x95"],
        ["\xE8\xA9\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x96"],
        ["\xE8\xA9\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x97"],
        ["\xE8\xA9\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x98"],
        ["\xE8\xA9\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x99"],
        ["\xE8\xAA\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x9A"],
        ["\xE8\xAA\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x9B"],
        ["\xE8\xAA\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x9C"],
        ["\xE8\xAA\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x9D"],
        ["\xE8\xAA\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x9E"],
        ["\xE8\xAA\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x9F"],
        ["\xE8\xAA\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA0"],
        ["\xE8\xAA\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA1"],
        ["\xE8\xAA\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA2"],
        ["\xE8\xAA\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA3"],
        ["\xE8\xAB\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA4"],
        ["\xE8\xAB\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA5"],
        ["\xE8\xAB\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA6"],
        ["\xE8\xAB\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA7"],
        ["\xE8\xAB\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA8"],
        ["\xE8\xAB\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA9"],
        ["\xE8\xAB\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xAA"],
        ["\xE8\xAB\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xAB"],
        ["\xE8\xAB\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xAC"],
        ["\xE8\xAC\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xAD"],
        ["\xE8\xAB\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xAE"],
        ["\xE8\xAB\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xAF"],
        ["\xE8\xAB\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB0"],
        ["\xE8\xAB\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB1"],
        ["\xE8\xAB\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB2"],
        ["\xE8\xAC\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB3"],
        ["\xE8\xAC\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB4"],
        ["\xE8\xAC\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB5"],
        ["\xE8\xAB\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB6"],
        ["\xE8\xAC\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB7"],
        ["\xE8\xAC\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB8"],
        ["\xE8\xAC\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB9"],
        ["\xE8\xAC\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xBA"],
        ["\xE8\xAC\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xBB"],
        ["\xE9\x9E\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xBC"],
        ["\xE8\xAC\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xBD"],
        ["\xE8\xAC\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xBE"],
        ["\xE8\xAC\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xBF"],
        ["\xE8\xAC\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x80"],
        ["\xE8\xAD\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x81"],
        ["\xE8\xAD\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x82"],
        ["\xE8\xAD\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x83"],
        ["\xE8\xAD\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x84"],
        ["\xE8\xAD\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x85"],
        ["\xE8\xAD\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x86"],
        ["\xE8\xAD\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x87"],
        ["\xE8\xAD\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x88"],
        ["\xE8\xAD\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x89"],
        ["\xE8\xAD\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x8A"],
        ["\xE8\xAD\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x8B"],
        ["\xE8\xAD\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x8C"],
        ["\xE8\xAD\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x8D"],
        ["\xE8\xAD\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x8E"],
        ["\xE8\xAE\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x8F"],
        ["\xE8\xAE\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x90"],
        ["\xE8\xAE\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x91"],
        ["\xE8\xAE\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x92"],
        ["\xE8\xAE\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x93"],
        ["\xE8\xAE\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x94"],
        ["\xE8\xAE\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x95"],
        ["\xE8\xAE\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x96"],
        ["\xE8\xB0\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x97"],
        ["\xE8\xB1\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x98"],
        ["\xE8\xB0\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x99"],
        ["\xE8\xB1\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x9A"],
        ["\xE8\xB1\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x9B"],
        ["\xE8\xB1\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x9C"],
        ["\xE8\xB1\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x9D"],
        ["\xE8\xB1\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x9E"],
        ["\xE8\xB1\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x9F"],
        ["\xE8\xB1\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA0"],
        ["\xE8\xB1\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA1"],
        ["\xE8\xB1\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA2"],
        ["\xE8\xB2\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA3"],
        ["\xE8\xB2\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA4"],
        ["\xE8\xB2\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA5"],
        ["\xE8\xB2\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA6"],
        ["\xE8\xB2\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA7"],
        ["\xE8\xB2\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA8"],
        ["\xE8\xB2\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA9"],
        ["\xE8\xB1\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xAA"],
        ["\xE8\xB2\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xAB"],
        ["\xE6\x88\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xAC"],
        ["\xE8\xB2\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xAD"],
        ["\xE8\xB2\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xAE"],
        ["\xE8\xB2\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xAF"],
        ["\xE8\xB2\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB0"],
        ["\xE8\xB2\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB1"],
        ["\xE8\xB2\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB2"],
        ["\xE8\xB2\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB3"],
        ["\xE8\xB3\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB4"],
        ["\xE8\xB3\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB5"],
        ["\xE8\xB3\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB6"],
        ["\xE8\xB3\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB7"],
        ["\xE8\xB3\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB8"],
        ["\xE8\xB3\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB9"],
        ["\xE8\xB3\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xBA"],
        ["\xE8\xB3\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xBB"],
        ["\xE8\xB4\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xBC"],
        ["\xE8\xB4\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xBD"],
        ["\xE8\xB4\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xBE"],
        ["\xE8\xB4\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xBF"],
        ["\xE8\xB4\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x80"],
        ["\xE8\xB4\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x81"],
        ["\xE8\xB4\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x82"],
        ["\xE9\xBD\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x83"],
        ["\xE8\xB4\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x84"],
        ["\xE8\xB3\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x85"],
        ["\xE8\xB4\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x86"],
        ["\xE8\xB4\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x87"],
        ["\xE8\xB5\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x88"],
        ["\xE8\xB5\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x89"],
        ["\xE8\xB5\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x8A"],
        ["\xE8\xB5\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x8B"],
        ["\xE8\xB6\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x8C"],
        ["\xE8\xB6\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x8D"],
        ["\xE8\xB7\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x8E"],
        ["\xE8\xB6\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x8F"],
        ["\xE8\xB6\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x90"],
        ["\xE8\xB7\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x91"],
        ["\xE8\xB7\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x92"],
        ["\xE8\xB7\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x93"],
        ["\xE8\xB7\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x94"],
        ["\xE8\xB7\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x95"],
        ["\xE8\xB7\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x96"],
        ["\xE8\xB7\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x97"],
        ["\xE8\xB7\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x98"],
        ["\xE8\xB7\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x99"],
        ["\xE8\xB7\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x9A"],
        ["\xE8\xB7\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x9B"],
        ["\xE8\xB8\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x9C"],
        ["\xE8\xB8\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x9D"],
        ["\xE8\xB7\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x9E"],
        ["\xE8\xB8\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x9F"],
        ["\xE8\xB8\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA0"],
        ["\xE8\xB8\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA1"],
        ["\xE8\xB8\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA2"],
        ["\xE8\xB9\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA3"],
        ["\xE8\xB8\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA4"],
        ["\xE8\xB8\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA5"],
        ["\xE8\xB8\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA6"],
        ["\xE8\xB9\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA7"],
        ["\xE8\xB9\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA8"],
        ["\xE8\xB9\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA9"],
        ["\xE8\xB9\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xAA"],
        ["\xE8\xB9\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xAB"],
        ["\xE8\xB9\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xAC"],
        ["\xE8\xB9\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xAD"],
        ["\xE8\xB9\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xAE"],
        ["\xE8\xB9\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xAF"],
        ["\xE8\xB8\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB0"],
        ["\xE8\xB9\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB1"],
        ["\xE8\xB9\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB2"],
        ["\xE8\xB9\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB3"],
        ["\xE8\xB9\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB4"],
        ["\xE8\xB9\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB5"],
        ["\xE8\xBA\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB6"],
        ["\xE8\xBA\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB7"],
        ["\xE8\xBA\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB8"],
        ["\xE8\xBA\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB9"],
        ["\xE8\xBA\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xBA"],
        ["\xE8\xBA\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xBB"],
        ["\xE8\xBA\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xBC"],
        ["\xE8\xBA\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xBD"],
        ["\xE8\xBA\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xBE"],
        ["\xE8\xBA\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xBF"],
        ["\xE8\xBA\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x80"],
        ["\xE8\xBA\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x81"],
        ["\xE8\xBA\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x82"],
        ["\xE8\xBA\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x83"],
        ["\xE8\xBB\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x84"],
        ["\xE8\xBA\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x85"],
        ["\xE8\xBA\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x86"],
        ["\xE8\xBB\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x87"],
        ["\xE8\xBB\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x88"],
        ["\xE8\xBB\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x89"],
        ["\xE8\xBB\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x8A"],
        ["\xE8\xBB\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x8B"],
        ["\xE8\xBB\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x8C"],
        ["\xE8\xBB\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x8D"],
        ["\xE8\xBB\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x8E"],
        ["\xE8\xBB\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x8F"],
        ["\xE8\xBC\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x90"],
        ["\xE8\xBC\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x91"],
        ["\xE8\xBC\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x92"],
        ["\xE8\xBC\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x93"],
        ["\xE8\xBC\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x94"],
        ["\xE8\xBC\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x95"],
        ["\xE8\xBC\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x96"],
        ["\xE8\xBC\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x97"],
        ["\xE8\xBC\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x98"],
        ["\xE8\xBC\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x99"],
        ["\xE8\xBC\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x9A"],
        ["\xE8\xBC\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x9B"],
        ["\xE8\xBC\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x9C"],
        ["\xE8\xBC\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x9D"],
        ["\xE8\xBD\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x9E"],
        ["\xE8\xBD\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x9F"],
        ["\xE8\xBC\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA0"],
        ["\xE8\xBD\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA1"],
        ["\xE8\xBD\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA2"],
        ["\xE8\xBD\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA3"],
        ["\xE8\xBD\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA4"],
        ["\xE8\xBD\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA5"],
        ["\xE8\xBD\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA6"],
        ["\xE8\xBD\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA7"],
        ["\xE8\xBD\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA8"],
        ["\xE8\xBD\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA9"],
        ["\xE8\xBE\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xAA"],
        ["\xE8\xBE\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xAB"],
        ["\xE8\xBE\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xAC"],
        ["\xE8\xBE\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xAD"],
        ["\xE8\xBE\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xAE"],
        ["\xE8\xBE\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xAF"],
        ["\xE8\xBF\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB0"],
        ["\xE8\xBF\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB1"],
        ["\xE8\xBF\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB2"],
        ["\xE8\xBF\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB3"],
        ["\xE8\xBF\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB4"],
        ["\xE9\x82\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB5"],
        ["\xE8\xBF\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB6"],
        ["\xE9\x80\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB7"],
        ["\xE8\xBF\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB8"],
        ["\xE8\xBF\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB9"],
        ["\xE9\x80\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xBA"],
        ["\xE9\x80\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xBB"],
        ["\xE9\x80\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xBC"],
        ["\xE9\x80\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xBD"],
        ["\xE9\x80\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xBE"],
        ["\xE9\x80\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xBF"],
        ["\xE9\x80\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x80"],
        ["\xE9\x80\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x81"],
        ["\xE9\x80\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x82"],
        ["\xE9\x80\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x83"],
        ["\xE9\x80\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x84"],
        ["\xE8\xBF\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x85"],
        ["\xE9\x81\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x86"],
        ["\xE9\x81\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x87"],
        ["\xE9\x81\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x88"],
        ["\xE9\x81\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x89"],
        ["\xE9\x80\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x8A"],
        ["\xE9\x81\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x8B"],
        ["\xE9\x80\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x8C"],
        ["\xE9\x81\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x8D"],
        ["\xE9\x81\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x8E"],
        ["\xE9\x81\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x8F"],
        ["\xE9\x81\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x90"],
        ["\xE9\x81\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x91"],
        ["\xE9\x81\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x92"],
        ["\xE9\x9A\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x93"],
        ["\xE9\x81\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x94"],
        ["\xE9\x82\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x95"],
        ["\xE9\x81\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x96"],
        ["\xE9\x82\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x97"],
        ["\xE9\x82\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x98"],
        ["\xE9\x82\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x99"],
        ["\xE9\x82\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x9A"],
        ["\xE9\x82\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x9B"],
        ["\xE9\x82\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x9C"],
        ["\xE9\x82\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x9D"],
        ["\xE9\x82\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x9E"],
        ["\xE9\x82\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x9F"],
        ["\xE9\x83\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xA0"],
        ["\xE9\x83\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xA1"],
        ["\xE6\x89\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xA2"],
        ["\xE9\x83\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xA3"],
        ["\xE9\x84\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xA4"],
        ["\xE9\x84\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xA5"],
        ["\xE9\x84\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xA6"],
        ["\xE9\x84\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xA7"],
        ["\xE9\x84\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xA8"],
        ["\xE9\x85\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xA9"],
        ["\xE9\x85\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xAA"],
        ["\xE9\x85\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xAB"],
        ["\xE9\x85\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xAC"],
        ["\xE9\x85\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xAD"],
        ["\xE9\x85\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xAE"],
        ["\xE9\x85\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xAF"],
        ["\xE9\x85\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xB0"],
        ["\xE9\x86\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xB1"],
        ["\xE9\x86\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xB2"],
        ["\xE9\x86\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xB3"],
        ["\xE9\x86\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xB4"],
        ["\xE9\x86\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xB5"],
        ["\xE9\x86\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xB6"],
        ["\xE9\x86\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xB7"],
        ["\xE9\x86\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xB8"],
        ["\xE9\x86\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xB9"],
        ["\xE9\x86\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xBA"],
        ["\xE9\x87\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xBB"],
        ["\xE9\x87\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xBC"],
        ["\xE9\x87\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xBD"],
        ["\xE9\x87\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xBE"],
        ["\xE9\x87\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xBF"],
        ["\xE9\x87\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x80"],
        ["\xE9\x87\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x81"],
        ["\xE9\x87\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x82"],
        ["\xE9\x87\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x83"],
        ["\xE9\x87\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x84"],
        ["\xE9\x87\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x85"],
        ["\xE9\x87\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x86"],
        ["\xE9\x88\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x87"],
        ["\xE9\x87\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x88"],
        ["\xE9\x88\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x89"],
        ["\xE9\x88\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x8A"],
        ["\xE9\x88\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x8B"],
        ["\xE9\x88\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x8C"],
        ["\xE9\x89\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x8D"],
        ["\xE9\x89\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x8E"],
        ["\xE9\x89\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x8F"],
        ["\xE9\x89\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x90"],
        ["\xE9\x89\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x91"],
        ["\xE9\x89\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x92"],
        ["\xE9\x8A\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x93"],
        ["\xE9\x88\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x94"],
        ["\xE9\x89\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x95"],
        ["\xE9\x89\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x96"],
        ["\xE9\x8A\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x97"],
        ["\xE9\x8A\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x98"],
        ["\xE9\x8A\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x99"],
        ["\xE9\x8A\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x9A"],
        ["\xE9\x89\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x9B"],
        ["\xE9\x8B\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x9C"],
        ["\xE9\x8A\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x9D"],
        ["\xE9\x8A\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x9E"],
        ["\xE9\x8B\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x9F"],
        ["\xE9\x8C\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xA0"],
        ["\xE9\x8B\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xA1"],
        ["\xE9\x8D\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xA2"],
        ["\xE9\x8C\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xA3"],
        ["\xE9\x8C\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xA4"],
        ["\xE9\x8C\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xA5"],
        ["\xE9\x8C\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xA6"],
        ["\xE9\x8C\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xA7"],
        ["\xE9\x8C\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xA8"],
        ["\xE9\x8C\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xA9"],
        ["\xE9\x8C\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xAA"],
        ["\xE9\x8D\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xAB"],
        ["\xE9\x8D\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xAC"],
        ["\xE9\x8D\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xAD"],
        ["\xE9\x8D\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xAE"],
        ["\xE9\x8D\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xAF"],
        ["\xE9\x8E\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xB0"],
        ["\xE9\x8E\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xB1"],
        ["\xE9\x8E\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xB2"],
        ["\xE9\x8E\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xB3"],
        ["\xE9\x8E\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xB4"],
        ["\xE9\x8F\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xB5"],
        ["\xE9\x8F\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xB6"],
        ["\xE9\x8F\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xB7"],
        ["\xE9\x8F\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xB8"],
        ["\xE9\x8F\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xB9"],
        ["\xE9\x8F\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xBA"],
        ["\xE9\x8F\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xBB"],
        ["\xE9\x8F\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xBC"],
        ["\xE9\x8F\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xBD"],
        ["\xE9\x8F\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xBE"],
        ["\xE9\x90\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xBF"],
        ["\xE9\x90\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x80"],
        ["\xE9\x90\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x81"],
        ["\xE9\x90\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x82"],
        ["\xE9\x90\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x83"],
        ["\xE9\x90\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x84"],
        ["\xE9\x90\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x85"],
        ["\xE9\x90\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x86"],
        ["\xE9\x90\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x87"],
        ["\xE9\x90\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x88"],
        ["\xE9\x90\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x89"],
        ["\xE9\x91\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x8A"],
        ["\xE9\x91\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x8B"],
        ["\xE9\x91\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x8C"],
        ["\xE9\x91\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x8D"],
        ["\xE9\x91\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x8E"],
        ["\xE9\x91\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x8F"],
        ["\xE9\x91\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x90"],
        ["\xE9\x91\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x91"],
        ["\xE9\x88\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x92"],
        ["\xE9\x91\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x93"],
        ["\xE9\x91\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x94"],
        ["\xE9\x91\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x95"],
        ["\xE9\x91\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x96"],
        ["\xE9\x91\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x97"],
        ["\xE9\x91\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x98"],
        ["\xE9\x91\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x99"],
        ["\xE9\x92\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x9A"],
        ["\xE9\x91\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x9B"],
        ["\xE9\x96\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x9C"],
        ["\xE9\x96\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x9D"],
        ["\xE9\x96\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x9E"],
        ["\xE9\x96\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x9F"],
        ["\xE9\x96\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xA0"],
        ["\xE9\x96\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xA1"],
        ["\xE9\x96\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xA2"],
        ["\xE9\x96\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xA3"],
        ["\xE9\x96\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xA4"],
        ["\xE9\x96\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xA5"],
        ["\xE9\x96\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xA6"],
        ["\xE9\x96\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xA7"],
        ["\xE9\x96\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xA8"],
        ["\xE9\x96\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xA9"],
        ["\xE9\x96\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xAA"],
        ["\xE9\x97\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xAB"],
        ["\xE6\xBF\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xAC"],
        ["\xE9\x97\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xAD"],
        ["\xE9\x97\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xAE"],
        ["\xE9\x97\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xAF"],
        ["\xE9\x97\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xB0"],
        ["\xE9\x97\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xB1"],
        ["\xE9\x97\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xB2"],
        ["\xE9\x97\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xB3"],
        ["\xE9\x97\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xB4"],
        ["\xE9\x97\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xB5"],
        ["\xE9\x97\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xB6"],
        ["\xE9\x98\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xB7"],
        ["\xE9\x98\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xB8"],
        ["\xE9\x98\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xB9"],
        ["\xE9\x98\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xBA"],
        ["\xE9\x99\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xBB"],
        ["\xE9\x99\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xBC"],
        ["\xE9\x99\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xBD"],
        ["\xE9\x99\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xBE"],
        ["\xE9\x99\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xBF"],
        ["\xE9\x99\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x80"],
        ["\xE9\x99\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x81"],
        ["\xE9\x99\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x82"],
        ["\xE9\x99\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x83"],
        ["\xE9\x99\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x84"],
        ["\xE9\x99\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x85"],
        ["\xE9\x99\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x86"],
        ["\xE9\x9A\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x87"],
        ["\xE9\x9A\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x88"],
        ["\xE9\x9A\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x89"],
        ["\xE9\x9A\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x8A"],
        ["\xE9\x9A\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x8B"],
        ["\xE9\x9A\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x8C"],
        ["\xE9\x9A\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x8D"],
        ["\xE9\x9A\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x8E"],
        ["\xE9\x9A\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x8F"],
        ["\xE9\x9A\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x90"],
        ["\xE9\x9A\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x91"],
        ["\xE9\x9A\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x92"],
        ["\xE9\x9A\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x93"],
        ["\xE9\x9B\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x94"],
        ["\xE9\x9B\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x95"],
        ["\xE9\x9B\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x96"],
        ["\xE9\x9B\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x97"],
        ["\xE8\xA5\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x98"],
        ["\xE9\x9B\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x99"],
        ["\xE9\x9C\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x9A"],
        ["\xE9\x9B\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x9B"],
        ["\xE9\x9B\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x9C"],
        ["\xE9\x9C\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x9D"],
        ["\xE9\x9C\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x9E"],
        ["\xE9\x9C\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x9F"],
        ["\xE9\x9C\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xA0"],
        ["\xE9\x9C\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xA1"],
        ["\xE9\x9C\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xA2"],
        ["\xE9\x9C\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xA3"],
        ["\xE9\x9C\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xA4"],
        ["\xE9\x9C\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xA5"],
        ["\xE9\x9C\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xA6"],
        ["\xE9\x9C\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xA7"],
        ["\xE9\x9C\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xA8"],
        ["\xE9\x9C\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xA9"],
        ["\xE9\x9C\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xAA"],
        ["\xE9\x9C\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xAB"],
        ["\xE9\x9D\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xAC"],
        ["\xE9\x9D\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xAD"],
        ["\xE9\x9D\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xAE"],
        ["\xE9\x9D\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xAF"],
        ["\xE9\x9D\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xB0"],
        ["\xE9\x9D\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xB1"],
        ["\xE9\x9D\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xB2"],
        ["\xE9\x9D\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xB3"],
        ["\xE9\x9D\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xB4"],
        ["\xE9\x9D\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xB5"],
        ["\xE5\x8B\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xB6"],
        ["\xE9\x9D\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xB7"],
        ["\xE9\x9D\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xB8"],
        ["\xE9\x9D\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xB9"],
        ["\xE9\x9E\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xBA"],
        ["\xE9\x9D\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xBB"],
        ["\xE9\x9E\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xBC"],
        ["\xE9\x9D\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xBD"],
        ["\xE9\x9E\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xBE"],
        ["\xE9\x9E\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xBF"],
        ["\xE9\x9E\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x80"],
        ["\xE9\x9E\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x81"],
        ["\xE9\x9E\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x82"],
        ["\xE9\x9E\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x83"],
        ["\xE9\x9E\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x84"],
        ["\xE9\x9E\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x85"],
        ["\xE9\x9E\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x86"],
        ["\xE9\x9E\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x87"],
        ["\xE9\x9F\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x88"],
        ["\xE9\x9F\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x89"],
        ["\xE9\x9F\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x8A"],
        ["\xE9\x9F\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x8B"],
        ["\xE9\x9F\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x8C"],
        ["\xE9\x9F\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x8D"],
        ["\xE9\xBD\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x8E"],
        ["\xE9\x9F\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x8F"],
        ["\xE7\xAB\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x90"],
        ["\xE9\x9F\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x91"],
        ["\xE9\x9F\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x92"],
        ["\xE9\xA0\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x93"],
        ["\xE9\xA0\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x94"],
        ["\xE9\xA0\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x95"],
        ["\xE9\xA0\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x96"],
        ["\xE9\xA0\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x97"],
        ["\xE9\xA0\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x98"],
        ["\xE9\xA0\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x99"],
        ["\xE9\xA1\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x9A"],
        ["\xE9\xA1\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x9B"],
        ["\xE9\xA1\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x9C"],
        ["\xE9\xA1\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x9D"],
        ["\xE9\xA1\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x9E"],
        ["\xE9\xA1\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x9F"],
        ["\xE9\xA1\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xA0"],
        ["\xE9\xA1\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xA1"],
        ["\xE9\xA1\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xA2"],
        ["\xE9\xA2\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xA3"],
        ["\xE9\xA2\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xA4"],
        ["\xE9\xA2\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xA5"],
        ["\xE9\xA2\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xA6"],
        ["\xE9\xA3\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xA7"],
        ["\xE9\xA3\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xA8"],
        ["\xE9\xA3\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xA9"],
        ["\xE9\xA3\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xAA"],
        ["\xE9\xA3\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xAB"],
        ["\xE9\xA4\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xAC"],
        ["\xE9\xA4\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xAD"],
        ["\xE9\xA4\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xAE"],
        ["\xE9\xA4\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xAF"],
        ["\xE9\xA4\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xB0"],
        ["\xE9\xA4\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xB1"],
        ["\xE9\xA4\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xB2"],
        ["\xE9\xA4\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xB3"],
        ["\xE9\xA4\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xB4"],
        ["\xE9\xA4\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xB5"],
        ["\xE9\xA4\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xB6"],
        ["\xE9\xA4\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xB7"],
        ["\xE9\xA4\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xB8"],
        ["\xE9\xA4\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xB9"],
        ["\xE9\xA5\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xBA"],
        ["\xE9\xA5\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xBB"],
        ["\xE9\xA5\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xBC"],
        ["\xE9\xA5\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xBD"],
        ["\xE9\xA5\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xBE"],
        ["\xE9\xA5\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xBF"],
        ["\xE9\xA5\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x80"],
        ["\xE9\xA5\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x81"],
        ["\xE9\xA5\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x82"],
        ["\xE9\xA6\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x83"],
        ["\xE9\xA6\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x84"],
        ["\xE9\xA6\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x85"],
        ["\xE9\xA6\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x86"],
        ["\xE9\xA6\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x87"],
        ["\xE9\xA6\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x88"],
        ["\xE9\xA7\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x89"],
        ["\xE9\xA7\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x8A"],
        ["\xE9\xA7\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x8B"],
        ["\xE9\xA7\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x8C"],
        ["\xE9\xA7\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x8D"],
        ["\xE9\xA7\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x8E"],
        ["\xE9\xA7\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x8F"],
        ["\xE9\xA7\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x90"],
        ["\xE9\xA7\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x91"],
        ["\xE9\xA7\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x92"],
        ["\xE9\xA7\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x93"],
        ["\xE9\xA8\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x94"],
        ["\xE9\xA8\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x95"],
        ["\xE9\xA8\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x96"],
        ["\xE9\xA7\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x97"],
        ["\xE9\xA8\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x98"],
        ["\xE9\xA8\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x99"],
        ["\xE9\xA8\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x9A"],
        ["\xE9\xA9\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x9B"],
        ["\xE9\xA9\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x9C"],
        ["\xE9\xA9\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x9D"],
        ["\xE9\xA9\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x9E"],
        ["\xE9\xA8\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x9F"],
        ["\xE9\xA9\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xA0"],
        ["\xE9\xA9\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xA1"],
        ["\xE9\xA9\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xA2"],
        ["\xE9\xA9\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xA3"],
        ["\xE9\xA9\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xA4"],
        ["\xE9\xA9\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xA5"],
        ["\xE9\xA9\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xA6"],
        ["\xE9\xA9\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xA7"],
        ["\xE9\xA9\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xA8"],
        ["\xE9\xA9\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xA9"],
        ["\xE9\xA9\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xAA"],
        ["\xE9\xAA\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xAB"],
        ["\xE9\xAA\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xAC"],
        ["\xE9\xAA\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xAD"],
        ["\xE9\xAB\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xAE"],
        ["\xE9\xAB\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xAF"],
        ["\xE9\xAB\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xB0"],
        ["\xE9\xAB\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xB1"],
        ["\xE9\xAB\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xB2"],
        ["\xE9\xAB\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xB3"],
        ["\xE9\xAB\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xB4"],
        ["\xE9\xAB\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xB5"],
        ["\xE9\xAB\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xB6"],
        ["\xE9\xAB\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xB7"],
        ["\xE9\xAB\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xB8"],
        ["\xE9\xAB\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xB9"],
        ["\xE9\xAB\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xBA"],
        ["\xE9\xAB\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xBB"],
        ["\xE9\xAB\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xBC"],
        ["\xE9\xAB\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xBD"],
        ["\xE9\xAB\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xBE"],
        ["\xE9\xAC\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xBF"],
        ["\xE9\xAC\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x80"],
        ["\xE9\xAC\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x81"],
        ["\xE9\xAC\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x82"],
        ["\xE9\xAC\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x83"],
        ["\xE9\xAC\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x84"],
        ["\xE9\xAC\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x85"],
        ["\xE9\xAC\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x86"],
        ["\xE9\xAC\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x87"],
        ["\xE9\xAC\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x88"],
        ["\xE9\xAC\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x89"],
        ["\xE9\xAC\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x8A"],
        ["\xE9\xAC\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x8B"],
        ["\xE9\xAC\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x8C"],
        ["\xE9\xAD\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x8D"],
        ["\xE9\xAD\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x8E"],
        ["\xE9\xAD\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x8F"],
        ["\xE9\xAD\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x90"],
        ["\xE9\xAD\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x91"],
        ["\xE9\xAD\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x92"],
        ["\xE9\xAD\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x93"],
        ["\xE9\xAD\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x94"],
        ["\xE9\xAE\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x95"],
        ["\xE9\xAE\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x96"],
        ["\xE9\xAE\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x97"],
        ["\xE9\xAE\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x98"],
        ["\xE9\xAE\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x99"],
        ["\xE9\xAE\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x9A"],
        ["\xE9\xAE\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x9B"],
        ["\xE9\xAE\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x9C"],
        ["\xE9\xAE\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x9D"],
        ["\xE9\xAF\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x9E"],
        ["\xE9\xAF\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x9F"],
        ["\xE9\xAE\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xA0"],
        ["\xE9\xAF\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xA1"],
        ["\xE9\xAF\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xA2"],
        ["\xE9\xAF\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xA3"],
        ["\xE9\xAF\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xA4"],
        ["\xE9\xAF\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xA5"],
        ["\xE9\xAF\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xA6"],
        ["\xE9\xAF\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xA7"],
        ["\xE9\xAF\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xA8"],
        ["\xE9\xAF\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xA9"],
        ["\xE9\xB0\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xAA"],
        ["\xE9\xAF\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xAB"],
        ["\xE9\xAF\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xAC"],
        ["\xE9\xAF\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xAD"],
        ["\xE9\xB0\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xAE"],
        ["\xE9\xB0\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xAF"],
        ["\xE9\xB0\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xB0"],
        ["\xE9\xB0\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xB1"],
        ["\xE9\xB0\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xB2"],
        ["\xE9\xB0\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xB3"],
        ["\xE9\xB0\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xB4"],
        ["\xE9\xB0\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xB5"],
        ["\xE9\xB0\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xB6"],
        ["\xE9\xB0\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xB7"],
        ["\xE9\xB0\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xB8"],
        ["\xE9\xB0\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xB9"],
        ["\xE9\xB0\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xBA"],
        ["\xE9\xB0\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xBB"],
        ["\xE9\xB0\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xBC"],
        ["\xE9\xB0\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xBD"],
        ["\xE9\xB1\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xBE"],
        ["\xE9\xB0\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xBF"],
        ["\xE9\xB1\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x80"],
        ["\xE9\xB0\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x81"],
        ["\xE9\xB1\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x82"],
        ["\xE9\xB1\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x83"],
        ["\xE9\xB1\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x84"],
        ["\xE9\xB1\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x85"],
        ["\xE9\xB1\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x86"],
        ["\xE9\xB3\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x87"],
        ["\xE9\xB3\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x88"],
        ["\xE9\xB3\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x89"],
        ["\xE9\xB4\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x8A"],
        ["\xE9\xB4\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x8B"],
        ["\xE9\xB3\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x8C"],
        ["\xE9\xB4\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x8D"],
        ["\xE9\xB4\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x8E"],
        ["\xE9\xB4\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x8F"],
        ["\xE9\xB4\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x90"],
        ["\xE9\xB6\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x91"],
        ["\xE9\xB4\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x92"],
        ["\xE9\xB4\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x93"],
        ["\xE9\xB5\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x94"],
        ["\xE9\xB4\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x95"],
        ["\xE9\xB4\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x96"],
        ["\xE9\xB5\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x97"],
        ["\xE9\xB4\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x98"],
        ["\xE9\xB4\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x99"],
        ["\xE9\xB5\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x9A"],
        ["\xE9\xB5\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x9B"],
        ["\xE9\xB5\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x9C"],
        ["\xE9\xB5\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x9D"],
        ["\xE9\xB5\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x9E"],
        ["\xE9\xB5\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x9F"],
        ["\xE9\xB5\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xA0"],
        ["\xE9\xB5\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xA1"],
        ["\xE9\xB5\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xA2"],
        ["\xE9\xB6\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xA3"],
        ["\xE9\xB6\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xA4"],
        ["\xE9\xB6\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xA5"],
        ["\xE9\xB5\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xA6"],
        ["\xE9\xB5\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xA7"],
        ["\xE9\xB6\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xA8"],
        ["\xE9\xB6\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xA9"],
        ["\xE9\xB6\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xAA"],
        ["\xE9\xB6\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xAB"],
        ["\xE9\xB7\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xAC"],
        ["\xE9\xB7\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xAD"],
        ["\xE9\xB6\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xAE"],
        ["\xE9\xB6\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xAF"],
        ["\xE9\xB6\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xB0"],
        ["\xE9\xB7\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xB1"],
        ["\xE9\xB7\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xB2"],
        ["\xE9\xB7\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xB3"],
        ["\xE9\xB7\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xB4"],
        ["\xE9\xB7\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xB5"],
        ["\xE9\xB7\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xB6"],
        ["\xE9\xB7\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xB7"],
        ["\xE9\xB7\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xB8"],
        ["\xE9\xB7\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xB9"],
        ["\xE9\xB7\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xBA"],
        ["\xE9\xB8\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xBB"],
        ["\xE9\xB8\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xBC"],
        ["\xE9\xB8\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xBD"],
        ["\xE9\xB9\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xBE"],
        ["\xE9\xB9\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xBF"],
        ["\xE9\xB9\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x80"],
        ["\xE9\xBA\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x81"],
        ["\xE9\xBA\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x82"],
        ["\xE9\xBA\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x83"],
        ["\xE9\xBA\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x84"],
        ["\xE9\xBA\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x85"],
        ["\xE9\xBA\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x86"],
        ["\xE9\xBA\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x87"],
        ["\xE9\xBA\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x88"],
        ["\xE9\xBA\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x89"],
        ["\xE9\xBA\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x8A"],
        ["\xE9\xBA\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x8B"],
        ["\xE9\xBA\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x8C"],
        ["\xE9\xBA\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x8D"],
        ["\xE9\x9D\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x8E"],
        ["\xE9\xBB\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x8F"],
        ["\xE9\xBB\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x90"],
        ["\xE9\xBB\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x91"],
        ["\xE9\xBB\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x92"],
        ["\xE9\xBB\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x93"],
        ["\xE9\xBB\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x94"],
        ["\xE9\xBB\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x95"],
        ["\xE9\xBB\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x96"],
        ["\xE9\xBB\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x97"],
        ["\xE9\xBB\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x98"],
        ["\xE9\xBB\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x99"],
        ["\xE9\xBB\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x9A"],
        ["\xE9\xBB\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x9B"],
        ["\xE9\xBB\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x9C"],
        ["\xE9\xBB\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x9D"],
        ["\xE9\xBB\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x9E"],
        ["\xE9\xBB\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x9F"],
        ["\xE9\xBB\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xA0"],
        ["\xE9\xBB\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xA1"],
        ["\xE9\xBC\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xA2"],
        ["\xE9\xBC\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xA3"],
        ["\xE7\x9A\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xA4"],
        ["\xE9\xBC\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xA5"],
        ["\xE9\xBC\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xA6"],
        ["\xE9\xBC\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xA7"],
        ["\xE9\xBC\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xA8"],
        ["\xE9\xBD\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xA9"],
        ["\xE9\xBD\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xAA"],
        ["\xE9\xBD\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xAB"],
        ["\xE9\xBD\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xAC"],
        ["\xE9\xBD\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xAD"],
        ["\xE9\xBD\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xAE"],
        ["\xE9\xBD\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xAF"],
        ["\xE9\xBD\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xB0"],
        ["\xE9\xBD\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xB1"],
        ["\xE9\xBD\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xB2"],
        ["\xE9\xBD\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xB3"],
        ["\xE9\xBD\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xB4"],
        ["\xE9\xBD\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xB5"],
        ["\xE9\xBD\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xB6"],
        ["\xE9\xBE\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xB7"],
        ["\xE9\xBE\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xB8"],
        ["\xE9\xBE\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xB9"],
        ["\xE5\xA0\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xBA"],
        ["\xE6\xA7\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xBB"],
        ["\xE9\x81\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xBC"],
        ["\xE7\x91\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xBD"],
        ["\xE5\x87\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xBE"],
        ["\xE7\x86\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xBF"],
        ["\xE2\x85\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\x9C"],
        ["\xE2\x85\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\x9D"],
        ["\xE2\x85\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\x9E"],
        ["\xE2\x85\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\x9F"],
        ["\xE2\x85\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xA0"],
        ["\xE2\x85\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xA1"],
        ["\xE2\x85\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xA2"],
        ["\xE2\x85\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xA3"],
        ["\xE2\x85\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xA4"],
        ["\xE2\x85\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xA5"],
        ["\xEF\xBF\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xB1"],
        ["\xEF\xBC\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xB2"],
        ["\xEF\xBC\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xB3"],
        ["\xE7\xBA\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xB8"],
        ["\xE8\xA4\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xB9"],
        ["\xE9\x8D\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xBA"],
        ["\xE9\x8A\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xBB"],
        ["\xE8\x93\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xBC"],
        ["\xE4\xBF\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xBD"],
        ["\xE7\x82\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xBE"],
        ["\xE6\x98\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xBF"],
        ["\xE6\xA3\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x80"],
        ["\xE9\x8B\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x81"],
        ["\xE6\x9B\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x82"],
        ["\xE5\xBD\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x83"],
        ["\xE4\xB8\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x84"],
        ["\xE4\xBB\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x85"],
        ["\xE4\xBB\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x86"],
        ["\xE4\xBC\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x87"],
        ["\xE4\xBC\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x88"],
        ["\xE4\xBC\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x89"],
        ["\xE4\xBD\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x8A"],
        ["\xE4\xBE\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x8B"],
        ["\xE4\xBE\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x8C"],
        ["\xE4\xBE\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x8D"],
        ["\xE4\xBE\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x8E"],
        ["\xE4\xBF\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x8F"],
        ["\xE5\x81\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x90"],
        ["\xE5\x80\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x91"],
        ["\xE4\xBF\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x92"],
        ["\xE5\x80\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x93"],
        ["\xE5\x81\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x94"],
        ["\xE5\x81\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x95"],
        ["\xE5\x81\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x96"],
        ["\xE5\x82\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x97"],
        ["\xE5\x83\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x98"],
        ["\xE5\x83\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x99"],
        ["\xE5\x85\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x9A"],
        ["\xE5\x85\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x9B"],
        ["\xE5\x86\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x9C"],
        ["\xE5\x86\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x9D"],
        ["\xE5\x87\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x9E"],
        ["\xE5\x88\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x9F"],
        ["\xE5\x8A\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xA0"],
        ["\xE5\x8A\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xA1"],
        ["\xE5\x8B\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xA2"],
        ["\xE5\x8B\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xA3"],
        ["\xE5\x8C\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xA4"],
        ["\xE5\x8C\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xA5"],
        ["\xE5\x8C\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xA6"],
        ["\xE5\x8D\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xA7"],
        ["\xE5\x8E\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xA8"],
        ["\xE5\x8E\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xA9"],
        ["\xE5\x8F\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xAA"],
        ["\xEF\xA8\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xAB"],
        ["\xE5\x92\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xAC"],
        ["\xE5\x92\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xAD"],
        ["\xE5\x92\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xAE"],
        ["\xE5\x93\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xAF"],
        ["\xE5\x96\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xB0"],
        ["\xE5\x9D\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xB1"],
        ["\xE5\x9D\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xB2"],
        ["\xE5\x9E\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xB3"],
        ["\xE5\x9F\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xB4"],
        ["\xE5\x9F\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xB5"],
        ["\xEF\xA8\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xB6"],
        ["\xEF\xA8\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xB7"],
        ["\xE5\xA2\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xB8"],
        ["\xE5\xA2\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xB9"],
        ["\xE5\xA4\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xBA"],
        ["\xE5\xA5\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xBB"],
        ["\xE5\xA5\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xBC"],
        ["\xE5\xA5\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xBD"],
        ["\xE5\xA5\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xBE"],
        ["\xE5\xA6\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xBF"],
        ["\xE5\xA6\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x80"],
        ["\xE5\xAD\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x81"],
        ["\xE5\xAF\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x82"],
        ["\xE7\x94\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x83"],
        ["\xE5\xAF\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x84"],
        ["\xE5\xAF\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x85"],
        ["\xE5\xB0\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x86"],
        ["\xE5\xB2\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x87"],
        ["\xE5\xB2\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x88"],
        ["\xE5\xB3\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x89"],
        ["\xE5\xB4\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x8A"],
        ["\xE5\xB5\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x8B"],
        ["\xEF\xA8\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x8C"],
        ["\xE5\xB5\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x8D"],
        ["\xE5\xB5\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x8E"],
        ["\xE5\xB6\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x8F"],
        ["\xE5\xB6\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x90"],
        ["\xE5\xB7\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x91"],
        ["\xE5\xBC\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x92"],
        ["\xE5\xBC\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x93"],
        ["\xE5\xBD\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x94"],
        ["\xE5\xBE\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x95"],
        ["\xE5\xBF\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x96"],
        ["\xE6\x81\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x97"],
        ["\xE6\x82\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x98"],
        ["\xE6\x82\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x99"],
        ["\xE6\x83\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x9A"],
        ["\xE6\x83\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x9B"],
        ["\xE6\x84\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x9C"],
        ["\xE6\x83\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x9D"],
        ["\xE6\x84\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x9E"],
        ["\xE6\x84\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x9F"],
        ["\xE6\x84\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xA0"],
        ["\xE6\x86\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xA1"],
        ["\xE6\x88\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xA2"],
        ["\xE6\x8A\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xA3"],
        ["\xE6\x8F\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xA4"],
        ["\xE6\x91\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xA5"],
        ["\xE6\x92\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xA6"],
        ["\xE6\x93\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xA7"],
        ["\xE6\x95\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xA8"],
        ["\xE6\x98\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xA9"],
        ["\xE6\x98\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xAA"],
        ["\xE6\x98\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xAB"],
        ["\xE6\x98\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xAC"],
        ["\xE6\x98\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xAD"],
        ["\xE6\x98\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xAE"],
        ["\xE6\x98\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xAF"],
        ["\xE6\x99\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xB0"],
        ["\xE6\x99\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xB1"],
        ["\xE6\x99\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xB2"],
        ["\xEF\xA8\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xB3"],
        ["\xE6\x99\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xB4"],
        ["\xE6\x9A\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xB5"],
        ["\xE6\x9A\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xB6"],
        ["\xE6\x9A\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xB7"],
        ["\xE6\x9A\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xB8"],
        ["\xE6\x9B\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xB9"],
        ["\xE6\x9C\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xBA"],
        ["\xEF\xA4\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xBB"],
        ["\xE6\x9D\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xBC"],
        ["\xE6\x9E\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xBD"],
        ["\xE6\xA1\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xBE"],
        ["\xE6\x9F\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xBF"],
        ["\xE6\xA0\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x80"],
        ["\xE6\xA1\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x81"],
        ["\xE6\xA3\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x82"],
        ["\xEF\xA8\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x83"],
        ["\xE6\xA5\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x84"],
        ["\xEF\xA8\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x85"],
        ["\xE6\xA6\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x86"],
        ["\xE6\xA7\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x87"],
        ["\xE6\xA8\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x88"],
        ["\xE6\xA9\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x89"],
        ["\xE6\xA9\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x8A"],
        ["\xE6\xA9\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x8B"],
        ["\xE6\xA9\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x8C"],
        ["\xE6\xAB\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x8D"],
        ["\xE6\xAB\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x8E"],
        ["\xE6\xAF\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x8F"],
        ["\xE6\xB0\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x90"],
        ["\xE6\xB1\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x91"],
        ["\xE6\xB2\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x92"],
        ["\xE6\xB1\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x93"],
        ["\xE6\xB3\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x94"],
        ["\xE6\xB4\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x95"],
        ["\xE6\xB6\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x96"],
        ["\xE6\xB5\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x97"],
        ["\xE6\xB6\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x98"],
        ["\xE6\xB6\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x99"],
        ["\xE6\xB7\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x9A"],
        ["\xE6\xB7\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x9B"],
        ["\xE6\xB7\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x9C"],
        ["\xE6\xB7\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x9D"],
        ["\xE6\xB8\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x9E"],
        ["\xE6\xB9\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x9F"],
        ["\xE6\xB8\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xA0"],
        ["\xE6\xB8\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xA1"],
        ["\xE6\xBA\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xA2"],
        ["\xE6\xBE\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xA3"],
        ["\xE6\xBE\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xA4"],
        ["\xE6\xBF\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xA5"],
        ["\xE7\x80\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xA6"],
        ["\xE7\x80\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xA7"],
        ["\xE7\x80\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xA8"],
        ["\xE7\x82\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xA9"],
        ["\xE7\x82\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xAA"],
        ["\xE7\x84\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xAB"],
        ["\xE7\x84\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xAC"],
        ["\xE7\x85\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xAD"],
        ["\xE7\x85\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xAE"],
        ["\xE7\x85\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xAF"],
        ["\xEF\xA8\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xB0"],
        ["\xE7\x87\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xB1"],
        ["\xE7\x87\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xB2"],
        ["\xE7\x8A\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xB3"],
        ["\xE7\x8A\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xB4"],
        ["\xE7\x8C\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xB5"],
        ["\xEF\xA8\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xB6"],
        ["\xE7\x8D\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xB7"],
        ["\xE7\x8E\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xB8"],
        ["\xE7\x8F\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xB9"],
        ["\xE7\x8F\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xBA"],
        ["\xE7\x8F\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xBB"],
        ["\xE7\x8F\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xBC"],
        ["\xE7\x90\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xBD"],
        ["\xE7\x8F\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xBE"],
        ["\xE7\x90\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xBF"],
        ["\xE7\x90\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x80"],
        ["\xE7\x90\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x81"],
        ["\xE7\x90\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x82"],
        ["\xE7\x91\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x83"],
        ["\xE7\x92\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x84"],
        ["\xE7\x92\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x85"],
        ["\xE7\x94\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x86"],
        ["\xE7\x95\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x87"],
        ["\xE7\x9A\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x88"],
        ["\xE7\x9A\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x89"],
        ["\xE7\x9A\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x8A"],
        ["\xE7\x9A\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x8B"],
        ["\xE7\x9A\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x8C"],
        ["\xEF\xA8\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x8D"],
        ["\xE7\x9D\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x8E"],
        ["\xE5\x8A\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x8F"],
        ["\xE7\xA0\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x90"],
        ["\xE7\xA1\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x91"],
        ["\xE7\xA1\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x92"],
        ["\xE7\xA1\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x93"],
        ["\xE7\xA4\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x94"],
        ["\xEF\xA8\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x95"],
        ["\xEF\xA8\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x96"],
        ["\xEF\xA8\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x97"],
        ["\xE7\xA6\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x98"],
        ["\xEF\xA8\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x99"],
        ["\xE7\xA6\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x9A"],
        ["\xE7\xAB\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x9B"],
        ["\xE7\xAB\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x9C"],
        ["\xEF\xA8\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x9D"],
        ["\xE7\xAB\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x9E"],
        ["\xE7\xAE\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x9F"],
        ["\xEF\xA8\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xA0"],
        ["\xE7\xB5\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xA1"],
        ["\xE7\xB5\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xA2"],
        ["\xE7\xB6\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xA3"],
        ["\xE7\xB6\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xA4"],
        ["\xE7\xB7\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xA5"],
        ["\xE7\xB9\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xA6"],
        ["\xE7\xBD\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xA7"],
        ["\xE7\xBE\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xA8"],
        ["\xEF\xA8\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xA9"],
        ["\xE8\x8C\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xAA"],
        ["\xE8\x8D\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xAB"],
        ["\xE8\x8D\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xAC"],
        ["\xE8\x8F\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xAD"],
        ["\xE8\x8F\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xAE"],
        ["\xE8\x91\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xAF"],
        ["\xE8\x92\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xB0"],
        ["\xE8\x95\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xB1"],
        ["\xE8\x95\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xB2"],
        ["\xE8\x95\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xB3"],
        ["\xEF\xA8\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xB4"],
        ["\xE8\x96\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xB5"],
        ["\xEF\xA8\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xB6"],
        ["\xEF\xA8\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xB7"],
        ["\xE8\xA0\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xB8"],
        ["\xE8\xA3\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xB9"],
        ["\xE8\xA8\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xBA"],
        ["\xE8\xA8\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xBB"],
        ["\xE8\xA9\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xBC"],
        ["\xE8\xAA\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xBD"],
        ["\xE8\xAA\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xBE"],
        ["\xE8\xAB\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xBF"],
        ["\xEF\xA8\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x80"],
        ["\xE8\xAB\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x81"],
        ["\xE8\xAD\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x82"],
        ["\xE8\xAD\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x83"],
        ["\xE8\xB3\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x84"],
        ["\xE8\xB3\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x85"],
        ["\xE8\xB4\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x86"],
        ["\xE8\xB5\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x87"],
        ["\xEF\xA8\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x88"],
        ["\xE8\xBB\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x89"],
        ["\xEF\xA8\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x8A"],
        ["\xEF\xA8\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x8B"],
        ["\xE9\x81\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x8C"],
        ["\xE9\x83\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x8D"],
        ["\xEF\xA8\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x8E"],
        ["\xE9\x84\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x8F"],
        ["\xE9\x84\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x90"],
        ["\xE9\x87\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x91"],
        ["\xE9\x87\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x92"],
        ["\xE9\x87\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x93"],
        ["\xE9\x87\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x94"],
        ["\xE9\x87\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x95"],
        ["\xE9\x87\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x96"],
        ["\xE9\x87\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x97"],
        ["\xE9\x88\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x98"],
        ["\xE9\x88\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x99"],
        ["\xE9\x88\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x9A"],
        ["\xE9\x88\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x9B"],
        ["\xE9\x89\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x9C"],
        ["\xE9\x88\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x9D"],
        ["\xE9\x89\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x9E"],
        ["\xE9\x89\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x9F"],
        ["\xE9\x89\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xA0"],
        ["\xE9\x88\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xA1"],
        ["\xE9\x89\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xA2"],
        ["\xE9\x8A\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xA3"],
        ["\xE9\x89\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xA4"],
        ["\xE9\x89\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xA5"],
        ["\xE9\x8B\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xA6"],
        ["\xE9\x8B\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xA7"],
        ["\xE9\x8B\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xA8"],
        ["\xE9\x8B\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xA9"],
        ["\xEF\xA8\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xAA"],
        ["\xE9\x8B\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xAB"],
        ["\xE9\x8B\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xAC"],
        ["\xE9\x8B\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xAD"],
        ["\xE9\x8C\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xAE"],
        ["\xE9\x8C\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xAF"],
        ["\xE9\x8B\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xB0"],
        ["\xEF\xA8\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xB1"],
        ["\xE9\x8C\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xB2"],
        ["\xE9\x8B\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xB3"],
        ["\xE9\x8C\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xB4"],
        ["\xE9\x8C\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xB5"],
        ["\xE9\x8D\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xB6"],
        ["\xE9\x8D\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xB7"],
        ["\xE9\x8E\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xB8"],
        ["\xE9\x8F\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xB9"],
        ["\xE9\x8F\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xBA"],
        ["\xE9\x8F\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xBB"],
        ["\xE9\x90\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xBC"],
        ["\xE9\x91\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xBD"],
        ["\xE9\x91\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xBE"],
        ["\xE9\x96\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xBF"],
        ["\xEF\xA7\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x80"],
        ["\xEF\xA8\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x81"],
        ["\xE9\x9A\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x82"],
        ["\xE9\x9A\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x83"],
        ["\xE9\x9C\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x84"],
        ["\xE9\x9C\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x85"],
        ["\xE9\x9D\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x86"],
        ["\xE9\x9D\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x87"],
        ["\xE9\x9D\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x88"],
        ["\xE9\x9D\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x89"],
        ["\xE9\x9D\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x8A"],
        ["\xE9\xA1\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x8B"],
        ["\xE9\xA1\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x8C"],
        ["\xEF\xA8\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x8D"],
        ["\xEF\xA8\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x8E"],
        ["\xE9\xA4\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x8F"],
        ["\xEF\xA8\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x90"],
        ["\xE9\xA6\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x91"],
        ["\xE9\xA9\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x92"],
        ["\xE9\xAB\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x93"],
        ["\xE9\xAB\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x94"],
        ["\xE9\xAD\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x95"],
        ["\xE9\xAD\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x96"],
        ["\xE9\xAE\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x97"],
        ["\xE9\xAE\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x98"],
        ["\xE9\xAE\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x99"],
        ["\xE9\xB0\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x9A"],
        ["\xE9\xB5\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x9B"],
        ["\xE9\xB5\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x9C"],
        ["\xEF\xA8\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x9D"],
        ["\xE9\xB8\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x9E"],
        ["\xE9\xBB\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x9F"],
        ["\xE2\x80\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB4\xAC"],
        ["\xE2\x80\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB4\xB1"],
        ["\xE2\x88\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB5\x8C"],
        ["\xC2\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB5\xA0"],
        ["\xC2\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB5\xA1"],
        ["\xE3\x80\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\x80"],
        ["\xE3\x80\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\x81"],
        ["\xE3\x80\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\x82"],
        ["\xE3\x80\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\x83"],
        ["\xE3\x80\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\x84"],
        ["\xE3\x83\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\x85"],
        ["\xE3\x82\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\x86"],
        ["\xE2\x8A\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\x8F"],
        ["\xE2\x8A\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\x90"],
        ["\xE2\x8A\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\x91"],
        ["\xE2\x8A\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\x92"],
        ["\xE2\x88\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\x93"],
        ["\xE2\x88\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\x94"],
        ["\xE2\x8C\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\x95"],
        ["\xE2\x8C\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\x96"],
        ["\xC2\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\x99"],
        ["\xE2\x8A\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\x9E"],
        ["\xE2\x8A\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\x9F"],
        ["\xE2\x8A\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\xA0"],
        ["\xE2\x88\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\xA2"],
        ["\xEF\xBD\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\xA3"],
        ["\xEF\xBD\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\xA4"],
        ["\xE3\x80\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\xA5"],
        ["\xE3\x80\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\xA6"],
        ["\xE3\x80\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\xA7"],
        ["\xE3\x80\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\xA8"],
        ["\xE2\x89\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\xB8"],
        ["\xE2\x89\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\xB9"],
        ["\xE2\x89\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\xBA"],
        ["\xE2\x89\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\xBB"],
        ["\xE2\x89\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\xBC"],
        ["\xE2\x89\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\xBD"],
        ["\xE2\x86\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\xBE"],
        ["\xE2\x99\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x87"],
        ["\xE2\x99\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x88"],
        ["\xE2\x99\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x89"],
        ["\xE2\x99\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x8A"],
        ["\xE2\x96\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x8C"],
        ["\xE2\x96\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x8D"],
        ["\xE2\x97\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x8E"],
        ["\xE2\x97\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x8F"],
        ["\xE2\x86\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x90"],
        ["\xE2\x86\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x91"],
        ["\xE2\x86\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x92"],
        ["\xE2\x86\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x93"],
        ["\xE2\x87\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x94"],
        ["\xE2\x87\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x95"],
        ["\xE2\x87\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x96"],
        ["\xE2\x87\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x97"],
        ["\xE2\x87\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x98"],
        ["\xE2\xA4\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x99"],
        ["\xE2\xA4\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x9A"],
        ["\xE2\xA6\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\xA5"],
        ["\xE2\x97\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\xA6"],
        ["\xE3\x80\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\xA7"],
        ["\xEF\xB9\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\xA8"],
        ["\xEF\xB9\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\xA9"],
        ["\xE2\x97\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\xAA"],
        ["\xE2\x80\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\xAB"],
        ["\xE2\x88\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB8\x86"],
        ["\xE2\x84\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB8\x87"],
        ["\xE2\x84\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB8\x88"],
        ["\xE3\x8F\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB8\x89"],
        ["\xE2\x84\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB8\x8A"],
        ["\xE2\x84\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB8\x8B"],
        ["\xE3\x82\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB8\xA6"],
        ["\xE2\x80\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB8\xA7"],
        ["\xE2\xA7\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB8\xA8"],
        ["\xE2\xA7\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB8\xA9"],
        ["\xE3\x82\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB9\xBD"],
        ["\xE3\x82\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB9\xBE"],
        ["\xE3\x82\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB9\xBF"],
        ["\xE3\x81\x8B\xE3\x82\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBA\x80"],
        ["\xE3\x81\x8D\xE3\x82\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBA\x81"],
        ["\xE3\x81\x8F\xE3\x82\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBA\x82"],
        ["\xE3\x81\x91\xE3\x82\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBA\x83"],
        ["\xE3\x81\x93\xE3\x82\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBA\x84"],
        ["\xE3\x82\xAB\xE3\x82\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBB\x9E"],
        ["\xE3\x82\xAD\xE3\x82\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBB\x9F"],
        ["\xE3\x82\xAF\xE3\x82\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBB\xA0"],
        ["\xE3\x82\xB1\xE3\x82\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBB\xA1"],
        ["\xE3\x82\xB3\xE3\x82\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBB\xA2"],
        ["\xE3\x82\xBB\xE3\x82\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBB\xA3"],
        ["\xE3\x83\x84\xE3\x82\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBB\xA4"],
        ["\xE3\x83\x88\xE3\x82\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBB\xA5"],
        ["\xE2\x99\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBB\xBE"],
        ["\xE2\x99\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBB\xBF"],
        ["\xE2\x99\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\x80"],
        ["\xE2\x99\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\x81"],
        ["\xE2\x99\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\x82"],
        ["\xE2\x99\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\x83"],
        ["\xE2\x99\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\x84"],
        ["\xE2\x99\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\x85"],
        ["\xCF\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\x9E"],
        ["\xE2\x93\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\x9F"],
        ["\xE2\x93\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xA0"],
        ["\xE2\x93\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xA1"],
        ["\xE2\x93\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xA2"],
        ["\xE2\x93\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xA3"],
        ["\xE2\x93\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xA4"],
        ["\xE2\x93\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xA5"],
        ["\xE2\x93\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xA6"],
        ["\xE2\x93\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xA7"],
        ["\xE2\x93\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xA8"],
        ["\xE2\x98\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xA9"],
        ["\xE2\x98\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xAA"],
        ["\xE3\x80\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xAB"],
        ["\xE2\x98\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xAC"],
        ["\xE2\x98\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xAD"],
        ["\xE2\x98\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xAE"],
        ["\xE2\x98\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xAF"],
        ["\xE2\x98\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xB0"],
        ["\xE2\x99\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xB1"],
        ["\xE2\x96\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xB2"],
        ["\xE3\x87\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xB3"],
        ["\xE3\x87\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xB4"],
        ["\xE3\x87\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xB5"],
        ["\xE3\x87\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xB6"],
        ["\xE3\x87\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xB7"],
        ["\xE3\x87\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xB8"],
        ["\xE3\x87\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xB9"],
        ["\xE3\x87\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xBA"],
        ["\xE3\x87\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xBB"],
        ["\xE3\x87\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xBC"],
        ["\xE3\x87\xB7\xE3\x82\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xBD"],
        ["\xE3\x87\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xBE"],
        ["\xE3\x87\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xBF"],
        ["\xE3\x87\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBD\x80"],
        ["\xE3\x87\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBD\x81"],
        ["\xE3\x87\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBD\x82"],
        ["\xE3\x87\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBD\x83"],
        ["\xE2\x8E\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBD\xA5"],
        ["\xE2\x8E\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBD\xA6"],
        ["\xE2\x8F\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBD\xA7"],
        ["\xE2\x8F\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBD\xA8"],
        ["\xE2\x8F\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBD\xA9"],
        ["\xE2\x8F\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBD\xAA"],
        ["\xE2\x8F\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBD\xAB"],
        ["\xE2\x8F\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBD\xAC"],
        ["\xE2\x8F\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBD\xAD"],
        ["\xE2\x8F\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBD\xAE"],
        ["\xE2\x8F\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBD\xAF"],
        ["\xE2\x8F\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBD\xB0"],
        ["\xE2\x8F\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBD\xB1"],
        ["\xE2\x8F\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBD\xB2"],
        ["\xE2\x8F\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBD\xB3"],
        ["\xE3\x83\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBE\x95"],
        ["\xE3\x83\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBE\x96"],
        ["\xE3\x83\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBE\x97"],
        ["\xE3\x83\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBE\x98"],
        ["\xE2\x8B\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBE\x99"],
        ["\xE2\x8B\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBE\x9A"],
        ["\xE2\x85\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBE\x9B"],
        ["\xE2\x85\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBE\x9C"],
        ["\xE2\x85\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBE\x9D"],
        ["\xE2\x9C\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBE\x9E"],
        ["\xE2\x8C\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBE\x9F"],
        ["\xE2\x90\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBE\xA0"],
        ["\xE2\x8F\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBE\xA1"],
        ["\xE3\x89\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x82"],
        ["\xE3\x89\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x83"],
        ["\xE3\x89\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x84"],
        ["\xE3\x89\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x85"],
        ["\xE3\x89\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x86"],
        ["\xE3\x89\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x87"],
        ["\xE3\x89\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x88"],
        ["\xE3\x89\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x89"],
        ["\xE3\x89\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x8A"],
        ["\xE3\x89\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x8B"],
        ["\xE3\x89\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x8C"],
        ["\xE3\x89\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x8D"],
        ["\xE3\x89\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x8E"],
        ["\xE3\x89\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x8F"],
        ["\xE3\x89\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x90"],
        ["\xE3\x8A\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x91"],
        ["\xE3\x8A\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x92"],
        ["\xE3\x8A\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x93"],
        ["\xE3\x8A\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x94"],
        ["\xE3\x8A\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x95"],
        ["\xE3\x8A\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x96"],
        ["\xE3\x8A\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x97"],
        ["\xE3\x8A\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x98"],
        ["\xE3\x8A\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x99"],
        ["\xE3\x8A\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x9A"],
        ["\xE3\x8A\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x9B"],
        ["\xE3\x8A\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x9C"],
        ["\xE3\x8A\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x9D"],
        ["\xE3\x8A\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x9E"],
        ["\xE3\x8A\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x9F"],
        ["\xE2\x97\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\xA8"],
        ["\xE2\x97\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\xA9"],
        ["\xE2\x97\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\xAA"],
        ["\xE2\x97\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\xAB"],
        ["\xE2\x80\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\xAC"],
        ["\xE2\x81\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\xAD"],
        ["\xE2\x81\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\xAE"],
        ["\xE2\x81\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\xAF"],
        ["\xC7\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\xB0"],
        ["\xC7\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\xB1"],
        ["\xC7\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\xB2"],
        ["\xE1\xB8\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\xB3"],
        ["\xE1\xB8\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\xB4"],
        ["\xC7\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\xB5"],
        ["\xC7\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\xB6"],
        ["\xC7\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\xB7"],
        ["\xC7\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\xB8"],
        ["\xC7\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\xB9"],
        ["\xC7\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\xBA"],
        ["\xC7\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\xBB"],
        ["\xC7\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\xBC"],
        ["\xC7\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\xBD"],
        ["\xE2\x82\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x80"],
        ["\xC2\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x81"],
        ["\xC2\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x82"],
        ["\xC2\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x83"],
        ["\xC2\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x84"],
        ["\xC2\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x85"],
        ["\xC2\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x86"],
        ["\xC2\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x87"],
        ["\xC2\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x88"],
        ["\xC2\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x89"],
        ["\xC2\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x8A"],
        ["\xC2\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x8B"],
        ["\xC2\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x8C"],
        ["\xC2\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x8D"],
        ["\xC2\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x8E"],
        ["\xC2\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x8F"],
        ["\xC2\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x90"],
        ["\xC2\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x91"],
        ["\xC2\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x92"],
        ["\xC2\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x93"],
        ["\xC2\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x94"],
        ["\xC2\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x95"],
        ["\xC3\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x96"],
        ["\xC3\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x97"],
        ["\xC3\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x98"],
        ["\xC3\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x99"],
        ["\xC3\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x9A"],
        ["\xC3\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x9B"],
        ["\xC3\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x9C"],
        ["\xC3\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x9D"],
        ["\xC3\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x9E"],
        ["\xC3\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x9F"],
        ["\xC3\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xA0"],
        ["\xC3\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xA1"],
        ["\xC3\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xA2"],
        ["\xC3\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xA3"],
        ["\xC3\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xA4"],
        ["\xC3\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xA5"],
        ["\xC3\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xA6"],
        ["\xC3\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xA7"],
        ["\xC3\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xA8"],
        ["\xC3\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xA9"],
        ["\xC3\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xAA"],
        ["\xC3\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xAB"],
        ["\xC3\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xAC"],
        ["\xC3\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xAD"],
        ["\xC3\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xAE"],
        ["\xC3\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xAF"],
        ["\xC3\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xB0"],
        ["\xC3\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xB1"],
        ["\xC3\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xB2"],
        ["\xC3\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xB3"],
        ["\xC3\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xB4"],
        ["\xC3\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xB5"],
        ["\xC3\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xB6"],
        ["\xC3\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xB7"],
        ["\xC3\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xB8"],
        ["\xC3\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xB9"],
        ["\xC3\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xBA"],
        ["\xC3\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xBB"],
        ["\xC3\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xBC"],
        ["\xC3\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xBD"],
        ["\xC3\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xBE"],
        ["\xC3\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xBF"],
        ["\xC3\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x80"],
        ["\xC3\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x81"],
        ["\xC3\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x82"],
        ["\xC3\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x83"],
        ["\xC3\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x84"],
        ["\xC3\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x85"],
        ["\xC3\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x86"],
        ["\xC3\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x87"],
        ["\xC3\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x88"],
        ["\xC3\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x89"],
        ["\xC3\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x8A"],
        ["\xC3\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x8B"],
        ["\xC3\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x8C"],
        ["\xC3\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x8D"],
        ["\xC3\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x8E"],
        ["\xC3\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x8F"],
        ["\xC3\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x90"],
        ["\xC3\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x91"],
        ["\xC3\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x92"],
        ["\xC3\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x93"],
        ["\xC4\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x94"],
        ["\xC4\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x95"],
        ["\xC5\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x96"],
        ["\xC4\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x97"],
        ["\xC5\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x98"],
        ["\xC4\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x99"],
        ["\xC4\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x9A"],
        ["\xC5\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x9B"],
        ["\xC4\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x9C"],
        ["\xC5\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x9D"],
        ["\xC4\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x9E"],
        ["\xCB\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x9F"],
        ["\xC5\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xA0"],
        ["\xC4\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xA1"],
        ["\xC5\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xA2"],
        ["\xC5\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xA3"],
        ["\xC5\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xA4"],
        ["\xC5\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xA5"],
        ["\xC5\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xA6"],
        ["\xC5\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xA7"],
        ["\xC5\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xA8"],
        ["\xC4\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xA9"],
        ["\xCB\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xAA"],
        ["\xC5\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xAB"],
        ["\xC4\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xAC"],
        ["\xC5\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xAD"],
        ["\xCB\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xAE"],
        ["\xC5\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xAF"],
        ["\xC5\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xB0"],
        ["\xC5\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xB1"],
        ["\xC5\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xB2"],
        ["\xCB\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xB3"],
        ["\xC5\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xB4"],
        ["\xC5\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xB5"],
        ["\xC5\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xB6"],
        ["\xC4\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xB7"],
        ["\xC4\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xB8"],
        ["\xC4\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xB9"],
        ["\xC4\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xBA"],
        ["\xC4\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xBB"],
        ["\xC4\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xBC"],
        ["\xC4\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xBD"],
        ["\xC5\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xBE"],
        ["\xC5\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xBF"],
        ["\xC5\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x80"],
        ["\xC5\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x81"],
        ["\xC5\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x82"],
        ["\xC5\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x83"],
        ["\xC5\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x84"],
        ["\xC5\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x85"],
        ["\xC4\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x86"],
        ["\xC4\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x87"],
        ["\xC4\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x88"],
        ["\xC4\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x89"],
        ["\xC4\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x8A"],
        ["\xC4\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x8B"],
        ["\xC4\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x8C"],
        ["\xC4\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x8D"],
        ["\xC5\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x8E"],
        ["\xC5\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x8F"],
        ["\xC5\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x90"],
        ["\xC5\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x91"],
        ["\xC5\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x92"],
        ["\xC5\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x93"],
        ["\xC5\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x94"],
        ["\xCB\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x95"],
        ["\xC4\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x96"],
        ["\xC4\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x97"],
        ["\xC4\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x98"],
        ["\xC4\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x99"],
        ["\xC5\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x9A"],
        ["\xC5\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x9B"],
        ["\xC4\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x9C"],
        ["\xC4\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x9D"],
        ["\xC4\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x9E"],
        ["\xC4\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x9F"],
        ["\xC5\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xA0"],
        ["\xC5\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xA1"],
        ["\xC9\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xA2"],
        ["\xCA\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xA3"],
        ["\xC9\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xA4"],
        ["\xCA\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xA5"],
        ["\xCA\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xA6"],
        ["\xC9\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xA7"],
        ["\xC9\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xA8"],
        ["\xC9\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xA9"],
        ["\xCA\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xAA"],
        ["\xC9\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xAB"],
        ["\xC9\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xAC"],
        ["\xC9\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xAD"],
        ["\xCA\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xAE"],
        ["\xCA\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xAF"],
        ["\xC9\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xB0"],
        ["\xC9\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xB1"],
        ["\xC9\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xB2"],
        ["\xC9\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xB3"],
        ["\xCA\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xB4"],
        ["\xCA\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xB5"],
        ["\xC9\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xB6"],
        ["\xC5\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xB7"],
        ["\xC9\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xB8"],
        ["\xCA\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xB9"],
        ["\xC4\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xBA"],
        ["\xCA\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xBB"],
        ["\xCA\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xBC"],
        ["\xC9\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xBD"],
        ["\xCA\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xBE"],
        ["\xC7\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xBF"],
        ["\xC9\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x80"],
        ["\xC9\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x81"],
        ["\xCA\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x82"],
        ["\xC9\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x83"],
        ["\xC6\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x84"],
        ["\xC5\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x85"],
        ["\xC5\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x86"],
        ["\xC9\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x87"],
        ["\xCA\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x88"],
        ["\xC9\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x89"],
        ["\xC9\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x8A"],
        ["\xC9\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x8B"],
        ["\xC9\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x8C"],
        ["\xC9\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x8D"],
        ["\xC9\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x8E"],
        ["\xC9\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x8F"],
        ["\xCA\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x90"],
        ["\xC9\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x91"],
        ["\xCA\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x92"],
        ["\xC9\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x93"],
        ["\xC9\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x94"],
        ["\xC9\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x95"],
        ["\xCA\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x96"],
        ["\xC9\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x97"],
        ["\xCA\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x98"],
        ["\xCA\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x99"],
        ["\xC9\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x9A"],
        ["\xCA\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x9B"],
        ["\xC9\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x9C"],
        ["\xC9\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x9D"],
        ["\xC9\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x9E"],
        ["\xC3\xA6\xCC\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x9F"],
        ["\xC7\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xA0"],
        ["\xE1\xBD\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xA1"],
        ["\xE1\xBD\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xA2"],
        ["\xC9\x94\xCC\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xA3"],
        ["\xC9\x94\xCC\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xA4"],
        ["\xCA\x8C\xCC\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xA5"],
        ["\xCA\x8C\xCC\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xA6"],
        ["\xC9\x99\xCC\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xA7"],
        ["\xC9\x99\xCC\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xA8"],
        ["\xC9\x9A\xCC\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xA9"],
        ["\xC9\x9A\xCC\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xAA"],
        ["\xE1\xBD\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xAB"],
        ["\xE1\xBD\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xAC"],
        ["\xCD\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xAD"],
        ["\xCB\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xAE"],
        ["\xCB\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xAF"],
        ["\xCB\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xB0"],
        ["\xCB\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xB1"],
        ["\xCC\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xB2"],
        ["\xE2\x80\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xB3"],
        ["\xCC\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xB4"],
        ["\xCC\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xB5"],
        ["\xCC\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xB6"],
        ["\xCC\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xB7"],
        ["\xCC\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xB8"],
        ["\xCC\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xB9"],
        ["\xCC\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xBA"],
        ["\xCB\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xBB"],
        ["\xCB\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xBC"],
        ["\xCB\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xBD"],
        ["\xCB\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xBE"],
        ["\xCB\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xBF"],
        ["\xCB\xA9\xCB\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x80"],
        ["\xCB\xA5\xCB\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x81"],
        ["\xCC\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x82"],
        ["\xCC\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x83"],
        ["\xCC\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x84"],
        ["\xCC\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x85"],
        ["\xCC\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x86"],
        ["\xCC\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x87"],
        ["\xCC\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x88"],
        ["\xCC\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x89"],
        ["\xCC\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x8A"],
        ["\xCC\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x8B"],
        ["\xCB\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x8C"],
        ["\xCC\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x8D"],
        ["\xCC\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x8E"],
        ["\xCC\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x8F"],
        ["\xCC\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x90"],
        ["\xCC\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x91"],
        ["\xCC\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x92"],
        ["\xCC\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x93"],
        ["\xCC\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x94"],
        ["\xCC\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x95"],
        ["\xCC\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x96"],
        ["\xCC\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x97"],
        ["\xCC\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x98"],
        ["\xCC\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x99"],
        ["\xE2\x9D\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x9A"],
        ["\xE2\x9D\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x9B"],
        ["\xE2\x9D\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x9C"],
        ["\xE2\x9D\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x9D"],
        ["\xE2\x9D\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x9E"],
        ["\xE2\x9D\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x9F"],
        ["\xE2\x9D\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xA0"],
        ["\xE2\x9D\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xA1"],
        ["\xE2\x9D\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xA2"],
        ["\xE2\x9D\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xA3"],
        ["\xE2\x93\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xA4"],
        ["\xE2\x93\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xA5"],
        ["\xE2\x93\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xA6"],
        ["\xE2\x93\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xA7"],
        ["\xE2\x93\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xA8"],
        ["\xE2\x93\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xA9"],
        ["\xE2\x93\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xAA"],
        ["\xE2\x93\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xAB"],
        ["\xE2\x93\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xAC"],
        ["\xE2\x93\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xAD"],
        ["\xE2\x85\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xB8"],
        ["\xE2\x85\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xB9"],
        ["\xE2\x93\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xBA"],
        ["\xE2\x93\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xBB"],
        ["\xE2\x93\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xBC"],
        ["\xE2\x93\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xBD"],
        ["\xE2\x93\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xBE"],
        ["\xE2\x93\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xBF"],
        ["\xE2\x93\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x80"],
        ["\xE2\x93\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x81"],
        ["\xE2\x93\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x82"],
        ["\xE2\x93\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x83"],
        ["\xE2\x93\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x84"],
        ["\xE2\x93\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x85"],
        ["\xE2\x93\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x86"],
        ["\xE2\x93\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x87"],
        ["\xE2\x93\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x88"],
        ["\xE2\x93\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x89"],
        ["\xE2\x93\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x8A"],
        ["\xE2\x93\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x8B"],
        ["\xE2\x93\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x8C"],
        ["\xE2\x93\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x8D"],
        ["\xE2\x93\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x8E"],
        ["\xE2\x93\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x8F"],
        ["\xE2\x93\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x90"],
        ["\xE2\x93\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x91"],
        ["\xE2\x93\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x92"],
        ["\xE2\x93\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x93"],
        ["\xE3\x8B\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x94"],
        ["\xE3\x8B\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x95"],
        ["\xE3\x8B\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x96"],
        ["\xE3\x8B\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x97"],
        ["\xE3\x8B\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x98"],
        ["\xE3\x8B\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x99"],
        ["\xE3\x8B\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x9A"],
        ["\xE3\x8B\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x9B"],
        ["\xE3\x8B\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x9C"],
        ["\xE3\x8B\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x9D"],
        ["\xE3\x8B\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x9E"],
        ["\xE3\x8B\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x9F"],
        ["\xE3\x8B\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\xA0"],
        ["\xE3\x8B\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\xA1"],
        ["\xE3\x8B\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\xA2"],
        ["\xE3\x8B\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\xA3"],
        ["\xE3\x8B\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\xA4"],
        ["\xE3\x8B\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\xA5"],
        ["\xE3\x8B\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\xA6"],
        ["\xE3\x8B\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\xA7"],
        ["\xE3\x8B\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\xA8"],
        ["\xE3\x8B\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\xA9"],
        ["\xE3\x8B\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\xAA"],
        ["\xE3\x8B\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\xAB"],
        ["\xE3\x8B\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\xAC"],
        ["\xE2\x81\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\xB6"],
        ["\xE2\x81\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\xB7"],
        ["\xE2\x85\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x86\x96"],
        ["\xE2\x85\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x86\xAE"],
        ["\xE2\x9D\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\x94"],
        ["\xE2\x98\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\x95"],
        ["\xE4\xBF\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\x96"],
        ["\xF0\xA0\x80\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\x97"],
        ["\xE3\x90\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\x98"],
        ["\xE4\xB8\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\x9A"],
        ["\xE4\xB8\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\x9B"],
        ["\xE4\xBA\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\x9C"],
        ["\xE4\xBB\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\x9E"],
        ["\xE4\xBB\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\x9F"],
        ["\xE4\xBC\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xA1"],
        ["\xE4\xBD\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xA2"],
        ["\xE4\xBD\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xA3"],
        ["\xE4\xBD\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xA4"],
        ["\xE4\xBD\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xA6"],
        ["\xE4\xBD\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xA7"],
        ["\xE4\xBD\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xA8"],
        ["\xE4\xBD\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xA9"],
        ["\xE4\xBE\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xAC"],
        ["\xEF\xA8\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xAD"],
        ["\xE4\xBF\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xAF"],
        ["\xE5\x80\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xB0"],
        ["\xE5\x80\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xB1"],
        ["\xE5\x80\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xB2"],
        ["\xE5\x80\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xB3"],
        ["\xE5\x80\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xB4"],
        ["\xE5\x80\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xB5"],
        ["\xE5\x80\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xB7"],
        ["\xE5\x81\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xB8"],
        ["\xE5\x83\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xBA"],
        ["\xE5\x83\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xBB"],
        ["\xE5\x83\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xBC"],
        ["\xE5\x83\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xBD"],
        ["\xEF\xA8\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xBE"],
        ["\xE5\x84\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xBF"],
        ["\xE5\x84\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x80"],
        ["\xE5\x84\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x81"],
        ["\xE5\x84\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x82"],
        ["\xE5\x84\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x83"],
        ["\xEF\xA8\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x85"],
        ["\xE5\x85\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x86"],
        ["\xE5\x85\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x87"],
        ["\xE3\x92\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x88"],
        ["\xE5\x87\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x8A"],
        ["\xE5\x87\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x8B"],
        ["\xE5\x87\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x8C"],
        ["\xE5\x87\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x8D"],
        ["\xE5\x87\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x8E"],
        ["\xE5\x88\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x8F"],
        ["\xE3\x93\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x90"],
        ["\xE5\x88\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x91"],
        ["\xE5\x89\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x93"],
        ["\xE5\x89\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x94"],
        ["\xE5\x89\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x95"],
        ["\xE5\x8A\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x96"],
        ["\xE5\x8B\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x97"],
        ["\xEF\xA8\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x98"],
        ["\xE5\x8B\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x99"],
        ["\xE5\x8B\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x9A"],
        ["\xE5\x8B\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x9B"],
        ["\xEF\xA8\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x9D"],
        ["\xE5\x8B\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x9E"],
        ["\xE5\x8B\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x9F"],
        ["\xE5\x8C\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xA2"],
        ["\xEF\xA8\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xA3"],
        ["\xE5\x8D\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xA4"],
        ["\xE5\x8D\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xA5"],
        ["\xE5\x8D\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xA6"],
        ["\xE5\x8E\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xA8"],
        ["\xE5\x90\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xAA"],
        ["\xE5\x90\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xAB"],
        ["\xE5\x91\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xAC"],
        ["\xE5\x91\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xAE"],
        ["\xE5\x91\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xAF"],
        ["\xE5\x91\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xB0"],
        ["\xE5\x92\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xB1"],
        ["\xE5\x92\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xB2"],
        ["\xE5\x92\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xB3"],
        ["\xE5\x93\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xB5"],
        ["\xE5\x94\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xB7"],
        ["\xE5\x94\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xB8"],
        ["\xE5\x94\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xB9"],
        ["\xE5\x95\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xBA"],
        ["\xE5\x95\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xBB"],
        ["\xE5\x96\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xBC"],
        ["\xE5\x96\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xBE"],
        ["\xEF\xA8\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xBF"],
        ["\xE5\x96\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x80"],
        ["\xE5\x97\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x81"],
        ["\xEF\xA8\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x82"],
        ["\xE5\x98\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x83"],
        ["\xE5\x98\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x84"],
        ["\xE5\x98\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x85"],
        ["\xE5\x99\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x86"],
        ["\xE5\x99\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x87"],
        ["\xE5\x99\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x88"],
        ["\xEF\xA8\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x89"],
        ["\xE5\x99\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x8A"],
        ["\xE5\x99\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x8B"],
        ["\xE5\x99\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x8C"],
        ["\xE5\x9A\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x8D"],
        ["\xE5\x9A\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x8E"],
        ["\xE5\x9A\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x8F"],
        ["\xE5\x9A\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x90"],
        ["\xE5\x9A\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x91"],
        ["\xE5\x9B\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x92"],
        ["\xE5\x9B\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x93"],
        ["\xE5\x9C\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x94"],
        ["\xF0\xA1\x88\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x95"],
        ["\xE5\x9C\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x96"],
        ["\xE5\x9C\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x97"],
        ["\xE5\x9C\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x98"],
        ["\xE5\x9C\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x99"],
        ["\xE5\x9D\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x9A"],
        ["\xE5\x9D\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x9B"],
        ["\xE5\x9D\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x9C"],
        ["\xE5\x9E\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x9D"],
        ["\xF0\xA1\x8C\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x9F"],
        ["\xE5\x9E\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xA0"],
        ["\xE5\x9F\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xA3"],
        ["\xE5\x9F\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xA4"],
        ["\xE5\x9F\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xA5"],
        ["\xE5\x9F\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xA6"],
        ["\xE5\x9F\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xA7"],
        ["\xE5\x9F\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xA8"],
        ["\xE5\xA0\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xA9"],
        ["\xE5\xA1\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xAB"],
        ["\xE5\xA1\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xAC"],
        ["\xEF\xA8\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xAD"],
        ["\xE5\xA1\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xAE"],
        ["\xE5\xA2\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xAF"],
        ["\xEF\xA8\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xB1"],
        ["\xE5\xA2\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xB2"],
        ["\xF0\xA1\x91\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xB3"],
        ["\xE5\xA3\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xB4"],
        ["\xE5\xA3\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xB5"],
        ["\xE5\xA3\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xB6"],
        ["\xE5\xA3\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xB7"],
        ["\xE5\xA3\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xB8"],
        ["\xE5\xA3\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xB9"],
        ["\xE5\xA4\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xBA"],
        ["\xE8\x99\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xBB"],
        ["\xE5\xA5\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xBD"],
        ["\xE5\xA6\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xBE"],
        ["\xE5\xA6\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xBF"],
        ["\xE5\xA7\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x81"],
        ["\xE5\xA7\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x82"],
        ["\xE5\xA7\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x83"],
        ["\xE5\xA8\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x84"],
        ["\xE5\xA8\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x85"],
        ["\xE5\xA9\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x86"],
        ["\xE5\xA9\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x87"],
        ["\xE5\xA9\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x88"],
        ["\xE5\xA9\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x89"],
        ["\xE5\xAA\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x8A"],
        ["\xE5\xAA\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x8B"],
        ["\xE5\xAA\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x8C"],
        ["\xE5\xAB\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x8D"],
        ["\xF0\xA1\xA2\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x8E"],
        ["\xE5\xAC\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x8F"],
        ["\xE5\xAC\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x90"],
        ["\xE5\x89\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x91"],
        ["\xF0\xA0\xAE\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xA7"],
        ["\xE5\xAD\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xA8"],
        ["\xE5\xAD\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xAA"],
        ["\xE5\xAE\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xAB"],
        ["\xE5\xB0\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xAE"],
        ["\xE5\xB0\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xB0"],
        ["\xE5\xB0\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xB1"],
        ["\xE3\x9E\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xB2"],
        ["\xE5\xB1\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xB3"],
        ["\xEF\xA8\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xB4"],
        ["\xEF\xA8\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xB5"],
        ["\xF0\xA1\x9A\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xB6"],
        ["\xE5\xB1\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xB7"],
        ["\xE5\xB2\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xB8"],
        ["\xE5\xB2\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xB9"],
        ["\xE5\xB2\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xBA"],
        ["\xE5\xB2\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xBB"],
        ["\xE5\xB3\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xBD"],
        ["\xE5\xB3\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xBE"],
        ["\xE5\xB3\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xBF"],
        ["\xE5\xB3\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB9\x80"],
        ["\xF0\xA1\xB8\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB9\x81"],
        ["\xE3\x9F\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB9\x82"],
        ["\xE5\xB4\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB9\x83"],
        ["\xE5\xB5\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB9\x86"],
        ["\xE5\xB5\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB9\x87"],
        ["\xE5\xB5\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB9\x89"],
        ["\xE5\xB6\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB9\x8B"],
        ["\xE5\xB6\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB9\x8C"],
        ["\xE5\xB6\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB9\x8D"],
        ["\xE5\xB6\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB9\x8E"],
        ["\xE5\xB7\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB9\x90"],
        ["\xE5\x90\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB9\x91"],
        ["\xE5\xBD\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\x83\xBE"],
        ["\xE5\x99\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\x90"],
        ["\xE5\xB7\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\x91"],
        ["\xE5\xB8\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\x92"],
        ["\xE5\xB8\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\x93"],
        ["\xE5\xB9\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\x94"],
        ["\xE5\xB9\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\x95"],
        ["\xE5\xBA\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\x96"],
        ["\xEF\xA4\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\x97"],
        ["\xE5\xBB\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\x98"],
        ["\xE5\xBB\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\x99"],
        ["\xE5\xBC\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\x9A"],
        ["\xE5\xBC\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\x9B"],
        ["\xE5\xBC\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\x9C"],
        ["\xE5\xBC\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\x9D"],
        ["\xE5\xBC\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\x9E"],
        ["\xE5\xBC\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xA0"],
        ["\xE5\xBC\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xA1"],
        ["\xE5\xBD\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xA2"],
        ["\xE5\xBD\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xA4"],
        ["\xE5\xBD\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xA5"],
        ["\xE5\xBD\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xA6"],
        ["\xE5\xBD\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xA8"],
        ["\xE5\xBE\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xA9"],
        ["\xE5\xBE\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xAA"],
        ["\xE5\xBE\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xAB"],
        ["\xE5\xBE\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xAC"],
        ["\xE5\xBE\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xAD"],
        ["\xE5\xBF\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xAF"],
        ["\xE5\xBF\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xB1"],
        ["\xE5\xBF\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xB2"],
        ["\xE6\x80\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xB3"],
        ["\xE6\x80\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xB4"],
        ["\xE6\x80\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xB5"],
        ["\xE6\x80\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xB6"],
        ["\xE6\x80\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xB7"],
        ["\xE6\x81\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xB8"],
        ["\xEF\xA8\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xB9"],
        ["\xE6\x82\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xBA"],
        ["\xE6\x82\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xBB"],
        ["\xE6\x83\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xBC"],
        ["\xE6\x83\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xBD"],
        ["\xE6\x83\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xBF"],
        ["\xE6\x83\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x80"],
        ["\xE6\x84\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x81"],
        ["\xE6\x84\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x82"],
        ["\xEF\xA8\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x85"],
        ["\xE6\x86\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x86"],
        ["\xEF\xA8\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x87"],
        ["\xE6\x86\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x88"],
        ["\xE6\x86\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x89"],
        ["\xEF\xA9\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x8A"],
        ["\xE6\x88\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x8B"],
        ["\xE6\x88\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x8C"],
        ["\xE6\x89\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x8D"],
        ["\xE6\x89\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x8E"],
        ["\xE6\x89\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x8F"],
        ["\xE6\x89\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x90"],
        ["\xE6\x8A\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x91"],
        ["\xE6\x8B\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x92"],
        ["\xE6\x8B\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x93"],
        ["\xE6\x8B\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x94"],
        ["\xE6\x8C\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x95"],
        ["\xE6\x8C\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x96"],
        ["\xE6\x8C\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x97"],
        ["\xE6\x8D\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x98"],
        ["\xE6\x8D\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x99"],
        ["\xE6\x8D\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x9A"],
        ["\xE6\x8F\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x9B"],
        ["\xE6\x8F\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x9C"],
        ["\xE6\x90\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x9E"],
        ["\xE6\x90\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x9F"],
        ["\xE6\x90\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xA0"],
        ["\xE6\x91\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xA1"],
        ["\xE6\x91\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xA2"],
        ["\xE6\x91\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xA4"],
        ["\xE6\x92\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xA6"],
        ["\xE6\x92\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xA7"],
        ["\xE6\x93\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xA8"],
        ["\xE6\x93\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xA9"],
        ["\xE6\x93\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xAA"],
        ["\xE6\x93\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xAB"],
        ["\xE6\x93\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xAC"],
        ["\xE6\x94\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xAD"],
        ["\xE6\x94\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xAE"],
        ["\xEF\xA9\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xAF"],
        ["\xE6\x95\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xB0"],
        ["\xE6\x96\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xB1"],
        ["\xEF\xA9\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xB2"],
        ["\xE6\x98\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xB7"],
        ["\xE6\x98\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xB8"],
        ["\xE6\x98\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xBA"],
        ["\xE6\x98\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xBB"],
        ["\xE6\x98\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xBD"],
        ["\xE6\x99\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xBF"],
        ["\xE6\x99\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x80"],
        ["\xF0\xA3\x87\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x81"],
        ["\xE6\x99\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x83"],
        ["\xE6\x99\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x84"],
        ["\xE6\x99\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x87"],
        ["\xE6\x99\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x88"],
        ["\xE6\x9A\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x89"],
        ["\xEF\xA9\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x8A"],
        ["\xE6\x9A\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x8D"],
        ["\xE6\x9B\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x8E"],
        ["\xE6\x9B\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x8F"],
        ["\xE3\xAC\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x90"],
        ["\xE6\x9B\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x91"],
        ["\xE6\x9B\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x92"],
        ["\xE6\x9C\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x94"],
        ["\xE6\x9C\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x96"],
        ["\xE6\x9D\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x98"],
        ["\xE6\x9D\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x99"],
        ["\xE6\x9D\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x9A"],
        ["\xE6\x9E\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x9B"],
        ["\xE6\x9E\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x9C"],
        ["\xE6\x9E\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x9D"],
        ["\xE6\x9E\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x9E"],
        ["\xE6\x9F\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xA0"],
        ["\xE6\x9F\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xA2"],
        ["\xE6\x9F\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xA3"],
        ["\xE6\xA0\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xA6"],
        ["\xE6\xA0\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xA7"],
        ["\xE6\xA0\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xA8"],
        ["\xE6\xA1\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xA9"],
        ["\xE6\xA1\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xAA"],
        ["\xE6\xA1\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xAB"],
        ["\xEF\xA9\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xAC"],
        ["\xE6\xA2\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xAD"],
        ["\xE6\xA2\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xAE"],
        ["\xE6\xA2\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xAF"],
        ["\xE6\xA3\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xB1"],
        ["\xE6\xA3\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xB2"],
        ["\xE6\xA3\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xB3"],
        ["\xE6\xA3\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xB4"],
        ["\xE6\xA3\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xB5"],
        ["\xE6\xA3\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xB6"],
        ["\xE6\xA4\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xB7"],
        ["\xE6\xA5\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xB8"],
        ["\xF0\xA3\x97\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xB9"],
        ["\xE6\xA4\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xBA"],
        ["\xE6\xA5\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xBB"],
        ["\xE6\xA5\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xBC"],
        ["\xE6\xA5\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xBD"],
        ["\xE6\xA5\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xBE"],
        ["\xE6\xA6\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x80"],
        ["\xE6\xA6\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x82"],
        ["\xE6\xA6\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x83"],
        ["\xE6\xA7\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x84"],
        ["\xE3\xAE\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x85"],
        ["\xE3\xAF\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x86"],
        ["\xE6\xA7\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x88"],
        ["\xE6\xA7\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x89"],
        ["\xE6\xA7\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x8A"],
        ["\xE6\xA7\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x8B"],
        ["\xE6\xA8\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x8C"],
        ["\xE6\xA8\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x8D"],
        ["\xF0\xA3\x9C\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x8E"],
        ["\xE6\xA8\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x8F"],
        ["\xE6\xA8\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x90"],
        ["\xE6\xA9\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x91"],
        ["\xE6\xA9\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x92"],
        ["\xE6\xA9\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x93"],
        ["\xE6\xA9\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x94"],
        ["\xF0\xA3\x9D\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x97"],
        ["\xE6\xAA\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x98"],
        ["\xE6\xAA\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x99"],
        ["\xE6\xAA\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x9A"],
        ["\xE6\xAA\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x9B"],
        ["\xE6\xAA\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x9C"],
        ["\xE6\xAB\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x9E"],
        ["\xE3\xB0\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x9F"],
        ["\xEF\xA4\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xA0"],
        ["\xE6\xAC\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xA1"],
        ["\xE6\xAC\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xA2"],
        ["\xE6\xAC\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xA3"],
        ["\xE6\xAC\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xA4"],
        ["\xE6\xAD\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xA5"],
        ["\xE6\xAD\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xA6"],
        ["\xE6\xAD\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xA7"],
        ["\xE6\xAD\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xA8"],
        ["\xE6\xAD\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xA9"],
        ["\xE6\xAD\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xAA"],
        ["\xE6\xAE\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xAB"],
        ["\xE6\xAE\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xAC"],
        ["\xE6\xAE\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xAD"],
        ["\xEF\xA5\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xAE"],
        ["\xE6\xAF\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xAF"],
        ["\xE6\xAF\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xB1"],
        ["\xE6\xAF\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xB2"],
        ["\xE6\xB0\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xB3"],
        ["\xE6\xB0\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xB4"],
        ["\xE6\xB0\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xB5"],
        ["\xE6\xB1\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xB6"],
        ["\xE6\xB2\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xB8"],
        ["\xE6\xB1\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xB9"],
        ["\xE6\xB1\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xBA"],
        ["\xE6\xB2\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xBB"],
        ["\xE6\xB2\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xBD"],
        ["\xE6\xB2\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xBE"],
        ["\xE6\xB3\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xBF"],
        ["\xE6\xB3\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x80"],
        ["\xE6\xB3\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x81"],
        ["\xE6\xB3\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x82"],
        ["\xE6\xB3\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x83"],
        ["\xE6\xB3\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x84"],
        ["\xF0\xA3\xB3\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x85"],
        ["\xE6\xB4\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x87"],
        ["\xE6\xB4\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x88"],
        ["\xE6\xB4\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x89"],
        ["\xE6\xB4\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x8A"],
        ["\xE6\xB4\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x8B"],
        ["\xE6\xB5\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x8C"],
        ["\xE6\xB5\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x8D"],
        ["\xEF\xA9\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x8E"],
        ["\xE6\xB6\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x8F"],
        ["\xE6\xB6\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x91"],
        ["\xE6\xB6\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x92"],
        ["\xE6\xB6\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x93"],
        ["\xE6\xB6\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x95"],
        ["\xE6\xB7\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x96"],
        ["\xE6\xB7\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x97"],
        ["\xE6\xB7\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x98"],
        ["\xE6\xB7\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x99"],
        ["\xE6\xB7\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x9A"],
        ["\xEF\xA9\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x9C"],
        ["\xE6\xB8\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x9D"],
        ["\xE6\xB9\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x9E"],
        ["\xE6\xB9\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xA0"],
        ["\xE6\xBA\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xA1"],
        ["\xE6\xBA\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xA2"],
        ["\xE6\xBB\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xA3"],
        ["\xE6\xBB\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xA4"],
        ["\xE6\xBB\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xA5"],
        ["\xE6\xBC\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xA6"],
        ["\xE6\xBC\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xA7"],
        ["\xEF\xA9\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xA8"],
        ["\xE6\xBC\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xA9"],
        ["\xE6\xBC\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xAA"],
        ["\xE6\xBC\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xAB"],
        ["\xE6\xBD\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xAC"],
        ["\xE6\xBD\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xAD"],
        ["\xE6\xBD\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xAE"],
        ["\xE6\xBD\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xAF"],
        ["\xE6\xBD\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xB0"],
        ["\xE6\xBD\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xB1"],
        ["\xE6\xBE\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xB3"],
        ["\xE6\xBE\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xB4"],
        ["\xE6\xBE\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xB5"],
        ["\xE6\xBE\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xB6"],
        ["\xE6\xBE\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xB7"],
        ["\xE6\xBE\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xB8"],
        ["\xE6\xBE\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xB9"],
        ["\xE6\xBF\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xBA"],
        ["\xE6\xBF\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xBB"],
        ["\xE6\xBF\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xBC"],
        ["\xE6\xBF\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xBD"],
        ["\xE7\x80\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x80"],
        ["\xE7\x81\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x82"],
        ["\xE7\x81\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x83"],
        ["\xE7\x81\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x84"],
        ["\xE7\x81\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x85"],
        ["\xE7\x81\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x86"],
        ["\xE7\x81\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x87"],
        ["\xE7\x82\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x89"],
        ["\xE7\x82\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x8B"],
        ["\xE7\x83\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x8C"],
        ["\xE7\x83\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x8D"],
        ["\xE7\x83\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x8E"],
        ["\xE7\x84\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x90"],
        ["\xE7\x84\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x91"],
        ["\xE7\x84\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x92"],
        ["\xE7\x84\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x93"],
        ["\xE7\x84\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x94"],
        ["\xE7\x85\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x97"],
        ["\xEF\xA9\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x98"],
        ["\xE7\x85\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x99"],
        ["\xE7\x85\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x9B"],
        ["\xE7\x85\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x9C"],
        ["\xE7\x86\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x9E"],
        ["\xE7\x86\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x9F"],
        ["\xE7\x86\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xA0"],
        ["\xE7\x86\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xA2"],
        ["\xE7\x87\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xA3"],
        ["\xE7\x88\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xA5"],
        ["\xE7\x88\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xA6"],
        ["\xE7\x89\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xA7"],
        ["\xE7\x89\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xA8"],
        ["\xE3\xB8\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xA9"],
        ["\xE7\x8A\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xAA"],
        ["\xE7\x8A\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xAB"],
        ["\xE7\x8B\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xAD"],
        ["\xE7\x8B\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xAE"],
        ["\xF0\xA4\x9F\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xAF"],
        ["\xE7\x8C\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xB0"],
        ["\xE7\x8C\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xB1"],
        ["\xE7\x8D\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xB3"],
        ["\xE7\x8D\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xB4"],
        ["\xE7\x8D\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xB5"],
        ["\xE7\x8E\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xB6"],
        ["\xE7\x8E\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xB7"],
        ["\xE7\x8E\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xB8"],
        ["\xE7\x8E\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xB9"],
        ["\xE7\x8E\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xBA"],
        ["\xE7\x8E\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xBB"],
        ["\xE7\x8F\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xBD"],
        ["\xE7\x8F\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xBF"],
        ["\xE7\x8F\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x81"],
        ["\xE7\x90\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x83"],
        ["\xE7\x90\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x84"],
        ["\xE7\x90\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x85"],
        ["\xEF\xA9\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x86"],
        ["\xE7\x90\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x88"],
        ["\xE7\x90\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x8A"],
        ["\xE7\x90\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x8B"],
        ["\xE7\x90\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x8D"],
        ["\xE7\x90\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x8E"],
        ["\xE7\x91\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x8F"],
        ["\xE7\x91\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x90"],
        ["\xE7\x91\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x91"],
        ["\xE7\x91\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x92"],
        ["\xE7\x91\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x93"],
        ["\xE7\x91\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x95"],
        ["\xE7\x91\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x96"],
        ["\xE7\x92\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x97"],
        ["\xE7\x92\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x98"],
        ["\xE7\x92\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x9A"],
        ["\xE7\x92\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x9B"],
        ["\xE7\x92\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x9D"],
        ["\xE7\x92\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x9E"],
        ["\xE7\x92\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x9F"],
        ["\xE7\x92\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xA0"],
        ["\xE7\x92\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xA1"],
        ["\xE7\x92\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xA2"],
        ["\xE7\x92\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xA3"],
        ["\xE7\x93\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xA4"],
        ["\xE7\x93\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xA5"],
        ["\xE7\x93\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xA6"],
        ["\xE7\x93\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xA7"],
        ["\xE7\x94\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xA9"],
        ["\xE7\x95\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xAC"],
        ["\xE7\x96\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xAD"],
        ["\xE3\xBD\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xAE"],
        ["\xE7\x97\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xAF"],
        ["\xE7\x97\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xB0"],
        ["\xE7\x98\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xB1"],
        ["\xE7\x98\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xB2"],
        ["\xE7\x98\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xB3"],
        ["\xE7\x98\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xB4"],
        ["\xE7\x98\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xB5"],
        ["\xE7\x98\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xB6"],
        ["\xE7\x98\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xB7"],
        ["\xE7\x98\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xB8"],
        ["\xE7\x98\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xB9"],
        ["\xE7\x99\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xBA"],
        ["\xE7\x99\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xBB"],
        ["\xE7\x99\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xBC"],
        ["\xE7\x99\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xBD"],
        ["\xE7\x99\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xBE"],
        ["\xE7\x99\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xBF"],
        ["\xE7\x99\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x80"],
        ["\xE7\x9A\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x81"],
        ["\xE7\x9A\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x83"],
        ["\xE7\x9A\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x86"],
        ["\xE7\x9A\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x87"],
        ["\xE7\x9B\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x88"],
        ["\xE7\x9B\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x89"],
        ["\xE7\x9B\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x8A"],
        ["\xE7\x9B\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x8B"],
        ["\xE7\x9B\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x8C"],
        ["\xE7\x9B\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x8D"],
        ["\xE7\x9B\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x8E"],
        ["\xE7\x9C\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x8F"],
        ["\xE7\x9C\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x90"],
        ["\xE7\x9C\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x91"],
        ["\xE7\x9C\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x92"],
        ["\xE7\x9D\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x94"],
        ["\xE7\x9D\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x95"],
        ["\xE7\x9D\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x96"],
        ["\xE7\x9D\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x97"],
        ["\xE7\x9D\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x98"],
        ["\xE7\x9D\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x99"],
        ["\xE7\x9E\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x9A"],
        ["\xE7\x9E\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x9B"],
        ["\xE7\x9E\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x9C"],
        ["\xE7\x9F\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x9D"],
        ["\xE7\xA0\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x9E"],
        ["\xF0\xA5\x92\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x9F"],
        ["\xE7\xA1\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xA0"],
        ["\xE7\xA1\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xA2"],
        ["\xE7\xA1\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xA3"],
        ["\xE7\xA1\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xA4"],
        ["\xE7\xA1\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xA5"],
        ["\xEF\xA9\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xA6"],
        ["\xE7\xA2\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xA7"],
        ["\xF0\xA5\x94\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xA8"],
        ["\xE7\xA2\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xA9"],
        ["\xE7\xA3\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xAA"],
        ["\xE7\xA3\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xAB"],
        ["\xE7\xA4\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xAC"],
        ["\xE7\xA3\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xAD"],
        ["\xE7\xA4\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xAE"],
        ["\xE7\xA4\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xAF"],
        ["\xE7\xA4\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xB0"],
        ["\xE7\xA4\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xB1"],
        ["\xEF\xA9\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xB2"],
        ["\xEF\xA9\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xB3"],
        ["\xE7\xA5\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xB4"],
        ["\xE7\xA5\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xB5"],
        ["\xEF\xA9\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xB6"],
        ["\xEF\xA9\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xB7"],
        ["\xEF\xA9\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xB8"],
        ["\xE7\xA5\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xB9"],
        ["\xEF\xA9\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xBA"],
        ["\xE7\xA5\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xBD"],
        ["\xEF\xA9\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xBE"],
        ["\xEF\xA9\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xBF"],
        ["\xE7\xA6\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x81"],
        ["\xE7\xA6\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x82"],
        ["\xE7\xA6\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x83"],
        ["\xE7\xA7\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x84"],
        ["\xE7\xA7\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x85"],
        ["\xF0\xA5\x9D\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x86"],
        ["\xE7\xA7\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x87"],
        ["\xE7\xA7\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x88"],
        ["\xE7\xA7\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x89"],
        ["\xE7\xA7\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x8A"],
        ["\xE7\xA8\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x8B"],
        ["\xEF\xA9\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x8C"],
        ["\xE7\xA8\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x8D"],
        ["\xE7\xA9\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x8E"],
        ["\xE7\xA9\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x8F"],
        ["\xEF\xA9\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x90"],
        ["\xE7\xAA\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x91"],
        ["\xE7\xAA\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x92"],
        ["\xF0\xA5\xA7\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x93"],
        ["\xE7\xAA\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x94"],
        ["\xE7\xAA\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x95"],
        ["\xE7\xAB\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x96"],
        ["\xE7\xAB\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x98"],
        ["\xE7\xAC\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x99"],
        ["\xE7\xAC\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x9A"],
        ["\xE7\xAC\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x9B"],
        ["\xE7\xAD\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x9C"],
        ["\xE7\xAD\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x9D"],
        ["\xE7\xAD\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x9E"],
        ["\xE7\xAD\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x9F"],
        ["\xE7\xAD\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xA0"],
        ["\xE7\xAD\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xA1"],
        ["\xEF\xA9\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xA3"],
        ["\xE7\xAF\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xA4"],
        ["\xE7\xAF\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xA5"],
        ["\xE7\xB0\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xA6"],
        ["\xE7\xB0\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xA7"],
        ["\xE7\xB0\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xA8"],
        ["\xE7\xB0\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xA9"],
        ["\xE7\xB0\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xAA"],
        ["\xE7\xB0\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xAB"],
        ["\xE4\x89\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xAC"],
        ["\xF0\xA5\xB6\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xAD"],
        ["\xE7\xB1\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xAE"],
        ["\xE7\xB1\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xAF"],
        ["\xE7\xB1\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xB0"],
        ["\xE7\xB2\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xB1"],
        ["\xE7\xB2\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xB2"],
        ["\xE7\xB2\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xB3"],
        ["\xE7\xB2\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xB4"],
        ["\xE7\xB3\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xB5"],
        ["\xE7\xB3\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xB6"],
        ["\xE7\xB3\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xB7"],
        ["\xE7\xB4\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xB8"],
        ["\xE7\xB4\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xB9"],
        ["\xE7\xB4\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xBA"],
        ["\xE7\xB4\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xBB"],
        ["\xE7\xB4\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xBC"],
        ["\xE7\xB4\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xBD"],
        ["\xE7\xB5\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xBE"],
        ["\xE7\xB5\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x80"],
        ["\xE7\xB5\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x82"],
        ["\xE7\xB6\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x83"],
        ["\xE7\xB6\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x84"],
        ["\xE7\xB6\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x86"],
        ["\xE7\xB7\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x87"],
        ["\xE7\xB7\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x88"],
        ["\xE7\xB7\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x8A"],
        ["\xEF\xA9\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x8B"],
        ["\xE7\xB8\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x8C"],
        ["\xE7\xB8\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x8D"],
        ["\xE7\xB8\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x8E"],
        ["\xE7\xB8\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x8F"],
        ["\xEF\xA9\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x90"],
        ["\xE7\xB9\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x91"],
        ["\xE7\xB9\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x93"],
        ["\xE7\xBA\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x95"],
        ["\xEF\xA9\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x97"],
        ["\xE7\xBE\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x98"],
        ["\xE7\xBE\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x99"],
        ["\xE7\xBE\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x9A"],
        ["\xE7\xBF\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x9B"],
        ["\xE7\xBF\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x9C"],
        ["\xE7\xBF\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x9D"],
        ["\xE7\xBF\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x9E"],
        ["\xE7\xBF\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x9F"],
        ["\xE7\xBF\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xA0"],
        ["\xEF\xA9\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xA1"],
        ["\xE8\x80\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xA2"],
        ["\xE8\x80\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xA3"],
        ["\xE8\x80\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xA4"],
        ["\xE8\x80\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xA5"],
        ["\xE8\x80\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xA6"],
        ["\xE8\x83\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xA7"],
        ["\xE8\x83\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xA8"],
        ["\xE8\x83\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xA9"],
        ["\xE8\x83\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xAA"],
        ["\xE8\x84\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xAB"],
        ["\xE8\x85\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xAC"],
        ["\xE8\x85\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xAD"],
        ["\xE8\x85\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xAE"],
        ["\xE8\x85\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xAF"],
        ["\xE8\x85\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xB0"],
        ["\xE8\x86\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xB1"],
        ["\xE8\x87\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xB2"],
        ["\xE8\x87\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xB3"],
        ["\xE8\x87\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xB4"],
        ["\xEF\xA9\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xB5"],
        ["\xE4\x91\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xB6"],
        ["\xE4\x91\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xB7"],
        ["\xE8\x89\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xB8"],
        ["\xE8\x89\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xB9"],
        ["\xF0\xA6\xAB\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xBA"],
        ["\xE8\x8A\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xBB"],
        ["\xE8\x8A\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xBC"],
        ["\xE8\x8A\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xBD"],
        ["\xE8\x8A\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xBE"],
        ["\xE8\x8A\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xBF"],
        ["\xE8\x8A\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x80"],
        ["\xE8\x8A\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x81"],
        ["\xE8\x8A\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x82"],
        ["\xE8\x8A\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x83"],
        ["\xE8\x8B\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x84"],
        ["\xE8\x8B\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x85"],
        ["\xE8\x8B\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x86"],
        ["\xE8\x8B\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x87"],
        ["\xE8\x8C\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x88"],
        ["\xE8\x8C\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x8B"],
        ["\xE8\x8C\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x8C"],
        ["\xE8\x8C\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x8D"],
        ["\xE8\x8D\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x8E"],
        ["\xE8\x8D\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x8F"],
        ["\xE8\x8D\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x90"],
        ["\xE8\x8D\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x91"],
        ["\xE8\x8D\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x92"],
        ["\xE8\x8E\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x93"],
        ["\xE8\x8E\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x94"],
        ["\xE8\x8E\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x95"],
        ["\xE8\x8E\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x96"],
        ["\xE8\x8E\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x97"],
        ["\xE8\x8E\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x98"],
        ["\xE8\x8F\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x99"],
        ["\xE8\x8F\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x9B"],
        ["\xE8\x8F\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x9C"],
        ["\xE8\x8F\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x9D"],
        ["\xE8\x8F\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x9E"],
        ["\xE8\x90\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x9F"],
        ["\xE8\x90\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xA0"],
        ["\xE8\x90\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xA1"],
        ["\xEF\xA9\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xA2"],
        ["\xE8\x91\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xA4"],
        ["\xE8\x91\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xA5"],
        ["\xE8\x91\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xA6"],
        ["\xE8\x92\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xA7"],
        ["\xE8\x92\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xA8"],
        ["\xE8\x92\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xA9"],
        ["\xE8\x92\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xAB"],
        ["\xE8\x93\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xAC"],
        ["\xE8\x93\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xAD"],
        ["\xF0\xA6\xB9\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xAE"],
        ["\xE8\x94\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xAF"],
        ["\xE8\x94\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xB0"],
        ["\xE8\x94\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xB1"],
        ["\xE8\x94\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xB2"],
        ["\xE8\x95\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xB4"],
        ["\xE8\x96\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xB6"],
        ["\xE8\x95\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xB7"],
        ["\xE8\x96\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xB8"],
        ["\xE8\x96\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xB9"],
        ["\xE8\x96\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xBA"],
        ["\xE8\x97\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xBC"],
        ["\xE8\x97\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xBD"],
        ["\xE8\x97\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xBE"],
        ["\xE8\x98\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xBF"],
        ["\xE8\x97\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x80"],
        ["\xE8\x98\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x81"],
        ["\xE8\x98\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x82"],
        ["\xE8\x98\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x83"],
        ["\xF0\xA7\x83\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x84"],
        ["\xE8\x98\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x85"],
        ["\xE8\x98\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x86"],
        ["\xE8\x98\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x87"],
        ["\xE8\x99\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x88"],
        ["\xE8\x99\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x89"],
        ["\xEF\xA4\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x8A"],
        ["\xE8\x99\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x8B"],
        ["\xE4\x96\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x8C"],
        ["\xE8\x99\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x8D"],
        ["\xE8\x99\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x8E"],
        ["\xE8\x9A\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x8F"],
        ["\xE8\x9A\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x90"],
        ["\xE8\x9B\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x91"],
        ["\xE8\x9B\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x92"],
        ["\xE8\x9B\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x93"],
        ["\xE8\x9C\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x94"],
        ["\xE8\x9D\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x95"],
        ["\xE8\x9E\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x96"],
        ["\xE8\x9E\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x97"],
        ["\xE8\x9E\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x98"],
        ["\xE8\x9E\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x99"],
        ["\xE8\x9E\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x9A"],
        ["\xE4\x97\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x9B"],
        ["\xE8\x9F\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x9C"],
        ["\xE8\x9F\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x9D"],
        ["\xE8\xA0\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x9E"],
        ["\xE8\xA0\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x9F"],
        ["\xE8\xA0\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xA0"],
        ["\xE8\xA0\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xA1"],
        ["\xE8\xA0\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xA2"],
        ["\xE8\xA2\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xA3"],
        ["\xE8\xA2\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xA4"],
        ["\xE8\xA3\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xA5"],
        ["\xE8\xA3\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xA6"],
        ["\xF0\xA7\x9A\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xA7"],
        ["\xEF\xA9\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xAA"],
        ["\xE8\xA4\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xAB"],
        ["\xE8\xA4\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xAC"],
        ["\xE8\xA4\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xAD"],
        ["\xE8\xA4\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xAE"],
        ["\xE8\xA4\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xAF"],
        ["\xE8\xA4\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xB0"],
        ["\xE8\xA4\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xB1"],
        ["\xE8\xA5\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xB2"],
        ["\xE8\xA6\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xB3"],
        ["\xEF\xA9\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xB4"],
        ["\xE8\xA7\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xB5"],
        ["\xE8\xA7\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xB6"],
        ["\xE8\xA7\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xB7"],
        ["\xE8\xA8\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xB9"],
        ["\xE8\xA8\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xBA"],
        ["\xE8\xA9\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xBC"],
        ["\xE8\xA9\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xBD"],
        ["\xE8\xA9\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xBE"],
        ["\xE8\xA9\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xBF"],
        ["\xE8\xA9\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x80"],
        ["\xE8\xAB\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x83"],
        ["\xE8\xAB\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x85"],
        ["\xEF\xA9\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x88"],
        ["\xEF\xA9\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x89"],
        ["\xE8\xAD\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x8A"],
        ["\xE8\xAD\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x8B"],
        ["\xE8\xAD\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x8C"],
        ["\xE8\xAD\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x8D"],
        ["\xE8\xAE\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x8E"],
        ["\xE8\xB1\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x8F"],
        ["\xE8\xB1\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x90"],
        ["\xEF\xA9\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x91"],
        ["\xE8\xB3\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x92"],
        ["\xE8\xB3\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x94"],
        ["\xE8\xB3\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x95"],
        ["\xEF\xA9\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x96"],
        ["\xE8\xB4\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x98"],
        ["\xE8\xB6\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x99"],
        ["\xE8\xB7\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x9A"],
        ["\xE8\xB7\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x9B"],
        ["\xE8\xB7\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x9C"],
        ["\xE8\xB8\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x9D"],
        ["\xE8\xB8\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x9E"],
        ["\xE8\xB8\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x9F"],
        ["\xE8\xB9\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xA0"],
        ["\xE8\xB9\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xA1"],
        ["\xF0\xA8\x89\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xA2"],
        ["\xE8\xBB\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xA3"],
        ["\xE4\xA1\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xA4"],
        ["\xE8\xBB\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xA5"],
        ["\xE8\xBC\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xA6"],
        ["\xE8\xBC\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xA7"],
        ["\xE8\xBC\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xA8"],
        ["\xE8\xBD\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xA9"],
        ["\xF0\xA8\x8F\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xAA"],
        ["\xE8\xBE\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xAB"],
        ["\xE8\xBE\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xAC"],
        ["\xE8\xBF\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xAD"],
        ["\xE8\xBF\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xAE"],
        ["\xE8\xBF\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xAF"],
        ["\xE9\x80\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xB0"],
        ["\xE9\x80\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xB1"],
        ["\xEF\xA9\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xB2"],
        ["\xE9\x82\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xB3"],
        ["\xE9\x82\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xB4"],
        ["\xE9\x82\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xB5"],
        ["\xE9\x82\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xB6"],
        ["\xE9\x82\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xB7"],
        ["\xE9\x82\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xB8"],
        ["\xE9\x82\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xB9"],
        ["\xE9\x82\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xBA"],
        ["\xE9\x83\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xBB"],
        ["\xE9\x83\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xBC"],
        ["\xE9\x83\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xBD"],
        ["\xE9\x83\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xBE"],
        ["\xE9\x83\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xBF"],
        ["\xE9\x83\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x81"],
        ["\xE9\x83\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x82"],
        ["\xE9\x84\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x84"],
        ["\xE9\x84\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x86"],
        ["\xE9\x84\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x87"],
        ["\xE9\x84\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x88"],
        ["\xE9\x84\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x8A"],
        ["\xE9\x84\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x8B"],
        ["\xE9\x84\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x8C"],
        ["\xE9\x84\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x8D"],
        ["\xE9\x85\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x8E"],
        ["\xE9\x85\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x8F"],
        ["\xE9\x86\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x90"],
        ["\xE9\x86\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x91"],
        ["\xE9\x86\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x92"],
        ["\xE9\x86\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x93"],
        ["\xE9\x86\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x94"],
        ["\xE9\x87\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x96"],
        ["\xE9\x87\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x9A"],
        ["\xE9\x88\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x9B"],
        ["\xE9\x88\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x9D"],
        ["\xE9\x89\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xA2"],
        ["\xE9\x89\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xA3"],
        ["\xE9\x8B\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xA6"],
        ["\xE9\x8B\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xA7"],
        ["\xE9\x8B\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xA8"],
        ["\xE9\x8C\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xAC"],
        ["\xE9\x8C\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xAD"],
        ["\xE9\x8D\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xB1"],
        ["\xE9\x8D\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xB2"],
        ["\xE9\x8D\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xB3"],
        ["\xE9\x8D\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xB4"],
        ["\xE9\x8D\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xB5"],
        ["\xE9\x8E\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xB7"],
        ["\xE9\x8E\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xB8"],
        ["\xE9\x8E\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xB9"],
        ["\xE9\x8F\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xBC"],
        ["\xE9\x90\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xBD"],
        ["\xE9\x8F\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xBE"],
        ["\xE9\x90\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xBF"],
        ["\xE9\x91\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x80"],
        ["\xE9\x91\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x81"],
        ["\xE9\x91\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x82"],
        ["\xE9\x91\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x83"],
        ["\xE9\x91\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x84"],
        ["\xE9\x96\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x85"],
        ["\xE9\x96\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x86"],
        ["\xE9\x96\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x87"],
        ["\xE9\x96\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x88"],
        ["\xE9\x96\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x89"],
        ["\xE9\x96\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x8A"],
        ["\xE9\x96\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x8B"],
        ["\xE9\x97\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x8C"],
        ["\xE9\x97\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x8D"],
        ["\xE9\x97\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x8E"],
        ["\xE4\xA6\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x8F"],
        ["\xE9\x97\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x90"],
        ["\xE9\x97\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x91"],
        ["\xE9\x99\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x92"],
        ["\xE9\x9A\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x93"],
        ["\xE9\x9A\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x96"],
        ["\xE9\x9A\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x97"],
        ["\xE9\x9B\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x98"],
        ["\xE9\x9B\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x99"],
        ["\xEF\xA9\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x9A"],
        ["\xE9\x9B\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x9B"],
        ["\xE9\x9B\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x9C"],
        ["\xE9\x9D\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xA0"],
        ["\xE9\x9D\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xA2"],
        ["\xE9\x9D\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xA3"],
        ["\xE9\x9D\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xA4"],
        ["\xE9\x9E\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xA5"],
        ["\xE9\x9E\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xA6"],
        ["\xE9\x9E\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xA7"],
        ["\xE9\x9F\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xA8"],
        ["\xE9\x9F\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xA9"],
        ["\xE9\x9F\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xAA"],
        ["\xE9\x9F\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xAB"],
        ["\xE9\x9F\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xAC"],
        ["\xEF\xA9\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xAD"],
        ["\xE9\xA0\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xAE"],
        ["\xE9\xA0\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xAF"],
        ["\xE9\xA0\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xB0"],
        ["\xE9\xA0\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xB1"],
        ["\xEF\xA9\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xB2"],
        ["\xE9\xA1\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xB3"],
        ["\xE9\xA1\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xB4"],
        ["\xE9\xA1\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xB5"],
        ["\xE9\xA1\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xB7"],
        ["\xE9\xA1\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xB8"],
        ["\xEF\xA7\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xB9"],
        ["\xE9\xA1\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xBB"],
        ["\xE9\xA2\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xBC"],
        ["\xE9\xA3\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xBD"],
        ["\xE9\xA3\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xBE"],
        ["\xE9\xA5\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xBF"],
        ["\xE9\xA8\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x81"],
        ["\xE9\xA8\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x82"],
        ["\xE9\xA8\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x83"],
        ["\xE9\xA8\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x84"],
        ["\xE9\xA8\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x85"],
        ["\xE9\xA8\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x86"],
        ["\xE9\xA9\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x87"],
        ["\xE9\xA9\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x89"],
        ["\xE9\xAA\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x8A"],
        ["\xE9\xAB\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x8B"],
        ["\xE9\xAB\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x8C"],
        ["\xE9\xAB\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x8D"],
        ["\xE9\xAB\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x8E"],
        ["\xE9\xAB\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x8F"],
        ["\xE9\xAC\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x90"],
        ["\xE9\xAC\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x91"],
        ["\xE9\xAC\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x92"],
        ["\xE4\xB0\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x93"],
        ["\xE9\xAC\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x94"],
        ["\xE9\xAD\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x95"],
        ["\xE9\xAD\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x96"],
        ["\xE9\xAD\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x97"],
        ["\xE9\xAE\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x9A"],
        ["\xE9\xAE\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x9B"],
        ["\xE9\xAE\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x9D"],
        ["\xE9\xAE\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x9E"],
        ["\xE9\xAF\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x9F"],
        ["\xE9\xAF\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xA0"],
        ["\xE9\xAF\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xA1"],
        ["\xE9\xAF\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xA2"],
        ["\xE9\xAF\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xA3"],
        ["\xE9\xB0\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xA5"],
        ["\xE9\xB1\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xA6"],
        ["\xE9\xB1\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xA7"],
        ["\xE9\xB1\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xA8"],
        ["\xE9\xB1\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xA9"],
        ["\xE9\xB1\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xAA"],
        ["\xE9\xB1\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xAB"],
        ["\xE9\xB1\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xAC"],
        ["\xE9\xB4\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xAD"],
        ["\xE9\xB4\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xAE"],
        ["\xE9\xB5\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xAF"],
        ["\xE9\xB5\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xB0"],
        ["\xE9\xB5\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xB1"],
        ["\xE9\xB5\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xB2"],
        ["\xE9\xB5\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xB4"],
        ["\xE9\xB6\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xB5"],
        ["\xE9\xB6\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xB6"],
        ["\xE9\xB7\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xB7"],
        ["\xE9\xB6\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xB8"],
        ["\xE9\xB6\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xB9"],
        ["\xE9\xB7\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xBA"],
        ["\xF0\xAA\x86\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xBB"],
        ["\xE9\xB7\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xBC"],
        ["\xE9\xB8\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xBD"],
        ["\xE9\xB8\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xBE"],
        ["\xE9\xB9\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xBF"],
        ["\xE9\xBA\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x80"],
        ["\xE9\xBA\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x81"],
        ["\xE9\xBA\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x82"],
        ["\xE9\xBA\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x83"],
        ["\xE9\xBA\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x84"],
        ["\xE9\xBA\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x85"],
        ["\xE9\xBB\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x86"],
        ["\xE9\xBC\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x88"],
        ["\xE9\xBC\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x89"],
        ["\xE9\xBD\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x8A"],
        ["\xE9\xBE\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x8B"],
        ["\xE9\xBE\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x8C"],
        ["\xE9\xBE\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x8D"],
        ["\xE9\xBE\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x8E"],
        ["\xE5\xA7\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x8F"],
        ["\xE5\xB1\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x90"],
        ["\xE5\xB9\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x91"],
        ["\xE7\x98\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x92"],
        ["\xE7\xB9\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x93"],
        ["\xF0\xA0\x82\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x94"],
        ["\xE4\xB8\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x95"],
        ["\xE4\xB8\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x96"],
        ["\xE4\xB8\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x97"],
        ["\xE4\xB8\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x98"],
        ["\xE4\xB8\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x99"],
        ["\xE4\xB8\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x9A"],
        ["\xE4\xB9\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x9B"],
        ["\xE4\xB9\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x9C"],
        ["\xE4\xB9\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x9D"],
        ["\xF0\xA0\x82\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x9E"],
        ["\xE4\xB9\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x9F"],
        ["\xE3\x90\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xA0"],
        ["\xF0\xA0\x82\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xA1"],
        ["\xE4\xB9\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xA2"],
        ["\xE4\xB9\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xA3"],
        ["\xE4\xBA\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xA4"],
        ["\xE3\x90\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xA5"],
        ["\xE3\x90\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xA6"],
        ["\xE4\xBA\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xA7"],
        ["\xE4\xBA\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xA8"],
        ["\xF0\xA0\x86\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xA9"],
        ["\xE4\xBA\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xAA"],
        ["\xE4\xBB\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xAB"],
        ["\xE4\xBB\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xAC"],
        ["\xE4\xBB\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xAD"],
        ["\xE4\xBB\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xAE"],
        ["\xE4\xBB\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xAF"],
        ["\xE4\xBB\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xB0"],
        ["\xE4\xBB\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xB1"],
        ["\xE4\xBC\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xB3"],
        ["\xE4\xBD\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xB4"],
        ["\xE4\xBC\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xB5"],
        ["\xE4\xBC\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xB6"],
        ["\xE4\xBD\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xB7"],
        ["\xE4\xBD\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xB8"],
        ["\xF0\xA0\x88\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xB9"],
        ["\xE4\xBD\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xBA"],
        ["\xE4\xBD\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xBB"],
        ["\xE4\xBD\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xBC"],
        ["\xE4\xBD\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xBD"],
        ["\xE4\xBE\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xBE"],
        ["\xE4\xBE\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xBF"],
        ["\xE4\xBF\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x82"],
        ["\xE4\xBE\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x83"],
        ["\xE4\xBE\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x84"],
        ["\xE4\xBF\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x85"],
        ["\xE4\xBF\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x86"],
        ["\xE4\xBF\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x87"],
        ["\xE4\xBF\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x88"],
        ["\xE3\x91\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x89"],
        ["\xE4\xBF\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x8A"],
        ["\xE5\x80\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x8B"],
        ["\xE5\x80\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x8C"],
        ["\xE5\x80\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x8D"],
        ["\xE5\x80\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x8E"],
        ["\xE3\x91\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x91"],
        ["\xE5\x81\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x94"],
        ["\xE5\x81\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x95"],
        ["\xE5\x81\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x96"],
        ["\xE5\x81\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x97"],
        ["\xE5\x81\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x98"],
        ["\xE5\x81\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x99"],
        ["\xE5\x82\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x9B"],
        ["\xE5\x82\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x9C"],
        ["\xE5\x82\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x9D"],
        ["\xE5\x82\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x9E"],
        ["\xE5\x82\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x9F"],
        ["\xE5\x82\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xA0"],
        ["\xE5\x82\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xA1"],
        ["\xE5\x82\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xA2"],
        ["\xF0\xA0\x8C\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xA3"],
        ["\xE5\x82\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xA4"],
        ["\xE5\x82\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xA5"],
        ["\xE5\x82\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xA6"],
        ["\xE5\x83\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xA7"],
        ["\xE5\x83\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xA8"],
        ["\xE5\x83\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xA9"],
        ["\xF0\xA0\x8E\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xAA"],
        ["\xE5\x83\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xAB"],
        ["\xF0\xA0\x8D\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xAC"],
        ["\xE5\x83\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xAD"],
        ["\xE5\x83\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xAE"],
        ["\xE5\x83\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xAF"],
        ["\xE5\x83\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xB0"],
        ["\xE3\x92\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xB1"],
        ["\xE5\xAE\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xB2"],
        ["\xE5\xAE\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xB3"],
        ["\xE3\x9D\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xB4"],
        ["\xE3\x9D\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xB6"],
        ["\xE5\xAF\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xB7"],
        ["\xE5\xAF\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xB8"],
        ["\xE3\x9D\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xB9"],
        ["\xE3\x9D\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xBA"],
        ["\xE5\xAF\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xBB"],
        ["\xE5\xAF\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xBC"],
        ["\xE3\x9D\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xBD"],
        ["\xE5\xB0\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xBE"],
        ["\xE5\xB0\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xBF"],
        ["\xE5\xB0\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x80"],
        ["\xF0\xA1\xB1\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x81"],
        ["\xE5\xB1\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x82"],
        ["\xE5\xB1\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x83"],
        ["\xE5\xB1\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x84"],
        ["\xE5\xB1\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x85"],
        ["\xE5\xB1\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x86"],
        ["\xE5\xB1\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x87"],
        ["\xF0\xA1\xB4\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x88"],
        ["\xF0\xA1\xB5\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x89"],
        ["\xE5\xB1\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x8A"],
        ["\xF0\xA1\xB5\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x8B"],
        ["\xF0\xA1\xB5\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x8C"],
        ["\xE5\xB2\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x8D"],
        ["\xE5\xB2\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x8E"],
        ["\xE3\x9F\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x8F"],
        ["\xF0\xA1\xB6\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x90"],
        ["\xF0\xA1\xB6\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x91"],
        ["\xE5\xB2\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x92"],
        ["\xE5\xB2\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x93"],
        ["\xE5\xB2\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x95"],
        ["\xF0\xA1\xB6\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x96"],
        ["\xE5\xB2\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x97"],
        ["\xE5\xB2\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x98"],
        ["\xF0\xA1\xB6\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x99"],
        ["\xE5\xB3\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x9A"],
        ["\xF0\xA1\xB7\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x9B"],
        ["\xF0\xA1\xB8\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x9C"],
        ["\xE5\xB4\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x9D"],
        ["\xE5\xB4\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x9E"],
        ["\xE5\xB4\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x9F"],
        ["\xE5\xB4\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xA0"],
        ["\xE5\xB4\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xA1"],
        ["\xE5\xB4\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xA2"],
        ["\xE5\xB4\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xA3"],
        ["\xE5\xB4\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xA4"],
        ["\xE5\xB4\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xA5"],
        ["\xE3\x9F\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xA7"],
        ["\xE5\xB5\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xA8"],
        ["\xE5\xB5\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xA9"],
        ["\xE3\x9F\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xAA"],
        ["\xE5\xB5\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xAB"],
        ["\xF0\xA1\xBC\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xAC"],
        ["\xE3\x9F\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xAD"],
        ["\xE5\xB6\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xAE"],
        ["\xE3\xA0\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xAF"],
        ["\xE5\xB6\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xB0"],
        ["\xE5\xB6\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xB1"],
        ["\xE5\xB6\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xB2"],
        ["\xE5\xB6\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xB3"],
        ["\xE5\xB6\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xB4"],
        ["\xE5\xB6\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xB5"],
        ["\xE5\xB6\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xB6"],
        ["\xF0\xA1\xBD\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xB7"],
        ["\xE5\xB7\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xB9"],
        ["\xE5\xB7\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xBA"],
        ["\xE5\xB7\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xBB"],
        ["\xE5\xB7\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xBC"],
        ["\xF0\xA1\xBF\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xBD"],
        ["\xE5\xB7\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xBE"],
        ["\xE5\xB7\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xBF"],
        ["\xE3\xA0\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x80"],
        ["\xE5\xB8\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x81"],
        ["\xE3\xA0\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x82"],
        ["\xE5\xB8\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x83"],
        ["\xE5\xB8\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x84"],
        ["\xE3\xA1\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x85"],
        ["\xE5\xB8\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x86"],
        ["\xE5\xB8\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x87"],
        ["\xE5\xB8\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x88"],
        ["\xE5\xB9\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x89"],
        ["\xE3\xA1\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x8A"],
        ["\xE5\xB9\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x8B"],
        ["\xE3\xA1\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x8C"],
        ["\xE5\xB9\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x8D"],
        ["\xE5\xB9\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x8E"],
        ["\xE5\xB9\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x8F"],
        ["\xE5\x84\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x90"],
        ["\xF0\xA0\x8F\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x91"],
        ["\xE5\x84\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x92"],
        ["\xE5\x84\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x93"],
        ["\xF0\xA0\x91\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x94"],
        ["\xE5\x85\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x95"],
        ["\xF0\xA0\x94\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x96"],
        ["\xE5\x85\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x97"],
        ["\xE5\x86\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x98"],
        ["\xE5\x86\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x99"],
        ["\xE3\x92\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x9A"],
        ["\xE5\x86\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x9B"],
        ["\xE5\x86\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x9C"],
        ["\xE5\x86\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x9D"],
        ["\xE3\x93\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x9E"],
        ["\xE5\x86\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x9F"],
        ["\xF0\xA0\x97\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xA0"],
        ["\xF0\xA0\x98\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xA1"],
        ["\xE5\x87\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xA2"],
        ["\xE5\x87\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xA3"],
        ["\xE5\x88\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xA4"],
        ["\xE5\x88\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xA5"],
        ["\xE5\x88\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xA6"],
        ["\xF0\xA0\x9D\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xA7"],
        ["\xE5\x89\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xA8"],
        ["\xE5\x89\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xA9"],
        ["\xE5\x89\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xAA"],
        ["\xE5\x89\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xAB"],
        ["\xE5\x8A\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xAC"],
        ["\xE5\x8A\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xAD"],
        ["\xF0\xA0\xA0\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xAE"],
        ["\xE5\x8A\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xAF"],
        ["\xF0\xA0\xA0\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xB0"],
        ["\xE5\x8A\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xB1"],
        ["\xE5\x8A\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xB4"],
        ["\xE5\x8A\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xB5"],
        ["\xE5\x8B\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xB6"],
        ["\xE3\x94\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xB7"],
        ["\xE5\x8B\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xB8"],
        ["\xF0\xA0\xA2\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xB9"],
        ["\xE5\x8B\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xBA"],
        ["\xE5\x8C\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xBB"],
        ["\xE5\x8C\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xBC"],
        ["\xE5\x8C\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xBE"],
        ["\xE5\x8C\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xBF"],
        ["\xE5\x8D\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x80"],
        ["\xF0\xA0\xA5\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x81"],
        ["\xF0\xA0\xA6\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x82"],
        ["\xE5\x8D\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x83"],
        ["\xE5\x8D\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x84"],
        ["\xE5\x8D\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x85"],
        ["\xE5\x8E\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x86"],
        ["\xE5\x8E\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x87"],
        ["\xF0\xA0\xAB\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x88"],
        ["\xE5\x8E\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x89"],
        ["\xE5\x8F\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x8A"],
        ["\xF0\xA0\xAC\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x8B"],
        ["\xE3\x95\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x8C"],
        ["\xE3\x95\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x8D"],
        ["\xE5\x8F\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x8E"],
        ["\xE5\x8F\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x8F"],
        ["\xE3\x95\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x90"],
        ["\xE5\x8F\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x91"],
        ["\xE5\x8F\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x92"],
        ["\xE5\x91\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x93"],
        ["\xE5\x90\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x94"],
        ["\xE5\x90\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x95"],
        ["\xE3\x95\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x96"],
        ["\xE5\x91\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x97"],
        ["\xE5\x91\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x98"],
        ["\xE5\x91\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x99"],
        ["\xE5\x91\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x9A"],
        ["\xE5\x92\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x9C"],
        ["\xE5\x92\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x9D"],
        ["\xE5\x92\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x9E"],
        ["\xE5\x92\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x9F"],
        ["\xE5\x92\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xA0"],
        ["\xE5\x92\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xA1"],
        ["\xE5\x92\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xA2"],
        ["\xE5\x92\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xA3"],
        ["\xE5\x92\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xA4"],
        ["\xE5\x93\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xA5"],
        ["\xF0\xA0\xB5\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xA6"],
        ["\xE5\x93\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xA7"],
        ["\xE5\x93\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xA8"],
        ["\xE5\x93\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xA9"],
        ["\xE5\x93\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xAA"],
        ["\xE5\x94\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xAB"],
        ["\xE5\x94\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xAC"],
        ["\xE5\x94\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xAD"],
        ["\xE5\x94\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xAE"],
        ["\xE5\x95\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xAF"],
        ["\xE3\x96\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xB0"],
        ["\xE5\x95\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xB1"],
        ["\xE5\x95\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xB2"],
        ["\xE3\x96\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xB3"],
        ["\xE5\x95\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xB4"],
        ["\xE5\x95\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xB5"],
        ["\xE5\x95\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xB6"],
        ["\xF0\xA0\xB7\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xB7"],
        ["\xE5\x95\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xB8"],
        ["\xE5\x96\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xB9"],
        ["\xE5\x96\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xBA"],
        ["\xE5\x96\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xBB"],
        ["\xE3\x97\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xBC"],
        ["\xE5\x97\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xBD"],
        ["\xF0\xA0\xBA\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xBE"],
        ["\xF0\xA0\xB9\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xBF"],
        ["\xE5\x96\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x80"],
        ["\xE5\x97\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x81"],
        ["\xE5\x97\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x82"],
        ["\xE5\x97\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x83"],
        ["\xE5\x97\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x84"],
        ["\xE3\x97\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x85"],
        ["\xE5\x97\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x86"],
        ["\xF0\xA0\xB9\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x87"],
        ["\xE5\x97\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x88"],
        ["\xE5\x98\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x89"],
        ["\xF0\xA0\xBD\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x8A"],
        ["\xE5\x98\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x8B"],
        ["\xE5\x98\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x8C"],
        ["\xE5\x98\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x8D"],
        ["\xE5\x98\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x8E"],
        ["\xE3\x97\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x8F"],
        ["\xE5\x98\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x90"],
        ["\xE5\x98\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x91"],
        ["\xE5\x99\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x92"],
        ["\xE5\x99\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x93"],
        ["\xE5\x99\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x94"],
        ["\xE5\x99\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x95"],
        ["\xE5\x99\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x96"],
        ["\xE3\x98\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x97"],
        ["\xE5\x9A\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x98"],
        ["\xE5\x9A\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x99"],
        ["\xE5\x9A\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x9A"],
        ["\xE5\x9A\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x9B"],
        ["\xE5\x9A\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x9C"],
        ["\xE5\x9A\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x9D"],
        ["\xE5\x9A\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x9E"],
        ["\xE5\x9A\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x9F"],
        ["\xE5\x9B\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xA0"],
        ["\xE5\x9B\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xA1"],
        ["\xE5\x9B\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xA2"],
        ["\xE5\x9B\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xA3"],
        ["\xE5\x9B\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xA4"],
        ["\xE5\x9B\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xA5"],
        ["\xF0\xA1\x88\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xA6"],
        ["\xE5\x9C\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xA7"],
        ["\xE5\x9C\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xA8"],
        ["\xF0\xA1\x89\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xA9"],
        ["\xE5\x9C\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xAA"],
        ["\xF0\xA1\x89\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xAB"],
        ["\xE5\x9D\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xAC"],
        ["\xE5\x9D\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xAD"],
        ["\xE5\x9D\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xAE"],
        ["\xE5\x9D\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xAF"],
        ["\xF0\xA1\x89\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xB0"],
        ["\xE5\x9D\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xB1"],
        ["\xE5\x9D\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xB2"],
        ["\xE5\x9D\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xB3"],
        ["\xE5\x9D\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xB4"],
        ["\xE5\x9D\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xB5"],
        ["\xE5\x9D\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xB6"],
        ["\xF0\xA1\x8B\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xB7"],
        ["\xF0\xA1\x8B\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xB8"],
        ["\xE5\x9E\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xBA"],
        ["\xE5\x9E\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xBB"],
        ["\xE5\x9E\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xBC"],
        ["\xE5\x9E\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xBD"],
        ["\xE5\x9F\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xBE"],
        ["\xF0\xA1\x8B\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xBF"],
        ["\xE5\x9F\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x80"],
        ["\xF0\xA1\x8C\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x81"],
        ["\xF0\xA1\x8D\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x82"],
        ["\xE5\x9F\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x83"],
        ["\xE5\x9F\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x84"],
        ["\xE5\x9F\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x85"],
        ["\xE3\x99\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x86"],
        ["\xE5\x9F\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x87"],
        ["\xE5\x9F\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x88"],
        ["\xE5\x9F\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x89"],
        ["\xE5\xA0\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x8A"],
        ["\xE5\xA0\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x8B"],
        ["\xE5\xA0\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x8C"],
        ["\xE5\xA0\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x8D"],
        ["\xE5\xA0\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x8E"],
        ["\xE5\xA0\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x8F"],
        ["\xF0\xA1\x8F\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x90"],
        ["\xE5\xA1\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x91"],
        ["\xE5\xA1\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x92"],
        ["\xE5\xA1\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x93"],
        ["\xE5\xA2\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x94"],
        ["\xE5\xA2\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x95"],
        ["\xE5\xA2\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x96"],
        ["\xE5\xA2\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x97"],
        ["\xE5\xA2\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x98"],
        ["\xE5\xA2\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x99"],
        ["\xE5\xA2\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x9A"],
        ["\xE5\xA2\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x9B"],
        ["\xE5\xA2\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x9C"],
        ["\xF0\xA1\x91\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x9D"],
        ["\xE5\xA3\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x9E"],
        ["\xE5\xA3\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x9F"],
        ["\xE5\xA3\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xA0"],
        ["\xE5\xA3\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xA1"],
        ["\xE5\xA3\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xA2"],
        ["\xE5\xA4\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xA3"],
        ["\xE5\xA4\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xA4"],
        ["\xE5\xA4\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xA6"],
        ["\xE5\xA4\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xA7"],
        ["\xE5\xA4\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xA8"],
        ["\xF0\xA1\x97\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xA9"],
        ["\xE3\x9A\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xAA"],
        ["\xE5\xA4\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xAB"],
        ["\xE3\x9A\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xAC"],
        ["\xE5\xA5\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xAD"],
        ["\xE3\x9A\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xAE"],
        ["\xF0\xA6\xB0\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xAF"],
        ["\xE5\xA5\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xB1"],
        ["\xF0\xA1\x99\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xB2"],
        ["\xE5\xA5\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xB3"],
        ["\xE5\xA5\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xB4"],
        ["\xE5\xA5\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xB5"],
        ["\xE5\xA6\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xB6"],
        ["\xE5\xA6\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xB7"],
        ["\xE5\xA6\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xB8"],
        ["\xE5\xA7\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xB9"],
        ["\xE5\xA7\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xBA"],
        ["\xE5\xA7\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xBB"],
        ["\xE5\xA7\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xBC"],
        ["\xE5\xA7\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xBD"],
        ["\xE5\xA7\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xBE"],
        ["\xE5\xA7\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xBF"],
        ["\xF0\xA1\x9C\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x80"],
        ["\xF0\xA1\x9D\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x81"],
        ["\xE3\x9B\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x82"],
        ["\xE5\xA8\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x83"],
        ["\xE5\xA8\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x84"],
        ["\xE5\xA8\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x85"],
        ["\xE5\xA8\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x86"],
        ["\xE5\xA8\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x87"],
        ["\xE5\xA9\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x88"],
        ["\xE5\xA9\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x89"],
        ["\xE5\xA9\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x8A"],
        ["\xE5\xAA\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x8B"],
        ["\xE5\xAA\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x8C"],
        ["\xE5\xAA\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x8D"],
        ["\xE5\xAA\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x8E"],
        ["\xE5\xAA\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x8F"],
        ["\xE5\xAA\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x90"],
        ["\xE5\xAA\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x91"],
        ["\xE5\xAA\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x92"],
        ["\xE5\xAA\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x93"],
        ["\xE5\xAA\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x94"],
        ["\xE5\xAB\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x95"],
        ["\xE5\xAB\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x96"],
        ["\xE5\xAB\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x97"],
        ["\xE5\xAB\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x98"],
        ["\xE5\xAB\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x99"],
        ["\xE5\xAB\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x9A"],
        ["\xE5\xAB\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x9B"],
        ["\xE5\xAC\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x9C"],
        ["\xE5\xAC\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x9D"],
        ["\xE5\xAC\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x9E"],
        ["\xE5\xAC\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x9F"],
        ["\xE5\xAC\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xA0"],
        ["\xE5\xAD\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xA1"],
        ["\xE5\xAD\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xA2"],
        ["\xE5\xAD\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xA3"],
        ["\xE5\xAD\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xA4"],
        ["\xE5\xAD\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xA5"],
        ["\xE5\xAD\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xA6"],
        ["\xE5\xAE\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xA7"],
        ["\xE5\xAE\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xA8"],
        ["\xF0\xA1\xA7\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xA9"],
        ["\xE5\xB9\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xAA"],
        ["\xF0\xA2\x85\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xAB"],
        ["\xE5\xBA\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xAC"],
        ["\xE5\xBA\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xAD"],
        ["\xE5\xBA\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xAE"],
        ["\xE5\xBA\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xAF"],
        ["\xE5\xBA\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xB0"],
        ["\xE5\xBB\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xB1"],
        ["\xE5\xBB\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xB2"],
        ["\xE5\xBB\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xB3"],
        ["\xF0\xA2\x8C\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xB4"],
        ["\xE5\xBB\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xB5"],
        ["\xE5\xBC\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xB6"],
        ["\xE5\xBC\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xB7"],
        ["\xE5\xBC\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xB8"],
        ["\xF0\xA2\x8E\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xB9"],
        ["\xE5\xBC\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xBA"],
        ["\xE5\xBD\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xBB"],
        ["\xE5\xBD\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xBC"],
        ["\xE5\xBD\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xBD"],
        ["\xE5\xBD\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xBE"],
        ["\xE5\xBE\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xBF"],
        ["\xE5\xBE\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x80"],
        ["\xE5\xBE\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x81"],
        ["\xE5\xBE\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x82"],
        ["\xE5\xBF\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x83"],
        ["\xE3\xA3\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x84"],
        ["\xE5\xBF\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x85"],
        ["\xE5\xBF\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x86"],
        ["\xE5\xBF\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x87"],
        ["\xE5\xBF\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x88"],
        ["\xE5\xBF\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x89"],
        ["\xE5\xBF\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x8A"],
        ["\xE5\xBF\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x8B"],
        ["\xE5\xBF\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x8C"],
        ["\xE5\xBF\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x8D"],
        ["\xE5\xBF\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x8E"],
        ["\xE3\xA4\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x8F"],
        ["\xE6\x80\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x90"],
        ["\xE6\x80\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x91"],
        ["\xE6\x80\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x92"],
        ["\xE3\xA4\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x93"],
        ["\xE6\x81\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x94"],
        ["\xE6\x81\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x95"],
        ["\xE6\x82\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x97"],
        ["\xE6\x82\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x98"],
        ["\xF0\xA2\x9B\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x99"],
        ["\xE6\x82\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x9A"],
        ["\xE6\x82\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x9B"],
        ["\xE6\x82\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x9C"],
        ["\xE6\x83\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x9D"],
        ["\xE6\x83\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x9E"],
        ["\xE6\x83\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x9F"],
        ["\xE6\x83\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xA0"],
        ["\xE6\x83\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xA2"],
        ["\xE6\x84\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xA3"],
        ["\xE6\x84\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xA4"],
        ["\xE6\x84\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xA5"],
        ["\xE6\x84\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xA6"],
        ["\xE6\x84\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xA7"],
        ["\xE6\x84\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xA8"],
        ["\xE3\xA5\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xA9"],
        ["\xE6\x85\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xAA"],
        ["\xE6\x85\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xAB"],
        ["\xE6\x85\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xAC"],
        ["\xE6\x85\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xAD"],
        ["\xF0\xA2\xA1\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xAE"],
        ["\xE6\x86\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xAF"],
        ["\xE6\x86\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xB0"],
        ["\xE6\x86\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xB1"],
        ["\xE6\x86\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xB3"],
        ["\xE6\x86\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xB4"],
        ["\xE6\x86\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xB5"],
        ["\xF0\xA2\xA2\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xB6"],
        ["\xE6\x87\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xB7"],
        ["\xE6\x87\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xB8"],
        ["\xE6\x87\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xB9"],
        ["\xE6\x87\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xBA"],
        ["\xF0\xA2\xA6\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xBB"],
        ["\xE6\x88\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xBC"],
        ["\xE6\x88\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xBD"],
        ["\xE6\x88\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xBE"],
        ["\xE6\x89\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xBF"],
        ["\xE6\x89\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x80"],
        ["\xE6\x89\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x81"],
        ["\xE6\x89\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x82"],
        ["\xE6\x89\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x83"],
        ["\xE6\x89\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x84"],
        ["\xE6\x89\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x85"],
        ["\xE6\x89\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x86"],
        ["\xE6\x89\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x87"],
        ["\xE6\x8A\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x88"],
        ["\xE6\x8B\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x8A"],
        ["\xF0\xA2\xAA\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x8B"],
        ["\xE6\x8B\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x8C"],
        ["\xE6\x8C\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x8D"],
        ["\xE6\x8C\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x8E"],
        ["\xE6\x8C\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x8F"],
        ["\xF0\xA2\xAD\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x90"],
        ["\xF0\xA2\xAD\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x91"],
        ["\xE6\x8C\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x92"],
        ["\xE6\x8C\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x93"],
        ["\xE6\x8C\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x94"],
        ["\xE6\x8C\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x95"],
        ["\xE6\x8D\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x96"],
        ["\xE6\x8D\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x97"],
        ["\xE6\x8D\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x98"],
        ["\xF0\xA2\xAD\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x99"],
        ["\xE6\x8D\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x9A"],
        ["\xF0\xA2\xB0\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x9B"],
        ["\xF0\xA2\xAE\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x9C"],
        ["\xE6\x8D\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x9D"],
        ["\xE6\x8E\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x9E"],
        ["\xE6\x8E\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x9F"],
        ["\xF0\xA2\xB0\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xA0"],
        ["\xE6\x8E\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xA1"],
        ["\xE6\x8E\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xA2"],
        ["\xE6\x8F\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xA3"],
        ["\xE6\x8F\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xA4"],
        ["\xE6\x8F\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xA5"],
        ["\xE6\x8F\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xA6"],
        ["\xE6\x8F\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xA7"],
        ["\xE6\x8F\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xA8"],
        ["\xE6\x8F\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xA9"],
        ["\xE6\x8F\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xAA"],
        ["\xE6\x90\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xAB"],
        ["\xE6\x90\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xAC"],
        ["\xE6\x90\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xAD"],
        ["\xE6\x90\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xAE"],
        ["\xE6\x90\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xAF"],
        ["\xE6\x91\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xB0"],
        ["\xE6\x91\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xB1"],
        ["\xE6\x91\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xB2"],
        ["\xE6\x91\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xB3"],
        ["\xE6\x91\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xB4"],
        ["\xE6\x92\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xB5"],
        ["\xE6\x92\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xB6"],
        ["\xE6\x92\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xB8"],
        ["\xE6\x93\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xB9"],
        ["\xE6\x93\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xBA"],
        ["\xE6\x93\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xBB"],
        ["\xE6\x93\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xBC"],
        ["\xF0\xA2\xB7\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xBD"],
        ["\xE6\x93\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xBE"],
        ["\xE6\x93\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xBF"],
        ["\xE6\x93\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x80"],
        ["\xE6\x94\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x81"],
        ["\xE3\xA9\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x82"],
        ["\xE6\x94\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x83"],
        ["\xE6\x94\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x84"],
        ["\xE6\x94\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x85"],
        ["\xE3\xA9\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x86"],
        ["\xE6\x94\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x87"],
        ["\xE6\x94\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x88"],
        ["\xE6\x95\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x89"],
        ["\xE6\x95\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x8A"],
        ["\xE6\x95\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x8B"],
        ["\xE6\x95\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x8C"],
        ["\xE6\x96\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x8D"],
        ["\xE6\x96\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x8E"],
        ["\xE6\x96\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x8F"],
        ["\xE6\x96\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x90"],
        ["\xE6\x96\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x91"],
        ["\xE6\x96\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x92"],
        ["\xE6\x96\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x93"],
        ["\xE6\x96\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x94"],
        ["\xE6\x97\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x95"],
        ["\xE6\x97\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x96"],
        ["\xE6\x97\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x97"],
        ["\xE3\xAB\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x98"],
        ["\xE6\x97\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x99"],
        ["\xE6\x97\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x9A"],
        ["\xE6\x97\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x9B"],
        ["\xE6\x98\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x9C"],
        ["\xE6\x98\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x9D"],
        ["\xE6\x98\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x9E"],
        ["\xE6\x98\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x9F"],
        ["\xE6\x99\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xA0"],
        ["\xE6\x99\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xA1"],
        ["\xE6\x99\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xA2"],
        ["\xE3\xAB\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xA3"],
        ["\xF0\xA3\x87\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xA4"],
        ["\xE6\x99\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xA6"],
        ["\xE6\x99\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xA7"],
        ["\xF0\xA3\x87\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xA8"],
        ["\xF0\xA3\x86\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xA9"],
        ["\xE6\x99\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xAA"],
        ["\xE6\x99\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xAB"],
        ["\xE6\x99\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xAC"],
        ["\xE6\x99\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xAD"],
        ["\xE6\x99\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xAE"],
        ["\xE6\x9A\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xAF"],
        ["\xE6\x9A\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xB0"],
        ["\xE6\x9A\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xB1"],
        ["\xE3\xAC\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xB3"],
        ["\xE6\x9A\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xB4"],
        ["\xE6\x9A\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xB5"],
        ["\xE6\x9A\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xB6"],
        ["\xE3\xAC\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xB7"],
        ["\xE3\xAC\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xB9"],
        ["\xE6\x9B\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xBA"],
        ["\xE3\xAB\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xBB"],
        ["\xE6\x9C\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xBC"],
        ["\xE6\x9C\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xBD"],
        ["\xE6\x9C\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xBE"],
        ["\xF0\xA3\x8D\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xBF"],
        ["\xE6\x9C\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x80"],
        ["\xF0\xA3\x8F\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x81"],
        ["\xF0\xA3\x8F\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x82"],
        ["\xE6\x9D\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x83"],
        ["\xE6\x9D\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x84"],
        ["\xE6\x9D\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x85"],
        ["\xE6\x9D\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x86"],
        ["\xF0\xA3\x8F\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x87"],
        ["\xF0\xA3\x8F\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x88"],
        ["\xF0\xA3\x8F\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x89"],
        ["\xE6\x9D\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x8A"],
        ["\xE6\x9D\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x8B"],
        ["\xF0\xA3\x8F\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x8C"],
        ["\xE6\x9E\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x8D"],
        ["\xF0\xA3\x8F\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x8E"],
        ["\xE8\x8D\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x8F"],
        ["\xE6\xA0\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x90"],
        ["\xE6\x9E\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x91"],
        ["\xE6\x9E\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x92"],
        ["\xE6\x9F\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x93"],
        ["\xE6\x9F\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x94"],
        ["\xE6\x9F\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x95"],
        ["\xE6\x9F\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x96"],
        ["\xE6\x9F\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x97"],
        ["\xE6\x9F\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x98"],
        ["\xE6\x9F\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x99"],
        ["\xF0\xA3\x91\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x9A"],
        ["\xF0\xA3\x91\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x9B"],
        ["\xF0\xA3\x91\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x9C"],
        ["\xE6\xA0\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x9D"],
        ["\xE6\xA0\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x9E"],
        ["\xE6\xA0\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x9F"],
        ["\xF0\xA3\x91\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xA0"],
        ["\xE6\xA0\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xA1"],
        ["\xE6\xA0\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xA2"],
        ["\xE6\xA0\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xA3"],
        ["\xE6\xA1\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xA5"],
        ["\xE6\xA1\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xA6"],
        ["\xE6\xA1\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xA7"],
        ["\xE6\xA1\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xA8"],
        ["\xE6\xA1\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xA9"],
        ["\xE3\xAD\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xAA"],
        ["\xE6\xA1\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xAB"],
        ["\xE6\xA1\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xAC"],
        ["\xE6\xA1\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xAD"],
        ["\xE6\xA1\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xAE"],
        ["\xE6\xA2\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xAF"],
        ["\xE6\xA2\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xB0"],
        ["\xE6\xA2\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xB1"],
        ["\xE3\xAD\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xB2"],
        ["\xE6\xA2\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xB3"],
        ["\xE6\xA2\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xB4"],
        ["\xE6\xA2\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xB5"],
        ["\xE6\xA2\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xB6"],
        ["\xE6\xA2\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xB7"],
        ["\xE6\xA2\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xB8"],
        ["\xE6\xA2\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xB9"],
        ["\xE6\xA2\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xBA"],
        ["\xE6\xA3\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xBB"],
        ["\xF0\xA3\x93\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xBC"],
        ["\xF0\xA3\x95\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xBD"],
        ["\xE6\xA3\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xBF"],
        ["\xE6\xA3\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x80"],
        ["\xE6\xA3\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x81"],
        ["\xE6\xA3\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x83"],
        ["\xE6\xA3\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x84"],
        ["\xE6\xA3\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x85"],
        ["\xE6\xA3\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x86"],
        ["\xE6\xA3\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x87"],
        ["\xE6\xA3\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x88"],
        ["\xE6\xA4\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x89"],
        ["\xE6\xA4\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x8A"],
        ["\xE3\xAE\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x8B"],
        ["\xE3\xAE\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x8C"],
        ["\xF0\xA3\x96\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x8D"],
        ["\xE6\xA4\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x8E"],
        ["\xE3\xAE\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x8F"],
        ["\xE6\xA5\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x90"],
        ["\xE6\xA5\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x91"],
        ["\xE6\xA5\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x92"],
        ["\xE6\xA5\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x93"],
        ["\xE6\xA5\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x94"],
        ["\xE6\xA5\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x95"],
        ["\xE6\xA6\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x96"],
        ["\xE3\xAE\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x97"],
        ["\xE6\xA6\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x98"],
        ["\xE6\xA6\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x9A"],
        ["\xE6\xA6\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x9B"],
        ["\xE6\xA6\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x9C"],
        ["\xE6\xA6\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x9D"],
        ["\xE6\xA6\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x9E"],
        ["\xE6\xA7\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x9F"],
        ["\xE6\xA7\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xA0"],
        ["\xE6\xA7\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xA1"],
        ["\xF0\xA3\x98\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xA2"],
        ["\xF0\xA3\x99\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xA3"],
        ["\xF0\xA3\x98\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xA5"],
        ["\xF0\xA3\x98\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xA6"],
        ["\xE6\xA7\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xA7"],
        ["\xE6\xA7\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xA8"],
        ["\xE6\xA7\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xA9"],
        ["\xE6\xA7\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xAA"],
        ["\xE3\xAF\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xAB"],
        ["\xE6\xA7\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xAC"],
        ["\xE6\xA7\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xAD"],
        ["\xE6\xA8\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xAE"],
        ["\xE6\xA8\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xAF"],
        ["\xE6\xA8\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xB0"],
        ["\xF0\xA3\x9C\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xB1"],
        ["\xE6\xA8\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xB2"],
        ["\xE6\xA8\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xB3"],
        ["\xE6\xA8\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xB4"],
        ["\xE6\xA8\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xB5"],
        ["\xE6\xA9\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xB7"],
        ["\xE6\xA9\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xB8"],
        ["\xE6\xA9\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xB9"],
        ["\xE6\xA9\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xBA"],
        ["\xE6\xA9\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xBB"],
        ["\xF0\xA3\x9C\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xBC"],
        ["\xE6\xAA\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xBE"],
        ["\xE6\xAA\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xBF"],
        ["\xE3\xAF\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x80"],
        ["\xE6\xAA\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x81"],
        ["\xE6\xAA\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x82"],
        ["\xE6\xAA\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x83"],
        ["\xF0\xA3\x9D\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x84"],
        ["\xE6\xAA\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x85"],
        ["\xE6\xAA\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x86"],
        ["\xE6\xAB\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x87"],
        ["\xE6\xAB\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x88"],
        ["\xE6\xAB\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x89"],
        ["\xE6\xAB\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x8A"],
        ["\xE6\xAB\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x8B"],
        ["\xF0\xA3\x9F\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x8C"],
        ["\xF0\xA3\x9F\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x8D"],
        ["\xE6\xAB\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x8E"],
        ["\xE6\xAB\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x8F"],
        ["\xE6\xAB\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x90"],
        ["\xE6\xAB\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x91"],
        ["\xE6\xAB\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x92"],
        ["\xF0\xA3\xA0\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x93"],
        ["\xE6\xAC\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x94"],
        ["\xE6\xAC\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x95"],
        ["\xE6\xAC\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x96"],
        ["\xE6\xAC\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x97"],
        ["\xF0\xA3\xA0\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x98"],
        ["\xE6\xAC\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x99"],
        ["\xE3\xB0\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x9A"],
        ["\xE6\xAC\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x9B"],
        ["\xE6\xAD\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x9C"],
        ["\xE6\xAD\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x9D"],
        ["\xE6\xAD\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x9E"],
        ["\xE6\xAD\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x9F"],
        ["\xE6\xAD\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xA0"],
        ["\xE6\xAE\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xA1"],
        ["\xE6\xAE\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xA2"],
        ["\xE6\xAE\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xA3"],
        ["\xF0\xA3\xAA\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xA4"],
        ["\xE6\xAE\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xA5"],
        ["\xE6\xAE\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xA6"],
        ["\xE6\xAF\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xA7"],
        ["\xE6\xAF\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xA8"],
        ["\xE6\xAF\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xA9"],
        ["\xE6\xAF\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xAA"],
        ["\xE6\xAF\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xAB"],
        ["\xE6\xAF\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xAC"],
        ["\xE6\xAF\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xAD"],
        ["\xE6\xAF\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xAE"],
        ["\xE6\xB0\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xAF"],
        ["\xE6\xB0\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xB0"],
        ["\xE6\xB0\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xB1"],
        ["\xE6\xB0\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xB2"],
        ["\xE6\xB0\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xB3"],
        ["\xE6\xB0\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xB4"],
        ["\xF0\xA3\xB1\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xB5"],
        ["\xE6\xB1\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xB7"],
        ["\xE6\xB1\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xB8"],
        ["\xE6\xB1\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xB9"],
        ["\xE6\xB2\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xBA"],
        ["\xE6\xB2\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xBB"],
        ["\xE3\xB3\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xBC"],
        ["\xE6\xB2\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xBD"],
        ["\xE6\xB2\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xBE"],
        ["\xE6\xB2\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xBF"],
        ["\xE6\xB2\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x80"],
        ["\xE6\xB3\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x81"],
        ["\xE6\xB3\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x82"],
        ["\xE3\xB3\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x83"],
        ["\xE6\xB3\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x84"],
        ["\xE6\xB3\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x86"],
        ["\xE6\xB3\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x87"],
        ["\xE6\xB3\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x88"],
        ["\xE6\xB3\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x89"],
        ["\xF0\xA3\xB4\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x8A"],
        ["\xE6\xB4\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x8B"],
        ["\xE6\xB4\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x8C"],
        ["\xE6\xB4\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x8D"],
        ["\xE6\xB4\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x8E"],
        ["\xE6\xB4\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x8F"],
        ["\xE6\xB1\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x90"],
        ["\xE6\xB4\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x91"],
        ["\xE6\xB4\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x92"],
        ["\xE6\xB5\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x93"],
        ["\xE6\xB5\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x94"],
        ["\xE6\xB5\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x95"],
        ["\xE6\xB5\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x96"],
        ["\xE6\xB6\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x97"],
        ["\xE6\xB6\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x98"],
        ["\xE6\xB6\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x99"],
        ["\xE6\xB6\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x9A"],
        ["\xE6\xB6\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x9B"],
        ["\xE6\xB6\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x9C"],
        ["\xF0\xA3\xB5\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x9D"],
        ["\xE6\xB8\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x9E"],
        ["\xF0\xA3\xB7\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x9F"],
        ["\xF0\xA3\xB7\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xA0"],
        ["\xF0\xA3\xB7\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xA1"],
        ["\xE6\xB6\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xA2"],
        ["\xE6\xB6\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xA3"],
        ["\xE6\xB6\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xA4"],
        ["\xE6\xB7\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xA5"],
        ["\xE6\xB4\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xA6"],
        ["\xE6\xB7\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xA7"],
        ["\xE6\xB7\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xA8"],
        ["\xE6\xB7\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xAA"],
        ["\xE6\xB7\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xAB"],
        ["\xE6\xB7\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xAC"],
        ["\xE6\xB7\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xAD"],
        ["\xE6\xB8\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xAE"],
        ["\xE6\xB8\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xAF"],
        ["\xE6\xB8\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xB0"],
        ["\xE3\xB4\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xB2"],
        ["\xE6\xB8\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xB3"],
        ["\xE6\xB9\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xB5"],
        ["\xE6\xB9\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xB6"],
        ["\xE6\xB9\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xB7"],
        ["\xE6\xB9\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xB8"],
        ["\xE6\xB9\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xB9"],
        ["\xE6\xB9\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xBA"],
        ["\xE6\xB9\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xBB"],
        ["\xE6\xB9\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xBC"],
        ["\xE6\xB9\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xBD"],
        ["\xE6\xB9\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xBE"],
        ["\xE3\xB4\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xBF"],
        ["\xE6\xBA\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x80"],
        ["\xE6\xBA\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x81"],
        ["\xE6\xBA\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x82"],
        ["\xE6\xBB\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x84"],
        ["\xE6\xBB\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x85"],
        ["\xE6\xBB\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x86"],
        ["\xE6\xBC\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x87"],
        ["\xE6\xBB\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x88"],
        ["\xE6\xBB\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x89"],
        ["\xE6\xBB\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x8A"],
        ["\xE6\xBC\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x8B"],
        ["\xE6\xBC\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x8C"],
        ["\xE6\xBC\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x8D"],
        ["\xE6\xBC\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x8E"],
        ["\xE6\xBC\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x8F"],
        ["\xE6\xBC\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x90"],
        ["\xF0\xA3\xBD\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x91"],
        ["\xE6\xBD\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x92"],
        ["\xE6\xBD\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x93"],
        ["\xE6\xBD\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x94"],
        ["\xE6\xBD\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x95"],
        ["\xE6\xBD\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x96"],
        ["\xE6\xBE\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x97"],
        ["\xE6\xBD\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x98"],
        ["\xE6\xBE\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x99"],
        ["\xE6\xBE\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x9A"],
        ["\xE6\xBE\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x9B"],
        ["\xE6\xBE\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x9C"],
        ["\xE6\xBE\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x9D"],
        ["\xE6\xBE\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x9E"],
        ["\xE3\xB5\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x9F"],
        ["\xE6\xBF\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xA1"],
        ["\xE6\xBF\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xA2"],
        ["\xE6\xBF\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xA3"],
        ["\xE6\xBF\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xA4"],
        ["\xE6\xBF\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xA5"],
        ["\xF0\xA4\x82\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xA6"],
        ["\xE6\xBF\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xA7"],
        ["\xE7\x80\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xA8"],
        ["\xE7\x80\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xAA"],
        ["\xE7\x80\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xAB"],
        ["\xF0\xA4\x84\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xAC"],
        ["\xE7\x80\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xAD"],
        ["\xE7\x80\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xAE"],
        ["\xE7\x80\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xAF"],
        ["\xE7\x81\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xB0"],
        ["\xE7\x81\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xB1"],
        ["\xE7\x81\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xB2"],
        ["\xE3\xB6\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xB3"],
        ["\xE7\x81\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xB4"],
        ["\xE7\x81\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xB5"],
        ["\xE7\x81\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xB6"],
        ["\xE7\x81\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xB7"],
        ["\xE7\x81\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xB8"],
        ["\xE7\x81\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xB9"],
        ["\xE7\x81\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xBA"],
        ["\xE7\x82\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xBB"],
        ["\xE7\x82\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xBC"],
        ["\xE7\x82\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xBD"],
        ["\xE7\x82\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xBE"],
        ["\xF0\xA4\x87\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x80"],
        ["\xE7\x82\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x81"],
        ["\xE7\x82\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x82"],
        ["\xF0\xA4\x87\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x83"],
        ["\xE7\x83\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x84"],
        ["\xE7\x83\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x85"],
        ["\xE7\x83\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x86"],
        ["\xE7\x83\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x87"],
        ["\xE7\x83\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x88"],
        ["\xE7\x84\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x89"],
        ["\xE7\x84\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x8B"],
        ["\xE7\x84\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x8C"],
        ["\xE7\x84\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x8D"],
        ["\xE7\x84\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x8E"],
        ["\xE3\xB7\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x8F"],
        ["\xE7\x84\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x90"],
        ["\xE7\x84\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x91"],
        ["\xE7\x85\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x92"],
        ["\xE7\x85\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x93"],
        ["\xE7\x85\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x94"],
        ["\xE7\x85\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x95"],
        ["\xE3\xB7\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x96"],
        ["\xE7\x86\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x97"],
        ["\xE7\x86\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x98"],
        ["\xE7\x86\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x99"],
        ["\xE7\x86\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x9A"],
        ["\xE7\x86\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x9B"],
        ["\xE7\x86\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x9C"],
        ["\xE7\x86\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x9D"],
        ["\xE7\x86\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x9E"],
        ["\xF0\xA4\x8E\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x9F"],
        ["\xE7\x87\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xA0"],
        ["\xE7\x87\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xA1"],
        ["\xE7\x87\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xA2"],
        ["\xE7\x87\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xA3"],
        ["\xE7\x88\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xA4"],
        ["\xE3\xB8\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xA5"],
        ["\xEF\xA9\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xA6"],
        ["\xE7\x88\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xA7"],
        ["\xE7\x88\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xA8"],
        ["\xE7\x88\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xA9"],
        ["\xE7\x88\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xAA"],
        ["\xE4\xB8\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xAB"],
        ["\xE7\x89\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xAC"],
        ["\xE7\x89\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xAD"],
        ["\xE7\x89\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xAE"],
        ["\xE7\x89\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xAF"],
        ["\xF0\xA4\x98\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xB0"],
        ["\xE7\x89\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xB1"],
        ["\xE7\x89\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xB2"],
        ["\xE7\x89\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xB3"],
        ["\xE7\x89\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xB4"],
        ["\xE7\x8A\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xB5"],
        ["\xF0\xA4\x9A\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xB6"],
        ["\xE7\x8A\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xB7"],
        ["\xE7\x8A\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xB8"],
        ["\xE7\x8A\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xB9"],
        ["\xE7\x8B\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xBB"],
        ["\xE3\xB9\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xBC"],
        ["\xE7\x8B\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xBD"],
        ["\xE3\xB9\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xBE"],
        ["\xE3\xB9\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xBF"],
        ["\xE7\x8B\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x80"],
        ["\xE7\x8B\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x81"],
        ["\xE7\x8C\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x82"],
        ["\xE7\x8C\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x83"],
        ["\xE7\x8C\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x84"],
        ["\xE7\x8C\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x85"],
        ["\xE3\xBA\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x86"],
        ["\xE7\x8C\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x87"],
        ["\xE7\x8C\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x88"],
        ["\xE7\x8C\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x89"],
        ["\xE7\x8C\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x8A"],
        ["\xE7\x8C\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x8B"],
        ["\xE7\x8D\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x8C"],
        ["\xE3\xBA\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x8D"],
        ["\xE7\x8D\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x8E"],
        ["\xE7\x8D\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x8F"],
        ["\xF0\xA4\xA2\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x90"],
        ["\xE7\x8D\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x91"],
        ["\xE7\x8D\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x92"],
        ["\xE7\x8D\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x93"],
        ["\xE7\x8E\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x95"],
        ["\xE7\x8E\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x96"],
        ["\xE7\x8E\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x97"],
        ["\xE7\x8E\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x98"],
        ["\xE7\x8E\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x99"],
        ["\xE7\x8E\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x9A"],
        ["\xE7\x8E\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x9B"],
        ["\xE7\x8E\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x9C"],
        ["\xE7\x8E\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x9D"],
        ["\xE7\x8E\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x9E"],
        ["\xE7\x8E\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x9F"],
        ["\xE7\x8E\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xA0"],
        ["\xE7\x8E\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xA1"],
        ["\xE7\x8E\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xA2"],
        ["\xE7\x8F\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xA3"],
        ["\xE7\x8F\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xA4"],
        ["\xE7\x8F\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xA5"],
        ["\xE7\x8F\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xA6"],
        ["\xE7\x8F\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xA7"],
        ["\xE7\x90\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xA8"],
        ["\xE7\x8F\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xA9"],
        ["\xE7\x90\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xAA"],
        ["\xE7\x90\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xAB"],
        ["\xE7\x90\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xAC"],
        ["\xE7\x90\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xAD"],
        ["\xE7\x91\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xAE"],
        ["\xE7\x91\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xAF"],
        ["\xE7\x91\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xB0"],
        ["\xE7\x91\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xB1"],
        ["\xE7\x91\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xB2"],
        ["\xE7\x91\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xB3"],
        ["\xE7\x91\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xB4"],
        ["\xE7\x92\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xB5"],
        ["\xE7\x92\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xB6"],
        ["\xE7\x92\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xB7"],
        ["\xF0\xA4\xA9\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xB8"],
        ["\xE7\x92\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xB9"],
        ["\xE7\x92\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xBA"],
        ["\xE7\x92\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xBB"],
        ["\xE7\x92\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xBC"],
        ["\xE7\x92\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xBD"],
        ["\xE7\x92\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xBE"],
        ["\xE7\x92\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xBF"],
        ["\xE7\x92\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x80"],
        ["\xE7\x92\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x81"],
        ["\xE7\x92\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x82"],
        ["\xE7\x92\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x83"],
        ["\xE7\x93\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x84"],
        ["\xE7\x93\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x85"],
        ["\xE7\x93\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x86"],
        ["\xE7\x93\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x87"],
        ["\xE7\x93\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x88"],
        ["\xF0\xA4\xAD\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x89"],
        ["\xE7\x93\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x8A"],
        ["\xF0\xA4\xAD\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x8B"],
        ["\xE7\x94\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x8C"],
        ["\xE7\x94\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x8D"],
        ["\xE7\x94\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x8E"],
        ["\xE3\xBD\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x8F"],
        ["\xF0\xA4\xB0\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x90"],
        ["\xE7\x94\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x91"],
        ["\xE7\x94\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x92"],
        ["\xE7\x95\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x93"],
        ["\xE7\x95\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x94"],
        ["\xE7\x95\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x95"],
        ["\xE7\x95\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x96"],
        ["\xE7\x95\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x97"],
        ["\xE7\x95\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x98"],
        ["\xE7\x95\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x99"],
        ["\xE7\x95\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x9A"],
        ["\xE7\x95\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x9B"],
        ["\xE7\x95\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x9C"],
        ["\xE7\x95\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x9D"],
        ["\xE7\x96\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x9E"],
        ["\xF0\xA4\xB4\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x9F"],
        ["\xE7\x96\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xA0"],
        ["\xE3\xBD\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xA1"],
        ["\xE7\x96\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xA2"],
        ["\xE3\xBD\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xA3"],
        ["\xE7\x96\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xA4"],
        ["\xE7\x96\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xA5"],
        ["\xE7\x96\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xA6"],
        ["\xE7\x97\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xA7"],
        ["\xE7\x97\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xA8"],
        ["\xE7\x97\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xA9"],
        ["\xE7\x97\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xAA"],
        ["\xE7\x97\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xAB"],
        ["\xE7\x97\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xAC"],
        ["\xE7\x97\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xAD"],
        ["\xE7\x97\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xAE"],
        ["\xE7\x97\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xAF"],
        ["\xE7\x97\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xB0"],
        ["\xE7\x97\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xB1"],
        ["\xE7\x97\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xB2"],
        ["\xE7\x98\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xB3"],
        ["\xE7\x98\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xB4"],
        ["\xE7\x98\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xB5"],
        ["\xE7\x98\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xB6"],
        ["\xE3\xBE\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xB7"],
        ["\xF0\xA4\xB8\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xB8"],
        ["\xE7\x98\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xB9"],
        ["\xE7\x98\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xBA"],
        ["\xE7\x98\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xBB"],
        ["\xF0\xA4\xB8\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xBC"],
        ["\xE7\x98\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xBD"],
        ["\xE7\x98\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xBE"],
        ["\xE7\x98\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xBF"],
        ["\xE7\x98\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x80"],
        ["\xF0\xA4\xB9\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x81"],
        ["\xE3\xBF\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x82"],
        ["\xE7\x99\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x83"],
        ["\xF0\xA4\xBA\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x84"],
        ["\xE7\x99\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x85"],
        ["\xE7\x99\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x86"],
        ["\xE3\xBF\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x87"],
        ["\xE7\x99\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x88"],
        ["\xE7\x9A\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x89"],
        ["\xE7\x9A\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x8B"],
        ["\xE7\x9A\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x8C"],
        ["\xE7\x9A\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x8D"],
        ["\xE7\x9A\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x8E"],
        ["\xE7\x9A\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x8F"],
        ["\xF0\xA5\x81\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x90"],
        ["\xE7\x9B\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x91"],
        ["\xF0\xA5\x81\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x92"],
        ["\xE7\x9B\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x93"],
        ["\xE7\x9B\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x94"],
        ["\xF0\xA5\x84\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x95"],
        ["\xE7\x9C\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x96"],
        ["\xE7\x9C\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x97"],
        ["\xE7\x9C\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x98"],
        ["\xE7\x9C\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x99"],
        ["\xF0\xA5\x86\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x9A"],
        ["\xE4\x80\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x9B"],
        ["\xF0\xA5\x87\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x9C"],
        ["\xF0\xA5\x87\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x9D"],
        ["\xE7\x9D\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x9E"],
        ["\xE7\x9D\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x9F"],
        ["\xE7\x9D\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xA0"],
        ["\xF0\xA5\x88\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xA1"],
        ["\xE7\x9D\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xA2"],
        ["\xE7\x9D\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xA3"],
        ["\xE7\x9D\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xA4"],
        ["\xF0\xA5\x89\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xA5"],
        ["\xE4\x81\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xA6"],
        ["\xE7\x9E\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xA7"],
        ["\xE7\x9E\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xA8"],
        ["\xE7\x9E\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xA9"],
        ["\xE7\x9E\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xAA"],
        ["\xE7\x9E\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xAB"],
        ["\xE7\x9F\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xAC"],
        ["\xE7\x9F\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xAD"],
        ["\xE7\x9F\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xAE"],
        ["\xE7\x9F\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xAF"],
        ["\xE7\x9F\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xB0"],
        ["\xE7\x9F\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xB1"],
        ["\xE4\x82\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xB2"],
        ["\xE7\x9F\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xB3"],
        ["\xE7\x9F\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xB4"],
        ["\xE7\x9F\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xB5"],
        ["\xF0\xA5\x90\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xB6"],
        ["\xE7\xA0\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xB7"],
        ["\xE7\xA0\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xB8"],
        ["\xE7\xA0\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xB9"],
        ["\xE7\xA0\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xBA"],
        ["\xE7\xA0\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xBB"],
        ["\xE7\xA0\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xBD"],
        ["\xE7\xA1\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xBE"],
        ["\xE7\xA1\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x80"],
        ["\xF0\xA5\x93\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x81"],
        ["\xE7\xA2\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x82"],
        ["\xE7\xA2\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x83"],
        ["\xE7\xA2\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x84"],
        ["\xE7\xA2\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x85"],
        ["\xE7\xA2\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x86"],
        ["\xE7\xA2\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x87"],
        ["\xE7\xA2\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x88"],
        ["\xE7\xA3\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x89"],
        ["\xE7\xA3\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x8A"],
        ["\xE7\xA3\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x8B"],
        ["\xE7\xA3\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x8C"],
        ["\xE7\xA3\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x8D"],
        ["\xE7\xA3\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x8E"],
        ["\xE7\xA3\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x8F"],
        ["\xE7\xA3\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x90"],
        ["\xE7\xA3\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x91"],
        ["\xE7\xA3\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x92"],
        ["\xE7\xA3\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x93"],
        ["\xF0\xA5\x96\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x94"],
        ["\xE7\xA4\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x95"],
        ["\xE7\xA4\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x96"],
        ["\xE7\xA4\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x98"],
        ["\xE7\xA4\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x99"],
        ["\xE7\xA5\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x9A"],
        ["\xE7\xA5\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x9B"],
        ["\xE7\xA5\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x9C"],
        ["\xE4\x84\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x9D"],
        ["\xE7\xA5\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x9E"],
        ["\xE7\xA5\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x9F"],
        ["\xE7\xA6\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xA1"],
        ["\xE7\xA6\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xA2"],
        ["\xE7\xA6\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xA4"],
        ["\xE7\xA6\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xA5"],
        ["\xE7\xA6\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xA6"],
        ["\xE7\xA6\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xA7"],
        ["\xE7\xA7\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xA8"],
        ["\xE7\xA7\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xA9"],
        ["\xE7\xA7\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xAA"],
        ["\xE7\xA7\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xAB"],
        ["\xE7\xA7\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xAC"],
        ["\xE4\x85\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xAD"],
        ["\xF0\xA5\x9E\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xAE"],
        ["\xF0\xA5\x9E\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xAF"],
        ["\xE4\x85\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xB0"],
        ["\xE7\xA8\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xB1"],
        ["\xE7\xA8\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xB2"],
        ["\xE7\xA8\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xB3"],
        ["\xE7\xA8\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xB4"],
        ["\xE7\xA8\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xB5"],
        ["\xE4\x85\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xB6"],
        ["\xE7\xA8\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xB7"],
        ["\xE7\xA8\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xB8"],
        ["\xE7\xA9\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xB9"],
        ["\xE7\xA9\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xBA"],
        ["\xE7\xA9\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xBB"],
        ["\xE7\xA9\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xBC"],
        ["\xE7\xA9\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xBD"],
        ["\xE7\xA9\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xBE"],
        ["\xE7\xA9\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xBF"],
        ["\xE7\xA9\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x80"],
        ["\xE7\xA9\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x81"],
        ["\xE7\xA9\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x82"],
        ["\xE7\xA9\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x83"],
        ["\xE7\xAA\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x84"],
        ["\xE7\xAA\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x85"],
        ["\xE7\xAA\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x86"],
        ["\xE7\xAA\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x87"],
        ["\xE7\xAA\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x88"],
        ["\xF0\xA5\xA7\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x89"],
        ["\xE4\x86\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x8A"],
        ["\xE7\xAA\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x8B"],
        ["\xE7\xAA\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x8C"],
        ["\xE7\xAA\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x8D"],
        ["\xE4\x86\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x8E"],
        ["\xE7\xAB\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x8F"],
        ["\xE7\xAB\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x92"],
        ["\xE7\xAB\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x93"],
        ["\xF0\xA5\xAB\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x94"],
        ["\xF0\xA5\xAB\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x95"],
        ["\xE7\xAC\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x96"],
        ["\xF0\xA5\xAB\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x97"],
        ["\xE7\xAC\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x98"],
        ["\xE7\xAC\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x99"],
        ["\xE7\xAC\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x9A"],
        ["\xE7\xAC\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x9B"],
        ["\xE7\xAC\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x9C"],
        ["\xE7\xAC\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x9D"],
        ["\xE4\x87\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x9E"],
        ["\xE4\x87\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x9F"],
        ["\xE7\xAD\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xA0"],
        ["\xE7\xAD\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xA1"],
        ["\xE4\x87\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xA2"],
        ["\xE7\xAD\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xA3"],
        ["\xE7\xAD\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xA4"],
        ["\xE7\xAD\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xA5"],
        ["\xE7\xAD\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xA6"],
        ["\xE7\xAD\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xA7"],
        ["\xE7\xAD\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xA8"],
        ["\xF0\xA5\xAE\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xA9"],
        ["\xE4\x88\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xAA"],
        ["\xE7\xAE\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xAB"],
        ["\xE7\xAE\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xAC"],
        ["\xE7\xAE\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xAD"],
        ["\xE4\x88\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xAE"],
        ["\xE7\xAE\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xAF"],
        ["\xE7\xAE\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xB0"],
        ["\xE7\xAE\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xB1"],
        ["\xE7\xAF\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xB2"],
        ["\xE7\xAF\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xB3"],
        ["\xF0\xA5\xB1\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xB4"],
        ["\xF0\xA5\xB1\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xB5"],
        ["\xE7\xAF\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xB6"],
        ["\xE7\xAF\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xB7"],
        ["\xE7\xAF\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xB8"],
        ["\xE7\xAF\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xB9"],
        ["\xE7\xAF\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xBA"],
        ["\xE7\xB0\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xBB"],
        ["\xE7\xB0\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xBC"],
        ["\xE7\xB0\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xBD"],
        ["\xE7\xB0\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xBE"],
        ["\xE7\xB0\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xBF"],
        ["\xE7\xB1\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x80"],
        ["\xE7\xB1\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x81"],
        ["\xE7\xB1\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x82"],
        ["\xE7\xB1\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x83"],
        ["\xE7\xB1\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x84"],
        ["\xE7\xB1\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x85"],
        ["\xE7\xB1\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x86"],
        ["\xE7\xB1\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x87"],
        ["\xE7\xB1\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x88"],
        ["\xE7\xB1\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x89"],
        ["\xF0\xA5\xB8\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x8A"],
        ["\xF0\xA5\xB9\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x8B"],
        ["\xF0\xA5\xB9\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x8C"],
        ["\xE7\xB2\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x8D"],
        ["\xF0\xA5\xB9\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x8E"],
        ["\xE7\xB2\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x8F"],
        ["\xE7\xB2\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x90"],
        ["\xE7\xB2\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x91"],
        ["\xF0\xA5\xBB\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x92"],
        ["\xE7\xB3\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x93"],
        ["\xF0\xA5\xBB\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x94"],
        ["\xE7\xB3\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x95"],
        ["\xE7\xB3\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x96"],
        ["\xF0\xA5\xBB\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x97"],
        ["\xE7\xB3\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x98"],
        ["\xF0\xA5\xBC\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x99"],
        ["\xE7\xB3\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x9A"],
        ["\xE7\xB3\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x9B"],
        ["\xF0\xA5\xBD\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x9C"],
        ["\xE7\xB3\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x9D"],
        ["\xE7\xB4\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x9E"],
        ["\xE7\xB4\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x9F"],
        ["\xE4\x8B\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xA0"],
        ["\xE7\xB4\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xA1"],
        ["\xE7\xB4\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xA2"],
        ["\xF0\xA5\xBF\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xA3"],
        ["\xF0\xA5\xBF\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xA4"],
        ["\xE7\xB4\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xA5"],
        ["\xE7\xB4\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xA6"],
        ["\xE7\xB5\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xA7"],
        ["\xE7\xB5\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xA8"],
        ["\xF0\xA6\x80\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xA9"],
        ["\xF0\xA5\xBF\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xAA"],
        ["\xE4\x8B\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xAB"],
        ["\xE7\xB5\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xAC"],
        ["\xE7\xB5\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xAD"],
        ["\xE7\xB5\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xAE"],
        ["\xE7\xB5\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xAF"],
        ["\xE4\x8B\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xB0"],
        ["\xE7\xB5\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xB1"],
        ["\xF0\xA6\x80\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xB2"],
        ["\xE7\xB6\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xB3"],
        ["\xE7\xB6\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xB4"],
        ["\xE7\xB6\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xB5"],
        ["\xE7\xB6\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xB6"],
        ["\xF0\xA6\x81\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xB7"],
        ["\xE7\xB6\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xB8"],
        ["\xE7\xB6\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xB9"],
        ["\xE7\xB6\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xBA"],
        ["\xE7\xB6\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xBB"],
        ["\xE7\xB7\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xBD"],
        ["\xE7\xB7\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xBE"],
        ["\xE7\xB7\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xBF"],
        ["\xE7\xB7\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x80"],
        ["\xE7\xB7\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x81"],
        ["\xE7\xB7\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x82"],
        ["\xE4\x8C\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x83"],
        ["\xF0\xA6\x83\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x84"],
        ["\xEF\xA9\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x85"],
        ["\xE7\xB8\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x86"],
        ["\xE7\xB8\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x87"],
        ["\xE7\xB8\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x88"],
        ["\xE7\xB8\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x89"],
        ["\xE7\xB8\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x8A"],
        ["\xE7\xB8\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x8B"],
        ["\xE7\xB9\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x8C"],
        ["\xE7\xB9\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x8D"],
        ["\xE7\xB9\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x8E"],
        ["\xE7\xB9\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x8F"],
        ["\xE7\xBA\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x90"],
        ["\xE7\xBA\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x91"],
        ["\xE4\x8C\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x92"],
        ["\xE7\xBA\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x93"],
        ["\xE7\xBA\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x94"],
        ["\xE7\xBA\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x95"],
        ["\xE4\x8D\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x96"],
        ["\xE7\xBC\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x97"],
        ["\xE7\xBC\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x98"],
        ["\xE7\xBC\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x99"],
        ["\xE7\xBD\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x9A"],
        ["\xE7\xBD\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x9B"],
        ["\xE7\xBD\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x9C"],
        ["\xE3\x93\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x9D"],
        ["\xF0\xA6\x89\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x9E"],
        ["\xE7\xBD\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x9F"],
        ["\xF0\xA6\x8A\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xA0"],
        ["\xE7\xBD\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xA1"],
        ["\xE7\xBD\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xA2"],
        ["\xE7\xBD\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xA3"],
        ["\xE7\xBD\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xA4"],
        ["\xE7\xBD\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xA5"],
        ["\xE7\xBD\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xA6"],
        ["\xF0\xA6\x8D\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xA7"],
        ["\xE7\xBE\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xA8"],
        ["\xE5\x85\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xA9"],
        ["\xF0\xA3\xB4\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xAA"],
        ["\xE7\xBE\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xAB"],
        ["\xE7\xBE\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xAC"],
        ["\xE7\xBE\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xAD"],
        ["\xF0\xA6\x90\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xAE"],
        ["\xE7\xBF\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xAF"],
        ["\xE7\xBF\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xB0"],
        ["\xE7\xBF\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xB1"],
        ["\xE7\xBF\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xB2"],
        ["\xE7\xBF\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xB3"],
        ["\xE7\xBF\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xB4"],
        ["\xE8\x80\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xB5"],
        ["\xE8\x80\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xB6"],
        ["\xE8\x80\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xB7"],
        ["\xE8\x80\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xB8"],
        ["\xE8\x80\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xB9"],
        ["\xE8\x80\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xBA"],
        ["\xE8\x80\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xBB"],
        ["\xE8\x80\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xBC"],
        ["\xE8\x80\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xBD"],
        ["\xE8\x81\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xBE"],
        ["\xE8\x81\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xBF"],
        ["\xE8\x81\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x80"],
        ["\xE8\x81\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x81"],
        ["\xE8\x81\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x82"],
        ["\xE8\x82\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x83"],
        ["\xE8\x82\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x84"],
        ["\xE8\x82\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x85"],
        ["\xE8\x82\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x86"],
        ["\xE8\x82\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x87"],
        ["\xF0\xA6\x99\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x88"],
        ["\xE8\x83\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x89"],
        ["\xE8\x83\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x8A"],
        ["\xE8\x83\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x8B"],
        ["\xE8\x83\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x8C"],
        ["\xF0\xA6\x9A\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x8D"],
        ["\xE8\x84\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x8E"],
        ["\xE8\x83\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x8F"],
        ["\xE8\x83\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x90"],
        ["\xE4\x8F\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x91"],
        ["\xE8\x84\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x92"],
        ["\xE8\x84\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x93"],
        ["\xE8\x84\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x94"],
        ["\xE4\x8F\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x95"],
        ["\xE8\x84\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x96"],
        ["\xE8\x84\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x97"],
        ["\xE8\x84\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x98"],
        ["\xF0\xA6\x9C\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x99"],
        ["\xE8\x84\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x9A"],
        ["\xE4\x90\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x9B"],
        ["\xE8\x85\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x9C"],
        ["\xE4\x90\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x9D"],
        ["\xE8\x86\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x9E"],
        ["\xE4\x90\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x9F"],
        ["\xE8\x86\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xA0"],
        ["\xE8\x86\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xA1"],
        ["\xE4\x90\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xA2"],
        ["\xE8\x86\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xA3"],
        ["\xE8\x86\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xA4"],
        ["\xE8\x87\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xA5"],
        ["\xE8\x87\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xA6"],
        ["\xE8\x87\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xA7"],
        ["\xE8\x87\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xA8"],
        ["\xF0\xA6\xA3\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xA9"],
        ["\xE8\x87\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xAA"],
        ["\xF0\xA6\xA3\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xAB"],
        ["\xE8\x87\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xAC"],
        ["\xF0\xA6\xA5\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xAD"],
        ["\xE8\x87\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xAE"],
        ["\xE8\x87\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xAF"],
        ["\xF0\xA6\xA5\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xB0"],
        ["\xE8\x88\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xB1"],
        ["\xF0\xA6\xA7\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xB2"],
        ["\xE8\x88\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xB3"],
        ["\xE8\x88\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xB4"],
        ["\xE8\x88\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xB5"],
        ["\xF0\xA6\xA8\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xB6"],
        ["\xE8\x88\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xB7"],
        ["\xE8\x88\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xB8"],
        ["\xE8\x88\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xB9"],
        ["\xE8\x89\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xBA"],
        ["\xE8\x89\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xBB"],
        ["\xE8\x89\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xBC"],
        ["\xF0\xA6\xA9\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xBD"],
        ["\xE8\x89\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xBE"],
        ["\xE4\x91\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xBF"],
        ["\xE8\x89\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x80"],
        ["\xE4\x91\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x81"],
        ["\xE8\x89\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x82"],
        ["\xF0\xA6\xAA\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x83"],
        ["\xE8\x89\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x84"],
        ["\xE8\x89\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x85"],
        ["\xF0\xA6\xAA\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x86"],
        ["\xEF\xA9\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x87"],
        ["\xEF\xA9\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x88"],
        ["\xE8\x89\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x89"],
        ["\xE4\x92\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x8A"],
        ["\xE8\x89\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x8B"],
        ["\xE8\x89\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x8C"],
        ["\xE8\x8A\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x8D"],
        ["\xE8\x8A\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x8E"],
        ["\xE8\x8A\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x8F"],
        ["\xE8\x8A\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x90"],
        ["\xE8\x8A\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x91"],
        ["\xE8\x8A\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x92"],
        ["\xE8\x8A\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x93"],
        ["\xE8\x8A\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x94"],
        ["\xE8\x8A\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x95"],
        ["\xE8\x8B\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x96"],
        ["\xE8\x8B\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x97"],
        ["\xE8\x8B\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x98"],
        ["\xE8\x8C\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x99"],
        ["\xE8\x8C\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x9A"],
        ["\xE8\x8C\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x9B"],
        ["\xE8\x8D\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x9C"],
        ["\xE8\x8C\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x9D"],
        ["\xE8\x8C\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x9E"],
        ["\xE8\x8C\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x9F"],
        ["\xE8\x8C\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xA0"],
        ["\xE8\x8D\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xA1"],
        ["\xE8\x8D\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xA2"],
        ["\xE4\x92\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xA3"],
        ["\xE4\x93\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xA5"],
        ["\xE4\x92\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xA6"],
        ["\xE8\x8E\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xA7"],
        ["\xE8\x8E\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xA8"],
        ["\xE8\x8E\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xA9"],
        ["\xE8\x8E\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xAA"],
        ["\xE8\x8E\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xAB"],
        ["\xE8\x8F\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xAC"],
        ["\xE8\x8F\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xAD"],
        ["\xE8\x8F\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xAE"],
        ["\xE8\x8F\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xAF"],
        ["\xE8\x8F\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xB0"],
        ["\xE8\x8F\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xB1"],
        ["\xE8\x90\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xB2"],
        ["\xE8\x90\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xB3"],
        ["\xE8\x90\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xB4"],
        ["\xF0\xA6\xB1\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xB5"],
        ["\xE8\x90\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xB6"],
        ["\xE8\x90\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xB7"],
        ["\xE8\x91\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xB8"],
        ["\xE8\x91\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xB9"],
        ["\xE8\x91\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xBA"],
        ["\xE8\x91\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xBB"],
        ["\xE8\x91\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xBC"],
        ["\xE8\x91\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xBD"],
        ["\xE8\x91\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xBE"],
        ["\xF0\xA6\xB3\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xBF"],
        ["\xE8\x91\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x80"],
        ["\xE8\x91\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x81"],
        ["\xE8\x91\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x82"],
        ["\xE8\x91\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x83"],
        ["\xE8\x92\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x84"],
        ["\xE4\x94\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x85"],
        ["\xE8\x92\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x87"],
        ["\xE8\x92\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x88"],
        ["\xE8\x92\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x89"],
        ["\xE4\x94\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x8A"],
        ["\xE8\x93\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x8B"],
        ["\xE8\x93\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x8C"],
        ["\xE8\x93\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x8D"],
        ["\xF0\xA6\xB9\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x8E"],
        ["\xE8\x93\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x8F"],
        ["\xE8\x93\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x90"],
        ["\xE8\x93\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x91"],
        ["\xE8\x93\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x92"],
        ["\xE8\x93\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x93"],
        ["\xE8\x93\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x94"],
        ["\xE8\x93\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x95"],
        ["\xE8\x94\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x96"],
        ["\xE8\x94\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x97"],
        ["\xE8\x94\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x98"],
        ["\xE8\x94\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x99"],
        ["\xE8\x94\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x9A"],
        ["\xE8\x94\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x9B"],
        ["\xE8\x95\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x9C"],
        ["\xE8\x95\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x9D"],
        ["\xE4\x94\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x9E"],
        ["\xE4\x95\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x9F"],
        ["\xE8\x94\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xA0"],
        ["\xE8\x95\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xA1"],
        ["\xE8\x95\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xA3"],
        ["\xE8\x95\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xA4"],
        ["\xE8\x95\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xA5"],
        ["\xF0\xA6\xBE\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xA6"],
        ["\xE8\x95\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xA7"],
        ["\xE8\x95\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xA8"],
        ["\xE8\x95\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xA9"],
        ["\xE8\x96\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xAA"],
        ["\xE8\x96\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xAB"],
        ["\xE8\x96\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xAC"],
        ["\xE8\x96\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xAD"],
        ["\xE8\x96\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xAE"],
        ["\xF0\xA6\xBF\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xAF"],
        ["\xF0\xA6\xBF\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xB0"],
        ["\xF0\xA6\xBF\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xB1"],
        ["\xE8\x96\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xB2"],
        ["\xE8\x96\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xB3"],
        ["\xE8\x97\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xB4"],
        ["\xE8\x97\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xB5"],
        ["\xE8\x97\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xB6"],
        ["\xE8\x97\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xB7"],
        ["\xE8\x97\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xB8"],
        ["\xE8\x97\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xB9"],
        ["\xE8\x97\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xBA"],
        ["\xE8\x97\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xBB"],
        ["\xE8\x98\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xBC"],
        ["\xE8\x98\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xBD"],
        ["\xE8\x98\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xBE"],
        ["\xE8\x98\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xBF"],
        ["\xE8\x98\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x80"],
        ["\xE8\x98\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x81"],
        ["\xF0\xA7\x84\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x82"],
        ["\xE8\x98\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x83"],
        ["\xE8\x98\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x84"],
        ["\xF0\xA7\x84\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x85"],
        ["\xE8\x99\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x86"],
        ["\xE8\x99\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x88"],
        ["\xE8\x99\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x89"],
        ["\xE8\x99\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x8A"],
        ["\xE8\x99\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x8B"],
        ["\xE8\x99\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x8C"],
        ["\xE8\x9A\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x8D"],
        ["\xE8\x9A\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x8E"],
        ["\xE8\x9A\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x8F"],
        ["\xE8\x9A\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x90"],
        ["\xE8\x9A\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x91"],
        ["\xE8\x9A\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x92"],
        ["\xE8\x9A\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x93"],
        ["\xE8\x9A\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x95"],
        ["\xE8\x9A\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x96"],
        ["\xE8\x9B\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x97"],
        ["\xE8\x9B\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x98"],
        ["\xE8\x9B\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x99"],
        ["\xE8\x9B\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x9A"],
        ["\xE8\x9B\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x9B"],
        ["\xE8\x9B\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x9C"],
        ["\xE8\x9B\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x9D"],
        ["\xE4\x96\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x9E"],
        ["\xE8\x9C\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x9F"],
        ["\xE8\x9C\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xA0"],
        ["\xE8\x9C\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xA1"],
        ["\xE8\x9C\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xA2"],
        ["\xE8\x9C\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xA3"],
        ["\xE8\x9C\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xA4"],
        ["\xE8\x9C\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xA5"],
        ["\xE8\x9C\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xA6"],
        ["\xE8\x9C\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xA7"],
        ["\xE8\x9C\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xA8"],
        ["\xE8\x9C\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xA9"],
        ["\xE8\x9C\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xAA"],
        ["\xE8\x9D\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xAB"],
        ["\xE8\x9D\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xAC"],
        ["\xE8\x9D\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xAD"],
        ["\xE8\x9D\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xAE"],
        ["\xE8\x9D\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xAF"],
        ["\xE8\x9D\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xB0"],
        ["\xE8\x9D\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xB1"],
        ["\xE8\x9D\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xB2"],
        ["\xF0\xA7\x8F\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xB3"],
        ["\xF0\xA7\x8F\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xB4"],
        ["\xE8\x9E\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xB5"],
        ["\xE8\x9E\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xB6"],
        ["\xE8\x9E\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xB7"],
        ["\xE8\x9E\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xB8"],
        ["\xE8\x9E\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xB9"],
        ["\xF0\xA7\x8F\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xBA"],
        ["\xE4\x97\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xBB"],
        ["\xE8\x9E\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xBC"],
        ["\xF0\xA7\x90\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xBD"],
        ["\xE8\x9F\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xBE"],
        ["\xE8\x9F\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xBF"],
        ["\xE8\x9F\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x80"],
        ["\xE8\x9F\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x81"],
        ["\xF0\xA7\x91\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x82"],
        ["\xE8\x9F\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x83"],
        ["\xE8\x9F\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x84"],
        ["\xE8\x9F\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x85"],
        ["\xE8\x9F\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x86"],
        ["\xE8\x9F\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x87"],
        ["\xE8\x9F\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x88"],
        ["\xE8\xA0\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x89"],
        ["\xE8\xA0\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x8A"],
        ["\xE8\xA0\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x8B"],
        ["\xE8\xA0\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x8C"],
        ["\xE8\xA0\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x8D"],
        ["\xE8\xA0\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x8E"],
        ["\xE8\xA0\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x8F"],
        ["\xE8\xA0\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x90"],
        ["\xE4\x98\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x91"],
        ["\xE8\xA1\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x92"],
        ["\xE8\xA1\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x93"],
        ["\xE8\xA1\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x94"],
        ["\xE8\xA1\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x95"],
        ["\xF0\xA7\x98\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x96"],
        ["\xF0\xA7\x98\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x97"],
        ["\xE8\xA1\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x98"],
        ["\xF0\xA7\x98\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x99"],
        ["\xE8\xA1\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x9A"],
        ["\xE8\xA2\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x9B"],
        ["\xE8\xA2\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x9C"],
        ["\xE8\xA2\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x9D"],
        ["\xE8\xA2\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x9E"],
        ["\xE8\xA3\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x9F"],
        ["\xE8\xA3\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xA0"],
        ["\xF0\xA7\x9A\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xA1"],
        ["\xE8\xA3\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xA2"],
        ["\xE8\xA3\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xA3"],
        ["\xE8\xA3\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xA4"],
        ["\xE8\xA3\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xA5"],
        ["\xE8\xA3\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xA6"],
        ["\xE4\x99\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xA7"],
        ["\xE8\xA4\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xA8"],
        ["\xF0\xA7\x9C\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xA9"],
        ["\xE8\xA4\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xAA"],
        ["\xF0\xA7\x9C\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xAB"],
        ["\xE8\xA5\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xAC"],
        ["\xE8\xA5\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xAD"],
        ["\xE8\xA5\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xAE"],
        ["\xF0\xA7\x9D\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xAF"],
        ["\xE4\x99\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xB0"],
        ["\xE8\xA5\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xB1"],
        ["\xE8\xA6\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xB2"],
        ["\xE8\xA6\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xB3"],
        ["\xE8\xA6\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xB4"],
        ["\xE8\xA6\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xB5"],
        ["\xE8\xA6\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xB6"],
        ["\xE8\xA6\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xB7"],
        ["\xE8\xA7\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xB8"],
        ["\xE8\xA7\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xB9"],
        ["\xE8\xA7\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xBA"],
        ["\xE4\x9A\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xBB"],
        ["\xE8\xA7\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xBC"],
        ["\xE8\xA7\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xBD"],
        ["\xE8\xA7\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xBE"],
        ["\xE8\xA7\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xBF"],
        ["\xE4\x9A\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x80"],
        ["\xE8\xA8\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x81"],
        ["\xE8\xA8\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x82"],
        ["\xF0\xA7\xA6\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x83"],
        ["\xE8\xA8\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x84"],
        ["\xE8\xA8\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x85"],
        ["\xE8\xA8\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x86"],
        ["\xE8\xA9\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x87"],
        ["\xE8\xA9\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x88"],
        ["\xE8\xA9\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x89"],
        ["\xE8\xAA\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x8A"],
        ["\xE8\xAA\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x8B"],
        ["\xE8\xAA\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x8C"],
        ["\xE8\xAB\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x8E"],
        ["\xE8\xAB\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x8F"],
        ["\xF0\xA7\xAA\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x90"],
        ["\xE8\xAC\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x91"],
        ["\xE8\xAC\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x92"],
        ["\xE8\xAC\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x93"],
        ["\xE8\xAC\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x94"],
        ["\xE8\xAC\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x95"],
        ["\xE8\xAC\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x96"],
        ["\xE8\xAD\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x97"],
        ["\xE4\x9C\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x98"],
        ["\xE8\xAD\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x99"],
        ["\xE8\xAD\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x9A"],
        ["\xE8\xAD\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x9B"],
        ["\xE8\xAE\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x9D"],
        ["\xE8\xAE\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x9E"],
        ["\xE8\xAE\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x9F"],
        ["\xE8\xAE\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xA0"],
        ["\xE8\xAE\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xA1"],
        ["\xE8\xAE\x9E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xA2"],
        ["\xE8\xB0\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xA3"],
        ["\xF0\xA7\xAE\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xA4"],
        ["\xE8\xB0\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xA5"],
        ["\xF0\xA7\xAE\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xA6"],
        ["\xF0\xA7\xAF\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xA7"],
        ["\xE8\xB1\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xA8"],
        ["\xE8\xB1\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xA9"],
        ["\xE8\xB1\x8F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xAA"],
        ["\xE8\xB1\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xAB"],
        ["\xE8\xB2\xA4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xB6"],
        ["\xE8\xB3\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xB7"],
        ["\xE8\xB3\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xB8"],
        ["\xE8\xB3\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xB9"],
        ["\xF0\xA7\xB6\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xBA"],
        ["\xE8\xB3\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xBC"],
        ["\xF0\xA7\xB8\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xBD"],
        ["\xE8\xB4\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xBE"],
        ["\xE8\xB4\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xBF"],
        ["\xE8\xB5\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9C\x80"],
        ["\xE8\xB6\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9C\x81"],
        ["\xE8\xB6\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9C\x82"],
        ["\xE8\xB6\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9C\x83"],
        ["\xF0\xA7\xBE\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9C\x84"],
        ["\xE8\xB7\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9C\x85"],
        ["\xE8\xB7\x88",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9C\x86"],
        ["\xE8\xB7\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9C\x87"],
        ["\xE4\x9F\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9C\x8A"],
        ["\xE8\xB7\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9C\x8B"],
        ["\xE8\xB8\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9C\x91"],
        ["\xE4\xA0\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9C\x94"],
        ["\xE4\xA1\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9C\xA7"],
        ["\xE8\xBF\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9C\xBB"],
        ["\xE9\x81\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9D\x86"],
        ["\xE9\x81\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9D\x87"],
        ["\xE4\xA2\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9D\x90"],
        ["\xE9\x83\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9D\x9C"],
        ["\xE9\x89\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9E\x83"],
        ["\xE9\x89\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9E\x8B"],
        ["\xE9\x8A\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9E\x93"],
        ["\xE9\x8A\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9E\x95"],
        ["\xE9\x8E\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9F\x80"],
        ["\xE9\x8F\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9F\x86"],
        ["\xE9\x96\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9F\x9D"],
        ["\xE9\x98\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9F\xA5"],
        ["\xE9\x98\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9F\xA6"],
        ["\xE9\x98\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9F\xA7"],
        ["\xE9\x98\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9F\xA9"],
        ["\xE9\x9A\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9F\xAD"],
        ["\xE4\xA7\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9F\xB1"],
        ["\xE4\xA7\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9F\xB7"],
        ["\xE9\x9B\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9F\xB9"],
        ["\xE4\xA8\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9F\xBC"],
        ["\xE4\xA8\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9F\xBF"],
        ["\xE9\x9D\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA0\x84"],
        ["\xE9\x9D\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA0\x86"],
        ["\xE9\x9F\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA0\x90"],
        ["\xE9\xA0\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA0\x98"],
        ["\xE9\xA0\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA0\x9A"],
        ["\xE9\xA0\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA0\x9B"],
        ["\xE4\xAA\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA0\x9C"],
        ["\xE9\xA0\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA0\x9E"],
        ["\xE4\xAC\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA0\xBA"],
        ["\xE9\xA4\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\x81"],
        ["\xE9\xA5\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\x90"],
        ["\xE9\xA6\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\x91"],
        ["\xE9\xA7\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\x9D"],
        ["\xE9\xA7\xBC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\x9E"],
        ["\xE9\xA8\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xA0"],
        ["\xE9\xA8\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xA2"],
        ["\xE9\xA8\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xA3"],
        ["\xE9\xA8\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xA4"],
        ["\xE9\xA8\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xA5"],
        ["\xE9\xA9\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xA6"],
        ["\xE9\xA9\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xA7"],
        ["\xE9\xA9\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xA8"],
        ["\xE4\xAF\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xA9"],
        ["\xE9\xAA\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xAA"],
        ["\xE4\xAF\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xAB"],
        ["\xE9\xAA\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xAC"],
        ["\xE4\xAF\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xAD"],
        ["\xE9\xAA\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xAE"],
        ["\xE9\xAB\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xB0"],
        ["\xE9\xAB\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xB1"],
        ["\xE9\xAB\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xB2"],
        ["\xE9\xAB\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xB3"],
        ["\xE4\xAF\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xB4"],
        ["\xE9\xAB\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xB6"],
        ["\xE9\xAB\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xB7"],
        ["\xE9\xAB\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xB8"],
        ["\xE9\xAC\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xB9"],
        ["\xE9\xAC\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xBA"],
        ["\xE9\xAC\x90",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xBB"],
        ["\xE9\xAC\x92",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xBC"],
        ["\xE9\xAC\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xBD"],
        ["\xE9\xAC\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xBE"],
        ["\xE9\xAC\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xBF"],
        ["\xE9\xAC\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x80"],
        ["\xE9\xAC\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x81"],
        ["\xE4\xB0\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x82"],
        ["\xE9\xAD\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x83"],
        ["\xE9\xAD\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x84"],
        ["\xE9\xAD\xA5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x85"],
        ["\xE9\xAD\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x86"],
        ["\xE9\xAD\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x87"],
        ["\xE9\xAD\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x88"],
        ["\xE9\xAD\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x89"],
        ["\xE9\xAD\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x8A"],
        ["\xE9\xAE\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x8B"],
        ["\xE9\xAE\xAC",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x8C"],
        ["\xF0\xA9\xB7\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x8E"],
        ["\xF0\xA9\xB8\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x8F"],
        ["\xE9\xAE\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x90"],
        ["\xE9\xAE\xB8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x91"],
        ["\xE9\xAE\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x92"],
        ["\xE9\xAF\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x93"],
        ["\xE9\xAF\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x94"],
        ["\xE9\xAF\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x95"],
        ["\xE9\xAF\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x96"],
        ["\xE9\xAF\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x97"],
        ["\xE9\xAF\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x98"],
        ["\xE9\xAF\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x99"],
        ["\xE9\xAF\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x9A"],
        ["\xE9\xAF\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x9B"],
        ["\xF0\xA9\xB8\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x9C"],
        ["\xE9\xAF\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x9D"],
        ["\xF0\xA9\xBA\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x9E"],
        ["\xE9\xAF\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x9F"],
        ["\xF0\xA9\xB9\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xA0"],
        ["\xE9\xB0\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xA1"],
        ["\xE9\xB0\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xA2"],
        ["\xE9\xB0\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xA3"],
        ["\xE9\xB0\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xA4"],
        ["\xE9\xB0\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xA5"],
        ["\xE9\xB0\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xA6"],
        ["\xE9\xB0\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xA7"],
        ["\xE9\xB0\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xA8"],
        ["\xE9\xB0\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xA9"],
        ["\xF0\xA9\xBB\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xAA"],
        ["\xE9\xB0\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xAB"],
        ["\xE9\xB0\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xAC"],
        ["\xE9\xB0\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xAD"],
        ["\xE9\xB1\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xAE"],
        ["\xE9\xB1\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xAF"],
        ["\xF0\xA9\xBB\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xB0"],
        ["\xE9\xB1\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xB1"],
        ["\xE9\xB1\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xB2"],
        ["\xF0\xA9\xBB\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xB3"],
        ["\xE9\xB1\x94",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xB4"],
        ["\xE9\xB1\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xB5"],
        ["\xE9\xB1\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xB6"],
        ["\xE9\xB1\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xB7"],
        ["\xE9\xB1\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xB8"],
        ["\xE9\xB1\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xB9"],
        ["\xE9\xB1\xAA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xBA"],
        ["\xE9\xB1\xAB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xBB"],
        ["\xE9\xB1\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xBC"],
        ["\xE9\xB1\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xBD"],
        ["\xE9\xB1\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xBE"],
        ["\xE9\xB1\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xBF"],
        ["\xE9\xB1\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x80"],
        ["\xE9\xB1\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x81"],
        ["\xE9\xB3\xA6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x82"],
        ["\xE9\xB3\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x83"],
        ["\xE9\xB4\x8B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x84"],
        ["\xE9\xB4\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x85"],
        ["\xF0\xA9\xBF\x8E",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x86"],
        ["\xE9\xB4\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x87"],
        ["\xE9\xB4\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x88"],
        ["\xE9\xB4\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x89"],
        ["\xF0\xAA\x80\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x8A"],
        ["\xE4\xB3\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x8B"],
        ["\xF0\xAA\x80\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x8C"],
        ["\xE9\xB4\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x8D"],
        ["\xE4\xB3\x91",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x8E"],
        ["\xE9\xB5\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x8F"],
        ["\xE9\xB5\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x90"],
        ["\xE9\xB5\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x91"],
        ["\xE9\xB5\xA2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x92"],
        ["\xF0\xAA\x83\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x93"],
        ["\xE9\xB5\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x94"],
        ["\xF0\xAA\x82\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x96"],
        ["\xE9\xB5\xB3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x97"],
        ["\xE9\xB5\xB6",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x98"],
        ["\xE9\xB5\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x99"],
        ["\xE9\xB5\xBE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x9A"],
        ["\xE9\xB6\x84",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x9B"],
        ["\xE9\xB6\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x9C"],
        ["\xE9\xB6\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x9D"],
        ["\xE9\xB6\xA1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x9E"],
        ["\xE9\xB6\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x9F"],
        ["\xE9\xB6\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xA0"],
        ["\xE9\xB6\xB9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xA1"],
        ["\xE9\xB6\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xA2"],
        ["\xE9\xB7\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xA3"],
        ["\xE9\xB7\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xA4"],
        ["\xE9\xB7\x89",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xA5"],
        ["\xE9\xB7\x96",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xA6"],
        ["\xE9\xB7\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xA7"],
        ["\xE9\xB7\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xA8"],
        ["\xE9\xB7\xA0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xA9"],
        ["\xE9\xB7\xA3",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xAA"],
        ["\xE9\xB7\xB4",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xAB"],
        ["\xE4\xB4\x87",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xAC"],
        ["\xE9\xB8\x8A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xAD"],
        ["\xE9\xB8\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xAE"],
        ["\xE9\xB8\x8D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xAF"],
        ["\xE9\xB8\x9C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xB1"],
        ["\xE9\xB8\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xB2"],
        ["\xE9\xB9\xBB",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xB3"],
        ["\xF0\xA2\x88\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xB4"],
        ["\xE9\xBA\x80",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xB5"],
        ["\xE9\xBA\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xB6"],
        ["\xE9\xBA\x9B",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xB7"],
        ["\xE9\xBA\xA8",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xB8"],
        ["\xF0\xAA\x8E\x8C",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xB9"],
        ["\xE9\xBA\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xBA"],
        ["\xF0\xAA\x90\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xBB"],
        ["\xE9\xBB\x9F",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xBC"],
        ["\xE9\xBB\xA7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xBD"],
        ["\xE9\xBB\xAE",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xBE"],
        ["\xE9\xBB\xBF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xBF"],
        ["\xE9\xBC\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x80"],
        ["\xE4\xB5\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x81"],
        ["\xE9\xBC\x83",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x82"],
        ["\xE9\xBC\x97",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x83"],
        ["\xE9\xBC\x99",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x84"],
        ["\xE9\xBC\xAF",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x85"],
        ["\xE9\xBC\xB7",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x86"],
        ["\xE9\xBC\xBA",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x87"],
        ["\xE9\xBC\xBD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x88"],
        ["\xE9\xBD\x81",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x89"],
        ["\xE9\xBD\x85",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x8A"],
        ["\xE9\xBD\x86",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x8B"],
        ["\xE9\xBD\x93",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x8C"],
        ["\xE9\xBD\x95",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x8D"],
        ["\xE9\xBD\x98",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x8E"],
        ["\xF0\xAA\x97\xB1",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x8F"],
        ["\xE9\xBD\x9D",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x90"],
        ["\xF0\xAA\x98\x82",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x91"],
        ["\xE9\xBD\xA9",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x92"],
        ["\xF0\xAA\x98\x9A",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x93"],
        ["\xE9\xBD\xAD",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x94"],
        ["\xE9\xBD\xB0",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x95"],
        ["\xE9\xBD\xB5",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x96"],
        ["\xF0\xAA\x9A\xB2",'utf8jp','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x97"],
    );
    $|=1; print "1..",scalar(@test),"\n"; my $testno=1; sub ok { print $_[0]?'ok ':'not ok ',$testno++,$_[1]?" - $_[1]\n":"\n" }
}

use Jacode4e;

for my $test (@test) {
    my($give,$OUTPUT_encoding,$INPUT_encoding,$option,$want) = @{$test};
    my $got = $give;
    my $return = Jacode4e::convert(\$got,$OUTPUT_encoding,$INPUT_encoding,$option);

    my $option_content = '';
    if (defined $option) {
        $option_content .= qq{INPUT_LAYOUT=>$option->{'INPUT_LAYOUT'}}        if exists $option->{'INPUT_LAYOUT'};
        $option_content .= qq{OUTPUT_SHIFTING=>$option->{'OUTPUT_SHIFTING'}}  if exists $option->{'OUTPUT_SHIFTING'};
        $option_content .= qq{SPACE=>@{[uc unpack('H*',$option->{'SPACE'})]}} if exists $option->{'SPACE'};
        $option_content .= qq{GETA=>@{[uc unpack('H*',$option->{'GETA'})]}}   if exists $option->{'GETA'};
        $option_content = "{$option_content}";
    }

    ok(($return > 0) and ($got eq $want),
        sprintf(qq{$INPUT_encoding(%s) to $OUTPUT_encoding(%s), $option_content => return=$return,got=(%s)},
            uc unpack('H*',$give),
            uc unpack('H*',$want),
            uc unpack('H*',$got),
        )
    );
}

__END__
