/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.sql.SQLException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.apache.derby.iapi.db.Database;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.jdbc.InternalDriver;

abstract class ConnectionChild {
    protected static final boolean CLOSE = true;
    protected static final boolean NOCLOSE = false;
    protected EmbedConnection localConn;
    protected final InternalDriver factory;
    private Calendar cal;

    protected ConnectionChild(EmbedConnection embedConnection) {
        this.localConn = embedConnection;
        this.factory = embedConnection.getLocalDriver();
    }

    protected final EmbedConnection getEmbedConnection() {
        return this.localConn;
    }

    protected final Object getConnectionSynchronization() {
        return this.localConn.getConnectionSynchronization();
    }

    protected final SQLException handleException(Throwable throwable) throws SQLException {
        return this.localConn.handleException(throwable);
    }

    protected final SQLException handleException(Throwable throwable, boolean bl) throws SQLException {
        return this.localConn.handleException(throwable, bl);
    }

    protected final void needCommit() {
        this.localConn.needCommit();
    }

    protected final void commitIfNeeded() throws SQLException {
        this.localConn.commitIfNeeded();
    }

    protected final void commitIfAutoCommit() throws SQLException {
        this.localConn.commitIfAutoCommit();
    }

    protected final void setupContextStack() throws SQLException {
        this.localConn.setupContextStack();
    }

    protected final void restoreContextStack() throws SQLException {
        this.localConn.restoreContextStack();
    }

    public ContextManager getContextManager() {
        return this.localConn.getContextManager();
    }

    public Database getDatabase() {
        return this.localConn.getDatabase();
    }

    protected Calendar getCal() {
        if (this.cal == null) {
            this.cal = new GregorianCalendar();
        }
        return this.cal;
    }

    protected SQLException newSQLException(String string) {
        return this.localConn.newSQLException(string);
    }

    protected SQLException newSQLException(String string, Object object) {
        return this.localConn.newSQLException(string, object);
    }

    protected SQLException newSQLException(String string, Object object, Object object2) {
        return this.localConn.newSQLException(string, object, object2);
    }
}

