/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class ArrayUtil {
    public static void writeArrayLength(ObjectOutput objectOutput, Object[] objectArray) throws IOException {
        objectOutput.writeInt(objectArray.length);
    }

    public static void writeArrayItems(ObjectOutput objectOutput, Object[] objectArray) throws IOException {
        if (objectArray == null) {
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            objectOutput.writeObject(objectArray[i]);
        }
    }

    public static void writeArray(ObjectOutput objectOutput, Object[] objectArray) throws IOException {
        if (objectArray == null) {
            objectOutput.writeInt(0);
            return;
        }
        objectOutput.writeInt(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            objectOutput.writeObject(objectArray[i]);
        }
    }

    public static void readArrayItems(ObjectInput objectInput, Object[] objectArray) throws IOException, ClassNotFoundException {
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = objectInput.readObject();
        }
    }

    public static int readArrayLength(ObjectInput objectInput) throws IOException {
        return objectInput.readInt();
    }

    public static Object[] readObjectArray(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        if (n == 0) {
            return null;
        }
        Object[] objectArray = new Object[n];
        ArrayUtil.readArrayItems(objectInput, objectArray);
        return objectArray;
    }

    public static void writeIntArray(ObjectOutput objectOutput, int[] nArray) throws IOException {
        if (nArray == null) {
            objectOutput.writeInt(0);
        } else {
            objectOutput.writeInt(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                objectOutput.writeInt(nArray[i]);
            }
        }
    }

    public static int[] readIntArray(ObjectInput objectInput) throws IOException {
        int n = objectInput.readInt();
        if (n == 0) {
            return null;
        }
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = objectInput.readInt();
        }
        return nArray;
    }

    public static void writeInts(ObjectOutput objectOutput, int[][] nArray) throws IOException {
        if (nArray == null) {
            objectOutput.writeBoolean(false);
        } else {
            objectOutput.writeBoolean(true);
            int n = nArray.length;
            objectOutput.writeInt(n);
            for (int i = 0; i < n; ++i) {
                ArrayUtil.writeIntArray(objectOutput, nArray[i]);
            }
        }
    }

    public static int[][] readInts(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Object object = null;
        if (objectInput.readBoolean()) {
            int n = objectInput.readInt();
            object = new int[n][];
            for (int i = 0; i < n; ++i) {
                object[i] = ArrayUtil.readIntArray(objectInput);
            }
        }
        return object;
    }

    public static void writeLongArray(ObjectOutput objectOutput, long[] lArray) throws IOException {
        if (lArray == null) {
            objectOutput.writeInt(0);
        } else {
            objectOutput.writeInt(lArray.length);
            for (int i = 0; i < lArray.length; ++i) {
                objectOutput.writeLong(lArray[i]);
            }
        }
    }

    public static long[] readLongArray(ObjectInput objectInput) throws IOException {
        int n = objectInput.readInt();
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = objectInput.readLong();
        }
        return lArray;
    }

    public static String[] readStringArray(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Object[] objectArray = ArrayUtil.readObjectArray(objectInput);
        int n = 0;
        if (objectArray == null) {
            return null;
        }
        n = objectArray.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)objectArray[i];
        }
        return stringArray;
    }

    public static void writeBooleanArray(ObjectOutput objectOutput, boolean[] blArray) throws IOException {
        if (blArray == null) {
            objectOutput.writeInt(0);
        } else {
            objectOutput.writeInt(blArray.length);
            for (int i = 0; i < blArray.length; ++i) {
                objectOutput.writeBoolean(blArray[i]);
            }
        }
    }

    public static boolean[] readBooleanArray(ObjectInput objectInput) throws IOException {
        int n = objectInput.readInt();
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            blArray[i] = objectInput.readBoolean();
        }
        return blArray;
    }
}

