#------------------------------------------------------------------------------
# $Id: Parser.pm,v 1.20 2010/10/02 19:42:00 Paulo Exp $
# Parser 'CPU::Z80::Assembler::Parser' generated by ParserGenerator.pm

package CPU::Z80::Assembler::Parser;

use strict;
use warnings;

use Data::Dump 'dump';
use Asm::Preproc::Stream;
use Asm::Preproc::Token;
use Carp;

use constant {
	ARGS => 0, PROG => 1, INPUT => 2,		# to decode args in parser functions
};


our $VERSION = "2.12";

use CPU::Z80::Assembler::Expr;
use CPU::Z80::Assembler::Opcode;
use CPU::Z80::Assembler::JumpOpcode;
use Asm::Preproc::Token;

use base "Exporter";
our @EXPORT = qw( z80parser );

#------------------------------------------------------------------------------

=head1 NAME

CPU::Z80::Assembler::Parser - Parser for the Z80 assembler

=head1 SYNOPSIS

  use CPU::Z80::Assembler::Parser;
  z80parser($input, $program);

=head1 DESCRIPTION

This module converts an input stream of tokens returned by the
L<CPU::Z80::Assembler::Lexer|CPU::Z80::Assembler::Lexer> to a binary object code that is returned in the
passed L<CPU::Z80::Assembler::Program|CPU::Z80::Assembler::Program> object.

=head1 EXPORTS

By default the z80parser subroutines is exported.

=head1 FUNCTIONS

=head2 z80parser

This function is just a wrapper around the parse function.
It takes as parameter a stream of assembly tokens as returned by the 
lexer and a L<CPU::Z80::Assembler::Program|CPU::Z80::Assembler::Program> object to collect the 
object code.

The assembly program is parsed and loaded into L<CPU::Z80::Assembler::Program|CPU::Z80::Assembler::Program>.

=cut

#------------------------------------------------------------------------------



#------------------------------------------------------------------------------
# Parsing state machine
# Each state hash has:
# 	terminal => (state ID), for a shift
# 	terminal => [ (subrule ID), (next state ID) ], for a sub-rule followed by a shift
# 	terminal => [ (subrule ID), sub{} ], for a sub-rule followed by an accept
# 	terminal => sub{}, for an accept
# Each sub{} is called with $sub->($args, $user); 
# $args is [] of all parsed elements
# $user is the user pointer passed to parse()
our $start_state = 7016;
our @state_table = (
	# [0] 
	{ binop => 1, cont_expr_N => 2, def_label => 4, end => 7, expr => 8, expr2 => 10, expr_DIS => 12, expr_N => 13, expr_NDIS => 14, expr_NN => 15, expr_const => 16, expr_list => 17, expr_list_N => 19, expr_list_NN => 20, expr_list_text => 21, expr_text => 23, expr_text2 => 26, expr_text_number => 28, expr_text_string => 29, inline_const => 30, macro => 31, macro_arg => 35, macro_arg2 => 36, macro_args => 38, macro_args_optional => 40, macro_body => 41, opcode => 42, program => 7016, term => 7018, term2 => 7022, unop => 7024, },
	# [1] binop : 
	{ "!=" => \&_action_unop_1, "%" => \&_action_unop_1, "&" => \&_action_unop_1, "&&" => \&_action_unop_1, "*" => \&_action_unop_1, "+" => \&_action_unop_1, "-" => \&_action_unop_1, "/" => \&_action_unop_1, "<" => \&_action_unop_1, "<<" => \&_action_unop_1, "<=" => \&_action_unop_1, "==" => \&_action_unop_1, ">" => \&_action_unop_1, ">=" => \&_action_unop_1, ">>" => \&_action_unop_1, "^" => \&_action_unop_1, "|" => \&_action_unop_1, "||" => \&_action_unop_1, },
	# [2] cont_expr_N : 
	{ "!=" => [ 1, 3 ], "%" => [ 1, 3 ], "&" => [ 1, 3 ], "&&" => [ 1, 3 ], "*" => [ 1, 3 ], "+" => [ 1, 3 ], "-" => [ 1, 3 ], "/" => [ 1, 3 ], "<" => [ 1, 3 ], "<<" => [ 1, 3 ], "<=" => [ 1, 3 ], "==" => [ 1, 3 ], ">" => [ 1, 3 ], ">=" => [ 1, 3 ], ">>" => [ 1, 3 ], "^" => [ 1, 3 ], "|" => [ 1, 3 ], "||" => [ 1, 3 ], },
	# [3] cont_expr_N : "[binop]"
	{ "!" => [ 13, \&_action_term_2 ], "+" => [ 13, \&_action_term_2 ], "-" => [ 13, \&_action_term_2 ], __else__ => [ 13, \&_action_term_2 ], "~" => [ 13, \&_action_term_2 ], },
	# [4] def_label : 
	{ "=" => 5, },
	# [5] def_label : "="
	{ "!" => [ 15, 6 ], "+" => [ 15, 6 ], "-" => [ 15, 6 ], __else__ => [ 15, 6 ], "~" => [ 15, 6 ], },
	# [6] def_label : "=" "[expr_NN]"
	{ "\n" => [ 7, \&_action_expr2_6 ], ":" => [ 7, \&_action_expr2_6 ], },
	# [7] end : 
	{ "\n" => \&_action_end_0, ":" => \&_action_end_0, },
	# [8] expr : 
	{ "!" => [ 7018, 9 ], "+" => [ 7018, 9 ], "-" => [ 7018, 9 ], __else__ => [ 7018, 9 ], "~" => [ 7018, 9 ], },
	# [9] expr : "[term]"
	{ "!=" => [ 7022, 9 ], "%" => [ 7022, 9 ], "&" => [ 7022, 9 ], "&&" => [ 7022, 9 ], "*" => [ 7022, 9 ], "+" => [ 7022, 9 ], "-" => [ 7022, 9 ], "/" => [ 7022, 9 ], "<" => [ 7022, 9 ], "<<" => [ 7022, 9 ], "<=" => [ 7022, 9 ], "==" => [ 7022, 9 ], ">" => [ 7022, 9 ], ">=" => [ 7022, 9 ], ">>" => [ 7022, 9 ], "^" => [ 7022, 9 ], __else__ => \&_action_expr_5, "|" => [ 7022, 9 ], "||" => [ 7022, 9 ], },
	# [10] expr2 : 
	{ "," => 11, },
	# [11] expr2 : ","
	{ "!" => [ 8, \&_action_expr2_6 ], "+" => [ 8, \&_action_expr2_6 ], "-" => [ 8, \&_action_expr2_6 ], __else__ => [ 8, \&_action_expr2_6 ], "~" => [ 8, \&_action_expr2_6 ], },
	# [12] expr_DIS : 
	{ "!" => [ 8, \&_action_expr_DIS_7 ], "+" => [ 8, \&_action_expr_DIS_7 ], "-" => [ 8, \&_action_expr_DIS_7 ], __else__ => [ 8, \&_action_expr_DIS_7 ], "~" => [ 8, \&_action_expr_DIS_7 ], },
	# [13] expr_N : 
	{ "!" => [ 8, \&_action_expr_N_9 ], "+" => [ 8, \&_action_expr_N_9 ], "-" => [ 8, \&_action_expr_N_9 ], __else__ => [ 8, \&_action_expr_N_9 ], "~" => [ 8, \&_action_expr_N_9 ], },
	# [14] expr_NDIS : 
	{ "!" => [ 12, \&_action_expr_NDIS_8 ], "+" => [ 12, \&_action_expr_NDIS_8 ], "-" => [ 12, \&_action_expr_NDIS_8 ], __else__ => [ 12, \&_action_expr_NDIS_8 ], "~" => [ 12, \&_action_expr_NDIS_8 ], },
	# [15] expr_NN : 
	{ "!" => [ 8, \&_action_expr_NN_11 ], "+" => [ 8, \&_action_expr_NN_11 ], "-" => [ 8, \&_action_expr_NN_11 ], __else__ => [ 8, \&_action_expr_NN_11 ], "~" => [ 8, \&_action_expr_NN_11 ], },
	# [16] expr_const : 
	{ "!" => [ 8, \&_action_expr_const_13 ], "+" => [ 8, \&_action_expr_const_13 ], "-" => [ 8, \&_action_expr_const_13 ], __else__ => [ 8, \&_action_expr_const_13 ], "~" => [ 8, \&_action_expr_const_13 ], },
	# [17] expr_list : 
	{ "!" => [ 8, 18 ], "+" => [ 8, 18 ], "-" => [ 8, 18 ], __else__ => [ 8, 18 ], "~" => [ 8, 18 ], },
	# [18] expr_list : "[expr]"
	{ "," => [ 10, 18 ], __else__ => \&_action_term_2, },
	# [19] expr_list_N : 
	{ "!" => [ 17, \&_action_expr_list_N_10 ], "+" => [ 17, \&_action_expr_list_N_10 ], "-" => [ 17, \&_action_expr_list_N_10 ], __else__ => [ 17, \&_action_expr_list_N_10 ], "~" => [ 17, \&_action_expr_list_N_10 ], },
	# [20] expr_list_NN : 
	{ "!" => [ 17, \&_action_expr_list_NN_12 ], "+" => [ 17, \&_action_expr_list_NN_12 ], "-" => [ 17, \&_action_expr_list_NN_12 ], __else__ => [ 17, \&_action_expr_list_NN_12 ], "~" => [ 17, \&_action_expr_list_NN_12 ], },
	# [21] expr_list_text : 
	{ NUMBER => [ 23, 22 ], STRING => [ 23, 22 ], },
	# [22] expr_list_text : "[expr_text]"
	{ "," => [ 26, 22 ], __else__ => \&_action_expr_list_text_18, },
	# [23] expr_text : 
	{ NUMBER => [ 28, 24 ], STRING => [ 29, 25 ], },
	# [24] expr_text : "[expr_text_number]"
	{ "!=" => [ 2, \&_action_expr_text_17 ], "%" => [ 2, \&_action_expr_text_17 ], "&" => [ 2, \&_action_expr_text_17 ], "&&" => [ 2, \&_action_expr_text_17 ], "*" => [ 2, \&_action_expr_text_17 ], "+" => [ 2, \&_action_expr_text_17 ], "-" => [ 2, \&_action_expr_text_17 ], "/" => [ 2, \&_action_expr_text_17 ], "<" => [ 2, \&_action_expr_text_17 ], "<<" => [ 2, \&_action_expr_text_17 ], "<=" => [ 2, \&_action_expr_text_17 ], "==" => [ 2, \&_action_expr_text_17 ], ">" => [ 2, \&_action_expr_text_17 ], ">=" => [ 2, \&_action_expr_text_17 ], ">>" => [ 2, \&_action_expr_text_17 ], "^" => [ 2, \&_action_expr_text_17 ], __else__ => \&_action_expr_text_17, "|" => [ 2, \&_action_expr_text_17 ], "||" => [ 2, \&_action_expr_text_17 ], },
	# [25] expr_text : "[expr_text_string]"
	{ "!=" => [ 2, \&_action_expr_text_17 ], "%" => [ 2, \&_action_expr_text_17 ], "&" => [ 2, \&_action_expr_text_17 ], "&&" => [ 2, \&_action_expr_text_17 ], "*" => [ 2, \&_action_expr_text_17 ], "+" => [ 2, \&_action_expr_text_17 ], "-" => [ 2, \&_action_expr_text_17 ], "/" => [ 2, \&_action_expr_text_17 ], "<" => [ 2, \&_action_expr_text_17 ], "<<" => [ 2, \&_action_expr_text_17 ], "<=" => [ 2, \&_action_expr_text_17 ], "==" => [ 2, \&_action_expr_text_17 ], ">" => [ 2, \&_action_expr_text_17 ], ">=" => [ 2, \&_action_expr_text_17 ], ">>" => [ 2, \&_action_expr_text_17 ], "^" => [ 2, \&_action_expr_text_17 ], __else__ => \&_action_expr_text_17, "|" => [ 2, \&_action_expr_text_17 ], "||" => [ 2, \&_action_expr_text_17 ], },
	# [26] expr_text2 : 
	{ "," => 27, },
	# [27] expr_text2 : ","
	{ NUMBER => [ 23, \&_action_expr2_6 ], STRING => [ 23, \&_action_expr2_6 ], },
	# [28] expr_text_number : 
	{ NUMBER => \&_action_expr_text_number_16, },
	# [29] expr_text_string : 
	{ STRING => \&_action_expr_text_string_15, },
	# [30] inline_const : 
	{ "!" => [ 8, \&_action_inline_const_14 ], "+" => [ 8, \&_action_inline_const_14 ], "-" => [ 8, \&_action_inline_const_14 ], __else__ => [ 8, \&_action_inline_const_14 ], "~" => [ 8, \&_action_inline_const_14 ], },
	# [31] macro : 
	{ macro => 32, },
	# [32] macro : macro
	{ NAME => 33, },
	# [33] macro : macro NAME
	{ NAME => [ 40, 34 ], __else__ => [ 40, 34 ], },
	# [34] macro : macro NAME "[macro_args_optional]"
	{ "\n" => [ 41, \&_action_macro_27 ], ":" => [ 41, \&_action_macro_27 ], "{" => [ 41, \&_action_macro_27 ], },
	# [35] macro_arg : 
	{ NAME => \&_action_macro_arg_22, },
	# [36] macro_arg2 : 
	{ "," => 37, },
	# [37] macro_arg2 : ","
	{ NAME => \&_action_macro_arg2_23, },
	# [38] macro_args : 
	{ NAME => [ 35, 39 ], },
	# [39] macro_args : "[macro_arg]"
	{ "," => [ 36, 39 ], __else__ => \&_action_macro_args_24, },
	# [40] macro_args_optional : 
	{ NAME => [ 38, \&_action_macro_args_optional_25 ], __else__ => \&_action_macro_args_optional_25, },
	# [41] macro_body : 
	{ "\n" => \&_action_macro_body_26, ":" => \&_action_macro_body_26, "{" => \&_action_macro_body_26, },
	# [42] opcode : 
	{ "\n" => [ 7, \&_action_end_0 ], ":" => [ 7, \&_action_end_0 ], NAME => 43, adc => 45, add => 112, and => 191, bit => 250, call => 628, ccf => 654, cp => 655, cpd => 714, cpdr => 715, cpi => 716, cpir => 717, cpl => 718, daa => 719, db => 720, dec => 722, defb => 786, defm => 788, deft => 790, defw => 792, di => 794, djnz => 795, dw => 797, ei => 799, ex => 800, exa => 822, exx => 823, halt => 824, im => 825, in => 830, inc => 899, ind => 963, indr => 964, ini => 965, inir => 966, jp => 967, jr => 1010, ld => 1024, ldd => 1987, lddr => 2456, ldi => 2457, ldir => 3082, macro => [ 31, 44 ], neg => 3083, nop => 3084, or => 3085, org => 3144, otdr => 3145, otir => 3146, out => 3147, outd => 3182, outi => 3183, pop => 3184, push => 3191, res => 3198, ret => 4344, reti => 4353, retn => 4354, rl => 4355, rla => 4500, rlc => 4501, rlca => 4643, rld => 4644, rr => 4645, rra => 4790, rrc => 4791, rrca => 4933, rrd => 4934, rst => 4935, sbc => 4952, scf => 5019, set => 5020, sla => 6166, sli => 6311, sll => 6456, sra => 6601, srl => 6746, stop => 6891, sub => 6892, xor => 6957, },
	# [43] opcode : NAME
	{ "=" => [ 4, \&_action_opcode_21 ], __else__ => \&_action_opcode_21, },
	# [44] opcode : "[macro]"
	{ "\n" => [ 7, \&_action_end_0 ], ":" => [ 7, \&_action_end_0 ], },
	# [45] opcode : adc
	{ a => 46, hl => 106, },
	# [46] opcode : adc a
	{ "," => 47, },
	# [47] opcode : adc a ","
	{ "!" => [ 13, 86 ], "(" => 48, "+" => [ 13, 86 ], "-" => [ 13, 86 ], "[" => 67, __else__ => [ 13, 86 ], a => 87, b => 88, c => 89, d => 90, e => 91, h => 92, hx => 93, hy => 94, ixh => 95, ixl => 96, iyh => 97, iyl => 98, l => 99, lx => 100, ly => 101, xh => 102, xl => 103, yh => 104, yl => 105, "~" => [ 13, 86 ], },
	# [48] opcode : adc a "," "("
	{ hl => 49, ix => 51, iy => 59, },
	# [49] opcode : adc a "," "(" hl
	{ ")" => 50, },
	# [50] opcode : adc a "," "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_28 ], ":" => [ 7, \&_action_opcode_28 ], },
	# [51] opcode : adc a "," "(" ix
	{ ")" => 52, "+" => 53, "-" => 56, },
	# [52] opcode : adc a "," "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_29 ], ":" => [ 7, \&_action_opcode_29 ], },
	# [53] opcode : adc a "," "(" ix "+"
	{ "!" => [ 12, 54 ], "+" => [ 12, 54 ], "-" => [ 12, 54 ], __else__ => [ 12, 54 ], "~" => [ 12, 54 ], },
	# [54] opcode : adc a "," "(" ix "+" "[expr_DIS]"
	{ ")" => 55, },
	# [55] opcode : adc a "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_30 ], ":" => [ 7, \&_action_opcode_30 ], },
	# [56] opcode : adc a "," "(" ix "-"
	{ "!" => [ 14, 57 ], "+" => [ 14, 57 ], "-" => [ 14, 57 ], __else__ => [ 14, 57 ], "~" => [ 14, 57 ], },
	# [57] opcode : adc a "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 58, },
	# [58] opcode : adc a "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_30 ], ":" => [ 7, \&_action_opcode_30 ], },
	# [59] opcode : adc a "," "(" iy
	{ ")" => 60, "+" => 61, "-" => 64, },
	# [60] opcode : adc a "," "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_31 ], ":" => [ 7, \&_action_opcode_31 ], },
	# [61] opcode : adc a "," "(" iy "+"
	{ "!" => [ 12, 62 ], "+" => [ 12, 62 ], "-" => [ 12, 62 ], __else__ => [ 12, 62 ], "~" => [ 12, 62 ], },
	# [62] opcode : adc a "," "(" iy "+" "[expr_DIS]"
	{ ")" => 63, },
	# [63] opcode : adc a "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_32 ], ":" => [ 7, \&_action_opcode_32 ], },
	# [64] opcode : adc a "," "(" iy "-"
	{ "!" => [ 14, 65 ], "+" => [ 14, 65 ], "-" => [ 14, 65 ], __else__ => [ 14, 65 ], "~" => [ 14, 65 ], },
	# [65] opcode : adc a "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 66, },
	# [66] opcode : adc a "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_32 ], ":" => [ 7, \&_action_opcode_32 ], },
	# [67] opcode : adc a "," "["
	{ hl => 68, ix => 70, iy => 78, },
	# [68] opcode : adc a "," "[" hl
	{ "]" => 69, },
	# [69] opcode : adc a "," "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_28 ], ":" => [ 7, \&_action_opcode_28 ], },
	# [70] opcode : adc a "," "[" ix
	{ "+" => 71, "-" => 74, "]" => 77, },
	# [71] opcode : adc a "," "[" ix "+"
	{ "!" => [ 12, 72 ], "+" => [ 12, 72 ], "-" => [ 12, 72 ], __else__ => [ 12, 72 ], "~" => [ 12, 72 ], },
	# [72] opcode : adc a "," "[" ix "+" "[expr_DIS]"
	{ "]" => 73, },
	# [73] opcode : adc a "," "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_30 ], ":" => [ 7, \&_action_opcode_30 ], },
	# [74] opcode : adc a "," "[" ix "-"
	{ "!" => [ 14, 75 ], "+" => [ 14, 75 ], "-" => [ 14, 75 ], __else__ => [ 14, 75 ], "~" => [ 14, 75 ], },
	# [75] opcode : adc a "," "[" ix "-" "[expr_NDIS]"
	{ "]" => 76, },
	# [76] opcode : adc a "," "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_30 ], ":" => [ 7, \&_action_opcode_30 ], },
	# [77] opcode : adc a "," "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_29 ], ":" => [ 7, \&_action_opcode_29 ], },
	# [78] opcode : adc a "," "[" iy
	{ "+" => 79, "-" => 82, "]" => 85, },
	# [79] opcode : adc a "," "[" iy "+"
	{ "!" => [ 12, 80 ], "+" => [ 12, 80 ], "-" => [ 12, 80 ], __else__ => [ 12, 80 ], "~" => [ 12, 80 ], },
	# [80] opcode : adc a "," "[" iy "+" "[expr_DIS]"
	{ "]" => 81, },
	# [81] opcode : adc a "," "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_32 ], ":" => [ 7, \&_action_opcode_32 ], },
	# [82] opcode : adc a "," "[" iy "-"
	{ "!" => [ 14, 83 ], "+" => [ 14, 83 ], "-" => [ 14, 83 ], __else__ => [ 14, 83 ], "~" => [ 14, 83 ], },
	# [83] opcode : adc a "," "[" iy "-" "[expr_NDIS]"
	{ "]" => 84, },
	# [84] opcode : adc a "," "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_32 ], ":" => [ 7, \&_action_opcode_32 ], },
	# [85] opcode : adc a "," "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_31 ], ":" => [ 7, \&_action_opcode_31 ], },
	# [86] opcode : adc a "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_33 ], ":" => [ 7, \&_action_opcode_33 ], },
	# [87] opcode : adc a "," a
	{ "\n" => [ 7, \&_action_opcode_34 ], ":" => [ 7, \&_action_opcode_34 ], },
	# [88] opcode : adc a "," b
	{ "\n" => [ 7, \&_action_opcode_35 ], ":" => [ 7, \&_action_opcode_35 ], },
	# [89] opcode : adc a "," c
	{ "\n" => [ 7, \&_action_opcode_36 ], ":" => [ 7, \&_action_opcode_36 ], },
	# [90] opcode : adc a "," d
	{ "\n" => [ 7, \&_action_opcode_37 ], ":" => [ 7, \&_action_opcode_37 ], },
	# [91] opcode : adc a "," e
	{ "\n" => [ 7, \&_action_opcode_38 ], ":" => [ 7, \&_action_opcode_38 ], },
	# [92] opcode : adc a "," h
	{ "\n" => [ 7, \&_action_opcode_39 ], ":" => [ 7, \&_action_opcode_39 ], },
	# [93] opcode : adc a "," hx
	{ "\n" => [ 7, \&_action_opcode_40 ], ":" => [ 7, \&_action_opcode_40 ], },
	# [94] opcode : adc a "," hy
	{ "\n" => [ 7, \&_action_opcode_41 ], ":" => [ 7, \&_action_opcode_41 ], },
	# [95] opcode : adc a "," ixh
	{ "\n" => [ 7, \&_action_opcode_40 ], ":" => [ 7, \&_action_opcode_40 ], },
	# [96] opcode : adc a "," ixl
	{ "\n" => [ 7, \&_action_opcode_42 ], ":" => [ 7, \&_action_opcode_42 ], },
	# [97] opcode : adc a "," iyh
	{ "\n" => [ 7, \&_action_opcode_41 ], ":" => [ 7, \&_action_opcode_41 ], },
	# [98] opcode : adc a "," iyl
	{ "\n" => [ 7, \&_action_opcode_43 ], ":" => [ 7, \&_action_opcode_43 ], },
	# [99] opcode : adc a "," l
	{ "\n" => [ 7, \&_action_opcode_44 ], ":" => [ 7, \&_action_opcode_44 ], },
	# [100] opcode : adc a "," lx
	{ "\n" => [ 7, \&_action_opcode_42 ], ":" => [ 7, \&_action_opcode_42 ], },
	# [101] opcode : adc a "," ly
	{ "\n" => [ 7, \&_action_opcode_43 ], ":" => [ 7, \&_action_opcode_43 ], },
	# [102] opcode : adc a "," xh
	{ "\n" => [ 7, \&_action_opcode_40 ], ":" => [ 7, \&_action_opcode_40 ], },
	# [103] opcode : adc a "," xl
	{ "\n" => [ 7, \&_action_opcode_42 ], ":" => [ 7, \&_action_opcode_42 ], },
	# [104] opcode : adc a "," yh
	{ "\n" => [ 7, \&_action_opcode_41 ], ":" => [ 7, \&_action_opcode_41 ], },
	# [105] opcode : adc a "," yl
	{ "\n" => [ 7, \&_action_opcode_43 ], ":" => [ 7, \&_action_opcode_43 ], },
	# [106] opcode : adc hl
	{ "," => 107, },
	# [107] opcode : adc hl ","
	{ bc => 108, de => 109, hl => 110, sp => 111, },
	# [108] opcode : adc hl "," bc
	{ "\n" => [ 7, \&_action_opcode_45 ], ":" => [ 7, \&_action_opcode_45 ], },
	# [109] opcode : adc hl "," de
	{ "\n" => [ 7, \&_action_opcode_46 ], ":" => [ 7, \&_action_opcode_46 ], },
	# [110] opcode : adc hl "," hl
	{ "\n" => [ 7, \&_action_opcode_47 ], ":" => [ 7, \&_action_opcode_47 ], },
	# [111] opcode : adc hl "," sp
	{ "\n" => [ 7, \&_action_opcode_48 ], ":" => [ 7, \&_action_opcode_48 ], },
	# [112] opcode : add
	{ a => 113, hl => 173, ix => 179, iy => 185, },
	# [113] opcode : add a
	{ "," => 114, },
	# [114] opcode : add a ","
	{ "!" => [ 13, 153 ], "(" => 115, "+" => [ 13, 153 ], "-" => [ 13, 153 ], "[" => 134, __else__ => [ 13, 153 ], a => 154, b => 155, c => 156, d => 157, e => 158, h => 159, hx => 160, hy => 161, ixh => 162, ixl => 163, iyh => 164, iyl => 165, l => 166, lx => 167, ly => 168, xh => 169, xl => 170, yh => 171, yl => 172, "~" => [ 13, 153 ], },
	# [115] opcode : add a "," "("
	{ hl => 116, ix => 118, iy => 126, },
	# [116] opcode : add a "," "(" hl
	{ ")" => 117, },
	# [117] opcode : add a "," "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_49 ], ":" => [ 7, \&_action_opcode_49 ], },
	# [118] opcode : add a "," "(" ix
	{ ")" => 119, "+" => 120, "-" => 123, },
	# [119] opcode : add a "," "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_50 ], ":" => [ 7, \&_action_opcode_50 ], },
	# [120] opcode : add a "," "(" ix "+"
	{ "!" => [ 12, 121 ], "+" => [ 12, 121 ], "-" => [ 12, 121 ], __else__ => [ 12, 121 ], "~" => [ 12, 121 ], },
	# [121] opcode : add a "," "(" ix "+" "[expr_DIS]"
	{ ")" => 122, },
	# [122] opcode : add a "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_51 ], ":" => [ 7, \&_action_opcode_51 ], },
	# [123] opcode : add a "," "(" ix "-"
	{ "!" => [ 14, 124 ], "+" => [ 14, 124 ], "-" => [ 14, 124 ], __else__ => [ 14, 124 ], "~" => [ 14, 124 ], },
	# [124] opcode : add a "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 125, },
	# [125] opcode : add a "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_51 ], ":" => [ 7, \&_action_opcode_51 ], },
	# [126] opcode : add a "," "(" iy
	{ ")" => 127, "+" => 128, "-" => 131, },
	# [127] opcode : add a "," "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_52 ], ":" => [ 7, \&_action_opcode_52 ], },
	# [128] opcode : add a "," "(" iy "+"
	{ "!" => [ 12, 129 ], "+" => [ 12, 129 ], "-" => [ 12, 129 ], __else__ => [ 12, 129 ], "~" => [ 12, 129 ], },
	# [129] opcode : add a "," "(" iy "+" "[expr_DIS]"
	{ ")" => 130, },
	# [130] opcode : add a "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_53 ], ":" => [ 7, \&_action_opcode_53 ], },
	# [131] opcode : add a "," "(" iy "-"
	{ "!" => [ 14, 132 ], "+" => [ 14, 132 ], "-" => [ 14, 132 ], __else__ => [ 14, 132 ], "~" => [ 14, 132 ], },
	# [132] opcode : add a "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 133, },
	# [133] opcode : add a "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_53 ], ":" => [ 7, \&_action_opcode_53 ], },
	# [134] opcode : add a "," "["
	{ hl => 135, ix => 137, iy => 145, },
	# [135] opcode : add a "," "[" hl
	{ "]" => 136, },
	# [136] opcode : add a "," "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_49 ], ":" => [ 7, \&_action_opcode_49 ], },
	# [137] opcode : add a "," "[" ix
	{ "+" => 138, "-" => 141, "]" => 144, },
	# [138] opcode : add a "," "[" ix "+"
	{ "!" => [ 12, 139 ], "+" => [ 12, 139 ], "-" => [ 12, 139 ], __else__ => [ 12, 139 ], "~" => [ 12, 139 ], },
	# [139] opcode : add a "," "[" ix "+" "[expr_DIS]"
	{ "]" => 140, },
	# [140] opcode : add a "," "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_51 ], ":" => [ 7, \&_action_opcode_51 ], },
	# [141] opcode : add a "," "[" ix "-"
	{ "!" => [ 14, 142 ], "+" => [ 14, 142 ], "-" => [ 14, 142 ], __else__ => [ 14, 142 ], "~" => [ 14, 142 ], },
	# [142] opcode : add a "," "[" ix "-" "[expr_NDIS]"
	{ "]" => 143, },
	# [143] opcode : add a "," "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_51 ], ":" => [ 7, \&_action_opcode_51 ], },
	# [144] opcode : add a "," "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_50 ], ":" => [ 7, \&_action_opcode_50 ], },
	# [145] opcode : add a "," "[" iy
	{ "+" => 146, "-" => 149, "]" => 152, },
	# [146] opcode : add a "," "[" iy "+"
	{ "!" => [ 12, 147 ], "+" => [ 12, 147 ], "-" => [ 12, 147 ], __else__ => [ 12, 147 ], "~" => [ 12, 147 ], },
	# [147] opcode : add a "," "[" iy "+" "[expr_DIS]"
	{ "]" => 148, },
	# [148] opcode : add a "," "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_53 ], ":" => [ 7, \&_action_opcode_53 ], },
	# [149] opcode : add a "," "[" iy "-"
	{ "!" => [ 14, 150 ], "+" => [ 14, 150 ], "-" => [ 14, 150 ], __else__ => [ 14, 150 ], "~" => [ 14, 150 ], },
	# [150] opcode : add a "," "[" iy "-" "[expr_NDIS]"
	{ "]" => 151, },
	# [151] opcode : add a "," "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_53 ], ":" => [ 7, \&_action_opcode_53 ], },
	# [152] opcode : add a "," "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_52 ], ":" => [ 7, \&_action_opcode_52 ], },
	# [153] opcode : add a "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_54 ], ":" => [ 7, \&_action_opcode_54 ], },
	# [154] opcode : add a "," a
	{ "\n" => [ 7, \&_action_opcode_55 ], ":" => [ 7, \&_action_opcode_55 ], },
	# [155] opcode : add a "," b
	{ "\n" => [ 7, \&_action_opcode_56 ], ":" => [ 7, \&_action_opcode_56 ], },
	# [156] opcode : add a "," c
	{ "\n" => [ 7, \&_action_opcode_57 ], ":" => [ 7, \&_action_opcode_57 ], },
	# [157] opcode : add a "," d
	{ "\n" => [ 7, \&_action_opcode_58 ], ":" => [ 7, \&_action_opcode_58 ], },
	# [158] opcode : add a "," e
	{ "\n" => [ 7, \&_action_opcode_59 ], ":" => [ 7, \&_action_opcode_59 ], },
	# [159] opcode : add a "," h
	{ "\n" => [ 7, \&_action_opcode_60 ], ":" => [ 7, \&_action_opcode_60 ], },
	# [160] opcode : add a "," hx
	{ "\n" => [ 7, \&_action_opcode_61 ], ":" => [ 7, \&_action_opcode_61 ], },
	# [161] opcode : add a "," hy
	{ "\n" => [ 7, \&_action_opcode_62 ], ":" => [ 7, \&_action_opcode_62 ], },
	# [162] opcode : add a "," ixh
	{ "\n" => [ 7, \&_action_opcode_61 ], ":" => [ 7, \&_action_opcode_61 ], },
	# [163] opcode : add a "," ixl
	{ "\n" => [ 7, \&_action_opcode_63 ], ":" => [ 7, \&_action_opcode_63 ], },
	# [164] opcode : add a "," iyh
	{ "\n" => [ 7, \&_action_opcode_62 ], ":" => [ 7, \&_action_opcode_62 ], },
	# [165] opcode : add a "," iyl
	{ "\n" => [ 7, \&_action_opcode_64 ], ":" => [ 7, \&_action_opcode_64 ], },
	# [166] opcode : add a "," l
	{ "\n" => [ 7, \&_action_opcode_65 ], ":" => [ 7, \&_action_opcode_65 ], },
	# [167] opcode : add a "," lx
	{ "\n" => [ 7, \&_action_opcode_63 ], ":" => [ 7, \&_action_opcode_63 ], },
	# [168] opcode : add a "," ly
	{ "\n" => [ 7, \&_action_opcode_64 ], ":" => [ 7, \&_action_opcode_64 ], },
	# [169] opcode : add a "," xh
	{ "\n" => [ 7, \&_action_opcode_61 ], ":" => [ 7, \&_action_opcode_61 ], },
	# [170] opcode : add a "," xl
	{ "\n" => [ 7, \&_action_opcode_63 ], ":" => [ 7, \&_action_opcode_63 ], },
	# [171] opcode : add a "," yh
	{ "\n" => [ 7, \&_action_opcode_62 ], ":" => [ 7, \&_action_opcode_62 ], },
	# [172] opcode : add a "," yl
	{ "\n" => [ 7, \&_action_opcode_64 ], ":" => [ 7, \&_action_opcode_64 ], },
	# [173] opcode : add hl
	{ "," => 174, },
	# [174] opcode : add hl ","
	{ bc => 175, de => 176, hl => 177, sp => 178, },
	# [175] opcode : add hl "," bc
	{ "\n" => [ 7, \&_action_opcode_66 ], ":" => [ 7, \&_action_opcode_66 ], },
	# [176] opcode : add hl "," de
	{ "\n" => [ 7, \&_action_opcode_67 ], ":" => [ 7, \&_action_opcode_67 ], },
	# [177] opcode : add hl "," hl
	{ "\n" => [ 7, \&_action_opcode_68 ], ":" => [ 7, \&_action_opcode_68 ], },
	# [178] opcode : add hl "," sp
	{ "\n" => [ 7, \&_action_opcode_69 ], ":" => [ 7, \&_action_opcode_69 ], },
	# [179] opcode : add ix
	{ "," => 180, },
	# [180] opcode : add ix ","
	{ bc => 181, de => 182, ix => 183, sp => 184, },
	# [181] opcode : add ix "," bc
	{ "\n" => [ 7, \&_action_opcode_70 ], ":" => [ 7, \&_action_opcode_70 ], },
	# [182] opcode : add ix "," de
	{ "\n" => [ 7, \&_action_opcode_71 ], ":" => [ 7, \&_action_opcode_71 ], },
	# [183] opcode : add ix "," ix
	{ "\n" => [ 7, \&_action_opcode_72 ], ":" => [ 7, \&_action_opcode_72 ], },
	# [184] opcode : add ix "," sp
	{ "\n" => [ 7, \&_action_opcode_73 ], ":" => [ 7, \&_action_opcode_73 ], },
	# [185] opcode : add iy
	{ "," => 186, },
	# [186] opcode : add iy ","
	{ bc => 187, de => 188, iy => 189, sp => 190, },
	# [187] opcode : add iy "," bc
	{ "\n" => [ 7, \&_action_opcode_74 ], ":" => [ 7, \&_action_opcode_74 ], },
	# [188] opcode : add iy "," de
	{ "\n" => [ 7, \&_action_opcode_75 ], ":" => [ 7, \&_action_opcode_75 ], },
	# [189] opcode : add iy "," iy
	{ "\n" => [ 7, \&_action_opcode_76 ], ":" => [ 7, \&_action_opcode_76 ], },
	# [190] opcode : add iy "," sp
	{ "\n" => [ 7, \&_action_opcode_77 ], ":" => [ 7, \&_action_opcode_77 ], },
	# [191] opcode : and
	{ "!" => [ 13, 230 ], "(" => 192, "+" => [ 13, 230 ], "-" => [ 13, 230 ], "[" => 211, __else__ => [ 13, 230 ], a => 231, b => 232, c => 233, d => 234, e => 235, h => 236, hx => 237, hy => 238, ixh => 239, ixl => 240, iyh => 241, iyl => 242, l => 243, lx => 244, ly => 245, xh => 246, xl => 247, yh => 248, yl => 249, "~" => [ 13, 230 ], },
	# [192] opcode : and "("
	{ hl => 193, ix => 195, iy => 203, },
	# [193] opcode : and "(" hl
	{ ")" => 194, },
	# [194] opcode : and "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_78 ], ":" => [ 7, \&_action_opcode_78 ], },
	# [195] opcode : and "(" ix
	{ ")" => 196, "+" => 197, "-" => 200, },
	# [196] opcode : and "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_79 ], ":" => [ 7, \&_action_opcode_79 ], },
	# [197] opcode : and "(" ix "+"
	{ "!" => [ 12, 198 ], "+" => [ 12, 198 ], "-" => [ 12, 198 ], __else__ => [ 12, 198 ], "~" => [ 12, 198 ], },
	# [198] opcode : and "(" ix "+" "[expr_DIS]"
	{ ")" => 199, },
	# [199] opcode : and "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_80 ], ":" => [ 7, \&_action_opcode_80 ], },
	# [200] opcode : and "(" ix "-"
	{ "!" => [ 14, 201 ], "+" => [ 14, 201 ], "-" => [ 14, 201 ], __else__ => [ 14, 201 ], "~" => [ 14, 201 ], },
	# [201] opcode : and "(" ix "-" "[expr_NDIS]"
	{ ")" => 202, },
	# [202] opcode : and "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_80 ], ":" => [ 7, \&_action_opcode_80 ], },
	# [203] opcode : and "(" iy
	{ ")" => 204, "+" => 205, "-" => 208, },
	# [204] opcode : and "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_81 ], ":" => [ 7, \&_action_opcode_81 ], },
	# [205] opcode : and "(" iy "+"
	{ "!" => [ 12, 206 ], "+" => [ 12, 206 ], "-" => [ 12, 206 ], __else__ => [ 12, 206 ], "~" => [ 12, 206 ], },
	# [206] opcode : and "(" iy "+" "[expr_DIS]"
	{ ")" => 207, },
	# [207] opcode : and "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_82 ], ":" => [ 7, \&_action_opcode_82 ], },
	# [208] opcode : and "(" iy "-"
	{ "!" => [ 14, 209 ], "+" => [ 14, 209 ], "-" => [ 14, 209 ], __else__ => [ 14, 209 ], "~" => [ 14, 209 ], },
	# [209] opcode : and "(" iy "-" "[expr_NDIS]"
	{ ")" => 210, },
	# [210] opcode : and "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_82 ], ":" => [ 7, \&_action_opcode_82 ], },
	# [211] opcode : and "["
	{ hl => 212, ix => 214, iy => 222, },
	# [212] opcode : and "[" hl
	{ "]" => 213, },
	# [213] opcode : and "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_78 ], ":" => [ 7, \&_action_opcode_78 ], },
	# [214] opcode : and "[" ix
	{ "+" => 215, "-" => 218, "]" => 221, },
	# [215] opcode : and "[" ix "+"
	{ "!" => [ 12, 216 ], "+" => [ 12, 216 ], "-" => [ 12, 216 ], __else__ => [ 12, 216 ], "~" => [ 12, 216 ], },
	# [216] opcode : and "[" ix "+" "[expr_DIS]"
	{ "]" => 217, },
	# [217] opcode : and "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_80 ], ":" => [ 7, \&_action_opcode_80 ], },
	# [218] opcode : and "[" ix "-"
	{ "!" => [ 14, 219 ], "+" => [ 14, 219 ], "-" => [ 14, 219 ], __else__ => [ 14, 219 ], "~" => [ 14, 219 ], },
	# [219] opcode : and "[" ix "-" "[expr_NDIS]"
	{ "]" => 220, },
	# [220] opcode : and "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_80 ], ":" => [ 7, \&_action_opcode_80 ], },
	# [221] opcode : and "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_79 ], ":" => [ 7, \&_action_opcode_79 ], },
	# [222] opcode : and "[" iy
	{ "+" => 223, "-" => 226, "]" => 229, },
	# [223] opcode : and "[" iy "+"
	{ "!" => [ 12, 224 ], "+" => [ 12, 224 ], "-" => [ 12, 224 ], __else__ => [ 12, 224 ], "~" => [ 12, 224 ], },
	# [224] opcode : and "[" iy "+" "[expr_DIS]"
	{ "]" => 225, },
	# [225] opcode : and "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_82 ], ":" => [ 7, \&_action_opcode_82 ], },
	# [226] opcode : and "[" iy "-"
	{ "!" => [ 14, 227 ], "+" => [ 14, 227 ], "-" => [ 14, 227 ], __else__ => [ 14, 227 ], "~" => [ 14, 227 ], },
	# [227] opcode : and "[" iy "-" "[expr_NDIS]"
	{ "]" => 228, },
	# [228] opcode : and "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_82 ], ":" => [ 7, \&_action_opcode_82 ], },
	# [229] opcode : and "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_81 ], ":" => [ 7, \&_action_opcode_81 ], },
	# [230] opcode : and "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_83 ], ":" => [ 7, \&_action_opcode_83 ], },
	# [231] opcode : and a
	{ "\n" => [ 7, \&_action_opcode_84 ], ":" => [ 7, \&_action_opcode_84 ], },
	# [232] opcode : and b
	{ "\n" => [ 7, \&_action_opcode_85 ], ":" => [ 7, \&_action_opcode_85 ], },
	# [233] opcode : and c
	{ "\n" => [ 7, \&_action_opcode_86 ], ":" => [ 7, \&_action_opcode_86 ], },
	# [234] opcode : and d
	{ "\n" => [ 7, \&_action_opcode_87 ], ":" => [ 7, \&_action_opcode_87 ], },
	# [235] opcode : and e
	{ "\n" => [ 7, \&_action_opcode_88 ], ":" => [ 7, \&_action_opcode_88 ], },
	# [236] opcode : and h
	{ "\n" => [ 7, \&_action_opcode_89 ], ":" => [ 7, \&_action_opcode_89 ], },
	# [237] opcode : and hx
	{ "\n" => [ 7, \&_action_opcode_90 ], ":" => [ 7, \&_action_opcode_90 ], },
	# [238] opcode : and hy
	{ "\n" => [ 7, \&_action_opcode_91 ], ":" => [ 7, \&_action_opcode_91 ], },
	# [239] opcode : and ixh
	{ "\n" => [ 7, \&_action_opcode_90 ], ":" => [ 7, \&_action_opcode_90 ], },
	# [240] opcode : and ixl
	{ "\n" => [ 7, \&_action_opcode_92 ], ":" => [ 7, \&_action_opcode_92 ], },
	# [241] opcode : and iyh
	{ "\n" => [ 7, \&_action_opcode_91 ], ":" => [ 7, \&_action_opcode_91 ], },
	# [242] opcode : and iyl
	{ "\n" => [ 7, \&_action_opcode_93 ], ":" => [ 7, \&_action_opcode_93 ], },
	# [243] opcode : and l
	{ "\n" => [ 7, \&_action_opcode_94 ], ":" => [ 7, \&_action_opcode_94 ], },
	# [244] opcode : and lx
	{ "\n" => [ 7, \&_action_opcode_92 ], ":" => [ 7, \&_action_opcode_92 ], },
	# [245] opcode : and ly
	{ "\n" => [ 7, \&_action_opcode_93 ], ":" => [ 7, \&_action_opcode_93 ], },
	# [246] opcode : and xh
	{ "\n" => [ 7, \&_action_opcode_90 ], ":" => [ 7, \&_action_opcode_90 ], },
	# [247] opcode : and xl
	{ "\n" => [ 7, \&_action_opcode_92 ], ":" => [ 7, \&_action_opcode_92 ], },
	# [248] opcode : and yh
	{ "\n" => [ 7, \&_action_opcode_91 ], ":" => [ 7, \&_action_opcode_91 ], },
	# [249] opcode : and yl
	{ "\n" => [ 7, \&_action_opcode_93 ], ":" => [ 7, \&_action_opcode_93 ], },
	# [250] opcode : bit
	{ "!" => [ 30, 251 ], "+" => [ 30, 251 ], "-" => [ 30, 251 ], __else__ => [ 30, 251 ], "~" => [ 30, 251 ], },
	# [251] opcode : bit "[inline_const]"
	{ 0 => 252, 1 => 299, 2 => 346, 3 => 393, 4 => 440, 5 => 487, 6 => 534, 7 => 581, },
	# [252] opcode : bit "[inline_const]" 0
	{ "," => 253, },
	# [253] opcode : bit "[inline_const]" 0 ","
	{ "(" => 254, "[" => 273, a => 292, b => 293, c => 294, d => 295, e => 296, h => 297, l => 298, },
	# [254] opcode : bit "[inline_const]" 0 "," "("
	{ hl => 255, ix => 257, iy => 265, },
	# [255] opcode : bit "[inline_const]" 0 "," "(" hl
	{ ")" => 256, },
	# [256] opcode : bit "[inline_const]" 0 "," "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_95 ], ":" => [ 7, \&_action_opcode_95 ], },
	# [257] opcode : bit "[inline_const]" 0 "," "(" ix
	{ ")" => 258, "+" => 259, "-" => 262, },
	# [258] opcode : bit "[inline_const]" 0 "," "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_96 ], ":" => [ 7, \&_action_opcode_96 ], },
	# [259] opcode : bit "[inline_const]" 0 "," "(" ix "+"
	{ "!" => [ 12, 260 ], "+" => [ 12, 260 ], "-" => [ 12, 260 ], __else__ => [ 12, 260 ], "~" => [ 12, 260 ], },
	# [260] opcode : bit "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]"
	{ ")" => 261, },
	# [261] opcode : bit "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_97 ], ":" => [ 7, \&_action_opcode_97 ], },
	# [262] opcode : bit "[inline_const]" 0 "," "(" ix "-"
	{ "!" => [ 14, 263 ], "+" => [ 14, 263 ], "-" => [ 14, 263 ], __else__ => [ 14, 263 ], "~" => [ 14, 263 ], },
	# [263] opcode : bit "[inline_const]" 0 "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 264, },
	# [264] opcode : bit "[inline_const]" 0 "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_97 ], ":" => [ 7, \&_action_opcode_97 ], },
	# [265] opcode : bit "[inline_const]" 0 "," "(" iy
	{ ")" => 266, "+" => 267, "-" => 270, },
	# [266] opcode : bit "[inline_const]" 0 "," "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_98 ], ":" => [ 7, \&_action_opcode_98 ], },
	# [267] opcode : bit "[inline_const]" 0 "," "(" iy "+"
	{ "!" => [ 12, 268 ], "+" => [ 12, 268 ], "-" => [ 12, 268 ], __else__ => [ 12, 268 ], "~" => [ 12, 268 ], },
	# [268] opcode : bit "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]"
	{ ")" => 269, },
	# [269] opcode : bit "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_99 ], ":" => [ 7, \&_action_opcode_99 ], },
	# [270] opcode : bit "[inline_const]" 0 "," "(" iy "-"
	{ "!" => [ 14, 271 ], "+" => [ 14, 271 ], "-" => [ 14, 271 ], __else__ => [ 14, 271 ], "~" => [ 14, 271 ], },
	# [271] opcode : bit "[inline_const]" 0 "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 272, },
	# [272] opcode : bit "[inline_const]" 0 "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_99 ], ":" => [ 7, \&_action_opcode_99 ], },
	# [273] opcode : bit "[inline_const]" 0 "," "["
	{ hl => 274, ix => 276, iy => 284, },
	# [274] opcode : bit "[inline_const]" 0 "," "[" hl
	{ "]" => 275, },
	# [275] opcode : bit "[inline_const]" 0 "," "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_95 ], ":" => [ 7, \&_action_opcode_95 ], },
	# [276] opcode : bit "[inline_const]" 0 "," "[" ix
	{ "+" => 277, "-" => 280, "]" => 283, },
	# [277] opcode : bit "[inline_const]" 0 "," "[" ix "+"
	{ "!" => [ 12, 278 ], "+" => [ 12, 278 ], "-" => [ 12, 278 ], __else__ => [ 12, 278 ], "~" => [ 12, 278 ], },
	# [278] opcode : bit "[inline_const]" 0 "," "[" ix "+" "[expr_DIS]"
	{ "]" => 279, },
	# [279] opcode : bit "[inline_const]" 0 "," "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_97 ], ":" => [ 7, \&_action_opcode_97 ], },
	# [280] opcode : bit "[inline_const]" 0 "," "[" ix "-"
	{ "!" => [ 14, 281 ], "+" => [ 14, 281 ], "-" => [ 14, 281 ], __else__ => [ 14, 281 ], "~" => [ 14, 281 ], },
	# [281] opcode : bit "[inline_const]" 0 "," "[" ix "-" "[expr_NDIS]"
	{ "]" => 282, },
	# [282] opcode : bit "[inline_const]" 0 "," "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_97 ], ":" => [ 7, \&_action_opcode_97 ], },
	# [283] opcode : bit "[inline_const]" 0 "," "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_96 ], ":" => [ 7, \&_action_opcode_96 ], },
	# [284] opcode : bit "[inline_const]" 0 "," "[" iy
	{ "+" => 285, "-" => 288, "]" => 291, },
	# [285] opcode : bit "[inline_const]" 0 "," "[" iy "+"
	{ "!" => [ 12, 286 ], "+" => [ 12, 286 ], "-" => [ 12, 286 ], __else__ => [ 12, 286 ], "~" => [ 12, 286 ], },
	# [286] opcode : bit "[inline_const]" 0 "," "[" iy "+" "[expr_DIS]"
	{ "]" => 287, },
	# [287] opcode : bit "[inline_const]" 0 "," "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_99 ], ":" => [ 7, \&_action_opcode_99 ], },
	# [288] opcode : bit "[inline_const]" 0 "," "[" iy "-"
	{ "!" => [ 14, 289 ], "+" => [ 14, 289 ], "-" => [ 14, 289 ], __else__ => [ 14, 289 ], "~" => [ 14, 289 ], },
	# [289] opcode : bit "[inline_const]" 0 "," "[" iy "-" "[expr_NDIS]"
	{ "]" => 290, },
	# [290] opcode : bit "[inline_const]" 0 "," "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_99 ], ":" => [ 7, \&_action_opcode_99 ], },
	# [291] opcode : bit "[inline_const]" 0 "," "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_98 ], ":" => [ 7, \&_action_opcode_98 ], },
	# [292] opcode : bit "[inline_const]" 0 "," a
	{ "\n" => [ 7, \&_action_opcode_100 ], ":" => [ 7, \&_action_opcode_100 ], },
	# [293] opcode : bit "[inline_const]" 0 "," b
	{ "\n" => [ 7, \&_action_opcode_101 ], ":" => [ 7, \&_action_opcode_101 ], },
	# [294] opcode : bit "[inline_const]" 0 "," c
	{ "\n" => [ 7, \&_action_opcode_102 ], ":" => [ 7, \&_action_opcode_102 ], },
	# [295] opcode : bit "[inline_const]" 0 "," d
	{ "\n" => [ 7, \&_action_opcode_103 ], ":" => [ 7, \&_action_opcode_103 ], },
	# [296] opcode : bit "[inline_const]" 0 "," e
	{ "\n" => [ 7, \&_action_opcode_104 ], ":" => [ 7, \&_action_opcode_104 ], },
	# [297] opcode : bit "[inline_const]" 0 "," h
	{ "\n" => [ 7, \&_action_opcode_105 ], ":" => [ 7, \&_action_opcode_105 ], },
	# [298] opcode : bit "[inline_const]" 0 "," l
	{ "\n" => [ 7, \&_action_opcode_106 ], ":" => [ 7, \&_action_opcode_106 ], },
	# [299] opcode : bit "[inline_const]" 1
	{ "," => 300, },
	# [300] opcode : bit "[inline_const]" 1 ","
	{ "(" => 301, "[" => 320, a => 339, b => 340, c => 341, d => 342, e => 343, h => 344, l => 345, },
	# [301] opcode : bit "[inline_const]" 1 "," "("
	{ hl => 302, ix => 304, iy => 312, },
	# [302] opcode : bit "[inline_const]" 1 "," "(" hl
	{ ")" => 303, },
	# [303] opcode : bit "[inline_const]" 1 "," "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_107 ], ":" => [ 7, \&_action_opcode_107 ], },
	# [304] opcode : bit "[inline_const]" 1 "," "(" ix
	{ ")" => 305, "+" => 306, "-" => 309, },
	# [305] opcode : bit "[inline_const]" 1 "," "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_108 ], ":" => [ 7, \&_action_opcode_108 ], },
	# [306] opcode : bit "[inline_const]" 1 "," "(" ix "+"
	{ "!" => [ 12, 307 ], "+" => [ 12, 307 ], "-" => [ 12, 307 ], __else__ => [ 12, 307 ], "~" => [ 12, 307 ], },
	# [307] opcode : bit "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]"
	{ ")" => 308, },
	# [308] opcode : bit "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_109 ], ":" => [ 7, \&_action_opcode_109 ], },
	# [309] opcode : bit "[inline_const]" 1 "," "(" ix "-"
	{ "!" => [ 14, 310 ], "+" => [ 14, 310 ], "-" => [ 14, 310 ], __else__ => [ 14, 310 ], "~" => [ 14, 310 ], },
	# [310] opcode : bit "[inline_const]" 1 "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 311, },
	# [311] opcode : bit "[inline_const]" 1 "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_109 ], ":" => [ 7, \&_action_opcode_109 ], },
	# [312] opcode : bit "[inline_const]" 1 "," "(" iy
	{ ")" => 313, "+" => 314, "-" => 317, },
	# [313] opcode : bit "[inline_const]" 1 "," "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_110 ], ":" => [ 7, \&_action_opcode_110 ], },
	# [314] opcode : bit "[inline_const]" 1 "," "(" iy "+"
	{ "!" => [ 12, 315 ], "+" => [ 12, 315 ], "-" => [ 12, 315 ], __else__ => [ 12, 315 ], "~" => [ 12, 315 ], },
	# [315] opcode : bit "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]"
	{ ")" => 316, },
	# [316] opcode : bit "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_111 ], ":" => [ 7, \&_action_opcode_111 ], },
	# [317] opcode : bit "[inline_const]" 1 "," "(" iy "-"
	{ "!" => [ 14, 318 ], "+" => [ 14, 318 ], "-" => [ 14, 318 ], __else__ => [ 14, 318 ], "~" => [ 14, 318 ], },
	# [318] opcode : bit "[inline_const]" 1 "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 319, },
	# [319] opcode : bit "[inline_const]" 1 "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_111 ], ":" => [ 7, \&_action_opcode_111 ], },
	# [320] opcode : bit "[inline_const]" 1 "," "["
	{ hl => 321, ix => 323, iy => 331, },
	# [321] opcode : bit "[inline_const]" 1 "," "[" hl
	{ "]" => 322, },
	# [322] opcode : bit "[inline_const]" 1 "," "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_107 ], ":" => [ 7, \&_action_opcode_107 ], },
	# [323] opcode : bit "[inline_const]" 1 "," "[" ix
	{ "+" => 324, "-" => 327, "]" => 330, },
	# [324] opcode : bit "[inline_const]" 1 "," "[" ix "+"
	{ "!" => [ 12, 325 ], "+" => [ 12, 325 ], "-" => [ 12, 325 ], __else__ => [ 12, 325 ], "~" => [ 12, 325 ], },
	# [325] opcode : bit "[inline_const]" 1 "," "[" ix "+" "[expr_DIS]"
	{ "]" => 326, },
	# [326] opcode : bit "[inline_const]" 1 "," "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_109 ], ":" => [ 7, \&_action_opcode_109 ], },
	# [327] opcode : bit "[inline_const]" 1 "," "[" ix "-"
	{ "!" => [ 14, 328 ], "+" => [ 14, 328 ], "-" => [ 14, 328 ], __else__ => [ 14, 328 ], "~" => [ 14, 328 ], },
	# [328] opcode : bit "[inline_const]" 1 "," "[" ix "-" "[expr_NDIS]"
	{ "]" => 329, },
	# [329] opcode : bit "[inline_const]" 1 "," "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_109 ], ":" => [ 7, \&_action_opcode_109 ], },
	# [330] opcode : bit "[inline_const]" 1 "," "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_108 ], ":" => [ 7, \&_action_opcode_108 ], },
	# [331] opcode : bit "[inline_const]" 1 "," "[" iy
	{ "+" => 332, "-" => 335, "]" => 338, },
	# [332] opcode : bit "[inline_const]" 1 "," "[" iy "+"
	{ "!" => [ 12, 333 ], "+" => [ 12, 333 ], "-" => [ 12, 333 ], __else__ => [ 12, 333 ], "~" => [ 12, 333 ], },
	# [333] opcode : bit "[inline_const]" 1 "," "[" iy "+" "[expr_DIS]"
	{ "]" => 334, },
	# [334] opcode : bit "[inline_const]" 1 "," "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_111 ], ":" => [ 7, \&_action_opcode_111 ], },
	# [335] opcode : bit "[inline_const]" 1 "," "[" iy "-"
	{ "!" => [ 14, 336 ], "+" => [ 14, 336 ], "-" => [ 14, 336 ], __else__ => [ 14, 336 ], "~" => [ 14, 336 ], },
	# [336] opcode : bit "[inline_const]" 1 "," "[" iy "-" "[expr_NDIS]"
	{ "]" => 337, },
	# [337] opcode : bit "[inline_const]" 1 "," "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_111 ], ":" => [ 7, \&_action_opcode_111 ], },
	# [338] opcode : bit "[inline_const]" 1 "," "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_110 ], ":" => [ 7, \&_action_opcode_110 ], },
	# [339] opcode : bit "[inline_const]" 1 "," a
	{ "\n" => [ 7, \&_action_opcode_112 ], ":" => [ 7, \&_action_opcode_112 ], },
	# [340] opcode : bit "[inline_const]" 1 "," b
	{ "\n" => [ 7, \&_action_opcode_113 ], ":" => [ 7, \&_action_opcode_113 ], },
	# [341] opcode : bit "[inline_const]" 1 "," c
	{ "\n" => [ 7, \&_action_opcode_114 ], ":" => [ 7, \&_action_opcode_114 ], },
	# [342] opcode : bit "[inline_const]" 1 "," d
	{ "\n" => [ 7, \&_action_opcode_115 ], ":" => [ 7, \&_action_opcode_115 ], },
	# [343] opcode : bit "[inline_const]" 1 "," e
	{ "\n" => [ 7, \&_action_opcode_116 ], ":" => [ 7, \&_action_opcode_116 ], },
	# [344] opcode : bit "[inline_const]" 1 "," h
	{ "\n" => [ 7, \&_action_opcode_117 ], ":" => [ 7, \&_action_opcode_117 ], },
	# [345] opcode : bit "[inline_const]" 1 "," l
	{ "\n" => [ 7, \&_action_opcode_118 ], ":" => [ 7, \&_action_opcode_118 ], },
	# [346] opcode : bit "[inline_const]" 2
	{ "," => 347, },
	# [347] opcode : bit "[inline_const]" 2 ","
	{ "(" => 348, "[" => 367, a => 386, b => 387, c => 388, d => 389, e => 390, h => 391, l => 392, },
	# [348] opcode : bit "[inline_const]" 2 "," "("
	{ hl => 349, ix => 351, iy => 359, },
	# [349] opcode : bit "[inline_const]" 2 "," "(" hl
	{ ")" => 350, },
	# [350] opcode : bit "[inline_const]" 2 "," "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_119 ], ":" => [ 7, \&_action_opcode_119 ], },
	# [351] opcode : bit "[inline_const]" 2 "," "(" ix
	{ ")" => 352, "+" => 353, "-" => 356, },
	# [352] opcode : bit "[inline_const]" 2 "," "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_120 ], ":" => [ 7, \&_action_opcode_120 ], },
	# [353] opcode : bit "[inline_const]" 2 "," "(" ix "+"
	{ "!" => [ 12, 354 ], "+" => [ 12, 354 ], "-" => [ 12, 354 ], __else__ => [ 12, 354 ], "~" => [ 12, 354 ], },
	# [354] opcode : bit "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]"
	{ ")" => 355, },
	# [355] opcode : bit "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_121 ], ":" => [ 7, \&_action_opcode_121 ], },
	# [356] opcode : bit "[inline_const]" 2 "," "(" ix "-"
	{ "!" => [ 14, 357 ], "+" => [ 14, 357 ], "-" => [ 14, 357 ], __else__ => [ 14, 357 ], "~" => [ 14, 357 ], },
	# [357] opcode : bit "[inline_const]" 2 "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 358, },
	# [358] opcode : bit "[inline_const]" 2 "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_121 ], ":" => [ 7, \&_action_opcode_121 ], },
	# [359] opcode : bit "[inline_const]" 2 "," "(" iy
	{ ")" => 360, "+" => 361, "-" => 364, },
	# [360] opcode : bit "[inline_const]" 2 "," "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_122 ], ":" => [ 7, \&_action_opcode_122 ], },
	# [361] opcode : bit "[inline_const]" 2 "," "(" iy "+"
	{ "!" => [ 12, 362 ], "+" => [ 12, 362 ], "-" => [ 12, 362 ], __else__ => [ 12, 362 ], "~" => [ 12, 362 ], },
	# [362] opcode : bit "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]"
	{ ")" => 363, },
	# [363] opcode : bit "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_123 ], ":" => [ 7, \&_action_opcode_123 ], },
	# [364] opcode : bit "[inline_const]" 2 "," "(" iy "-"
	{ "!" => [ 14, 365 ], "+" => [ 14, 365 ], "-" => [ 14, 365 ], __else__ => [ 14, 365 ], "~" => [ 14, 365 ], },
	# [365] opcode : bit "[inline_const]" 2 "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 366, },
	# [366] opcode : bit "[inline_const]" 2 "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_123 ], ":" => [ 7, \&_action_opcode_123 ], },
	# [367] opcode : bit "[inline_const]" 2 "," "["
	{ hl => 368, ix => 370, iy => 378, },
	# [368] opcode : bit "[inline_const]" 2 "," "[" hl
	{ "]" => 369, },
	# [369] opcode : bit "[inline_const]" 2 "," "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_119 ], ":" => [ 7, \&_action_opcode_119 ], },
	# [370] opcode : bit "[inline_const]" 2 "," "[" ix
	{ "+" => 371, "-" => 374, "]" => 377, },
	# [371] opcode : bit "[inline_const]" 2 "," "[" ix "+"
	{ "!" => [ 12, 372 ], "+" => [ 12, 372 ], "-" => [ 12, 372 ], __else__ => [ 12, 372 ], "~" => [ 12, 372 ], },
	# [372] opcode : bit "[inline_const]" 2 "," "[" ix "+" "[expr_DIS]"
	{ "]" => 373, },
	# [373] opcode : bit "[inline_const]" 2 "," "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_121 ], ":" => [ 7, \&_action_opcode_121 ], },
	# [374] opcode : bit "[inline_const]" 2 "," "[" ix "-"
	{ "!" => [ 14, 375 ], "+" => [ 14, 375 ], "-" => [ 14, 375 ], __else__ => [ 14, 375 ], "~" => [ 14, 375 ], },
	# [375] opcode : bit "[inline_const]" 2 "," "[" ix "-" "[expr_NDIS]"
	{ "]" => 376, },
	# [376] opcode : bit "[inline_const]" 2 "," "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_121 ], ":" => [ 7, \&_action_opcode_121 ], },
	# [377] opcode : bit "[inline_const]" 2 "," "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_120 ], ":" => [ 7, \&_action_opcode_120 ], },
	# [378] opcode : bit "[inline_const]" 2 "," "[" iy
	{ "+" => 379, "-" => 382, "]" => 385, },
	# [379] opcode : bit "[inline_const]" 2 "," "[" iy "+"
	{ "!" => [ 12, 380 ], "+" => [ 12, 380 ], "-" => [ 12, 380 ], __else__ => [ 12, 380 ], "~" => [ 12, 380 ], },
	# [380] opcode : bit "[inline_const]" 2 "," "[" iy "+" "[expr_DIS]"
	{ "]" => 381, },
	# [381] opcode : bit "[inline_const]" 2 "," "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_123 ], ":" => [ 7, \&_action_opcode_123 ], },
	# [382] opcode : bit "[inline_const]" 2 "," "[" iy "-"
	{ "!" => [ 14, 383 ], "+" => [ 14, 383 ], "-" => [ 14, 383 ], __else__ => [ 14, 383 ], "~" => [ 14, 383 ], },
	# [383] opcode : bit "[inline_const]" 2 "," "[" iy "-" "[expr_NDIS]"
	{ "]" => 384, },
	# [384] opcode : bit "[inline_const]" 2 "," "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_123 ], ":" => [ 7, \&_action_opcode_123 ], },
	# [385] opcode : bit "[inline_const]" 2 "," "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_122 ], ":" => [ 7, \&_action_opcode_122 ], },
	# [386] opcode : bit "[inline_const]" 2 "," a
	{ "\n" => [ 7, \&_action_opcode_124 ], ":" => [ 7, \&_action_opcode_124 ], },
	# [387] opcode : bit "[inline_const]" 2 "," b
	{ "\n" => [ 7, \&_action_opcode_125 ], ":" => [ 7, \&_action_opcode_125 ], },
	# [388] opcode : bit "[inline_const]" 2 "," c
	{ "\n" => [ 7, \&_action_opcode_126 ], ":" => [ 7, \&_action_opcode_126 ], },
	# [389] opcode : bit "[inline_const]" 2 "," d
	{ "\n" => [ 7, \&_action_opcode_127 ], ":" => [ 7, \&_action_opcode_127 ], },
	# [390] opcode : bit "[inline_const]" 2 "," e
	{ "\n" => [ 7, \&_action_opcode_128 ], ":" => [ 7, \&_action_opcode_128 ], },
	# [391] opcode : bit "[inline_const]" 2 "," h
	{ "\n" => [ 7, \&_action_opcode_129 ], ":" => [ 7, \&_action_opcode_129 ], },
	# [392] opcode : bit "[inline_const]" 2 "," l
	{ "\n" => [ 7, \&_action_opcode_130 ], ":" => [ 7, \&_action_opcode_130 ], },
	# [393] opcode : bit "[inline_const]" 3
	{ "," => 394, },
	# [394] opcode : bit "[inline_const]" 3 ","
	{ "(" => 395, "[" => 414, a => 433, b => 434, c => 435, d => 436, e => 437, h => 438, l => 439, },
	# [395] opcode : bit "[inline_const]" 3 "," "("
	{ hl => 396, ix => 398, iy => 406, },
	# [396] opcode : bit "[inline_const]" 3 "," "(" hl
	{ ")" => 397, },
	# [397] opcode : bit "[inline_const]" 3 "," "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_131 ], ":" => [ 7, \&_action_opcode_131 ], },
	# [398] opcode : bit "[inline_const]" 3 "," "(" ix
	{ ")" => 399, "+" => 400, "-" => 403, },
	# [399] opcode : bit "[inline_const]" 3 "," "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_132 ], ":" => [ 7, \&_action_opcode_132 ], },
	# [400] opcode : bit "[inline_const]" 3 "," "(" ix "+"
	{ "!" => [ 12, 401 ], "+" => [ 12, 401 ], "-" => [ 12, 401 ], __else__ => [ 12, 401 ], "~" => [ 12, 401 ], },
	# [401] opcode : bit "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]"
	{ ")" => 402, },
	# [402] opcode : bit "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_133 ], ":" => [ 7, \&_action_opcode_133 ], },
	# [403] opcode : bit "[inline_const]" 3 "," "(" ix "-"
	{ "!" => [ 14, 404 ], "+" => [ 14, 404 ], "-" => [ 14, 404 ], __else__ => [ 14, 404 ], "~" => [ 14, 404 ], },
	# [404] opcode : bit "[inline_const]" 3 "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 405, },
	# [405] opcode : bit "[inline_const]" 3 "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_133 ], ":" => [ 7, \&_action_opcode_133 ], },
	# [406] opcode : bit "[inline_const]" 3 "," "(" iy
	{ ")" => 407, "+" => 408, "-" => 411, },
	# [407] opcode : bit "[inline_const]" 3 "," "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_134 ], ":" => [ 7, \&_action_opcode_134 ], },
	# [408] opcode : bit "[inline_const]" 3 "," "(" iy "+"
	{ "!" => [ 12, 409 ], "+" => [ 12, 409 ], "-" => [ 12, 409 ], __else__ => [ 12, 409 ], "~" => [ 12, 409 ], },
	# [409] opcode : bit "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]"
	{ ")" => 410, },
	# [410] opcode : bit "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_135 ], ":" => [ 7, \&_action_opcode_135 ], },
	# [411] opcode : bit "[inline_const]" 3 "," "(" iy "-"
	{ "!" => [ 14, 412 ], "+" => [ 14, 412 ], "-" => [ 14, 412 ], __else__ => [ 14, 412 ], "~" => [ 14, 412 ], },
	# [412] opcode : bit "[inline_const]" 3 "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 413, },
	# [413] opcode : bit "[inline_const]" 3 "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_135 ], ":" => [ 7, \&_action_opcode_135 ], },
	# [414] opcode : bit "[inline_const]" 3 "," "["
	{ hl => 415, ix => 417, iy => 425, },
	# [415] opcode : bit "[inline_const]" 3 "," "[" hl
	{ "]" => 416, },
	# [416] opcode : bit "[inline_const]" 3 "," "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_131 ], ":" => [ 7, \&_action_opcode_131 ], },
	# [417] opcode : bit "[inline_const]" 3 "," "[" ix
	{ "+" => 418, "-" => 421, "]" => 424, },
	# [418] opcode : bit "[inline_const]" 3 "," "[" ix "+"
	{ "!" => [ 12, 419 ], "+" => [ 12, 419 ], "-" => [ 12, 419 ], __else__ => [ 12, 419 ], "~" => [ 12, 419 ], },
	# [419] opcode : bit "[inline_const]" 3 "," "[" ix "+" "[expr_DIS]"
	{ "]" => 420, },
	# [420] opcode : bit "[inline_const]" 3 "," "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_133 ], ":" => [ 7, \&_action_opcode_133 ], },
	# [421] opcode : bit "[inline_const]" 3 "," "[" ix "-"
	{ "!" => [ 14, 422 ], "+" => [ 14, 422 ], "-" => [ 14, 422 ], __else__ => [ 14, 422 ], "~" => [ 14, 422 ], },
	# [422] opcode : bit "[inline_const]" 3 "," "[" ix "-" "[expr_NDIS]"
	{ "]" => 423, },
	# [423] opcode : bit "[inline_const]" 3 "," "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_133 ], ":" => [ 7, \&_action_opcode_133 ], },
	# [424] opcode : bit "[inline_const]" 3 "," "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_132 ], ":" => [ 7, \&_action_opcode_132 ], },
	# [425] opcode : bit "[inline_const]" 3 "," "[" iy
	{ "+" => 426, "-" => 429, "]" => 432, },
	# [426] opcode : bit "[inline_const]" 3 "," "[" iy "+"
	{ "!" => [ 12, 427 ], "+" => [ 12, 427 ], "-" => [ 12, 427 ], __else__ => [ 12, 427 ], "~" => [ 12, 427 ], },
	# [427] opcode : bit "[inline_const]" 3 "," "[" iy "+" "[expr_DIS]"
	{ "]" => 428, },
	# [428] opcode : bit "[inline_const]" 3 "," "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_135 ], ":" => [ 7, \&_action_opcode_135 ], },
	# [429] opcode : bit "[inline_const]" 3 "," "[" iy "-"
	{ "!" => [ 14, 430 ], "+" => [ 14, 430 ], "-" => [ 14, 430 ], __else__ => [ 14, 430 ], "~" => [ 14, 430 ], },
	# [430] opcode : bit "[inline_const]" 3 "," "[" iy "-" "[expr_NDIS]"
	{ "]" => 431, },
	# [431] opcode : bit "[inline_const]" 3 "," "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_135 ], ":" => [ 7, \&_action_opcode_135 ], },
	# [432] opcode : bit "[inline_const]" 3 "," "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_134 ], ":" => [ 7, \&_action_opcode_134 ], },
	# [433] opcode : bit "[inline_const]" 3 "," a
	{ "\n" => [ 7, \&_action_opcode_136 ], ":" => [ 7, \&_action_opcode_136 ], },
	# [434] opcode : bit "[inline_const]" 3 "," b
	{ "\n" => [ 7, \&_action_opcode_137 ], ":" => [ 7, \&_action_opcode_137 ], },
	# [435] opcode : bit "[inline_const]" 3 "," c
	{ "\n" => [ 7, \&_action_opcode_138 ], ":" => [ 7, \&_action_opcode_138 ], },
	# [436] opcode : bit "[inline_const]" 3 "," d
	{ "\n" => [ 7, \&_action_opcode_139 ], ":" => [ 7, \&_action_opcode_139 ], },
	# [437] opcode : bit "[inline_const]" 3 "," e
	{ "\n" => [ 7, \&_action_opcode_140 ], ":" => [ 7, \&_action_opcode_140 ], },
	# [438] opcode : bit "[inline_const]" 3 "," h
	{ "\n" => [ 7, \&_action_opcode_141 ], ":" => [ 7, \&_action_opcode_141 ], },
	# [439] opcode : bit "[inline_const]" 3 "," l
	{ "\n" => [ 7, \&_action_opcode_142 ], ":" => [ 7, \&_action_opcode_142 ], },
	# [440] opcode : bit "[inline_const]" 4
	{ "," => 441, },
	# [441] opcode : bit "[inline_const]" 4 ","
	{ "(" => 442, "[" => 461, a => 480, b => 481, c => 482, d => 483, e => 484, h => 485, l => 486, },
	# [442] opcode : bit "[inline_const]" 4 "," "("
	{ hl => 443, ix => 445, iy => 453, },
	# [443] opcode : bit "[inline_const]" 4 "," "(" hl
	{ ")" => 444, },
	# [444] opcode : bit "[inline_const]" 4 "," "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_143 ], ":" => [ 7, \&_action_opcode_143 ], },
	# [445] opcode : bit "[inline_const]" 4 "," "(" ix
	{ ")" => 446, "+" => 447, "-" => 450, },
	# [446] opcode : bit "[inline_const]" 4 "," "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_144 ], ":" => [ 7, \&_action_opcode_144 ], },
	# [447] opcode : bit "[inline_const]" 4 "," "(" ix "+"
	{ "!" => [ 12, 448 ], "+" => [ 12, 448 ], "-" => [ 12, 448 ], __else__ => [ 12, 448 ], "~" => [ 12, 448 ], },
	# [448] opcode : bit "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]"
	{ ")" => 449, },
	# [449] opcode : bit "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_145 ], ":" => [ 7, \&_action_opcode_145 ], },
	# [450] opcode : bit "[inline_const]" 4 "," "(" ix "-"
	{ "!" => [ 14, 451 ], "+" => [ 14, 451 ], "-" => [ 14, 451 ], __else__ => [ 14, 451 ], "~" => [ 14, 451 ], },
	# [451] opcode : bit "[inline_const]" 4 "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 452, },
	# [452] opcode : bit "[inline_const]" 4 "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_145 ], ":" => [ 7, \&_action_opcode_145 ], },
	# [453] opcode : bit "[inline_const]" 4 "," "(" iy
	{ ")" => 454, "+" => 455, "-" => 458, },
	# [454] opcode : bit "[inline_const]" 4 "," "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_146 ], ":" => [ 7, \&_action_opcode_146 ], },
	# [455] opcode : bit "[inline_const]" 4 "," "(" iy "+"
	{ "!" => [ 12, 456 ], "+" => [ 12, 456 ], "-" => [ 12, 456 ], __else__ => [ 12, 456 ], "~" => [ 12, 456 ], },
	# [456] opcode : bit "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]"
	{ ")" => 457, },
	# [457] opcode : bit "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_147 ], ":" => [ 7, \&_action_opcode_147 ], },
	# [458] opcode : bit "[inline_const]" 4 "," "(" iy "-"
	{ "!" => [ 14, 459 ], "+" => [ 14, 459 ], "-" => [ 14, 459 ], __else__ => [ 14, 459 ], "~" => [ 14, 459 ], },
	# [459] opcode : bit "[inline_const]" 4 "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 460, },
	# [460] opcode : bit "[inline_const]" 4 "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_147 ], ":" => [ 7, \&_action_opcode_147 ], },
	# [461] opcode : bit "[inline_const]" 4 "," "["
	{ hl => 462, ix => 464, iy => 472, },
	# [462] opcode : bit "[inline_const]" 4 "," "[" hl
	{ "]" => 463, },
	# [463] opcode : bit "[inline_const]" 4 "," "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_143 ], ":" => [ 7, \&_action_opcode_143 ], },
	# [464] opcode : bit "[inline_const]" 4 "," "[" ix
	{ "+" => 465, "-" => 468, "]" => 471, },
	# [465] opcode : bit "[inline_const]" 4 "," "[" ix "+"
	{ "!" => [ 12, 466 ], "+" => [ 12, 466 ], "-" => [ 12, 466 ], __else__ => [ 12, 466 ], "~" => [ 12, 466 ], },
	# [466] opcode : bit "[inline_const]" 4 "," "[" ix "+" "[expr_DIS]"
	{ "]" => 467, },
	# [467] opcode : bit "[inline_const]" 4 "," "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_145 ], ":" => [ 7, \&_action_opcode_145 ], },
	# [468] opcode : bit "[inline_const]" 4 "," "[" ix "-"
	{ "!" => [ 14, 469 ], "+" => [ 14, 469 ], "-" => [ 14, 469 ], __else__ => [ 14, 469 ], "~" => [ 14, 469 ], },
	# [469] opcode : bit "[inline_const]" 4 "," "[" ix "-" "[expr_NDIS]"
	{ "]" => 470, },
	# [470] opcode : bit "[inline_const]" 4 "," "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_145 ], ":" => [ 7, \&_action_opcode_145 ], },
	# [471] opcode : bit "[inline_const]" 4 "," "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_144 ], ":" => [ 7, \&_action_opcode_144 ], },
	# [472] opcode : bit "[inline_const]" 4 "," "[" iy
	{ "+" => 473, "-" => 476, "]" => 479, },
	# [473] opcode : bit "[inline_const]" 4 "," "[" iy "+"
	{ "!" => [ 12, 474 ], "+" => [ 12, 474 ], "-" => [ 12, 474 ], __else__ => [ 12, 474 ], "~" => [ 12, 474 ], },
	# [474] opcode : bit "[inline_const]" 4 "," "[" iy "+" "[expr_DIS]"
	{ "]" => 475, },
	# [475] opcode : bit "[inline_const]" 4 "," "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_147 ], ":" => [ 7, \&_action_opcode_147 ], },
	# [476] opcode : bit "[inline_const]" 4 "," "[" iy "-"
	{ "!" => [ 14, 477 ], "+" => [ 14, 477 ], "-" => [ 14, 477 ], __else__ => [ 14, 477 ], "~" => [ 14, 477 ], },
	# [477] opcode : bit "[inline_const]" 4 "," "[" iy "-" "[expr_NDIS]"
	{ "]" => 478, },
	# [478] opcode : bit "[inline_const]" 4 "," "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_147 ], ":" => [ 7, \&_action_opcode_147 ], },
	# [479] opcode : bit "[inline_const]" 4 "," "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_146 ], ":" => [ 7, \&_action_opcode_146 ], },
	# [480] opcode : bit "[inline_const]" 4 "," a
	{ "\n" => [ 7, \&_action_opcode_148 ], ":" => [ 7, \&_action_opcode_148 ], },
	# [481] opcode : bit "[inline_const]" 4 "," b
	{ "\n" => [ 7, \&_action_opcode_149 ], ":" => [ 7, \&_action_opcode_149 ], },
	# [482] opcode : bit "[inline_const]" 4 "," c
	{ "\n" => [ 7, \&_action_opcode_150 ], ":" => [ 7, \&_action_opcode_150 ], },
	# [483] opcode : bit "[inline_const]" 4 "," d
	{ "\n" => [ 7, \&_action_opcode_151 ], ":" => [ 7, \&_action_opcode_151 ], },
	# [484] opcode : bit "[inline_const]" 4 "," e
	{ "\n" => [ 7, \&_action_opcode_152 ], ":" => [ 7, \&_action_opcode_152 ], },
	# [485] opcode : bit "[inline_const]" 4 "," h
	{ "\n" => [ 7, \&_action_opcode_153 ], ":" => [ 7, \&_action_opcode_153 ], },
	# [486] opcode : bit "[inline_const]" 4 "," l
	{ "\n" => [ 7, \&_action_opcode_154 ], ":" => [ 7, \&_action_opcode_154 ], },
	# [487] opcode : bit "[inline_const]" 5
	{ "," => 488, },
	# [488] opcode : bit "[inline_const]" 5 ","
	{ "(" => 489, "[" => 508, a => 527, b => 528, c => 529, d => 530, e => 531, h => 532, l => 533, },
	# [489] opcode : bit "[inline_const]" 5 "," "("
	{ hl => 490, ix => 492, iy => 500, },
	# [490] opcode : bit "[inline_const]" 5 "," "(" hl
	{ ")" => 491, },
	# [491] opcode : bit "[inline_const]" 5 "," "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_155 ], ":" => [ 7, \&_action_opcode_155 ], },
	# [492] opcode : bit "[inline_const]" 5 "," "(" ix
	{ ")" => 493, "+" => 494, "-" => 497, },
	# [493] opcode : bit "[inline_const]" 5 "," "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_156 ], ":" => [ 7, \&_action_opcode_156 ], },
	# [494] opcode : bit "[inline_const]" 5 "," "(" ix "+"
	{ "!" => [ 12, 495 ], "+" => [ 12, 495 ], "-" => [ 12, 495 ], __else__ => [ 12, 495 ], "~" => [ 12, 495 ], },
	# [495] opcode : bit "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]"
	{ ")" => 496, },
	# [496] opcode : bit "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_157 ], ":" => [ 7, \&_action_opcode_157 ], },
	# [497] opcode : bit "[inline_const]" 5 "," "(" ix "-"
	{ "!" => [ 14, 498 ], "+" => [ 14, 498 ], "-" => [ 14, 498 ], __else__ => [ 14, 498 ], "~" => [ 14, 498 ], },
	# [498] opcode : bit "[inline_const]" 5 "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 499, },
	# [499] opcode : bit "[inline_const]" 5 "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_157 ], ":" => [ 7, \&_action_opcode_157 ], },
	# [500] opcode : bit "[inline_const]" 5 "," "(" iy
	{ ")" => 501, "+" => 502, "-" => 505, },
	# [501] opcode : bit "[inline_const]" 5 "," "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_158 ], ":" => [ 7, \&_action_opcode_158 ], },
	# [502] opcode : bit "[inline_const]" 5 "," "(" iy "+"
	{ "!" => [ 12, 503 ], "+" => [ 12, 503 ], "-" => [ 12, 503 ], __else__ => [ 12, 503 ], "~" => [ 12, 503 ], },
	# [503] opcode : bit "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]"
	{ ")" => 504, },
	# [504] opcode : bit "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_159 ], ":" => [ 7, \&_action_opcode_159 ], },
	# [505] opcode : bit "[inline_const]" 5 "," "(" iy "-"
	{ "!" => [ 14, 506 ], "+" => [ 14, 506 ], "-" => [ 14, 506 ], __else__ => [ 14, 506 ], "~" => [ 14, 506 ], },
	# [506] opcode : bit "[inline_const]" 5 "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 507, },
	# [507] opcode : bit "[inline_const]" 5 "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_159 ], ":" => [ 7, \&_action_opcode_159 ], },
	# [508] opcode : bit "[inline_const]" 5 "," "["
	{ hl => 509, ix => 511, iy => 519, },
	# [509] opcode : bit "[inline_const]" 5 "," "[" hl
	{ "]" => 510, },
	# [510] opcode : bit "[inline_const]" 5 "," "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_155 ], ":" => [ 7, \&_action_opcode_155 ], },
	# [511] opcode : bit "[inline_const]" 5 "," "[" ix
	{ "+" => 512, "-" => 515, "]" => 518, },
	# [512] opcode : bit "[inline_const]" 5 "," "[" ix "+"
	{ "!" => [ 12, 513 ], "+" => [ 12, 513 ], "-" => [ 12, 513 ], __else__ => [ 12, 513 ], "~" => [ 12, 513 ], },
	# [513] opcode : bit "[inline_const]" 5 "," "[" ix "+" "[expr_DIS]"
	{ "]" => 514, },
	# [514] opcode : bit "[inline_const]" 5 "," "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_157 ], ":" => [ 7, \&_action_opcode_157 ], },
	# [515] opcode : bit "[inline_const]" 5 "," "[" ix "-"
	{ "!" => [ 14, 516 ], "+" => [ 14, 516 ], "-" => [ 14, 516 ], __else__ => [ 14, 516 ], "~" => [ 14, 516 ], },
	# [516] opcode : bit "[inline_const]" 5 "," "[" ix "-" "[expr_NDIS]"
	{ "]" => 517, },
	# [517] opcode : bit "[inline_const]" 5 "," "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_157 ], ":" => [ 7, \&_action_opcode_157 ], },
	# [518] opcode : bit "[inline_const]" 5 "," "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_156 ], ":" => [ 7, \&_action_opcode_156 ], },
	# [519] opcode : bit "[inline_const]" 5 "," "[" iy
	{ "+" => 520, "-" => 523, "]" => 526, },
	# [520] opcode : bit "[inline_const]" 5 "," "[" iy "+"
	{ "!" => [ 12, 521 ], "+" => [ 12, 521 ], "-" => [ 12, 521 ], __else__ => [ 12, 521 ], "~" => [ 12, 521 ], },
	# [521] opcode : bit "[inline_const]" 5 "," "[" iy "+" "[expr_DIS]"
	{ "]" => 522, },
	# [522] opcode : bit "[inline_const]" 5 "," "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_159 ], ":" => [ 7, \&_action_opcode_159 ], },
	# [523] opcode : bit "[inline_const]" 5 "," "[" iy "-"
	{ "!" => [ 14, 524 ], "+" => [ 14, 524 ], "-" => [ 14, 524 ], __else__ => [ 14, 524 ], "~" => [ 14, 524 ], },
	# [524] opcode : bit "[inline_const]" 5 "," "[" iy "-" "[expr_NDIS]"
	{ "]" => 525, },
	# [525] opcode : bit "[inline_const]" 5 "," "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_159 ], ":" => [ 7, \&_action_opcode_159 ], },
	# [526] opcode : bit "[inline_const]" 5 "," "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_158 ], ":" => [ 7, \&_action_opcode_158 ], },
	# [527] opcode : bit "[inline_const]" 5 "," a
	{ "\n" => [ 7, \&_action_opcode_160 ], ":" => [ 7, \&_action_opcode_160 ], },
	# [528] opcode : bit "[inline_const]" 5 "," b
	{ "\n" => [ 7, \&_action_opcode_161 ], ":" => [ 7, \&_action_opcode_161 ], },
	# [529] opcode : bit "[inline_const]" 5 "," c
	{ "\n" => [ 7, \&_action_opcode_162 ], ":" => [ 7, \&_action_opcode_162 ], },
	# [530] opcode : bit "[inline_const]" 5 "," d
	{ "\n" => [ 7, \&_action_opcode_163 ], ":" => [ 7, \&_action_opcode_163 ], },
	# [531] opcode : bit "[inline_const]" 5 "," e
	{ "\n" => [ 7, \&_action_opcode_164 ], ":" => [ 7, \&_action_opcode_164 ], },
	# [532] opcode : bit "[inline_const]" 5 "," h
	{ "\n" => [ 7, \&_action_opcode_165 ], ":" => [ 7, \&_action_opcode_165 ], },
	# [533] opcode : bit "[inline_const]" 5 "," l
	{ "\n" => [ 7, \&_action_opcode_166 ], ":" => [ 7, \&_action_opcode_166 ], },
	# [534] opcode : bit "[inline_const]" 6
	{ "," => 535, },
	# [535] opcode : bit "[inline_const]" 6 ","
	{ "(" => 536, "[" => 555, a => 574, b => 575, c => 576, d => 577, e => 578, h => 579, l => 580, },
	# [536] opcode : bit "[inline_const]" 6 "," "("
	{ hl => 537, ix => 539, iy => 547, },
	# [537] opcode : bit "[inline_const]" 6 "," "(" hl
	{ ")" => 538, },
	# [538] opcode : bit "[inline_const]" 6 "," "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_167 ], ":" => [ 7, \&_action_opcode_167 ], },
	# [539] opcode : bit "[inline_const]" 6 "," "(" ix
	{ ")" => 540, "+" => 541, "-" => 544, },
	# [540] opcode : bit "[inline_const]" 6 "," "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_168 ], ":" => [ 7, \&_action_opcode_168 ], },
	# [541] opcode : bit "[inline_const]" 6 "," "(" ix "+"
	{ "!" => [ 12, 542 ], "+" => [ 12, 542 ], "-" => [ 12, 542 ], __else__ => [ 12, 542 ], "~" => [ 12, 542 ], },
	# [542] opcode : bit "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]"
	{ ")" => 543, },
	# [543] opcode : bit "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_169 ], ":" => [ 7, \&_action_opcode_169 ], },
	# [544] opcode : bit "[inline_const]" 6 "," "(" ix "-"
	{ "!" => [ 14, 545 ], "+" => [ 14, 545 ], "-" => [ 14, 545 ], __else__ => [ 14, 545 ], "~" => [ 14, 545 ], },
	# [545] opcode : bit "[inline_const]" 6 "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 546, },
	# [546] opcode : bit "[inline_const]" 6 "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_169 ], ":" => [ 7, \&_action_opcode_169 ], },
	# [547] opcode : bit "[inline_const]" 6 "," "(" iy
	{ ")" => 548, "+" => 549, "-" => 552, },
	# [548] opcode : bit "[inline_const]" 6 "," "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_170 ], ":" => [ 7, \&_action_opcode_170 ], },
	# [549] opcode : bit "[inline_const]" 6 "," "(" iy "+"
	{ "!" => [ 12, 550 ], "+" => [ 12, 550 ], "-" => [ 12, 550 ], __else__ => [ 12, 550 ], "~" => [ 12, 550 ], },
	# [550] opcode : bit "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]"
	{ ")" => 551, },
	# [551] opcode : bit "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_171 ], ":" => [ 7, \&_action_opcode_171 ], },
	# [552] opcode : bit "[inline_const]" 6 "," "(" iy "-"
	{ "!" => [ 14, 553 ], "+" => [ 14, 553 ], "-" => [ 14, 553 ], __else__ => [ 14, 553 ], "~" => [ 14, 553 ], },
	# [553] opcode : bit "[inline_const]" 6 "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 554, },
	# [554] opcode : bit "[inline_const]" 6 "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_171 ], ":" => [ 7, \&_action_opcode_171 ], },
	# [555] opcode : bit "[inline_const]" 6 "," "["
	{ hl => 556, ix => 558, iy => 566, },
	# [556] opcode : bit "[inline_const]" 6 "," "[" hl
	{ "]" => 557, },
	# [557] opcode : bit "[inline_const]" 6 "," "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_167 ], ":" => [ 7, \&_action_opcode_167 ], },
	# [558] opcode : bit "[inline_const]" 6 "," "[" ix
	{ "+" => 559, "-" => 562, "]" => 565, },
	# [559] opcode : bit "[inline_const]" 6 "," "[" ix "+"
	{ "!" => [ 12, 560 ], "+" => [ 12, 560 ], "-" => [ 12, 560 ], __else__ => [ 12, 560 ], "~" => [ 12, 560 ], },
	# [560] opcode : bit "[inline_const]" 6 "," "[" ix "+" "[expr_DIS]"
	{ "]" => 561, },
	# [561] opcode : bit "[inline_const]" 6 "," "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_169 ], ":" => [ 7, \&_action_opcode_169 ], },
	# [562] opcode : bit "[inline_const]" 6 "," "[" ix "-"
	{ "!" => [ 14, 563 ], "+" => [ 14, 563 ], "-" => [ 14, 563 ], __else__ => [ 14, 563 ], "~" => [ 14, 563 ], },
	# [563] opcode : bit "[inline_const]" 6 "," "[" ix "-" "[expr_NDIS]"
	{ "]" => 564, },
	# [564] opcode : bit "[inline_const]" 6 "," "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_169 ], ":" => [ 7, \&_action_opcode_169 ], },
	# [565] opcode : bit "[inline_const]" 6 "," "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_168 ], ":" => [ 7, \&_action_opcode_168 ], },
	# [566] opcode : bit "[inline_const]" 6 "," "[" iy
	{ "+" => 567, "-" => 570, "]" => 573, },
	# [567] opcode : bit "[inline_const]" 6 "," "[" iy "+"
	{ "!" => [ 12, 568 ], "+" => [ 12, 568 ], "-" => [ 12, 568 ], __else__ => [ 12, 568 ], "~" => [ 12, 568 ], },
	# [568] opcode : bit "[inline_const]" 6 "," "[" iy "+" "[expr_DIS]"
	{ "]" => 569, },
	# [569] opcode : bit "[inline_const]" 6 "," "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_171 ], ":" => [ 7, \&_action_opcode_171 ], },
	# [570] opcode : bit "[inline_const]" 6 "," "[" iy "-"
	{ "!" => [ 14, 571 ], "+" => [ 14, 571 ], "-" => [ 14, 571 ], __else__ => [ 14, 571 ], "~" => [ 14, 571 ], },
	# [571] opcode : bit "[inline_const]" 6 "," "[" iy "-" "[expr_NDIS]"
	{ "]" => 572, },
	# [572] opcode : bit "[inline_const]" 6 "," "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_171 ], ":" => [ 7, \&_action_opcode_171 ], },
	# [573] opcode : bit "[inline_const]" 6 "," "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_170 ], ":" => [ 7, \&_action_opcode_170 ], },
	# [574] opcode : bit "[inline_const]" 6 "," a
	{ "\n" => [ 7, \&_action_opcode_172 ], ":" => [ 7, \&_action_opcode_172 ], },
	# [575] opcode : bit "[inline_const]" 6 "," b
	{ "\n" => [ 7, \&_action_opcode_173 ], ":" => [ 7, \&_action_opcode_173 ], },
	# [576] opcode : bit "[inline_const]" 6 "," c
	{ "\n" => [ 7, \&_action_opcode_174 ], ":" => [ 7, \&_action_opcode_174 ], },
	# [577] opcode : bit "[inline_const]" 6 "," d
	{ "\n" => [ 7, \&_action_opcode_175 ], ":" => [ 7, \&_action_opcode_175 ], },
	# [578] opcode : bit "[inline_const]" 6 "," e
	{ "\n" => [ 7, \&_action_opcode_176 ], ":" => [ 7, \&_action_opcode_176 ], },
	# [579] opcode : bit "[inline_const]" 6 "," h
	{ "\n" => [ 7, \&_action_opcode_177 ], ":" => [ 7, \&_action_opcode_177 ], },
	# [580] opcode : bit "[inline_const]" 6 "," l
	{ "\n" => [ 7, \&_action_opcode_178 ], ":" => [ 7, \&_action_opcode_178 ], },
	# [581] opcode : bit "[inline_const]" 7
	{ "," => 582, },
	# [582] opcode : bit "[inline_const]" 7 ","
	{ "(" => 583, "[" => 602, a => 621, b => 622, c => 623, d => 624, e => 625, h => 626, l => 627, },
	# [583] opcode : bit "[inline_const]" 7 "," "("
	{ hl => 584, ix => 586, iy => 594, },
	# [584] opcode : bit "[inline_const]" 7 "," "(" hl
	{ ")" => 585, },
	# [585] opcode : bit "[inline_const]" 7 "," "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_179 ], ":" => [ 7, \&_action_opcode_179 ], },
	# [586] opcode : bit "[inline_const]" 7 "," "(" ix
	{ ")" => 587, "+" => 588, "-" => 591, },
	# [587] opcode : bit "[inline_const]" 7 "," "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_180 ], ":" => [ 7, \&_action_opcode_180 ], },
	# [588] opcode : bit "[inline_const]" 7 "," "(" ix "+"
	{ "!" => [ 12, 589 ], "+" => [ 12, 589 ], "-" => [ 12, 589 ], __else__ => [ 12, 589 ], "~" => [ 12, 589 ], },
	# [589] opcode : bit "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]"
	{ ")" => 590, },
	# [590] opcode : bit "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_181 ], ":" => [ 7, \&_action_opcode_181 ], },
	# [591] opcode : bit "[inline_const]" 7 "," "(" ix "-"
	{ "!" => [ 14, 592 ], "+" => [ 14, 592 ], "-" => [ 14, 592 ], __else__ => [ 14, 592 ], "~" => [ 14, 592 ], },
	# [592] opcode : bit "[inline_const]" 7 "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 593, },
	# [593] opcode : bit "[inline_const]" 7 "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_181 ], ":" => [ 7, \&_action_opcode_181 ], },
	# [594] opcode : bit "[inline_const]" 7 "," "(" iy
	{ ")" => 595, "+" => 596, "-" => 599, },
	# [595] opcode : bit "[inline_const]" 7 "," "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_182 ], ":" => [ 7, \&_action_opcode_182 ], },
	# [596] opcode : bit "[inline_const]" 7 "," "(" iy "+"
	{ "!" => [ 12, 597 ], "+" => [ 12, 597 ], "-" => [ 12, 597 ], __else__ => [ 12, 597 ], "~" => [ 12, 597 ], },
	# [597] opcode : bit "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]"
	{ ")" => 598, },
	# [598] opcode : bit "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_183 ], ":" => [ 7, \&_action_opcode_183 ], },
	# [599] opcode : bit "[inline_const]" 7 "," "(" iy "-"
	{ "!" => [ 14, 600 ], "+" => [ 14, 600 ], "-" => [ 14, 600 ], __else__ => [ 14, 600 ], "~" => [ 14, 600 ], },
	# [600] opcode : bit "[inline_const]" 7 "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 601, },
	# [601] opcode : bit "[inline_const]" 7 "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_183 ], ":" => [ 7, \&_action_opcode_183 ], },
	# [602] opcode : bit "[inline_const]" 7 "," "["
	{ hl => 603, ix => 605, iy => 613, },
	# [603] opcode : bit "[inline_const]" 7 "," "[" hl
	{ "]" => 604, },
	# [604] opcode : bit "[inline_const]" 7 "," "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_179 ], ":" => [ 7, \&_action_opcode_179 ], },
	# [605] opcode : bit "[inline_const]" 7 "," "[" ix
	{ "+" => 606, "-" => 609, "]" => 612, },
	# [606] opcode : bit "[inline_const]" 7 "," "[" ix "+"
	{ "!" => [ 12, 607 ], "+" => [ 12, 607 ], "-" => [ 12, 607 ], __else__ => [ 12, 607 ], "~" => [ 12, 607 ], },
	# [607] opcode : bit "[inline_const]" 7 "," "[" ix "+" "[expr_DIS]"
	{ "]" => 608, },
	# [608] opcode : bit "[inline_const]" 7 "," "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_181 ], ":" => [ 7, \&_action_opcode_181 ], },
	# [609] opcode : bit "[inline_const]" 7 "," "[" ix "-"
	{ "!" => [ 14, 610 ], "+" => [ 14, 610 ], "-" => [ 14, 610 ], __else__ => [ 14, 610 ], "~" => [ 14, 610 ], },
	# [610] opcode : bit "[inline_const]" 7 "," "[" ix "-" "[expr_NDIS]"
	{ "]" => 611, },
	# [611] opcode : bit "[inline_const]" 7 "," "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_181 ], ":" => [ 7, \&_action_opcode_181 ], },
	# [612] opcode : bit "[inline_const]" 7 "," "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_180 ], ":" => [ 7, \&_action_opcode_180 ], },
	# [613] opcode : bit "[inline_const]" 7 "," "[" iy
	{ "+" => 614, "-" => 617, "]" => 620, },
	# [614] opcode : bit "[inline_const]" 7 "," "[" iy "+"
	{ "!" => [ 12, 615 ], "+" => [ 12, 615 ], "-" => [ 12, 615 ], __else__ => [ 12, 615 ], "~" => [ 12, 615 ], },
	# [615] opcode : bit "[inline_const]" 7 "," "[" iy "+" "[expr_DIS]"
	{ "]" => 616, },
	# [616] opcode : bit "[inline_const]" 7 "," "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_183 ], ":" => [ 7, \&_action_opcode_183 ], },
	# [617] opcode : bit "[inline_const]" 7 "," "[" iy "-"
	{ "!" => [ 14, 618 ], "+" => [ 14, 618 ], "-" => [ 14, 618 ], __else__ => [ 14, 618 ], "~" => [ 14, 618 ], },
	# [618] opcode : bit "[inline_const]" 7 "," "[" iy "-" "[expr_NDIS]"
	{ "]" => 619, },
	# [619] opcode : bit "[inline_const]" 7 "," "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_183 ], ":" => [ 7, \&_action_opcode_183 ], },
	# [620] opcode : bit "[inline_const]" 7 "," "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_182 ], ":" => [ 7, \&_action_opcode_182 ], },
	# [621] opcode : bit "[inline_const]" 7 "," a
	{ "\n" => [ 7, \&_action_opcode_184 ], ":" => [ 7, \&_action_opcode_184 ], },
	# [622] opcode : bit "[inline_const]" 7 "," b
	{ "\n" => [ 7, \&_action_opcode_185 ], ":" => [ 7, \&_action_opcode_185 ], },
	# [623] opcode : bit "[inline_const]" 7 "," c
	{ "\n" => [ 7, \&_action_opcode_186 ], ":" => [ 7, \&_action_opcode_186 ], },
	# [624] opcode : bit "[inline_const]" 7 "," d
	{ "\n" => [ 7, \&_action_opcode_187 ], ":" => [ 7, \&_action_opcode_187 ], },
	# [625] opcode : bit "[inline_const]" 7 "," e
	{ "\n" => [ 7, \&_action_opcode_188 ], ":" => [ 7, \&_action_opcode_188 ], },
	# [626] opcode : bit "[inline_const]" 7 "," h
	{ "\n" => [ 7, \&_action_opcode_189 ], ":" => [ 7, \&_action_opcode_189 ], },
	# [627] opcode : bit "[inline_const]" 7 "," l
	{ "\n" => [ 7, \&_action_opcode_190 ], ":" => [ 7, \&_action_opcode_190 ], },
	# [628] opcode : call
	{ "!" => [ 15, 629 ], "+" => [ 15, 629 ], "-" => [ 15, 629 ], __else__ => [ 15, 629 ], c => 630, m => 633, nc => 636, nz => 639, p => 642, pe => 645, po => 648, z => 651, "~" => [ 15, 629 ], },
	# [629] opcode : call "[expr_NN]"
	{ "\n" => [ 7, \&_action_opcode_191 ], ":" => [ 7, \&_action_opcode_191 ], },
	# [630] opcode : call c
	{ "," => 631, },
	# [631] opcode : call c ","
	{ "!" => [ 15, 632 ], "+" => [ 15, 632 ], "-" => [ 15, 632 ], __else__ => [ 15, 632 ], "~" => [ 15, 632 ], },
	# [632] opcode : call c "," "[expr_NN]"
	{ "\n" => [ 7, \&_action_opcode_192 ], ":" => [ 7, \&_action_opcode_192 ], },
	# [633] opcode : call m
	{ "," => 634, },
	# [634] opcode : call m ","
	{ "!" => [ 15, 635 ], "+" => [ 15, 635 ], "-" => [ 15, 635 ], __else__ => [ 15, 635 ], "~" => [ 15, 635 ], },
	# [635] opcode : call m "," "[expr_NN]"
	{ "\n" => [ 7, \&_action_opcode_193 ], ":" => [ 7, \&_action_opcode_193 ], },
	# [636] opcode : call nc
	{ "," => 637, },
	# [637] opcode : call nc ","
	{ "!" => [ 15, 638 ], "+" => [ 15, 638 ], "-" => [ 15, 638 ], __else__ => [ 15, 638 ], "~" => [ 15, 638 ], },
	# [638] opcode : call nc "," "[expr_NN]"
	{ "\n" => [ 7, \&_action_opcode_194 ], ":" => [ 7, \&_action_opcode_194 ], },
	# [639] opcode : call nz
	{ "," => 640, },
	# [640] opcode : call nz ","
	{ "!" => [ 15, 641 ], "+" => [ 15, 641 ], "-" => [ 15, 641 ], __else__ => [ 15, 641 ], "~" => [ 15, 641 ], },
	# [641] opcode : call nz "," "[expr_NN]"
	{ "\n" => [ 7, \&_action_opcode_195 ], ":" => [ 7, \&_action_opcode_195 ], },
	# [642] opcode : call p
	{ "," => 643, },
	# [643] opcode : call p ","
	{ "!" => [ 15, 644 ], "+" => [ 15, 644 ], "-" => [ 15, 644 ], __else__ => [ 15, 644 ], "~" => [ 15, 644 ], },
	# [644] opcode : call p "," "[expr_NN]"
	{ "\n" => [ 7, \&_action_opcode_196 ], ":" => [ 7, \&_action_opcode_196 ], },
	# [645] opcode : call pe
	{ "," => 646, },
	# [646] opcode : call pe ","
	{ "!" => [ 15, 647 ], "+" => [ 15, 647 ], "-" => [ 15, 647 ], __else__ => [ 15, 647 ], "~" => [ 15, 647 ], },
	# [647] opcode : call pe "," "[expr_NN]"
	{ "\n" => [ 7, \&_action_opcode_197 ], ":" => [ 7, \&_action_opcode_197 ], },
	# [648] opcode : call po
	{ "," => 649, },
	# [649] opcode : call po ","
	{ "!" => [ 15, 650 ], "+" => [ 15, 650 ], "-" => [ 15, 650 ], __else__ => [ 15, 650 ], "~" => [ 15, 650 ], },
	# [650] opcode : call po "," "[expr_NN]"
	{ "\n" => [ 7, \&_action_opcode_198 ], ":" => [ 7, \&_action_opcode_198 ], },
	# [651] opcode : call z
	{ "," => 652, },
	# [652] opcode : call z ","
	{ "!" => [ 15, 653 ], "+" => [ 15, 653 ], "-" => [ 15, 653 ], __else__ => [ 15, 653 ], "~" => [ 15, 653 ], },
	# [653] opcode : call z "," "[expr_NN]"
	{ "\n" => [ 7, \&_action_opcode_199 ], ":" => [ 7, \&_action_opcode_199 ], },
	# [654] opcode : ccf
	{ "\n" => [ 7, \&_action_opcode_200 ], ":" => [ 7, \&_action_opcode_200 ], },
	# [655] opcode : cp
	{ "!" => [ 13, 694 ], "(" => 656, "+" => [ 13, 694 ], "-" => [ 13, 694 ], "[" => 675, __else__ => [ 13, 694 ], a => 695, b => 696, c => 697, d => 698, e => 699, h => 700, hx => 701, hy => 702, ixh => 703, ixl => 704, iyh => 705, iyl => 706, l => 707, lx => 708, ly => 709, xh => 710, xl => 711, yh => 712, yl => 713, "~" => [ 13, 694 ], },
	# [656] opcode : cp "("
	{ hl => 657, ix => 659, iy => 667, },
	# [657] opcode : cp "(" hl
	{ ")" => 658, },
	# [658] opcode : cp "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_201 ], ":" => [ 7, \&_action_opcode_201 ], },
	# [659] opcode : cp "(" ix
	{ ")" => 660, "+" => 661, "-" => 664, },
	# [660] opcode : cp "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_202 ], ":" => [ 7, \&_action_opcode_202 ], },
	# [661] opcode : cp "(" ix "+"
	{ "!" => [ 12, 662 ], "+" => [ 12, 662 ], "-" => [ 12, 662 ], __else__ => [ 12, 662 ], "~" => [ 12, 662 ], },
	# [662] opcode : cp "(" ix "+" "[expr_DIS]"
	{ ")" => 663, },
	# [663] opcode : cp "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_203 ], ":" => [ 7, \&_action_opcode_203 ], },
	# [664] opcode : cp "(" ix "-"
	{ "!" => [ 14, 665 ], "+" => [ 14, 665 ], "-" => [ 14, 665 ], __else__ => [ 14, 665 ], "~" => [ 14, 665 ], },
	# [665] opcode : cp "(" ix "-" "[expr_NDIS]"
	{ ")" => 666, },
	# [666] opcode : cp "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_203 ], ":" => [ 7, \&_action_opcode_203 ], },
	# [667] opcode : cp "(" iy
	{ ")" => 668, "+" => 669, "-" => 672, },
	# [668] opcode : cp "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_204 ], ":" => [ 7, \&_action_opcode_204 ], },
	# [669] opcode : cp "(" iy "+"
	{ "!" => [ 12, 670 ], "+" => [ 12, 670 ], "-" => [ 12, 670 ], __else__ => [ 12, 670 ], "~" => [ 12, 670 ], },
	# [670] opcode : cp "(" iy "+" "[expr_DIS]"
	{ ")" => 671, },
	# [671] opcode : cp "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_205 ], ":" => [ 7, \&_action_opcode_205 ], },
	# [672] opcode : cp "(" iy "-"
	{ "!" => [ 14, 673 ], "+" => [ 14, 673 ], "-" => [ 14, 673 ], __else__ => [ 14, 673 ], "~" => [ 14, 673 ], },
	# [673] opcode : cp "(" iy "-" "[expr_NDIS]"
	{ ")" => 674, },
	# [674] opcode : cp "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_205 ], ":" => [ 7, \&_action_opcode_205 ], },
	# [675] opcode : cp "["
	{ hl => 676, ix => 678, iy => 686, },
	# [676] opcode : cp "[" hl
	{ "]" => 677, },
	# [677] opcode : cp "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_201 ], ":" => [ 7, \&_action_opcode_201 ], },
	# [678] opcode : cp "[" ix
	{ "+" => 679, "-" => 682, "]" => 685, },
	# [679] opcode : cp "[" ix "+"
	{ "!" => [ 12, 680 ], "+" => [ 12, 680 ], "-" => [ 12, 680 ], __else__ => [ 12, 680 ], "~" => [ 12, 680 ], },
	# [680] opcode : cp "[" ix "+" "[expr_DIS]"
	{ "]" => 681, },
	# [681] opcode : cp "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_203 ], ":" => [ 7, \&_action_opcode_203 ], },
	# [682] opcode : cp "[" ix "-"
	{ "!" => [ 14, 683 ], "+" => [ 14, 683 ], "-" => [ 14, 683 ], __else__ => [ 14, 683 ], "~" => [ 14, 683 ], },
	# [683] opcode : cp "[" ix "-" "[expr_NDIS]"
	{ "]" => 684, },
	# [684] opcode : cp "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_203 ], ":" => [ 7, \&_action_opcode_203 ], },
	# [685] opcode : cp "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_202 ], ":" => [ 7, \&_action_opcode_202 ], },
	# [686] opcode : cp "[" iy
	{ "+" => 687, "-" => 690, "]" => 693, },
	# [687] opcode : cp "[" iy "+"
	{ "!" => [ 12, 688 ], "+" => [ 12, 688 ], "-" => [ 12, 688 ], __else__ => [ 12, 688 ], "~" => [ 12, 688 ], },
	# [688] opcode : cp "[" iy "+" "[expr_DIS]"
	{ "]" => 689, },
	# [689] opcode : cp "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_205 ], ":" => [ 7, \&_action_opcode_205 ], },
	# [690] opcode : cp "[" iy "-"
	{ "!" => [ 14, 691 ], "+" => [ 14, 691 ], "-" => [ 14, 691 ], __else__ => [ 14, 691 ], "~" => [ 14, 691 ], },
	# [691] opcode : cp "[" iy "-" "[expr_NDIS]"
	{ "]" => 692, },
	# [692] opcode : cp "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_205 ], ":" => [ 7, \&_action_opcode_205 ], },
	# [693] opcode : cp "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_204 ], ":" => [ 7, \&_action_opcode_204 ], },
	# [694] opcode : cp "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_206 ], ":" => [ 7, \&_action_opcode_206 ], },
	# [695] opcode : cp a
	{ "\n" => [ 7, \&_action_opcode_207 ], ":" => [ 7, \&_action_opcode_207 ], },
	# [696] opcode : cp b
	{ "\n" => [ 7, \&_action_opcode_208 ], ":" => [ 7, \&_action_opcode_208 ], },
	# [697] opcode : cp c
	{ "\n" => [ 7, \&_action_opcode_209 ], ":" => [ 7, \&_action_opcode_209 ], },
	# [698] opcode : cp d
	{ "\n" => [ 7, \&_action_opcode_210 ], ":" => [ 7, \&_action_opcode_210 ], },
	# [699] opcode : cp e
	{ "\n" => [ 7, \&_action_opcode_211 ], ":" => [ 7, \&_action_opcode_211 ], },
	# [700] opcode : cp h
	{ "\n" => [ 7, \&_action_opcode_212 ], ":" => [ 7, \&_action_opcode_212 ], },
	# [701] opcode : cp hx
	{ "\n" => [ 7, \&_action_opcode_213 ], ":" => [ 7, \&_action_opcode_213 ], },
	# [702] opcode : cp hy
	{ "\n" => [ 7, \&_action_opcode_214 ], ":" => [ 7, \&_action_opcode_214 ], },
	# [703] opcode : cp ixh
	{ "\n" => [ 7, \&_action_opcode_213 ], ":" => [ 7, \&_action_opcode_213 ], },
	# [704] opcode : cp ixl
	{ "\n" => [ 7, \&_action_opcode_215 ], ":" => [ 7, \&_action_opcode_215 ], },
	# [705] opcode : cp iyh
	{ "\n" => [ 7, \&_action_opcode_214 ], ":" => [ 7, \&_action_opcode_214 ], },
	# [706] opcode : cp iyl
	{ "\n" => [ 7, \&_action_opcode_216 ], ":" => [ 7, \&_action_opcode_216 ], },
	# [707] opcode : cp l
	{ "\n" => [ 7, \&_action_opcode_217 ], ":" => [ 7, \&_action_opcode_217 ], },
	# [708] opcode : cp lx
	{ "\n" => [ 7, \&_action_opcode_215 ], ":" => [ 7, \&_action_opcode_215 ], },
	# [709] opcode : cp ly
	{ "\n" => [ 7, \&_action_opcode_216 ], ":" => [ 7, \&_action_opcode_216 ], },
	# [710] opcode : cp xh
	{ "\n" => [ 7, \&_action_opcode_213 ], ":" => [ 7, \&_action_opcode_213 ], },
	# [711] opcode : cp xl
	{ "\n" => [ 7, \&_action_opcode_215 ], ":" => [ 7, \&_action_opcode_215 ], },
	# [712] opcode : cp yh
	{ "\n" => [ 7, \&_action_opcode_214 ], ":" => [ 7, \&_action_opcode_214 ], },
	# [713] opcode : cp yl
	{ "\n" => [ 7, \&_action_opcode_216 ], ":" => [ 7, \&_action_opcode_216 ], },
	# [714] opcode : cpd
	{ "\n" => [ 7, \&_action_opcode_218 ], ":" => [ 7, \&_action_opcode_218 ], },
	# [715] opcode : cpdr
	{ "\n" => [ 7, \&_action_opcode_219 ], ":" => [ 7, \&_action_opcode_219 ], },
	# [716] opcode : cpi
	{ "\n" => [ 7, \&_action_opcode_220 ], ":" => [ 7, \&_action_opcode_220 ], },
	# [717] opcode : cpir
	{ "\n" => [ 7, \&_action_opcode_221 ], ":" => [ 7, \&_action_opcode_221 ], },
	# [718] opcode : cpl
	{ "\n" => [ 7, \&_action_opcode_222 ], ":" => [ 7, \&_action_opcode_222 ], },
	# [719] opcode : daa
	{ "\n" => [ 7, \&_action_opcode_223 ], ":" => [ 7, \&_action_opcode_223 ], },
	# [720] opcode : db
	{ "!" => [ 19, 721 ], "+" => [ 19, 721 ], "-" => [ 19, 721 ], __else__ => [ 19, 721 ], "~" => [ 19, 721 ], },
	# [721] opcode : db "[expr_list_N]"
	{ "\n" => [ 7, \&_action_opcode_19 ], ":" => [ 7, \&_action_opcode_19 ], },
	# [722] opcode : dec
	{ "(" => 723, "[" => 742, a => 761, b => 762, bc => 763, c => 764, d => 765, de => 766, e => 767, h => 768, hl => 769, hx => 770, hy => 771, ix => 772, ixh => 773, ixl => 774, iy => 775, iyh => 776, iyl => 777, l => 778, lx => 779, ly => 780, sp => 781, xh => 782, xl => 783, yh => 784, yl => 785, },
	# [723] opcode : dec "("
	{ hl => 724, ix => 726, iy => 734, },
	# [724] opcode : dec "(" hl
	{ ")" => 725, },
	# [725] opcode : dec "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_224 ], ":" => [ 7, \&_action_opcode_224 ], },
	# [726] opcode : dec "(" ix
	{ ")" => 727, "+" => 728, "-" => 731, },
	# [727] opcode : dec "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_225 ], ":" => [ 7, \&_action_opcode_225 ], },
	# [728] opcode : dec "(" ix "+"
	{ "!" => [ 12, 729 ], "+" => [ 12, 729 ], "-" => [ 12, 729 ], __else__ => [ 12, 729 ], "~" => [ 12, 729 ], },
	# [729] opcode : dec "(" ix "+" "[expr_DIS]"
	{ ")" => 730, },
	# [730] opcode : dec "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_226 ], ":" => [ 7, \&_action_opcode_226 ], },
	# [731] opcode : dec "(" ix "-"
	{ "!" => [ 14, 732 ], "+" => [ 14, 732 ], "-" => [ 14, 732 ], __else__ => [ 14, 732 ], "~" => [ 14, 732 ], },
	# [732] opcode : dec "(" ix "-" "[expr_NDIS]"
	{ ")" => 733, },
	# [733] opcode : dec "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_226 ], ":" => [ 7, \&_action_opcode_226 ], },
	# [734] opcode : dec "(" iy
	{ ")" => 735, "+" => 736, "-" => 739, },
	# [735] opcode : dec "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_227 ], ":" => [ 7, \&_action_opcode_227 ], },
	# [736] opcode : dec "(" iy "+"
	{ "!" => [ 12, 737 ], "+" => [ 12, 737 ], "-" => [ 12, 737 ], __else__ => [ 12, 737 ], "~" => [ 12, 737 ], },
	# [737] opcode : dec "(" iy "+" "[expr_DIS]"
	{ ")" => 738, },
	# [738] opcode : dec "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_228 ], ":" => [ 7, \&_action_opcode_228 ], },
	# [739] opcode : dec "(" iy "-"
	{ "!" => [ 14, 740 ], "+" => [ 14, 740 ], "-" => [ 14, 740 ], __else__ => [ 14, 740 ], "~" => [ 14, 740 ], },
	# [740] opcode : dec "(" iy "-" "[expr_NDIS]"
	{ ")" => 741, },
	# [741] opcode : dec "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_228 ], ":" => [ 7, \&_action_opcode_228 ], },
	# [742] opcode : dec "["
	{ hl => 743, ix => 745, iy => 753, },
	# [743] opcode : dec "[" hl
	{ "]" => 744, },
	# [744] opcode : dec "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_224 ], ":" => [ 7, \&_action_opcode_224 ], },
	# [745] opcode : dec "[" ix
	{ "+" => 746, "-" => 749, "]" => 752, },
	# [746] opcode : dec "[" ix "+"
	{ "!" => [ 12, 747 ], "+" => [ 12, 747 ], "-" => [ 12, 747 ], __else__ => [ 12, 747 ], "~" => [ 12, 747 ], },
	# [747] opcode : dec "[" ix "+" "[expr_DIS]"
	{ "]" => 748, },
	# [748] opcode : dec "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_226 ], ":" => [ 7, \&_action_opcode_226 ], },
	# [749] opcode : dec "[" ix "-"
	{ "!" => [ 14, 750 ], "+" => [ 14, 750 ], "-" => [ 14, 750 ], __else__ => [ 14, 750 ], "~" => [ 14, 750 ], },
	# [750] opcode : dec "[" ix "-" "[expr_NDIS]"
	{ "]" => 751, },
	# [751] opcode : dec "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_226 ], ":" => [ 7, \&_action_opcode_226 ], },
	# [752] opcode : dec "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_225 ], ":" => [ 7, \&_action_opcode_225 ], },
	# [753] opcode : dec "[" iy
	{ "+" => 754, "-" => 757, "]" => 760, },
	# [754] opcode : dec "[" iy "+"
	{ "!" => [ 12, 755 ], "+" => [ 12, 755 ], "-" => [ 12, 755 ], __else__ => [ 12, 755 ], "~" => [ 12, 755 ], },
	# [755] opcode : dec "[" iy "+" "[expr_DIS]"
	{ "]" => 756, },
	# [756] opcode : dec "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_228 ], ":" => [ 7, \&_action_opcode_228 ], },
	# [757] opcode : dec "[" iy "-"
	{ "!" => [ 14, 758 ], "+" => [ 14, 758 ], "-" => [ 14, 758 ], __else__ => [ 14, 758 ], "~" => [ 14, 758 ], },
	# [758] opcode : dec "[" iy "-" "[expr_NDIS]"
	{ "]" => 759, },
	# [759] opcode : dec "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_228 ], ":" => [ 7, \&_action_opcode_228 ], },
	# [760] opcode : dec "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_227 ], ":" => [ 7, \&_action_opcode_227 ], },
	# [761] opcode : dec a
	{ "\n" => [ 7, \&_action_opcode_229 ], ":" => [ 7, \&_action_opcode_229 ], },
	# [762] opcode : dec b
	{ "\n" => [ 7, \&_action_opcode_230 ], ":" => [ 7, \&_action_opcode_230 ], },
	# [763] opcode : dec bc
	{ "\n" => [ 7, \&_action_opcode_231 ], ":" => [ 7, \&_action_opcode_231 ], },
	# [764] opcode : dec c
	{ "\n" => [ 7, \&_action_opcode_232 ], ":" => [ 7, \&_action_opcode_232 ], },
	# [765] opcode : dec d
	{ "\n" => [ 7, \&_action_opcode_233 ], ":" => [ 7, \&_action_opcode_233 ], },
	# [766] opcode : dec de
	{ "\n" => [ 7, \&_action_opcode_234 ], ":" => [ 7, \&_action_opcode_234 ], },
	# [767] opcode : dec e
	{ "\n" => [ 7, \&_action_opcode_235 ], ":" => [ 7, \&_action_opcode_235 ], },
	# [768] opcode : dec h
	{ "\n" => [ 7, \&_action_opcode_236 ], ":" => [ 7, \&_action_opcode_236 ], },
	# [769] opcode : dec hl
	{ "\n" => [ 7, \&_action_opcode_237 ], ":" => [ 7, \&_action_opcode_237 ], },
	# [770] opcode : dec hx
	{ "\n" => [ 7, \&_action_opcode_238 ], ":" => [ 7, \&_action_opcode_238 ], },
	# [771] opcode : dec hy
	{ "\n" => [ 7, \&_action_opcode_239 ], ":" => [ 7, \&_action_opcode_239 ], },
	# [772] opcode : dec ix
	{ "\n" => [ 7, \&_action_opcode_240 ], ":" => [ 7, \&_action_opcode_240 ], },
	# [773] opcode : dec ixh
	{ "\n" => [ 7, \&_action_opcode_238 ], ":" => [ 7, \&_action_opcode_238 ], },
	# [774] opcode : dec ixl
	{ "\n" => [ 7, \&_action_opcode_241 ], ":" => [ 7, \&_action_opcode_241 ], },
	# [775] opcode : dec iy
	{ "\n" => [ 7, \&_action_opcode_242 ], ":" => [ 7, \&_action_opcode_242 ], },
	# [776] opcode : dec iyh
	{ "\n" => [ 7, \&_action_opcode_239 ], ":" => [ 7, \&_action_opcode_239 ], },
	# [777] opcode : dec iyl
	{ "\n" => [ 7, \&_action_opcode_243 ], ":" => [ 7, \&_action_opcode_243 ], },
	# [778] opcode : dec l
	{ "\n" => [ 7, \&_action_opcode_244 ], ":" => [ 7, \&_action_opcode_244 ], },
	# [779] opcode : dec lx
	{ "\n" => [ 7, \&_action_opcode_241 ], ":" => [ 7, \&_action_opcode_241 ], },
	# [780] opcode : dec ly
	{ "\n" => [ 7, \&_action_opcode_243 ], ":" => [ 7, \&_action_opcode_243 ], },
	# [781] opcode : dec sp
	{ "\n" => [ 7, \&_action_opcode_245 ], ":" => [ 7, \&_action_opcode_245 ], },
	# [782] opcode : dec xh
	{ "\n" => [ 7, \&_action_opcode_238 ], ":" => [ 7, \&_action_opcode_238 ], },
	# [783] opcode : dec xl
	{ "\n" => [ 7, \&_action_opcode_241 ], ":" => [ 7, \&_action_opcode_241 ], },
	# [784] opcode : dec yh
	{ "\n" => [ 7, \&_action_opcode_239 ], ":" => [ 7, \&_action_opcode_239 ], },
	# [785] opcode : dec yl
	{ "\n" => [ 7, \&_action_opcode_243 ], ":" => [ 7, \&_action_opcode_243 ], },
	# [786] opcode : defb
	{ "!" => [ 19, 787 ], "+" => [ 19, 787 ], "-" => [ 19, 787 ], __else__ => [ 19, 787 ], "~" => [ 19, 787 ], },
	# [787] opcode : defb "[expr_list_N]"
	{ "\n" => [ 7, \&_action_opcode_19 ], ":" => [ 7, \&_action_opcode_19 ], },
	# [788] opcode : defm
	{ NUMBER => [ 21, 789 ], STRING => [ 21, 789 ], },
	# [789] opcode : defm "[expr_list_text]"
	{ "\n" => [ 7, \&_action_opcode_19 ], ":" => [ 7, \&_action_opcode_19 ], },
	# [790] opcode : deft
	{ NUMBER => [ 21, 791 ], STRING => [ 21, 791 ], },
	# [791] opcode : deft "[expr_list_text]"
	{ "\n" => [ 7, \&_action_opcode_19 ], ":" => [ 7, \&_action_opcode_19 ], },
	# [792] opcode : defw
	{ "!" => [ 20, 793 ], "+" => [ 20, 793 ], "-" => [ 20, 793 ], __else__ => [ 20, 793 ], "~" => [ 20, 793 ], },
	# [793] opcode : defw "[expr_list_NN]"
	{ "\n" => [ 7, \&_action_opcode_19 ], ":" => [ 7, \&_action_opcode_19 ], },
	# [794] opcode : di
	{ "\n" => [ 7, \&_action_opcode_246 ], ":" => [ 7, \&_action_opcode_246 ], },
	# [795] opcode : djnz
	{ "!" => [ 15, 796 ], "+" => [ 15, 796 ], "-" => [ 15, 796 ], __else__ => [ 15, 796 ], "~" => [ 15, 796 ], },
	# [796] opcode : djnz "[expr_NN]"
	{ "\n" => [ 7, \&_action_opcode_247 ], ":" => [ 7, \&_action_opcode_247 ], },
	# [797] opcode : dw
	{ "!" => [ 20, 798 ], "+" => [ 20, 798 ], "-" => [ 20, 798 ], __else__ => [ 20, 798 ], "~" => [ 20, 798 ], },
	# [798] opcode : dw "[expr_list_NN]"
	{ "\n" => [ 7, \&_action_opcode_19 ], ":" => [ 7, \&_action_opcode_19 ], },
	# [799] opcode : ei
	{ "\n" => [ 7, \&_action_opcode_248 ], ":" => [ 7, \&_action_opcode_248 ], },
	# [800] opcode : ex
	{ "(" => 801, "[" => 808, af => 815, de => 819, },
	# [801] opcode : ex "("
	{ sp => 802, },
	# [802] opcode : ex "(" sp
	{ ")" => 803, },
	# [803] opcode : ex "(" sp ")"
	{ "," => 804, },
	# [804] opcode : ex "(" sp ")" ","
	{ hl => 805, ix => 806, iy => 807, },
	# [805] opcode : ex "(" sp ")" "," hl
	{ "\n" => [ 7, \&_action_opcode_249 ], ":" => [ 7, \&_action_opcode_249 ], },
	# [806] opcode : ex "(" sp ")" "," ix
	{ "\n" => [ 7, \&_action_opcode_250 ], ":" => [ 7, \&_action_opcode_250 ], },
	# [807] opcode : ex "(" sp ")" "," iy
	{ "\n" => [ 7, \&_action_opcode_251 ], ":" => [ 7, \&_action_opcode_251 ], },
	# [808] opcode : ex "["
	{ sp => 809, },
	# [809] opcode : ex "[" sp
	{ "]" => 810, },
	# [810] opcode : ex "[" sp "]"
	{ "," => 811, },
	# [811] opcode : ex "[" sp "]" ","
	{ hl => 812, ix => 813, iy => 814, },
	# [812] opcode : ex "[" sp "]" "," hl
	{ "\n" => [ 7, \&_action_opcode_249 ], ":" => [ 7, \&_action_opcode_249 ], },
	# [813] opcode : ex "[" sp "]" "," ix
	{ "\n" => [ 7, \&_action_opcode_250 ], ":" => [ 7, \&_action_opcode_250 ], },
	# [814] opcode : ex "[" sp "]" "," iy
	{ "\n" => [ 7, \&_action_opcode_251 ], ":" => [ 7, \&_action_opcode_251 ], },
	# [815] opcode : ex af
	{ "\n" => [ 7, \&_action_opcode_252 ], "," => 816, ":" => [ 7, \&_action_opcode_252 ], },
	# [816] opcode : ex af ","
	{ af => 817, "af'" => 818, },
	# [817] opcode : ex af "," af
	{ "\n" => [ 7, \&_action_opcode_252 ], ":" => [ 7, \&_action_opcode_252 ], },
	# [818] opcode : ex af "," "af'"
	{ "\n" => [ 7, \&_action_opcode_252 ], ":" => [ 7, \&_action_opcode_252 ], },
	# [819] opcode : ex de
	{ "," => 820, },
	# [820] opcode : ex de ","
	{ hl => 821, },
	# [821] opcode : ex de "," hl
	{ "\n" => [ 7, \&_action_opcode_253 ], ":" => [ 7, \&_action_opcode_253 ], },
	# [822] opcode : exa
	{ "\n" => [ 7, \&_action_opcode_252 ], ":" => [ 7, \&_action_opcode_252 ], },
	# [823] opcode : exx
	{ "\n" => [ 7, \&_action_opcode_254 ], ":" => [ 7, \&_action_opcode_254 ], },
	# [824] opcode : halt
	{ "\n" => [ 7, \&_action_opcode_255 ], ":" => [ 7, \&_action_opcode_255 ], },
	# [825] opcode : im
	{ "!" => [ 30, 826 ], "+" => [ 30, 826 ], "-" => [ 30, 826 ], __else__ => [ 30, 826 ], "~" => [ 30, 826 ], },
	# [826] opcode : im "[inline_const]"
	{ 0 => 827, 1 => 828, 2 => 829, },
	# [827] opcode : im "[inline_const]" 0
	{ "\n" => [ 7, \&_action_opcode_256 ], ":" => [ 7, \&_action_opcode_256 ], },
	# [828] opcode : im "[inline_const]" 1
	{ "\n" => [ 7, \&_action_opcode_257 ], ":" => [ 7, \&_action_opcode_257 ], },
	# [829] opcode : im "[inline_const]" 2
	{ "\n" => [ 7, \&_action_opcode_258 ], ":" => [ 7, \&_action_opcode_258 ], },
	# [830] opcode : in
	{ a => 831, b => 843, c => 851, d => 859, e => 867, f => 875, h => 883, l => 891, },
	# [831] opcode : in a
	{ "," => 832, },
	# [832] opcode : in a ","
	{ "(" => 833, "[" => 838, },
	# [833] opcode : in a "," "("
	{ "!" => [ 13, 834 ], "+" => [ 13, 834 ], "-" => [ 13, 834 ], __else__ => [ 13, 834 ], c => 836, "~" => [ 13, 834 ], },
	# [834] opcode : in a "," "(" "[expr_N]"
	{ ")" => 835, },
	# [835] opcode : in a "," "(" "[expr_N]" ")"
	{ "\n" => [ 7, \&_action_opcode_259 ], ":" => [ 7, \&_action_opcode_259 ], },
	# [836] opcode : in a "," "(" c
	{ ")" => 837, },
	# [837] opcode : in a "," "(" c ")"
	{ "\n" => [ 7, \&_action_opcode_260 ], ":" => [ 7, \&_action_opcode_260 ], },
	# [838] opcode : in a "," "["
	{ "!" => [ 13, 839 ], "+" => [ 13, 839 ], "-" => [ 13, 839 ], __else__ => [ 13, 839 ], c => 841, "~" => [ 13, 839 ], },
	# [839] opcode : in a "," "[" "[expr_N]"
	{ "]" => 840, },
	# [840] opcode : in a "," "[" "[expr_N]" "]"
	{ "\n" => [ 7, \&_action_opcode_259 ], ":" => [ 7, \&_action_opcode_259 ], },
	# [841] opcode : in a "," "[" c
	{ "]" => 842, },
	# [842] opcode : in a "," "[" c "]"
	{ "\n" => [ 7, \&_action_opcode_260 ], ":" => [ 7, \&_action_opcode_260 ], },
	# [843] opcode : in b
	{ "," => 844, },
	# [844] opcode : in b ","
	{ "(" => 845, "[" => 848, },
	# [845] opcode : in b "," "("
	{ c => 846, },
	# [846] opcode : in b "," "(" c
	{ ")" => 847, },
	# [847] opcode : in b "," "(" c ")"
	{ "\n" => [ 7, \&_action_opcode_261 ], ":" => [ 7, \&_action_opcode_261 ], },
	# [848] opcode : in b "," "["
	{ c => 849, },
	# [849] opcode : in b "," "[" c
	{ "]" => 850, },
	# [850] opcode : in b "," "[" c "]"
	{ "\n" => [ 7, \&_action_opcode_261 ], ":" => [ 7, \&_action_opcode_261 ], },
	# [851] opcode : in c
	{ "," => 852, },
	# [852] opcode : in c ","
	{ "(" => 853, "[" => 856, },
	# [853] opcode : in c "," "("
	{ c => 854, },
	# [854] opcode : in c "," "(" c
	{ ")" => 855, },
	# [855] opcode : in c "," "(" c ")"
	{ "\n" => [ 7, \&_action_opcode_262 ], ":" => [ 7, \&_action_opcode_262 ], },
	# [856] opcode : in c "," "["
	{ c => 857, },
	# [857] opcode : in c "," "[" c
	{ "]" => 858, },
	# [858] opcode : in c "," "[" c "]"
	{ "\n" => [ 7, \&_action_opcode_262 ], ":" => [ 7, \&_action_opcode_262 ], },
	# [859] opcode : in d
	{ "," => 860, },
	# [860] opcode : in d ","
	{ "(" => 861, "[" => 864, },
	# [861] opcode : in d "," "("
	{ c => 862, },
	# [862] opcode : in d "," "(" c
	{ ")" => 863, },
	# [863] opcode : in d "," "(" c ")"
	{ "\n" => [ 7, \&_action_opcode_263 ], ":" => [ 7, \&_action_opcode_263 ], },
	# [864] opcode : in d "," "["
	{ c => 865, },
	# [865] opcode : in d "," "[" c
	{ "]" => 866, },
	# [866] opcode : in d "," "[" c "]"
	{ "\n" => [ 7, \&_action_opcode_263 ], ":" => [ 7, \&_action_opcode_263 ], },
	# [867] opcode : in e
	{ "," => 868, },
	# [868] opcode : in e ","
	{ "(" => 869, "[" => 872, },
	# [869] opcode : in e "," "("
	{ c => 870, },
	# [870] opcode : in e "," "(" c
	{ ")" => 871, },
	# [871] opcode : in e "," "(" c ")"
	{ "\n" => [ 7, \&_action_opcode_264 ], ":" => [ 7, \&_action_opcode_264 ], },
	# [872] opcode : in e "," "["
	{ c => 873, },
	# [873] opcode : in e "," "[" c
	{ "]" => 874, },
	# [874] opcode : in e "," "[" c "]"
	{ "\n" => [ 7, \&_action_opcode_264 ], ":" => [ 7, \&_action_opcode_264 ], },
	# [875] opcode : in f
	{ "," => 876, },
	# [876] opcode : in f ","
	{ "(" => 877, "[" => 880, },
	# [877] opcode : in f "," "("
	{ c => 878, },
	# [878] opcode : in f "," "(" c
	{ ")" => 879, },
	# [879] opcode : in f "," "(" c ")"
	{ "\n" => [ 7, \&_action_opcode_265 ], ":" => [ 7, \&_action_opcode_265 ], },
	# [880] opcode : in f "," "["
	{ c => 881, },
	# [881] opcode : in f "," "[" c
	{ "]" => 882, },
	# [882] opcode : in f "," "[" c "]"
	{ "\n" => [ 7, \&_action_opcode_265 ], ":" => [ 7, \&_action_opcode_265 ], },
	# [883] opcode : in h
	{ "," => 884, },
	# [884] opcode : in h ","
	{ "(" => 885, "[" => 888, },
	# [885] opcode : in h "," "("
	{ c => 886, },
	# [886] opcode : in h "," "(" c
	{ ")" => 887, },
	# [887] opcode : in h "," "(" c ")"
	{ "\n" => [ 7, \&_action_opcode_266 ], ":" => [ 7, \&_action_opcode_266 ], },
	# [888] opcode : in h "," "["
	{ c => 889, },
	# [889] opcode : in h "," "[" c
	{ "]" => 890, },
	# [890] opcode : in h "," "[" c "]"
	{ "\n" => [ 7, \&_action_opcode_266 ], ":" => [ 7, \&_action_opcode_266 ], },
	# [891] opcode : in l
	{ "," => 892, },
	# [892] opcode : in l ","
	{ "(" => 893, "[" => 896, },
	# [893] opcode : in l "," "("
	{ c => 894, },
	# [894] opcode : in l "," "(" c
	{ ")" => 895, },
	# [895] opcode : in l "," "(" c ")"
	{ "\n" => [ 7, \&_action_opcode_267 ], ":" => [ 7, \&_action_opcode_267 ], },
	# [896] opcode : in l "," "["
	{ c => 897, },
	# [897] opcode : in l "," "[" c
	{ "]" => 898, },
	# [898] opcode : in l "," "[" c "]"
	{ "\n" => [ 7, \&_action_opcode_267 ], ":" => [ 7, \&_action_opcode_267 ], },
	# [899] opcode : inc
	{ "(" => 900, "[" => 919, a => 938, b => 939, bc => 940, c => 941, d => 942, de => 943, e => 944, h => 945, hl => 946, hx => 947, hy => 948, ix => 949, ixh => 950, ixl => 951, iy => 952, iyh => 953, iyl => 954, l => 955, lx => 956, ly => 957, sp => 958, xh => 959, xl => 960, yh => 961, yl => 962, },
	# [900] opcode : inc "("
	{ hl => 901, ix => 903, iy => 911, },
	# [901] opcode : inc "(" hl
	{ ")" => 902, },
	# [902] opcode : inc "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_268 ], ":" => [ 7, \&_action_opcode_268 ], },
	# [903] opcode : inc "(" ix
	{ ")" => 904, "+" => 905, "-" => 908, },
	# [904] opcode : inc "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_269 ], ":" => [ 7, \&_action_opcode_269 ], },
	# [905] opcode : inc "(" ix "+"
	{ "!" => [ 12, 906 ], "+" => [ 12, 906 ], "-" => [ 12, 906 ], __else__ => [ 12, 906 ], "~" => [ 12, 906 ], },
	# [906] opcode : inc "(" ix "+" "[expr_DIS]"
	{ ")" => 907, },
	# [907] opcode : inc "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_270 ], ":" => [ 7, \&_action_opcode_270 ], },
	# [908] opcode : inc "(" ix "-"
	{ "!" => [ 14, 909 ], "+" => [ 14, 909 ], "-" => [ 14, 909 ], __else__ => [ 14, 909 ], "~" => [ 14, 909 ], },
	# [909] opcode : inc "(" ix "-" "[expr_NDIS]"
	{ ")" => 910, },
	# [910] opcode : inc "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_270 ], ":" => [ 7, \&_action_opcode_270 ], },
	# [911] opcode : inc "(" iy
	{ ")" => 912, "+" => 913, "-" => 916, },
	# [912] opcode : inc "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_271 ], ":" => [ 7, \&_action_opcode_271 ], },
	# [913] opcode : inc "(" iy "+"
	{ "!" => [ 12, 914 ], "+" => [ 12, 914 ], "-" => [ 12, 914 ], __else__ => [ 12, 914 ], "~" => [ 12, 914 ], },
	# [914] opcode : inc "(" iy "+" "[expr_DIS]"
	{ ")" => 915, },
	# [915] opcode : inc "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_272 ], ":" => [ 7, \&_action_opcode_272 ], },
	# [916] opcode : inc "(" iy "-"
	{ "!" => [ 14, 917 ], "+" => [ 14, 917 ], "-" => [ 14, 917 ], __else__ => [ 14, 917 ], "~" => [ 14, 917 ], },
	# [917] opcode : inc "(" iy "-" "[expr_NDIS]"
	{ ")" => 918, },
	# [918] opcode : inc "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_272 ], ":" => [ 7, \&_action_opcode_272 ], },
	# [919] opcode : inc "["
	{ hl => 920, ix => 922, iy => 930, },
	# [920] opcode : inc "[" hl
	{ "]" => 921, },
	# [921] opcode : inc "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_268 ], ":" => [ 7, \&_action_opcode_268 ], },
	# [922] opcode : inc "[" ix
	{ "+" => 923, "-" => 926, "]" => 929, },
	# [923] opcode : inc "[" ix "+"
	{ "!" => [ 12, 924 ], "+" => [ 12, 924 ], "-" => [ 12, 924 ], __else__ => [ 12, 924 ], "~" => [ 12, 924 ], },
	# [924] opcode : inc "[" ix "+" "[expr_DIS]"
	{ "]" => 925, },
	# [925] opcode : inc "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_270 ], ":" => [ 7, \&_action_opcode_270 ], },
	# [926] opcode : inc "[" ix "-"
	{ "!" => [ 14, 927 ], "+" => [ 14, 927 ], "-" => [ 14, 927 ], __else__ => [ 14, 927 ], "~" => [ 14, 927 ], },
	# [927] opcode : inc "[" ix "-" "[expr_NDIS]"
	{ "]" => 928, },
	# [928] opcode : inc "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_270 ], ":" => [ 7, \&_action_opcode_270 ], },
	# [929] opcode : inc "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_269 ], ":" => [ 7, \&_action_opcode_269 ], },
	# [930] opcode : inc "[" iy
	{ "+" => 931, "-" => 934, "]" => 937, },
	# [931] opcode : inc "[" iy "+"
	{ "!" => [ 12, 932 ], "+" => [ 12, 932 ], "-" => [ 12, 932 ], __else__ => [ 12, 932 ], "~" => [ 12, 932 ], },
	# [932] opcode : inc "[" iy "+" "[expr_DIS]"
	{ "]" => 933, },
	# [933] opcode : inc "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_272 ], ":" => [ 7, \&_action_opcode_272 ], },
	# [934] opcode : inc "[" iy "-"
	{ "!" => [ 14, 935 ], "+" => [ 14, 935 ], "-" => [ 14, 935 ], __else__ => [ 14, 935 ], "~" => [ 14, 935 ], },
	# [935] opcode : inc "[" iy "-" "[expr_NDIS]"
	{ "]" => 936, },
	# [936] opcode : inc "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_272 ], ":" => [ 7, \&_action_opcode_272 ], },
	# [937] opcode : inc "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_271 ], ":" => [ 7, \&_action_opcode_271 ], },
	# [938] opcode : inc a
	{ "\n" => [ 7, \&_action_opcode_273 ], ":" => [ 7, \&_action_opcode_273 ], },
	# [939] opcode : inc b
	{ "\n" => [ 7, \&_action_opcode_274 ], ":" => [ 7, \&_action_opcode_274 ], },
	# [940] opcode : inc bc
	{ "\n" => [ 7, \&_action_opcode_275 ], ":" => [ 7, \&_action_opcode_275 ], },
	# [941] opcode : inc c
	{ "\n" => [ 7, \&_action_opcode_276 ], ":" => [ 7, \&_action_opcode_276 ], },
	# [942] opcode : inc d
	{ "\n" => [ 7, \&_action_opcode_277 ], ":" => [ 7, \&_action_opcode_277 ], },
	# [943] opcode : inc de
	{ "\n" => [ 7, \&_action_opcode_278 ], ":" => [ 7, \&_action_opcode_278 ], },
	# [944] opcode : inc e
	{ "\n" => [ 7, \&_action_opcode_279 ], ":" => [ 7, \&_action_opcode_279 ], },
	# [945] opcode : inc h
	{ "\n" => [ 7, \&_action_opcode_280 ], ":" => [ 7, \&_action_opcode_280 ], },
	# [946] opcode : inc hl
	{ "\n" => [ 7, \&_action_opcode_281 ], ":" => [ 7, \&_action_opcode_281 ], },
	# [947] opcode : inc hx
	{ "\n" => [ 7, \&_action_opcode_282 ], ":" => [ 7, \&_action_opcode_282 ], },
	# [948] opcode : inc hy
	{ "\n" => [ 7, \&_action_opcode_283 ], ":" => [ 7, \&_action_opcode_283 ], },
	# [949] opcode : inc ix
	{ "\n" => [ 7, \&_action_opcode_284 ], ":" => [ 7, \&_action_opcode_284 ], },
	# [950] opcode : inc ixh
	{ "\n" => [ 7, \&_action_opcode_282 ], ":" => [ 7, \&_action_opcode_282 ], },
	# [951] opcode : inc ixl
	{ "\n" => [ 7, \&_action_opcode_285 ], ":" => [ 7, \&_action_opcode_285 ], },
	# [952] opcode : inc iy
	{ "\n" => [ 7, \&_action_opcode_286 ], ":" => [ 7, \&_action_opcode_286 ], },
	# [953] opcode : inc iyh
	{ "\n" => [ 7, \&_action_opcode_283 ], ":" => [ 7, \&_action_opcode_283 ], },
	# [954] opcode : inc iyl
	{ "\n" => [ 7, \&_action_opcode_287 ], ":" => [ 7, \&_action_opcode_287 ], },
	# [955] opcode : inc l
	{ "\n" => [ 7, \&_action_opcode_288 ], ":" => [ 7, \&_action_opcode_288 ], },
	# [956] opcode : inc lx
	{ "\n" => [ 7, \&_action_opcode_285 ], ":" => [ 7, \&_action_opcode_285 ], },
	# [957] opcode : inc ly
	{ "\n" => [ 7, \&_action_opcode_287 ], ":" => [ 7, \&_action_opcode_287 ], },
	# [958] opcode : inc sp
	{ "\n" => [ 7, \&_action_opcode_289 ], ":" => [ 7, \&_action_opcode_289 ], },
	# [959] opcode : inc xh
	{ "\n" => [ 7, \&_action_opcode_282 ], ":" => [ 7, \&_action_opcode_282 ], },
	# [960] opcode : inc xl
	{ "\n" => [ 7, \&_action_opcode_285 ], ":" => [ 7, \&_action_opcode_285 ], },
	# [961] opcode : inc yh
	{ "\n" => [ 7, \&_action_opcode_283 ], ":" => [ 7, \&_action_opcode_283 ], },
	# [962] opcode : inc yl
	{ "\n" => [ 7, \&_action_opcode_287 ], ":" => [ 7, \&_action_opcode_287 ], },
	# [963] opcode : ind
	{ "\n" => [ 7, \&_action_opcode_290 ], ":" => [ 7, \&_action_opcode_290 ], },
	# [964] opcode : indr
	{ "\n" => [ 7, \&_action_opcode_291 ], ":" => [ 7, \&_action_opcode_291 ], },
	# [965] opcode : ini
	{ "\n" => [ 7, \&_action_opcode_292 ], ":" => [ 7, \&_action_opcode_292 ], },
	# [966] opcode : inir
	{ "\n" => [ 7, \&_action_opcode_293 ], ":" => [ 7, \&_action_opcode_293 ], },
	# [967] opcode : jp
	{ "!" => [ 15, 982 ], "(" => 968, "+" => [ 15, 982 ], "-" => [ 15, 982 ], "[" => 975, __else__ => [ 15, 982 ], c => 983, hl => 986, ix => 987, iy => 988, m => 989, nc => 992, nz => 995, p => 998, pe => 1001, po => 1004, z => 1007, "~" => [ 15, 982 ], },
	# [968] opcode : jp "("
	{ hl => 969, ix => 971, iy => 973, },
	# [969] opcode : jp "(" hl
	{ ")" => 970, },
	# [970] opcode : jp "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_294 ], ":" => [ 7, \&_action_opcode_294 ], },
	# [971] opcode : jp "(" ix
	{ ")" => 972, },
	# [972] opcode : jp "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_295 ], ":" => [ 7, \&_action_opcode_295 ], },
	# [973] opcode : jp "(" iy
	{ ")" => 974, },
	# [974] opcode : jp "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_296 ], ":" => [ 7, \&_action_opcode_296 ], },
	# [975] opcode : jp "["
	{ hl => 976, ix => 978, iy => 980, },
	# [976] opcode : jp "[" hl
	{ "]" => 977, },
	# [977] opcode : jp "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_294 ], ":" => [ 7, \&_action_opcode_294 ], },
	# [978] opcode : jp "[" ix
	{ "]" => 979, },
	# [979] opcode : jp "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_295 ], ":" => [ 7, \&_action_opcode_295 ], },
	# [980] opcode : jp "[" iy
	{ "]" => 981, },
	# [981] opcode : jp "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_296 ], ":" => [ 7, \&_action_opcode_296 ], },
	# [982] opcode : jp "[expr_NN]"
	{ "\n" => [ 7, \&_action_opcode_297 ], ":" => [ 7, \&_action_opcode_297 ], },
	# [983] opcode : jp c
	{ "," => 984, },
	# [984] opcode : jp c ","
	{ "!" => [ 15, 985 ], "+" => [ 15, 985 ], "-" => [ 15, 985 ], __else__ => [ 15, 985 ], "~" => [ 15, 985 ], },
	# [985] opcode : jp c "," "[expr_NN]"
	{ "\n" => [ 7, \&_action_opcode_298 ], ":" => [ 7, \&_action_opcode_298 ], },
	# [986] opcode : jp hl
	{ "\n" => [ 7, \&_action_opcode_294 ], ":" => [ 7, \&_action_opcode_294 ], },
	# [987] opcode : jp ix
	{ "\n" => [ 7, \&_action_opcode_295 ], ":" => [ 7, \&_action_opcode_295 ], },
	# [988] opcode : jp iy
	{ "\n" => [ 7, \&_action_opcode_296 ], ":" => [ 7, \&_action_opcode_296 ], },
	# [989] opcode : jp m
	{ "," => 990, },
	# [990] opcode : jp m ","
	{ "!" => [ 15, 991 ], "+" => [ 15, 991 ], "-" => [ 15, 991 ], __else__ => [ 15, 991 ], "~" => [ 15, 991 ], },
	# [991] opcode : jp m "," "[expr_NN]"
	{ "\n" => [ 7, \&_action_opcode_299 ], ":" => [ 7, \&_action_opcode_299 ], },
	# [992] opcode : jp nc
	{ "," => 993, },
	# [993] opcode : jp nc ","
	{ "!" => [ 15, 994 ], "+" => [ 15, 994 ], "-" => [ 15, 994 ], __else__ => [ 15, 994 ], "~" => [ 15, 994 ], },
	# [994] opcode : jp nc "," "[expr_NN]"
	{ "\n" => [ 7, \&_action_opcode_300 ], ":" => [ 7, \&_action_opcode_300 ], },
	# [995] opcode : jp nz
	{ "," => 996, },
	# [996] opcode : jp nz ","
	{ "!" => [ 15, 997 ], "+" => [ 15, 997 ], "-" => [ 15, 997 ], __else__ => [ 15, 997 ], "~" => [ 15, 997 ], },
	# [997] opcode : jp nz "," "[expr_NN]"
	{ "\n" => [ 7, \&_action_opcode_301 ], ":" => [ 7, \&_action_opcode_301 ], },
	# [998] opcode : jp p
	{ "," => 999, },
	# [999] opcode : jp p ","
	{ "!" => [ 15, 1000 ], "+" => [ 15, 1000 ], "-" => [ 15, 1000 ], __else__ => [ 15, 1000 ], "~" => [ 15, 1000 ], },
	# [1000] opcode : jp p "," "[expr_NN]"
	{ "\n" => [ 7, \&_action_opcode_302 ], ":" => [ 7, \&_action_opcode_302 ], },
	# [1001] opcode : jp pe
	{ "," => 1002, },
	# [1002] opcode : jp pe ","
	{ "!" => [ 15, 1003 ], "+" => [ 15, 1003 ], "-" => [ 15, 1003 ], __else__ => [ 15, 1003 ], "~" => [ 15, 1003 ], },
	# [1003] opcode : jp pe "," "[expr_NN]"
	{ "\n" => [ 7, \&_action_opcode_303 ], ":" => [ 7, \&_action_opcode_303 ], },
	# [1004] opcode : jp po
	{ "," => 1005, },
	# [1005] opcode : jp po ","
	{ "!" => [ 15, 1006 ], "+" => [ 15, 1006 ], "-" => [ 15, 1006 ], __else__ => [ 15, 1006 ], "~" => [ 15, 1006 ], },
	# [1006] opcode : jp po "," "[expr_NN]"
	{ "\n" => [ 7, \&_action_opcode_304 ], ":" => [ 7, \&_action_opcode_304 ], },
	# [1007] opcode : jp z
	{ "," => 1008, },
	# [1008] opcode : jp z ","
	{ "!" => [ 15, 1009 ], "+" => [ 15, 1009 ], "-" => [ 15, 1009 ], __else__ => [ 15, 1009 ], "~" => [ 15, 1009 ], },
	# [1009] opcode : jp z "," "[expr_NN]"
	{ "\n" => [ 7, \&_action_opcode_305 ], ":" => [ 7, \&_action_opcode_305 ], },
	# [1010] opcode : jr
	{ "!" => [ 15, 1011 ], "+" => [ 15, 1011 ], "-" => [ 15, 1011 ], __else__ => [ 15, 1011 ], c => 1012, nc => 1015, nz => 1018, z => 1021, "~" => [ 15, 1011 ], },
	# [1011] opcode : jr "[expr_NN]"
	{ "\n" => [ 7, \&_action_opcode_306 ], ":" => [ 7, \&_action_opcode_306 ], },
	# [1012] opcode : jr c
	{ "," => 1013, },
	# [1013] opcode : jr c ","
	{ "!" => [ 15, 1014 ], "+" => [ 15, 1014 ], "-" => [ 15, 1014 ], __else__ => [ 15, 1014 ], "~" => [ 15, 1014 ], },
	# [1014] opcode : jr c "," "[expr_NN]"
	{ "\n" => [ 7, \&_action_opcode_307 ], ":" => [ 7, \&_action_opcode_307 ], },
	# [1015] opcode : jr nc
	{ "," => 1016, },
	# [1016] opcode : jr nc ","
	{ "!" => [ 15, 1017 ], "+" => [ 15, 1017 ], "-" => [ 15, 1017 ], __else__ => [ 15, 1017 ], "~" => [ 15, 1017 ], },
	# [1017] opcode : jr nc "," "[expr_NN]"
	{ "\n" => [ 7, \&_action_opcode_308 ], ":" => [ 7, \&_action_opcode_308 ], },
	# [1018] opcode : jr nz
	{ "," => 1019, },
	# [1019] opcode : jr nz ","
	{ "!" => [ 15, 1020 ], "+" => [ 15, 1020 ], "-" => [ 15, 1020 ], __else__ => [ 15, 1020 ], "~" => [ 15, 1020 ], },
	# [1020] opcode : jr nz "," "[expr_NN]"
	{ "\n" => [ 7, \&_action_opcode_309 ], ":" => [ 7, \&_action_opcode_309 ], },
	# [1021] opcode : jr z
	{ "," => 1022, },
	# [1022] opcode : jr z ","
	{ "!" => [ 15, 1023 ], "+" => [ 15, 1023 ], "-" => [ 15, 1023 ], __else__ => [ 15, 1023 ], "~" => [ 15, 1023 ], },
	# [1023] opcode : jr z "," "[expr_NN]"
	{ "\n" => [ 7, \&_action_opcode_310 ], ":" => [ 7, \&_action_opcode_310 ], },
	# [1024] opcode : ld
	{ "(" => 1025, "[" => 1145, a => 1265, b => 1339, bc => 1399, c => 1449, d => 1509, de => 1569, e => 1619, h => 1679, hl => 1727, hx => 1773, hy => 1783, i => 1793, ix => 1796, ixh => 1810, ixl => 1820, iy => 1830, iyh => 1844, iyl => 1854, l => 1864, lx => 1912, ly => 1922, r => 1932, sp => 1935, xh => 1947, xl => 1957, yh => 1967, yl => 1977, },
	# [1025] opcode : ld "("
	{ "!" => [ 15, 1026 ], "+" => [ 15, 1026 ], "-" => [ 15, 1026 ], __else__ => [ 15, 1026 ], bc => 1036, de => 1040, hl => 1044, ix => 1057, iy => 1101, "~" => [ 15, 1026 ], },
	# [1026] opcode : ld "(" "[expr_NN]"
	{ ")" => 1027, },
	# [1027] opcode : ld "(" "[expr_NN]" ")"
	{ "," => 1028, },
	# [1028] opcode : ld "(" "[expr_NN]" ")" ","
	{ a => 1029, bc => 1030, de => 1031, hl => 1032, ix => 1033, iy => 1034, sp => 1035, },
	# [1029] opcode : ld "(" "[expr_NN]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_311 ], ":" => [ 7, \&_action_opcode_311 ], },
	# [1030] opcode : ld "(" "[expr_NN]" ")" "," bc
	{ "\n" => [ 7, \&_action_opcode_312 ], ":" => [ 7, \&_action_opcode_312 ], },
	# [1031] opcode : ld "(" "[expr_NN]" ")" "," de
	{ "\n" => [ 7, \&_action_opcode_313 ], ":" => [ 7, \&_action_opcode_313 ], },
	# [1032] opcode : ld "(" "[expr_NN]" ")" "," hl
	{ "\n" => [ 7, \&_action_opcode_314 ], ":" => [ 7, \&_action_opcode_314 ], },
	# [1033] opcode : ld "(" "[expr_NN]" ")" "," ix
	{ "\n" => [ 7, \&_action_opcode_315 ], ":" => [ 7, \&_action_opcode_315 ], },
	# [1034] opcode : ld "(" "[expr_NN]" ")" "," iy
	{ "\n" => [ 7, \&_action_opcode_316 ], ":" => [ 7, \&_action_opcode_316 ], },
	# [1035] opcode : ld "(" "[expr_NN]" ")" "," sp
	{ "\n" => [ 7, \&_action_opcode_317 ], ":" => [ 7, \&_action_opcode_317 ], },
	# [1036] opcode : ld "(" bc
	{ ")" => 1037, },
	# [1037] opcode : ld "(" bc ")"
	{ "," => 1038, },
	# [1038] opcode : ld "(" bc ")" ","
	{ a => 1039, },
	# [1039] opcode : ld "(" bc ")" "," a
	{ "\n" => [ 7, \&_action_opcode_318 ], ":" => [ 7, \&_action_opcode_318 ], },
	# [1040] opcode : ld "(" de
	{ ")" => 1041, },
	# [1041] opcode : ld "(" de ")"
	{ "," => 1042, },
	# [1042] opcode : ld "(" de ")" ","
	{ a => 1043, },
	# [1043] opcode : ld "(" de ")" "," a
	{ "\n" => [ 7, \&_action_opcode_319 ], ":" => [ 7, \&_action_opcode_319 ], },
	# [1044] opcode : ld "(" hl
	{ ")" => 1045, },
	# [1045] opcode : ld "(" hl ")"
	{ "," => 1046, },
	# [1046] opcode : ld "(" hl ")" ","
	{ "!" => [ 13, 1047 ], "+" => [ 13, 1047 ], "-" => [ 13, 1047 ], __else__ => [ 13, 1047 ], a => 1048, b => 1049, bc => 1050, c => 1051, d => 1052, de => 1053, e => 1054, h => 1055, l => 1056, "~" => [ 13, 1047 ], },
	# [1047] opcode : ld "(" hl ")" "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_320 ], ":" => [ 7, \&_action_opcode_320 ], },
	# [1048] opcode : ld "(" hl ")" "," a
	{ "\n" => [ 7, \&_action_opcode_321 ], ":" => [ 7, \&_action_opcode_321 ], },
	# [1049] opcode : ld "(" hl ")" "," b
	{ "\n" => [ 7, \&_action_opcode_322 ], ":" => [ 7, \&_action_opcode_322 ], },
	# [1050] opcode : ld "(" hl ")" "," bc
	{ "\n" => [ 7, \&_action_opcode_323 ], ":" => [ 7, \&_action_opcode_323 ], },
	# [1051] opcode : ld "(" hl ")" "," c
	{ "\n" => [ 7, \&_action_opcode_324 ], ":" => [ 7, \&_action_opcode_324 ], },
	# [1052] opcode : ld "(" hl ")" "," d
	{ "\n" => [ 7, \&_action_opcode_325 ], ":" => [ 7, \&_action_opcode_325 ], },
	# [1053] opcode : ld "(" hl ")" "," de
	{ "\n" => [ 7, \&_action_opcode_326 ], ":" => [ 7, \&_action_opcode_326 ], },
	# [1054] opcode : ld "(" hl ")" "," e
	{ "\n" => [ 7, \&_action_opcode_327 ], ":" => [ 7, \&_action_opcode_327 ], },
	# [1055] opcode : ld "(" hl ")" "," h
	{ "\n" => [ 7, \&_action_opcode_328 ], ":" => [ 7, \&_action_opcode_328 ], },
	# [1056] opcode : ld "(" hl ")" "," l
	{ "\n" => [ 7, \&_action_opcode_329 ], ":" => [ 7, \&_action_opcode_329 ], },
	# [1057] opcode : ld "(" ix
	{ ")" => 1058, "+" => 1071, "-" => 1086, },
	# [1058] opcode : ld "(" ix ")"
	{ "," => 1059, },
	# [1059] opcode : ld "(" ix ")" ","
	{ "!" => [ 13, 1060 ], "+" => [ 13, 1060 ], "-" => [ 13, 1060 ], __else__ => [ 13, 1060 ], a => 1061, b => 1062, bc => 1063, c => 1064, d => 1065, de => 1066, e => 1067, h => 1068, hl => 1069, l => 1070, "~" => [ 13, 1060 ], },
	# [1060] opcode : ld "(" ix ")" "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_330 ], ":" => [ 7, \&_action_opcode_330 ], },
	# [1061] opcode : ld "(" ix ")" "," a
	{ "\n" => [ 7, \&_action_opcode_331 ], ":" => [ 7, \&_action_opcode_331 ], },
	# [1062] opcode : ld "(" ix ")" "," b
	{ "\n" => [ 7, \&_action_opcode_332 ], ":" => [ 7, \&_action_opcode_332 ], },
	# [1063] opcode : ld "(" ix ")" "," bc
	{ "\n" => [ 7, \&_action_opcode_333 ], ":" => [ 7, \&_action_opcode_333 ], },
	# [1064] opcode : ld "(" ix ")" "," c
	{ "\n" => [ 7, \&_action_opcode_334 ], ":" => [ 7, \&_action_opcode_334 ], },
	# [1065] opcode : ld "(" ix ")" "," d
	{ "\n" => [ 7, \&_action_opcode_335 ], ":" => [ 7, \&_action_opcode_335 ], },
	# [1066] opcode : ld "(" ix ")" "," de
	{ "\n" => [ 7, \&_action_opcode_336 ], ":" => [ 7, \&_action_opcode_336 ], },
	# [1067] opcode : ld "(" ix ")" "," e
	{ "\n" => [ 7, \&_action_opcode_337 ], ":" => [ 7, \&_action_opcode_337 ], },
	# [1068] opcode : ld "(" ix ")" "," h
	{ "\n" => [ 7, \&_action_opcode_338 ], ":" => [ 7, \&_action_opcode_338 ], },
	# [1069] opcode : ld "(" ix ")" "," hl
	{ "\n" => [ 7, \&_action_opcode_339 ], ":" => [ 7, \&_action_opcode_339 ], },
	# [1070] opcode : ld "(" ix ")" "," l
	{ "\n" => [ 7, \&_action_opcode_340 ], ":" => [ 7, \&_action_opcode_340 ], },
	# [1071] opcode : ld "(" ix "+"
	{ "!" => [ 12, 1072 ], "+" => [ 12, 1072 ], "-" => [ 12, 1072 ], __else__ => [ 12, 1072 ], "~" => [ 12, 1072 ], },
	# [1072] opcode : ld "(" ix "+" "[expr_DIS]"
	{ ")" => 1073, },
	# [1073] opcode : ld "(" ix "+" "[expr_DIS]" ")"
	{ "," => 1074, },
	# [1074] opcode : ld "(" ix "+" "[expr_DIS]" ")" ","
	{ "!" => [ 13, 1075 ], "+" => [ 13, 1075 ], "-" => [ 13, 1075 ], __else__ => [ 13, 1075 ], a => 1076, b => 1077, bc => 1078, c => 1079, d => 1080, de => 1081, e => 1082, h => 1083, hl => 1084, l => 1085, "~" => [ 13, 1075 ], },
	# [1075] opcode : ld "(" ix "+" "[expr_DIS]" ")" "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_341 ], ":" => [ 7, \&_action_opcode_341 ], },
	# [1076] opcode : ld "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_342 ], ":" => [ 7, \&_action_opcode_342 ], },
	# [1077] opcode : ld "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_343 ], ":" => [ 7, \&_action_opcode_343 ], },
	# [1078] opcode : ld "(" ix "+" "[expr_DIS]" ")" "," bc
	{ "\n" => [ 7, \&_action_opcode_344 ], ":" => [ 7, \&_action_opcode_344 ], },
	# [1079] opcode : ld "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_345 ], ":" => [ 7, \&_action_opcode_345 ], },
	# [1080] opcode : ld "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_346 ], ":" => [ 7, \&_action_opcode_346 ], },
	# [1081] opcode : ld "(" ix "+" "[expr_DIS]" ")" "," de
	{ "\n" => [ 7, \&_action_opcode_347 ], ":" => [ 7, \&_action_opcode_347 ], },
	# [1082] opcode : ld "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_348 ], ":" => [ 7, \&_action_opcode_348 ], },
	# [1083] opcode : ld "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_349 ], ":" => [ 7, \&_action_opcode_349 ], },
	# [1084] opcode : ld "(" ix "+" "[expr_DIS]" ")" "," hl
	{ "\n" => [ 7, \&_action_opcode_350 ], ":" => [ 7, \&_action_opcode_350 ], },
	# [1085] opcode : ld "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_351 ], ":" => [ 7, \&_action_opcode_351 ], },
	# [1086] opcode : ld "(" ix "-"
	{ "!" => [ 14, 1087 ], "+" => [ 14, 1087 ], "-" => [ 14, 1087 ], __else__ => [ 14, 1087 ], "~" => [ 14, 1087 ], },
	# [1087] opcode : ld "(" ix "-" "[expr_NDIS]"
	{ ")" => 1088, },
	# [1088] opcode : ld "(" ix "-" "[expr_NDIS]" ")"
	{ "," => 1089, },
	# [1089] opcode : ld "(" ix "-" "[expr_NDIS]" ")" ","
	{ "!" => [ 13, 1090 ], "+" => [ 13, 1090 ], "-" => [ 13, 1090 ], __else__ => [ 13, 1090 ], a => 1091, b => 1092, bc => 1093, c => 1094, d => 1095, de => 1096, e => 1097, h => 1098, hl => 1099, l => 1100, "~" => [ 13, 1090 ], },
	# [1090] opcode : ld "(" ix "-" "[expr_NDIS]" ")" "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_341 ], ":" => [ 7, \&_action_opcode_341 ], },
	# [1091] opcode : ld "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_342 ], ":" => [ 7, \&_action_opcode_342 ], },
	# [1092] opcode : ld "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_343 ], ":" => [ 7, \&_action_opcode_343 ], },
	# [1093] opcode : ld "(" ix "-" "[expr_NDIS]" ")" "," bc
	{ "\n" => [ 7, \&_action_opcode_344 ], ":" => [ 7, \&_action_opcode_344 ], },
	# [1094] opcode : ld "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_345 ], ":" => [ 7, \&_action_opcode_345 ], },
	# [1095] opcode : ld "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_346 ], ":" => [ 7, \&_action_opcode_346 ], },
	# [1096] opcode : ld "(" ix "-" "[expr_NDIS]" ")" "," de
	{ "\n" => [ 7, \&_action_opcode_347 ], ":" => [ 7, \&_action_opcode_347 ], },
	# [1097] opcode : ld "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_348 ], ":" => [ 7, \&_action_opcode_348 ], },
	# [1098] opcode : ld "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_349 ], ":" => [ 7, \&_action_opcode_349 ], },
	# [1099] opcode : ld "(" ix "-" "[expr_NDIS]" ")" "," hl
	{ "\n" => [ 7, \&_action_opcode_350 ], ":" => [ 7, \&_action_opcode_350 ], },
	# [1100] opcode : ld "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_351 ], ":" => [ 7, \&_action_opcode_351 ], },
	# [1101] opcode : ld "(" iy
	{ ")" => 1102, "+" => 1115, "-" => 1130, },
	# [1102] opcode : ld "(" iy ")"
	{ "," => 1103, },
	# [1103] opcode : ld "(" iy ")" ","
	{ "!" => [ 13, 1104 ], "+" => [ 13, 1104 ], "-" => [ 13, 1104 ], __else__ => [ 13, 1104 ], a => 1105, b => 1106, bc => 1107, c => 1108, d => 1109, de => 1110, e => 1111, h => 1112, hl => 1113, l => 1114, "~" => [ 13, 1104 ], },
	# [1104] opcode : ld "(" iy ")" "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_352 ], ":" => [ 7, \&_action_opcode_352 ], },
	# [1105] opcode : ld "(" iy ")" "," a
	{ "\n" => [ 7, \&_action_opcode_353 ], ":" => [ 7, \&_action_opcode_353 ], },
	# [1106] opcode : ld "(" iy ")" "," b
	{ "\n" => [ 7, \&_action_opcode_354 ], ":" => [ 7, \&_action_opcode_354 ], },
	# [1107] opcode : ld "(" iy ")" "," bc
	{ "\n" => [ 7, \&_action_opcode_355 ], ":" => [ 7, \&_action_opcode_355 ], },
	# [1108] opcode : ld "(" iy ")" "," c
	{ "\n" => [ 7, \&_action_opcode_356 ], ":" => [ 7, \&_action_opcode_356 ], },
	# [1109] opcode : ld "(" iy ")" "," d
	{ "\n" => [ 7, \&_action_opcode_357 ], ":" => [ 7, \&_action_opcode_357 ], },
	# [1110] opcode : ld "(" iy ")" "," de
	{ "\n" => [ 7, \&_action_opcode_358 ], ":" => [ 7, \&_action_opcode_358 ], },
	# [1111] opcode : ld "(" iy ")" "," e
	{ "\n" => [ 7, \&_action_opcode_359 ], ":" => [ 7, \&_action_opcode_359 ], },
	# [1112] opcode : ld "(" iy ")" "," h
	{ "\n" => [ 7, \&_action_opcode_360 ], ":" => [ 7, \&_action_opcode_360 ], },
	# [1113] opcode : ld "(" iy ")" "," hl
	{ "\n" => [ 7, \&_action_opcode_361 ], ":" => [ 7, \&_action_opcode_361 ], },
	# [1114] opcode : ld "(" iy ")" "," l
	{ "\n" => [ 7, \&_action_opcode_362 ], ":" => [ 7, \&_action_opcode_362 ], },
	# [1115] opcode : ld "(" iy "+"
	{ "!" => [ 12, 1116 ], "+" => [ 12, 1116 ], "-" => [ 12, 1116 ], __else__ => [ 12, 1116 ], "~" => [ 12, 1116 ], },
	# [1116] opcode : ld "(" iy "+" "[expr_DIS]"
	{ ")" => 1117, },
	# [1117] opcode : ld "(" iy "+" "[expr_DIS]" ")"
	{ "," => 1118, },
	# [1118] opcode : ld "(" iy "+" "[expr_DIS]" ")" ","
	{ "!" => [ 13, 1119 ], "+" => [ 13, 1119 ], "-" => [ 13, 1119 ], __else__ => [ 13, 1119 ], a => 1120, b => 1121, bc => 1122, c => 1123, d => 1124, de => 1125, e => 1126, h => 1127, hl => 1128, l => 1129, "~" => [ 13, 1119 ], },
	# [1119] opcode : ld "(" iy "+" "[expr_DIS]" ")" "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_363 ], ":" => [ 7, \&_action_opcode_363 ], },
	# [1120] opcode : ld "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_364 ], ":" => [ 7, \&_action_opcode_364 ], },
	# [1121] opcode : ld "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_365 ], ":" => [ 7, \&_action_opcode_365 ], },
	# [1122] opcode : ld "(" iy "+" "[expr_DIS]" ")" "," bc
	{ "\n" => [ 7, \&_action_opcode_366 ], ":" => [ 7, \&_action_opcode_366 ], },
	# [1123] opcode : ld "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_367 ], ":" => [ 7, \&_action_opcode_367 ], },
	# [1124] opcode : ld "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_368 ], ":" => [ 7, \&_action_opcode_368 ], },
	# [1125] opcode : ld "(" iy "+" "[expr_DIS]" ")" "," de
	{ "\n" => [ 7, \&_action_opcode_369 ], ":" => [ 7, \&_action_opcode_369 ], },
	# [1126] opcode : ld "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_370 ], ":" => [ 7, \&_action_opcode_370 ], },
	# [1127] opcode : ld "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_371 ], ":" => [ 7, \&_action_opcode_371 ], },
	# [1128] opcode : ld "(" iy "+" "[expr_DIS]" ")" "," hl
	{ "\n" => [ 7, \&_action_opcode_372 ], ":" => [ 7, \&_action_opcode_372 ], },
	# [1129] opcode : ld "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_373 ], ":" => [ 7, \&_action_opcode_373 ], },
	# [1130] opcode : ld "(" iy "-"
	{ "!" => [ 14, 1131 ], "+" => [ 14, 1131 ], "-" => [ 14, 1131 ], __else__ => [ 14, 1131 ], "~" => [ 14, 1131 ], },
	# [1131] opcode : ld "(" iy "-" "[expr_NDIS]"
	{ ")" => 1132, },
	# [1132] opcode : ld "(" iy "-" "[expr_NDIS]" ")"
	{ "," => 1133, },
	# [1133] opcode : ld "(" iy "-" "[expr_NDIS]" ")" ","
	{ "!" => [ 13, 1134 ], "+" => [ 13, 1134 ], "-" => [ 13, 1134 ], __else__ => [ 13, 1134 ], a => 1135, b => 1136, bc => 1137, c => 1138, d => 1139, de => 1140, e => 1141, h => 1142, hl => 1143, l => 1144, "~" => [ 13, 1134 ], },
	# [1134] opcode : ld "(" iy "-" "[expr_NDIS]" ")" "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_363 ], ":" => [ 7, \&_action_opcode_363 ], },
	# [1135] opcode : ld "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_364 ], ":" => [ 7, \&_action_opcode_364 ], },
	# [1136] opcode : ld "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_365 ], ":" => [ 7, \&_action_opcode_365 ], },
	# [1137] opcode : ld "(" iy "-" "[expr_NDIS]" ")" "," bc
	{ "\n" => [ 7, \&_action_opcode_366 ], ":" => [ 7, \&_action_opcode_366 ], },
	# [1138] opcode : ld "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_367 ], ":" => [ 7, \&_action_opcode_367 ], },
	# [1139] opcode : ld "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_368 ], ":" => [ 7, \&_action_opcode_368 ], },
	# [1140] opcode : ld "(" iy "-" "[expr_NDIS]" ")" "," de
	{ "\n" => [ 7, \&_action_opcode_369 ], ":" => [ 7, \&_action_opcode_369 ], },
	# [1141] opcode : ld "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_370 ], ":" => [ 7, \&_action_opcode_370 ], },
	# [1142] opcode : ld "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_371 ], ":" => [ 7, \&_action_opcode_371 ], },
	# [1143] opcode : ld "(" iy "-" "[expr_NDIS]" ")" "," hl
	{ "\n" => [ 7, \&_action_opcode_372 ], ":" => [ 7, \&_action_opcode_372 ], },
	# [1144] opcode : ld "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_373 ], ":" => [ 7, \&_action_opcode_373 ], },
	# [1145] opcode : ld "["
	{ "!" => [ 15, 1146 ], "+" => [ 15, 1146 ], "-" => [ 15, 1146 ], __else__ => [ 15, 1146 ], bc => 1156, de => 1160, hl => 1164, ix => 1177, iy => 1221, "~" => [ 15, 1146 ], },
	# [1146] opcode : ld "[" "[expr_NN]"
	{ "]" => 1147, },
	# [1147] opcode : ld "[" "[expr_NN]" "]"
	{ "," => 1148, },
	# [1148] opcode : ld "[" "[expr_NN]" "]" ","
	{ a => 1149, bc => 1150, de => 1151, hl => 1152, ix => 1153, iy => 1154, sp => 1155, },
	# [1149] opcode : ld "[" "[expr_NN]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_311 ], ":" => [ 7, \&_action_opcode_311 ], },
	# [1150] opcode : ld "[" "[expr_NN]" "]" "," bc
	{ "\n" => [ 7, \&_action_opcode_312 ], ":" => [ 7, \&_action_opcode_312 ], },
	# [1151] opcode : ld "[" "[expr_NN]" "]" "," de
	{ "\n" => [ 7, \&_action_opcode_313 ], ":" => [ 7, \&_action_opcode_313 ], },
	# [1152] opcode : ld "[" "[expr_NN]" "]" "," hl
	{ "\n" => [ 7, \&_action_opcode_314 ], ":" => [ 7, \&_action_opcode_314 ], },
	# [1153] opcode : ld "[" "[expr_NN]" "]" "," ix
	{ "\n" => [ 7, \&_action_opcode_315 ], ":" => [ 7, \&_action_opcode_315 ], },
	# [1154] opcode : ld "[" "[expr_NN]" "]" "," iy
	{ "\n" => [ 7, \&_action_opcode_316 ], ":" => [ 7, \&_action_opcode_316 ], },
	# [1155] opcode : ld "[" "[expr_NN]" "]" "," sp
	{ "\n" => [ 7, \&_action_opcode_317 ], ":" => [ 7, \&_action_opcode_317 ], },
	# [1156] opcode : ld "[" bc
	{ "]" => 1157, },
	# [1157] opcode : ld "[" bc "]"
	{ "," => 1158, },
	# [1158] opcode : ld "[" bc "]" ","
	{ a => 1159, },
	# [1159] opcode : ld "[" bc "]" "," a
	{ "\n" => [ 7, \&_action_opcode_318 ], ":" => [ 7, \&_action_opcode_318 ], },
	# [1160] opcode : ld "[" de
	{ "]" => 1161, },
	# [1161] opcode : ld "[" de "]"
	{ "," => 1162, },
	# [1162] opcode : ld "[" de "]" ","
	{ a => 1163, },
	# [1163] opcode : ld "[" de "]" "," a
	{ "\n" => [ 7, \&_action_opcode_319 ], ":" => [ 7, \&_action_opcode_319 ], },
	# [1164] opcode : ld "[" hl
	{ "]" => 1165, },
	# [1165] opcode : ld "[" hl "]"
	{ "," => 1166, },
	# [1166] opcode : ld "[" hl "]" ","
	{ "!" => [ 13, 1167 ], "+" => [ 13, 1167 ], "-" => [ 13, 1167 ], __else__ => [ 13, 1167 ], a => 1168, b => 1169, bc => 1170, c => 1171, d => 1172, de => 1173, e => 1174, h => 1175, l => 1176, "~" => [ 13, 1167 ], },
	# [1167] opcode : ld "[" hl "]" "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_320 ], ":" => [ 7, \&_action_opcode_320 ], },
	# [1168] opcode : ld "[" hl "]" "," a
	{ "\n" => [ 7, \&_action_opcode_321 ], ":" => [ 7, \&_action_opcode_321 ], },
	# [1169] opcode : ld "[" hl "]" "," b
	{ "\n" => [ 7, \&_action_opcode_322 ], ":" => [ 7, \&_action_opcode_322 ], },
	# [1170] opcode : ld "[" hl "]" "," bc
	{ "\n" => [ 7, \&_action_opcode_323 ], ":" => [ 7, \&_action_opcode_323 ], },
	# [1171] opcode : ld "[" hl "]" "," c
	{ "\n" => [ 7, \&_action_opcode_324 ], ":" => [ 7, \&_action_opcode_324 ], },
	# [1172] opcode : ld "[" hl "]" "," d
	{ "\n" => [ 7, \&_action_opcode_325 ], ":" => [ 7, \&_action_opcode_325 ], },
	# [1173] opcode : ld "[" hl "]" "," de
	{ "\n" => [ 7, \&_action_opcode_326 ], ":" => [ 7, \&_action_opcode_326 ], },
	# [1174] opcode : ld "[" hl "]" "," e
	{ "\n" => [ 7, \&_action_opcode_327 ], ":" => [ 7, \&_action_opcode_327 ], },
	# [1175] opcode : ld "[" hl "]" "," h
	{ "\n" => [ 7, \&_action_opcode_328 ], ":" => [ 7, \&_action_opcode_328 ], },
	# [1176] opcode : ld "[" hl "]" "," l
	{ "\n" => [ 7, \&_action_opcode_329 ], ":" => [ 7, \&_action_opcode_329 ], },
	# [1177] opcode : ld "[" ix
	{ "+" => 1178, "-" => 1193, "]" => 1208, },
	# [1178] opcode : ld "[" ix "+"
	{ "!" => [ 12, 1179 ], "+" => [ 12, 1179 ], "-" => [ 12, 1179 ], __else__ => [ 12, 1179 ], "~" => [ 12, 1179 ], },
	# [1179] opcode : ld "[" ix "+" "[expr_DIS]"
	{ "]" => 1180, },
	# [1180] opcode : ld "[" ix "+" "[expr_DIS]" "]"
	{ "," => 1181, },
	# [1181] opcode : ld "[" ix "+" "[expr_DIS]" "]" ","
	{ "!" => [ 13, 1182 ], "+" => [ 13, 1182 ], "-" => [ 13, 1182 ], __else__ => [ 13, 1182 ], a => 1183, b => 1184, bc => 1185, c => 1186, d => 1187, de => 1188, e => 1189, h => 1190, hl => 1191, l => 1192, "~" => [ 13, 1182 ], },
	# [1182] opcode : ld "[" ix "+" "[expr_DIS]" "]" "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_341 ], ":" => [ 7, \&_action_opcode_341 ], },
	# [1183] opcode : ld "[" ix "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_342 ], ":" => [ 7, \&_action_opcode_342 ], },
	# [1184] opcode : ld "[" ix "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_343 ], ":" => [ 7, \&_action_opcode_343 ], },
	# [1185] opcode : ld "[" ix "+" "[expr_DIS]" "]" "," bc
	{ "\n" => [ 7, \&_action_opcode_344 ], ":" => [ 7, \&_action_opcode_344 ], },
	# [1186] opcode : ld "[" ix "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_345 ], ":" => [ 7, \&_action_opcode_345 ], },
	# [1187] opcode : ld "[" ix "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_346 ], ":" => [ 7, \&_action_opcode_346 ], },
	# [1188] opcode : ld "[" ix "+" "[expr_DIS]" "]" "," de
	{ "\n" => [ 7, \&_action_opcode_347 ], ":" => [ 7, \&_action_opcode_347 ], },
	# [1189] opcode : ld "[" ix "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_348 ], ":" => [ 7, \&_action_opcode_348 ], },
	# [1190] opcode : ld "[" ix "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_349 ], ":" => [ 7, \&_action_opcode_349 ], },
	# [1191] opcode : ld "[" ix "+" "[expr_DIS]" "]" "," hl
	{ "\n" => [ 7, \&_action_opcode_350 ], ":" => [ 7, \&_action_opcode_350 ], },
	# [1192] opcode : ld "[" ix "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_351 ], ":" => [ 7, \&_action_opcode_351 ], },
	# [1193] opcode : ld "[" ix "-"
	{ "!" => [ 14, 1194 ], "+" => [ 14, 1194 ], "-" => [ 14, 1194 ], __else__ => [ 14, 1194 ], "~" => [ 14, 1194 ], },
	# [1194] opcode : ld "[" ix "-" "[expr_NDIS]"
	{ "]" => 1195, },
	# [1195] opcode : ld "[" ix "-" "[expr_NDIS]" "]"
	{ "," => 1196, },
	# [1196] opcode : ld "[" ix "-" "[expr_NDIS]" "]" ","
	{ "!" => [ 13, 1197 ], "+" => [ 13, 1197 ], "-" => [ 13, 1197 ], __else__ => [ 13, 1197 ], a => 1198, b => 1199, bc => 1200, c => 1201, d => 1202, de => 1203, e => 1204, h => 1205, hl => 1206, l => 1207, "~" => [ 13, 1197 ], },
	# [1197] opcode : ld "[" ix "-" "[expr_NDIS]" "]" "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_341 ], ":" => [ 7, \&_action_opcode_341 ], },
	# [1198] opcode : ld "[" ix "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_342 ], ":" => [ 7, \&_action_opcode_342 ], },
	# [1199] opcode : ld "[" ix "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_343 ], ":" => [ 7, \&_action_opcode_343 ], },
	# [1200] opcode : ld "[" ix "-" "[expr_NDIS]" "]" "," bc
	{ "\n" => [ 7, \&_action_opcode_344 ], ":" => [ 7, \&_action_opcode_344 ], },
	# [1201] opcode : ld "[" ix "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_345 ], ":" => [ 7, \&_action_opcode_345 ], },
	# [1202] opcode : ld "[" ix "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_346 ], ":" => [ 7, \&_action_opcode_346 ], },
	# [1203] opcode : ld "[" ix "-" "[expr_NDIS]" "]" "," de
	{ "\n" => [ 7, \&_action_opcode_347 ], ":" => [ 7, \&_action_opcode_347 ], },
	# [1204] opcode : ld "[" ix "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_348 ], ":" => [ 7, \&_action_opcode_348 ], },
	# [1205] opcode : ld "[" ix "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_349 ], ":" => [ 7, \&_action_opcode_349 ], },
	# [1206] opcode : ld "[" ix "-" "[expr_NDIS]" "]" "," hl
	{ "\n" => [ 7, \&_action_opcode_350 ], ":" => [ 7, \&_action_opcode_350 ], },
	# [1207] opcode : ld "[" ix "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_351 ], ":" => [ 7, \&_action_opcode_351 ], },
	# [1208] opcode : ld "[" ix "]"
	{ "," => 1209, },
	# [1209] opcode : ld "[" ix "]" ","
	{ "!" => [ 13, 1210 ], "+" => [ 13, 1210 ], "-" => [ 13, 1210 ], __else__ => [ 13, 1210 ], a => 1211, b => 1212, bc => 1213, c => 1214, d => 1215, de => 1216, e => 1217, h => 1218, hl => 1219, l => 1220, "~" => [ 13, 1210 ], },
	# [1210] opcode : ld "[" ix "]" "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_330 ], ":" => [ 7, \&_action_opcode_330 ], },
	# [1211] opcode : ld "[" ix "]" "," a
	{ "\n" => [ 7, \&_action_opcode_331 ], ":" => [ 7, \&_action_opcode_331 ], },
	# [1212] opcode : ld "[" ix "]" "," b
	{ "\n" => [ 7, \&_action_opcode_332 ], ":" => [ 7, \&_action_opcode_332 ], },
	# [1213] opcode : ld "[" ix "]" "," bc
	{ "\n" => [ 7, \&_action_opcode_333 ], ":" => [ 7, \&_action_opcode_333 ], },
	# [1214] opcode : ld "[" ix "]" "," c
	{ "\n" => [ 7, \&_action_opcode_334 ], ":" => [ 7, \&_action_opcode_334 ], },
	# [1215] opcode : ld "[" ix "]" "," d
	{ "\n" => [ 7, \&_action_opcode_335 ], ":" => [ 7, \&_action_opcode_335 ], },
	# [1216] opcode : ld "[" ix "]" "," de
	{ "\n" => [ 7, \&_action_opcode_336 ], ":" => [ 7, \&_action_opcode_336 ], },
	# [1217] opcode : ld "[" ix "]" "," e
	{ "\n" => [ 7, \&_action_opcode_337 ], ":" => [ 7, \&_action_opcode_337 ], },
	# [1218] opcode : ld "[" ix "]" "," h
	{ "\n" => [ 7, \&_action_opcode_338 ], ":" => [ 7, \&_action_opcode_338 ], },
	# [1219] opcode : ld "[" ix "]" "," hl
	{ "\n" => [ 7, \&_action_opcode_339 ], ":" => [ 7, \&_action_opcode_339 ], },
	# [1220] opcode : ld "[" ix "]" "," l
	{ "\n" => [ 7, \&_action_opcode_340 ], ":" => [ 7, \&_action_opcode_340 ], },
	# [1221] opcode : ld "[" iy
	{ "+" => 1222, "-" => 1237, "]" => 1252, },
	# [1222] opcode : ld "[" iy "+"
	{ "!" => [ 12, 1223 ], "+" => [ 12, 1223 ], "-" => [ 12, 1223 ], __else__ => [ 12, 1223 ], "~" => [ 12, 1223 ], },
	# [1223] opcode : ld "[" iy "+" "[expr_DIS]"
	{ "]" => 1224, },
	# [1224] opcode : ld "[" iy "+" "[expr_DIS]" "]"
	{ "," => 1225, },
	# [1225] opcode : ld "[" iy "+" "[expr_DIS]" "]" ","
	{ "!" => [ 13, 1226 ], "+" => [ 13, 1226 ], "-" => [ 13, 1226 ], __else__ => [ 13, 1226 ], a => 1227, b => 1228, bc => 1229, c => 1230, d => 1231, de => 1232, e => 1233, h => 1234, hl => 1235, l => 1236, "~" => [ 13, 1226 ], },
	# [1226] opcode : ld "[" iy "+" "[expr_DIS]" "]" "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_363 ], ":" => [ 7, \&_action_opcode_363 ], },
	# [1227] opcode : ld "[" iy "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_364 ], ":" => [ 7, \&_action_opcode_364 ], },
	# [1228] opcode : ld "[" iy "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_365 ], ":" => [ 7, \&_action_opcode_365 ], },
	# [1229] opcode : ld "[" iy "+" "[expr_DIS]" "]" "," bc
	{ "\n" => [ 7, \&_action_opcode_366 ], ":" => [ 7, \&_action_opcode_366 ], },
	# [1230] opcode : ld "[" iy "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_367 ], ":" => [ 7, \&_action_opcode_367 ], },
	# [1231] opcode : ld "[" iy "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_368 ], ":" => [ 7, \&_action_opcode_368 ], },
	# [1232] opcode : ld "[" iy "+" "[expr_DIS]" "]" "," de
	{ "\n" => [ 7, \&_action_opcode_369 ], ":" => [ 7, \&_action_opcode_369 ], },
	# [1233] opcode : ld "[" iy "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_370 ], ":" => [ 7, \&_action_opcode_370 ], },
	# [1234] opcode : ld "[" iy "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_371 ], ":" => [ 7, \&_action_opcode_371 ], },
	# [1235] opcode : ld "[" iy "+" "[expr_DIS]" "]" "," hl
	{ "\n" => [ 7, \&_action_opcode_372 ], ":" => [ 7, \&_action_opcode_372 ], },
	# [1236] opcode : ld "[" iy "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_373 ], ":" => [ 7, \&_action_opcode_373 ], },
	# [1237] opcode : ld "[" iy "-"
	{ "!" => [ 14, 1238 ], "+" => [ 14, 1238 ], "-" => [ 14, 1238 ], __else__ => [ 14, 1238 ], "~" => [ 14, 1238 ], },
	# [1238] opcode : ld "[" iy "-" "[expr_NDIS]"
	{ "]" => 1239, },
	# [1239] opcode : ld "[" iy "-" "[expr_NDIS]" "]"
	{ "," => 1240, },
	# [1240] opcode : ld "[" iy "-" "[expr_NDIS]" "]" ","
	{ "!" => [ 13, 1241 ], "+" => [ 13, 1241 ], "-" => [ 13, 1241 ], __else__ => [ 13, 1241 ], a => 1242, b => 1243, bc => 1244, c => 1245, d => 1246, de => 1247, e => 1248, h => 1249, hl => 1250, l => 1251, "~" => [ 13, 1241 ], },
	# [1241] opcode : ld "[" iy "-" "[expr_NDIS]" "]" "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_363 ], ":" => [ 7, \&_action_opcode_363 ], },
	# [1242] opcode : ld "[" iy "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_364 ], ":" => [ 7, \&_action_opcode_364 ], },
	# [1243] opcode : ld "[" iy "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_365 ], ":" => [ 7, \&_action_opcode_365 ], },
	# [1244] opcode : ld "[" iy "-" "[expr_NDIS]" "]" "," bc
	{ "\n" => [ 7, \&_action_opcode_366 ], ":" => [ 7, \&_action_opcode_366 ], },
	# [1245] opcode : ld "[" iy "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_367 ], ":" => [ 7, \&_action_opcode_367 ], },
	# [1246] opcode : ld "[" iy "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_368 ], ":" => [ 7, \&_action_opcode_368 ], },
	# [1247] opcode : ld "[" iy "-" "[expr_NDIS]" "]" "," de
	{ "\n" => [ 7, \&_action_opcode_369 ], ":" => [ 7, \&_action_opcode_369 ], },
	# [1248] opcode : ld "[" iy "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_370 ], ":" => [ 7, \&_action_opcode_370 ], },
	# [1249] opcode : ld "[" iy "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_371 ], ":" => [ 7, \&_action_opcode_371 ], },
	# [1250] opcode : ld "[" iy "-" "[expr_NDIS]" "]" "," hl
	{ "\n" => [ 7, \&_action_opcode_372 ], ":" => [ 7, \&_action_opcode_372 ], },
	# [1251] opcode : ld "[" iy "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_373 ], ":" => [ 7, \&_action_opcode_373 ], },
	# [1252] opcode : ld "[" iy "]"
	{ "," => 1253, },
	# [1253] opcode : ld "[" iy "]" ","
	{ "!" => [ 13, 1254 ], "+" => [ 13, 1254 ], "-" => [ 13, 1254 ], __else__ => [ 13, 1254 ], a => 1255, b => 1256, bc => 1257, c => 1258, d => 1259, de => 1260, e => 1261, h => 1262, hl => 1263, l => 1264, "~" => [ 13, 1254 ], },
	# [1254] opcode : ld "[" iy "]" "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_352 ], ":" => [ 7, \&_action_opcode_352 ], },
	# [1255] opcode : ld "[" iy "]" "," a
	{ "\n" => [ 7, \&_action_opcode_353 ], ":" => [ 7, \&_action_opcode_353 ], },
	# [1256] opcode : ld "[" iy "]" "," b
	{ "\n" => [ 7, \&_action_opcode_354 ], ":" => [ 7, \&_action_opcode_354 ], },
	# [1257] opcode : ld "[" iy "]" "," bc
	{ "\n" => [ 7, \&_action_opcode_355 ], ":" => [ 7, \&_action_opcode_355 ], },
	# [1258] opcode : ld "[" iy "]" "," c
	{ "\n" => [ 7, \&_action_opcode_356 ], ":" => [ 7, \&_action_opcode_356 ], },
	# [1259] opcode : ld "[" iy "]" "," d
	{ "\n" => [ 7, \&_action_opcode_357 ], ":" => [ 7, \&_action_opcode_357 ], },
	# [1260] opcode : ld "[" iy "]" "," de
	{ "\n" => [ 7, \&_action_opcode_358 ], ":" => [ 7, \&_action_opcode_358 ], },
	# [1261] opcode : ld "[" iy "]" "," e
	{ "\n" => [ 7, \&_action_opcode_359 ], ":" => [ 7, \&_action_opcode_359 ], },
	# [1262] opcode : ld "[" iy "]" "," h
	{ "\n" => [ 7, \&_action_opcode_360 ], ":" => [ 7, \&_action_opcode_360 ], },
	# [1263] opcode : ld "[" iy "]" "," hl
	{ "\n" => [ 7, \&_action_opcode_361 ], ":" => [ 7, \&_action_opcode_361 ], },
	# [1264] opcode : ld "[" iy "]" "," l
	{ "\n" => [ 7, \&_action_opcode_362 ], ":" => [ 7, \&_action_opcode_362 ], },
	# [1265] opcode : ld a
	{ "," => 1266, },
	# [1266] opcode : ld a ","
	{ "!" => [ 13, 1317 ], "(" => 1267, "+" => [ 13, 1317 ], "-" => [ 13, 1317 ], "[" => 1292, __else__ => [ 13, 1317 ], a => 1318, b => 1319, c => 1320, d => 1321, e => 1322, h => 1323, hx => 1324, hy => 1325, i => 1326, ixh => 1327, ixl => 1328, iyh => 1329, iyl => 1330, l => 1331, lx => 1332, ly => 1333, r => 1334, xh => 1335, xl => 1336, yh => 1337, yl => 1338, "~" => [ 13, 1317 ], },
	# [1267] opcode : ld a "," "("
	{ "!" => [ 15, 1268 ], "+" => [ 15, 1268 ], "-" => [ 15, 1268 ], __else__ => [ 15, 1268 ], bc => 1270, de => 1272, hl => 1274, ix => 1276, iy => 1284, "~" => [ 15, 1268 ], },
	# [1268] opcode : ld a "," "(" "[expr_NN]"
	{ ")" => 1269, },
	# [1269] opcode : ld a "," "(" "[expr_NN]" ")"
	{ "\n" => [ 7, \&_action_opcode_374 ], ":" => [ 7, \&_action_opcode_374 ], },
	# [1270] opcode : ld a "," "(" bc
	{ ")" => 1271, },
	# [1271] opcode : ld a "," "(" bc ")"
	{ "\n" => [ 7, \&_action_opcode_375 ], ":" => [ 7, \&_action_opcode_375 ], },
	# [1272] opcode : ld a "," "(" de
	{ ")" => 1273, },
	# [1273] opcode : ld a "," "(" de ")"
	{ "\n" => [ 7, \&_action_opcode_376 ], ":" => [ 7, \&_action_opcode_376 ], },
	# [1274] opcode : ld a "," "(" hl
	{ ")" => 1275, },
	# [1275] opcode : ld a "," "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_377 ], ":" => [ 7, \&_action_opcode_377 ], },
	# [1276] opcode : ld a "," "(" ix
	{ ")" => 1277, "+" => 1278, "-" => 1281, },
	# [1277] opcode : ld a "," "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_378 ], ":" => [ 7, \&_action_opcode_378 ], },
	# [1278] opcode : ld a "," "(" ix "+"
	{ "!" => [ 12, 1279 ], "+" => [ 12, 1279 ], "-" => [ 12, 1279 ], __else__ => [ 12, 1279 ], "~" => [ 12, 1279 ], },
	# [1279] opcode : ld a "," "(" ix "+" "[expr_DIS]"
	{ ")" => 1280, },
	# [1280] opcode : ld a "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_379 ], ":" => [ 7, \&_action_opcode_379 ], },
	# [1281] opcode : ld a "," "(" ix "-"
	{ "!" => [ 14, 1282 ], "+" => [ 14, 1282 ], "-" => [ 14, 1282 ], __else__ => [ 14, 1282 ], "~" => [ 14, 1282 ], },
	# [1282] opcode : ld a "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 1283, },
	# [1283] opcode : ld a "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_379 ], ":" => [ 7, \&_action_opcode_379 ], },
	# [1284] opcode : ld a "," "(" iy
	{ ")" => 1285, "+" => 1286, "-" => 1289, },
	# [1285] opcode : ld a "," "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_380 ], ":" => [ 7, \&_action_opcode_380 ], },
	# [1286] opcode : ld a "," "(" iy "+"
	{ "!" => [ 12, 1287 ], "+" => [ 12, 1287 ], "-" => [ 12, 1287 ], __else__ => [ 12, 1287 ], "~" => [ 12, 1287 ], },
	# [1287] opcode : ld a "," "(" iy "+" "[expr_DIS]"
	{ ")" => 1288, },
	# [1288] opcode : ld a "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_381 ], ":" => [ 7, \&_action_opcode_381 ], },
	# [1289] opcode : ld a "," "(" iy "-"
	{ "!" => [ 14, 1290 ], "+" => [ 14, 1290 ], "-" => [ 14, 1290 ], __else__ => [ 14, 1290 ], "~" => [ 14, 1290 ], },
	# [1290] opcode : ld a "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 1291, },
	# [1291] opcode : ld a "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_381 ], ":" => [ 7, \&_action_opcode_381 ], },
	# [1292] opcode : ld a "," "["
	{ "!" => [ 15, 1293 ], "+" => [ 15, 1293 ], "-" => [ 15, 1293 ], __else__ => [ 15, 1293 ], bc => 1295, de => 1297, hl => 1299, ix => 1301, iy => 1309, "~" => [ 15, 1293 ], },
	# [1293] opcode : ld a "," "[" "[expr_NN]"
	{ "]" => 1294, },
	# [1294] opcode : ld a "," "[" "[expr_NN]" "]"
	{ "\n" => [ 7, \&_action_opcode_374 ], ":" => [ 7, \&_action_opcode_374 ], },
	# [1295] opcode : ld a "," "[" bc
	{ "]" => 1296, },
	# [1296] opcode : ld a "," "[" bc "]"
	{ "\n" => [ 7, \&_action_opcode_375 ], ":" => [ 7, \&_action_opcode_375 ], },
	# [1297] opcode : ld a "," "[" de
	{ "]" => 1298, },
	# [1298] opcode : ld a "," "[" de "]"
	{ "\n" => [ 7, \&_action_opcode_376 ], ":" => [ 7, \&_action_opcode_376 ], },
	# [1299] opcode : ld a "," "[" hl
	{ "]" => 1300, },
	# [1300] opcode : ld a "," "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_377 ], ":" => [ 7, \&_action_opcode_377 ], },
	# [1301] opcode : ld a "," "[" ix
	{ "+" => 1302, "-" => 1305, "]" => 1308, },
	# [1302] opcode : ld a "," "[" ix "+"
	{ "!" => [ 12, 1303 ], "+" => [ 12, 1303 ], "-" => [ 12, 1303 ], __else__ => [ 12, 1303 ], "~" => [ 12, 1303 ], },
	# [1303] opcode : ld a "," "[" ix "+" "[expr_DIS]"
	{ "]" => 1304, },
	# [1304] opcode : ld a "," "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_379 ], ":" => [ 7, \&_action_opcode_379 ], },
	# [1305] opcode : ld a "," "[" ix "-"
	{ "!" => [ 14, 1306 ], "+" => [ 14, 1306 ], "-" => [ 14, 1306 ], __else__ => [ 14, 1306 ], "~" => [ 14, 1306 ], },
	# [1306] opcode : ld a "," "[" ix "-" "[expr_NDIS]"
	{ "]" => 1307, },
	# [1307] opcode : ld a "," "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_379 ], ":" => [ 7, \&_action_opcode_379 ], },
	# [1308] opcode : ld a "," "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_378 ], ":" => [ 7, \&_action_opcode_378 ], },
	# [1309] opcode : ld a "," "[" iy
	{ "+" => 1310, "-" => 1313, "]" => 1316, },
	# [1310] opcode : ld a "," "[" iy "+"
	{ "!" => [ 12, 1311 ], "+" => [ 12, 1311 ], "-" => [ 12, 1311 ], __else__ => [ 12, 1311 ], "~" => [ 12, 1311 ], },
	# [1311] opcode : ld a "," "[" iy "+" "[expr_DIS]"
	{ "]" => 1312, },
	# [1312] opcode : ld a "," "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_381 ], ":" => [ 7, \&_action_opcode_381 ], },
	# [1313] opcode : ld a "," "[" iy "-"
	{ "!" => [ 14, 1314 ], "+" => [ 14, 1314 ], "-" => [ 14, 1314 ], __else__ => [ 14, 1314 ], "~" => [ 14, 1314 ], },
	# [1314] opcode : ld a "," "[" iy "-" "[expr_NDIS]"
	{ "]" => 1315, },
	# [1315] opcode : ld a "," "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_381 ], ":" => [ 7, \&_action_opcode_381 ], },
	# [1316] opcode : ld a "," "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_380 ], ":" => [ 7, \&_action_opcode_380 ], },
	# [1317] opcode : ld a "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_382 ], ":" => [ 7, \&_action_opcode_382 ], },
	# [1318] opcode : ld a "," a
	{ "\n" => [ 7, \&_action_opcode_383 ], ":" => [ 7, \&_action_opcode_383 ], },
	# [1319] opcode : ld a "," b
	{ "\n" => [ 7, \&_action_opcode_384 ], ":" => [ 7, \&_action_opcode_384 ], },
	# [1320] opcode : ld a "," c
	{ "\n" => [ 7, \&_action_opcode_385 ], ":" => [ 7, \&_action_opcode_385 ], },
	# [1321] opcode : ld a "," d
	{ "\n" => [ 7, \&_action_opcode_386 ], ":" => [ 7, \&_action_opcode_386 ], },
	# [1322] opcode : ld a "," e
	{ "\n" => [ 7, \&_action_opcode_387 ], ":" => [ 7, \&_action_opcode_387 ], },
	# [1323] opcode : ld a "," h
	{ "\n" => [ 7, \&_action_opcode_388 ], ":" => [ 7, \&_action_opcode_388 ], },
	# [1324] opcode : ld a "," hx
	{ "\n" => [ 7, \&_action_opcode_389 ], ":" => [ 7, \&_action_opcode_389 ], },
	# [1325] opcode : ld a "," hy
	{ "\n" => [ 7, \&_action_opcode_390 ], ":" => [ 7, \&_action_opcode_390 ], },
	# [1326] opcode : ld a "," i
	{ "\n" => [ 7, \&_action_opcode_391 ], ":" => [ 7, \&_action_opcode_391 ], },
	# [1327] opcode : ld a "," ixh
	{ "\n" => [ 7, \&_action_opcode_389 ], ":" => [ 7, \&_action_opcode_389 ], },
	# [1328] opcode : ld a "," ixl
	{ "\n" => [ 7, \&_action_opcode_392 ], ":" => [ 7, \&_action_opcode_392 ], },
	# [1329] opcode : ld a "," iyh
	{ "\n" => [ 7, \&_action_opcode_390 ], ":" => [ 7, \&_action_opcode_390 ], },
	# [1330] opcode : ld a "," iyl
	{ "\n" => [ 7, \&_action_opcode_393 ], ":" => [ 7, \&_action_opcode_393 ], },
	# [1331] opcode : ld a "," l
	{ "\n" => [ 7, \&_action_opcode_394 ], ":" => [ 7, \&_action_opcode_394 ], },
	# [1332] opcode : ld a "," lx
	{ "\n" => [ 7, \&_action_opcode_392 ], ":" => [ 7, \&_action_opcode_392 ], },
	# [1333] opcode : ld a "," ly
	{ "\n" => [ 7, \&_action_opcode_393 ], ":" => [ 7, \&_action_opcode_393 ], },
	# [1334] opcode : ld a "," r
	{ "\n" => [ 7, \&_action_opcode_395 ], ":" => [ 7, \&_action_opcode_395 ], },
	# [1335] opcode : ld a "," xh
	{ "\n" => [ 7, \&_action_opcode_389 ], ":" => [ 7, \&_action_opcode_389 ], },
	# [1336] opcode : ld a "," xl
	{ "\n" => [ 7, \&_action_opcode_392 ], ":" => [ 7, \&_action_opcode_392 ], },
	# [1337] opcode : ld a "," yh
	{ "\n" => [ 7, \&_action_opcode_390 ], ":" => [ 7, \&_action_opcode_390 ], },
	# [1338] opcode : ld a "," yl
	{ "\n" => [ 7, \&_action_opcode_393 ], ":" => [ 7, \&_action_opcode_393 ], },
	# [1339] opcode : ld b
	{ "," => 1340, },
	# [1340] opcode : ld b ","
	{ "!" => [ 13, 1379 ], "(" => 1341, "+" => [ 13, 1379 ], "-" => [ 13, 1379 ], "[" => 1360, __else__ => [ 13, 1379 ], a => 1380, b => 1381, c => 1382, d => 1383, e => 1384, h => 1385, hx => 1386, hy => 1387, ixh => 1388, ixl => 1389, iyh => 1390, iyl => 1391, l => 1392, lx => 1393, ly => 1394, xh => 1395, xl => 1396, yh => 1397, yl => 1398, "~" => [ 13, 1379 ], },
	# [1341] opcode : ld b "," "("
	{ hl => 1342, ix => 1344, iy => 1352, },
	# [1342] opcode : ld b "," "(" hl
	{ ")" => 1343, },
	# [1343] opcode : ld b "," "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_396 ], ":" => [ 7, \&_action_opcode_396 ], },
	# [1344] opcode : ld b "," "(" ix
	{ ")" => 1345, "+" => 1346, "-" => 1349, },
	# [1345] opcode : ld b "," "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_397 ], ":" => [ 7, \&_action_opcode_397 ], },
	# [1346] opcode : ld b "," "(" ix "+"
	{ "!" => [ 12, 1347 ], "+" => [ 12, 1347 ], "-" => [ 12, 1347 ], __else__ => [ 12, 1347 ], "~" => [ 12, 1347 ], },
	# [1347] opcode : ld b "," "(" ix "+" "[expr_DIS]"
	{ ")" => 1348, },
	# [1348] opcode : ld b "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_398 ], ":" => [ 7, \&_action_opcode_398 ], },
	# [1349] opcode : ld b "," "(" ix "-"
	{ "!" => [ 14, 1350 ], "+" => [ 14, 1350 ], "-" => [ 14, 1350 ], __else__ => [ 14, 1350 ], "~" => [ 14, 1350 ], },
	# [1350] opcode : ld b "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 1351, },
	# [1351] opcode : ld b "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_398 ], ":" => [ 7, \&_action_opcode_398 ], },
	# [1352] opcode : ld b "," "(" iy
	{ ")" => 1353, "+" => 1354, "-" => 1357, },
	# [1353] opcode : ld b "," "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_399 ], ":" => [ 7, \&_action_opcode_399 ], },
	# [1354] opcode : ld b "," "(" iy "+"
	{ "!" => [ 12, 1355 ], "+" => [ 12, 1355 ], "-" => [ 12, 1355 ], __else__ => [ 12, 1355 ], "~" => [ 12, 1355 ], },
	# [1355] opcode : ld b "," "(" iy "+" "[expr_DIS]"
	{ ")" => 1356, },
	# [1356] opcode : ld b "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_400 ], ":" => [ 7, \&_action_opcode_400 ], },
	# [1357] opcode : ld b "," "(" iy "-"
	{ "!" => [ 14, 1358 ], "+" => [ 14, 1358 ], "-" => [ 14, 1358 ], __else__ => [ 14, 1358 ], "~" => [ 14, 1358 ], },
	# [1358] opcode : ld b "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 1359, },
	# [1359] opcode : ld b "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_400 ], ":" => [ 7, \&_action_opcode_400 ], },
	# [1360] opcode : ld b "," "["
	{ hl => 1361, ix => 1363, iy => 1371, },
	# [1361] opcode : ld b "," "[" hl
	{ "]" => 1362, },
	# [1362] opcode : ld b "," "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_396 ], ":" => [ 7, \&_action_opcode_396 ], },
	# [1363] opcode : ld b "," "[" ix
	{ "+" => 1364, "-" => 1367, "]" => 1370, },
	# [1364] opcode : ld b "," "[" ix "+"
	{ "!" => [ 12, 1365 ], "+" => [ 12, 1365 ], "-" => [ 12, 1365 ], __else__ => [ 12, 1365 ], "~" => [ 12, 1365 ], },
	# [1365] opcode : ld b "," "[" ix "+" "[expr_DIS]"
	{ "]" => 1366, },
	# [1366] opcode : ld b "," "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_398 ], ":" => [ 7, \&_action_opcode_398 ], },
	# [1367] opcode : ld b "," "[" ix "-"
	{ "!" => [ 14, 1368 ], "+" => [ 14, 1368 ], "-" => [ 14, 1368 ], __else__ => [ 14, 1368 ], "~" => [ 14, 1368 ], },
	# [1368] opcode : ld b "," "[" ix "-" "[expr_NDIS]"
	{ "]" => 1369, },
	# [1369] opcode : ld b "," "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_398 ], ":" => [ 7, \&_action_opcode_398 ], },
	# [1370] opcode : ld b "," "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_397 ], ":" => [ 7, \&_action_opcode_397 ], },
	# [1371] opcode : ld b "," "[" iy
	{ "+" => 1372, "-" => 1375, "]" => 1378, },
	# [1372] opcode : ld b "," "[" iy "+"
	{ "!" => [ 12, 1373 ], "+" => [ 12, 1373 ], "-" => [ 12, 1373 ], __else__ => [ 12, 1373 ], "~" => [ 12, 1373 ], },
	# [1373] opcode : ld b "," "[" iy "+" "[expr_DIS]"
	{ "]" => 1374, },
	# [1374] opcode : ld b "," "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_400 ], ":" => [ 7, \&_action_opcode_400 ], },
	# [1375] opcode : ld b "," "[" iy "-"
	{ "!" => [ 14, 1376 ], "+" => [ 14, 1376 ], "-" => [ 14, 1376 ], __else__ => [ 14, 1376 ], "~" => [ 14, 1376 ], },
	# [1376] opcode : ld b "," "[" iy "-" "[expr_NDIS]"
	{ "]" => 1377, },
	# [1377] opcode : ld b "," "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_400 ], ":" => [ 7, \&_action_opcode_400 ], },
	# [1378] opcode : ld b "," "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_399 ], ":" => [ 7, \&_action_opcode_399 ], },
	# [1379] opcode : ld b "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_401 ], ":" => [ 7, \&_action_opcode_401 ], },
	# [1380] opcode : ld b "," a
	{ "\n" => [ 7, \&_action_opcode_402 ], ":" => [ 7, \&_action_opcode_402 ], },
	# [1381] opcode : ld b "," b
	{ "\n" => [ 7, \&_action_opcode_403 ], ":" => [ 7, \&_action_opcode_403 ], },
	# [1382] opcode : ld b "," c
	{ "\n" => [ 7, \&_action_opcode_404 ], ":" => [ 7, \&_action_opcode_404 ], },
	# [1383] opcode : ld b "," d
	{ "\n" => [ 7, \&_action_opcode_405 ], ":" => [ 7, \&_action_opcode_405 ], },
	# [1384] opcode : ld b "," e
	{ "\n" => [ 7, \&_action_opcode_406 ], ":" => [ 7, \&_action_opcode_406 ], },
	# [1385] opcode : ld b "," h
	{ "\n" => [ 7, \&_action_opcode_407 ], ":" => [ 7, \&_action_opcode_407 ], },
	# [1386] opcode : ld b "," hx
	{ "\n" => [ 7, \&_action_opcode_408 ], ":" => [ 7, \&_action_opcode_408 ], },
	# [1387] opcode : ld b "," hy
	{ "\n" => [ 7, \&_action_opcode_409 ], ":" => [ 7, \&_action_opcode_409 ], },
	# [1388] opcode : ld b "," ixh
	{ "\n" => [ 7, \&_action_opcode_408 ], ":" => [ 7, \&_action_opcode_408 ], },
	# [1389] opcode : ld b "," ixl
	{ "\n" => [ 7, \&_action_opcode_410 ], ":" => [ 7, \&_action_opcode_410 ], },
	# [1390] opcode : ld b "," iyh
	{ "\n" => [ 7, \&_action_opcode_409 ], ":" => [ 7, \&_action_opcode_409 ], },
	# [1391] opcode : ld b "," iyl
	{ "\n" => [ 7, \&_action_opcode_411 ], ":" => [ 7, \&_action_opcode_411 ], },
	# [1392] opcode : ld b "," l
	{ "\n" => [ 7, \&_action_opcode_412 ], ":" => [ 7, \&_action_opcode_412 ], },
	# [1393] opcode : ld b "," lx
	{ "\n" => [ 7, \&_action_opcode_410 ], ":" => [ 7, \&_action_opcode_410 ], },
	# [1394] opcode : ld b "," ly
	{ "\n" => [ 7, \&_action_opcode_411 ], ":" => [ 7, \&_action_opcode_411 ], },
	# [1395] opcode : ld b "," xh
	{ "\n" => [ 7, \&_action_opcode_408 ], ":" => [ 7, \&_action_opcode_408 ], },
	# [1396] opcode : ld b "," xl
	{ "\n" => [ 7, \&_action_opcode_410 ], ":" => [ 7, \&_action_opcode_410 ], },
	# [1397] opcode : ld b "," yh
	{ "\n" => [ 7, \&_action_opcode_409 ], ":" => [ 7, \&_action_opcode_409 ], },
	# [1398] opcode : ld b "," yl
	{ "\n" => [ 7, \&_action_opcode_411 ], ":" => [ 7, \&_action_opcode_411 ], },
	# [1399] opcode : ld bc
	{ "," => 1400, },
	# [1400] opcode : ld bc ","
	{ "!" => [ 15, 1443 ], "(" => 1401, "+" => [ 15, 1443 ], "-" => [ 15, 1443 ], "[" => 1422, __else__ => [ 15, 1443 ], bc => 1444, de => 1445, hl => 1446, ix => 1447, iy => 1448, "~" => [ 15, 1443 ], },
	# [1401] opcode : ld bc "," "("
	{ "!" => [ 15, 1402 ], "+" => [ 15, 1402 ], "-" => [ 15, 1402 ], __else__ => [ 15, 1402 ], hl => 1404, ix => 1406, iy => 1414, "~" => [ 15, 1402 ], },
	# [1402] opcode : ld bc "," "(" "[expr_NN]"
	{ ")" => 1403, },
	# [1403] opcode : ld bc "," "(" "[expr_NN]" ")"
	{ "\n" => [ 7, \&_action_opcode_413 ], ":" => [ 7, \&_action_opcode_413 ], },
	# [1404] opcode : ld bc "," "(" hl
	{ ")" => 1405, },
	# [1405] opcode : ld bc "," "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_414 ], ":" => [ 7, \&_action_opcode_414 ], },
	# [1406] opcode : ld bc "," "(" ix
	{ ")" => 1407, "+" => 1408, "-" => 1411, },
	# [1407] opcode : ld bc "," "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_415 ], ":" => [ 7, \&_action_opcode_415 ], },
	# [1408] opcode : ld bc "," "(" ix "+"
	{ "!" => [ 12, 1409 ], "+" => [ 12, 1409 ], "-" => [ 12, 1409 ], __else__ => [ 12, 1409 ], "~" => [ 12, 1409 ], },
	# [1409] opcode : ld bc "," "(" ix "+" "[expr_DIS]"
	{ ")" => 1410, },
	# [1410] opcode : ld bc "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_416 ], ":" => [ 7, \&_action_opcode_416 ], },
	# [1411] opcode : ld bc "," "(" ix "-"
	{ "!" => [ 14, 1412 ], "+" => [ 14, 1412 ], "-" => [ 14, 1412 ], __else__ => [ 14, 1412 ], "~" => [ 14, 1412 ], },
	# [1412] opcode : ld bc "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 1413, },
	# [1413] opcode : ld bc "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_416 ], ":" => [ 7, \&_action_opcode_416 ], },
	# [1414] opcode : ld bc "," "(" iy
	{ ")" => 1415, "+" => 1416, "-" => 1419, },
	# [1415] opcode : ld bc "," "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_417 ], ":" => [ 7, \&_action_opcode_417 ], },
	# [1416] opcode : ld bc "," "(" iy "+"
	{ "!" => [ 12, 1417 ], "+" => [ 12, 1417 ], "-" => [ 12, 1417 ], __else__ => [ 12, 1417 ], "~" => [ 12, 1417 ], },
	# [1417] opcode : ld bc "," "(" iy "+" "[expr_DIS]"
	{ ")" => 1418, },
	# [1418] opcode : ld bc "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_418 ], ":" => [ 7, \&_action_opcode_418 ], },
	# [1419] opcode : ld bc "," "(" iy "-"
	{ "!" => [ 14, 1420 ], "+" => [ 14, 1420 ], "-" => [ 14, 1420 ], __else__ => [ 14, 1420 ], "~" => [ 14, 1420 ], },
	# [1420] opcode : ld bc "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 1421, },
	# [1421] opcode : ld bc "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_418 ], ":" => [ 7, \&_action_opcode_418 ], },
	# [1422] opcode : ld bc "," "["
	{ "!" => [ 15, 1423 ], "+" => [ 15, 1423 ], "-" => [ 15, 1423 ], __else__ => [ 15, 1423 ], hl => 1425, ix => 1427, iy => 1435, "~" => [ 15, 1423 ], },
	# [1423] opcode : ld bc "," "[" "[expr_NN]"
	{ "]" => 1424, },
	# [1424] opcode : ld bc "," "[" "[expr_NN]" "]"
	{ "\n" => [ 7, \&_action_opcode_413 ], ":" => [ 7, \&_action_opcode_413 ], },
	# [1425] opcode : ld bc "," "[" hl
	{ "]" => 1426, },
	# [1426] opcode : ld bc "," "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_414 ], ":" => [ 7, \&_action_opcode_414 ], },
	# [1427] opcode : ld bc "," "[" ix
	{ "+" => 1428, "-" => 1431, "]" => 1434, },
	# [1428] opcode : ld bc "," "[" ix "+"
	{ "!" => [ 12, 1429 ], "+" => [ 12, 1429 ], "-" => [ 12, 1429 ], __else__ => [ 12, 1429 ], "~" => [ 12, 1429 ], },
	# [1429] opcode : ld bc "," "[" ix "+" "[expr_DIS]"
	{ "]" => 1430, },
	# [1430] opcode : ld bc "," "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_416 ], ":" => [ 7, \&_action_opcode_416 ], },
	# [1431] opcode : ld bc "," "[" ix "-"
	{ "!" => [ 14, 1432 ], "+" => [ 14, 1432 ], "-" => [ 14, 1432 ], __else__ => [ 14, 1432 ], "~" => [ 14, 1432 ], },
	# [1432] opcode : ld bc "," "[" ix "-" "[expr_NDIS]"
	{ "]" => 1433, },
	# [1433] opcode : ld bc "," "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_416 ], ":" => [ 7, \&_action_opcode_416 ], },
	# [1434] opcode : ld bc "," "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_415 ], ":" => [ 7, \&_action_opcode_415 ], },
	# [1435] opcode : ld bc "," "[" iy
	{ "+" => 1436, "-" => 1439, "]" => 1442, },
	# [1436] opcode : ld bc "," "[" iy "+"
	{ "!" => [ 12, 1437 ], "+" => [ 12, 1437 ], "-" => [ 12, 1437 ], __else__ => [ 12, 1437 ], "~" => [ 12, 1437 ], },
	# [1437] opcode : ld bc "," "[" iy "+" "[expr_DIS]"
	{ "]" => 1438, },
	# [1438] opcode : ld bc "," "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_418 ], ":" => [ 7, \&_action_opcode_418 ], },
	# [1439] opcode : ld bc "," "[" iy "-"
	{ "!" => [ 14, 1440 ], "+" => [ 14, 1440 ], "-" => [ 14, 1440 ], __else__ => [ 14, 1440 ], "~" => [ 14, 1440 ], },
	# [1440] opcode : ld bc "," "[" iy "-" "[expr_NDIS]"
	{ "]" => 1441, },
	# [1441] opcode : ld bc "," "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_418 ], ":" => [ 7, \&_action_opcode_418 ], },
	# [1442] opcode : ld bc "," "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_417 ], ":" => [ 7, \&_action_opcode_417 ], },
	# [1443] opcode : ld bc "," "[expr_NN]"
	{ "\n" => [ 7, \&_action_opcode_419 ], ":" => [ 7, \&_action_opcode_419 ], },
	# [1444] opcode : ld bc "," bc
	{ "\n" => [ 7, \&_action_opcode_420 ], ":" => [ 7, \&_action_opcode_420 ], },
	# [1445] opcode : ld bc "," de
	{ "\n" => [ 7, \&_action_opcode_421 ], ":" => [ 7, \&_action_opcode_421 ], },
	# [1446] opcode : ld bc "," hl
	{ "\n" => [ 7, \&_action_opcode_422 ], ":" => [ 7, \&_action_opcode_422 ], },
	# [1447] opcode : ld bc "," ix
	{ "\n" => [ 7, \&_action_opcode_423 ], ":" => [ 7, \&_action_opcode_423 ], },
	# [1448] opcode : ld bc "," iy
	{ "\n" => [ 7, \&_action_opcode_424 ], ":" => [ 7, \&_action_opcode_424 ], },
	# [1449] opcode : ld c
	{ "," => 1450, },
	# [1450] opcode : ld c ","
	{ "!" => [ 13, 1489 ], "(" => 1451, "+" => [ 13, 1489 ], "-" => [ 13, 1489 ], "[" => 1470, __else__ => [ 13, 1489 ], a => 1490, b => 1491, c => 1492, d => 1493, e => 1494, h => 1495, hx => 1496, hy => 1497, ixh => 1498, ixl => 1499, iyh => 1500, iyl => 1501, l => 1502, lx => 1503, ly => 1504, xh => 1505, xl => 1506, yh => 1507, yl => 1508, "~" => [ 13, 1489 ], },
	# [1451] opcode : ld c "," "("
	{ hl => 1452, ix => 1454, iy => 1462, },
	# [1452] opcode : ld c "," "(" hl
	{ ")" => 1453, },
	# [1453] opcode : ld c "," "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_425 ], ":" => [ 7, \&_action_opcode_425 ], },
	# [1454] opcode : ld c "," "(" ix
	{ ")" => 1455, "+" => 1456, "-" => 1459, },
	# [1455] opcode : ld c "," "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_426 ], ":" => [ 7, \&_action_opcode_426 ], },
	# [1456] opcode : ld c "," "(" ix "+"
	{ "!" => [ 12, 1457 ], "+" => [ 12, 1457 ], "-" => [ 12, 1457 ], __else__ => [ 12, 1457 ], "~" => [ 12, 1457 ], },
	# [1457] opcode : ld c "," "(" ix "+" "[expr_DIS]"
	{ ")" => 1458, },
	# [1458] opcode : ld c "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_427 ], ":" => [ 7, \&_action_opcode_427 ], },
	# [1459] opcode : ld c "," "(" ix "-"
	{ "!" => [ 14, 1460 ], "+" => [ 14, 1460 ], "-" => [ 14, 1460 ], __else__ => [ 14, 1460 ], "~" => [ 14, 1460 ], },
	# [1460] opcode : ld c "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 1461, },
	# [1461] opcode : ld c "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_427 ], ":" => [ 7, \&_action_opcode_427 ], },
	# [1462] opcode : ld c "," "(" iy
	{ ")" => 1463, "+" => 1464, "-" => 1467, },
	# [1463] opcode : ld c "," "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_428 ], ":" => [ 7, \&_action_opcode_428 ], },
	# [1464] opcode : ld c "," "(" iy "+"
	{ "!" => [ 12, 1465 ], "+" => [ 12, 1465 ], "-" => [ 12, 1465 ], __else__ => [ 12, 1465 ], "~" => [ 12, 1465 ], },
	# [1465] opcode : ld c "," "(" iy "+" "[expr_DIS]"
	{ ")" => 1466, },
	# [1466] opcode : ld c "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_429 ], ":" => [ 7, \&_action_opcode_429 ], },
	# [1467] opcode : ld c "," "(" iy "-"
	{ "!" => [ 14, 1468 ], "+" => [ 14, 1468 ], "-" => [ 14, 1468 ], __else__ => [ 14, 1468 ], "~" => [ 14, 1468 ], },
	# [1468] opcode : ld c "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 1469, },
	# [1469] opcode : ld c "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_429 ], ":" => [ 7, \&_action_opcode_429 ], },
	# [1470] opcode : ld c "," "["
	{ hl => 1471, ix => 1473, iy => 1481, },
	# [1471] opcode : ld c "," "[" hl
	{ "]" => 1472, },
	# [1472] opcode : ld c "," "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_425 ], ":" => [ 7, \&_action_opcode_425 ], },
	# [1473] opcode : ld c "," "[" ix
	{ "+" => 1474, "-" => 1477, "]" => 1480, },
	# [1474] opcode : ld c "," "[" ix "+"
	{ "!" => [ 12, 1475 ], "+" => [ 12, 1475 ], "-" => [ 12, 1475 ], __else__ => [ 12, 1475 ], "~" => [ 12, 1475 ], },
	# [1475] opcode : ld c "," "[" ix "+" "[expr_DIS]"
	{ "]" => 1476, },
	# [1476] opcode : ld c "," "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_427 ], ":" => [ 7, \&_action_opcode_427 ], },
	# [1477] opcode : ld c "," "[" ix "-"
	{ "!" => [ 14, 1478 ], "+" => [ 14, 1478 ], "-" => [ 14, 1478 ], __else__ => [ 14, 1478 ], "~" => [ 14, 1478 ], },
	# [1478] opcode : ld c "," "[" ix "-" "[expr_NDIS]"
	{ "]" => 1479, },
	# [1479] opcode : ld c "," "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_427 ], ":" => [ 7, \&_action_opcode_427 ], },
	# [1480] opcode : ld c "," "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_426 ], ":" => [ 7, \&_action_opcode_426 ], },
	# [1481] opcode : ld c "," "[" iy
	{ "+" => 1482, "-" => 1485, "]" => 1488, },
	# [1482] opcode : ld c "," "[" iy "+"
	{ "!" => [ 12, 1483 ], "+" => [ 12, 1483 ], "-" => [ 12, 1483 ], __else__ => [ 12, 1483 ], "~" => [ 12, 1483 ], },
	# [1483] opcode : ld c "," "[" iy "+" "[expr_DIS]"
	{ "]" => 1484, },
	# [1484] opcode : ld c "," "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_429 ], ":" => [ 7, \&_action_opcode_429 ], },
	# [1485] opcode : ld c "," "[" iy "-"
	{ "!" => [ 14, 1486 ], "+" => [ 14, 1486 ], "-" => [ 14, 1486 ], __else__ => [ 14, 1486 ], "~" => [ 14, 1486 ], },
	# [1486] opcode : ld c "," "[" iy "-" "[expr_NDIS]"
	{ "]" => 1487, },
	# [1487] opcode : ld c "," "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_429 ], ":" => [ 7, \&_action_opcode_429 ], },
	# [1488] opcode : ld c "," "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_428 ], ":" => [ 7, \&_action_opcode_428 ], },
	# [1489] opcode : ld c "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_430 ], ":" => [ 7, \&_action_opcode_430 ], },
	# [1490] opcode : ld c "," a
	{ "\n" => [ 7, \&_action_opcode_431 ], ":" => [ 7, \&_action_opcode_431 ], },
	# [1491] opcode : ld c "," b
	{ "\n" => [ 7, \&_action_opcode_432 ], ":" => [ 7, \&_action_opcode_432 ], },
	# [1492] opcode : ld c "," c
	{ "\n" => [ 7, \&_action_opcode_433 ], ":" => [ 7, \&_action_opcode_433 ], },
	# [1493] opcode : ld c "," d
	{ "\n" => [ 7, \&_action_opcode_434 ], ":" => [ 7, \&_action_opcode_434 ], },
	# [1494] opcode : ld c "," e
	{ "\n" => [ 7, \&_action_opcode_435 ], ":" => [ 7, \&_action_opcode_435 ], },
	# [1495] opcode : ld c "," h
	{ "\n" => [ 7, \&_action_opcode_436 ], ":" => [ 7, \&_action_opcode_436 ], },
	# [1496] opcode : ld c "," hx
	{ "\n" => [ 7, \&_action_opcode_437 ], ":" => [ 7, \&_action_opcode_437 ], },
	# [1497] opcode : ld c "," hy
	{ "\n" => [ 7, \&_action_opcode_438 ], ":" => [ 7, \&_action_opcode_438 ], },
	# [1498] opcode : ld c "," ixh
	{ "\n" => [ 7, \&_action_opcode_437 ], ":" => [ 7, \&_action_opcode_437 ], },
	# [1499] opcode : ld c "," ixl
	{ "\n" => [ 7, \&_action_opcode_439 ], ":" => [ 7, \&_action_opcode_439 ], },
	# [1500] opcode : ld c "," iyh
	{ "\n" => [ 7, \&_action_opcode_438 ], ":" => [ 7, \&_action_opcode_438 ], },
	# [1501] opcode : ld c "," iyl
	{ "\n" => [ 7, \&_action_opcode_440 ], ":" => [ 7, \&_action_opcode_440 ], },
	# [1502] opcode : ld c "," l
	{ "\n" => [ 7, \&_action_opcode_441 ], ":" => [ 7, \&_action_opcode_441 ], },
	# [1503] opcode : ld c "," lx
	{ "\n" => [ 7, \&_action_opcode_439 ], ":" => [ 7, \&_action_opcode_439 ], },
	# [1504] opcode : ld c "," ly
	{ "\n" => [ 7, \&_action_opcode_440 ], ":" => [ 7, \&_action_opcode_440 ], },
	# [1505] opcode : ld c "," xh
	{ "\n" => [ 7, \&_action_opcode_437 ], ":" => [ 7, \&_action_opcode_437 ], },
	# [1506] opcode : ld c "," xl
	{ "\n" => [ 7, \&_action_opcode_439 ], ":" => [ 7, \&_action_opcode_439 ], },
	# [1507] opcode : ld c "," yh
	{ "\n" => [ 7, \&_action_opcode_438 ], ":" => [ 7, \&_action_opcode_438 ], },
	# [1508] opcode : ld c "," yl
	{ "\n" => [ 7, \&_action_opcode_440 ], ":" => [ 7, \&_action_opcode_440 ], },
	# [1509] opcode : ld d
	{ "," => 1510, },
	# [1510] opcode : ld d ","
	{ "!" => [ 13, 1549 ], "(" => 1511, "+" => [ 13, 1549 ], "-" => [ 13, 1549 ], "[" => 1530, __else__ => [ 13, 1549 ], a => 1550, b => 1551, c => 1552, d => 1553, e => 1554, h => 1555, hx => 1556, hy => 1557, ixh => 1558, ixl => 1559, iyh => 1560, iyl => 1561, l => 1562, lx => 1563, ly => 1564, xh => 1565, xl => 1566, yh => 1567, yl => 1568, "~" => [ 13, 1549 ], },
	# [1511] opcode : ld d "," "("
	{ hl => 1512, ix => 1514, iy => 1522, },
	# [1512] opcode : ld d "," "(" hl
	{ ")" => 1513, },
	# [1513] opcode : ld d "," "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_442 ], ":" => [ 7, \&_action_opcode_442 ], },
	# [1514] opcode : ld d "," "(" ix
	{ ")" => 1515, "+" => 1516, "-" => 1519, },
	# [1515] opcode : ld d "," "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_443 ], ":" => [ 7, \&_action_opcode_443 ], },
	# [1516] opcode : ld d "," "(" ix "+"
	{ "!" => [ 12, 1517 ], "+" => [ 12, 1517 ], "-" => [ 12, 1517 ], __else__ => [ 12, 1517 ], "~" => [ 12, 1517 ], },
	# [1517] opcode : ld d "," "(" ix "+" "[expr_DIS]"
	{ ")" => 1518, },
	# [1518] opcode : ld d "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_444 ], ":" => [ 7, \&_action_opcode_444 ], },
	# [1519] opcode : ld d "," "(" ix "-"
	{ "!" => [ 14, 1520 ], "+" => [ 14, 1520 ], "-" => [ 14, 1520 ], __else__ => [ 14, 1520 ], "~" => [ 14, 1520 ], },
	# [1520] opcode : ld d "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 1521, },
	# [1521] opcode : ld d "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_444 ], ":" => [ 7, \&_action_opcode_444 ], },
	# [1522] opcode : ld d "," "(" iy
	{ ")" => 1523, "+" => 1524, "-" => 1527, },
	# [1523] opcode : ld d "," "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_445 ], ":" => [ 7, \&_action_opcode_445 ], },
	# [1524] opcode : ld d "," "(" iy "+"
	{ "!" => [ 12, 1525 ], "+" => [ 12, 1525 ], "-" => [ 12, 1525 ], __else__ => [ 12, 1525 ], "~" => [ 12, 1525 ], },
	# [1525] opcode : ld d "," "(" iy "+" "[expr_DIS]"
	{ ")" => 1526, },
	# [1526] opcode : ld d "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_446 ], ":" => [ 7, \&_action_opcode_446 ], },
	# [1527] opcode : ld d "," "(" iy "-"
	{ "!" => [ 14, 1528 ], "+" => [ 14, 1528 ], "-" => [ 14, 1528 ], __else__ => [ 14, 1528 ], "~" => [ 14, 1528 ], },
	# [1528] opcode : ld d "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 1529, },
	# [1529] opcode : ld d "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_446 ], ":" => [ 7, \&_action_opcode_446 ], },
	# [1530] opcode : ld d "," "["
	{ hl => 1531, ix => 1533, iy => 1541, },
	# [1531] opcode : ld d "," "[" hl
	{ "]" => 1532, },
	# [1532] opcode : ld d "," "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_442 ], ":" => [ 7, \&_action_opcode_442 ], },
	# [1533] opcode : ld d "," "[" ix
	{ "+" => 1534, "-" => 1537, "]" => 1540, },
	# [1534] opcode : ld d "," "[" ix "+"
	{ "!" => [ 12, 1535 ], "+" => [ 12, 1535 ], "-" => [ 12, 1535 ], __else__ => [ 12, 1535 ], "~" => [ 12, 1535 ], },
	# [1535] opcode : ld d "," "[" ix "+" "[expr_DIS]"
	{ "]" => 1536, },
	# [1536] opcode : ld d "," "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_444 ], ":" => [ 7, \&_action_opcode_444 ], },
	# [1537] opcode : ld d "," "[" ix "-"
	{ "!" => [ 14, 1538 ], "+" => [ 14, 1538 ], "-" => [ 14, 1538 ], __else__ => [ 14, 1538 ], "~" => [ 14, 1538 ], },
	# [1538] opcode : ld d "," "[" ix "-" "[expr_NDIS]"
	{ "]" => 1539, },
	# [1539] opcode : ld d "," "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_444 ], ":" => [ 7, \&_action_opcode_444 ], },
	# [1540] opcode : ld d "," "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_443 ], ":" => [ 7, \&_action_opcode_443 ], },
	# [1541] opcode : ld d "," "[" iy
	{ "+" => 1542, "-" => 1545, "]" => 1548, },
	# [1542] opcode : ld d "," "[" iy "+"
	{ "!" => [ 12, 1543 ], "+" => [ 12, 1543 ], "-" => [ 12, 1543 ], __else__ => [ 12, 1543 ], "~" => [ 12, 1543 ], },
	# [1543] opcode : ld d "," "[" iy "+" "[expr_DIS]"
	{ "]" => 1544, },
	# [1544] opcode : ld d "," "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_446 ], ":" => [ 7, \&_action_opcode_446 ], },
	# [1545] opcode : ld d "," "[" iy "-"
	{ "!" => [ 14, 1546 ], "+" => [ 14, 1546 ], "-" => [ 14, 1546 ], __else__ => [ 14, 1546 ], "~" => [ 14, 1546 ], },
	# [1546] opcode : ld d "," "[" iy "-" "[expr_NDIS]"
	{ "]" => 1547, },
	# [1547] opcode : ld d "," "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_446 ], ":" => [ 7, \&_action_opcode_446 ], },
	# [1548] opcode : ld d "," "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_445 ], ":" => [ 7, \&_action_opcode_445 ], },
	# [1549] opcode : ld d "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_447 ], ":" => [ 7, \&_action_opcode_447 ], },
	# [1550] opcode : ld d "," a
	{ "\n" => [ 7, \&_action_opcode_448 ], ":" => [ 7, \&_action_opcode_448 ], },
	# [1551] opcode : ld d "," b
	{ "\n" => [ 7, \&_action_opcode_449 ], ":" => [ 7, \&_action_opcode_449 ], },
	# [1552] opcode : ld d "," c
	{ "\n" => [ 7, \&_action_opcode_450 ], ":" => [ 7, \&_action_opcode_450 ], },
	# [1553] opcode : ld d "," d
	{ "\n" => [ 7, \&_action_opcode_451 ], ":" => [ 7, \&_action_opcode_451 ], },
	# [1554] opcode : ld d "," e
	{ "\n" => [ 7, \&_action_opcode_452 ], ":" => [ 7, \&_action_opcode_452 ], },
	# [1555] opcode : ld d "," h
	{ "\n" => [ 7, \&_action_opcode_453 ], ":" => [ 7, \&_action_opcode_453 ], },
	# [1556] opcode : ld d "," hx
	{ "\n" => [ 7, \&_action_opcode_454 ], ":" => [ 7, \&_action_opcode_454 ], },
	# [1557] opcode : ld d "," hy
	{ "\n" => [ 7, \&_action_opcode_455 ], ":" => [ 7, \&_action_opcode_455 ], },
	# [1558] opcode : ld d "," ixh
	{ "\n" => [ 7, \&_action_opcode_454 ], ":" => [ 7, \&_action_opcode_454 ], },
	# [1559] opcode : ld d "," ixl
	{ "\n" => [ 7, \&_action_opcode_456 ], ":" => [ 7, \&_action_opcode_456 ], },
	# [1560] opcode : ld d "," iyh
	{ "\n" => [ 7, \&_action_opcode_455 ], ":" => [ 7, \&_action_opcode_455 ], },
	# [1561] opcode : ld d "," iyl
	{ "\n" => [ 7, \&_action_opcode_457 ], ":" => [ 7, \&_action_opcode_457 ], },
	# [1562] opcode : ld d "," l
	{ "\n" => [ 7, \&_action_opcode_458 ], ":" => [ 7, \&_action_opcode_458 ], },
	# [1563] opcode : ld d "," lx
	{ "\n" => [ 7, \&_action_opcode_456 ], ":" => [ 7, \&_action_opcode_456 ], },
	# [1564] opcode : ld d "," ly
	{ "\n" => [ 7, \&_action_opcode_457 ], ":" => [ 7, \&_action_opcode_457 ], },
	# [1565] opcode : ld d "," xh
	{ "\n" => [ 7, \&_action_opcode_454 ], ":" => [ 7, \&_action_opcode_454 ], },
	# [1566] opcode : ld d "," xl
	{ "\n" => [ 7, \&_action_opcode_456 ], ":" => [ 7, \&_action_opcode_456 ], },
	# [1567] opcode : ld d "," yh
	{ "\n" => [ 7, \&_action_opcode_455 ], ":" => [ 7, \&_action_opcode_455 ], },
	# [1568] opcode : ld d "," yl
	{ "\n" => [ 7, \&_action_opcode_457 ], ":" => [ 7, \&_action_opcode_457 ], },
	# [1569] opcode : ld de
	{ "," => 1570, },
	# [1570] opcode : ld de ","
	{ "!" => [ 15, 1613 ], "(" => 1571, "+" => [ 15, 1613 ], "-" => [ 15, 1613 ], "[" => 1592, __else__ => [ 15, 1613 ], bc => 1614, de => 1615, hl => 1616, ix => 1617, iy => 1618, "~" => [ 15, 1613 ], },
	# [1571] opcode : ld de "," "("
	{ "!" => [ 15, 1572 ], "+" => [ 15, 1572 ], "-" => [ 15, 1572 ], __else__ => [ 15, 1572 ], hl => 1574, ix => 1576, iy => 1584, "~" => [ 15, 1572 ], },
	# [1572] opcode : ld de "," "(" "[expr_NN]"
	{ ")" => 1573, },
	# [1573] opcode : ld de "," "(" "[expr_NN]" ")"
	{ "\n" => [ 7, \&_action_opcode_459 ], ":" => [ 7, \&_action_opcode_459 ], },
	# [1574] opcode : ld de "," "(" hl
	{ ")" => 1575, },
	# [1575] opcode : ld de "," "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_460 ], ":" => [ 7, \&_action_opcode_460 ], },
	# [1576] opcode : ld de "," "(" ix
	{ ")" => 1577, "+" => 1578, "-" => 1581, },
	# [1577] opcode : ld de "," "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_461 ], ":" => [ 7, \&_action_opcode_461 ], },
	# [1578] opcode : ld de "," "(" ix "+"
	{ "!" => [ 12, 1579 ], "+" => [ 12, 1579 ], "-" => [ 12, 1579 ], __else__ => [ 12, 1579 ], "~" => [ 12, 1579 ], },
	# [1579] opcode : ld de "," "(" ix "+" "[expr_DIS]"
	{ ")" => 1580, },
	# [1580] opcode : ld de "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_462 ], ":" => [ 7, \&_action_opcode_462 ], },
	# [1581] opcode : ld de "," "(" ix "-"
	{ "!" => [ 14, 1582 ], "+" => [ 14, 1582 ], "-" => [ 14, 1582 ], __else__ => [ 14, 1582 ], "~" => [ 14, 1582 ], },
	# [1582] opcode : ld de "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 1583, },
	# [1583] opcode : ld de "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_462 ], ":" => [ 7, \&_action_opcode_462 ], },
	# [1584] opcode : ld de "," "(" iy
	{ ")" => 1585, "+" => 1586, "-" => 1589, },
	# [1585] opcode : ld de "," "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_463 ], ":" => [ 7, \&_action_opcode_463 ], },
	# [1586] opcode : ld de "," "(" iy "+"
	{ "!" => [ 12, 1587 ], "+" => [ 12, 1587 ], "-" => [ 12, 1587 ], __else__ => [ 12, 1587 ], "~" => [ 12, 1587 ], },
	# [1587] opcode : ld de "," "(" iy "+" "[expr_DIS]"
	{ ")" => 1588, },
	# [1588] opcode : ld de "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_464 ], ":" => [ 7, \&_action_opcode_464 ], },
	# [1589] opcode : ld de "," "(" iy "-"
	{ "!" => [ 14, 1590 ], "+" => [ 14, 1590 ], "-" => [ 14, 1590 ], __else__ => [ 14, 1590 ], "~" => [ 14, 1590 ], },
	# [1590] opcode : ld de "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 1591, },
	# [1591] opcode : ld de "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_464 ], ":" => [ 7, \&_action_opcode_464 ], },
	# [1592] opcode : ld de "," "["
	{ "!" => [ 15, 1593 ], "+" => [ 15, 1593 ], "-" => [ 15, 1593 ], __else__ => [ 15, 1593 ], hl => 1595, ix => 1597, iy => 1605, "~" => [ 15, 1593 ], },
	# [1593] opcode : ld de "," "[" "[expr_NN]"
	{ "]" => 1594, },
	# [1594] opcode : ld de "," "[" "[expr_NN]" "]"
	{ "\n" => [ 7, \&_action_opcode_459 ], ":" => [ 7, \&_action_opcode_459 ], },
	# [1595] opcode : ld de "," "[" hl
	{ "]" => 1596, },
	# [1596] opcode : ld de "," "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_460 ], ":" => [ 7, \&_action_opcode_460 ], },
	# [1597] opcode : ld de "," "[" ix
	{ "+" => 1598, "-" => 1601, "]" => 1604, },
	# [1598] opcode : ld de "," "[" ix "+"
	{ "!" => [ 12, 1599 ], "+" => [ 12, 1599 ], "-" => [ 12, 1599 ], __else__ => [ 12, 1599 ], "~" => [ 12, 1599 ], },
	# [1599] opcode : ld de "," "[" ix "+" "[expr_DIS]"
	{ "]" => 1600, },
	# [1600] opcode : ld de "," "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_462 ], ":" => [ 7, \&_action_opcode_462 ], },
	# [1601] opcode : ld de "," "[" ix "-"
	{ "!" => [ 14, 1602 ], "+" => [ 14, 1602 ], "-" => [ 14, 1602 ], __else__ => [ 14, 1602 ], "~" => [ 14, 1602 ], },
	# [1602] opcode : ld de "," "[" ix "-" "[expr_NDIS]"
	{ "]" => 1603, },
	# [1603] opcode : ld de "," "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_462 ], ":" => [ 7, \&_action_opcode_462 ], },
	# [1604] opcode : ld de "," "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_461 ], ":" => [ 7, \&_action_opcode_461 ], },
	# [1605] opcode : ld de "," "[" iy
	{ "+" => 1606, "-" => 1609, "]" => 1612, },
	# [1606] opcode : ld de "," "[" iy "+"
	{ "!" => [ 12, 1607 ], "+" => [ 12, 1607 ], "-" => [ 12, 1607 ], __else__ => [ 12, 1607 ], "~" => [ 12, 1607 ], },
	# [1607] opcode : ld de "," "[" iy "+" "[expr_DIS]"
	{ "]" => 1608, },
	# [1608] opcode : ld de "," "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_464 ], ":" => [ 7, \&_action_opcode_464 ], },
	# [1609] opcode : ld de "," "[" iy "-"
	{ "!" => [ 14, 1610 ], "+" => [ 14, 1610 ], "-" => [ 14, 1610 ], __else__ => [ 14, 1610 ], "~" => [ 14, 1610 ], },
	# [1610] opcode : ld de "," "[" iy "-" "[expr_NDIS]"
	{ "]" => 1611, },
	# [1611] opcode : ld de "," "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_464 ], ":" => [ 7, \&_action_opcode_464 ], },
	# [1612] opcode : ld de "," "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_463 ], ":" => [ 7, \&_action_opcode_463 ], },
	# [1613] opcode : ld de "," "[expr_NN]"
	{ "\n" => [ 7, \&_action_opcode_465 ], ":" => [ 7, \&_action_opcode_465 ], },
	# [1614] opcode : ld de "," bc
	{ "\n" => [ 7, \&_action_opcode_466 ], ":" => [ 7, \&_action_opcode_466 ], },
	# [1615] opcode : ld de "," de
	{ "\n" => [ 7, \&_action_opcode_467 ], ":" => [ 7, \&_action_opcode_467 ], },
	# [1616] opcode : ld de "," hl
	{ "\n" => [ 7, \&_action_opcode_468 ], ":" => [ 7, \&_action_opcode_468 ], },
	# [1617] opcode : ld de "," ix
	{ "\n" => [ 7, \&_action_opcode_469 ], ":" => [ 7, \&_action_opcode_469 ], },
	# [1618] opcode : ld de "," iy
	{ "\n" => [ 7, \&_action_opcode_470 ], ":" => [ 7, \&_action_opcode_470 ], },
	# [1619] opcode : ld e
	{ "," => 1620, },
	# [1620] opcode : ld e ","
	{ "!" => [ 13, 1659 ], "(" => 1621, "+" => [ 13, 1659 ], "-" => [ 13, 1659 ], "[" => 1640, __else__ => [ 13, 1659 ], a => 1660, b => 1661, c => 1662, d => 1663, e => 1664, h => 1665, hx => 1666, hy => 1667, ixh => 1668, ixl => 1669, iyh => 1670, iyl => 1671, l => 1672, lx => 1673, ly => 1674, xh => 1675, xl => 1676, yh => 1677, yl => 1678, "~" => [ 13, 1659 ], },
	# [1621] opcode : ld e "," "("
	{ hl => 1622, ix => 1624, iy => 1632, },
	# [1622] opcode : ld e "," "(" hl
	{ ")" => 1623, },
	# [1623] opcode : ld e "," "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_471 ], ":" => [ 7, \&_action_opcode_471 ], },
	# [1624] opcode : ld e "," "(" ix
	{ ")" => 1625, "+" => 1626, "-" => 1629, },
	# [1625] opcode : ld e "," "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_472 ], ":" => [ 7, \&_action_opcode_472 ], },
	# [1626] opcode : ld e "," "(" ix "+"
	{ "!" => [ 12, 1627 ], "+" => [ 12, 1627 ], "-" => [ 12, 1627 ], __else__ => [ 12, 1627 ], "~" => [ 12, 1627 ], },
	# [1627] opcode : ld e "," "(" ix "+" "[expr_DIS]"
	{ ")" => 1628, },
	# [1628] opcode : ld e "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_473 ], ":" => [ 7, \&_action_opcode_473 ], },
	# [1629] opcode : ld e "," "(" ix "-"
	{ "!" => [ 14, 1630 ], "+" => [ 14, 1630 ], "-" => [ 14, 1630 ], __else__ => [ 14, 1630 ], "~" => [ 14, 1630 ], },
	# [1630] opcode : ld e "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 1631, },
	# [1631] opcode : ld e "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_473 ], ":" => [ 7, \&_action_opcode_473 ], },
	# [1632] opcode : ld e "," "(" iy
	{ ")" => 1633, "+" => 1634, "-" => 1637, },
	# [1633] opcode : ld e "," "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_474 ], ":" => [ 7, \&_action_opcode_474 ], },
	# [1634] opcode : ld e "," "(" iy "+"
	{ "!" => [ 12, 1635 ], "+" => [ 12, 1635 ], "-" => [ 12, 1635 ], __else__ => [ 12, 1635 ], "~" => [ 12, 1635 ], },
	# [1635] opcode : ld e "," "(" iy "+" "[expr_DIS]"
	{ ")" => 1636, },
	# [1636] opcode : ld e "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_475 ], ":" => [ 7, \&_action_opcode_475 ], },
	# [1637] opcode : ld e "," "(" iy "-"
	{ "!" => [ 14, 1638 ], "+" => [ 14, 1638 ], "-" => [ 14, 1638 ], __else__ => [ 14, 1638 ], "~" => [ 14, 1638 ], },
	# [1638] opcode : ld e "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 1639, },
	# [1639] opcode : ld e "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_475 ], ":" => [ 7, \&_action_opcode_475 ], },
	# [1640] opcode : ld e "," "["
	{ hl => 1641, ix => 1643, iy => 1651, },
	# [1641] opcode : ld e "," "[" hl
	{ "]" => 1642, },
	# [1642] opcode : ld e "," "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_471 ], ":" => [ 7, \&_action_opcode_471 ], },
	# [1643] opcode : ld e "," "[" ix
	{ "+" => 1644, "-" => 1647, "]" => 1650, },
	# [1644] opcode : ld e "," "[" ix "+"
	{ "!" => [ 12, 1645 ], "+" => [ 12, 1645 ], "-" => [ 12, 1645 ], __else__ => [ 12, 1645 ], "~" => [ 12, 1645 ], },
	# [1645] opcode : ld e "," "[" ix "+" "[expr_DIS]"
	{ "]" => 1646, },
	# [1646] opcode : ld e "," "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_473 ], ":" => [ 7, \&_action_opcode_473 ], },
	# [1647] opcode : ld e "," "[" ix "-"
	{ "!" => [ 14, 1648 ], "+" => [ 14, 1648 ], "-" => [ 14, 1648 ], __else__ => [ 14, 1648 ], "~" => [ 14, 1648 ], },
	# [1648] opcode : ld e "," "[" ix "-" "[expr_NDIS]"
	{ "]" => 1649, },
	# [1649] opcode : ld e "," "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_473 ], ":" => [ 7, \&_action_opcode_473 ], },
	# [1650] opcode : ld e "," "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_472 ], ":" => [ 7, \&_action_opcode_472 ], },
	# [1651] opcode : ld e "," "[" iy
	{ "+" => 1652, "-" => 1655, "]" => 1658, },
	# [1652] opcode : ld e "," "[" iy "+"
	{ "!" => [ 12, 1653 ], "+" => [ 12, 1653 ], "-" => [ 12, 1653 ], __else__ => [ 12, 1653 ], "~" => [ 12, 1653 ], },
	# [1653] opcode : ld e "," "[" iy "+" "[expr_DIS]"
	{ "]" => 1654, },
	# [1654] opcode : ld e "," "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_475 ], ":" => [ 7, \&_action_opcode_475 ], },
	# [1655] opcode : ld e "," "[" iy "-"
	{ "!" => [ 14, 1656 ], "+" => [ 14, 1656 ], "-" => [ 14, 1656 ], __else__ => [ 14, 1656 ], "~" => [ 14, 1656 ], },
	# [1656] opcode : ld e "," "[" iy "-" "[expr_NDIS]"
	{ "]" => 1657, },
	# [1657] opcode : ld e "," "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_475 ], ":" => [ 7, \&_action_opcode_475 ], },
	# [1658] opcode : ld e "," "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_474 ], ":" => [ 7, \&_action_opcode_474 ], },
	# [1659] opcode : ld e "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_476 ], ":" => [ 7, \&_action_opcode_476 ], },
	# [1660] opcode : ld e "," a
	{ "\n" => [ 7, \&_action_opcode_477 ], ":" => [ 7, \&_action_opcode_477 ], },
	# [1661] opcode : ld e "," b
	{ "\n" => [ 7, \&_action_opcode_478 ], ":" => [ 7, \&_action_opcode_478 ], },
	# [1662] opcode : ld e "," c
	{ "\n" => [ 7, \&_action_opcode_479 ], ":" => [ 7, \&_action_opcode_479 ], },
	# [1663] opcode : ld e "," d
	{ "\n" => [ 7, \&_action_opcode_480 ], ":" => [ 7, \&_action_opcode_480 ], },
	# [1664] opcode : ld e "," e
	{ "\n" => [ 7, \&_action_opcode_481 ], ":" => [ 7, \&_action_opcode_481 ], },
	# [1665] opcode : ld e "," h
	{ "\n" => [ 7, \&_action_opcode_482 ], ":" => [ 7, \&_action_opcode_482 ], },
	# [1666] opcode : ld e "," hx
	{ "\n" => [ 7, \&_action_opcode_483 ], ":" => [ 7, \&_action_opcode_483 ], },
	# [1667] opcode : ld e "," hy
	{ "\n" => [ 7, \&_action_opcode_484 ], ":" => [ 7, \&_action_opcode_484 ], },
	# [1668] opcode : ld e "," ixh
	{ "\n" => [ 7, \&_action_opcode_483 ], ":" => [ 7, \&_action_opcode_483 ], },
	# [1669] opcode : ld e "," ixl
	{ "\n" => [ 7, \&_action_opcode_485 ], ":" => [ 7, \&_action_opcode_485 ], },
	# [1670] opcode : ld e "," iyh
	{ "\n" => [ 7, \&_action_opcode_484 ], ":" => [ 7, \&_action_opcode_484 ], },
	# [1671] opcode : ld e "," iyl
	{ "\n" => [ 7, \&_action_opcode_486 ], ":" => [ 7, \&_action_opcode_486 ], },
	# [1672] opcode : ld e "," l
	{ "\n" => [ 7, \&_action_opcode_487 ], ":" => [ 7, \&_action_opcode_487 ], },
	# [1673] opcode : ld e "," lx
	{ "\n" => [ 7, \&_action_opcode_485 ], ":" => [ 7, \&_action_opcode_485 ], },
	# [1674] opcode : ld e "," ly
	{ "\n" => [ 7, \&_action_opcode_486 ], ":" => [ 7, \&_action_opcode_486 ], },
	# [1675] opcode : ld e "," xh
	{ "\n" => [ 7, \&_action_opcode_483 ], ":" => [ 7, \&_action_opcode_483 ], },
	# [1676] opcode : ld e "," xl
	{ "\n" => [ 7, \&_action_opcode_485 ], ":" => [ 7, \&_action_opcode_485 ], },
	# [1677] opcode : ld e "," yh
	{ "\n" => [ 7, \&_action_opcode_484 ], ":" => [ 7, \&_action_opcode_484 ], },
	# [1678] opcode : ld e "," yl
	{ "\n" => [ 7, \&_action_opcode_486 ], ":" => [ 7, \&_action_opcode_486 ], },
	# [1679] opcode : ld h
	{ "," => 1680, },
	# [1680] opcode : ld h ","
	{ "!" => [ 13, 1719 ], "(" => 1681, "+" => [ 13, 1719 ], "-" => [ 13, 1719 ], "[" => 1700, __else__ => [ 13, 1719 ], a => 1720, b => 1721, c => 1722, d => 1723, e => 1724, h => 1725, l => 1726, "~" => [ 13, 1719 ], },
	# [1681] opcode : ld h "," "("
	{ hl => 1682, ix => 1684, iy => 1692, },
	# [1682] opcode : ld h "," "(" hl
	{ ")" => 1683, },
	# [1683] opcode : ld h "," "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_488 ], ":" => [ 7, \&_action_opcode_488 ], },
	# [1684] opcode : ld h "," "(" ix
	{ ")" => 1685, "+" => 1686, "-" => 1689, },
	# [1685] opcode : ld h "," "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_489 ], ":" => [ 7, \&_action_opcode_489 ], },
	# [1686] opcode : ld h "," "(" ix "+"
	{ "!" => [ 12, 1687 ], "+" => [ 12, 1687 ], "-" => [ 12, 1687 ], __else__ => [ 12, 1687 ], "~" => [ 12, 1687 ], },
	# [1687] opcode : ld h "," "(" ix "+" "[expr_DIS]"
	{ ")" => 1688, },
	# [1688] opcode : ld h "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_490 ], ":" => [ 7, \&_action_opcode_490 ], },
	# [1689] opcode : ld h "," "(" ix "-"
	{ "!" => [ 14, 1690 ], "+" => [ 14, 1690 ], "-" => [ 14, 1690 ], __else__ => [ 14, 1690 ], "~" => [ 14, 1690 ], },
	# [1690] opcode : ld h "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 1691, },
	# [1691] opcode : ld h "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_490 ], ":" => [ 7, \&_action_opcode_490 ], },
	# [1692] opcode : ld h "," "(" iy
	{ ")" => 1693, "+" => 1694, "-" => 1697, },
	# [1693] opcode : ld h "," "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_491 ], ":" => [ 7, \&_action_opcode_491 ], },
	# [1694] opcode : ld h "," "(" iy "+"
	{ "!" => [ 12, 1695 ], "+" => [ 12, 1695 ], "-" => [ 12, 1695 ], __else__ => [ 12, 1695 ], "~" => [ 12, 1695 ], },
	# [1695] opcode : ld h "," "(" iy "+" "[expr_DIS]"
	{ ")" => 1696, },
	# [1696] opcode : ld h "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_492 ], ":" => [ 7, \&_action_opcode_492 ], },
	# [1697] opcode : ld h "," "(" iy "-"
	{ "!" => [ 14, 1698 ], "+" => [ 14, 1698 ], "-" => [ 14, 1698 ], __else__ => [ 14, 1698 ], "~" => [ 14, 1698 ], },
	# [1698] opcode : ld h "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 1699, },
	# [1699] opcode : ld h "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_492 ], ":" => [ 7, \&_action_opcode_492 ], },
	# [1700] opcode : ld h "," "["
	{ hl => 1701, ix => 1703, iy => 1711, },
	# [1701] opcode : ld h "," "[" hl
	{ "]" => 1702, },
	# [1702] opcode : ld h "," "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_488 ], ":" => [ 7, \&_action_opcode_488 ], },
	# [1703] opcode : ld h "," "[" ix
	{ "+" => 1704, "-" => 1707, "]" => 1710, },
	# [1704] opcode : ld h "," "[" ix "+"
	{ "!" => [ 12, 1705 ], "+" => [ 12, 1705 ], "-" => [ 12, 1705 ], __else__ => [ 12, 1705 ], "~" => [ 12, 1705 ], },
	# [1705] opcode : ld h "," "[" ix "+" "[expr_DIS]"
	{ "]" => 1706, },
	# [1706] opcode : ld h "," "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_490 ], ":" => [ 7, \&_action_opcode_490 ], },
	# [1707] opcode : ld h "," "[" ix "-"
	{ "!" => [ 14, 1708 ], "+" => [ 14, 1708 ], "-" => [ 14, 1708 ], __else__ => [ 14, 1708 ], "~" => [ 14, 1708 ], },
	# [1708] opcode : ld h "," "[" ix "-" "[expr_NDIS]"
	{ "]" => 1709, },
	# [1709] opcode : ld h "," "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_490 ], ":" => [ 7, \&_action_opcode_490 ], },
	# [1710] opcode : ld h "," "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_489 ], ":" => [ 7, \&_action_opcode_489 ], },
	# [1711] opcode : ld h "," "[" iy
	{ "+" => 1712, "-" => 1715, "]" => 1718, },
	# [1712] opcode : ld h "," "[" iy "+"
	{ "!" => [ 12, 1713 ], "+" => [ 12, 1713 ], "-" => [ 12, 1713 ], __else__ => [ 12, 1713 ], "~" => [ 12, 1713 ], },
	# [1713] opcode : ld h "," "[" iy "+" "[expr_DIS]"
	{ "]" => 1714, },
	# [1714] opcode : ld h "," "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_492 ], ":" => [ 7, \&_action_opcode_492 ], },
	# [1715] opcode : ld h "," "[" iy "-"
	{ "!" => [ 14, 1716 ], "+" => [ 14, 1716 ], "-" => [ 14, 1716 ], __else__ => [ 14, 1716 ], "~" => [ 14, 1716 ], },
	# [1716] opcode : ld h "," "[" iy "-" "[expr_NDIS]"
	{ "]" => 1717, },
	# [1717] opcode : ld h "," "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_492 ], ":" => [ 7, \&_action_opcode_492 ], },
	# [1718] opcode : ld h "," "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_491 ], ":" => [ 7, \&_action_opcode_491 ], },
	# [1719] opcode : ld h "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_493 ], ":" => [ 7, \&_action_opcode_493 ], },
	# [1720] opcode : ld h "," a
	{ "\n" => [ 7, \&_action_opcode_494 ], ":" => [ 7, \&_action_opcode_494 ], },
	# [1721] opcode : ld h "," b
	{ "\n" => [ 7, \&_action_opcode_495 ], ":" => [ 7, \&_action_opcode_495 ], },
	# [1722] opcode : ld h "," c
	{ "\n" => [ 7, \&_action_opcode_496 ], ":" => [ 7, \&_action_opcode_496 ], },
	# [1723] opcode : ld h "," d
	{ "\n" => [ 7, \&_action_opcode_497 ], ":" => [ 7, \&_action_opcode_497 ], },
	# [1724] opcode : ld h "," e
	{ "\n" => [ 7, \&_action_opcode_498 ], ":" => [ 7, \&_action_opcode_498 ], },
	# [1725] opcode : ld h "," h
	{ "\n" => [ 7, \&_action_opcode_499 ], ":" => [ 7, \&_action_opcode_499 ], },
	# [1726] opcode : ld h "," l
	{ "\n" => [ 7, \&_action_opcode_500 ], ":" => [ 7, \&_action_opcode_500 ], },
	# [1727] opcode : ld hl
	{ "," => 1728, },
	# [1728] opcode : ld hl ","
	{ "!" => [ 15, 1767 ], "(" => 1729, "+" => [ 15, 1767 ], "-" => [ 15, 1767 ], "[" => 1748, __else__ => [ 15, 1767 ], bc => 1768, de => 1769, hl => 1770, ix => 1771, iy => 1772, "~" => [ 15, 1767 ], },
	# [1729] opcode : ld hl "," "("
	{ "!" => [ 15, 1730 ], "+" => [ 15, 1730 ], "-" => [ 15, 1730 ], __else__ => [ 15, 1730 ], ix => 1732, iy => 1740, "~" => [ 15, 1730 ], },
	# [1730] opcode : ld hl "," "(" "[expr_NN]"
	{ ")" => 1731, },
	# [1731] opcode : ld hl "," "(" "[expr_NN]" ")"
	{ "\n" => [ 7, \&_action_opcode_501 ], ":" => [ 7, \&_action_opcode_501 ], },
	# [1732] opcode : ld hl "," "(" ix
	{ ")" => 1733, "+" => 1734, "-" => 1737, },
	# [1733] opcode : ld hl "," "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_502 ], ":" => [ 7, \&_action_opcode_502 ], },
	# [1734] opcode : ld hl "," "(" ix "+"
	{ "!" => [ 12, 1735 ], "+" => [ 12, 1735 ], "-" => [ 12, 1735 ], __else__ => [ 12, 1735 ], "~" => [ 12, 1735 ], },
	# [1735] opcode : ld hl "," "(" ix "+" "[expr_DIS]"
	{ ")" => 1736, },
	# [1736] opcode : ld hl "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_503 ], ":" => [ 7, \&_action_opcode_503 ], },
	# [1737] opcode : ld hl "," "(" ix "-"
	{ "!" => [ 14, 1738 ], "+" => [ 14, 1738 ], "-" => [ 14, 1738 ], __else__ => [ 14, 1738 ], "~" => [ 14, 1738 ], },
	# [1738] opcode : ld hl "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 1739, },
	# [1739] opcode : ld hl "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_503 ], ":" => [ 7, \&_action_opcode_503 ], },
	# [1740] opcode : ld hl "," "(" iy
	{ ")" => 1741, "+" => 1742, "-" => 1745, },
	# [1741] opcode : ld hl "," "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_504 ], ":" => [ 7, \&_action_opcode_504 ], },
	# [1742] opcode : ld hl "," "(" iy "+"
	{ "!" => [ 12, 1743 ], "+" => [ 12, 1743 ], "-" => [ 12, 1743 ], __else__ => [ 12, 1743 ], "~" => [ 12, 1743 ], },
	# [1743] opcode : ld hl "," "(" iy "+" "[expr_DIS]"
	{ ")" => 1744, },
	# [1744] opcode : ld hl "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_505 ], ":" => [ 7, \&_action_opcode_505 ], },
	# [1745] opcode : ld hl "," "(" iy "-"
	{ "!" => [ 14, 1746 ], "+" => [ 14, 1746 ], "-" => [ 14, 1746 ], __else__ => [ 14, 1746 ], "~" => [ 14, 1746 ], },
	# [1746] opcode : ld hl "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 1747, },
	# [1747] opcode : ld hl "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_505 ], ":" => [ 7, \&_action_opcode_505 ], },
	# [1748] opcode : ld hl "," "["
	{ "!" => [ 15, 1749 ], "+" => [ 15, 1749 ], "-" => [ 15, 1749 ], __else__ => [ 15, 1749 ], ix => 1751, iy => 1759, "~" => [ 15, 1749 ], },
	# [1749] opcode : ld hl "," "[" "[expr_NN]"
	{ "]" => 1750, },
	# [1750] opcode : ld hl "," "[" "[expr_NN]" "]"
	{ "\n" => [ 7, \&_action_opcode_501 ], ":" => [ 7, \&_action_opcode_501 ], },
	# [1751] opcode : ld hl "," "[" ix
	{ "+" => 1752, "-" => 1755, "]" => 1758, },
	# [1752] opcode : ld hl "," "[" ix "+"
	{ "!" => [ 12, 1753 ], "+" => [ 12, 1753 ], "-" => [ 12, 1753 ], __else__ => [ 12, 1753 ], "~" => [ 12, 1753 ], },
	# [1753] opcode : ld hl "," "[" ix "+" "[expr_DIS]"
	{ "]" => 1754, },
	# [1754] opcode : ld hl "," "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_503 ], ":" => [ 7, \&_action_opcode_503 ], },
	# [1755] opcode : ld hl "," "[" ix "-"
	{ "!" => [ 14, 1756 ], "+" => [ 14, 1756 ], "-" => [ 14, 1756 ], __else__ => [ 14, 1756 ], "~" => [ 14, 1756 ], },
	# [1756] opcode : ld hl "," "[" ix "-" "[expr_NDIS]"
	{ "]" => 1757, },
	# [1757] opcode : ld hl "," "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_503 ], ":" => [ 7, \&_action_opcode_503 ], },
	# [1758] opcode : ld hl "," "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_502 ], ":" => [ 7, \&_action_opcode_502 ], },
	# [1759] opcode : ld hl "," "[" iy
	{ "+" => 1760, "-" => 1763, "]" => 1766, },
	# [1760] opcode : ld hl "," "[" iy "+"
	{ "!" => [ 12, 1761 ], "+" => [ 12, 1761 ], "-" => [ 12, 1761 ], __else__ => [ 12, 1761 ], "~" => [ 12, 1761 ], },
	# [1761] opcode : ld hl "," "[" iy "+" "[expr_DIS]"
	{ "]" => 1762, },
	# [1762] opcode : ld hl "," "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_505 ], ":" => [ 7, \&_action_opcode_505 ], },
	# [1763] opcode : ld hl "," "[" iy "-"
	{ "!" => [ 14, 1764 ], "+" => [ 14, 1764 ], "-" => [ 14, 1764 ], __else__ => [ 14, 1764 ], "~" => [ 14, 1764 ], },
	# [1764] opcode : ld hl "," "[" iy "-" "[expr_NDIS]"
	{ "]" => 1765, },
	# [1765] opcode : ld hl "," "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_505 ], ":" => [ 7, \&_action_opcode_505 ], },
	# [1766] opcode : ld hl "," "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_504 ], ":" => [ 7, \&_action_opcode_504 ], },
	# [1767] opcode : ld hl "," "[expr_NN]"
	{ "\n" => [ 7, \&_action_opcode_506 ], ":" => [ 7, \&_action_opcode_506 ], },
	# [1768] opcode : ld hl "," bc
	{ "\n" => [ 7, \&_action_opcode_507 ], ":" => [ 7, \&_action_opcode_507 ], },
	# [1769] opcode : ld hl "," de
	{ "\n" => [ 7, \&_action_opcode_508 ], ":" => [ 7, \&_action_opcode_508 ], },
	# [1770] opcode : ld hl "," hl
	{ "\n" => [ 7, \&_action_opcode_509 ], ":" => [ 7, \&_action_opcode_509 ], },
	# [1771] opcode : ld hl "," ix
	{ "\n" => [ 7, \&_action_opcode_510 ], ":" => [ 7, \&_action_opcode_510 ], },
	# [1772] opcode : ld hl "," iy
	{ "\n" => [ 7, \&_action_opcode_511 ], ":" => [ 7, \&_action_opcode_511 ], },
	# [1773] opcode : ld hx
	{ "," => 1774, },
	# [1774] opcode : ld hx ","
	{ "!" => [ 13, 1775 ], "+" => [ 13, 1775 ], "-" => [ 13, 1775 ], __else__ => [ 13, 1775 ], a => 1776, b => 1777, c => 1778, d => 1779, e => 1780, hx => 1781, lx => 1782, "~" => [ 13, 1775 ], },
	# [1775] opcode : ld hx "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_512 ], ":" => [ 7, \&_action_opcode_512 ], },
	# [1776] opcode : ld hx "," a
	{ "\n" => [ 7, \&_action_opcode_513 ], ":" => [ 7, \&_action_opcode_513 ], },
	# [1777] opcode : ld hx "," b
	{ "\n" => [ 7, \&_action_opcode_514 ], ":" => [ 7, \&_action_opcode_514 ], },
	# [1778] opcode : ld hx "," c
	{ "\n" => [ 7, \&_action_opcode_515 ], ":" => [ 7, \&_action_opcode_515 ], },
	# [1779] opcode : ld hx "," d
	{ "\n" => [ 7, \&_action_opcode_516 ], ":" => [ 7, \&_action_opcode_516 ], },
	# [1780] opcode : ld hx "," e
	{ "\n" => [ 7, \&_action_opcode_517 ], ":" => [ 7, \&_action_opcode_517 ], },
	# [1781] opcode : ld hx "," hx
	{ "\n" => [ 7, \&_action_opcode_518 ], ":" => [ 7, \&_action_opcode_518 ], },
	# [1782] opcode : ld hx "," lx
	{ "\n" => [ 7, \&_action_opcode_519 ], ":" => [ 7, \&_action_opcode_519 ], },
	# [1783] opcode : ld hy
	{ "," => 1784, },
	# [1784] opcode : ld hy ","
	{ "!" => [ 13, 1785 ], "+" => [ 13, 1785 ], "-" => [ 13, 1785 ], __else__ => [ 13, 1785 ], a => 1786, b => 1787, c => 1788, d => 1789, e => 1790, hy => 1791, ly => 1792, "~" => [ 13, 1785 ], },
	# [1785] opcode : ld hy "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_520 ], ":" => [ 7, \&_action_opcode_520 ], },
	# [1786] opcode : ld hy "," a
	{ "\n" => [ 7, \&_action_opcode_521 ], ":" => [ 7, \&_action_opcode_521 ], },
	# [1787] opcode : ld hy "," b
	{ "\n" => [ 7, \&_action_opcode_522 ], ":" => [ 7, \&_action_opcode_522 ], },
	# [1788] opcode : ld hy "," c
	{ "\n" => [ 7, \&_action_opcode_523 ], ":" => [ 7, \&_action_opcode_523 ], },
	# [1789] opcode : ld hy "," d
	{ "\n" => [ 7, \&_action_opcode_524 ], ":" => [ 7, \&_action_opcode_524 ], },
	# [1790] opcode : ld hy "," e
	{ "\n" => [ 7, \&_action_opcode_525 ], ":" => [ 7, \&_action_opcode_525 ], },
	# [1791] opcode : ld hy "," hy
	{ "\n" => [ 7, \&_action_opcode_526 ], ":" => [ 7, \&_action_opcode_526 ], },
	# [1792] opcode : ld hy "," ly
	{ "\n" => [ 7, \&_action_opcode_527 ], ":" => [ 7, \&_action_opcode_527 ], },
	# [1793] opcode : ld i
	{ "," => 1794, },
	# [1794] opcode : ld i ","
	{ a => 1795, },
	# [1795] opcode : ld i "," a
	{ "\n" => [ 7, \&_action_opcode_528 ], ":" => [ 7, \&_action_opcode_528 ], },
	# [1796] opcode : ld ix
	{ "," => 1797, },
	# [1797] opcode : ld ix ","
	{ "!" => [ 15, 1804 ], "(" => 1798, "+" => [ 15, 1804 ], "-" => [ 15, 1804 ], "[" => 1801, __else__ => [ 15, 1804 ], bc => 1805, de => 1806, hl => 1807, ix => 1808, iy => 1809, "~" => [ 15, 1804 ], },
	# [1798] opcode : ld ix "," "("
	{ "!" => [ 15, 1799 ], "+" => [ 15, 1799 ], "-" => [ 15, 1799 ], __else__ => [ 15, 1799 ], "~" => [ 15, 1799 ], },
	# [1799] opcode : ld ix "," "(" "[expr_NN]"
	{ ")" => 1800, },
	# [1800] opcode : ld ix "," "(" "[expr_NN]" ")"
	{ "\n" => [ 7, \&_action_opcode_529 ], ":" => [ 7, \&_action_opcode_529 ], },
	# [1801] opcode : ld ix "," "["
	{ "!" => [ 15, 1802 ], "+" => [ 15, 1802 ], "-" => [ 15, 1802 ], __else__ => [ 15, 1802 ], "~" => [ 15, 1802 ], },
	# [1802] opcode : ld ix "," "[" "[expr_NN]"
	{ "]" => 1803, },
	# [1803] opcode : ld ix "," "[" "[expr_NN]" "]"
	{ "\n" => [ 7, \&_action_opcode_529 ], ":" => [ 7, \&_action_opcode_529 ], },
	# [1804] opcode : ld ix "," "[expr_NN]"
	{ "\n" => [ 7, \&_action_opcode_530 ], ":" => [ 7, \&_action_opcode_530 ], },
	# [1805] opcode : ld ix "," bc
	{ "\n" => [ 7, \&_action_opcode_531 ], ":" => [ 7, \&_action_opcode_531 ], },
	# [1806] opcode : ld ix "," de
	{ "\n" => [ 7, \&_action_opcode_532 ], ":" => [ 7, \&_action_opcode_532 ], },
	# [1807] opcode : ld ix "," hl
	{ "\n" => [ 7, \&_action_opcode_533 ], ":" => [ 7, \&_action_opcode_533 ], },
	# [1808] opcode : ld ix "," ix
	{ "\n" => [ 7, \&_action_opcode_534 ], ":" => [ 7, \&_action_opcode_534 ], },
	# [1809] opcode : ld ix "," iy
	{ "\n" => [ 7, \&_action_opcode_535 ], ":" => [ 7, \&_action_opcode_535 ], },
	# [1810] opcode : ld ixh
	{ "," => 1811, },
	# [1811] opcode : ld ixh ","
	{ "!" => [ 13, 1812 ], "+" => [ 13, 1812 ], "-" => [ 13, 1812 ], __else__ => [ 13, 1812 ], a => 1813, b => 1814, c => 1815, d => 1816, e => 1817, ixh => 1818, ixl => 1819, "~" => [ 13, 1812 ], },
	# [1812] opcode : ld ixh "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_512 ], ":" => [ 7, \&_action_opcode_512 ], },
	# [1813] opcode : ld ixh "," a
	{ "\n" => [ 7, \&_action_opcode_513 ], ":" => [ 7, \&_action_opcode_513 ], },
	# [1814] opcode : ld ixh "," b
	{ "\n" => [ 7, \&_action_opcode_514 ], ":" => [ 7, \&_action_opcode_514 ], },
	# [1815] opcode : ld ixh "," c
	{ "\n" => [ 7, \&_action_opcode_515 ], ":" => [ 7, \&_action_opcode_515 ], },
	# [1816] opcode : ld ixh "," d
	{ "\n" => [ 7, \&_action_opcode_516 ], ":" => [ 7, \&_action_opcode_516 ], },
	# [1817] opcode : ld ixh "," e
	{ "\n" => [ 7, \&_action_opcode_517 ], ":" => [ 7, \&_action_opcode_517 ], },
	# [1818] opcode : ld ixh "," ixh
	{ "\n" => [ 7, \&_action_opcode_518 ], ":" => [ 7, \&_action_opcode_518 ], },
	# [1819] opcode : ld ixh "," ixl
	{ "\n" => [ 7, \&_action_opcode_519 ], ":" => [ 7, \&_action_opcode_519 ], },
	# [1820] opcode : ld ixl
	{ "," => 1821, },
	# [1821] opcode : ld ixl ","
	{ "!" => [ 13, 1822 ], "+" => [ 13, 1822 ], "-" => [ 13, 1822 ], __else__ => [ 13, 1822 ], a => 1823, b => 1824, c => 1825, d => 1826, e => 1827, ixh => 1828, ixl => 1829, "~" => [ 13, 1822 ], },
	# [1822] opcode : ld ixl "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_536 ], ":" => [ 7, \&_action_opcode_536 ], },
	# [1823] opcode : ld ixl "," a
	{ "\n" => [ 7, \&_action_opcode_537 ], ":" => [ 7, \&_action_opcode_537 ], },
	# [1824] opcode : ld ixl "," b
	{ "\n" => [ 7, \&_action_opcode_538 ], ":" => [ 7, \&_action_opcode_538 ], },
	# [1825] opcode : ld ixl "," c
	{ "\n" => [ 7, \&_action_opcode_539 ], ":" => [ 7, \&_action_opcode_539 ], },
	# [1826] opcode : ld ixl "," d
	{ "\n" => [ 7, \&_action_opcode_540 ], ":" => [ 7, \&_action_opcode_540 ], },
	# [1827] opcode : ld ixl "," e
	{ "\n" => [ 7, \&_action_opcode_541 ], ":" => [ 7, \&_action_opcode_541 ], },
	# [1828] opcode : ld ixl "," ixh
	{ "\n" => [ 7, \&_action_opcode_542 ], ":" => [ 7, \&_action_opcode_542 ], },
	# [1829] opcode : ld ixl "," ixl
	{ "\n" => [ 7, \&_action_opcode_543 ], ":" => [ 7, \&_action_opcode_543 ], },
	# [1830] opcode : ld iy
	{ "," => 1831, },
	# [1831] opcode : ld iy ","
	{ "!" => [ 15, 1838 ], "(" => 1832, "+" => [ 15, 1838 ], "-" => [ 15, 1838 ], "[" => 1835, __else__ => [ 15, 1838 ], bc => 1839, de => 1840, hl => 1841, ix => 1842, iy => 1843, "~" => [ 15, 1838 ], },
	# [1832] opcode : ld iy "," "("
	{ "!" => [ 15, 1833 ], "+" => [ 15, 1833 ], "-" => [ 15, 1833 ], __else__ => [ 15, 1833 ], "~" => [ 15, 1833 ], },
	# [1833] opcode : ld iy "," "(" "[expr_NN]"
	{ ")" => 1834, },
	# [1834] opcode : ld iy "," "(" "[expr_NN]" ")"
	{ "\n" => [ 7, \&_action_opcode_544 ], ":" => [ 7, \&_action_opcode_544 ], },
	# [1835] opcode : ld iy "," "["
	{ "!" => [ 15, 1836 ], "+" => [ 15, 1836 ], "-" => [ 15, 1836 ], __else__ => [ 15, 1836 ], "~" => [ 15, 1836 ], },
	# [1836] opcode : ld iy "," "[" "[expr_NN]"
	{ "]" => 1837, },
	# [1837] opcode : ld iy "," "[" "[expr_NN]" "]"
	{ "\n" => [ 7, \&_action_opcode_544 ], ":" => [ 7, \&_action_opcode_544 ], },
	# [1838] opcode : ld iy "," "[expr_NN]"
	{ "\n" => [ 7, \&_action_opcode_545 ], ":" => [ 7, \&_action_opcode_545 ], },
	# [1839] opcode : ld iy "," bc
	{ "\n" => [ 7, \&_action_opcode_546 ], ":" => [ 7, \&_action_opcode_546 ], },
	# [1840] opcode : ld iy "," de
	{ "\n" => [ 7, \&_action_opcode_547 ], ":" => [ 7, \&_action_opcode_547 ], },
	# [1841] opcode : ld iy "," hl
	{ "\n" => [ 7, \&_action_opcode_548 ], ":" => [ 7, \&_action_opcode_548 ], },
	# [1842] opcode : ld iy "," ix
	{ "\n" => [ 7, \&_action_opcode_549 ], ":" => [ 7, \&_action_opcode_549 ], },
	# [1843] opcode : ld iy "," iy
	{ "\n" => [ 7, \&_action_opcode_550 ], ":" => [ 7, \&_action_opcode_550 ], },
	# [1844] opcode : ld iyh
	{ "," => 1845, },
	# [1845] opcode : ld iyh ","
	{ "!" => [ 13, 1846 ], "+" => [ 13, 1846 ], "-" => [ 13, 1846 ], __else__ => [ 13, 1846 ], a => 1847, b => 1848, c => 1849, d => 1850, e => 1851, iyh => 1852, iyl => 1853, "~" => [ 13, 1846 ], },
	# [1846] opcode : ld iyh "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_520 ], ":" => [ 7, \&_action_opcode_520 ], },
	# [1847] opcode : ld iyh "," a
	{ "\n" => [ 7, \&_action_opcode_521 ], ":" => [ 7, \&_action_opcode_521 ], },
	# [1848] opcode : ld iyh "," b
	{ "\n" => [ 7, \&_action_opcode_522 ], ":" => [ 7, \&_action_opcode_522 ], },
	# [1849] opcode : ld iyh "," c
	{ "\n" => [ 7, \&_action_opcode_523 ], ":" => [ 7, \&_action_opcode_523 ], },
	# [1850] opcode : ld iyh "," d
	{ "\n" => [ 7, \&_action_opcode_524 ], ":" => [ 7, \&_action_opcode_524 ], },
	# [1851] opcode : ld iyh "," e
	{ "\n" => [ 7, \&_action_opcode_525 ], ":" => [ 7, \&_action_opcode_525 ], },
	# [1852] opcode : ld iyh "," iyh
	{ "\n" => [ 7, \&_action_opcode_526 ], ":" => [ 7, \&_action_opcode_526 ], },
	# [1853] opcode : ld iyh "," iyl
	{ "\n" => [ 7, \&_action_opcode_527 ], ":" => [ 7, \&_action_opcode_527 ], },
	# [1854] opcode : ld iyl
	{ "," => 1855, },
	# [1855] opcode : ld iyl ","
	{ "!" => [ 13, 1856 ], "+" => [ 13, 1856 ], "-" => [ 13, 1856 ], __else__ => [ 13, 1856 ], a => 1857, b => 1858, c => 1859, d => 1860, e => 1861, iyh => 1862, iyl => 1863, "~" => [ 13, 1856 ], },
	# [1856] opcode : ld iyl "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_551 ], ":" => [ 7, \&_action_opcode_551 ], },
	# [1857] opcode : ld iyl "," a
	{ "\n" => [ 7, \&_action_opcode_552 ], ":" => [ 7, \&_action_opcode_552 ], },
	# [1858] opcode : ld iyl "," b
	{ "\n" => [ 7, \&_action_opcode_553 ], ":" => [ 7, \&_action_opcode_553 ], },
	# [1859] opcode : ld iyl "," c
	{ "\n" => [ 7, \&_action_opcode_554 ], ":" => [ 7, \&_action_opcode_554 ], },
	# [1860] opcode : ld iyl "," d
	{ "\n" => [ 7, \&_action_opcode_555 ], ":" => [ 7, \&_action_opcode_555 ], },
	# [1861] opcode : ld iyl "," e
	{ "\n" => [ 7, \&_action_opcode_556 ], ":" => [ 7, \&_action_opcode_556 ], },
	# [1862] opcode : ld iyl "," iyh
	{ "\n" => [ 7, \&_action_opcode_557 ], ":" => [ 7, \&_action_opcode_557 ], },
	# [1863] opcode : ld iyl "," iyl
	{ "\n" => [ 7, \&_action_opcode_558 ], ":" => [ 7, \&_action_opcode_558 ], },
	# [1864] opcode : ld l
	{ "," => 1865, },
	# [1865] opcode : ld l ","
	{ "!" => [ 13, 1904 ], "(" => 1866, "+" => [ 13, 1904 ], "-" => [ 13, 1904 ], "[" => 1885, __else__ => [ 13, 1904 ], a => 1905, b => 1906, c => 1907, d => 1908, e => 1909, h => 1910, l => 1911, "~" => [ 13, 1904 ], },
	# [1866] opcode : ld l "," "("
	{ hl => 1867, ix => 1869, iy => 1877, },
	# [1867] opcode : ld l "," "(" hl
	{ ")" => 1868, },
	# [1868] opcode : ld l "," "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_559 ], ":" => [ 7, \&_action_opcode_559 ], },
	# [1869] opcode : ld l "," "(" ix
	{ ")" => 1870, "+" => 1871, "-" => 1874, },
	# [1870] opcode : ld l "," "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_560 ], ":" => [ 7, \&_action_opcode_560 ], },
	# [1871] opcode : ld l "," "(" ix "+"
	{ "!" => [ 12, 1872 ], "+" => [ 12, 1872 ], "-" => [ 12, 1872 ], __else__ => [ 12, 1872 ], "~" => [ 12, 1872 ], },
	# [1872] opcode : ld l "," "(" ix "+" "[expr_DIS]"
	{ ")" => 1873, },
	# [1873] opcode : ld l "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_561 ], ":" => [ 7, \&_action_opcode_561 ], },
	# [1874] opcode : ld l "," "(" ix "-"
	{ "!" => [ 14, 1875 ], "+" => [ 14, 1875 ], "-" => [ 14, 1875 ], __else__ => [ 14, 1875 ], "~" => [ 14, 1875 ], },
	# [1875] opcode : ld l "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 1876, },
	# [1876] opcode : ld l "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_561 ], ":" => [ 7, \&_action_opcode_561 ], },
	# [1877] opcode : ld l "," "(" iy
	{ ")" => 1878, "+" => 1879, "-" => 1882, },
	# [1878] opcode : ld l "," "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_562 ], ":" => [ 7, \&_action_opcode_562 ], },
	# [1879] opcode : ld l "," "(" iy "+"
	{ "!" => [ 12, 1880 ], "+" => [ 12, 1880 ], "-" => [ 12, 1880 ], __else__ => [ 12, 1880 ], "~" => [ 12, 1880 ], },
	# [1880] opcode : ld l "," "(" iy "+" "[expr_DIS]"
	{ ")" => 1881, },
	# [1881] opcode : ld l "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_563 ], ":" => [ 7, \&_action_opcode_563 ], },
	# [1882] opcode : ld l "," "(" iy "-"
	{ "!" => [ 14, 1883 ], "+" => [ 14, 1883 ], "-" => [ 14, 1883 ], __else__ => [ 14, 1883 ], "~" => [ 14, 1883 ], },
	# [1883] opcode : ld l "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 1884, },
	# [1884] opcode : ld l "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_563 ], ":" => [ 7, \&_action_opcode_563 ], },
	# [1885] opcode : ld l "," "["
	{ hl => 1886, ix => 1888, iy => 1896, },
	# [1886] opcode : ld l "," "[" hl
	{ "]" => 1887, },
	# [1887] opcode : ld l "," "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_559 ], ":" => [ 7, \&_action_opcode_559 ], },
	# [1888] opcode : ld l "," "[" ix
	{ "+" => 1889, "-" => 1892, "]" => 1895, },
	# [1889] opcode : ld l "," "[" ix "+"
	{ "!" => [ 12, 1890 ], "+" => [ 12, 1890 ], "-" => [ 12, 1890 ], __else__ => [ 12, 1890 ], "~" => [ 12, 1890 ], },
	# [1890] opcode : ld l "," "[" ix "+" "[expr_DIS]"
	{ "]" => 1891, },
	# [1891] opcode : ld l "," "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_561 ], ":" => [ 7, \&_action_opcode_561 ], },
	# [1892] opcode : ld l "," "[" ix "-"
	{ "!" => [ 14, 1893 ], "+" => [ 14, 1893 ], "-" => [ 14, 1893 ], __else__ => [ 14, 1893 ], "~" => [ 14, 1893 ], },
	# [1893] opcode : ld l "," "[" ix "-" "[expr_NDIS]"
	{ "]" => 1894, },
	# [1894] opcode : ld l "," "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_561 ], ":" => [ 7, \&_action_opcode_561 ], },
	# [1895] opcode : ld l "," "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_560 ], ":" => [ 7, \&_action_opcode_560 ], },
	# [1896] opcode : ld l "," "[" iy
	{ "+" => 1897, "-" => 1900, "]" => 1903, },
	# [1897] opcode : ld l "," "[" iy "+"
	{ "!" => [ 12, 1898 ], "+" => [ 12, 1898 ], "-" => [ 12, 1898 ], __else__ => [ 12, 1898 ], "~" => [ 12, 1898 ], },
	# [1898] opcode : ld l "," "[" iy "+" "[expr_DIS]"
	{ "]" => 1899, },
	# [1899] opcode : ld l "," "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_563 ], ":" => [ 7, \&_action_opcode_563 ], },
	# [1900] opcode : ld l "," "[" iy "-"
	{ "!" => [ 14, 1901 ], "+" => [ 14, 1901 ], "-" => [ 14, 1901 ], __else__ => [ 14, 1901 ], "~" => [ 14, 1901 ], },
	# [1901] opcode : ld l "," "[" iy "-" "[expr_NDIS]"
	{ "]" => 1902, },
	# [1902] opcode : ld l "," "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_563 ], ":" => [ 7, \&_action_opcode_563 ], },
	# [1903] opcode : ld l "," "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_562 ], ":" => [ 7, \&_action_opcode_562 ], },
	# [1904] opcode : ld l "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_564 ], ":" => [ 7, \&_action_opcode_564 ], },
	# [1905] opcode : ld l "," a
	{ "\n" => [ 7, \&_action_opcode_565 ], ":" => [ 7, \&_action_opcode_565 ], },
	# [1906] opcode : ld l "," b
	{ "\n" => [ 7, \&_action_opcode_566 ], ":" => [ 7, \&_action_opcode_566 ], },
	# [1907] opcode : ld l "," c
	{ "\n" => [ 7, \&_action_opcode_567 ], ":" => [ 7, \&_action_opcode_567 ], },
	# [1908] opcode : ld l "," d
	{ "\n" => [ 7, \&_action_opcode_568 ], ":" => [ 7, \&_action_opcode_568 ], },
	# [1909] opcode : ld l "," e
	{ "\n" => [ 7, \&_action_opcode_569 ], ":" => [ 7, \&_action_opcode_569 ], },
	# [1910] opcode : ld l "," h
	{ "\n" => [ 7, \&_action_opcode_570 ], ":" => [ 7, \&_action_opcode_570 ], },
	# [1911] opcode : ld l "," l
	{ "\n" => [ 7, \&_action_opcode_571 ], ":" => [ 7, \&_action_opcode_571 ], },
	# [1912] opcode : ld lx
	{ "," => 1913, },
	# [1913] opcode : ld lx ","
	{ "!" => [ 13, 1914 ], "+" => [ 13, 1914 ], "-" => [ 13, 1914 ], __else__ => [ 13, 1914 ], a => 1915, b => 1916, c => 1917, d => 1918, e => 1919, hx => 1920, lx => 1921, "~" => [ 13, 1914 ], },
	# [1914] opcode : ld lx "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_536 ], ":" => [ 7, \&_action_opcode_536 ], },
	# [1915] opcode : ld lx "," a
	{ "\n" => [ 7, \&_action_opcode_537 ], ":" => [ 7, \&_action_opcode_537 ], },
	# [1916] opcode : ld lx "," b
	{ "\n" => [ 7, \&_action_opcode_538 ], ":" => [ 7, \&_action_opcode_538 ], },
	# [1917] opcode : ld lx "," c
	{ "\n" => [ 7, \&_action_opcode_539 ], ":" => [ 7, \&_action_opcode_539 ], },
	# [1918] opcode : ld lx "," d
	{ "\n" => [ 7, \&_action_opcode_540 ], ":" => [ 7, \&_action_opcode_540 ], },
	# [1919] opcode : ld lx "," e
	{ "\n" => [ 7, \&_action_opcode_541 ], ":" => [ 7, \&_action_opcode_541 ], },
	# [1920] opcode : ld lx "," hx
	{ "\n" => [ 7, \&_action_opcode_542 ], ":" => [ 7, \&_action_opcode_542 ], },
	# [1921] opcode : ld lx "," lx
	{ "\n" => [ 7, \&_action_opcode_543 ], ":" => [ 7, \&_action_opcode_543 ], },
	# [1922] opcode : ld ly
	{ "," => 1923, },
	# [1923] opcode : ld ly ","
	{ "!" => [ 13, 1924 ], "+" => [ 13, 1924 ], "-" => [ 13, 1924 ], __else__ => [ 13, 1924 ], a => 1925, b => 1926, c => 1927, d => 1928, e => 1929, hy => 1930, ly => 1931, "~" => [ 13, 1924 ], },
	# [1924] opcode : ld ly "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_551 ], ":" => [ 7, \&_action_opcode_551 ], },
	# [1925] opcode : ld ly "," a
	{ "\n" => [ 7, \&_action_opcode_552 ], ":" => [ 7, \&_action_opcode_552 ], },
	# [1926] opcode : ld ly "," b
	{ "\n" => [ 7, \&_action_opcode_553 ], ":" => [ 7, \&_action_opcode_553 ], },
	# [1927] opcode : ld ly "," c
	{ "\n" => [ 7, \&_action_opcode_554 ], ":" => [ 7, \&_action_opcode_554 ], },
	# [1928] opcode : ld ly "," d
	{ "\n" => [ 7, \&_action_opcode_555 ], ":" => [ 7, \&_action_opcode_555 ], },
	# [1929] opcode : ld ly "," e
	{ "\n" => [ 7, \&_action_opcode_556 ], ":" => [ 7, \&_action_opcode_556 ], },
	# [1930] opcode : ld ly "," hy
	{ "\n" => [ 7, \&_action_opcode_557 ], ":" => [ 7, \&_action_opcode_557 ], },
	# [1931] opcode : ld ly "," ly
	{ "\n" => [ 7, \&_action_opcode_558 ], ":" => [ 7, \&_action_opcode_558 ], },
	# [1932] opcode : ld r
	{ "," => 1933, },
	# [1933] opcode : ld r ","
	{ a => 1934, },
	# [1934] opcode : ld r "," a
	{ "\n" => [ 7, \&_action_opcode_572 ], ":" => [ 7, \&_action_opcode_572 ], },
	# [1935] opcode : ld sp
	{ "," => 1936, },
	# [1936] opcode : ld sp ","
	{ "!" => [ 15, 1943 ], "(" => 1937, "+" => [ 15, 1943 ], "-" => [ 15, 1943 ], "[" => 1940, __else__ => [ 15, 1943 ], hl => 1944, ix => 1945, iy => 1946, "~" => [ 15, 1943 ], },
	# [1937] opcode : ld sp "," "("
	{ "!" => [ 15, 1938 ], "+" => [ 15, 1938 ], "-" => [ 15, 1938 ], __else__ => [ 15, 1938 ], "~" => [ 15, 1938 ], },
	# [1938] opcode : ld sp "," "(" "[expr_NN]"
	{ ")" => 1939, },
	# [1939] opcode : ld sp "," "(" "[expr_NN]" ")"
	{ "\n" => [ 7, \&_action_opcode_573 ], ":" => [ 7, \&_action_opcode_573 ], },
	# [1940] opcode : ld sp "," "["
	{ "!" => [ 15, 1941 ], "+" => [ 15, 1941 ], "-" => [ 15, 1941 ], __else__ => [ 15, 1941 ], "~" => [ 15, 1941 ], },
	# [1941] opcode : ld sp "," "[" "[expr_NN]"
	{ "]" => 1942, },
	# [1942] opcode : ld sp "," "[" "[expr_NN]" "]"
	{ "\n" => [ 7, \&_action_opcode_573 ], ":" => [ 7, \&_action_opcode_573 ], },
	# [1943] opcode : ld sp "," "[expr_NN]"
	{ "\n" => [ 7, \&_action_opcode_574 ], ":" => [ 7, \&_action_opcode_574 ], },
	# [1944] opcode : ld sp "," hl
	{ "\n" => [ 7, \&_action_opcode_575 ], ":" => [ 7, \&_action_opcode_575 ], },
	# [1945] opcode : ld sp "," ix
	{ "\n" => [ 7, \&_action_opcode_576 ], ":" => [ 7, \&_action_opcode_576 ], },
	# [1946] opcode : ld sp "," iy
	{ "\n" => [ 7, \&_action_opcode_577 ], ":" => [ 7, \&_action_opcode_577 ], },
	# [1947] opcode : ld xh
	{ "," => 1948, },
	# [1948] opcode : ld xh ","
	{ "!" => [ 13, 1949 ], "+" => [ 13, 1949 ], "-" => [ 13, 1949 ], __else__ => [ 13, 1949 ], a => 1950, b => 1951, c => 1952, d => 1953, e => 1954, xh => 1955, xl => 1956, "~" => [ 13, 1949 ], },
	# [1949] opcode : ld xh "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_512 ], ":" => [ 7, \&_action_opcode_512 ], },
	# [1950] opcode : ld xh "," a
	{ "\n" => [ 7, \&_action_opcode_513 ], ":" => [ 7, \&_action_opcode_513 ], },
	# [1951] opcode : ld xh "," b
	{ "\n" => [ 7, \&_action_opcode_514 ], ":" => [ 7, \&_action_opcode_514 ], },
	# [1952] opcode : ld xh "," c
	{ "\n" => [ 7, \&_action_opcode_515 ], ":" => [ 7, \&_action_opcode_515 ], },
	# [1953] opcode : ld xh "," d
	{ "\n" => [ 7, \&_action_opcode_516 ], ":" => [ 7, \&_action_opcode_516 ], },
	# [1954] opcode : ld xh "," e
	{ "\n" => [ 7, \&_action_opcode_517 ], ":" => [ 7, \&_action_opcode_517 ], },
	# [1955] opcode : ld xh "," xh
	{ "\n" => [ 7, \&_action_opcode_518 ], ":" => [ 7, \&_action_opcode_518 ], },
	# [1956] opcode : ld xh "," xl
	{ "\n" => [ 7, \&_action_opcode_519 ], ":" => [ 7, \&_action_opcode_519 ], },
	# [1957] opcode : ld xl
	{ "," => 1958, },
	# [1958] opcode : ld xl ","
	{ "!" => [ 13, 1959 ], "+" => [ 13, 1959 ], "-" => [ 13, 1959 ], __else__ => [ 13, 1959 ], a => 1960, b => 1961, c => 1962, d => 1963, e => 1964, xh => 1965, xl => 1966, "~" => [ 13, 1959 ], },
	# [1959] opcode : ld xl "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_536 ], ":" => [ 7, \&_action_opcode_536 ], },
	# [1960] opcode : ld xl "," a
	{ "\n" => [ 7, \&_action_opcode_537 ], ":" => [ 7, \&_action_opcode_537 ], },
	# [1961] opcode : ld xl "," b
	{ "\n" => [ 7, \&_action_opcode_538 ], ":" => [ 7, \&_action_opcode_538 ], },
	# [1962] opcode : ld xl "," c
	{ "\n" => [ 7, \&_action_opcode_539 ], ":" => [ 7, \&_action_opcode_539 ], },
	# [1963] opcode : ld xl "," d
	{ "\n" => [ 7, \&_action_opcode_540 ], ":" => [ 7, \&_action_opcode_540 ], },
	# [1964] opcode : ld xl "," e
	{ "\n" => [ 7, \&_action_opcode_541 ], ":" => [ 7, \&_action_opcode_541 ], },
	# [1965] opcode : ld xl "," xh
	{ "\n" => [ 7, \&_action_opcode_542 ], ":" => [ 7, \&_action_opcode_542 ], },
	# [1966] opcode : ld xl "," xl
	{ "\n" => [ 7, \&_action_opcode_543 ], ":" => [ 7, \&_action_opcode_543 ], },
	# [1967] opcode : ld yh
	{ "," => 1968, },
	# [1968] opcode : ld yh ","
	{ "!" => [ 13, 1969 ], "+" => [ 13, 1969 ], "-" => [ 13, 1969 ], __else__ => [ 13, 1969 ], a => 1970, b => 1971, c => 1972, d => 1973, e => 1974, yh => 1975, yl => 1976, "~" => [ 13, 1969 ], },
	# [1969] opcode : ld yh "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_520 ], ":" => [ 7, \&_action_opcode_520 ], },
	# [1970] opcode : ld yh "," a
	{ "\n" => [ 7, \&_action_opcode_521 ], ":" => [ 7, \&_action_opcode_521 ], },
	# [1971] opcode : ld yh "," b
	{ "\n" => [ 7, \&_action_opcode_522 ], ":" => [ 7, \&_action_opcode_522 ], },
	# [1972] opcode : ld yh "," c
	{ "\n" => [ 7, \&_action_opcode_523 ], ":" => [ 7, \&_action_opcode_523 ], },
	# [1973] opcode : ld yh "," d
	{ "\n" => [ 7, \&_action_opcode_524 ], ":" => [ 7, \&_action_opcode_524 ], },
	# [1974] opcode : ld yh "," e
	{ "\n" => [ 7, \&_action_opcode_525 ], ":" => [ 7, \&_action_opcode_525 ], },
	# [1975] opcode : ld yh "," yh
	{ "\n" => [ 7, \&_action_opcode_526 ], ":" => [ 7, \&_action_opcode_526 ], },
	# [1976] opcode : ld yh "," yl
	{ "\n" => [ 7, \&_action_opcode_527 ], ":" => [ 7, \&_action_opcode_527 ], },
	# [1977] opcode : ld yl
	{ "," => 1978, },
	# [1978] opcode : ld yl ","
	{ "!" => [ 13, 1979 ], "+" => [ 13, 1979 ], "-" => [ 13, 1979 ], __else__ => [ 13, 1979 ], a => 1980, b => 1981, c => 1982, d => 1983, e => 1984, yh => 1985, yl => 1986, "~" => [ 13, 1979 ], },
	# [1979] opcode : ld yl "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_551 ], ":" => [ 7, \&_action_opcode_551 ], },
	# [1980] opcode : ld yl "," a
	{ "\n" => [ 7, \&_action_opcode_552 ], ":" => [ 7, \&_action_opcode_552 ], },
	# [1981] opcode : ld yl "," b
	{ "\n" => [ 7, \&_action_opcode_553 ], ":" => [ 7, \&_action_opcode_553 ], },
	# [1982] opcode : ld yl "," c
	{ "\n" => [ 7, \&_action_opcode_554 ], ":" => [ 7, \&_action_opcode_554 ], },
	# [1983] opcode : ld yl "," d
	{ "\n" => [ 7, \&_action_opcode_555 ], ":" => [ 7, \&_action_opcode_555 ], },
	# [1984] opcode : ld yl "," e
	{ "\n" => [ 7, \&_action_opcode_556 ], ":" => [ 7, \&_action_opcode_556 ], },
	# [1985] opcode : ld yl "," yh
	{ "\n" => [ 7, \&_action_opcode_557 ], ":" => [ 7, \&_action_opcode_557 ], },
	# [1986] opcode : ld yl "," yl
	{ "\n" => [ 7, \&_action_opcode_558 ], ":" => [ 7, \&_action_opcode_558 ], },
	# [1987] opcode : ldd
	{ "\n" => [ 7, \&_action_opcode_578 ], "(" => 1988, ":" => [ 7, \&_action_opcode_578 ], "[" => 2078, a => 2168, b => 2216, c => 2256, d => 2296, e => 2336, h => 2376, l => 2416, },
	# [1988] opcode : ldd "("
	{ bc => 1989, de => 1993, hl => 1997, ix => 2008, iy => 2043, },
	# [1989] opcode : ldd "(" bc
	{ ")" => 1990, },
	# [1990] opcode : ldd "(" bc ")"
	{ "," => 1991, },
	# [1991] opcode : ldd "(" bc ")" ","
	{ a => 1992, },
	# [1992] opcode : ldd "(" bc ")" "," a
	{ "\n" => [ 7, \&_action_opcode_579 ], ":" => [ 7, \&_action_opcode_579 ], },
	# [1993] opcode : ldd "(" de
	{ ")" => 1994, },
	# [1994] opcode : ldd "(" de ")"
	{ "," => 1995, },
	# [1995] opcode : ldd "(" de ")" ","
	{ a => 1996, },
	# [1996] opcode : ldd "(" de ")" "," a
	{ "\n" => [ 7, \&_action_opcode_580 ], ":" => [ 7, \&_action_opcode_580 ], },
	# [1997] opcode : ldd "(" hl
	{ ")" => 1998, },
	# [1998] opcode : ldd "(" hl ")"
	{ "," => 1999, },
	# [1999] opcode : ldd "(" hl ")" ","
	{ "!" => [ 13, 2000 ], "+" => [ 13, 2000 ], "-" => [ 13, 2000 ], __else__ => [ 13, 2000 ], a => 2001, b => 2002, c => 2003, d => 2004, e => 2005, h => 2006, l => 2007, "~" => [ 13, 2000 ], },
	# [2000] opcode : ldd "(" hl ")" "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_581 ], ":" => [ 7, \&_action_opcode_581 ], },
	# [2001] opcode : ldd "(" hl ")" "," a
	{ "\n" => [ 7, \&_action_opcode_582 ], ":" => [ 7, \&_action_opcode_582 ], },
	# [2002] opcode : ldd "(" hl ")" "," b
	{ "\n" => [ 7, \&_action_opcode_583 ], ":" => [ 7, \&_action_opcode_583 ], },
	# [2003] opcode : ldd "(" hl ")" "," c
	{ "\n" => [ 7, \&_action_opcode_584 ], ":" => [ 7, \&_action_opcode_584 ], },
	# [2004] opcode : ldd "(" hl ")" "," d
	{ "\n" => [ 7, \&_action_opcode_585 ], ":" => [ 7, \&_action_opcode_585 ], },
	# [2005] opcode : ldd "(" hl ")" "," e
	{ "\n" => [ 7, \&_action_opcode_586 ], ":" => [ 7, \&_action_opcode_586 ], },
	# [2006] opcode : ldd "(" hl ")" "," h
	{ "\n" => [ 7, \&_action_opcode_587 ], ":" => [ 7, \&_action_opcode_587 ], },
	# [2007] opcode : ldd "(" hl ")" "," l
	{ "\n" => [ 7, \&_action_opcode_588 ], ":" => [ 7, \&_action_opcode_588 ], },
	# [2008] opcode : ldd "(" ix
	{ ")" => 2009, "+" => 2019, "-" => 2031, },
	# [2009] opcode : ldd "(" ix ")"
	{ "," => 2010, },
	# [2010] opcode : ldd "(" ix ")" ","
	{ "!" => [ 13, 2011 ], "+" => [ 13, 2011 ], "-" => [ 13, 2011 ], __else__ => [ 13, 2011 ], a => 2012, b => 2013, c => 2014, d => 2015, e => 2016, h => 2017, l => 2018, "~" => [ 13, 2011 ], },
	# [2011] opcode : ldd "(" ix ")" "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_589 ], ":" => [ 7, \&_action_opcode_589 ], },
	# [2012] opcode : ldd "(" ix ")" "," a
	{ "\n" => [ 7, \&_action_opcode_590 ], ":" => [ 7, \&_action_opcode_590 ], },
	# [2013] opcode : ldd "(" ix ")" "," b
	{ "\n" => [ 7, \&_action_opcode_591 ], ":" => [ 7, \&_action_opcode_591 ], },
	# [2014] opcode : ldd "(" ix ")" "," c
	{ "\n" => [ 7, \&_action_opcode_592 ], ":" => [ 7, \&_action_opcode_592 ], },
	# [2015] opcode : ldd "(" ix ")" "," d
	{ "\n" => [ 7, \&_action_opcode_593 ], ":" => [ 7, \&_action_opcode_593 ], },
	# [2016] opcode : ldd "(" ix ")" "," e
	{ "\n" => [ 7, \&_action_opcode_594 ], ":" => [ 7, \&_action_opcode_594 ], },
	# [2017] opcode : ldd "(" ix ")" "," h
	{ "\n" => [ 7, \&_action_opcode_595 ], ":" => [ 7, \&_action_opcode_595 ], },
	# [2018] opcode : ldd "(" ix ")" "," l
	{ "\n" => [ 7, \&_action_opcode_596 ], ":" => [ 7, \&_action_opcode_596 ], },
	# [2019] opcode : ldd "(" ix "+"
	{ "!" => [ 12, 2020 ], "+" => [ 12, 2020 ], "-" => [ 12, 2020 ], __else__ => [ 12, 2020 ], "~" => [ 12, 2020 ], },
	# [2020] opcode : ldd "(" ix "+" "[expr_DIS]"
	{ ")" => 2021, },
	# [2021] opcode : ldd "(" ix "+" "[expr_DIS]" ")"
	{ "," => 2022, },
	# [2022] opcode : ldd "(" ix "+" "[expr_DIS]" ")" ","
	{ "!" => [ 13, 2023 ], "+" => [ 13, 2023 ], "-" => [ 13, 2023 ], __else__ => [ 13, 2023 ], a => 2024, b => 2025, c => 2026, d => 2027, e => 2028, h => 2029, l => 2030, "~" => [ 13, 2023 ], },
	# [2023] opcode : ldd "(" ix "+" "[expr_DIS]" ")" "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_597 ], ":" => [ 7, \&_action_opcode_597 ], },
	# [2024] opcode : ldd "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_598 ], ":" => [ 7, \&_action_opcode_598 ], },
	# [2025] opcode : ldd "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_599 ], ":" => [ 7, \&_action_opcode_599 ], },
	# [2026] opcode : ldd "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_600 ], ":" => [ 7, \&_action_opcode_600 ], },
	# [2027] opcode : ldd "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_601 ], ":" => [ 7, \&_action_opcode_601 ], },
	# [2028] opcode : ldd "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_602 ], ":" => [ 7, \&_action_opcode_602 ], },
	# [2029] opcode : ldd "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_603 ], ":" => [ 7, \&_action_opcode_603 ], },
	# [2030] opcode : ldd "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_604 ], ":" => [ 7, \&_action_opcode_604 ], },
	# [2031] opcode : ldd "(" ix "-"
	{ "!" => [ 14, 2032 ], "+" => [ 14, 2032 ], "-" => [ 14, 2032 ], __else__ => [ 14, 2032 ], "~" => [ 14, 2032 ], },
	# [2032] opcode : ldd "(" ix "-" "[expr_NDIS]"
	{ ")" => 2033, },
	# [2033] opcode : ldd "(" ix "-" "[expr_NDIS]" ")"
	{ "," => 2034, },
	# [2034] opcode : ldd "(" ix "-" "[expr_NDIS]" ")" ","
	{ "!" => [ 13, 2035 ], "+" => [ 13, 2035 ], "-" => [ 13, 2035 ], __else__ => [ 13, 2035 ], a => 2036, b => 2037, c => 2038, d => 2039, e => 2040, h => 2041, l => 2042, "~" => [ 13, 2035 ], },
	# [2035] opcode : ldd "(" ix "-" "[expr_NDIS]" ")" "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_597 ], ":" => [ 7, \&_action_opcode_597 ], },
	# [2036] opcode : ldd "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_598 ], ":" => [ 7, \&_action_opcode_598 ], },
	# [2037] opcode : ldd "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_599 ], ":" => [ 7, \&_action_opcode_599 ], },
	# [2038] opcode : ldd "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_600 ], ":" => [ 7, \&_action_opcode_600 ], },
	# [2039] opcode : ldd "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_601 ], ":" => [ 7, \&_action_opcode_601 ], },
	# [2040] opcode : ldd "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_602 ], ":" => [ 7, \&_action_opcode_602 ], },
	# [2041] opcode : ldd "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_603 ], ":" => [ 7, \&_action_opcode_603 ], },
	# [2042] opcode : ldd "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_604 ], ":" => [ 7, \&_action_opcode_604 ], },
	# [2043] opcode : ldd "(" iy
	{ ")" => 2044, "+" => 2054, "-" => 2066, },
	# [2044] opcode : ldd "(" iy ")"
	{ "," => 2045, },
	# [2045] opcode : ldd "(" iy ")" ","
	{ "!" => [ 13, 2046 ], "+" => [ 13, 2046 ], "-" => [ 13, 2046 ], __else__ => [ 13, 2046 ], a => 2047, b => 2048, c => 2049, d => 2050, e => 2051, h => 2052, l => 2053, "~" => [ 13, 2046 ], },
	# [2046] opcode : ldd "(" iy ")" "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_605 ], ":" => [ 7, \&_action_opcode_605 ], },
	# [2047] opcode : ldd "(" iy ")" "," a
	{ "\n" => [ 7, \&_action_opcode_606 ], ":" => [ 7, \&_action_opcode_606 ], },
	# [2048] opcode : ldd "(" iy ")" "," b
	{ "\n" => [ 7, \&_action_opcode_607 ], ":" => [ 7, \&_action_opcode_607 ], },
	# [2049] opcode : ldd "(" iy ")" "," c
	{ "\n" => [ 7, \&_action_opcode_608 ], ":" => [ 7, \&_action_opcode_608 ], },
	# [2050] opcode : ldd "(" iy ")" "," d
	{ "\n" => [ 7, \&_action_opcode_609 ], ":" => [ 7, \&_action_opcode_609 ], },
	# [2051] opcode : ldd "(" iy ")" "," e
	{ "\n" => [ 7, \&_action_opcode_610 ], ":" => [ 7, \&_action_opcode_610 ], },
	# [2052] opcode : ldd "(" iy ")" "," h
	{ "\n" => [ 7, \&_action_opcode_611 ], ":" => [ 7, \&_action_opcode_611 ], },
	# [2053] opcode : ldd "(" iy ")" "," l
	{ "\n" => [ 7, \&_action_opcode_612 ], ":" => [ 7, \&_action_opcode_612 ], },
	# [2054] opcode : ldd "(" iy "+"
	{ "!" => [ 12, 2055 ], "+" => [ 12, 2055 ], "-" => [ 12, 2055 ], __else__ => [ 12, 2055 ], "~" => [ 12, 2055 ], },
	# [2055] opcode : ldd "(" iy "+" "[expr_DIS]"
	{ ")" => 2056, },
	# [2056] opcode : ldd "(" iy "+" "[expr_DIS]" ")"
	{ "," => 2057, },
	# [2057] opcode : ldd "(" iy "+" "[expr_DIS]" ")" ","
	{ "!" => [ 13, 2058 ], "+" => [ 13, 2058 ], "-" => [ 13, 2058 ], __else__ => [ 13, 2058 ], a => 2059, b => 2060, c => 2061, d => 2062, e => 2063, h => 2064, l => 2065, "~" => [ 13, 2058 ], },
	# [2058] opcode : ldd "(" iy "+" "[expr_DIS]" ")" "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_613 ], ":" => [ 7, \&_action_opcode_613 ], },
	# [2059] opcode : ldd "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_614 ], ":" => [ 7, \&_action_opcode_614 ], },
	# [2060] opcode : ldd "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_615 ], ":" => [ 7, \&_action_opcode_615 ], },
	# [2061] opcode : ldd "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_616 ], ":" => [ 7, \&_action_opcode_616 ], },
	# [2062] opcode : ldd "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_617 ], ":" => [ 7, \&_action_opcode_617 ], },
	# [2063] opcode : ldd "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_618 ], ":" => [ 7, \&_action_opcode_618 ], },
	# [2064] opcode : ldd "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_619 ], ":" => [ 7, \&_action_opcode_619 ], },
	# [2065] opcode : ldd "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_620 ], ":" => [ 7, \&_action_opcode_620 ], },
	# [2066] opcode : ldd "(" iy "-"
	{ "!" => [ 14, 2067 ], "+" => [ 14, 2067 ], "-" => [ 14, 2067 ], __else__ => [ 14, 2067 ], "~" => [ 14, 2067 ], },
	# [2067] opcode : ldd "(" iy "-" "[expr_NDIS]"
	{ ")" => 2068, },
	# [2068] opcode : ldd "(" iy "-" "[expr_NDIS]" ")"
	{ "," => 2069, },
	# [2069] opcode : ldd "(" iy "-" "[expr_NDIS]" ")" ","
	{ "!" => [ 13, 2070 ], "+" => [ 13, 2070 ], "-" => [ 13, 2070 ], __else__ => [ 13, 2070 ], a => 2071, b => 2072, c => 2073, d => 2074, e => 2075, h => 2076, l => 2077, "~" => [ 13, 2070 ], },
	# [2070] opcode : ldd "(" iy "-" "[expr_NDIS]" ")" "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_613 ], ":" => [ 7, \&_action_opcode_613 ], },
	# [2071] opcode : ldd "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_614 ], ":" => [ 7, \&_action_opcode_614 ], },
	# [2072] opcode : ldd "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_615 ], ":" => [ 7, \&_action_opcode_615 ], },
	# [2073] opcode : ldd "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_616 ], ":" => [ 7, \&_action_opcode_616 ], },
	# [2074] opcode : ldd "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_617 ], ":" => [ 7, \&_action_opcode_617 ], },
	# [2075] opcode : ldd "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_618 ], ":" => [ 7, \&_action_opcode_618 ], },
	# [2076] opcode : ldd "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_619 ], ":" => [ 7, \&_action_opcode_619 ], },
	# [2077] opcode : ldd "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_620 ], ":" => [ 7, \&_action_opcode_620 ], },
	# [2078] opcode : ldd "["
	{ bc => 2079, de => 2083, hl => 2087, ix => 2098, iy => 2133, },
	# [2079] opcode : ldd "[" bc
	{ "]" => 2080, },
	# [2080] opcode : ldd "[" bc "]"
	{ "," => 2081, },
	# [2081] opcode : ldd "[" bc "]" ","
	{ a => 2082, },
	# [2082] opcode : ldd "[" bc "]" "," a
	{ "\n" => [ 7, \&_action_opcode_579 ], ":" => [ 7, \&_action_opcode_579 ], },
	# [2083] opcode : ldd "[" de
	{ "]" => 2084, },
	# [2084] opcode : ldd "[" de "]"
	{ "," => 2085, },
	# [2085] opcode : ldd "[" de "]" ","
	{ a => 2086, },
	# [2086] opcode : ldd "[" de "]" "," a
	{ "\n" => [ 7, \&_action_opcode_580 ], ":" => [ 7, \&_action_opcode_580 ], },
	# [2087] opcode : ldd "[" hl
	{ "]" => 2088, },
	# [2088] opcode : ldd "[" hl "]"
	{ "," => 2089, },
	# [2089] opcode : ldd "[" hl "]" ","
	{ "!" => [ 13, 2090 ], "+" => [ 13, 2090 ], "-" => [ 13, 2090 ], __else__ => [ 13, 2090 ], a => 2091, b => 2092, c => 2093, d => 2094, e => 2095, h => 2096, l => 2097, "~" => [ 13, 2090 ], },
	# [2090] opcode : ldd "[" hl "]" "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_581 ], ":" => [ 7, \&_action_opcode_581 ], },
	# [2091] opcode : ldd "[" hl "]" "," a
	{ "\n" => [ 7, \&_action_opcode_582 ], ":" => [ 7, \&_action_opcode_582 ], },
	# [2092] opcode : ldd "[" hl "]" "," b
	{ "\n" => [ 7, \&_action_opcode_583 ], ":" => [ 7, \&_action_opcode_583 ], },
	# [2093] opcode : ldd "[" hl "]" "," c
	{ "\n" => [ 7, \&_action_opcode_584 ], ":" => [ 7, \&_action_opcode_584 ], },
	# [2094] opcode : ldd "[" hl "]" "," d
	{ "\n" => [ 7, \&_action_opcode_585 ], ":" => [ 7, \&_action_opcode_585 ], },
	# [2095] opcode : ldd "[" hl "]" "," e
	{ "\n" => [ 7, \&_action_opcode_586 ], ":" => [ 7, \&_action_opcode_586 ], },
	# [2096] opcode : ldd "[" hl "]" "," h
	{ "\n" => [ 7, \&_action_opcode_587 ], ":" => [ 7, \&_action_opcode_587 ], },
	# [2097] opcode : ldd "[" hl "]" "," l
	{ "\n" => [ 7, \&_action_opcode_588 ], ":" => [ 7, \&_action_opcode_588 ], },
	# [2098] opcode : ldd "[" ix
	{ "+" => 2099, "-" => 2111, "]" => 2123, },
	# [2099] opcode : ldd "[" ix "+"
	{ "!" => [ 12, 2100 ], "+" => [ 12, 2100 ], "-" => [ 12, 2100 ], __else__ => [ 12, 2100 ], "~" => [ 12, 2100 ], },
	# [2100] opcode : ldd "[" ix "+" "[expr_DIS]"
	{ "]" => 2101, },
	# [2101] opcode : ldd "[" ix "+" "[expr_DIS]" "]"
	{ "," => 2102, },
	# [2102] opcode : ldd "[" ix "+" "[expr_DIS]" "]" ","
	{ "!" => [ 13, 2103 ], "+" => [ 13, 2103 ], "-" => [ 13, 2103 ], __else__ => [ 13, 2103 ], a => 2104, b => 2105, c => 2106, d => 2107, e => 2108, h => 2109, l => 2110, "~" => [ 13, 2103 ], },
	# [2103] opcode : ldd "[" ix "+" "[expr_DIS]" "]" "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_597 ], ":" => [ 7, \&_action_opcode_597 ], },
	# [2104] opcode : ldd "[" ix "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_598 ], ":" => [ 7, \&_action_opcode_598 ], },
	# [2105] opcode : ldd "[" ix "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_599 ], ":" => [ 7, \&_action_opcode_599 ], },
	# [2106] opcode : ldd "[" ix "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_600 ], ":" => [ 7, \&_action_opcode_600 ], },
	# [2107] opcode : ldd "[" ix "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_601 ], ":" => [ 7, \&_action_opcode_601 ], },
	# [2108] opcode : ldd "[" ix "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_602 ], ":" => [ 7, \&_action_opcode_602 ], },
	# [2109] opcode : ldd "[" ix "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_603 ], ":" => [ 7, \&_action_opcode_603 ], },
	# [2110] opcode : ldd "[" ix "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_604 ], ":" => [ 7, \&_action_opcode_604 ], },
	# [2111] opcode : ldd "[" ix "-"
	{ "!" => [ 14, 2112 ], "+" => [ 14, 2112 ], "-" => [ 14, 2112 ], __else__ => [ 14, 2112 ], "~" => [ 14, 2112 ], },
	# [2112] opcode : ldd "[" ix "-" "[expr_NDIS]"
	{ "]" => 2113, },
	# [2113] opcode : ldd "[" ix "-" "[expr_NDIS]" "]"
	{ "," => 2114, },
	# [2114] opcode : ldd "[" ix "-" "[expr_NDIS]" "]" ","
	{ "!" => [ 13, 2115 ], "+" => [ 13, 2115 ], "-" => [ 13, 2115 ], __else__ => [ 13, 2115 ], a => 2116, b => 2117, c => 2118, d => 2119, e => 2120, h => 2121, l => 2122, "~" => [ 13, 2115 ], },
	# [2115] opcode : ldd "[" ix "-" "[expr_NDIS]" "]" "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_597 ], ":" => [ 7, \&_action_opcode_597 ], },
	# [2116] opcode : ldd "[" ix "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_598 ], ":" => [ 7, \&_action_opcode_598 ], },
	# [2117] opcode : ldd "[" ix "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_599 ], ":" => [ 7, \&_action_opcode_599 ], },
	# [2118] opcode : ldd "[" ix "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_600 ], ":" => [ 7, \&_action_opcode_600 ], },
	# [2119] opcode : ldd "[" ix "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_601 ], ":" => [ 7, \&_action_opcode_601 ], },
	# [2120] opcode : ldd "[" ix "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_602 ], ":" => [ 7, \&_action_opcode_602 ], },
	# [2121] opcode : ldd "[" ix "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_603 ], ":" => [ 7, \&_action_opcode_603 ], },
	# [2122] opcode : ldd "[" ix "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_604 ], ":" => [ 7, \&_action_opcode_604 ], },
	# [2123] opcode : ldd "[" ix "]"
	{ "," => 2124, },
	# [2124] opcode : ldd "[" ix "]" ","
	{ "!" => [ 13, 2125 ], "+" => [ 13, 2125 ], "-" => [ 13, 2125 ], __else__ => [ 13, 2125 ], a => 2126, b => 2127, c => 2128, d => 2129, e => 2130, h => 2131, l => 2132, "~" => [ 13, 2125 ], },
	# [2125] opcode : ldd "[" ix "]" "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_589 ], ":" => [ 7, \&_action_opcode_589 ], },
	# [2126] opcode : ldd "[" ix "]" "," a
	{ "\n" => [ 7, \&_action_opcode_590 ], ":" => [ 7, \&_action_opcode_590 ], },
	# [2127] opcode : ldd "[" ix "]" "," b
	{ "\n" => [ 7, \&_action_opcode_591 ], ":" => [ 7, \&_action_opcode_591 ], },
	# [2128] opcode : ldd "[" ix "]" "," c
	{ "\n" => [ 7, \&_action_opcode_592 ], ":" => [ 7, \&_action_opcode_592 ], },
	# [2129] opcode : ldd "[" ix "]" "," d
	{ "\n" => [ 7, \&_action_opcode_593 ], ":" => [ 7, \&_action_opcode_593 ], },
	# [2130] opcode : ldd "[" ix "]" "," e
	{ "\n" => [ 7, \&_action_opcode_594 ], ":" => [ 7, \&_action_opcode_594 ], },
	# [2131] opcode : ldd "[" ix "]" "," h
	{ "\n" => [ 7, \&_action_opcode_595 ], ":" => [ 7, \&_action_opcode_595 ], },
	# [2132] opcode : ldd "[" ix "]" "," l
	{ "\n" => [ 7, \&_action_opcode_596 ], ":" => [ 7, \&_action_opcode_596 ], },
	# [2133] opcode : ldd "[" iy
	{ "+" => 2134, "-" => 2146, "]" => 2158, },
	# [2134] opcode : ldd "[" iy "+"
	{ "!" => [ 12, 2135 ], "+" => [ 12, 2135 ], "-" => [ 12, 2135 ], __else__ => [ 12, 2135 ], "~" => [ 12, 2135 ], },
	# [2135] opcode : ldd "[" iy "+" "[expr_DIS]"
	{ "]" => 2136, },
	# [2136] opcode : ldd "[" iy "+" "[expr_DIS]" "]"
	{ "," => 2137, },
	# [2137] opcode : ldd "[" iy "+" "[expr_DIS]" "]" ","
	{ "!" => [ 13, 2138 ], "+" => [ 13, 2138 ], "-" => [ 13, 2138 ], __else__ => [ 13, 2138 ], a => 2139, b => 2140, c => 2141, d => 2142, e => 2143, h => 2144, l => 2145, "~" => [ 13, 2138 ], },
	# [2138] opcode : ldd "[" iy "+" "[expr_DIS]" "]" "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_613 ], ":" => [ 7, \&_action_opcode_613 ], },
	# [2139] opcode : ldd "[" iy "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_614 ], ":" => [ 7, \&_action_opcode_614 ], },
	# [2140] opcode : ldd "[" iy "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_615 ], ":" => [ 7, \&_action_opcode_615 ], },
	# [2141] opcode : ldd "[" iy "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_616 ], ":" => [ 7, \&_action_opcode_616 ], },
	# [2142] opcode : ldd "[" iy "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_617 ], ":" => [ 7, \&_action_opcode_617 ], },
	# [2143] opcode : ldd "[" iy "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_618 ], ":" => [ 7, \&_action_opcode_618 ], },
	# [2144] opcode : ldd "[" iy "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_619 ], ":" => [ 7, \&_action_opcode_619 ], },
	# [2145] opcode : ldd "[" iy "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_620 ], ":" => [ 7, \&_action_opcode_620 ], },
	# [2146] opcode : ldd "[" iy "-"
	{ "!" => [ 14, 2147 ], "+" => [ 14, 2147 ], "-" => [ 14, 2147 ], __else__ => [ 14, 2147 ], "~" => [ 14, 2147 ], },
	# [2147] opcode : ldd "[" iy "-" "[expr_NDIS]"
	{ "]" => 2148, },
	# [2148] opcode : ldd "[" iy "-" "[expr_NDIS]" "]"
	{ "," => 2149, },
	# [2149] opcode : ldd "[" iy "-" "[expr_NDIS]" "]" ","
	{ "!" => [ 13, 2150 ], "+" => [ 13, 2150 ], "-" => [ 13, 2150 ], __else__ => [ 13, 2150 ], a => 2151, b => 2152, c => 2153, d => 2154, e => 2155, h => 2156, l => 2157, "~" => [ 13, 2150 ], },
	# [2150] opcode : ldd "[" iy "-" "[expr_NDIS]" "]" "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_613 ], ":" => [ 7, \&_action_opcode_613 ], },
	# [2151] opcode : ldd "[" iy "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_614 ], ":" => [ 7, \&_action_opcode_614 ], },
	# [2152] opcode : ldd "[" iy "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_615 ], ":" => [ 7, \&_action_opcode_615 ], },
	# [2153] opcode : ldd "[" iy "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_616 ], ":" => [ 7, \&_action_opcode_616 ], },
	# [2154] opcode : ldd "[" iy "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_617 ], ":" => [ 7, \&_action_opcode_617 ], },
	# [2155] opcode : ldd "[" iy "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_618 ], ":" => [ 7, \&_action_opcode_618 ], },
	# [2156] opcode : ldd "[" iy "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_619 ], ":" => [ 7, \&_action_opcode_619 ], },
	# [2157] opcode : ldd "[" iy "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_620 ], ":" => [ 7, \&_action_opcode_620 ], },
	# [2158] opcode : ldd "[" iy "]"
	{ "," => 2159, },
	# [2159] opcode : ldd "[" iy "]" ","
	{ "!" => [ 13, 2160 ], "+" => [ 13, 2160 ], "-" => [ 13, 2160 ], __else__ => [ 13, 2160 ], a => 2161, b => 2162, c => 2163, d => 2164, e => 2165, h => 2166, l => 2167, "~" => [ 13, 2160 ], },
	# [2160] opcode : ldd "[" iy "]" "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_605 ], ":" => [ 7, \&_action_opcode_605 ], },
	# [2161] opcode : ldd "[" iy "]" "," a
	{ "\n" => [ 7, \&_action_opcode_606 ], ":" => [ 7, \&_action_opcode_606 ], },
	# [2162] opcode : ldd "[" iy "]" "," b
	{ "\n" => [ 7, \&_action_opcode_607 ], ":" => [ 7, \&_action_opcode_607 ], },
	# [2163] opcode : ldd "[" iy "]" "," c
	{ "\n" => [ 7, \&_action_opcode_608 ], ":" => [ 7, \&_action_opcode_608 ], },
	# [2164] opcode : ldd "[" iy "]" "," d
	{ "\n" => [ 7, \&_action_opcode_609 ], ":" => [ 7, \&_action_opcode_609 ], },
	# [2165] opcode : ldd "[" iy "]" "," e
	{ "\n" => [ 7, \&_action_opcode_610 ], ":" => [ 7, \&_action_opcode_610 ], },
	# [2166] opcode : ldd "[" iy "]" "," h
	{ "\n" => [ 7, \&_action_opcode_611 ], ":" => [ 7, \&_action_opcode_611 ], },
	# [2167] opcode : ldd "[" iy "]" "," l
	{ "\n" => [ 7, \&_action_opcode_612 ], ":" => [ 7, \&_action_opcode_612 ], },
	# [2168] opcode : ldd a
	{ "," => 2169, },
	# [2169] opcode : ldd a ","
	{ "(" => 2170, "[" => 2193, },
	# [2170] opcode : ldd a "," "("
	{ bc => 2171, de => 2173, hl => 2175, ix => 2177, iy => 2185, },
	# [2171] opcode : ldd a "," "(" bc
	{ ")" => 2172, },
	# [2172] opcode : ldd a "," "(" bc ")"
	{ "\n" => [ 7, \&_action_opcode_621 ], ":" => [ 7, \&_action_opcode_621 ], },
	# [2173] opcode : ldd a "," "(" de
	{ ")" => 2174, },
	# [2174] opcode : ldd a "," "(" de ")"
	{ "\n" => [ 7, \&_action_opcode_622 ], ":" => [ 7, \&_action_opcode_622 ], },
	# [2175] opcode : ldd a "," "(" hl
	{ ")" => 2176, },
	# [2176] opcode : ldd a "," "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_623 ], ":" => [ 7, \&_action_opcode_623 ], },
	# [2177] opcode : ldd a "," "(" ix
	{ ")" => 2178, "+" => 2179, "-" => 2182, },
	# [2178] opcode : ldd a "," "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_624 ], ":" => [ 7, \&_action_opcode_624 ], },
	# [2179] opcode : ldd a "," "(" ix "+"
	{ "!" => [ 12, 2180 ], "+" => [ 12, 2180 ], "-" => [ 12, 2180 ], __else__ => [ 12, 2180 ], "~" => [ 12, 2180 ], },
	# [2180] opcode : ldd a "," "(" ix "+" "[expr_DIS]"
	{ ")" => 2181, },
	# [2181] opcode : ldd a "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_625 ], ":" => [ 7, \&_action_opcode_625 ], },
	# [2182] opcode : ldd a "," "(" ix "-"
	{ "!" => [ 14, 2183 ], "+" => [ 14, 2183 ], "-" => [ 14, 2183 ], __else__ => [ 14, 2183 ], "~" => [ 14, 2183 ], },
	# [2183] opcode : ldd a "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 2184, },
	# [2184] opcode : ldd a "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_625 ], ":" => [ 7, \&_action_opcode_625 ], },
	# [2185] opcode : ldd a "," "(" iy
	{ ")" => 2186, "+" => 2187, "-" => 2190, },
	# [2186] opcode : ldd a "," "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_626 ], ":" => [ 7, \&_action_opcode_626 ], },
	# [2187] opcode : ldd a "," "(" iy "+"
	{ "!" => [ 12, 2188 ], "+" => [ 12, 2188 ], "-" => [ 12, 2188 ], __else__ => [ 12, 2188 ], "~" => [ 12, 2188 ], },
	# [2188] opcode : ldd a "," "(" iy "+" "[expr_DIS]"
	{ ")" => 2189, },
	# [2189] opcode : ldd a "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_627 ], ":" => [ 7, \&_action_opcode_627 ], },
	# [2190] opcode : ldd a "," "(" iy "-"
	{ "!" => [ 14, 2191 ], "+" => [ 14, 2191 ], "-" => [ 14, 2191 ], __else__ => [ 14, 2191 ], "~" => [ 14, 2191 ], },
	# [2191] opcode : ldd a "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 2192, },
	# [2192] opcode : ldd a "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_627 ], ":" => [ 7, \&_action_opcode_627 ], },
	# [2193] opcode : ldd a "," "["
	{ bc => 2194, de => 2196, hl => 2198, ix => 2200, iy => 2208, },
	# [2194] opcode : ldd a "," "[" bc
	{ "]" => 2195, },
	# [2195] opcode : ldd a "," "[" bc "]"
	{ "\n" => [ 7, \&_action_opcode_621 ], ":" => [ 7, \&_action_opcode_621 ], },
	# [2196] opcode : ldd a "," "[" de
	{ "]" => 2197, },
	# [2197] opcode : ldd a "," "[" de "]"
	{ "\n" => [ 7, \&_action_opcode_622 ], ":" => [ 7, \&_action_opcode_622 ], },
	# [2198] opcode : ldd a "," "[" hl
	{ "]" => 2199, },
	# [2199] opcode : ldd a "," "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_623 ], ":" => [ 7, \&_action_opcode_623 ], },
	# [2200] opcode : ldd a "," "[" ix
	{ "+" => 2201, "-" => 2204, "]" => 2207, },
	# [2201] opcode : ldd a "," "[" ix "+"
	{ "!" => [ 12, 2202 ], "+" => [ 12, 2202 ], "-" => [ 12, 2202 ], __else__ => [ 12, 2202 ], "~" => [ 12, 2202 ], },
	# [2202] opcode : ldd a "," "[" ix "+" "[expr_DIS]"
	{ "]" => 2203, },
	# [2203] opcode : ldd a "," "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_625 ], ":" => [ 7, \&_action_opcode_625 ], },
	# [2204] opcode : ldd a "," "[" ix "-"
	{ "!" => [ 14, 2205 ], "+" => [ 14, 2205 ], "-" => [ 14, 2205 ], __else__ => [ 14, 2205 ], "~" => [ 14, 2205 ], },
	# [2205] opcode : ldd a "," "[" ix "-" "[expr_NDIS]"
	{ "]" => 2206, },
	# [2206] opcode : ldd a "," "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_625 ], ":" => [ 7, \&_action_opcode_625 ], },
	# [2207] opcode : ldd a "," "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_624 ], ":" => [ 7, \&_action_opcode_624 ], },
	# [2208] opcode : ldd a "," "[" iy
	{ "+" => 2209, "-" => 2212, "]" => 2215, },
	# [2209] opcode : ldd a "," "[" iy "+"
	{ "!" => [ 12, 2210 ], "+" => [ 12, 2210 ], "-" => [ 12, 2210 ], __else__ => [ 12, 2210 ], "~" => [ 12, 2210 ], },
	# [2210] opcode : ldd a "," "[" iy "+" "[expr_DIS]"
	{ "]" => 2211, },
	# [2211] opcode : ldd a "," "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_627 ], ":" => [ 7, \&_action_opcode_627 ], },
	# [2212] opcode : ldd a "," "[" iy "-"
	{ "!" => [ 14, 2213 ], "+" => [ 14, 2213 ], "-" => [ 14, 2213 ], __else__ => [ 14, 2213 ], "~" => [ 14, 2213 ], },
	# [2213] opcode : ldd a "," "[" iy "-" "[expr_NDIS]"
	{ "]" => 2214, },
	# [2214] opcode : ldd a "," "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_627 ], ":" => [ 7, \&_action_opcode_627 ], },
	# [2215] opcode : ldd a "," "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_626 ], ":" => [ 7, \&_action_opcode_626 ], },
	# [2216] opcode : ldd b
	{ "," => 2217, },
	# [2217] opcode : ldd b ","
	{ "(" => 2218, "[" => 2237, },
	# [2218] opcode : ldd b "," "("
	{ hl => 2219, ix => 2221, iy => 2229, },
	# [2219] opcode : ldd b "," "(" hl
	{ ")" => 2220, },
	# [2220] opcode : ldd b "," "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_628 ], ":" => [ 7, \&_action_opcode_628 ], },
	# [2221] opcode : ldd b "," "(" ix
	{ ")" => 2222, "+" => 2223, "-" => 2226, },
	# [2222] opcode : ldd b "," "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_629 ], ":" => [ 7, \&_action_opcode_629 ], },
	# [2223] opcode : ldd b "," "(" ix "+"
	{ "!" => [ 12, 2224 ], "+" => [ 12, 2224 ], "-" => [ 12, 2224 ], __else__ => [ 12, 2224 ], "~" => [ 12, 2224 ], },
	# [2224] opcode : ldd b "," "(" ix "+" "[expr_DIS]"
	{ ")" => 2225, },
	# [2225] opcode : ldd b "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_630 ], ":" => [ 7, \&_action_opcode_630 ], },
	# [2226] opcode : ldd b "," "(" ix "-"
	{ "!" => [ 14, 2227 ], "+" => [ 14, 2227 ], "-" => [ 14, 2227 ], __else__ => [ 14, 2227 ], "~" => [ 14, 2227 ], },
	# [2227] opcode : ldd b "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 2228, },
	# [2228] opcode : ldd b "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_630 ], ":" => [ 7, \&_action_opcode_630 ], },
	# [2229] opcode : ldd b "," "(" iy
	{ ")" => 2230, "+" => 2231, "-" => 2234, },
	# [2230] opcode : ldd b "," "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_631 ], ":" => [ 7, \&_action_opcode_631 ], },
	# [2231] opcode : ldd b "," "(" iy "+"
	{ "!" => [ 12, 2232 ], "+" => [ 12, 2232 ], "-" => [ 12, 2232 ], __else__ => [ 12, 2232 ], "~" => [ 12, 2232 ], },
	# [2232] opcode : ldd b "," "(" iy "+" "[expr_DIS]"
	{ ")" => 2233, },
	# [2233] opcode : ldd b "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_632 ], ":" => [ 7, \&_action_opcode_632 ], },
	# [2234] opcode : ldd b "," "(" iy "-"
	{ "!" => [ 14, 2235 ], "+" => [ 14, 2235 ], "-" => [ 14, 2235 ], __else__ => [ 14, 2235 ], "~" => [ 14, 2235 ], },
	# [2235] opcode : ldd b "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 2236, },
	# [2236] opcode : ldd b "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_632 ], ":" => [ 7, \&_action_opcode_632 ], },
	# [2237] opcode : ldd b "," "["
	{ hl => 2238, ix => 2240, iy => 2248, },
	# [2238] opcode : ldd b "," "[" hl
	{ "]" => 2239, },
	# [2239] opcode : ldd b "," "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_628 ], ":" => [ 7, \&_action_opcode_628 ], },
	# [2240] opcode : ldd b "," "[" ix
	{ "+" => 2241, "-" => 2244, "]" => 2247, },
	# [2241] opcode : ldd b "," "[" ix "+"
	{ "!" => [ 12, 2242 ], "+" => [ 12, 2242 ], "-" => [ 12, 2242 ], __else__ => [ 12, 2242 ], "~" => [ 12, 2242 ], },
	# [2242] opcode : ldd b "," "[" ix "+" "[expr_DIS]"
	{ "]" => 2243, },
	# [2243] opcode : ldd b "," "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_630 ], ":" => [ 7, \&_action_opcode_630 ], },
	# [2244] opcode : ldd b "," "[" ix "-"
	{ "!" => [ 14, 2245 ], "+" => [ 14, 2245 ], "-" => [ 14, 2245 ], __else__ => [ 14, 2245 ], "~" => [ 14, 2245 ], },
	# [2245] opcode : ldd b "," "[" ix "-" "[expr_NDIS]"
	{ "]" => 2246, },
	# [2246] opcode : ldd b "," "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_630 ], ":" => [ 7, \&_action_opcode_630 ], },
	# [2247] opcode : ldd b "," "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_629 ], ":" => [ 7, \&_action_opcode_629 ], },
	# [2248] opcode : ldd b "," "[" iy
	{ "+" => 2249, "-" => 2252, "]" => 2255, },
	# [2249] opcode : ldd b "," "[" iy "+"
	{ "!" => [ 12, 2250 ], "+" => [ 12, 2250 ], "-" => [ 12, 2250 ], __else__ => [ 12, 2250 ], "~" => [ 12, 2250 ], },
	# [2250] opcode : ldd b "," "[" iy "+" "[expr_DIS]"
	{ "]" => 2251, },
	# [2251] opcode : ldd b "," "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_632 ], ":" => [ 7, \&_action_opcode_632 ], },
	# [2252] opcode : ldd b "," "[" iy "-"
	{ "!" => [ 14, 2253 ], "+" => [ 14, 2253 ], "-" => [ 14, 2253 ], __else__ => [ 14, 2253 ], "~" => [ 14, 2253 ], },
	# [2253] opcode : ldd b "," "[" iy "-" "[expr_NDIS]"
	{ "]" => 2254, },
	# [2254] opcode : ldd b "," "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_632 ], ":" => [ 7, \&_action_opcode_632 ], },
	# [2255] opcode : ldd b "," "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_631 ], ":" => [ 7, \&_action_opcode_631 ], },
	# [2256] opcode : ldd c
	{ "," => 2257, },
	# [2257] opcode : ldd c ","
	{ "(" => 2258, "[" => 2277, },
	# [2258] opcode : ldd c "," "("
	{ hl => 2259, ix => 2261, iy => 2269, },
	# [2259] opcode : ldd c "," "(" hl
	{ ")" => 2260, },
	# [2260] opcode : ldd c "," "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_633 ], ":" => [ 7, \&_action_opcode_633 ], },
	# [2261] opcode : ldd c "," "(" ix
	{ ")" => 2262, "+" => 2263, "-" => 2266, },
	# [2262] opcode : ldd c "," "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_634 ], ":" => [ 7, \&_action_opcode_634 ], },
	# [2263] opcode : ldd c "," "(" ix "+"
	{ "!" => [ 12, 2264 ], "+" => [ 12, 2264 ], "-" => [ 12, 2264 ], __else__ => [ 12, 2264 ], "~" => [ 12, 2264 ], },
	# [2264] opcode : ldd c "," "(" ix "+" "[expr_DIS]"
	{ ")" => 2265, },
	# [2265] opcode : ldd c "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_635 ], ":" => [ 7, \&_action_opcode_635 ], },
	# [2266] opcode : ldd c "," "(" ix "-"
	{ "!" => [ 14, 2267 ], "+" => [ 14, 2267 ], "-" => [ 14, 2267 ], __else__ => [ 14, 2267 ], "~" => [ 14, 2267 ], },
	# [2267] opcode : ldd c "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 2268, },
	# [2268] opcode : ldd c "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_635 ], ":" => [ 7, \&_action_opcode_635 ], },
	# [2269] opcode : ldd c "," "(" iy
	{ ")" => 2270, "+" => 2271, "-" => 2274, },
	# [2270] opcode : ldd c "," "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_636 ], ":" => [ 7, \&_action_opcode_636 ], },
	# [2271] opcode : ldd c "," "(" iy "+"
	{ "!" => [ 12, 2272 ], "+" => [ 12, 2272 ], "-" => [ 12, 2272 ], __else__ => [ 12, 2272 ], "~" => [ 12, 2272 ], },
	# [2272] opcode : ldd c "," "(" iy "+" "[expr_DIS]"
	{ ")" => 2273, },
	# [2273] opcode : ldd c "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_637 ], ":" => [ 7, \&_action_opcode_637 ], },
	# [2274] opcode : ldd c "," "(" iy "-"
	{ "!" => [ 14, 2275 ], "+" => [ 14, 2275 ], "-" => [ 14, 2275 ], __else__ => [ 14, 2275 ], "~" => [ 14, 2275 ], },
	# [2275] opcode : ldd c "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 2276, },
	# [2276] opcode : ldd c "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_637 ], ":" => [ 7, \&_action_opcode_637 ], },
	# [2277] opcode : ldd c "," "["
	{ hl => 2278, ix => 2280, iy => 2288, },
	# [2278] opcode : ldd c "," "[" hl
	{ "]" => 2279, },
	# [2279] opcode : ldd c "," "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_633 ], ":" => [ 7, \&_action_opcode_633 ], },
	# [2280] opcode : ldd c "," "[" ix
	{ "+" => 2281, "-" => 2284, "]" => 2287, },
	# [2281] opcode : ldd c "," "[" ix "+"
	{ "!" => [ 12, 2282 ], "+" => [ 12, 2282 ], "-" => [ 12, 2282 ], __else__ => [ 12, 2282 ], "~" => [ 12, 2282 ], },
	# [2282] opcode : ldd c "," "[" ix "+" "[expr_DIS]"
	{ "]" => 2283, },
	# [2283] opcode : ldd c "," "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_635 ], ":" => [ 7, \&_action_opcode_635 ], },
	# [2284] opcode : ldd c "," "[" ix "-"
	{ "!" => [ 14, 2285 ], "+" => [ 14, 2285 ], "-" => [ 14, 2285 ], __else__ => [ 14, 2285 ], "~" => [ 14, 2285 ], },
	# [2285] opcode : ldd c "," "[" ix "-" "[expr_NDIS]"
	{ "]" => 2286, },
	# [2286] opcode : ldd c "," "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_635 ], ":" => [ 7, \&_action_opcode_635 ], },
	# [2287] opcode : ldd c "," "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_634 ], ":" => [ 7, \&_action_opcode_634 ], },
	# [2288] opcode : ldd c "," "[" iy
	{ "+" => 2289, "-" => 2292, "]" => 2295, },
	# [2289] opcode : ldd c "," "[" iy "+"
	{ "!" => [ 12, 2290 ], "+" => [ 12, 2290 ], "-" => [ 12, 2290 ], __else__ => [ 12, 2290 ], "~" => [ 12, 2290 ], },
	# [2290] opcode : ldd c "," "[" iy "+" "[expr_DIS]"
	{ "]" => 2291, },
	# [2291] opcode : ldd c "," "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_637 ], ":" => [ 7, \&_action_opcode_637 ], },
	# [2292] opcode : ldd c "," "[" iy "-"
	{ "!" => [ 14, 2293 ], "+" => [ 14, 2293 ], "-" => [ 14, 2293 ], __else__ => [ 14, 2293 ], "~" => [ 14, 2293 ], },
	# [2293] opcode : ldd c "," "[" iy "-" "[expr_NDIS]"
	{ "]" => 2294, },
	# [2294] opcode : ldd c "," "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_637 ], ":" => [ 7, \&_action_opcode_637 ], },
	# [2295] opcode : ldd c "," "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_636 ], ":" => [ 7, \&_action_opcode_636 ], },
	# [2296] opcode : ldd d
	{ "," => 2297, },
	# [2297] opcode : ldd d ","
	{ "(" => 2298, "[" => 2317, },
	# [2298] opcode : ldd d "," "("
	{ hl => 2299, ix => 2301, iy => 2309, },
	# [2299] opcode : ldd d "," "(" hl
	{ ")" => 2300, },
	# [2300] opcode : ldd d "," "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_638 ], ":" => [ 7, \&_action_opcode_638 ], },
	# [2301] opcode : ldd d "," "(" ix
	{ ")" => 2302, "+" => 2303, "-" => 2306, },
	# [2302] opcode : ldd d "," "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_639 ], ":" => [ 7, \&_action_opcode_639 ], },
	# [2303] opcode : ldd d "," "(" ix "+"
	{ "!" => [ 12, 2304 ], "+" => [ 12, 2304 ], "-" => [ 12, 2304 ], __else__ => [ 12, 2304 ], "~" => [ 12, 2304 ], },
	# [2304] opcode : ldd d "," "(" ix "+" "[expr_DIS]"
	{ ")" => 2305, },
	# [2305] opcode : ldd d "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_640 ], ":" => [ 7, \&_action_opcode_640 ], },
	# [2306] opcode : ldd d "," "(" ix "-"
	{ "!" => [ 14, 2307 ], "+" => [ 14, 2307 ], "-" => [ 14, 2307 ], __else__ => [ 14, 2307 ], "~" => [ 14, 2307 ], },
	# [2307] opcode : ldd d "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 2308, },
	# [2308] opcode : ldd d "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_640 ], ":" => [ 7, \&_action_opcode_640 ], },
	# [2309] opcode : ldd d "," "(" iy
	{ ")" => 2310, "+" => 2311, "-" => 2314, },
	# [2310] opcode : ldd d "," "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_641 ], ":" => [ 7, \&_action_opcode_641 ], },
	# [2311] opcode : ldd d "," "(" iy "+"
	{ "!" => [ 12, 2312 ], "+" => [ 12, 2312 ], "-" => [ 12, 2312 ], __else__ => [ 12, 2312 ], "~" => [ 12, 2312 ], },
	# [2312] opcode : ldd d "," "(" iy "+" "[expr_DIS]"
	{ ")" => 2313, },
	# [2313] opcode : ldd d "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_642 ], ":" => [ 7, \&_action_opcode_642 ], },
	# [2314] opcode : ldd d "," "(" iy "-"
	{ "!" => [ 14, 2315 ], "+" => [ 14, 2315 ], "-" => [ 14, 2315 ], __else__ => [ 14, 2315 ], "~" => [ 14, 2315 ], },
	# [2315] opcode : ldd d "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 2316, },
	# [2316] opcode : ldd d "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_642 ], ":" => [ 7, \&_action_opcode_642 ], },
	# [2317] opcode : ldd d "," "["
	{ hl => 2318, ix => 2320, iy => 2328, },
	# [2318] opcode : ldd d "," "[" hl
	{ "]" => 2319, },
	# [2319] opcode : ldd d "," "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_638 ], ":" => [ 7, \&_action_opcode_638 ], },
	# [2320] opcode : ldd d "," "[" ix
	{ "+" => 2321, "-" => 2324, "]" => 2327, },
	# [2321] opcode : ldd d "," "[" ix "+"
	{ "!" => [ 12, 2322 ], "+" => [ 12, 2322 ], "-" => [ 12, 2322 ], __else__ => [ 12, 2322 ], "~" => [ 12, 2322 ], },
	# [2322] opcode : ldd d "," "[" ix "+" "[expr_DIS]"
	{ "]" => 2323, },
	# [2323] opcode : ldd d "," "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_640 ], ":" => [ 7, \&_action_opcode_640 ], },
	# [2324] opcode : ldd d "," "[" ix "-"
	{ "!" => [ 14, 2325 ], "+" => [ 14, 2325 ], "-" => [ 14, 2325 ], __else__ => [ 14, 2325 ], "~" => [ 14, 2325 ], },
	# [2325] opcode : ldd d "," "[" ix "-" "[expr_NDIS]"
	{ "]" => 2326, },
	# [2326] opcode : ldd d "," "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_640 ], ":" => [ 7, \&_action_opcode_640 ], },
	# [2327] opcode : ldd d "," "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_639 ], ":" => [ 7, \&_action_opcode_639 ], },
	# [2328] opcode : ldd d "," "[" iy
	{ "+" => 2329, "-" => 2332, "]" => 2335, },
	# [2329] opcode : ldd d "," "[" iy "+"
	{ "!" => [ 12, 2330 ], "+" => [ 12, 2330 ], "-" => [ 12, 2330 ], __else__ => [ 12, 2330 ], "~" => [ 12, 2330 ], },
	# [2330] opcode : ldd d "," "[" iy "+" "[expr_DIS]"
	{ "]" => 2331, },
	# [2331] opcode : ldd d "," "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_642 ], ":" => [ 7, \&_action_opcode_642 ], },
	# [2332] opcode : ldd d "," "[" iy "-"
	{ "!" => [ 14, 2333 ], "+" => [ 14, 2333 ], "-" => [ 14, 2333 ], __else__ => [ 14, 2333 ], "~" => [ 14, 2333 ], },
	# [2333] opcode : ldd d "," "[" iy "-" "[expr_NDIS]"
	{ "]" => 2334, },
	# [2334] opcode : ldd d "," "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_642 ], ":" => [ 7, \&_action_opcode_642 ], },
	# [2335] opcode : ldd d "," "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_641 ], ":" => [ 7, \&_action_opcode_641 ], },
	# [2336] opcode : ldd e
	{ "," => 2337, },
	# [2337] opcode : ldd e ","
	{ "(" => 2338, "[" => 2357, },
	# [2338] opcode : ldd e "," "("
	{ hl => 2339, ix => 2341, iy => 2349, },
	# [2339] opcode : ldd e "," "(" hl
	{ ")" => 2340, },
	# [2340] opcode : ldd e "," "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_643 ], ":" => [ 7, \&_action_opcode_643 ], },
	# [2341] opcode : ldd e "," "(" ix
	{ ")" => 2342, "+" => 2343, "-" => 2346, },
	# [2342] opcode : ldd e "," "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_644 ], ":" => [ 7, \&_action_opcode_644 ], },
	# [2343] opcode : ldd e "," "(" ix "+"
	{ "!" => [ 12, 2344 ], "+" => [ 12, 2344 ], "-" => [ 12, 2344 ], __else__ => [ 12, 2344 ], "~" => [ 12, 2344 ], },
	# [2344] opcode : ldd e "," "(" ix "+" "[expr_DIS]"
	{ ")" => 2345, },
	# [2345] opcode : ldd e "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_645 ], ":" => [ 7, \&_action_opcode_645 ], },
	# [2346] opcode : ldd e "," "(" ix "-"
	{ "!" => [ 14, 2347 ], "+" => [ 14, 2347 ], "-" => [ 14, 2347 ], __else__ => [ 14, 2347 ], "~" => [ 14, 2347 ], },
	# [2347] opcode : ldd e "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 2348, },
	# [2348] opcode : ldd e "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_645 ], ":" => [ 7, \&_action_opcode_645 ], },
	# [2349] opcode : ldd e "," "(" iy
	{ ")" => 2350, "+" => 2351, "-" => 2354, },
	# [2350] opcode : ldd e "," "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_646 ], ":" => [ 7, \&_action_opcode_646 ], },
	# [2351] opcode : ldd e "," "(" iy "+"
	{ "!" => [ 12, 2352 ], "+" => [ 12, 2352 ], "-" => [ 12, 2352 ], __else__ => [ 12, 2352 ], "~" => [ 12, 2352 ], },
	# [2352] opcode : ldd e "," "(" iy "+" "[expr_DIS]"
	{ ")" => 2353, },
	# [2353] opcode : ldd e "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_647 ], ":" => [ 7, \&_action_opcode_647 ], },
	# [2354] opcode : ldd e "," "(" iy "-"
	{ "!" => [ 14, 2355 ], "+" => [ 14, 2355 ], "-" => [ 14, 2355 ], __else__ => [ 14, 2355 ], "~" => [ 14, 2355 ], },
	# [2355] opcode : ldd e "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 2356, },
	# [2356] opcode : ldd e "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_647 ], ":" => [ 7, \&_action_opcode_647 ], },
	# [2357] opcode : ldd e "," "["
	{ hl => 2358, ix => 2360, iy => 2368, },
	# [2358] opcode : ldd e "," "[" hl
	{ "]" => 2359, },
	# [2359] opcode : ldd e "," "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_643 ], ":" => [ 7, \&_action_opcode_643 ], },
	# [2360] opcode : ldd e "," "[" ix
	{ "+" => 2361, "-" => 2364, "]" => 2367, },
	# [2361] opcode : ldd e "," "[" ix "+"
	{ "!" => [ 12, 2362 ], "+" => [ 12, 2362 ], "-" => [ 12, 2362 ], __else__ => [ 12, 2362 ], "~" => [ 12, 2362 ], },
	# [2362] opcode : ldd e "," "[" ix "+" "[expr_DIS]"
	{ "]" => 2363, },
	# [2363] opcode : ldd e "," "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_645 ], ":" => [ 7, \&_action_opcode_645 ], },
	# [2364] opcode : ldd e "," "[" ix "-"
	{ "!" => [ 14, 2365 ], "+" => [ 14, 2365 ], "-" => [ 14, 2365 ], __else__ => [ 14, 2365 ], "~" => [ 14, 2365 ], },
	# [2365] opcode : ldd e "," "[" ix "-" "[expr_NDIS]"
	{ "]" => 2366, },
	# [2366] opcode : ldd e "," "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_645 ], ":" => [ 7, \&_action_opcode_645 ], },
	# [2367] opcode : ldd e "," "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_644 ], ":" => [ 7, \&_action_opcode_644 ], },
	# [2368] opcode : ldd e "," "[" iy
	{ "+" => 2369, "-" => 2372, "]" => 2375, },
	# [2369] opcode : ldd e "," "[" iy "+"
	{ "!" => [ 12, 2370 ], "+" => [ 12, 2370 ], "-" => [ 12, 2370 ], __else__ => [ 12, 2370 ], "~" => [ 12, 2370 ], },
	# [2370] opcode : ldd e "," "[" iy "+" "[expr_DIS]"
	{ "]" => 2371, },
	# [2371] opcode : ldd e "," "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_647 ], ":" => [ 7, \&_action_opcode_647 ], },
	# [2372] opcode : ldd e "," "[" iy "-"
	{ "!" => [ 14, 2373 ], "+" => [ 14, 2373 ], "-" => [ 14, 2373 ], __else__ => [ 14, 2373 ], "~" => [ 14, 2373 ], },
	# [2373] opcode : ldd e "," "[" iy "-" "[expr_NDIS]"
	{ "]" => 2374, },
	# [2374] opcode : ldd e "," "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_647 ], ":" => [ 7, \&_action_opcode_647 ], },
	# [2375] opcode : ldd e "," "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_646 ], ":" => [ 7, \&_action_opcode_646 ], },
	# [2376] opcode : ldd h
	{ "," => 2377, },
	# [2377] opcode : ldd h ","
	{ "(" => 2378, "[" => 2397, },
	# [2378] opcode : ldd h "," "("
	{ hl => 2379, ix => 2381, iy => 2389, },
	# [2379] opcode : ldd h "," "(" hl
	{ ")" => 2380, },
	# [2380] opcode : ldd h "," "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_648 ], ":" => [ 7, \&_action_opcode_648 ], },
	# [2381] opcode : ldd h "," "(" ix
	{ ")" => 2382, "+" => 2383, "-" => 2386, },
	# [2382] opcode : ldd h "," "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_649 ], ":" => [ 7, \&_action_opcode_649 ], },
	# [2383] opcode : ldd h "," "(" ix "+"
	{ "!" => [ 12, 2384 ], "+" => [ 12, 2384 ], "-" => [ 12, 2384 ], __else__ => [ 12, 2384 ], "~" => [ 12, 2384 ], },
	# [2384] opcode : ldd h "," "(" ix "+" "[expr_DIS]"
	{ ")" => 2385, },
	# [2385] opcode : ldd h "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_650 ], ":" => [ 7, \&_action_opcode_650 ], },
	# [2386] opcode : ldd h "," "(" ix "-"
	{ "!" => [ 14, 2387 ], "+" => [ 14, 2387 ], "-" => [ 14, 2387 ], __else__ => [ 14, 2387 ], "~" => [ 14, 2387 ], },
	# [2387] opcode : ldd h "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 2388, },
	# [2388] opcode : ldd h "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_650 ], ":" => [ 7, \&_action_opcode_650 ], },
	# [2389] opcode : ldd h "," "(" iy
	{ ")" => 2390, "+" => 2391, "-" => 2394, },
	# [2390] opcode : ldd h "," "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_651 ], ":" => [ 7, \&_action_opcode_651 ], },
	# [2391] opcode : ldd h "," "(" iy "+"
	{ "!" => [ 12, 2392 ], "+" => [ 12, 2392 ], "-" => [ 12, 2392 ], __else__ => [ 12, 2392 ], "~" => [ 12, 2392 ], },
	# [2392] opcode : ldd h "," "(" iy "+" "[expr_DIS]"
	{ ")" => 2393, },
	# [2393] opcode : ldd h "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_652 ], ":" => [ 7, \&_action_opcode_652 ], },
	# [2394] opcode : ldd h "," "(" iy "-"
	{ "!" => [ 14, 2395 ], "+" => [ 14, 2395 ], "-" => [ 14, 2395 ], __else__ => [ 14, 2395 ], "~" => [ 14, 2395 ], },
	# [2395] opcode : ldd h "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 2396, },
	# [2396] opcode : ldd h "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_652 ], ":" => [ 7, \&_action_opcode_652 ], },
	# [2397] opcode : ldd h "," "["
	{ hl => 2398, ix => 2400, iy => 2408, },
	# [2398] opcode : ldd h "," "[" hl
	{ "]" => 2399, },
	# [2399] opcode : ldd h "," "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_648 ], ":" => [ 7, \&_action_opcode_648 ], },
	# [2400] opcode : ldd h "," "[" ix
	{ "+" => 2401, "-" => 2404, "]" => 2407, },
	# [2401] opcode : ldd h "," "[" ix "+"
	{ "!" => [ 12, 2402 ], "+" => [ 12, 2402 ], "-" => [ 12, 2402 ], __else__ => [ 12, 2402 ], "~" => [ 12, 2402 ], },
	# [2402] opcode : ldd h "," "[" ix "+" "[expr_DIS]"
	{ "]" => 2403, },
	# [2403] opcode : ldd h "," "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_650 ], ":" => [ 7, \&_action_opcode_650 ], },
	# [2404] opcode : ldd h "," "[" ix "-"
	{ "!" => [ 14, 2405 ], "+" => [ 14, 2405 ], "-" => [ 14, 2405 ], __else__ => [ 14, 2405 ], "~" => [ 14, 2405 ], },
	# [2405] opcode : ldd h "," "[" ix "-" "[expr_NDIS]"
	{ "]" => 2406, },
	# [2406] opcode : ldd h "," "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_650 ], ":" => [ 7, \&_action_opcode_650 ], },
	# [2407] opcode : ldd h "," "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_649 ], ":" => [ 7, \&_action_opcode_649 ], },
	# [2408] opcode : ldd h "," "[" iy
	{ "+" => 2409, "-" => 2412, "]" => 2415, },
	# [2409] opcode : ldd h "," "[" iy "+"
	{ "!" => [ 12, 2410 ], "+" => [ 12, 2410 ], "-" => [ 12, 2410 ], __else__ => [ 12, 2410 ], "~" => [ 12, 2410 ], },
	# [2410] opcode : ldd h "," "[" iy "+" "[expr_DIS]"
	{ "]" => 2411, },
	# [2411] opcode : ldd h "," "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_652 ], ":" => [ 7, \&_action_opcode_652 ], },
	# [2412] opcode : ldd h "," "[" iy "-"
	{ "!" => [ 14, 2413 ], "+" => [ 14, 2413 ], "-" => [ 14, 2413 ], __else__ => [ 14, 2413 ], "~" => [ 14, 2413 ], },
	# [2413] opcode : ldd h "," "[" iy "-" "[expr_NDIS]"
	{ "]" => 2414, },
	# [2414] opcode : ldd h "," "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_652 ], ":" => [ 7, \&_action_opcode_652 ], },
	# [2415] opcode : ldd h "," "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_651 ], ":" => [ 7, \&_action_opcode_651 ], },
	# [2416] opcode : ldd l
	{ "," => 2417, },
	# [2417] opcode : ldd l ","
	{ "(" => 2418, "[" => 2437, },
	# [2418] opcode : ldd l "," "("
	{ hl => 2419, ix => 2421, iy => 2429, },
	# [2419] opcode : ldd l "," "(" hl
	{ ")" => 2420, },
	# [2420] opcode : ldd l "," "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_653 ], ":" => [ 7, \&_action_opcode_653 ], },
	# [2421] opcode : ldd l "," "(" ix
	{ ")" => 2422, "+" => 2423, "-" => 2426, },
	# [2422] opcode : ldd l "," "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_654 ], ":" => [ 7, \&_action_opcode_654 ], },
	# [2423] opcode : ldd l "," "(" ix "+"
	{ "!" => [ 12, 2424 ], "+" => [ 12, 2424 ], "-" => [ 12, 2424 ], __else__ => [ 12, 2424 ], "~" => [ 12, 2424 ], },
	# [2424] opcode : ldd l "," "(" ix "+" "[expr_DIS]"
	{ ")" => 2425, },
	# [2425] opcode : ldd l "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_655 ], ":" => [ 7, \&_action_opcode_655 ], },
	# [2426] opcode : ldd l "," "(" ix "-"
	{ "!" => [ 14, 2427 ], "+" => [ 14, 2427 ], "-" => [ 14, 2427 ], __else__ => [ 14, 2427 ], "~" => [ 14, 2427 ], },
	# [2427] opcode : ldd l "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 2428, },
	# [2428] opcode : ldd l "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_655 ], ":" => [ 7, \&_action_opcode_655 ], },
	# [2429] opcode : ldd l "," "(" iy
	{ ")" => 2430, "+" => 2431, "-" => 2434, },
	# [2430] opcode : ldd l "," "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_656 ], ":" => [ 7, \&_action_opcode_656 ], },
	# [2431] opcode : ldd l "," "(" iy "+"
	{ "!" => [ 12, 2432 ], "+" => [ 12, 2432 ], "-" => [ 12, 2432 ], __else__ => [ 12, 2432 ], "~" => [ 12, 2432 ], },
	# [2432] opcode : ldd l "," "(" iy "+" "[expr_DIS]"
	{ ")" => 2433, },
	# [2433] opcode : ldd l "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_657 ], ":" => [ 7, \&_action_opcode_657 ], },
	# [2434] opcode : ldd l "," "(" iy "-"
	{ "!" => [ 14, 2435 ], "+" => [ 14, 2435 ], "-" => [ 14, 2435 ], __else__ => [ 14, 2435 ], "~" => [ 14, 2435 ], },
	# [2435] opcode : ldd l "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 2436, },
	# [2436] opcode : ldd l "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_657 ], ":" => [ 7, \&_action_opcode_657 ], },
	# [2437] opcode : ldd l "," "["
	{ hl => 2438, ix => 2440, iy => 2448, },
	# [2438] opcode : ldd l "," "[" hl
	{ "]" => 2439, },
	# [2439] opcode : ldd l "," "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_653 ], ":" => [ 7, \&_action_opcode_653 ], },
	# [2440] opcode : ldd l "," "[" ix
	{ "+" => 2441, "-" => 2444, "]" => 2447, },
	# [2441] opcode : ldd l "," "[" ix "+"
	{ "!" => [ 12, 2442 ], "+" => [ 12, 2442 ], "-" => [ 12, 2442 ], __else__ => [ 12, 2442 ], "~" => [ 12, 2442 ], },
	# [2442] opcode : ldd l "," "[" ix "+" "[expr_DIS]"
	{ "]" => 2443, },
	# [2443] opcode : ldd l "," "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_655 ], ":" => [ 7, \&_action_opcode_655 ], },
	# [2444] opcode : ldd l "," "[" ix "-"
	{ "!" => [ 14, 2445 ], "+" => [ 14, 2445 ], "-" => [ 14, 2445 ], __else__ => [ 14, 2445 ], "~" => [ 14, 2445 ], },
	# [2445] opcode : ldd l "," "[" ix "-" "[expr_NDIS]"
	{ "]" => 2446, },
	# [2446] opcode : ldd l "," "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_655 ], ":" => [ 7, \&_action_opcode_655 ], },
	# [2447] opcode : ldd l "," "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_654 ], ":" => [ 7, \&_action_opcode_654 ], },
	# [2448] opcode : ldd l "," "[" iy
	{ "+" => 2449, "-" => 2452, "]" => 2455, },
	# [2449] opcode : ldd l "," "[" iy "+"
	{ "!" => [ 12, 2450 ], "+" => [ 12, 2450 ], "-" => [ 12, 2450 ], __else__ => [ 12, 2450 ], "~" => [ 12, 2450 ], },
	# [2450] opcode : ldd l "," "[" iy "+" "[expr_DIS]"
	{ "]" => 2451, },
	# [2451] opcode : ldd l "," "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_657 ], ":" => [ 7, \&_action_opcode_657 ], },
	# [2452] opcode : ldd l "," "[" iy "-"
	{ "!" => [ 14, 2453 ], "+" => [ 14, 2453 ], "-" => [ 14, 2453 ], __else__ => [ 14, 2453 ], "~" => [ 14, 2453 ], },
	# [2453] opcode : ldd l "," "[" iy "-" "[expr_NDIS]"
	{ "]" => 2454, },
	# [2454] opcode : ldd l "," "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_657 ], ":" => [ 7, \&_action_opcode_657 ], },
	# [2455] opcode : ldd l "," "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_656 ], ":" => [ 7, \&_action_opcode_656 ], },
	# [2456] opcode : lddr
	{ "\n" => [ 7, \&_action_opcode_658 ], ":" => [ 7, \&_action_opcode_658 ], },
	# [2457] opcode : ldi
	{ "\n" => [ 7, \&_action_opcode_659 ], "(" => 2458, ":" => [ 7, \&_action_opcode_659 ], "[" => 2568, a => 2678, b => 2726, bc => 2766, c => 2806, d => 2846, de => 2886, e => 2926, h => 2966, hl => 3006, l => 3042, },
	# [2458] opcode : ldi "("
	{ bc => 2459, de => 2463, hl => 2467, ix => 2480, iy => 2524, },
	# [2459] opcode : ldi "(" bc
	{ ")" => 2460, },
	# [2460] opcode : ldi "(" bc ")"
	{ "," => 2461, },
	# [2461] opcode : ldi "(" bc ")" ","
	{ a => 2462, },
	# [2462] opcode : ldi "(" bc ")" "," a
	{ "\n" => [ 7, \&_action_opcode_660 ], ":" => [ 7, \&_action_opcode_660 ], },
	# [2463] opcode : ldi "(" de
	{ ")" => 2464, },
	# [2464] opcode : ldi "(" de ")"
	{ "," => 2465, },
	# [2465] opcode : ldi "(" de ")" ","
	{ a => 2466, },
	# [2466] opcode : ldi "(" de ")" "," a
	{ "\n" => [ 7, \&_action_opcode_661 ], ":" => [ 7, \&_action_opcode_661 ], },
	# [2467] opcode : ldi "(" hl
	{ ")" => 2468, },
	# [2468] opcode : ldi "(" hl ")"
	{ "," => 2469, },
	# [2469] opcode : ldi "(" hl ")" ","
	{ "!" => [ 13, 2470 ], "+" => [ 13, 2470 ], "-" => [ 13, 2470 ], __else__ => [ 13, 2470 ], a => 2471, b => 2472, bc => 2473, c => 2474, d => 2475, de => 2476, e => 2477, h => 2478, l => 2479, "~" => [ 13, 2470 ], },
	# [2470] opcode : ldi "(" hl ")" "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_662 ], ":" => [ 7, \&_action_opcode_662 ], },
	# [2471] opcode : ldi "(" hl ")" "," a
	{ "\n" => [ 7, \&_action_opcode_663 ], ":" => [ 7, \&_action_opcode_663 ], },
	# [2472] opcode : ldi "(" hl ")" "," b
	{ "\n" => [ 7, \&_action_opcode_664 ], ":" => [ 7, \&_action_opcode_664 ], },
	# [2473] opcode : ldi "(" hl ")" "," bc
	{ "\n" => [ 7, \&_action_opcode_665 ], ":" => [ 7, \&_action_opcode_665 ], },
	# [2474] opcode : ldi "(" hl ")" "," c
	{ "\n" => [ 7, \&_action_opcode_666 ], ":" => [ 7, \&_action_opcode_666 ], },
	# [2475] opcode : ldi "(" hl ")" "," d
	{ "\n" => [ 7, \&_action_opcode_667 ], ":" => [ 7, \&_action_opcode_667 ], },
	# [2476] opcode : ldi "(" hl ")" "," de
	{ "\n" => [ 7, \&_action_opcode_668 ], ":" => [ 7, \&_action_opcode_668 ], },
	# [2477] opcode : ldi "(" hl ")" "," e
	{ "\n" => [ 7, \&_action_opcode_669 ], ":" => [ 7, \&_action_opcode_669 ], },
	# [2478] opcode : ldi "(" hl ")" "," h
	{ "\n" => [ 7, \&_action_opcode_670 ], ":" => [ 7, \&_action_opcode_670 ], },
	# [2479] opcode : ldi "(" hl ")" "," l
	{ "\n" => [ 7, \&_action_opcode_671 ], ":" => [ 7, \&_action_opcode_671 ], },
	# [2480] opcode : ldi "(" ix
	{ ")" => 2481, "+" => 2494, "-" => 2509, },
	# [2481] opcode : ldi "(" ix ")"
	{ "," => 2482, },
	# [2482] opcode : ldi "(" ix ")" ","
	{ "!" => [ 13, 2483 ], "+" => [ 13, 2483 ], "-" => [ 13, 2483 ], __else__ => [ 13, 2483 ], a => 2484, b => 2485, bc => 2486, c => 2487, d => 2488, de => 2489, e => 2490, h => 2491, hl => 2492, l => 2493, "~" => [ 13, 2483 ], },
	# [2483] opcode : ldi "(" ix ")" "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_672 ], ":" => [ 7, \&_action_opcode_672 ], },
	# [2484] opcode : ldi "(" ix ")" "," a
	{ "\n" => [ 7, \&_action_opcode_673 ], ":" => [ 7, \&_action_opcode_673 ], },
	# [2485] opcode : ldi "(" ix ")" "," b
	{ "\n" => [ 7, \&_action_opcode_674 ], ":" => [ 7, \&_action_opcode_674 ], },
	# [2486] opcode : ldi "(" ix ")" "," bc
	{ "\n" => [ 7, \&_action_opcode_675 ], ":" => [ 7, \&_action_opcode_675 ], },
	# [2487] opcode : ldi "(" ix ")" "," c
	{ "\n" => [ 7, \&_action_opcode_676 ], ":" => [ 7, \&_action_opcode_676 ], },
	# [2488] opcode : ldi "(" ix ")" "," d
	{ "\n" => [ 7, \&_action_opcode_677 ], ":" => [ 7, \&_action_opcode_677 ], },
	# [2489] opcode : ldi "(" ix ")" "," de
	{ "\n" => [ 7, \&_action_opcode_678 ], ":" => [ 7, \&_action_opcode_678 ], },
	# [2490] opcode : ldi "(" ix ")" "," e
	{ "\n" => [ 7, \&_action_opcode_679 ], ":" => [ 7, \&_action_opcode_679 ], },
	# [2491] opcode : ldi "(" ix ")" "," h
	{ "\n" => [ 7, \&_action_opcode_680 ], ":" => [ 7, \&_action_opcode_680 ], },
	# [2492] opcode : ldi "(" ix ")" "," hl
	{ "\n" => [ 7, \&_action_opcode_681 ], ":" => [ 7, \&_action_opcode_681 ], },
	# [2493] opcode : ldi "(" ix ")" "," l
	{ "\n" => [ 7, \&_action_opcode_682 ], ":" => [ 7, \&_action_opcode_682 ], },
	# [2494] opcode : ldi "(" ix "+"
	{ "!" => [ 12, 2495 ], "+" => [ 12, 2495 ], "-" => [ 12, 2495 ], __else__ => [ 12, 2495 ], "~" => [ 12, 2495 ], },
	# [2495] opcode : ldi "(" ix "+" "[expr_DIS]"
	{ ")" => 2496, },
	# [2496] opcode : ldi "(" ix "+" "[expr_DIS]" ")"
	{ "," => 2497, },
	# [2497] opcode : ldi "(" ix "+" "[expr_DIS]" ")" ","
	{ "!" => [ 13, 2498 ], "+" => [ 13, 2498 ], "-" => [ 13, 2498 ], __else__ => [ 13, 2498 ], a => 2499, b => 2500, bc => 2501, c => 2502, d => 2503, de => 2504, e => 2505, h => 2506, hl => 2507, l => 2508, "~" => [ 13, 2498 ], },
	# [2498] opcode : ldi "(" ix "+" "[expr_DIS]" ")" "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_683 ], ":" => [ 7, \&_action_opcode_683 ], },
	# [2499] opcode : ldi "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_684 ], ":" => [ 7, \&_action_opcode_684 ], },
	# [2500] opcode : ldi "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_685 ], ":" => [ 7, \&_action_opcode_685 ], },
	# [2501] opcode : ldi "(" ix "+" "[expr_DIS]" ")" "," bc
	{ "\n" => [ 7, \&_action_opcode_686 ], ":" => [ 7, \&_action_opcode_686 ], },
	# [2502] opcode : ldi "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_687 ], ":" => [ 7, \&_action_opcode_687 ], },
	# [2503] opcode : ldi "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_688 ], ":" => [ 7, \&_action_opcode_688 ], },
	# [2504] opcode : ldi "(" ix "+" "[expr_DIS]" ")" "," de
	{ "\n" => [ 7, \&_action_opcode_689 ], ":" => [ 7, \&_action_opcode_689 ], },
	# [2505] opcode : ldi "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_690 ], ":" => [ 7, \&_action_opcode_690 ], },
	# [2506] opcode : ldi "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_691 ], ":" => [ 7, \&_action_opcode_691 ], },
	# [2507] opcode : ldi "(" ix "+" "[expr_DIS]" ")" "," hl
	{ "\n" => [ 7, \&_action_opcode_692 ], ":" => [ 7, \&_action_opcode_692 ], },
	# [2508] opcode : ldi "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_693 ], ":" => [ 7, \&_action_opcode_693 ], },
	# [2509] opcode : ldi "(" ix "-"
	{ "!" => [ 14, 2510 ], "+" => [ 14, 2510 ], "-" => [ 14, 2510 ], __else__ => [ 14, 2510 ], "~" => [ 14, 2510 ], },
	# [2510] opcode : ldi "(" ix "-" "[expr_NDIS]"
	{ ")" => 2511, },
	# [2511] opcode : ldi "(" ix "-" "[expr_NDIS]" ")"
	{ "," => 2512, },
	# [2512] opcode : ldi "(" ix "-" "[expr_NDIS]" ")" ","
	{ "!" => [ 13, 2513 ], "+" => [ 13, 2513 ], "-" => [ 13, 2513 ], __else__ => [ 13, 2513 ], a => 2514, b => 2515, bc => 2516, c => 2517, d => 2518, de => 2519, e => 2520, h => 2521, hl => 2522, l => 2523, "~" => [ 13, 2513 ], },
	# [2513] opcode : ldi "(" ix "-" "[expr_NDIS]" ")" "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_683 ], ":" => [ 7, \&_action_opcode_683 ], },
	# [2514] opcode : ldi "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_684 ], ":" => [ 7, \&_action_opcode_684 ], },
	# [2515] opcode : ldi "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_685 ], ":" => [ 7, \&_action_opcode_685 ], },
	# [2516] opcode : ldi "(" ix "-" "[expr_NDIS]" ")" "," bc
	{ "\n" => [ 7, \&_action_opcode_686 ], ":" => [ 7, \&_action_opcode_686 ], },
	# [2517] opcode : ldi "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_687 ], ":" => [ 7, \&_action_opcode_687 ], },
	# [2518] opcode : ldi "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_688 ], ":" => [ 7, \&_action_opcode_688 ], },
	# [2519] opcode : ldi "(" ix "-" "[expr_NDIS]" ")" "," de
	{ "\n" => [ 7, \&_action_opcode_689 ], ":" => [ 7, \&_action_opcode_689 ], },
	# [2520] opcode : ldi "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_690 ], ":" => [ 7, \&_action_opcode_690 ], },
	# [2521] opcode : ldi "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_691 ], ":" => [ 7, \&_action_opcode_691 ], },
	# [2522] opcode : ldi "(" ix "-" "[expr_NDIS]" ")" "," hl
	{ "\n" => [ 7, \&_action_opcode_692 ], ":" => [ 7, \&_action_opcode_692 ], },
	# [2523] opcode : ldi "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_693 ], ":" => [ 7, \&_action_opcode_693 ], },
	# [2524] opcode : ldi "(" iy
	{ ")" => 2525, "+" => 2538, "-" => 2553, },
	# [2525] opcode : ldi "(" iy ")"
	{ "," => 2526, },
	# [2526] opcode : ldi "(" iy ")" ","
	{ "!" => [ 13, 2527 ], "+" => [ 13, 2527 ], "-" => [ 13, 2527 ], __else__ => [ 13, 2527 ], a => 2528, b => 2529, bc => 2530, c => 2531, d => 2532, de => 2533, e => 2534, h => 2535, hl => 2536, l => 2537, "~" => [ 13, 2527 ], },
	# [2527] opcode : ldi "(" iy ")" "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_694 ], ":" => [ 7, \&_action_opcode_694 ], },
	# [2528] opcode : ldi "(" iy ")" "," a
	{ "\n" => [ 7, \&_action_opcode_695 ], ":" => [ 7, \&_action_opcode_695 ], },
	# [2529] opcode : ldi "(" iy ")" "," b
	{ "\n" => [ 7, \&_action_opcode_696 ], ":" => [ 7, \&_action_opcode_696 ], },
	# [2530] opcode : ldi "(" iy ")" "," bc
	{ "\n" => [ 7, \&_action_opcode_697 ], ":" => [ 7, \&_action_opcode_697 ], },
	# [2531] opcode : ldi "(" iy ")" "," c
	{ "\n" => [ 7, \&_action_opcode_698 ], ":" => [ 7, \&_action_opcode_698 ], },
	# [2532] opcode : ldi "(" iy ")" "," d
	{ "\n" => [ 7, \&_action_opcode_699 ], ":" => [ 7, \&_action_opcode_699 ], },
	# [2533] opcode : ldi "(" iy ")" "," de
	{ "\n" => [ 7, \&_action_opcode_700 ], ":" => [ 7, \&_action_opcode_700 ], },
	# [2534] opcode : ldi "(" iy ")" "," e
	{ "\n" => [ 7, \&_action_opcode_701 ], ":" => [ 7, \&_action_opcode_701 ], },
	# [2535] opcode : ldi "(" iy ")" "," h
	{ "\n" => [ 7, \&_action_opcode_702 ], ":" => [ 7, \&_action_opcode_702 ], },
	# [2536] opcode : ldi "(" iy ")" "," hl
	{ "\n" => [ 7, \&_action_opcode_703 ], ":" => [ 7, \&_action_opcode_703 ], },
	# [2537] opcode : ldi "(" iy ")" "," l
	{ "\n" => [ 7, \&_action_opcode_704 ], ":" => [ 7, \&_action_opcode_704 ], },
	# [2538] opcode : ldi "(" iy "+"
	{ "!" => [ 12, 2539 ], "+" => [ 12, 2539 ], "-" => [ 12, 2539 ], __else__ => [ 12, 2539 ], "~" => [ 12, 2539 ], },
	# [2539] opcode : ldi "(" iy "+" "[expr_DIS]"
	{ ")" => 2540, },
	# [2540] opcode : ldi "(" iy "+" "[expr_DIS]" ")"
	{ "," => 2541, },
	# [2541] opcode : ldi "(" iy "+" "[expr_DIS]" ")" ","
	{ "!" => [ 13, 2542 ], "+" => [ 13, 2542 ], "-" => [ 13, 2542 ], __else__ => [ 13, 2542 ], a => 2543, b => 2544, bc => 2545, c => 2546, d => 2547, de => 2548, e => 2549, h => 2550, hl => 2551, l => 2552, "~" => [ 13, 2542 ], },
	# [2542] opcode : ldi "(" iy "+" "[expr_DIS]" ")" "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_705 ], ":" => [ 7, \&_action_opcode_705 ], },
	# [2543] opcode : ldi "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_706 ], ":" => [ 7, \&_action_opcode_706 ], },
	# [2544] opcode : ldi "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_707 ], ":" => [ 7, \&_action_opcode_707 ], },
	# [2545] opcode : ldi "(" iy "+" "[expr_DIS]" ")" "," bc
	{ "\n" => [ 7, \&_action_opcode_708 ], ":" => [ 7, \&_action_opcode_708 ], },
	# [2546] opcode : ldi "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_709 ], ":" => [ 7, \&_action_opcode_709 ], },
	# [2547] opcode : ldi "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_710 ], ":" => [ 7, \&_action_opcode_710 ], },
	# [2548] opcode : ldi "(" iy "+" "[expr_DIS]" ")" "," de
	{ "\n" => [ 7, \&_action_opcode_711 ], ":" => [ 7, \&_action_opcode_711 ], },
	# [2549] opcode : ldi "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_712 ], ":" => [ 7, \&_action_opcode_712 ], },
	# [2550] opcode : ldi "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_713 ], ":" => [ 7, \&_action_opcode_713 ], },
	# [2551] opcode : ldi "(" iy "+" "[expr_DIS]" ")" "," hl
	{ "\n" => [ 7, \&_action_opcode_714 ], ":" => [ 7, \&_action_opcode_714 ], },
	# [2552] opcode : ldi "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_715 ], ":" => [ 7, \&_action_opcode_715 ], },
	# [2553] opcode : ldi "(" iy "-"
	{ "!" => [ 14, 2554 ], "+" => [ 14, 2554 ], "-" => [ 14, 2554 ], __else__ => [ 14, 2554 ], "~" => [ 14, 2554 ], },
	# [2554] opcode : ldi "(" iy "-" "[expr_NDIS]"
	{ ")" => 2555, },
	# [2555] opcode : ldi "(" iy "-" "[expr_NDIS]" ")"
	{ "," => 2556, },
	# [2556] opcode : ldi "(" iy "-" "[expr_NDIS]" ")" ","
	{ "!" => [ 13, 2557 ], "+" => [ 13, 2557 ], "-" => [ 13, 2557 ], __else__ => [ 13, 2557 ], a => 2558, b => 2559, bc => 2560, c => 2561, d => 2562, de => 2563, e => 2564, h => 2565, hl => 2566, l => 2567, "~" => [ 13, 2557 ], },
	# [2557] opcode : ldi "(" iy "-" "[expr_NDIS]" ")" "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_705 ], ":" => [ 7, \&_action_opcode_705 ], },
	# [2558] opcode : ldi "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_706 ], ":" => [ 7, \&_action_opcode_706 ], },
	# [2559] opcode : ldi "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_707 ], ":" => [ 7, \&_action_opcode_707 ], },
	# [2560] opcode : ldi "(" iy "-" "[expr_NDIS]" ")" "," bc
	{ "\n" => [ 7, \&_action_opcode_708 ], ":" => [ 7, \&_action_opcode_708 ], },
	# [2561] opcode : ldi "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_709 ], ":" => [ 7, \&_action_opcode_709 ], },
	# [2562] opcode : ldi "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_710 ], ":" => [ 7, \&_action_opcode_710 ], },
	# [2563] opcode : ldi "(" iy "-" "[expr_NDIS]" ")" "," de
	{ "\n" => [ 7, \&_action_opcode_711 ], ":" => [ 7, \&_action_opcode_711 ], },
	# [2564] opcode : ldi "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_712 ], ":" => [ 7, \&_action_opcode_712 ], },
	# [2565] opcode : ldi "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_713 ], ":" => [ 7, \&_action_opcode_713 ], },
	# [2566] opcode : ldi "(" iy "-" "[expr_NDIS]" ")" "," hl
	{ "\n" => [ 7, \&_action_opcode_714 ], ":" => [ 7, \&_action_opcode_714 ], },
	# [2567] opcode : ldi "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_715 ], ":" => [ 7, \&_action_opcode_715 ], },
	# [2568] opcode : ldi "["
	{ bc => 2569, de => 2573, hl => 2577, ix => 2590, iy => 2634, },
	# [2569] opcode : ldi "[" bc
	{ "]" => 2570, },
	# [2570] opcode : ldi "[" bc "]"
	{ "," => 2571, },
	# [2571] opcode : ldi "[" bc "]" ","
	{ a => 2572, },
	# [2572] opcode : ldi "[" bc "]" "," a
	{ "\n" => [ 7, \&_action_opcode_660 ], ":" => [ 7, \&_action_opcode_660 ], },
	# [2573] opcode : ldi "[" de
	{ "]" => 2574, },
	# [2574] opcode : ldi "[" de "]"
	{ "," => 2575, },
	# [2575] opcode : ldi "[" de "]" ","
	{ a => 2576, },
	# [2576] opcode : ldi "[" de "]" "," a
	{ "\n" => [ 7, \&_action_opcode_661 ], ":" => [ 7, \&_action_opcode_661 ], },
	# [2577] opcode : ldi "[" hl
	{ "]" => 2578, },
	# [2578] opcode : ldi "[" hl "]"
	{ "," => 2579, },
	# [2579] opcode : ldi "[" hl "]" ","
	{ "!" => [ 13, 2580 ], "+" => [ 13, 2580 ], "-" => [ 13, 2580 ], __else__ => [ 13, 2580 ], a => 2581, b => 2582, bc => 2583, c => 2584, d => 2585, de => 2586, e => 2587, h => 2588, l => 2589, "~" => [ 13, 2580 ], },
	# [2580] opcode : ldi "[" hl "]" "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_662 ], ":" => [ 7, \&_action_opcode_662 ], },
	# [2581] opcode : ldi "[" hl "]" "," a
	{ "\n" => [ 7, \&_action_opcode_663 ], ":" => [ 7, \&_action_opcode_663 ], },
	# [2582] opcode : ldi "[" hl "]" "," b
	{ "\n" => [ 7, \&_action_opcode_664 ], ":" => [ 7, \&_action_opcode_664 ], },
	# [2583] opcode : ldi "[" hl "]" "," bc
	{ "\n" => [ 7, \&_action_opcode_665 ], ":" => [ 7, \&_action_opcode_665 ], },
	# [2584] opcode : ldi "[" hl "]" "," c
	{ "\n" => [ 7, \&_action_opcode_666 ], ":" => [ 7, \&_action_opcode_666 ], },
	# [2585] opcode : ldi "[" hl "]" "," d
	{ "\n" => [ 7, \&_action_opcode_667 ], ":" => [ 7, \&_action_opcode_667 ], },
	# [2586] opcode : ldi "[" hl "]" "," de
	{ "\n" => [ 7, \&_action_opcode_668 ], ":" => [ 7, \&_action_opcode_668 ], },
	# [2587] opcode : ldi "[" hl "]" "," e
	{ "\n" => [ 7, \&_action_opcode_669 ], ":" => [ 7, \&_action_opcode_669 ], },
	# [2588] opcode : ldi "[" hl "]" "," h
	{ "\n" => [ 7, \&_action_opcode_670 ], ":" => [ 7, \&_action_opcode_670 ], },
	# [2589] opcode : ldi "[" hl "]" "," l
	{ "\n" => [ 7, \&_action_opcode_671 ], ":" => [ 7, \&_action_opcode_671 ], },
	# [2590] opcode : ldi "[" ix
	{ "+" => 2591, "-" => 2606, "]" => 2621, },
	# [2591] opcode : ldi "[" ix "+"
	{ "!" => [ 12, 2592 ], "+" => [ 12, 2592 ], "-" => [ 12, 2592 ], __else__ => [ 12, 2592 ], "~" => [ 12, 2592 ], },
	# [2592] opcode : ldi "[" ix "+" "[expr_DIS]"
	{ "]" => 2593, },
	# [2593] opcode : ldi "[" ix "+" "[expr_DIS]" "]"
	{ "," => 2594, },
	# [2594] opcode : ldi "[" ix "+" "[expr_DIS]" "]" ","
	{ "!" => [ 13, 2595 ], "+" => [ 13, 2595 ], "-" => [ 13, 2595 ], __else__ => [ 13, 2595 ], a => 2596, b => 2597, bc => 2598, c => 2599, d => 2600, de => 2601, e => 2602, h => 2603, hl => 2604, l => 2605, "~" => [ 13, 2595 ], },
	# [2595] opcode : ldi "[" ix "+" "[expr_DIS]" "]" "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_683 ], ":" => [ 7, \&_action_opcode_683 ], },
	# [2596] opcode : ldi "[" ix "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_684 ], ":" => [ 7, \&_action_opcode_684 ], },
	# [2597] opcode : ldi "[" ix "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_685 ], ":" => [ 7, \&_action_opcode_685 ], },
	# [2598] opcode : ldi "[" ix "+" "[expr_DIS]" "]" "," bc
	{ "\n" => [ 7, \&_action_opcode_686 ], ":" => [ 7, \&_action_opcode_686 ], },
	# [2599] opcode : ldi "[" ix "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_687 ], ":" => [ 7, \&_action_opcode_687 ], },
	# [2600] opcode : ldi "[" ix "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_688 ], ":" => [ 7, \&_action_opcode_688 ], },
	# [2601] opcode : ldi "[" ix "+" "[expr_DIS]" "]" "," de
	{ "\n" => [ 7, \&_action_opcode_689 ], ":" => [ 7, \&_action_opcode_689 ], },
	# [2602] opcode : ldi "[" ix "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_690 ], ":" => [ 7, \&_action_opcode_690 ], },
	# [2603] opcode : ldi "[" ix "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_691 ], ":" => [ 7, \&_action_opcode_691 ], },
	# [2604] opcode : ldi "[" ix "+" "[expr_DIS]" "]" "," hl
	{ "\n" => [ 7, \&_action_opcode_692 ], ":" => [ 7, \&_action_opcode_692 ], },
	# [2605] opcode : ldi "[" ix "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_693 ], ":" => [ 7, \&_action_opcode_693 ], },
	# [2606] opcode : ldi "[" ix "-"
	{ "!" => [ 14, 2607 ], "+" => [ 14, 2607 ], "-" => [ 14, 2607 ], __else__ => [ 14, 2607 ], "~" => [ 14, 2607 ], },
	# [2607] opcode : ldi "[" ix "-" "[expr_NDIS]"
	{ "]" => 2608, },
	# [2608] opcode : ldi "[" ix "-" "[expr_NDIS]" "]"
	{ "," => 2609, },
	# [2609] opcode : ldi "[" ix "-" "[expr_NDIS]" "]" ","
	{ "!" => [ 13, 2610 ], "+" => [ 13, 2610 ], "-" => [ 13, 2610 ], __else__ => [ 13, 2610 ], a => 2611, b => 2612, bc => 2613, c => 2614, d => 2615, de => 2616, e => 2617, h => 2618, hl => 2619, l => 2620, "~" => [ 13, 2610 ], },
	# [2610] opcode : ldi "[" ix "-" "[expr_NDIS]" "]" "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_683 ], ":" => [ 7, \&_action_opcode_683 ], },
	# [2611] opcode : ldi "[" ix "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_684 ], ":" => [ 7, \&_action_opcode_684 ], },
	# [2612] opcode : ldi "[" ix "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_685 ], ":" => [ 7, \&_action_opcode_685 ], },
	# [2613] opcode : ldi "[" ix "-" "[expr_NDIS]" "]" "," bc
	{ "\n" => [ 7, \&_action_opcode_686 ], ":" => [ 7, \&_action_opcode_686 ], },
	# [2614] opcode : ldi "[" ix "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_687 ], ":" => [ 7, \&_action_opcode_687 ], },
	# [2615] opcode : ldi "[" ix "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_688 ], ":" => [ 7, \&_action_opcode_688 ], },
	# [2616] opcode : ldi "[" ix "-" "[expr_NDIS]" "]" "," de
	{ "\n" => [ 7, \&_action_opcode_689 ], ":" => [ 7, \&_action_opcode_689 ], },
	# [2617] opcode : ldi "[" ix "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_690 ], ":" => [ 7, \&_action_opcode_690 ], },
	# [2618] opcode : ldi "[" ix "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_691 ], ":" => [ 7, \&_action_opcode_691 ], },
	# [2619] opcode : ldi "[" ix "-" "[expr_NDIS]" "]" "," hl
	{ "\n" => [ 7, \&_action_opcode_692 ], ":" => [ 7, \&_action_opcode_692 ], },
	# [2620] opcode : ldi "[" ix "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_693 ], ":" => [ 7, \&_action_opcode_693 ], },
	# [2621] opcode : ldi "[" ix "]"
	{ "," => 2622, },
	# [2622] opcode : ldi "[" ix "]" ","
	{ "!" => [ 13, 2623 ], "+" => [ 13, 2623 ], "-" => [ 13, 2623 ], __else__ => [ 13, 2623 ], a => 2624, b => 2625, bc => 2626, c => 2627, d => 2628, de => 2629, e => 2630, h => 2631, hl => 2632, l => 2633, "~" => [ 13, 2623 ], },
	# [2623] opcode : ldi "[" ix "]" "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_672 ], ":" => [ 7, \&_action_opcode_672 ], },
	# [2624] opcode : ldi "[" ix "]" "," a
	{ "\n" => [ 7, \&_action_opcode_673 ], ":" => [ 7, \&_action_opcode_673 ], },
	# [2625] opcode : ldi "[" ix "]" "," b
	{ "\n" => [ 7, \&_action_opcode_674 ], ":" => [ 7, \&_action_opcode_674 ], },
	# [2626] opcode : ldi "[" ix "]" "," bc
	{ "\n" => [ 7, \&_action_opcode_675 ], ":" => [ 7, \&_action_opcode_675 ], },
	# [2627] opcode : ldi "[" ix "]" "," c
	{ "\n" => [ 7, \&_action_opcode_676 ], ":" => [ 7, \&_action_opcode_676 ], },
	# [2628] opcode : ldi "[" ix "]" "," d
	{ "\n" => [ 7, \&_action_opcode_677 ], ":" => [ 7, \&_action_opcode_677 ], },
	# [2629] opcode : ldi "[" ix "]" "," de
	{ "\n" => [ 7, \&_action_opcode_678 ], ":" => [ 7, \&_action_opcode_678 ], },
	# [2630] opcode : ldi "[" ix "]" "," e
	{ "\n" => [ 7, \&_action_opcode_679 ], ":" => [ 7, \&_action_opcode_679 ], },
	# [2631] opcode : ldi "[" ix "]" "," h
	{ "\n" => [ 7, \&_action_opcode_680 ], ":" => [ 7, \&_action_opcode_680 ], },
	# [2632] opcode : ldi "[" ix "]" "," hl
	{ "\n" => [ 7, \&_action_opcode_681 ], ":" => [ 7, \&_action_opcode_681 ], },
	# [2633] opcode : ldi "[" ix "]" "," l
	{ "\n" => [ 7, \&_action_opcode_682 ], ":" => [ 7, \&_action_opcode_682 ], },
	# [2634] opcode : ldi "[" iy
	{ "+" => 2635, "-" => 2650, "]" => 2665, },
	# [2635] opcode : ldi "[" iy "+"
	{ "!" => [ 12, 2636 ], "+" => [ 12, 2636 ], "-" => [ 12, 2636 ], __else__ => [ 12, 2636 ], "~" => [ 12, 2636 ], },
	# [2636] opcode : ldi "[" iy "+" "[expr_DIS]"
	{ "]" => 2637, },
	# [2637] opcode : ldi "[" iy "+" "[expr_DIS]" "]"
	{ "," => 2638, },
	# [2638] opcode : ldi "[" iy "+" "[expr_DIS]" "]" ","
	{ "!" => [ 13, 2639 ], "+" => [ 13, 2639 ], "-" => [ 13, 2639 ], __else__ => [ 13, 2639 ], a => 2640, b => 2641, bc => 2642, c => 2643, d => 2644, de => 2645, e => 2646, h => 2647, hl => 2648, l => 2649, "~" => [ 13, 2639 ], },
	# [2639] opcode : ldi "[" iy "+" "[expr_DIS]" "]" "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_705 ], ":" => [ 7, \&_action_opcode_705 ], },
	# [2640] opcode : ldi "[" iy "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_706 ], ":" => [ 7, \&_action_opcode_706 ], },
	# [2641] opcode : ldi "[" iy "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_707 ], ":" => [ 7, \&_action_opcode_707 ], },
	# [2642] opcode : ldi "[" iy "+" "[expr_DIS]" "]" "," bc
	{ "\n" => [ 7, \&_action_opcode_708 ], ":" => [ 7, \&_action_opcode_708 ], },
	# [2643] opcode : ldi "[" iy "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_709 ], ":" => [ 7, \&_action_opcode_709 ], },
	# [2644] opcode : ldi "[" iy "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_710 ], ":" => [ 7, \&_action_opcode_710 ], },
	# [2645] opcode : ldi "[" iy "+" "[expr_DIS]" "]" "," de
	{ "\n" => [ 7, \&_action_opcode_711 ], ":" => [ 7, \&_action_opcode_711 ], },
	# [2646] opcode : ldi "[" iy "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_712 ], ":" => [ 7, \&_action_opcode_712 ], },
	# [2647] opcode : ldi "[" iy "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_713 ], ":" => [ 7, \&_action_opcode_713 ], },
	# [2648] opcode : ldi "[" iy "+" "[expr_DIS]" "]" "," hl
	{ "\n" => [ 7, \&_action_opcode_714 ], ":" => [ 7, \&_action_opcode_714 ], },
	# [2649] opcode : ldi "[" iy "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_715 ], ":" => [ 7, \&_action_opcode_715 ], },
	# [2650] opcode : ldi "[" iy "-"
	{ "!" => [ 14, 2651 ], "+" => [ 14, 2651 ], "-" => [ 14, 2651 ], __else__ => [ 14, 2651 ], "~" => [ 14, 2651 ], },
	# [2651] opcode : ldi "[" iy "-" "[expr_NDIS]"
	{ "]" => 2652, },
	# [2652] opcode : ldi "[" iy "-" "[expr_NDIS]" "]"
	{ "," => 2653, },
	# [2653] opcode : ldi "[" iy "-" "[expr_NDIS]" "]" ","
	{ "!" => [ 13, 2654 ], "+" => [ 13, 2654 ], "-" => [ 13, 2654 ], __else__ => [ 13, 2654 ], a => 2655, b => 2656, bc => 2657, c => 2658, d => 2659, de => 2660, e => 2661, h => 2662, hl => 2663, l => 2664, "~" => [ 13, 2654 ], },
	# [2654] opcode : ldi "[" iy "-" "[expr_NDIS]" "]" "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_705 ], ":" => [ 7, \&_action_opcode_705 ], },
	# [2655] opcode : ldi "[" iy "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_706 ], ":" => [ 7, \&_action_opcode_706 ], },
	# [2656] opcode : ldi "[" iy "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_707 ], ":" => [ 7, \&_action_opcode_707 ], },
	# [2657] opcode : ldi "[" iy "-" "[expr_NDIS]" "]" "," bc
	{ "\n" => [ 7, \&_action_opcode_708 ], ":" => [ 7, \&_action_opcode_708 ], },
	# [2658] opcode : ldi "[" iy "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_709 ], ":" => [ 7, \&_action_opcode_709 ], },
	# [2659] opcode : ldi "[" iy "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_710 ], ":" => [ 7, \&_action_opcode_710 ], },
	# [2660] opcode : ldi "[" iy "-" "[expr_NDIS]" "]" "," de
	{ "\n" => [ 7, \&_action_opcode_711 ], ":" => [ 7, \&_action_opcode_711 ], },
	# [2661] opcode : ldi "[" iy "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_712 ], ":" => [ 7, \&_action_opcode_712 ], },
	# [2662] opcode : ldi "[" iy "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_713 ], ":" => [ 7, \&_action_opcode_713 ], },
	# [2663] opcode : ldi "[" iy "-" "[expr_NDIS]" "]" "," hl
	{ "\n" => [ 7, \&_action_opcode_714 ], ":" => [ 7, \&_action_opcode_714 ], },
	# [2664] opcode : ldi "[" iy "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_715 ], ":" => [ 7, \&_action_opcode_715 ], },
	# [2665] opcode : ldi "[" iy "]"
	{ "," => 2666, },
	# [2666] opcode : ldi "[" iy "]" ","
	{ "!" => [ 13, 2667 ], "+" => [ 13, 2667 ], "-" => [ 13, 2667 ], __else__ => [ 13, 2667 ], a => 2668, b => 2669, bc => 2670, c => 2671, d => 2672, de => 2673, e => 2674, h => 2675, hl => 2676, l => 2677, "~" => [ 13, 2667 ], },
	# [2667] opcode : ldi "[" iy "]" "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_694 ], ":" => [ 7, \&_action_opcode_694 ], },
	# [2668] opcode : ldi "[" iy "]" "," a
	{ "\n" => [ 7, \&_action_opcode_695 ], ":" => [ 7, \&_action_opcode_695 ], },
	# [2669] opcode : ldi "[" iy "]" "," b
	{ "\n" => [ 7, \&_action_opcode_696 ], ":" => [ 7, \&_action_opcode_696 ], },
	# [2670] opcode : ldi "[" iy "]" "," bc
	{ "\n" => [ 7, \&_action_opcode_697 ], ":" => [ 7, \&_action_opcode_697 ], },
	# [2671] opcode : ldi "[" iy "]" "," c
	{ "\n" => [ 7, \&_action_opcode_698 ], ":" => [ 7, \&_action_opcode_698 ], },
	# [2672] opcode : ldi "[" iy "]" "," d
	{ "\n" => [ 7, \&_action_opcode_699 ], ":" => [ 7, \&_action_opcode_699 ], },
	# [2673] opcode : ldi "[" iy "]" "," de
	{ "\n" => [ 7, \&_action_opcode_700 ], ":" => [ 7, \&_action_opcode_700 ], },
	# [2674] opcode : ldi "[" iy "]" "," e
	{ "\n" => [ 7, \&_action_opcode_701 ], ":" => [ 7, \&_action_opcode_701 ], },
	# [2675] opcode : ldi "[" iy "]" "," h
	{ "\n" => [ 7, \&_action_opcode_702 ], ":" => [ 7, \&_action_opcode_702 ], },
	# [2676] opcode : ldi "[" iy "]" "," hl
	{ "\n" => [ 7, \&_action_opcode_703 ], ":" => [ 7, \&_action_opcode_703 ], },
	# [2677] opcode : ldi "[" iy "]" "," l
	{ "\n" => [ 7, \&_action_opcode_704 ], ":" => [ 7, \&_action_opcode_704 ], },
	# [2678] opcode : ldi a
	{ "," => 2679, },
	# [2679] opcode : ldi a ","
	{ "(" => 2680, "[" => 2703, },
	# [2680] opcode : ldi a "," "("
	{ bc => 2681, de => 2683, hl => 2685, ix => 2687, iy => 2695, },
	# [2681] opcode : ldi a "," "(" bc
	{ ")" => 2682, },
	# [2682] opcode : ldi a "," "(" bc ")"
	{ "\n" => [ 7, \&_action_opcode_716 ], ":" => [ 7, \&_action_opcode_716 ], },
	# [2683] opcode : ldi a "," "(" de
	{ ")" => 2684, },
	# [2684] opcode : ldi a "," "(" de ")"
	{ "\n" => [ 7, \&_action_opcode_717 ], ":" => [ 7, \&_action_opcode_717 ], },
	# [2685] opcode : ldi a "," "(" hl
	{ ")" => 2686, },
	# [2686] opcode : ldi a "," "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_718 ], ":" => [ 7, \&_action_opcode_718 ], },
	# [2687] opcode : ldi a "," "(" ix
	{ ")" => 2688, "+" => 2689, "-" => 2692, },
	# [2688] opcode : ldi a "," "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_719 ], ":" => [ 7, \&_action_opcode_719 ], },
	# [2689] opcode : ldi a "," "(" ix "+"
	{ "!" => [ 12, 2690 ], "+" => [ 12, 2690 ], "-" => [ 12, 2690 ], __else__ => [ 12, 2690 ], "~" => [ 12, 2690 ], },
	# [2690] opcode : ldi a "," "(" ix "+" "[expr_DIS]"
	{ ")" => 2691, },
	# [2691] opcode : ldi a "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_720 ], ":" => [ 7, \&_action_opcode_720 ], },
	# [2692] opcode : ldi a "," "(" ix "-"
	{ "!" => [ 14, 2693 ], "+" => [ 14, 2693 ], "-" => [ 14, 2693 ], __else__ => [ 14, 2693 ], "~" => [ 14, 2693 ], },
	# [2693] opcode : ldi a "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 2694, },
	# [2694] opcode : ldi a "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_720 ], ":" => [ 7, \&_action_opcode_720 ], },
	# [2695] opcode : ldi a "," "(" iy
	{ ")" => 2696, "+" => 2697, "-" => 2700, },
	# [2696] opcode : ldi a "," "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_721 ], ":" => [ 7, \&_action_opcode_721 ], },
	# [2697] opcode : ldi a "," "(" iy "+"
	{ "!" => [ 12, 2698 ], "+" => [ 12, 2698 ], "-" => [ 12, 2698 ], __else__ => [ 12, 2698 ], "~" => [ 12, 2698 ], },
	# [2698] opcode : ldi a "," "(" iy "+" "[expr_DIS]"
	{ ")" => 2699, },
	# [2699] opcode : ldi a "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_722 ], ":" => [ 7, \&_action_opcode_722 ], },
	# [2700] opcode : ldi a "," "(" iy "-"
	{ "!" => [ 14, 2701 ], "+" => [ 14, 2701 ], "-" => [ 14, 2701 ], __else__ => [ 14, 2701 ], "~" => [ 14, 2701 ], },
	# [2701] opcode : ldi a "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 2702, },
	# [2702] opcode : ldi a "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_722 ], ":" => [ 7, \&_action_opcode_722 ], },
	# [2703] opcode : ldi a "," "["
	{ bc => 2704, de => 2706, hl => 2708, ix => 2710, iy => 2718, },
	# [2704] opcode : ldi a "," "[" bc
	{ "]" => 2705, },
	# [2705] opcode : ldi a "," "[" bc "]"
	{ "\n" => [ 7, \&_action_opcode_716 ], ":" => [ 7, \&_action_opcode_716 ], },
	# [2706] opcode : ldi a "," "[" de
	{ "]" => 2707, },
	# [2707] opcode : ldi a "," "[" de "]"
	{ "\n" => [ 7, \&_action_opcode_717 ], ":" => [ 7, \&_action_opcode_717 ], },
	# [2708] opcode : ldi a "," "[" hl
	{ "]" => 2709, },
	# [2709] opcode : ldi a "," "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_718 ], ":" => [ 7, \&_action_opcode_718 ], },
	# [2710] opcode : ldi a "," "[" ix
	{ "+" => 2711, "-" => 2714, "]" => 2717, },
	# [2711] opcode : ldi a "," "[" ix "+"
	{ "!" => [ 12, 2712 ], "+" => [ 12, 2712 ], "-" => [ 12, 2712 ], __else__ => [ 12, 2712 ], "~" => [ 12, 2712 ], },
	# [2712] opcode : ldi a "," "[" ix "+" "[expr_DIS]"
	{ "]" => 2713, },
	# [2713] opcode : ldi a "," "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_720 ], ":" => [ 7, \&_action_opcode_720 ], },
	# [2714] opcode : ldi a "," "[" ix "-"
	{ "!" => [ 14, 2715 ], "+" => [ 14, 2715 ], "-" => [ 14, 2715 ], __else__ => [ 14, 2715 ], "~" => [ 14, 2715 ], },
	# [2715] opcode : ldi a "," "[" ix "-" "[expr_NDIS]"
	{ "]" => 2716, },
	# [2716] opcode : ldi a "," "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_720 ], ":" => [ 7, \&_action_opcode_720 ], },
	# [2717] opcode : ldi a "," "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_719 ], ":" => [ 7, \&_action_opcode_719 ], },
	# [2718] opcode : ldi a "," "[" iy
	{ "+" => 2719, "-" => 2722, "]" => 2725, },
	# [2719] opcode : ldi a "," "[" iy "+"
	{ "!" => [ 12, 2720 ], "+" => [ 12, 2720 ], "-" => [ 12, 2720 ], __else__ => [ 12, 2720 ], "~" => [ 12, 2720 ], },
	# [2720] opcode : ldi a "," "[" iy "+" "[expr_DIS]"
	{ "]" => 2721, },
	# [2721] opcode : ldi a "," "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_722 ], ":" => [ 7, \&_action_opcode_722 ], },
	# [2722] opcode : ldi a "," "[" iy "-"
	{ "!" => [ 14, 2723 ], "+" => [ 14, 2723 ], "-" => [ 14, 2723 ], __else__ => [ 14, 2723 ], "~" => [ 14, 2723 ], },
	# [2723] opcode : ldi a "," "[" iy "-" "[expr_NDIS]"
	{ "]" => 2724, },
	# [2724] opcode : ldi a "," "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_722 ], ":" => [ 7, \&_action_opcode_722 ], },
	# [2725] opcode : ldi a "," "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_721 ], ":" => [ 7, \&_action_opcode_721 ], },
	# [2726] opcode : ldi b
	{ "," => 2727, },
	# [2727] opcode : ldi b ","
	{ "(" => 2728, "[" => 2747, },
	# [2728] opcode : ldi b "," "("
	{ hl => 2729, ix => 2731, iy => 2739, },
	# [2729] opcode : ldi b "," "(" hl
	{ ")" => 2730, },
	# [2730] opcode : ldi b "," "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_723 ], ":" => [ 7, \&_action_opcode_723 ], },
	# [2731] opcode : ldi b "," "(" ix
	{ ")" => 2732, "+" => 2733, "-" => 2736, },
	# [2732] opcode : ldi b "," "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_724 ], ":" => [ 7, \&_action_opcode_724 ], },
	# [2733] opcode : ldi b "," "(" ix "+"
	{ "!" => [ 12, 2734 ], "+" => [ 12, 2734 ], "-" => [ 12, 2734 ], __else__ => [ 12, 2734 ], "~" => [ 12, 2734 ], },
	# [2734] opcode : ldi b "," "(" ix "+" "[expr_DIS]"
	{ ")" => 2735, },
	# [2735] opcode : ldi b "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_725 ], ":" => [ 7, \&_action_opcode_725 ], },
	# [2736] opcode : ldi b "," "(" ix "-"
	{ "!" => [ 14, 2737 ], "+" => [ 14, 2737 ], "-" => [ 14, 2737 ], __else__ => [ 14, 2737 ], "~" => [ 14, 2737 ], },
	# [2737] opcode : ldi b "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 2738, },
	# [2738] opcode : ldi b "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_725 ], ":" => [ 7, \&_action_opcode_725 ], },
	# [2739] opcode : ldi b "," "(" iy
	{ ")" => 2740, "+" => 2741, "-" => 2744, },
	# [2740] opcode : ldi b "," "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_726 ], ":" => [ 7, \&_action_opcode_726 ], },
	# [2741] opcode : ldi b "," "(" iy "+"
	{ "!" => [ 12, 2742 ], "+" => [ 12, 2742 ], "-" => [ 12, 2742 ], __else__ => [ 12, 2742 ], "~" => [ 12, 2742 ], },
	# [2742] opcode : ldi b "," "(" iy "+" "[expr_DIS]"
	{ ")" => 2743, },
	# [2743] opcode : ldi b "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_727 ], ":" => [ 7, \&_action_opcode_727 ], },
	# [2744] opcode : ldi b "," "(" iy "-"
	{ "!" => [ 14, 2745 ], "+" => [ 14, 2745 ], "-" => [ 14, 2745 ], __else__ => [ 14, 2745 ], "~" => [ 14, 2745 ], },
	# [2745] opcode : ldi b "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 2746, },
	# [2746] opcode : ldi b "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_727 ], ":" => [ 7, \&_action_opcode_727 ], },
	# [2747] opcode : ldi b "," "["
	{ hl => 2748, ix => 2750, iy => 2758, },
	# [2748] opcode : ldi b "," "[" hl
	{ "]" => 2749, },
	# [2749] opcode : ldi b "," "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_723 ], ":" => [ 7, \&_action_opcode_723 ], },
	# [2750] opcode : ldi b "," "[" ix
	{ "+" => 2751, "-" => 2754, "]" => 2757, },
	# [2751] opcode : ldi b "," "[" ix "+"
	{ "!" => [ 12, 2752 ], "+" => [ 12, 2752 ], "-" => [ 12, 2752 ], __else__ => [ 12, 2752 ], "~" => [ 12, 2752 ], },
	# [2752] opcode : ldi b "," "[" ix "+" "[expr_DIS]"
	{ "]" => 2753, },
	# [2753] opcode : ldi b "," "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_725 ], ":" => [ 7, \&_action_opcode_725 ], },
	# [2754] opcode : ldi b "," "[" ix "-"
	{ "!" => [ 14, 2755 ], "+" => [ 14, 2755 ], "-" => [ 14, 2755 ], __else__ => [ 14, 2755 ], "~" => [ 14, 2755 ], },
	# [2755] opcode : ldi b "," "[" ix "-" "[expr_NDIS]"
	{ "]" => 2756, },
	# [2756] opcode : ldi b "," "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_725 ], ":" => [ 7, \&_action_opcode_725 ], },
	# [2757] opcode : ldi b "," "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_724 ], ":" => [ 7, \&_action_opcode_724 ], },
	# [2758] opcode : ldi b "," "[" iy
	{ "+" => 2759, "-" => 2762, "]" => 2765, },
	# [2759] opcode : ldi b "," "[" iy "+"
	{ "!" => [ 12, 2760 ], "+" => [ 12, 2760 ], "-" => [ 12, 2760 ], __else__ => [ 12, 2760 ], "~" => [ 12, 2760 ], },
	# [2760] opcode : ldi b "," "[" iy "+" "[expr_DIS]"
	{ "]" => 2761, },
	# [2761] opcode : ldi b "," "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_727 ], ":" => [ 7, \&_action_opcode_727 ], },
	# [2762] opcode : ldi b "," "[" iy "-"
	{ "!" => [ 14, 2763 ], "+" => [ 14, 2763 ], "-" => [ 14, 2763 ], __else__ => [ 14, 2763 ], "~" => [ 14, 2763 ], },
	# [2763] opcode : ldi b "," "[" iy "-" "[expr_NDIS]"
	{ "]" => 2764, },
	# [2764] opcode : ldi b "," "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_727 ], ":" => [ 7, \&_action_opcode_727 ], },
	# [2765] opcode : ldi b "," "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_726 ], ":" => [ 7, \&_action_opcode_726 ], },
	# [2766] opcode : ldi bc
	{ "," => 2767, },
	# [2767] opcode : ldi bc ","
	{ "(" => 2768, "[" => 2787, },
	# [2768] opcode : ldi bc "," "("
	{ hl => 2769, ix => 2771, iy => 2779, },
	# [2769] opcode : ldi bc "," "(" hl
	{ ")" => 2770, },
	# [2770] opcode : ldi bc "," "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_728 ], ":" => [ 7, \&_action_opcode_728 ], },
	# [2771] opcode : ldi bc "," "(" ix
	{ ")" => 2772, "+" => 2773, "-" => 2776, },
	# [2772] opcode : ldi bc "," "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_729 ], ":" => [ 7, \&_action_opcode_729 ], },
	# [2773] opcode : ldi bc "," "(" ix "+"
	{ "!" => [ 12, 2774 ], "+" => [ 12, 2774 ], "-" => [ 12, 2774 ], __else__ => [ 12, 2774 ], "~" => [ 12, 2774 ], },
	# [2774] opcode : ldi bc "," "(" ix "+" "[expr_DIS]"
	{ ")" => 2775, },
	# [2775] opcode : ldi bc "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_730 ], ":" => [ 7, \&_action_opcode_730 ], },
	# [2776] opcode : ldi bc "," "(" ix "-"
	{ "!" => [ 14, 2777 ], "+" => [ 14, 2777 ], "-" => [ 14, 2777 ], __else__ => [ 14, 2777 ], "~" => [ 14, 2777 ], },
	# [2777] opcode : ldi bc "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 2778, },
	# [2778] opcode : ldi bc "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_730 ], ":" => [ 7, \&_action_opcode_730 ], },
	# [2779] opcode : ldi bc "," "(" iy
	{ ")" => 2780, "+" => 2781, "-" => 2784, },
	# [2780] opcode : ldi bc "," "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_731 ], ":" => [ 7, \&_action_opcode_731 ], },
	# [2781] opcode : ldi bc "," "(" iy "+"
	{ "!" => [ 12, 2782 ], "+" => [ 12, 2782 ], "-" => [ 12, 2782 ], __else__ => [ 12, 2782 ], "~" => [ 12, 2782 ], },
	# [2782] opcode : ldi bc "," "(" iy "+" "[expr_DIS]"
	{ ")" => 2783, },
	# [2783] opcode : ldi bc "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_732 ], ":" => [ 7, \&_action_opcode_732 ], },
	# [2784] opcode : ldi bc "," "(" iy "-"
	{ "!" => [ 14, 2785 ], "+" => [ 14, 2785 ], "-" => [ 14, 2785 ], __else__ => [ 14, 2785 ], "~" => [ 14, 2785 ], },
	# [2785] opcode : ldi bc "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 2786, },
	# [2786] opcode : ldi bc "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_732 ], ":" => [ 7, \&_action_opcode_732 ], },
	# [2787] opcode : ldi bc "," "["
	{ hl => 2788, ix => 2790, iy => 2798, },
	# [2788] opcode : ldi bc "," "[" hl
	{ "]" => 2789, },
	# [2789] opcode : ldi bc "," "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_728 ], ":" => [ 7, \&_action_opcode_728 ], },
	# [2790] opcode : ldi bc "," "[" ix
	{ "+" => 2791, "-" => 2794, "]" => 2797, },
	# [2791] opcode : ldi bc "," "[" ix "+"
	{ "!" => [ 12, 2792 ], "+" => [ 12, 2792 ], "-" => [ 12, 2792 ], __else__ => [ 12, 2792 ], "~" => [ 12, 2792 ], },
	# [2792] opcode : ldi bc "," "[" ix "+" "[expr_DIS]"
	{ "]" => 2793, },
	# [2793] opcode : ldi bc "," "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_730 ], ":" => [ 7, \&_action_opcode_730 ], },
	# [2794] opcode : ldi bc "," "[" ix "-"
	{ "!" => [ 14, 2795 ], "+" => [ 14, 2795 ], "-" => [ 14, 2795 ], __else__ => [ 14, 2795 ], "~" => [ 14, 2795 ], },
	# [2795] opcode : ldi bc "," "[" ix "-" "[expr_NDIS]"
	{ "]" => 2796, },
	# [2796] opcode : ldi bc "," "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_730 ], ":" => [ 7, \&_action_opcode_730 ], },
	# [2797] opcode : ldi bc "," "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_729 ], ":" => [ 7, \&_action_opcode_729 ], },
	# [2798] opcode : ldi bc "," "[" iy
	{ "+" => 2799, "-" => 2802, "]" => 2805, },
	# [2799] opcode : ldi bc "," "[" iy "+"
	{ "!" => [ 12, 2800 ], "+" => [ 12, 2800 ], "-" => [ 12, 2800 ], __else__ => [ 12, 2800 ], "~" => [ 12, 2800 ], },
	# [2800] opcode : ldi bc "," "[" iy "+" "[expr_DIS]"
	{ "]" => 2801, },
	# [2801] opcode : ldi bc "," "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_732 ], ":" => [ 7, \&_action_opcode_732 ], },
	# [2802] opcode : ldi bc "," "[" iy "-"
	{ "!" => [ 14, 2803 ], "+" => [ 14, 2803 ], "-" => [ 14, 2803 ], __else__ => [ 14, 2803 ], "~" => [ 14, 2803 ], },
	# [2803] opcode : ldi bc "," "[" iy "-" "[expr_NDIS]"
	{ "]" => 2804, },
	# [2804] opcode : ldi bc "," "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_732 ], ":" => [ 7, \&_action_opcode_732 ], },
	# [2805] opcode : ldi bc "," "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_731 ], ":" => [ 7, \&_action_opcode_731 ], },
	# [2806] opcode : ldi c
	{ "," => 2807, },
	# [2807] opcode : ldi c ","
	{ "(" => 2808, "[" => 2827, },
	# [2808] opcode : ldi c "," "("
	{ hl => 2809, ix => 2811, iy => 2819, },
	# [2809] opcode : ldi c "," "(" hl
	{ ")" => 2810, },
	# [2810] opcode : ldi c "," "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_733 ], ":" => [ 7, \&_action_opcode_733 ], },
	# [2811] opcode : ldi c "," "(" ix
	{ ")" => 2812, "+" => 2813, "-" => 2816, },
	# [2812] opcode : ldi c "," "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_734 ], ":" => [ 7, \&_action_opcode_734 ], },
	# [2813] opcode : ldi c "," "(" ix "+"
	{ "!" => [ 12, 2814 ], "+" => [ 12, 2814 ], "-" => [ 12, 2814 ], __else__ => [ 12, 2814 ], "~" => [ 12, 2814 ], },
	# [2814] opcode : ldi c "," "(" ix "+" "[expr_DIS]"
	{ ")" => 2815, },
	# [2815] opcode : ldi c "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_735 ], ":" => [ 7, \&_action_opcode_735 ], },
	# [2816] opcode : ldi c "," "(" ix "-"
	{ "!" => [ 14, 2817 ], "+" => [ 14, 2817 ], "-" => [ 14, 2817 ], __else__ => [ 14, 2817 ], "~" => [ 14, 2817 ], },
	# [2817] opcode : ldi c "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 2818, },
	# [2818] opcode : ldi c "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_735 ], ":" => [ 7, \&_action_opcode_735 ], },
	# [2819] opcode : ldi c "," "(" iy
	{ ")" => 2820, "+" => 2821, "-" => 2824, },
	# [2820] opcode : ldi c "," "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_736 ], ":" => [ 7, \&_action_opcode_736 ], },
	# [2821] opcode : ldi c "," "(" iy "+"
	{ "!" => [ 12, 2822 ], "+" => [ 12, 2822 ], "-" => [ 12, 2822 ], __else__ => [ 12, 2822 ], "~" => [ 12, 2822 ], },
	# [2822] opcode : ldi c "," "(" iy "+" "[expr_DIS]"
	{ ")" => 2823, },
	# [2823] opcode : ldi c "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_737 ], ":" => [ 7, \&_action_opcode_737 ], },
	# [2824] opcode : ldi c "," "(" iy "-"
	{ "!" => [ 14, 2825 ], "+" => [ 14, 2825 ], "-" => [ 14, 2825 ], __else__ => [ 14, 2825 ], "~" => [ 14, 2825 ], },
	# [2825] opcode : ldi c "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 2826, },
	# [2826] opcode : ldi c "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_737 ], ":" => [ 7, \&_action_opcode_737 ], },
	# [2827] opcode : ldi c "," "["
	{ hl => 2828, ix => 2830, iy => 2838, },
	# [2828] opcode : ldi c "," "[" hl
	{ "]" => 2829, },
	# [2829] opcode : ldi c "," "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_733 ], ":" => [ 7, \&_action_opcode_733 ], },
	# [2830] opcode : ldi c "," "[" ix
	{ "+" => 2831, "-" => 2834, "]" => 2837, },
	# [2831] opcode : ldi c "," "[" ix "+"
	{ "!" => [ 12, 2832 ], "+" => [ 12, 2832 ], "-" => [ 12, 2832 ], __else__ => [ 12, 2832 ], "~" => [ 12, 2832 ], },
	# [2832] opcode : ldi c "," "[" ix "+" "[expr_DIS]"
	{ "]" => 2833, },
	# [2833] opcode : ldi c "," "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_735 ], ":" => [ 7, \&_action_opcode_735 ], },
	# [2834] opcode : ldi c "," "[" ix "-"
	{ "!" => [ 14, 2835 ], "+" => [ 14, 2835 ], "-" => [ 14, 2835 ], __else__ => [ 14, 2835 ], "~" => [ 14, 2835 ], },
	# [2835] opcode : ldi c "," "[" ix "-" "[expr_NDIS]"
	{ "]" => 2836, },
	# [2836] opcode : ldi c "," "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_735 ], ":" => [ 7, \&_action_opcode_735 ], },
	# [2837] opcode : ldi c "," "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_734 ], ":" => [ 7, \&_action_opcode_734 ], },
	# [2838] opcode : ldi c "," "[" iy
	{ "+" => 2839, "-" => 2842, "]" => 2845, },
	# [2839] opcode : ldi c "," "[" iy "+"
	{ "!" => [ 12, 2840 ], "+" => [ 12, 2840 ], "-" => [ 12, 2840 ], __else__ => [ 12, 2840 ], "~" => [ 12, 2840 ], },
	# [2840] opcode : ldi c "," "[" iy "+" "[expr_DIS]"
	{ "]" => 2841, },
	# [2841] opcode : ldi c "," "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_737 ], ":" => [ 7, \&_action_opcode_737 ], },
	# [2842] opcode : ldi c "," "[" iy "-"
	{ "!" => [ 14, 2843 ], "+" => [ 14, 2843 ], "-" => [ 14, 2843 ], __else__ => [ 14, 2843 ], "~" => [ 14, 2843 ], },
	# [2843] opcode : ldi c "," "[" iy "-" "[expr_NDIS]"
	{ "]" => 2844, },
	# [2844] opcode : ldi c "," "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_737 ], ":" => [ 7, \&_action_opcode_737 ], },
	# [2845] opcode : ldi c "," "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_736 ], ":" => [ 7, \&_action_opcode_736 ], },
	# [2846] opcode : ldi d
	{ "," => 2847, },
	# [2847] opcode : ldi d ","
	{ "(" => 2848, "[" => 2867, },
	# [2848] opcode : ldi d "," "("
	{ hl => 2849, ix => 2851, iy => 2859, },
	# [2849] opcode : ldi d "," "(" hl
	{ ")" => 2850, },
	# [2850] opcode : ldi d "," "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_738 ], ":" => [ 7, \&_action_opcode_738 ], },
	# [2851] opcode : ldi d "," "(" ix
	{ ")" => 2852, "+" => 2853, "-" => 2856, },
	# [2852] opcode : ldi d "," "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_739 ], ":" => [ 7, \&_action_opcode_739 ], },
	# [2853] opcode : ldi d "," "(" ix "+"
	{ "!" => [ 12, 2854 ], "+" => [ 12, 2854 ], "-" => [ 12, 2854 ], __else__ => [ 12, 2854 ], "~" => [ 12, 2854 ], },
	# [2854] opcode : ldi d "," "(" ix "+" "[expr_DIS]"
	{ ")" => 2855, },
	# [2855] opcode : ldi d "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_740 ], ":" => [ 7, \&_action_opcode_740 ], },
	# [2856] opcode : ldi d "," "(" ix "-"
	{ "!" => [ 14, 2857 ], "+" => [ 14, 2857 ], "-" => [ 14, 2857 ], __else__ => [ 14, 2857 ], "~" => [ 14, 2857 ], },
	# [2857] opcode : ldi d "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 2858, },
	# [2858] opcode : ldi d "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_740 ], ":" => [ 7, \&_action_opcode_740 ], },
	# [2859] opcode : ldi d "," "(" iy
	{ ")" => 2860, "+" => 2861, "-" => 2864, },
	# [2860] opcode : ldi d "," "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_741 ], ":" => [ 7, \&_action_opcode_741 ], },
	# [2861] opcode : ldi d "," "(" iy "+"
	{ "!" => [ 12, 2862 ], "+" => [ 12, 2862 ], "-" => [ 12, 2862 ], __else__ => [ 12, 2862 ], "~" => [ 12, 2862 ], },
	# [2862] opcode : ldi d "," "(" iy "+" "[expr_DIS]"
	{ ")" => 2863, },
	# [2863] opcode : ldi d "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_742 ], ":" => [ 7, \&_action_opcode_742 ], },
	# [2864] opcode : ldi d "," "(" iy "-"
	{ "!" => [ 14, 2865 ], "+" => [ 14, 2865 ], "-" => [ 14, 2865 ], __else__ => [ 14, 2865 ], "~" => [ 14, 2865 ], },
	# [2865] opcode : ldi d "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 2866, },
	# [2866] opcode : ldi d "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_742 ], ":" => [ 7, \&_action_opcode_742 ], },
	# [2867] opcode : ldi d "," "["
	{ hl => 2868, ix => 2870, iy => 2878, },
	# [2868] opcode : ldi d "," "[" hl
	{ "]" => 2869, },
	# [2869] opcode : ldi d "," "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_738 ], ":" => [ 7, \&_action_opcode_738 ], },
	# [2870] opcode : ldi d "," "[" ix
	{ "+" => 2871, "-" => 2874, "]" => 2877, },
	# [2871] opcode : ldi d "," "[" ix "+"
	{ "!" => [ 12, 2872 ], "+" => [ 12, 2872 ], "-" => [ 12, 2872 ], __else__ => [ 12, 2872 ], "~" => [ 12, 2872 ], },
	# [2872] opcode : ldi d "," "[" ix "+" "[expr_DIS]"
	{ "]" => 2873, },
	# [2873] opcode : ldi d "," "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_740 ], ":" => [ 7, \&_action_opcode_740 ], },
	# [2874] opcode : ldi d "," "[" ix "-"
	{ "!" => [ 14, 2875 ], "+" => [ 14, 2875 ], "-" => [ 14, 2875 ], __else__ => [ 14, 2875 ], "~" => [ 14, 2875 ], },
	# [2875] opcode : ldi d "," "[" ix "-" "[expr_NDIS]"
	{ "]" => 2876, },
	# [2876] opcode : ldi d "," "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_740 ], ":" => [ 7, \&_action_opcode_740 ], },
	# [2877] opcode : ldi d "," "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_739 ], ":" => [ 7, \&_action_opcode_739 ], },
	# [2878] opcode : ldi d "," "[" iy
	{ "+" => 2879, "-" => 2882, "]" => 2885, },
	# [2879] opcode : ldi d "," "[" iy "+"
	{ "!" => [ 12, 2880 ], "+" => [ 12, 2880 ], "-" => [ 12, 2880 ], __else__ => [ 12, 2880 ], "~" => [ 12, 2880 ], },
	# [2880] opcode : ldi d "," "[" iy "+" "[expr_DIS]"
	{ "]" => 2881, },
	# [2881] opcode : ldi d "," "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_742 ], ":" => [ 7, \&_action_opcode_742 ], },
	# [2882] opcode : ldi d "," "[" iy "-"
	{ "!" => [ 14, 2883 ], "+" => [ 14, 2883 ], "-" => [ 14, 2883 ], __else__ => [ 14, 2883 ], "~" => [ 14, 2883 ], },
	# [2883] opcode : ldi d "," "[" iy "-" "[expr_NDIS]"
	{ "]" => 2884, },
	# [2884] opcode : ldi d "," "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_742 ], ":" => [ 7, \&_action_opcode_742 ], },
	# [2885] opcode : ldi d "," "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_741 ], ":" => [ 7, \&_action_opcode_741 ], },
	# [2886] opcode : ldi de
	{ "," => 2887, },
	# [2887] opcode : ldi de ","
	{ "(" => 2888, "[" => 2907, },
	# [2888] opcode : ldi de "," "("
	{ hl => 2889, ix => 2891, iy => 2899, },
	# [2889] opcode : ldi de "," "(" hl
	{ ")" => 2890, },
	# [2890] opcode : ldi de "," "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_743 ], ":" => [ 7, \&_action_opcode_743 ], },
	# [2891] opcode : ldi de "," "(" ix
	{ ")" => 2892, "+" => 2893, "-" => 2896, },
	# [2892] opcode : ldi de "," "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_744 ], ":" => [ 7, \&_action_opcode_744 ], },
	# [2893] opcode : ldi de "," "(" ix "+"
	{ "!" => [ 12, 2894 ], "+" => [ 12, 2894 ], "-" => [ 12, 2894 ], __else__ => [ 12, 2894 ], "~" => [ 12, 2894 ], },
	# [2894] opcode : ldi de "," "(" ix "+" "[expr_DIS]"
	{ ")" => 2895, },
	# [2895] opcode : ldi de "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_745 ], ":" => [ 7, \&_action_opcode_745 ], },
	# [2896] opcode : ldi de "," "(" ix "-"
	{ "!" => [ 14, 2897 ], "+" => [ 14, 2897 ], "-" => [ 14, 2897 ], __else__ => [ 14, 2897 ], "~" => [ 14, 2897 ], },
	# [2897] opcode : ldi de "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 2898, },
	# [2898] opcode : ldi de "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_745 ], ":" => [ 7, \&_action_opcode_745 ], },
	# [2899] opcode : ldi de "," "(" iy
	{ ")" => 2900, "+" => 2901, "-" => 2904, },
	# [2900] opcode : ldi de "," "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_746 ], ":" => [ 7, \&_action_opcode_746 ], },
	# [2901] opcode : ldi de "," "(" iy "+"
	{ "!" => [ 12, 2902 ], "+" => [ 12, 2902 ], "-" => [ 12, 2902 ], __else__ => [ 12, 2902 ], "~" => [ 12, 2902 ], },
	# [2902] opcode : ldi de "," "(" iy "+" "[expr_DIS]"
	{ ")" => 2903, },
	# [2903] opcode : ldi de "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_747 ], ":" => [ 7, \&_action_opcode_747 ], },
	# [2904] opcode : ldi de "," "(" iy "-"
	{ "!" => [ 14, 2905 ], "+" => [ 14, 2905 ], "-" => [ 14, 2905 ], __else__ => [ 14, 2905 ], "~" => [ 14, 2905 ], },
	# [2905] opcode : ldi de "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 2906, },
	# [2906] opcode : ldi de "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_747 ], ":" => [ 7, \&_action_opcode_747 ], },
	# [2907] opcode : ldi de "," "["
	{ hl => 2908, ix => 2910, iy => 2918, },
	# [2908] opcode : ldi de "," "[" hl
	{ "]" => 2909, },
	# [2909] opcode : ldi de "," "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_743 ], ":" => [ 7, \&_action_opcode_743 ], },
	# [2910] opcode : ldi de "," "[" ix
	{ "+" => 2911, "-" => 2914, "]" => 2917, },
	# [2911] opcode : ldi de "," "[" ix "+"
	{ "!" => [ 12, 2912 ], "+" => [ 12, 2912 ], "-" => [ 12, 2912 ], __else__ => [ 12, 2912 ], "~" => [ 12, 2912 ], },
	# [2912] opcode : ldi de "," "[" ix "+" "[expr_DIS]"
	{ "]" => 2913, },
	# [2913] opcode : ldi de "," "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_745 ], ":" => [ 7, \&_action_opcode_745 ], },
	# [2914] opcode : ldi de "," "[" ix "-"
	{ "!" => [ 14, 2915 ], "+" => [ 14, 2915 ], "-" => [ 14, 2915 ], __else__ => [ 14, 2915 ], "~" => [ 14, 2915 ], },
	# [2915] opcode : ldi de "," "[" ix "-" "[expr_NDIS]"
	{ "]" => 2916, },
	# [2916] opcode : ldi de "," "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_745 ], ":" => [ 7, \&_action_opcode_745 ], },
	# [2917] opcode : ldi de "," "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_744 ], ":" => [ 7, \&_action_opcode_744 ], },
	# [2918] opcode : ldi de "," "[" iy
	{ "+" => 2919, "-" => 2922, "]" => 2925, },
	# [2919] opcode : ldi de "," "[" iy "+"
	{ "!" => [ 12, 2920 ], "+" => [ 12, 2920 ], "-" => [ 12, 2920 ], __else__ => [ 12, 2920 ], "~" => [ 12, 2920 ], },
	# [2920] opcode : ldi de "," "[" iy "+" "[expr_DIS]"
	{ "]" => 2921, },
	# [2921] opcode : ldi de "," "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_747 ], ":" => [ 7, \&_action_opcode_747 ], },
	# [2922] opcode : ldi de "," "[" iy "-"
	{ "!" => [ 14, 2923 ], "+" => [ 14, 2923 ], "-" => [ 14, 2923 ], __else__ => [ 14, 2923 ], "~" => [ 14, 2923 ], },
	# [2923] opcode : ldi de "," "[" iy "-" "[expr_NDIS]"
	{ "]" => 2924, },
	# [2924] opcode : ldi de "," "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_747 ], ":" => [ 7, \&_action_opcode_747 ], },
	# [2925] opcode : ldi de "," "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_746 ], ":" => [ 7, \&_action_opcode_746 ], },
	# [2926] opcode : ldi e
	{ "," => 2927, },
	# [2927] opcode : ldi e ","
	{ "(" => 2928, "[" => 2947, },
	# [2928] opcode : ldi e "," "("
	{ hl => 2929, ix => 2931, iy => 2939, },
	# [2929] opcode : ldi e "," "(" hl
	{ ")" => 2930, },
	# [2930] opcode : ldi e "," "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_748 ], ":" => [ 7, \&_action_opcode_748 ], },
	# [2931] opcode : ldi e "," "(" ix
	{ ")" => 2932, "+" => 2933, "-" => 2936, },
	# [2932] opcode : ldi e "," "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_749 ], ":" => [ 7, \&_action_opcode_749 ], },
	# [2933] opcode : ldi e "," "(" ix "+"
	{ "!" => [ 12, 2934 ], "+" => [ 12, 2934 ], "-" => [ 12, 2934 ], __else__ => [ 12, 2934 ], "~" => [ 12, 2934 ], },
	# [2934] opcode : ldi e "," "(" ix "+" "[expr_DIS]"
	{ ")" => 2935, },
	# [2935] opcode : ldi e "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_750 ], ":" => [ 7, \&_action_opcode_750 ], },
	# [2936] opcode : ldi e "," "(" ix "-"
	{ "!" => [ 14, 2937 ], "+" => [ 14, 2937 ], "-" => [ 14, 2937 ], __else__ => [ 14, 2937 ], "~" => [ 14, 2937 ], },
	# [2937] opcode : ldi e "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 2938, },
	# [2938] opcode : ldi e "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_750 ], ":" => [ 7, \&_action_opcode_750 ], },
	# [2939] opcode : ldi e "," "(" iy
	{ ")" => 2940, "+" => 2941, "-" => 2944, },
	# [2940] opcode : ldi e "," "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_751 ], ":" => [ 7, \&_action_opcode_751 ], },
	# [2941] opcode : ldi e "," "(" iy "+"
	{ "!" => [ 12, 2942 ], "+" => [ 12, 2942 ], "-" => [ 12, 2942 ], __else__ => [ 12, 2942 ], "~" => [ 12, 2942 ], },
	# [2942] opcode : ldi e "," "(" iy "+" "[expr_DIS]"
	{ ")" => 2943, },
	# [2943] opcode : ldi e "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_752 ], ":" => [ 7, \&_action_opcode_752 ], },
	# [2944] opcode : ldi e "," "(" iy "-"
	{ "!" => [ 14, 2945 ], "+" => [ 14, 2945 ], "-" => [ 14, 2945 ], __else__ => [ 14, 2945 ], "~" => [ 14, 2945 ], },
	# [2945] opcode : ldi e "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 2946, },
	# [2946] opcode : ldi e "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_752 ], ":" => [ 7, \&_action_opcode_752 ], },
	# [2947] opcode : ldi e "," "["
	{ hl => 2948, ix => 2950, iy => 2958, },
	# [2948] opcode : ldi e "," "[" hl
	{ "]" => 2949, },
	# [2949] opcode : ldi e "," "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_748 ], ":" => [ 7, \&_action_opcode_748 ], },
	# [2950] opcode : ldi e "," "[" ix
	{ "+" => 2951, "-" => 2954, "]" => 2957, },
	# [2951] opcode : ldi e "," "[" ix "+"
	{ "!" => [ 12, 2952 ], "+" => [ 12, 2952 ], "-" => [ 12, 2952 ], __else__ => [ 12, 2952 ], "~" => [ 12, 2952 ], },
	# [2952] opcode : ldi e "," "[" ix "+" "[expr_DIS]"
	{ "]" => 2953, },
	# [2953] opcode : ldi e "," "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_750 ], ":" => [ 7, \&_action_opcode_750 ], },
	# [2954] opcode : ldi e "," "[" ix "-"
	{ "!" => [ 14, 2955 ], "+" => [ 14, 2955 ], "-" => [ 14, 2955 ], __else__ => [ 14, 2955 ], "~" => [ 14, 2955 ], },
	# [2955] opcode : ldi e "," "[" ix "-" "[expr_NDIS]"
	{ "]" => 2956, },
	# [2956] opcode : ldi e "," "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_750 ], ":" => [ 7, \&_action_opcode_750 ], },
	# [2957] opcode : ldi e "," "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_749 ], ":" => [ 7, \&_action_opcode_749 ], },
	# [2958] opcode : ldi e "," "[" iy
	{ "+" => 2959, "-" => 2962, "]" => 2965, },
	# [2959] opcode : ldi e "," "[" iy "+"
	{ "!" => [ 12, 2960 ], "+" => [ 12, 2960 ], "-" => [ 12, 2960 ], __else__ => [ 12, 2960 ], "~" => [ 12, 2960 ], },
	# [2960] opcode : ldi e "," "[" iy "+" "[expr_DIS]"
	{ "]" => 2961, },
	# [2961] opcode : ldi e "," "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_752 ], ":" => [ 7, \&_action_opcode_752 ], },
	# [2962] opcode : ldi e "," "[" iy "-"
	{ "!" => [ 14, 2963 ], "+" => [ 14, 2963 ], "-" => [ 14, 2963 ], __else__ => [ 14, 2963 ], "~" => [ 14, 2963 ], },
	# [2963] opcode : ldi e "," "[" iy "-" "[expr_NDIS]"
	{ "]" => 2964, },
	# [2964] opcode : ldi e "," "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_752 ], ":" => [ 7, \&_action_opcode_752 ], },
	# [2965] opcode : ldi e "," "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_751 ], ":" => [ 7, \&_action_opcode_751 ], },
	# [2966] opcode : ldi h
	{ "," => 2967, },
	# [2967] opcode : ldi h ","
	{ "(" => 2968, "[" => 2987, },
	# [2968] opcode : ldi h "," "("
	{ hl => 2969, ix => 2971, iy => 2979, },
	# [2969] opcode : ldi h "," "(" hl
	{ ")" => 2970, },
	# [2970] opcode : ldi h "," "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_753 ], ":" => [ 7, \&_action_opcode_753 ], },
	# [2971] opcode : ldi h "," "(" ix
	{ ")" => 2972, "+" => 2973, "-" => 2976, },
	# [2972] opcode : ldi h "," "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_754 ], ":" => [ 7, \&_action_opcode_754 ], },
	# [2973] opcode : ldi h "," "(" ix "+"
	{ "!" => [ 12, 2974 ], "+" => [ 12, 2974 ], "-" => [ 12, 2974 ], __else__ => [ 12, 2974 ], "~" => [ 12, 2974 ], },
	# [2974] opcode : ldi h "," "(" ix "+" "[expr_DIS]"
	{ ")" => 2975, },
	# [2975] opcode : ldi h "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_755 ], ":" => [ 7, \&_action_opcode_755 ], },
	# [2976] opcode : ldi h "," "(" ix "-"
	{ "!" => [ 14, 2977 ], "+" => [ 14, 2977 ], "-" => [ 14, 2977 ], __else__ => [ 14, 2977 ], "~" => [ 14, 2977 ], },
	# [2977] opcode : ldi h "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 2978, },
	# [2978] opcode : ldi h "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_755 ], ":" => [ 7, \&_action_opcode_755 ], },
	# [2979] opcode : ldi h "," "(" iy
	{ ")" => 2980, "+" => 2981, "-" => 2984, },
	# [2980] opcode : ldi h "," "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_756 ], ":" => [ 7, \&_action_opcode_756 ], },
	# [2981] opcode : ldi h "," "(" iy "+"
	{ "!" => [ 12, 2982 ], "+" => [ 12, 2982 ], "-" => [ 12, 2982 ], __else__ => [ 12, 2982 ], "~" => [ 12, 2982 ], },
	# [2982] opcode : ldi h "," "(" iy "+" "[expr_DIS]"
	{ ")" => 2983, },
	# [2983] opcode : ldi h "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_757 ], ":" => [ 7, \&_action_opcode_757 ], },
	# [2984] opcode : ldi h "," "(" iy "-"
	{ "!" => [ 14, 2985 ], "+" => [ 14, 2985 ], "-" => [ 14, 2985 ], __else__ => [ 14, 2985 ], "~" => [ 14, 2985 ], },
	# [2985] opcode : ldi h "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 2986, },
	# [2986] opcode : ldi h "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_757 ], ":" => [ 7, \&_action_opcode_757 ], },
	# [2987] opcode : ldi h "," "["
	{ hl => 2988, ix => 2990, iy => 2998, },
	# [2988] opcode : ldi h "," "[" hl
	{ "]" => 2989, },
	# [2989] opcode : ldi h "," "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_753 ], ":" => [ 7, \&_action_opcode_753 ], },
	# [2990] opcode : ldi h "," "[" ix
	{ "+" => 2991, "-" => 2994, "]" => 2997, },
	# [2991] opcode : ldi h "," "[" ix "+"
	{ "!" => [ 12, 2992 ], "+" => [ 12, 2992 ], "-" => [ 12, 2992 ], __else__ => [ 12, 2992 ], "~" => [ 12, 2992 ], },
	# [2992] opcode : ldi h "," "[" ix "+" "[expr_DIS]"
	{ "]" => 2993, },
	# [2993] opcode : ldi h "," "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_755 ], ":" => [ 7, \&_action_opcode_755 ], },
	# [2994] opcode : ldi h "," "[" ix "-"
	{ "!" => [ 14, 2995 ], "+" => [ 14, 2995 ], "-" => [ 14, 2995 ], __else__ => [ 14, 2995 ], "~" => [ 14, 2995 ], },
	# [2995] opcode : ldi h "," "[" ix "-" "[expr_NDIS]"
	{ "]" => 2996, },
	# [2996] opcode : ldi h "," "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_755 ], ":" => [ 7, \&_action_opcode_755 ], },
	# [2997] opcode : ldi h "," "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_754 ], ":" => [ 7, \&_action_opcode_754 ], },
	# [2998] opcode : ldi h "," "[" iy
	{ "+" => 2999, "-" => 3002, "]" => 3005, },
	# [2999] opcode : ldi h "," "[" iy "+"
	{ "!" => [ 12, 3000 ], "+" => [ 12, 3000 ], "-" => [ 12, 3000 ], __else__ => [ 12, 3000 ], "~" => [ 12, 3000 ], },
	# [3000] opcode : ldi h "," "[" iy "+" "[expr_DIS]"
	{ "]" => 3001, },
	# [3001] opcode : ldi h "," "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_757 ], ":" => [ 7, \&_action_opcode_757 ], },
	# [3002] opcode : ldi h "," "[" iy "-"
	{ "!" => [ 14, 3003 ], "+" => [ 14, 3003 ], "-" => [ 14, 3003 ], __else__ => [ 14, 3003 ], "~" => [ 14, 3003 ], },
	# [3003] opcode : ldi h "," "[" iy "-" "[expr_NDIS]"
	{ "]" => 3004, },
	# [3004] opcode : ldi h "," "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_757 ], ":" => [ 7, \&_action_opcode_757 ], },
	# [3005] opcode : ldi h "," "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_756 ], ":" => [ 7, \&_action_opcode_756 ], },
	# [3006] opcode : ldi hl
	{ "," => 3007, },
	# [3007] opcode : ldi hl ","
	{ "(" => 3008, "[" => 3025, },
	# [3008] opcode : ldi hl "," "("
	{ ix => 3009, iy => 3017, },
	# [3009] opcode : ldi hl "," "(" ix
	{ ")" => 3010, "+" => 3011, "-" => 3014, },
	# [3010] opcode : ldi hl "," "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_758 ], ":" => [ 7, \&_action_opcode_758 ], },
	# [3011] opcode : ldi hl "," "(" ix "+"
	{ "!" => [ 12, 3012 ], "+" => [ 12, 3012 ], "-" => [ 12, 3012 ], __else__ => [ 12, 3012 ], "~" => [ 12, 3012 ], },
	# [3012] opcode : ldi hl "," "(" ix "+" "[expr_DIS]"
	{ ")" => 3013, },
	# [3013] opcode : ldi hl "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_759 ], ":" => [ 7, \&_action_opcode_759 ], },
	# [3014] opcode : ldi hl "," "(" ix "-"
	{ "!" => [ 14, 3015 ], "+" => [ 14, 3015 ], "-" => [ 14, 3015 ], __else__ => [ 14, 3015 ], "~" => [ 14, 3015 ], },
	# [3015] opcode : ldi hl "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 3016, },
	# [3016] opcode : ldi hl "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_759 ], ":" => [ 7, \&_action_opcode_759 ], },
	# [3017] opcode : ldi hl "," "(" iy
	{ ")" => 3018, "+" => 3019, "-" => 3022, },
	# [3018] opcode : ldi hl "," "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_760 ], ":" => [ 7, \&_action_opcode_760 ], },
	# [3019] opcode : ldi hl "," "(" iy "+"
	{ "!" => [ 12, 3020 ], "+" => [ 12, 3020 ], "-" => [ 12, 3020 ], __else__ => [ 12, 3020 ], "~" => [ 12, 3020 ], },
	# [3020] opcode : ldi hl "," "(" iy "+" "[expr_DIS]"
	{ ")" => 3021, },
	# [3021] opcode : ldi hl "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_761 ], ":" => [ 7, \&_action_opcode_761 ], },
	# [3022] opcode : ldi hl "," "(" iy "-"
	{ "!" => [ 14, 3023 ], "+" => [ 14, 3023 ], "-" => [ 14, 3023 ], __else__ => [ 14, 3023 ], "~" => [ 14, 3023 ], },
	# [3023] opcode : ldi hl "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 3024, },
	# [3024] opcode : ldi hl "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_761 ], ":" => [ 7, \&_action_opcode_761 ], },
	# [3025] opcode : ldi hl "," "["
	{ ix => 3026, iy => 3034, },
	# [3026] opcode : ldi hl "," "[" ix
	{ "+" => 3027, "-" => 3030, "]" => 3033, },
	# [3027] opcode : ldi hl "," "[" ix "+"
	{ "!" => [ 12, 3028 ], "+" => [ 12, 3028 ], "-" => [ 12, 3028 ], __else__ => [ 12, 3028 ], "~" => [ 12, 3028 ], },
	# [3028] opcode : ldi hl "," "[" ix "+" "[expr_DIS]"
	{ "]" => 3029, },
	# [3029] opcode : ldi hl "," "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_759 ], ":" => [ 7, \&_action_opcode_759 ], },
	# [3030] opcode : ldi hl "," "[" ix "-"
	{ "!" => [ 14, 3031 ], "+" => [ 14, 3031 ], "-" => [ 14, 3031 ], __else__ => [ 14, 3031 ], "~" => [ 14, 3031 ], },
	# [3031] opcode : ldi hl "," "[" ix "-" "[expr_NDIS]"
	{ "]" => 3032, },
	# [3032] opcode : ldi hl "," "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_759 ], ":" => [ 7, \&_action_opcode_759 ], },
	# [3033] opcode : ldi hl "," "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_758 ], ":" => [ 7, \&_action_opcode_758 ], },
	# [3034] opcode : ldi hl "," "[" iy
	{ "+" => 3035, "-" => 3038, "]" => 3041, },
	# [3035] opcode : ldi hl "," "[" iy "+"
	{ "!" => [ 12, 3036 ], "+" => [ 12, 3036 ], "-" => [ 12, 3036 ], __else__ => [ 12, 3036 ], "~" => [ 12, 3036 ], },
	# [3036] opcode : ldi hl "," "[" iy "+" "[expr_DIS]"
	{ "]" => 3037, },
	# [3037] opcode : ldi hl "," "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_761 ], ":" => [ 7, \&_action_opcode_761 ], },
	# [3038] opcode : ldi hl "," "[" iy "-"
	{ "!" => [ 14, 3039 ], "+" => [ 14, 3039 ], "-" => [ 14, 3039 ], __else__ => [ 14, 3039 ], "~" => [ 14, 3039 ], },
	# [3039] opcode : ldi hl "," "[" iy "-" "[expr_NDIS]"
	{ "]" => 3040, },
	# [3040] opcode : ldi hl "," "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_761 ], ":" => [ 7, \&_action_opcode_761 ], },
	# [3041] opcode : ldi hl "," "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_760 ], ":" => [ 7, \&_action_opcode_760 ], },
	# [3042] opcode : ldi l
	{ "," => 3043, },
	# [3043] opcode : ldi l ","
	{ "(" => 3044, "[" => 3063, },
	# [3044] opcode : ldi l "," "("
	{ hl => 3045, ix => 3047, iy => 3055, },
	# [3045] opcode : ldi l "," "(" hl
	{ ")" => 3046, },
	# [3046] opcode : ldi l "," "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_762 ], ":" => [ 7, \&_action_opcode_762 ], },
	# [3047] opcode : ldi l "," "(" ix
	{ ")" => 3048, "+" => 3049, "-" => 3052, },
	# [3048] opcode : ldi l "," "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_763 ], ":" => [ 7, \&_action_opcode_763 ], },
	# [3049] opcode : ldi l "," "(" ix "+"
	{ "!" => [ 12, 3050 ], "+" => [ 12, 3050 ], "-" => [ 12, 3050 ], __else__ => [ 12, 3050 ], "~" => [ 12, 3050 ], },
	# [3050] opcode : ldi l "," "(" ix "+" "[expr_DIS]"
	{ ")" => 3051, },
	# [3051] opcode : ldi l "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_764 ], ":" => [ 7, \&_action_opcode_764 ], },
	# [3052] opcode : ldi l "," "(" ix "-"
	{ "!" => [ 14, 3053 ], "+" => [ 14, 3053 ], "-" => [ 14, 3053 ], __else__ => [ 14, 3053 ], "~" => [ 14, 3053 ], },
	# [3053] opcode : ldi l "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 3054, },
	# [3054] opcode : ldi l "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_764 ], ":" => [ 7, \&_action_opcode_764 ], },
	# [3055] opcode : ldi l "," "(" iy
	{ ")" => 3056, "+" => 3057, "-" => 3060, },
	# [3056] opcode : ldi l "," "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_765 ], ":" => [ 7, \&_action_opcode_765 ], },
	# [3057] opcode : ldi l "," "(" iy "+"
	{ "!" => [ 12, 3058 ], "+" => [ 12, 3058 ], "-" => [ 12, 3058 ], __else__ => [ 12, 3058 ], "~" => [ 12, 3058 ], },
	# [3058] opcode : ldi l "," "(" iy "+" "[expr_DIS]"
	{ ")" => 3059, },
	# [3059] opcode : ldi l "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_766 ], ":" => [ 7, \&_action_opcode_766 ], },
	# [3060] opcode : ldi l "," "(" iy "-"
	{ "!" => [ 14, 3061 ], "+" => [ 14, 3061 ], "-" => [ 14, 3061 ], __else__ => [ 14, 3061 ], "~" => [ 14, 3061 ], },
	# [3061] opcode : ldi l "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 3062, },
	# [3062] opcode : ldi l "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_766 ], ":" => [ 7, \&_action_opcode_766 ], },
	# [3063] opcode : ldi l "," "["
	{ hl => 3064, ix => 3066, iy => 3074, },
	# [3064] opcode : ldi l "," "[" hl
	{ "]" => 3065, },
	# [3065] opcode : ldi l "," "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_762 ], ":" => [ 7, \&_action_opcode_762 ], },
	# [3066] opcode : ldi l "," "[" ix
	{ "+" => 3067, "-" => 3070, "]" => 3073, },
	# [3067] opcode : ldi l "," "[" ix "+"
	{ "!" => [ 12, 3068 ], "+" => [ 12, 3068 ], "-" => [ 12, 3068 ], __else__ => [ 12, 3068 ], "~" => [ 12, 3068 ], },
	# [3068] opcode : ldi l "," "[" ix "+" "[expr_DIS]"
	{ "]" => 3069, },
	# [3069] opcode : ldi l "," "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_764 ], ":" => [ 7, \&_action_opcode_764 ], },
	# [3070] opcode : ldi l "," "[" ix "-"
	{ "!" => [ 14, 3071 ], "+" => [ 14, 3071 ], "-" => [ 14, 3071 ], __else__ => [ 14, 3071 ], "~" => [ 14, 3071 ], },
	# [3071] opcode : ldi l "," "[" ix "-" "[expr_NDIS]"
	{ "]" => 3072, },
	# [3072] opcode : ldi l "," "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_764 ], ":" => [ 7, \&_action_opcode_764 ], },
	# [3073] opcode : ldi l "," "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_763 ], ":" => [ 7, \&_action_opcode_763 ], },
	# [3074] opcode : ldi l "," "[" iy
	{ "+" => 3075, "-" => 3078, "]" => 3081, },
	# [3075] opcode : ldi l "," "[" iy "+"
	{ "!" => [ 12, 3076 ], "+" => [ 12, 3076 ], "-" => [ 12, 3076 ], __else__ => [ 12, 3076 ], "~" => [ 12, 3076 ], },
	# [3076] opcode : ldi l "," "[" iy "+" "[expr_DIS]"
	{ "]" => 3077, },
	# [3077] opcode : ldi l "," "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_766 ], ":" => [ 7, \&_action_opcode_766 ], },
	# [3078] opcode : ldi l "," "[" iy "-"
	{ "!" => [ 14, 3079 ], "+" => [ 14, 3079 ], "-" => [ 14, 3079 ], __else__ => [ 14, 3079 ], "~" => [ 14, 3079 ], },
	# [3079] opcode : ldi l "," "[" iy "-" "[expr_NDIS]"
	{ "]" => 3080, },
	# [3080] opcode : ldi l "," "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_766 ], ":" => [ 7, \&_action_opcode_766 ], },
	# [3081] opcode : ldi l "," "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_765 ], ":" => [ 7, \&_action_opcode_765 ], },
	# [3082] opcode : ldir
	{ "\n" => [ 7, \&_action_opcode_767 ], ":" => [ 7, \&_action_opcode_767 ], },
	# [3083] opcode : neg
	{ "\n" => [ 7, \&_action_opcode_768 ], ":" => [ 7, \&_action_opcode_768 ], },
	# [3084] opcode : nop
	{ "\n" => [ 7, \&_action_opcode_769 ], ":" => [ 7, \&_action_opcode_769 ], },
	# [3085] opcode : or
	{ "!" => [ 13, 3124 ], "(" => 3086, "+" => [ 13, 3124 ], "-" => [ 13, 3124 ], "[" => 3105, __else__ => [ 13, 3124 ], a => 3125, b => 3126, c => 3127, d => 3128, e => 3129, h => 3130, hx => 3131, hy => 3132, ixh => 3133, ixl => 3134, iyh => 3135, iyl => 3136, l => 3137, lx => 3138, ly => 3139, xh => 3140, xl => 3141, yh => 3142, yl => 3143, "~" => [ 13, 3124 ], },
	# [3086] opcode : or "("
	{ hl => 3087, ix => 3089, iy => 3097, },
	# [3087] opcode : or "(" hl
	{ ")" => 3088, },
	# [3088] opcode : or "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_770 ], ":" => [ 7, \&_action_opcode_770 ], },
	# [3089] opcode : or "(" ix
	{ ")" => 3090, "+" => 3091, "-" => 3094, },
	# [3090] opcode : or "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_771 ], ":" => [ 7, \&_action_opcode_771 ], },
	# [3091] opcode : or "(" ix "+"
	{ "!" => [ 12, 3092 ], "+" => [ 12, 3092 ], "-" => [ 12, 3092 ], __else__ => [ 12, 3092 ], "~" => [ 12, 3092 ], },
	# [3092] opcode : or "(" ix "+" "[expr_DIS]"
	{ ")" => 3093, },
	# [3093] opcode : or "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_772 ], ":" => [ 7, \&_action_opcode_772 ], },
	# [3094] opcode : or "(" ix "-"
	{ "!" => [ 14, 3095 ], "+" => [ 14, 3095 ], "-" => [ 14, 3095 ], __else__ => [ 14, 3095 ], "~" => [ 14, 3095 ], },
	# [3095] opcode : or "(" ix "-" "[expr_NDIS]"
	{ ")" => 3096, },
	# [3096] opcode : or "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_772 ], ":" => [ 7, \&_action_opcode_772 ], },
	# [3097] opcode : or "(" iy
	{ ")" => 3098, "+" => 3099, "-" => 3102, },
	# [3098] opcode : or "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_773 ], ":" => [ 7, \&_action_opcode_773 ], },
	# [3099] opcode : or "(" iy "+"
	{ "!" => [ 12, 3100 ], "+" => [ 12, 3100 ], "-" => [ 12, 3100 ], __else__ => [ 12, 3100 ], "~" => [ 12, 3100 ], },
	# [3100] opcode : or "(" iy "+" "[expr_DIS]"
	{ ")" => 3101, },
	# [3101] opcode : or "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_774 ], ":" => [ 7, \&_action_opcode_774 ], },
	# [3102] opcode : or "(" iy "-"
	{ "!" => [ 14, 3103 ], "+" => [ 14, 3103 ], "-" => [ 14, 3103 ], __else__ => [ 14, 3103 ], "~" => [ 14, 3103 ], },
	# [3103] opcode : or "(" iy "-" "[expr_NDIS]"
	{ ")" => 3104, },
	# [3104] opcode : or "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_774 ], ":" => [ 7, \&_action_opcode_774 ], },
	# [3105] opcode : or "["
	{ hl => 3106, ix => 3108, iy => 3116, },
	# [3106] opcode : or "[" hl
	{ "]" => 3107, },
	# [3107] opcode : or "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_770 ], ":" => [ 7, \&_action_opcode_770 ], },
	# [3108] opcode : or "[" ix
	{ "+" => 3109, "-" => 3112, "]" => 3115, },
	# [3109] opcode : or "[" ix "+"
	{ "!" => [ 12, 3110 ], "+" => [ 12, 3110 ], "-" => [ 12, 3110 ], __else__ => [ 12, 3110 ], "~" => [ 12, 3110 ], },
	# [3110] opcode : or "[" ix "+" "[expr_DIS]"
	{ "]" => 3111, },
	# [3111] opcode : or "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_772 ], ":" => [ 7, \&_action_opcode_772 ], },
	# [3112] opcode : or "[" ix "-"
	{ "!" => [ 14, 3113 ], "+" => [ 14, 3113 ], "-" => [ 14, 3113 ], __else__ => [ 14, 3113 ], "~" => [ 14, 3113 ], },
	# [3113] opcode : or "[" ix "-" "[expr_NDIS]"
	{ "]" => 3114, },
	# [3114] opcode : or "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_772 ], ":" => [ 7, \&_action_opcode_772 ], },
	# [3115] opcode : or "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_771 ], ":" => [ 7, \&_action_opcode_771 ], },
	# [3116] opcode : or "[" iy
	{ "+" => 3117, "-" => 3120, "]" => 3123, },
	# [3117] opcode : or "[" iy "+"
	{ "!" => [ 12, 3118 ], "+" => [ 12, 3118 ], "-" => [ 12, 3118 ], __else__ => [ 12, 3118 ], "~" => [ 12, 3118 ], },
	# [3118] opcode : or "[" iy "+" "[expr_DIS]"
	{ "]" => 3119, },
	# [3119] opcode : or "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_774 ], ":" => [ 7, \&_action_opcode_774 ], },
	# [3120] opcode : or "[" iy "-"
	{ "!" => [ 14, 3121 ], "+" => [ 14, 3121 ], "-" => [ 14, 3121 ], __else__ => [ 14, 3121 ], "~" => [ 14, 3121 ], },
	# [3121] opcode : or "[" iy "-" "[expr_NDIS]"
	{ "]" => 3122, },
	# [3122] opcode : or "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_774 ], ":" => [ 7, \&_action_opcode_774 ], },
	# [3123] opcode : or "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_773 ], ":" => [ 7, \&_action_opcode_773 ], },
	# [3124] opcode : or "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_775 ], ":" => [ 7, \&_action_opcode_775 ], },
	# [3125] opcode : or a
	{ "\n" => [ 7, \&_action_opcode_776 ], ":" => [ 7, \&_action_opcode_776 ], },
	# [3126] opcode : or b
	{ "\n" => [ 7, \&_action_opcode_777 ], ":" => [ 7, \&_action_opcode_777 ], },
	# [3127] opcode : or c
	{ "\n" => [ 7, \&_action_opcode_778 ], ":" => [ 7, \&_action_opcode_778 ], },
	# [3128] opcode : or d
	{ "\n" => [ 7, \&_action_opcode_779 ], ":" => [ 7, \&_action_opcode_779 ], },
	# [3129] opcode : or e
	{ "\n" => [ 7, \&_action_opcode_780 ], ":" => [ 7, \&_action_opcode_780 ], },
	# [3130] opcode : or h
	{ "\n" => [ 7, \&_action_opcode_781 ], ":" => [ 7, \&_action_opcode_781 ], },
	# [3131] opcode : or hx
	{ "\n" => [ 7, \&_action_opcode_782 ], ":" => [ 7, \&_action_opcode_782 ], },
	# [3132] opcode : or hy
	{ "\n" => [ 7, \&_action_opcode_783 ], ":" => [ 7, \&_action_opcode_783 ], },
	# [3133] opcode : or ixh
	{ "\n" => [ 7, \&_action_opcode_782 ], ":" => [ 7, \&_action_opcode_782 ], },
	# [3134] opcode : or ixl
	{ "\n" => [ 7, \&_action_opcode_784 ], ":" => [ 7, \&_action_opcode_784 ], },
	# [3135] opcode : or iyh
	{ "\n" => [ 7, \&_action_opcode_783 ], ":" => [ 7, \&_action_opcode_783 ], },
	# [3136] opcode : or iyl
	{ "\n" => [ 7, \&_action_opcode_785 ], ":" => [ 7, \&_action_opcode_785 ], },
	# [3137] opcode : or l
	{ "\n" => [ 7, \&_action_opcode_786 ], ":" => [ 7, \&_action_opcode_786 ], },
	# [3138] opcode : or lx
	{ "\n" => [ 7, \&_action_opcode_784 ], ":" => [ 7, \&_action_opcode_784 ], },
	# [3139] opcode : or ly
	{ "\n" => [ 7, \&_action_opcode_785 ], ":" => [ 7, \&_action_opcode_785 ], },
	# [3140] opcode : or xh
	{ "\n" => [ 7, \&_action_opcode_782 ], ":" => [ 7, \&_action_opcode_782 ], },
	# [3141] opcode : or xl
	{ "\n" => [ 7, \&_action_opcode_784 ], ":" => [ 7, \&_action_opcode_784 ], },
	# [3142] opcode : or yh
	{ "\n" => [ 7, \&_action_opcode_783 ], ":" => [ 7, \&_action_opcode_783 ], },
	# [3143] opcode : or yl
	{ "\n" => [ 7, \&_action_opcode_785 ], ":" => [ 7, \&_action_opcode_785 ], },
	# [3144] opcode : org
	{ "!" => [ 16, \&_action_opcode_20 ], "+" => [ 16, \&_action_opcode_20 ], "-" => [ 16, \&_action_opcode_20 ], __else__ => [ 16, \&_action_opcode_20 ], "~" => [ 16, \&_action_opcode_20 ], },
	# [3145] opcode : otdr
	{ "\n" => [ 7, \&_action_opcode_787 ], ":" => [ 7, \&_action_opcode_787 ], },
	# [3146] opcode : otir
	{ "\n" => [ 7, \&_action_opcode_788 ], ":" => [ 7, \&_action_opcode_788 ], },
	# [3147] opcode : out
	{ "(" => 3148, "[" => 3165, },
	# [3148] opcode : out "("
	{ "!" => [ 13, 3149 ], "+" => [ 13, 3149 ], "-" => [ 13, 3149 ], __else__ => [ 13, 3149 ], c => 3153, "~" => [ 13, 3149 ], },
	# [3149] opcode : out "(" "[expr_N]"
	{ ")" => 3150, },
	# [3150] opcode : out "(" "[expr_N]" ")"
	{ "," => 3151, },
	# [3151] opcode : out "(" "[expr_N]" ")" ","
	{ a => 3152, },
	# [3152] opcode : out "(" "[expr_N]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_789 ], ":" => [ 7, \&_action_opcode_789 ], },
	# [3153] opcode : out "(" c
	{ ")" => 3154, },
	# [3154] opcode : out "(" c ")"
	{ "," => 3155, },
	# [3155] opcode : out "(" c ")" ","
	{ "!" => [ 30, 3156 ], "+" => [ 30, 3156 ], "-" => [ 30, 3156 ], __else__ => [ 30, 3156 ], a => 3158, b => 3159, c => 3160, d => 3161, e => 3162, h => 3163, l => 3164, "~" => [ 30, 3156 ], },
	# [3156] opcode : out "(" c ")" "," "[inline_const]"
	{ 0 => 3157, },
	# [3157] opcode : out "(" c ")" "," "[inline_const]" 0
	{ "\n" => [ 7, \&_action_opcode_790 ], ":" => [ 7, \&_action_opcode_790 ], },
	# [3158] opcode : out "(" c ")" "," a
	{ "\n" => [ 7, \&_action_opcode_791 ], ":" => [ 7, \&_action_opcode_791 ], },
	# [3159] opcode : out "(" c ")" "," b
	{ "\n" => [ 7, \&_action_opcode_792 ], ":" => [ 7, \&_action_opcode_792 ], },
	# [3160] opcode : out "(" c ")" "," c
	{ "\n" => [ 7, \&_action_opcode_793 ], ":" => [ 7, \&_action_opcode_793 ], },
	# [3161] opcode : out "(" c ")" "," d
	{ "\n" => [ 7, \&_action_opcode_794 ], ":" => [ 7, \&_action_opcode_794 ], },
	# [3162] opcode : out "(" c ")" "," e
	{ "\n" => [ 7, \&_action_opcode_795 ], ":" => [ 7, \&_action_opcode_795 ], },
	# [3163] opcode : out "(" c ")" "," h
	{ "\n" => [ 7, \&_action_opcode_796 ], ":" => [ 7, \&_action_opcode_796 ], },
	# [3164] opcode : out "(" c ")" "," l
	{ "\n" => [ 7, \&_action_opcode_797 ], ":" => [ 7, \&_action_opcode_797 ], },
	# [3165] opcode : out "["
	{ "!" => [ 13, 3166 ], "+" => [ 13, 3166 ], "-" => [ 13, 3166 ], __else__ => [ 13, 3166 ], c => 3170, "~" => [ 13, 3166 ], },
	# [3166] opcode : out "[" "[expr_N]"
	{ "]" => 3167, },
	# [3167] opcode : out "[" "[expr_N]" "]"
	{ "," => 3168, },
	# [3168] opcode : out "[" "[expr_N]" "]" ","
	{ a => 3169, },
	# [3169] opcode : out "[" "[expr_N]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_789 ], ":" => [ 7, \&_action_opcode_789 ], },
	# [3170] opcode : out "[" c
	{ "]" => 3171, },
	# [3171] opcode : out "[" c "]"
	{ "," => 3172, },
	# [3172] opcode : out "[" c "]" ","
	{ "!" => [ 30, 3173 ], "+" => [ 30, 3173 ], "-" => [ 30, 3173 ], __else__ => [ 30, 3173 ], a => 3175, b => 3176, c => 3177, d => 3178, e => 3179, h => 3180, l => 3181, "~" => [ 30, 3173 ], },
	# [3173] opcode : out "[" c "]" "," "[inline_const]"
	{ 0 => 3174, },
	# [3174] opcode : out "[" c "]" "," "[inline_const]" 0
	{ "\n" => [ 7, \&_action_opcode_790 ], ":" => [ 7, \&_action_opcode_790 ], },
	# [3175] opcode : out "[" c "]" "," a
	{ "\n" => [ 7, \&_action_opcode_791 ], ":" => [ 7, \&_action_opcode_791 ], },
	# [3176] opcode : out "[" c "]" "," b
	{ "\n" => [ 7, \&_action_opcode_792 ], ":" => [ 7, \&_action_opcode_792 ], },
	# [3177] opcode : out "[" c "]" "," c
	{ "\n" => [ 7, \&_action_opcode_793 ], ":" => [ 7, \&_action_opcode_793 ], },
	# [3178] opcode : out "[" c "]" "," d
	{ "\n" => [ 7, \&_action_opcode_794 ], ":" => [ 7, \&_action_opcode_794 ], },
	# [3179] opcode : out "[" c "]" "," e
	{ "\n" => [ 7, \&_action_opcode_795 ], ":" => [ 7, \&_action_opcode_795 ], },
	# [3180] opcode : out "[" c "]" "," h
	{ "\n" => [ 7, \&_action_opcode_796 ], ":" => [ 7, \&_action_opcode_796 ], },
	# [3181] opcode : out "[" c "]" "," l
	{ "\n" => [ 7, \&_action_opcode_797 ], ":" => [ 7, \&_action_opcode_797 ], },
	# [3182] opcode : outd
	{ "\n" => [ 7, \&_action_opcode_798 ], ":" => [ 7, \&_action_opcode_798 ], },
	# [3183] opcode : outi
	{ "\n" => [ 7, \&_action_opcode_799 ], ":" => [ 7, \&_action_opcode_799 ], },
	# [3184] opcode : pop
	{ af => 3185, bc => 3186, de => 3187, hl => 3188, ix => 3189, iy => 3190, },
	# [3185] opcode : pop af
	{ "\n" => [ 7, \&_action_opcode_800 ], ":" => [ 7, \&_action_opcode_800 ], },
	# [3186] opcode : pop bc
	{ "\n" => [ 7, \&_action_opcode_801 ], ":" => [ 7, \&_action_opcode_801 ], },
	# [3187] opcode : pop de
	{ "\n" => [ 7, \&_action_opcode_802 ], ":" => [ 7, \&_action_opcode_802 ], },
	# [3188] opcode : pop hl
	{ "\n" => [ 7, \&_action_opcode_803 ], ":" => [ 7, \&_action_opcode_803 ], },
	# [3189] opcode : pop ix
	{ "\n" => [ 7, \&_action_opcode_804 ], ":" => [ 7, \&_action_opcode_804 ], },
	# [3190] opcode : pop iy
	{ "\n" => [ 7, \&_action_opcode_805 ], ":" => [ 7, \&_action_opcode_805 ], },
	# [3191] opcode : push
	{ af => 3192, bc => 3193, de => 3194, hl => 3195, ix => 3196, iy => 3197, },
	# [3192] opcode : push af
	{ "\n" => [ 7, \&_action_opcode_806 ], ":" => [ 7, \&_action_opcode_806 ], },
	# [3193] opcode : push bc
	{ "\n" => [ 7, \&_action_opcode_807 ], ":" => [ 7, \&_action_opcode_807 ], },
	# [3194] opcode : push de
	{ "\n" => [ 7, \&_action_opcode_808 ], ":" => [ 7, \&_action_opcode_808 ], },
	# [3195] opcode : push hl
	{ "\n" => [ 7, \&_action_opcode_809 ], ":" => [ 7, \&_action_opcode_809 ], },
	# [3196] opcode : push ix
	{ "\n" => [ 7, \&_action_opcode_810 ], ":" => [ 7, \&_action_opcode_810 ], },
	# [3197] opcode : push iy
	{ "\n" => [ 7, \&_action_opcode_811 ], ":" => [ 7, \&_action_opcode_811 ], },
	# [3198] opcode : res
	{ "!" => [ 30, 3199 ], "+" => [ 30, 3199 ], "-" => [ 30, 3199 ], __else__ => [ 30, 3199 ], "~" => [ 30, 3199 ], },
	# [3199] opcode : res "[inline_const]"
	{ 0 => 3200, 1 => 3343, 2 => 3486, 3 => 3629, 4 => 3772, 5 => 3915, 6 => 4058, 7 => 4201, },
	# [3200] opcode : res "[inline_const]" 0
	{ "," => 3201, },
	# [3201] opcode : res "[inline_const]" 0 ","
	{ "(" => 3202, "[" => 3269, a => 3336, b => 3337, c => 3338, d => 3339, e => 3340, h => 3341, l => 3342, },
	# [3202] opcode : res "[inline_const]" 0 "," "("
	{ hl => 3203, ix => 3205, iy => 3237, },
	# [3203] opcode : res "[inline_const]" 0 "," "(" hl
	{ ")" => 3204, },
	# [3204] opcode : res "[inline_const]" 0 "," "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_812 ], ":" => [ 7, \&_action_opcode_812 ], },
	# [3205] opcode : res "[inline_const]" 0 "," "(" ix
	{ ")" => 3206, "+" => 3215, "-" => 3226, },
	# [3206] opcode : res "[inline_const]" 0 "," "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_813 ], "," => 3207, ":" => [ 7, \&_action_opcode_813 ], },
	# [3207] opcode : res "[inline_const]" 0 "," "(" ix ")" ","
	{ a => 3208, b => 3209, c => 3210, d => 3211, e => 3212, h => 3213, l => 3214, },
	# [3208] opcode : res "[inline_const]" 0 "," "(" ix ")" "," a
	{ "\n" => [ 7, \&_action_opcode_814 ], ":" => [ 7, \&_action_opcode_814 ], },
	# [3209] opcode : res "[inline_const]" 0 "," "(" ix ")" "," b
	{ "\n" => [ 7, \&_action_opcode_815 ], ":" => [ 7, \&_action_opcode_815 ], },
	# [3210] opcode : res "[inline_const]" 0 "," "(" ix ")" "," c
	{ "\n" => [ 7, \&_action_opcode_816 ], ":" => [ 7, \&_action_opcode_816 ], },
	# [3211] opcode : res "[inline_const]" 0 "," "(" ix ")" "," d
	{ "\n" => [ 7, \&_action_opcode_817 ], ":" => [ 7, \&_action_opcode_817 ], },
	# [3212] opcode : res "[inline_const]" 0 "," "(" ix ")" "," e
	{ "\n" => [ 7, \&_action_opcode_818 ], ":" => [ 7, \&_action_opcode_818 ], },
	# [3213] opcode : res "[inline_const]" 0 "," "(" ix ")" "," h
	{ "\n" => [ 7, \&_action_opcode_819 ], ":" => [ 7, \&_action_opcode_819 ], },
	# [3214] opcode : res "[inline_const]" 0 "," "(" ix ")" "," l
	{ "\n" => [ 7, \&_action_opcode_820 ], ":" => [ 7, \&_action_opcode_820 ], },
	# [3215] opcode : res "[inline_const]" 0 "," "(" ix "+"
	{ "!" => [ 12, 3216 ], "+" => [ 12, 3216 ], "-" => [ 12, 3216 ], __else__ => [ 12, 3216 ], "~" => [ 12, 3216 ], },
	# [3216] opcode : res "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]"
	{ ")" => 3217, },
	# [3217] opcode : res "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_821 ], "," => 3218, ":" => [ 7, \&_action_opcode_821 ], },
	# [3218] opcode : res "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" ","
	{ a => 3219, b => 3220, c => 3221, d => 3222, e => 3223, h => 3224, l => 3225, },
	# [3219] opcode : res "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_822 ], ":" => [ 7, \&_action_opcode_822 ], },
	# [3220] opcode : res "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_823 ], ":" => [ 7, \&_action_opcode_823 ], },
	# [3221] opcode : res "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_824 ], ":" => [ 7, \&_action_opcode_824 ], },
	# [3222] opcode : res "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_825 ], ":" => [ 7, \&_action_opcode_825 ], },
	# [3223] opcode : res "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_826 ], ":" => [ 7, \&_action_opcode_826 ], },
	# [3224] opcode : res "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_827 ], ":" => [ 7, \&_action_opcode_827 ], },
	# [3225] opcode : res "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_828 ], ":" => [ 7, \&_action_opcode_828 ], },
	# [3226] opcode : res "[inline_const]" 0 "," "(" ix "-"
	{ "!" => [ 14, 3227 ], "+" => [ 14, 3227 ], "-" => [ 14, 3227 ], __else__ => [ 14, 3227 ], "~" => [ 14, 3227 ], },
	# [3227] opcode : res "[inline_const]" 0 "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 3228, },
	# [3228] opcode : res "[inline_const]" 0 "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_821 ], "," => 3229, ":" => [ 7, \&_action_opcode_821 ], },
	# [3229] opcode : res "[inline_const]" 0 "," "(" ix "-" "[expr_NDIS]" ")" ","
	{ a => 3230, b => 3231, c => 3232, d => 3233, e => 3234, h => 3235, l => 3236, },
	# [3230] opcode : res "[inline_const]" 0 "," "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_822 ], ":" => [ 7, \&_action_opcode_822 ], },
	# [3231] opcode : res "[inline_const]" 0 "," "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_823 ], ":" => [ 7, \&_action_opcode_823 ], },
	# [3232] opcode : res "[inline_const]" 0 "," "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_824 ], ":" => [ 7, \&_action_opcode_824 ], },
	# [3233] opcode : res "[inline_const]" 0 "," "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_825 ], ":" => [ 7, \&_action_opcode_825 ], },
	# [3234] opcode : res "[inline_const]" 0 "," "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_826 ], ":" => [ 7, \&_action_opcode_826 ], },
	# [3235] opcode : res "[inline_const]" 0 "," "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_827 ], ":" => [ 7, \&_action_opcode_827 ], },
	# [3236] opcode : res "[inline_const]" 0 "," "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_828 ], ":" => [ 7, \&_action_opcode_828 ], },
	# [3237] opcode : res "[inline_const]" 0 "," "(" iy
	{ ")" => 3238, "+" => 3247, "-" => 3258, },
	# [3238] opcode : res "[inline_const]" 0 "," "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_829 ], "," => 3239, ":" => [ 7, \&_action_opcode_829 ], },
	# [3239] opcode : res "[inline_const]" 0 "," "(" iy ")" ","
	{ a => 3240, b => 3241, c => 3242, d => 3243, e => 3244, h => 3245, l => 3246, },
	# [3240] opcode : res "[inline_const]" 0 "," "(" iy ")" "," a
	{ "\n" => [ 7, \&_action_opcode_830 ], ":" => [ 7, \&_action_opcode_830 ], },
	# [3241] opcode : res "[inline_const]" 0 "," "(" iy ")" "," b
	{ "\n" => [ 7, \&_action_opcode_831 ], ":" => [ 7, \&_action_opcode_831 ], },
	# [3242] opcode : res "[inline_const]" 0 "," "(" iy ")" "," c
	{ "\n" => [ 7, \&_action_opcode_832 ], ":" => [ 7, \&_action_opcode_832 ], },
	# [3243] opcode : res "[inline_const]" 0 "," "(" iy ")" "," d
	{ "\n" => [ 7, \&_action_opcode_833 ], ":" => [ 7, \&_action_opcode_833 ], },
	# [3244] opcode : res "[inline_const]" 0 "," "(" iy ")" "," e
	{ "\n" => [ 7, \&_action_opcode_834 ], ":" => [ 7, \&_action_opcode_834 ], },
	# [3245] opcode : res "[inline_const]" 0 "," "(" iy ")" "," h
	{ "\n" => [ 7, \&_action_opcode_835 ], ":" => [ 7, \&_action_opcode_835 ], },
	# [3246] opcode : res "[inline_const]" 0 "," "(" iy ")" "," l
	{ "\n" => [ 7, \&_action_opcode_836 ], ":" => [ 7, \&_action_opcode_836 ], },
	# [3247] opcode : res "[inline_const]" 0 "," "(" iy "+"
	{ "!" => [ 12, 3248 ], "+" => [ 12, 3248 ], "-" => [ 12, 3248 ], __else__ => [ 12, 3248 ], "~" => [ 12, 3248 ], },
	# [3248] opcode : res "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]"
	{ ")" => 3249, },
	# [3249] opcode : res "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_837 ], "," => 3250, ":" => [ 7, \&_action_opcode_837 ], },
	# [3250] opcode : res "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" ","
	{ a => 3251, b => 3252, c => 3253, d => 3254, e => 3255, h => 3256, l => 3257, },
	# [3251] opcode : res "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_838 ], ":" => [ 7, \&_action_opcode_838 ], },
	# [3252] opcode : res "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_839 ], ":" => [ 7, \&_action_opcode_839 ], },
	# [3253] opcode : res "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_840 ], ":" => [ 7, \&_action_opcode_840 ], },
	# [3254] opcode : res "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_841 ], ":" => [ 7, \&_action_opcode_841 ], },
	# [3255] opcode : res "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_842 ], ":" => [ 7, \&_action_opcode_842 ], },
	# [3256] opcode : res "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_843 ], ":" => [ 7, \&_action_opcode_843 ], },
	# [3257] opcode : res "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_844 ], ":" => [ 7, \&_action_opcode_844 ], },
	# [3258] opcode : res "[inline_const]" 0 "," "(" iy "-"
	{ "!" => [ 14, 3259 ], "+" => [ 14, 3259 ], "-" => [ 14, 3259 ], __else__ => [ 14, 3259 ], "~" => [ 14, 3259 ], },
	# [3259] opcode : res "[inline_const]" 0 "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 3260, },
	# [3260] opcode : res "[inline_const]" 0 "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_837 ], "," => 3261, ":" => [ 7, \&_action_opcode_837 ], },
	# [3261] opcode : res "[inline_const]" 0 "," "(" iy "-" "[expr_NDIS]" ")" ","
	{ a => 3262, b => 3263, c => 3264, d => 3265, e => 3266, h => 3267, l => 3268, },
	# [3262] opcode : res "[inline_const]" 0 "," "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_838 ], ":" => [ 7, \&_action_opcode_838 ], },
	# [3263] opcode : res "[inline_const]" 0 "," "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_839 ], ":" => [ 7, \&_action_opcode_839 ], },
	# [3264] opcode : res "[inline_const]" 0 "," "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_840 ], ":" => [ 7, \&_action_opcode_840 ], },
	# [3265] opcode : res "[inline_const]" 0 "," "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_841 ], ":" => [ 7, \&_action_opcode_841 ], },
	# [3266] opcode : res "[inline_const]" 0 "," "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_842 ], ":" => [ 7, \&_action_opcode_842 ], },
	# [3267] opcode : res "[inline_const]" 0 "," "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_843 ], ":" => [ 7, \&_action_opcode_843 ], },
	# [3268] opcode : res "[inline_const]" 0 "," "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_844 ], ":" => [ 7, \&_action_opcode_844 ], },
	# [3269] opcode : res "[inline_const]" 0 "," "["
	{ hl => 3270, ix => 3272, iy => 3304, },
	# [3270] opcode : res "[inline_const]" 0 "," "[" hl
	{ "]" => 3271, },
	# [3271] opcode : res "[inline_const]" 0 "," "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_812 ], ":" => [ 7, \&_action_opcode_812 ], },
	# [3272] opcode : res "[inline_const]" 0 "," "[" ix
	{ "+" => 3273, "-" => 3284, "]" => 3295, },
	# [3273] opcode : res "[inline_const]" 0 "," "[" ix "+"
	{ "!" => [ 12, 3274 ], "+" => [ 12, 3274 ], "-" => [ 12, 3274 ], __else__ => [ 12, 3274 ], "~" => [ 12, 3274 ], },
	# [3274] opcode : res "[inline_const]" 0 "," "[" ix "+" "[expr_DIS]"
	{ "]" => 3275, },
	# [3275] opcode : res "[inline_const]" 0 "," "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_821 ], "," => 3276, ":" => [ 7, \&_action_opcode_821 ], },
	# [3276] opcode : res "[inline_const]" 0 "," "[" ix "+" "[expr_DIS]" "]" ","
	{ a => 3277, b => 3278, c => 3279, d => 3280, e => 3281, h => 3282, l => 3283, },
	# [3277] opcode : res "[inline_const]" 0 "," "[" ix "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_822 ], ":" => [ 7, \&_action_opcode_822 ], },
	# [3278] opcode : res "[inline_const]" 0 "," "[" ix "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_823 ], ":" => [ 7, \&_action_opcode_823 ], },
	# [3279] opcode : res "[inline_const]" 0 "," "[" ix "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_824 ], ":" => [ 7, \&_action_opcode_824 ], },
	# [3280] opcode : res "[inline_const]" 0 "," "[" ix "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_825 ], ":" => [ 7, \&_action_opcode_825 ], },
	# [3281] opcode : res "[inline_const]" 0 "," "[" ix "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_826 ], ":" => [ 7, \&_action_opcode_826 ], },
	# [3282] opcode : res "[inline_const]" 0 "," "[" ix "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_827 ], ":" => [ 7, \&_action_opcode_827 ], },
	# [3283] opcode : res "[inline_const]" 0 "," "[" ix "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_828 ], ":" => [ 7, \&_action_opcode_828 ], },
	# [3284] opcode : res "[inline_const]" 0 "," "[" ix "-"
	{ "!" => [ 14, 3285 ], "+" => [ 14, 3285 ], "-" => [ 14, 3285 ], __else__ => [ 14, 3285 ], "~" => [ 14, 3285 ], },
	# [3285] opcode : res "[inline_const]" 0 "," "[" ix "-" "[expr_NDIS]"
	{ "]" => 3286, },
	# [3286] opcode : res "[inline_const]" 0 "," "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_821 ], "," => 3287, ":" => [ 7, \&_action_opcode_821 ], },
	# [3287] opcode : res "[inline_const]" 0 "," "[" ix "-" "[expr_NDIS]" "]" ","
	{ a => 3288, b => 3289, c => 3290, d => 3291, e => 3292, h => 3293, l => 3294, },
	# [3288] opcode : res "[inline_const]" 0 "," "[" ix "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_822 ], ":" => [ 7, \&_action_opcode_822 ], },
	# [3289] opcode : res "[inline_const]" 0 "," "[" ix "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_823 ], ":" => [ 7, \&_action_opcode_823 ], },
	# [3290] opcode : res "[inline_const]" 0 "," "[" ix "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_824 ], ":" => [ 7, \&_action_opcode_824 ], },
	# [3291] opcode : res "[inline_const]" 0 "," "[" ix "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_825 ], ":" => [ 7, \&_action_opcode_825 ], },
	# [3292] opcode : res "[inline_const]" 0 "," "[" ix "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_826 ], ":" => [ 7, \&_action_opcode_826 ], },
	# [3293] opcode : res "[inline_const]" 0 "," "[" ix "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_827 ], ":" => [ 7, \&_action_opcode_827 ], },
	# [3294] opcode : res "[inline_const]" 0 "," "[" ix "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_828 ], ":" => [ 7, \&_action_opcode_828 ], },
	# [3295] opcode : res "[inline_const]" 0 "," "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_813 ], "," => 3296, ":" => [ 7, \&_action_opcode_813 ], },
	# [3296] opcode : res "[inline_const]" 0 "," "[" ix "]" ","
	{ a => 3297, b => 3298, c => 3299, d => 3300, e => 3301, h => 3302, l => 3303, },
	# [3297] opcode : res "[inline_const]" 0 "," "[" ix "]" "," a
	{ "\n" => [ 7, \&_action_opcode_814 ], ":" => [ 7, \&_action_opcode_814 ], },
	# [3298] opcode : res "[inline_const]" 0 "," "[" ix "]" "," b
	{ "\n" => [ 7, \&_action_opcode_815 ], ":" => [ 7, \&_action_opcode_815 ], },
	# [3299] opcode : res "[inline_const]" 0 "," "[" ix "]" "," c
	{ "\n" => [ 7, \&_action_opcode_816 ], ":" => [ 7, \&_action_opcode_816 ], },
	# [3300] opcode : res "[inline_const]" 0 "," "[" ix "]" "," d
	{ "\n" => [ 7, \&_action_opcode_817 ], ":" => [ 7, \&_action_opcode_817 ], },
	# [3301] opcode : res "[inline_const]" 0 "," "[" ix "]" "," e
	{ "\n" => [ 7, \&_action_opcode_818 ], ":" => [ 7, \&_action_opcode_818 ], },
	# [3302] opcode : res "[inline_const]" 0 "," "[" ix "]" "," h
	{ "\n" => [ 7, \&_action_opcode_819 ], ":" => [ 7, \&_action_opcode_819 ], },
	# [3303] opcode : res "[inline_const]" 0 "," "[" ix "]" "," l
	{ "\n" => [ 7, \&_action_opcode_820 ], ":" => [ 7, \&_action_opcode_820 ], },
	# [3304] opcode : res "[inline_const]" 0 "," "[" iy
	{ "+" => 3305, "-" => 3316, "]" => 3327, },
	# [3305] opcode : res "[inline_const]" 0 "," "[" iy "+"
	{ "!" => [ 12, 3306 ], "+" => [ 12, 3306 ], "-" => [ 12, 3306 ], __else__ => [ 12, 3306 ], "~" => [ 12, 3306 ], },
	# [3306] opcode : res "[inline_const]" 0 "," "[" iy "+" "[expr_DIS]"
	{ "]" => 3307, },
	# [3307] opcode : res "[inline_const]" 0 "," "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_837 ], "," => 3308, ":" => [ 7, \&_action_opcode_837 ], },
	# [3308] opcode : res "[inline_const]" 0 "," "[" iy "+" "[expr_DIS]" "]" ","
	{ a => 3309, b => 3310, c => 3311, d => 3312, e => 3313, h => 3314, l => 3315, },
	# [3309] opcode : res "[inline_const]" 0 "," "[" iy "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_838 ], ":" => [ 7, \&_action_opcode_838 ], },
	# [3310] opcode : res "[inline_const]" 0 "," "[" iy "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_839 ], ":" => [ 7, \&_action_opcode_839 ], },
	# [3311] opcode : res "[inline_const]" 0 "," "[" iy "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_840 ], ":" => [ 7, \&_action_opcode_840 ], },
	# [3312] opcode : res "[inline_const]" 0 "," "[" iy "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_841 ], ":" => [ 7, \&_action_opcode_841 ], },
	# [3313] opcode : res "[inline_const]" 0 "," "[" iy "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_842 ], ":" => [ 7, \&_action_opcode_842 ], },
	# [3314] opcode : res "[inline_const]" 0 "," "[" iy "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_843 ], ":" => [ 7, \&_action_opcode_843 ], },
	# [3315] opcode : res "[inline_const]" 0 "," "[" iy "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_844 ], ":" => [ 7, \&_action_opcode_844 ], },
	# [3316] opcode : res "[inline_const]" 0 "," "[" iy "-"
	{ "!" => [ 14, 3317 ], "+" => [ 14, 3317 ], "-" => [ 14, 3317 ], __else__ => [ 14, 3317 ], "~" => [ 14, 3317 ], },
	# [3317] opcode : res "[inline_const]" 0 "," "[" iy "-" "[expr_NDIS]"
	{ "]" => 3318, },
	# [3318] opcode : res "[inline_const]" 0 "," "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_837 ], "," => 3319, ":" => [ 7, \&_action_opcode_837 ], },
	# [3319] opcode : res "[inline_const]" 0 "," "[" iy "-" "[expr_NDIS]" "]" ","
	{ a => 3320, b => 3321, c => 3322, d => 3323, e => 3324, h => 3325, l => 3326, },
	# [3320] opcode : res "[inline_const]" 0 "," "[" iy "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_838 ], ":" => [ 7, \&_action_opcode_838 ], },
	# [3321] opcode : res "[inline_const]" 0 "," "[" iy "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_839 ], ":" => [ 7, \&_action_opcode_839 ], },
	# [3322] opcode : res "[inline_const]" 0 "," "[" iy "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_840 ], ":" => [ 7, \&_action_opcode_840 ], },
	# [3323] opcode : res "[inline_const]" 0 "," "[" iy "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_841 ], ":" => [ 7, \&_action_opcode_841 ], },
	# [3324] opcode : res "[inline_const]" 0 "," "[" iy "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_842 ], ":" => [ 7, \&_action_opcode_842 ], },
	# [3325] opcode : res "[inline_const]" 0 "," "[" iy "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_843 ], ":" => [ 7, \&_action_opcode_843 ], },
	# [3326] opcode : res "[inline_const]" 0 "," "[" iy "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_844 ], ":" => [ 7, \&_action_opcode_844 ], },
	# [3327] opcode : res "[inline_const]" 0 "," "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_829 ], "," => 3328, ":" => [ 7, \&_action_opcode_829 ], },
	# [3328] opcode : res "[inline_const]" 0 "," "[" iy "]" ","
	{ a => 3329, b => 3330, c => 3331, d => 3332, e => 3333, h => 3334, l => 3335, },
	# [3329] opcode : res "[inline_const]" 0 "," "[" iy "]" "," a
	{ "\n" => [ 7, \&_action_opcode_830 ], ":" => [ 7, \&_action_opcode_830 ], },
	# [3330] opcode : res "[inline_const]" 0 "," "[" iy "]" "," b
	{ "\n" => [ 7, \&_action_opcode_831 ], ":" => [ 7, \&_action_opcode_831 ], },
	# [3331] opcode : res "[inline_const]" 0 "," "[" iy "]" "," c
	{ "\n" => [ 7, \&_action_opcode_832 ], ":" => [ 7, \&_action_opcode_832 ], },
	# [3332] opcode : res "[inline_const]" 0 "," "[" iy "]" "," d
	{ "\n" => [ 7, \&_action_opcode_833 ], ":" => [ 7, \&_action_opcode_833 ], },
	# [3333] opcode : res "[inline_const]" 0 "," "[" iy "]" "," e
	{ "\n" => [ 7, \&_action_opcode_834 ], ":" => [ 7, \&_action_opcode_834 ], },
	# [3334] opcode : res "[inline_const]" 0 "," "[" iy "]" "," h
	{ "\n" => [ 7, \&_action_opcode_835 ], ":" => [ 7, \&_action_opcode_835 ], },
	# [3335] opcode : res "[inline_const]" 0 "," "[" iy "]" "," l
	{ "\n" => [ 7, \&_action_opcode_836 ], ":" => [ 7, \&_action_opcode_836 ], },
	# [3336] opcode : res "[inline_const]" 0 "," a
	{ "\n" => [ 7, \&_action_opcode_845 ], ":" => [ 7, \&_action_opcode_845 ], },
	# [3337] opcode : res "[inline_const]" 0 "," b
	{ "\n" => [ 7, \&_action_opcode_846 ], ":" => [ 7, \&_action_opcode_846 ], },
	# [3338] opcode : res "[inline_const]" 0 "," c
	{ "\n" => [ 7, \&_action_opcode_847 ], ":" => [ 7, \&_action_opcode_847 ], },
	# [3339] opcode : res "[inline_const]" 0 "," d
	{ "\n" => [ 7, \&_action_opcode_848 ], ":" => [ 7, \&_action_opcode_848 ], },
	# [3340] opcode : res "[inline_const]" 0 "," e
	{ "\n" => [ 7, \&_action_opcode_849 ], ":" => [ 7, \&_action_opcode_849 ], },
	# [3341] opcode : res "[inline_const]" 0 "," h
	{ "\n" => [ 7, \&_action_opcode_850 ], ":" => [ 7, \&_action_opcode_850 ], },
	# [3342] opcode : res "[inline_const]" 0 "," l
	{ "\n" => [ 7, \&_action_opcode_851 ], ":" => [ 7, \&_action_opcode_851 ], },
	# [3343] opcode : res "[inline_const]" 1
	{ "," => 3344, },
	# [3344] opcode : res "[inline_const]" 1 ","
	{ "(" => 3345, "[" => 3412, a => 3479, b => 3480, c => 3481, d => 3482, e => 3483, h => 3484, l => 3485, },
	# [3345] opcode : res "[inline_const]" 1 "," "("
	{ hl => 3346, ix => 3348, iy => 3380, },
	# [3346] opcode : res "[inline_const]" 1 "," "(" hl
	{ ")" => 3347, },
	# [3347] opcode : res "[inline_const]" 1 "," "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_852 ], ":" => [ 7, \&_action_opcode_852 ], },
	# [3348] opcode : res "[inline_const]" 1 "," "(" ix
	{ ")" => 3349, "+" => 3358, "-" => 3369, },
	# [3349] opcode : res "[inline_const]" 1 "," "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_853 ], "," => 3350, ":" => [ 7, \&_action_opcode_853 ], },
	# [3350] opcode : res "[inline_const]" 1 "," "(" ix ")" ","
	{ a => 3351, b => 3352, c => 3353, d => 3354, e => 3355, h => 3356, l => 3357, },
	# [3351] opcode : res "[inline_const]" 1 "," "(" ix ")" "," a
	{ "\n" => [ 7, \&_action_opcode_854 ], ":" => [ 7, \&_action_opcode_854 ], },
	# [3352] opcode : res "[inline_const]" 1 "," "(" ix ")" "," b
	{ "\n" => [ 7, \&_action_opcode_855 ], ":" => [ 7, \&_action_opcode_855 ], },
	# [3353] opcode : res "[inline_const]" 1 "," "(" ix ")" "," c
	{ "\n" => [ 7, \&_action_opcode_856 ], ":" => [ 7, \&_action_opcode_856 ], },
	# [3354] opcode : res "[inline_const]" 1 "," "(" ix ")" "," d
	{ "\n" => [ 7, \&_action_opcode_857 ], ":" => [ 7, \&_action_opcode_857 ], },
	# [3355] opcode : res "[inline_const]" 1 "," "(" ix ")" "," e
	{ "\n" => [ 7, \&_action_opcode_858 ], ":" => [ 7, \&_action_opcode_858 ], },
	# [3356] opcode : res "[inline_const]" 1 "," "(" ix ")" "," h
	{ "\n" => [ 7, \&_action_opcode_859 ], ":" => [ 7, \&_action_opcode_859 ], },
	# [3357] opcode : res "[inline_const]" 1 "," "(" ix ")" "," l
	{ "\n" => [ 7, \&_action_opcode_860 ], ":" => [ 7, \&_action_opcode_860 ], },
	# [3358] opcode : res "[inline_const]" 1 "," "(" ix "+"
	{ "!" => [ 12, 3359 ], "+" => [ 12, 3359 ], "-" => [ 12, 3359 ], __else__ => [ 12, 3359 ], "~" => [ 12, 3359 ], },
	# [3359] opcode : res "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]"
	{ ")" => 3360, },
	# [3360] opcode : res "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_861 ], "," => 3361, ":" => [ 7, \&_action_opcode_861 ], },
	# [3361] opcode : res "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" ","
	{ a => 3362, b => 3363, c => 3364, d => 3365, e => 3366, h => 3367, l => 3368, },
	# [3362] opcode : res "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_862 ], ":" => [ 7, \&_action_opcode_862 ], },
	# [3363] opcode : res "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_863 ], ":" => [ 7, \&_action_opcode_863 ], },
	# [3364] opcode : res "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_864 ], ":" => [ 7, \&_action_opcode_864 ], },
	# [3365] opcode : res "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_865 ], ":" => [ 7, \&_action_opcode_865 ], },
	# [3366] opcode : res "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_866 ], ":" => [ 7, \&_action_opcode_866 ], },
	# [3367] opcode : res "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_867 ], ":" => [ 7, \&_action_opcode_867 ], },
	# [3368] opcode : res "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_868 ], ":" => [ 7, \&_action_opcode_868 ], },
	# [3369] opcode : res "[inline_const]" 1 "," "(" ix "-"
	{ "!" => [ 14, 3370 ], "+" => [ 14, 3370 ], "-" => [ 14, 3370 ], __else__ => [ 14, 3370 ], "~" => [ 14, 3370 ], },
	# [3370] opcode : res "[inline_const]" 1 "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 3371, },
	# [3371] opcode : res "[inline_const]" 1 "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_861 ], "," => 3372, ":" => [ 7, \&_action_opcode_861 ], },
	# [3372] opcode : res "[inline_const]" 1 "," "(" ix "-" "[expr_NDIS]" ")" ","
	{ a => 3373, b => 3374, c => 3375, d => 3376, e => 3377, h => 3378, l => 3379, },
	# [3373] opcode : res "[inline_const]" 1 "," "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_862 ], ":" => [ 7, \&_action_opcode_862 ], },
	# [3374] opcode : res "[inline_const]" 1 "," "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_863 ], ":" => [ 7, \&_action_opcode_863 ], },
	# [3375] opcode : res "[inline_const]" 1 "," "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_864 ], ":" => [ 7, \&_action_opcode_864 ], },
	# [3376] opcode : res "[inline_const]" 1 "," "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_865 ], ":" => [ 7, \&_action_opcode_865 ], },
	# [3377] opcode : res "[inline_const]" 1 "," "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_866 ], ":" => [ 7, \&_action_opcode_866 ], },
	# [3378] opcode : res "[inline_const]" 1 "," "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_867 ], ":" => [ 7, \&_action_opcode_867 ], },
	# [3379] opcode : res "[inline_const]" 1 "," "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_868 ], ":" => [ 7, \&_action_opcode_868 ], },
	# [3380] opcode : res "[inline_const]" 1 "," "(" iy
	{ ")" => 3381, "+" => 3390, "-" => 3401, },
	# [3381] opcode : res "[inline_const]" 1 "," "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_869 ], "," => 3382, ":" => [ 7, \&_action_opcode_869 ], },
	# [3382] opcode : res "[inline_const]" 1 "," "(" iy ")" ","
	{ a => 3383, b => 3384, c => 3385, d => 3386, e => 3387, h => 3388, l => 3389, },
	# [3383] opcode : res "[inline_const]" 1 "," "(" iy ")" "," a
	{ "\n" => [ 7, \&_action_opcode_870 ], ":" => [ 7, \&_action_opcode_870 ], },
	# [3384] opcode : res "[inline_const]" 1 "," "(" iy ")" "," b
	{ "\n" => [ 7, \&_action_opcode_871 ], ":" => [ 7, \&_action_opcode_871 ], },
	# [3385] opcode : res "[inline_const]" 1 "," "(" iy ")" "," c
	{ "\n" => [ 7, \&_action_opcode_872 ], ":" => [ 7, \&_action_opcode_872 ], },
	# [3386] opcode : res "[inline_const]" 1 "," "(" iy ")" "," d
	{ "\n" => [ 7, \&_action_opcode_873 ], ":" => [ 7, \&_action_opcode_873 ], },
	# [3387] opcode : res "[inline_const]" 1 "," "(" iy ")" "," e
	{ "\n" => [ 7, \&_action_opcode_874 ], ":" => [ 7, \&_action_opcode_874 ], },
	# [3388] opcode : res "[inline_const]" 1 "," "(" iy ")" "," h
	{ "\n" => [ 7, \&_action_opcode_875 ], ":" => [ 7, \&_action_opcode_875 ], },
	# [3389] opcode : res "[inline_const]" 1 "," "(" iy ")" "," l
	{ "\n" => [ 7, \&_action_opcode_876 ], ":" => [ 7, \&_action_opcode_876 ], },
	# [3390] opcode : res "[inline_const]" 1 "," "(" iy "+"
	{ "!" => [ 12, 3391 ], "+" => [ 12, 3391 ], "-" => [ 12, 3391 ], __else__ => [ 12, 3391 ], "~" => [ 12, 3391 ], },
	# [3391] opcode : res "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]"
	{ ")" => 3392, },
	# [3392] opcode : res "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_877 ], "," => 3393, ":" => [ 7, \&_action_opcode_877 ], },
	# [3393] opcode : res "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" ","
	{ a => 3394, b => 3395, c => 3396, d => 3397, e => 3398, h => 3399, l => 3400, },
	# [3394] opcode : res "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_878 ], ":" => [ 7, \&_action_opcode_878 ], },
	# [3395] opcode : res "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_879 ], ":" => [ 7, \&_action_opcode_879 ], },
	# [3396] opcode : res "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_880 ], ":" => [ 7, \&_action_opcode_880 ], },
	# [3397] opcode : res "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_881 ], ":" => [ 7, \&_action_opcode_881 ], },
	# [3398] opcode : res "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_882 ], ":" => [ 7, \&_action_opcode_882 ], },
	# [3399] opcode : res "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_883 ], ":" => [ 7, \&_action_opcode_883 ], },
	# [3400] opcode : res "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_884 ], ":" => [ 7, \&_action_opcode_884 ], },
	# [3401] opcode : res "[inline_const]" 1 "," "(" iy "-"
	{ "!" => [ 14, 3402 ], "+" => [ 14, 3402 ], "-" => [ 14, 3402 ], __else__ => [ 14, 3402 ], "~" => [ 14, 3402 ], },
	# [3402] opcode : res "[inline_const]" 1 "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 3403, },
	# [3403] opcode : res "[inline_const]" 1 "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_877 ], "," => 3404, ":" => [ 7, \&_action_opcode_877 ], },
	# [3404] opcode : res "[inline_const]" 1 "," "(" iy "-" "[expr_NDIS]" ")" ","
	{ a => 3405, b => 3406, c => 3407, d => 3408, e => 3409, h => 3410, l => 3411, },
	# [3405] opcode : res "[inline_const]" 1 "," "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_878 ], ":" => [ 7, \&_action_opcode_878 ], },
	# [3406] opcode : res "[inline_const]" 1 "," "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_879 ], ":" => [ 7, \&_action_opcode_879 ], },
	# [3407] opcode : res "[inline_const]" 1 "," "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_880 ], ":" => [ 7, \&_action_opcode_880 ], },
	# [3408] opcode : res "[inline_const]" 1 "," "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_881 ], ":" => [ 7, \&_action_opcode_881 ], },
	# [3409] opcode : res "[inline_const]" 1 "," "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_882 ], ":" => [ 7, \&_action_opcode_882 ], },
	# [3410] opcode : res "[inline_const]" 1 "," "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_883 ], ":" => [ 7, \&_action_opcode_883 ], },
	# [3411] opcode : res "[inline_const]" 1 "," "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_884 ], ":" => [ 7, \&_action_opcode_884 ], },
	# [3412] opcode : res "[inline_const]" 1 "," "["
	{ hl => 3413, ix => 3415, iy => 3447, },
	# [3413] opcode : res "[inline_const]" 1 "," "[" hl
	{ "]" => 3414, },
	# [3414] opcode : res "[inline_const]" 1 "," "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_852 ], ":" => [ 7, \&_action_opcode_852 ], },
	# [3415] opcode : res "[inline_const]" 1 "," "[" ix
	{ "+" => 3416, "-" => 3427, "]" => 3438, },
	# [3416] opcode : res "[inline_const]" 1 "," "[" ix "+"
	{ "!" => [ 12, 3417 ], "+" => [ 12, 3417 ], "-" => [ 12, 3417 ], __else__ => [ 12, 3417 ], "~" => [ 12, 3417 ], },
	# [3417] opcode : res "[inline_const]" 1 "," "[" ix "+" "[expr_DIS]"
	{ "]" => 3418, },
	# [3418] opcode : res "[inline_const]" 1 "," "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_861 ], "," => 3419, ":" => [ 7, \&_action_opcode_861 ], },
	# [3419] opcode : res "[inline_const]" 1 "," "[" ix "+" "[expr_DIS]" "]" ","
	{ a => 3420, b => 3421, c => 3422, d => 3423, e => 3424, h => 3425, l => 3426, },
	# [3420] opcode : res "[inline_const]" 1 "," "[" ix "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_862 ], ":" => [ 7, \&_action_opcode_862 ], },
	# [3421] opcode : res "[inline_const]" 1 "," "[" ix "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_863 ], ":" => [ 7, \&_action_opcode_863 ], },
	# [3422] opcode : res "[inline_const]" 1 "," "[" ix "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_864 ], ":" => [ 7, \&_action_opcode_864 ], },
	# [3423] opcode : res "[inline_const]" 1 "," "[" ix "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_865 ], ":" => [ 7, \&_action_opcode_865 ], },
	# [3424] opcode : res "[inline_const]" 1 "," "[" ix "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_866 ], ":" => [ 7, \&_action_opcode_866 ], },
	# [3425] opcode : res "[inline_const]" 1 "," "[" ix "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_867 ], ":" => [ 7, \&_action_opcode_867 ], },
	# [3426] opcode : res "[inline_const]" 1 "," "[" ix "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_868 ], ":" => [ 7, \&_action_opcode_868 ], },
	# [3427] opcode : res "[inline_const]" 1 "," "[" ix "-"
	{ "!" => [ 14, 3428 ], "+" => [ 14, 3428 ], "-" => [ 14, 3428 ], __else__ => [ 14, 3428 ], "~" => [ 14, 3428 ], },
	# [3428] opcode : res "[inline_const]" 1 "," "[" ix "-" "[expr_NDIS]"
	{ "]" => 3429, },
	# [3429] opcode : res "[inline_const]" 1 "," "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_861 ], "," => 3430, ":" => [ 7, \&_action_opcode_861 ], },
	# [3430] opcode : res "[inline_const]" 1 "," "[" ix "-" "[expr_NDIS]" "]" ","
	{ a => 3431, b => 3432, c => 3433, d => 3434, e => 3435, h => 3436, l => 3437, },
	# [3431] opcode : res "[inline_const]" 1 "," "[" ix "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_862 ], ":" => [ 7, \&_action_opcode_862 ], },
	# [3432] opcode : res "[inline_const]" 1 "," "[" ix "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_863 ], ":" => [ 7, \&_action_opcode_863 ], },
	# [3433] opcode : res "[inline_const]" 1 "," "[" ix "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_864 ], ":" => [ 7, \&_action_opcode_864 ], },
	# [3434] opcode : res "[inline_const]" 1 "," "[" ix "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_865 ], ":" => [ 7, \&_action_opcode_865 ], },
	# [3435] opcode : res "[inline_const]" 1 "," "[" ix "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_866 ], ":" => [ 7, \&_action_opcode_866 ], },
	# [3436] opcode : res "[inline_const]" 1 "," "[" ix "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_867 ], ":" => [ 7, \&_action_opcode_867 ], },
	# [3437] opcode : res "[inline_const]" 1 "," "[" ix "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_868 ], ":" => [ 7, \&_action_opcode_868 ], },
	# [3438] opcode : res "[inline_const]" 1 "," "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_853 ], "," => 3439, ":" => [ 7, \&_action_opcode_853 ], },
	# [3439] opcode : res "[inline_const]" 1 "," "[" ix "]" ","
	{ a => 3440, b => 3441, c => 3442, d => 3443, e => 3444, h => 3445, l => 3446, },
	# [3440] opcode : res "[inline_const]" 1 "," "[" ix "]" "," a
	{ "\n" => [ 7, \&_action_opcode_854 ], ":" => [ 7, \&_action_opcode_854 ], },
	# [3441] opcode : res "[inline_const]" 1 "," "[" ix "]" "," b
	{ "\n" => [ 7, \&_action_opcode_855 ], ":" => [ 7, \&_action_opcode_855 ], },
	# [3442] opcode : res "[inline_const]" 1 "," "[" ix "]" "," c
	{ "\n" => [ 7, \&_action_opcode_856 ], ":" => [ 7, \&_action_opcode_856 ], },
	# [3443] opcode : res "[inline_const]" 1 "," "[" ix "]" "," d
	{ "\n" => [ 7, \&_action_opcode_857 ], ":" => [ 7, \&_action_opcode_857 ], },
	# [3444] opcode : res "[inline_const]" 1 "," "[" ix "]" "," e
	{ "\n" => [ 7, \&_action_opcode_858 ], ":" => [ 7, \&_action_opcode_858 ], },
	# [3445] opcode : res "[inline_const]" 1 "," "[" ix "]" "," h
	{ "\n" => [ 7, \&_action_opcode_859 ], ":" => [ 7, \&_action_opcode_859 ], },
	# [3446] opcode : res "[inline_const]" 1 "," "[" ix "]" "," l
	{ "\n" => [ 7, \&_action_opcode_860 ], ":" => [ 7, \&_action_opcode_860 ], },
	# [3447] opcode : res "[inline_const]" 1 "," "[" iy
	{ "+" => 3448, "-" => 3459, "]" => 3470, },
	# [3448] opcode : res "[inline_const]" 1 "," "[" iy "+"
	{ "!" => [ 12, 3449 ], "+" => [ 12, 3449 ], "-" => [ 12, 3449 ], __else__ => [ 12, 3449 ], "~" => [ 12, 3449 ], },
	# [3449] opcode : res "[inline_const]" 1 "," "[" iy "+" "[expr_DIS]"
	{ "]" => 3450, },
	# [3450] opcode : res "[inline_const]" 1 "," "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_877 ], "," => 3451, ":" => [ 7, \&_action_opcode_877 ], },
	# [3451] opcode : res "[inline_const]" 1 "," "[" iy "+" "[expr_DIS]" "]" ","
	{ a => 3452, b => 3453, c => 3454, d => 3455, e => 3456, h => 3457, l => 3458, },
	# [3452] opcode : res "[inline_const]" 1 "," "[" iy "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_878 ], ":" => [ 7, \&_action_opcode_878 ], },
	# [3453] opcode : res "[inline_const]" 1 "," "[" iy "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_879 ], ":" => [ 7, \&_action_opcode_879 ], },
	# [3454] opcode : res "[inline_const]" 1 "," "[" iy "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_880 ], ":" => [ 7, \&_action_opcode_880 ], },
	# [3455] opcode : res "[inline_const]" 1 "," "[" iy "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_881 ], ":" => [ 7, \&_action_opcode_881 ], },
	# [3456] opcode : res "[inline_const]" 1 "," "[" iy "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_882 ], ":" => [ 7, \&_action_opcode_882 ], },
	# [3457] opcode : res "[inline_const]" 1 "," "[" iy "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_883 ], ":" => [ 7, \&_action_opcode_883 ], },
	# [3458] opcode : res "[inline_const]" 1 "," "[" iy "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_884 ], ":" => [ 7, \&_action_opcode_884 ], },
	# [3459] opcode : res "[inline_const]" 1 "," "[" iy "-"
	{ "!" => [ 14, 3460 ], "+" => [ 14, 3460 ], "-" => [ 14, 3460 ], __else__ => [ 14, 3460 ], "~" => [ 14, 3460 ], },
	# [3460] opcode : res "[inline_const]" 1 "," "[" iy "-" "[expr_NDIS]"
	{ "]" => 3461, },
	# [3461] opcode : res "[inline_const]" 1 "," "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_877 ], "," => 3462, ":" => [ 7, \&_action_opcode_877 ], },
	# [3462] opcode : res "[inline_const]" 1 "," "[" iy "-" "[expr_NDIS]" "]" ","
	{ a => 3463, b => 3464, c => 3465, d => 3466, e => 3467, h => 3468, l => 3469, },
	# [3463] opcode : res "[inline_const]" 1 "," "[" iy "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_878 ], ":" => [ 7, \&_action_opcode_878 ], },
	# [3464] opcode : res "[inline_const]" 1 "," "[" iy "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_879 ], ":" => [ 7, \&_action_opcode_879 ], },
	# [3465] opcode : res "[inline_const]" 1 "," "[" iy "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_880 ], ":" => [ 7, \&_action_opcode_880 ], },
	# [3466] opcode : res "[inline_const]" 1 "," "[" iy "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_881 ], ":" => [ 7, \&_action_opcode_881 ], },
	# [3467] opcode : res "[inline_const]" 1 "," "[" iy "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_882 ], ":" => [ 7, \&_action_opcode_882 ], },
	# [3468] opcode : res "[inline_const]" 1 "," "[" iy "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_883 ], ":" => [ 7, \&_action_opcode_883 ], },
	# [3469] opcode : res "[inline_const]" 1 "," "[" iy "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_884 ], ":" => [ 7, \&_action_opcode_884 ], },
	# [3470] opcode : res "[inline_const]" 1 "," "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_869 ], "," => 3471, ":" => [ 7, \&_action_opcode_869 ], },
	# [3471] opcode : res "[inline_const]" 1 "," "[" iy "]" ","
	{ a => 3472, b => 3473, c => 3474, d => 3475, e => 3476, h => 3477, l => 3478, },
	# [3472] opcode : res "[inline_const]" 1 "," "[" iy "]" "," a
	{ "\n" => [ 7, \&_action_opcode_870 ], ":" => [ 7, \&_action_opcode_870 ], },
	# [3473] opcode : res "[inline_const]" 1 "," "[" iy "]" "," b
	{ "\n" => [ 7, \&_action_opcode_871 ], ":" => [ 7, \&_action_opcode_871 ], },
	# [3474] opcode : res "[inline_const]" 1 "," "[" iy "]" "," c
	{ "\n" => [ 7, \&_action_opcode_872 ], ":" => [ 7, \&_action_opcode_872 ], },
	# [3475] opcode : res "[inline_const]" 1 "," "[" iy "]" "," d
	{ "\n" => [ 7, \&_action_opcode_873 ], ":" => [ 7, \&_action_opcode_873 ], },
	# [3476] opcode : res "[inline_const]" 1 "," "[" iy "]" "," e
	{ "\n" => [ 7, \&_action_opcode_874 ], ":" => [ 7, \&_action_opcode_874 ], },
	# [3477] opcode : res "[inline_const]" 1 "," "[" iy "]" "," h
	{ "\n" => [ 7, \&_action_opcode_875 ], ":" => [ 7, \&_action_opcode_875 ], },
	# [3478] opcode : res "[inline_const]" 1 "," "[" iy "]" "," l
	{ "\n" => [ 7, \&_action_opcode_876 ], ":" => [ 7, \&_action_opcode_876 ], },
	# [3479] opcode : res "[inline_const]" 1 "," a
	{ "\n" => [ 7, \&_action_opcode_885 ], ":" => [ 7, \&_action_opcode_885 ], },
	# [3480] opcode : res "[inline_const]" 1 "," b
	{ "\n" => [ 7, \&_action_opcode_886 ], ":" => [ 7, \&_action_opcode_886 ], },
	# [3481] opcode : res "[inline_const]" 1 "," c
	{ "\n" => [ 7, \&_action_opcode_887 ], ":" => [ 7, \&_action_opcode_887 ], },
	# [3482] opcode : res "[inline_const]" 1 "," d
	{ "\n" => [ 7, \&_action_opcode_888 ], ":" => [ 7, \&_action_opcode_888 ], },
	# [3483] opcode : res "[inline_const]" 1 "," e
	{ "\n" => [ 7, \&_action_opcode_889 ], ":" => [ 7, \&_action_opcode_889 ], },
	# [3484] opcode : res "[inline_const]" 1 "," h
	{ "\n" => [ 7, \&_action_opcode_890 ], ":" => [ 7, \&_action_opcode_890 ], },
	# [3485] opcode : res "[inline_const]" 1 "," l
	{ "\n" => [ 7, \&_action_opcode_891 ], ":" => [ 7, \&_action_opcode_891 ], },
	# [3486] opcode : res "[inline_const]" 2
	{ "," => 3487, },
	# [3487] opcode : res "[inline_const]" 2 ","
	{ "(" => 3488, "[" => 3555, a => 3622, b => 3623, c => 3624, d => 3625, e => 3626, h => 3627, l => 3628, },
	# [3488] opcode : res "[inline_const]" 2 "," "("
	{ hl => 3489, ix => 3491, iy => 3523, },
	# [3489] opcode : res "[inline_const]" 2 "," "(" hl
	{ ")" => 3490, },
	# [3490] opcode : res "[inline_const]" 2 "," "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_892 ], ":" => [ 7, \&_action_opcode_892 ], },
	# [3491] opcode : res "[inline_const]" 2 "," "(" ix
	{ ")" => 3492, "+" => 3501, "-" => 3512, },
	# [3492] opcode : res "[inline_const]" 2 "," "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_893 ], "," => 3493, ":" => [ 7, \&_action_opcode_893 ], },
	# [3493] opcode : res "[inline_const]" 2 "," "(" ix ")" ","
	{ a => 3494, b => 3495, c => 3496, d => 3497, e => 3498, h => 3499, l => 3500, },
	# [3494] opcode : res "[inline_const]" 2 "," "(" ix ")" "," a
	{ "\n" => [ 7, \&_action_opcode_894 ], ":" => [ 7, \&_action_opcode_894 ], },
	# [3495] opcode : res "[inline_const]" 2 "," "(" ix ")" "," b
	{ "\n" => [ 7, \&_action_opcode_895 ], ":" => [ 7, \&_action_opcode_895 ], },
	# [3496] opcode : res "[inline_const]" 2 "," "(" ix ")" "," c
	{ "\n" => [ 7, \&_action_opcode_896 ], ":" => [ 7, \&_action_opcode_896 ], },
	# [3497] opcode : res "[inline_const]" 2 "," "(" ix ")" "," d
	{ "\n" => [ 7, \&_action_opcode_897 ], ":" => [ 7, \&_action_opcode_897 ], },
	# [3498] opcode : res "[inline_const]" 2 "," "(" ix ")" "," e
	{ "\n" => [ 7, \&_action_opcode_898 ], ":" => [ 7, \&_action_opcode_898 ], },
	# [3499] opcode : res "[inline_const]" 2 "," "(" ix ")" "," h
	{ "\n" => [ 7, \&_action_opcode_899 ], ":" => [ 7, \&_action_opcode_899 ], },
	# [3500] opcode : res "[inline_const]" 2 "," "(" ix ")" "," l
	{ "\n" => [ 7, \&_action_opcode_900 ], ":" => [ 7, \&_action_opcode_900 ], },
	# [3501] opcode : res "[inline_const]" 2 "," "(" ix "+"
	{ "!" => [ 12, 3502 ], "+" => [ 12, 3502 ], "-" => [ 12, 3502 ], __else__ => [ 12, 3502 ], "~" => [ 12, 3502 ], },
	# [3502] opcode : res "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]"
	{ ")" => 3503, },
	# [3503] opcode : res "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_901 ], "," => 3504, ":" => [ 7, \&_action_opcode_901 ], },
	# [3504] opcode : res "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" ","
	{ a => 3505, b => 3506, c => 3507, d => 3508, e => 3509, h => 3510, l => 3511, },
	# [3505] opcode : res "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_902 ], ":" => [ 7, \&_action_opcode_902 ], },
	# [3506] opcode : res "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_903 ], ":" => [ 7, \&_action_opcode_903 ], },
	# [3507] opcode : res "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_904 ], ":" => [ 7, \&_action_opcode_904 ], },
	# [3508] opcode : res "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_905 ], ":" => [ 7, \&_action_opcode_905 ], },
	# [3509] opcode : res "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_906 ], ":" => [ 7, \&_action_opcode_906 ], },
	# [3510] opcode : res "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_907 ], ":" => [ 7, \&_action_opcode_907 ], },
	# [3511] opcode : res "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_908 ], ":" => [ 7, \&_action_opcode_908 ], },
	# [3512] opcode : res "[inline_const]" 2 "," "(" ix "-"
	{ "!" => [ 14, 3513 ], "+" => [ 14, 3513 ], "-" => [ 14, 3513 ], __else__ => [ 14, 3513 ], "~" => [ 14, 3513 ], },
	# [3513] opcode : res "[inline_const]" 2 "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 3514, },
	# [3514] opcode : res "[inline_const]" 2 "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_901 ], "," => 3515, ":" => [ 7, \&_action_opcode_901 ], },
	# [3515] opcode : res "[inline_const]" 2 "," "(" ix "-" "[expr_NDIS]" ")" ","
	{ a => 3516, b => 3517, c => 3518, d => 3519, e => 3520, h => 3521, l => 3522, },
	# [3516] opcode : res "[inline_const]" 2 "," "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_902 ], ":" => [ 7, \&_action_opcode_902 ], },
	# [3517] opcode : res "[inline_const]" 2 "," "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_903 ], ":" => [ 7, \&_action_opcode_903 ], },
	# [3518] opcode : res "[inline_const]" 2 "," "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_904 ], ":" => [ 7, \&_action_opcode_904 ], },
	# [3519] opcode : res "[inline_const]" 2 "," "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_905 ], ":" => [ 7, \&_action_opcode_905 ], },
	# [3520] opcode : res "[inline_const]" 2 "," "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_906 ], ":" => [ 7, \&_action_opcode_906 ], },
	# [3521] opcode : res "[inline_const]" 2 "," "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_907 ], ":" => [ 7, \&_action_opcode_907 ], },
	# [3522] opcode : res "[inline_const]" 2 "," "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_908 ], ":" => [ 7, \&_action_opcode_908 ], },
	# [3523] opcode : res "[inline_const]" 2 "," "(" iy
	{ ")" => 3524, "+" => 3533, "-" => 3544, },
	# [3524] opcode : res "[inline_const]" 2 "," "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_909 ], "," => 3525, ":" => [ 7, \&_action_opcode_909 ], },
	# [3525] opcode : res "[inline_const]" 2 "," "(" iy ")" ","
	{ a => 3526, b => 3527, c => 3528, d => 3529, e => 3530, h => 3531, l => 3532, },
	# [3526] opcode : res "[inline_const]" 2 "," "(" iy ")" "," a
	{ "\n" => [ 7, \&_action_opcode_910 ], ":" => [ 7, \&_action_opcode_910 ], },
	# [3527] opcode : res "[inline_const]" 2 "," "(" iy ")" "," b
	{ "\n" => [ 7, \&_action_opcode_911 ], ":" => [ 7, \&_action_opcode_911 ], },
	# [3528] opcode : res "[inline_const]" 2 "," "(" iy ")" "," c
	{ "\n" => [ 7, \&_action_opcode_912 ], ":" => [ 7, \&_action_opcode_912 ], },
	# [3529] opcode : res "[inline_const]" 2 "," "(" iy ")" "," d
	{ "\n" => [ 7, \&_action_opcode_913 ], ":" => [ 7, \&_action_opcode_913 ], },
	# [3530] opcode : res "[inline_const]" 2 "," "(" iy ")" "," e
	{ "\n" => [ 7, \&_action_opcode_914 ], ":" => [ 7, \&_action_opcode_914 ], },
	# [3531] opcode : res "[inline_const]" 2 "," "(" iy ")" "," h
	{ "\n" => [ 7, \&_action_opcode_915 ], ":" => [ 7, \&_action_opcode_915 ], },
	# [3532] opcode : res "[inline_const]" 2 "," "(" iy ")" "," l
	{ "\n" => [ 7, \&_action_opcode_916 ], ":" => [ 7, \&_action_opcode_916 ], },
	# [3533] opcode : res "[inline_const]" 2 "," "(" iy "+"
	{ "!" => [ 12, 3534 ], "+" => [ 12, 3534 ], "-" => [ 12, 3534 ], __else__ => [ 12, 3534 ], "~" => [ 12, 3534 ], },
	# [3534] opcode : res "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]"
	{ ")" => 3535, },
	# [3535] opcode : res "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_917 ], "," => 3536, ":" => [ 7, \&_action_opcode_917 ], },
	# [3536] opcode : res "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" ","
	{ a => 3537, b => 3538, c => 3539, d => 3540, e => 3541, h => 3542, l => 3543, },
	# [3537] opcode : res "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_918 ], ":" => [ 7, \&_action_opcode_918 ], },
	# [3538] opcode : res "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_919 ], ":" => [ 7, \&_action_opcode_919 ], },
	# [3539] opcode : res "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_920 ], ":" => [ 7, \&_action_opcode_920 ], },
	# [3540] opcode : res "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_921 ], ":" => [ 7, \&_action_opcode_921 ], },
	# [3541] opcode : res "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_922 ], ":" => [ 7, \&_action_opcode_922 ], },
	# [3542] opcode : res "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_923 ], ":" => [ 7, \&_action_opcode_923 ], },
	# [3543] opcode : res "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_924 ], ":" => [ 7, \&_action_opcode_924 ], },
	# [3544] opcode : res "[inline_const]" 2 "," "(" iy "-"
	{ "!" => [ 14, 3545 ], "+" => [ 14, 3545 ], "-" => [ 14, 3545 ], __else__ => [ 14, 3545 ], "~" => [ 14, 3545 ], },
	# [3545] opcode : res "[inline_const]" 2 "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 3546, },
	# [3546] opcode : res "[inline_const]" 2 "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_917 ], "," => 3547, ":" => [ 7, \&_action_opcode_917 ], },
	# [3547] opcode : res "[inline_const]" 2 "," "(" iy "-" "[expr_NDIS]" ")" ","
	{ a => 3548, b => 3549, c => 3550, d => 3551, e => 3552, h => 3553, l => 3554, },
	# [3548] opcode : res "[inline_const]" 2 "," "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_918 ], ":" => [ 7, \&_action_opcode_918 ], },
	# [3549] opcode : res "[inline_const]" 2 "," "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_919 ], ":" => [ 7, \&_action_opcode_919 ], },
	# [3550] opcode : res "[inline_const]" 2 "," "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_920 ], ":" => [ 7, \&_action_opcode_920 ], },
	# [3551] opcode : res "[inline_const]" 2 "," "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_921 ], ":" => [ 7, \&_action_opcode_921 ], },
	# [3552] opcode : res "[inline_const]" 2 "," "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_922 ], ":" => [ 7, \&_action_opcode_922 ], },
	# [3553] opcode : res "[inline_const]" 2 "," "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_923 ], ":" => [ 7, \&_action_opcode_923 ], },
	# [3554] opcode : res "[inline_const]" 2 "," "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_924 ], ":" => [ 7, \&_action_opcode_924 ], },
	# [3555] opcode : res "[inline_const]" 2 "," "["
	{ hl => 3556, ix => 3558, iy => 3590, },
	# [3556] opcode : res "[inline_const]" 2 "," "[" hl
	{ "]" => 3557, },
	# [3557] opcode : res "[inline_const]" 2 "," "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_892 ], ":" => [ 7, \&_action_opcode_892 ], },
	# [3558] opcode : res "[inline_const]" 2 "," "[" ix
	{ "+" => 3559, "-" => 3570, "]" => 3581, },
	# [3559] opcode : res "[inline_const]" 2 "," "[" ix "+"
	{ "!" => [ 12, 3560 ], "+" => [ 12, 3560 ], "-" => [ 12, 3560 ], __else__ => [ 12, 3560 ], "~" => [ 12, 3560 ], },
	# [3560] opcode : res "[inline_const]" 2 "," "[" ix "+" "[expr_DIS]"
	{ "]" => 3561, },
	# [3561] opcode : res "[inline_const]" 2 "," "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_901 ], "," => 3562, ":" => [ 7, \&_action_opcode_901 ], },
	# [3562] opcode : res "[inline_const]" 2 "," "[" ix "+" "[expr_DIS]" "]" ","
	{ a => 3563, b => 3564, c => 3565, d => 3566, e => 3567, h => 3568, l => 3569, },
	# [3563] opcode : res "[inline_const]" 2 "," "[" ix "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_902 ], ":" => [ 7, \&_action_opcode_902 ], },
	# [3564] opcode : res "[inline_const]" 2 "," "[" ix "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_903 ], ":" => [ 7, \&_action_opcode_903 ], },
	# [3565] opcode : res "[inline_const]" 2 "," "[" ix "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_904 ], ":" => [ 7, \&_action_opcode_904 ], },
	# [3566] opcode : res "[inline_const]" 2 "," "[" ix "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_905 ], ":" => [ 7, \&_action_opcode_905 ], },
	# [3567] opcode : res "[inline_const]" 2 "," "[" ix "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_906 ], ":" => [ 7, \&_action_opcode_906 ], },
	# [3568] opcode : res "[inline_const]" 2 "," "[" ix "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_907 ], ":" => [ 7, \&_action_opcode_907 ], },
	# [3569] opcode : res "[inline_const]" 2 "," "[" ix "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_908 ], ":" => [ 7, \&_action_opcode_908 ], },
	# [3570] opcode : res "[inline_const]" 2 "," "[" ix "-"
	{ "!" => [ 14, 3571 ], "+" => [ 14, 3571 ], "-" => [ 14, 3571 ], __else__ => [ 14, 3571 ], "~" => [ 14, 3571 ], },
	# [3571] opcode : res "[inline_const]" 2 "," "[" ix "-" "[expr_NDIS]"
	{ "]" => 3572, },
	# [3572] opcode : res "[inline_const]" 2 "," "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_901 ], "," => 3573, ":" => [ 7, \&_action_opcode_901 ], },
	# [3573] opcode : res "[inline_const]" 2 "," "[" ix "-" "[expr_NDIS]" "]" ","
	{ a => 3574, b => 3575, c => 3576, d => 3577, e => 3578, h => 3579, l => 3580, },
	# [3574] opcode : res "[inline_const]" 2 "," "[" ix "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_902 ], ":" => [ 7, \&_action_opcode_902 ], },
	# [3575] opcode : res "[inline_const]" 2 "," "[" ix "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_903 ], ":" => [ 7, \&_action_opcode_903 ], },
	# [3576] opcode : res "[inline_const]" 2 "," "[" ix "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_904 ], ":" => [ 7, \&_action_opcode_904 ], },
	# [3577] opcode : res "[inline_const]" 2 "," "[" ix "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_905 ], ":" => [ 7, \&_action_opcode_905 ], },
	# [3578] opcode : res "[inline_const]" 2 "," "[" ix "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_906 ], ":" => [ 7, \&_action_opcode_906 ], },
	# [3579] opcode : res "[inline_const]" 2 "," "[" ix "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_907 ], ":" => [ 7, \&_action_opcode_907 ], },
	# [3580] opcode : res "[inline_const]" 2 "," "[" ix "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_908 ], ":" => [ 7, \&_action_opcode_908 ], },
	# [3581] opcode : res "[inline_const]" 2 "," "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_893 ], "," => 3582, ":" => [ 7, \&_action_opcode_893 ], },
	# [3582] opcode : res "[inline_const]" 2 "," "[" ix "]" ","
	{ a => 3583, b => 3584, c => 3585, d => 3586, e => 3587, h => 3588, l => 3589, },
	# [3583] opcode : res "[inline_const]" 2 "," "[" ix "]" "," a
	{ "\n" => [ 7, \&_action_opcode_894 ], ":" => [ 7, \&_action_opcode_894 ], },
	# [3584] opcode : res "[inline_const]" 2 "," "[" ix "]" "," b
	{ "\n" => [ 7, \&_action_opcode_895 ], ":" => [ 7, \&_action_opcode_895 ], },
	# [3585] opcode : res "[inline_const]" 2 "," "[" ix "]" "," c
	{ "\n" => [ 7, \&_action_opcode_896 ], ":" => [ 7, \&_action_opcode_896 ], },
	# [3586] opcode : res "[inline_const]" 2 "," "[" ix "]" "," d
	{ "\n" => [ 7, \&_action_opcode_897 ], ":" => [ 7, \&_action_opcode_897 ], },
	# [3587] opcode : res "[inline_const]" 2 "," "[" ix "]" "," e
	{ "\n" => [ 7, \&_action_opcode_898 ], ":" => [ 7, \&_action_opcode_898 ], },
	# [3588] opcode : res "[inline_const]" 2 "," "[" ix "]" "," h
	{ "\n" => [ 7, \&_action_opcode_899 ], ":" => [ 7, \&_action_opcode_899 ], },
	# [3589] opcode : res "[inline_const]" 2 "," "[" ix "]" "," l
	{ "\n" => [ 7, \&_action_opcode_900 ], ":" => [ 7, \&_action_opcode_900 ], },
	# [3590] opcode : res "[inline_const]" 2 "," "[" iy
	{ "+" => 3591, "-" => 3602, "]" => 3613, },
	# [3591] opcode : res "[inline_const]" 2 "," "[" iy "+"
	{ "!" => [ 12, 3592 ], "+" => [ 12, 3592 ], "-" => [ 12, 3592 ], __else__ => [ 12, 3592 ], "~" => [ 12, 3592 ], },
	# [3592] opcode : res "[inline_const]" 2 "," "[" iy "+" "[expr_DIS]"
	{ "]" => 3593, },
	# [3593] opcode : res "[inline_const]" 2 "," "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_917 ], "," => 3594, ":" => [ 7, \&_action_opcode_917 ], },
	# [3594] opcode : res "[inline_const]" 2 "," "[" iy "+" "[expr_DIS]" "]" ","
	{ a => 3595, b => 3596, c => 3597, d => 3598, e => 3599, h => 3600, l => 3601, },
	# [3595] opcode : res "[inline_const]" 2 "," "[" iy "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_918 ], ":" => [ 7, \&_action_opcode_918 ], },
	# [3596] opcode : res "[inline_const]" 2 "," "[" iy "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_919 ], ":" => [ 7, \&_action_opcode_919 ], },
	# [3597] opcode : res "[inline_const]" 2 "," "[" iy "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_920 ], ":" => [ 7, \&_action_opcode_920 ], },
	# [3598] opcode : res "[inline_const]" 2 "," "[" iy "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_921 ], ":" => [ 7, \&_action_opcode_921 ], },
	# [3599] opcode : res "[inline_const]" 2 "," "[" iy "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_922 ], ":" => [ 7, \&_action_opcode_922 ], },
	# [3600] opcode : res "[inline_const]" 2 "," "[" iy "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_923 ], ":" => [ 7, \&_action_opcode_923 ], },
	# [3601] opcode : res "[inline_const]" 2 "," "[" iy "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_924 ], ":" => [ 7, \&_action_opcode_924 ], },
	# [3602] opcode : res "[inline_const]" 2 "," "[" iy "-"
	{ "!" => [ 14, 3603 ], "+" => [ 14, 3603 ], "-" => [ 14, 3603 ], __else__ => [ 14, 3603 ], "~" => [ 14, 3603 ], },
	# [3603] opcode : res "[inline_const]" 2 "," "[" iy "-" "[expr_NDIS]"
	{ "]" => 3604, },
	# [3604] opcode : res "[inline_const]" 2 "," "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_917 ], "," => 3605, ":" => [ 7, \&_action_opcode_917 ], },
	# [3605] opcode : res "[inline_const]" 2 "," "[" iy "-" "[expr_NDIS]" "]" ","
	{ a => 3606, b => 3607, c => 3608, d => 3609, e => 3610, h => 3611, l => 3612, },
	# [3606] opcode : res "[inline_const]" 2 "," "[" iy "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_918 ], ":" => [ 7, \&_action_opcode_918 ], },
	# [3607] opcode : res "[inline_const]" 2 "," "[" iy "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_919 ], ":" => [ 7, \&_action_opcode_919 ], },
	# [3608] opcode : res "[inline_const]" 2 "," "[" iy "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_920 ], ":" => [ 7, \&_action_opcode_920 ], },
	# [3609] opcode : res "[inline_const]" 2 "," "[" iy "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_921 ], ":" => [ 7, \&_action_opcode_921 ], },
	# [3610] opcode : res "[inline_const]" 2 "," "[" iy "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_922 ], ":" => [ 7, \&_action_opcode_922 ], },
	# [3611] opcode : res "[inline_const]" 2 "," "[" iy "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_923 ], ":" => [ 7, \&_action_opcode_923 ], },
	# [3612] opcode : res "[inline_const]" 2 "," "[" iy "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_924 ], ":" => [ 7, \&_action_opcode_924 ], },
	# [3613] opcode : res "[inline_const]" 2 "," "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_909 ], "," => 3614, ":" => [ 7, \&_action_opcode_909 ], },
	# [3614] opcode : res "[inline_const]" 2 "," "[" iy "]" ","
	{ a => 3615, b => 3616, c => 3617, d => 3618, e => 3619, h => 3620, l => 3621, },
	# [3615] opcode : res "[inline_const]" 2 "," "[" iy "]" "," a
	{ "\n" => [ 7, \&_action_opcode_910 ], ":" => [ 7, \&_action_opcode_910 ], },
	# [3616] opcode : res "[inline_const]" 2 "," "[" iy "]" "," b
	{ "\n" => [ 7, \&_action_opcode_911 ], ":" => [ 7, \&_action_opcode_911 ], },
	# [3617] opcode : res "[inline_const]" 2 "," "[" iy "]" "," c
	{ "\n" => [ 7, \&_action_opcode_912 ], ":" => [ 7, \&_action_opcode_912 ], },
	# [3618] opcode : res "[inline_const]" 2 "," "[" iy "]" "," d
	{ "\n" => [ 7, \&_action_opcode_913 ], ":" => [ 7, \&_action_opcode_913 ], },
	# [3619] opcode : res "[inline_const]" 2 "," "[" iy "]" "," e
	{ "\n" => [ 7, \&_action_opcode_914 ], ":" => [ 7, \&_action_opcode_914 ], },
	# [3620] opcode : res "[inline_const]" 2 "," "[" iy "]" "," h
	{ "\n" => [ 7, \&_action_opcode_915 ], ":" => [ 7, \&_action_opcode_915 ], },
	# [3621] opcode : res "[inline_const]" 2 "," "[" iy "]" "," l
	{ "\n" => [ 7, \&_action_opcode_916 ], ":" => [ 7, \&_action_opcode_916 ], },
	# [3622] opcode : res "[inline_const]" 2 "," a
	{ "\n" => [ 7, \&_action_opcode_925 ], ":" => [ 7, \&_action_opcode_925 ], },
	# [3623] opcode : res "[inline_const]" 2 "," b
	{ "\n" => [ 7, \&_action_opcode_926 ], ":" => [ 7, \&_action_opcode_926 ], },
	# [3624] opcode : res "[inline_const]" 2 "," c
	{ "\n" => [ 7, \&_action_opcode_927 ], ":" => [ 7, \&_action_opcode_927 ], },
	# [3625] opcode : res "[inline_const]" 2 "," d
	{ "\n" => [ 7, \&_action_opcode_928 ], ":" => [ 7, \&_action_opcode_928 ], },
	# [3626] opcode : res "[inline_const]" 2 "," e
	{ "\n" => [ 7, \&_action_opcode_929 ], ":" => [ 7, \&_action_opcode_929 ], },
	# [3627] opcode : res "[inline_const]" 2 "," h
	{ "\n" => [ 7, \&_action_opcode_930 ], ":" => [ 7, \&_action_opcode_930 ], },
	# [3628] opcode : res "[inline_const]" 2 "," l
	{ "\n" => [ 7, \&_action_opcode_931 ], ":" => [ 7, \&_action_opcode_931 ], },
	# [3629] opcode : res "[inline_const]" 3
	{ "," => 3630, },
	# [3630] opcode : res "[inline_const]" 3 ","
	{ "(" => 3631, "[" => 3698, a => 3765, b => 3766, c => 3767, d => 3768, e => 3769, h => 3770, l => 3771, },
	# [3631] opcode : res "[inline_const]" 3 "," "("
	{ hl => 3632, ix => 3634, iy => 3666, },
	# [3632] opcode : res "[inline_const]" 3 "," "(" hl
	{ ")" => 3633, },
	# [3633] opcode : res "[inline_const]" 3 "," "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_932 ], ":" => [ 7, \&_action_opcode_932 ], },
	# [3634] opcode : res "[inline_const]" 3 "," "(" ix
	{ ")" => 3635, "+" => 3644, "-" => 3655, },
	# [3635] opcode : res "[inline_const]" 3 "," "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_933 ], "," => 3636, ":" => [ 7, \&_action_opcode_933 ], },
	# [3636] opcode : res "[inline_const]" 3 "," "(" ix ")" ","
	{ a => 3637, b => 3638, c => 3639, d => 3640, e => 3641, h => 3642, l => 3643, },
	# [3637] opcode : res "[inline_const]" 3 "," "(" ix ")" "," a
	{ "\n" => [ 7, \&_action_opcode_934 ], ":" => [ 7, \&_action_opcode_934 ], },
	# [3638] opcode : res "[inline_const]" 3 "," "(" ix ")" "," b
	{ "\n" => [ 7, \&_action_opcode_935 ], ":" => [ 7, \&_action_opcode_935 ], },
	# [3639] opcode : res "[inline_const]" 3 "," "(" ix ")" "," c
	{ "\n" => [ 7, \&_action_opcode_936 ], ":" => [ 7, \&_action_opcode_936 ], },
	# [3640] opcode : res "[inline_const]" 3 "," "(" ix ")" "," d
	{ "\n" => [ 7, \&_action_opcode_937 ], ":" => [ 7, \&_action_opcode_937 ], },
	# [3641] opcode : res "[inline_const]" 3 "," "(" ix ")" "," e
	{ "\n" => [ 7, \&_action_opcode_938 ], ":" => [ 7, \&_action_opcode_938 ], },
	# [3642] opcode : res "[inline_const]" 3 "," "(" ix ")" "," h
	{ "\n" => [ 7, \&_action_opcode_939 ], ":" => [ 7, \&_action_opcode_939 ], },
	# [3643] opcode : res "[inline_const]" 3 "," "(" ix ")" "," l
	{ "\n" => [ 7, \&_action_opcode_940 ], ":" => [ 7, \&_action_opcode_940 ], },
	# [3644] opcode : res "[inline_const]" 3 "," "(" ix "+"
	{ "!" => [ 12, 3645 ], "+" => [ 12, 3645 ], "-" => [ 12, 3645 ], __else__ => [ 12, 3645 ], "~" => [ 12, 3645 ], },
	# [3645] opcode : res "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]"
	{ ")" => 3646, },
	# [3646] opcode : res "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_941 ], "," => 3647, ":" => [ 7, \&_action_opcode_941 ], },
	# [3647] opcode : res "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" ","
	{ a => 3648, b => 3649, c => 3650, d => 3651, e => 3652, h => 3653, l => 3654, },
	# [3648] opcode : res "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_942 ], ":" => [ 7, \&_action_opcode_942 ], },
	# [3649] opcode : res "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_943 ], ":" => [ 7, \&_action_opcode_943 ], },
	# [3650] opcode : res "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_944 ], ":" => [ 7, \&_action_opcode_944 ], },
	# [3651] opcode : res "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_945 ], ":" => [ 7, \&_action_opcode_945 ], },
	# [3652] opcode : res "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_946 ], ":" => [ 7, \&_action_opcode_946 ], },
	# [3653] opcode : res "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_947 ], ":" => [ 7, \&_action_opcode_947 ], },
	# [3654] opcode : res "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_948 ], ":" => [ 7, \&_action_opcode_948 ], },
	# [3655] opcode : res "[inline_const]" 3 "," "(" ix "-"
	{ "!" => [ 14, 3656 ], "+" => [ 14, 3656 ], "-" => [ 14, 3656 ], __else__ => [ 14, 3656 ], "~" => [ 14, 3656 ], },
	# [3656] opcode : res "[inline_const]" 3 "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 3657, },
	# [3657] opcode : res "[inline_const]" 3 "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_941 ], "," => 3658, ":" => [ 7, \&_action_opcode_941 ], },
	# [3658] opcode : res "[inline_const]" 3 "," "(" ix "-" "[expr_NDIS]" ")" ","
	{ a => 3659, b => 3660, c => 3661, d => 3662, e => 3663, h => 3664, l => 3665, },
	# [3659] opcode : res "[inline_const]" 3 "," "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_942 ], ":" => [ 7, \&_action_opcode_942 ], },
	# [3660] opcode : res "[inline_const]" 3 "," "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_943 ], ":" => [ 7, \&_action_opcode_943 ], },
	# [3661] opcode : res "[inline_const]" 3 "," "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_944 ], ":" => [ 7, \&_action_opcode_944 ], },
	# [3662] opcode : res "[inline_const]" 3 "," "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_945 ], ":" => [ 7, \&_action_opcode_945 ], },
	# [3663] opcode : res "[inline_const]" 3 "," "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_946 ], ":" => [ 7, \&_action_opcode_946 ], },
	# [3664] opcode : res "[inline_const]" 3 "," "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_947 ], ":" => [ 7, \&_action_opcode_947 ], },
	# [3665] opcode : res "[inline_const]" 3 "," "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_948 ], ":" => [ 7, \&_action_opcode_948 ], },
	# [3666] opcode : res "[inline_const]" 3 "," "(" iy
	{ ")" => 3667, "+" => 3676, "-" => 3687, },
	# [3667] opcode : res "[inline_const]" 3 "," "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_949 ], "," => 3668, ":" => [ 7, \&_action_opcode_949 ], },
	# [3668] opcode : res "[inline_const]" 3 "," "(" iy ")" ","
	{ a => 3669, b => 3670, c => 3671, d => 3672, e => 3673, h => 3674, l => 3675, },
	# [3669] opcode : res "[inline_const]" 3 "," "(" iy ")" "," a
	{ "\n" => [ 7, \&_action_opcode_950 ], ":" => [ 7, \&_action_opcode_950 ], },
	# [3670] opcode : res "[inline_const]" 3 "," "(" iy ")" "," b
	{ "\n" => [ 7, \&_action_opcode_951 ], ":" => [ 7, \&_action_opcode_951 ], },
	# [3671] opcode : res "[inline_const]" 3 "," "(" iy ")" "," c
	{ "\n" => [ 7, \&_action_opcode_952 ], ":" => [ 7, \&_action_opcode_952 ], },
	# [3672] opcode : res "[inline_const]" 3 "," "(" iy ")" "," d
	{ "\n" => [ 7, \&_action_opcode_953 ], ":" => [ 7, \&_action_opcode_953 ], },
	# [3673] opcode : res "[inline_const]" 3 "," "(" iy ")" "," e
	{ "\n" => [ 7, \&_action_opcode_954 ], ":" => [ 7, \&_action_opcode_954 ], },
	# [3674] opcode : res "[inline_const]" 3 "," "(" iy ")" "," h
	{ "\n" => [ 7, \&_action_opcode_955 ], ":" => [ 7, \&_action_opcode_955 ], },
	# [3675] opcode : res "[inline_const]" 3 "," "(" iy ")" "," l
	{ "\n" => [ 7, \&_action_opcode_956 ], ":" => [ 7, \&_action_opcode_956 ], },
	# [3676] opcode : res "[inline_const]" 3 "," "(" iy "+"
	{ "!" => [ 12, 3677 ], "+" => [ 12, 3677 ], "-" => [ 12, 3677 ], __else__ => [ 12, 3677 ], "~" => [ 12, 3677 ], },
	# [3677] opcode : res "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]"
	{ ")" => 3678, },
	# [3678] opcode : res "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_957 ], "," => 3679, ":" => [ 7, \&_action_opcode_957 ], },
	# [3679] opcode : res "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" ","
	{ a => 3680, b => 3681, c => 3682, d => 3683, e => 3684, h => 3685, l => 3686, },
	# [3680] opcode : res "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_958 ], ":" => [ 7, \&_action_opcode_958 ], },
	# [3681] opcode : res "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_959 ], ":" => [ 7, \&_action_opcode_959 ], },
	# [3682] opcode : res "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_960 ], ":" => [ 7, \&_action_opcode_960 ], },
	# [3683] opcode : res "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_961 ], ":" => [ 7, \&_action_opcode_961 ], },
	# [3684] opcode : res "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_962 ], ":" => [ 7, \&_action_opcode_962 ], },
	# [3685] opcode : res "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_963 ], ":" => [ 7, \&_action_opcode_963 ], },
	# [3686] opcode : res "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_964 ], ":" => [ 7, \&_action_opcode_964 ], },
	# [3687] opcode : res "[inline_const]" 3 "," "(" iy "-"
	{ "!" => [ 14, 3688 ], "+" => [ 14, 3688 ], "-" => [ 14, 3688 ], __else__ => [ 14, 3688 ], "~" => [ 14, 3688 ], },
	# [3688] opcode : res "[inline_const]" 3 "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 3689, },
	# [3689] opcode : res "[inline_const]" 3 "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_957 ], "," => 3690, ":" => [ 7, \&_action_opcode_957 ], },
	# [3690] opcode : res "[inline_const]" 3 "," "(" iy "-" "[expr_NDIS]" ")" ","
	{ a => 3691, b => 3692, c => 3693, d => 3694, e => 3695, h => 3696, l => 3697, },
	# [3691] opcode : res "[inline_const]" 3 "," "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_958 ], ":" => [ 7, \&_action_opcode_958 ], },
	# [3692] opcode : res "[inline_const]" 3 "," "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_959 ], ":" => [ 7, \&_action_opcode_959 ], },
	# [3693] opcode : res "[inline_const]" 3 "," "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_960 ], ":" => [ 7, \&_action_opcode_960 ], },
	# [3694] opcode : res "[inline_const]" 3 "," "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_961 ], ":" => [ 7, \&_action_opcode_961 ], },
	# [3695] opcode : res "[inline_const]" 3 "," "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_962 ], ":" => [ 7, \&_action_opcode_962 ], },
	# [3696] opcode : res "[inline_const]" 3 "," "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_963 ], ":" => [ 7, \&_action_opcode_963 ], },
	# [3697] opcode : res "[inline_const]" 3 "," "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_964 ], ":" => [ 7, \&_action_opcode_964 ], },
	# [3698] opcode : res "[inline_const]" 3 "," "["
	{ hl => 3699, ix => 3701, iy => 3733, },
	# [3699] opcode : res "[inline_const]" 3 "," "[" hl
	{ "]" => 3700, },
	# [3700] opcode : res "[inline_const]" 3 "," "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_932 ], ":" => [ 7, \&_action_opcode_932 ], },
	# [3701] opcode : res "[inline_const]" 3 "," "[" ix
	{ "+" => 3702, "-" => 3713, "]" => 3724, },
	# [3702] opcode : res "[inline_const]" 3 "," "[" ix "+"
	{ "!" => [ 12, 3703 ], "+" => [ 12, 3703 ], "-" => [ 12, 3703 ], __else__ => [ 12, 3703 ], "~" => [ 12, 3703 ], },
	# [3703] opcode : res "[inline_const]" 3 "," "[" ix "+" "[expr_DIS]"
	{ "]" => 3704, },
	# [3704] opcode : res "[inline_const]" 3 "," "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_941 ], "," => 3705, ":" => [ 7, \&_action_opcode_941 ], },
	# [3705] opcode : res "[inline_const]" 3 "," "[" ix "+" "[expr_DIS]" "]" ","
	{ a => 3706, b => 3707, c => 3708, d => 3709, e => 3710, h => 3711, l => 3712, },
	# [3706] opcode : res "[inline_const]" 3 "," "[" ix "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_942 ], ":" => [ 7, \&_action_opcode_942 ], },
	# [3707] opcode : res "[inline_const]" 3 "," "[" ix "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_943 ], ":" => [ 7, \&_action_opcode_943 ], },
	# [3708] opcode : res "[inline_const]" 3 "," "[" ix "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_944 ], ":" => [ 7, \&_action_opcode_944 ], },
	# [3709] opcode : res "[inline_const]" 3 "," "[" ix "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_945 ], ":" => [ 7, \&_action_opcode_945 ], },
	# [3710] opcode : res "[inline_const]" 3 "," "[" ix "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_946 ], ":" => [ 7, \&_action_opcode_946 ], },
	# [3711] opcode : res "[inline_const]" 3 "," "[" ix "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_947 ], ":" => [ 7, \&_action_opcode_947 ], },
	# [3712] opcode : res "[inline_const]" 3 "," "[" ix "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_948 ], ":" => [ 7, \&_action_opcode_948 ], },
	# [3713] opcode : res "[inline_const]" 3 "," "[" ix "-"
	{ "!" => [ 14, 3714 ], "+" => [ 14, 3714 ], "-" => [ 14, 3714 ], __else__ => [ 14, 3714 ], "~" => [ 14, 3714 ], },
	# [3714] opcode : res "[inline_const]" 3 "," "[" ix "-" "[expr_NDIS]"
	{ "]" => 3715, },
	# [3715] opcode : res "[inline_const]" 3 "," "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_941 ], "," => 3716, ":" => [ 7, \&_action_opcode_941 ], },
	# [3716] opcode : res "[inline_const]" 3 "," "[" ix "-" "[expr_NDIS]" "]" ","
	{ a => 3717, b => 3718, c => 3719, d => 3720, e => 3721, h => 3722, l => 3723, },
	# [3717] opcode : res "[inline_const]" 3 "," "[" ix "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_942 ], ":" => [ 7, \&_action_opcode_942 ], },
	# [3718] opcode : res "[inline_const]" 3 "," "[" ix "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_943 ], ":" => [ 7, \&_action_opcode_943 ], },
	# [3719] opcode : res "[inline_const]" 3 "," "[" ix "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_944 ], ":" => [ 7, \&_action_opcode_944 ], },
	# [3720] opcode : res "[inline_const]" 3 "," "[" ix "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_945 ], ":" => [ 7, \&_action_opcode_945 ], },
	# [3721] opcode : res "[inline_const]" 3 "," "[" ix "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_946 ], ":" => [ 7, \&_action_opcode_946 ], },
	# [3722] opcode : res "[inline_const]" 3 "," "[" ix "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_947 ], ":" => [ 7, \&_action_opcode_947 ], },
	# [3723] opcode : res "[inline_const]" 3 "," "[" ix "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_948 ], ":" => [ 7, \&_action_opcode_948 ], },
	# [3724] opcode : res "[inline_const]" 3 "," "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_933 ], "," => 3725, ":" => [ 7, \&_action_opcode_933 ], },
	# [3725] opcode : res "[inline_const]" 3 "," "[" ix "]" ","
	{ a => 3726, b => 3727, c => 3728, d => 3729, e => 3730, h => 3731, l => 3732, },
	# [3726] opcode : res "[inline_const]" 3 "," "[" ix "]" "," a
	{ "\n" => [ 7, \&_action_opcode_934 ], ":" => [ 7, \&_action_opcode_934 ], },
	# [3727] opcode : res "[inline_const]" 3 "," "[" ix "]" "," b
	{ "\n" => [ 7, \&_action_opcode_935 ], ":" => [ 7, \&_action_opcode_935 ], },
	# [3728] opcode : res "[inline_const]" 3 "," "[" ix "]" "," c
	{ "\n" => [ 7, \&_action_opcode_936 ], ":" => [ 7, \&_action_opcode_936 ], },
	# [3729] opcode : res "[inline_const]" 3 "," "[" ix "]" "," d
	{ "\n" => [ 7, \&_action_opcode_937 ], ":" => [ 7, \&_action_opcode_937 ], },
	# [3730] opcode : res "[inline_const]" 3 "," "[" ix "]" "," e
	{ "\n" => [ 7, \&_action_opcode_938 ], ":" => [ 7, \&_action_opcode_938 ], },
	# [3731] opcode : res "[inline_const]" 3 "," "[" ix "]" "," h
	{ "\n" => [ 7, \&_action_opcode_939 ], ":" => [ 7, \&_action_opcode_939 ], },
	# [3732] opcode : res "[inline_const]" 3 "," "[" ix "]" "," l
	{ "\n" => [ 7, \&_action_opcode_940 ], ":" => [ 7, \&_action_opcode_940 ], },
	# [3733] opcode : res "[inline_const]" 3 "," "[" iy
	{ "+" => 3734, "-" => 3745, "]" => 3756, },
	# [3734] opcode : res "[inline_const]" 3 "," "[" iy "+"
	{ "!" => [ 12, 3735 ], "+" => [ 12, 3735 ], "-" => [ 12, 3735 ], __else__ => [ 12, 3735 ], "~" => [ 12, 3735 ], },
	# [3735] opcode : res "[inline_const]" 3 "," "[" iy "+" "[expr_DIS]"
	{ "]" => 3736, },
	# [3736] opcode : res "[inline_const]" 3 "," "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_957 ], "," => 3737, ":" => [ 7, \&_action_opcode_957 ], },
	# [3737] opcode : res "[inline_const]" 3 "," "[" iy "+" "[expr_DIS]" "]" ","
	{ a => 3738, b => 3739, c => 3740, d => 3741, e => 3742, h => 3743, l => 3744, },
	# [3738] opcode : res "[inline_const]" 3 "," "[" iy "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_958 ], ":" => [ 7, \&_action_opcode_958 ], },
	# [3739] opcode : res "[inline_const]" 3 "," "[" iy "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_959 ], ":" => [ 7, \&_action_opcode_959 ], },
	# [3740] opcode : res "[inline_const]" 3 "," "[" iy "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_960 ], ":" => [ 7, \&_action_opcode_960 ], },
	# [3741] opcode : res "[inline_const]" 3 "," "[" iy "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_961 ], ":" => [ 7, \&_action_opcode_961 ], },
	# [3742] opcode : res "[inline_const]" 3 "," "[" iy "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_962 ], ":" => [ 7, \&_action_opcode_962 ], },
	# [3743] opcode : res "[inline_const]" 3 "," "[" iy "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_963 ], ":" => [ 7, \&_action_opcode_963 ], },
	# [3744] opcode : res "[inline_const]" 3 "," "[" iy "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_964 ], ":" => [ 7, \&_action_opcode_964 ], },
	# [3745] opcode : res "[inline_const]" 3 "," "[" iy "-"
	{ "!" => [ 14, 3746 ], "+" => [ 14, 3746 ], "-" => [ 14, 3746 ], __else__ => [ 14, 3746 ], "~" => [ 14, 3746 ], },
	# [3746] opcode : res "[inline_const]" 3 "," "[" iy "-" "[expr_NDIS]"
	{ "]" => 3747, },
	# [3747] opcode : res "[inline_const]" 3 "," "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_957 ], "," => 3748, ":" => [ 7, \&_action_opcode_957 ], },
	# [3748] opcode : res "[inline_const]" 3 "," "[" iy "-" "[expr_NDIS]" "]" ","
	{ a => 3749, b => 3750, c => 3751, d => 3752, e => 3753, h => 3754, l => 3755, },
	# [3749] opcode : res "[inline_const]" 3 "," "[" iy "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_958 ], ":" => [ 7, \&_action_opcode_958 ], },
	# [3750] opcode : res "[inline_const]" 3 "," "[" iy "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_959 ], ":" => [ 7, \&_action_opcode_959 ], },
	# [3751] opcode : res "[inline_const]" 3 "," "[" iy "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_960 ], ":" => [ 7, \&_action_opcode_960 ], },
	# [3752] opcode : res "[inline_const]" 3 "," "[" iy "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_961 ], ":" => [ 7, \&_action_opcode_961 ], },
	# [3753] opcode : res "[inline_const]" 3 "," "[" iy "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_962 ], ":" => [ 7, \&_action_opcode_962 ], },
	# [3754] opcode : res "[inline_const]" 3 "," "[" iy "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_963 ], ":" => [ 7, \&_action_opcode_963 ], },
	# [3755] opcode : res "[inline_const]" 3 "," "[" iy "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_964 ], ":" => [ 7, \&_action_opcode_964 ], },
	# [3756] opcode : res "[inline_const]" 3 "," "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_949 ], "," => 3757, ":" => [ 7, \&_action_opcode_949 ], },
	# [3757] opcode : res "[inline_const]" 3 "," "[" iy "]" ","
	{ a => 3758, b => 3759, c => 3760, d => 3761, e => 3762, h => 3763, l => 3764, },
	# [3758] opcode : res "[inline_const]" 3 "," "[" iy "]" "," a
	{ "\n" => [ 7, \&_action_opcode_950 ], ":" => [ 7, \&_action_opcode_950 ], },
	# [3759] opcode : res "[inline_const]" 3 "," "[" iy "]" "," b
	{ "\n" => [ 7, \&_action_opcode_951 ], ":" => [ 7, \&_action_opcode_951 ], },
	# [3760] opcode : res "[inline_const]" 3 "," "[" iy "]" "," c
	{ "\n" => [ 7, \&_action_opcode_952 ], ":" => [ 7, \&_action_opcode_952 ], },
	# [3761] opcode : res "[inline_const]" 3 "," "[" iy "]" "," d
	{ "\n" => [ 7, \&_action_opcode_953 ], ":" => [ 7, \&_action_opcode_953 ], },
	# [3762] opcode : res "[inline_const]" 3 "," "[" iy "]" "," e
	{ "\n" => [ 7, \&_action_opcode_954 ], ":" => [ 7, \&_action_opcode_954 ], },
	# [3763] opcode : res "[inline_const]" 3 "," "[" iy "]" "," h
	{ "\n" => [ 7, \&_action_opcode_955 ], ":" => [ 7, \&_action_opcode_955 ], },
	# [3764] opcode : res "[inline_const]" 3 "," "[" iy "]" "," l
	{ "\n" => [ 7, \&_action_opcode_956 ], ":" => [ 7, \&_action_opcode_956 ], },
	# [3765] opcode : res "[inline_const]" 3 "," a
	{ "\n" => [ 7, \&_action_opcode_965 ], ":" => [ 7, \&_action_opcode_965 ], },
	# [3766] opcode : res "[inline_const]" 3 "," b
	{ "\n" => [ 7, \&_action_opcode_966 ], ":" => [ 7, \&_action_opcode_966 ], },
	# [3767] opcode : res "[inline_const]" 3 "," c
	{ "\n" => [ 7, \&_action_opcode_967 ], ":" => [ 7, \&_action_opcode_967 ], },
	# [3768] opcode : res "[inline_const]" 3 "," d
	{ "\n" => [ 7, \&_action_opcode_968 ], ":" => [ 7, \&_action_opcode_968 ], },
	# [3769] opcode : res "[inline_const]" 3 "," e
	{ "\n" => [ 7, \&_action_opcode_969 ], ":" => [ 7, \&_action_opcode_969 ], },
	# [3770] opcode : res "[inline_const]" 3 "," h
	{ "\n" => [ 7, \&_action_opcode_970 ], ":" => [ 7, \&_action_opcode_970 ], },
	# [3771] opcode : res "[inline_const]" 3 "," l
	{ "\n" => [ 7, \&_action_opcode_971 ], ":" => [ 7, \&_action_opcode_971 ], },
	# [3772] opcode : res "[inline_const]" 4
	{ "," => 3773, },
	# [3773] opcode : res "[inline_const]" 4 ","
	{ "(" => 3774, "[" => 3841, a => 3908, b => 3909, c => 3910, d => 3911, e => 3912, h => 3913, l => 3914, },
	# [3774] opcode : res "[inline_const]" 4 "," "("
	{ hl => 3775, ix => 3777, iy => 3809, },
	# [3775] opcode : res "[inline_const]" 4 "," "(" hl
	{ ")" => 3776, },
	# [3776] opcode : res "[inline_const]" 4 "," "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_972 ], ":" => [ 7, \&_action_opcode_972 ], },
	# [3777] opcode : res "[inline_const]" 4 "," "(" ix
	{ ")" => 3778, "+" => 3787, "-" => 3798, },
	# [3778] opcode : res "[inline_const]" 4 "," "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_973 ], "," => 3779, ":" => [ 7, \&_action_opcode_973 ], },
	# [3779] opcode : res "[inline_const]" 4 "," "(" ix ")" ","
	{ a => 3780, b => 3781, c => 3782, d => 3783, e => 3784, h => 3785, l => 3786, },
	# [3780] opcode : res "[inline_const]" 4 "," "(" ix ")" "," a
	{ "\n" => [ 7, \&_action_opcode_974 ], ":" => [ 7, \&_action_opcode_974 ], },
	# [3781] opcode : res "[inline_const]" 4 "," "(" ix ")" "," b
	{ "\n" => [ 7, \&_action_opcode_975 ], ":" => [ 7, \&_action_opcode_975 ], },
	# [3782] opcode : res "[inline_const]" 4 "," "(" ix ")" "," c
	{ "\n" => [ 7, \&_action_opcode_976 ], ":" => [ 7, \&_action_opcode_976 ], },
	# [3783] opcode : res "[inline_const]" 4 "," "(" ix ")" "," d
	{ "\n" => [ 7, \&_action_opcode_977 ], ":" => [ 7, \&_action_opcode_977 ], },
	# [3784] opcode : res "[inline_const]" 4 "," "(" ix ")" "," e
	{ "\n" => [ 7, \&_action_opcode_978 ], ":" => [ 7, \&_action_opcode_978 ], },
	# [3785] opcode : res "[inline_const]" 4 "," "(" ix ")" "," h
	{ "\n" => [ 7, \&_action_opcode_979 ], ":" => [ 7, \&_action_opcode_979 ], },
	# [3786] opcode : res "[inline_const]" 4 "," "(" ix ")" "," l
	{ "\n" => [ 7, \&_action_opcode_980 ], ":" => [ 7, \&_action_opcode_980 ], },
	# [3787] opcode : res "[inline_const]" 4 "," "(" ix "+"
	{ "!" => [ 12, 3788 ], "+" => [ 12, 3788 ], "-" => [ 12, 3788 ], __else__ => [ 12, 3788 ], "~" => [ 12, 3788 ], },
	# [3788] opcode : res "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]"
	{ ")" => 3789, },
	# [3789] opcode : res "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_981 ], "," => 3790, ":" => [ 7, \&_action_opcode_981 ], },
	# [3790] opcode : res "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" ","
	{ a => 3791, b => 3792, c => 3793, d => 3794, e => 3795, h => 3796, l => 3797, },
	# [3791] opcode : res "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_982 ], ":" => [ 7, \&_action_opcode_982 ], },
	# [3792] opcode : res "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_983 ], ":" => [ 7, \&_action_opcode_983 ], },
	# [3793] opcode : res "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_984 ], ":" => [ 7, \&_action_opcode_984 ], },
	# [3794] opcode : res "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_985 ], ":" => [ 7, \&_action_opcode_985 ], },
	# [3795] opcode : res "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_986 ], ":" => [ 7, \&_action_opcode_986 ], },
	# [3796] opcode : res "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_987 ], ":" => [ 7, \&_action_opcode_987 ], },
	# [3797] opcode : res "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_988 ], ":" => [ 7, \&_action_opcode_988 ], },
	# [3798] opcode : res "[inline_const]" 4 "," "(" ix "-"
	{ "!" => [ 14, 3799 ], "+" => [ 14, 3799 ], "-" => [ 14, 3799 ], __else__ => [ 14, 3799 ], "~" => [ 14, 3799 ], },
	# [3799] opcode : res "[inline_const]" 4 "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 3800, },
	# [3800] opcode : res "[inline_const]" 4 "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_981 ], "," => 3801, ":" => [ 7, \&_action_opcode_981 ], },
	# [3801] opcode : res "[inline_const]" 4 "," "(" ix "-" "[expr_NDIS]" ")" ","
	{ a => 3802, b => 3803, c => 3804, d => 3805, e => 3806, h => 3807, l => 3808, },
	# [3802] opcode : res "[inline_const]" 4 "," "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_982 ], ":" => [ 7, \&_action_opcode_982 ], },
	# [3803] opcode : res "[inline_const]" 4 "," "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_983 ], ":" => [ 7, \&_action_opcode_983 ], },
	# [3804] opcode : res "[inline_const]" 4 "," "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_984 ], ":" => [ 7, \&_action_opcode_984 ], },
	# [3805] opcode : res "[inline_const]" 4 "," "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_985 ], ":" => [ 7, \&_action_opcode_985 ], },
	# [3806] opcode : res "[inline_const]" 4 "," "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_986 ], ":" => [ 7, \&_action_opcode_986 ], },
	# [3807] opcode : res "[inline_const]" 4 "," "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_987 ], ":" => [ 7, \&_action_opcode_987 ], },
	# [3808] opcode : res "[inline_const]" 4 "," "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_988 ], ":" => [ 7, \&_action_opcode_988 ], },
	# [3809] opcode : res "[inline_const]" 4 "," "(" iy
	{ ")" => 3810, "+" => 3819, "-" => 3830, },
	# [3810] opcode : res "[inline_const]" 4 "," "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_989 ], "," => 3811, ":" => [ 7, \&_action_opcode_989 ], },
	# [3811] opcode : res "[inline_const]" 4 "," "(" iy ")" ","
	{ a => 3812, b => 3813, c => 3814, d => 3815, e => 3816, h => 3817, l => 3818, },
	# [3812] opcode : res "[inline_const]" 4 "," "(" iy ")" "," a
	{ "\n" => [ 7, \&_action_opcode_990 ], ":" => [ 7, \&_action_opcode_990 ], },
	# [3813] opcode : res "[inline_const]" 4 "," "(" iy ")" "," b
	{ "\n" => [ 7, \&_action_opcode_991 ], ":" => [ 7, \&_action_opcode_991 ], },
	# [3814] opcode : res "[inline_const]" 4 "," "(" iy ")" "," c
	{ "\n" => [ 7, \&_action_opcode_992 ], ":" => [ 7, \&_action_opcode_992 ], },
	# [3815] opcode : res "[inline_const]" 4 "," "(" iy ")" "," d
	{ "\n" => [ 7, \&_action_opcode_993 ], ":" => [ 7, \&_action_opcode_993 ], },
	# [3816] opcode : res "[inline_const]" 4 "," "(" iy ")" "," e
	{ "\n" => [ 7, \&_action_opcode_994 ], ":" => [ 7, \&_action_opcode_994 ], },
	# [3817] opcode : res "[inline_const]" 4 "," "(" iy ")" "," h
	{ "\n" => [ 7, \&_action_opcode_995 ], ":" => [ 7, \&_action_opcode_995 ], },
	# [3818] opcode : res "[inline_const]" 4 "," "(" iy ")" "," l
	{ "\n" => [ 7, \&_action_opcode_996 ], ":" => [ 7, \&_action_opcode_996 ], },
	# [3819] opcode : res "[inline_const]" 4 "," "(" iy "+"
	{ "!" => [ 12, 3820 ], "+" => [ 12, 3820 ], "-" => [ 12, 3820 ], __else__ => [ 12, 3820 ], "~" => [ 12, 3820 ], },
	# [3820] opcode : res "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]"
	{ ")" => 3821, },
	# [3821] opcode : res "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_997 ], "," => 3822, ":" => [ 7, \&_action_opcode_997 ], },
	# [3822] opcode : res "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" ","
	{ a => 3823, b => 3824, c => 3825, d => 3826, e => 3827, h => 3828, l => 3829, },
	# [3823] opcode : res "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_998 ], ":" => [ 7, \&_action_opcode_998 ], },
	# [3824] opcode : res "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_999 ], ":" => [ 7, \&_action_opcode_999 ], },
	# [3825] opcode : res "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1000 ], ":" => [ 7, \&_action_opcode_1000 ], },
	# [3826] opcode : res "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1001 ], ":" => [ 7, \&_action_opcode_1001 ], },
	# [3827] opcode : res "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1002 ], ":" => [ 7, \&_action_opcode_1002 ], },
	# [3828] opcode : res "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1003 ], ":" => [ 7, \&_action_opcode_1003 ], },
	# [3829] opcode : res "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1004 ], ":" => [ 7, \&_action_opcode_1004 ], },
	# [3830] opcode : res "[inline_const]" 4 "," "(" iy "-"
	{ "!" => [ 14, 3831 ], "+" => [ 14, 3831 ], "-" => [ 14, 3831 ], __else__ => [ 14, 3831 ], "~" => [ 14, 3831 ], },
	# [3831] opcode : res "[inline_const]" 4 "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 3832, },
	# [3832] opcode : res "[inline_const]" 4 "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_997 ], "," => 3833, ":" => [ 7, \&_action_opcode_997 ], },
	# [3833] opcode : res "[inline_const]" 4 "," "(" iy "-" "[expr_NDIS]" ")" ","
	{ a => 3834, b => 3835, c => 3836, d => 3837, e => 3838, h => 3839, l => 3840, },
	# [3834] opcode : res "[inline_const]" 4 "," "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_998 ], ":" => [ 7, \&_action_opcode_998 ], },
	# [3835] opcode : res "[inline_const]" 4 "," "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_999 ], ":" => [ 7, \&_action_opcode_999 ], },
	# [3836] opcode : res "[inline_const]" 4 "," "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1000 ], ":" => [ 7, \&_action_opcode_1000 ], },
	# [3837] opcode : res "[inline_const]" 4 "," "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1001 ], ":" => [ 7, \&_action_opcode_1001 ], },
	# [3838] opcode : res "[inline_const]" 4 "," "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1002 ], ":" => [ 7, \&_action_opcode_1002 ], },
	# [3839] opcode : res "[inline_const]" 4 "," "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1003 ], ":" => [ 7, \&_action_opcode_1003 ], },
	# [3840] opcode : res "[inline_const]" 4 "," "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1004 ], ":" => [ 7, \&_action_opcode_1004 ], },
	# [3841] opcode : res "[inline_const]" 4 "," "["
	{ hl => 3842, ix => 3844, iy => 3876, },
	# [3842] opcode : res "[inline_const]" 4 "," "[" hl
	{ "]" => 3843, },
	# [3843] opcode : res "[inline_const]" 4 "," "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_972 ], ":" => [ 7, \&_action_opcode_972 ], },
	# [3844] opcode : res "[inline_const]" 4 "," "[" ix
	{ "+" => 3845, "-" => 3856, "]" => 3867, },
	# [3845] opcode : res "[inline_const]" 4 "," "[" ix "+"
	{ "!" => [ 12, 3846 ], "+" => [ 12, 3846 ], "-" => [ 12, 3846 ], __else__ => [ 12, 3846 ], "~" => [ 12, 3846 ], },
	# [3846] opcode : res "[inline_const]" 4 "," "[" ix "+" "[expr_DIS]"
	{ "]" => 3847, },
	# [3847] opcode : res "[inline_const]" 4 "," "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_981 ], "," => 3848, ":" => [ 7, \&_action_opcode_981 ], },
	# [3848] opcode : res "[inline_const]" 4 "," "[" ix "+" "[expr_DIS]" "]" ","
	{ a => 3849, b => 3850, c => 3851, d => 3852, e => 3853, h => 3854, l => 3855, },
	# [3849] opcode : res "[inline_const]" 4 "," "[" ix "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_982 ], ":" => [ 7, \&_action_opcode_982 ], },
	# [3850] opcode : res "[inline_const]" 4 "," "[" ix "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_983 ], ":" => [ 7, \&_action_opcode_983 ], },
	# [3851] opcode : res "[inline_const]" 4 "," "[" ix "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_984 ], ":" => [ 7, \&_action_opcode_984 ], },
	# [3852] opcode : res "[inline_const]" 4 "," "[" ix "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_985 ], ":" => [ 7, \&_action_opcode_985 ], },
	# [3853] opcode : res "[inline_const]" 4 "," "[" ix "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_986 ], ":" => [ 7, \&_action_opcode_986 ], },
	# [3854] opcode : res "[inline_const]" 4 "," "[" ix "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_987 ], ":" => [ 7, \&_action_opcode_987 ], },
	# [3855] opcode : res "[inline_const]" 4 "," "[" ix "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_988 ], ":" => [ 7, \&_action_opcode_988 ], },
	# [3856] opcode : res "[inline_const]" 4 "," "[" ix "-"
	{ "!" => [ 14, 3857 ], "+" => [ 14, 3857 ], "-" => [ 14, 3857 ], __else__ => [ 14, 3857 ], "~" => [ 14, 3857 ], },
	# [3857] opcode : res "[inline_const]" 4 "," "[" ix "-" "[expr_NDIS]"
	{ "]" => 3858, },
	# [3858] opcode : res "[inline_const]" 4 "," "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_981 ], "," => 3859, ":" => [ 7, \&_action_opcode_981 ], },
	# [3859] opcode : res "[inline_const]" 4 "," "[" ix "-" "[expr_NDIS]" "]" ","
	{ a => 3860, b => 3861, c => 3862, d => 3863, e => 3864, h => 3865, l => 3866, },
	# [3860] opcode : res "[inline_const]" 4 "," "[" ix "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_982 ], ":" => [ 7, \&_action_opcode_982 ], },
	# [3861] opcode : res "[inline_const]" 4 "," "[" ix "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_983 ], ":" => [ 7, \&_action_opcode_983 ], },
	# [3862] opcode : res "[inline_const]" 4 "," "[" ix "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_984 ], ":" => [ 7, \&_action_opcode_984 ], },
	# [3863] opcode : res "[inline_const]" 4 "," "[" ix "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_985 ], ":" => [ 7, \&_action_opcode_985 ], },
	# [3864] opcode : res "[inline_const]" 4 "," "[" ix "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_986 ], ":" => [ 7, \&_action_opcode_986 ], },
	# [3865] opcode : res "[inline_const]" 4 "," "[" ix "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_987 ], ":" => [ 7, \&_action_opcode_987 ], },
	# [3866] opcode : res "[inline_const]" 4 "," "[" ix "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_988 ], ":" => [ 7, \&_action_opcode_988 ], },
	# [3867] opcode : res "[inline_const]" 4 "," "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_973 ], "," => 3868, ":" => [ 7, \&_action_opcode_973 ], },
	# [3868] opcode : res "[inline_const]" 4 "," "[" ix "]" ","
	{ a => 3869, b => 3870, c => 3871, d => 3872, e => 3873, h => 3874, l => 3875, },
	# [3869] opcode : res "[inline_const]" 4 "," "[" ix "]" "," a
	{ "\n" => [ 7, \&_action_opcode_974 ], ":" => [ 7, \&_action_opcode_974 ], },
	# [3870] opcode : res "[inline_const]" 4 "," "[" ix "]" "," b
	{ "\n" => [ 7, \&_action_opcode_975 ], ":" => [ 7, \&_action_opcode_975 ], },
	# [3871] opcode : res "[inline_const]" 4 "," "[" ix "]" "," c
	{ "\n" => [ 7, \&_action_opcode_976 ], ":" => [ 7, \&_action_opcode_976 ], },
	# [3872] opcode : res "[inline_const]" 4 "," "[" ix "]" "," d
	{ "\n" => [ 7, \&_action_opcode_977 ], ":" => [ 7, \&_action_opcode_977 ], },
	# [3873] opcode : res "[inline_const]" 4 "," "[" ix "]" "," e
	{ "\n" => [ 7, \&_action_opcode_978 ], ":" => [ 7, \&_action_opcode_978 ], },
	# [3874] opcode : res "[inline_const]" 4 "," "[" ix "]" "," h
	{ "\n" => [ 7, \&_action_opcode_979 ], ":" => [ 7, \&_action_opcode_979 ], },
	# [3875] opcode : res "[inline_const]" 4 "," "[" ix "]" "," l
	{ "\n" => [ 7, \&_action_opcode_980 ], ":" => [ 7, \&_action_opcode_980 ], },
	# [3876] opcode : res "[inline_const]" 4 "," "[" iy
	{ "+" => 3877, "-" => 3888, "]" => 3899, },
	# [3877] opcode : res "[inline_const]" 4 "," "[" iy "+"
	{ "!" => [ 12, 3878 ], "+" => [ 12, 3878 ], "-" => [ 12, 3878 ], __else__ => [ 12, 3878 ], "~" => [ 12, 3878 ], },
	# [3878] opcode : res "[inline_const]" 4 "," "[" iy "+" "[expr_DIS]"
	{ "]" => 3879, },
	# [3879] opcode : res "[inline_const]" 4 "," "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_997 ], "," => 3880, ":" => [ 7, \&_action_opcode_997 ], },
	# [3880] opcode : res "[inline_const]" 4 "," "[" iy "+" "[expr_DIS]" "]" ","
	{ a => 3881, b => 3882, c => 3883, d => 3884, e => 3885, h => 3886, l => 3887, },
	# [3881] opcode : res "[inline_const]" 4 "," "[" iy "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_998 ], ":" => [ 7, \&_action_opcode_998 ], },
	# [3882] opcode : res "[inline_const]" 4 "," "[" iy "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_999 ], ":" => [ 7, \&_action_opcode_999 ], },
	# [3883] opcode : res "[inline_const]" 4 "," "[" iy "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1000 ], ":" => [ 7, \&_action_opcode_1000 ], },
	# [3884] opcode : res "[inline_const]" 4 "," "[" iy "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1001 ], ":" => [ 7, \&_action_opcode_1001 ], },
	# [3885] opcode : res "[inline_const]" 4 "," "[" iy "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1002 ], ":" => [ 7, \&_action_opcode_1002 ], },
	# [3886] opcode : res "[inline_const]" 4 "," "[" iy "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1003 ], ":" => [ 7, \&_action_opcode_1003 ], },
	# [3887] opcode : res "[inline_const]" 4 "," "[" iy "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1004 ], ":" => [ 7, \&_action_opcode_1004 ], },
	# [3888] opcode : res "[inline_const]" 4 "," "[" iy "-"
	{ "!" => [ 14, 3889 ], "+" => [ 14, 3889 ], "-" => [ 14, 3889 ], __else__ => [ 14, 3889 ], "~" => [ 14, 3889 ], },
	# [3889] opcode : res "[inline_const]" 4 "," "[" iy "-" "[expr_NDIS]"
	{ "]" => 3890, },
	# [3890] opcode : res "[inline_const]" 4 "," "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_997 ], "," => 3891, ":" => [ 7, \&_action_opcode_997 ], },
	# [3891] opcode : res "[inline_const]" 4 "," "[" iy "-" "[expr_NDIS]" "]" ","
	{ a => 3892, b => 3893, c => 3894, d => 3895, e => 3896, h => 3897, l => 3898, },
	# [3892] opcode : res "[inline_const]" 4 "," "[" iy "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_998 ], ":" => [ 7, \&_action_opcode_998 ], },
	# [3893] opcode : res "[inline_const]" 4 "," "[" iy "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_999 ], ":" => [ 7, \&_action_opcode_999 ], },
	# [3894] opcode : res "[inline_const]" 4 "," "[" iy "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1000 ], ":" => [ 7, \&_action_opcode_1000 ], },
	# [3895] opcode : res "[inline_const]" 4 "," "[" iy "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1001 ], ":" => [ 7, \&_action_opcode_1001 ], },
	# [3896] opcode : res "[inline_const]" 4 "," "[" iy "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1002 ], ":" => [ 7, \&_action_opcode_1002 ], },
	# [3897] opcode : res "[inline_const]" 4 "," "[" iy "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1003 ], ":" => [ 7, \&_action_opcode_1003 ], },
	# [3898] opcode : res "[inline_const]" 4 "," "[" iy "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1004 ], ":" => [ 7, \&_action_opcode_1004 ], },
	# [3899] opcode : res "[inline_const]" 4 "," "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_989 ], "," => 3900, ":" => [ 7, \&_action_opcode_989 ], },
	# [3900] opcode : res "[inline_const]" 4 "," "[" iy "]" ","
	{ a => 3901, b => 3902, c => 3903, d => 3904, e => 3905, h => 3906, l => 3907, },
	# [3901] opcode : res "[inline_const]" 4 "," "[" iy "]" "," a
	{ "\n" => [ 7, \&_action_opcode_990 ], ":" => [ 7, \&_action_opcode_990 ], },
	# [3902] opcode : res "[inline_const]" 4 "," "[" iy "]" "," b
	{ "\n" => [ 7, \&_action_opcode_991 ], ":" => [ 7, \&_action_opcode_991 ], },
	# [3903] opcode : res "[inline_const]" 4 "," "[" iy "]" "," c
	{ "\n" => [ 7, \&_action_opcode_992 ], ":" => [ 7, \&_action_opcode_992 ], },
	# [3904] opcode : res "[inline_const]" 4 "," "[" iy "]" "," d
	{ "\n" => [ 7, \&_action_opcode_993 ], ":" => [ 7, \&_action_opcode_993 ], },
	# [3905] opcode : res "[inline_const]" 4 "," "[" iy "]" "," e
	{ "\n" => [ 7, \&_action_opcode_994 ], ":" => [ 7, \&_action_opcode_994 ], },
	# [3906] opcode : res "[inline_const]" 4 "," "[" iy "]" "," h
	{ "\n" => [ 7, \&_action_opcode_995 ], ":" => [ 7, \&_action_opcode_995 ], },
	# [3907] opcode : res "[inline_const]" 4 "," "[" iy "]" "," l
	{ "\n" => [ 7, \&_action_opcode_996 ], ":" => [ 7, \&_action_opcode_996 ], },
	# [3908] opcode : res "[inline_const]" 4 "," a
	{ "\n" => [ 7, \&_action_opcode_1005 ], ":" => [ 7, \&_action_opcode_1005 ], },
	# [3909] opcode : res "[inline_const]" 4 "," b
	{ "\n" => [ 7, \&_action_opcode_1006 ], ":" => [ 7, \&_action_opcode_1006 ], },
	# [3910] opcode : res "[inline_const]" 4 "," c
	{ "\n" => [ 7, \&_action_opcode_1007 ], ":" => [ 7, \&_action_opcode_1007 ], },
	# [3911] opcode : res "[inline_const]" 4 "," d
	{ "\n" => [ 7, \&_action_opcode_1008 ], ":" => [ 7, \&_action_opcode_1008 ], },
	# [3912] opcode : res "[inline_const]" 4 "," e
	{ "\n" => [ 7, \&_action_opcode_1009 ], ":" => [ 7, \&_action_opcode_1009 ], },
	# [3913] opcode : res "[inline_const]" 4 "," h
	{ "\n" => [ 7, \&_action_opcode_1010 ], ":" => [ 7, \&_action_opcode_1010 ], },
	# [3914] opcode : res "[inline_const]" 4 "," l
	{ "\n" => [ 7, \&_action_opcode_1011 ], ":" => [ 7, \&_action_opcode_1011 ], },
	# [3915] opcode : res "[inline_const]" 5
	{ "," => 3916, },
	# [3916] opcode : res "[inline_const]" 5 ","
	{ "(" => 3917, "[" => 3984, a => 4051, b => 4052, c => 4053, d => 4054, e => 4055, h => 4056, l => 4057, },
	# [3917] opcode : res "[inline_const]" 5 "," "("
	{ hl => 3918, ix => 3920, iy => 3952, },
	# [3918] opcode : res "[inline_const]" 5 "," "(" hl
	{ ")" => 3919, },
	# [3919] opcode : res "[inline_const]" 5 "," "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_1012 ], ":" => [ 7, \&_action_opcode_1012 ], },
	# [3920] opcode : res "[inline_const]" 5 "," "(" ix
	{ ")" => 3921, "+" => 3930, "-" => 3941, },
	# [3921] opcode : res "[inline_const]" 5 "," "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_1013 ], "," => 3922, ":" => [ 7, \&_action_opcode_1013 ], },
	# [3922] opcode : res "[inline_const]" 5 "," "(" ix ")" ","
	{ a => 3923, b => 3924, c => 3925, d => 3926, e => 3927, h => 3928, l => 3929, },
	# [3923] opcode : res "[inline_const]" 5 "," "(" ix ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1014 ], ":" => [ 7, \&_action_opcode_1014 ], },
	# [3924] opcode : res "[inline_const]" 5 "," "(" ix ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1015 ], ":" => [ 7, \&_action_opcode_1015 ], },
	# [3925] opcode : res "[inline_const]" 5 "," "(" ix ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1016 ], ":" => [ 7, \&_action_opcode_1016 ], },
	# [3926] opcode : res "[inline_const]" 5 "," "(" ix ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1017 ], ":" => [ 7, \&_action_opcode_1017 ], },
	# [3927] opcode : res "[inline_const]" 5 "," "(" ix ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1018 ], ":" => [ 7, \&_action_opcode_1018 ], },
	# [3928] opcode : res "[inline_const]" 5 "," "(" ix ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1019 ], ":" => [ 7, \&_action_opcode_1019 ], },
	# [3929] opcode : res "[inline_const]" 5 "," "(" ix ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1020 ], ":" => [ 7, \&_action_opcode_1020 ], },
	# [3930] opcode : res "[inline_const]" 5 "," "(" ix "+"
	{ "!" => [ 12, 3931 ], "+" => [ 12, 3931 ], "-" => [ 12, 3931 ], __else__ => [ 12, 3931 ], "~" => [ 12, 3931 ], },
	# [3931] opcode : res "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]"
	{ ")" => 3932, },
	# [3932] opcode : res "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1021 ], "," => 3933, ":" => [ 7, \&_action_opcode_1021 ], },
	# [3933] opcode : res "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" ","
	{ a => 3934, b => 3935, c => 3936, d => 3937, e => 3938, h => 3939, l => 3940, },
	# [3934] opcode : res "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1022 ], ":" => [ 7, \&_action_opcode_1022 ], },
	# [3935] opcode : res "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1023 ], ":" => [ 7, \&_action_opcode_1023 ], },
	# [3936] opcode : res "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1024 ], ":" => [ 7, \&_action_opcode_1024 ], },
	# [3937] opcode : res "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1025 ], ":" => [ 7, \&_action_opcode_1025 ], },
	# [3938] opcode : res "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1026 ], ":" => [ 7, \&_action_opcode_1026 ], },
	# [3939] opcode : res "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1027 ], ":" => [ 7, \&_action_opcode_1027 ], },
	# [3940] opcode : res "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1028 ], ":" => [ 7, \&_action_opcode_1028 ], },
	# [3941] opcode : res "[inline_const]" 5 "," "(" ix "-"
	{ "!" => [ 14, 3942 ], "+" => [ 14, 3942 ], "-" => [ 14, 3942 ], __else__ => [ 14, 3942 ], "~" => [ 14, 3942 ], },
	# [3942] opcode : res "[inline_const]" 5 "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 3943, },
	# [3943] opcode : res "[inline_const]" 5 "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1021 ], "," => 3944, ":" => [ 7, \&_action_opcode_1021 ], },
	# [3944] opcode : res "[inline_const]" 5 "," "(" ix "-" "[expr_NDIS]" ")" ","
	{ a => 3945, b => 3946, c => 3947, d => 3948, e => 3949, h => 3950, l => 3951, },
	# [3945] opcode : res "[inline_const]" 5 "," "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1022 ], ":" => [ 7, \&_action_opcode_1022 ], },
	# [3946] opcode : res "[inline_const]" 5 "," "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1023 ], ":" => [ 7, \&_action_opcode_1023 ], },
	# [3947] opcode : res "[inline_const]" 5 "," "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1024 ], ":" => [ 7, \&_action_opcode_1024 ], },
	# [3948] opcode : res "[inline_const]" 5 "," "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1025 ], ":" => [ 7, \&_action_opcode_1025 ], },
	# [3949] opcode : res "[inline_const]" 5 "," "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1026 ], ":" => [ 7, \&_action_opcode_1026 ], },
	# [3950] opcode : res "[inline_const]" 5 "," "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1027 ], ":" => [ 7, \&_action_opcode_1027 ], },
	# [3951] opcode : res "[inline_const]" 5 "," "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1028 ], ":" => [ 7, \&_action_opcode_1028 ], },
	# [3952] opcode : res "[inline_const]" 5 "," "(" iy
	{ ")" => 3953, "+" => 3962, "-" => 3973, },
	# [3953] opcode : res "[inline_const]" 5 "," "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_1029 ], "," => 3954, ":" => [ 7, \&_action_opcode_1029 ], },
	# [3954] opcode : res "[inline_const]" 5 "," "(" iy ")" ","
	{ a => 3955, b => 3956, c => 3957, d => 3958, e => 3959, h => 3960, l => 3961, },
	# [3955] opcode : res "[inline_const]" 5 "," "(" iy ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1030 ], ":" => [ 7, \&_action_opcode_1030 ], },
	# [3956] opcode : res "[inline_const]" 5 "," "(" iy ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1031 ], ":" => [ 7, \&_action_opcode_1031 ], },
	# [3957] opcode : res "[inline_const]" 5 "," "(" iy ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1032 ], ":" => [ 7, \&_action_opcode_1032 ], },
	# [3958] opcode : res "[inline_const]" 5 "," "(" iy ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1033 ], ":" => [ 7, \&_action_opcode_1033 ], },
	# [3959] opcode : res "[inline_const]" 5 "," "(" iy ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1034 ], ":" => [ 7, \&_action_opcode_1034 ], },
	# [3960] opcode : res "[inline_const]" 5 "," "(" iy ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1035 ], ":" => [ 7, \&_action_opcode_1035 ], },
	# [3961] opcode : res "[inline_const]" 5 "," "(" iy ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1036 ], ":" => [ 7, \&_action_opcode_1036 ], },
	# [3962] opcode : res "[inline_const]" 5 "," "(" iy "+"
	{ "!" => [ 12, 3963 ], "+" => [ 12, 3963 ], "-" => [ 12, 3963 ], __else__ => [ 12, 3963 ], "~" => [ 12, 3963 ], },
	# [3963] opcode : res "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]"
	{ ")" => 3964, },
	# [3964] opcode : res "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1037 ], "," => 3965, ":" => [ 7, \&_action_opcode_1037 ], },
	# [3965] opcode : res "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" ","
	{ a => 3966, b => 3967, c => 3968, d => 3969, e => 3970, h => 3971, l => 3972, },
	# [3966] opcode : res "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1038 ], ":" => [ 7, \&_action_opcode_1038 ], },
	# [3967] opcode : res "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1039 ], ":" => [ 7, \&_action_opcode_1039 ], },
	# [3968] opcode : res "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1040 ], ":" => [ 7, \&_action_opcode_1040 ], },
	# [3969] opcode : res "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1041 ], ":" => [ 7, \&_action_opcode_1041 ], },
	# [3970] opcode : res "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1042 ], ":" => [ 7, \&_action_opcode_1042 ], },
	# [3971] opcode : res "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1043 ], ":" => [ 7, \&_action_opcode_1043 ], },
	# [3972] opcode : res "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1044 ], ":" => [ 7, \&_action_opcode_1044 ], },
	# [3973] opcode : res "[inline_const]" 5 "," "(" iy "-"
	{ "!" => [ 14, 3974 ], "+" => [ 14, 3974 ], "-" => [ 14, 3974 ], __else__ => [ 14, 3974 ], "~" => [ 14, 3974 ], },
	# [3974] opcode : res "[inline_const]" 5 "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 3975, },
	# [3975] opcode : res "[inline_const]" 5 "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1037 ], "," => 3976, ":" => [ 7, \&_action_opcode_1037 ], },
	# [3976] opcode : res "[inline_const]" 5 "," "(" iy "-" "[expr_NDIS]" ")" ","
	{ a => 3977, b => 3978, c => 3979, d => 3980, e => 3981, h => 3982, l => 3983, },
	# [3977] opcode : res "[inline_const]" 5 "," "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1038 ], ":" => [ 7, \&_action_opcode_1038 ], },
	# [3978] opcode : res "[inline_const]" 5 "," "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1039 ], ":" => [ 7, \&_action_opcode_1039 ], },
	# [3979] opcode : res "[inline_const]" 5 "," "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1040 ], ":" => [ 7, \&_action_opcode_1040 ], },
	# [3980] opcode : res "[inline_const]" 5 "," "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1041 ], ":" => [ 7, \&_action_opcode_1041 ], },
	# [3981] opcode : res "[inline_const]" 5 "," "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1042 ], ":" => [ 7, \&_action_opcode_1042 ], },
	# [3982] opcode : res "[inline_const]" 5 "," "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1043 ], ":" => [ 7, \&_action_opcode_1043 ], },
	# [3983] opcode : res "[inline_const]" 5 "," "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1044 ], ":" => [ 7, \&_action_opcode_1044 ], },
	# [3984] opcode : res "[inline_const]" 5 "," "["
	{ hl => 3985, ix => 3987, iy => 4019, },
	# [3985] opcode : res "[inline_const]" 5 "," "[" hl
	{ "]" => 3986, },
	# [3986] opcode : res "[inline_const]" 5 "," "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_1012 ], ":" => [ 7, \&_action_opcode_1012 ], },
	# [3987] opcode : res "[inline_const]" 5 "," "[" ix
	{ "+" => 3988, "-" => 3999, "]" => 4010, },
	# [3988] opcode : res "[inline_const]" 5 "," "[" ix "+"
	{ "!" => [ 12, 3989 ], "+" => [ 12, 3989 ], "-" => [ 12, 3989 ], __else__ => [ 12, 3989 ], "~" => [ 12, 3989 ], },
	# [3989] opcode : res "[inline_const]" 5 "," "[" ix "+" "[expr_DIS]"
	{ "]" => 3990, },
	# [3990] opcode : res "[inline_const]" 5 "," "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1021 ], "," => 3991, ":" => [ 7, \&_action_opcode_1021 ], },
	# [3991] opcode : res "[inline_const]" 5 "," "[" ix "+" "[expr_DIS]" "]" ","
	{ a => 3992, b => 3993, c => 3994, d => 3995, e => 3996, h => 3997, l => 3998, },
	# [3992] opcode : res "[inline_const]" 5 "," "[" ix "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1022 ], ":" => [ 7, \&_action_opcode_1022 ], },
	# [3993] opcode : res "[inline_const]" 5 "," "[" ix "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1023 ], ":" => [ 7, \&_action_opcode_1023 ], },
	# [3994] opcode : res "[inline_const]" 5 "," "[" ix "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1024 ], ":" => [ 7, \&_action_opcode_1024 ], },
	# [3995] opcode : res "[inline_const]" 5 "," "[" ix "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1025 ], ":" => [ 7, \&_action_opcode_1025 ], },
	# [3996] opcode : res "[inline_const]" 5 "," "[" ix "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1026 ], ":" => [ 7, \&_action_opcode_1026 ], },
	# [3997] opcode : res "[inline_const]" 5 "," "[" ix "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1027 ], ":" => [ 7, \&_action_opcode_1027 ], },
	# [3998] opcode : res "[inline_const]" 5 "," "[" ix "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1028 ], ":" => [ 7, \&_action_opcode_1028 ], },
	# [3999] opcode : res "[inline_const]" 5 "," "[" ix "-"
	{ "!" => [ 14, 4000 ], "+" => [ 14, 4000 ], "-" => [ 14, 4000 ], __else__ => [ 14, 4000 ], "~" => [ 14, 4000 ], },
	# [4000] opcode : res "[inline_const]" 5 "," "[" ix "-" "[expr_NDIS]"
	{ "]" => 4001, },
	# [4001] opcode : res "[inline_const]" 5 "," "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1021 ], "," => 4002, ":" => [ 7, \&_action_opcode_1021 ], },
	# [4002] opcode : res "[inline_const]" 5 "," "[" ix "-" "[expr_NDIS]" "]" ","
	{ a => 4003, b => 4004, c => 4005, d => 4006, e => 4007, h => 4008, l => 4009, },
	# [4003] opcode : res "[inline_const]" 5 "," "[" ix "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1022 ], ":" => [ 7, \&_action_opcode_1022 ], },
	# [4004] opcode : res "[inline_const]" 5 "," "[" ix "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1023 ], ":" => [ 7, \&_action_opcode_1023 ], },
	# [4005] opcode : res "[inline_const]" 5 "," "[" ix "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1024 ], ":" => [ 7, \&_action_opcode_1024 ], },
	# [4006] opcode : res "[inline_const]" 5 "," "[" ix "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1025 ], ":" => [ 7, \&_action_opcode_1025 ], },
	# [4007] opcode : res "[inline_const]" 5 "," "[" ix "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1026 ], ":" => [ 7, \&_action_opcode_1026 ], },
	# [4008] opcode : res "[inline_const]" 5 "," "[" ix "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1027 ], ":" => [ 7, \&_action_opcode_1027 ], },
	# [4009] opcode : res "[inline_const]" 5 "," "[" ix "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1028 ], ":" => [ 7, \&_action_opcode_1028 ], },
	# [4010] opcode : res "[inline_const]" 5 "," "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_1013 ], "," => 4011, ":" => [ 7, \&_action_opcode_1013 ], },
	# [4011] opcode : res "[inline_const]" 5 "," "[" ix "]" ","
	{ a => 4012, b => 4013, c => 4014, d => 4015, e => 4016, h => 4017, l => 4018, },
	# [4012] opcode : res "[inline_const]" 5 "," "[" ix "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1014 ], ":" => [ 7, \&_action_opcode_1014 ], },
	# [4013] opcode : res "[inline_const]" 5 "," "[" ix "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1015 ], ":" => [ 7, \&_action_opcode_1015 ], },
	# [4014] opcode : res "[inline_const]" 5 "," "[" ix "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1016 ], ":" => [ 7, \&_action_opcode_1016 ], },
	# [4015] opcode : res "[inline_const]" 5 "," "[" ix "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1017 ], ":" => [ 7, \&_action_opcode_1017 ], },
	# [4016] opcode : res "[inline_const]" 5 "," "[" ix "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1018 ], ":" => [ 7, \&_action_opcode_1018 ], },
	# [4017] opcode : res "[inline_const]" 5 "," "[" ix "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1019 ], ":" => [ 7, \&_action_opcode_1019 ], },
	# [4018] opcode : res "[inline_const]" 5 "," "[" ix "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1020 ], ":" => [ 7, \&_action_opcode_1020 ], },
	# [4019] opcode : res "[inline_const]" 5 "," "[" iy
	{ "+" => 4020, "-" => 4031, "]" => 4042, },
	# [4020] opcode : res "[inline_const]" 5 "," "[" iy "+"
	{ "!" => [ 12, 4021 ], "+" => [ 12, 4021 ], "-" => [ 12, 4021 ], __else__ => [ 12, 4021 ], "~" => [ 12, 4021 ], },
	# [4021] opcode : res "[inline_const]" 5 "," "[" iy "+" "[expr_DIS]"
	{ "]" => 4022, },
	# [4022] opcode : res "[inline_const]" 5 "," "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1037 ], "," => 4023, ":" => [ 7, \&_action_opcode_1037 ], },
	# [4023] opcode : res "[inline_const]" 5 "," "[" iy "+" "[expr_DIS]" "]" ","
	{ a => 4024, b => 4025, c => 4026, d => 4027, e => 4028, h => 4029, l => 4030, },
	# [4024] opcode : res "[inline_const]" 5 "," "[" iy "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1038 ], ":" => [ 7, \&_action_opcode_1038 ], },
	# [4025] opcode : res "[inline_const]" 5 "," "[" iy "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1039 ], ":" => [ 7, \&_action_opcode_1039 ], },
	# [4026] opcode : res "[inline_const]" 5 "," "[" iy "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1040 ], ":" => [ 7, \&_action_opcode_1040 ], },
	# [4027] opcode : res "[inline_const]" 5 "," "[" iy "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1041 ], ":" => [ 7, \&_action_opcode_1041 ], },
	# [4028] opcode : res "[inline_const]" 5 "," "[" iy "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1042 ], ":" => [ 7, \&_action_opcode_1042 ], },
	# [4029] opcode : res "[inline_const]" 5 "," "[" iy "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1043 ], ":" => [ 7, \&_action_opcode_1043 ], },
	# [4030] opcode : res "[inline_const]" 5 "," "[" iy "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1044 ], ":" => [ 7, \&_action_opcode_1044 ], },
	# [4031] opcode : res "[inline_const]" 5 "," "[" iy "-"
	{ "!" => [ 14, 4032 ], "+" => [ 14, 4032 ], "-" => [ 14, 4032 ], __else__ => [ 14, 4032 ], "~" => [ 14, 4032 ], },
	# [4032] opcode : res "[inline_const]" 5 "," "[" iy "-" "[expr_NDIS]"
	{ "]" => 4033, },
	# [4033] opcode : res "[inline_const]" 5 "," "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1037 ], "," => 4034, ":" => [ 7, \&_action_opcode_1037 ], },
	# [4034] opcode : res "[inline_const]" 5 "," "[" iy "-" "[expr_NDIS]" "]" ","
	{ a => 4035, b => 4036, c => 4037, d => 4038, e => 4039, h => 4040, l => 4041, },
	# [4035] opcode : res "[inline_const]" 5 "," "[" iy "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1038 ], ":" => [ 7, \&_action_opcode_1038 ], },
	# [4036] opcode : res "[inline_const]" 5 "," "[" iy "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1039 ], ":" => [ 7, \&_action_opcode_1039 ], },
	# [4037] opcode : res "[inline_const]" 5 "," "[" iy "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1040 ], ":" => [ 7, \&_action_opcode_1040 ], },
	# [4038] opcode : res "[inline_const]" 5 "," "[" iy "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1041 ], ":" => [ 7, \&_action_opcode_1041 ], },
	# [4039] opcode : res "[inline_const]" 5 "," "[" iy "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1042 ], ":" => [ 7, \&_action_opcode_1042 ], },
	# [4040] opcode : res "[inline_const]" 5 "," "[" iy "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1043 ], ":" => [ 7, \&_action_opcode_1043 ], },
	# [4041] opcode : res "[inline_const]" 5 "," "[" iy "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1044 ], ":" => [ 7, \&_action_opcode_1044 ], },
	# [4042] opcode : res "[inline_const]" 5 "," "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_1029 ], "," => 4043, ":" => [ 7, \&_action_opcode_1029 ], },
	# [4043] opcode : res "[inline_const]" 5 "," "[" iy "]" ","
	{ a => 4044, b => 4045, c => 4046, d => 4047, e => 4048, h => 4049, l => 4050, },
	# [4044] opcode : res "[inline_const]" 5 "," "[" iy "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1030 ], ":" => [ 7, \&_action_opcode_1030 ], },
	# [4045] opcode : res "[inline_const]" 5 "," "[" iy "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1031 ], ":" => [ 7, \&_action_opcode_1031 ], },
	# [4046] opcode : res "[inline_const]" 5 "," "[" iy "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1032 ], ":" => [ 7, \&_action_opcode_1032 ], },
	# [4047] opcode : res "[inline_const]" 5 "," "[" iy "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1033 ], ":" => [ 7, \&_action_opcode_1033 ], },
	# [4048] opcode : res "[inline_const]" 5 "," "[" iy "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1034 ], ":" => [ 7, \&_action_opcode_1034 ], },
	# [4049] opcode : res "[inline_const]" 5 "," "[" iy "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1035 ], ":" => [ 7, \&_action_opcode_1035 ], },
	# [4050] opcode : res "[inline_const]" 5 "," "[" iy "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1036 ], ":" => [ 7, \&_action_opcode_1036 ], },
	# [4051] opcode : res "[inline_const]" 5 "," a
	{ "\n" => [ 7, \&_action_opcode_1045 ], ":" => [ 7, \&_action_opcode_1045 ], },
	# [4052] opcode : res "[inline_const]" 5 "," b
	{ "\n" => [ 7, \&_action_opcode_1046 ], ":" => [ 7, \&_action_opcode_1046 ], },
	# [4053] opcode : res "[inline_const]" 5 "," c
	{ "\n" => [ 7, \&_action_opcode_1047 ], ":" => [ 7, \&_action_opcode_1047 ], },
	# [4054] opcode : res "[inline_const]" 5 "," d
	{ "\n" => [ 7, \&_action_opcode_1048 ], ":" => [ 7, \&_action_opcode_1048 ], },
	# [4055] opcode : res "[inline_const]" 5 "," e
	{ "\n" => [ 7, \&_action_opcode_1049 ], ":" => [ 7, \&_action_opcode_1049 ], },
	# [4056] opcode : res "[inline_const]" 5 "," h
	{ "\n" => [ 7, \&_action_opcode_1050 ], ":" => [ 7, \&_action_opcode_1050 ], },
	# [4057] opcode : res "[inline_const]" 5 "," l
	{ "\n" => [ 7, \&_action_opcode_1051 ], ":" => [ 7, \&_action_opcode_1051 ], },
	# [4058] opcode : res "[inline_const]" 6
	{ "," => 4059, },
	# [4059] opcode : res "[inline_const]" 6 ","
	{ "(" => 4060, "[" => 4127, a => 4194, b => 4195, c => 4196, d => 4197, e => 4198, h => 4199, l => 4200, },
	# [4060] opcode : res "[inline_const]" 6 "," "("
	{ hl => 4061, ix => 4063, iy => 4095, },
	# [4061] opcode : res "[inline_const]" 6 "," "(" hl
	{ ")" => 4062, },
	# [4062] opcode : res "[inline_const]" 6 "," "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_1052 ], ":" => [ 7, \&_action_opcode_1052 ], },
	# [4063] opcode : res "[inline_const]" 6 "," "(" ix
	{ ")" => 4064, "+" => 4073, "-" => 4084, },
	# [4064] opcode : res "[inline_const]" 6 "," "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_1053 ], "," => 4065, ":" => [ 7, \&_action_opcode_1053 ], },
	# [4065] opcode : res "[inline_const]" 6 "," "(" ix ")" ","
	{ a => 4066, b => 4067, c => 4068, d => 4069, e => 4070, h => 4071, l => 4072, },
	# [4066] opcode : res "[inline_const]" 6 "," "(" ix ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1054 ], ":" => [ 7, \&_action_opcode_1054 ], },
	# [4067] opcode : res "[inline_const]" 6 "," "(" ix ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1055 ], ":" => [ 7, \&_action_opcode_1055 ], },
	# [4068] opcode : res "[inline_const]" 6 "," "(" ix ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1056 ], ":" => [ 7, \&_action_opcode_1056 ], },
	# [4069] opcode : res "[inline_const]" 6 "," "(" ix ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1057 ], ":" => [ 7, \&_action_opcode_1057 ], },
	# [4070] opcode : res "[inline_const]" 6 "," "(" ix ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1058 ], ":" => [ 7, \&_action_opcode_1058 ], },
	# [4071] opcode : res "[inline_const]" 6 "," "(" ix ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1059 ], ":" => [ 7, \&_action_opcode_1059 ], },
	# [4072] opcode : res "[inline_const]" 6 "," "(" ix ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1060 ], ":" => [ 7, \&_action_opcode_1060 ], },
	# [4073] opcode : res "[inline_const]" 6 "," "(" ix "+"
	{ "!" => [ 12, 4074 ], "+" => [ 12, 4074 ], "-" => [ 12, 4074 ], __else__ => [ 12, 4074 ], "~" => [ 12, 4074 ], },
	# [4074] opcode : res "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]"
	{ ")" => 4075, },
	# [4075] opcode : res "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1061 ], "," => 4076, ":" => [ 7, \&_action_opcode_1061 ], },
	# [4076] opcode : res "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" ","
	{ a => 4077, b => 4078, c => 4079, d => 4080, e => 4081, h => 4082, l => 4083, },
	# [4077] opcode : res "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1062 ], ":" => [ 7, \&_action_opcode_1062 ], },
	# [4078] opcode : res "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1063 ], ":" => [ 7, \&_action_opcode_1063 ], },
	# [4079] opcode : res "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1064 ], ":" => [ 7, \&_action_opcode_1064 ], },
	# [4080] opcode : res "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1065 ], ":" => [ 7, \&_action_opcode_1065 ], },
	# [4081] opcode : res "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1066 ], ":" => [ 7, \&_action_opcode_1066 ], },
	# [4082] opcode : res "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1067 ], ":" => [ 7, \&_action_opcode_1067 ], },
	# [4083] opcode : res "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1068 ], ":" => [ 7, \&_action_opcode_1068 ], },
	# [4084] opcode : res "[inline_const]" 6 "," "(" ix "-"
	{ "!" => [ 14, 4085 ], "+" => [ 14, 4085 ], "-" => [ 14, 4085 ], __else__ => [ 14, 4085 ], "~" => [ 14, 4085 ], },
	# [4085] opcode : res "[inline_const]" 6 "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 4086, },
	# [4086] opcode : res "[inline_const]" 6 "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1061 ], "," => 4087, ":" => [ 7, \&_action_opcode_1061 ], },
	# [4087] opcode : res "[inline_const]" 6 "," "(" ix "-" "[expr_NDIS]" ")" ","
	{ a => 4088, b => 4089, c => 4090, d => 4091, e => 4092, h => 4093, l => 4094, },
	# [4088] opcode : res "[inline_const]" 6 "," "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1062 ], ":" => [ 7, \&_action_opcode_1062 ], },
	# [4089] opcode : res "[inline_const]" 6 "," "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1063 ], ":" => [ 7, \&_action_opcode_1063 ], },
	# [4090] opcode : res "[inline_const]" 6 "," "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1064 ], ":" => [ 7, \&_action_opcode_1064 ], },
	# [4091] opcode : res "[inline_const]" 6 "," "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1065 ], ":" => [ 7, \&_action_opcode_1065 ], },
	# [4092] opcode : res "[inline_const]" 6 "," "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1066 ], ":" => [ 7, \&_action_opcode_1066 ], },
	# [4093] opcode : res "[inline_const]" 6 "," "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1067 ], ":" => [ 7, \&_action_opcode_1067 ], },
	# [4094] opcode : res "[inline_const]" 6 "," "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1068 ], ":" => [ 7, \&_action_opcode_1068 ], },
	# [4095] opcode : res "[inline_const]" 6 "," "(" iy
	{ ")" => 4096, "+" => 4105, "-" => 4116, },
	# [4096] opcode : res "[inline_const]" 6 "," "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_1069 ], "," => 4097, ":" => [ 7, \&_action_opcode_1069 ], },
	# [4097] opcode : res "[inline_const]" 6 "," "(" iy ")" ","
	{ a => 4098, b => 4099, c => 4100, d => 4101, e => 4102, h => 4103, l => 4104, },
	# [4098] opcode : res "[inline_const]" 6 "," "(" iy ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1070 ], ":" => [ 7, \&_action_opcode_1070 ], },
	# [4099] opcode : res "[inline_const]" 6 "," "(" iy ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1071 ], ":" => [ 7, \&_action_opcode_1071 ], },
	# [4100] opcode : res "[inline_const]" 6 "," "(" iy ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1072 ], ":" => [ 7, \&_action_opcode_1072 ], },
	# [4101] opcode : res "[inline_const]" 6 "," "(" iy ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1073 ], ":" => [ 7, \&_action_opcode_1073 ], },
	# [4102] opcode : res "[inline_const]" 6 "," "(" iy ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1074 ], ":" => [ 7, \&_action_opcode_1074 ], },
	# [4103] opcode : res "[inline_const]" 6 "," "(" iy ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1075 ], ":" => [ 7, \&_action_opcode_1075 ], },
	# [4104] opcode : res "[inline_const]" 6 "," "(" iy ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1076 ], ":" => [ 7, \&_action_opcode_1076 ], },
	# [4105] opcode : res "[inline_const]" 6 "," "(" iy "+"
	{ "!" => [ 12, 4106 ], "+" => [ 12, 4106 ], "-" => [ 12, 4106 ], __else__ => [ 12, 4106 ], "~" => [ 12, 4106 ], },
	# [4106] opcode : res "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]"
	{ ")" => 4107, },
	# [4107] opcode : res "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1077 ], "," => 4108, ":" => [ 7, \&_action_opcode_1077 ], },
	# [4108] opcode : res "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" ","
	{ a => 4109, b => 4110, c => 4111, d => 4112, e => 4113, h => 4114, l => 4115, },
	# [4109] opcode : res "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1078 ], ":" => [ 7, \&_action_opcode_1078 ], },
	# [4110] opcode : res "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1079 ], ":" => [ 7, \&_action_opcode_1079 ], },
	# [4111] opcode : res "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1080 ], ":" => [ 7, \&_action_opcode_1080 ], },
	# [4112] opcode : res "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1081 ], ":" => [ 7, \&_action_opcode_1081 ], },
	# [4113] opcode : res "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1082 ], ":" => [ 7, \&_action_opcode_1082 ], },
	# [4114] opcode : res "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1083 ], ":" => [ 7, \&_action_opcode_1083 ], },
	# [4115] opcode : res "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1084 ], ":" => [ 7, \&_action_opcode_1084 ], },
	# [4116] opcode : res "[inline_const]" 6 "," "(" iy "-"
	{ "!" => [ 14, 4117 ], "+" => [ 14, 4117 ], "-" => [ 14, 4117 ], __else__ => [ 14, 4117 ], "~" => [ 14, 4117 ], },
	# [4117] opcode : res "[inline_const]" 6 "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 4118, },
	# [4118] opcode : res "[inline_const]" 6 "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1077 ], "," => 4119, ":" => [ 7, \&_action_opcode_1077 ], },
	# [4119] opcode : res "[inline_const]" 6 "," "(" iy "-" "[expr_NDIS]" ")" ","
	{ a => 4120, b => 4121, c => 4122, d => 4123, e => 4124, h => 4125, l => 4126, },
	# [4120] opcode : res "[inline_const]" 6 "," "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1078 ], ":" => [ 7, \&_action_opcode_1078 ], },
	# [4121] opcode : res "[inline_const]" 6 "," "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1079 ], ":" => [ 7, \&_action_opcode_1079 ], },
	# [4122] opcode : res "[inline_const]" 6 "," "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1080 ], ":" => [ 7, \&_action_opcode_1080 ], },
	# [4123] opcode : res "[inline_const]" 6 "," "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1081 ], ":" => [ 7, \&_action_opcode_1081 ], },
	# [4124] opcode : res "[inline_const]" 6 "," "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1082 ], ":" => [ 7, \&_action_opcode_1082 ], },
	# [4125] opcode : res "[inline_const]" 6 "," "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1083 ], ":" => [ 7, \&_action_opcode_1083 ], },
	# [4126] opcode : res "[inline_const]" 6 "," "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1084 ], ":" => [ 7, \&_action_opcode_1084 ], },
	# [4127] opcode : res "[inline_const]" 6 "," "["
	{ hl => 4128, ix => 4130, iy => 4162, },
	# [4128] opcode : res "[inline_const]" 6 "," "[" hl
	{ "]" => 4129, },
	# [4129] opcode : res "[inline_const]" 6 "," "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_1052 ], ":" => [ 7, \&_action_opcode_1052 ], },
	# [4130] opcode : res "[inline_const]" 6 "," "[" ix
	{ "+" => 4131, "-" => 4142, "]" => 4153, },
	# [4131] opcode : res "[inline_const]" 6 "," "[" ix "+"
	{ "!" => [ 12, 4132 ], "+" => [ 12, 4132 ], "-" => [ 12, 4132 ], __else__ => [ 12, 4132 ], "~" => [ 12, 4132 ], },
	# [4132] opcode : res "[inline_const]" 6 "," "[" ix "+" "[expr_DIS]"
	{ "]" => 4133, },
	# [4133] opcode : res "[inline_const]" 6 "," "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1061 ], "," => 4134, ":" => [ 7, \&_action_opcode_1061 ], },
	# [4134] opcode : res "[inline_const]" 6 "," "[" ix "+" "[expr_DIS]" "]" ","
	{ a => 4135, b => 4136, c => 4137, d => 4138, e => 4139, h => 4140, l => 4141, },
	# [4135] opcode : res "[inline_const]" 6 "," "[" ix "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1062 ], ":" => [ 7, \&_action_opcode_1062 ], },
	# [4136] opcode : res "[inline_const]" 6 "," "[" ix "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1063 ], ":" => [ 7, \&_action_opcode_1063 ], },
	# [4137] opcode : res "[inline_const]" 6 "," "[" ix "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1064 ], ":" => [ 7, \&_action_opcode_1064 ], },
	# [4138] opcode : res "[inline_const]" 6 "," "[" ix "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1065 ], ":" => [ 7, \&_action_opcode_1065 ], },
	# [4139] opcode : res "[inline_const]" 6 "," "[" ix "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1066 ], ":" => [ 7, \&_action_opcode_1066 ], },
	# [4140] opcode : res "[inline_const]" 6 "," "[" ix "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1067 ], ":" => [ 7, \&_action_opcode_1067 ], },
	# [4141] opcode : res "[inline_const]" 6 "," "[" ix "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1068 ], ":" => [ 7, \&_action_opcode_1068 ], },
	# [4142] opcode : res "[inline_const]" 6 "," "[" ix "-"
	{ "!" => [ 14, 4143 ], "+" => [ 14, 4143 ], "-" => [ 14, 4143 ], __else__ => [ 14, 4143 ], "~" => [ 14, 4143 ], },
	# [4143] opcode : res "[inline_const]" 6 "," "[" ix "-" "[expr_NDIS]"
	{ "]" => 4144, },
	# [4144] opcode : res "[inline_const]" 6 "," "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1061 ], "," => 4145, ":" => [ 7, \&_action_opcode_1061 ], },
	# [4145] opcode : res "[inline_const]" 6 "," "[" ix "-" "[expr_NDIS]" "]" ","
	{ a => 4146, b => 4147, c => 4148, d => 4149, e => 4150, h => 4151, l => 4152, },
	# [4146] opcode : res "[inline_const]" 6 "," "[" ix "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1062 ], ":" => [ 7, \&_action_opcode_1062 ], },
	# [4147] opcode : res "[inline_const]" 6 "," "[" ix "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1063 ], ":" => [ 7, \&_action_opcode_1063 ], },
	# [4148] opcode : res "[inline_const]" 6 "," "[" ix "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1064 ], ":" => [ 7, \&_action_opcode_1064 ], },
	# [4149] opcode : res "[inline_const]" 6 "," "[" ix "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1065 ], ":" => [ 7, \&_action_opcode_1065 ], },
	# [4150] opcode : res "[inline_const]" 6 "," "[" ix "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1066 ], ":" => [ 7, \&_action_opcode_1066 ], },
	# [4151] opcode : res "[inline_const]" 6 "," "[" ix "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1067 ], ":" => [ 7, \&_action_opcode_1067 ], },
	# [4152] opcode : res "[inline_const]" 6 "," "[" ix "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1068 ], ":" => [ 7, \&_action_opcode_1068 ], },
	# [4153] opcode : res "[inline_const]" 6 "," "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_1053 ], "," => 4154, ":" => [ 7, \&_action_opcode_1053 ], },
	# [4154] opcode : res "[inline_const]" 6 "," "[" ix "]" ","
	{ a => 4155, b => 4156, c => 4157, d => 4158, e => 4159, h => 4160, l => 4161, },
	# [4155] opcode : res "[inline_const]" 6 "," "[" ix "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1054 ], ":" => [ 7, \&_action_opcode_1054 ], },
	# [4156] opcode : res "[inline_const]" 6 "," "[" ix "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1055 ], ":" => [ 7, \&_action_opcode_1055 ], },
	# [4157] opcode : res "[inline_const]" 6 "," "[" ix "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1056 ], ":" => [ 7, \&_action_opcode_1056 ], },
	# [4158] opcode : res "[inline_const]" 6 "," "[" ix "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1057 ], ":" => [ 7, \&_action_opcode_1057 ], },
	# [4159] opcode : res "[inline_const]" 6 "," "[" ix "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1058 ], ":" => [ 7, \&_action_opcode_1058 ], },
	# [4160] opcode : res "[inline_const]" 6 "," "[" ix "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1059 ], ":" => [ 7, \&_action_opcode_1059 ], },
	# [4161] opcode : res "[inline_const]" 6 "," "[" ix "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1060 ], ":" => [ 7, \&_action_opcode_1060 ], },
	# [4162] opcode : res "[inline_const]" 6 "," "[" iy
	{ "+" => 4163, "-" => 4174, "]" => 4185, },
	# [4163] opcode : res "[inline_const]" 6 "," "[" iy "+"
	{ "!" => [ 12, 4164 ], "+" => [ 12, 4164 ], "-" => [ 12, 4164 ], __else__ => [ 12, 4164 ], "~" => [ 12, 4164 ], },
	# [4164] opcode : res "[inline_const]" 6 "," "[" iy "+" "[expr_DIS]"
	{ "]" => 4165, },
	# [4165] opcode : res "[inline_const]" 6 "," "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1077 ], "," => 4166, ":" => [ 7, \&_action_opcode_1077 ], },
	# [4166] opcode : res "[inline_const]" 6 "," "[" iy "+" "[expr_DIS]" "]" ","
	{ a => 4167, b => 4168, c => 4169, d => 4170, e => 4171, h => 4172, l => 4173, },
	# [4167] opcode : res "[inline_const]" 6 "," "[" iy "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1078 ], ":" => [ 7, \&_action_opcode_1078 ], },
	# [4168] opcode : res "[inline_const]" 6 "," "[" iy "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1079 ], ":" => [ 7, \&_action_opcode_1079 ], },
	# [4169] opcode : res "[inline_const]" 6 "," "[" iy "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1080 ], ":" => [ 7, \&_action_opcode_1080 ], },
	# [4170] opcode : res "[inline_const]" 6 "," "[" iy "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1081 ], ":" => [ 7, \&_action_opcode_1081 ], },
	# [4171] opcode : res "[inline_const]" 6 "," "[" iy "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1082 ], ":" => [ 7, \&_action_opcode_1082 ], },
	# [4172] opcode : res "[inline_const]" 6 "," "[" iy "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1083 ], ":" => [ 7, \&_action_opcode_1083 ], },
	# [4173] opcode : res "[inline_const]" 6 "," "[" iy "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1084 ], ":" => [ 7, \&_action_opcode_1084 ], },
	# [4174] opcode : res "[inline_const]" 6 "," "[" iy "-"
	{ "!" => [ 14, 4175 ], "+" => [ 14, 4175 ], "-" => [ 14, 4175 ], __else__ => [ 14, 4175 ], "~" => [ 14, 4175 ], },
	# [4175] opcode : res "[inline_const]" 6 "," "[" iy "-" "[expr_NDIS]"
	{ "]" => 4176, },
	# [4176] opcode : res "[inline_const]" 6 "," "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1077 ], "," => 4177, ":" => [ 7, \&_action_opcode_1077 ], },
	# [4177] opcode : res "[inline_const]" 6 "," "[" iy "-" "[expr_NDIS]" "]" ","
	{ a => 4178, b => 4179, c => 4180, d => 4181, e => 4182, h => 4183, l => 4184, },
	# [4178] opcode : res "[inline_const]" 6 "," "[" iy "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1078 ], ":" => [ 7, \&_action_opcode_1078 ], },
	# [4179] opcode : res "[inline_const]" 6 "," "[" iy "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1079 ], ":" => [ 7, \&_action_opcode_1079 ], },
	# [4180] opcode : res "[inline_const]" 6 "," "[" iy "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1080 ], ":" => [ 7, \&_action_opcode_1080 ], },
	# [4181] opcode : res "[inline_const]" 6 "," "[" iy "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1081 ], ":" => [ 7, \&_action_opcode_1081 ], },
	# [4182] opcode : res "[inline_const]" 6 "," "[" iy "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1082 ], ":" => [ 7, \&_action_opcode_1082 ], },
	# [4183] opcode : res "[inline_const]" 6 "," "[" iy "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1083 ], ":" => [ 7, \&_action_opcode_1083 ], },
	# [4184] opcode : res "[inline_const]" 6 "," "[" iy "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1084 ], ":" => [ 7, \&_action_opcode_1084 ], },
	# [4185] opcode : res "[inline_const]" 6 "," "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_1069 ], "," => 4186, ":" => [ 7, \&_action_opcode_1069 ], },
	# [4186] opcode : res "[inline_const]" 6 "," "[" iy "]" ","
	{ a => 4187, b => 4188, c => 4189, d => 4190, e => 4191, h => 4192, l => 4193, },
	# [4187] opcode : res "[inline_const]" 6 "," "[" iy "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1070 ], ":" => [ 7, \&_action_opcode_1070 ], },
	# [4188] opcode : res "[inline_const]" 6 "," "[" iy "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1071 ], ":" => [ 7, \&_action_opcode_1071 ], },
	# [4189] opcode : res "[inline_const]" 6 "," "[" iy "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1072 ], ":" => [ 7, \&_action_opcode_1072 ], },
	# [4190] opcode : res "[inline_const]" 6 "," "[" iy "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1073 ], ":" => [ 7, \&_action_opcode_1073 ], },
	# [4191] opcode : res "[inline_const]" 6 "," "[" iy "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1074 ], ":" => [ 7, \&_action_opcode_1074 ], },
	# [4192] opcode : res "[inline_const]" 6 "," "[" iy "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1075 ], ":" => [ 7, \&_action_opcode_1075 ], },
	# [4193] opcode : res "[inline_const]" 6 "," "[" iy "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1076 ], ":" => [ 7, \&_action_opcode_1076 ], },
	# [4194] opcode : res "[inline_const]" 6 "," a
	{ "\n" => [ 7, \&_action_opcode_1085 ], ":" => [ 7, \&_action_opcode_1085 ], },
	# [4195] opcode : res "[inline_const]" 6 "," b
	{ "\n" => [ 7, \&_action_opcode_1086 ], ":" => [ 7, \&_action_opcode_1086 ], },
	# [4196] opcode : res "[inline_const]" 6 "," c
	{ "\n" => [ 7, \&_action_opcode_1087 ], ":" => [ 7, \&_action_opcode_1087 ], },
	# [4197] opcode : res "[inline_const]" 6 "," d
	{ "\n" => [ 7, \&_action_opcode_1088 ], ":" => [ 7, \&_action_opcode_1088 ], },
	# [4198] opcode : res "[inline_const]" 6 "," e
	{ "\n" => [ 7, \&_action_opcode_1089 ], ":" => [ 7, \&_action_opcode_1089 ], },
	# [4199] opcode : res "[inline_const]" 6 "," h
	{ "\n" => [ 7, \&_action_opcode_1090 ], ":" => [ 7, \&_action_opcode_1090 ], },
	# [4200] opcode : res "[inline_const]" 6 "," l
	{ "\n" => [ 7, \&_action_opcode_1091 ], ":" => [ 7, \&_action_opcode_1091 ], },
	# [4201] opcode : res "[inline_const]" 7
	{ "," => 4202, },
	# [4202] opcode : res "[inline_const]" 7 ","
	{ "(" => 4203, "[" => 4270, a => 4337, b => 4338, c => 4339, d => 4340, e => 4341, h => 4342, l => 4343, },
	# [4203] opcode : res "[inline_const]" 7 "," "("
	{ hl => 4204, ix => 4206, iy => 4238, },
	# [4204] opcode : res "[inline_const]" 7 "," "(" hl
	{ ")" => 4205, },
	# [4205] opcode : res "[inline_const]" 7 "," "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_1092 ], ":" => [ 7, \&_action_opcode_1092 ], },
	# [4206] opcode : res "[inline_const]" 7 "," "(" ix
	{ ")" => 4207, "+" => 4216, "-" => 4227, },
	# [4207] opcode : res "[inline_const]" 7 "," "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_1093 ], "," => 4208, ":" => [ 7, \&_action_opcode_1093 ], },
	# [4208] opcode : res "[inline_const]" 7 "," "(" ix ")" ","
	{ a => 4209, b => 4210, c => 4211, d => 4212, e => 4213, h => 4214, l => 4215, },
	# [4209] opcode : res "[inline_const]" 7 "," "(" ix ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1094 ], ":" => [ 7, \&_action_opcode_1094 ], },
	# [4210] opcode : res "[inline_const]" 7 "," "(" ix ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1095 ], ":" => [ 7, \&_action_opcode_1095 ], },
	# [4211] opcode : res "[inline_const]" 7 "," "(" ix ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1096 ], ":" => [ 7, \&_action_opcode_1096 ], },
	# [4212] opcode : res "[inline_const]" 7 "," "(" ix ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1097 ], ":" => [ 7, \&_action_opcode_1097 ], },
	# [4213] opcode : res "[inline_const]" 7 "," "(" ix ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1098 ], ":" => [ 7, \&_action_opcode_1098 ], },
	# [4214] opcode : res "[inline_const]" 7 "," "(" ix ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1099 ], ":" => [ 7, \&_action_opcode_1099 ], },
	# [4215] opcode : res "[inline_const]" 7 "," "(" ix ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1100 ], ":" => [ 7, \&_action_opcode_1100 ], },
	# [4216] opcode : res "[inline_const]" 7 "," "(" ix "+"
	{ "!" => [ 12, 4217 ], "+" => [ 12, 4217 ], "-" => [ 12, 4217 ], __else__ => [ 12, 4217 ], "~" => [ 12, 4217 ], },
	# [4217] opcode : res "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]"
	{ ")" => 4218, },
	# [4218] opcode : res "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1101 ], "," => 4219, ":" => [ 7, \&_action_opcode_1101 ], },
	# [4219] opcode : res "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" ","
	{ a => 4220, b => 4221, c => 4222, d => 4223, e => 4224, h => 4225, l => 4226, },
	# [4220] opcode : res "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1102 ], ":" => [ 7, \&_action_opcode_1102 ], },
	# [4221] opcode : res "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1103 ], ":" => [ 7, \&_action_opcode_1103 ], },
	# [4222] opcode : res "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1104 ], ":" => [ 7, \&_action_opcode_1104 ], },
	# [4223] opcode : res "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1105 ], ":" => [ 7, \&_action_opcode_1105 ], },
	# [4224] opcode : res "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1106 ], ":" => [ 7, \&_action_opcode_1106 ], },
	# [4225] opcode : res "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1107 ], ":" => [ 7, \&_action_opcode_1107 ], },
	# [4226] opcode : res "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1108 ], ":" => [ 7, \&_action_opcode_1108 ], },
	# [4227] opcode : res "[inline_const]" 7 "," "(" ix "-"
	{ "!" => [ 14, 4228 ], "+" => [ 14, 4228 ], "-" => [ 14, 4228 ], __else__ => [ 14, 4228 ], "~" => [ 14, 4228 ], },
	# [4228] opcode : res "[inline_const]" 7 "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 4229, },
	# [4229] opcode : res "[inline_const]" 7 "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1101 ], "," => 4230, ":" => [ 7, \&_action_opcode_1101 ], },
	# [4230] opcode : res "[inline_const]" 7 "," "(" ix "-" "[expr_NDIS]" ")" ","
	{ a => 4231, b => 4232, c => 4233, d => 4234, e => 4235, h => 4236, l => 4237, },
	# [4231] opcode : res "[inline_const]" 7 "," "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1102 ], ":" => [ 7, \&_action_opcode_1102 ], },
	# [4232] opcode : res "[inline_const]" 7 "," "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1103 ], ":" => [ 7, \&_action_opcode_1103 ], },
	# [4233] opcode : res "[inline_const]" 7 "," "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1104 ], ":" => [ 7, \&_action_opcode_1104 ], },
	# [4234] opcode : res "[inline_const]" 7 "," "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1105 ], ":" => [ 7, \&_action_opcode_1105 ], },
	# [4235] opcode : res "[inline_const]" 7 "," "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1106 ], ":" => [ 7, \&_action_opcode_1106 ], },
	# [4236] opcode : res "[inline_const]" 7 "," "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1107 ], ":" => [ 7, \&_action_opcode_1107 ], },
	# [4237] opcode : res "[inline_const]" 7 "," "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1108 ], ":" => [ 7, \&_action_opcode_1108 ], },
	# [4238] opcode : res "[inline_const]" 7 "," "(" iy
	{ ")" => 4239, "+" => 4248, "-" => 4259, },
	# [4239] opcode : res "[inline_const]" 7 "," "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_1109 ], "," => 4240, ":" => [ 7, \&_action_opcode_1109 ], },
	# [4240] opcode : res "[inline_const]" 7 "," "(" iy ")" ","
	{ a => 4241, b => 4242, c => 4243, d => 4244, e => 4245, h => 4246, l => 4247, },
	# [4241] opcode : res "[inline_const]" 7 "," "(" iy ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1110 ], ":" => [ 7, \&_action_opcode_1110 ], },
	# [4242] opcode : res "[inline_const]" 7 "," "(" iy ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1111 ], ":" => [ 7, \&_action_opcode_1111 ], },
	# [4243] opcode : res "[inline_const]" 7 "," "(" iy ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1112 ], ":" => [ 7, \&_action_opcode_1112 ], },
	# [4244] opcode : res "[inline_const]" 7 "," "(" iy ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1113 ], ":" => [ 7, \&_action_opcode_1113 ], },
	# [4245] opcode : res "[inline_const]" 7 "," "(" iy ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1114 ], ":" => [ 7, \&_action_opcode_1114 ], },
	# [4246] opcode : res "[inline_const]" 7 "," "(" iy ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1115 ], ":" => [ 7, \&_action_opcode_1115 ], },
	# [4247] opcode : res "[inline_const]" 7 "," "(" iy ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1116 ], ":" => [ 7, \&_action_opcode_1116 ], },
	# [4248] opcode : res "[inline_const]" 7 "," "(" iy "+"
	{ "!" => [ 12, 4249 ], "+" => [ 12, 4249 ], "-" => [ 12, 4249 ], __else__ => [ 12, 4249 ], "~" => [ 12, 4249 ], },
	# [4249] opcode : res "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]"
	{ ")" => 4250, },
	# [4250] opcode : res "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1117 ], "," => 4251, ":" => [ 7, \&_action_opcode_1117 ], },
	# [4251] opcode : res "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" ","
	{ a => 4252, b => 4253, c => 4254, d => 4255, e => 4256, h => 4257, l => 4258, },
	# [4252] opcode : res "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1118 ], ":" => [ 7, \&_action_opcode_1118 ], },
	# [4253] opcode : res "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1119 ], ":" => [ 7, \&_action_opcode_1119 ], },
	# [4254] opcode : res "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1120 ], ":" => [ 7, \&_action_opcode_1120 ], },
	# [4255] opcode : res "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1121 ], ":" => [ 7, \&_action_opcode_1121 ], },
	# [4256] opcode : res "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1122 ], ":" => [ 7, \&_action_opcode_1122 ], },
	# [4257] opcode : res "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1123 ], ":" => [ 7, \&_action_opcode_1123 ], },
	# [4258] opcode : res "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1124 ], ":" => [ 7, \&_action_opcode_1124 ], },
	# [4259] opcode : res "[inline_const]" 7 "," "(" iy "-"
	{ "!" => [ 14, 4260 ], "+" => [ 14, 4260 ], "-" => [ 14, 4260 ], __else__ => [ 14, 4260 ], "~" => [ 14, 4260 ], },
	# [4260] opcode : res "[inline_const]" 7 "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 4261, },
	# [4261] opcode : res "[inline_const]" 7 "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1117 ], "," => 4262, ":" => [ 7, \&_action_opcode_1117 ], },
	# [4262] opcode : res "[inline_const]" 7 "," "(" iy "-" "[expr_NDIS]" ")" ","
	{ a => 4263, b => 4264, c => 4265, d => 4266, e => 4267, h => 4268, l => 4269, },
	# [4263] opcode : res "[inline_const]" 7 "," "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1118 ], ":" => [ 7, \&_action_opcode_1118 ], },
	# [4264] opcode : res "[inline_const]" 7 "," "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1119 ], ":" => [ 7, \&_action_opcode_1119 ], },
	# [4265] opcode : res "[inline_const]" 7 "," "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1120 ], ":" => [ 7, \&_action_opcode_1120 ], },
	# [4266] opcode : res "[inline_const]" 7 "," "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1121 ], ":" => [ 7, \&_action_opcode_1121 ], },
	# [4267] opcode : res "[inline_const]" 7 "," "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1122 ], ":" => [ 7, \&_action_opcode_1122 ], },
	# [4268] opcode : res "[inline_const]" 7 "," "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1123 ], ":" => [ 7, \&_action_opcode_1123 ], },
	# [4269] opcode : res "[inline_const]" 7 "," "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1124 ], ":" => [ 7, \&_action_opcode_1124 ], },
	# [4270] opcode : res "[inline_const]" 7 "," "["
	{ hl => 4271, ix => 4273, iy => 4305, },
	# [4271] opcode : res "[inline_const]" 7 "," "[" hl
	{ "]" => 4272, },
	# [4272] opcode : res "[inline_const]" 7 "," "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_1092 ], ":" => [ 7, \&_action_opcode_1092 ], },
	# [4273] opcode : res "[inline_const]" 7 "," "[" ix
	{ "+" => 4274, "-" => 4285, "]" => 4296, },
	# [4274] opcode : res "[inline_const]" 7 "," "[" ix "+"
	{ "!" => [ 12, 4275 ], "+" => [ 12, 4275 ], "-" => [ 12, 4275 ], __else__ => [ 12, 4275 ], "~" => [ 12, 4275 ], },
	# [4275] opcode : res "[inline_const]" 7 "," "[" ix "+" "[expr_DIS]"
	{ "]" => 4276, },
	# [4276] opcode : res "[inline_const]" 7 "," "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1101 ], "," => 4277, ":" => [ 7, \&_action_opcode_1101 ], },
	# [4277] opcode : res "[inline_const]" 7 "," "[" ix "+" "[expr_DIS]" "]" ","
	{ a => 4278, b => 4279, c => 4280, d => 4281, e => 4282, h => 4283, l => 4284, },
	# [4278] opcode : res "[inline_const]" 7 "," "[" ix "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1102 ], ":" => [ 7, \&_action_opcode_1102 ], },
	# [4279] opcode : res "[inline_const]" 7 "," "[" ix "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1103 ], ":" => [ 7, \&_action_opcode_1103 ], },
	# [4280] opcode : res "[inline_const]" 7 "," "[" ix "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1104 ], ":" => [ 7, \&_action_opcode_1104 ], },
	# [4281] opcode : res "[inline_const]" 7 "," "[" ix "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1105 ], ":" => [ 7, \&_action_opcode_1105 ], },
	# [4282] opcode : res "[inline_const]" 7 "," "[" ix "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1106 ], ":" => [ 7, \&_action_opcode_1106 ], },
	# [4283] opcode : res "[inline_const]" 7 "," "[" ix "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1107 ], ":" => [ 7, \&_action_opcode_1107 ], },
	# [4284] opcode : res "[inline_const]" 7 "," "[" ix "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1108 ], ":" => [ 7, \&_action_opcode_1108 ], },
	# [4285] opcode : res "[inline_const]" 7 "," "[" ix "-"
	{ "!" => [ 14, 4286 ], "+" => [ 14, 4286 ], "-" => [ 14, 4286 ], __else__ => [ 14, 4286 ], "~" => [ 14, 4286 ], },
	# [4286] opcode : res "[inline_const]" 7 "," "[" ix "-" "[expr_NDIS]"
	{ "]" => 4287, },
	# [4287] opcode : res "[inline_const]" 7 "," "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1101 ], "," => 4288, ":" => [ 7, \&_action_opcode_1101 ], },
	# [4288] opcode : res "[inline_const]" 7 "," "[" ix "-" "[expr_NDIS]" "]" ","
	{ a => 4289, b => 4290, c => 4291, d => 4292, e => 4293, h => 4294, l => 4295, },
	# [4289] opcode : res "[inline_const]" 7 "," "[" ix "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1102 ], ":" => [ 7, \&_action_opcode_1102 ], },
	# [4290] opcode : res "[inline_const]" 7 "," "[" ix "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1103 ], ":" => [ 7, \&_action_opcode_1103 ], },
	# [4291] opcode : res "[inline_const]" 7 "," "[" ix "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1104 ], ":" => [ 7, \&_action_opcode_1104 ], },
	# [4292] opcode : res "[inline_const]" 7 "," "[" ix "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1105 ], ":" => [ 7, \&_action_opcode_1105 ], },
	# [4293] opcode : res "[inline_const]" 7 "," "[" ix "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1106 ], ":" => [ 7, \&_action_opcode_1106 ], },
	# [4294] opcode : res "[inline_const]" 7 "," "[" ix "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1107 ], ":" => [ 7, \&_action_opcode_1107 ], },
	# [4295] opcode : res "[inline_const]" 7 "," "[" ix "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1108 ], ":" => [ 7, \&_action_opcode_1108 ], },
	# [4296] opcode : res "[inline_const]" 7 "," "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_1093 ], "," => 4297, ":" => [ 7, \&_action_opcode_1093 ], },
	# [4297] opcode : res "[inline_const]" 7 "," "[" ix "]" ","
	{ a => 4298, b => 4299, c => 4300, d => 4301, e => 4302, h => 4303, l => 4304, },
	# [4298] opcode : res "[inline_const]" 7 "," "[" ix "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1094 ], ":" => [ 7, \&_action_opcode_1094 ], },
	# [4299] opcode : res "[inline_const]" 7 "," "[" ix "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1095 ], ":" => [ 7, \&_action_opcode_1095 ], },
	# [4300] opcode : res "[inline_const]" 7 "," "[" ix "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1096 ], ":" => [ 7, \&_action_opcode_1096 ], },
	# [4301] opcode : res "[inline_const]" 7 "," "[" ix "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1097 ], ":" => [ 7, \&_action_opcode_1097 ], },
	# [4302] opcode : res "[inline_const]" 7 "," "[" ix "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1098 ], ":" => [ 7, \&_action_opcode_1098 ], },
	# [4303] opcode : res "[inline_const]" 7 "," "[" ix "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1099 ], ":" => [ 7, \&_action_opcode_1099 ], },
	# [4304] opcode : res "[inline_const]" 7 "," "[" ix "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1100 ], ":" => [ 7, \&_action_opcode_1100 ], },
	# [4305] opcode : res "[inline_const]" 7 "," "[" iy
	{ "+" => 4306, "-" => 4317, "]" => 4328, },
	# [4306] opcode : res "[inline_const]" 7 "," "[" iy "+"
	{ "!" => [ 12, 4307 ], "+" => [ 12, 4307 ], "-" => [ 12, 4307 ], __else__ => [ 12, 4307 ], "~" => [ 12, 4307 ], },
	# [4307] opcode : res "[inline_const]" 7 "," "[" iy "+" "[expr_DIS]"
	{ "]" => 4308, },
	# [4308] opcode : res "[inline_const]" 7 "," "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1117 ], "," => 4309, ":" => [ 7, \&_action_opcode_1117 ], },
	# [4309] opcode : res "[inline_const]" 7 "," "[" iy "+" "[expr_DIS]" "]" ","
	{ a => 4310, b => 4311, c => 4312, d => 4313, e => 4314, h => 4315, l => 4316, },
	# [4310] opcode : res "[inline_const]" 7 "," "[" iy "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1118 ], ":" => [ 7, \&_action_opcode_1118 ], },
	# [4311] opcode : res "[inline_const]" 7 "," "[" iy "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1119 ], ":" => [ 7, \&_action_opcode_1119 ], },
	# [4312] opcode : res "[inline_const]" 7 "," "[" iy "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1120 ], ":" => [ 7, \&_action_opcode_1120 ], },
	# [4313] opcode : res "[inline_const]" 7 "," "[" iy "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1121 ], ":" => [ 7, \&_action_opcode_1121 ], },
	# [4314] opcode : res "[inline_const]" 7 "," "[" iy "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1122 ], ":" => [ 7, \&_action_opcode_1122 ], },
	# [4315] opcode : res "[inline_const]" 7 "," "[" iy "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1123 ], ":" => [ 7, \&_action_opcode_1123 ], },
	# [4316] opcode : res "[inline_const]" 7 "," "[" iy "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1124 ], ":" => [ 7, \&_action_opcode_1124 ], },
	# [4317] opcode : res "[inline_const]" 7 "," "[" iy "-"
	{ "!" => [ 14, 4318 ], "+" => [ 14, 4318 ], "-" => [ 14, 4318 ], __else__ => [ 14, 4318 ], "~" => [ 14, 4318 ], },
	# [4318] opcode : res "[inline_const]" 7 "," "[" iy "-" "[expr_NDIS]"
	{ "]" => 4319, },
	# [4319] opcode : res "[inline_const]" 7 "," "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1117 ], "," => 4320, ":" => [ 7, \&_action_opcode_1117 ], },
	# [4320] opcode : res "[inline_const]" 7 "," "[" iy "-" "[expr_NDIS]" "]" ","
	{ a => 4321, b => 4322, c => 4323, d => 4324, e => 4325, h => 4326, l => 4327, },
	# [4321] opcode : res "[inline_const]" 7 "," "[" iy "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1118 ], ":" => [ 7, \&_action_opcode_1118 ], },
	# [4322] opcode : res "[inline_const]" 7 "," "[" iy "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1119 ], ":" => [ 7, \&_action_opcode_1119 ], },
	# [4323] opcode : res "[inline_const]" 7 "," "[" iy "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1120 ], ":" => [ 7, \&_action_opcode_1120 ], },
	# [4324] opcode : res "[inline_const]" 7 "," "[" iy "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1121 ], ":" => [ 7, \&_action_opcode_1121 ], },
	# [4325] opcode : res "[inline_const]" 7 "," "[" iy "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1122 ], ":" => [ 7, \&_action_opcode_1122 ], },
	# [4326] opcode : res "[inline_const]" 7 "," "[" iy "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1123 ], ":" => [ 7, \&_action_opcode_1123 ], },
	# [4327] opcode : res "[inline_const]" 7 "," "[" iy "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1124 ], ":" => [ 7, \&_action_opcode_1124 ], },
	# [4328] opcode : res "[inline_const]" 7 "," "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_1109 ], "," => 4329, ":" => [ 7, \&_action_opcode_1109 ], },
	# [4329] opcode : res "[inline_const]" 7 "," "[" iy "]" ","
	{ a => 4330, b => 4331, c => 4332, d => 4333, e => 4334, h => 4335, l => 4336, },
	# [4330] opcode : res "[inline_const]" 7 "," "[" iy "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1110 ], ":" => [ 7, \&_action_opcode_1110 ], },
	# [4331] opcode : res "[inline_const]" 7 "," "[" iy "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1111 ], ":" => [ 7, \&_action_opcode_1111 ], },
	# [4332] opcode : res "[inline_const]" 7 "," "[" iy "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1112 ], ":" => [ 7, \&_action_opcode_1112 ], },
	# [4333] opcode : res "[inline_const]" 7 "," "[" iy "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1113 ], ":" => [ 7, \&_action_opcode_1113 ], },
	# [4334] opcode : res "[inline_const]" 7 "," "[" iy "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1114 ], ":" => [ 7, \&_action_opcode_1114 ], },
	# [4335] opcode : res "[inline_const]" 7 "," "[" iy "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1115 ], ":" => [ 7, \&_action_opcode_1115 ], },
	# [4336] opcode : res "[inline_const]" 7 "," "[" iy "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1116 ], ":" => [ 7, \&_action_opcode_1116 ], },
	# [4337] opcode : res "[inline_const]" 7 "," a
	{ "\n" => [ 7, \&_action_opcode_1125 ], ":" => [ 7, \&_action_opcode_1125 ], },
	# [4338] opcode : res "[inline_const]" 7 "," b
	{ "\n" => [ 7, \&_action_opcode_1126 ], ":" => [ 7, \&_action_opcode_1126 ], },
	# [4339] opcode : res "[inline_const]" 7 "," c
	{ "\n" => [ 7, \&_action_opcode_1127 ], ":" => [ 7, \&_action_opcode_1127 ], },
	# [4340] opcode : res "[inline_const]" 7 "," d
	{ "\n" => [ 7, \&_action_opcode_1128 ], ":" => [ 7, \&_action_opcode_1128 ], },
	# [4341] opcode : res "[inline_const]" 7 "," e
	{ "\n" => [ 7, \&_action_opcode_1129 ], ":" => [ 7, \&_action_opcode_1129 ], },
	# [4342] opcode : res "[inline_const]" 7 "," h
	{ "\n" => [ 7, \&_action_opcode_1130 ], ":" => [ 7, \&_action_opcode_1130 ], },
	# [4343] opcode : res "[inline_const]" 7 "," l
	{ "\n" => [ 7, \&_action_opcode_1131 ], ":" => [ 7, \&_action_opcode_1131 ], },
	# [4344] opcode : ret
	{ "\n" => [ 7, \&_action_opcode_1132 ], ":" => [ 7, \&_action_opcode_1132 ], c => 4345, m => 4346, nc => 4347, nz => 4348, p => 4349, pe => 4350, po => 4351, z => 4352, },
	# [4345] opcode : ret c
	{ "\n" => [ 7, \&_action_opcode_1133 ], ":" => [ 7, \&_action_opcode_1133 ], },
	# [4346] opcode : ret m
	{ "\n" => [ 7, \&_action_opcode_1134 ], ":" => [ 7, \&_action_opcode_1134 ], },
	# [4347] opcode : ret nc
	{ "\n" => [ 7, \&_action_opcode_1135 ], ":" => [ 7, \&_action_opcode_1135 ], },
	# [4348] opcode : ret nz
	{ "\n" => [ 7, \&_action_opcode_1136 ], ":" => [ 7, \&_action_opcode_1136 ], },
	# [4349] opcode : ret p
	{ "\n" => [ 7, \&_action_opcode_1137 ], ":" => [ 7, \&_action_opcode_1137 ], },
	# [4350] opcode : ret pe
	{ "\n" => [ 7, \&_action_opcode_1138 ], ":" => [ 7, \&_action_opcode_1138 ], },
	# [4351] opcode : ret po
	{ "\n" => [ 7, \&_action_opcode_1139 ], ":" => [ 7, \&_action_opcode_1139 ], },
	# [4352] opcode : ret z
	{ "\n" => [ 7, \&_action_opcode_1140 ], ":" => [ 7, \&_action_opcode_1140 ], },
	# [4353] opcode : reti
	{ "\n" => [ 7, \&_action_opcode_1141 ], ":" => [ 7, \&_action_opcode_1141 ], },
	# [4354] opcode : retn
	{ "\n" => [ 7, \&_action_opcode_1142 ], ":" => [ 7, \&_action_opcode_1142 ], },
	# [4355] opcode : rl
	{ "(" => 4356, "[" => 4423, a => 4490, b => 4491, bc => 4492, c => 4493, d => 4494, de => 4495, e => 4496, h => 4497, hl => 4498, l => 4499, },
	# [4356] opcode : rl "("
	{ hl => 4357, ix => 4359, iy => 4391, },
	# [4357] opcode : rl "(" hl
	{ ")" => 4358, },
	# [4358] opcode : rl "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_1143 ], ":" => [ 7, \&_action_opcode_1143 ], },
	# [4359] opcode : rl "(" ix
	{ ")" => 4360, "+" => 4369, "-" => 4380, },
	# [4360] opcode : rl "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_1144 ], "," => 4361, ":" => [ 7, \&_action_opcode_1144 ], },
	# [4361] opcode : rl "(" ix ")" ","
	{ a => 4362, b => 4363, c => 4364, d => 4365, e => 4366, h => 4367, l => 4368, },
	# [4362] opcode : rl "(" ix ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1145 ], ":" => [ 7, \&_action_opcode_1145 ], },
	# [4363] opcode : rl "(" ix ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1146 ], ":" => [ 7, \&_action_opcode_1146 ], },
	# [4364] opcode : rl "(" ix ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1147 ], ":" => [ 7, \&_action_opcode_1147 ], },
	# [4365] opcode : rl "(" ix ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1148 ], ":" => [ 7, \&_action_opcode_1148 ], },
	# [4366] opcode : rl "(" ix ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1149 ], ":" => [ 7, \&_action_opcode_1149 ], },
	# [4367] opcode : rl "(" ix ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1150 ], ":" => [ 7, \&_action_opcode_1150 ], },
	# [4368] opcode : rl "(" ix ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1151 ], ":" => [ 7, \&_action_opcode_1151 ], },
	# [4369] opcode : rl "(" ix "+"
	{ "!" => [ 12, 4370 ], "+" => [ 12, 4370 ], "-" => [ 12, 4370 ], __else__ => [ 12, 4370 ], "~" => [ 12, 4370 ], },
	# [4370] opcode : rl "(" ix "+" "[expr_DIS]"
	{ ")" => 4371, },
	# [4371] opcode : rl "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1152 ], "," => 4372, ":" => [ 7, \&_action_opcode_1152 ], },
	# [4372] opcode : rl "(" ix "+" "[expr_DIS]" ")" ","
	{ a => 4373, b => 4374, c => 4375, d => 4376, e => 4377, h => 4378, l => 4379, },
	# [4373] opcode : rl "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1153 ], ":" => [ 7, \&_action_opcode_1153 ], },
	# [4374] opcode : rl "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1154 ], ":" => [ 7, \&_action_opcode_1154 ], },
	# [4375] opcode : rl "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1155 ], ":" => [ 7, \&_action_opcode_1155 ], },
	# [4376] opcode : rl "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1156 ], ":" => [ 7, \&_action_opcode_1156 ], },
	# [4377] opcode : rl "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1157 ], ":" => [ 7, \&_action_opcode_1157 ], },
	# [4378] opcode : rl "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1158 ], ":" => [ 7, \&_action_opcode_1158 ], },
	# [4379] opcode : rl "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1159 ], ":" => [ 7, \&_action_opcode_1159 ], },
	# [4380] opcode : rl "(" ix "-"
	{ "!" => [ 14, 4381 ], "+" => [ 14, 4381 ], "-" => [ 14, 4381 ], __else__ => [ 14, 4381 ], "~" => [ 14, 4381 ], },
	# [4381] opcode : rl "(" ix "-" "[expr_NDIS]"
	{ ")" => 4382, },
	# [4382] opcode : rl "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1152 ], "," => 4383, ":" => [ 7, \&_action_opcode_1152 ], },
	# [4383] opcode : rl "(" ix "-" "[expr_NDIS]" ")" ","
	{ a => 4384, b => 4385, c => 4386, d => 4387, e => 4388, h => 4389, l => 4390, },
	# [4384] opcode : rl "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1153 ], ":" => [ 7, \&_action_opcode_1153 ], },
	# [4385] opcode : rl "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1154 ], ":" => [ 7, \&_action_opcode_1154 ], },
	# [4386] opcode : rl "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1155 ], ":" => [ 7, \&_action_opcode_1155 ], },
	# [4387] opcode : rl "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1156 ], ":" => [ 7, \&_action_opcode_1156 ], },
	# [4388] opcode : rl "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1157 ], ":" => [ 7, \&_action_opcode_1157 ], },
	# [4389] opcode : rl "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1158 ], ":" => [ 7, \&_action_opcode_1158 ], },
	# [4390] opcode : rl "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1159 ], ":" => [ 7, \&_action_opcode_1159 ], },
	# [4391] opcode : rl "(" iy
	{ ")" => 4392, "+" => 4401, "-" => 4412, },
	# [4392] opcode : rl "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_1160 ], "," => 4393, ":" => [ 7, \&_action_opcode_1160 ], },
	# [4393] opcode : rl "(" iy ")" ","
	{ a => 4394, b => 4395, c => 4396, d => 4397, e => 4398, h => 4399, l => 4400, },
	# [4394] opcode : rl "(" iy ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1161 ], ":" => [ 7, \&_action_opcode_1161 ], },
	# [4395] opcode : rl "(" iy ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1162 ], ":" => [ 7, \&_action_opcode_1162 ], },
	# [4396] opcode : rl "(" iy ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1163 ], ":" => [ 7, \&_action_opcode_1163 ], },
	# [4397] opcode : rl "(" iy ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1164 ], ":" => [ 7, \&_action_opcode_1164 ], },
	# [4398] opcode : rl "(" iy ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1165 ], ":" => [ 7, \&_action_opcode_1165 ], },
	# [4399] opcode : rl "(" iy ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1166 ], ":" => [ 7, \&_action_opcode_1166 ], },
	# [4400] opcode : rl "(" iy ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1167 ], ":" => [ 7, \&_action_opcode_1167 ], },
	# [4401] opcode : rl "(" iy "+"
	{ "!" => [ 12, 4402 ], "+" => [ 12, 4402 ], "-" => [ 12, 4402 ], __else__ => [ 12, 4402 ], "~" => [ 12, 4402 ], },
	# [4402] opcode : rl "(" iy "+" "[expr_DIS]"
	{ ")" => 4403, },
	# [4403] opcode : rl "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1168 ], "," => 4404, ":" => [ 7, \&_action_opcode_1168 ], },
	# [4404] opcode : rl "(" iy "+" "[expr_DIS]" ")" ","
	{ a => 4405, b => 4406, c => 4407, d => 4408, e => 4409, h => 4410, l => 4411, },
	# [4405] opcode : rl "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1169 ], ":" => [ 7, \&_action_opcode_1169 ], },
	# [4406] opcode : rl "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1170 ], ":" => [ 7, \&_action_opcode_1170 ], },
	# [4407] opcode : rl "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1171 ], ":" => [ 7, \&_action_opcode_1171 ], },
	# [4408] opcode : rl "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1172 ], ":" => [ 7, \&_action_opcode_1172 ], },
	# [4409] opcode : rl "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1173 ], ":" => [ 7, \&_action_opcode_1173 ], },
	# [4410] opcode : rl "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1174 ], ":" => [ 7, \&_action_opcode_1174 ], },
	# [4411] opcode : rl "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1175 ], ":" => [ 7, \&_action_opcode_1175 ], },
	# [4412] opcode : rl "(" iy "-"
	{ "!" => [ 14, 4413 ], "+" => [ 14, 4413 ], "-" => [ 14, 4413 ], __else__ => [ 14, 4413 ], "~" => [ 14, 4413 ], },
	# [4413] opcode : rl "(" iy "-" "[expr_NDIS]"
	{ ")" => 4414, },
	# [4414] opcode : rl "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1168 ], "," => 4415, ":" => [ 7, \&_action_opcode_1168 ], },
	# [4415] opcode : rl "(" iy "-" "[expr_NDIS]" ")" ","
	{ a => 4416, b => 4417, c => 4418, d => 4419, e => 4420, h => 4421, l => 4422, },
	# [4416] opcode : rl "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1169 ], ":" => [ 7, \&_action_opcode_1169 ], },
	# [4417] opcode : rl "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1170 ], ":" => [ 7, \&_action_opcode_1170 ], },
	# [4418] opcode : rl "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1171 ], ":" => [ 7, \&_action_opcode_1171 ], },
	# [4419] opcode : rl "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1172 ], ":" => [ 7, \&_action_opcode_1172 ], },
	# [4420] opcode : rl "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1173 ], ":" => [ 7, \&_action_opcode_1173 ], },
	# [4421] opcode : rl "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1174 ], ":" => [ 7, \&_action_opcode_1174 ], },
	# [4422] opcode : rl "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1175 ], ":" => [ 7, \&_action_opcode_1175 ], },
	# [4423] opcode : rl "["
	{ hl => 4424, ix => 4426, iy => 4458, },
	# [4424] opcode : rl "[" hl
	{ "]" => 4425, },
	# [4425] opcode : rl "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_1143 ], ":" => [ 7, \&_action_opcode_1143 ], },
	# [4426] opcode : rl "[" ix
	{ "+" => 4427, "-" => 4438, "]" => 4449, },
	# [4427] opcode : rl "[" ix "+"
	{ "!" => [ 12, 4428 ], "+" => [ 12, 4428 ], "-" => [ 12, 4428 ], __else__ => [ 12, 4428 ], "~" => [ 12, 4428 ], },
	# [4428] opcode : rl "[" ix "+" "[expr_DIS]"
	{ "]" => 4429, },
	# [4429] opcode : rl "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1152 ], "," => 4430, ":" => [ 7, \&_action_opcode_1152 ], },
	# [4430] opcode : rl "[" ix "+" "[expr_DIS]" "]" ","
	{ a => 4431, b => 4432, c => 4433, d => 4434, e => 4435, h => 4436, l => 4437, },
	# [4431] opcode : rl "[" ix "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1153 ], ":" => [ 7, \&_action_opcode_1153 ], },
	# [4432] opcode : rl "[" ix "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1154 ], ":" => [ 7, \&_action_opcode_1154 ], },
	# [4433] opcode : rl "[" ix "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1155 ], ":" => [ 7, \&_action_opcode_1155 ], },
	# [4434] opcode : rl "[" ix "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1156 ], ":" => [ 7, \&_action_opcode_1156 ], },
	# [4435] opcode : rl "[" ix "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1157 ], ":" => [ 7, \&_action_opcode_1157 ], },
	# [4436] opcode : rl "[" ix "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1158 ], ":" => [ 7, \&_action_opcode_1158 ], },
	# [4437] opcode : rl "[" ix "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1159 ], ":" => [ 7, \&_action_opcode_1159 ], },
	# [4438] opcode : rl "[" ix "-"
	{ "!" => [ 14, 4439 ], "+" => [ 14, 4439 ], "-" => [ 14, 4439 ], __else__ => [ 14, 4439 ], "~" => [ 14, 4439 ], },
	# [4439] opcode : rl "[" ix "-" "[expr_NDIS]"
	{ "]" => 4440, },
	# [4440] opcode : rl "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1152 ], "," => 4441, ":" => [ 7, \&_action_opcode_1152 ], },
	# [4441] opcode : rl "[" ix "-" "[expr_NDIS]" "]" ","
	{ a => 4442, b => 4443, c => 4444, d => 4445, e => 4446, h => 4447, l => 4448, },
	# [4442] opcode : rl "[" ix "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1153 ], ":" => [ 7, \&_action_opcode_1153 ], },
	# [4443] opcode : rl "[" ix "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1154 ], ":" => [ 7, \&_action_opcode_1154 ], },
	# [4444] opcode : rl "[" ix "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1155 ], ":" => [ 7, \&_action_opcode_1155 ], },
	# [4445] opcode : rl "[" ix "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1156 ], ":" => [ 7, \&_action_opcode_1156 ], },
	# [4446] opcode : rl "[" ix "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1157 ], ":" => [ 7, \&_action_opcode_1157 ], },
	# [4447] opcode : rl "[" ix "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1158 ], ":" => [ 7, \&_action_opcode_1158 ], },
	# [4448] opcode : rl "[" ix "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1159 ], ":" => [ 7, \&_action_opcode_1159 ], },
	# [4449] opcode : rl "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_1144 ], "," => 4450, ":" => [ 7, \&_action_opcode_1144 ], },
	# [4450] opcode : rl "[" ix "]" ","
	{ a => 4451, b => 4452, c => 4453, d => 4454, e => 4455, h => 4456, l => 4457, },
	# [4451] opcode : rl "[" ix "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1145 ], ":" => [ 7, \&_action_opcode_1145 ], },
	# [4452] opcode : rl "[" ix "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1146 ], ":" => [ 7, \&_action_opcode_1146 ], },
	# [4453] opcode : rl "[" ix "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1147 ], ":" => [ 7, \&_action_opcode_1147 ], },
	# [4454] opcode : rl "[" ix "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1148 ], ":" => [ 7, \&_action_opcode_1148 ], },
	# [4455] opcode : rl "[" ix "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1149 ], ":" => [ 7, \&_action_opcode_1149 ], },
	# [4456] opcode : rl "[" ix "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1150 ], ":" => [ 7, \&_action_opcode_1150 ], },
	# [4457] opcode : rl "[" ix "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1151 ], ":" => [ 7, \&_action_opcode_1151 ], },
	# [4458] opcode : rl "[" iy
	{ "+" => 4459, "-" => 4470, "]" => 4481, },
	# [4459] opcode : rl "[" iy "+"
	{ "!" => [ 12, 4460 ], "+" => [ 12, 4460 ], "-" => [ 12, 4460 ], __else__ => [ 12, 4460 ], "~" => [ 12, 4460 ], },
	# [4460] opcode : rl "[" iy "+" "[expr_DIS]"
	{ "]" => 4461, },
	# [4461] opcode : rl "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1168 ], "," => 4462, ":" => [ 7, \&_action_opcode_1168 ], },
	# [4462] opcode : rl "[" iy "+" "[expr_DIS]" "]" ","
	{ a => 4463, b => 4464, c => 4465, d => 4466, e => 4467, h => 4468, l => 4469, },
	# [4463] opcode : rl "[" iy "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1169 ], ":" => [ 7, \&_action_opcode_1169 ], },
	# [4464] opcode : rl "[" iy "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1170 ], ":" => [ 7, \&_action_opcode_1170 ], },
	# [4465] opcode : rl "[" iy "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1171 ], ":" => [ 7, \&_action_opcode_1171 ], },
	# [4466] opcode : rl "[" iy "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1172 ], ":" => [ 7, \&_action_opcode_1172 ], },
	# [4467] opcode : rl "[" iy "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1173 ], ":" => [ 7, \&_action_opcode_1173 ], },
	# [4468] opcode : rl "[" iy "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1174 ], ":" => [ 7, \&_action_opcode_1174 ], },
	# [4469] opcode : rl "[" iy "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1175 ], ":" => [ 7, \&_action_opcode_1175 ], },
	# [4470] opcode : rl "[" iy "-"
	{ "!" => [ 14, 4471 ], "+" => [ 14, 4471 ], "-" => [ 14, 4471 ], __else__ => [ 14, 4471 ], "~" => [ 14, 4471 ], },
	# [4471] opcode : rl "[" iy "-" "[expr_NDIS]"
	{ "]" => 4472, },
	# [4472] opcode : rl "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1168 ], "," => 4473, ":" => [ 7, \&_action_opcode_1168 ], },
	# [4473] opcode : rl "[" iy "-" "[expr_NDIS]" "]" ","
	{ a => 4474, b => 4475, c => 4476, d => 4477, e => 4478, h => 4479, l => 4480, },
	# [4474] opcode : rl "[" iy "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1169 ], ":" => [ 7, \&_action_opcode_1169 ], },
	# [4475] opcode : rl "[" iy "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1170 ], ":" => [ 7, \&_action_opcode_1170 ], },
	# [4476] opcode : rl "[" iy "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1171 ], ":" => [ 7, \&_action_opcode_1171 ], },
	# [4477] opcode : rl "[" iy "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1172 ], ":" => [ 7, \&_action_opcode_1172 ], },
	# [4478] opcode : rl "[" iy "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1173 ], ":" => [ 7, \&_action_opcode_1173 ], },
	# [4479] opcode : rl "[" iy "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1174 ], ":" => [ 7, \&_action_opcode_1174 ], },
	# [4480] opcode : rl "[" iy "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1175 ], ":" => [ 7, \&_action_opcode_1175 ], },
	# [4481] opcode : rl "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_1160 ], "," => 4482, ":" => [ 7, \&_action_opcode_1160 ], },
	# [4482] opcode : rl "[" iy "]" ","
	{ a => 4483, b => 4484, c => 4485, d => 4486, e => 4487, h => 4488, l => 4489, },
	# [4483] opcode : rl "[" iy "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1161 ], ":" => [ 7, \&_action_opcode_1161 ], },
	# [4484] opcode : rl "[" iy "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1162 ], ":" => [ 7, \&_action_opcode_1162 ], },
	# [4485] opcode : rl "[" iy "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1163 ], ":" => [ 7, \&_action_opcode_1163 ], },
	# [4486] opcode : rl "[" iy "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1164 ], ":" => [ 7, \&_action_opcode_1164 ], },
	# [4487] opcode : rl "[" iy "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1165 ], ":" => [ 7, \&_action_opcode_1165 ], },
	# [4488] opcode : rl "[" iy "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1166 ], ":" => [ 7, \&_action_opcode_1166 ], },
	# [4489] opcode : rl "[" iy "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1167 ], ":" => [ 7, \&_action_opcode_1167 ], },
	# [4490] opcode : rl a
	{ "\n" => [ 7, \&_action_opcode_1176 ], ":" => [ 7, \&_action_opcode_1176 ], },
	# [4491] opcode : rl b
	{ "\n" => [ 7, \&_action_opcode_1177 ], ":" => [ 7, \&_action_opcode_1177 ], },
	# [4492] opcode : rl bc
	{ "\n" => [ 7, \&_action_opcode_1178 ], ":" => [ 7, \&_action_opcode_1178 ], },
	# [4493] opcode : rl c
	{ "\n" => [ 7, \&_action_opcode_1179 ], ":" => [ 7, \&_action_opcode_1179 ], },
	# [4494] opcode : rl d
	{ "\n" => [ 7, \&_action_opcode_1180 ], ":" => [ 7, \&_action_opcode_1180 ], },
	# [4495] opcode : rl de
	{ "\n" => [ 7, \&_action_opcode_1181 ], ":" => [ 7, \&_action_opcode_1181 ], },
	# [4496] opcode : rl e
	{ "\n" => [ 7, \&_action_opcode_1182 ], ":" => [ 7, \&_action_opcode_1182 ], },
	# [4497] opcode : rl h
	{ "\n" => [ 7, \&_action_opcode_1183 ], ":" => [ 7, \&_action_opcode_1183 ], },
	# [4498] opcode : rl hl
	{ "\n" => [ 7, \&_action_opcode_1184 ], ":" => [ 7, \&_action_opcode_1184 ], },
	# [4499] opcode : rl l
	{ "\n" => [ 7, \&_action_opcode_1185 ], ":" => [ 7, \&_action_opcode_1185 ], },
	# [4500] opcode : rla
	{ "\n" => [ 7, \&_action_opcode_1186 ], ":" => [ 7, \&_action_opcode_1186 ], },
	# [4501] opcode : rlc
	{ "(" => 4502, "[" => 4569, a => 4636, b => 4637, c => 4638, d => 4639, e => 4640, h => 4641, l => 4642, },
	# [4502] opcode : rlc "("
	{ hl => 4503, ix => 4505, iy => 4537, },
	# [4503] opcode : rlc "(" hl
	{ ")" => 4504, },
	# [4504] opcode : rlc "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_1187 ], ":" => [ 7, \&_action_opcode_1187 ], },
	# [4505] opcode : rlc "(" ix
	{ ")" => 4506, "+" => 4515, "-" => 4526, },
	# [4506] opcode : rlc "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_1188 ], "," => 4507, ":" => [ 7, \&_action_opcode_1188 ], },
	# [4507] opcode : rlc "(" ix ")" ","
	{ a => 4508, b => 4509, c => 4510, d => 4511, e => 4512, h => 4513, l => 4514, },
	# [4508] opcode : rlc "(" ix ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1189 ], ":" => [ 7, \&_action_opcode_1189 ], },
	# [4509] opcode : rlc "(" ix ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1190 ], ":" => [ 7, \&_action_opcode_1190 ], },
	# [4510] opcode : rlc "(" ix ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1191 ], ":" => [ 7, \&_action_opcode_1191 ], },
	# [4511] opcode : rlc "(" ix ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1192 ], ":" => [ 7, \&_action_opcode_1192 ], },
	# [4512] opcode : rlc "(" ix ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1193 ], ":" => [ 7, \&_action_opcode_1193 ], },
	# [4513] opcode : rlc "(" ix ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1194 ], ":" => [ 7, \&_action_opcode_1194 ], },
	# [4514] opcode : rlc "(" ix ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1195 ], ":" => [ 7, \&_action_opcode_1195 ], },
	# [4515] opcode : rlc "(" ix "+"
	{ "!" => [ 12, 4516 ], "+" => [ 12, 4516 ], "-" => [ 12, 4516 ], __else__ => [ 12, 4516 ], "~" => [ 12, 4516 ], },
	# [4516] opcode : rlc "(" ix "+" "[expr_DIS]"
	{ ")" => 4517, },
	# [4517] opcode : rlc "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1196 ], "," => 4518, ":" => [ 7, \&_action_opcode_1196 ], },
	# [4518] opcode : rlc "(" ix "+" "[expr_DIS]" ")" ","
	{ a => 4519, b => 4520, c => 4521, d => 4522, e => 4523, h => 4524, l => 4525, },
	# [4519] opcode : rlc "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1197 ], ":" => [ 7, \&_action_opcode_1197 ], },
	# [4520] opcode : rlc "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1198 ], ":" => [ 7, \&_action_opcode_1198 ], },
	# [4521] opcode : rlc "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1199 ], ":" => [ 7, \&_action_opcode_1199 ], },
	# [4522] opcode : rlc "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1200 ], ":" => [ 7, \&_action_opcode_1200 ], },
	# [4523] opcode : rlc "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1201 ], ":" => [ 7, \&_action_opcode_1201 ], },
	# [4524] opcode : rlc "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1202 ], ":" => [ 7, \&_action_opcode_1202 ], },
	# [4525] opcode : rlc "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1203 ], ":" => [ 7, \&_action_opcode_1203 ], },
	# [4526] opcode : rlc "(" ix "-"
	{ "!" => [ 14, 4527 ], "+" => [ 14, 4527 ], "-" => [ 14, 4527 ], __else__ => [ 14, 4527 ], "~" => [ 14, 4527 ], },
	# [4527] opcode : rlc "(" ix "-" "[expr_NDIS]"
	{ ")" => 4528, },
	# [4528] opcode : rlc "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1196 ], "," => 4529, ":" => [ 7, \&_action_opcode_1196 ], },
	# [4529] opcode : rlc "(" ix "-" "[expr_NDIS]" ")" ","
	{ a => 4530, b => 4531, c => 4532, d => 4533, e => 4534, h => 4535, l => 4536, },
	# [4530] opcode : rlc "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1197 ], ":" => [ 7, \&_action_opcode_1197 ], },
	# [4531] opcode : rlc "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1198 ], ":" => [ 7, \&_action_opcode_1198 ], },
	# [4532] opcode : rlc "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1199 ], ":" => [ 7, \&_action_opcode_1199 ], },
	# [4533] opcode : rlc "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1200 ], ":" => [ 7, \&_action_opcode_1200 ], },
	# [4534] opcode : rlc "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1201 ], ":" => [ 7, \&_action_opcode_1201 ], },
	# [4535] opcode : rlc "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1202 ], ":" => [ 7, \&_action_opcode_1202 ], },
	# [4536] opcode : rlc "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1203 ], ":" => [ 7, \&_action_opcode_1203 ], },
	# [4537] opcode : rlc "(" iy
	{ ")" => 4538, "+" => 4547, "-" => 4558, },
	# [4538] opcode : rlc "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_1204 ], "," => 4539, ":" => [ 7, \&_action_opcode_1204 ], },
	# [4539] opcode : rlc "(" iy ")" ","
	{ a => 4540, b => 4541, c => 4542, d => 4543, e => 4544, h => 4545, l => 4546, },
	# [4540] opcode : rlc "(" iy ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1205 ], ":" => [ 7, \&_action_opcode_1205 ], },
	# [4541] opcode : rlc "(" iy ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1206 ], ":" => [ 7, \&_action_opcode_1206 ], },
	# [4542] opcode : rlc "(" iy ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1207 ], ":" => [ 7, \&_action_opcode_1207 ], },
	# [4543] opcode : rlc "(" iy ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1208 ], ":" => [ 7, \&_action_opcode_1208 ], },
	# [4544] opcode : rlc "(" iy ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1209 ], ":" => [ 7, \&_action_opcode_1209 ], },
	# [4545] opcode : rlc "(" iy ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1210 ], ":" => [ 7, \&_action_opcode_1210 ], },
	# [4546] opcode : rlc "(" iy ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1211 ], ":" => [ 7, \&_action_opcode_1211 ], },
	# [4547] opcode : rlc "(" iy "+"
	{ "!" => [ 12, 4548 ], "+" => [ 12, 4548 ], "-" => [ 12, 4548 ], __else__ => [ 12, 4548 ], "~" => [ 12, 4548 ], },
	# [4548] opcode : rlc "(" iy "+" "[expr_DIS]"
	{ ")" => 4549, },
	# [4549] opcode : rlc "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1212 ], "," => 4550, ":" => [ 7, \&_action_opcode_1212 ], },
	# [4550] opcode : rlc "(" iy "+" "[expr_DIS]" ")" ","
	{ a => 4551, b => 4552, c => 4553, d => 4554, e => 4555, h => 4556, l => 4557, },
	# [4551] opcode : rlc "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1213 ], ":" => [ 7, \&_action_opcode_1213 ], },
	# [4552] opcode : rlc "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1214 ], ":" => [ 7, \&_action_opcode_1214 ], },
	# [4553] opcode : rlc "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1215 ], ":" => [ 7, \&_action_opcode_1215 ], },
	# [4554] opcode : rlc "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1216 ], ":" => [ 7, \&_action_opcode_1216 ], },
	# [4555] opcode : rlc "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1217 ], ":" => [ 7, \&_action_opcode_1217 ], },
	# [4556] opcode : rlc "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1218 ], ":" => [ 7, \&_action_opcode_1218 ], },
	# [4557] opcode : rlc "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1219 ], ":" => [ 7, \&_action_opcode_1219 ], },
	# [4558] opcode : rlc "(" iy "-"
	{ "!" => [ 14, 4559 ], "+" => [ 14, 4559 ], "-" => [ 14, 4559 ], __else__ => [ 14, 4559 ], "~" => [ 14, 4559 ], },
	# [4559] opcode : rlc "(" iy "-" "[expr_NDIS]"
	{ ")" => 4560, },
	# [4560] opcode : rlc "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1212 ], "," => 4561, ":" => [ 7, \&_action_opcode_1212 ], },
	# [4561] opcode : rlc "(" iy "-" "[expr_NDIS]" ")" ","
	{ a => 4562, b => 4563, c => 4564, d => 4565, e => 4566, h => 4567, l => 4568, },
	# [4562] opcode : rlc "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1213 ], ":" => [ 7, \&_action_opcode_1213 ], },
	# [4563] opcode : rlc "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1214 ], ":" => [ 7, \&_action_opcode_1214 ], },
	# [4564] opcode : rlc "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1215 ], ":" => [ 7, \&_action_opcode_1215 ], },
	# [4565] opcode : rlc "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1216 ], ":" => [ 7, \&_action_opcode_1216 ], },
	# [4566] opcode : rlc "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1217 ], ":" => [ 7, \&_action_opcode_1217 ], },
	# [4567] opcode : rlc "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1218 ], ":" => [ 7, \&_action_opcode_1218 ], },
	# [4568] opcode : rlc "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1219 ], ":" => [ 7, \&_action_opcode_1219 ], },
	# [4569] opcode : rlc "["
	{ hl => 4570, ix => 4572, iy => 4604, },
	# [4570] opcode : rlc "[" hl
	{ "]" => 4571, },
	# [4571] opcode : rlc "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_1187 ], ":" => [ 7, \&_action_opcode_1187 ], },
	# [4572] opcode : rlc "[" ix
	{ "+" => 4573, "-" => 4584, "]" => 4595, },
	# [4573] opcode : rlc "[" ix "+"
	{ "!" => [ 12, 4574 ], "+" => [ 12, 4574 ], "-" => [ 12, 4574 ], __else__ => [ 12, 4574 ], "~" => [ 12, 4574 ], },
	# [4574] opcode : rlc "[" ix "+" "[expr_DIS]"
	{ "]" => 4575, },
	# [4575] opcode : rlc "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1196 ], "," => 4576, ":" => [ 7, \&_action_opcode_1196 ], },
	# [4576] opcode : rlc "[" ix "+" "[expr_DIS]" "]" ","
	{ a => 4577, b => 4578, c => 4579, d => 4580, e => 4581, h => 4582, l => 4583, },
	# [4577] opcode : rlc "[" ix "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1197 ], ":" => [ 7, \&_action_opcode_1197 ], },
	# [4578] opcode : rlc "[" ix "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1198 ], ":" => [ 7, \&_action_opcode_1198 ], },
	# [4579] opcode : rlc "[" ix "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1199 ], ":" => [ 7, \&_action_opcode_1199 ], },
	# [4580] opcode : rlc "[" ix "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1200 ], ":" => [ 7, \&_action_opcode_1200 ], },
	# [4581] opcode : rlc "[" ix "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1201 ], ":" => [ 7, \&_action_opcode_1201 ], },
	# [4582] opcode : rlc "[" ix "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1202 ], ":" => [ 7, \&_action_opcode_1202 ], },
	# [4583] opcode : rlc "[" ix "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1203 ], ":" => [ 7, \&_action_opcode_1203 ], },
	# [4584] opcode : rlc "[" ix "-"
	{ "!" => [ 14, 4585 ], "+" => [ 14, 4585 ], "-" => [ 14, 4585 ], __else__ => [ 14, 4585 ], "~" => [ 14, 4585 ], },
	# [4585] opcode : rlc "[" ix "-" "[expr_NDIS]"
	{ "]" => 4586, },
	# [4586] opcode : rlc "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1196 ], "," => 4587, ":" => [ 7, \&_action_opcode_1196 ], },
	# [4587] opcode : rlc "[" ix "-" "[expr_NDIS]" "]" ","
	{ a => 4588, b => 4589, c => 4590, d => 4591, e => 4592, h => 4593, l => 4594, },
	# [4588] opcode : rlc "[" ix "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1197 ], ":" => [ 7, \&_action_opcode_1197 ], },
	# [4589] opcode : rlc "[" ix "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1198 ], ":" => [ 7, \&_action_opcode_1198 ], },
	# [4590] opcode : rlc "[" ix "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1199 ], ":" => [ 7, \&_action_opcode_1199 ], },
	# [4591] opcode : rlc "[" ix "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1200 ], ":" => [ 7, \&_action_opcode_1200 ], },
	# [4592] opcode : rlc "[" ix "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1201 ], ":" => [ 7, \&_action_opcode_1201 ], },
	# [4593] opcode : rlc "[" ix "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1202 ], ":" => [ 7, \&_action_opcode_1202 ], },
	# [4594] opcode : rlc "[" ix "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1203 ], ":" => [ 7, \&_action_opcode_1203 ], },
	# [4595] opcode : rlc "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_1188 ], "," => 4596, ":" => [ 7, \&_action_opcode_1188 ], },
	# [4596] opcode : rlc "[" ix "]" ","
	{ a => 4597, b => 4598, c => 4599, d => 4600, e => 4601, h => 4602, l => 4603, },
	# [4597] opcode : rlc "[" ix "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1189 ], ":" => [ 7, \&_action_opcode_1189 ], },
	# [4598] opcode : rlc "[" ix "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1190 ], ":" => [ 7, \&_action_opcode_1190 ], },
	# [4599] opcode : rlc "[" ix "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1191 ], ":" => [ 7, \&_action_opcode_1191 ], },
	# [4600] opcode : rlc "[" ix "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1192 ], ":" => [ 7, \&_action_opcode_1192 ], },
	# [4601] opcode : rlc "[" ix "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1193 ], ":" => [ 7, \&_action_opcode_1193 ], },
	# [4602] opcode : rlc "[" ix "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1194 ], ":" => [ 7, \&_action_opcode_1194 ], },
	# [4603] opcode : rlc "[" ix "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1195 ], ":" => [ 7, \&_action_opcode_1195 ], },
	# [4604] opcode : rlc "[" iy
	{ "+" => 4605, "-" => 4616, "]" => 4627, },
	# [4605] opcode : rlc "[" iy "+"
	{ "!" => [ 12, 4606 ], "+" => [ 12, 4606 ], "-" => [ 12, 4606 ], __else__ => [ 12, 4606 ], "~" => [ 12, 4606 ], },
	# [4606] opcode : rlc "[" iy "+" "[expr_DIS]"
	{ "]" => 4607, },
	# [4607] opcode : rlc "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1212 ], "," => 4608, ":" => [ 7, \&_action_opcode_1212 ], },
	# [4608] opcode : rlc "[" iy "+" "[expr_DIS]" "]" ","
	{ a => 4609, b => 4610, c => 4611, d => 4612, e => 4613, h => 4614, l => 4615, },
	# [4609] opcode : rlc "[" iy "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1213 ], ":" => [ 7, \&_action_opcode_1213 ], },
	# [4610] opcode : rlc "[" iy "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1214 ], ":" => [ 7, \&_action_opcode_1214 ], },
	# [4611] opcode : rlc "[" iy "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1215 ], ":" => [ 7, \&_action_opcode_1215 ], },
	# [4612] opcode : rlc "[" iy "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1216 ], ":" => [ 7, \&_action_opcode_1216 ], },
	# [4613] opcode : rlc "[" iy "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1217 ], ":" => [ 7, \&_action_opcode_1217 ], },
	# [4614] opcode : rlc "[" iy "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1218 ], ":" => [ 7, \&_action_opcode_1218 ], },
	# [4615] opcode : rlc "[" iy "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1219 ], ":" => [ 7, \&_action_opcode_1219 ], },
	# [4616] opcode : rlc "[" iy "-"
	{ "!" => [ 14, 4617 ], "+" => [ 14, 4617 ], "-" => [ 14, 4617 ], __else__ => [ 14, 4617 ], "~" => [ 14, 4617 ], },
	# [4617] opcode : rlc "[" iy "-" "[expr_NDIS]"
	{ "]" => 4618, },
	# [4618] opcode : rlc "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1212 ], "," => 4619, ":" => [ 7, \&_action_opcode_1212 ], },
	# [4619] opcode : rlc "[" iy "-" "[expr_NDIS]" "]" ","
	{ a => 4620, b => 4621, c => 4622, d => 4623, e => 4624, h => 4625, l => 4626, },
	# [4620] opcode : rlc "[" iy "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1213 ], ":" => [ 7, \&_action_opcode_1213 ], },
	# [4621] opcode : rlc "[" iy "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1214 ], ":" => [ 7, \&_action_opcode_1214 ], },
	# [4622] opcode : rlc "[" iy "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1215 ], ":" => [ 7, \&_action_opcode_1215 ], },
	# [4623] opcode : rlc "[" iy "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1216 ], ":" => [ 7, \&_action_opcode_1216 ], },
	# [4624] opcode : rlc "[" iy "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1217 ], ":" => [ 7, \&_action_opcode_1217 ], },
	# [4625] opcode : rlc "[" iy "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1218 ], ":" => [ 7, \&_action_opcode_1218 ], },
	# [4626] opcode : rlc "[" iy "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1219 ], ":" => [ 7, \&_action_opcode_1219 ], },
	# [4627] opcode : rlc "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_1204 ], "," => 4628, ":" => [ 7, \&_action_opcode_1204 ], },
	# [4628] opcode : rlc "[" iy "]" ","
	{ a => 4629, b => 4630, c => 4631, d => 4632, e => 4633, h => 4634, l => 4635, },
	# [4629] opcode : rlc "[" iy "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1205 ], ":" => [ 7, \&_action_opcode_1205 ], },
	# [4630] opcode : rlc "[" iy "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1206 ], ":" => [ 7, \&_action_opcode_1206 ], },
	# [4631] opcode : rlc "[" iy "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1207 ], ":" => [ 7, \&_action_opcode_1207 ], },
	# [4632] opcode : rlc "[" iy "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1208 ], ":" => [ 7, \&_action_opcode_1208 ], },
	# [4633] opcode : rlc "[" iy "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1209 ], ":" => [ 7, \&_action_opcode_1209 ], },
	# [4634] opcode : rlc "[" iy "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1210 ], ":" => [ 7, \&_action_opcode_1210 ], },
	# [4635] opcode : rlc "[" iy "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1211 ], ":" => [ 7, \&_action_opcode_1211 ], },
	# [4636] opcode : rlc a
	{ "\n" => [ 7, \&_action_opcode_1220 ], ":" => [ 7, \&_action_opcode_1220 ], },
	# [4637] opcode : rlc b
	{ "\n" => [ 7, \&_action_opcode_1221 ], ":" => [ 7, \&_action_opcode_1221 ], },
	# [4638] opcode : rlc c
	{ "\n" => [ 7, \&_action_opcode_1222 ], ":" => [ 7, \&_action_opcode_1222 ], },
	# [4639] opcode : rlc d
	{ "\n" => [ 7, \&_action_opcode_1223 ], ":" => [ 7, \&_action_opcode_1223 ], },
	# [4640] opcode : rlc e
	{ "\n" => [ 7, \&_action_opcode_1224 ], ":" => [ 7, \&_action_opcode_1224 ], },
	# [4641] opcode : rlc h
	{ "\n" => [ 7, \&_action_opcode_1225 ], ":" => [ 7, \&_action_opcode_1225 ], },
	# [4642] opcode : rlc l
	{ "\n" => [ 7, \&_action_opcode_1226 ], ":" => [ 7, \&_action_opcode_1226 ], },
	# [4643] opcode : rlca
	{ "\n" => [ 7, \&_action_opcode_1227 ], ":" => [ 7, \&_action_opcode_1227 ], },
	# [4644] opcode : rld
	{ "\n" => [ 7, \&_action_opcode_1228 ], ":" => [ 7, \&_action_opcode_1228 ], },
	# [4645] opcode : rr
	{ "(" => 4646, "[" => 4713, a => 4780, b => 4781, bc => 4782, c => 4783, d => 4784, de => 4785, e => 4786, h => 4787, hl => 4788, l => 4789, },
	# [4646] opcode : rr "("
	{ hl => 4647, ix => 4649, iy => 4681, },
	# [4647] opcode : rr "(" hl
	{ ")" => 4648, },
	# [4648] opcode : rr "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_1229 ], ":" => [ 7, \&_action_opcode_1229 ], },
	# [4649] opcode : rr "(" ix
	{ ")" => 4650, "+" => 4659, "-" => 4670, },
	# [4650] opcode : rr "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_1230 ], "," => 4651, ":" => [ 7, \&_action_opcode_1230 ], },
	# [4651] opcode : rr "(" ix ")" ","
	{ a => 4652, b => 4653, c => 4654, d => 4655, e => 4656, h => 4657, l => 4658, },
	# [4652] opcode : rr "(" ix ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1231 ], ":" => [ 7, \&_action_opcode_1231 ], },
	# [4653] opcode : rr "(" ix ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1232 ], ":" => [ 7, \&_action_opcode_1232 ], },
	# [4654] opcode : rr "(" ix ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1233 ], ":" => [ 7, \&_action_opcode_1233 ], },
	# [4655] opcode : rr "(" ix ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1234 ], ":" => [ 7, \&_action_opcode_1234 ], },
	# [4656] opcode : rr "(" ix ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1235 ], ":" => [ 7, \&_action_opcode_1235 ], },
	# [4657] opcode : rr "(" ix ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1236 ], ":" => [ 7, \&_action_opcode_1236 ], },
	# [4658] opcode : rr "(" ix ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1237 ], ":" => [ 7, \&_action_opcode_1237 ], },
	# [4659] opcode : rr "(" ix "+"
	{ "!" => [ 12, 4660 ], "+" => [ 12, 4660 ], "-" => [ 12, 4660 ], __else__ => [ 12, 4660 ], "~" => [ 12, 4660 ], },
	# [4660] opcode : rr "(" ix "+" "[expr_DIS]"
	{ ")" => 4661, },
	# [4661] opcode : rr "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1238 ], "," => 4662, ":" => [ 7, \&_action_opcode_1238 ], },
	# [4662] opcode : rr "(" ix "+" "[expr_DIS]" ")" ","
	{ a => 4663, b => 4664, c => 4665, d => 4666, e => 4667, h => 4668, l => 4669, },
	# [4663] opcode : rr "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1239 ], ":" => [ 7, \&_action_opcode_1239 ], },
	# [4664] opcode : rr "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1240 ], ":" => [ 7, \&_action_opcode_1240 ], },
	# [4665] opcode : rr "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1241 ], ":" => [ 7, \&_action_opcode_1241 ], },
	# [4666] opcode : rr "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1242 ], ":" => [ 7, \&_action_opcode_1242 ], },
	# [4667] opcode : rr "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1243 ], ":" => [ 7, \&_action_opcode_1243 ], },
	# [4668] opcode : rr "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1244 ], ":" => [ 7, \&_action_opcode_1244 ], },
	# [4669] opcode : rr "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1245 ], ":" => [ 7, \&_action_opcode_1245 ], },
	# [4670] opcode : rr "(" ix "-"
	{ "!" => [ 14, 4671 ], "+" => [ 14, 4671 ], "-" => [ 14, 4671 ], __else__ => [ 14, 4671 ], "~" => [ 14, 4671 ], },
	# [4671] opcode : rr "(" ix "-" "[expr_NDIS]"
	{ ")" => 4672, },
	# [4672] opcode : rr "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1238 ], "," => 4673, ":" => [ 7, \&_action_opcode_1238 ], },
	# [4673] opcode : rr "(" ix "-" "[expr_NDIS]" ")" ","
	{ a => 4674, b => 4675, c => 4676, d => 4677, e => 4678, h => 4679, l => 4680, },
	# [4674] opcode : rr "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1239 ], ":" => [ 7, \&_action_opcode_1239 ], },
	# [4675] opcode : rr "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1240 ], ":" => [ 7, \&_action_opcode_1240 ], },
	# [4676] opcode : rr "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1241 ], ":" => [ 7, \&_action_opcode_1241 ], },
	# [4677] opcode : rr "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1242 ], ":" => [ 7, \&_action_opcode_1242 ], },
	# [4678] opcode : rr "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1243 ], ":" => [ 7, \&_action_opcode_1243 ], },
	# [4679] opcode : rr "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1244 ], ":" => [ 7, \&_action_opcode_1244 ], },
	# [4680] opcode : rr "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1245 ], ":" => [ 7, \&_action_opcode_1245 ], },
	# [4681] opcode : rr "(" iy
	{ ")" => 4682, "+" => 4691, "-" => 4702, },
	# [4682] opcode : rr "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_1246 ], "," => 4683, ":" => [ 7, \&_action_opcode_1246 ], },
	# [4683] opcode : rr "(" iy ")" ","
	{ a => 4684, b => 4685, c => 4686, d => 4687, e => 4688, h => 4689, l => 4690, },
	# [4684] opcode : rr "(" iy ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1247 ], ":" => [ 7, \&_action_opcode_1247 ], },
	# [4685] opcode : rr "(" iy ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1248 ], ":" => [ 7, \&_action_opcode_1248 ], },
	# [4686] opcode : rr "(" iy ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1249 ], ":" => [ 7, \&_action_opcode_1249 ], },
	# [4687] opcode : rr "(" iy ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1250 ], ":" => [ 7, \&_action_opcode_1250 ], },
	# [4688] opcode : rr "(" iy ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1251 ], ":" => [ 7, \&_action_opcode_1251 ], },
	# [4689] opcode : rr "(" iy ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1252 ], ":" => [ 7, \&_action_opcode_1252 ], },
	# [4690] opcode : rr "(" iy ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1253 ], ":" => [ 7, \&_action_opcode_1253 ], },
	# [4691] opcode : rr "(" iy "+"
	{ "!" => [ 12, 4692 ], "+" => [ 12, 4692 ], "-" => [ 12, 4692 ], __else__ => [ 12, 4692 ], "~" => [ 12, 4692 ], },
	# [4692] opcode : rr "(" iy "+" "[expr_DIS]"
	{ ")" => 4693, },
	# [4693] opcode : rr "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1254 ], "," => 4694, ":" => [ 7, \&_action_opcode_1254 ], },
	# [4694] opcode : rr "(" iy "+" "[expr_DIS]" ")" ","
	{ a => 4695, b => 4696, c => 4697, d => 4698, e => 4699, h => 4700, l => 4701, },
	# [4695] opcode : rr "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1255 ], ":" => [ 7, \&_action_opcode_1255 ], },
	# [4696] opcode : rr "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1256 ], ":" => [ 7, \&_action_opcode_1256 ], },
	# [4697] opcode : rr "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1257 ], ":" => [ 7, \&_action_opcode_1257 ], },
	# [4698] opcode : rr "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1258 ], ":" => [ 7, \&_action_opcode_1258 ], },
	# [4699] opcode : rr "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1259 ], ":" => [ 7, \&_action_opcode_1259 ], },
	# [4700] opcode : rr "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1260 ], ":" => [ 7, \&_action_opcode_1260 ], },
	# [4701] opcode : rr "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1261 ], ":" => [ 7, \&_action_opcode_1261 ], },
	# [4702] opcode : rr "(" iy "-"
	{ "!" => [ 14, 4703 ], "+" => [ 14, 4703 ], "-" => [ 14, 4703 ], __else__ => [ 14, 4703 ], "~" => [ 14, 4703 ], },
	# [4703] opcode : rr "(" iy "-" "[expr_NDIS]"
	{ ")" => 4704, },
	# [4704] opcode : rr "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1254 ], "," => 4705, ":" => [ 7, \&_action_opcode_1254 ], },
	# [4705] opcode : rr "(" iy "-" "[expr_NDIS]" ")" ","
	{ a => 4706, b => 4707, c => 4708, d => 4709, e => 4710, h => 4711, l => 4712, },
	# [4706] opcode : rr "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1255 ], ":" => [ 7, \&_action_opcode_1255 ], },
	# [4707] opcode : rr "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1256 ], ":" => [ 7, \&_action_opcode_1256 ], },
	# [4708] opcode : rr "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1257 ], ":" => [ 7, \&_action_opcode_1257 ], },
	# [4709] opcode : rr "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1258 ], ":" => [ 7, \&_action_opcode_1258 ], },
	# [4710] opcode : rr "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1259 ], ":" => [ 7, \&_action_opcode_1259 ], },
	# [4711] opcode : rr "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1260 ], ":" => [ 7, \&_action_opcode_1260 ], },
	# [4712] opcode : rr "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1261 ], ":" => [ 7, \&_action_opcode_1261 ], },
	# [4713] opcode : rr "["
	{ hl => 4714, ix => 4716, iy => 4748, },
	# [4714] opcode : rr "[" hl
	{ "]" => 4715, },
	# [4715] opcode : rr "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_1229 ], ":" => [ 7, \&_action_opcode_1229 ], },
	# [4716] opcode : rr "[" ix
	{ "+" => 4717, "-" => 4728, "]" => 4739, },
	# [4717] opcode : rr "[" ix "+"
	{ "!" => [ 12, 4718 ], "+" => [ 12, 4718 ], "-" => [ 12, 4718 ], __else__ => [ 12, 4718 ], "~" => [ 12, 4718 ], },
	# [4718] opcode : rr "[" ix "+" "[expr_DIS]"
	{ "]" => 4719, },
	# [4719] opcode : rr "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1238 ], "," => 4720, ":" => [ 7, \&_action_opcode_1238 ], },
	# [4720] opcode : rr "[" ix "+" "[expr_DIS]" "]" ","
	{ a => 4721, b => 4722, c => 4723, d => 4724, e => 4725, h => 4726, l => 4727, },
	# [4721] opcode : rr "[" ix "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1239 ], ":" => [ 7, \&_action_opcode_1239 ], },
	# [4722] opcode : rr "[" ix "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1240 ], ":" => [ 7, \&_action_opcode_1240 ], },
	# [4723] opcode : rr "[" ix "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1241 ], ":" => [ 7, \&_action_opcode_1241 ], },
	# [4724] opcode : rr "[" ix "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1242 ], ":" => [ 7, \&_action_opcode_1242 ], },
	# [4725] opcode : rr "[" ix "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1243 ], ":" => [ 7, \&_action_opcode_1243 ], },
	# [4726] opcode : rr "[" ix "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1244 ], ":" => [ 7, \&_action_opcode_1244 ], },
	# [4727] opcode : rr "[" ix "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1245 ], ":" => [ 7, \&_action_opcode_1245 ], },
	# [4728] opcode : rr "[" ix "-"
	{ "!" => [ 14, 4729 ], "+" => [ 14, 4729 ], "-" => [ 14, 4729 ], __else__ => [ 14, 4729 ], "~" => [ 14, 4729 ], },
	# [4729] opcode : rr "[" ix "-" "[expr_NDIS]"
	{ "]" => 4730, },
	# [4730] opcode : rr "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1238 ], "," => 4731, ":" => [ 7, \&_action_opcode_1238 ], },
	# [4731] opcode : rr "[" ix "-" "[expr_NDIS]" "]" ","
	{ a => 4732, b => 4733, c => 4734, d => 4735, e => 4736, h => 4737, l => 4738, },
	# [4732] opcode : rr "[" ix "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1239 ], ":" => [ 7, \&_action_opcode_1239 ], },
	# [4733] opcode : rr "[" ix "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1240 ], ":" => [ 7, \&_action_opcode_1240 ], },
	# [4734] opcode : rr "[" ix "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1241 ], ":" => [ 7, \&_action_opcode_1241 ], },
	# [4735] opcode : rr "[" ix "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1242 ], ":" => [ 7, \&_action_opcode_1242 ], },
	# [4736] opcode : rr "[" ix "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1243 ], ":" => [ 7, \&_action_opcode_1243 ], },
	# [4737] opcode : rr "[" ix "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1244 ], ":" => [ 7, \&_action_opcode_1244 ], },
	# [4738] opcode : rr "[" ix "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1245 ], ":" => [ 7, \&_action_opcode_1245 ], },
	# [4739] opcode : rr "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_1230 ], "," => 4740, ":" => [ 7, \&_action_opcode_1230 ], },
	# [4740] opcode : rr "[" ix "]" ","
	{ a => 4741, b => 4742, c => 4743, d => 4744, e => 4745, h => 4746, l => 4747, },
	# [4741] opcode : rr "[" ix "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1231 ], ":" => [ 7, \&_action_opcode_1231 ], },
	# [4742] opcode : rr "[" ix "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1232 ], ":" => [ 7, \&_action_opcode_1232 ], },
	# [4743] opcode : rr "[" ix "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1233 ], ":" => [ 7, \&_action_opcode_1233 ], },
	# [4744] opcode : rr "[" ix "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1234 ], ":" => [ 7, \&_action_opcode_1234 ], },
	# [4745] opcode : rr "[" ix "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1235 ], ":" => [ 7, \&_action_opcode_1235 ], },
	# [4746] opcode : rr "[" ix "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1236 ], ":" => [ 7, \&_action_opcode_1236 ], },
	# [4747] opcode : rr "[" ix "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1237 ], ":" => [ 7, \&_action_opcode_1237 ], },
	# [4748] opcode : rr "[" iy
	{ "+" => 4749, "-" => 4760, "]" => 4771, },
	# [4749] opcode : rr "[" iy "+"
	{ "!" => [ 12, 4750 ], "+" => [ 12, 4750 ], "-" => [ 12, 4750 ], __else__ => [ 12, 4750 ], "~" => [ 12, 4750 ], },
	# [4750] opcode : rr "[" iy "+" "[expr_DIS]"
	{ "]" => 4751, },
	# [4751] opcode : rr "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1254 ], "," => 4752, ":" => [ 7, \&_action_opcode_1254 ], },
	# [4752] opcode : rr "[" iy "+" "[expr_DIS]" "]" ","
	{ a => 4753, b => 4754, c => 4755, d => 4756, e => 4757, h => 4758, l => 4759, },
	# [4753] opcode : rr "[" iy "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1255 ], ":" => [ 7, \&_action_opcode_1255 ], },
	# [4754] opcode : rr "[" iy "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1256 ], ":" => [ 7, \&_action_opcode_1256 ], },
	# [4755] opcode : rr "[" iy "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1257 ], ":" => [ 7, \&_action_opcode_1257 ], },
	# [4756] opcode : rr "[" iy "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1258 ], ":" => [ 7, \&_action_opcode_1258 ], },
	# [4757] opcode : rr "[" iy "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1259 ], ":" => [ 7, \&_action_opcode_1259 ], },
	# [4758] opcode : rr "[" iy "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1260 ], ":" => [ 7, \&_action_opcode_1260 ], },
	# [4759] opcode : rr "[" iy "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1261 ], ":" => [ 7, \&_action_opcode_1261 ], },
	# [4760] opcode : rr "[" iy "-"
	{ "!" => [ 14, 4761 ], "+" => [ 14, 4761 ], "-" => [ 14, 4761 ], __else__ => [ 14, 4761 ], "~" => [ 14, 4761 ], },
	# [4761] opcode : rr "[" iy "-" "[expr_NDIS]"
	{ "]" => 4762, },
	# [4762] opcode : rr "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1254 ], "," => 4763, ":" => [ 7, \&_action_opcode_1254 ], },
	# [4763] opcode : rr "[" iy "-" "[expr_NDIS]" "]" ","
	{ a => 4764, b => 4765, c => 4766, d => 4767, e => 4768, h => 4769, l => 4770, },
	# [4764] opcode : rr "[" iy "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1255 ], ":" => [ 7, \&_action_opcode_1255 ], },
	# [4765] opcode : rr "[" iy "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1256 ], ":" => [ 7, \&_action_opcode_1256 ], },
	# [4766] opcode : rr "[" iy "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1257 ], ":" => [ 7, \&_action_opcode_1257 ], },
	# [4767] opcode : rr "[" iy "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1258 ], ":" => [ 7, \&_action_opcode_1258 ], },
	# [4768] opcode : rr "[" iy "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1259 ], ":" => [ 7, \&_action_opcode_1259 ], },
	# [4769] opcode : rr "[" iy "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1260 ], ":" => [ 7, \&_action_opcode_1260 ], },
	# [4770] opcode : rr "[" iy "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1261 ], ":" => [ 7, \&_action_opcode_1261 ], },
	# [4771] opcode : rr "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_1246 ], "," => 4772, ":" => [ 7, \&_action_opcode_1246 ], },
	# [4772] opcode : rr "[" iy "]" ","
	{ a => 4773, b => 4774, c => 4775, d => 4776, e => 4777, h => 4778, l => 4779, },
	# [4773] opcode : rr "[" iy "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1247 ], ":" => [ 7, \&_action_opcode_1247 ], },
	# [4774] opcode : rr "[" iy "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1248 ], ":" => [ 7, \&_action_opcode_1248 ], },
	# [4775] opcode : rr "[" iy "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1249 ], ":" => [ 7, \&_action_opcode_1249 ], },
	# [4776] opcode : rr "[" iy "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1250 ], ":" => [ 7, \&_action_opcode_1250 ], },
	# [4777] opcode : rr "[" iy "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1251 ], ":" => [ 7, \&_action_opcode_1251 ], },
	# [4778] opcode : rr "[" iy "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1252 ], ":" => [ 7, \&_action_opcode_1252 ], },
	# [4779] opcode : rr "[" iy "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1253 ], ":" => [ 7, \&_action_opcode_1253 ], },
	# [4780] opcode : rr a
	{ "\n" => [ 7, \&_action_opcode_1262 ], ":" => [ 7, \&_action_opcode_1262 ], },
	# [4781] opcode : rr b
	{ "\n" => [ 7, \&_action_opcode_1263 ], ":" => [ 7, \&_action_opcode_1263 ], },
	# [4782] opcode : rr bc
	{ "\n" => [ 7, \&_action_opcode_1264 ], ":" => [ 7, \&_action_opcode_1264 ], },
	# [4783] opcode : rr c
	{ "\n" => [ 7, \&_action_opcode_1265 ], ":" => [ 7, \&_action_opcode_1265 ], },
	# [4784] opcode : rr d
	{ "\n" => [ 7, \&_action_opcode_1266 ], ":" => [ 7, \&_action_opcode_1266 ], },
	# [4785] opcode : rr de
	{ "\n" => [ 7, \&_action_opcode_1267 ], ":" => [ 7, \&_action_opcode_1267 ], },
	# [4786] opcode : rr e
	{ "\n" => [ 7, \&_action_opcode_1268 ], ":" => [ 7, \&_action_opcode_1268 ], },
	# [4787] opcode : rr h
	{ "\n" => [ 7, \&_action_opcode_1269 ], ":" => [ 7, \&_action_opcode_1269 ], },
	# [4788] opcode : rr hl
	{ "\n" => [ 7, \&_action_opcode_1270 ], ":" => [ 7, \&_action_opcode_1270 ], },
	# [4789] opcode : rr l
	{ "\n" => [ 7, \&_action_opcode_1271 ], ":" => [ 7, \&_action_opcode_1271 ], },
	# [4790] opcode : rra
	{ "\n" => [ 7, \&_action_opcode_1272 ], ":" => [ 7, \&_action_opcode_1272 ], },
	# [4791] opcode : rrc
	{ "(" => 4792, "[" => 4859, a => 4926, b => 4927, c => 4928, d => 4929, e => 4930, h => 4931, l => 4932, },
	# [4792] opcode : rrc "("
	{ hl => 4793, ix => 4795, iy => 4827, },
	# [4793] opcode : rrc "(" hl
	{ ")" => 4794, },
	# [4794] opcode : rrc "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_1273 ], ":" => [ 7, \&_action_opcode_1273 ], },
	# [4795] opcode : rrc "(" ix
	{ ")" => 4796, "+" => 4805, "-" => 4816, },
	# [4796] opcode : rrc "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_1274 ], "," => 4797, ":" => [ 7, \&_action_opcode_1274 ], },
	# [4797] opcode : rrc "(" ix ")" ","
	{ a => 4798, b => 4799, c => 4800, d => 4801, e => 4802, h => 4803, l => 4804, },
	# [4798] opcode : rrc "(" ix ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1275 ], ":" => [ 7, \&_action_opcode_1275 ], },
	# [4799] opcode : rrc "(" ix ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1276 ], ":" => [ 7, \&_action_opcode_1276 ], },
	# [4800] opcode : rrc "(" ix ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1277 ], ":" => [ 7, \&_action_opcode_1277 ], },
	# [4801] opcode : rrc "(" ix ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1278 ], ":" => [ 7, \&_action_opcode_1278 ], },
	# [4802] opcode : rrc "(" ix ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1279 ], ":" => [ 7, \&_action_opcode_1279 ], },
	# [4803] opcode : rrc "(" ix ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1280 ], ":" => [ 7, \&_action_opcode_1280 ], },
	# [4804] opcode : rrc "(" ix ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1281 ], ":" => [ 7, \&_action_opcode_1281 ], },
	# [4805] opcode : rrc "(" ix "+"
	{ "!" => [ 12, 4806 ], "+" => [ 12, 4806 ], "-" => [ 12, 4806 ], __else__ => [ 12, 4806 ], "~" => [ 12, 4806 ], },
	# [4806] opcode : rrc "(" ix "+" "[expr_DIS]"
	{ ")" => 4807, },
	# [4807] opcode : rrc "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1282 ], "," => 4808, ":" => [ 7, \&_action_opcode_1282 ], },
	# [4808] opcode : rrc "(" ix "+" "[expr_DIS]" ")" ","
	{ a => 4809, b => 4810, c => 4811, d => 4812, e => 4813, h => 4814, l => 4815, },
	# [4809] opcode : rrc "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1283 ], ":" => [ 7, \&_action_opcode_1283 ], },
	# [4810] opcode : rrc "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1284 ], ":" => [ 7, \&_action_opcode_1284 ], },
	# [4811] opcode : rrc "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1285 ], ":" => [ 7, \&_action_opcode_1285 ], },
	# [4812] opcode : rrc "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1286 ], ":" => [ 7, \&_action_opcode_1286 ], },
	# [4813] opcode : rrc "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1287 ], ":" => [ 7, \&_action_opcode_1287 ], },
	# [4814] opcode : rrc "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1288 ], ":" => [ 7, \&_action_opcode_1288 ], },
	# [4815] opcode : rrc "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1289 ], ":" => [ 7, \&_action_opcode_1289 ], },
	# [4816] opcode : rrc "(" ix "-"
	{ "!" => [ 14, 4817 ], "+" => [ 14, 4817 ], "-" => [ 14, 4817 ], __else__ => [ 14, 4817 ], "~" => [ 14, 4817 ], },
	# [4817] opcode : rrc "(" ix "-" "[expr_NDIS]"
	{ ")" => 4818, },
	# [4818] opcode : rrc "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1282 ], "," => 4819, ":" => [ 7, \&_action_opcode_1282 ], },
	# [4819] opcode : rrc "(" ix "-" "[expr_NDIS]" ")" ","
	{ a => 4820, b => 4821, c => 4822, d => 4823, e => 4824, h => 4825, l => 4826, },
	# [4820] opcode : rrc "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1283 ], ":" => [ 7, \&_action_opcode_1283 ], },
	# [4821] opcode : rrc "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1284 ], ":" => [ 7, \&_action_opcode_1284 ], },
	# [4822] opcode : rrc "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1285 ], ":" => [ 7, \&_action_opcode_1285 ], },
	# [4823] opcode : rrc "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1286 ], ":" => [ 7, \&_action_opcode_1286 ], },
	# [4824] opcode : rrc "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1287 ], ":" => [ 7, \&_action_opcode_1287 ], },
	# [4825] opcode : rrc "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1288 ], ":" => [ 7, \&_action_opcode_1288 ], },
	# [4826] opcode : rrc "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1289 ], ":" => [ 7, \&_action_opcode_1289 ], },
	# [4827] opcode : rrc "(" iy
	{ ")" => 4828, "+" => 4837, "-" => 4848, },
	# [4828] opcode : rrc "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_1290 ], "," => 4829, ":" => [ 7, \&_action_opcode_1290 ], },
	# [4829] opcode : rrc "(" iy ")" ","
	{ a => 4830, b => 4831, c => 4832, d => 4833, e => 4834, h => 4835, l => 4836, },
	# [4830] opcode : rrc "(" iy ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1291 ], ":" => [ 7, \&_action_opcode_1291 ], },
	# [4831] opcode : rrc "(" iy ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1292 ], ":" => [ 7, \&_action_opcode_1292 ], },
	# [4832] opcode : rrc "(" iy ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1293 ], ":" => [ 7, \&_action_opcode_1293 ], },
	# [4833] opcode : rrc "(" iy ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1294 ], ":" => [ 7, \&_action_opcode_1294 ], },
	# [4834] opcode : rrc "(" iy ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1295 ], ":" => [ 7, \&_action_opcode_1295 ], },
	# [4835] opcode : rrc "(" iy ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1296 ], ":" => [ 7, \&_action_opcode_1296 ], },
	# [4836] opcode : rrc "(" iy ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1297 ], ":" => [ 7, \&_action_opcode_1297 ], },
	# [4837] opcode : rrc "(" iy "+"
	{ "!" => [ 12, 4838 ], "+" => [ 12, 4838 ], "-" => [ 12, 4838 ], __else__ => [ 12, 4838 ], "~" => [ 12, 4838 ], },
	# [4838] opcode : rrc "(" iy "+" "[expr_DIS]"
	{ ")" => 4839, },
	# [4839] opcode : rrc "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1298 ], "," => 4840, ":" => [ 7, \&_action_opcode_1298 ], },
	# [4840] opcode : rrc "(" iy "+" "[expr_DIS]" ")" ","
	{ a => 4841, b => 4842, c => 4843, d => 4844, e => 4845, h => 4846, l => 4847, },
	# [4841] opcode : rrc "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1299 ], ":" => [ 7, \&_action_opcode_1299 ], },
	# [4842] opcode : rrc "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1300 ], ":" => [ 7, \&_action_opcode_1300 ], },
	# [4843] opcode : rrc "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1301 ], ":" => [ 7, \&_action_opcode_1301 ], },
	# [4844] opcode : rrc "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1302 ], ":" => [ 7, \&_action_opcode_1302 ], },
	# [4845] opcode : rrc "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1303 ], ":" => [ 7, \&_action_opcode_1303 ], },
	# [4846] opcode : rrc "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1304 ], ":" => [ 7, \&_action_opcode_1304 ], },
	# [4847] opcode : rrc "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1305 ], ":" => [ 7, \&_action_opcode_1305 ], },
	# [4848] opcode : rrc "(" iy "-"
	{ "!" => [ 14, 4849 ], "+" => [ 14, 4849 ], "-" => [ 14, 4849 ], __else__ => [ 14, 4849 ], "~" => [ 14, 4849 ], },
	# [4849] opcode : rrc "(" iy "-" "[expr_NDIS]"
	{ ")" => 4850, },
	# [4850] opcode : rrc "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1298 ], "," => 4851, ":" => [ 7, \&_action_opcode_1298 ], },
	# [4851] opcode : rrc "(" iy "-" "[expr_NDIS]" ")" ","
	{ a => 4852, b => 4853, c => 4854, d => 4855, e => 4856, h => 4857, l => 4858, },
	# [4852] opcode : rrc "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1299 ], ":" => [ 7, \&_action_opcode_1299 ], },
	# [4853] opcode : rrc "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1300 ], ":" => [ 7, \&_action_opcode_1300 ], },
	# [4854] opcode : rrc "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1301 ], ":" => [ 7, \&_action_opcode_1301 ], },
	# [4855] opcode : rrc "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1302 ], ":" => [ 7, \&_action_opcode_1302 ], },
	# [4856] opcode : rrc "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1303 ], ":" => [ 7, \&_action_opcode_1303 ], },
	# [4857] opcode : rrc "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1304 ], ":" => [ 7, \&_action_opcode_1304 ], },
	# [4858] opcode : rrc "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1305 ], ":" => [ 7, \&_action_opcode_1305 ], },
	# [4859] opcode : rrc "["
	{ hl => 4860, ix => 4862, iy => 4894, },
	# [4860] opcode : rrc "[" hl
	{ "]" => 4861, },
	# [4861] opcode : rrc "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_1273 ], ":" => [ 7, \&_action_opcode_1273 ], },
	# [4862] opcode : rrc "[" ix
	{ "+" => 4863, "-" => 4874, "]" => 4885, },
	# [4863] opcode : rrc "[" ix "+"
	{ "!" => [ 12, 4864 ], "+" => [ 12, 4864 ], "-" => [ 12, 4864 ], __else__ => [ 12, 4864 ], "~" => [ 12, 4864 ], },
	# [4864] opcode : rrc "[" ix "+" "[expr_DIS]"
	{ "]" => 4865, },
	# [4865] opcode : rrc "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1282 ], "," => 4866, ":" => [ 7, \&_action_opcode_1282 ], },
	# [4866] opcode : rrc "[" ix "+" "[expr_DIS]" "]" ","
	{ a => 4867, b => 4868, c => 4869, d => 4870, e => 4871, h => 4872, l => 4873, },
	# [4867] opcode : rrc "[" ix "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1283 ], ":" => [ 7, \&_action_opcode_1283 ], },
	# [4868] opcode : rrc "[" ix "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1284 ], ":" => [ 7, \&_action_opcode_1284 ], },
	# [4869] opcode : rrc "[" ix "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1285 ], ":" => [ 7, \&_action_opcode_1285 ], },
	# [4870] opcode : rrc "[" ix "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1286 ], ":" => [ 7, \&_action_opcode_1286 ], },
	# [4871] opcode : rrc "[" ix "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1287 ], ":" => [ 7, \&_action_opcode_1287 ], },
	# [4872] opcode : rrc "[" ix "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1288 ], ":" => [ 7, \&_action_opcode_1288 ], },
	# [4873] opcode : rrc "[" ix "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1289 ], ":" => [ 7, \&_action_opcode_1289 ], },
	# [4874] opcode : rrc "[" ix "-"
	{ "!" => [ 14, 4875 ], "+" => [ 14, 4875 ], "-" => [ 14, 4875 ], __else__ => [ 14, 4875 ], "~" => [ 14, 4875 ], },
	# [4875] opcode : rrc "[" ix "-" "[expr_NDIS]"
	{ "]" => 4876, },
	# [4876] opcode : rrc "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1282 ], "," => 4877, ":" => [ 7, \&_action_opcode_1282 ], },
	# [4877] opcode : rrc "[" ix "-" "[expr_NDIS]" "]" ","
	{ a => 4878, b => 4879, c => 4880, d => 4881, e => 4882, h => 4883, l => 4884, },
	# [4878] opcode : rrc "[" ix "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1283 ], ":" => [ 7, \&_action_opcode_1283 ], },
	# [4879] opcode : rrc "[" ix "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1284 ], ":" => [ 7, \&_action_opcode_1284 ], },
	# [4880] opcode : rrc "[" ix "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1285 ], ":" => [ 7, \&_action_opcode_1285 ], },
	# [4881] opcode : rrc "[" ix "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1286 ], ":" => [ 7, \&_action_opcode_1286 ], },
	# [4882] opcode : rrc "[" ix "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1287 ], ":" => [ 7, \&_action_opcode_1287 ], },
	# [4883] opcode : rrc "[" ix "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1288 ], ":" => [ 7, \&_action_opcode_1288 ], },
	# [4884] opcode : rrc "[" ix "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1289 ], ":" => [ 7, \&_action_opcode_1289 ], },
	# [4885] opcode : rrc "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_1274 ], "," => 4886, ":" => [ 7, \&_action_opcode_1274 ], },
	# [4886] opcode : rrc "[" ix "]" ","
	{ a => 4887, b => 4888, c => 4889, d => 4890, e => 4891, h => 4892, l => 4893, },
	# [4887] opcode : rrc "[" ix "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1275 ], ":" => [ 7, \&_action_opcode_1275 ], },
	# [4888] opcode : rrc "[" ix "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1276 ], ":" => [ 7, \&_action_opcode_1276 ], },
	# [4889] opcode : rrc "[" ix "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1277 ], ":" => [ 7, \&_action_opcode_1277 ], },
	# [4890] opcode : rrc "[" ix "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1278 ], ":" => [ 7, \&_action_opcode_1278 ], },
	# [4891] opcode : rrc "[" ix "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1279 ], ":" => [ 7, \&_action_opcode_1279 ], },
	# [4892] opcode : rrc "[" ix "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1280 ], ":" => [ 7, \&_action_opcode_1280 ], },
	# [4893] opcode : rrc "[" ix "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1281 ], ":" => [ 7, \&_action_opcode_1281 ], },
	# [4894] opcode : rrc "[" iy
	{ "+" => 4895, "-" => 4906, "]" => 4917, },
	# [4895] opcode : rrc "[" iy "+"
	{ "!" => [ 12, 4896 ], "+" => [ 12, 4896 ], "-" => [ 12, 4896 ], __else__ => [ 12, 4896 ], "~" => [ 12, 4896 ], },
	# [4896] opcode : rrc "[" iy "+" "[expr_DIS]"
	{ "]" => 4897, },
	# [4897] opcode : rrc "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1298 ], "," => 4898, ":" => [ 7, \&_action_opcode_1298 ], },
	# [4898] opcode : rrc "[" iy "+" "[expr_DIS]" "]" ","
	{ a => 4899, b => 4900, c => 4901, d => 4902, e => 4903, h => 4904, l => 4905, },
	# [4899] opcode : rrc "[" iy "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1299 ], ":" => [ 7, \&_action_opcode_1299 ], },
	# [4900] opcode : rrc "[" iy "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1300 ], ":" => [ 7, \&_action_opcode_1300 ], },
	# [4901] opcode : rrc "[" iy "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1301 ], ":" => [ 7, \&_action_opcode_1301 ], },
	# [4902] opcode : rrc "[" iy "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1302 ], ":" => [ 7, \&_action_opcode_1302 ], },
	# [4903] opcode : rrc "[" iy "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1303 ], ":" => [ 7, \&_action_opcode_1303 ], },
	# [4904] opcode : rrc "[" iy "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1304 ], ":" => [ 7, \&_action_opcode_1304 ], },
	# [4905] opcode : rrc "[" iy "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1305 ], ":" => [ 7, \&_action_opcode_1305 ], },
	# [4906] opcode : rrc "[" iy "-"
	{ "!" => [ 14, 4907 ], "+" => [ 14, 4907 ], "-" => [ 14, 4907 ], __else__ => [ 14, 4907 ], "~" => [ 14, 4907 ], },
	# [4907] opcode : rrc "[" iy "-" "[expr_NDIS]"
	{ "]" => 4908, },
	# [4908] opcode : rrc "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1298 ], "," => 4909, ":" => [ 7, \&_action_opcode_1298 ], },
	# [4909] opcode : rrc "[" iy "-" "[expr_NDIS]" "]" ","
	{ a => 4910, b => 4911, c => 4912, d => 4913, e => 4914, h => 4915, l => 4916, },
	# [4910] opcode : rrc "[" iy "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1299 ], ":" => [ 7, \&_action_opcode_1299 ], },
	# [4911] opcode : rrc "[" iy "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1300 ], ":" => [ 7, \&_action_opcode_1300 ], },
	# [4912] opcode : rrc "[" iy "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1301 ], ":" => [ 7, \&_action_opcode_1301 ], },
	# [4913] opcode : rrc "[" iy "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1302 ], ":" => [ 7, \&_action_opcode_1302 ], },
	# [4914] opcode : rrc "[" iy "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1303 ], ":" => [ 7, \&_action_opcode_1303 ], },
	# [4915] opcode : rrc "[" iy "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1304 ], ":" => [ 7, \&_action_opcode_1304 ], },
	# [4916] opcode : rrc "[" iy "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1305 ], ":" => [ 7, \&_action_opcode_1305 ], },
	# [4917] opcode : rrc "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_1290 ], "," => 4918, ":" => [ 7, \&_action_opcode_1290 ], },
	# [4918] opcode : rrc "[" iy "]" ","
	{ a => 4919, b => 4920, c => 4921, d => 4922, e => 4923, h => 4924, l => 4925, },
	# [4919] opcode : rrc "[" iy "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1291 ], ":" => [ 7, \&_action_opcode_1291 ], },
	# [4920] opcode : rrc "[" iy "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1292 ], ":" => [ 7, \&_action_opcode_1292 ], },
	# [4921] opcode : rrc "[" iy "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1293 ], ":" => [ 7, \&_action_opcode_1293 ], },
	# [4922] opcode : rrc "[" iy "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1294 ], ":" => [ 7, \&_action_opcode_1294 ], },
	# [4923] opcode : rrc "[" iy "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1295 ], ":" => [ 7, \&_action_opcode_1295 ], },
	# [4924] opcode : rrc "[" iy "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1296 ], ":" => [ 7, \&_action_opcode_1296 ], },
	# [4925] opcode : rrc "[" iy "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1297 ], ":" => [ 7, \&_action_opcode_1297 ], },
	# [4926] opcode : rrc a
	{ "\n" => [ 7, \&_action_opcode_1306 ], ":" => [ 7, \&_action_opcode_1306 ], },
	# [4927] opcode : rrc b
	{ "\n" => [ 7, \&_action_opcode_1307 ], ":" => [ 7, \&_action_opcode_1307 ], },
	# [4928] opcode : rrc c
	{ "\n" => [ 7, \&_action_opcode_1308 ], ":" => [ 7, \&_action_opcode_1308 ], },
	# [4929] opcode : rrc d
	{ "\n" => [ 7, \&_action_opcode_1309 ], ":" => [ 7, \&_action_opcode_1309 ], },
	# [4930] opcode : rrc e
	{ "\n" => [ 7, \&_action_opcode_1310 ], ":" => [ 7, \&_action_opcode_1310 ], },
	# [4931] opcode : rrc h
	{ "\n" => [ 7, \&_action_opcode_1311 ], ":" => [ 7, \&_action_opcode_1311 ], },
	# [4932] opcode : rrc l
	{ "\n" => [ 7, \&_action_opcode_1312 ], ":" => [ 7, \&_action_opcode_1312 ], },
	# [4933] opcode : rrca
	{ "\n" => [ 7, \&_action_opcode_1313 ], ":" => [ 7, \&_action_opcode_1313 ], },
	# [4934] opcode : rrd
	{ "\n" => [ 7, \&_action_opcode_1314 ], ":" => [ 7, \&_action_opcode_1314 ], },
	# [4935] opcode : rst
	{ "!" => [ 30, 4936 ], "+" => [ 30, 4936 ], "-" => [ 30, 4936 ], __else__ => [ 30, 4936 ], "~" => [ 30, 4936 ], },
	# [4936] opcode : rst "[inline_const]"
	{ 0 => 4937, 1 => 4938, 16 => 4939, 2 => 4940, 24 => 4941, 3 => 4942, 32 => 4943, 4 => 4944, 40 => 4945, 48 => 4946, 5 => 4947, 56 => 4948, 6 => 4949, 7 => 4950, 8 => 4951, },
	# [4937] opcode : rst "[inline_const]" 0
	{ "\n" => [ 7, \&_action_opcode_1315 ], ":" => [ 7, \&_action_opcode_1315 ], },
	# [4938] opcode : rst "[inline_const]" 1
	{ "\n" => [ 7, \&_action_opcode_1316 ], ":" => [ 7, \&_action_opcode_1316 ], },
	# [4939] opcode : rst "[inline_const]" 16
	{ "\n" => [ 7, \&_action_opcode_1317 ], ":" => [ 7, \&_action_opcode_1317 ], },
	# [4940] opcode : rst "[inline_const]" 2
	{ "\n" => [ 7, \&_action_opcode_1317 ], ":" => [ 7, \&_action_opcode_1317 ], },
	# [4941] opcode : rst "[inline_const]" 24
	{ "\n" => [ 7, \&_action_opcode_1318 ], ":" => [ 7, \&_action_opcode_1318 ], },
	# [4942] opcode : rst "[inline_const]" 3
	{ "\n" => [ 7, \&_action_opcode_1318 ], ":" => [ 7, \&_action_opcode_1318 ], },
	# [4943] opcode : rst "[inline_const]" 32
	{ "\n" => [ 7, \&_action_opcode_1319 ], ":" => [ 7, \&_action_opcode_1319 ], },
	# [4944] opcode : rst "[inline_const]" 4
	{ "\n" => [ 7, \&_action_opcode_1319 ], ":" => [ 7, \&_action_opcode_1319 ], },
	# [4945] opcode : rst "[inline_const]" 40
	{ "\n" => [ 7, \&_action_opcode_1320 ], ":" => [ 7, \&_action_opcode_1320 ], },
	# [4946] opcode : rst "[inline_const]" 48
	{ "\n" => [ 7, \&_action_opcode_1321 ], ":" => [ 7, \&_action_opcode_1321 ], },
	# [4947] opcode : rst "[inline_const]" 5
	{ "\n" => [ 7, \&_action_opcode_1320 ], ":" => [ 7, \&_action_opcode_1320 ], },
	# [4948] opcode : rst "[inline_const]" 56
	{ "\n" => [ 7, \&_action_opcode_1322 ], ":" => [ 7, \&_action_opcode_1322 ], },
	# [4949] opcode : rst "[inline_const]" 6
	{ "\n" => [ 7, \&_action_opcode_1321 ], ":" => [ 7, \&_action_opcode_1321 ], },
	# [4950] opcode : rst "[inline_const]" 7
	{ "\n" => [ 7, \&_action_opcode_1322 ], ":" => [ 7, \&_action_opcode_1322 ], },
	# [4951] opcode : rst "[inline_const]" 8
	{ "\n" => [ 7, \&_action_opcode_1316 ], ":" => [ 7, \&_action_opcode_1316 ], },
	# [4952] opcode : sbc
	{ a => 4953, hl => 5013, },
	# [4953] opcode : sbc a
	{ "," => 4954, },
	# [4954] opcode : sbc a ","
	{ "!" => [ 13, 4993 ], "(" => 4955, "+" => [ 13, 4993 ], "-" => [ 13, 4993 ], "[" => 4974, __else__ => [ 13, 4993 ], a => 4994, b => 4995, c => 4996, d => 4997, e => 4998, h => 4999, hx => 5000, hy => 5001, ixh => 5002, ixl => 5003, iyh => 5004, iyl => 5005, l => 5006, lx => 5007, ly => 5008, xh => 5009, xl => 5010, yh => 5011, yl => 5012, "~" => [ 13, 4993 ], },
	# [4955] opcode : sbc a "," "("
	{ hl => 4956, ix => 4958, iy => 4966, },
	# [4956] opcode : sbc a "," "(" hl
	{ ")" => 4957, },
	# [4957] opcode : sbc a "," "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_1323 ], ":" => [ 7, \&_action_opcode_1323 ], },
	# [4958] opcode : sbc a "," "(" ix
	{ ")" => 4959, "+" => 4960, "-" => 4963, },
	# [4959] opcode : sbc a "," "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_1324 ], ":" => [ 7, \&_action_opcode_1324 ], },
	# [4960] opcode : sbc a "," "(" ix "+"
	{ "!" => [ 12, 4961 ], "+" => [ 12, 4961 ], "-" => [ 12, 4961 ], __else__ => [ 12, 4961 ], "~" => [ 12, 4961 ], },
	# [4961] opcode : sbc a "," "(" ix "+" "[expr_DIS]"
	{ ")" => 4962, },
	# [4962] opcode : sbc a "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1325 ], ":" => [ 7, \&_action_opcode_1325 ], },
	# [4963] opcode : sbc a "," "(" ix "-"
	{ "!" => [ 14, 4964 ], "+" => [ 14, 4964 ], "-" => [ 14, 4964 ], __else__ => [ 14, 4964 ], "~" => [ 14, 4964 ], },
	# [4964] opcode : sbc a "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 4965, },
	# [4965] opcode : sbc a "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1325 ], ":" => [ 7, \&_action_opcode_1325 ], },
	# [4966] opcode : sbc a "," "(" iy
	{ ")" => 4967, "+" => 4968, "-" => 4971, },
	# [4967] opcode : sbc a "," "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_1326 ], ":" => [ 7, \&_action_opcode_1326 ], },
	# [4968] opcode : sbc a "," "(" iy "+"
	{ "!" => [ 12, 4969 ], "+" => [ 12, 4969 ], "-" => [ 12, 4969 ], __else__ => [ 12, 4969 ], "~" => [ 12, 4969 ], },
	# [4969] opcode : sbc a "," "(" iy "+" "[expr_DIS]"
	{ ")" => 4970, },
	# [4970] opcode : sbc a "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1327 ], ":" => [ 7, \&_action_opcode_1327 ], },
	# [4971] opcode : sbc a "," "(" iy "-"
	{ "!" => [ 14, 4972 ], "+" => [ 14, 4972 ], "-" => [ 14, 4972 ], __else__ => [ 14, 4972 ], "~" => [ 14, 4972 ], },
	# [4972] opcode : sbc a "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 4973, },
	# [4973] opcode : sbc a "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1327 ], ":" => [ 7, \&_action_opcode_1327 ], },
	# [4974] opcode : sbc a "," "["
	{ hl => 4975, ix => 4977, iy => 4985, },
	# [4975] opcode : sbc a "," "[" hl
	{ "]" => 4976, },
	# [4976] opcode : sbc a "," "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_1323 ], ":" => [ 7, \&_action_opcode_1323 ], },
	# [4977] opcode : sbc a "," "[" ix
	{ "+" => 4978, "-" => 4981, "]" => 4984, },
	# [4978] opcode : sbc a "," "[" ix "+"
	{ "!" => [ 12, 4979 ], "+" => [ 12, 4979 ], "-" => [ 12, 4979 ], __else__ => [ 12, 4979 ], "~" => [ 12, 4979 ], },
	# [4979] opcode : sbc a "," "[" ix "+" "[expr_DIS]"
	{ "]" => 4980, },
	# [4980] opcode : sbc a "," "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1325 ], ":" => [ 7, \&_action_opcode_1325 ], },
	# [4981] opcode : sbc a "," "[" ix "-"
	{ "!" => [ 14, 4982 ], "+" => [ 14, 4982 ], "-" => [ 14, 4982 ], __else__ => [ 14, 4982 ], "~" => [ 14, 4982 ], },
	# [4982] opcode : sbc a "," "[" ix "-" "[expr_NDIS]"
	{ "]" => 4983, },
	# [4983] opcode : sbc a "," "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1325 ], ":" => [ 7, \&_action_opcode_1325 ], },
	# [4984] opcode : sbc a "," "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_1324 ], ":" => [ 7, \&_action_opcode_1324 ], },
	# [4985] opcode : sbc a "," "[" iy
	{ "+" => 4986, "-" => 4989, "]" => 4992, },
	# [4986] opcode : sbc a "," "[" iy "+"
	{ "!" => [ 12, 4987 ], "+" => [ 12, 4987 ], "-" => [ 12, 4987 ], __else__ => [ 12, 4987 ], "~" => [ 12, 4987 ], },
	# [4987] opcode : sbc a "," "[" iy "+" "[expr_DIS]"
	{ "]" => 4988, },
	# [4988] opcode : sbc a "," "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1327 ], ":" => [ 7, \&_action_opcode_1327 ], },
	# [4989] opcode : sbc a "," "[" iy "-"
	{ "!" => [ 14, 4990 ], "+" => [ 14, 4990 ], "-" => [ 14, 4990 ], __else__ => [ 14, 4990 ], "~" => [ 14, 4990 ], },
	# [4990] opcode : sbc a "," "[" iy "-" "[expr_NDIS]"
	{ "]" => 4991, },
	# [4991] opcode : sbc a "," "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1327 ], ":" => [ 7, \&_action_opcode_1327 ], },
	# [4992] opcode : sbc a "," "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_1326 ], ":" => [ 7, \&_action_opcode_1326 ], },
	# [4993] opcode : sbc a "," "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_1328 ], ":" => [ 7, \&_action_opcode_1328 ], },
	# [4994] opcode : sbc a "," a
	{ "\n" => [ 7, \&_action_opcode_1329 ], ":" => [ 7, \&_action_opcode_1329 ], },
	# [4995] opcode : sbc a "," b
	{ "\n" => [ 7, \&_action_opcode_1330 ], ":" => [ 7, \&_action_opcode_1330 ], },
	# [4996] opcode : sbc a "," c
	{ "\n" => [ 7, \&_action_opcode_1331 ], ":" => [ 7, \&_action_opcode_1331 ], },
	# [4997] opcode : sbc a "," d
	{ "\n" => [ 7, \&_action_opcode_1332 ], ":" => [ 7, \&_action_opcode_1332 ], },
	# [4998] opcode : sbc a "," e
	{ "\n" => [ 7, \&_action_opcode_1333 ], ":" => [ 7, \&_action_opcode_1333 ], },
	# [4999] opcode : sbc a "," h
	{ "\n" => [ 7, \&_action_opcode_1334 ], ":" => [ 7, \&_action_opcode_1334 ], },
	# [5000] opcode : sbc a "," hx
	{ "\n" => [ 7, \&_action_opcode_1335 ], ":" => [ 7, \&_action_opcode_1335 ], },
	# [5001] opcode : sbc a "," hy
	{ "\n" => [ 7, \&_action_opcode_1336 ], ":" => [ 7, \&_action_opcode_1336 ], },
	# [5002] opcode : sbc a "," ixh
	{ "\n" => [ 7, \&_action_opcode_1335 ], ":" => [ 7, \&_action_opcode_1335 ], },
	# [5003] opcode : sbc a "," ixl
	{ "\n" => [ 7, \&_action_opcode_1337 ], ":" => [ 7, \&_action_opcode_1337 ], },
	# [5004] opcode : sbc a "," iyh
	{ "\n" => [ 7, \&_action_opcode_1336 ], ":" => [ 7, \&_action_opcode_1336 ], },
	# [5005] opcode : sbc a "," iyl
	{ "\n" => [ 7, \&_action_opcode_1338 ], ":" => [ 7, \&_action_opcode_1338 ], },
	# [5006] opcode : sbc a "," l
	{ "\n" => [ 7, \&_action_opcode_1339 ], ":" => [ 7, \&_action_opcode_1339 ], },
	# [5007] opcode : sbc a "," lx
	{ "\n" => [ 7, \&_action_opcode_1337 ], ":" => [ 7, \&_action_opcode_1337 ], },
	# [5008] opcode : sbc a "," ly
	{ "\n" => [ 7, \&_action_opcode_1338 ], ":" => [ 7, \&_action_opcode_1338 ], },
	# [5009] opcode : sbc a "," xh
	{ "\n" => [ 7, \&_action_opcode_1335 ], ":" => [ 7, \&_action_opcode_1335 ], },
	# [5010] opcode : sbc a "," xl
	{ "\n" => [ 7, \&_action_opcode_1337 ], ":" => [ 7, \&_action_opcode_1337 ], },
	# [5011] opcode : sbc a "," yh
	{ "\n" => [ 7, \&_action_opcode_1336 ], ":" => [ 7, \&_action_opcode_1336 ], },
	# [5012] opcode : sbc a "," yl
	{ "\n" => [ 7, \&_action_opcode_1338 ], ":" => [ 7, \&_action_opcode_1338 ], },
	# [5013] opcode : sbc hl
	{ "," => 5014, },
	# [5014] opcode : sbc hl ","
	{ bc => 5015, de => 5016, hl => 5017, sp => 5018, },
	# [5015] opcode : sbc hl "," bc
	{ "\n" => [ 7, \&_action_opcode_1340 ], ":" => [ 7, \&_action_opcode_1340 ], },
	# [5016] opcode : sbc hl "," de
	{ "\n" => [ 7, \&_action_opcode_1341 ], ":" => [ 7, \&_action_opcode_1341 ], },
	# [5017] opcode : sbc hl "," hl
	{ "\n" => [ 7, \&_action_opcode_1342 ], ":" => [ 7, \&_action_opcode_1342 ], },
	# [5018] opcode : sbc hl "," sp
	{ "\n" => [ 7, \&_action_opcode_1343 ], ":" => [ 7, \&_action_opcode_1343 ], },
	# [5019] opcode : scf
	{ "\n" => [ 7, \&_action_opcode_1344 ], ":" => [ 7, \&_action_opcode_1344 ], },
	# [5020] opcode : set
	{ "!" => [ 30, 5021 ], "+" => [ 30, 5021 ], "-" => [ 30, 5021 ], __else__ => [ 30, 5021 ], "~" => [ 30, 5021 ], },
	# [5021] opcode : set "[inline_const]"
	{ 0 => 5022, 1 => 5165, 2 => 5308, 3 => 5451, 4 => 5594, 5 => 5737, 6 => 5880, 7 => 6023, },
	# [5022] opcode : set "[inline_const]" 0
	{ "," => 5023, },
	# [5023] opcode : set "[inline_const]" 0 ","
	{ "(" => 5024, "[" => 5091, a => 5158, b => 5159, c => 5160, d => 5161, e => 5162, h => 5163, l => 5164, },
	# [5024] opcode : set "[inline_const]" 0 "," "("
	{ hl => 5025, ix => 5027, iy => 5059, },
	# [5025] opcode : set "[inline_const]" 0 "," "(" hl
	{ ")" => 5026, },
	# [5026] opcode : set "[inline_const]" 0 "," "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_1345 ], ":" => [ 7, \&_action_opcode_1345 ], },
	# [5027] opcode : set "[inline_const]" 0 "," "(" ix
	{ ")" => 5028, "+" => 5037, "-" => 5048, },
	# [5028] opcode : set "[inline_const]" 0 "," "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_1346 ], "," => 5029, ":" => [ 7, \&_action_opcode_1346 ], },
	# [5029] opcode : set "[inline_const]" 0 "," "(" ix ")" ","
	{ a => 5030, b => 5031, c => 5032, d => 5033, e => 5034, h => 5035, l => 5036, },
	# [5030] opcode : set "[inline_const]" 0 "," "(" ix ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1347 ], ":" => [ 7, \&_action_opcode_1347 ], },
	# [5031] opcode : set "[inline_const]" 0 "," "(" ix ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1348 ], ":" => [ 7, \&_action_opcode_1348 ], },
	# [5032] opcode : set "[inline_const]" 0 "," "(" ix ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1349 ], ":" => [ 7, \&_action_opcode_1349 ], },
	# [5033] opcode : set "[inline_const]" 0 "," "(" ix ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1350 ], ":" => [ 7, \&_action_opcode_1350 ], },
	# [5034] opcode : set "[inline_const]" 0 "," "(" ix ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1351 ], ":" => [ 7, \&_action_opcode_1351 ], },
	# [5035] opcode : set "[inline_const]" 0 "," "(" ix ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1352 ], ":" => [ 7, \&_action_opcode_1352 ], },
	# [5036] opcode : set "[inline_const]" 0 "," "(" ix ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1353 ], ":" => [ 7, \&_action_opcode_1353 ], },
	# [5037] opcode : set "[inline_const]" 0 "," "(" ix "+"
	{ "!" => [ 12, 5038 ], "+" => [ 12, 5038 ], "-" => [ 12, 5038 ], __else__ => [ 12, 5038 ], "~" => [ 12, 5038 ], },
	# [5038] opcode : set "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]"
	{ ")" => 5039, },
	# [5039] opcode : set "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1354 ], "," => 5040, ":" => [ 7, \&_action_opcode_1354 ], },
	# [5040] opcode : set "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" ","
	{ a => 5041, b => 5042, c => 5043, d => 5044, e => 5045, h => 5046, l => 5047, },
	# [5041] opcode : set "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1355 ], ":" => [ 7, \&_action_opcode_1355 ], },
	# [5042] opcode : set "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1356 ], ":" => [ 7, \&_action_opcode_1356 ], },
	# [5043] opcode : set "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1357 ], ":" => [ 7, \&_action_opcode_1357 ], },
	# [5044] opcode : set "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1358 ], ":" => [ 7, \&_action_opcode_1358 ], },
	# [5045] opcode : set "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1359 ], ":" => [ 7, \&_action_opcode_1359 ], },
	# [5046] opcode : set "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1360 ], ":" => [ 7, \&_action_opcode_1360 ], },
	# [5047] opcode : set "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1361 ], ":" => [ 7, \&_action_opcode_1361 ], },
	# [5048] opcode : set "[inline_const]" 0 "," "(" ix "-"
	{ "!" => [ 14, 5049 ], "+" => [ 14, 5049 ], "-" => [ 14, 5049 ], __else__ => [ 14, 5049 ], "~" => [ 14, 5049 ], },
	# [5049] opcode : set "[inline_const]" 0 "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 5050, },
	# [5050] opcode : set "[inline_const]" 0 "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1354 ], "," => 5051, ":" => [ 7, \&_action_opcode_1354 ], },
	# [5051] opcode : set "[inline_const]" 0 "," "(" ix "-" "[expr_NDIS]" ")" ","
	{ a => 5052, b => 5053, c => 5054, d => 5055, e => 5056, h => 5057, l => 5058, },
	# [5052] opcode : set "[inline_const]" 0 "," "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1355 ], ":" => [ 7, \&_action_opcode_1355 ], },
	# [5053] opcode : set "[inline_const]" 0 "," "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1356 ], ":" => [ 7, \&_action_opcode_1356 ], },
	# [5054] opcode : set "[inline_const]" 0 "," "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1357 ], ":" => [ 7, \&_action_opcode_1357 ], },
	# [5055] opcode : set "[inline_const]" 0 "," "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1358 ], ":" => [ 7, \&_action_opcode_1358 ], },
	# [5056] opcode : set "[inline_const]" 0 "," "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1359 ], ":" => [ 7, \&_action_opcode_1359 ], },
	# [5057] opcode : set "[inline_const]" 0 "," "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1360 ], ":" => [ 7, \&_action_opcode_1360 ], },
	# [5058] opcode : set "[inline_const]" 0 "," "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1361 ], ":" => [ 7, \&_action_opcode_1361 ], },
	# [5059] opcode : set "[inline_const]" 0 "," "(" iy
	{ ")" => 5060, "+" => 5069, "-" => 5080, },
	# [5060] opcode : set "[inline_const]" 0 "," "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_1362 ], "," => 5061, ":" => [ 7, \&_action_opcode_1362 ], },
	# [5061] opcode : set "[inline_const]" 0 "," "(" iy ")" ","
	{ a => 5062, b => 5063, c => 5064, d => 5065, e => 5066, h => 5067, l => 5068, },
	# [5062] opcode : set "[inline_const]" 0 "," "(" iy ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1363 ], ":" => [ 7, \&_action_opcode_1363 ], },
	# [5063] opcode : set "[inline_const]" 0 "," "(" iy ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1364 ], ":" => [ 7, \&_action_opcode_1364 ], },
	# [5064] opcode : set "[inline_const]" 0 "," "(" iy ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1365 ], ":" => [ 7, \&_action_opcode_1365 ], },
	# [5065] opcode : set "[inline_const]" 0 "," "(" iy ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1366 ], ":" => [ 7, \&_action_opcode_1366 ], },
	# [5066] opcode : set "[inline_const]" 0 "," "(" iy ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1367 ], ":" => [ 7, \&_action_opcode_1367 ], },
	# [5067] opcode : set "[inline_const]" 0 "," "(" iy ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1368 ], ":" => [ 7, \&_action_opcode_1368 ], },
	# [5068] opcode : set "[inline_const]" 0 "," "(" iy ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1369 ], ":" => [ 7, \&_action_opcode_1369 ], },
	# [5069] opcode : set "[inline_const]" 0 "," "(" iy "+"
	{ "!" => [ 12, 5070 ], "+" => [ 12, 5070 ], "-" => [ 12, 5070 ], __else__ => [ 12, 5070 ], "~" => [ 12, 5070 ], },
	# [5070] opcode : set "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]"
	{ ")" => 5071, },
	# [5071] opcode : set "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1370 ], "," => 5072, ":" => [ 7, \&_action_opcode_1370 ], },
	# [5072] opcode : set "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" ","
	{ a => 5073, b => 5074, c => 5075, d => 5076, e => 5077, h => 5078, l => 5079, },
	# [5073] opcode : set "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1371 ], ":" => [ 7, \&_action_opcode_1371 ], },
	# [5074] opcode : set "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1372 ], ":" => [ 7, \&_action_opcode_1372 ], },
	# [5075] opcode : set "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1373 ], ":" => [ 7, \&_action_opcode_1373 ], },
	# [5076] opcode : set "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1374 ], ":" => [ 7, \&_action_opcode_1374 ], },
	# [5077] opcode : set "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1375 ], ":" => [ 7, \&_action_opcode_1375 ], },
	# [5078] opcode : set "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1376 ], ":" => [ 7, \&_action_opcode_1376 ], },
	# [5079] opcode : set "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1377 ], ":" => [ 7, \&_action_opcode_1377 ], },
	# [5080] opcode : set "[inline_const]" 0 "," "(" iy "-"
	{ "!" => [ 14, 5081 ], "+" => [ 14, 5081 ], "-" => [ 14, 5081 ], __else__ => [ 14, 5081 ], "~" => [ 14, 5081 ], },
	# [5081] opcode : set "[inline_const]" 0 "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 5082, },
	# [5082] opcode : set "[inline_const]" 0 "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1370 ], "," => 5083, ":" => [ 7, \&_action_opcode_1370 ], },
	# [5083] opcode : set "[inline_const]" 0 "," "(" iy "-" "[expr_NDIS]" ")" ","
	{ a => 5084, b => 5085, c => 5086, d => 5087, e => 5088, h => 5089, l => 5090, },
	# [5084] opcode : set "[inline_const]" 0 "," "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1371 ], ":" => [ 7, \&_action_opcode_1371 ], },
	# [5085] opcode : set "[inline_const]" 0 "," "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1372 ], ":" => [ 7, \&_action_opcode_1372 ], },
	# [5086] opcode : set "[inline_const]" 0 "," "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1373 ], ":" => [ 7, \&_action_opcode_1373 ], },
	# [5087] opcode : set "[inline_const]" 0 "," "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1374 ], ":" => [ 7, \&_action_opcode_1374 ], },
	# [5088] opcode : set "[inline_const]" 0 "," "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1375 ], ":" => [ 7, \&_action_opcode_1375 ], },
	# [5089] opcode : set "[inline_const]" 0 "," "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1376 ], ":" => [ 7, \&_action_opcode_1376 ], },
	# [5090] opcode : set "[inline_const]" 0 "," "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1377 ], ":" => [ 7, \&_action_opcode_1377 ], },
	# [5091] opcode : set "[inline_const]" 0 "," "["
	{ hl => 5092, ix => 5094, iy => 5126, },
	# [5092] opcode : set "[inline_const]" 0 "," "[" hl
	{ "]" => 5093, },
	# [5093] opcode : set "[inline_const]" 0 "," "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_1345 ], ":" => [ 7, \&_action_opcode_1345 ], },
	# [5094] opcode : set "[inline_const]" 0 "," "[" ix
	{ "+" => 5095, "-" => 5106, "]" => 5117, },
	# [5095] opcode : set "[inline_const]" 0 "," "[" ix "+"
	{ "!" => [ 12, 5096 ], "+" => [ 12, 5096 ], "-" => [ 12, 5096 ], __else__ => [ 12, 5096 ], "~" => [ 12, 5096 ], },
	# [5096] opcode : set "[inline_const]" 0 "," "[" ix "+" "[expr_DIS]"
	{ "]" => 5097, },
	# [5097] opcode : set "[inline_const]" 0 "," "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1354 ], "," => 5098, ":" => [ 7, \&_action_opcode_1354 ], },
	# [5098] opcode : set "[inline_const]" 0 "," "[" ix "+" "[expr_DIS]" "]" ","
	{ a => 5099, b => 5100, c => 5101, d => 5102, e => 5103, h => 5104, l => 5105, },
	# [5099] opcode : set "[inline_const]" 0 "," "[" ix "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1355 ], ":" => [ 7, \&_action_opcode_1355 ], },
	# [5100] opcode : set "[inline_const]" 0 "," "[" ix "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1356 ], ":" => [ 7, \&_action_opcode_1356 ], },
	# [5101] opcode : set "[inline_const]" 0 "," "[" ix "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1357 ], ":" => [ 7, \&_action_opcode_1357 ], },
	# [5102] opcode : set "[inline_const]" 0 "," "[" ix "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1358 ], ":" => [ 7, \&_action_opcode_1358 ], },
	# [5103] opcode : set "[inline_const]" 0 "," "[" ix "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1359 ], ":" => [ 7, \&_action_opcode_1359 ], },
	# [5104] opcode : set "[inline_const]" 0 "," "[" ix "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1360 ], ":" => [ 7, \&_action_opcode_1360 ], },
	# [5105] opcode : set "[inline_const]" 0 "," "[" ix "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1361 ], ":" => [ 7, \&_action_opcode_1361 ], },
	# [5106] opcode : set "[inline_const]" 0 "," "[" ix "-"
	{ "!" => [ 14, 5107 ], "+" => [ 14, 5107 ], "-" => [ 14, 5107 ], __else__ => [ 14, 5107 ], "~" => [ 14, 5107 ], },
	# [5107] opcode : set "[inline_const]" 0 "," "[" ix "-" "[expr_NDIS]"
	{ "]" => 5108, },
	# [5108] opcode : set "[inline_const]" 0 "," "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1354 ], "," => 5109, ":" => [ 7, \&_action_opcode_1354 ], },
	# [5109] opcode : set "[inline_const]" 0 "," "[" ix "-" "[expr_NDIS]" "]" ","
	{ a => 5110, b => 5111, c => 5112, d => 5113, e => 5114, h => 5115, l => 5116, },
	# [5110] opcode : set "[inline_const]" 0 "," "[" ix "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1355 ], ":" => [ 7, \&_action_opcode_1355 ], },
	# [5111] opcode : set "[inline_const]" 0 "," "[" ix "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1356 ], ":" => [ 7, \&_action_opcode_1356 ], },
	# [5112] opcode : set "[inline_const]" 0 "," "[" ix "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1357 ], ":" => [ 7, \&_action_opcode_1357 ], },
	# [5113] opcode : set "[inline_const]" 0 "," "[" ix "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1358 ], ":" => [ 7, \&_action_opcode_1358 ], },
	# [5114] opcode : set "[inline_const]" 0 "," "[" ix "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1359 ], ":" => [ 7, \&_action_opcode_1359 ], },
	# [5115] opcode : set "[inline_const]" 0 "," "[" ix "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1360 ], ":" => [ 7, \&_action_opcode_1360 ], },
	# [5116] opcode : set "[inline_const]" 0 "," "[" ix "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1361 ], ":" => [ 7, \&_action_opcode_1361 ], },
	# [5117] opcode : set "[inline_const]" 0 "," "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_1346 ], "," => 5118, ":" => [ 7, \&_action_opcode_1346 ], },
	# [5118] opcode : set "[inline_const]" 0 "," "[" ix "]" ","
	{ a => 5119, b => 5120, c => 5121, d => 5122, e => 5123, h => 5124, l => 5125, },
	# [5119] opcode : set "[inline_const]" 0 "," "[" ix "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1347 ], ":" => [ 7, \&_action_opcode_1347 ], },
	# [5120] opcode : set "[inline_const]" 0 "," "[" ix "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1348 ], ":" => [ 7, \&_action_opcode_1348 ], },
	# [5121] opcode : set "[inline_const]" 0 "," "[" ix "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1349 ], ":" => [ 7, \&_action_opcode_1349 ], },
	# [5122] opcode : set "[inline_const]" 0 "," "[" ix "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1350 ], ":" => [ 7, \&_action_opcode_1350 ], },
	# [5123] opcode : set "[inline_const]" 0 "," "[" ix "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1351 ], ":" => [ 7, \&_action_opcode_1351 ], },
	# [5124] opcode : set "[inline_const]" 0 "," "[" ix "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1352 ], ":" => [ 7, \&_action_opcode_1352 ], },
	# [5125] opcode : set "[inline_const]" 0 "," "[" ix "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1353 ], ":" => [ 7, \&_action_opcode_1353 ], },
	# [5126] opcode : set "[inline_const]" 0 "," "[" iy
	{ "+" => 5127, "-" => 5138, "]" => 5149, },
	# [5127] opcode : set "[inline_const]" 0 "," "[" iy "+"
	{ "!" => [ 12, 5128 ], "+" => [ 12, 5128 ], "-" => [ 12, 5128 ], __else__ => [ 12, 5128 ], "~" => [ 12, 5128 ], },
	# [5128] opcode : set "[inline_const]" 0 "," "[" iy "+" "[expr_DIS]"
	{ "]" => 5129, },
	# [5129] opcode : set "[inline_const]" 0 "," "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1370 ], "," => 5130, ":" => [ 7, \&_action_opcode_1370 ], },
	# [5130] opcode : set "[inline_const]" 0 "," "[" iy "+" "[expr_DIS]" "]" ","
	{ a => 5131, b => 5132, c => 5133, d => 5134, e => 5135, h => 5136, l => 5137, },
	# [5131] opcode : set "[inline_const]" 0 "," "[" iy "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1371 ], ":" => [ 7, \&_action_opcode_1371 ], },
	# [5132] opcode : set "[inline_const]" 0 "," "[" iy "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1372 ], ":" => [ 7, \&_action_opcode_1372 ], },
	# [5133] opcode : set "[inline_const]" 0 "," "[" iy "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1373 ], ":" => [ 7, \&_action_opcode_1373 ], },
	# [5134] opcode : set "[inline_const]" 0 "," "[" iy "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1374 ], ":" => [ 7, \&_action_opcode_1374 ], },
	# [5135] opcode : set "[inline_const]" 0 "," "[" iy "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1375 ], ":" => [ 7, \&_action_opcode_1375 ], },
	# [5136] opcode : set "[inline_const]" 0 "," "[" iy "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1376 ], ":" => [ 7, \&_action_opcode_1376 ], },
	# [5137] opcode : set "[inline_const]" 0 "," "[" iy "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1377 ], ":" => [ 7, \&_action_opcode_1377 ], },
	# [5138] opcode : set "[inline_const]" 0 "," "[" iy "-"
	{ "!" => [ 14, 5139 ], "+" => [ 14, 5139 ], "-" => [ 14, 5139 ], __else__ => [ 14, 5139 ], "~" => [ 14, 5139 ], },
	# [5139] opcode : set "[inline_const]" 0 "," "[" iy "-" "[expr_NDIS]"
	{ "]" => 5140, },
	# [5140] opcode : set "[inline_const]" 0 "," "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1370 ], "," => 5141, ":" => [ 7, \&_action_opcode_1370 ], },
	# [5141] opcode : set "[inline_const]" 0 "," "[" iy "-" "[expr_NDIS]" "]" ","
	{ a => 5142, b => 5143, c => 5144, d => 5145, e => 5146, h => 5147, l => 5148, },
	# [5142] opcode : set "[inline_const]" 0 "," "[" iy "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1371 ], ":" => [ 7, \&_action_opcode_1371 ], },
	# [5143] opcode : set "[inline_const]" 0 "," "[" iy "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1372 ], ":" => [ 7, \&_action_opcode_1372 ], },
	# [5144] opcode : set "[inline_const]" 0 "," "[" iy "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1373 ], ":" => [ 7, \&_action_opcode_1373 ], },
	# [5145] opcode : set "[inline_const]" 0 "," "[" iy "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1374 ], ":" => [ 7, \&_action_opcode_1374 ], },
	# [5146] opcode : set "[inline_const]" 0 "," "[" iy "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1375 ], ":" => [ 7, \&_action_opcode_1375 ], },
	# [5147] opcode : set "[inline_const]" 0 "," "[" iy "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1376 ], ":" => [ 7, \&_action_opcode_1376 ], },
	# [5148] opcode : set "[inline_const]" 0 "," "[" iy "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1377 ], ":" => [ 7, \&_action_opcode_1377 ], },
	# [5149] opcode : set "[inline_const]" 0 "," "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_1362 ], "," => 5150, ":" => [ 7, \&_action_opcode_1362 ], },
	# [5150] opcode : set "[inline_const]" 0 "," "[" iy "]" ","
	{ a => 5151, b => 5152, c => 5153, d => 5154, e => 5155, h => 5156, l => 5157, },
	# [5151] opcode : set "[inline_const]" 0 "," "[" iy "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1363 ], ":" => [ 7, \&_action_opcode_1363 ], },
	# [5152] opcode : set "[inline_const]" 0 "," "[" iy "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1364 ], ":" => [ 7, \&_action_opcode_1364 ], },
	# [5153] opcode : set "[inline_const]" 0 "," "[" iy "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1365 ], ":" => [ 7, \&_action_opcode_1365 ], },
	# [5154] opcode : set "[inline_const]" 0 "," "[" iy "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1366 ], ":" => [ 7, \&_action_opcode_1366 ], },
	# [5155] opcode : set "[inline_const]" 0 "," "[" iy "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1367 ], ":" => [ 7, \&_action_opcode_1367 ], },
	# [5156] opcode : set "[inline_const]" 0 "," "[" iy "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1368 ], ":" => [ 7, \&_action_opcode_1368 ], },
	# [5157] opcode : set "[inline_const]" 0 "," "[" iy "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1369 ], ":" => [ 7, \&_action_opcode_1369 ], },
	# [5158] opcode : set "[inline_const]" 0 "," a
	{ "\n" => [ 7, \&_action_opcode_1378 ], ":" => [ 7, \&_action_opcode_1378 ], },
	# [5159] opcode : set "[inline_const]" 0 "," b
	{ "\n" => [ 7, \&_action_opcode_1379 ], ":" => [ 7, \&_action_opcode_1379 ], },
	# [5160] opcode : set "[inline_const]" 0 "," c
	{ "\n" => [ 7, \&_action_opcode_1380 ], ":" => [ 7, \&_action_opcode_1380 ], },
	# [5161] opcode : set "[inline_const]" 0 "," d
	{ "\n" => [ 7, \&_action_opcode_1381 ], ":" => [ 7, \&_action_opcode_1381 ], },
	# [5162] opcode : set "[inline_const]" 0 "," e
	{ "\n" => [ 7, \&_action_opcode_1382 ], ":" => [ 7, \&_action_opcode_1382 ], },
	# [5163] opcode : set "[inline_const]" 0 "," h
	{ "\n" => [ 7, \&_action_opcode_1383 ], ":" => [ 7, \&_action_opcode_1383 ], },
	# [5164] opcode : set "[inline_const]" 0 "," l
	{ "\n" => [ 7, \&_action_opcode_1384 ], ":" => [ 7, \&_action_opcode_1384 ], },
	# [5165] opcode : set "[inline_const]" 1
	{ "," => 5166, },
	# [5166] opcode : set "[inline_const]" 1 ","
	{ "(" => 5167, "[" => 5234, a => 5301, b => 5302, c => 5303, d => 5304, e => 5305, h => 5306, l => 5307, },
	# [5167] opcode : set "[inline_const]" 1 "," "("
	{ hl => 5168, ix => 5170, iy => 5202, },
	# [5168] opcode : set "[inline_const]" 1 "," "(" hl
	{ ")" => 5169, },
	# [5169] opcode : set "[inline_const]" 1 "," "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_1385 ], ":" => [ 7, \&_action_opcode_1385 ], },
	# [5170] opcode : set "[inline_const]" 1 "," "(" ix
	{ ")" => 5171, "+" => 5180, "-" => 5191, },
	# [5171] opcode : set "[inline_const]" 1 "," "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_1386 ], "," => 5172, ":" => [ 7, \&_action_opcode_1386 ], },
	# [5172] opcode : set "[inline_const]" 1 "," "(" ix ")" ","
	{ a => 5173, b => 5174, c => 5175, d => 5176, e => 5177, h => 5178, l => 5179, },
	# [5173] opcode : set "[inline_const]" 1 "," "(" ix ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1387 ], ":" => [ 7, \&_action_opcode_1387 ], },
	# [5174] opcode : set "[inline_const]" 1 "," "(" ix ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1388 ], ":" => [ 7, \&_action_opcode_1388 ], },
	# [5175] opcode : set "[inline_const]" 1 "," "(" ix ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1389 ], ":" => [ 7, \&_action_opcode_1389 ], },
	# [5176] opcode : set "[inline_const]" 1 "," "(" ix ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1390 ], ":" => [ 7, \&_action_opcode_1390 ], },
	# [5177] opcode : set "[inline_const]" 1 "," "(" ix ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1391 ], ":" => [ 7, \&_action_opcode_1391 ], },
	# [5178] opcode : set "[inline_const]" 1 "," "(" ix ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1392 ], ":" => [ 7, \&_action_opcode_1392 ], },
	# [5179] opcode : set "[inline_const]" 1 "," "(" ix ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1393 ], ":" => [ 7, \&_action_opcode_1393 ], },
	# [5180] opcode : set "[inline_const]" 1 "," "(" ix "+"
	{ "!" => [ 12, 5181 ], "+" => [ 12, 5181 ], "-" => [ 12, 5181 ], __else__ => [ 12, 5181 ], "~" => [ 12, 5181 ], },
	# [5181] opcode : set "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]"
	{ ")" => 5182, },
	# [5182] opcode : set "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1394 ], "," => 5183, ":" => [ 7, \&_action_opcode_1394 ], },
	# [5183] opcode : set "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" ","
	{ a => 5184, b => 5185, c => 5186, d => 5187, e => 5188, h => 5189, l => 5190, },
	# [5184] opcode : set "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1395 ], ":" => [ 7, \&_action_opcode_1395 ], },
	# [5185] opcode : set "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1396 ], ":" => [ 7, \&_action_opcode_1396 ], },
	# [5186] opcode : set "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1397 ], ":" => [ 7, \&_action_opcode_1397 ], },
	# [5187] opcode : set "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1398 ], ":" => [ 7, \&_action_opcode_1398 ], },
	# [5188] opcode : set "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1399 ], ":" => [ 7, \&_action_opcode_1399 ], },
	# [5189] opcode : set "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1400 ], ":" => [ 7, \&_action_opcode_1400 ], },
	# [5190] opcode : set "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1401 ], ":" => [ 7, \&_action_opcode_1401 ], },
	# [5191] opcode : set "[inline_const]" 1 "," "(" ix "-"
	{ "!" => [ 14, 5192 ], "+" => [ 14, 5192 ], "-" => [ 14, 5192 ], __else__ => [ 14, 5192 ], "~" => [ 14, 5192 ], },
	# [5192] opcode : set "[inline_const]" 1 "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 5193, },
	# [5193] opcode : set "[inline_const]" 1 "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1394 ], "," => 5194, ":" => [ 7, \&_action_opcode_1394 ], },
	# [5194] opcode : set "[inline_const]" 1 "," "(" ix "-" "[expr_NDIS]" ")" ","
	{ a => 5195, b => 5196, c => 5197, d => 5198, e => 5199, h => 5200, l => 5201, },
	# [5195] opcode : set "[inline_const]" 1 "," "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1395 ], ":" => [ 7, \&_action_opcode_1395 ], },
	# [5196] opcode : set "[inline_const]" 1 "," "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1396 ], ":" => [ 7, \&_action_opcode_1396 ], },
	# [5197] opcode : set "[inline_const]" 1 "," "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1397 ], ":" => [ 7, \&_action_opcode_1397 ], },
	# [5198] opcode : set "[inline_const]" 1 "," "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1398 ], ":" => [ 7, \&_action_opcode_1398 ], },
	# [5199] opcode : set "[inline_const]" 1 "," "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1399 ], ":" => [ 7, \&_action_opcode_1399 ], },
	# [5200] opcode : set "[inline_const]" 1 "," "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1400 ], ":" => [ 7, \&_action_opcode_1400 ], },
	# [5201] opcode : set "[inline_const]" 1 "," "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1401 ], ":" => [ 7, \&_action_opcode_1401 ], },
	# [5202] opcode : set "[inline_const]" 1 "," "(" iy
	{ ")" => 5203, "+" => 5212, "-" => 5223, },
	# [5203] opcode : set "[inline_const]" 1 "," "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_1402 ], "," => 5204, ":" => [ 7, \&_action_opcode_1402 ], },
	# [5204] opcode : set "[inline_const]" 1 "," "(" iy ")" ","
	{ a => 5205, b => 5206, c => 5207, d => 5208, e => 5209, h => 5210, l => 5211, },
	# [5205] opcode : set "[inline_const]" 1 "," "(" iy ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1403 ], ":" => [ 7, \&_action_opcode_1403 ], },
	# [5206] opcode : set "[inline_const]" 1 "," "(" iy ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1404 ], ":" => [ 7, \&_action_opcode_1404 ], },
	# [5207] opcode : set "[inline_const]" 1 "," "(" iy ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1405 ], ":" => [ 7, \&_action_opcode_1405 ], },
	# [5208] opcode : set "[inline_const]" 1 "," "(" iy ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1406 ], ":" => [ 7, \&_action_opcode_1406 ], },
	# [5209] opcode : set "[inline_const]" 1 "," "(" iy ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1407 ], ":" => [ 7, \&_action_opcode_1407 ], },
	# [5210] opcode : set "[inline_const]" 1 "," "(" iy ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1408 ], ":" => [ 7, \&_action_opcode_1408 ], },
	# [5211] opcode : set "[inline_const]" 1 "," "(" iy ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1409 ], ":" => [ 7, \&_action_opcode_1409 ], },
	# [5212] opcode : set "[inline_const]" 1 "," "(" iy "+"
	{ "!" => [ 12, 5213 ], "+" => [ 12, 5213 ], "-" => [ 12, 5213 ], __else__ => [ 12, 5213 ], "~" => [ 12, 5213 ], },
	# [5213] opcode : set "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]"
	{ ")" => 5214, },
	# [5214] opcode : set "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1410 ], "," => 5215, ":" => [ 7, \&_action_opcode_1410 ], },
	# [5215] opcode : set "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" ","
	{ a => 5216, b => 5217, c => 5218, d => 5219, e => 5220, h => 5221, l => 5222, },
	# [5216] opcode : set "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1411 ], ":" => [ 7, \&_action_opcode_1411 ], },
	# [5217] opcode : set "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1412 ], ":" => [ 7, \&_action_opcode_1412 ], },
	# [5218] opcode : set "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1413 ], ":" => [ 7, \&_action_opcode_1413 ], },
	# [5219] opcode : set "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1414 ], ":" => [ 7, \&_action_opcode_1414 ], },
	# [5220] opcode : set "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1415 ], ":" => [ 7, \&_action_opcode_1415 ], },
	# [5221] opcode : set "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1416 ], ":" => [ 7, \&_action_opcode_1416 ], },
	# [5222] opcode : set "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1417 ], ":" => [ 7, \&_action_opcode_1417 ], },
	# [5223] opcode : set "[inline_const]" 1 "," "(" iy "-"
	{ "!" => [ 14, 5224 ], "+" => [ 14, 5224 ], "-" => [ 14, 5224 ], __else__ => [ 14, 5224 ], "~" => [ 14, 5224 ], },
	# [5224] opcode : set "[inline_const]" 1 "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 5225, },
	# [5225] opcode : set "[inline_const]" 1 "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1410 ], "," => 5226, ":" => [ 7, \&_action_opcode_1410 ], },
	# [5226] opcode : set "[inline_const]" 1 "," "(" iy "-" "[expr_NDIS]" ")" ","
	{ a => 5227, b => 5228, c => 5229, d => 5230, e => 5231, h => 5232, l => 5233, },
	# [5227] opcode : set "[inline_const]" 1 "," "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1411 ], ":" => [ 7, \&_action_opcode_1411 ], },
	# [5228] opcode : set "[inline_const]" 1 "," "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1412 ], ":" => [ 7, \&_action_opcode_1412 ], },
	# [5229] opcode : set "[inline_const]" 1 "," "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1413 ], ":" => [ 7, \&_action_opcode_1413 ], },
	# [5230] opcode : set "[inline_const]" 1 "," "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1414 ], ":" => [ 7, \&_action_opcode_1414 ], },
	# [5231] opcode : set "[inline_const]" 1 "," "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1415 ], ":" => [ 7, \&_action_opcode_1415 ], },
	# [5232] opcode : set "[inline_const]" 1 "," "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1416 ], ":" => [ 7, \&_action_opcode_1416 ], },
	# [5233] opcode : set "[inline_const]" 1 "," "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1417 ], ":" => [ 7, \&_action_opcode_1417 ], },
	# [5234] opcode : set "[inline_const]" 1 "," "["
	{ hl => 5235, ix => 5237, iy => 5269, },
	# [5235] opcode : set "[inline_const]" 1 "," "[" hl
	{ "]" => 5236, },
	# [5236] opcode : set "[inline_const]" 1 "," "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_1385 ], ":" => [ 7, \&_action_opcode_1385 ], },
	# [5237] opcode : set "[inline_const]" 1 "," "[" ix
	{ "+" => 5238, "-" => 5249, "]" => 5260, },
	# [5238] opcode : set "[inline_const]" 1 "," "[" ix "+"
	{ "!" => [ 12, 5239 ], "+" => [ 12, 5239 ], "-" => [ 12, 5239 ], __else__ => [ 12, 5239 ], "~" => [ 12, 5239 ], },
	# [5239] opcode : set "[inline_const]" 1 "," "[" ix "+" "[expr_DIS]"
	{ "]" => 5240, },
	# [5240] opcode : set "[inline_const]" 1 "," "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1394 ], "," => 5241, ":" => [ 7, \&_action_opcode_1394 ], },
	# [5241] opcode : set "[inline_const]" 1 "," "[" ix "+" "[expr_DIS]" "]" ","
	{ a => 5242, b => 5243, c => 5244, d => 5245, e => 5246, h => 5247, l => 5248, },
	# [5242] opcode : set "[inline_const]" 1 "," "[" ix "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1395 ], ":" => [ 7, \&_action_opcode_1395 ], },
	# [5243] opcode : set "[inline_const]" 1 "," "[" ix "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1396 ], ":" => [ 7, \&_action_opcode_1396 ], },
	# [5244] opcode : set "[inline_const]" 1 "," "[" ix "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1397 ], ":" => [ 7, \&_action_opcode_1397 ], },
	# [5245] opcode : set "[inline_const]" 1 "," "[" ix "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1398 ], ":" => [ 7, \&_action_opcode_1398 ], },
	# [5246] opcode : set "[inline_const]" 1 "," "[" ix "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1399 ], ":" => [ 7, \&_action_opcode_1399 ], },
	# [5247] opcode : set "[inline_const]" 1 "," "[" ix "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1400 ], ":" => [ 7, \&_action_opcode_1400 ], },
	# [5248] opcode : set "[inline_const]" 1 "," "[" ix "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1401 ], ":" => [ 7, \&_action_opcode_1401 ], },
	# [5249] opcode : set "[inline_const]" 1 "," "[" ix "-"
	{ "!" => [ 14, 5250 ], "+" => [ 14, 5250 ], "-" => [ 14, 5250 ], __else__ => [ 14, 5250 ], "~" => [ 14, 5250 ], },
	# [5250] opcode : set "[inline_const]" 1 "," "[" ix "-" "[expr_NDIS]"
	{ "]" => 5251, },
	# [5251] opcode : set "[inline_const]" 1 "," "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1394 ], "," => 5252, ":" => [ 7, \&_action_opcode_1394 ], },
	# [5252] opcode : set "[inline_const]" 1 "," "[" ix "-" "[expr_NDIS]" "]" ","
	{ a => 5253, b => 5254, c => 5255, d => 5256, e => 5257, h => 5258, l => 5259, },
	# [5253] opcode : set "[inline_const]" 1 "," "[" ix "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1395 ], ":" => [ 7, \&_action_opcode_1395 ], },
	# [5254] opcode : set "[inline_const]" 1 "," "[" ix "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1396 ], ":" => [ 7, \&_action_opcode_1396 ], },
	# [5255] opcode : set "[inline_const]" 1 "," "[" ix "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1397 ], ":" => [ 7, \&_action_opcode_1397 ], },
	# [5256] opcode : set "[inline_const]" 1 "," "[" ix "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1398 ], ":" => [ 7, \&_action_opcode_1398 ], },
	# [5257] opcode : set "[inline_const]" 1 "," "[" ix "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1399 ], ":" => [ 7, \&_action_opcode_1399 ], },
	# [5258] opcode : set "[inline_const]" 1 "," "[" ix "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1400 ], ":" => [ 7, \&_action_opcode_1400 ], },
	# [5259] opcode : set "[inline_const]" 1 "," "[" ix "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1401 ], ":" => [ 7, \&_action_opcode_1401 ], },
	# [5260] opcode : set "[inline_const]" 1 "," "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_1386 ], "," => 5261, ":" => [ 7, \&_action_opcode_1386 ], },
	# [5261] opcode : set "[inline_const]" 1 "," "[" ix "]" ","
	{ a => 5262, b => 5263, c => 5264, d => 5265, e => 5266, h => 5267, l => 5268, },
	# [5262] opcode : set "[inline_const]" 1 "," "[" ix "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1387 ], ":" => [ 7, \&_action_opcode_1387 ], },
	# [5263] opcode : set "[inline_const]" 1 "," "[" ix "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1388 ], ":" => [ 7, \&_action_opcode_1388 ], },
	# [5264] opcode : set "[inline_const]" 1 "," "[" ix "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1389 ], ":" => [ 7, \&_action_opcode_1389 ], },
	# [5265] opcode : set "[inline_const]" 1 "," "[" ix "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1390 ], ":" => [ 7, \&_action_opcode_1390 ], },
	# [5266] opcode : set "[inline_const]" 1 "," "[" ix "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1391 ], ":" => [ 7, \&_action_opcode_1391 ], },
	# [5267] opcode : set "[inline_const]" 1 "," "[" ix "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1392 ], ":" => [ 7, \&_action_opcode_1392 ], },
	# [5268] opcode : set "[inline_const]" 1 "," "[" ix "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1393 ], ":" => [ 7, \&_action_opcode_1393 ], },
	# [5269] opcode : set "[inline_const]" 1 "," "[" iy
	{ "+" => 5270, "-" => 5281, "]" => 5292, },
	# [5270] opcode : set "[inline_const]" 1 "," "[" iy "+"
	{ "!" => [ 12, 5271 ], "+" => [ 12, 5271 ], "-" => [ 12, 5271 ], __else__ => [ 12, 5271 ], "~" => [ 12, 5271 ], },
	# [5271] opcode : set "[inline_const]" 1 "," "[" iy "+" "[expr_DIS]"
	{ "]" => 5272, },
	# [5272] opcode : set "[inline_const]" 1 "," "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1410 ], "," => 5273, ":" => [ 7, \&_action_opcode_1410 ], },
	# [5273] opcode : set "[inline_const]" 1 "," "[" iy "+" "[expr_DIS]" "]" ","
	{ a => 5274, b => 5275, c => 5276, d => 5277, e => 5278, h => 5279, l => 5280, },
	# [5274] opcode : set "[inline_const]" 1 "," "[" iy "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1411 ], ":" => [ 7, \&_action_opcode_1411 ], },
	# [5275] opcode : set "[inline_const]" 1 "," "[" iy "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1412 ], ":" => [ 7, \&_action_opcode_1412 ], },
	# [5276] opcode : set "[inline_const]" 1 "," "[" iy "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1413 ], ":" => [ 7, \&_action_opcode_1413 ], },
	# [5277] opcode : set "[inline_const]" 1 "," "[" iy "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1414 ], ":" => [ 7, \&_action_opcode_1414 ], },
	# [5278] opcode : set "[inline_const]" 1 "," "[" iy "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1415 ], ":" => [ 7, \&_action_opcode_1415 ], },
	# [5279] opcode : set "[inline_const]" 1 "," "[" iy "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1416 ], ":" => [ 7, \&_action_opcode_1416 ], },
	# [5280] opcode : set "[inline_const]" 1 "," "[" iy "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1417 ], ":" => [ 7, \&_action_opcode_1417 ], },
	# [5281] opcode : set "[inline_const]" 1 "," "[" iy "-"
	{ "!" => [ 14, 5282 ], "+" => [ 14, 5282 ], "-" => [ 14, 5282 ], __else__ => [ 14, 5282 ], "~" => [ 14, 5282 ], },
	# [5282] opcode : set "[inline_const]" 1 "," "[" iy "-" "[expr_NDIS]"
	{ "]" => 5283, },
	# [5283] opcode : set "[inline_const]" 1 "," "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1410 ], "," => 5284, ":" => [ 7, \&_action_opcode_1410 ], },
	# [5284] opcode : set "[inline_const]" 1 "," "[" iy "-" "[expr_NDIS]" "]" ","
	{ a => 5285, b => 5286, c => 5287, d => 5288, e => 5289, h => 5290, l => 5291, },
	# [5285] opcode : set "[inline_const]" 1 "," "[" iy "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1411 ], ":" => [ 7, \&_action_opcode_1411 ], },
	# [5286] opcode : set "[inline_const]" 1 "," "[" iy "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1412 ], ":" => [ 7, \&_action_opcode_1412 ], },
	# [5287] opcode : set "[inline_const]" 1 "," "[" iy "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1413 ], ":" => [ 7, \&_action_opcode_1413 ], },
	# [5288] opcode : set "[inline_const]" 1 "," "[" iy "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1414 ], ":" => [ 7, \&_action_opcode_1414 ], },
	# [5289] opcode : set "[inline_const]" 1 "," "[" iy "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1415 ], ":" => [ 7, \&_action_opcode_1415 ], },
	# [5290] opcode : set "[inline_const]" 1 "," "[" iy "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1416 ], ":" => [ 7, \&_action_opcode_1416 ], },
	# [5291] opcode : set "[inline_const]" 1 "," "[" iy "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1417 ], ":" => [ 7, \&_action_opcode_1417 ], },
	# [5292] opcode : set "[inline_const]" 1 "," "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_1402 ], "," => 5293, ":" => [ 7, \&_action_opcode_1402 ], },
	# [5293] opcode : set "[inline_const]" 1 "," "[" iy "]" ","
	{ a => 5294, b => 5295, c => 5296, d => 5297, e => 5298, h => 5299, l => 5300, },
	# [5294] opcode : set "[inline_const]" 1 "," "[" iy "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1403 ], ":" => [ 7, \&_action_opcode_1403 ], },
	# [5295] opcode : set "[inline_const]" 1 "," "[" iy "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1404 ], ":" => [ 7, \&_action_opcode_1404 ], },
	# [5296] opcode : set "[inline_const]" 1 "," "[" iy "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1405 ], ":" => [ 7, \&_action_opcode_1405 ], },
	# [5297] opcode : set "[inline_const]" 1 "," "[" iy "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1406 ], ":" => [ 7, \&_action_opcode_1406 ], },
	# [5298] opcode : set "[inline_const]" 1 "," "[" iy "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1407 ], ":" => [ 7, \&_action_opcode_1407 ], },
	# [5299] opcode : set "[inline_const]" 1 "," "[" iy "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1408 ], ":" => [ 7, \&_action_opcode_1408 ], },
	# [5300] opcode : set "[inline_const]" 1 "," "[" iy "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1409 ], ":" => [ 7, \&_action_opcode_1409 ], },
	# [5301] opcode : set "[inline_const]" 1 "," a
	{ "\n" => [ 7, \&_action_opcode_1418 ], ":" => [ 7, \&_action_opcode_1418 ], },
	# [5302] opcode : set "[inline_const]" 1 "," b
	{ "\n" => [ 7, \&_action_opcode_1419 ], ":" => [ 7, \&_action_opcode_1419 ], },
	# [5303] opcode : set "[inline_const]" 1 "," c
	{ "\n" => [ 7, \&_action_opcode_1420 ], ":" => [ 7, \&_action_opcode_1420 ], },
	# [5304] opcode : set "[inline_const]" 1 "," d
	{ "\n" => [ 7, \&_action_opcode_1421 ], ":" => [ 7, \&_action_opcode_1421 ], },
	# [5305] opcode : set "[inline_const]" 1 "," e
	{ "\n" => [ 7, \&_action_opcode_1422 ], ":" => [ 7, \&_action_opcode_1422 ], },
	# [5306] opcode : set "[inline_const]" 1 "," h
	{ "\n" => [ 7, \&_action_opcode_1423 ], ":" => [ 7, \&_action_opcode_1423 ], },
	# [5307] opcode : set "[inline_const]" 1 "," l
	{ "\n" => [ 7, \&_action_opcode_1424 ], ":" => [ 7, \&_action_opcode_1424 ], },
	# [5308] opcode : set "[inline_const]" 2
	{ "," => 5309, },
	# [5309] opcode : set "[inline_const]" 2 ","
	{ "(" => 5310, "[" => 5377, a => 5444, b => 5445, c => 5446, d => 5447, e => 5448, h => 5449, l => 5450, },
	# [5310] opcode : set "[inline_const]" 2 "," "("
	{ hl => 5311, ix => 5313, iy => 5345, },
	# [5311] opcode : set "[inline_const]" 2 "," "(" hl
	{ ")" => 5312, },
	# [5312] opcode : set "[inline_const]" 2 "," "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_1425 ], ":" => [ 7, \&_action_opcode_1425 ], },
	# [5313] opcode : set "[inline_const]" 2 "," "(" ix
	{ ")" => 5314, "+" => 5323, "-" => 5334, },
	# [5314] opcode : set "[inline_const]" 2 "," "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_1426 ], "," => 5315, ":" => [ 7, \&_action_opcode_1426 ], },
	# [5315] opcode : set "[inline_const]" 2 "," "(" ix ")" ","
	{ a => 5316, b => 5317, c => 5318, d => 5319, e => 5320, h => 5321, l => 5322, },
	# [5316] opcode : set "[inline_const]" 2 "," "(" ix ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1427 ], ":" => [ 7, \&_action_opcode_1427 ], },
	# [5317] opcode : set "[inline_const]" 2 "," "(" ix ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1428 ], ":" => [ 7, \&_action_opcode_1428 ], },
	# [5318] opcode : set "[inline_const]" 2 "," "(" ix ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1429 ], ":" => [ 7, \&_action_opcode_1429 ], },
	# [5319] opcode : set "[inline_const]" 2 "," "(" ix ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1430 ], ":" => [ 7, \&_action_opcode_1430 ], },
	# [5320] opcode : set "[inline_const]" 2 "," "(" ix ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1431 ], ":" => [ 7, \&_action_opcode_1431 ], },
	# [5321] opcode : set "[inline_const]" 2 "," "(" ix ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1432 ], ":" => [ 7, \&_action_opcode_1432 ], },
	# [5322] opcode : set "[inline_const]" 2 "," "(" ix ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1433 ], ":" => [ 7, \&_action_opcode_1433 ], },
	# [5323] opcode : set "[inline_const]" 2 "," "(" ix "+"
	{ "!" => [ 12, 5324 ], "+" => [ 12, 5324 ], "-" => [ 12, 5324 ], __else__ => [ 12, 5324 ], "~" => [ 12, 5324 ], },
	# [5324] opcode : set "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]"
	{ ")" => 5325, },
	# [5325] opcode : set "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1434 ], "," => 5326, ":" => [ 7, \&_action_opcode_1434 ], },
	# [5326] opcode : set "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" ","
	{ a => 5327, b => 5328, c => 5329, d => 5330, e => 5331, h => 5332, l => 5333, },
	# [5327] opcode : set "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1435 ], ":" => [ 7, \&_action_opcode_1435 ], },
	# [5328] opcode : set "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1436 ], ":" => [ 7, \&_action_opcode_1436 ], },
	# [5329] opcode : set "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1437 ], ":" => [ 7, \&_action_opcode_1437 ], },
	# [5330] opcode : set "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1438 ], ":" => [ 7, \&_action_opcode_1438 ], },
	# [5331] opcode : set "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1439 ], ":" => [ 7, \&_action_opcode_1439 ], },
	# [5332] opcode : set "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1440 ], ":" => [ 7, \&_action_opcode_1440 ], },
	# [5333] opcode : set "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1441 ], ":" => [ 7, \&_action_opcode_1441 ], },
	# [5334] opcode : set "[inline_const]" 2 "," "(" ix "-"
	{ "!" => [ 14, 5335 ], "+" => [ 14, 5335 ], "-" => [ 14, 5335 ], __else__ => [ 14, 5335 ], "~" => [ 14, 5335 ], },
	# [5335] opcode : set "[inline_const]" 2 "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 5336, },
	# [5336] opcode : set "[inline_const]" 2 "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1434 ], "," => 5337, ":" => [ 7, \&_action_opcode_1434 ], },
	# [5337] opcode : set "[inline_const]" 2 "," "(" ix "-" "[expr_NDIS]" ")" ","
	{ a => 5338, b => 5339, c => 5340, d => 5341, e => 5342, h => 5343, l => 5344, },
	# [5338] opcode : set "[inline_const]" 2 "," "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1435 ], ":" => [ 7, \&_action_opcode_1435 ], },
	# [5339] opcode : set "[inline_const]" 2 "," "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1436 ], ":" => [ 7, \&_action_opcode_1436 ], },
	# [5340] opcode : set "[inline_const]" 2 "," "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1437 ], ":" => [ 7, \&_action_opcode_1437 ], },
	# [5341] opcode : set "[inline_const]" 2 "," "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1438 ], ":" => [ 7, \&_action_opcode_1438 ], },
	# [5342] opcode : set "[inline_const]" 2 "," "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1439 ], ":" => [ 7, \&_action_opcode_1439 ], },
	# [5343] opcode : set "[inline_const]" 2 "," "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1440 ], ":" => [ 7, \&_action_opcode_1440 ], },
	# [5344] opcode : set "[inline_const]" 2 "," "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1441 ], ":" => [ 7, \&_action_opcode_1441 ], },
	# [5345] opcode : set "[inline_const]" 2 "," "(" iy
	{ ")" => 5346, "+" => 5355, "-" => 5366, },
	# [5346] opcode : set "[inline_const]" 2 "," "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_1442 ], "," => 5347, ":" => [ 7, \&_action_opcode_1442 ], },
	# [5347] opcode : set "[inline_const]" 2 "," "(" iy ")" ","
	{ a => 5348, b => 5349, c => 5350, d => 5351, e => 5352, h => 5353, l => 5354, },
	# [5348] opcode : set "[inline_const]" 2 "," "(" iy ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1443 ], ":" => [ 7, \&_action_opcode_1443 ], },
	# [5349] opcode : set "[inline_const]" 2 "," "(" iy ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1444 ], ":" => [ 7, \&_action_opcode_1444 ], },
	# [5350] opcode : set "[inline_const]" 2 "," "(" iy ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1445 ], ":" => [ 7, \&_action_opcode_1445 ], },
	# [5351] opcode : set "[inline_const]" 2 "," "(" iy ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1446 ], ":" => [ 7, \&_action_opcode_1446 ], },
	# [5352] opcode : set "[inline_const]" 2 "," "(" iy ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1447 ], ":" => [ 7, \&_action_opcode_1447 ], },
	# [5353] opcode : set "[inline_const]" 2 "," "(" iy ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1448 ], ":" => [ 7, \&_action_opcode_1448 ], },
	# [5354] opcode : set "[inline_const]" 2 "," "(" iy ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1449 ], ":" => [ 7, \&_action_opcode_1449 ], },
	# [5355] opcode : set "[inline_const]" 2 "," "(" iy "+"
	{ "!" => [ 12, 5356 ], "+" => [ 12, 5356 ], "-" => [ 12, 5356 ], __else__ => [ 12, 5356 ], "~" => [ 12, 5356 ], },
	# [5356] opcode : set "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]"
	{ ")" => 5357, },
	# [5357] opcode : set "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1450 ], "," => 5358, ":" => [ 7, \&_action_opcode_1450 ], },
	# [5358] opcode : set "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" ","
	{ a => 5359, b => 5360, c => 5361, d => 5362, e => 5363, h => 5364, l => 5365, },
	# [5359] opcode : set "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1451 ], ":" => [ 7, \&_action_opcode_1451 ], },
	# [5360] opcode : set "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1452 ], ":" => [ 7, \&_action_opcode_1452 ], },
	# [5361] opcode : set "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1453 ], ":" => [ 7, \&_action_opcode_1453 ], },
	# [5362] opcode : set "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1454 ], ":" => [ 7, \&_action_opcode_1454 ], },
	# [5363] opcode : set "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1455 ], ":" => [ 7, \&_action_opcode_1455 ], },
	# [5364] opcode : set "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1456 ], ":" => [ 7, \&_action_opcode_1456 ], },
	# [5365] opcode : set "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1457 ], ":" => [ 7, \&_action_opcode_1457 ], },
	# [5366] opcode : set "[inline_const]" 2 "," "(" iy "-"
	{ "!" => [ 14, 5367 ], "+" => [ 14, 5367 ], "-" => [ 14, 5367 ], __else__ => [ 14, 5367 ], "~" => [ 14, 5367 ], },
	# [5367] opcode : set "[inline_const]" 2 "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 5368, },
	# [5368] opcode : set "[inline_const]" 2 "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1450 ], "," => 5369, ":" => [ 7, \&_action_opcode_1450 ], },
	# [5369] opcode : set "[inline_const]" 2 "," "(" iy "-" "[expr_NDIS]" ")" ","
	{ a => 5370, b => 5371, c => 5372, d => 5373, e => 5374, h => 5375, l => 5376, },
	# [5370] opcode : set "[inline_const]" 2 "," "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1451 ], ":" => [ 7, \&_action_opcode_1451 ], },
	# [5371] opcode : set "[inline_const]" 2 "," "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1452 ], ":" => [ 7, \&_action_opcode_1452 ], },
	# [5372] opcode : set "[inline_const]" 2 "," "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1453 ], ":" => [ 7, \&_action_opcode_1453 ], },
	# [5373] opcode : set "[inline_const]" 2 "," "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1454 ], ":" => [ 7, \&_action_opcode_1454 ], },
	# [5374] opcode : set "[inline_const]" 2 "," "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1455 ], ":" => [ 7, \&_action_opcode_1455 ], },
	# [5375] opcode : set "[inline_const]" 2 "," "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1456 ], ":" => [ 7, \&_action_opcode_1456 ], },
	# [5376] opcode : set "[inline_const]" 2 "," "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1457 ], ":" => [ 7, \&_action_opcode_1457 ], },
	# [5377] opcode : set "[inline_const]" 2 "," "["
	{ hl => 5378, ix => 5380, iy => 5412, },
	# [5378] opcode : set "[inline_const]" 2 "," "[" hl
	{ "]" => 5379, },
	# [5379] opcode : set "[inline_const]" 2 "," "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_1425 ], ":" => [ 7, \&_action_opcode_1425 ], },
	# [5380] opcode : set "[inline_const]" 2 "," "[" ix
	{ "+" => 5381, "-" => 5392, "]" => 5403, },
	# [5381] opcode : set "[inline_const]" 2 "," "[" ix "+"
	{ "!" => [ 12, 5382 ], "+" => [ 12, 5382 ], "-" => [ 12, 5382 ], __else__ => [ 12, 5382 ], "~" => [ 12, 5382 ], },
	# [5382] opcode : set "[inline_const]" 2 "," "[" ix "+" "[expr_DIS]"
	{ "]" => 5383, },
	# [5383] opcode : set "[inline_const]" 2 "," "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1434 ], "," => 5384, ":" => [ 7, \&_action_opcode_1434 ], },
	# [5384] opcode : set "[inline_const]" 2 "," "[" ix "+" "[expr_DIS]" "]" ","
	{ a => 5385, b => 5386, c => 5387, d => 5388, e => 5389, h => 5390, l => 5391, },
	# [5385] opcode : set "[inline_const]" 2 "," "[" ix "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1435 ], ":" => [ 7, \&_action_opcode_1435 ], },
	# [5386] opcode : set "[inline_const]" 2 "," "[" ix "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1436 ], ":" => [ 7, \&_action_opcode_1436 ], },
	# [5387] opcode : set "[inline_const]" 2 "," "[" ix "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1437 ], ":" => [ 7, \&_action_opcode_1437 ], },
	# [5388] opcode : set "[inline_const]" 2 "," "[" ix "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1438 ], ":" => [ 7, \&_action_opcode_1438 ], },
	# [5389] opcode : set "[inline_const]" 2 "," "[" ix "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1439 ], ":" => [ 7, \&_action_opcode_1439 ], },
	# [5390] opcode : set "[inline_const]" 2 "," "[" ix "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1440 ], ":" => [ 7, \&_action_opcode_1440 ], },
	# [5391] opcode : set "[inline_const]" 2 "," "[" ix "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1441 ], ":" => [ 7, \&_action_opcode_1441 ], },
	# [5392] opcode : set "[inline_const]" 2 "," "[" ix "-"
	{ "!" => [ 14, 5393 ], "+" => [ 14, 5393 ], "-" => [ 14, 5393 ], __else__ => [ 14, 5393 ], "~" => [ 14, 5393 ], },
	# [5393] opcode : set "[inline_const]" 2 "," "[" ix "-" "[expr_NDIS]"
	{ "]" => 5394, },
	# [5394] opcode : set "[inline_const]" 2 "," "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1434 ], "," => 5395, ":" => [ 7, \&_action_opcode_1434 ], },
	# [5395] opcode : set "[inline_const]" 2 "," "[" ix "-" "[expr_NDIS]" "]" ","
	{ a => 5396, b => 5397, c => 5398, d => 5399, e => 5400, h => 5401, l => 5402, },
	# [5396] opcode : set "[inline_const]" 2 "," "[" ix "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1435 ], ":" => [ 7, \&_action_opcode_1435 ], },
	# [5397] opcode : set "[inline_const]" 2 "," "[" ix "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1436 ], ":" => [ 7, \&_action_opcode_1436 ], },
	# [5398] opcode : set "[inline_const]" 2 "," "[" ix "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1437 ], ":" => [ 7, \&_action_opcode_1437 ], },
	# [5399] opcode : set "[inline_const]" 2 "," "[" ix "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1438 ], ":" => [ 7, \&_action_opcode_1438 ], },
	# [5400] opcode : set "[inline_const]" 2 "," "[" ix "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1439 ], ":" => [ 7, \&_action_opcode_1439 ], },
	# [5401] opcode : set "[inline_const]" 2 "," "[" ix "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1440 ], ":" => [ 7, \&_action_opcode_1440 ], },
	# [5402] opcode : set "[inline_const]" 2 "," "[" ix "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1441 ], ":" => [ 7, \&_action_opcode_1441 ], },
	# [5403] opcode : set "[inline_const]" 2 "," "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_1426 ], "," => 5404, ":" => [ 7, \&_action_opcode_1426 ], },
	# [5404] opcode : set "[inline_const]" 2 "," "[" ix "]" ","
	{ a => 5405, b => 5406, c => 5407, d => 5408, e => 5409, h => 5410, l => 5411, },
	# [5405] opcode : set "[inline_const]" 2 "," "[" ix "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1427 ], ":" => [ 7, \&_action_opcode_1427 ], },
	# [5406] opcode : set "[inline_const]" 2 "," "[" ix "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1428 ], ":" => [ 7, \&_action_opcode_1428 ], },
	# [5407] opcode : set "[inline_const]" 2 "," "[" ix "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1429 ], ":" => [ 7, \&_action_opcode_1429 ], },
	# [5408] opcode : set "[inline_const]" 2 "," "[" ix "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1430 ], ":" => [ 7, \&_action_opcode_1430 ], },
	# [5409] opcode : set "[inline_const]" 2 "," "[" ix "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1431 ], ":" => [ 7, \&_action_opcode_1431 ], },
	# [5410] opcode : set "[inline_const]" 2 "," "[" ix "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1432 ], ":" => [ 7, \&_action_opcode_1432 ], },
	# [5411] opcode : set "[inline_const]" 2 "," "[" ix "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1433 ], ":" => [ 7, \&_action_opcode_1433 ], },
	# [5412] opcode : set "[inline_const]" 2 "," "[" iy
	{ "+" => 5413, "-" => 5424, "]" => 5435, },
	# [5413] opcode : set "[inline_const]" 2 "," "[" iy "+"
	{ "!" => [ 12, 5414 ], "+" => [ 12, 5414 ], "-" => [ 12, 5414 ], __else__ => [ 12, 5414 ], "~" => [ 12, 5414 ], },
	# [5414] opcode : set "[inline_const]" 2 "," "[" iy "+" "[expr_DIS]"
	{ "]" => 5415, },
	# [5415] opcode : set "[inline_const]" 2 "," "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1450 ], "," => 5416, ":" => [ 7, \&_action_opcode_1450 ], },
	# [5416] opcode : set "[inline_const]" 2 "," "[" iy "+" "[expr_DIS]" "]" ","
	{ a => 5417, b => 5418, c => 5419, d => 5420, e => 5421, h => 5422, l => 5423, },
	# [5417] opcode : set "[inline_const]" 2 "," "[" iy "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1451 ], ":" => [ 7, \&_action_opcode_1451 ], },
	# [5418] opcode : set "[inline_const]" 2 "," "[" iy "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1452 ], ":" => [ 7, \&_action_opcode_1452 ], },
	# [5419] opcode : set "[inline_const]" 2 "," "[" iy "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1453 ], ":" => [ 7, \&_action_opcode_1453 ], },
	# [5420] opcode : set "[inline_const]" 2 "," "[" iy "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1454 ], ":" => [ 7, \&_action_opcode_1454 ], },
	# [5421] opcode : set "[inline_const]" 2 "," "[" iy "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1455 ], ":" => [ 7, \&_action_opcode_1455 ], },
	# [5422] opcode : set "[inline_const]" 2 "," "[" iy "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1456 ], ":" => [ 7, \&_action_opcode_1456 ], },
	# [5423] opcode : set "[inline_const]" 2 "," "[" iy "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1457 ], ":" => [ 7, \&_action_opcode_1457 ], },
	# [5424] opcode : set "[inline_const]" 2 "," "[" iy "-"
	{ "!" => [ 14, 5425 ], "+" => [ 14, 5425 ], "-" => [ 14, 5425 ], __else__ => [ 14, 5425 ], "~" => [ 14, 5425 ], },
	# [5425] opcode : set "[inline_const]" 2 "," "[" iy "-" "[expr_NDIS]"
	{ "]" => 5426, },
	# [5426] opcode : set "[inline_const]" 2 "," "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1450 ], "," => 5427, ":" => [ 7, \&_action_opcode_1450 ], },
	# [5427] opcode : set "[inline_const]" 2 "," "[" iy "-" "[expr_NDIS]" "]" ","
	{ a => 5428, b => 5429, c => 5430, d => 5431, e => 5432, h => 5433, l => 5434, },
	# [5428] opcode : set "[inline_const]" 2 "," "[" iy "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1451 ], ":" => [ 7, \&_action_opcode_1451 ], },
	# [5429] opcode : set "[inline_const]" 2 "," "[" iy "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1452 ], ":" => [ 7, \&_action_opcode_1452 ], },
	# [5430] opcode : set "[inline_const]" 2 "," "[" iy "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1453 ], ":" => [ 7, \&_action_opcode_1453 ], },
	# [5431] opcode : set "[inline_const]" 2 "," "[" iy "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1454 ], ":" => [ 7, \&_action_opcode_1454 ], },
	# [5432] opcode : set "[inline_const]" 2 "," "[" iy "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1455 ], ":" => [ 7, \&_action_opcode_1455 ], },
	# [5433] opcode : set "[inline_const]" 2 "," "[" iy "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1456 ], ":" => [ 7, \&_action_opcode_1456 ], },
	# [5434] opcode : set "[inline_const]" 2 "," "[" iy "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1457 ], ":" => [ 7, \&_action_opcode_1457 ], },
	# [5435] opcode : set "[inline_const]" 2 "," "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_1442 ], "," => 5436, ":" => [ 7, \&_action_opcode_1442 ], },
	# [5436] opcode : set "[inline_const]" 2 "," "[" iy "]" ","
	{ a => 5437, b => 5438, c => 5439, d => 5440, e => 5441, h => 5442, l => 5443, },
	# [5437] opcode : set "[inline_const]" 2 "," "[" iy "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1443 ], ":" => [ 7, \&_action_opcode_1443 ], },
	# [5438] opcode : set "[inline_const]" 2 "," "[" iy "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1444 ], ":" => [ 7, \&_action_opcode_1444 ], },
	# [5439] opcode : set "[inline_const]" 2 "," "[" iy "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1445 ], ":" => [ 7, \&_action_opcode_1445 ], },
	# [5440] opcode : set "[inline_const]" 2 "," "[" iy "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1446 ], ":" => [ 7, \&_action_opcode_1446 ], },
	# [5441] opcode : set "[inline_const]" 2 "," "[" iy "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1447 ], ":" => [ 7, \&_action_opcode_1447 ], },
	# [5442] opcode : set "[inline_const]" 2 "," "[" iy "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1448 ], ":" => [ 7, \&_action_opcode_1448 ], },
	# [5443] opcode : set "[inline_const]" 2 "," "[" iy "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1449 ], ":" => [ 7, \&_action_opcode_1449 ], },
	# [5444] opcode : set "[inline_const]" 2 "," a
	{ "\n" => [ 7, \&_action_opcode_1458 ], ":" => [ 7, \&_action_opcode_1458 ], },
	# [5445] opcode : set "[inline_const]" 2 "," b
	{ "\n" => [ 7, \&_action_opcode_1459 ], ":" => [ 7, \&_action_opcode_1459 ], },
	# [5446] opcode : set "[inline_const]" 2 "," c
	{ "\n" => [ 7, \&_action_opcode_1460 ], ":" => [ 7, \&_action_opcode_1460 ], },
	# [5447] opcode : set "[inline_const]" 2 "," d
	{ "\n" => [ 7, \&_action_opcode_1461 ], ":" => [ 7, \&_action_opcode_1461 ], },
	# [5448] opcode : set "[inline_const]" 2 "," e
	{ "\n" => [ 7, \&_action_opcode_1462 ], ":" => [ 7, \&_action_opcode_1462 ], },
	# [5449] opcode : set "[inline_const]" 2 "," h
	{ "\n" => [ 7, \&_action_opcode_1463 ], ":" => [ 7, \&_action_opcode_1463 ], },
	# [5450] opcode : set "[inline_const]" 2 "," l
	{ "\n" => [ 7, \&_action_opcode_1464 ], ":" => [ 7, \&_action_opcode_1464 ], },
	# [5451] opcode : set "[inline_const]" 3
	{ "," => 5452, },
	# [5452] opcode : set "[inline_const]" 3 ","
	{ "(" => 5453, "[" => 5520, a => 5587, b => 5588, c => 5589, d => 5590, e => 5591, h => 5592, l => 5593, },
	# [5453] opcode : set "[inline_const]" 3 "," "("
	{ hl => 5454, ix => 5456, iy => 5488, },
	# [5454] opcode : set "[inline_const]" 3 "," "(" hl
	{ ")" => 5455, },
	# [5455] opcode : set "[inline_const]" 3 "," "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_1465 ], ":" => [ 7, \&_action_opcode_1465 ], },
	# [5456] opcode : set "[inline_const]" 3 "," "(" ix
	{ ")" => 5457, "+" => 5466, "-" => 5477, },
	# [5457] opcode : set "[inline_const]" 3 "," "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_1466 ], "," => 5458, ":" => [ 7, \&_action_opcode_1466 ], },
	# [5458] opcode : set "[inline_const]" 3 "," "(" ix ")" ","
	{ a => 5459, b => 5460, c => 5461, d => 5462, e => 5463, h => 5464, l => 5465, },
	# [5459] opcode : set "[inline_const]" 3 "," "(" ix ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1467 ], ":" => [ 7, \&_action_opcode_1467 ], },
	# [5460] opcode : set "[inline_const]" 3 "," "(" ix ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1468 ], ":" => [ 7, \&_action_opcode_1468 ], },
	# [5461] opcode : set "[inline_const]" 3 "," "(" ix ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1469 ], ":" => [ 7, \&_action_opcode_1469 ], },
	# [5462] opcode : set "[inline_const]" 3 "," "(" ix ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1470 ], ":" => [ 7, \&_action_opcode_1470 ], },
	# [5463] opcode : set "[inline_const]" 3 "," "(" ix ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1471 ], ":" => [ 7, \&_action_opcode_1471 ], },
	# [5464] opcode : set "[inline_const]" 3 "," "(" ix ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1472 ], ":" => [ 7, \&_action_opcode_1472 ], },
	# [5465] opcode : set "[inline_const]" 3 "," "(" ix ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1473 ], ":" => [ 7, \&_action_opcode_1473 ], },
	# [5466] opcode : set "[inline_const]" 3 "," "(" ix "+"
	{ "!" => [ 12, 5467 ], "+" => [ 12, 5467 ], "-" => [ 12, 5467 ], __else__ => [ 12, 5467 ], "~" => [ 12, 5467 ], },
	# [5467] opcode : set "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]"
	{ ")" => 5468, },
	# [5468] opcode : set "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1474 ], "," => 5469, ":" => [ 7, \&_action_opcode_1474 ], },
	# [5469] opcode : set "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" ","
	{ a => 5470, b => 5471, c => 5472, d => 5473, e => 5474, h => 5475, l => 5476, },
	# [5470] opcode : set "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1475 ], ":" => [ 7, \&_action_opcode_1475 ], },
	# [5471] opcode : set "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1476 ], ":" => [ 7, \&_action_opcode_1476 ], },
	# [5472] opcode : set "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1477 ], ":" => [ 7, \&_action_opcode_1477 ], },
	# [5473] opcode : set "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1478 ], ":" => [ 7, \&_action_opcode_1478 ], },
	# [5474] opcode : set "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1479 ], ":" => [ 7, \&_action_opcode_1479 ], },
	# [5475] opcode : set "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1480 ], ":" => [ 7, \&_action_opcode_1480 ], },
	# [5476] opcode : set "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1481 ], ":" => [ 7, \&_action_opcode_1481 ], },
	# [5477] opcode : set "[inline_const]" 3 "," "(" ix "-"
	{ "!" => [ 14, 5478 ], "+" => [ 14, 5478 ], "-" => [ 14, 5478 ], __else__ => [ 14, 5478 ], "~" => [ 14, 5478 ], },
	# [5478] opcode : set "[inline_const]" 3 "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 5479, },
	# [5479] opcode : set "[inline_const]" 3 "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1474 ], "," => 5480, ":" => [ 7, \&_action_opcode_1474 ], },
	# [5480] opcode : set "[inline_const]" 3 "," "(" ix "-" "[expr_NDIS]" ")" ","
	{ a => 5481, b => 5482, c => 5483, d => 5484, e => 5485, h => 5486, l => 5487, },
	# [5481] opcode : set "[inline_const]" 3 "," "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1475 ], ":" => [ 7, \&_action_opcode_1475 ], },
	# [5482] opcode : set "[inline_const]" 3 "," "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1476 ], ":" => [ 7, \&_action_opcode_1476 ], },
	# [5483] opcode : set "[inline_const]" 3 "," "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1477 ], ":" => [ 7, \&_action_opcode_1477 ], },
	# [5484] opcode : set "[inline_const]" 3 "," "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1478 ], ":" => [ 7, \&_action_opcode_1478 ], },
	# [5485] opcode : set "[inline_const]" 3 "," "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1479 ], ":" => [ 7, \&_action_opcode_1479 ], },
	# [5486] opcode : set "[inline_const]" 3 "," "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1480 ], ":" => [ 7, \&_action_opcode_1480 ], },
	# [5487] opcode : set "[inline_const]" 3 "," "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1481 ], ":" => [ 7, \&_action_opcode_1481 ], },
	# [5488] opcode : set "[inline_const]" 3 "," "(" iy
	{ ")" => 5489, "+" => 5498, "-" => 5509, },
	# [5489] opcode : set "[inline_const]" 3 "," "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_1482 ], "," => 5490, ":" => [ 7, \&_action_opcode_1482 ], },
	# [5490] opcode : set "[inline_const]" 3 "," "(" iy ")" ","
	{ a => 5491, b => 5492, c => 5493, d => 5494, e => 5495, h => 5496, l => 5497, },
	# [5491] opcode : set "[inline_const]" 3 "," "(" iy ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1483 ], ":" => [ 7, \&_action_opcode_1483 ], },
	# [5492] opcode : set "[inline_const]" 3 "," "(" iy ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1484 ], ":" => [ 7, \&_action_opcode_1484 ], },
	# [5493] opcode : set "[inline_const]" 3 "," "(" iy ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1485 ], ":" => [ 7, \&_action_opcode_1485 ], },
	# [5494] opcode : set "[inline_const]" 3 "," "(" iy ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1486 ], ":" => [ 7, \&_action_opcode_1486 ], },
	# [5495] opcode : set "[inline_const]" 3 "," "(" iy ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1487 ], ":" => [ 7, \&_action_opcode_1487 ], },
	# [5496] opcode : set "[inline_const]" 3 "," "(" iy ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1488 ], ":" => [ 7, \&_action_opcode_1488 ], },
	# [5497] opcode : set "[inline_const]" 3 "," "(" iy ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1489 ], ":" => [ 7, \&_action_opcode_1489 ], },
	# [5498] opcode : set "[inline_const]" 3 "," "(" iy "+"
	{ "!" => [ 12, 5499 ], "+" => [ 12, 5499 ], "-" => [ 12, 5499 ], __else__ => [ 12, 5499 ], "~" => [ 12, 5499 ], },
	# [5499] opcode : set "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]"
	{ ")" => 5500, },
	# [5500] opcode : set "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1490 ], "," => 5501, ":" => [ 7, \&_action_opcode_1490 ], },
	# [5501] opcode : set "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" ","
	{ a => 5502, b => 5503, c => 5504, d => 5505, e => 5506, h => 5507, l => 5508, },
	# [5502] opcode : set "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1491 ], ":" => [ 7, \&_action_opcode_1491 ], },
	# [5503] opcode : set "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1492 ], ":" => [ 7, \&_action_opcode_1492 ], },
	# [5504] opcode : set "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1493 ], ":" => [ 7, \&_action_opcode_1493 ], },
	# [5505] opcode : set "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1494 ], ":" => [ 7, \&_action_opcode_1494 ], },
	# [5506] opcode : set "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1495 ], ":" => [ 7, \&_action_opcode_1495 ], },
	# [5507] opcode : set "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1496 ], ":" => [ 7, \&_action_opcode_1496 ], },
	# [5508] opcode : set "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1497 ], ":" => [ 7, \&_action_opcode_1497 ], },
	# [5509] opcode : set "[inline_const]" 3 "," "(" iy "-"
	{ "!" => [ 14, 5510 ], "+" => [ 14, 5510 ], "-" => [ 14, 5510 ], __else__ => [ 14, 5510 ], "~" => [ 14, 5510 ], },
	# [5510] opcode : set "[inline_const]" 3 "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 5511, },
	# [5511] opcode : set "[inline_const]" 3 "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1490 ], "," => 5512, ":" => [ 7, \&_action_opcode_1490 ], },
	# [5512] opcode : set "[inline_const]" 3 "," "(" iy "-" "[expr_NDIS]" ")" ","
	{ a => 5513, b => 5514, c => 5515, d => 5516, e => 5517, h => 5518, l => 5519, },
	# [5513] opcode : set "[inline_const]" 3 "," "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1491 ], ":" => [ 7, \&_action_opcode_1491 ], },
	# [5514] opcode : set "[inline_const]" 3 "," "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1492 ], ":" => [ 7, \&_action_opcode_1492 ], },
	# [5515] opcode : set "[inline_const]" 3 "," "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1493 ], ":" => [ 7, \&_action_opcode_1493 ], },
	# [5516] opcode : set "[inline_const]" 3 "," "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1494 ], ":" => [ 7, \&_action_opcode_1494 ], },
	# [5517] opcode : set "[inline_const]" 3 "," "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1495 ], ":" => [ 7, \&_action_opcode_1495 ], },
	# [5518] opcode : set "[inline_const]" 3 "," "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1496 ], ":" => [ 7, \&_action_opcode_1496 ], },
	# [5519] opcode : set "[inline_const]" 3 "," "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1497 ], ":" => [ 7, \&_action_opcode_1497 ], },
	# [5520] opcode : set "[inline_const]" 3 "," "["
	{ hl => 5521, ix => 5523, iy => 5555, },
	# [5521] opcode : set "[inline_const]" 3 "," "[" hl
	{ "]" => 5522, },
	# [5522] opcode : set "[inline_const]" 3 "," "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_1465 ], ":" => [ 7, \&_action_opcode_1465 ], },
	# [5523] opcode : set "[inline_const]" 3 "," "[" ix
	{ "+" => 5524, "-" => 5535, "]" => 5546, },
	# [5524] opcode : set "[inline_const]" 3 "," "[" ix "+"
	{ "!" => [ 12, 5525 ], "+" => [ 12, 5525 ], "-" => [ 12, 5525 ], __else__ => [ 12, 5525 ], "~" => [ 12, 5525 ], },
	# [5525] opcode : set "[inline_const]" 3 "," "[" ix "+" "[expr_DIS]"
	{ "]" => 5526, },
	# [5526] opcode : set "[inline_const]" 3 "," "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1474 ], "," => 5527, ":" => [ 7, \&_action_opcode_1474 ], },
	# [5527] opcode : set "[inline_const]" 3 "," "[" ix "+" "[expr_DIS]" "]" ","
	{ a => 5528, b => 5529, c => 5530, d => 5531, e => 5532, h => 5533, l => 5534, },
	# [5528] opcode : set "[inline_const]" 3 "," "[" ix "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1475 ], ":" => [ 7, \&_action_opcode_1475 ], },
	# [5529] opcode : set "[inline_const]" 3 "," "[" ix "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1476 ], ":" => [ 7, \&_action_opcode_1476 ], },
	# [5530] opcode : set "[inline_const]" 3 "," "[" ix "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1477 ], ":" => [ 7, \&_action_opcode_1477 ], },
	# [5531] opcode : set "[inline_const]" 3 "," "[" ix "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1478 ], ":" => [ 7, \&_action_opcode_1478 ], },
	# [5532] opcode : set "[inline_const]" 3 "," "[" ix "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1479 ], ":" => [ 7, \&_action_opcode_1479 ], },
	# [5533] opcode : set "[inline_const]" 3 "," "[" ix "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1480 ], ":" => [ 7, \&_action_opcode_1480 ], },
	# [5534] opcode : set "[inline_const]" 3 "," "[" ix "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1481 ], ":" => [ 7, \&_action_opcode_1481 ], },
	# [5535] opcode : set "[inline_const]" 3 "," "[" ix "-"
	{ "!" => [ 14, 5536 ], "+" => [ 14, 5536 ], "-" => [ 14, 5536 ], __else__ => [ 14, 5536 ], "~" => [ 14, 5536 ], },
	# [5536] opcode : set "[inline_const]" 3 "," "[" ix "-" "[expr_NDIS]"
	{ "]" => 5537, },
	# [5537] opcode : set "[inline_const]" 3 "," "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1474 ], "," => 5538, ":" => [ 7, \&_action_opcode_1474 ], },
	# [5538] opcode : set "[inline_const]" 3 "," "[" ix "-" "[expr_NDIS]" "]" ","
	{ a => 5539, b => 5540, c => 5541, d => 5542, e => 5543, h => 5544, l => 5545, },
	# [5539] opcode : set "[inline_const]" 3 "," "[" ix "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1475 ], ":" => [ 7, \&_action_opcode_1475 ], },
	# [5540] opcode : set "[inline_const]" 3 "," "[" ix "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1476 ], ":" => [ 7, \&_action_opcode_1476 ], },
	# [5541] opcode : set "[inline_const]" 3 "," "[" ix "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1477 ], ":" => [ 7, \&_action_opcode_1477 ], },
	# [5542] opcode : set "[inline_const]" 3 "," "[" ix "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1478 ], ":" => [ 7, \&_action_opcode_1478 ], },
	# [5543] opcode : set "[inline_const]" 3 "," "[" ix "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1479 ], ":" => [ 7, \&_action_opcode_1479 ], },
	# [5544] opcode : set "[inline_const]" 3 "," "[" ix "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1480 ], ":" => [ 7, \&_action_opcode_1480 ], },
	# [5545] opcode : set "[inline_const]" 3 "," "[" ix "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1481 ], ":" => [ 7, \&_action_opcode_1481 ], },
	# [5546] opcode : set "[inline_const]" 3 "," "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_1466 ], "," => 5547, ":" => [ 7, \&_action_opcode_1466 ], },
	# [5547] opcode : set "[inline_const]" 3 "," "[" ix "]" ","
	{ a => 5548, b => 5549, c => 5550, d => 5551, e => 5552, h => 5553, l => 5554, },
	# [5548] opcode : set "[inline_const]" 3 "," "[" ix "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1467 ], ":" => [ 7, \&_action_opcode_1467 ], },
	# [5549] opcode : set "[inline_const]" 3 "," "[" ix "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1468 ], ":" => [ 7, \&_action_opcode_1468 ], },
	# [5550] opcode : set "[inline_const]" 3 "," "[" ix "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1469 ], ":" => [ 7, \&_action_opcode_1469 ], },
	# [5551] opcode : set "[inline_const]" 3 "," "[" ix "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1470 ], ":" => [ 7, \&_action_opcode_1470 ], },
	# [5552] opcode : set "[inline_const]" 3 "," "[" ix "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1471 ], ":" => [ 7, \&_action_opcode_1471 ], },
	# [5553] opcode : set "[inline_const]" 3 "," "[" ix "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1472 ], ":" => [ 7, \&_action_opcode_1472 ], },
	# [5554] opcode : set "[inline_const]" 3 "," "[" ix "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1473 ], ":" => [ 7, \&_action_opcode_1473 ], },
	# [5555] opcode : set "[inline_const]" 3 "," "[" iy
	{ "+" => 5556, "-" => 5567, "]" => 5578, },
	# [5556] opcode : set "[inline_const]" 3 "," "[" iy "+"
	{ "!" => [ 12, 5557 ], "+" => [ 12, 5557 ], "-" => [ 12, 5557 ], __else__ => [ 12, 5557 ], "~" => [ 12, 5557 ], },
	# [5557] opcode : set "[inline_const]" 3 "," "[" iy "+" "[expr_DIS]"
	{ "]" => 5558, },
	# [5558] opcode : set "[inline_const]" 3 "," "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1490 ], "," => 5559, ":" => [ 7, \&_action_opcode_1490 ], },
	# [5559] opcode : set "[inline_const]" 3 "," "[" iy "+" "[expr_DIS]" "]" ","
	{ a => 5560, b => 5561, c => 5562, d => 5563, e => 5564, h => 5565, l => 5566, },
	# [5560] opcode : set "[inline_const]" 3 "," "[" iy "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1491 ], ":" => [ 7, \&_action_opcode_1491 ], },
	# [5561] opcode : set "[inline_const]" 3 "," "[" iy "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1492 ], ":" => [ 7, \&_action_opcode_1492 ], },
	# [5562] opcode : set "[inline_const]" 3 "," "[" iy "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1493 ], ":" => [ 7, \&_action_opcode_1493 ], },
	# [5563] opcode : set "[inline_const]" 3 "," "[" iy "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1494 ], ":" => [ 7, \&_action_opcode_1494 ], },
	# [5564] opcode : set "[inline_const]" 3 "," "[" iy "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1495 ], ":" => [ 7, \&_action_opcode_1495 ], },
	# [5565] opcode : set "[inline_const]" 3 "," "[" iy "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1496 ], ":" => [ 7, \&_action_opcode_1496 ], },
	# [5566] opcode : set "[inline_const]" 3 "," "[" iy "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1497 ], ":" => [ 7, \&_action_opcode_1497 ], },
	# [5567] opcode : set "[inline_const]" 3 "," "[" iy "-"
	{ "!" => [ 14, 5568 ], "+" => [ 14, 5568 ], "-" => [ 14, 5568 ], __else__ => [ 14, 5568 ], "~" => [ 14, 5568 ], },
	# [5568] opcode : set "[inline_const]" 3 "," "[" iy "-" "[expr_NDIS]"
	{ "]" => 5569, },
	# [5569] opcode : set "[inline_const]" 3 "," "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1490 ], "," => 5570, ":" => [ 7, \&_action_opcode_1490 ], },
	# [5570] opcode : set "[inline_const]" 3 "," "[" iy "-" "[expr_NDIS]" "]" ","
	{ a => 5571, b => 5572, c => 5573, d => 5574, e => 5575, h => 5576, l => 5577, },
	# [5571] opcode : set "[inline_const]" 3 "," "[" iy "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1491 ], ":" => [ 7, \&_action_opcode_1491 ], },
	# [5572] opcode : set "[inline_const]" 3 "," "[" iy "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1492 ], ":" => [ 7, \&_action_opcode_1492 ], },
	# [5573] opcode : set "[inline_const]" 3 "," "[" iy "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1493 ], ":" => [ 7, \&_action_opcode_1493 ], },
	# [5574] opcode : set "[inline_const]" 3 "," "[" iy "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1494 ], ":" => [ 7, \&_action_opcode_1494 ], },
	# [5575] opcode : set "[inline_const]" 3 "," "[" iy "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1495 ], ":" => [ 7, \&_action_opcode_1495 ], },
	# [5576] opcode : set "[inline_const]" 3 "," "[" iy "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1496 ], ":" => [ 7, \&_action_opcode_1496 ], },
	# [5577] opcode : set "[inline_const]" 3 "," "[" iy "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1497 ], ":" => [ 7, \&_action_opcode_1497 ], },
	# [5578] opcode : set "[inline_const]" 3 "," "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_1482 ], "," => 5579, ":" => [ 7, \&_action_opcode_1482 ], },
	# [5579] opcode : set "[inline_const]" 3 "," "[" iy "]" ","
	{ a => 5580, b => 5581, c => 5582, d => 5583, e => 5584, h => 5585, l => 5586, },
	# [5580] opcode : set "[inline_const]" 3 "," "[" iy "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1483 ], ":" => [ 7, \&_action_opcode_1483 ], },
	# [5581] opcode : set "[inline_const]" 3 "," "[" iy "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1484 ], ":" => [ 7, \&_action_opcode_1484 ], },
	# [5582] opcode : set "[inline_const]" 3 "," "[" iy "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1485 ], ":" => [ 7, \&_action_opcode_1485 ], },
	# [5583] opcode : set "[inline_const]" 3 "," "[" iy "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1486 ], ":" => [ 7, \&_action_opcode_1486 ], },
	# [5584] opcode : set "[inline_const]" 3 "," "[" iy "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1487 ], ":" => [ 7, \&_action_opcode_1487 ], },
	# [5585] opcode : set "[inline_const]" 3 "," "[" iy "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1488 ], ":" => [ 7, \&_action_opcode_1488 ], },
	# [5586] opcode : set "[inline_const]" 3 "," "[" iy "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1489 ], ":" => [ 7, \&_action_opcode_1489 ], },
	# [5587] opcode : set "[inline_const]" 3 "," a
	{ "\n" => [ 7, \&_action_opcode_1498 ], ":" => [ 7, \&_action_opcode_1498 ], },
	# [5588] opcode : set "[inline_const]" 3 "," b
	{ "\n" => [ 7, \&_action_opcode_1499 ], ":" => [ 7, \&_action_opcode_1499 ], },
	# [5589] opcode : set "[inline_const]" 3 "," c
	{ "\n" => [ 7, \&_action_opcode_1500 ], ":" => [ 7, \&_action_opcode_1500 ], },
	# [5590] opcode : set "[inline_const]" 3 "," d
	{ "\n" => [ 7, \&_action_opcode_1501 ], ":" => [ 7, \&_action_opcode_1501 ], },
	# [5591] opcode : set "[inline_const]" 3 "," e
	{ "\n" => [ 7, \&_action_opcode_1502 ], ":" => [ 7, \&_action_opcode_1502 ], },
	# [5592] opcode : set "[inline_const]" 3 "," h
	{ "\n" => [ 7, \&_action_opcode_1503 ], ":" => [ 7, \&_action_opcode_1503 ], },
	# [5593] opcode : set "[inline_const]" 3 "," l
	{ "\n" => [ 7, \&_action_opcode_1504 ], ":" => [ 7, \&_action_opcode_1504 ], },
	# [5594] opcode : set "[inline_const]" 4
	{ "," => 5595, },
	# [5595] opcode : set "[inline_const]" 4 ","
	{ "(" => 5596, "[" => 5663, a => 5730, b => 5731, c => 5732, d => 5733, e => 5734, h => 5735, l => 5736, },
	# [5596] opcode : set "[inline_const]" 4 "," "("
	{ hl => 5597, ix => 5599, iy => 5631, },
	# [5597] opcode : set "[inline_const]" 4 "," "(" hl
	{ ")" => 5598, },
	# [5598] opcode : set "[inline_const]" 4 "," "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_1505 ], ":" => [ 7, \&_action_opcode_1505 ], },
	# [5599] opcode : set "[inline_const]" 4 "," "(" ix
	{ ")" => 5600, "+" => 5609, "-" => 5620, },
	# [5600] opcode : set "[inline_const]" 4 "," "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_1506 ], "," => 5601, ":" => [ 7, \&_action_opcode_1506 ], },
	# [5601] opcode : set "[inline_const]" 4 "," "(" ix ")" ","
	{ a => 5602, b => 5603, c => 5604, d => 5605, e => 5606, h => 5607, l => 5608, },
	# [5602] opcode : set "[inline_const]" 4 "," "(" ix ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1507 ], ":" => [ 7, \&_action_opcode_1507 ], },
	# [5603] opcode : set "[inline_const]" 4 "," "(" ix ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1508 ], ":" => [ 7, \&_action_opcode_1508 ], },
	# [5604] opcode : set "[inline_const]" 4 "," "(" ix ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1509 ], ":" => [ 7, \&_action_opcode_1509 ], },
	# [5605] opcode : set "[inline_const]" 4 "," "(" ix ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1510 ], ":" => [ 7, \&_action_opcode_1510 ], },
	# [5606] opcode : set "[inline_const]" 4 "," "(" ix ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1511 ], ":" => [ 7, \&_action_opcode_1511 ], },
	# [5607] opcode : set "[inline_const]" 4 "," "(" ix ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1512 ], ":" => [ 7, \&_action_opcode_1512 ], },
	# [5608] opcode : set "[inline_const]" 4 "," "(" ix ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1513 ], ":" => [ 7, \&_action_opcode_1513 ], },
	# [5609] opcode : set "[inline_const]" 4 "," "(" ix "+"
	{ "!" => [ 12, 5610 ], "+" => [ 12, 5610 ], "-" => [ 12, 5610 ], __else__ => [ 12, 5610 ], "~" => [ 12, 5610 ], },
	# [5610] opcode : set "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]"
	{ ")" => 5611, },
	# [5611] opcode : set "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1514 ], "," => 5612, ":" => [ 7, \&_action_opcode_1514 ], },
	# [5612] opcode : set "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" ","
	{ a => 5613, b => 5614, c => 5615, d => 5616, e => 5617, h => 5618, l => 5619, },
	# [5613] opcode : set "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1515 ], ":" => [ 7, \&_action_opcode_1515 ], },
	# [5614] opcode : set "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1516 ], ":" => [ 7, \&_action_opcode_1516 ], },
	# [5615] opcode : set "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1517 ], ":" => [ 7, \&_action_opcode_1517 ], },
	# [5616] opcode : set "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1518 ], ":" => [ 7, \&_action_opcode_1518 ], },
	# [5617] opcode : set "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1519 ], ":" => [ 7, \&_action_opcode_1519 ], },
	# [5618] opcode : set "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1520 ], ":" => [ 7, \&_action_opcode_1520 ], },
	# [5619] opcode : set "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1521 ], ":" => [ 7, \&_action_opcode_1521 ], },
	# [5620] opcode : set "[inline_const]" 4 "," "(" ix "-"
	{ "!" => [ 14, 5621 ], "+" => [ 14, 5621 ], "-" => [ 14, 5621 ], __else__ => [ 14, 5621 ], "~" => [ 14, 5621 ], },
	# [5621] opcode : set "[inline_const]" 4 "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 5622, },
	# [5622] opcode : set "[inline_const]" 4 "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1514 ], "," => 5623, ":" => [ 7, \&_action_opcode_1514 ], },
	# [5623] opcode : set "[inline_const]" 4 "," "(" ix "-" "[expr_NDIS]" ")" ","
	{ a => 5624, b => 5625, c => 5626, d => 5627, e => 5628, h => 5629, l => 5630, },
	# [5624] opcode : set "[inline_const]" 4 "," "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1515 ], ":" => [ 7, \&_action_opcode_1515 ], },
	# [5625] opcode : set "[inline_const]" 4 "," "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1516 ], ":" => [ 7, \&_action_opcode_1516 ], },
	# [5626] opcode : set "[inline_const]" 4 "," "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1517 ], ":" => [ 7, \&_action_opcode_1517 ], },
	# [5627] opcode : set "[inline_const]" 4 "," "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1518 ], ":" => [ 7, \&_action_opcode_1518 ], },
	# [5628] opcode : set "[inline_const]" 4 "," "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1519 ], ":" => [ 7, \&_action_opcode_1519 ], },
	# [5629] opcode : set "[inline_const]" 4 "," "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1520 ], ":" => [ 7, \&_action_opcode_1520 ], },
	# [5630] opcode : set "[inline_const]" 4 "," "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1521 ], ":" => [ 7, \&_action_opcode_1521 ], },
	# [5631] opcode : set "[inline_const]" 4 "," "(" iy
	{ ")" => 5632, "+" => 5641, "-" => 5652, },
	# [5632] opcode : set "[inline_const]" 4 "," "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_1522 ], "," => 5633, ":" => [ 7, \&_action_opcode_1522 ], },
	# [5633] opcode : set "[inline_const]" 4 "," "(" iy ")" ","
	{ a => 5634, b => 5635, c => 5636, d => 5637, e => 5638, h => 5639, l => 5640, },
	# [5634] opcode : set "[inline_const]" 4 "," "(" iy ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1523 ], ":" => [ 7, \&_action_opcode_1523 ], },
	# [5635] opcode : set "[inline_const]" 4 "," "(" iy ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1524 ], ":" => [ 7, \&_action_opcode_1524 ], },
	# [5636] opcode : set "[inline_const]" 4 "," "(" iy ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1525 ], ":" => [ 7, \&_action_opcode_1525 ], },
	# [5637] opcode : set "[inline_const]" 4 "," "(" iy ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1526 ], ":" => [ 7, \&_action_opcode_1526 ], },
	# [5638] opcode : set "[inline_const]" 4 "," "(" iy ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1527 ], ":" => [ 7, \&_action_opcode_1527 ], },
	# [5639] opcode : set "[inline_const]" 4 "," "(" iy ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1528 ], ":" => [ 7, \&_action_opcode_1528 ], },
	# [5640] opcode : set "[inline_const]" 4 "," "(" iy ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1529 ], ":" => [ 7, \&_action_opcode_1529 ], },
	# [5641] opcode : set "[inline_const]" 4 "," "(" iy "+"
	{ "!" => [ 12, 5642 ], "+" => [ 12, 5642 ], "-" => [ 12, 5642 ], __else__ => [ 12, 5642 ], "~" => [ 12, 5642 ], },
	# [5642] opcode : set "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]"
	{ ")" => 5643, },
	# [5643] opcode : set "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1530 ], "," => 5644, ":" => [ 7, \&_action_opcode_1530 ], },
	# [5644] opcode : set "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" ","
	{ a => 5645, b => 5646, c => 5647, d => 5648, e => 5649, h => 5650, l => 5651, },
	# [5645] opcode : set "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1531 ], ":" => [ 7, \&_action_opcode_1531 ], },
	# [5646] opcode : set "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1532 ], ":" => [ 7, \&_action_opcode_1532 ], },
	# [5647] opcode : set "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1533 ], ":" => [ 7, \&_action_opcode_1533 ], },
	# [5648] opcode : set "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1534 ], ":" => [ 7, \&_action_opcode_1534 ], },
	# [5649] opcode : set "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1535 ], ":" => [ 7, \&_action_opcode_1535 ], },
	# [5650] opcode : set "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1536 ], ":" => [ 7, \&_action_opcode_1536 ], },
	# [5651] opcode : set "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1537 ], ":" => [ 7, \&_action_opcode_1537 ], },
	# [5652] opcode : set "[inline_const]" 4 "," "(" iy "-"
	{ "!" => [ 14, 5653 ], "+" => [ 14, 5653 ], "-" => [ 14, 5653 ], __else__ => [ 14, 5653 ], "~" => [ 14, 5653 ], },
	# [5653] opcode : set "[inline_const]" 4 "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 5654, },
	# [5654] opcode : set "[inline_const]" 4 "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1530 ], "," => 5655, ":" => [ 7, \&_action_opcode_1530 ], },
	# [5655] opcode : set "[inline_const]" 4 "," "(" iy "-" "[expr_NDIS]" ")" ","
	{ a => 5656, b => 5657, c => 5658, d => 5659, e => 5660, h => 5661, l => 5662, },
	# [5656] opcode : set "[inline_const]" 4 "," "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1531 ], ":" => [ 7, \&_action_opcode_1531 ], },
	# [5657] opcode : set "[inline_const]" 4 "," "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1532 ], ":" => [ 7, \&_action_opcode_1532 ], },
	# [5658] opcode : set "[inline_const]" 4 "," "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1533 ], ":" => [ 7, \&_action_opcode_1533 ], },
	# [5659] opcode : set "[inline_const]" 4 "," "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1534 ], ":" => [ 7, \&_action_opcode_1534 ], },
	# [5660] opcode : set "[inline_const]" 4 "," "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1535 ], ":" => [ 7, \&_action_opcode_1535 ], },
	# [5661] opcode : set "[inline_const]" 4 "," "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1536 ], ":" => [ 7, \&_action_opcode_1536 ], },
	# [5662] opcode : set "[inline_const]" 4 "," "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1537 ], ":" => [ 7, \&_action_opcode_1537 ], },
	# [5663] opcode : set "[inline_const]" 4 "," "["
	{ hl => 5664, ix => 5666, iy => 5698, },
	# [5664] opcode : set "[inline_const]" 4 "," "[" hl
	{ "]" => 5665, },
	# [5665] opcode : set "[inline_const]" 4 "," "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_1505 ], ":" => [ 7, \&_action_opcode_1505 ], },
	# [5666] opcode : set "[inline_const]" 4 "," "[" ix
	{ "+" => 5667, "-" => 5678, "]" => 5689, },
	# [5667] opcode : set "[inline_const]" 4 "," "[" ix "+"
	{ "!" => [ 12, 5668 ], "+" => [ 12, 5668 ], "-" => [ 12, 5668 ], __else__ => [ 12, 5668 ], "~" => [ 12, 5668 ], },
	# [5668] opcode : set "[inline_const]" 4 "," "[" ix "+" "[expr_DIS]"
	{ "]" => 5669, },
	# [5669] opcode : set "[inline_const]" 4 "," "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1514 ], "," => 5670, ":" => [ 7, \&_action_opcode_1514 ], },
	# [5670] opcode : set "[inline_const]" 4 "," "[" ix "+" "[expr_DIS]" "]" ","
	{ a => 5671, b => 5672, c => 5673, d => 5674, e => 5675, h => 5676, l => 5677, },
	# [5671] opcode : set "[inline_const]" 4 "," "[" ix "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1515 ], ":" => [ 7, \&_action_opcode_1515 ], },
	# [5672] opcode : set "[inline_const]" 4 "," "[" ix "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1516 ], ":" => [ 7, \&_action_opcode_1516 ], },
	# [5673] opcode : set "[inline_const]" 4 "," "[" ix "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1517 ], ":" => [ 7, \&_action_opcode_1517 ], },
	# [5674] opcode : set "[inline_const]" 4 "," "[" ix "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1518 ], ":" => [ 7, \&_action_opcode_1518 ], },
	# [5675] opcode : set "[inline_const]" 4 "," "[" ix "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1519 ], ":" => [ 7, \&_action_opcode_1519 ], },
	# [5676] opcode : set "[inline_const]" 4 "," "[" ix "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1520 ], ":" => [ 7, \&_action_opcode_1520 ], },
	# [5677] opcode : set "[inline_const]" 4 "," "[" ix "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1521 ], ":" => [ 7, \&_action_opcode_1521 ], },
	# [5678] opcode : set "[inline_const]" 4 "," "[" ix "-"
	{ "!" => [ 14, 5679 ], "+" => [ 14, 5679 ], "-" => [ 14, 5679 ], __else__ => [ 14, 5679 ], "~" => [ 14, 5679 ], },
	# [5679] opcode : set "[inline_const]" 4 "," "[" ix "-" "[expr_NDIS]"
	{ "]" => 5680, },
	# [5680] opcode : set "[inline_const]" 4 "," "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1514 ], "," => 5681, ":" => [ 7, \&_action_opcode_1514 ], },
	# [5681] opcode : set "[inline_const]" 4 "," "[" ix "-" "[expr_NDIS]" "]" ","
	{ a => 5682, b => 5683, c => 5684, d => 5685, e => 5686, h => 5687, l => 5688, },
	# [5682] opcode : set "[inline_const]" 4 "," "[" ix "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1515 ], ":" => [ 7, \&_action_opcode_1515 ], },
	# [5683] opcode : set "[inline_const]" 4 "," "[" ix "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1516 ], ":" => [ 7, \&_action_opcode_1516 ], },
	# [5684] opcode : set "[inline_const]" 4 "," "[" ix "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1517 ], ":" => [ 7, \&_action_opcode_1517 ], },
	# [5685] opcode : set "[inline_const]" 4 "," "[" ix "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1518 ], ":" => [ 7, \&_action_opcode_1518 ], },
	# [5686] opcode : set "[inline_const]" 4 "," "[" ix "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1519 ], ":" => [ 7, \&_action_opcode_1519 ], },
	# [5687] opcode : set "[inline_const]" 4 "," "[" ix "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1520 ], ":" => [ 7, \&_action_opcode_1520 ], },
	# [5688] opcode : set "[inline_const]" 4 "," "[" ix "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1521 ], ":" => [ 7, \&_action_opcode_1521 ], },
	# [5689] opcode : set "[inline_const]" 4 "," "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_1506 ], "," => 5690, ":" => [ 7, \&_action_opcode_1506 ], },
	# [5690] opcode : set "[inline_const]" 4 "," "[" ix "]" ","
	{ a => 5691, b => 5692, c => 5693, d => 5694, e => 5695, h => 5696, l => 5697, },
	# [5691] opcode : set "[inline_const]" 4 "," "[" ix "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1507 ], ":" => [ 7, \&_action_opcode_1507 ], },
	# [5692] opcode : set "[inline_const]" 4 "," "[" ix "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1508 ], ":" => [ 7, \&_action_opcode_1508 ], },
	# [5693] opcode : set "[inline_const]" 4 "," "[" ix "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1509 ], ":" => [ 7, \&_action_opcode_1509 ], },
	# [5694] opcode : set "[inline_const]" 4 "," "[" ix "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1510 ], ":" => [ 7, \&_action_opcode_1510 ], },
	# [5695] opcode : set "[inline_const]" 4 "," "[" ix "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1511 ], ":" => [ 7, \&_action_opcode_1511 ], },
	# [5696] opcode : set "[inline_const]" 4 "," "[" ix "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1512 ], ":" => [ 7, \&_action_opcode_1512 ], },
	# [5697] opcode : set "[inline_const]" 4 "," "[" ix "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1513 ], ":" => [ 7, \&_action_opcode_1513 ], },
	# [5698] opcode : set "[inline_const]" 4 "," "[" iy
	{ "+" => 5699, "-" => 5710, "]" => 5721, },
	# [5699] opcode : set "[inline_const]" 4 "," "[" iy "+"
	{ "!" => [ 12, 5700 ], "+" => [ 12, 5700 ], "-" => [ 12, 5700 ], __else__ => [ 12, 5700 ], "~" => [ 12, 5700 ], },
	# [5700] opcode : set "[inline_const]" 4 "," "[" iy "+" "[expr_DIS]"
	{ "]" => 5701, },
	# [5701] opcode : set "[inline_const]" 4 "," "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1530 ], "," => 5702, ":" => [ 7, \&_action_opcode_1530 ], },
	# [5702] opcode : set "[inline_const]" 4 "," "[" iy "+" "[expr_DIS]" "]" ","
	{ a => 5703, b => 5704, c => 5705, d => 5706, e => 5707, h => 5708, l => 5709, },
	# [5703] opcode : set "[inline_const]" 4 "," "[" iy "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1531 ], ":" => [ 7, \&_action_opcode_1531 ], },
	# [5704] opcode : set "[inline_const]" 4 "," "[" iy "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1532 ], ":" => [ 7, \&_action_opcode_1532 ], },
	# [5705] opcode : set "[inline_const]" 4 "," "[" iy "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1533 ], ":" => [ 7, \&_action_opcode_1533 ], },
	# [5706] opcode : set "[inline_const]" 4 "," "[" iy "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1534 ], ":" => [ 7, \&_action_opcode_1534 ], },
	# [5707] opcode : set "[inline_const]" 4 "," "[" iy "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1535 ], ":" => [ 7, \&_action_opcode_1535 ], },
	# [5708] opcode : set "[inline_const]" 4 "," "[" iy "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1536 ], ":" => [ 7, \&_action_opcode_1536 ], },
	# [5709] opcode : set "[inline_const]" 4 "," "[" iy "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1537 ], ":" => [ 7, \&_action_opcode_1537 ], },
	# [5710] opcode : set "[inline_const]" 4 "," "[" iy "-"
	{ "!" => [ 14, 5711 ], "+" => [ 14, 5711 ], "-" => [ 14, 5711 ], __else__ => [ 14, 5711 ], "~" => [ 14, 5711 ], },
	# [5711] opcode : set "[inline_const]" 4 "," "[" iy "-" "[expr_NDIS]"
	{ "]" => 5712, },
	# [5712] opcode : set "[inline_const]" 4 "," "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1530 ], "," => 5713, ":" => [ 7, \&_action_opcode_1530 ], },
	# [5713] opcode : set "[inline_const]" 4 "," "[" iy "-" "[expr_NDIS]" "]" ","
	{ a => 5714, b => 5715, c => 5716, d => 5717, e => 5718, h => 5719, l => 5720, },
	# [5714] opcode : set "[inline_const]" 4 "," "[" iy "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1531 ], ":" => [ 7, \&_action_opcode_1531 ], },
	# [5715] opcode : set "[inline_const]" 4 "," "[" iy "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1532 ], ":" => [ 7, \&_action_opcode_1532 ], },
	# [5716] opcode : set "[inline_const]" 4 "," "[" iy "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1533 ], ":" => [ 7, \&_action_opcode_1533 ], },
	# [5717] opcode : set "[inline_const]" 4 "," "[" iy "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1534 ], ":" => [ 7, \&_action_opcode_1534 ], },
	# [5718] opcode : set "[inline_const]" 4 "," "[" iy "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1535 ], ":" => [ 7, \&_action_opcode_1535 ], },
	# [5719] opcode : set "[inline_const]" 4 "," "[" iy "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1536 ], ":" => [ 7, \&_action_opcode_1536 ], },
	# [5720] opcode : set "[inline_const]" 4 "," "[" iy "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1537 ], ":" => [ 7, \&_action_opcode_1537 ], },
	# [5721] opcode : set "[inline_const]" 4 "," "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_1522 ], "," => 5722, ":" => [ 7, \&_action_opcode_1522 ], },
	# [5722] opcode : set "[inline_const]" 4 "," "[" iy "]" ","
	{ a => 5723, b => 5724, c => 5725, d => 5726, e => 5727, h => 5728, l => 5729, },
	# [5723] opcode : set "[inline_const]" 4 "," "[" iy "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1523 ], ":" => [ 7, \&_action_opcode_1523 ], },
	# [5724] opcode : set "[inline_const]" 4 "," "[" iy "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1524 ], ":" => [ 7, \&_action_opcode_1524 ], },
	# [5725] opcode : set "[inline_const]" 4 "," "[" iy "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1525 ], ":" => [ 7, \&_action_opcode_1525 ], },
	# [5726] opcode : set "[inline_const]" 4 "," "[" iy "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1526 ], ":" => [ 7, \&_action_opcode_1526 ], },
	# [5727] opcode : set "[inline_const]" 4 "," "[" iy "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1527 ], ":" => [ 7, \&_action_opcode_1527 ], },
	# [5728] opcode : set "[inline_const]" 4 "," "[" iy "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1528 ], ":" => [ 7, \&_action_opcode_1528 ], },
	# [5729] opcode : set "[inline_const]" 4 "," "[" iy "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1529 ], ":" => [ 7, \&_action_opcode_1529 ], },
	# [5730] opcode : set "[inline_const]" 4 "," a
	{ "\n" => [ 7, \&_action_opcode_1538 ], ":" => [ 7, \&_action_opcode_1538 ], },
	# [5731] opcode : set "[inline_const]" 4 "," b
	{ "\n" => [ 7, \&_action_opcode_1539 ], ":" => [ 7, \&_action_opcode_1539 ], },
	# [5732] opcode : set "[inline_const]" 4 "," c
	{ "\n" => [ 7, \&_action_opcode_1540 ], ":" => [ 7, \&_action_opcode_1540 ], },
	# [5733] opcode : set "[inline_const]" 4 "," d
	{ "\n" => [ 7, \&_action_opcode_1541 ], ":" => [ 7, \&_action_opcode_1541 ], },
	# [5734] opcode : set "[inline_const]" 4 "," e
	{ "\n" => [ 7, \&_action_opcode_1542 ], ":" => [ 7, \&_action_opcode_1542 ], },
	# [5735] opcode : set "[inline_const]" 4 "," h
	{ "\n" => [ 7, \&_action_opcode_1543 ], ":" => [ 7, \&_action_opcode_1543 ], },
	# [5736] opcode : set "[inline_const]" 4 "," l
	{ "\n" => [ 7, \&_action_opcode_1544 ], ":" => [ 7, \&_action_opcode_1544 ], },
	# [5737] opcode : set "[inline_const]" 5
	{ "," => 5738, },
	# [5738] opcode : set "[inline_const]" 5 ","
	{ "(" => 5739, "[" => 5806, a => 5873, b => 5874, c => 5875, d => 5876, e => 5877, h => 5878, l => 5879, },
	# [5739] opcode : set "[inline_const]" 5 "," "("
	{ hl => 5740, ix => 5742, iy => 5774, },
	# [5740] opcode : set "[inline_const]" 5 "," "(" hl
	{ ")" => 5741, },
	# [5741] opcode : set "[inline_const]" 5 "," "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_1545 ], ":" => [ 7, \&_action_opcode_1545 ], },
	# [5742] opcode : set "[inline_const]" 5 "," "(" ix
	{ ")" => 5743, "+" => 5752, "-" => 5763, },
	# [5743] opcode : set "[inline_const]" 5 "," "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_1546 ], "," => 5744, ":" => [ 7, \&_action_opcode_1546 ], },
	# [5744] opcode : set "[inline_const]" 5 "," "(" ix ")" ","
	{ a => 5745, b => 5746, c => 5747, d => 5748, e => 5749, h => 5750, l => 5751, },
	# [5745] opcode : set "[inline_const]" 5 "," "(" ix ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1547 ], ":" => [ 7, \&_action_opcode_1547 ], },
	# [5746] opcode : set "[inline_const]" 5 "," "(" ix ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1548 ], ":" => [ 7, \&_action_opcode_1548 ], },
	# [5747] opcode : set "[inline_const]" 5 "," "(" ix ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1549 ], ":" => [ 7, \&_action_opcode_1549 ], },
	# [5748] opcode : set "[inline_const]" 5 "," "(" ix ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1550 ], ":" => [ 7, \&_action_opcode_1550 ], },
	# [5749] opcode : set "[inline_const]" 5 "," "(" ix ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1551 ], ":" => [ 7, \&_action_opcode_1551 ], },
	# [5750] opcode : set "[inline_const]" 5 "," "(" ix ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1552 ], ":" => [ 7, \&_action_opcode_1552 ], },
	# [5751] opcode : set "[inline_const]" 5 "," "(" ix ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1553 ], ":" => [ 7, \&_action_opcode_1553 ], },
	# [5752] opcode : set "[inline_const]" 5 "," "(" ix "+"
	{ "!" => [ 12, 5753 ], "+" => [ 12, 5753 ], "-" => [ 12, 5753 ], __else__ => [ 12, 5753 ], "~" => [ 12, 5753 ], },
	# [5753] opcode : set "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]"
	{ ")" => 5754, },
	# [5754] opcode : set "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1554 ], "," => 5755, ":" => [ 7, \&_action_opcode_1554 ], },
	# [5755] opcode : set "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" ","
	{ a => 5756, b => 5757, c => 5758, d => 5759, e => 5760, h => 5761, l => 5762, },
	# [5756] opcode : set "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1555 ], ":" => [ 7, \&_action_opcode_1555 ], },
	# [5757] opcode : set "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1556 ], ":" => [ 7, \&_action_opcode_1556 ], },
	# [5758] opcode : set "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1557 ], ":" => [ 7, \&_action_opcode_1557 ], },
	# [5759] opcode : set "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1558 ], ":" => [ 7, \&_action_opcode_1558 ], },
	# [5760] opcode : set "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1559 ], ":" => [ 7, \&_action_opcode_1559 ], },
	# [5761] opcode : set "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1560 ], ":" => [ 7, \&_action_opcode_1560 ], },
	# [5762] opcode : set "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1561 ], ":" => [ 7, \&_action_opcode_1561 ], },
	# [5763] opcode : set "[inline_const]" 5 "," "(" ix "-"
	{ "!" => [ 14, 5764 ], "+" => [ 14, 5764 ], "-" => [ 14, 5764 ], __else__ => [ 14, 5764 ], "~" => [ 14, 5764 ], },
	# [5764] opcode : set "[inline_const]" 5 "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 5765, },
	# [5765] opcode : set "[inline_const]" 5 "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1554 ], "," => 5766, ":" => [ 7, \&_action_opcode_1554 ], },
	# [5766] opcode : set "[inline_const]" 5 "," "(" ix "-" "[expr_NDIS]" ")" ","
	{ a => 5767, b => 5768, c => 5769, d => 5770, e => 5771, h => 5772, l => 5773, },
	# [5767] opcode : set "[inline_const]" 5 "," "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1555 ], ":" => [ 7, \&_action_opcode_1555 ], },
	# [5768] opcode : set "[inline_const]" 5 "," "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1556 ], ":" => [ 7, \&_action_opcode_1556 ], },
	# [5769] opcode : set "[inline_const]" 5 "," "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1557 ], ":" => [ 7, \&_action_opcode_1557 ], },
	# [5770] opcode : set "[inline_const]" 5 "," "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1558 ], ":" => [ 7, \&_action_opcode_1558 ], },
	# [5771] opcode : set "[inline_const]" 5 "," "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1559 ], ":" => [ 7, \&_action_opcode_1559 ], },
	# [5772] opcode : set "[inline_const]" 5 "," "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1560 ], ":" => [ 7, \&_action_opcode_1560 ], },
	# [5773] opcode : set "[inline_const]" 5 "," "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1561 ], ":" => [ 7, \&_action_opcode_1561 ], },
	# [5774] opcode : set "[inline_const]" 5 "," "(" iy
	{ ")" => 5775, "+" => 5784, "-" => 5795, },
	# [5775] opcode : set "[inline_const]" 5 "," "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_1562 ], "," => 5776, ":" => [ 7, \&_action_opcode_1562 ], },
	# [5776] opcode : set "[inline_const]" 5 "," "(" iy ")" ","
	{ a => 5777, b => 5778, c => 5779, d => 5780, e => 5781, h => 5782, l => 5783, },
	# [5777] opcode : set "[inline_const]" 5 "," "(" iy ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1563 ], ":" => [ 7, \&_action_opcode_1563 ], },
	# [5778] opcode : set "[inline_const]" 5 "," "(" iy ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1564 ], ":" => [ 7, \&_action_opcode_1564 ], },
	# [5779] opcode : set "[inline_const]" 5 "," "(" iy ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1565 ], ":" => [ 7, \&_action_opcode_1565 ], },
	# [5780] opcode : set "[inline_const]" 5 "," "(" iy ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1566 ], ":" => [ 7, \&_action_opcode_1566 ], },
	# [5781] opcode : set "[inline_const]" 5 "," "(" iy ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1567 ], ":" => [ 7, \&_action_opcode_1567 ], },
	# [5782] opcode : set "[inline_const]" 5 "," "(" iy ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1568 ], ":" => [ 7, \&_action_opcode_1568 ], },
	# [5783] opcode : set "[inline_const]" 5 "," "(" iy ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1569 ], ":" => [ 7, \&_action_opcode_1569 ], },
	# [5784] opcode : set "[inline_const]" 5 "," "(" iy "+"
	{ "!" => [ 12, 5785 ], "+" => [ 12, 5785 ], "-" => [ 12, 5785 ], __else__ => [ 12, 5785 ], "~" => [ 12, 5785 ], },
	# [5785] opcode : set "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]"
	{ ")" => 5786, },
	# [5786] opcode : set "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1570 ], "," => 5787, ":" => [ 7, \&_action_opcode_1570 ], },
	# [5787] opcode : set "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" ","
	{ a => 5788, b => 5789, c => 5790, d => 5791, e => 5792, h => 5793, l => 5794, },
	# [5788] opcode : set "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1571 ], ":" => [ 7, \&_action_opcode_1571 ], },
	# [5789] opcode : set "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1572 ], ":" => [ 7, \&_action_opcode_1572 ], },
	# [5790] opcode : set "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1573 ], ":" => [ 7, \&_action_opcode_1573 ], },
	# [5791] opcode : set "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1574 ], ":" => [ 7, \&_action_opcode_1574 ], },
	# [5792] opcode : set "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1575 ], ":" => [ 7, \&_action_opcode_1575 ], },
	# [5793] opcode : set "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1576 ], ":" => [ 7, \&_action_opcode_1576 ], },
	# [5794] opcode : set "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1577 ], ":" => [ 7, \&_action_opcode_1577 ], },
	# [5795] opcode : set "[inline_const]" 5 "," "(" iy "-"
	{ "!" => [ 14, 5796 ], "+" => [ 14, 5796 ], "-" => [ 14, 5796 ], __else__ => [ 14, 5796 ], "~" => [ 14, 5796 ], },
	# [5796] opcode : set "[inline_const]" 5 "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 5797, },
	# [5797] opcode : set "[inline_const]" 5 "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1570 ], "," => 5798, ":" => [ 7, \&_action_opcode_1570 ], },
	# [5798] opcode : set "[inline_const]" 5 "," "(" iy "-" "[expr_NDIS]" ")" ","
	{ a => 5799, b => 5800, c => 5801, d => 5802, e => 5803, h => 5804, l => 5805, },
	# [5799] opcode : set "[inline_const]" 5 "," "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1571 ], ":" => [ 7, \&_action_opcode_1571 ], },
	# [5800] opcode : set "[inline_const]" 5 "," "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1572 ], ":" => [ 7, \&_action_opcode_1572 ], },
	# [5801] opcode : set "[inline_const]" 5 "," "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1573 ], ":" => [ 7, \&_action_opcode_1573 ], },
	# [5802] opcode : set "[inline_const]" 5 "," "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1574 ], ":" => [ 7, \&_action_opcode_1574 ], },
	# [5803] opcode : set "[inline_const]" 5 "," "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1575 ], ":" => [ 7, \&_action_opcode_1575 ], },
	# [5804] opcode : set "[inline_const]" 5 "," "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1576 ], ":" => [ 7, \&_action_opcode_1576 ], },
	# [5805] opcode : set "[inline_const]" 5 "," "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1577 ], ":" => [ 7, \&_action_opcode_1577 ], },
	# [5806] opcode : set "[inline_const]" 5 "," "["
	{ hl => 5807, ix => 5809, iy => 5841, },
	# [5807] opcode : set "[inline_const]" 5 "," "[" hl
	{ "]" => 5808, },
	# [5808] opcode : set "[inline_const]" 5 "," "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_1545 ], ":" => [ 7, \&_action_opcode_1545 ], },
	# [5809] opcode : set "[inline_const]" 5 "," "[" ix
	{ "+" => 5810, "-" => 5821, "]" => 5832, },
	# [5810] opcode : set "[inline_const]" 5 "," "[" ix "+"
	{ "!" => [ 12, 5811 ], "+" => [ 12, 5811 ], "-" => [ 12, 5811 ], __else__ => [ 12, 5811 ], "~" => [ 12, 5811 ], },
	# [5811] opcode : set "[inline_const]" 5 "," "[" ix "+" "[expr_DIS]"
	{ "]" => 5812, },
	# [5812] opcode : set "[inline_const]" 5 "," "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1554 ], "," => 5813, ":" => [ 7, \&_action_opcode_1554 ], },
	# [5813] opcode : set "[inline_const]" 5 "," "[" ix "+" "[expr_DIS]" "]" ","
	{ a => 5814, b => 5815, c => 5816, d => 5817, e => 5818, h => 5819, l => 5820, },
	# [5814] opcode : set "[inline_const]" 5 "," "[" ix "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1555 ], ":" => [ 7, \&_action_opcode_1555 ], },
	# [5815] opcode : set "[inline_const]" 5 "," "[" ix "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1556 ], ":" => [ 7, \&_action_opcode_1556 ], },
	# [5816] opcode : set "[inline_const]" 5 "," "[" ix "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1557 ], ":" => [ 7, \&_action_opcode_1557 ], },
	# [5817] opcode : set "[inline_const]" 5 "," "[" ix "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1558 ], ":" => [ 7, \&_action_opcode_1558 ], },
	# [5818] opcode : set "[inline_const]" 5 "," "[" ix "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1559 ], ":" => [ 7, \&_action_opcode_1559 ], },
	# [5819] opcode : set "[inline_const]" 5 "," "[" ix "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1560 ], ":" => [ 7, \&_action_opcode_1560 ], },
	# [5820] opcode : set "[inline_const]" 5 "," "[" ix "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1561 ], ":" => [ 7, \&_action_opcode_1561 ], },
	# [5821] opcode : set "[inline_const]" 5 "," "[" ix "-"
	{ "!" => [ 14, 5822 ], "+" => [ 14, 5822 ], "-" => [ 14, 5822 ], __else__ => [ 14, 5822 ], "~" => [ 14, 5822 ], },
	# [5822] opcode : set "[inline_const]" 5 "," "[" ix "-" "[expr_NDIS]"
	{ "]" => 5823, },
	# [5823] opcode : set "[inline_const]" 5 "," "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1554 ], "," => 5824, ":" => [ 7, \&_action_opcode_1554 ], },
	# [5824] opcode : set "[inline_const]" 5 "," "[" ix "-" "[expr_NDIS]" "]" ","
	{ a => 5825, b => 5826, c => 5827, d => 5828, e => 5829, h => 5830, l => 5831, },
	# [5825] opcode : set "[inline_const]" 5 "," "[" ix "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1555 ], ":" => [ 7, \&_action_opcode_1555 ], },
	# [5826] opcode : set "[inline_const]" 5 "," "[" ix "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1556 ], ":" => [ 7, \&_action_opcode_1556 ], },
	# [5827] opcode : set "[inline_const]" 5 "," "[" ix "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1557 ], ":" => [ 7, \&_action_opcode_1557 ], },
	# [5828] opcode : set "[inline_const]" 5 "," "[" ix "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1558 ], ":" => [ 7, \&_action_opcode_1558 ], },
	# [5829] opcode : set "[inline_const]" 5 "," "[" ix "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1559 ], ":" => [ 7, \&_action_opcode_1559 ], },
	# [5830] opcode : set "[inline_const]" 5 "," "[" ix "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1560 ], ":" => [ 7, \&_action_opcode_1560 ], },
	# [5831] opcode : set "[inline_const]" 5 "," "[" ix "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1561 ], ":" => [ 7, \&_action_opcode_1561 ], },
	# [5832] opcode : set "[inline_const]" 5 "," "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_1546 ], "," => 5833, ":" => [ 7, \&_action_opcode_1546 ], },
	# [5833] opcode : set "[inline_const]" 5 "," "[" ix "]" ","
	{ a => 5834, b => 5835, c => 5836, d => 5837, e => 5838, h => 5839, l => 5840, },
	# [5834] opcode : set "[inline_const]" 5 "," "[" ix "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1547 ], ":" => [ 7, \&_action_opcode_1547 ], },
	# [5835] opcode : set "[inline_const]" 5 "," "[" ix "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1548 ], ":" => [ 7, \&_action_opcode_1548 ], },
	# [5836] opcode : set "[inline_const]" 5 "," "[" ix "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1549 ], ":" => [ 7, \&_action_opcode_1549 ], },
	# [5837] opcode : set "[inline_const]" 5 "," "[" ix "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1550 ], ":" => [ 7, \&_action_opcode_1550 ], },
	# [5838] opcode : set "[inline_const]" 5 "," "[" ix "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1551 ], ":" => [ 7, \&_action_opcode_1551 ], },
	# [5839] opcode : set "[inline_const]" 5 "," "[" ix "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1552 ], ":" => [ 7, \&_action_opcode_1552 ], },
	# [5840] opcode : set "[inline_const]" 5 "," "[" ix "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1553 ], ":" => [ 7, \&_action_opcode_1553 ], },
	# [5841] opcode : set "[inline_const]" 5 "," "[" iy
	{ "+" => 5842, "-" => 5853, "]" => 5864, },
	# [5842] opcode : set "[inline_const]" 5 "," "[" iy "+"
	{ "!" => [ 12, 5843 ], "+" => [ 12, 5843 ], "-" => [ 12, 5843 ], __else__ => [ 12, 5843 ], "~" => [ 12, 5843 ], },
	# [5843] opcode : set "[inline_const]" 5 "," "[" iy "+" "[expr_DIS]"
	{ "]" => 5844, },
	# [5844] opcode : set "[inline_const]" 5 "," "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1570 ], "," => 5845, ":" => [ 7, \&_action_opcode_1570 ], },
	# [5845] opcode : set "[inline_const]" 5 "," "[" iy "+" "[expr_DIS]" "]" ","
	{ a => 5846, b => 5847, c => 5848, d => 5849, e => 5850, h => 5851, l => 5852, },
	# [5846] opcode : set "[inline_const]" 5 "," "[" iy "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1571 ], ":" => [ 7, \&_action_opcode_1571 ], },
	# [5847] opcode : set "[inline_const]" 5 "," "[" iy "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1572 ], ":" => [ 7, \&_action_opcode_1572 ], },
	# [5848] opcode : set "[inline_const]" 5 "," "[" iy "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1573 ], ":" => [ 7, \&_action_opcode_1573 ], },
	# [5849] opcode : set "[inline_const]" 5 "," "[" iy "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1574 ], ":" => [ 7, \&_action_opcode_1574 ], },
	# [5850] opcode : set "[inline_const]" 5 "," "[" iy "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1575 ], ":" => [ 7, \&_action_opcode_1575 ], },
	# [5851] opcode : set "[inline_const]" 5 "," "[" iy "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1576 ], ":" => [ 7, \&_action_opcode_1576 ], },
	# [5852] opcode : set "[inline_const]" 5 "," "[" iy "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1577 ], ":" => [ 7, \&_action_opcode_1577 ], },
	# [5853] opcode : set "[inline_const]" 5 "," "[" iy "-"
	{ "!" => [ 14, 5854 ], "+" => [ 14, 5854 ], "-" => [ 14, 5854 ], __else__ => [ 14, 5854 ], "~" => [ 14, 5854 ], },
	# [5854] opcode : set "[inline_const]" 5 "," "[" iy "-" "[expr_NDIS]"
	{ "]" => 5855, },
	# [5855] opcode : set "[inline_const]" 5 "," "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1570 ], "," => 5856, ":" => [ 7, \&_action_opcode_1570 ], },
	# [5856] opcode : set "[inline_const]" 5 "," "[" iy "-" "[expr_NDIS]" "]" ","
	{ a => 5857, b => 5858, c => 5859, d => 5860, e => 5861, h => 5862, l => 5863, },
	# [5857] opcode : set "[inline_const]" 5 "," "[" iy "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1571 ], ":" => [ 7, \&_action_opcode_1571 ], },
	# [5858] opcode : set "[inline_const]" 5 "," "[" iy "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1572 ], ":" => [ 7, \&_action_opcode_1572 ], },
	# [5859] opcode : set "[inline_const]" 5 "," "[" iy "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1573 ], ":" => [ 7, \&_action_opcode_1573 ], },
	# [5860] opcode : set "[inline_const]" 5 "," "[" iy "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1574 ], ":" => [ 7, \&_action_opcode_1574 ], },
	# [5861] opcode : set "[inline_const]" 5 "," "[" iy "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1575 ], ":" => [ 7, \&_action_opcode_1575 ], },
	# [5862] opcode : set "[inline_const]" 5 "," "[" iy "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1576 ], ":" => [ 7, \&_action_opcode_1576 ], },
	# [5863] opcode : set "[inline_const]" 5 "," "[" iy "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1577 ], ":" => [ 7, \&_action_opcode_1577 ], },
	# [5864] opcode : set "[inline_const]" 5 "," "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_1562 ], "," => 5865, ":" => [ 7, \&_action_opcode_1562 ], },
	# [5865] opcode : set "[inline_const]" 5 "," "[" iy "]" ","
	{ a => 5866, b => 5867, c => 5868, d => 5869, e => 5870, h => 5871, l => 5872, },
	# [5866] opcode : set "[inline_const]" 5 "," "[" iy "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1563 ], ":" => [ 7, \&_action_opcode_1563 ], },
	# [5867] opcode : set "[inline_const]" 5 "," "[" iy "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1564 ], ":" => [ 7, \&_action_opcode_1564 ], },
	# [5868] opcode : set "[inline_const]" 5 "," "[" iy "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1565 ], ":" => [ 7, \&_action_opcode_1565 ], },
	# [5869] opcode : set "[inline_const]" 5 "," "[" iy "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1566 ], ":" => [ 7, \&_action_opcode_1566 ], },
	# [5870] opcode : set "[inline_const]" 5 "," "[" iy "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1567 ], ":" => [ 7, \&_action_opcode_1567 ], },
	# [5871] opcode : set "[inline_const]" 5 "," "[" iy "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1568 ], ":" => [ 7, \&_action_opcode_1568 ], },
	# [5872] opcode : set "[inline_const]" 5 "," "[" iy "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1569 ], ":" => [ 7, \&_action_opcode_1569 ], },
	# [5873] opcode : set "[inline_const]" 5 "," a
	{ "\n" => [ 7, \&_action_opcode_1578 ], ":" => [ 7, \&_action_opcode_1578 ], },
	# [5874] opcode : set "[inline_const]" 5 "," b
	{ "\n" => [ 7, \&_action_opcode_1579 ], ":" => [ 7, \&_action_opcode_1579 ], },
	# [5875] opcode : set "[inline_const]" 5 "," c
	{ "\n" => [ 7, \&_action_opcode_1580 ], ":" => [ 7, \&_action_opcode_1580 ], },
	# [5876] opcode : set "[inline_const]" 5 "," d
	{ "\n" => [ 7, \&_action_opcode_1581 ], ":" => [ 7, \&_action_opcode_1581 ], },
	# [5877] opcode : set "[inline_const]" 5 "," e
	{ "\n" => [ 7, \&_action_opcode_1582 ], ":" => [ 7, \&_action_opcode_1582 ], },
	# [5878] opcode : set "[inline_const]" 5 "," h
	{ "\n" => [ 7, \&_action_opcode_1583 ], ":" => [ 7, \&_action_opcode_1583 ], },
	# [5879] opcode : set "[inline_const]" 5 "," l
	{ "\n" => [ 7, \&_action_opcode_1584 ], ":" => [ 7, \&_action_opcode_1584 ], },
	# [5880] opcode : set "[inline_const]" 6
	{ "," => 5881, },
	# [5881] opcode : set "[inline_const]" 6 ","
	{ "(" => 5882, "[" => 5949, a => 6016, b => 6017, c => 6018, d => 6019, e => 6020, h => 6021, l => 6022, },
	# [5882] opcode : set "[inline_const]" 6 "," "("
	{ hl => 5883, ix => 5885, iy => 5917, },
	# [5883] opcode : set "[inline_const]" 6 "," "(" hl
	{ ")" => 5884, },
	# [5884] opcode : set "[inline_const]" 6 "," "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_1585 ], ":" => [ 7, \&_action_opcode_1585 ], },
	# [5885] opcode : set "[inline_const]" 6 "," "(" ix
	{ ")" => 5886, "+" => 5895, "-" => 5906, },
	# [5886] opcode : set "[inline_const]" 6 "," "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_1586 ], "," => 5887, ":" => [ 7, \&_action_opcode_1586 ], },
	# [5887] opcode : set "[inline_const]" 6 "," "(" ix ")" ","
	{ a => 5888, b => 5889, c => 5890, d => 5891, e => 5892, h => 5893, l => 5894, },
	# [5888] opcode : set "[inline_const]" 6 "," "(" ix ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1587 ], ":" => [ 7, \&_action_opcode_1587 ], },
	# [5889] opcode : set "[inline_const]" 6 "," "(" ix ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1588 ], ":" => [ 7, \&_action_opcode_1588 ], },
	# [5890] opcode : set "[inline_const]" 6 "," "(" ix ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1589 ], ":" => [ 7, \&_action_opcode_1589 ], },
	# [5891] opcode : set "[inline_const]" 6 "," "(" ix ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1590 ], ":" => [ 7, \&_action_opcode_1590 ], },
	# [5892] opcode : set "[inline_const]" 6 "," "(" ix ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1591 ], ":" => [ 7, \&_action_opcode_1591 ], },
	# [5893] opcode : set "[inline_const]" 6 "," "(" ix ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1592 ], ":" => [ 7, \&_action_opcode_1592 ], },
	# [5894] opcode : set "[inline_const]" 6 "," "(" ix ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1593 ], ":" => [ 7, \&_action_opcode_1593 ], },
	# [5895] opcode : set "[inline_const]" 6 "," "(" ix "+"
	{ "!" => [ 12, 5896 ], "+" => [ 12, 5896 ], "-" => [ 12, 5896 ], __else__ => [ 12, 5896 ], "~" => [ 12, 5896 ], },
	# [5896] opcode : set "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]"
	{ ")" => 5897, },
	# [5897] opcode : set "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1594 ], "," => 5898, ":" => [ 7, \&_action_opcode_1594 ], },
	# [5898] opcode : set "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" ","
	{ a => 5899, b => 5900, c => 5901, d => 5902, e => 5903, h => 5904, l => 5905, },
	# [5899] opcode : set "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1595 ], ":" => [ 7, \&_action_opcode_1595 ], },
	# [5900] opcode : set "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1596 ], ":" => [ 7, \&_action_opcode_1596 ], },
	# [5901] opcode : set "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1597 ], ":" => [ 7, \&_action_opcode_1597 ], },
	# [5902] opcode : set "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1598 ], ":" => [ 7, \&_action_opcode_1598 ], },
	# [5903] opcode : set "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1599 ], ":" => [ 7, \&_action_opcode_1599 ], },
	# [5904] opcode : set "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1600 ], ":" => [ 7, \&_action_opcode_1600 ], },
	# [5905] opcode : set "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1601 ], ":" => [ 7, \&_action_opcode_1601 ], },
	# [5906] opcode : set "[inline_const]" 6 "," "(" ix "-"
	{ "!" => [ 14, 5907 ], "+" => [ 14, 5907 ], "-" => [ 14, 5907 ], __else__ => [ 14, 5907 ], "~" => [ 14, 5907 ], },
	# [5907] opcode : set "[inline_const]" 6 "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 5908, },
	# [5908] opcode : set "[inline_const]" 6 "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1594 ], "," => 5909, ":" => [ 7, \&_action_opcode_1594 ], },
	# [5909] opcode : set "[inline_const]" 6 "," "(" ix "-" "[expr_NDIS]" ")" ","
	{ a => 5910, b => 5911, c => 5912, d => 5913, e => 5914, h => 5915, l => 5916, },
	# [5910] opcode : set "[inline_const]" 6 "," "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1595 ], ":" => [ 7, \&_action_opcode_1595 ], },
	# [5911] opcode : set "[inline_const]" 6 "," "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1596 ], ":" => [ 7, \&_action_opcode_1596 ], },
	# [5912] opcode : set "[inline_const]" 6 "," "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1597 ], ":" => [ 7, \&_action_opcode_1597 ], },
	# [5913] opcode : set "[inline_const]" 6 "," "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1598 ], ":" => [ 7, \&_action_opcode_1598 ], },
	# [5914] opcode : set "[inline_const]" 6 "," "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1599 ], ":" => [ 7, \&_action_opcode_1599 ], },
	# [5915] opcode : set "[inline_const]" 6 "," "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1600 ], ":" => [ 7, \&_action_opcode_1600 ], },
	# [5916] opcode : set "[inline_const]" 6 "," "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1601 ], ":" => [ 7, \&_action_opcode_1601 ], },
	# [5917] opcode : set "[inline_const]" 6 "," "(" iy
	{ ")" => 5918, "+" => 5927, "-" => 5938, },
	# [5918] opcode : set "[inline_const]" 6 "," "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_1602 ], "," => 5919, ":" => [ 7, \&_action_opcode_1602 ], },
	# [5919] opcode : set "[inline_const]" 6 "," "(" iy ")" ","
	{ a => 5920, b => 5921, c => 5922, d => 5923, e => 5924, h => 5925, l => 5926, },
	# [5920] opcode : set "[inline_const]" 6 "," "(" iy ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1603 ], ":" => [ 7, \&_action_opcode_1603 ], },
	# [5921] opcode : set "[inline_const]" 6 "," "(" iy ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1604 ], ":" => [ 7, \&_action_opcode_1604 ], },
	# [5922] opcode : set "[inline_const]" 6 "," "(" iy ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1605 ], ":" => [ 7, \&_action_opcode_1605 ], },
	# [5923] opcode : set "[inline_const]" 6 "," "(" iy ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1606 ], ":" => [ 7, \&_action_opcode_1606 ], },
	# [5924] opcode : set "[inline_const]" 6 "," "(" iy ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1607 ], ":" => [ 7, \&_action_opcode_1607 ], },
	# [5925] opcode : set "[inline_const]" 6 "," "(" iy ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1608 ], ":" => [ 7, \&_action_opcode_1608 ], },
	# [5926] opcode : set "[inline_const]" 6 "," "(" iy ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1609 ], ":" => [ 7, \&_action_opcode_1609 ], },
	# [5927] opcode : set "[inline_const]" 6 "," "(" iy "+"
	{ "!" => [ 12, 5928 ], "+" => [ 12, 5928 ], "-" => [ 12, 5928 ], __else__ => [ 12, 5928 ], "~" => [ 12, 5928 ], },
	# [5928] opcode : set "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]"
	{ ")" => 5929, },
	# [5929] opcode : set "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1610 ], "," => 5930, ":" => [ 7, \&_action_opcode_1610 ], },
	# [5930] opcode : set "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" ","
	{ a => 5931, b => 5932, c => 5933, d => 5934, e => 5935, h => 5936, l => 5937, },
	# [5931] opcode : set "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1611 ], ":" => [ 7, \&_action_opcode_1611 ], },
	# [5932] opcode : set "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1612 ], ":" => [ 7, \&_action_opcode_1612 ], },
	# [5933] opcode : set "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1613 ], ":" => [ 7, \&_action_opcode_1613 ], },
	# [5934] opcode : set "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1614 ], ":" => [ 7, \&_action_opcode_1614 ], },
	# [5935] opcode : set "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1615 ], ":" => [ 7, \&_action_opcode_1615 ], },
	# [5936] opcode : set "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1616 ], ":" => [ 7, \&_action_opcode_1616 ], },
	# [5937] opcode : set "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1617 ], ":" => [ 7, \&_action_opcode_1617 ], },
	# [5938] opcode : set "[inline_const]" 6 "," "(" iy "-"
	{ "!" => [ 14, 5939 ], "+" => [ 14, 5939 ], "-" => [ 14, 5939 ], __else__ => [ 14, 5939 ], "~" => [ 14, 5939 ], },
	# [5939] opcode : set "[inline_const]" 6 "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 5940, },
	# [5940] opcode : set "[inline_const]" 6 "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1610 ], "," => 5941, ":" => [ 7, \&_action_opcode_1610 ], },
	# [5941] opcode : set "[inline_const]" 6 "," "(" iy "-" "[expr_NDIS]" ")" ","
	{ a => 5942, b => 5943, c => 5944, d => 5945, e => 5946, h => 5947, l => 5948, },
	# [5942] opcode : set "[inline_const]" 6 "," "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1611 ], ":" => [ 7, \&_action_opcode_1611 ], },
	# [5943] opcode : set "[inline_const]" 6 "," "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1612 ], ":" => [ 7, \&_action_opcode_1612 ], },
	# [5944] opcode : set "[inline_const]" 6 "," "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1613 ], ":" => [ 7, \&_action_opcode_1613 ], },
	# [5945] opcode : set "[inline_const]" 6 "," "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1614 ], ":" => [ 7, \&_action_opcode_1614 ], },
	# [5946] opcode : set "[inline_const]" 6 "," "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1615 ], ":" => [ 7, \&_action_opcode_1615 ], },
	# [5947] opcode : set "[inline_const]" 6 "," "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1616 ], ":" => [ 7, \&_action_opcode_1616 ], },
	# [5948] opcode : set "[inline_const]" 6 "," "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1617 ], ":" => [ 7, \&_action_opcode_1617 ], },
	# [5949] opcode : set "[inline_const]" 6 "," "["
	{ hl => 5950, ix => 5952, iy => 5984, },
	# [5950] opcode : set "[inline_const]" 6 "," "[" hl
	{ "]" => 5951, },
	# [5951] opcode : set "[inline_const]" 6 "," "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_1585 ], ":" => [ 7, \&_action_opcode_1585 ], },
	# [5952] opcode : set "[inline_const]" 6 "," "[" ix
	{ "+" => 5953, "-" => 5964, "]" => 5975, },
	# [5953] opcode : set "[inline_const]" 6 "," "[" ix "+"
	{ "!" => [ 12, 5954 ], "+" => [ 12, 5954 ], "-" => [ 12, 5954 ], __else__ => [ 12, 5954 ], "~" => [ 12, 5954 ], },
	# [5954] opcode : set "[inline_const]" 6 "," "[" ix "+" "[expr_DIS]"
	{ "]" => 5955, },
	# [5955] opcode : set "[inline_const]" 6 "," "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1594 ], "," => 5956, ":" => [ 7, \&_action_opcode_1594 ], },
	# [5956] opcode : set "[inline_const]" 6 "," "[" ix "+" "[expr_DIS]" "]" ","
	{ a => 5957, b => 5958, c => 5959, d => 5960, e => 5961, h => 5962, l => 5963, },
	# [5957] opcode : set "[inline_const]" 6 "," "[" ix "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1595 ], ":" => [ 7, \&_action_opcode_1595 ], },
	# [5958] opcode : set "[inline_const]" 6 "," "[" ix "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1596 ], ":" => [ 7, \&_action_opcode_1596 ], },
	# [5959] opcode : set "[inline_const]" 6 "," "[" ix "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1597 ], ":" => [ 7, \&_action_opcode_1597 ], },
	# [5960] opcode : set "[inline_const]" 6 "," "[" ix "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1598 ], ":" => [ 7, \&_action_opcode_1598 ], },
	# [5961] opcode : set "[inline_const]" 6 "," "[" ix "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1599 ], ":" => [ 7, \&_action_opcode_1599 ], },
	# [5962] opcode : set "[inline_const]" 6 "," "[" ix "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1600 ], ":" => [ 7, \&_action_opcode_1600 ], },
	# [5963] opcode : set "[inline_const]" 6 "," "[" ix "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1601 ], ":" => [ 7, \&_action_opcode_1601 ], },
	# [5964] opcode : set "[inline_const]" 6 "," "[" ix "-"
	{ "!" => [ 14, 5965 ], "+" => [ 14, 5965 ], "-" => [ 14, 5965 ], __else__ => [ 14, 5965 ], "~" => [ 14, 5965 ], },
	# [5965] opcode : set "[inline_const]" 6 "," "[" ix "-" "[expr_NDIS]"
	{ "]" => 5966, },
	# [5966] opcode : set "[inline_const]" 6 "," "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1594 ], "," => 5967, ":" => [ 7, \&_action_opcode_1594 ], },
	# [5967] opcode : set "[inline_const]" 6 "," "[" ix "-" "[expr_NDIS]" "]" ","
	{ a => 5968, b => 5969, c => 5970, d => 5971, e => 5972, h => 5973, l => 5974, },
	# [5968] opcode : set "[inline_const]" 6 "," "[" ix "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1595 ], ":" => [ 7, \&_action_opcode_1595 ], },
	# [5969] opcode : set "[inline_const]" 6 "," "[" ix "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1596 ], ":" => [ 7, \&_action_opcode_1596 ], },
	# [5970] opcode : set "[inline_const]" 6 "," "[" ix "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1597 ], ":" => [ 7, \&_action_opcode_1597 ], },
	# [5971] opcode : set "[inline_const]" 6 "," "[" ix "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1598 ], ":" => [ 7, \&_action_opcode_1598 ], },
	# [5972] opcode : set "[inline_const]" 6 "," "[" ix "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1599 ], ":" => [ 7, \&_action_opcode_1599 ], },
	# [5973] opcode : set "[inline_const]" 6 "," "[" ix "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1600 ], ":" => [ 7, \&_action_opcode_1600 ], },
	# [5974] opcode : set "[inline_const]" 6 "," "[" ix "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1601 ], ":" => [ 7, \&_action_opcode_1601 ], },
	# [5975] opcode : set "[inline_const]" 6 "," "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_1586 ], "," => 5976, ":" => [ 7, \&_action_opcode_1586 ], },
	# [5976] opcode : set "[inline_const]" 6 "," "[" ix "]" ","
	{ a => 5977, b => 5978, c => 5979, d => 5980, e => 5981, h => 5982, l => 5983, },
	# [5977] opcode : set "[inline_const]" 6 "," "[" ix "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1587 ], ":" => [ 7, \&_action_opcode_1587 ], },
	# [5978] opcode : set "[inline_const]" 6 "," "[" ix "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1588 ], ":" => [ 7, \&_action_opcode_1588 ], },
	# [5979] opcode : set "[inline_const]" 6 "," "[" ix "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1589 ], ":" => [ 7, \&_action_opcode_1589 ], },
	# [5980] opcode : set "[inline_const]" 6 "," "[" ix "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1590 ], ":" => [ 7, \&_action_opcode_1590 ], },
	# [5981] opcode : set "[inline_const]" 6 "," "[" ix "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1591 ], ":" => [ 7, \&_action_opcode_1591 ], },
	# [5982] opcode : set "[inline_const]" 6 "," "[" ix "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1592 ], ":" => [ 7, \&_action_opcode_1592 ], },
	# [5983] opcode : set "[inline_const]" 6 "," "[" ix "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1593 ], ":" => [ 7, \&_action_opcode_1593 ], },
	# [5984] opcode : set "[inline_const]" 6 "," "[" iy
	{ "+" => 5985, "-" => 5996, "]" => 6007, },
	# [5985] opcode : set "[inline_const]" 6 "," "[" iy "+"
	{ "!" => [ 12, 5986 ], "+" => [ 12, 5986 ], "-" => [ 12, 5986 ], __else__ => [ 12, 5986 ], "~" => [ 12, 5986 ], },
	# [5986] opcode : set "[inline_const]" 6 "," "[" iy "+" "[expr_DIS]"
	{ "]" => 5987, },
	# [5987] opcode : set "[inline_const]" 6 "," "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1610 ], "," => 5988, ":" => [ 7, \&_action_opcode_1610 ], },
	# [5988] opcode : set "[inline_const]" 6 "," "[" iy "+" "[expr_DIS]" "]" ","
	{ a => 5989, b => 5990, c => 5991, d => 5992, e => 5993, h => 5994, l => 5995, },
	# [5989] opcode : set "[inline_const]" 6 "," "[" iy "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1611 ], ":" => [ 7, \&_action_opcode_1611 ], },
	# [5990] opcode : set "[inline_const]" 6 "," "[" iy "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1612 ], ":" => [ 7, \&_action_opcode_1612 ], },
	# [5991] opcode : set "[inline_const]" 6 "," "[" iy "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1613 ], ":" => [ 7, \&_action_opcode_1613 ], },
	# [5992] opcode : set "[inline_const]" 6 "," "[" iy "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1614 ], ":" => [ 7, \&_action_opcode_1614 ], },
	# [5993] opcode : set "[inline_const]" 6 "," "[" iy "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1615 ], ":" => [ 7, \&_action_opcode_1615 ], },
	# [5994] opcode : set "[inline_const]" 6 "," "[" iy "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1616 ], ":" => [ 7, \&_action_opcode_1616 ], },
	# [5995] opcode : set "[inline_const]" 6 "," "[" iy "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1617 ], ":" => [ 7, \&_action_opcode_1617 ], },
	# [5996] opcode : set "[inline_const]" 6 "," "[" iy "-"
	{ "!" => [ 14, 5997 ], "+" => [ 14, 5997 ], "-" => [ 14, 5997 ], __else__ => [ 14, 5997 ], "~" => [ 14, 5997 ], },
	# [5997] opcode : set "[inline_const]" 6 "," "[" iy "-" "[expr_NDIS]"
	{ "]" => 5998, },
	# [5998] opcode : set "[inline_const]" 6 "," "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1610 ], "," => 5999, ":" => [ 7, \&_action_opcode_1610 ], },
	# [5999] opcode : set "[inline_const]" 6 "," "[" iy "-" "[expr_NDIS]" "]" ","
	{ a => 6000, b => 6001, c => 6002, d => 6003, e => 6004, h => 6005, l => 6006, },
	# [6000] opcode : set "[inline_const]" 6 "," "[" iy "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1611 ], ":" => [ 7, \&_action_opcode_1611 ], },
	# [6001] opcode : set "[inline_const]" 6 "," "[" iy "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1612 ], ":" => [ 7, \&_action_opcode_1612 ], },
	# [6002] opcode : set "[inline_const]" 6 "," "[" iy "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1613 ], ":" => [ 7, \&_action_opcode_1613 ], },
	# [6003] opcode : set "[inline_const]" 6 "," "[" iy "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1614 ], ":" => [ 7, \&_action_opcode_1614 ], },
	# [6004] opcode : set "[inline_const]" 6 "," "[" iy "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1615 ], ":" => [ 7, \&_action_opcode_1615 ], },
	# [6005] opcode : set "[inline_const]" 6 "," "[" iy "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1616 ], ":" => [ 7, \&_action_opcode_1616 ], },
	# [6006] opcode : set "[inline_const]" 6 "," "[" iy "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1617 ], ":" => [ 7, \&_action_opcode_1617 ], },
	# [6007] opcode : set "[inline_const]" 6 "," "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_1602 ], "," => 6008, ":" => [ 7, \&_action_opcode_1602 ], },
	# [6008] opcode : set "[inline_const]" 6 "," "[" iy "]" ","
	{ a => 6009, b => 6010, c => 6011, d => 6012, e => 6013, h => 6014, l => 6015, },
	# [6009] opcode : set "[inline_const]" 6 "," "[" iy "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1603 ], ":" => [ 7, \&_action_opcode_1603 ], },
	# [6010] opcode : set "[inline_const]" 6 "," "[" iy "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1604 ], ":" => [ 7, \&_action_opcode_1604 ], },
	# [6011] opcode : set "[inline_const]" 6 "," "[" iy "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1605 ], ":" => [ 7, \&_action_opcode_1605 ], },
	# [6012] opcode : set "[inline_const]" 6 "," "[" iy "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1606 ], ":" => [ 7, \&_action_opcode_1606 ], },
	# [6013] opcode : set "[inline_const]" 6 "," "[" iy "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1607 ], ":" => [ 7, \&_action_opcode_1607 ], },
	# [6014] opcode : set "[inline_const]" 6 "," "[" iy "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1608 ], ":" => [ 7, \&_action_opcode_1608 ], },
	# [6015] opcode : set "[inline_const]" 6 "," "[" iy "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1609 ], ":" => [ 7, \&_action_opcode_1609 ], },
	# [6016] opcode : set "[inline_const]" 6 "," a
	{ "\n" => [ 7, \&_action_opcode_1618 ], ":" => [ 7, \&_action_opcode_1618 ], },
	# [6017] opcode : set "[inline_const]" 6 "," b
	{ "\n" => [ 7, \&_action_opcode_1619 ], ":" => [ 7, \&_action_opcode_1619 ], },
	# [6018] opcode : set "[inline_const]" 6 "," c
	{ "\n" => [ 7, \&_action_opcode_1620 ], ":" => [ 7, \&_action_opcode_1620 ], },
	# [6019] opcode : set "[inline_const]" 6 "," d
	{ "\n" => [ 7, \&_action_opcode_1621 ], ":" => [ 7, \&_action_opcode_1621 ], },
	# [6020] opcode : set "[inline_const]" 6 "," e
	{ "\n" => [ 7, \&_action_opcode_1622 ], ":" => [ 7, \&_action_opcode_1622 ], },
	# [6021] opcode : set "[inline_const]" 6 "," h
	{ "\n" => [ 7, \&_action_opcode_1623 ], ":" => [ 7, \&_action_opcode_1623 ], },
	# [6022] opcode : set "[inline_const]" 6 "," l
	{ "\n" => [ 7, \&_action_opcode_1624 ], ":" => [ 7, \&_action_opcode_1624 ], },
	# [6023] opcode : set "[inline_const]" 7
	{ "," => 6024, },
	# [6024] opcode : set "[inline_const]" 7 ","
	{ "(" => 6025, "[" => 6092, a => 6159, b => 6160, c => 6161, d => 6162, e => 6163, h => 6164, l => 6165, },
	# [6025] opcode : set "[inline_const]" 7 "," "("
	{ hl => 6026, ix => 6028, iy => 6060, },
	# [6026] opcode : set "[inline_const]" 7 "," "(" hl
	{ ")" => 6027, },
	# [6027] opcode : set "[inline_const]" 7 "," "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_1625 ], ":" => [ 7, \&_action_opcode_1625 ], },
	# [6028] opcode : set "[inline_const]" 7 "," "(" ix
	{ ")" => 6029, "+" => 6038, "-" => 6049, },
	# [6029] opcode : set "[inline_const]" 7 "," "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_1626 ], "," => 6030, ":" => [ 7, \&_action_opcode_1626 ], },
	# [6030] opcode : set "[inline_const]" 7 "," "(" ix ")" ","
	{ a => 6031, b => 6032, c => 6033, d => 6034, e => 6035, h => 6036, l => 6037, },
	# [6031] opcode : set "[inline_const]" 7 "," "(" ix ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1627 ], ":" => [ 7, \&_action_opcode_1627 ], },
	# [6032] opcode : set "[inline_const]" 7 "," "(" ix ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1628 ], ":" => [ 7, \&_action_opcode_1628 ], },
	# [6033] opcode : set "[inline_const]" 7 "," "(" ix ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1629 ], ":" => [ 7, \&_action_opcode_1629 ], },
	# [6034] opcode : set "[inline_const]" 7 "," "(" ix ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1630 ], ":" => [ 7, \&_action_opcode_1630 ], },
	# [6035] opcode : set "[inline_const]" 7 "," "(" ix ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1631 ], ":" => [ 7, \&_action_opcode_1631 ], },
	# [6036] opcode : set "[inline_const]" 7 "," "(" ix ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1632 ], ":" => [ 7, \&_action_opcode_1632 ], },
	# [6037] opcode : set "[inline_const]" 7 "," "(" ix ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1633 ], ":" => [ 7, \&_action_opcode_1633 ], },
	# [6038] opcode : set "[inline_const]" 7 "," "(" ix "+"
	{ "!" => [ 12, 6039 ], "+" => [ 12, 6039 ], "-" => [ 12, 6039 ], __else__ => [ 12, 6039 ], "~" => [ 12, 6039 ], },
	# [6039] opcode : set "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]"
	{ ")" => 6040, },
	# [6040] opcode : set "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1634 ], "," => 6041, ":" => [ 7, \&_action_opcode_1634 ], },
	# [6041] opcode : set "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" ","
	{ a => 6042, b => 6043, c => 6044, d => 6045, e => 6046, h => 6047, l => 6048, },
	# [6042] opcode : set "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1635 ], ":" => [ 7, \&_action_opcode_1635 ], },
	# [6043] opcode : set "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1636 ], ":" => [ 7, \&_action_opcode_1636 ], },
	# [6044] opcode : set "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1637 ], ":" => [ 7, \&_action_opcode_1637 ], },
	# [6045] opcode : set "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1638 ], ":" => [ 7, \&_action_opcode_1638 ], },
	# [6046] opcode : set "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1639 ], ":" => [ 7, \&_action_opcode_1639 ], },
	# [6047] opcode : set "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1640 ], ":" => [ 7, \&_action_opcode_1640 ], },
	# [6048] opcode : set "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1641 ], ":" => [ 7, \&_action_opcode_1641 ], },
	# [6049] opcode : set "[inline_const]" 7 "," "(" ix "-"
	{ "!" => [ 14, 6050 ], "+" => [ 14, 6050 ], "-" => [ 14, 6050 ], __else__ => [ 14, 6050 ], "~" => [ 14, 6050 ], },
	# [6050] opcode : set "[inline_const]" 7 "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 6051, },
	# [6051] opcode : set "[inline_const]" 7 "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1634 ], "," => 6052, ":" => [ 7, \&_action_opcode_1634 ], },
	# [6052] opcode : set "[inline_const]" 7 "," "(" ix "-" "[expr_NDIS]" ")" ","
	{ a => 6053, b => 6054, c => 6055, d => 6056, e => 6057, h => 6058, l => 6059, },
	# [6053] opcode : set "[inline_const]" 7 "," "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1635 ], ":" => [ 7, \&_action_opcode_1635 ], },
	# [6054] opcode : set "[inline_const]" 7 "," "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1636 ], ":" => [ 7, \&_action_opcode_1636 ], },
	# [6055] opcode : set "[inline_const]" 7 "," "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1637 ], ":" => [ 7, \&_action_opcode_1637 ], },
	# [6056] opcode : set "[inline_const]" 7 "," "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1638 ], ":" => [ 7, \&_action_opcode_1638 ], },
	# [6057] opcode : set "[inline_const]" 7 "," "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1639 ], ":" => [ 7, \&_action_opcode_1639 ], },
	# [6058] opcode : set "[inline_const]" 7 "," "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1640 ], ":" => [ 7, \&_action_opcode_1640 ], },
	# [6059] opcode : set "[inline_const]" 7 "," "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1641 ], ":" => [ 7, \&_action_opcode_1641 ], },
	# [6060] opcode : set "[inline_const]" 7 "," "(" iy
	{ ")" => 6061, "+" => 6070, "-" => 6081, },
	# [6061] opcode : set "[inline_const]" 7 "," "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_1642 ], "," => 6062, ":" => [ 7, \&_action_opcode_1642 ], },
	# [6062] opcode : set "[inline_const]" 7 "," "(" iy ")" ","
	{ a => 6063, b => 6064, c => 6065, d => 6066, e => 6067, h => 6068, l => 6069, },
	# [6063] opcode : set "[inline_const]" 7 "," "(" iy ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1643 ], ":" => [ 7, \&_action_opcode_1643 ], },
	# [6064] opcode : set "[inline_const]" 7 "," "(" iy ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1644 ], ":" => [ 7, \&_action_opcode_1644 ], },
	# [6065] opcode : set "[inline_const]" 7 "," "(" iy ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1645 ], ":" => [ 7, \&_action_opcode_1645 ], },
	# [6066] opcode : set "[inline_const]" 7 "," "(" iy ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1646 ], ":" => [ 7, \&_action_opcode_1646 ], },
	# [6067] opcode : set "[inline_const]" 7 "," "(" iy ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1647 ], ":" => [ 7, \&_action_opcode_1647 ], },
	# [6068] opcode : set "[inline_const]" 7 "," "(" iy ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1648 ], ":" => [ 7, \&_action_opcode_1648 ], },
	# [6069] opcode : set "[inline_const]" 7 "," "(" iy ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1649 ], ":" => [ 7, \&_action_opcode_1649 ], },
	# [6070] opcode : set "[inline_const]" 7 "," "(" iy "+"
	{ "!" => [ 12, 6071 ], "+" => [ 12, 6071 ], "-" => [ 12, 6071 ], __else__ => [ 12, 6071 ], "~" => [ 12, 6071 ], },
	# [6071] opcode : set "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]"
	{ ")" => 6072, },
	# [6072] opcode : set "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1650 ], "," => 6073, ":" => [ 7, \&_action_opcode_1650 ], },
	# [6073] opcode : set "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" ","
	{ a => 6074, b => 6075, c => 6076, d => 6077, e => 6078, h => 6079, l => 6080, },
	# [6074] opcode : set "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1651 ], ":" => [ 7, \&_action_opcode_1651 ], },
	# [6075] opcode : set "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1652 ], ":" => [ 7, \&_action_opcode_1652 ], },
	# [6076] opcode : set "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1653 ], ":" => [ 7, \&_action_opcode_1653 ], },
	# [6077] opcode : set "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1654 ], ":" => [ 7, \&_action_opcode_1654 ], },
	# [6078] opcode : set "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1655 ], ":" => [ 7, \&_action_opcode_1655 ], },
	# [6079] opcode : set "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1656 ], ":" => [ 7, \&_action_opcode_1656 ], },
	# [6080] opcode : set "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1657 ], ":" => [ 7, \&_action_opcode_1657 ], },
	# [6081] opcode : set "[inline_const]" 7 "," "(" iy "-"
	{ "!" => [ 14, 6082 ], "+" => [ 14, 6082 ], "-" => [ 14, 6082 ], __else__ => [ 14, 6082 ], "~" => [ 14, 6082 ], },
	# [6082] opcode : set "[inline_const]" 7 "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 6083, },
	# [6083] opcode : set "[inline_const]" 7 "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1650 ], "," => 6084, ":" => [ 7, \&_action_opcode_1650 ], },
	# [6084] opcode : set "[inline_const]" 7 "," "(" iy "-" "[expr_NDIS]" ")" ","
	{ a => 6085, b => 6086, c => 6087, d => 6088, e => 6089, h => 6090, l => 6091, },
	# [6085] opcode : set "[inline_const]" 7 "," "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1651 ], ":" => [ 7, \&_action_opcode_1651 ], },
	# [6086] opcode : set "[inline_const]" 7 "," "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1652 ], ":" => [ 7, \&_action_opcode_1652 ], },
	# [6087] opcode : set "[inline_const]" 7 "," "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1653 ], ":" => [ 7, \&_action_opcode_1653 ], },
	# [6088] opcode : set "[inline_const]" 7 "," "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1654 ], ":" => [ 7, \&_action_opcode_1654 ], },
	# [6089] opcode : set "[inline_const]" 7 "," "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1655 ], ":" => [ 7, \&_action_opcode_1655 ], },
	# [6090] opcode : set "[inline_const]" 7 "," "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1656 ], ":" => [ 7, \&_action_opcode_1656 ], },
	# [6091] opcode : set "[inline_const]" 7 "," "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1657 ], ":" => [ 7, \&_action_opcode_1657 ], },
	# [6092] opcode : set "[inline_const]" 7 "," "["
	{ hl => 6093, ix => 6095, iy => 6127, },
	# [6093] opcode : set "[inline_const]" 7 "," "[" hl
	{ "]" => 6094, },
	# [6094] opcode : set "[inline_const]" 7 "," "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_1625 ], ":" => [ 7, \&_action_opcode_1625 ], },
	# [6095] opcode : set "[inline_const]" 7 "," "[" ix
	{ "+" => 6096, "-" => 6107, "]" => 6118, },
	# [6096] opcode : set "[inline_const]" 7 "," "[" ix "+"
	{ "!" => [ 12, 6097 ], "+" => [ 12, 6097 ], "-" => [ 12, 6097 ], __else__ => [ 12, 6097 ], "~" => [ 12, 6097 ], },
	# [6097] opcode : set "[inline_const]" 7 "," "[" ix "+" "[expr_DIS]"
	{ "]" => 6098, },
	# [6098] opcode : set "[inline_const]" 7 "," "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1634 ], "," => 6099, ":" => [ 7, \&_action_opcode_1634 ], },
	# [6099] opcode : set "[inline_const]" 7 "," "[" ix "+" "[expr_DIS]" "]" ","
	{ a => 6100, b => 6101, c => 6102, d => 6103, e => 6104, h => 6105, l => 6106, },
	# [6100] opcode : set "[inline_const]" 7 "," "[" ix "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1635 ], ":" => [ 7, \&_action_opcode_1635 ], },
	# [6101] opcode : set "[inline_const]" 7 "," "[" ix "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1636 ], ":" => [ 7, \&_action_opcode_1636 ], },
	# [6102] opcode : set "[inline_const]" 7 "," "[" ix "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1637 ], ":" => [ 7, \&_action_opcode_1637 ], },
	# [6103] opcode : set "[inline_const]" 7 "," "[" ix "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1638 ], ":" => [ 7, \&_action_opcode_1638 ], },
	# [6104] opcode : set "[inline_const]" 7 "," "[" ix "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1639 ], ":" => [ 7, \&_action_opcode_1639 ], },
	# [6105] opcode : set "[inline_const]" 7 "," "[" ix "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1640 ], ":" => [ 7, \&_action_opcode_1640 ], },
	# [6106] opcode : set "[inline_const]" 7 "," "[" ix "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1641 ], ":" => [ 7, \&_action_opcode_1641 ], },
	# [6107] opcode : set "[inline_const]" 7 "," "[" ix "-"
	{ "!" => [ 14, 6108 ], "+" => [ 14, 6108 ], "-" => [ 14, 6108 ], __else__ => [ 14, 6108 ], "~" => [ 14, 6108 ], },
	# [6108] opcode : set "[inline_const]" 7 "," "[" ix "-" "[expr_NDIS]"
	{ "]" => 6109, },
	# [6109] opcode : set "[inline_const]" 7 "," "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1634 ], "," => 6110, ":" => [ 7, \&_action_opcode_1634 ], },
	# [6110] opcode : set "[inline_const]" 7 "," "[" ix "-" "[expr_NDIS]" "]" ","
	{ a => 6111, b => 6112, c => 6113, d => 6114, e => 6115, h => 6116, l => 6117, },
	# [6111] opcode : set "[inline_const]" 7 "," "[" ix "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1635 ], ":" => [ 7, \&_action_opcode_1635 ], },
	# [6112] opcode : set "[inline_const]" 7 "," "[" ix "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1636 ], ":" => [ 7, \&_action_opcode_1636 ], },
	# [6113] opcode : set "[inline_const]" 7 "," "[" ix "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1637 ], ":" => [ 7, \&_action_opcode_1637 ], },
	# [6114] opcode : set "[inline_const]" 7 "," "[" ix "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1638 ], ":" => [ 7, \&_action_opcode_1638 ], },
	# [6115] opcode : set "[inline_const]" 7 "," "[" ix "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1639 ], ":" => [ 7, \&_action_opcode_1639 ], },
	# [6116] opcode : set "[inline_const]" 7 "," "[" ix "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1640 ], ":" => [ 7, \&_action_opcode_1640 ], },
	# [6117] opcode : set "[inline_const]" 7 "," "[" ix "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1641 ], ":" => [ 7, \&_action_opcode_1641 ], },
	# [6118] opcode : set "[inline_const]" 7 "," "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_1626 ], "," => 6119, ":" => [ 7, \&_action_opcode_1626 ], },
	# [6119] opcode : set "[inline_const]" 7 "," "[" ix "]" ","
	{ a => 6120, b => 6121, c => 6122, d => 6123, e => 6124, h => 6125, l => 6126, },
	# [6120] opcode : set "[inline_const]" 7 "," "[" ix "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1627 ], ":" => [ 7, \&_action_opcode_1627 ], },
	# [6121] opcode : set "[inline_const]" 7 "," "[" ix "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1628 ], ":" => [ 7, \&_action_opcode_1628 ], },
	# [6122] opcode : set "[inline_const]" 7 "," "[" ix "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1629 ], ":" => [ 7, \&_action_opcode_1629 ], },
	# [6123] opcode : set "[inline_const]" 7 "," "[" ix "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1630 ], ":" => [ 7, \&_action_opcode_1630 ], },
	# [6124] opcode : set "[inline_const]" 7 "," "[" ix "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1631 ], ":" => [ 7, \&_action_opcode_1631 ], },
	# [6125] opcode : set "[inline_const]" 7 "," "[" ix "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1632 ], ":" => [ 7, \&_action_opcode_1632 ], },
	# [6126] opcode : set "[inline_const]" 7 "," "[" ix "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1633 ], ":" => [ 7, \&_action_opcode_1633 ], },
	# [6127] opcode : set "[inline_const]" 7 "," "[" iy
	{ "+" => 6128, "-" => 6139, "]" => 6150, },
	# [6128] opcode : set "[inline_const]" 7 "," "[" iy "+"
	{ "!" => [ 12, 6129 ], "+" => [ 12, 6129 ], "-" => [ 12, 6129 ], __else__ => [ 12, 6129 ], "~" => [ 12, 6129 ], },
	# [6129] opcode : set "[inline_const]" 7 "," "[" iy "+" "[expr_DIS]"
	{ "]" => 6130, },
	# [6130] opcode : set "[inline_const]" 7 "," "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1650 ], "," => 6131, ":" => [ 7, \&_action_opcode_1650 ], },
	# [6131] opcode : set "[inline_const]" 7 "," "[" iy "+" "[expr_DIS]" "]" ","
	{ a => 6132, b => 6133, c => 6134, d => 6135, e => 6136, h => 6137, l => 6138, },
	# [6132] opcode : set "[inline_const]" 7 "," "[" iy "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1651 ], ":" => [ 7, \&_action_opcode_1651 ], },
	# [6133] opcode : set "[inline_const]" 7 "," "[" iy "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1652 ], ":" => [ 7, \&_action_opcode_1652 ], },
	# [6134] opcode : set "[inline_const]" 7 "," "[" iy "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1653 ], ":" => [ 7, \&_action_opcode_1653 ], },
	# [6135] opcode : set "[inline_const]" 7 "," "[" iy "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1654 ], ":" => [ 7, \&_action_opcode_1654 ], },
	# [6136] opcode : set "[inline_const]" 7 "," "[" iy "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1655 ], ":" => [ 7, \&_action_opcode_1655 ], },
	# [6137] opcode : set "[inline_const]" 7 "," "[" iy "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1656 ], ":" => [ 7, \&_action_opcode_1656 ], },
	# [6138] opcode : set "[inline_const]" 7 "," "[" iy "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1657 ], ":" => [ 7, \&_action_opcode_1657 ], },
	# [6139] opcode : set "[inline_const]" 7 "," "[" iy "-"
	{ "!" => [ 14, 6140 ], "+" => [ 14, 6140 ], "-" => [ 14, 6140 ], __else__ => [ 14, 6140 ], "~" => [ 14, 6140 ], },
	# [6140] opcode : set "[inline_const]" 7 "," "[" iy "-" "[expr_NDIS]"
	{ "]" => 6141, },
	# [6141] opcode : set "[inline_const]" 7 "," "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1650 ], "," => 6142, ":" => [ 7, \&_action_opcode_1650 ], },
	# [6142] opcode : set "[inline_const]" 7 "," "[" iy "-" "[expr_NDIS]" "]" ","
	{ a => 6143, b => 6144, c => 6145, d => 6146, e => 6147, h => 6148, l => 6149, },
	# [6143] opcode : set "[inline_const]" 7 "," "[" iy "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1651 ], ":" => [ 7, \&_action_opcode_1651 ], },
	# [6144] opcode : set "[inline_const]" 7 "," "[" iy "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1652 ], ":" => [ 7, \&_action_opcode_1652 ], },
	# [6145] opcode : set "[inline_const]" 7 "," "[" iy "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1653 ], ":" => [ 7, \&_action_opcode_1653 ], },
	# [6146] opcode : set "[inline_const]" 7 "," "[" iy "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1654 ], ":" => [ 7, \&_action_opcode_1654 ], },
	# [6147] opcode : set "[inline_const]" 7 "," "[" iy "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1655 ], ":" => [ 7, \&_action_opcode_1655 ], },
	# [6148] opcode : set "[inline_const]" 7 "," "[" iy "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1656 ], ":" => [ 7, \&_action_opcode_1656 ], },
	# [6149] opcode : set "[inline_const]" 7 "," "[" iy "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1657 ], ":" => [ 7, \&_action_opcode_1657 ], },
	# [6150] opcode : set "[inline_const]" 7 "," "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_1642 ], "," => 6151, ":" => [ 7, \&_action_opcode_1642 ], },
	# [6151] opcode : set "[inline_const]" 7 "," "[" iy "]" ","
	{ a => 6152, b => 6153, c => 6154, d => 6155, e => 6156, h => 6157, l => 6158, },
	# [6152] opcode : set "[inline_const]" 7 "," "[" iy "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1643 ], ":" => [ 7, \&_action_opcode_1643 ], },
	# [6153] opcode : set "[inline_const]" 7 "," "[" iy "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1644 ], ":" => [ 7, \&_action_opcode_1644 ], },
	# [6154] opcode : set "[inline_const]" 7 "," "[" iy "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1645 ], ":" => [ 7, \&_action_opcode_1645 ], },
	# [6155] opcode : set "[inline_const]" 7 "," "[" iy "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1646 ], ":" => [ 7, \&_action_opcode_1646 ], },
	# [6156] opcode : set "[inline_const]" 7 "," "[" iy "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1647 ], ":" => [ 7, \&_action_opcode_1647 ], },
	# [6157] opcode : set "[inline_const]" 7 "," "[" iy "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1648 ], ":" => [ 7, \&_action_opcode_1648 ], },
	# [6158] opcode : set "[inline_const]" 7 "," "[" iy "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1649 ], ":" => [ 7, \&_action_opcode_1649 ], },
	# [6159] opcode : set "[inline_const]" 7 "," a
	{ "\n" => [ 7, \&_action_opcode_1658 ], ":" => [ 7, \&_action_opcode_1658 ], },
	# [6160] opcode : set "[inline_const]" 7 "," b
	{ "\n" => [ 7, \&_action_opcode_1659 ], ":" => [ 7, \&_action_opcode_1659 ], },
	# [6161] opcode : set "[inline_const]" 7 "," c
	{ "\n" => [ 7, \&_action_opcode_1660 ], ":" => [ 7, \&_action_opcode_1660 ], },
	# [6162] opcode : set "[inline_const]" 7 "," d
	{ "\n" => [ 7, \&_action_opcode_1661 ], ":" => [ 7, \&_action_opcode_1661 ], },
	# [6163] opcode : set "[inline_const]" 7 "," e
	{ "\n" => [ 7, \&_action_opcode_1662 ], ":" => [ 7, \&_action_opcode_1662 ], },
	# [6164] opcode : set "[inline_const]" 7 "," h
	{ "\n" => [ 7, \&_action_opcode_1663 ], ":" => [ 7, \&_action_opcode_1663 ], },
	# [6165] opcode : set "[inline_const]" 7 "," l
	{ "\n" => [ 7, \&_action_opcode_1664 ], ":" => [ 7, \&_action_opcode_1664 ], },
	# [6166] opcode : sla
	{ "(" => 6167, "[" => 6234, a => 6301, b => 6302, bc => 6303, c => 6304, d => 6305, de => 6306, e => 6307, h => 6308, hl => 6309, l => 6310, },
	# [6167] opcode : sla "("
	{ hl => 6168, ix => 6170, iy => 6202, },
	# [6168] opcode : sla "(" hl
	{ ")" => 6169, },
	# [6169] opcode : sla "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_1665 ], ":" => [ 7, \&_action_opcode_1665 ], },
	# [6170] opcode : sla "(" ix
	{ ")" => 6171, "+" => 6180, "-" => 6191, },
	# [6171] opcode : sla "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_1666 ], "," => 6172, ":" => [ 7, \&_action_opcode_1666 ], },
	# [6172] opcode : sla "(" ix ")" ","
	{ a => 6173, b => 6174, c => 6175, d => 6176, e => 6177, h => 6178, l => 6179, },
	# [6173] opcode : sla "(" ix ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1667 ], ":" => [ 7, \&_action_opcode_1667 ], },
	# [6174] opcode : sla "(" ix ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1668 ], ":" => [ 7, \&_action_opcode_1668 ], },
	# [6175] opcode : sla "(" ix ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1669 ], ":" => [ 7, \&_action_opcode_1669 ], },
	# [6176] opcode : sla "(" ix ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1670 ], ":" => [ 7, \&_action_opcode_1670 ], },
	# [6177] opcode : sla "(" ix ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1671 ], ":" => [ 7, \&_action_opcode_1671 ], },
	# [6178] opcode : sla "(" ix ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1672 ], ":" => [ 7, \&_action_opcode_1672 ], },
	# [6179] opcode : sla "(" ix ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1673 ], ":" => [ 7, \&_action_opcode_1673 ], },
	# [6180] opcode : sla "(" ix "+"
	{ "!" => [ 12, 6181 ], "+" => [ 12, 6181 ], "-" => [ 12, 6181 ], __else__ => [ 12, 6181 ], "~" => [ 12, 6181 ], },
	# [6181] opcode : sla "(" ix "+" "[expr_DIS]"
	{ ")" => 6182, },
	# [6182] opcode : sla "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1674 ], "," => 6183, ":" => [ 7, \&_action_opcode_1674 ], },
	# [6183] opcode : sla "(" ix "+" "[expr_DIS]" ")" ","
	{ a => 6184, b => 6185, c => 6186, d => 6187, e => 6188, h => 6189, l => 6190, },
	# [6184] opcode : sla "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1675 ], ":" => [ 7, \&_action_opcode_1675 ], },
	# [6185] opcode : sla "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1676 ], ":" => [ 7, \&_action_opcode_1676 ], },
	# [6186] opcode : sla "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1677 ], ":" => [ 7, \&_action_opcode_1677 ], },
	# [6187] opcode : sla "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1678 ], ":" => [ 7, \&_action_opcode_1678 ], },
	# [6188] opcode : sla "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1679 ], ":" => [ 7, \&_action_opcode_1679 ], },
	# [6189] opcode : sla "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1680 ], ":" => [ 7, \&_action_opcode_1680 ], },
	# [6190] opcode : sla "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1681 ], ":" => [ 7, \&_action_opcode_1681 ], },
	# [6191] opcode : sla "(" ix "-"
	{ "!" => [ 14, 6192 ], "+" => [ 14, 6192 ], "-" => [ 14, 6192 ], __else__ => [ 14, 6192 ], "~" => [ 14, 6192 ], },
	# [6192] opcode : sla "(" ix "-" "[expr_NDIS]"
	{ ")" => 6193, },
	# [6193] opcode : sla "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1674 ], "," => 6194, ":" => [ 7, \&_action_opcode_1674 ], },
	# [6194] opcode : sla "(" ix "-" "[expr_NDIS]" ")" ","
	{ a => 6195, b => 6196, c => 6197, d => 6198, e => 6199, h => 6200, l => 6201, },
	# [6195] opcode : sla "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1675 ], ":" => [ 7, \&_action_opcode_1675 ], },
	# [6196] opcode : sla "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1676 ], ":" => [ 7, \&_action_opcode_1676 ], },
	# [6197] opcode : sla "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1677 ], ":" => [ 7, \&_action_opcode_1677 ], },
	# [6198] opcode : sla "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1678 ], ":" => [ 7, \&_action_opcode_1678 ], },
	# [6199] opcode : sla "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1679 ], ":" => [ 7, \&_action_opcode_1679 ], },
	# [6200] opcode : sla "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1680 ], ":" => [ 7, \&_action_opcode_1680 ], },
	# [6201] opcode : sla "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1681 ], ":" => [ 7, \&_action_opcode_1681 ], },
	# [6202] opcode : sla "(" iy
	{ ")" => 6203, "+" => 6212, "-" => 6223, },
	# [6203] opcode : sla "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_1682 ], "," => 6204, ":" => [ 7, \&_action_opcode_1682 ], },
	# [6204] opcode : sla "(" iy ")" ","
	{ a => 6205, b => 6206, c => 6207, d => 6208, e => 6209, h => 6210, l => 6211, },
	# [6205] opcode : sla "(" iy ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1683 ], ":" => [ 7, \&_action_opcode_1683 ], },
	# [6206] opcode : sla "(" iy ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1684 ], ":" => [ 7, \&_action_opcode_1684 ], },
	# [6207] opcode : sla "(" iy ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1685 ], ":" => [ 7, \&_action_opcode_1685 ], },
	# [6208] opcode : sla "(" iy ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1686 ], ":" => [ 7, \&_action_opcode_1686 ], },
	# [6209] opcode : sla "(" iy ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1687 ], ":" => [ 7, \&_action_opcode_1687 ], },
	# [6210] opcode : sla "(" iy ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1688 ], ":" => [ 7, \&_action_opcode_1688 ], },
	# [6211] opcode : sla "(" iy ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1689 ], ":" => [ 7, \&_action_opcode_1689 ], },
	# [6212] opcode : sla "(" iy "+"
	{ "!" => [ 12, 6213 ], "+" => [ 12, 6213 ], "-" => [ 12, 6213 ], __else__ => [ 12, 6213 ], "~" => [ 12, 6213 ], },
	# [6213] opcode : sla "(" iy "+" "[expr_DIS]"
	{ ")" => 6214, },
	# [6214] opcode : sla "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1690 ], "," => 6215, ":" => [ 7, \&_action_opcode_1690 ], },
	# [6215] opcode : sla "(" iy "+" "[expr_DIS]" ")" ","
	{ a => 6216, b => 6217, c => 6218, d => 6219, e => 6220, h => 6221, l => 6222, },
	# [6216] opcode : sla "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1691 ], ":" => [ 7, \&_action_opcode_1691 ], },
	# [6217] opcode : sla "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1692 ], ":" => [ 7, \&_action_opcode_1692 ], },
	# [6218] opcode : sla "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1693 ], ":" => [ 7, \&_action_opcode_1693 ], },
	# [6219] opcode : sla "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1694 ], ":" => [ 7, \&_action_opcode_1694 ], },
	# [6220] opcode : sla "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1695 ], ":" => [ 7, \&_action_opcode_1695 ], },
	# [6221] opcode : sla "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1696 ], ":" => [ 7, \&_action_opcode_1696 ], },
	# [6222] opcode : sla "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1697 ], ":" => [ 7, \&_action_opcode_1697 ], },
	# [6223] opcode : sla "(" iy "-"
	{ "!" => [ 14, 6224 ], "+" => [ 14, 6224 ], "-" => [ 14, 6224 ], __else__ => [ 14, 6224 ], "~" => [ 14, 6224 ], },
	# [6224] opcode : sla "(" iy "-" "[expr_NDIS]"
	{ ")" => 6225, },
	# [6225] opcode : sla "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1690 ], "," => 6226, ":" => [ 7, \&_action_opcode_1690 ], },
	# [6226] opcode : sla "(" iy "-" "[expr_NDIS]" ")" ","
	{ a => 6227, b => 6228, c => 6229, d => 6230, e => 6231, h => 6232, l => 6233, },
	# [6227] opcode : sla "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1691 ], ":" => [ 7, \&_action_opcode_1691 ], },
	# [6228] opcode : sla "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1692 ], ":" => [ 7, \&_action_opcode_1692 ], },
	# [6229] opcode : sla "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1693 ], ":" => [ 7, \&_action_opcode_1693 ], },
	# [6230] opcode : sla "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1694 ], ":" => [ 7, \&_action_opcode_1694 ], },
	# [6231] opcode : sla "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1695 ], ":" => [ 7, \&_action_opcode_1695 ], },
	# [6232] opcode : sla "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1696 ], ":" => [ 7, \&_action_opcode_1696 ], },
	# [6233] opcode : sla "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1697 ], ":" => [ 7, \&_action_opcode_1697 ], },
	# [6234] opcode : sla "["
	{ hl => 6235, ix => 6237, iy => 6269, },
	# [6235] opcode : sla "[" hl
	{ "]" => 6236, },
	# [6236] opcode : sla "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_1665 ], ":" => [ 7, \&_action_opcode_1665 ], },
	# [6237] opcode : sla "[" ix
	{ "+" => 6238, "-" => 6249, "]" => 6260, },
	# [6238] opcode : sla "[" ix "+"
	{ "!" => [ 12, 6239 ], "+" => [ 12, 6239 ], "-" => [ 12, 6239 ], __else__ => [ 12, 6239 ], "~" => [ 12, 6239 ], },
	# [6239] opcode : sla "[" ix "+" "[expr_DIS]"
	{ "]" => 6240, },
	# [6240] opcode : sla "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1674 ], "," => 6241, ":" => [ 7, \&_action_opcode_1674 ], },
	# [6241] opcode : sla "[" ix "+" "[expr_DIS]" "]" ","
	{ a => 6242, b => 6243, c => 6244, d => 6245, e => 6246, h => 6247, l => 6248, },
	# [6242] opcode : sla "[" ix "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1675 ], ":" => [ 7, \&_action_opcode_1675 ], },
	# [6243] opcode : sla "[" ix "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1676 ], ":" => [ 7, \&_action_opcode_1676 ], },
	# [6244] opcode : sla "[" ix "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1677 ], ":" => [ 7, \&_action_opcode_1677 ], },
	# [6245] opcode : sla "[" ix "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1678 ], ":" => [ 7, \&_action_opcode_1678 ], },
	# [6246] opcode : sla "[" ix "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1679 ], ":" => [ 7, \&_action_opcode_1679 ], },
	# [6247] opcode : sla "[" ix "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1680 ], ":" => [ 7, \&_action_opcode_1680 ], },
	# [6248] opcode : sla "[" ix "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1681 ], ":" => [ 7, \&_action_opcode_1681 ], },
	# [6249] opcode : sla "[" ix "-"
	{ "!" => [ 14, 6250 ], "+" => [ 14, 6250 ], "-" => [ 14, 6250 ], __else__ => [ 14, 6250 ], "~" => [ 14, 6250 ], },
	# [6250] opcode : sla "[" ix "-" "[expr_NDIS]"
	{ "]" => 6251, },
	# [6251] opcode : sla "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1674 ], "," => 6252, ":" => [ 7, \&_action_opcode_1674 ], },
	# [6252] opcode : sla "[" ix "-" "[expr_NDIS]" "]" ","
	{ a => 6253, b => 6254, c => 6255, d => 6256, e => 6257, h => 6258, l => 6259, },
	# [6253] opcode : sla "[" ix "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1675 ], ":" => [ 7, \&_action_opcode_1675 ], },
	# [6254] opcode : sla "[" ix "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1676 ], ":" => [ 7, \&_action_opcode_1676 ], },
	# [6255] opcode : sla "[" ix "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1677 ], ":" => [ 7, \&_action_opcode_1677 ], },
	# [6256] opcode : sla "[" ix "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1678 ], ":" => [ 7, \&_action_opcode_1678 ], },
	# [6257] opcode : sla "[" ix "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1679 ], ":" => [ 7, \&_action_opcode_1679 ], },
	# [6258] opcode : sla "[" ix "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1680 ], ":" => [ 7, \&_action_opcode_1680 ], },
	# [6259] opcode : sla "[" ix "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1681 ], ":" => [ 7, \&_action_opcode_1681 ], },
	# [6260] opcode : sla "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_1666 ], "," => 6261, ":" => [ 7, \&_action_opcode_1666 ], },
	# [6261] opcode : sla "[" ix "]" ","
	{ a => 6262, b => 6263, c => 6264, d => 6265, e => 6266, h => 6267, l => 6268, },
	# [6262] opcode : sla "[" ix "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1667 ], ":" => [ 7, \&_action_opcode_1667 ], },
	# [6263] opcode : sla "[" ix "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1668 ], ":" => [ 7, \&_action_opcode_1668 ], },
	# [6264] opcode : sla "[" ix "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1669 ], ":" => [ 7, \&_action_opcode_1669 ], },
	# [6265] opcode : sla "[" ix "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1670 ], ":" => [ 7, \&_action_opcode_1670 ], },
	# [6266] opcode : sla "[" ix "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1671 ], ":" => [ 7, \&_action_opcode_1671 ], },
	# [6267] opcode : sla "[" ix "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1672 ], ":" => [ 7, \&_action_opcode_1672 ], },
	# [6268] opcode : sla "[" ix "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1673 ], ":" => [ 7, \&_action_opcode_1673 ], },
	# [6269] opcode : sla "[" iy
	{ "+" => 6270, "-" => 6281, "]" => 6292, },
	# [6270] opcode : sla "[" iy "+"
	{ "!" => [ 12, 6271 ], "+" => [ 12, 6271 ], "-" => [ 12, 6271 ], __else__ => [ 12, 6271 ], "~" => [ 12, 6271 ], },
	# [6271] opcode : sla "[" iy "+" "[expr_DIS]"
	{ "]" => 6272, },
	# [6272] opcode : sla "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1690 ], "," => 6273, ":" => [ 7, \&_action_opcode_1690 ], },
	# [6273] opcode : sla "[" iy "+" "[expr_DIS]" "]" ","
	{ a => 6274, b => 6275, c => 6276, d => 6277, e => 6278, h => 6279, l => 6280, },
	# [6274] opcode : sla "[" iy "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1691 ], ":" => [ 7, \&_action_opcode_1691 ], },
	# [6275] opcode : sla "[" iy "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1692 ], ":" => [ 7, \&_action_opcode_1692 ], },
	# [6276] opcode : sla "[" iy "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1693 ], ":" => [ 7, \&_action_opcode_1693 ], },
	# [6277] opcode : sla "[" iy "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1694 ], ":" => [ 7, \&_action_opcode_1694 ], },
	# [6278] opcode : sla "[" iy "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1695 ], ":" => [ 7, \&_action_opcode_1695 ], },
	# [6279] opcode : sla "[" iy "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1696 ], ":" => [ 7, \&_action_opcode_1696 ], },
	# [6280] opcode : sla "[" iy "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1697 ], ":" => [ 7, \&_action_opcode_1697 ], },
	# [6281] opcode : sla "[" iy "-"
	{ "!" => [ 14, 6282 ], "+" => [ 14, 6282 ], "-" => [ 14, 6282 ], __else__ => [ 14, 6282 ], "~" => [ 14, 6282 ], },
	# [6282] opcode : sla "[" iy "-" "[expr_NDIS]"
	{ "]" => 6283, },
	# [6283] opcode : sla "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1690 ], "," => 6284, ":" => [ 7, \&_action_opcode_1690 ], },
	# [6284] opcode : sla "[" iy "-" "[expr_NDIS]" "]" ","
	{ a => 6285, b => 6286, c => 6287, d => 6288, e => 6289, h => 6290, l => 6291, },
	# [6285] opcode : sla "[" iy "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1691 ], ":" => [ 7, \&_action_opcode_1691 ], },
	# [6286] opcode : sla "[" iy "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1692 ], ":" => [ 7, \&_action_opcode_1692 ], },
	# [6287] opcode : sla "[" iy "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1693 ], ":" => [ 7, \&_action_opcode_1693 ], },
	# [6288] opcode : sla "[" iy "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1694 ], ":" => [ 7, \&_action_opcode_1694 ], },
	# [6289] opcode : sla "[" iy "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1695 ], ":" => [ 7, \&_action_opcode_1695 ], },
	# [6290] opcode : sla "[" iy "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1696 ], ":" => [ 7, \&_action_opcode_1696 ], },
	# [6291] opcode : sla "[" iy "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1697 ], ":" => [ 7, \&_action_opcode_1697 ], },
	# [6292] opcode : sla "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_1682 ], "," => 6293, ":" => [ 7, \&_action_opcode_1682 ], },
	# [6293] opcode : sla "[" iy "]" ","
	{ a => 6294, b => 6295, c => 6296, d => 6297, e => 6298, h => 6299, l => 6300, },
	# [6294] opcode : sla "[" iy "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1683 ], ":" => [ 7, \&_action_opcode_1683 ], },
	# [6295] opcode : sla "[" iy "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1684 ], ":" => [ 7, \&_action_opcode_1684 ], },
	# [6296] opcode : sla "[" iy "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1685 ], ":" => [ 7, \&_action_opcode_1685 ], },
	# [6297] opcode : sla "[" iy "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1686 ], ":" => [ 7, \&_action_opcode_1686 ], },
	# [6298] opcode : sla "[" iy "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1687 ], ":" => [ 7, \&_action_opcode_1687 ], },
	# [6299] opcode : sla "[" iy "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1688 ], ":" => [ 7, \&_action_opcode_1688 ], },
	# [6300] opcode : sla "[" iy "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1689 ], ":" => [ 7, \&_action_opcode_1689 ], },
	# [6301] opcode : sla a
	{ "\n" => [ 7, \&_action_opcode_1698 ], ":" => [ 7, \&_action_opcode_1698 ], },
	# [6302] opcode : sla b
	{ "\n" => [ 7, \&_action_opcode_1699 ], ":" => [ 7, \&_action_opcode_1699 ], },
	# [6303] opcode : sla bc
	{ "\n" => [ 7, \&_action_opcode_1700 ], ":" => [ 7, \&_action_opcode_1700 ], },
	# [6304] opcode : sla c
	{ "\n" => [ 7, \&_action_opcode_1701 ], ":" => [ 7, \&_action_opcode_1701 ], },
	# [6305] opcode : sla d
	{ "\n" => [ 7, \&_action_opcode_1702 ], ":" => [ 7, \&_action_opcode_1702 ], },
	# [6306] opcode : sla de
	{ "\n" => [ 7, \&_action_opcode_1703 ], ":" => [ 7, \&_action_opcode_1703 ], },
	# [6307] opcode : sla e
	{ "\n" => [ 7, \&_action_opcode_1704 ], ":" => [ 7, \&_action_opcode_1704 ], },
	# [6308] opcode : sla h
	{ "\n" => [ 7, \&_action_opcode_1705 ], ":" => [ 7, \&_action_opcode_1705 ], },
	# [6309] opcode : sla hl
	{ "\n" => [ 7, \&_action_opcode_68 ], ":" => [ 7, \&_action_opcode_68 ], },
	# [6310] opcode : sla l
	{ "\n" => [ 7, \&_action_opcode_1706 ], ":" => [ 7, \&_action_opcode_1706 ], },
	# [6311] opcode : sli
	{ "(" => 6312, "[" => 6379, a => 6446, b => 6447, bc => 6448, c => 6449, d => 6450, de => 6451, e => 6452, h => 6453, hl => 6454, l => 6455, },
	# [6312] opcode : sli "("
	{ hl => 6313, ix => 6315, iy => 6347, },
	# [6313] opcode : sli "(" hl
	{ ")" => 6314, },
	# [6314] opcode : sli "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_1707 ], ":" => [ 7, \&_action_opcode_1707 ], },
	# [6315] opcode : sli "(" ix
	{ ")" => 6316, "+" => 6325, "-" => 6336, },
	# [6316] opcode : sli "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_1708 ], "," => 6317, ":" => [ 7, \&_action_opcode_1708 ], },
	# [6317] opcode : sli "(" ix ")" ","
	{ a => 6318, b => 6319, c => 6320, d => 6321, e => 6322, h => 6323, l => 6324, },
	# [6318] opcode : sli "(" ix ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1709 ], ":" => [ 7, \&_action_opcode_1709 ], },
	# [6319] opcode : sli "(" ix ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1710 ], ":" => [ 7, \&_action_opcode_1710 ], },
	# [6320] opcode : sli "(" ix ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1711 ], ":" => [ 7, \&_action_opcode_1711 ], },
	# [6321] opcode : sli "(" ix ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1712 ], ":" => [ 7, \&_action_opcode_1712 ], },
	# [6322] opcode : sli "(" ix ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1713 ], ":" => [ 7, \&_action_opcode_1713 ], },
	# [6323] opcode : sli "(" ix ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1714 ], ":" => [ 7, \&_action_opcode_1714 ], },
	# [6324] opcode : sli "(" ix ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1715 ], ":" => [ 7, \&_action_opcode_1715 ], },
	# [6325] opcode : sli "(" ix "+"
	{ "!" => [ 12, 6326 ], "+" => [ 12, 6326 ], "-" => [ 12, 6326 ], __else__ => [ 12, 6326 ], "~" => [ 12, 6326 ], },
	# [6326] opcode : sli "(" ix "+" "[expr_DIS]"
	{ ")" => 6327, },
	# [6327] opcode : sli "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1716 ], "," => 6328, ":" => [ 7, \&_action_opcode_1716 ], },
	# [6328] opcode : sli "(" ix "+" "[expr_DIS]" ")" ","
	{ a => 6329, b => 6330, c => 6331, d => 6332, e => 6333, h => 6334, l => 6335, },
	# [6329] opcode : sli "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1717 ], ":" => [ 7, \&_action_opcode_1717 ], },
	# [6330] opcode : sli "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1718 ], ":" => [ 7, \&_action_opcode_1718 ], },
	# [6331] opcode : sli "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1719 ], ":" => [ 7, \&_action_opcode_1719 ], },
	# [6332] opcode : sli "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1720 ], ":" => [ 7, \&_action_opcode_1720 ], },
	# [6333] opcode : sli "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1721 ], ":" => [ 7, \&_action_opcode_1721 ], },
	# [6334] opcode : sli "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1722 ], ":" => [ 7, \&_action_opcode_1722 ], },
	# [6335] opcode : sli "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1723 ], ":" => [ 7, \&_action_opcode_1723 ], },
	# [6336] opcode : sli "(" ix "-"
	{ "!" => [ 14, 6337 ], "+" => [ 14, 6337 ], "-" => [ 14, 6337 ], __else__ => [ 14, 6337 ], "~" => [ 14, 6337 ], },
	# [6337] opcode : sli "(" ix "-" "[expr_NDIS]"
	{ ")" => 6338, },
	# [6338] opcode : sli "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1716 ], "," => 6339, ":" => [ 7, \&_action_opcode_1716 ], },
	# [6339] opcode : sli "(" ix "-" "[expr_NDIS]" ")" ","
	{ a => 6340, b => 6341, c => 6342, d => 6343, e => 6344, h => 6345, l => 6346, },
	# [6340] opcode : sli "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1717 ], ":" => [ 7, \&_action_opcode_1717 ], },
	# [6341] opcode : sli "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1718 ], ":" => [ 7, \&_action_opcode_1718 ], },
	# [6342] opcode : sli "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1719 ], ":" => [ 7, \&_action_opcode_1719 ], },
	# [6343] opcode : sli "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1720 ], ":" => [ 7, \&_action_opcode_1720 ], },
	# [6344] opcode : sli "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1721 ], ":" => [ 7, \&_action_opcode_1721 ], },
	# [6345] opcode : sli "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1722 ], ":" => [ 7, \&_action_opcode_1722 ], },
	# [6346] opcode : sli "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1723 ], ":" => [ 7, \&_action_opcode_1723 ], },
	# [6347] opcode : sli "(" iy
	{ ")" => 6348, "+" => 6357, "-" => 6368, },
	# [6348] opcode : sli "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_1724 ], "," => 6349, ":" => [ 7, \&_action_opcode_1724 ], },
	# [6349] opcode : sli "(" iy ")" ","
	{ a => 6350, b => 6351, c => 6352, d => 6353, e => 6354, h => 6355, l => 6356, },
	# [6350] opcode : sli "(" iy ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1725 ], ":" => [ 7, \&_action_opcode_1725 ], },
	# [6351] opcode : sli "(" iy ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1726 ], ":" => [ 7, \&_action_opcode_1726 ], },
	# [6352] opcode : sli "(" iy ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1727 ], ":" => [ 7, \&_action_opcode_1727 ], },
	# [6353] opcode : sli "(" iy ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1728 ], ":" => [ 7, \&_action_opcode_1728 ], },
	# [6354] opcode : sli "(" iy ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1729 ], ":" => [ 7, \&_action_opcode_1729 ], },
	# [6355] opcode : sli "(" iy ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1730 ], ":" => [ 7, \&_action_opcode_1730 ], },
	# [6356] opcode : sli "(" iy ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1731 ], ":" => [ 7, \&_action_opcode_1731 ], },
	# [6357] opcode : sli "(" iy "+"
	{ "!" => [ 12, 6358 ], "+" => [ 12, 6358 ], "-" => [ 12, 6358 ], __else__ => [ 12, 6358 ], "~" => [ 12, 6358 ], },
	# [6358] opcode : sli "(" iy "+" "[expr_DIS]"
	{ ")" => 6359, },
	# [6359] opcode : sli "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1732 ], "," => 6360, ":" => [ 7, \&_action_opcode_1732 ], },
	# [6360] opcode : sli "(" iy "+" "[expr_DIS]" ")" ","
	{ a => 6361, b => 6362, c => 6363, d => 6364, e => 6365, h => 6366, l => 6367, },
	# [6361] opcode : sli "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1733 ], ":" => [ 7, \&_action_opcode_1733 ], },
	# [6362] opcode : sli "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1734 ], ":" => [ 7, \&_action_opcode_1734 ], },
	# [6363] opcode : sli "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1735 ], ":" => [ 7, \&_action_opcode_1735 ], },
	# [6364] opcode : sli "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1736 ], ":" => [ 7, \&_action_opcode_1736 ], },
	# [6365] opcode : sli "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1737 ], ":" => [ 7, \&_action_opcode_1737 ], },
	# [6366] opcode : sli "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1738 ], ":" => [ 7, \&_action_opcode_1738 ], },
	# [6367] opcode : sli "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1739 ], ":" => [ 7, \&_action_opcode_1739 ], },
	# [6368] opcode : sli "(" iy "-"
	{ "!" => [ 14, 6369 ], "+" => [ 14, 6369 ], "-" => [ 14, 6369 ], __else__ => [ 14, 6369 ], "~" => [ 14, 6369 ], },
	# [6369] opcode : sli "(" iy "-" "[expr_NDIS]"
	{ ")" => 6370, },
	# [6370] opcode : sli "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1732 ], "," => 6371, ":" => [ 7, \&_action_opcode_1732 ], },
	# [6371] opcode : sli "(" iy "-" "[expr_NDIS]" ")" ","
	{ a => 6372, b => 6373, c => 6374, d => 6375, e => 6376, h => 6377, l => 6378, },
	# [6372] opcode : sli "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1733 ], ":" => [ 7, \&_action_opcode_1733 ], },
	# [6373] opcode : sli "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1734 ], ":" => [ 7, \&_action_opcode_1734 ], },
	# [6374] opcode : sli "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1735 ], ":" => [ 7, \&_action_opcode_1735 ], },
	# [6375] opcode : sli "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1736 ], ":" => [ 7, \&_action_opcode_1736 ], },
	# [6376] opcode : sli "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1737 ], ":" => [ 7, \&_action_opcode_1737 ], },
	# [6377] opcode : sli "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1738 ], ":" => [ 7, \&_action_opcode_1738 ], },
	# [6378] opcode : sli "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1739 ], ":" => [ 7, \&_action_opcode_1739 ], },
	# [6379] opcode : sli "["
	{ hl => 6380, ix => 6382, iy => 6414, },
	# [6380] opcode : sli "[" hl
	{ "]" => 6381, },
	# [6381] opcode : sli "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_1707 ], ":" => [ 7, \&_action_opcode_1707 ], },
	# [6382] opcode : sli "[" ix
	{ "+" => 6383, "-" => 6394, "]" => 6405, },
	# [6383] opcode : sli "[" ix "+"
	{ "!" => [ 12, 6384 ], "+" => [ 12, 6384 ], "-" => [ 12, 6384 ], __else__ => [ 12, 6384 ], "~" => [ 12, 6384 ], },
	# [6384] opcode : sli "[" ix "+" "[expr_DIS]"
	{ "]" => 6385, },
	# [6385] opcode : sli "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1716 ], "," => 6386, ":" => [ 7, \&_action_opcode_1716 ], },
	# [6386] opcode : sli "[" ix "+" "[expr_DIS]" "]" ","
	{ a => 6387, b => 6388, c => 6389, d => 6390, e => 6391, h => 6392, l => 6393, },
	# [6387] opcode : sli "[" ix "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1717 ], ":" => [ 7, \&_action_opcode_1717 ], },
	# [6388] opcode : sli "[" ix "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1718 ], ":" => [ 7, \&_action_opcode_1718 ], },
	# [6389] opcode : sli "[" ix "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1719 ], ":" => [ 7, \&_action_opcode_1719 ], },
	# [6390] opcode : sli "[" ix "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1720 ], ":" => [ 7, \&_action_opcode_1720 ], },
	# [6391] opcode : sli "[" ix "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1721 ], ":" => [ 7, \&_action_opcode_1721 ], },
	# [6392] opcode : sli "[" ix "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1722 ], ":" => [ 7, \&_action_opcode_1722 ], },
	# [6393] opcode : sli "[" ix "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1723 ], ":" => [ 7, \&_action_opcode_1723 ], },
	# [6394] opcode : sli "[" ix "-"
	{ "!" => [ 14, 6395 ], "+" => [ 14, 6395 ], "-" => [ 14, 6395 ], __else__ => [ 14, 6395 ], "~" => [ 14, 6395 ], },
	# [6395] opcode : sli "[" ix "-" "[expr_NDIS]"
	{ "]" => 6396, },
	# [6396] opcode : sli "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1716 ], "," => 6397, ":" => [ 7, \&_action_opcode_1716 ], },
	# [6397] opcode : sli "[" ix "-" "[expr_NDIS]" "]" ","
	{ a => 6398, b => 6399, c => 6400, d => 6401, e => 6402, h => 6403, l => 6404, },
	# [6398] opcode : sli "[" ix "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1717 ], ":" => [ 7, \&_action_opcode_1717 ], },
	# [6399] opcode : sli "[" ix "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1718 ], ":" => [ 7, \&_action_opcode_1718 ], },
	# [6400] opcode : sli "[" ix "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1719 ], ":" => [ 7, \&_action_opcode_1719 ], },
	# [6401] opcode : sli "[" ix "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1720 ], ":" => [ 7, \&_action_opcode_1720 ], },
	# [6402] opcode : sli "[" ix "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1721 ], ":" => [ 7, \&_action_opcode_1721 ], },
	# [6403] opcode : sli "[" ix "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1722 ], ":" => [ 7, \&_action_opcode_1722 ], },
	# [6404] opcode : sli "[" ix "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1723 ], ":" => [ 7, \&_action_opcode_1723 ], },
	# [6405] opcode : sli "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_1708 ], "," => 6406, ":" => [ 7, \&_action_opcode_1708 ], },
	# [6406] opcode : sli "[" ix "]" ","
	{ a => 6407, b => 6408, c => 6409, d => 6410, e => 6411, h => 6412, l => 6413, },
	# [6407] opcode : sli "[" ix "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1709 ], ":" => [ 7, \&_action_opcode_1709 ], },
	# [6408] opcode : sli "[" ix "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1710 ], ":" => [ 7, \&_action_opcode_1710 ], },
	# [6409] opcode : sli "[" ix "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1711 ], ":" => [ 7, \&_action_opcode_1711 ], },
	# [6410] opcode : sli "[" ix "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1712 ], ":" => [ 7, \&_action_opcode_1712 ], },
	# [6411] opcode : sli "[" ix "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1713 ], ":" => [ 7, \&_action_opcode_1713 ], },
	# [6412] opcode : sli "[" ix "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1714 ], ":" => [ 7, \&_action_opcode_1714 ], },
	# [6413] opcode : sli "[" ix "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1715 ], ":" => [ 7, \&_action_opcode_1715 ], },
	# [6414] opcode : sli "[" iy
	{ "+" => 6415, "-" => 6426, "]" => 6437, },
	# [6415] opcode : sli "[" iy "+"
	{ "!" => [ 12, 6416 ], "+" => [ 12, 6416 ], "-" => [ 12, 6416 ], __else__ => [ 12, 6416 ], "~" => [ 12, 6416 ], },
	# [6416] opcode : sli "[" iy "+" "[expr_DIS]"
	{ "]" => 6417, },
	# [6417] opcode : sli "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1732 ], "," => 6418, ":" => [ 7, \&_action_opcode_1732 ], },
	# [6418] opcode : sli "[" iy "+" "[expr_DIS]" "]" ","
	{ a => 6419, b => 6420, c => 6421, d => 6422, e => 6423, h => 6424, l => 6425, },
	# [6419] opcode : sli "[" iy "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1733 ], ":" => [ 7, \&_action_opcode_1733 ], },
	# [6420] opcode : sli "[" iy "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1734 ], ":" => [ 7, \&_action_opcode_1734 ], },
	# [6421] opcode : sli "[" iy "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1735 ], ":" => [ 7, \&_action_opcode_1735 ], },
	# [6422] opcode : sli "[" iy "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1736 ], ":" => [ 7, \&_action_opcode_1736 ], },
	# [6423] opcode : sli "[" iy "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1737 ], ":" => [ 7, \&_action_opcode_1737 ], },
	# [6424] opcode : sli "[" iy "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1738 ], ":" => [ 7, \&_action_opcode_1738 ], },
	# [6425] opcode : sli "[" iy "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1739 ], ":" => [ 7, \&_action_opcode_1739 ], },
	# [6426] opcode : sli "[" iy "-"
	{ "!" => [ 14, 6427 ], "+" => [ 14, 6427 ], "-" => [ 14, 6427 ], __else__ => [ 14, 6427 ], "~" => [ 14, 6427 ], },
	# [6427] opcode : sli "[" iy "-" "[expr_NDIS]"
	{ "]" => 6428, },
	# [6428] opcode : sli "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1732 ], "," => 6429, ":" => [ 7, \&_action_opcode_1732 ], },
	# [6429] opcode : sli "[" iy "-" "[expr_NDIS]" "]" ","
	{ a => 6430, b => 6431, c => 6432, d => 6433, e => 6434, h => 6435, l => 6436, },
	# [6430] opcode : sli "[" iy "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1733 ], ":" => [ 7, \&_action_opcode_1733 ], },
	# [6431] opcode : sli "[" iy "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1734 ], ":" => [ 7, \&_action_opcode_1734 ], },
	# [6432] opcode : sli "[" iy "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1735 ], ":" => [ 7, \&_action_opcode_1735 ], },
	# [6433] opcode : sli "[" iy "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1736 ], ":" => [ 7, \&_action_opcode_1736 ], },
	# [6434] opcode : sli "[" iy "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1737 ], ":" => [ 7, \&_action_opcode_1737 ], },
	# [6435] opcode : sli "[" iy "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1738 ], ":" => [ 7, \&_action_opcode_1738 ], },
	# [6436] opcode : sli "[" iy "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1739 ], ":" => [ 7, \&_action_opcode_1739 ], },
	# [6437] opcode : sli "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_1724 ], "," => 6438, ":" => [ 7, \&_action_opcode_1724 ], },
	# [6438] opcode : sli "[" iy "]" ","
	{ a => 6439, b => 6440, c => 6441, d => 6442, e => 6443, h => 6444, l => 6445, },
	# [6439] opcode : sli "[" iy "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1725 ], ":" => [ 7, \&_action_opcode_1725 ], },
	# [6440] opcode : sli "[" iy "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1726 ], ":" => [ 7, \&_action_opcode_1726 ], },
	# [6441] opcode : sli "[" iy "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1727 ], ":" => [ 7, \&_action_opcode_1727 ], },
	# [6442] opcode : sli "[" iy "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1728 ], ":" => [ 7, \&_action_opcode_1728 ], },
	# [6443] opcode : sli "[" iy "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1729 ], ":" => [ 7, \&_action_opcode_1729 ], },
	# [6444] opcode : sli "[" iy "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1730 ], ":" => [ 7, \&_action_opcode_1730 ], },
	# [6445] opcode : sli "[" iy "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1731 ], ":" => [ 7, \&_action_opcode_1731 ], },
	# [6446] opcode : sli a
	{ "\n" => [ 7, \&_action_opcode_1740 ], ":" => [ 7, \&_action_opcode_1740 ], },
	# [6447] opcode : sli b
	{ "\n" => [ 7, \&_action_opcode_1741 ], ":" => [ 7, \&_action_opcode_1741 ], },
	# [6448] opcode : sli bc
	{ "\n" => [ 7, \&_action_opcode_1742 ], ":" => [ 7, \&_action_opcode_1742 ], },
	# [6449] opcode : sli c
	{ "\n" => [ 7, \&_action_opcode_1743 ], ":" => [ 7, \&_action_opcode_1743 ], },
	# [6450] opcode : sli d
	{ "\n" => [ 7, \&_action_opcode_1744 ], ":" => [ 7, \&_action_opcode_1744 ], },
	# [6451] opcode : sli de
	{ "\n" => [ 7, \&_action_opcode_1745 ], ":" => [ 7, \&_action_opcode_1745 ], },
	# [6452] opcode : sli e
	{ "\n" => [ 7, \&_action_opcode_1746 ], ":" => [ 7, \&_action_opcode_1746 ], },
	# [6453] opcode : sli h
	{ "\n" => [ 7, \&_action_opcode_1747 ], ":" => [ 7, \&_action_opcode_1747 ], },
	# [6454] opcode : sli hl
	{ "\n" => [ 7, \&_action_opcode_1748 ], ":" => [ 7, \&_action_opcode_1748 ], },
	# [6455] opcode : sli l
	{ "\n" => [ 7, \&_action_opcode_1749 ], ":" => [ 7, \&_action_opcode_1749 ], },
	# [6456] opcode : sll
	{ "(" => 6457, "[" => 6524, a => 6591, b => 6592, bc => 6593, c => 6594, d => 6595, de => 6596, e => 6597, h => 6598, hl => 6599, l => 6600, },
	# [6457] opcode : sll "("
	{ hl => 6458, ix => 6460, iy => 6492, },
	# [6458] opcode : sll "(" hl
	{ ")" => 6459, },
	# [6459] opcode : sll "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_1707 ], ":" => [ 7, \&_action_opcode_1707 ], },
	# [6460] opcode : sll "(" ix
	{ ")" => 6461, "+" => 6470, "-" => 6481, },
	# [6461] opcode : sll "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_1708 ], "," => 6462, ":" => [ 7, \&_action_opcode_1708 ], },
	# [6462] opcode : sll "(" ix ")" ","
	{ a => 6463, b => 6464, c => 6465, d => 6466, e => 6467, h => 6468, l => 6469, },
	# [6463] opcode : sll "(" ix ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1709 ], ":" => [ 7, \&_action_opcode_1709 ], },
	# [6464] opcode : sll "(" ix ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1710 ], ":" => [ 7, \&_action_opcode_1710 ], },
	# [6465] opcode : sll "(" ix ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1711 ], ":" => [ 7, \&_action_opcode_1711 ], },
	# [6466] opcode : sll "(" ix ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1712 ], ":" => [ 7, \&_action_opcode_1712 ], },
	# [6467] opcode : sll "(" ix ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1713 ], ":" => [ 7, \&_action_opcode_1713 ], },
	# [6468] opcode : sll "(" ix ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1714 ], ":" => [ 7, \&_action_opcode_1714 ], },
	# [6469] opcode : sll "(" ix ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1715 ], ":" => [ 7, \&_action_opcode_1715 ], },
	# [6470] opcode : sll "(" ix "+"
	{ "!" => [ 12, 6471 ], "+" => [ 12, 6471 ], "-" => [ 12, 6471 ], __else__ => [ 12, 6471 ], "~" => [ 12, 6471 ], },
	# [6471] opcode : sll "(" ix "+" "[expr_DIS]"
	{ ")" => 6472, },
	# [6472] opcode : sll "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1716 ], "," => 6473, ":" => [ 7, \&_action_opcode_1716 ], },
	# [6473] opcode : sll "(" ix "+" "[expr_DIS]" ")" ","
	{ a => 6474, b => 6475, c => 6476, d => 6477, e => 6478, h => 6479, l => 6480, },
	# [6474] opcode : sll "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1717 ], ":" => [ 7, \&_action_opcode_1717 ], },
	# [6475] opcode : sll "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1718 ], ":" => [ 7, \&_action_opcode_1718 ], },
	# [6476] opcode : sll "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1719 ], ":" => [ 7, \&_action_opcode_1719 ], },
	# [6477] opcode : sll "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1720 ], ":" => [ 7, \&_action_opcode_1720 ], },
	# [6478] opcode : sll "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1721 ], ":" => [ 7, \&_action_opcode_1721 ], },
	# [6479] opcode : sll "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1722 ], ":" => [ 7, \&_action_opcode_1722 ], },
	# [6480] opcode : sll "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1723 ], ":" => [ 7, \&_action_opcode_1723 ], },
	# [6481] opcode : sll "(" ix "-"
	{ "!" => [ 14, 6482 ], "+" => [ 14, 6482 ], "-" => [ 14, 6482 ], __else__ => [ 14, 6482 ], "~" => [ 14, 6482 ], },
	# [6482] opcode : sll "(" ix "-" "[expr_NDIS]"
	{ ")" => 6483, },
	# [6483] opcode : sll "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1716 ], "," => 6484, ":" => [ 7, \&_action_opcode_1716 ], },
	# [6484] opcode : sll "(" ix "-" "[expr_NDIS]" ")" ","
	{ a => 6485, b => 6486, c => 6487, d => 6488, e => 6489, h => 6490, l => 6491, },
	# [6485] opcode : sll "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1717 ], ":" => [ 7, \&_action_opcode_1717 ], },
	# [6486] opcode : sll "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1718 ], ":" => [ 7, \&_action_opcode_1718 ], },
	# [6487] opcode : sll "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1719 ], ":" => [ 7, \&_action_opcode_1719 ], },
	# [6488] opcode : sll "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1720 ], ":" => [ 7, \&_action_opcode_1720 ], },
	# [6489] opcode : sll "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1721 ], ":" => [ 7, \&_action_opcode_1721 ], },
	# [6490] opcode : sll "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1722 ], ":" => [ 7, \&_action_opcode_1722 ], },
	# [6491] opcode : sll "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1723 ], ":" => [ 7, \&_action_opcode_1723 ], },
	# [6492] opcode : sll "(" iy
	{ ")" => 6493, "+" => 6502, "-" => 6513, },
	# [6493] opcode : sll "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_1724 ], "," => 6494, ":" => [ 7, \&_action_opcode_1724 ], },
	# [6494] opcode : sll "(" iy ")" ","
	{ a => 6495, b => 6496, c => 6497, d => 6498, e => 6499, h => 6500, l => 6501, },
	# [6495] opcode : sll "(" iy ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1725 ], ":" => [ 7, \&_action_opcode_1725 ], },
	# [6496] opcode : sll "(" iy ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1726 ], ":" => [ 7, \&_action_opcode_1726 ], },
	# [6497] opcode : sll "(" iy ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1727 ], ":" => [ 7, \&_action_opcode_1727 ], },
	# [6498] opcode : sll "(" iy ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1728 ], ":" => [ 7, \&_action_opcode_1728 ], },
	# [6499] opcode : sll "(" iy ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1729 ], ":" => [ 7, \&_action_opcode_1729 ], },
	# [6500] opcode : sll "(" iy ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1730 ], ":" => [ 7, \&_action_opcode_1730 ], },
	# [6501] opcode : sll "(" iy ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1731 ], ":" => [ 7, \&_action_opcode_1731 ], },
	# [6502] opcode : sll "(" iy "+"
	{ "!" => [ 12, 6503 ], "+" => [ 12, 6503 ], "-" => [ 12, 6503 ], __else__ => [ 12, 6503 ], "~" => [ 12, 6503 ], },
	# [6503] opcode : sll "(" iy "+" "[expr_DIS]"
	{ ")" => 6504, },
	# [6504] opcode : sll "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1732 ], "," => 6505, ":" => [ 7, \&_action_opcode_1732 ], },
	# [6505] opcode : sll "(" iy "+" "[expr_DIS]" ")" ","
	{ a => 6506, b => 6507, c => 6508, d => 6509, e => 6510, h => 6511, l => 6512, },
	# [6506] opcode : sll "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1733 ], ":" => [ 7, \&_action_opcode_1733 ], },
	# [6507] opcode : sll "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1734 ], ":" => [ 7, \&_action_opcode_1734 ], },
	# [6508] opcode : sll "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1735 ], ":" => [ 7, \&_action_opcode_1735 ], },
	# [6509] opcode : sll "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1736 ], ":" => [ 7, \&_action_opcode_1736 ], },
	# [6510] opcode : sll "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1737 ], ":" => [ 7, \&_action_opcode_1737 ], },
	# [6511] opcode : sll "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1738 ], ":" => [ 7, \&_action_opcode_1738 ], },
	# [6512] opcode : sll "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1739 ], ":" => [ 7, \&_action_opcode_1739 ], },
	# [6513] opcode : sll "(" iy "-"
	{ "!" => [ 14, 6514 ], "+" => [ 14, 6514 ], "-" => [ 14, 6514 ], __else__ => [ 14, 6514 ], "~" => [ 14, 6514 ], },
	# [6514] opcode : sll "(" iy "-" "[expr_NDIS]"
	{ ")" => 6515, },
	# [6515] opcode : sll "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1732 ], "," => 6516, ":" => [ 7, \&_action_opcode_1732 ], },
	# [6516] opcode : sll "(" iy "-" "[expr_NDIS]" ")" ","
	{ a => 6517, b => 6518, c => 6519, d => 6520, e => 6521, h => 6522, l => 6523, },
	# [6517] opcode : sll "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1733 ], ":" => [ 7, \&_action_opcode_1733 ], },
	# [6518] opcode : sll "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1734 ], ":" => [ 7, \&_action_opcode_1734 ], },
	# [6519] opcode : sll "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1735 ], ":" => [ 7, \&_action_opcode_1735 ], },
	# [6520] opcode : sll "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1736 ], ":" => [ 7, \&_action_opcode_1736 ], },
	# [6521] opcode : sll "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1737 ], ":" => [ 7, \&_action_opcode_1737 ], },
	# [6522] opcode : sll "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1738 ], ":" => [ 7, \&_action_opcode_1738 ], },
	# [6523] opcode : sll "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1739 ], ":" => [ 7, \&_action_opcode_1739 ], },
	# [6524] opcode : sll "["
	{ hl => 6525, ix => 6527, iy => 6559, },
	# [6525] opcode : sll "[" hl
	{ "]" => 6526, },
	# [6526] opcode : sll "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_1707 ], ":" => [ 7, \&_action_opcode_1707 ], },
	# [6527] opcode : sll "[" ix
	{ "+" => 6528, "-" => 6539, "]" => 6550, },
	# [6528] opcode : sll "[" ix "+"
	{ "!" => [ 12, 6529 ], "+" => [ 12, 6529 ], "-" => [ 12, 6529 ], __else__ => [ 12, 6529 ], "~" => [ 12, 6529 ], },
	# [6529] opcode : sll "[" ix "+" "[expr_DIS]"
	{ "]" => 6530, },
	# [6530] opcode : sll "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1716 ], "," => 6531, ":" => [ 7, \&_action_opcode_1716 ], },
	# [6531] opcode : sll "[" ix "+" "[expr_DIS]" "]" ","
	{ a => 6532, b => 6533, c => 6534, d => 6535, e => 6536, h => 6537, l => 6538, },
	# [6532] opcode : sll "[" ix "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1717 ], ":" => [ 7, \&_action_opcode_1717 ], },
	# [6533] opcode : sll "[" ix "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1718 ], ":" => [ 7, \&_action_opcode_1718 ], },
	# [6534] opcode : sll "[" ix "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1719 ], ":" => [ 7, \&_action_opcode_1719 ], },
	# [6535] opcode : sll "[" ix "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1720 ], ":" => [ 7, \&_action_opcode_1720 ], },
	# [6536] opcode : sll "[" ix "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1721 ], ":" => [ 7, \&_action_opcode_1721 ], },
	# [6537] opcode : sll "[" ix "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1722 ], ":" => [ 7, \&_action_opcode_1722 ], },
	# [6538] opcode : sll "[" ix "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1723 ], ":" => [ 7, \&_action_opcode_1723 ], },
	# [6539] opcode : sll "[" ix "-"
	{ "!" => [ 14, 6540 ], "+" => [ 14, 6540 ], "-" => [ 14, 6540 ], __else__ => [ 14, 6540 ], "~" => [ 14, 6540 ], },
	# [6540] opcode : sll "[" ix "-" "[expr_NDIS]"
	{ "]" => 6541, },
	# [6541] opcode : sll "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1716 ], "," => 6542, ":" => [ 7, \&_action_opcode_1716 ], },
	# [6542] opcode : sll "[" ix "-" "[expr_NDIS]" "]" ","
	{ a => 6543, b => 6544, c => 6545, d => 6546, e => 6547, h => 6548, l => 6549, },
	# [6543] opcode : sll "[" ix "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1717 ], ":" => [ 7, \&_action_opcode_1717 ], },
	# [6544] opcode : sll "[" ix "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1718 ], ":" => [ 7, \&_action_opcode_1718 ], },
	# [6545] opcode : sll "[" ix "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1719 ], ":" => [ 7, \&_action_opcode_1719 ], },
	# [6546] opcode : sll "[" ix "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1720 ], ":" => [ 7, \&_action_opcode_1720 ], },
	# [6547] opcode : sll "[" ix "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1721 ], ":" => [ 7, \&_action_opcode_1721 ], },
	# [6548] opcode : sll "[" ix "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1722 ], ":" => [ 7, \&_action_opcode_1722 ], },
	# [6549] opcode : sll "[" ix "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1723 ], ":" => [ 7, \&_action_opcode_1723 ], },
	# [6550] opcode : sll "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_1708 ], "," => 6551, ":" => [ 7, \&_action_opcode_1708 ], },
	# [6551] opcode : sll "[" ix "]" ","
	{ a => 6552, b => 6553, c => 6554, d => 6555, e => 6556, h => 6557, l => 6558, },
	# [6552] opcode : sll "[" ix "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1709 ], ":" => [ 7, \&_action_opcode_1709 ], },
	# [6553] opcode : sll "[" ix "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1710 ], ":" => [ 7, \&_action_opcode_1710 ], },
	# [6554] opcode : sll "[" ix "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1711 ], ":" => [ 7, \&_action_opcode_1711 ], },
	# [6555] opcode : sll "[" ix "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1712 ], ":" => [ 7, \&_action_opcode_1712 ], },
	# [6556] opcode : sll "[" ix "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1713 ], ":" => [ 7, \&_action_opcode_1713 ], },
	# [6557] opcode : sll "[" ix "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1714 ], ":" => [ 7, \&_action_opcode_1714 ], },
	# [6558] opcode : sll "[" ix "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1715 ], ":" => [ 7, \&_action_opcode_1715 ], },
	# [6559] opcode : sll "[" iy
	{ "+" => 6560, "-" => 6571, "]" => 6582, },
	# [6560] opcode : sll "[" iy "+"
	{ "!" => [ 12, 6561 ], "+" => [ 12, 6561 ], "-" => [ 12, 6561 ], __else__ => [ 12, 6561 ], "~" => [ 12, 6561 ], },
	# [6561] opcode : sll "[" iy "+" "[expr_DIS]"
	{ "]" => 6562, },
	# [6562] opcode : sll "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1732 ], "," => 6563, ":" => [ 7, \&_action_opcode_1732 ], },
	# [6563] opcode : sll "[" iy "+" "[expr_DIS]" "]" ","
	{ a => 6564, b => 6565, c => 6566, d => 6567, e => 6568, h => 6569, l => 6570, },
	# [6564] opcode : sll "[" iy "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1733 ], ":" => [ 7, \&_action_opcode_1733 ], },
	# [6565] opcode : sll "[" iy "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1734 ], ":" => [ 7, \&_action_opcode_1734 ], },
	# [6566] opcode : sll "[" iy "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1735 ], ":" => [ 7, \&_action_opcode_1735 ], },
	# [6567] opcode : sll "[" iy "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1736 ], ":" => [ 7, \&_action_opcode_1736 ], },
	# [6568] opcode : sll "[" iy "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1737 ], ":" => [ 7, \&_action_opcode_1737 ], },
	# [6569] opcode : sll "[" iy "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1738 ], ":" => [ 7, \&_action_opcode_1738 ], },
	# [6570] opcode : sll "[" iy "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1739 ], ":" => [ 7, \&_action_opcode_1739 ], },
	# [6571] opcode : sll "[" iy "-"
	{ "!" => [ 14, 6572 ], "+" => [ 14, 6572 ], "-" => [ 14, 6572 ], __else__ => [ 14, 6572 ], "~" => [ 14, 6572 ], },
	# [6572] opcode : sll "[" iy "-" "[expr_NDIS]"
	{ "]" => 6573, },
	# [6573] opcode : sll "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1732 ], "," => 6574, ":" => [ 7, \&_action_opcode_1732 ], },
	# [6574] opcode : sll "[" iy "-" "[expr_NDIS]" "]" ","
	{ a => 6575, b => 6576, c => 6577, d => 6578, e => 6579, h => 6580, l => 6581, },
	# [6575] opcode : sll "[" iy "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1733 ], ":" => [ 7, \&_action_opcode_1733 ], },
	# [6576] opcode : sll "[" iy "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1734 ], ":" => [ 7, \&_action_opcode_1734 ], },
	# [6577] opcode : sll "[" iy "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1735 ], ":" => [ 7, \&_action_opcode_1735 ], },
	# [6578] opcode : sll "[" iy "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1736 ], ":" => [ 7, \&_action_opcode_1736 ], },
	# [6579] opcode : sll "[" iy "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1737 ], ":" => [ 7, \&_action_opcode_1737 ], },
	# [6580] opcode : sll "[" iy "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1738 ], ":" => [ 7, \&_action_opcode_1738 ], },
	# [6581] opcode : sll "[" iy "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1739 ], ":" => [ 7, \&_action_opcode_1739 ], },
	# [6582] opcode : sll "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_1724 ], "," => 6583, ":" => [ 7, \&_action_opcode_1724 ], },
	# [6583] opcode : sll "[" iy "]" ","
	{ a => 6584, b => 6585, c => 6586, d => 6587, e => 6588, h => 6589, l => 6590, },
	# [6584] opcode : sll "[" iy "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1725 ], ":" => [ 7, \&_action_opcode_1725 ], },
	# [6585] opcode : sll "[" iy "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1726 ], ":" => [ 7, \&_action_opcode_1726 ], },
	# [6586] opcode : sll "[" iy "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1727 ], ":" => [ 7, \&_action_opcode_1727 ], },
	# [6587] opcode : sll "[" iy "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1728 ], ":" => [ 7, \&_action_opcode_1728 ], },
	# [6588] opcode : sll "[" iy "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1729 ], ":" => [ 7, \&_action_opcode_1729 ], },
	# [6589] opcode : sll "[" iy "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1730 ], ":" => [ 7, \&_action_opcode_1730 ], },
	# [6590] opcode : sll "[" iy "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1731 ], ":" => [ 7, \&_action_opcode_1731 ], },
	# [6591] opcode : sll a
	{ "\n" => [ 7, \&_action_opcode_1740 ], ":" => [ 7, \&_action_opcode_1740 ], },
	# [6592] opcode : sll b
	{ "\n" => [ 7, \&_action_opcode_1741 ], ":" => [ 7, \&_action_opcode_1741 ], },
	# [6593] opcode : sll bc
	{ "\n" => [ 7, \&_action_opcode_1742 ], ":" => [ 7, \&_action_opcode_1742 ], },
	# [6594] opcode : sll c
	{ "\n" => [ 7, \&_action_opcode_1743 ], ":" => [ 7, \&_action_opcode_1743 ], },
	# [6595] opcode : sll d
	{ "\n" => [ 7, \&_action_opcode_1744 ], ":" => [ 7, \&_action_opcode_1744 ], },
	# [6596] opcode : sll de
	{ "\n" => [ 7, \&_action_opcode_1745 ], ":" => [ 7, \&_action_opcode_1745 ], },
	# [6597] opcode : sll e
	{ "\n" => [ 7, \&_action_opcode_1746 ], ":" => [ 7, \&_action_opcode_1746 ], },
	# [6598] opcode : sll h
	{ "\n" => [ 7, \&_action_opcode_1747 ], ":" => [ 7, \&_action_opcode_1747 ], },
	# [6599] opcode : sll hl
	{ "\n" => [ 7, \&_action_opcode_1748 ], ":" => [ 7, \&_action_opcode_1748 ], },
	# [6600] opcode : sll l
	{ "\n" => [ 7, \&_action_opcode_1749 ], ":" => [ 7, \&_action_opcode_1749 ], },
	# [6601] opcode : sra
	{ "(" => 6602, "[" => 6669, a => 6736, b => 6737, bc => 6738, c => 6739, d => 6740, de => 6741, e => 6742, h => 6743, hl => 6744, l => 6745, },
	# [6602] opcode : sra "("
	{ hl => 6603, ix => 6605, iy => 6637, },
	# [6603] opcode : sra "(" hl
	{ ")" => 6604, },
	# [6604] opcode : sra "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_1750 ], ":" => [ 7, \&_action_opcode_1750 ], },
	# [6605] opcode : sra "(" ix
	{ ")" => 6606, "+" => 6615, "-" => 6626, },
	# [6606] opcode : sra "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_1751 ], "," => 6607, ":" => [ 7, \&_action_opcode_1751 ], },
	# [6607] opcode : sra "(" ix ")" ","
	{ a => 6608, b => 6609, c => 6610, d => 6611, e => 6612, h => 6613, l => 6614, },
	# [6608] opcode : sra "(" ix ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1752 ], ":" => [ 7, \&_action_opcode_1752 ], },
	# [6609] opcode : sra "(" ix ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1753 ], ":" => [ 7, \&_action_opcode_1753 ], },
	# [6610] opcode : sra "(" ix ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1754 ], ":" => [ 7, \&_action_opcode_1754 ], },
	# [6611] opcode : sra "(" ix ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1755 ], ":" => [ 7, \&_action_opcode_1755 ], },
	# [6612] opcode : sra "(" ix ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1756 ], ":" => [ 7, \&_action_opcode_1756 ], },
	# [6613] opcode : sra "(" ix ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1757 ], ":" => [ 7, \&_action_opcode_1757 ], },
	# [6614] opcode : sra "(" ix ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1758 ], ":" => [ 7, \&_action_opcode_1758 ], },
	# [6615] opcode : sra "(" ix "+"
	{ "!" => [ 12, 6616 ], "+" => [ 12, 6616 ], "-" => [ 12, 6616 ], __else__ => [ 12, 6616 ], "~" => [ 12, 6616 ], },
	# [6616] opcode : sra "(" ix "+" "[expr_DIS]"
	{ ")" => 6617, },
	# [6617] opcode : sra "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1759 ], "," => 6618, ":" => [ 7, \&_action_opcode_1759 ], },
	# [6618] opcode : sra "(" ix "+" "[expr_DIS]" ")" ","
	{ a => 6619, b => 6620, c => 6621, d => 6622, e => 6623, h => 6624, l => 6625, },
	# [6619] opcode : sra "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1760 ], ":" => [ 7, \&_action_opcode_1760 ], },
	# [6620] opcode : sra "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1761 ], ":" => [ 7, \&_action_opcode_1761 ], },
	# [6621] opcode : sra "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1762 ], ":" => [ 7, \&_action_opcode_1762 ], },
	# [6622] opcode : sra "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1763 ], ":" => [ 7, \&_action_opcode_1763 ], },
	# [6623] opcode : sra "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1764 ], ":" => [ 7, \&_action_opcode_1764 ], },
	# [6624] opcode : sra "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1765 ], ":" => [ 7, \&_action_opcode_1765 ], },
	# [6625] opcode : sra "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1766 ], ":" => [ 7, \&_action_opcode_1766 ], },
	# [6626] opcode : sra "(" ix "-"
	{ "!" => [ 14, 6627 ], "+" => [ 14, 6627 ], "-" => [ 14, 6627 ], __else__ => [ 14, 6627 ], "~" => [ 14, 6627 ], },
	# [6627] opcode : sra "(" ix "-" "[expr_NDIS]"
	{ ")" => 6628, },
	# [6628] opcode : sra "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1759 ], "," => 6629, ":" => [ 7, \&_action_opcode_1759 ], },
	# [6629] opcode : sra "(" ix "-" "[expr_NDIS]" ")" ","
	{ a => 6630, b => 6631, c => 6632, d => 6633, e => 6634, h => 6635, l => 6636, },
	# [6630] opcode : sra "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1760 ], ":" => [ 7, \&_action_opcode_1760 ], },
	# [6631] opcode : sra "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1761 ], ":" => [ 7, \&_action_opcode_1761 ], },
	# [6632] opcode : sra "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1762 ], ":" => [ 7, \&_action_opcode_1762 ], },
	# [6633] opcode : sra "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1763 ], ":" => [ 7, \&_action_opcode_1763 ], },
	# [6634] opcode : sra "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1764 ], ":" => [ 7, \&_action_opcode_1764 ], },
	# [6635] opcode : sra "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1765 ], ":" => [ 7, \&_action_opcode_1765 ], },
	# [6636] opcode : sra "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1766 ], ":" => [ 7, \&_action_opcode_1766 ], },
	# [6637] opcode : sra "(" iy
	{ ")" => 6638, "+" => 6647, "-" => 6658, },
	# [6638] opcode : sra "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_1767 ], "," => 6639, ":" => [ 7, \&_action_opcode_1767 ], },
	# [6639] opcode : sra "(" iy ")" ","
	{ a => 6640, b => 6641, c => 6642, d => 6643, e => 6644, h => 6645, l => 6646, },
	# [6640] opcode : sra "(" iy ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1768 ], ":" => [ 7, \&_action_opcode_1768 ], },
	# [6641] opcode : sra "(" iy ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1769 ], ":" => [ 7, \&_action_opcode_1769 ], },
	# [6642] opcode : sra "(" iy ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1770 ], ":" => [ 7, \&_action_opcode_1770 ], },
	# [6643] opcode : sra "(" iy ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1771 ], ":" => [ 7, \&_action_opcode_1771 ], },
	# [6644] opcode : sra "(" iy ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1772 ], ":" => [ 7, \&_action_opcode_1772 ], },
	# [6645] opcode : sra "(" iy ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1773 ], ":" => [ 7, \&_action_opcode_1773 ], },
	# [6646] opcode : sra "(" iy ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1774 ], ":" => [ 7, \&_action_opcode_1774 ], },
	# [6647] opcode : sra "(" iy "+"
	{ "!" => [ 12, 6648 ], "+" => [ 12, 6648 ], "-" => [ 12, 6648 ], __else__ => [ 12, 6648 ], "~" => [ 12, 6648 ], },
	# [6648] opcode : sra "(" iy "+" "[expr_DIS]"
	{ ")" => 6649, },
	# [6649] opcode : sra "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1775 ], "," => 6650, ":" => [ 7, \&_action_opcode_1775 ], },
	# [6650] opcode : sra "(" iy "+" "[expr_DIS]" ")" ","
	{ a => 6651, b => 6652, c => 6653, d => 6654, e => 6655, h => 6656, l => 6657, },
	# [6651] opcode : sra "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1776 ], ":" => [ 7, \&_action_opcode_1776 ], },
	# [6652] opcode : sra "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1777 ], ":" => [ 7, \&_action_opcode_1777 ], },
	# [6653] opcode : sra "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1778 ], ":" => [ 7, \&_action_opcode_1778 ], },
	# [6654] opcode : sra "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1779 ], ":" => [ 7, \&_action_opcode_1779 ], },
	# [6655] opcode : sra "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1780 ], ":" => [ 7, \&_action_opcode_1780 ], },
	# [6656] opcode : sra "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1781 ], ":" => [ 7, \&_action_opcode_1781 ], },
	# [6657] opcode : sra "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1782 ], ":" => [ 7, \&_action_opcode_1782 ], },
	# [6658] opcode : sra "(" iy "-"
	{ "!" => [ 14, 6659 ], "+" => [ 14, 6659 ], "-" => [ 14, 6659 ], __else__ => [ 14, 6659 ], "~" => [ 14, 6659 ], },
	# [6659] opcode : sra "(" iy "-" "[expr_NDIS]"
	{ ")" => 6660, },
	# [6660] opcode : sra "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1775 ], "," => 6661, ":" => [ 7, \&_action_opcode_1775 ], },
	# [6661] opcode : sra "(" iy "-" "[expr_NDIS]" ")" ","
	{ a => 6662, b => 6663, c => 6664, d => 6665, e => 6666, h => 6667, l => 6668, },
	# [6662] opcode : sra "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1776 ], ":" => [ 7, \&_action_opcode_1776 ], },
	# [6663] opcode : sra "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1777 ], ":" => [ 7, \&_action_opcode_1777 ], },
	# [6664] opcode : sra "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1778 ], ":" => [ 7, \&_action_opcode_1778 ], },
	# [6665] opcode : sra "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1779 ], ":" => [ 7, \&_action_opcode_1779 ], },
	# [6666] opcode : sra "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1780 ], ":" => [ 7, \&_action_opcode_1780 ], },
	# [6667] opcode : sra "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1781 ], ":" => [ 7, \&_action_opcode_1781 ], },
	# [6668] opcode : sra "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1782 ], ":" => [ 7, \&_action_opcode_1782 ], },
	# [6669] opcode : sra "["
	{ hl => 6670, ix => 6672, iy => 6704, },
	# [6670] opcode : sra "[" hl
	{ "]" => 6671, },
	# [6671] opcode : sra "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_1750 ], ":" => [ 7, \&_action_opcode_1750 ], },
	# [6672] opcode : sra "[" ix
	{ "+" => 6673, "-" => 6684, "]" => 6695, },
	# [6673] opcode : sra "[" ix "+"
	{ "!" => [ 12, 6674 ], "+" => [ 12, 6674 ], "-" => [ 12, 6674 ], __else__ => [ 12, 6674 ], "~" => [ 12, 6674 ], },
	# [6674] opcode : sra "[" ix "+" "[expr_DIS]"
	{ "]" => 6675, },
	# [6675] opcode : sra "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1759 ], "," => 6676, ":" => [ 7, \&_action_opcode_1759 ], },
	# [6676] opcode : sra "[" ix "+" "[expr_DIS]" "]" ","
	{ a => 6677, b => 6678, c => 6679, d => 6680, e => 6681, h => 6682, l => 6683, },
	# [6677] opcode : sra "[" ix "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1760 ], ":" => [ 7, \&_action_opcode_1760 ], },
	# [6678] opcode : sra "[" ix "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1761 ], ":" => [ 7, \&_action_opcode_1761 ], },
	# [6679] opcode : sra "[" ix "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1762 ], ":" => [ 7, \&_action_opcode_1762 ], },
	# [6680] opcode : sra "[" ix "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1763 ], ":" => [ 7, \&_action_opcode_1763 ], },
	# [6681] opcode : sra "[" ix "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1764 ], ":" => [ 7, \&_action_opcode_1764 ], },
	# [6682] opcode : sra "[" ix "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1765 ], ":" => [ 7, \&_action_opcode_1765 ], },
	# [6683] opcode : sra "[" ix "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1766 ], ":" => [ 7, \&_action_opcode_1766 ], },
	# [6684] opcode : sra "[" ix "-"
	{ "!" => [ 14, 6685 ], "+" => [ 14, 6685 ], "-" => [ 14, 6685 ], __else__ => [ 14, 6685 ], "~" => [ 14, 6685 ], },
	# [6685] opcode : sra "[" ix "-" "[expr_NDIS]"
	{ "]" => 6686, },
	# [6686] opcode : sra "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1759 ], "," => 6687, ":" => [ 7, \&_action_opcode_1759 ], },
	# [6687] opcode : sra "[" ix "-" "[expr_NDIS]" "]" ","
	{ a => 6688, b => 6689, c => 6690, d => 6691, e => 6692, h => 6693, l => 6694, },
	# [6688] opcode : sra "[" ix "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1760 ], ":" => [ 7, \&_action_opcode_1760 ], },
	# [6689] opcode : sra "[" ix "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1761 ], ":" => [ 7, \&_action_opcode_1761 ], },
	# [6690] opcode : sra "[" ix "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1762 ], ":" => [ 7, \&_action_opcode_1762 ], },
	# [6691] opcode : sra "[" ix "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1763 ], ":" => [ 7, \&_action_opcode_1763 ], },
	# [6692] opcode : sra "[" ix "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1764 ], ":" => [ 7, \&_action_opcode_1764 ], },
	# [6693] opcode : sra "[" ix "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1765 ], ":" => [ 7, \&_action_opcode_1765 ], },
	# [6694] opcode : sra "[" ix "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1766 ], ":" => [ 7, \&_action_opcode_1766 ], },
	# [6695] opcode : sra "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_1751 ], "," => 6696, ":" => [ 7, \&_action_opcode_1751 ], },
	# [6696] opcode : sra "[" ix "]" ","
	{ a => 6697, b => 6698, c => 6699, d => 6700, e => 6701, h => 6702, l => 6703, },
	# [6697] opcode : sra "[" ix "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1752 ], ":" => [ 7, \&_action_opcode_1752 ], },
	# [6698] opcode : sra "[" ix "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1753 ], ":" => [ 7, \&_action_opcode_1753 ], },
	# [6699] opcode : sra "[" ix "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1754 ], ":" => [ 7, \&_action_opcode_1754 ], },
	# [6700] opcode : sra "[" ix "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1755 ], ":" => [ 7, \&_action_opcode_1755 ], },
	# [6701] opcode : sra "[" ix "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1756 ], ":" => [ 7, \&_action_opcode_1756 ], },
	# [6702] opcode : sra "[" ix "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1757 ], ":" => [ 7, \&_action_opcode_1757 ], },
	# [6703] opcode : sra "[" ix "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1758 ], ":" => [ 7, \&_action_opcode_1758 ], },
	# [6704] opcode : sra "[" iy
	{ "+" => 6705, "-" => 6716, "]" => 6727, },
	# [6705] opcode : sra "[" iy "+"
	{ "!" => [ 12, 6706 ], "+" => [ 12, 6706 ], "-" => [ 12, 6706 ], __else__ => [ 12, 6706 ], "~" => [ 12, 6706 ], },
	# [6706] opcode : sra "[" iy "+" "[expr_DIS]"
	{ "]" => 6707, },
	# [6707] opcode : sra "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1775 ], "," => 6708, ":" => [ 7, \&_action_opcode_1775 ], },
	# [6708] opcode : sra "[" iy "+" "[expr_DIS]" "]" ","
	{ a => 6709, b => 6710, c => 6711, d => 6712, e => 6713, h => 6714, l => 6715, },
	# [6709] opcode : sra "[" iy "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1776 ], ":" => [ 7, \&_action_opcode_1776 ], },
	# [6710] opcode : sra "[" iy "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1777 ], ":" => [ 7, \&_action_opcode_1777 ], },
	# [6711] opcode : sra "[" iy "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1778 ], ":" => [ 7, \&_action_opcode_1778 ], },
	# [6712] opcode : sra "[" iy "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1779 ], ":" => [ 7, \&_action_opcode_1779 ], },
	# [6713] opcode : sra "[" iy "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1780 ], ":" => [ 7, \&_action_opcode_1780 ], },
	# [6714] opcode : sra "[" iy "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1781 ], ":" => [ 7, \&_action_opcode_1781 ], },
	# [6715] opcode : sra "[" iy "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1782 ], ":" => [ 7, \&_action_opcode_1782 ], },
	# [6716] opcode : sra "[" iy "-"
	{ "!" => [ 14, 6717 ], "+" => [ 14, 6717 ], "-" => [ 14, 6717 ], __else__ => [ 14, 6717 ], "~" => [ 14, 6717 ], },
	# [6717] opcode : sra "[" iy "-" "[expr_NDIS]"
	{ "]" => 6718, },
	# [6718] opcode : sra "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1775 ], "," => 6719, ":" => [ 7, \&_action_opcode_1775 ], },
	# [6719] opcode : sra "[" iy "-" "[expr_NDIS]" "]" ","
	{ a => 6720, b => 6721, c => 6722, d => 6723, e => 6724, h => 6725, l => 6726, },
	# [6720] opcode : sra "[" iy "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1776 ], ":" => [ 7, \&_action_opcode_1776 ], },
	# [6721] opcode : sra "[" iy "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1777 ], ":" => [ 7, \&_action_opcode_1777 ], },
	# [6722] opcode : sra "[" iy "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1778 ], ":" => [ 7, \&_action_opcode_1778 ], },
	# [6723] opcode : sra "[" iy "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1779 ], ":" => [ 7, \&_action_opcode_1779 ], },
	# [6724] opcode : sra "[" iy "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1780 ], ":" => [ 7, \&_action_opcode_1780 ], },
	# [6725] opcode : sra "[" iy "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1781 ], ":" => [ 7, \&_action_opcode_1781 ], },
	# [6726] opcode : sra "[" iy "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1782 ], ":" => [ 7, \&_action_opcode_1782 ], },
	# [6727] opcode : sra "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_1767 ], "," => 6728, ":" => [ 7, \&_action_opcode_1767 ], },
	# [6728] opcode : sra "[" iy "]" ","
	{ a => 6729, b => 6730, c => 6731, d => 6732, e => 6733, h => 6734, l => 6735, },
	# [6729] opcode : sra "[" iy "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1768 ], ":" => [ 7, \&_action_opcode_1768 ], },
	# [6730] opcode : sra "[" iy "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1769 ], ":" => [ 7, \&_action_opcode_1769 ], },
	# [6731] opcode : sra "[" iy "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1770 ], ":" => [ 7, \&_action_opcode_1770 ], },
	# [6732] opcode : sra "[" iy "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1771 ], ":" => [ 7, \&_action_opcode_1771 ], },
	# [6733] opcode : sra "[" iy "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1772 ], ":" => [ 7, \&_action_opcode_1772 ], },
	# [6734] opcode : sra "[" iy "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1773 ], ":" => [ 7, \&_action_opcode_1773 ], },
	# [6735] opcode : sra "[" iy "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1774 ], ":" => [ 7, \&_action_opcode_1774 ], },
	# [6736] opcode : sra a
	{ "\n" => [ 7, \&_action_opcode_1783 ], ":" => [ 7, \&_action_opcode_1783 ], },
	# [6737] opcode : sra b
	{ "\n" => [ 7, \&_action_opcode_1784 ], ":" => [ 7, \&_action_opcode_1784 ], },
	# [6738] opcode : sra bc
	{ "\n" => [ 7, \&_action_opcode_1785 ], ":" => [ 7, \&_action_opcode_1785 ], },
	# [6739] opcode : sra c
	{ "\n" => [ 7, \&_action_opcode_1786 ], ":" => [ 7, \&_action_opcode_1786 ], },
	# [6740] opcode : sra d
	{ "\n" => [ 7, \&_action_opcode_1787 ], ":" => [ 7, \&_action_opcode_1787 ], },
	# [6741] opcode : sra de
	{ "\n" => [ 7, \&_action_opcode_1788 ], ":" => [ 7, \&_action_opcode_1788 ], },
	# [6742] opcode : sra e
	{ "\n" => [ 7, \&_action_opcode_1789 ], ":" => [ 7, \&_action_opcode_1789 ], },
	# [6743] opcode : sra h
	{ "\n" => [ 7, \&_action_opcode_1790 ], ":" => [ 7, \&_action_opcode_1790 ], },
	# [6744] opcode : sra hl
	{ "\n" => [ 7, \&_action_opcode_1791 ], ":" => [ 7, \&_action_opcode_1791 ], },
	# [6745] opcode : sra l
	{ "\n" => [ 7, \&_action_opcode_1792 ], ":" => [ 7, \&_action_opcode_1792 ], },
	# [6746] opcode : srl
	{ "(" => 6747, "[" => 6814, a => 6881, b => 6882, bc => 6883, c => 6884, d => 6885, de => 6886, e => 6887, h => 6888, hl => 6889, l => 6890, },
	# [6747] opcode : srl "("
	{ hl => 6748, ix => 6750, iy => 6782, },
	# [6748] opcode : srl "(" hl
	{ ")" => 6749, },
	# [6749] opcode : srl "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_1793 ], ":" => [ 7, \&_action_opcode_1793 ], },
	# [6750] opcode : srl "(" ix
	{ ")" => 6751, "+" => 6760, "-" => 6771, },
	# [6751] opcode : srl "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_1794 ], "," => 6752, ":" => [ 7, \&_action_opcode_1794 ], },
	# [6752] opcode : srl "(" ix ")" ","
	{ a => 6753, b => 6754, c => 6755, d => 6756, e => 6757, h => 6758, l => 6759, },
	# [6753] opcode : srl "(" ix ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1795 ], ":" => [ 7, \&_action_opcode_1795 ], },
	# [6754] opcode : srl "(" ix ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1796 ], ":" => [ 7, \&_action_opcode_1796 ], },
	# [6755] opcode : srl "(" ix ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1797 ], ":" => [ 7, \&_action_opcode_1797 ], },
	# [6756] opcode : srl "(" ix ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1798 ], ":" => [ 7, \&_action_opcode_1798 ], },
	# [6757] opcode : srl "(" ix ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1799 ], ":" => [ 7, \&_action_opcode_1799 ], },
	# [6758] opcode : srl "(" ix ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1800 ], ":" => [ 7, \&_action_opcode_1800 ], },
	# [6759] opcode : srl "(" ix ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1801 ], ":" => [ 7, \&_action_opcode_1801 ], },
	# [6760] opcode : srl "(" ix "+"
	{ "!" => [ 12, 6761 ], "+" => [ 12, 6761 ], "-" => [ 12, 6761 ], __else__ => [ 12, 6761 ], "~" => [ 12, 6761 ], },
	# [6761] opcode : srl "(" ix "+" "[expr_DIS]"
	{ ")" => 6762, },
	# [6762] opcode : srl "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1802 ], "," => 6763, ":" => [ 7, \&_action_opcode_1802 ], },
	# [6763] opcode : srl "(" ix "+" "[expr_DIS]" ")" ","
	{ a => 6764, b => 6765, c => 6766, d => 6767, e => 6768, h => 6769, l => 6770, },
	# [6764] opcode : srl "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1803 ], ":" => [ 7, \&_action_opcode_1803 ], },
	# [6765] opcode : srl "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1804 ], ":" => [ 7, \&_action_opcode_1804 ], },
	# [6766] opcode : srl "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1805 ], ":" => [ 7, \&_action_opcode_1805 ], },
	# [6767] opcode : srl "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1806 ], ":" => [ 7, \&_action_opcode_1806 ], },
	# [6768] opcode : srl "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1807 ], ":" => [ 7, \&_action_opcode_1807 ], },
	# [6769] opcode : srl "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1808 ], ":" => [ 7, \&_action_opcode_1808 ], },
	# [6770] opcode : srl "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1809 ], ":" => [ 7, \&_action_opcode_1809 ], },
	# [6771] opcode : srl "(" ix "-"
	{ "!" => [ 14, 6772 ], "+" => [ 14, 6772 ], "-" => [ 14, 6772 ], __else__ => [ 14, 6772 ], "~" => [ 14, 6772 ], },
	# [6772] opcode : srl "(" ix "-" "[expr_NDIS]"
	{ ")" => 6773, },
	# [6773] opcode : srl "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1802 ], "," => 6774, ":" => [ 7, \&_action_opcode_1802 ], },
	# [6774] opcode : srl "(" ix "-" "[expr_NDIS]" ")" ","
	{ a => 6775, b => 6776, c => 6777, d => 6778, e => 6779, h => 6780, l => 6781, },
	# [6775] opcode : srl "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1803 ], ":" => [ 7, \&_action_opcode_1803 ], },
	# [6776] opcode : srl "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1804 ], ":" => [ 7, \&_action_opcode_1804 ], },
	# [6777] opcode : srl "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1805 ], ":" => [ 7, \&_action_opcode_1805 ], },
	# [6778] opcode : srl "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1806 ], ":" => [ 7, \&_action_opcode_1806 ], },
	# [6779] opcode : srl "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1807 ], ":" => [ 7, \&_action_opcode_1807 ], },
	# [6780] opcode : srl "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1808 ], ":" => [ 7, \&_action_opcode_1808 ], },
	# [6781] opcode : srl "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1809 ], ":" => [ 7, \&_action_opcode_1809 ], },
	# [6782] opcode : srl "(" iy
	{ ")" => 6783, "+" => 6792, "-" => 6803, },
	# [6783] opcode : srl "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_1810 ], "," => 6784, ":" => [ 7, \&_action_opcode_1810 ], },
	# [6784] opcode : srl "(" iy ")" ","
	{ a => 6785, b => 6786, c => 6787, d => 6788, e => 6789, h => 6790, l => 6791, },
	# [6785] opcode : srl "(" iy ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1811 ], ":" => [ 7, \&_action_opcode_1811 ], },
	# [6786] opcode : srl "(" iy ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1812 ], ":" => [ 7, \&_action_opcode_1812 ], },
	# [6787] opcode : srl "(" iy ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1813 ], ":" => [ 7, \&_action_opcode_1813 ], },
	# [6788] opcode : srl "(" iy ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1814 ], ":" => [ 7, \&_action_opcode_1814 ], },
	# [6789] opcode : srl "(" iy ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1815 ], ":" => [ 7, \&_action_opcode_1815 ], },
	# [6790] opcode : srl "(" iy ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1816 ], ":" => [ 7, \&_action_opcode_1816 ], },
	# [6791] opcode : srl "(" iy ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1817 ], ":" => [ 7, \&_action_opcode_1817 ], },
	# [6792] opcode : srl "(" iy "+"
	{ "!" => [ 12, 6793 ], "+" => [ 12, 6793 ], "-" => [ 12, 6793 ], __else__ => [ 12, 6793 ], "~" => [ 12, 6793 ], },
	# [6793] opcode : srl "(" iy "+" "[expr_DIS]"
	{ ")" => 6794, },
	# [6794] opcode : srl "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1818 ], "," => 6795, ":" => [ 7, \&_action_opcode_1818 ], },
	# [6795] opcode : srl "(" iy "+" "[expr_DIS]" ")" ","
	{ a => 6796, b => 6797, c => 6798, d => 6799, e => 6800, h => 6801, l => 6802, },
	# [6796] opcode : srl "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1819 ], ":" => [ 7, \&_action_opcode_1819 ], },
	# [6797] opcode : srl "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1820 ], ":" => [ 7, \&_action_opcode_1820 ], },
	# [6798] opcode : srl "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1821 ], ":" => [ 7, \&_action_opcode_1821 ], },
	# [6799] opcode : srl "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1822 ], ":" => [ 7, \&_action_opcode_1822 ], },
	# [6800] opcode : srl "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1823 ], ":" => [ 7, \&_action_opcode_1823 ], },
	# [6801] opcode : srl "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1824 ], ":" => [ 7, \&_action_opcode_1824 ], },
	# [6802] opcode : srl "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1825 ], ":" => [ 7, \&_action_opcode_1825 ], },
	# [6803] opcode : srl "(" iy "-"
	{ "!" => [ 14, 6804 ], "+" => [ 14, 6804 ], "-" => [ 14, 6804 ], __else__ => [ 14, 6804 ], "~" => [ 14, 6804 ], },
	# [6804] opcode : srl "(" iy "-" "[expr_NDIS]"
	{ ")" => 6805, },
	# [6805] opcode : srl "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1818 ], "," => 6806, ":" => [ 7, \&_action_opcode_1818 ], },
	# [6806] opcode : srl "(" iy "-" "[expr_NDIS]" ")" ","
	{ a => 6807, b => 6808, c => 6809, d => 6810, e => 6811, h => 6812, l => 6813, },
	# [6807] opcode : srl "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 7, \&_action_opcode_1819 ], ":" => [ 7, \&_action_opcode_1819 ], },
	# [6808] opcode : srl "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 7, \&_action_opcode_1820 ], ":" => [ 7, \&_action_opcode_1820 ], },
	# [6809] opcode : srl "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 7, \&_action_opcode_1821 ], ":" => [ 7, \&_action_opcode_1821 ], },
	# [6810] opcode : srl "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 7, \&_action_opcode_1822 ], ":" => [ 7, \&_action_opcode_1822 ], },
	# [6811] opcode : srl "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 7, \&_action_opcode_1823 ], ":" => [ 7, \&_action_opcode_1823 ], },
	# [6812] opcode : srl "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 7, \&_action_opcode_1824 ], ":" => [ 7, \&_action_opcode_1824 ], },
	# [6813] opcode : srl "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 7, \&_action_opcode_1825 ], ":" => [ 7, \&_action_opcode_1825 ], },
	# [6814] opcode : srl "["
	{ hl => 6815, ix => 6817, iy => 6849, },
	# [6815] opcode : srl "[" hl
	{ "]" => 6816, },
	# [6816] opcode : srl "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_1793 ], ":" => [ 7, \&_action_opcode_1793 ], },
	# [6817] opcode : srl "[" ix
	{ "+" => 6818, "-" => 6829, "]" => 6840, },
	# [6818] opcode : srl "[" ix "+"
	{ "!" => [ 12, 6819 ], "+" => [ 12, 6819 ], "-" => [ 12, 6819 ], __else__ => [ 12, 6819 ], "~" => [ 12, 6819 ], },
	# [6819] opcode : srl "[" ix "+" "[expr_DIS]"
	{ "]" => 6820, },
	# [6820] opcode : srl "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1802 ], "," => 6821, ":" => [ 7, \&_action_opcode_1802 ], },
	# [6821] opcode : srl "[" ix "+" "[expr_DIS]" "]" ","
	{ a => 6822, b => 6823, c => 6824, d => 6825, e => 6826, h => 6827, l => 6828, },
	# [6822] opcode : srl "[" ix "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1803 ], ":" => [ 7, \&_action_opcode_1803 ], },
	# [6823] opcode : srl "[" ix "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1804 ], ":" => [ 7, \&_action_opcode_1804 ], },
	# [6824] opcode : srl "[" ix "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1805 ], ":" => [ 7, \&_action_opcode_1805 ], },
	# [6825] opcode : srl "[" ix "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1806 ], ":" => [ 7, \&_action_opcode_1806 ], },
	# [6826] opcode : srl "[" ix "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1807 ], ":" => [ 7, \&_action_opcode_1807 ], },
	# [6827] opcode : srl "[" ix "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1808 ], ":" => [ 7, \&_action_opcode_1808 ], },
	# [6828] opcode : srl "[" ix "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1809 ], ":" => [ 7, \&_action_opcode_1809 ], },
	# [6829] opcode : srl "[" ix "-"
	{ "!" => [ 14, 6830 ], "+" => [ 14, 6830 ], "-" => [ 14, 6830 ], __else__ => [ 14, 6830 ], "~" => [ 14, 6830 ], },
	# [6830] opcode : srl "[" ix "-" "[expr_NDIS]"
	{ "]" => 6831, },
	# [6831] opcode : srl "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1802 ], "," => 6832, ":" => [ 7, \&_action_opcode_1802 ], },
	# [6832] opcode : srl "[" ix "-" "[expr_NDIS]" "]" ","
	{ a => 6833, b => 6834, c => 6835, d => 6836, e => 6837, h => 6838, l => 6839, },
	# [6833] opcode : srl "[" ix "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1803 ], ":" => [ 7, \&_action_opcode_1803 ], },
	# [6834] opcode : srl "[" ix "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1804 ], ":" => [ 7, \&_action_opcode_1804 ], },
	# [6835] opcode : srl "[" ix "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1805 ], ":" => [ 7, \&_action_opcode_1805 ], },
	# [6836] opcode : srl "[" ix "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1806 ], ":" => [ 7, \&_action_opcode_1806 ], },
	# [6837] opcode : srl "[" ix "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1807 ], ":" => [ 7, \&_action_opcode_1807 ], },
	# [6838] opcode : srl "[" ix "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1808 ], ":" => [ 7, \&_action_opcode_1808 ], },
	# [6839] opcode : srl "[" ix "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1809 ], ":" => [ 7, \&_action_opcode_1809 ], },
	# [6840] opcode : srl "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_1794 ], "," => 6841, ":" => [ 7, \&_action_opcode_1794 ], },
	# [6841] opcode : srl "[" ix "]" ","
	{ a => 6842, b => 6843, c => 6844, d => 6845, e => 6846, h => 6847, l => 6848, },
	# [6842] opcode : srl "[" ix "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1795 ], ":" => [ 7, \&_action_opcode_1795 ], },
	# [6843] opcode : srl "[" ix "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1796 ], ":" => [ 7, \&_action_opcode_1796 ], },
	# [6844] opcode : srl "[" ix "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1797 ], ":" => [ 7, \&_action_opcode_1797 ], },
	# [6845] opcode : srl "[" ix "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1798 ], ":" => [ 7, \&_action_opcode_1798 ], },
	# [6846] opcode : srl "[" ix "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1799 ], ":" => [ 7, \&_action_opcode_1799 ], },
	# [6847] opcode : srl "[" ix "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1800 ], ":" => [ 7, \&_action_opcode_1800 ], },
	# [6848] opcode : srl "[" ix "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1801 ], ":" => [ 7, \&_action_opcode_1801 ], },
	# [6849] opcode : srl "[" iy
	{ "+" => 6850, "-" => 6861, "]" => 6872, },
	# [6850] opcode : srl "[" iy "+"
	{ "!" => [ 12, 6851 ], "+" => [ 12, 6851 ], "-" => [ 12, 6851 ], __else__ => [ 12, 6851 ], "~" => [ 12, 6851 ], },
	# [6851] opcode : srl "[" iy "+" "[expr_DIS]"
	{ "]" => 6852, },
	# [6852] opcode : srl "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1818 ], "," => 6853, ":" => [ 7, \&_action_opcode_1818 ], },
	# [6853] opcode : srl "[" iy "+" "[expr_DIS]" "]" ","
	{ a => 6854, b => 6855, c => 6856, d => 6857, e => 6858, h => 6859, l => 6860, },
	# [6854] opcode : srl "[" iy "+" "[expr_DIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1819 ], ":" => [ 7, \&_action_opcode_1819 ], },
	# [6855] opcode : srl "[" iy "+" "[expr_DIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1820 ], ":" => [ 7, \&_action_opcode_1820 ], },
	# [6856] opcode : srl "[" iy "+" "[expr_DIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1821 ], ":" => [ 7, \&_action_opcode_1821 ], },
	# [6857] opcode : srl "[" iy "+" "[expr_DIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1822 ], ":" => [ 7, \&_action_opcode_1822 ], },
	# [6858] opcode : srl "[" iy "+" "[expr_DIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1823 ], ":" => [ 7, \&_action_opcode_1823 ], },
	# [6859] opcode : srl "[" iy "+" "[expr_DIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1824 ], ":" => [ 7, \&_action_opcode_1824 ], },
	# [6860] opcode : srl "[" iy "+" "[expr_DIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1825 ], ":" => [ 7, \&_action_opcode_1825 ], },
	# [6861] opcode : srl "[" iy "-"
	{ "!" => [ 14, 6862 ], "+" => [ 14, 6862 ], "-" => [ 14, 6862 ], __else__ => [ 14, 6862 ], "~" => [ 14, 6862 ], },
	# [6862] opcode : srl "[" iy "-" "[expr_NDIS]"
	{ "]" => 6863, },
	# [6863] opcode : srl "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1818 ], "," => 6864, ":" => [ 7, \&_action_opcode_1818 ], },
	# [6864] opcode : srl "[" iy "-" "[expr_NDIS]" "]" ","
	{ a => 6865, b => 6866, c => 6867, d => 6868, e => 6869, h => 6870, l => 6871, },
	# [6865] opcode : srl "[" iy "-" "[expr_NDIS]" "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1819 ], ":" => [ 7, \&_action_opcode_1819 ], },
	# [6866] opcode : srl "[" iy "-" "[expr_NDIS]" "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1820 ], ":" => [ 7, \&_action_opcode_1820 ], },
	# [6867] opcode : srl "[" iy "-" "[expr_NDIS]" "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1821 ], ":" => [ 7, \&_action_opcode_1821 ], },
	# [6868] opcode : srl "[" iy "-" "[expr_NDIS]" "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1822 ], ":" => [ 7, \&_action_opcode_1822 ], },
	# [6869] opcode : srl "[" iy "-" "[expr_NDIS]" "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1823 ], ":" => [ 7, \&_action_opcode_1823 ], },
	# [6870] opcode : srl "[" iy "-" "[expr_NDIS]" "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1824 ], ":" => [ 7, \&_action_opcode_1824 ], },
	# [6871] opcode : srl "[" iy "-" "[expr_NDIS]" "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1825 ], ":" => [ 7, \&_action_opcode_1825 ], },
	# [6872] opcode : srl "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_1810 ], "," => 6873, ":" => [ 7, \&_action_opcode_1810 ], },
	# [6873] opcode : srl "[" iy "]" ","
	{ a => 6874, b => 6875, c => 6876, d => 6877, e => 6878, h => 6879, l => 6880, },
	# [6874] opcode : srl "[" iy "]" "," a
	{ "\n" => [ 7, \&_action_opcode_1811 ], ":" => [ 7, \&_action_opcode_1811 ], },
	# [6875] opcode : srl "[" iy "]" "," b
	{ "\n" => [ 7, \&_action_opcode_1812 ], ":" => [ 7, \&_action_opcode_1812 ], },
	# [6876] opcode : srl "[" iy "]" "," c
	{ "\n" => [ 7, \&_action_opcode_1813 ], ":" => [ 7, \&_action_opcode_1813 ], },
	# [6877] opcode : srl "[" iy "]" "," d
	{ "\n" => [ 7, \&_action_opcode_1814 ], ":" => [ 7, \&_action_opcode_1814 ], },
	# [6878] opcode : srl "[" iy "]" "," e
	{ "\n" => [ 7, \&_action_opcode_1815 ], ":" => [ 7, \&_action_opcode_1815 ], },
	# [6879] opcode : srl "[" iy "]" "," h
	{ "\n" => [ 7, \&_action_opcode_1816 ], ":" => [ 7, \&_action_opcode_1816 ], },
	# [6880] opcode : srl "[" iy "]" "," l
	{ "\n" => [ 7, \&_action_opcode_1817 ], ":" => [ 7, \&_action_opcode_1817 ], },
	# [6881] opcode : srl a
	{ "\n" => [ 7, \&_action_opcode_1826 ], ":" => [ 7, \&_action_opcode_1826 ], },
	# [6882] opcode : srl b
	{ "\n" => [ 7, \&_action_opcode_1827 ], ":" => [ 7, \&_action_opcode_1827 ], },
	# [6883] opcode : srl bc
	{ "\n" => [ 7, \&_action_opcode_1828 ], ":" => [ 7, \&_action_opcode_1828 ], },
	# [6884] opcode : srl c
	{ "\n" => [ 7, \&_action_opcode_1829 ], ":" => [ 7, \&_action_opcode_1829 ], },
	# [6885] opcode : srl d
	{ "\n" => [ 7, \&_action_opcode_1830 ], ":" => [ 7, \&_action_opcode_1830 ], },
	# [6886] opcode : srl de
	{ "\n" => [ 7, \&_action_opcode_1831 ], ":" => [ 7, \&_action_opcode_1831 ], },
	# [6887] opcode : srl e
	{ "\n" => [ 7, \&_action_opcode_1832 ], ":" => [ 7, \&_action_opcode_1832 ], },
	# [6888] opcode : srl h
	{ "\n" => [ 7, \&_action_opcode_1833 ], ":" => [ 7, \&_action_opcode_1833 ], },
	# [6889] opcode : srl hl
	{ "\n" => [ 7, \&_action_opcode_1834 ], ":" => [ 7, \&_action_opcode_1834 ], },
	# [6890] opcode : srl l
	{ "\n" => [ 7, \&_action_opcode_1835 ], ":" => [ 7, \&_action_opcode_1835 ], },
	# [6891] opcode : stop
	{ "\n" => [ 7, \&_action_opcode_1836 ], ":" => [ 7, \&_action_opcode_1836 ], },
	# [6892] opcode : sub
	{ "!" => [ 13, 6931 ], "(" => 6893, "+" => [ 13, 6931 ], "-" => [ 13, 6931 ], "[" => 6912, __else__ => [ 13, 6931 ], a => 6932, b => 6933, c => 6934, d => 6935, e => 6936, h => 6937, hl => 6938, hx => 6944, hy => 6945, ixh => 6946, ixl => 6947, iyh => 6948, iyl => 6949, l => 6950, lx => 6951, ly => 6952, xh => 6953, xl => 6954, yh => 6955, yl => 6956, "~" => [ 13, 6931 ], },
	# [6893] opcode : sub "("
	{ hl => 6894, ix => 6896, iy => 6904, },
	# [6894] opcode : sub "(" hl
	{ ")" => 6895, },
	# [6895] opcode : sub "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_1837 ], ":" => [ 7, \&_action_opcode_1837 ], },
	# [6896] opcode : sub "(" ix
	{ ")" => 6897, "+" => 6898, "-" => 6901, },
	# [6897] opcode : sub "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_1838 ], ":" => [ 7, \&_action_opcode_1838 ], },
	# [6898] opcode : sub "(" ix "+"
	{ "!" => [ 12, 6899 ], "+" => [ 12, 6899 ], "-" => [ 12, 6899 ], __else__ => [ 12, 6899 ], "~" => [ 12, 6899 ], },
	# [6899] opcode : sub "(" ix "+" "[expr_DIS]"
	{ ")" => 6900, },
	# [6900] opcode : sub "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1839 ], ":" => [ 7, \&_action_opcode_1839 ], },
	# [6901] opcode : sub "(" ix "-"
	{ "!" => [ 14, 6902 ], "+" => [ 14, 6902 ], "-" => [ 14, 6902 ], __else__ => [ 14, 6902 ], "~" => [ 14, 6902 ], },
	# [6902] opcode : sub "(" ix "-" "[expr_NDIS]"
	{ ")" => 6903, },
	# [6903] opcode : sub "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1839 ], ":" => [ 7, \&_action_opcode_1839 ], },
	# [6904] opcode : sub "(" iy
	{ ")" => 6905, "+" => 6906, "-" => 6909, },
	# [6905] opcode : sub "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_1840 ], ":" => [ 7, \&_action_opcode_1840 ], },
	# [6906] opcode : sub "(" iy "+"
	{ "!" => [ 12, 6907 ], "+" => [ 12, 6907 ], "-" => [ 12, 6907 ], __else__ => [ 12, 6907 ], "~" => [ 12, 6907 ], },
	# [6907] opcode : sub "(" iy "+" "[expr_DIS]"
	{ ")" => 6908, },
	# [6908] opcode : sub "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1841 ], ":" => [ 7, \&_action_opcode_1841 ], },
	# [6909] opcode : sub "(" iy "-"
	{ "!" => [ 14, 6910 ], "+" => [ 14, 6910 ], "-" => [ 14, 6910 ], __else__ => [ 14, 6910 ], "~" => [ 14, 6910 ], },
	# [6910] opcode : sub "(" iy "-" "[expr_NDIS]"
	{ ")" => 6911, },
	# [6911] opcode : sub "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1841 ], ":" => [ 7, \&_action_opcode_1841 ], },
	# [6912] opcode : sub "["
	{ hl => 6913, ix => 6915, iy => 6923, },
	# [6913] opcode : sub "[" hl
	{ "]" => 6914, },
	# [6914] opcode : sub "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_1837 ], ":" => [ 7, \&_action_opcode_1837 ], },
	# [6915] opcode : sub "[" ix
	{ "+" => 6916, "-" => 6919, "]" => 6922, },
	# [6916] opcode : sub "[" ix "+"
	{ "!" => [ 12, 6917 ], "+" => [ 12, 6917 ], "-" => [ 12, 6917 ], __else__ => [ 12, 6917 ], "~" => [ 12, 6917 ], },
	# [6917] opcode : sub "[" ix "+" "[expr_DIS]"
	{ "]" => 6918, },
	# [6918] opcode : sub "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1839 ], ":" => [ 7, \&_action_opcode_1839 ], },
	# [6919] opcode : sub "[" ix "-"
	{ "!" => [ 14, 6920 ], "+" => [ 14, 6920 ], "-" => [ 14, 6920 ], __else__ => [ 14, 6920 ], "~" => [ 14, 6920 ], },
	# [6920] opcode : sub "[" ix "-" "[expr_NDIS]"
	{ "]" => 6921, },
	# [6921] opcode : sub "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1839 ], ":" => [ 7, \&_action_opcode_1839 ], },
	# [6922] opcode : sub "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_1838 ], ":" => [ 7, \&_action_opcode_1838 ], },
	# [6923] opcode : sub "[" iy
	{ "+" => 6924, "-" => 6927, "]" => 6930, },
	# [6924] opcode : sub "[" iy "+"
	{ "!" => [ 12, 6925 ], "+" => [ 12, 6925 ], "-" => [ 12, 6925 ], __else__ => [ 12, 6925 ], "~" => [ 12, 6925 ], },
	# [6925] opcode : sub "[" iy "+" "[expr_DIS]"
	{ "]" => 6926, },
	# [6926] opcode : sub "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1841 ], ":" => [ 7, \&_action_opcode_1841 ], },
	# [6927] opcode : sub "[" iy "-"
	{ "!" => [ 14, 6928 ], "+" => [ 14, 6928 ], "-" => [ 14, 6928 ], __else__ => [ 14, 6928 ], "~" => [ 14, 6928 ], },
	# [6928] opcode : sub "[" iy "-" "[expr_NDIS]"
	{ "]" => 6929, },
	# [6929] opcode : sub "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1841 ], ":" => [ 7, \&_action_opcode_1841 ], },
	# [6930] opcode : sub "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_1840 ], ":" => [ 7, \&_action_opcode_1840 ], },
	# [6931] opcode : sub "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_1842 ], ":" => [ 7, \&_action_opcode_1842 ], },
	# [6932] opcode : sub a
	{ "\n" => [ 7, \&_action_opcode_1843 ], ":" => [ 7, \&_action_opcode_1843 ], },
	# [6933] opcode : sub b
	{ "\n" => [ 7, \&_action_opcode_1844 ], ":" => [ 7, \&_action_opcode_1844 ], },
	# [6934] opcode : sub c
	{ "\n" => [ 7, \&_action_opcode_1845 ], ":" => [ 7, \&_action_opcode_1845 ], },
	# [6935] opcode : sub d
	{ "\n" => [ 7, \&_action_opcode_1846 ], ":" => [ 7, \&_action_opcode_1846 ], },
	# [6936] opcode : sub e
	{ "\n" => [ 7, \&_action_opcode_1847 ], ":" => [ 7, \&_action_opcode_1847 ], },
	# [6937] opcode : sub h
	{ "\n" => [ 7, \&_action_opcode_1848 ], ":" => [ 7, \&_action_opcode_1848 ], },
	# [6938] opcode : sub hl
	{ "," => 6939, },
	# [6939] opcode : sub hl ","
	{ bc => 6940, de => 6941, hl => 6942, sp => 6943, },
	# [6940] opcode : sub hl "," bc
	{ "\n" => [ 7, \&_action_opcode_1849 ], ":" => [ 7, \&_action_opcode_1849 ], },
	# [6941] opcode : sub hl "," de
	{ "\n" => [ 7, \&_action_opcode_1850 ], ":" => [ 7, \&_action_opcode_1850 ], },
	# [6942] opcode : sub hl "," hl
	{ "\n" => [ 7, \&_action_opcode_1851 ], ":" => [ 7, \&_action_opcode_1851 ], },
	# [6943] opcode : sub hl "," sp
	{ "\n" => [ 7, \&_action_opcode_1852 ], ":" => [ 7, \&_action_opcode_1852 ], },
	# [6944] opcode : sub hx
	{ "\n" => [ 7, \&_action_opcode_1853 ], ":" => [ 7, \&_action_opcode_1853 ], },
	# [6945] opcode : sub hy
	{ "\n" => [ 7, \&_action_opcode_1854 ], ":" => [ 7, \&_action_opcode_1854 ], },
	# [6946] opcode : sub ixh
	{ "\n" => [ 7, \&_action_opcode_1853 ], ":" => [ 7, \&_action_opcode_1853 ], },
	# [6947] opcode : sub ixl
	{ "\n" => [ 7, \&_action_opcode_1855 ], ":" => [ 7, \&_action_opcode_1855 ], },
	# [6948] opcode : sub iyh
	{ "\n" => [ 7, \&_action_opcode_1854 ], ":" => [ 7, \&_action_opcode_1854 ], },
	# [6949] opcode : sub iyl
	{ "\n" => [ 7, \&_action_opcode_1856 ], ":" => [ 7, \&_action_opcode_1856 ], },
	# [6950] opcode : sub l
	{ "\n" => [ 7, \&_action_opcode_1857 ], ":" => [ 7, \&_action_opcode_1857 ], },
	# [6951] opcode : sub lx
	{ "\n" => [ 7, \&_action_opcode_1855 ], ":" => [ 7, \&_action_opcode_1855 ], },
	# [6952] opcode : sub ly
	{ "\n" => [ 7, \&_action_opcode_1856 ], ":" => [ 7, \&_action_opcode_1856 ], },
	# [6953] opcode : sub xh
	{ "\n" => [ 7, \&_action_opcode_1853 ], ":" => [ 7, \&_action_opcode_1853 ], },
	# [6954] opcode : sub xl
	{ "\n" => [ 7, \&_action_opcode_1855 ], ":" => [ 7, \&_action_opcode_1855 ], },
	# [6955] opcode : sub yh
	{ "\n" => [ 7, \&_action_opcode_1854 ], ":" => [ 7, \&_action_opcode_1854 ], },
	# [6956] opcode : sub yl
	{ "\n" => [ 7, \&_action_opcode_1856 ], ":" => [ 7, \&_action_opcode_1856 ], },
	# [6957] opcode : xor
	{ "!" => [ 13, 6996 ], "(" => 6958, "+" => [ 13, 6996 ], "-" => [ 13, 6996 ], "[" => 6977, __else__ => [ 13, 6996 ], a => 6997, b => 6998, c => 6999, d => 7000, e => 7001, h => 7002, hx => 7003, hy => 7004, ixh => 7005, ixl => 7006, iyh => 7007, iyl => 7008, l => 7009, lx => 7010, ly => 7011, xh => 7012, xl => 7013, yh => 7014, yl => 7015, "~" => [ 13, 6996 ], },
	# [6958] opcode : xor "("
	{ hl => 6959, ix => 6961, iy => 6969, },
	# [6959] opcode : xor "(" hl
	{ ")" => 6960, },
	# [6960] opcode : xor "(" hl ")"
	{ "\n" => [ 7, \&_action_opcode_1858 ], ":" => [ 7, \&_action_opcode_1858 ], },
	# [6961] opcode : xor "(" ix
	{ ")" => 6962, "+" => 6963, "-" => 6966, },
	# [6962] opcode : xor "(" ix ")"
	{ "\n" => [ 7, \&_action_opcode_1859 ], ":" => [ 7, \&_action_opcode_1859 ], },
	# [6963] opcode : xor "(" ix "+"
	{ "!" => [ 12, 6964 ], "+" => [ 12, 6964 ], "-" => [ 12, 6964 ], __else__ => [ 12, 6964 ], "~" => [ 12, 6964 ], },
	# [6964] opcode : xor "(" ix "+" "[expr_DIS]"
	{ ")" => 6965, },
	# [6965] opcode : xor "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1860 ], ":" => [ 7, \&_action_opcode_1860 ], },
	# [6966] opcode : xor "(" ix "-"
	{ "!" => [ 14, 6967 ], "+" => [ 14, 6967 ], "-" => [ 14, 6967 ], __else__ => [ 14, 6967 ], "~" => [ 14, 6967 ], },
	# [6967] opcode : xor "(" ix "-" "[expr_NDIS]"
	{ ")" => 6968, },
	# [6968] opcode : xor "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1860 ], ":" => [ 7, \&_action_opcode_1860 ], },
	# [6969] opcode : xor "(" iy
	{ ")" => 6970, "+" => 6971, "-" => 6974, },
	# [6970] opcode : xor "(" iy ")"
	{ "\n" => [ 7, \&_action_opcode_1861 ], ":" => [ 7, \&_action_opcode_1861 ], },
	# [6971] opcode : xor "(" iy "+"
	{ "!" => [ 12, 6972 ], "+" => [ 12, 6972 ], "-" => [ 12, 6972 ], __else__ => [ 12, 6972 ], "~" => [ 12, 6972 ], },
	# [6972] opcode : xor "(" iy "+" "[expr_DIS]"
	{ ")" => 6973, },
	# [6973] opcode : xor "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1862 ], ":" => [ 7, \&_action_opcode_1862 ], },
	# [6974] opcode : xor "(" iy "-"
	{ "!" => [ 14, 6975 ], "+" => [ 14, 6975 ], "-" => [ 14, 6975 ], __else__ => [ 14, 6975 ], "~" => [ 14, 6975 ], },
	# [6975] opcode : xor "(" iy "-" "[expr_NDIS]"
	{ ")" => 6976, },
	# [6976] opcode : xor "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 7, \&_action_opcode_1862 ], ":" => [ 7, \&_action_opcode_1862 ], },
	# [6977] opcode : xor "["
	{ hl => 6978, ix => 6980, iy => 6988, },
	# [6978] opcode : xor "[" hl
	{ "]" => 6979, },
	# [6979] opcode : xor "[" hl "]"
	{ "\n" => [ 7, \&_action_opcode_1858 ], ":" => [ 7, \&_action_opcode_1858 ], },
	# [6980] opcode : xor "[" ix
	{ "+" => 6981, "-" => 6984, "]" => 6987, },
	# [6981] opcode : xor "[" ix "+"
	{ "!" => [ 12, 6982 ], "+" => [ 12, 6982 ], "-" => [ 12, 6982 ], __else__ => [ 12, 6982 ], "~" => [ 12, 6982 ], },
	# [6982] opcode : xor "[" ix "+" "[expr_DIS]"
	{ "]" => 6983, },
	# [6983] opcode : xor "[" ix "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1860 ], ":" => [ 7, \&_action_opcode_1860 ], },
	# [6984] opcode : xor "[" ix "-"
	{ "!" => [ 14, 6985 ], "+" => [ 14, 6985 ], "-" => [ 14, 6985 ], __else__ => [ 14, 6985 ], "~" => [ 14, 6985 ], },
	# [6985] opcode : xor "[" ix "-" "[expr_NDIS]"
	{ "]" => 6986, },
	# [6986] opcode : xor "[" ix "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1860 ], ":" => [ 7, \&_action_opcode_1860 ], },
	# [6987] opcode : xor "[" ix "]"
	{ "\n" => [ 7, \&_action_opcode_1859 ], ":" => [ 7, \&_action_opcode_1859 ], },
	# [6988] opcode : xor "[" iy
	{ "+" => 6989, "-" => 6992, "]" => 6995, },
	# [6989] opcode : xor "[" iy "+"
	{ "!" => [ 12, 6990 ], "+" => [ 12, 6990 ], "-" => [ 12, 6990 ], __else__ => [ 12, 6990 ], "~" => [ 12, 6990 ], },
	# [6990] opcode : xor "[" iy "+" "[expr_DIS]"
	{ "]" => 6991, },
	# [6991] opcode : xor "[" iy "+" "[expr_DIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1862 ], ":" => [ 7, \&_action_opcode_1862 ], },
	# [6992] opcode : xor "[" iy "-"
	{ "!" => [ 14, 6993 ], "+" => [ 14, 6993 ], "-" => [ 14, 6993 ], __else__ => [ 14, 6993 ], "~" => [ 14, 6993 ], },
	# [6993] opcode : xor "[" iy "-" "[expr_NDIS]"
	{ "]" => 6994, },
	# [6994] opcode : xor "[" iy "-" "[expr_NDIS]" "]"
	{ "\n" => [ 7, \&_action_opcode_1862 ], ":" => [ 7, \&_action_opcode_1862 ], },
	# [6995] opcode : xor "[" iy "]"
	{ "\n" => [ 7, \&_action_opcode_1861 ], ":" => [ 7, \&_action_opcode_1861 ], },
	# [6996] opcode : xor "[expr_N]"
	{ "\n" => [ 7, \&_action_opcode_1863 ], ":" => [ 7, \&_action_opcode_1863 ], },
	# [6997] opcode : xor a
	{ "\n" => [ 7, \&_action_opcode_1864 ], ":" => [ 7, \&_action_opcode_1864 ], },
	# [6998] opcode : xor b
	{ "\n" => [ 7, \&_action_opcode_1865 ], ":" => [ 7, \&_action_opcode_1865 ], },
	# [6999] opcode : xor c
	{ "\n" => [ 7, \&_action_opcode_1866 ], ":" => [ 7, \&_action_opcode_1866 ], },
	# [7000] opcode : xor d
	{ "\n" => [ 7, \&_action_opcode_1867 ], ":" => [ 7, \&_action_opcode_1867 ], },
	# [7001] opcode : xor e
	{ "\n" => [ 7, \&_action_opcode_1868 ], ":" => [ 7, \&_action_opcode_1868 ], },
	# [7002] opcode : xor h
	{ "\n" => [ 7, \&_action_opcode_1869 ], ":" => [ 7, \&_action_opcode_1869 ], },
	# [7003] opcode : xor hx
	{ "\n" => [ 7, \&_action_opcode_1870 ], ":" => [ 7, \&_action_opcode_1870 ], },
	# [7004] opcode : xor hy
	{ "\n" => [ 7, \&_action_opcode_1871 ], ":" => [ 7, \&_action_opcode_1871 ], },
	# [7005] opcode : xor ixh
	{ "\n" => [ 7, \&_action_opcode_1870 ], ":" => [ 7, \&_action_opcode_1870 ], },
	# [7006] opcode : xor ixl
	{ "\n" => [ 7, \&_action_opcode_1872 ], ":" => [ 7, \&_action_opcode_1872 ], },
	# [7007] opcode : xor iyh
	{ "\n" => [ 7, \&_action_opcode_1871 ], ":" => [ 7, \&_action_opcode_1871 ], },
	# [7008] opcode : xor iyl
	{ "\n" => [ 7, \&_action_opcode_1873 ], ":" => [ 7, \&_action_opcode_1873 ], },
	# [7009] opcode : xor l
	{ "\n" => [ 7, \&_action_opcode_1874 ], ":" => [ 7, \&_action_opcode_1874 ], },
	# [7010] opcode : xor lx
	{ "\n" => [ 7, \&_action_opcode_1872 ], ":" => [ 7, \&_action_opcode_1872 ], },
	# [7011] opcode : xor ly
	{ "\n" => [ 7, \&_action_opcode_1873 ], ":" => [ 7, \&_action_opcode_1873 ], },
	# [7012] opcode : xor xh
	{ "\n" => [ 7, \&_action_opcode_1870 ], ":" => [ 7, \&_action_opcode_1870 ], },
	# [7013] opcode : xor xl
	{ "\n" => [ 7, \&_action_opcode_1872 ], ":" => [ 7, \&_action_opcode_1872 ], },
	# [7014] opcode : xor yh
	{ "\n" => [ 7, \&_action_opcode_1871 ], ":" => [ 7, \&_action_opcode_1871 ], },
	# [7015] opcode : xor yl
	{ "\n" => [ 7, \&_action_opcode_1873 ], ":" => [ 7, \&_action_opcode_1873 ], },
	# [7016] program : 
	{ "\n" => [ 42, 7016 ], ":" => [ 42, 7016 ], NAME => [ 42, 7016 ], __else__ => 7017, adc => [ 42, 7016 ], add => [ 42, 7016 ], and => [ 42, 7016 ], bit => [ 42, 7016 ], call => [ 42, 7016 ], ccf => [ 42, 7016 ], cp => [ 42, 7016 ], cpd => [ 42, 7016 ], cpdr => [ 42, 7016 ], cpi => [ 42, 7016 ], cpir => [ 42, 7016 ], cpl => [ 42, 7016 ], daa => [ 42, 7016 ], db => [ 42, 7016 ], dec => [ 42, 7016 ], defb => [ 42, 7016 ], defm => [ 42, 7016 ], deft => [ 42, 7016 ], defw => [ 42, 7016 ], di => [ 42, 7016 ], djnz => [ 42, 7016 ], dw => [ 42, 7016 ], ei => [ 42, 7016 ], ex => [ 42, 7016 ], exa => [ 42, 7016 ], exx => [ 42, 7016 ], halt => [ 42, 7016 ], im => [ 42, 7016 ], in => [ 42, 7016 ], inc => [ 42, 7016 ], ind => [ 42, 7016 ], indr => [ 42, 7016 ], ini => [ 42, 7016 ], inir => [ 42, 7016 ], jp => [ 42, 7016 ], jr => [ 42, 7016 ], ld => [ 42, 7016 ], ldd => [ 42, 7016 ], lddr => [ 42, 7016 ], ldi => [ 42, 7016 ], ldir => [ 42, 7016 ], macro => [ 42, 7016 ], neg => [ 42, 7016 ], nop => [ 42, 7016 ], or => [ 42, 7016 ], org => [ 42, 7016 ], otdr => [ 42, 7016 ], otir => [ 42, 7016 ], out => [ 42, 7016 ], outd => [ 42, 7016 ], outi => [ 42, 7016 ], pop => [ 42, 7016 ], push => [ 42, 7016 ], res => [ 42, 7016 ], ret => [ 42, 7016 ], reti => [ 42, 7016 ], retn => [ 42, 7016 ], rl => [ 42, 7016 ], rla => [ 42, 7016 ], rlc => [ 42, 7016 ], rlca => [ 42, 7016 ], rld => [ 42, 7016 ], rr => [ 42, 7016 ], rra => [ 42, 7016 ], rrc => [ 42, 7016 ], rrca => [ 42, 7016 ], rrd => [ 42, 7016 ], rst => [ 42, 7016 ], sbc => [ 42, 7016 ], scf => [ 42, 7016 ], set => [ 42, 7016 ], sla => [ 42, 7016 ], sli => [ 42, 7016 ], sll => [ 42, 7016 ], sra => [ 42, 7016 ], srl => [ 42, 7016 ], stop => [ 42, 7016 ], sub => [ 42, 7016 ], xor => [ 42, 7016 ], },
	# [7017] program : "[opcode]*"
	{ "" => \&_action_end_0, },
	# [7018] term : 
	{ "!" => [ 7024, 7018 ], "+" => [ 7024, 7018 ], "-" => [ 7024, 7018 ], __else__ => 7019, "~" => [ 7024, 7018 ], },
	# [7019] term : "[unop]*"
	{ "(" => 7020, NAME => \&_action_term_2, NUMBER => \&_action_term_2, STRING => \&_action_term_2, },
	# [7020] term : "[unop]*" "("
	{ "!" => [ 8, 7021 ], "+" => [ 8, 7021 ], "-" => [ 8, 7021 ], __else__ => [ 8, 7021 ], "~" => [ 8, 7021 ], },
	# [7021] term : "[unop]*" "(" "[expr]"
	{ ")" => \&_action_term_3, },
	# [7022] term2 : 
	{ "!=" => [ 1, 7023 ], "%" => [ 1, 7023 ], "&" => [ 1, 7023 ], "&&" => [ 1, 7023 ], "*" => [ 1, 7023 ], "+" => [ 1, 7023 ], "-" => [ 1, 7023 ], "/" => [ 1, 7023 ], "<" => [ 1, 7023 ], "<<" => [ 1, 7023 ], "<=" => [ 1, 7023 ], "==" => [ 1, 7023 ], ">" => [ 1, 7023 ], ">=" => [ 1, 7023 ], ">>" => [ 1, 7023 ], "^" => [ 1, 7023 ], "|" => [ 1, 7023 ], "||" => [ 1, 7023 ], },
	# [7023] term2 : "[binop]"
	{ "!" => [ 7018, \&_action_term2_4 ], "+" => [ 7018, \&_action_term2_4 ], "-" => [ 7018, \&_action_term2_4 ], __else__ => [ 7018, \&_action_term2_4 ], "~" => [ 7018, \&_action_term2_4 ], },
	# [7024] unop : 
	{ "!" => \&_action_unop_1, "+" => \&_action_unop_1, "-" => \&_action_unop_1, "~" => \&_action_unop_1, },
);
# end : ":"
sub _action_end_0 {
	undef
}
# expr2 : "," "[expr]"
sub _action_expr2_6 {
	$_[ARGS][1]
}
# expr : "[term]" "[term2]*"
sub _action_expr_5 {
	# flat the input lists
	my @ret;
	for (@{$_[ARGS]}) {
		push(@ret, @$_);
	}
	\@ret;
}
# expr_DIS : "[expr]"
sub _action_expr_DIS_7 {
	return CPU::Z80::Assembler::Expr->new(
				child 	=> $_[ARGS][0],
				line	=> $_[ARGS][0][0]->line,
				type	=> "sb");
}
# expr_NDIS : "[expr_DIS]"
sub _action_expr_NDIS_8 {
	return $_[ARGS][0]->build("-{}");
}
# expr_NN : "[expr]"
sub _action_expr_NN_11 {
	return CPU::Z80::Assembler::Expr->new(
				child 	=> $_[ARGS][0],
				line	=> $_[ARGS][0][0]->line,
				type	=> "w");
}
# expr_N : "[expr]"
sub _action_expr_N_9 {
	return CPU::Z80::Assembler::Expr->new(
				child 	=> $_[ARGS][0],
				line	=> $_[ARGS][0][0]->line,
				type	=> "ub");
}
# expr_const : "[expr]"
sub _action_expr_const_13 {
	my $expr = CPU::Z80::Assembler::Expr->new(
				child 	=> $_[ARGS][0],
				line	=> $_[ARGS][0][0]->line);
	return $expr->evaluate();
}
# expr_list_NN : "[expr_list]"
sub _action_expr_list_NN_12 {
	# return list of NN expressions
	my @ret;
	for (@{$_[ARGS][0]}) {
		push(@ret, 
				CPU::Z80::Assembler::Expr->new(
							child 	=> $_,
							line	=> $_[ARGS][0][0][0]->line,
							type	=> "w"),
				undef,		# placeholder for second byte
			);
	}
	\@ret;
}
# expr_list_N : "[expr_list]"
sub _action_expr_list_N_10 {
	# return list of N expressions
	my @ret;
	for (@{$_[ARGS][0]}) {
		push(@ret, CPU::Z80::Assembler::Expr->new(
				child 	=> $_,
				line	=> $_[ARGS][0][0][0]->line,
				type	=> "ub"));
	}
	\@ret;
}
# expr_list_text : "[expr_text]" "[expr_text2]*"
sub _action_expr_list_text_18 {
	my @bytes;
	for (@{$_[ARGS]}) {
		push @bytes, @$_;
	}
	return \@bytes;
}
# expr_text : "[expr_text_string]" "[cont_expr_N]?"
sub _action_expr_text_17 {
	my @bytes = @{ $_[ARGS][0] };
	
	if ( @{ $_[ARGS] } > 1 ) {
		my $last = pop(@bytes) || 0;			# last byte
		
		my $binop = $_[ARGS][1][0]->type;		# operator
		my $expr =  $_[ARGS][1][1]->build("$last $binop {}");
		
		return [ @bytes, $expr ];					
	}
	else {
		return \@bytes;
	}
}
# expr_text_number : NUMBER
sub _action_expr_text_number_16 {
	my @bytes;
	my $value = eval($_[ARGS][0]->value); $@ and die $@; # ASSERT
	while ($value) {
		unshift(@bytes, $value & 0xFF);
		$value >>= 8;
	}
	return \@bytes;
}
# expr_text_string : STRING
sub _action_expr_text_string_15 {
	my @bytes = map {ord($_)} split(//, $_[ARGS][0]->value);
	return \@bytes;
}
# inline_const : "[expr]"
sub _action_inline_const_14 {
	my $expr = CPU::Z80::Assembler::Expr->new(
				child 	=> $_[ARGS][0],
				line	=> $_[ARGS][0][0]->line);
	my $value = $expr->evaluate();
	$_[INPUT]->unget(Asm::Preproc::Token->new($value,
											  $value,
											  $expr->line));
	return 0;	# return dummy value to keep index into values correct
}
# macro : macro NAME "[macro_args_optional]" "[macro_body]"
sub _action_macro_27 {
	my $name = $_[ARGS][1]->value;
	exists $_[PROG]->macros->{$name}
		and $_[ARGS][1]->error("macro $name redefined");

	my $macro = $_[ARGS][3];
	$macro->name(   $name );
	$macro->params( $_[ARGS][2] );
	$_[PROG]->macros->{$name} = $macro;
}
# macro_arg2 : "," NAME
sub _action_macro_arg2_23 {
	#DEBUG
	$_[ARGS][1]->value
}
# macro_arg : NAME
sub _action_macro_arg_22 {
	#DEBUG
	$_[ARGS][0]->value
}
# macro_args : "[macro_arg]" "[macro_arg2]*"
sub _action_macro_args_24 {
	#DEBUG
	$_[ARGS]
}
# macro_args_optional : "[macro_args]?"
sub _action_macro_args_optional_25 {
	#DEBUG
	defined($_[ARGS][0]) ? $_[ARGS][0] : []
}
# macro_body : "{"
sub _action_macro_body_26 {
	$_[INPUT]->unget($_[ARGS][0]);		# push back starting token
	my $macro = CPU::Z80::Assembler::Macro->new();
	$macro->parse_body($_[INPUT]);
	return $macro;
}
# opcode : bit "[inline_const]" 0 "," a "[end]"
sub _action_opcode_100 {
	_add_opcode(@_, 0xCB, 0x47);
}
# opcode : res "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1000 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xA1);
}
# opcode : res "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1001 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xA2);
}
# opcode : res "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1002 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xA3);
}
# opcode : res "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1003 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xA4);
}
# opcode : res "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1004 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xA5);
}
# opcode : res "[inline_const]" 4 "," a "[end]"
sub _action_opcode_1005 {
	_add_opcode(@_, 0xCB, 0xA7);
}
# opcode : res "[inline_const]" 4 "," b "[end]"
sub _action_opcode_1006 {
	_add_opcode(@_, 0xCB, 0xA0);
}
# opcode : res "[inline_const]" 4 "," c "[end]"
sub _action_opcode_1007 {
	_add_opcode(@_, 0xCB, 0xA1);
}
# opcode : res "[inline_const]" 4 "," d "[end]"
sub _action_opcode_1008 {
	_add_opcode(@_, 0xCB, 0xA2);
}
# opcode : res "[inline_const]" 4 "," e "[end]"
sub _action_opcode_1009 {
	_add_opcode(@_, 0xCB, 0xA3);
}
# opcode : bit "[inline_const]" 0 "," b "[end]"
sub _action_opcode_101 {
	_add_opcode(@_, 0xCB, 0x40);
}
# opcode : res "[inline_const]" 4 "," h "[end]"
sub _action_opcode_1010 {
	_add_opcode(@_, 0xCB, 0xA4);
}
# opcode : res "[inline_const]" 4 "," l "[end]"
sub _action_opcode_1011 {
	_add_opcode(@_, 0xCB, 0xA5);
}
# opcode : res "[inline_const]" 5 "," "(" hl ")" "[end]"
sub _action_opcode_1012 {
	_add_opcode(@_, 0xCB, 0xAE);
}
# opcode : res "[inline_const]" 5 "," "(" ix ")" "[end]"
sub _action_opcode_1013 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xAE);
}
# opcode : res "[inline_const]" 5 "," "(" ix ")" "," a "[end]"
sub _action_opcode_1014 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xAF);
}
# opcode : res "[inline_const]" 5 "," "(" ix ")" "," b "[end]"
sub _action_opcode_1015 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xA8);
}
# opcode : res "[inline_const]" 5 "," "(" ix ")" "," c "[end]"
sub _action_opcode_1016 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xA9);
}
# opcode : res "[inline_const]" 5 "," "(" ix ")" "," d "[end]"
sub _action_opcode_1017 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xAA);
}
# opcode : res "[inline_const]" 5 "," "(" ix ")" "," e "[end]"
sub _action_opcode_1018 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xAB);
}
# opcode : res "[inline_const]" 5 "," "(" ix ")" "," h "[end]"
sub _action_opcode_1019 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xAC);
}
# opcode : bit "[inline_const]" 0 "," c "[end]"
sub _action_opcode_102 {
	_add_opcode(@_, 0xCB, 0x41);
}
# opcode : res "[inline_const]" 5 "," "(" ix ")" "," l "[end]"
sub _action_opcode_1020 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xAD);
}
# opcode : res "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1021 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xAE);
}
# opcode : res "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1022 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xAF);
}
# opcode : res "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1023 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xA8);
}
# opcode : res "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1024 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xA9);
}
# opcode : res "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1025 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xAA);
}
# opcode : res "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1026 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xAB);
}
# opcode : res "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1027 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xAC);
}
# opcode : res "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1028 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xAD);
}
# opcode : res "[inline_const]" 5 "," "(" iy ")" "[end]"
sub _action_opcode_1029 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xAE);
}
# opcode : bit "[inline_const]" 0 "," d "[end]"
sub _action_opcode_103 {
	_add_opcode(@_, 0xCB, 0x42);
}
# opcode : res "[inline_const]" 5 "," "(" iy ")" "," a "[end]"
sub _action_opcode_1030 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xAF);
}
# opcode : res "[inline_const]" 5 "," "(" iy ")" "," b "[end]"
sub _action_opcode_1031 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xA8);
}
# opcode : res "[inline_const]" 5 "," "(" iy ")" "," c "[end]"
sub _action_opcode_1032 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xA9);
}
# opcode : res "[inline_const]" 5 "," "(" iy ")" "," d "[end]"
sub _action_opcode_1033 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xAA);
}
# opcode : res "[inline_const]" 5 "," "(" iy ")" "," e "[end]"
sub _action_opcode_1034 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xAB);
}
# opcode : res "[inline_const]" 5 "," "(" iy ")" "," h "[end]"
sub _action_opcode_1035 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xAC);
}
# opcode : res "[inline_const]" 5 "," "(" iy ")" "," l "[end]"
sub _action_opcode_1036 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xAD);
}
# opcode : res "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1037 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xAE);
}
# opcode : res "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1038 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xAF);
}
# opcode : res "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1039 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xA8);
}
# opcode : bit "[inline_const]" 0 "," e "[end]"
sub _action_opcode_104 {
	_add_opcode(@_, 0xCB, 0x43);
}
# opcode : res "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1040 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xA9);
}
# opcode : res "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1041 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xAA);
}
# opcode : res "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1042 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xAB);
}
# opcode : res "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1043 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xAC);
}
# opcode : res "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1044 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xAD);
}
# opcode : res "[inline_const]" 5 "," a "[end]"
sub _action_opcode_1045 {
	_add_opcode(@_, 0xCB, 0xAF);
}
# opcode : res "[inline_const]" 5 "," b "[end]"
sub _action_opcode_1046 {
	_add_opcode(@_, 0xCB, 0xA8);
}
# opcode : res "[inline_const]" 5 "," c "[end]"
sub _action_opcode_1047 {
	_add_opcode(@_, 0xCB, 0xA9);
}
# opcode : res "[inline_const]" 5 "," d "[end]"
sub _action_opcode_1048 {
	_add_opcode(@_, 0xCB, 0xAA);
}
# opcode : res "[inline_const]" 5 "," e "[end]"
sub _action_opcode_1049 {
	_add_opcode(@_, 0xCB, 0xAB);
}
# opcode : bit "[inline_const]" 0 "," h "[end]"
sub _action_opcode_105 {
	_add_opcode(@_, 0xCB, 0x44);
}
# opcode : res "[inline_const]" 5 "," h "[end]"
sub _action_opcode_1050 {
	_add_opcode(@_, 0xCB, 0xAC);
}
# opcode : res "[inline_const]" 5 "," l "[end]"
sub _action_opcode_1051 {
	_add_opcode(@_, 0xCB, 0xAD);
}
# opcode : res "[inline_const]" 6 "," "(" hl ")" "[end]"
sub _action_opcode_1052 {
	_add_opcode(@_, 0xCB, 0xB6);
}
# opcode : res "[inline_const]" 6 "," "(" ix ")" "[end]"
sub _action_opcode_1053 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xB6);
}
# opcode : res "[inline_const]" 6 "," "(" ix ")" "," a "[end]"
sub _action_opcode_1054 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xB7);
}
# opcode : res "[inline_const]" 6 "," "(" ix ")" "," b "[end]"
sub _action_opcode_1055 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xB0);
}
# opcode : res "[inline_const]" 6 "," "(" ix ")" "," c "[end]"
sub _action_opcode_1056 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xB1);
}
# opcode : res "[inline_const]" 6 "," "(" ix ")" "," d "[end]"
sub _action_opcode_1057 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xB2);
}
# opcode : res "[inline_const]" 6 "," "(" ix ")" "," e "[end]"
sub _action_opcode_1058 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xB3);
}
# opcode : res "[inline_const]" 6 "," "(" ix ")" "," h "[end]"
sub _action_opcode_1059 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xB4);
}
# opcode : bit "[inline_const]" 0 "," l "[end]"
sub _action_opcode_106 {
	_add_opcode(@_, 0xCB, 0x45);
}
# opcode : res "[inline_const]" 6 "," "(" ix ")" "," l "[end]"
sub _action_opcode_1060 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xB5);
}
# opcode : res "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1061 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xB6);
}
# opcode : res "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1062 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xB7);
}
# opcode : res "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1063 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xB0);
}
# opcode : res "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1064 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xB1);
}
# opcode : res "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1065 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xB2);
}
# opcode : res "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1066 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xB3);
}
# opcode : res "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1067 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xB4);
}
# opcode : res "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1068 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xB5);
}
# opcode : res "[inline_const]" 6 "," "(" iy ")" "[end]"
sub _action_opcode_1069 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xB6);
}
# opcode : bit "[inline_const]" 1 "," "(" hl ")" "[end]"
sub _action_opcode_107 {
	_add_opcode(@_, 0xCB, 0x4E);
}
# opcode : res "[inline_const]" 6 "," "(" iy ")" "," a "[end]"
sub _action_opcode_1070 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xB7);
}
# opcode : res "[inline_const]" 6 "," "(" iy ")" "," b "[end]"
sub _action_opcode_1071 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xB0);
}
# opcode : res "[inline_const]" 6 "," "(" iy ")" "," c "[end]"
sub _action_opcode_1072 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xB1);
}
# opcode : res "[inline_const]" 6 "," "(" iy ")" "," d "[end]"
sub _action_opcode_1073 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xB2);
}
# opcode : res "[inline_const]" 6 "," "(" iy ")" "," e "[end]"
sub _action_opcode_1074 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xB3);
}
# opcode : res "[inline_const]" 6 "," "(" iy ")" "," h "[end]"
sub _action_opcode_1075 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xB4);
}
# opcode : res "[inline_const]" 6 "," "(" iy ")" "," l "[end]"
sub _action_opcode_1076 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xB5);
}
# opcode : res "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1077 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xB6);
}
# opcode : res "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1078 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xB7);
}
# opcode : res "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1079 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xB0);
}
# opcode : bit "[inline_const]" 1 "," "(" ix ")" "[end]"
sub _action_opcode_108 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x4E);
}
# opcode : res "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1080 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xB1);
}
# opcode : res "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1081 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xB2);
}
# opcode : res "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1082 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xB3);
}
# opcode : res "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1083 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xB4);
}
# opcode : res "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1084 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xB5);
}
# opcode : res "[inline_const]" 6 "," a "[end]"
sub _action_opcode_1085 {
	_add_opcode(@_, 0xCB, 0xB7);
}
# opcode : res "[inline_const]" 6 "," b "[end]"
sub _action_opcode_1086 {
	_add_opcode(@_, 0xCB, 0xB0);
}
# opcode : res "[inline_const]" 6 "," c "[end]"
sub _action_opcode_1087 {
	_add_opcode(@_, 0xCB, 0xB1);
}
# opcode : res "[inline_const]" 6 "," d "[end]"
sub _action_opcode_1088 {
	_add_opcode(@_, 0xCB, 0xB2);
}
# opcode : res "[inline_const]" 6 "," e "[end]"
sub _action_opcode_1089 {
	_add_opcode(@_, 0xCB, 0xB3);
}
# opcode : bit "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_109 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0x4E);
}
# opcode : res "[inline_const]" 6 "," h "[end]"
sub _action_opcode_1090 {
	_add_opcode(@_, 0xCB, 0xB4);
}
# opcode : res "[inline_const]" 6 "," l "[end]"
sub _action_opcode_1091 {
	_add_opcode(@_, 0xCB, 0xB5);
}
# opcode : res "[inline_const]" 7 "," "(" hl ")" "[end]"
sub _action_opcode_1092 {
	_add_opcode(@_, 0xCB, 0xBE);
}
# opcode : res "[inline_const]" 7 "," "(" ix ")" "[end]"
sub _action_opcode_1093 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xBE);
}
# opcode : res "[inline_const]" 7 "," "(" ix ")" "," a "[end]"
sub _action_opcode_1094 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xBF);
}
# opcode : res "[inline_const]" 7 "," "(" ix ")" "," b "[end]"
sub _action_opcode_1095 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xB8);
}
# opcode : res "[inline_const]" 7 "," "(" ix ")" "," c "[end]"
sub _action_opcode_1096 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xB9);
}
# opcode : res "[inline_const]" 7 "," "(" ix ")" "," d "[end]"
sub _action_opcode_1097 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xBA);
}
# opcode : res "[inline_const]" 7 "," "(" ix ")" "," e "[end]"
sub _action_opcode_1098 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xBB);
}
# opcode : res "[inline_const]" 7 "," "(" ix ")" "," h "[end]"
sub _action_opcode_1099 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xBC);
}
# opcode : bit "[inline_const]" 1 "," "(" iy ")" "[end]"
sub _action_opcode_110 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x4E);
}
# opcode : res "[inline_const]" 7 "," "(" ix ")" "," l "[end]"
sub _action_opcode_1100 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xBD);
}
# opcode : res "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1101 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xBE);
}
# opcode : res "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1102 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xBF);
}
# opcode : res "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1103 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xB8);
}
# opcode : res "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1104 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xB9);
}
# opcode : res "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1105 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xBA);
}
# opcode : res "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1106 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xBB);
}
# opcode : res "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1107 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xBC);
}
# opcode : res "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1108 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xBD);
}
# opcode : res "[inline_const]" 7 "," "(" iy ")" "[end]"
sub _action_opcode_1109 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xBE);
}
# opcode : bit "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_111 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0x4E);
}
# opcode : res "[inline_const]" 7 "," "(" iy ")" "," a "[end]"
sub _action_opcode_1110 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xBF);
}
# opcode : res "[inline_const]" 7 "," "(" iy ")" "," b "[end]"
sub _action_opcode_1111 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xB8);
}
# opcode : res "[inline_const]" 7 "," "(" iy ")" "," c "[end]"
sub _action_opcode_1112 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xB9);
}
# opcode : res "[inline_const]" 7 "," "(" iy ")" "," d "[end]"
sub _action_opcode_1113 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xBA);
}
# opcode : res "[inline_const]" 7 "," "(" iy ")" "," e "[end]"
sub _action_opcode_1114 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xBB);
}
# opcode : res "[inline_const]" 7 "," "(" iy ")" "," h "[end]"
sub _action_opcode_1115 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xBC);
}
# opcode : res "[inline_const]" 7 "," "(" iy ")" "," l "[end]"
sub _action_opcode_1116 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xBD);
}
# opcode : res "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1117 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xBE);
}
# opcode : res "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1118 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xBF);
}
# opcode : res "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1119 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xB8);
}
# opcode : bit "[inline_const]" 1 "," a "[end]"
sub _action_opcode_112 {
	_add_opcode(@_, 0xCB, 0x4F);
}
# opcode : res "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1120 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xB9);
}
# opcode : res "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1121 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xBA);
}
# opcode : res "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1122 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xBB);
}
# opcode : res "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1123 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xBC);
}
# opcode : res "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1124 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xBD);
}
# opcode : res "[inline_const]" 7 "," a "[end]"
sub _action_opcode_1125 {
	_add_opcode(@_, 0xCB, 0xBF);
}
# opcode : res "[inline_const]" 7 "," b "[end]"
sub _action_opcode_1126 {
	_add_opcode(@_, 0xCB, 0xB8);
}
# opcode : res "[inline_const]" 7 "," c "[end]"
sub _action_opcode_1127 {
	_add_opcode(@_, 0xCB, 0xB9);
}
# opcode : res "[inline_const]" 7 "," d "[end]"
sub _action_opcode_1128 {
	_add_opcode(@_, 0xCB, 0xBA);
}
# opcode : res "[inline_const]" 7 "," e "[end]"
sub _action_opcode_1129 {
	_add_opcode(@_, 0xCB, 0xBB);
}
# opcode : bit "[inline_const]" 1 "," b "[end]"
sub _action_opcode_113 {
	_add_opcode(@_, 0xCB, 0x48);
}
# opcode : res "[inline_const]" 7 "," h "[end]"
sub _action_opcode_1130 {
	_add_opcode(@_, 0xCB, 0xBC);
}
# opcode : res "[inline_const]" 7 "," l "[end]"
sub _action_opcode_1131 {
	_add_opcode(@_, 0xCB, 0xBD);
}
# opcode : ret "[end]"
sub _action_opcode_1132 {
	_add_opcode(@_, 0xC9);
}
# opcode : ret c "[end]"
sub _action_opcode_1133 {
	_add_opcode(@_, 0xD8);
}
# opcode : ret m "[end]"
sub _action_opcode_1134 {
	_add_opcode(@_, 0xF8);
}
# opcode : ret nc "[end]"
sub _action_opcode_1135 {
	_add_opcode(@_, 0xD0);
}
# opcode : ret nz "[end]"
sub _action_opcode_1136 {
	_add_opcode(@_, 0xC0);
}
# opcode : ret p "[end]"
sub _action_opcode_1137 {
	_add_opcode(@_, 0xF0);
}
# opcode : ret pe "[end]"
sub _action_opcode_1138 {
	_add_opcode(@_, 0xE8);
}
# opcode : ret po "[end]"
sub _action_opcode_1139 {
	_add_opcode(@_, 0xE0);
}
# opcode : bit "[inline_const]" 1 "," c "[end]"
sub _action_opcode_114 {
	_add_opcode(@_, 0xCB, 0x49);
}
# opcode : ret z "[end]"
sub _action_opcode_1140 {
	_add_opcode(@_, 0xC8);
}
# opcode : reti "[end]"
sub _action_opcode_1141 {
	_add_opcode(@_, 0xED, 0x4D);
}
# opcode : retn "[end]"
sub _action_opcode_1142 {
	_add_opcode(@_, 0xED, 0x45);
}
# opcode : rl "(" hl ")" "[end]"
sub _action_opcode_1143 {
	_add_opcode(@_, 0xCB, 0x16);
}
# opcode : rl "(" ix ")" "[end]"
sub _action_opcode_1144 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x16);
}
# opcode : rl "(" ix ")" "," a "[end]"
sub _action_opcode_1145 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x17);
}
# opcode : rl "(" ix ")" "," b "[end]"
sub _action_opcode_1146 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x10);
}
# opcode : rl "(" ix ")" "," c "[end]"
sub _action_opcode_1147 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x11);
}
# opcode : rl "(" ix ")" "," d "[end]"
sub _action_opcode_1148 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x12);
}
# opcode : rl "(" ix ")" "," e "[end]"
sub _action_opcode_1149 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x13);
}
# opcode : bit "[inline_const]" 1 "," d "[end]"
sub _action_opcode_115 {
	_add_opcode(@_, 0xCB, 0x4A);
}
# opcode : rl "(" ix ")" "," h "[end]"
sub _action_opcode_1150 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x14);
}
# opcode : rl "(" ix ")" "," l "[end]"
sub _action_opcode_1151 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x15);
}
# opcode : rl "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1152 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x16);
}
# opcode : rl "(" ix "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1153 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x17);
}
# opcode : rl "(" ix "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1154 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x10);
}
# opcode : rl "(" ix "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1155 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x11);
}
# opcode : rl "(" ix "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1156 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x12);
}
# opcode : rl "(" ix "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1157 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x13);
}
# opcode : rl "(" ix "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1158 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x14);
}
# opcode : rl "(" ix "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1159 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x15);
}
# opcode : bit "[inline_const]" 1 "," e "[end]"
sub _action_opcode_116 {
	_add_opcode(@_, 0xCB, 0x4B);
}
# opcode : rl "(" iy ")" "[end]"
sub _action_opcode_1160 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x16);
}
# opcode : rl "(" iy ")" "," a "[end]"
sub _action_opcode_1161 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x17);
}
# opcode : rl "(" iy ")" "," b "[end]"
sub _action_opcode_1162 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x10);
}
# opcode : rl "(" iy ")" "," c "[end]"
sub _action_opcode_1163 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x11);
}
# opcode : rl "(" iy ")" "," d "[end]"
sub _action_opcode_1164 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x12);
}
# opcode : rl "(" iy ")" "," e "[end]"
sub _action_opcode_1165 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x13);
}
# opcode : rl "(" iy ")" "," h "[end]"
sub _action_opcode_1166 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x14);
}
# opcode : rl "(" iy ")" "," l "[end]"
sub _action_opcode_1167 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x15);
}
# opcode : rl "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1168 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x16);
}
# opcode : rl "(" iy "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1169 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x17);
}
# opcode : bit "[inline_const]" 1 "," h "[end]"
sub _action_opcode_117 {
	_add_opcode(@_, 0xCB, 0x4C);
}
# opcode : rl "(" iy "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1170 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x10);
}
# opcode : rl "(" iy "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1171 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x11);
}
# opcode : rl "(" iy "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1172 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x12);
}
# opcode : rl "(" iy "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1173 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x13);
}
# opcode : rl "(" iy "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1174 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x14);
}
# opcode : rl "(" iy "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1175 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x15);
}
# opcode : rl a "[end]"
sub _action_opcode_1176 {
	_add_opcode(@_, 0xCB, 0x17);
}
# opcode : rl b "[end]"
sub _action_opcode_1177 {
	_add_opcode(@_, 0xCB, 0x10);
}
# opcode : rl bc "[end]"
sub _action_opcode_1178 {
	_add_opcode(@_, 0xCB, 0x11, 0xCB, 0x10);
}
# opcode : rl c "[end]"
sub _action_opcode_1179 {
	_add_opcode(@_, 0xCB, 0x11);
}
# opcode : bit "[inline_const]" 1 "," l "[end]"
sub _action_opcode_118 {
	_add_opcode(@_, 0xCB, 0x4D);
}
# opcode : rl d "[end]"
sub _action_opcode_1180 {
	_add_opcode(@_, 0xCB, 0x12);
}
# opcode : rl de "[end]"
sub _action_opcode_1181 {
	_add_opcode(@_, 0xCB, 0x13, 0xCB, 0x12);
}
# opcode : rl e "[end]"
sub _action_opcode_1182 {
	_add_opcode(@_, 0xCB, 0x13);
}
# opcode : rl h "[end]"
sub _action_opcode_1183 {
	_add_opcode(@_, 0xCB, 0x14);
}
# opcode : rl hl "[end]"
sub _action_opcode_1184 {
	_add_opcode(@_, 0xCB, 0x15, 0xCB, 0x14);
}
# opcode : rl l "[end]"
sub _action_opcode_1185 {
	_add_opcode(@_, 0xCB, 0x15);
}
# opcode : rla "[end]"
sub _action_opcode_1186 {
	_add_opcode(@_, 0x17);
}
# opcode : rlc "(" hl ")" "[end]"
sub _action_opcode_1187 {
	_add_opcode(@_, 0xCB, 0x06);
}
# opcode : rlc "(" ix ")" "[end]"
sub _action_opcode_1188 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x06);
}
# opcode : rlc "(" ix ")" "," a "[end]"
sub _action_opcode_1189 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x07);
}
# opcode : bit "[inline_const]" 2 "," "(" hl ")" "[end]"
sub _action_opcode_119 {
	_add_opcode(@_, 0xCB, 0x56);
}
# opcode : rlc "(" ix ")" "," b "[end]"
sub _action_opcode_1190 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x00);
}
# opcode : rlc "(" ix ")" "," c "[end]"
sub _action_opcode_1191 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x01);
}
# opcode : rlc "(" ix ")" "," d "[end]"
sub _action_opcode_1192 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x02);
}
# opcode : rlc "(" ix ")" "," e "[end]"
sub _action_opcode_1193 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x03);
}
# opcode : rlc "(" ix ")" "," h "[end]"
sub _action_opcode_1194 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x04);
}
# opcode : rlc "(" ix ")" "," l "[end]"
sub _action_opcode_1195 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x05);
}
# opcode : rlc "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1196 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x06);
}
# opcode : rlc "(" ix "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1197 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x07);
}
# opcode : rlc "(" ix "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1198 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x00);
}
# opcode : rlc "(" ix "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1199 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x01);
}
# opcode : bit "[inline_const]" 2 "," "(" ix ")" "[end]"
sub _action_opcode_120 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x56);
}
# opcode : rlc "(" ix "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1200 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x02);
}
# opcode : rlc "(" ix "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1201 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x03);
}
# opcode : rlc "(" ix "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1202 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x04);
}
# opcode : rlc "(" ix "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1203 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x05);
}
# opcode : rlc "(" iy ")" "[end]"
sub _action_opcode_1204 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x06);
}
# opcode : rlc "(" iy ")" "," a "[end]"
sub _action_opcode_1205 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x07);
}
# opcode : rlc "(" iy ")" "," b "[end]"
sub _action_opcode_1206 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x00);
}
# opcode : rlc "(" iy ")" "," c "[end]"
sub _action_opcode_1207 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x01);
}
# opcode : rlc "(" iy ")" "," d "[end]"
sub _action_opcode_1208 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x02);
}
# opcode : rlc "(" iy ")" "," e "[end]"
sub _action_opcode_1209 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x03);
}
# opcode : bit "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_121 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0x56);
}
# opcode : rlc "(" iy ")" "," h "[end]"
sub _action_opcode_1210 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x04);
}
# opcode : rlc "(" iy ")" "," l "[end]"
sub _action_opcode_1211 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x05);
}
# opcode : rlc "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1212 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x06);
}
# opcode : rlc "(" iy "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1213 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x07);
}
# opcode : rlc "(" iy "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1214 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x00);
}
# opcode : rlc "(" iy "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1215 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x01);
}
# opcode : rlc "(" iy "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1216 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x02);
}
# opcode : rlc "(" iy "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1217 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x03);
}
# opcode : rlc "(" iy "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1218 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x04);
}
# opcode : rlc "(" iy "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1219 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x05);
}
# opcode : bit "[inline_const]" 2 "," "(" iy ")" "[end]"
sub _action_opcode_122 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x56);
}
# opcode : rlc a "[end]"
sub _action_opcode_1220 {
	_add_opcode(@_, 0xCB, 0x07);
}
# opcode : rlc b "[end]"
sub _action_opcode_1221 {
	_add_opcode(@_, 0xCB, 0x00);
}
# opcode : rlc c "[end]"
sub _action_opcode_1222 {
	_add_opcode(@_, 0xCB, 0x01);
}
# opcode : rlc d "[end]"
sub _action_opcode_1223 {
	_add_opcode(@_, 0xCB, 0x02);
}
# opcode : rlc e "[end]"
sub _action_opcode_1224 {
	_add_opcode(@_, 0xCB, 0x03);
}
# opcode : rlc h "[end]"
sub _action_opcode_1225 {
	_add_opcode(@_, 0xCB, 0x04);
}
# opcode : rlc l "[end]"
sub _action_opcode_1226 {
	_add_opcode(@_, 0xCB, 0x05);
}
# opcode : rlca "[end]"
sub _action_opcode_1227 {
	_add_opcode(@_, 0x07);
}
# opcode : rld "[end]"
sub _action_opcode_1228 {
	_add_opcode(@_, 0xED, 0x6F);
}
# opcode : rr "(" hl ")" "[end]"
sub _action_opcode_1229 {
	_add_opcode(@_, 0xCB, 0x1E);
}
# opcode : bit "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_123 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0x56);
}
# opcode : rr "(" ix ")" "[end]"
sub _action_opcode_1230 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x1E);
}
# opcode : rr "(" ix ")" "," a "[end]"
sub _action_opcode_1231 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x1F);
}
# opcode : rr "(" ix ")" "," b "[end]"
sub _action_opcode_1232 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x18);
}
# opcode : rr "(" ix ")" "," c "[end]"
sub _action_opcode_1233 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x19);
}
# opcode : rr "(" ix ")" "," d "[end]"
sub _action_opcode_1234 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x1A);
}
# opcode : rr "(" ix ")" "," e "[end]"
sub _action_opcode_1235 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x1B);
}
# opcode : rr "(" ix ")" "," h "[end]"
sub _action_opcode_1236 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x1C);
}
# opcode : rr "(" ix ")" "," l "[end]"
sub _action_opcode_1237 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x1D);
}
# opcode : rr "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1238 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x1E);
}
# opcode : rr "(" ix "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1239 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x1F);
}
# opcode : bit "[inline_const]" 2 "," a "[end]"
sub _action_opcode_124 {
	_add_opcode(@_, 0xCB, 0x57);
}
# opcode : rr "(" ix "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1240 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x18);
}
# opcode : rr "(" ix "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1241 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x19);
}
# opcode : rr "(" ix "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1242 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x1A);
}
# opcode : rr "(" ix "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1243 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x1B);
}
# opcode : rr "(" ix "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1244 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x1C);
}
# opcode : rr "(" ix "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1245 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x1D);
}
# opcode : rr "(" iy ")" "[end]"
sub _action_opcode_1246 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x1E);
}
# opcode : rr "(" iy ")" "," a "[end]"
sub _action_opcode_1247 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x1F);
}
# opcode : rr "(" iy ")" "," b "[end]"
sub _action_opcode_1248 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x18);
}
# opcode : rr "(" iy ")" "," c "[end]"
sub _action_opcode_1249 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x19);
}
# opcode : bit "[inline_const]" 2 "," b "[end]"
sub _action_opcode_125 {
	_add_opcode(@_, 0xCB, 0x50);
}
# opcode : rr "(" iy ")" "," d "[end]"
sub _action_opcode_1250 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x1A);
}
# opcode : rr "(" iy ")" "," e "[end]"
sub _action_opcode_1251 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x1B);
}
# opcode : rr "(" iy ")" "," h "[end]"
sub _action_opcode_1252 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x1C);
}
# opcode : rr "(" iy ")" "," l "[end]"
sub _action_opcode_1253 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x1D);
}
# opcode : rr "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1254 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x1E);
}
# opcode : rr "(" iy "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1255 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x1F);
}
# opcode : rr "(" iy "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1256 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x18);
}
# opcode : rr "(" iy "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1257 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x19);
}
# opcode : rr "(" iy "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1258 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x1A);
}
# opcode : rr "(" iy "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1259 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x1B);
}
# opcode : bit "[inline_const]" 2 "," c "[end]"
sub _action_opcode_126 {
	_add_opcode(@_, 0xCB, 0x51);
}
# opcode : rr "(" iy "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1260 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x1C);
}
# opcode : rr "(" iy "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1261 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x1D);
}
# opcode : rr a "[end]"
sub _action_opcode_1262 {
	_add_opcode(@_, 0xCB, 0x1F);
}
# opcode : rr b "[end]"
sub _action_opcode_1263 {
	_add_opcode(@_, 0xCB, 0x18);
}
# opcode : rr bc "[end]"
sub _action_opcode_1264 {
	_add_opcode(@_, 0xCB, 0x18, 0xCB, 0x19);
}
# opcode : rr c "[end]"
sub _action_opcode_1265 {
	_add_opcode(@_, 0xCB, 0x19);
}
# opcode : rr d "[end]"
sub _action_opcode_1266 {
	_add_opcode(@_, 0xCB, 0x1A);
}
# opcode : rr de "[end]"
sub _action_opcode_1267 {
	_add_opcode(@_, 0xCB, 0x1A, 0xCB, 0x1B);
}
# opcode : rr e "[end]"
sub _action_opcode_1268 {
	_add_opcode(@_, 0xCB, 0x1B);
}
# opcode : rr h "[end]"
sub _action_opcode_1269 {
	_add_opcode(@_, 0xCB, 0x1C);
}
# opcode : bit "[inline_const]" 2 "," d "[end]"
sub _action_opcode_127 {
	_add_opcode(@_, 0xCB, 0x52);
}
# opcode : rr hl "[end]"
sub _action_opcode_1270 {
	_add_opcode(@_, 0xCB, 0x1C, 0xCB, 0x1D);
}
# opcode : rr l "[end]"
sub _action_opcode_1271 {
	_add_opcode(@_, 0xCB, 0x1D);
}
# opcode : rra "[end]"
sub _action_opcode_1272 {
	_add_opcode(@_, 0x1F);
}
# opcode : rrc "(" hl ")" "[end]"
sub _action_opcode_1273 {
	_add_opcode(@_, 0xCB, 0x0E);
}
# opcode : rrc "(" ix ")" "[end]"
sub _action_opcode_1274 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x0E);
}
# opcode : rrc "(" ix ")" "," a "[end]"
sub _action_opcode_1275 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x0F);
}
# opcode : rrc "(" ix ")" "," b "[end]"
sub _action_opcode_1276 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x08);
}
# opcode : rrc "(" ix ")" "," c "[end]"
sub _action_opcode_1277 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x09);
}
# opcode : rrc "(" ix ")" "," d "[end]"
sub _action_opcode_1278 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x0A);
}
# opcode : rrc "(" ix ")" "," e "[end]"
sub _action_opcode_1279 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x0B);
}
# opcode : bit "[inline_const]" 2 "," e "[end]"
sub _action_opcode_128 {
	_add_opcode(@_, 0xCB, 0x53);
}
# opcode : rrc "(" ix ")" "," h "[end]"
sub _action_opcode_1280 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x0C);
}
# opcode : rrc "(" ix ")" "," l "[end]"
sub _action_opcode_1281 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x0D);
}
# opcode : rrc "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1282 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x0E);
}
# opcode : rrc "(" ix "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1283 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x0F);
}
# opcode : rrc "(" ix "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1284 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x08);
}
# opcode : rrc "(" ix "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1285 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x09);
}
# opcode : rrc "(" ix "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1286 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x0A);
}
# opcode : rrc "(" ix "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1287 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x0B);
}
# opcode : rrc "(" ix "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1288 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x0C);
}
# opcode : rrc "(" ix "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1289 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x0D);
}
# opcode : bit "[inline_const]" 2 "," h "[end]"
sub _action_opcode_129 {
	_add_opcode(@_, 0xCB, 0x54);
}
# opcode : rrc "(" iy ")" "[end]"
sub _action_opcode_1290 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x0E);
}
# opcode : rrc "(" iy ")" "," a "[end]"
sub _action_opcode_1291 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x0F);
}
# opcode : rrc "(" iy ")" "," b "[end]"
sub _action_opcode_1292 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x08);
}
# opcode : rrc "(" iy ")" "," c "[end]"
sub _action_opcode_1293 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x09);
}
# opcode : rrc "(" iy ")" "," d "[end]"
sub _action_opcode_1294 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x0A);
}
# opcode : rrc "(" iy ")" "," e "[end]"
sub _action_opcode_1295 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x0B);
}
# opcode : rrc "(" iy ")" "," h "[end]"
sub _action_opcode_1296 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x0C);
}
# opcode : rrc "(" iy ")" "," l "[end]"
sub _action_opcode_1297 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x0D);
}
# opcode : rrc "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1298 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x0E);
}
# opcode : rrc "(" iy "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1299 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x0F);
}
# opcode : bit "[inline_const]" 2 "," l "[end]"
sub _action_opcode_130 {
	_add_opcode(@_, 0xCB, 0x55);
}
# opcode : rrc "(" iy "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1300 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x08);
}
# opcode : rrc "(" iy "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1301 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x09);
}
# opcode : rrc "(" iy "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1302 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x0A);
}
# opcode : rrc "(" iy "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1303 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x0B);
}
# opcode : rrc "(" iy "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1304 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x0C);
}
# opcode : rrc "(" iy "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1305 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x0D);
}
# opcode : rrc a "[end]"
sub _action_opcode_1306 {
	_add_opcode(@_, 0xCB, 0x0F);
}
# opcode : rrc b "[end]"
sub _action_opcode_1307 {
	_add_opcode(@_, 0xCB, 0x08);
}
# opcode : rrc c "[end]"
sub _action_opcode_1308 {
	_add_opcode(@_, 0xCB, 0x09);
}
# opcode : rrc d "[end]"
sub _action_opcode_1309 {
	_add_opcode(@_, 0xCB, 0x0A);
}
# opcode : bit "[inline_const]" 3 "," "(" hl ")" "[end]"
sub _action_opcode_131 {
	_add_opcode(@_, 0xCB, 0x5E);
}
# opcode : rrc e "[end]"
sub _action_opcode_1310 {
	_add_opcode(@_, 0xCB, 0x0B);
}
# opcode : rrc h "[end]"
sub _action_opcode_1311 {
	_add_opcode(@_, 0xCB, 0x0C);
}
# opcode : rrc l "[end]"
sub _action_opcode_1312 {
	_add_opcode(@_, 0xCB, 0x0D);
}
# opcode : rrca "[end]"
sub _action_opcode_1313 {
	_add_opcode(@_, 0x0F);
}
# opcode : rrd "[end]"
sub _action_opcode_1314 {
	_add_opcode(@_, 0xED, 0x67);
}
# opcode : rst "[inline_const]" 0 "[end]"
sub _action_opcode_1315 {
	_add_opcode(@_, 0xC7);
}
# opcode : rst "[inline_const]" 1 "[end]"
sub _action_opcode_1316 {
	_add_opcode(@_, 0xCF);
}
# opcode : rst "[inline_const]" 16 "[end]"
sub _action_opcode_1317 {
	_add_opcode(@_, 0xD7);
}
# opcode : rst "[inline_const]" 24 "[end]"
sub _action_opcode_1318 {
	_add_opcode(@_, 0xDF);
}
# opcode : rst "[inline_const]" 32 "[end]"
sub _action_opcode_1319 {
	_add_opcode(@_, 0xE7);
}
# opcode : bit "[inline_const]" 3 "," "(" ix ")" "[end]"
sub _action_opcode_132 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x5E);
}
# opcode : rst "[inline_const]" 40 "[end]"
sub _action_opcode_1320 {
	_add_opcode(@_, 0xEF);
}
# opcode : rst "[inline_const]" 48 "[end]"
sub _action_opcode_1321 {
	_add_opcode(@_, 0xF7);
}
# opcode : rst "[inline_const]" 56 "[end]"
sub _action_opcode_1322 {
	_add_opcode(@_, 0xFF);
}
# opcode : sbc a "," "(" hl ")" "[end]"
sub _action_opcode_1323 {
	_add_opcode(@_, 0x9E);
}
# opcode : sbc a "," "(" ix ")" "[end]"
sub _action_opcode_1324 {
	_add_opcode(@_, 0xDD, 0x9E, 0x00);
}
# opcode : sbc a "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1325 {
	_add_opcode(@_, 0xDD, 0x9E, $_[ARGS][6]);
}
# opcode : sbc a "," "(" iy ")" "[end]"
sub _action_opcode_1326 {
	_add_opcode(@_, 0xFD, 0x9E, 0x00);
}
# opcode : sbc a "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1327 {
	_add_opcode(@_, 0xFD, 0x9E, $_[ARGS][6]);
}
# opcode : sbc a "," "[expr_N]" "[end]"
sub _action_opcode_1328 {
	_add_opcode(@_, 0xDE, $_[ARGS][3]);
}
# opcode : sbc a "," a "[end]"
sub _action_opcode_1329 {
	_add_opcode(@_, 0x9F);
}
# opcode : bit "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_133 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0x5E);
}
# opcode : sbc a "," b "[end]"
sub _action_opcode_1330 {
	_add_opcode(@_, 0x98);
}
# opcode : sbc a "," c "[end]"
sub _action_opcode_1331 {
	_add_opcode(@_, 0x99);
}
# opcode : sbc a "," d "[end]"
sub _action_opcode_1332 {
	_add_opcode(@_, 0x9A);
}
# opcode : sbc a "," e "[end]"
sub _action_opcode_1333 {
	_add_opcode(@_, 0x9B);
}
# opcode : sbc a "," h "[end]"
sub _action_opcode_1334 {
	_add_opcode(@_, 0x9C);
}
# opcode : sbc a "," hx "[end]"
sub _action_opcode_1335 {
	_add_opcode(@_, 0xDD, 0x9C);
}
# opcode : sbc a "," hy "[end]"
sub _action_opcode_1336 {
	_add_opcode(@_, 0xFD, 0x9C);
}
# opcode : sbc a "," ixl "[end]"
sub _action_opcode_1337 {
	_add_opcode(@_, 0xDD, 0x9D);
}
# opcode : sbc a "," iyl "[end]"
sub _action_opcode_1338 {
	_add_opcode(@_, 0xFD, 0x9D);
}
# opcode : sbc a "," l "[end]"
sub _action_opcode_1339 {
	_add_opcode(@_, 0x9D);
}
# opcode : bit "[inline_const]" 3 "," "(" iy ")" "[end]"
sub _action_opcode_134 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x5E);
}
# opcode : sbc hl "," bc "[end]"
sub _action_opcode_1340 {
	_add_opcode(@_, 0xED, 0x42);
}
# opcode : sbc hl "," de "[end]"
sub _action_opcode_1341 {
	_add_opcode(@_, 0xED, 0x52);
}
# opcode : sbc hl "," hl "[end]"
sub _action_opcode_1342 {
	_add_opcode(@_, 0xED, 0x62);
}
# opcode : sbc hl "," sp "[end]"
sub _action_opcode_1343 {
	_add_opcode(@_, 0xED, 0x72);
}
# opcode : scf "[end]"
sub _action_opcode_1344 {
	_add_opcode(@_, 0x37);
}
# opcode : set "[inline_const]" 0 "," "(" hl ")" "[end]"
sub _action_opcode_1345 {
	_add_opcode(@_, 0xCB, 0xC6);
}
# opcode : set "[inline_const]" 0 "," "(" ix ")" "[end]"
sub _action_opcode_1346 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xC6);
}
# opcode : set "[inline_const]" 0 "," "(" ix ")" "," a "[end]"
sub _action_opcode_1347 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xC7);
}
# opcode : set "[inline_const]" 0 "," "(" ix ")" "," b "[end]"
sub _action_opcode_1348 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xC0);
}
# opcode : set "[inline_const]" 0 "," "(" ix ")" "," c "[end]"
sub _action_opcode_1349 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xC1);
}
# opcode : bit "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_135 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0x5E);
}
# opcode : set "[inline_const]" 0 "," "(" ix ")" "," d "[end]"
sub _action_opcode_1350 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xC2);
}
# opcode : set "[inline_const]" 0 "," "(" ix ")" "," e "[end]"
sub _action_opcode_1351 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xC3);
}
# opcode : set "[inline_const]" 0 "," "(" ix ")" "," h "[end]"
sub _action_opcode_1352 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xC4);
}
# opcode : set "[inline_const]" 0 "," "(" ix ")" "," l "[end]"
sub _action_opcode_1353 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xC5);
}
# opcode : set "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1354 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xC6);
}
# opcode : set "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1355 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xC7);
}
# opcode : set "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1356 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xC0);
}
# opcode : set "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1357 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xC1);
}
# opcode : set "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1358 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xC2);
}
# opcode : set "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1359 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xC3);
}
# opcode : bit "[inline_const]" 3 "," a "[end]"
sub _action_opcode_136 {
	_add_opcode(@_, 0xCB, 0x5F);
}
# opcode : set "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1360 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xC4);
}
# opcode : set "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1361 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xC5);
}
# opcode : set "[inline_const]" 0 "," "(" iy ")" "[end]"
sub _action_opcode_1362 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xC6);
}
# opcode : set "[inline_const]" 0 "," "(" iy ")" "," a "[end]"
sub _action_opcode_1363 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xC7);
}
# opcode : set "[inline_const]" 0 "," "(" iy ")" "," b "[end]"
sub _action_opcode_1364 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xC0);
}
# opcode : set "[inline_const]" 0 "," "(" iy ")" "," c "[end]"
sub _action_opcode_1365 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xC1);
}
# opcode : set "[inline_const]" 0 "," "(" iy ")" "," d "[end]"
sub _action_opcode_1366 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xC2);
}
# opcode : set "[inline_const]" 0 "," "(" iy ")" "," e "[end]"
sub _action_opcode_1367 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xC3);
}
# opcode : set "[inline_const]" 0 "," "(" iy ")" "," h "[end]"
sub _action_opcode_1368 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xC4);
}
# opcode : set "[inline_const]" 0 "," "(" iy ")" "," l "[end]"
sub _action_opcode_1369 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xC5);
}
# opcode : bit "[inline_const]" 3 "," b "[end]"
sub _action_opcode_137 {
	_add_opcode(@_, 0xCB, 0x58);
}
# opcode : set "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1370 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xC6);
}
# opcode : set "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1371 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xC7);
}
# opcode : set "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1372 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xC0);
}
# opcode : set "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1373 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xC1);
}
# opcode : set "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1374 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xC2);
}
# opcode : set "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1375 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xC3);
}
# opcode : set "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1376 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xC4);
}
# opcode : set "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1377 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xC5);
}
# opcode : set "[inline_const]" 0 "," a "[end]"
sub _action_opcode_1378 {
	_add_opcode(@_, 0xCB, 0xC7);
}
# opcode : set "[inline_const]" 0 "," b "[end]"
sub _action_opcode_1379 {
	_add_opcode(@_, 0xCB, 0xC0);
}
# opcode : bit "[inline_const]" 3 "," c "[end]"
sub _action_opcode_138 {
	_add_opcode(@_, 0xCB, 0x59);
}
# opcode : set "[inline_const]" 0 "," c "[end]"
sub _action_opcode_1380 {
	_add_opcode(@_, 0xCB, 0xC1);
}
# opcode : set "[inline_const]" 0 "," d "[end]"
sub _action_opcode_1381 {
	_add_opcode(@_, 0xCB, 0xC2);
}
# opcode : set "[inline_const]" 0 "," e "[end]"
sub _action_opcode_1382 {
	_add_opcode(@_, 0xCB, 0xC3);
}
# opcode : set "[inline_const]" 0 "," h "[end]"
sub _action_opcode_1383 {
	_add_opcode(@_, 0xCB, 0xC4);
}
# opcode : set "[inline_const]" 0 "," l "[end]"
sub _action_opcode_1384 {
	_add_opcode(@_, 0xCB, 0xC5);
}
# opcode : set "[inline_const]" 1 "," "(" hl ")" "[end]"
sub _action_opcode_1385 {
	_add_opcode(@_, 0xCB, 0xCE);
}
# opcode : set "[inline_const]" 1 "," "(" ix ")" "[end]"
sub _action_opcode_1386 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xCE);
}
# opcode : set "[inline_const]" 1 "," "(" ix ")" "," a "[end]"
sub _action_opcode_1387 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xCF);
}
# opcode : set "[inline_const]" 1 "," "(" ix ")" "," b "[end]"
sub _action_opcode_1388 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xC8);
}
# opcode : set "[inline_const]" 1 "," "(" ix ")" "," c "[end]"
sub _action_opcode_1389 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xC9);
}
# opcode : bit "[inline_const]" 3 "," d "[end]"
sub _action_opcode_139 {
	_add_opcode(@_, 0xCB, 0x5A);
}
# opcode : set "[inline_const]" 1 "," "(" ix ")" "," d "[end]"
sub _action_opcode_1390 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xCA);
}
# opcode : set "[inline_const]" 1 "," "(" ix ")" "," e "[end]"
sub _action_opcode_1391 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xCB);
}
# opcode : set "[inline_const]" 1 "," "(" ix ")" "," h "[end]"
sub _action_opcode_1392 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xCC);
}
# opcode : set "[inline_const]" 1 "," "(" ix ")" "," l "[end]"
sub _action_opcode_1393 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xCD);
}
# opcode : set "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1394 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xCE);
}
# opcode : set "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1395 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xCF);
}
# opcode : set "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1396 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xC8);
}
# opcode : set "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1397 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xC9);
}
# opcode : set "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1398 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xCA);
}
# opcode : set "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1399 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xCB);
}
# opcode : bit "[inline_const]" 3 "," e "[end]"
sub _action_opcode_140 {
	_add_opcode(@_, 0xCB, 0x5B);
}
# opcode : set "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1400 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xCC);
}
# opcode : set "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1401 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xCD);
}
# opcode : set "[inline_const]" 1 "," "(" iy ")" "[end]"
sub _action_opcode_1402 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xCE);
}
# opcode : set "[inline_const]" 1 "," "(" iy ")" "," a "[end]"
sub _action_opcode_1403 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xCF);
}
# opcode : set "[inline_const]" 1 "," "(" iy ")" "," b "[end]"
sub _action_opcode_1404 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xC8);
}
# opcode : set "[inline_const]" 1 "," "(" iy ")" "," c "[end]"
sub _action_opcode_1405 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xC9);
}
# opcode : set "[inline_const]" 1 "," "(" iy ")" "," d "[end]"
sub _action_opcode_1406 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xCA);
}
# opcode : set "[inline_const]" 1 "," "(" iy ")" "," e "[end]"
sub _action_opcode_1407 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xCB);
}
# opcode : set "[inline_const]" 1 "," "(" iy ")" "," h "[end]"
sub _action_opcode_1408 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xCC);
}
# opcode : set "[inline_const]" 1 "," "(" iy ")" "," l "[end]"
sub _action_opcode_1409 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xCD);
}
# opcode : bit "[inline_const]" 3 "," h "[end]"
sub _action_opcode_141 {
	_add_opcode(@_, 0xCB, 0x5C);
}
# opcode : set "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1410 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xCE);
}
# opcode : set "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1411 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xCF);
}
# opcode : set "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1412 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xC8);
}
# opcode : set "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1413 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xC9);
}
# opcode : set "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1414 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xCA);
}
# opcode : set "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1415 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xCB);
}
# opcode : set "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1416 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xCC);
}
# opcode : set "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1417 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xCD);
}
# opcode : set "[inline_const]" 1 "," a "[end]"
sub _action_opcode_1418 {
	_add_opcode(@_, 0xCB, 0xCF);
}
# opcode : set "[inline_const]" 1 "," b "[end]"
sub _action_opcode_1419 {
	_add_opcode(@_, 0xCB, 0xC8);
}
# opcode : bit "[inline_const]" 3 "," l "[end]"
sub _action_opcode_142 {
	_add_opcode(@_, 0xCB, 0x5D);
}
# opcode : set "[inline_const]" 1 "," c "[end]"
sub _action_opcode_1420 {
	_add_opcode(@_, 0xCB, 0xC9);
}
# opcode : set "[inline_const]" 1 "," d "[end]"
sub _action_opcode_1421 {
	_add_opcode(@_, 0xCB, 0xCA);
}
# opcode : set "[inline_const]" 1 "," e "[end]"
sub _action_opcode_1422 {
	_add_opcode(@_, 0xCB, 0xCB);
}
# opcode : set "[inline_const]" 1 "," h "[end]"
sub _action_opcode_1423 {
	_add_opcode(@_, 0xCB, 0xCC);
}
# opcode : set "[inline_const]" 1 "," l "[end]"
sub _action_opcode_1424 {
	_add_opcode(@_, 0xCB, 0xCD);
}
# opcode : set "[inline_const]" 2 "," "(" hl ")" "[end]"
sub _action_opcode_1425 {
	_add_opcode(@_, 0xCB, 0xD6);
}
# opcode : set "[inline_const]" 2 "," "(" ix ")" "[end]"
sub _action_opcode_1426 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xD6);
}
# opcode : set "[inline_const]" 2 "," "(" ix ")" "," a "[end]"
sub _action_opcode_1427 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xD7);
}
# opcode : set "[inline_const]" 2 "," "(" ix ")" "," b "[end]"
sub _action_opcode_1428 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xD0);
}
# opcode : set "[inline_const]" 2 "," "(" ix ")" "," c "[end]"
sub _action_opcode_1429 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xD1);
}
# opcode : bit "[inline_const]" 4 "," "(" hl ")" "[end]"
sub _action_opcode_143 {
	_add_opcode(@_, 0xCB, 0x66);
}
# opcode : set "[inline_const]" 2 "," "(" ix ")" "," d "[end]"
sub _action_opcode_1430 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xD2);
}
# opcode : set "[inline_const]" 2 "," "(" ix ")" "," e "[end]"
sub _action_opcode_1431 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xD3);
}
# opcode : set "[inline_const]" 2 "," "(" ix ")" "," h "[end]"
sub _action_opcode_1432 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xD4);
}
# opcode : set "[inline_const]" 2 "," "(" ix ")" "," l "[end]"
sub _action_opcode_1433 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xD5);
}
# opcode : set "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1434 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xD6);
}
# opcode : set "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1435 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xD7);
}
# opcode : set "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1436 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xD0);
}
# opcode : set "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1437 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xD1);
}
# opcode : set "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1438 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xD2);
}
# opcode : set "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1439 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xD3);
}
# opcode : bit "[inline_const]" 4 "," "(" ix ")" "[end]"
sub _action_opcode_144 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x66);
}
# opcode : set "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1440 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xD4);
}
# opcode : set "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1441 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xD5);
}
# opcode : set "[inline_const]" 2 "," "(" iy ")" "[end]"
sub _action_opcode_1442 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xD6);
}
# opcode : set "[inline_const]" 2 "," "(" iy ")" "," a "[end]"
sub _action_opcode_1443 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xD7);
}
# opcode : set "[inline_const]" 2 "," "(" iy ")" "," b "[end]"
sub _action_opcode_1444 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xD0);
}
# opcode : set "[inline_const]" 2 "," "(" iy ")" "," c "[end]"
sub _action_opcode_1445 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xD1);
}
# opcode : set "[inline_const]" 2 "," "(" iy ")" "," d "[end]"
sub _action_opcode_1446 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xD2);
}
# opcode : set "[inline_const]" 2 "," "(" iy ")" "," e "[end]"
sub _action_opcode_1447 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xD3);
}
# opcode : set "[inline_const]" 2 "," "(" iy ")" "," h "[end]"
sub _action_opcode_1448 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xD4);
}
# opcode : set "[inline_const]" 2 "," "(" iy ")" "," l "[end]"
sub _action_opcode_1449 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xD5);
}
# opcode : bit "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_145 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0x66);
}
# opcode : set "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1450 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xD6);
}
# opcode : set "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1451 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xD7);
}
# opcode : set "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1452 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xD0);
}
# opcode : set "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1453 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xD1);
}
# opcode : set "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1454 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xD2);
}
# opcode : set "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1455 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xD3);
}
# opcode : set "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1456 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xD4);
}
# opcode : set "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1457 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xD5);
}
# opcode : set "[inline_const]" 2 "," a "[end]"
sub _action_opcode_1458 {
	_add_opcode(@_, 0xCB, 0xD7);
}
# opcode : set "[inline_const]" 2 "," b "[end]"
sub _action_opcode_1459 {
	_add_opcode(@_, 0xCB, 0xD0);
}
# opcode : bit "[inline_const]" 4 "," "(" iy ")" "[end]"
sub _action_opcode_146 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x66);
}
# opcode : set "[inline_const]" 2 "," c "[end]"
sub _action_opcode_1460 {
	_add_opcode(@_, 0xCB, 0xD1);
}
# opcode : set "[inline_const]" 2 "," d "[end]"
sub _action_opcode_1461 {
	_add_opcode(@_, 0xCB, 0xD2);
}
# opcode : set "[inline_const]" 2 "," e "[end]"
sub _action_opcode_1462 {
	_add_opcode(@_, 0xCB, 0xD3);
}
# opcode : set "[inline_const]" 2 "," h "[end]"
sub _action_opcode_1463 {
	_add_opcode(@_, 0xCB, 0xD4);
}
# opcode : set "[inline_const]" 2 "," l "[end]"
sub _action_opcode_1464 {
	_add_opcode(@_, 0xCB, 0xD5);
}
# opcode : set "[inline_const]" 3 "," "(" hl ")" "[end]"
sub _action_opcode_1465 {
	_add_opcode(@_, 0xCB, 0xDE);
}
# opcode : set "[inline_const]" 3 "," "(" ix ")" "[end]"
sub _action_opcode_1466 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xDE);
}
# opcode : set "[inline_const]" 3 "," "(" ix ")" "," a "[end]"
sub _action_opcode_1467 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xDF);
}
# opcode : set "[inline_const]" 3 "," "(" ix ")" "," b "[end]"
sub _action_opcode_1468 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xD8);
}
# opcode : set "[inline_const]" 3 "," "(" ix ")" "," c "[end]"
sub _action_opcode_1469 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xD9);
}
# opcode : bit "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_147 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0x66);
}
# opcode : set "[inline_const]" 3 "," "(" ix ")" "," d "[end]"
sub _action_opcode_1470 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xDA);
}
# opcode : set "[inline_const]" 3 "," "(" ix ")" "," e "[end]"
sub _action_opcode_1471 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xDB);
}
# opcode : set "[inline_const]" 3 "," "(" ix ")" "," h "[end]"
sub _action_opcode_1472 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xDC);
}
# opcode : set "[inline_const]" 3 "," "(" ix ")" "," l "[end]"
sub _action_opcode_1473 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xDD);
}
# opcode : set "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1474 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xDE);
}
# opcode : set "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1475 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xDF);
}
# opcode : set "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1476 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xD8);
}
# opcode : set "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1477 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xD9);
}
# opcode : set "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1478 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xDA);
}
# opcode : set "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1479 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xDB);
}
# opcode : bit "[inline_const]" 4 "," a "[end]"
sub _action_opcode_148 {
	_add_opcode(@_, 0xCB, 0x67);
}
# opcode : set "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1480 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xDC);
}
# opcode : set "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1481 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xDD);
}
# opcode : set "[inline_const]" 3 "," "(" iy ")" "[end]"
sub _action_opcode_1482 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xDE);
}
# opcode : set "[inline_const]" 3 "," "(" iy ")" "," a "[end]"
sub _action_opcode_1483 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xDF);
}
# opcode : set "[inline_const]" 3 "," "(" iy ")" "," b "[end]"
sub _action_opcode_1484 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xD8);
}
# opcode : set "[inline_const]" 3 "," "(" iy ")" "," c "[end]"
sub _action_opcode_1485 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xD9);
}
# opcode : set "[inline_const]" 3 "," "(" iy ")" "," d "[end]"
sub _action_opcode_1486 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xDA);
}
# opcode : set "[inline_const]" 3 "," "(" iy ")" "," e "[end]"
sub _action_opcode_1487 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xDB);
}
# opcode : set "[inline_const]" 3 "," "(" iy ")" "," h "[end]"
sub _action_opcode_1488 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xDC);
}
# opcode : set "[inline_const]" 3 "," "(" iy ")" "," l "[end]"
sub _action_opcode_1489 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xDD);
}
# opcode : bit "[inline_const]" 4 "," b "[end]"
sub _action_opcode_149 {
	_add_opcode(@_, 0xCB, 0x60);
}
# opcode : set "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1490 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xDE);
}
# opcode : set "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1491 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xDF);
}
# opcode : set "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1492 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xD8);
}
# opcode : set "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1493 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xD9);
}
# opcode : set "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1494 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xDA);
}
# opcode : set "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1495 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xDB);
}
# opcode : set "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1496 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xDC);
}
# opcode : set "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1497 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xDD);
}
# opcode : set "[inline_const]" 3 "," a "[end]"
sub _action_opcode_1498 {
	_add_opcode(@_, 0xCB, 0xDF);
}
# opcode : set "[inline_const]" 3 "," b "[end]"
sub _action_opcode_1499 {
	_add_opcode(@_, 0xCB, 0xD8);
}
# opcode : bit "[inline_const]" 4 "," c "[end]"
sub _action_opcode_150 {
	_add_opcode(@_, 0xCB, 0x61);
}
# opcode : set "[inline_const]" 3 "," c "[end]"
sub _action_opcode_1500 {
	_add_opcode(@_, 0xCB, 0xD9);
}
# opcode : set "[inline_const]" 3 "," d "[end]"
sub _action_opcode_1501 {
	_add_opcode(@_, 0xCB, 0xDA);
}
# opcode : set "[inline_const]" 3 "," e "[end]"
sub _action_opcode_1502 {
	_add_opcode(@_, 0xCB, 0xDB);
}
# opcode : set "[inline_const]" 3 "," h "[end]"
sub _action_opcode_1503 {
	_add_opcode(@_, 0xCB, 0xDC);
}
# opcode : set "[inline_const]" 3 "," l "[end]"
sub _action_opcode_1504 {
	_add_opcode(@_, 0xCB, 0xDD);
}
# opcode : set "[inline_const]" 4 "," "(" hl ")" "[end]"
sub _action_opcode_1505 {
	_add_opcode(@_, 0xCB, 0xE6);
}
# opcode : set "[inline_const]" 4 "," "(" ix ")" "[end]"
sub _action_opcode_1506 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xE6);
}
# opcode : set "[inline_const]" 4 "," "(" ix ")" "," a "[end]"
sub _action_opcode_1507 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xE7);
}
# opcode : set "[inline_const]" 4 "," "(" ix ")" "," b "[end]"
sub _action_opcode_1508 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xE0);
}
# opcode : set "[inline_const]" 4 "," "(" ix ")" "," c "[end]"
sub _action_opcode_1509 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xE1);
}
# opcode : bit "[inline_const]" 4 "," d "[end]"
sub _action_opcode_151 {
	_add_opcode(@_, 0xCB, 0x62);
}
# opcode : set "[inline_const]" 4 "," "(" ix ")" "," d "[end]"
sub _action_opcode_1510 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xE2);
}
# opcode : set "[inline_const]" 4 "," "(" ix ")" "," e "[end]"
sub _action_opcode_1511 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xE3);
}
# opcode : set "[inline_const]" 4 "," "(" ix ")" "," h "[end]"
sub _action_opcode_1512 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xE4);
}
# opcode : set "[inline_const]" 4 "," "(" ix ")" "," l "[end]"
sub _action_opcode_1513 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xE5);
}
# opcode : set "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1514 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xE6);
}
# opcode : set "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1515 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xE7);
}
# opcode : set "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1516 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xE0);
}
# opcode : set "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1517 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xE1);
}
# opcode : set "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1518 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xE2);
}
# opcode : set "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1519 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xE3);
}
# opcode : bit "[inline_const]" 4 "," e "[end]"
sub _action_opcode_152 {
	_add_opcode(@_, 0xCB, 0x63);
}
# opcode : set "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1520 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xE4);
}
# opcode : set "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1521 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xE5);
}
# opcode : set "[inline_const]" 4 "," "(" iy ")" "[end]"
sub _action_opcode_1522 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xE6);
}
# opcode : set "[inline_const]" 4 "," "(" iy ")" "," a "[end]"
sub _action_opcode_1523 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xE7);
}
# opcode : set "[inline_const]" 4 "," "(" iy ")" "," b "[end]"
sub _action_opcode_1524 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xE0);
}
# opcode : set "[inline_const]" 4 "," "(" iy ")" "," c "[end]"
sub _action_opcode_1525 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xE1);
}
# opcode : set "[inline_const]" 4 "," "(" iy ")" "," d "[end]"
sub _action_opcode_1526 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xE2);
}
# opcode : set "[inline_const]" 4 "," "(" iy ")" "," e "[end]"
sub _action_opcode_1527 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xE3);
}
# opcode : set "[inline_const]" 4 "," "(" iy ")" "," h "[end]"
sub _action_opcode_1528 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xE4);
}
# opcode : set "[inline_const]" 4 "," "(" iy ")" "," l "[end]"
sub _action_opcode_1529 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xE5);
}
# opcode : bit "[inline_const]" 4 "," h "[end]"
sub _action_opcode_153 {
	_add_opcode(@_, 0xCB, 0x64);
}
# opcode : set "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1530 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xE6);
}
# opcode : set "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1531 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xE7);
}
# opcode : set "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1532 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xE0);
}
# opcode : set "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1533 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xE1);
}
# opcode : set "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1534 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xE2);
}
# opcode : set "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1535 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xE3);
}
# opcode : set "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1536 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xE4);
}
# opcode : set "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1537 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xE5);
}
# opcode : set "[inline_const]" 4 "," a "[end]"
sub _action_opcode_1538 {
	_add_opcode(@_, 0xCB, 0xE7);
}
# opcode : set "[inline_const]" 4 "," b "[end]"
sub _action_opcode_1539 {
	_add_opcode(@_, 0xCB, 0xE0);
}
# opcode : bit "[inline_const]" 4 "," l "[end]"
sub _action_opcode_154 {
	_add_opcode(@_, 0xCB, 0x65);
}
# opcode : set "[inline_const]" 4 "," c "[end]"
sub _action_opcode_1540 {
	_add_opcode(@_, 0xCB, 0xE1);
}
# opcode : set "[inline_const]" 4 "," d "[end]"
sub _action_opcode_1541 {
	_add_opcode(@_, 0xCB, 0xE2);
}
# opcode : set "[inline_const]" 4 "," e "[end]"
sub _action_opcode_1542 {
	_add_opcode(@_, 0xCB, 0xE3);
}
# opcode : set "[inline_const]" 4 "," h "[end]"
sub _action_opcode_1543 {
	_add_opcode(@_, 0xCB, 0xE4);
}
# opcode : set "[inline_const]" 4 "," l "[end]"
sub _action_opcode_1544 {
	_add_opcode(@_, 0xCB, 0xE5);
}
# opcode : set "[inline_const]" 5 "," "(" hl ")" "[end]"
sub _action_opcode_1545 {
	_add_opcode(@_, 0xCB, 0xEE);
}
# opcode : set "[inline_const]" 5 "," "(" ix ")" "[end]"
sub _action_opcode_1546 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xEE);
}
# opcode : set "[inline_const]" 5 "," "(" ix ")" "," a "[end]"
sub _action_opcode_1547 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xEF);
}
# opcode : set "[inline_const]" 5 "," "(" ix ")" "," b "[end]"
sub _action_opcode_1548 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xE8);
}
# opcode : set "[inline_const]" 5 "," "(" ix ")" "," c "[end]"
sub _action_opcode_1549 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xE9);
}
# opcode : bit "[inline_const]" 5 "," "(" hl ")" "[end]"
sub _action_opcode_155 {
	_add_opcode(@_, 0xCB, 0x6E);
}
# opcode : set "[inline_const]" 5 "," "(" ix ")" "," d "[end]"
sub _action_opcode_1550 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xEA);
}
# opcode : set "[inline_const]" 5 "," "(" ix ")" "," e "[end]"
sub _action_opcode_1551 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xEB);
}
# opcode : set "[inline_const]" 5 "," "(" ix ")" "," h "[end]"
sub _action_opcode_1552 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xEC);
}
# opcode : set "[inline_const]" 5 "," "(" ix ")" "," l "[end]"
sub _action_opcode_1553 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xED);
}
# opcode : set "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1554 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xEE);
}
# opcode : set "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1555 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xEF);
}
# opcode : set "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1556 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xE8);
}
# opcode : set "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1557 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xE9);
}
# opcode : set "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1558 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xEA);
}
# opcode : set "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1559 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xEB);
}
# opcode : bit "[inline_const]" 5 "," "(" ix ")" "[end]"
sub _action_opcode_156 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x6E);
}
# opcode : set "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1560 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xEC);
}
# opcode : set "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1561 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xED);
}
# opcode : set "[inline_const]" 5 "," "(" iy ")" "[end]"
sub _action_opcode_1562 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xEE);
}
# opcode : set "[inline_const]" 5 "," "(" iy ")" "," a "[end]"
sub _action_opcode_1563 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xEF);
}
# opcode : set "[inline_const]" 5 "," "(" iy ")" "," b "[end]"
sub _action_opcode_1564 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xE8);
}
# opcode : set "[inline_const]" 5 "," "(" iy ")" "," c "[end]"
sub _action_opcode_1565 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xE9);
}
# opcode : set "[inline_const]" 5 "," "(" iy ")" "," d "[end]"
sub _action_opcode_1566 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xEA);
}
# opcode : set "[inline_const]" 5 "," "(" iy ")" "," e "[end]"
sub _action_opcode_1567 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xEB);
}
# opcode : set "[inline_const]" 5 "," "(" iy ")" "," h "[end]"
sub _action_opcode_1568 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xEC);
}
# opcode : set "[inline_const]" 5 "," "(" iy ")" "," l "[end]"
sub _action_opcode_1569 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xED);
}
# opcode : bit "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_157 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0x6E);
}
# opcode : set "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1570 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xEE);
}
# opcode : set "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1571 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xEF);
}
# opcode : set "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1572 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xE8);
}
# opcode : set "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1573 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xE9);
}
# opcode : set "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1574 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xEA);
}
# opcode : set "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1575 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xEB);
}
# opcode : set "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1576 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xEC);
}
# opcode : set "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1577 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xED);
}
# opcode : set "[inline_const]" 5 "," a "[end]"
sub _action_opcode_1578 {
	_add_opcode(@_, 0xCB, 0xEF);
}
# opcode : set "[inline_const]" 5 "," b "[end]"
sub _action_opcode_1579 {
	_add_opcode(@_, 0xCB, 0xE8);
}
# opcode : bit "[inline_const]" 5 "," "(" iy ")" "[end]"
sub _action_opcode_158 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x6E);
}
# opcode : set "[inline_const]" 5 "," c "[end]"
sub _action_opcode_1580 {
	_add_opcode(@_, 0xCB, 0xE9);
}
# opcode : set "[inline_const]" 5 "," d "[end]"
sub _action_opcode_1581 {
	_add_opcode(@_, 0xCB, 0xEA);
}
# opcode : set "[inline_const]" 5 "," e "[end]"
sub _action_opcode_1582 {
	_add_opcode(@_, 0xCB, 0xEB);
}
# opcode : set "[inline_const]" 5 "," h "[end]"
sub _action_opcode_1583 {
	_add_opcode(@_, 0xCB, 0xEC);
}
# opcode : set "[inline_const]" 5 "," l "[end]"
sub _action_opcode_1584 {
	_add_opcode(@_, 0xCB, 0xED);
}
# opcode : set "[inline_const]" 6 "," "(" hl ")" "[end]"
sub _action_opcode_1585 {
	_add_opcode(@_, 0xCB, 0xF6);
}
# opcode : set "[inline_const]" 6 "," "(" ix ")" "[end]"
sub _action_opcode_1586 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xF6);
}
# opcode : set "[inline_const]" 6 "," "(" ix ")" "," a "[end]"
sub _action_opcode_1587 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xF7);
}
# opcode : set "[inline_const]" 6 "," "(" ix ")" "," b "[end]"
sub _action_opcode_1588 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xF0);
}
# opcode : set "[inline_const]" 6 "," "(" ix ")" "," c "[end]"
sub _action_opcode_1589 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xF1);
}
# opcode : bit "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_159 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0x6E);
}
# opcode : set "[inline_const]" 6 "," "(" ix ")" "," d "[end]"
sub _action_opcode_1590 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xF2);
}
# opcode : set "[inline_const]" 6 "," "(" ix ")" "," e "[end]"
sub _action_opcode_1591 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xF3);
}
# opcode : set "[inline_const]" 6 "," "(" ix ")" "," h "[end]"
sub _action_opcode_1592 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xF4);
}
# opcode : set "[inline_const]" 6 "," "(" ix ")" "," l "[end]"
sub _action_opcode_1593 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xF5);
}
# opcode : set "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1594 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xF6);
}
# opcode : set "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1595 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xF7);
}
# opcode : set "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1596 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xF0);
}
# opcode : set "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1597 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xF1);
}
# opcode : set "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1598 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xF2);
}
# opcode : set "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1599 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xF3);
}
# opcode : bit "[inline_const]" 5 "," a "[end]"
sub _action_opcode_160 {
	_add_opcode(@_, 0xCB, 0x6F);
}
# opcode : set "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1600 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xF4);
}
# opcode : set "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1601 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xF5);
}
# opcode : set "[inline_const]" 6 "," "(" iy ")" "[end]"
sub _action_opcode_1602 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xF6);
}
# opcode : set "[inline_const]" 6 "," "(" iy ")" "," a "[end]"
sub _action_opcode_1603 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xF7);
}
# opcode : set "[inline_const]" 6 "," "(" iy ")" "," b "[end]"
sub _action_opcode_1604 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xF0);
}
# opcode : set "[inline_const]" 6 "," "(" iy ")" "," c "[end]"
sub _action_opcode_1605 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xF1);
}
# opcode : set "[inline_const]" 6 "," "(" iy ")" "," d "[end]"
sub _action_opcode_1606 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xF2);
}
# opcode : set "[inline_const]" 6 "," "(" iy ")" "," e "[end]"
sub _action_opcode_1607 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xF3);
}
# opcode : set "[inline_const]" 6 "," "(" iy ")" "," h "[end]"
sub _action_opcode_1608 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xF4);
}
# opcode : set "[inline_const]" 6 "," "(" iy ")" "," l "[end]"
sub _action_opcode_1609 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xF5);
}
# opcode : bit "[inline_const]" 5 "," b "[end]"
sub _action_opcode_161 {
	_add_opcode(@_, 0xCB, 0x68);
}
# opcode : set "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1610 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xF6);
}
# opcode : set "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1611 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xF7);
}
# opcode : set "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1612 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xF0);
}
# opcode : set "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1613 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xF1);
}
# opcode : set "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1614 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xF2);
}
# opcode : set "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1615 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xF3);
}
# opcode : set "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1616 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xF4);
}
# opcode : set "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1617 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xF5);
}
# opcode : set "[inline_const]" 6 "," a "[end]"
sub _action_opcode_1618 {
	_add_opcode(@_, 0xCB, 0xF7);
}
# opcode : set "[inline_const]" 6 "," b "[end]"
sub _action_opcode_1619 {
	_add_opcode(@_, 0xCB, 0xF0);
}
# opcode : bit "[inline_const]" 5 "," c "[end]"
sub _action_opcode_162 {
	_add_opcode(@_, 0xCB, 0x69);
}
# opcode : set "[inline_const]" 6 "," c "[end]"
sub _action_opcode_1620 {
	_add_opcode(@_, 0xCB, 0xF1);
}
# opcode : set "[inline_const]" 6 "," d "[end]"
sub _action_opcode_1621 {
	_add_opcode(@_, 0xCB, 0xF2);
}
# opcode : set "[inline_const]" 6 "," e "[end]"
sub _action_opcode_1622 {
	_add_opcode(@_, 0xCB, 0xF3);
}
# opcode : set "[inline_const]" 6 "," h "[end]"
sub _action_opcode_1623 {
	_add_opcode(@_, 0xCB, 0xF4);
}
# opcode : set "[inline_const]" 6 "," l "[end]"
sub _action_opcode_1624 {
	_add_opcode(@_, 0xCB, 0xF5);
}
# opcode : set "[inline_const]" 7 "," "(" hl ")" "[end]"
sub _action_opcode_1625 {
	_add_opcode(@_, 0xCB, 0xFE);
}
# opcode : set "[inline_const]" 7 "," "(" ix ")" "[end]"
sub _action_opcode_1626 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xFE);
}
# opcode : set "[inline_const]" 7 "," "(" ix ")" "," a "[end]"
sub _action_opcode_1627 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xFF);
}
# opcode : set "[inline_const]" 7 "," "(" ix ")" "," b "[end]"
sub _action_opcode_1628 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xF8);
}
# opcode : set "[inline_const]" 7 "," "(" ix ")" "," c "[end]"
sub _action_opcode_1629 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xF9);
}
# opcode : bit "[inline_const]" 5 "," d "[end]"
sub _action_opcode_163 {
	_add_opcode(@_, 0xCB, 0x6A);
}
# opcode : set "[inline_const]" 7 "," "(" ix ")" "," d "[end]"
sub _action_opcode_1630 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xFA);
}
# opcode : set "[inline_const]" 7 "," "(" ix ")" "," e "[end]"
sub _action_opcode_1631 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xFB);
}
# opcode : set "[inline_const]" 7 "," "(" ix ")" "," h "[end]"
sub _action_opcode_1632 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xFC);
}
# opcode : set "[inline_const]" 7 "," "(" ix ")" "," l "[end]"
sub _action_opcode_1633 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xFD);
}
# opcode : set "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1634 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xFE);
}
# opcode : set "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1635 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xFF);
}
# opcode : set "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1636 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xF8);
}
# opcode : set "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1637 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xF9);
}
# opcode : set "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1638 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xFA);
}
# opcode : set "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1639 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xFB);
}
# opcode : bit "[inline_const]" 5 "," e "[end]"
sub _action_opcode_164 {
	_add_opcode(@_, 0xCB, 0x6B);
}
# opcode : set "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1640 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xFC);
}
# opcode : set "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1641 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xFD);
}
# opcode : set "[inline_const]" 7 "," "(" iy ")" "[end]"
sub _action_opcode_1642 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xFE);
}
# opcode : set "[inline_const]" 7 "," "(" iy ")" "," a "[end]"
sub _action_opcode_1643 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xFF);
}
# opcode : set "[inline_const]" 7 "," "(" iy ")" "," b "[end]"
sub _action_opcode_1644 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xF8);
}
# opcode : set "[inline_const]" 7 "," "(" iy ")" "," c "[end]"
sub _action_opcode_1645 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xF9);
}
# opcode : set "[inline_const]" 7 "," "(" iy ")" "," d "[end]"
sub _action_opcode_1646 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xFA);
}
# opcode : set "[inline_const]" 7 "," "(" iy ")" "," e "[end]"
sub _action_opcode_1647 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xFB);
}
# opcode : set "[inline_const]" 7 "," "(" iy ")" "," h "[end]"
sub _action_opcode_1648 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xFC);
}
# opcode : set "[inline_const]" 7 "," "(" iy ")" "," l "[end]"
sub _action_opcode_1649 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xFD);
}
# opcode : bit "[inline_const]" 5 "," h "[end]"
sub _action_opcode_165 {
	_add_opcode(@_, 0xCB, 0x6C);
}
# opcode : set "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1650 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xFE);
}
# opcode : set "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1651 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xFF);
}
# opcode : set "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1652 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xF8);
}
# opcode : set "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1653 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xF9);
}
# opcode : set "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1654 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xFA);
}
# opcode : set "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1655 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xFB);
}
# opcode : set "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1656 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xFC);
}
# opcode : set "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1657 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xFD);
}
# opcode : set "[inline_const]" 7 "," a "[end]"
sub _action_opcode_1658 {
	_add_opcode(@_, 0xCB, 0xFF);
}
# opcode : set "[inline_const]" 7 "," b "[end]"
sub _action_opcode_1659 {
	_add_opcode(@_, 0xCB, 0xF8);
}
# opcode : bit "[inline_const]" 5 "," l "[end]"
sub _action_opcode_166 {
	_add_opcode(@_, 0xCB, 0x6D);
}
# opcode : set "[inline_const]" 7 "," c "[end]"
sub _action_opcode_1660 {
	_add_opcode(@_, 0xCB, 0xF9);
}
# opcode : set "[inline_const]" 7 "," d "[end]"
sub _action_opcode_1661 {
	_add_opcode(@_, 0xCB, 0xFA);
}
# opcode : set "[inline_const]" 7 "," e "[end]"
sub _action_opcode_1662 {
	_add_opcode(@_, 0xCB, 0xFB);
}
# opcode : set "[inline_const]" 7 "," h "[end]"
sub _action_opcode_1663 {
	_add_opcode(@_, 0xCB, 0xFC);
}
# opcode : set "[inline_const]" 7 "," l "[end]"
sub _action_opcode_1664 {
	_add_opcode(@_, 0xCB, 0xFD);
}
# opcode : sla "(" hl ")" "[end]"
sub _action_opcode_1665 {
	_add_opcode(@_, 0xCB, 0x26);
}
# opcode : sla "(" ix ")" "[end]"
sub _action_opcode_1666 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x26);
}
# opcode : sla "(" ix ")" "," a "[end]"
sub _action_opcode_1667 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x27);
}
# opcode : sla "(" ix ")" "," b "[end]"
sub _action_opcode_1668 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x20);
}
# opcode : sla "(" ix ")" "," c "[end]"
sub _action_opcode_1669 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x21);
}
# opcode : bit "[inline_const]" 6 "," "(" hl ")" "[end]"
sub _action_opcode_167 {
	_add_opcode(@_, 0xCB, 0x76);
}
# opcode : sla "(" ix ")" "," d "[end]"
sub _action_opcode_1670 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x22);
}
# opcode : sla "(" ix ")" "," e "[end]"
sub _action_opcode_1671 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x23);
}
# opcode : sla "(" ix ")" "," h "[end]"
sub _action_opcode_1672 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x24);
}
# opcode : sla "(" ix ")" "," l "[end]"
sub _action_opcode_1673 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x25);
}
# opcode : sla "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1674 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x26);
}
# opcode : sla "(" ix "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1675 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x27);
}
# opcode : sla "(" ix "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1676 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x20);
}
# opcode : sla "(" ix "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1677 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x21);
}
# opcode : sla "(" ix "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1678 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x22);
}
# opcode : sla "(" ix "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1679 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x23);
}
# opcode : bit "[inline_const]" 6 "," "(" ix ")" "[end]"
sub _action_opcode_168 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x76);
}
# opcode : sla "(" ix "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1680 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x24);
}
# opcode : sla "(" ix "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1681 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x25);
}
# opcode : sla "(" iy ")" "[end]"
sub _action_opcode_1682 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x26);
}
# opcode : sla "(" iy ")" "," a "[end]"
sub _action_opcode_1683 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x27);
}
# opcode : sla "(" iy ")" "," b "[end]"
sub _action_opcode_1684 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x20);
}
# opcode : sla "(" iy ")" "," c "[end]"
sub _action_opcode_1685 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x21);
}
# opcode : sla "(" iy ")" "," d "[end]"
sub _action_opcode_1686 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x22);
}
# opcode : sla "(" iy ")" "," e "[end]"
sub _action_opcode_1687 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x23);
}
# opcode : sla "(" iy ")" "," h "[end]"
sub _action_opcode_1688 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x24);
}
# opcode : sla "(" iy ")" "," l "[end]"
sub _action_opcode_1689 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x25);
}
# opcode : bit "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_169 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0x76);
}
# opcode : sla "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1690 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x26);
}
# opcode : sla "(" iy "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1691 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x27);
}
# opcode : sla "(" iy "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1692 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x20);
}
# opcode : sla "(" iy "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1693 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x21);
}
# opcode : sla "(" iy "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1694 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x22);
}
# opcode : sla "(" iy "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1695 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x23);
}
# opcode : sla "(" iy "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1696 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x24);
}
# opcode : sla "(" iy "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1697 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x25);
}
# opcode : sla a "[end]"
sub _action_opcode_1698 {
	_add_opcode(@_, 0xCB, 0x27);
}
# opcode : sla b "[end]"
sub _action_opcode_1699 {
	_add_opcode(@_, 0xCB, 0x20);
}
# opcode : bit "[inline_const]" 6 "," "(" iy ")" "[end]"
sub _action_opcode_170 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x76);
}
# opcode : sla bc "[end]"
sub _action_opcode_1700 {
	_add_opcode(@_, 0xCB, 0x21, 0xCB, 0x10);
}
# opcode : sla c "[end]"
sub _action_opcode_1701 {
	_add_opcode(@_, 0xCB, 0x21);
}
# opcode : sla d "[end]"
sub _action_opcode_1702 {
	_add_opcode(@_, 0xCB, 0x22);
}
# opcode : sla de "[end]"
sub _action_opcode_1703 {
	_add_opcode(@_, 0xCB, 0x23, 0xCB, 0x12);
}
# opcode : sla e "[end]"
sub _action_opcode_1704 {
	_add_opcode(@_, 0xCB, 0x23);
}
# opcode : sla h "[end]"
sub _action_opcode_1705 {
	_add_opcode(@_, 0xCB, 0x24);
}
# opcode : sla l "[end]"
sub _action_opcode_1706 {
	_add_opcode(@_, 0xCB, 0x25);
}
# opcode : sli "(" hl ")" "[end]"
sub _action_opcode_1707 {
	_add_opcode(@_, 0xCB, 0x36);
}
# opcode : sli "(" ix ")" "[end]"
sub _action_opcode_1708 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x36);
}
# opcode : sli "(" ix ")" "," a "[end]"
sub _action_opcode_1709 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x37);
}
# opcode : bit "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_171 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0x76);
}
# opcode : sli "(" ix ")" "," b "[end]"
sub _action_opcode_1710 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x30);
}
# opcode : sli "(" ix ")" "," c "[end]"
sub _action_opcode_1711 {
	_add_o