/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.parser.lexparser.Rule;
import edu.stanford.nlp.util.Numberer;
import edu.stanford.nlp.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnaryRule
extends Rule
implements Comparable<UnaryRule> {
    public int child = -1;
    private static final char[] charsToEscape = new char[]{'\"'};
    private transient String cached = null;
    private static final long serialVersionUID = 1L;

    public UnaryRule() {
    }

    public UnaryRule(int parent, int child) {
        this.parent = parent;
        this.child = child;
    }

    public UnaryRule(int parent, int child, double score) {
        this.parent = parent;
        this.child = child;
        this.score = (float)score;
    }

    public UnaryRule(String s, Numberer n) {
        String[] fields = StringUtils.splitOnCharWithQuoting(s, ' ', '\"', '\\');
        this.parent = n.number(fields[0]);
        this.child = n.number(fields[2]);
        this.score = Float.parseFloat(fields[3]);
    }

    @Override
    public boolean isUnary() {
        return true;
    }

    public int hashCode() {
        return this.parent << 16 ^ this.child;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof UnaryRule) {
            UnaryRule ur = (UnaryRule)o;
            if (this.parent == ur.parent && this.child == ur.child) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int compareTo(UnaryRule ur) {
        if (this.parent < ur.parent) {
            return -1;
        }
        if (this.parent > ur.parent) {
            return 1;
        }
        if (this.child < ur.child) {
            return -1;
        }
        if (this.child > ur.child) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        Numberer n = Numberer.getGlobalNumberer("states");
        return "\"" + StringUtils.escapeString(n.object(this.parent).toString(), charsToEscape, '\\') + "\" -> \"" + StringUtils.escapeString(n.object(this.child).toString(), charsToEscape, '\\') + "\" " + this.score;
    }

    public String toStringNoScore() {
        if (this.cached == null) {
            Numberer n = Numberer.getGlobalNumberer("states");
            this.cached = "\"" + StringUtils.escapeString(n.object(this.parent).toString(), charsToEscape, '\\') + "\" -> \"" + StringUtils.escapeString(n.object(this.child).toString(), charsToEscape, '\\');
        }
        return this.cached;
    }
}

