/*
 * Decompiled with CFR 0.152.
 */
package opennlp.grok.preprocess.mwe;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import opennlp.common.util.PerlHelp;
import opennlp.grok.preprocess.mwe.MWEModel;

public class VariableMWEModel
implements MWEModel {
    Map map = new HashMap();

    public String[] getMWE(String[] l, int pos) {
        int x = 0;
        while (x < 3) {
            List[] lists;
            if (pos + x < l.length && (lists = (List[])this.map.get(l[pos + x])) != null && lists[x] != null) {
                Iterator i = lists[x].iterator();
                while (i.hasNext()) {
                    ModelData mwe = (ModelData)i.next();
                    if (!this.tryMWE(mwe, l, pos, x)) continue;
                    return mwe.getWords();
                }
            }
            ++x;
        }
        return null;
    }

    public void addMWE(String mweWords) {
        try {
            String[] spaceSplit = PerlHelp.split((String)mweWords);
            if (spaceSplit.length < 3) {
                System.out.println("+addVariableMWE: " + mweWords + " has a wrong format");
                return;
            }
            int n = Integer.parseInt(spaceSplit[0]);
            String[] newSplit = new String[spaceSplit.length - 1];
            int i = 0;
            while (i < spaceSplit.length - 1) {
                newSplit[i] = spaceSplit[i + 1];
                ++i;
            }
            ModelData mwe = new ModelData(newSplit, n);
            String indexWord = newSplit[mwe.getIndexWord()];
            this.addMWE(indexWord, mwe);
            if (n == 1 && newSplit[n - 1].equals("lie")) {
                this.addMWE(indexWord, newSplit, 1, "lying");
            } else if (n == 1 && newSplit[n - 1].equals("die")) {
                this.addMWE(indexWord, newSplit, 1, "dying");
            } else if (n == 1 && newSplit[n - 1].equals("tie")) {
                this.addMWE(indexWord, newSplit, 1, "tying");
            } else if (n == 1 && indexWord.endsWith("e")) {
                String newIndexWord = indexWord.substring(0, indexWord.length() - 1) + "ing";
                newSplit[mwe.getIndexWord()] = "newIndexWord";
                mwe = new ModelData(newSplit, n);
                this.addMWE(newIndexWord, mwe);
            }
        }
        catch (Exception e) {
            System.out.println("+addVariableMWE: " + mweWords + " has a wrong format");
        }
    }

    private void addMWE(String indexWord, String[] oldSplit, int n, String newStr) {
        String[] newSplit = new String[oldSplit.length];
        int i = 0;
        while (i < oldSplit.length) {
            newSplit[i] = oldSplit[i];
            ++i;
        }
        newSplit[n - 1] = newStr;
        ModelData mwe = new ModelData(newSplit, n);
        this.addMWE(indexWord, mwe);
    }

    private void addMWE(String indexWord, ModelData mwe) {
        List[] l = (List[])this.map.get(indexWord);
        if (l == null) {
            l = new List[3];
            this.map.put(indexWord, l);
        }
        if (l[mwe.getIndexWord()] == null) {
            l[mwe.getIndexWord()] = new ArrayList();
        }
        l[mwe.getIndexWord()].add(mwe);
    }

    private boolean tryMWE(ModelData mwe, String[] l, int pos, int x) {
        String[] mweWords = mwe.getWords();
        try {
            int i = 0;
            while (i < mweWords.length) {
                if (i != x && (i == mwe.getVariableWord() ? l[pos + i].indexOf(mweWords[i]) != 0 : !mweWords[i].equals(l[pos + i]))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static class ModelData {
        private String[] words;
        private int variableWord;
        private int indexWord;

        public ModelData(String[] words) {
            this.words = words;
            this.variableWord = -1;
            this.indexWord = 0;
        }

        public ModelData(String[] words, int variableWord) {
            this.words = words;
            this.variableWord = variableWord - 1;
            this.indexWord = this.variableWord > 0 ? 0 : 1;
        }

        public String[] getWords() {
            return this.words;
        }

        public int getVariableWord() {
            return this.variableWord;
        }

        public int getIndexWord() {
            return this.indexWord;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < this.words.length) {
                sb.append(this.words[i]).append(" ");
                ++i;
            }
            return sb.toString();
        }
    }
}

