//
// Copyright 2014 Google Inc. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Created by postproc-cld2 4.0 on 2014-02-04 09:10:03
// From command line:
//  --cld2 --cc --just_read_raw --distinct_octa --standard --minchars=2 
//  --mincount=1 --max_items_per_langscript=2000 --flatmap --rr_alloc 
//  --freq_alloc --boostcloseweakerpercent=00 --indirectbits=12 --thresh=240 
//  --v25 --kentries=32 --tablename=DistinctOcta0122 --suppress=bs-Cyrl 
//  sr-ME-Latn sh-Cyrl sh-Latn ce-Cyrl cv-Cyrl    az-Arab az-Cyrl bs-Cyrl 
//  kk-Latn ku-Latn my-Latn ru-Latn tg-Arab tk-Arab ug-Latn za-Hani zzb-Latn 
//  zze-Latn zzh-Latn --remap=xxx-Latn=>ut-Latn tw-Latn=>ak-Latn 
//  nd-Latn=>nr-Latn blu-Latn=>hmn-Latn  --ko_english --force_to_lang_soft 
//  --nosoft_cram2 --nomsidlevel --shapeflatprob --langpriorpercent=10 
//  --skipnuc --noshapeforcetop --noshapeeventop --noshapesteep2 --spread=15 
//  --nodoubleclose --langcounts --writebin --list_items=120 
//  /tmp/xocta_octa2.utf8 
// 
// CLD2_pslangs
// 
// See compact_lang_det.cc for usage
// 
#include "cld2tablesummary.h"
namespace CLD2 {

static const uint32 kDistinctOcta0122BuildDate = 20140204;    // yyyymmdd


// Of 19781 offered items into 32768 table entries:
// 18561 filled (93%), 20 merged (0%), 1200 dropped (6%)

// Nil-grams: 19 languages
//     GREEK MALAYALAM TELUGU TAMIL GUJARATI THAI KANNADA PUNJABI 
//     GEORGIAN SINHALESE ARMENIAN LAOTHIAN KHMER DHIVEHI CHEROKEE 
//     SYRIAC LIMBU ORIYA INUKTITUT 

// Uni-grams: 4 languages
//     Japanese Korean Chinese ChineseT 

// Words/Quads: 23 languages in range DANISH..RUNDI:
//     DANISH NORWEGIAN PORTUGUESE SPANISH CZECH CROATIAN SERBIAN 
//     GALICIAN HINDI INDONESIAN MALAY NEPALI BIHARI MARATHI SLOVAK 
//     BOSNIAN NORWEGIAN_N XHOSA ZULU TIBETAN DZONGKHA KINYARWANDA 
//     RUNDI 

// TopLanguage  TokenCount
//  DANISH 759
//  NORWEGIAN 346
//  PORTUGUESE 1109
//  SPANISH 606
//  CZECH 1151
//  CROATIAN 96
//  SERBIAN 2011
//  GALICIAN 781
//  HINDI 1485
//  INDONESIAN 489
//  MALAY 539
//  NEPALI 48
//  BIHARI 1800
//  MARATHI 26
//  SLOVAK 1032
//  BOSNIAN 151
//  NORWEGIAN_N 795
//  XHOSA 256
//  ZULU 1294
//  TIBETAN 1794
//  DZONGKHA 714
//  KINYARWANDA 1294
//  RUNDI 5



// Recognized language-script combinations [24]:
static const char* const kDistinctOcta0122RecognizedLangScripts = 
  "bh-Deva bo-Tibt bs-Latn cs-Latn da-Latn dz-Tibt es-Latn gl-Latn "
  "hi-Deva hr-Latn id-Latn mr-Deva ms-Latn ne-Deva nn-Latn no-Latn "
  "pt-Latn rn-Latn rw-Latn sk-Latn sr-Cyrl sr-Latn xh-Latn zu-Latn "
  "";

static const uint32 kDistinctOcta0122Size = 8192;    // Bucket count
static const uint32 kDistinctOcta0122KeyMask = 0xffffe000;    // Mask hash key

static const IndirectProbBucket4 kDistinctOcta0122[kDistinctOcta0122Size] = {
  // hash_indirect[4], tokens[4] in UTF-8
   {{0xebb62002,0x824da003,0x00000000,0x00000000}},	// [000] _имао_, _རགས_, --, --, 
   {{0x72006004,0xe2a92005,0x2bf58003,0x00000000}},	//   _kuni_, _er__heilt_, _གི__ཆབ_, --, 
   {{0x229e8006,0x04420007,0xb166c008,0x7658c006}},	//   _བསལ__ཤོག_, _secara__terus_, _vázquez_, _དོ__ཡོདཔ_, 
   {{0x54824008,0xd9158009,0x0c0ac00a,0x29e7c002}},	//   _novo__no_, _hvornår_, _किसी__को_, _портала__коментар, 
   {{0xc311a00b,0x3a95c00c,0x00000000,0x00000000}},	//   _buri__wese_, _बा__जवन_, --, --, 
   {{0x3354c00d,0x9494c00e,0x00000000,0x00000000}},	//   _quienes_, _se__tak_, --, --, 
   {{0x8212200f,0xcd206006,0xfbfbc003,0x00000000}},	//   _lokhu_, _འབྲེས__འཁྲུངས_, _མོ__དང_, --, 
   {{0x6291e010,0x535bc00f,0x00000000,0x00000000}},	//   _antal_, _okukhulu_ngaye_, --, --, 
   {{0x12e8200b,0xc4972011,0x00000000,0x00000000}},	//   _yicisha_, _ou__non_, --, --, 
   {{0x626de00e,0xa8b78002,0x00000000,0x00000000}},	//   _tyto_, _хришћанс, --, --, 
   {{0x73eb8012,0x79f4e011,0x32526003,0x00000000}},	//   _mesta_, _senón_, _བརྡ__ཁམས_, --, 
   {{0xade90006,0xe2892003,0x00000000,0x00000000}},	//   _ཆས__སྒྲོམ_, _ཀུན__བཟང_, --, --, 
   {{0x8a3c8013,0x59208014,0x14972011,0x00000000}},	//   _लॉग_, _गुंजन_, _ou__con_, --, 
   {{0xebf9e003,0x9b8c400f,0x5470e00e,0x00000000}},	//   _མི__ཚེ_, _izinzuzo_, _kdy__se_, --, 
   {{0x6e058015,0x82780016,0xf1c92002,0x00000000}},	//   _kendaraa, _åpnet_, _доста_, --, 
   {{0xec13e00c,0xa0a2e002,0x00000000,0x00000000}},	//   _इरादा__के_, _је__заштићен, --, --, 
   {{0x8291e017,0x79fc200f,0x00000000,0x00000000}},	// [010] _dotaz_, _ibhayibh_libonisa_, --, --, 
   {{0xe2bf0006,0xfe592002,0x6219e00e,0x00000000}},	//   _དབང__མངའ_, _молимо__вас_, _podnikán, --, 
   {{0x1e73c013,0x41010002,0x3c7d0005,0x00000000}},	//   _सिर्फ_, _свет_, _miljø__næring_, --, 
   {{0x6c6c6018,0x00000000,0x00000000,0x00000000}},	//   _alguém_, --, --, --, 
   {{0x1224800e,0xe7e9600f,0x00000000,0x00000000}},	//   _velké_, _acashunw, --, --, 
   {{0x6df76003,0x00000000,0x00000000,0x00000000}},	//   _མི__རིགས_, --, --, --, 
   {{0x62dde018,0xe41bc00f,0x00000000,0x00000000}},	//   _em__cima_, _phawula__ukuthi_, --, --, 
   {{0xc4906019,0x00000000,0x00000000,0x00000000}},	//   _av__dem_, --, --, --, 
   {{0xb29e4003,0x00000000,0x00000000,0x00000000}},	//   _འཛུགས__ཀྱི_, --, --, --, 
   {{0x7e7d4002,0x00000000,0x00000000,0x00000000}},	//   _коме__се_, --, --, --, 
   {{0x1b8c8003,0x36f9400a,0x52d7000b,0x7bd0c003}},	//   _ནས_, _सकता_, _murongo_, _མཉམ__དུ_, 
   {{0xe4b7a00f,0x00000000,0x00000000,0x00000000}},	//   _inceku__ethembek, --, --, --, 
   {{0x4e61c003,0xaf1b2002,0xbb71c00c,0x00000000}},	//   _བོད__བརྒྱུད_, _види__још_, _के__खजाना_, --, 
   {{0x262ec01a,0x00000000,0x00000000,0x00000000}},	//   _samanslå, --, --, --, 
   {{0xebc7e00c,0x00000000,0x00000000,0x00000000}},	//   _वर्मा__के_, --, --, --, 
   {{0x8d9b4003,0x00000000,0x00000000,0x00000000}},	//   _རྒྱལ__གཅེས_, --, --, --, 
   {{0xe364c002,0x5bd00018,0x00000000,0x00000000}},	// [020] _ekstovi__blogu_, _opinião_, --, --, 
   {{0xa2586003,0x00000000,0x00000000,0x00000000}},	//   _བྱུང__ཚུལ_, --, --, --, 
   {{0x6c90400a,0xe68a6002,0x10e40012,0x6cc3600b}},	//   _लोगों_, _презимен, _užívatel, _za__amerika_, 
   {{0xa3a5a016,0xa2d8201b,0xe493a00b,0xe7ad0003}},	//   _innlegg__svar_, _enje_, _nk__ibi_, _མུ__མཐུད_, 
   {{0x0bc1801c,0x00000000,0x00000000,0x00000000}},	//   _नही__है_, --, --, --, 
   {{0x4585201d,0xf2970006,0x6dcca002,0x00000000}},	//   _pengguna_komersil_, _ཨིང__ལིཤ_, _да__сте_, --, 
   {{0x827ee009,0x00000000,0x00000000,0x00000000}},	//   _gennem_, --, --, --, 
   {{0x32fd401e,0xadcb800e,0xebf1a00c,0x00000000}},	//   _dana__tjedna_, _zakázáno_, _देखे__के_, --, 
   {{0xd202c003,0x00000000,0x00000000,0x00000000}},	//   _ཡིག__འདེམས_, --, --, --, 
   {{0xc2fce01f,0xded7200b,0x5357a002,0x00000000}},	//   _tengok_, _bijyanye_, _видео__снимци_, --, 
   {{0x83eb8002,0xba3ce01c,0x00000000,0x00000000}},	//   _vesti_, _शाम_, --, --, 
   {{0x2de18020,0x0bec4021,0xc313000d,0x00000000}},	//   _བའི__རྗེས_, _འབྲེལ__ནང_, _para__mejorar_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x1f40200b,0x00000000,0x00000000,0x00000000}},	//   _nyagasan, --, --, --, 
   {{0xc25c2003,0x027fa00e,0x00000000,0x00000000}},	//   _བྲིས__པའི_, _kam__dál_, --, --, 
   {{0x83b0000e,0x0bd7a00a,0x7d86c002,0x678f0002}},	//   _hlasován, _गया__और_, _награда_, _правосла_цркве_, 
   {{0x8c862022,0x9290401a,0x52c6a006,0x22a6800e}},	// [030] _के__माध्यम_, _timar_, _ཏོག__བདག_, _životní_, 
   {{0xf4426023,0xebad2014,0x83682004,0xfacae003}},	//   _mwo_, _कार्यक्र_के_, _lo__mfazi_, _རྟོག_, 
   {{0xc3d90009,0x8a55600a,0x7986c00f,0x00000000}},	//   _at__være_, _इस__बार_, _isihloko__esilande, --, 
   {{0x0ffb000a,0x00000000,0x00000000,0x00000000}},	//   _स्पाइसी_, --, --, --, 
   {{0xfba8800a,0x00000000,0x00000000,0x00000000}},	//   _अमिताभ__नच_, --, --, --, 
   {{0x7698c006,0x9b0d4003,0x1bce8003,0xacc18003}},	//   _ཚུ__ཡོདཔ_, _མིང__གློག_, _ཁོངས__སུ_, _དར__སྤེལ_, 
   {{0xb3eb8024,0x00000000,0x00000000,0x00000000}},	//   _mestu_, --, --, --, 
   {{0x5262e020,0x7be66003,0xf6f5200a,0xfbd2000c}},	//   _དཔེ__ཆའི_, _འཕྲིན__དྲ_, _हैं__ताकि_, _भोजपुर__से_, 
   {{0x8a33e014,0xa3b62025,0x523aa009,0x00000000}},	//   _जाई_, _sexta__feira_, _høje_, --, 
   {{0xd351a026,0x4f24c00e,0xb471a00f,0x404c400f}},	//   _synes__ikke_, _naší_, _futhi__uma_, _zokugcin, 
   {{0xfb9ac003,0x00000000,0x00000000,0x00000000}},	//   _མཆོག__དང_, --, --, --, 
   {{0x0a692022,0xc26cc004,0x8dbe4002,0xb212a027}},	//   _पाकिस्ता_में_, _abaninzi_, _више__информац, _nech_, 
   {{0x0f246012,0x44b14009,0x77ce400a,0x00000000}},	//   _prácu_, _grund__af_, _आपत्तिजन_टिप्पणी_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x4a3d2013,0x025b000c,0x00000000,0x00000000}},	//   _हॉट_, _के__श्रेणी_, --, --, 
   {{0xebed6014,0x37a78003,0xc386000b,0x00000000}},	//   _मध्यप्रद_के_, _ཐོ__འགོད_, _tpir_, --, 
   {{0xe014e002,0x00000000,0x00000000,0x00000000}},	// [040] _хрватски__чешки_, --, --, --, 
   {{0x7469400b,0xdb9aa00c,0x00000000,0x00000000}},	//   _amaguru__mu_, _की__छी_, --, --, 
   {{0x74986028,0x00000000,0x00000000,0x00000000}},	//   _sé__si_, --, --, --, 
   {{0x7c802002,0x5ecda012,0x12d04003,0x00000000}},	//   _теме_, _spôsob_, _ཚོགས__ཆུང_, --, 
   {{0x2b8ca029,0x72c5202a,0xc9d06002,0x00000000}},	//   _བས_, _vanlige_, _речи_, --, 
   {{0x4442602b,0x2b4a2006,0x97f12002,0x00000000}},	//   _rwo_, _གདོང__ཤོགངོ_, _скоро_, --, 
   {{0x32012002,0x7baf0003,0x5490a027,0x00000000}},	//   _свиђа_, _ཕྱོགས__དྲ_, _je__len_, --, 
   {{0x22d98012,0x00000000,0x00000000,0x00000000}},	//   _hore_, --, --, --, 
   {{0xc3954004,0xe4462017,0x00000000,0x00000000}},	//   _ixesha_, _musí__být_, --, --, 
   {{0xe29b6006,0x632a202a,0xebdb8003,0x00000000}},	//   _མེད__རྡོ_, _på__annen_, _རིན__ཐང_, --, 
   {{0x0200400f,0xea14a00e,0x3c75600a,0x00000000}},	//   _kimi_, _zrušit_, _रिव्यू_, --, 
   {{0x6441e002,0x3e7e2002,0x00000000,0x00000000}},	//   _детаљниј, _србима__на_, --, --, 
   {{0x3346800f,0x248e6009,0xcbd8e003,0x00000000}},	//   _izindaba__ezinhle_, _af__og_, _གསལ__པོ_, --, 
   {{0x2237c00b,0x00000000,0x00000000,0x00000000}},	//   _ngombwa_, --, --, --, 
   {{0xb9ee602b,0x00000000,0x00000000,0x00000000}},	//   _kubikora_, --, --, --, 
   {{0xab4ba020,0x00000000,0x00000000,0x00000000}},	//   _དབང__ཕྱུག_, --, --, --, 
   {{0x13f80008,0xf25ac01a,0x51c8a003,0xec032014}},	// [050] _por__outra_, _samlar_, _ཆེད__བསྒྲིགས_, _मातृभाषा, 
   {{0xc2bbe00e,0x00000000,0x00000000,0x00000000}},	//   _zadejte_, --, --, --, 
   {{0xe2d9800b,0x32da6018,0x00000000,0x00000000}},	//   _dore_, _deseja_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xebe40003,0xe6a22002,0x3ba8600a,0x00000000}},	//   _ལོའི__ཟླ_, _институц, _था__यह_, --, 
   {{0x3347401d,0x00000000,0x00000000,0x00000000}},	//   _kerajaan__negeri_, --, --, --, 
   {{0x02900007,0x00000000,0x00000000,0x00000000}},	//   _faham_, --, --, --, 
   {{0x1f37600e,0x00000000,0x00000000,0x00000000}},	//   _vyhrazen_prázdný_, --, --, --, 
   {{0x72d9800b,0x62772006,0xec664002,0x2b3e6006}},	//   _mose_, _བསྐྱོད__བསམ_, _свој__налог_, _ཤོགངོ_, 
   {{0x64b9a011,0x0a50e00a,0xa23b2012,0x00000000}},	//   _millóns__de_, _हिन्दी__में_, _mája_, --, 
   {{0xa290401f,0xd201600f,0xf1c90002,0xb4734025}},	//   _ramai_, _amakhosi_, _пошто_, _cada__um_, 
   {{0x6ab98002,0x00000000,0x00000000,0x00000000}},	//   _политике_, --, --, --, 
   {{0x7f238018,0x6b560003,0x74acc012,0x00000000}},	//   _semelhan, _དུང__གཟིགས_, _alebo__si_, --, 
   {{0x6b7fc024,0xf490a009,0x54b2e00a,0x00000000}},	//   _posledic, _en__ven_, _टुंडा_, --, 
   {{0xf358000c,0x5a7ea00b,0xf2a36003,0x00000000}},	//   _कि__भोजपुरी_, _ukwakira_, _སྟེགས__བཅར_, --, 
   {{0x7bbb800a,0xad06e003,0x4a9f200a,0x14b6a012}},	//   _हैं__तो_, _རྒྱུའི_, _समाचार__खबर_, _časy__sú_, 
   {{0x64bc4018,0xba5d800e,0x00000000,0x00000000}},	// [060] _jogo__de_, _jiného_, --, --, 
   {{0xa98e401b,0x34b4a00a,0x00000000,0x00000000}},	//   _waphinda_, _अमृतसर_, --, --, 
   {{0x02d9801a,0x20716017,0x00000000,0x00000000}},	//   _vore_, _slovníče, --, --, 
   {{0xbf7b0009,0xd0e62013,0x00000000,0x00000000}},	//   _denne__tråd_, _अमरीका_, --, --, 
   {{0x6df7c003,0x765b4006,0x634e6018,0xd2772003}},	//   _མི__རྣམས_, _ལུ__ཡོདཔ_, _função_, _ནས__ཡིན_, 
   {{0xd4b4600d,0xf5a5e012,0x00000000,0x00000000}},	//   _dice__que_, _niektorý, --, --, 
   {{0x5d838006,0xb24f8028,0x62b00003,0x00000000}},	//   _འབྱོན_, _el__sitio_, _བསྒྲགས__གསར_, --, 
   {{0x835be00f,0xd4b6a00a,0x00000000,0x00000000}},	//   _kungaba_, _टाइल__धर्म_, --, --, 
   {{0xfad18021,0x8820e003,0x00000000,0x00000000}},	//   _བཙུགས_, _མཆོག__ྋརྒྱལ_, --, --, 
   {{0xd442802c,0x5bb9c002,0x9bb10003,0x00000000}},	//   _rwa_, _недеља_, _ཡང__མི_, --, 
   {{0x6c4ec00a,0x128dc003,0x00000000,0x00000000}},	//   _जैसे_, _བསམ__བློ_, --, --, 
   {{0x42f6201e,0x00000000,0x00000000,0x00000000}},	//   _dan__dana_, --, --, --, 
   {{0xb4824019,0x7200e00d,0xa33f201a,0x6af1e002}},	//   _uten__at_, _sonido_, _den__eine_, _непријат, 
   {{0x7646800f,0xc48f400e,0x00000000,0x00000000}},	//   _ngokweqi, _který__je_, --, --, 
   {{0xca55600a,0xc2584011,0x39f4600e,0x00000000}},	//   _इस__बात_, _de__máis_, _jiný_, --, 
   {{0x9740800e,0x1c56200c,0xdbcec00a,0x00000000}},	//   _šířka_, _काहें_, _फनी_, --, 
   {{0xa510c002,0x59b7e00f,0x00000000,0x00000000}},	// [070] _веома_, _ibhayibh_lisitshe, --, --, 
   {{0x84af6005,0xf3f10005,0x332b2009,0x00000000}},	//   _men__eg_, _ikkje__berre_, _på__vores_, --, 
   {{0xa9f3602d,0x37fa6003,0xc496602a,0x74438009}},	//   _prosvjed, _བྱེད__བཞིན_, _ta__en_, _cvr_, 
   {{0x1242a021,0x1e5d8011,0x507d8011,0x8978600e}},	//   _བསལ_, _traballa, _traballo, _velikost, 
   {{0xd69aa01a,0xb2d84025,0x00000000,0x00000000}},	//   _andre__verdskri, _óleo_, --, --, 
   {{0x81fe8002,0x9bffe00c,0x0055800a,0x8cee0003}},	//   _нови__чланак_, _सकेला__कि_, _रामपुर__बुशहर_, _གྲུབ__འབྲས_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x3387e005,0x52396002,0x5b98e00a,0xfb8d4013}},	//   _trur_, _коју_, _क्__या_, _कब_, 
   {{0xf4624018,0xa3f1c018,0x00000000,0x00000000}},	//   _não__me_, _você__quiser_, --, --, 
   {{0x24b9a01a,0x00000000,0x00000000,0x00000000}},	//   _forsking__og_, --, --, --, 
   {{0x996f2008,0x14788005,0x96320011,0x5a4bc00c}},	//   _clandest, _fylkesko_har_, _na__categorí, _के__वजह_, 
   {{0xf2e1a02e,0xe796a006,0x00000000,0x00000000}},	//   _kolovoz_, _འཕྲོ__མཐུད_, --, --, 
   {{0xda6ae022,0xa2e5e00f,0x847b800b,0x8c63600c}},	//   _कुछ__दिन_, _isinkwa_, _tweet__uru_, _गुंजाइश__नइखे_, 
   {{0xbf698002,0x00000000,0x00000000,0x00000000}},	//   _румунски__руски_, --, --, --, 
   {{0xa260800f,0x7e12a00c,0x00000000,0x00000000}},	//   _usuku__lonke_, _एस__मजूमदार_, --, --, 
   {{0x0a1d001d,0x00000000,0x00000000,0x00000000}},	//   _bercakap_, --, --, --, 
   {{0xef57600a,0xf329000a,0x00000000,0x00000000}},	// [080] _जाएगी_, _अनुवाद__हेतु_, --, --, 
   {{0x2e9a4002,0x22fb6015,0x5200e00b,0x00000000}},	//   _што__је_, _wawasan__anda_, _mugi_, --, 
   {{0x496e002f,0x37a7400f,0x00000000,0x00000000}},	//   _moviment, _qhathani, --, --, 
   {{0xe475e030,0x5290a018,0x548f400e,0xb2612018}},	//   _dana__okt_, _dicas_, _který__se_, _mão_, 
   {{0xa2a0a003,0x00000000,0x00000000,0x00000000}},	//   _སྤེལ__བྱས_, --, --, --, 
   {{0x0d5fc014,0xbbec2006,0xac2a200e,0x9c110003}},	//   _विक्रमाद, _སྡེ__ཚུ_, _černá_, _ཚོགས__མི_, 
   {{0xc2612018,0x924e4003,0x00000000,0x00000000}},	//   _não_, _ལགས_, --, --, 
   {{0xd20cc002,0x00000000,0x00000000,0x00000000}},	//   _претрага_, --, --, --, 
   {{0xb2d8a00d,0x00000000,0x00000000,0x00000000}},	//   _madera_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x82ad400a,0xd2634003,0x022b800f,0xbac42018}},	//   _इस__स्टोरी_, _དབྱིན__སྐད_, _kunabo__bonke_, _nosso__catálogo_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xe495600b,0x3410a01a,0x6290a025,0x34622012}},	//   _ni__na_, _dei__siste_, _ficar_, _stredisk, 
   {{0x54624025,0xd2006031,0x7d09c013,0x00000000}},	//   _não__se_, _gini_, _सदाबहार_, --, 
   {{0xa7802008,0xc40f200b,0x00000000,0x00000000}},	//   _subvenci, _abo__bantu_, --, --, 
   {{0x82174006,0x00000000,0x00000000,0x00000000}},	//   _ནི__ཨིནམ_, --, --, --, 
   {{0xf2006032,0x32760006,0xc278c011,0xe2c4800f}},	// [090] _yini_, _བརྒྱུད__གོང_, _ler__máis_, _kanjani__ukuba_, 
   {{0x4a4c0013,0x9ca0e00e,0xb870e003,0x00000000}},	//   _हो__गया_, _bez__souhlasu_, _པའི__འབྲི_, --, 
   {{0x2486c01c,0x00000000,0x00000000,0x00000000}},	//   _रोमांस_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa37d4012,0xebd22003,0x00000000,0x00000000}},	//   _zdravie_, _སྣང__གི_, --, --, 
   {{0x325a6011,0x00000000,0x00000000,0x00000000}},	//   _xullo_, --, --, --, 
   {{0xd291c007,0x00000000,0x00000000,0x00000000}},	//   _anwar_, --, --, --, 
   {{0x12612018,0x9e108011,0x22cb4018,0xb4356009}},	//   _são_, _igual__pódense_, _mostrand_para_, _at__sætte_, 
   {{0xf2cb2015,0xa2896006,0x9ac2600c,0x1377c00f}},	//   _follow__thank_, _ཡོངས__དགའ_, _तमाम__लोग_, _ukukhonz_ujehova_, 
   {{0x9e52c007,0x0be8c003,0x00000000,0x00000000}},	//   _kebajika, _བཟོ__ཅན_, --, --, 
   {{0x1f49c002,0x42612018,0x92d8c018,0xc413c002}},	//   _производ, _vão_, _galera_, _човека_, 
   {{0x575a000c,0x3c56a013,0x00000000,0x00000000}},	//   _बा__रउरा_, _जानें_, --, --, 
   {{0xa256600e,0x22612025,0xfbe10003,0x3839a003}},	//   _více__hodin_, _tão_, _གཙོ__དང_, _སྲུང__བརྩི_, 
   {{0xdaf3a009,0x4eaae002,0x00000000,0x00000000}},	//   _yderlige, _или__не_, --, --, 
   {{0x50cba002,0x2201001d,0x00000000,0x00000000}},	//   _ове__године_, _dibina_, --, --, 
   {{0xa075a011,0x2eadc002,0x00000000,0x00000000}},	// [0a0] _navegaci_ferramen, _поделио__ла_, --, --, 
   {{0x7442000b,0x65ef800f,0x00000000,0x00000000}},	//   _iti_, _ukutadis_ibhayibh, --, --, 
   {{0x244d400b,0x6259c006,0x0474c00b,0xe5832013}},	//   _kubera__ko_, _སྒྲིང__བཟོ_, _nyuma__yo_, _अम्बेडकर, 
   {{0xc201200f,0x4edca015,0xccf1800b,0xf442c00b}},	//   _kuyi_, _mengenai__lintasme_, _ibiteker, _bwe_, 
   {{0xaf354002,0x2ddf4003,0x00000000,0x00000000}},	//   _за__то_, _འདི__སེམས_, --, --, 
   {{0xc291e015,0x863f201d,0x34828012,0x00000000}},	//   _antar_, _berhampi, _registru_sa_, --, 
   {{0x2442c004,0x72da6011,0xd4b9600b,0x00000000}},	//   _ewe_, _igrexa_, _ubuteget_bwa_, --, 
   {{0xf2300015,0x00000000,0x00000000,0x00000000}},	//   _utama__berisi_, --, --, --, 
   {{0xa4676033,0x5290a01d,0x127ae006,0x00000000}},	//   _prije__minuta_, _sabah_, _ཏོ__སྦེ_, --, 
   {{0x9a5f800d,0x00000000,0x00000000,0x00000000}},	//   _pregunta_, --, --, --, 
   {{0xf442002c,0x4f3aa034,0xf3f8c004,0x7442c035}},	//   _ati_, _koordina, _indu_, _zwe_, 
   {{0x238ae00f,0xa351200b,0x4c4e000c,0x57692003}},	//   _zonke__izizwe_, _ya__congo_, _कहले_, _ལམ__བྱེད_, 
   {{0x2e080018,0x9a276002,0x00000000,0x00000000}},	//   _se__esqueceu_, _га__проширит, --, --, 
   {{0xe1bd2002,0x451ba002,0xfbe18003,0x00000000}},	//   _бисте_, _су__написани_, _ཚུལ__དང_, --, 
   {{0x340b0033,0x82d9e019,0x5d862002,0x00000000}},	//   _osobnu__poruku_, _mote_, _разред_, --, 
   {{0x28c58036,0x58c6e02a,0x00000000,0x00000000}},	//   _उदयपुर_, _innehold, --, --, 
   {{0x2200a00b,0x7b9c2004,0x2be7a022,0x2bbce003}},	// [0b0] _bibi_, _njengoko_, _से__हम_, _ཡི__གེ_, 
   {{0xf442c00b,0xce350011,0xcc60801a,0x9cbb6037}},	//   _rwe_, _mulleres_, _laurdag_, _teléfono__escribe_, 
   {{0xa3312031,0xa709c002,0x32de8034,0xe2caa038}},	//   _indonesi_yang_, _делити_, _ei__lita_, _este__mapa_, 
   {{0x07620014,0xdc6f600a,0x00000000,0x00000000}},	//   _में__पूरा_, _अक्सर__पूछे_, --, --, 
   {{0x92902015,0xe2d9c014,0x00000000,0x00000000}},	//   _pajak_, _नकदी_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x1442c00b,0x00000000,0x00000000,0x00000000}},	//   _twe_, --, --, --, 
   {{0x433fa011,0x00000000,0x00000000,0x00000000}},	//   _dispoñib_baixo_, --, --, --, 
   {{0xe4748038,0x9e730002,0xe23fc012,0x32d9c00b}},	//   _publicad_na_, _цео_, _pred__mesiacmi_, _wowe_, 
   {{0x44778011,0x42f2400a,0x00000000,0x00000000}},	//   _informac_da_, _हो__सकती_, --, --, 
   {{0x3e72e002,0x00000000,0x00000000,0x00000000}},	//   _ње_, --, --, --, 
   {{0xf4420004,0x02d8e00d,0xebe76006,0x159e200e}},	//   _ath_, _manera_, _འཕྲིན__གི_, _fóru__nemůžete_, 
   {{0x9b19e002,0x00000000,0x00000000,0x00000000}},	//   _библиоте, --, --, --, 
   {{0x1b61800a,0x00000000,0x00000000,0x00000000}},	//   _दिखने_, --, --, --, 
   {{0x048f400e,0xe29b8003,0x00000000,0x00000000}},	//   _seznam__cz_, _ཚོད__སྐར_, --, --, 
   {{0x56b1a013,0x12616018,0x00000000,0x00000000}},	// [0c0] _मस्ती_, _aço_, --, --, 
   {{0x542b6009,0x6212600e,0x1aca400a,0x49ac2002}},	//   _regioner__postnr_, _mnoha_, _देवरिया_, _превод__захтеви_, 
   {{0x2c8e400c,0x7b8d2003,0x1c03800c,0x00000000}},	//   _कईगो_, _ཟས_, _रउरा__ना_, --, 
   {{0x0290401f,0xe306a00d,0xd290e015,0x9c0b6003}},	//   _ialah_, _los__mejores_, _ngga_, _ཕྱག__ལས_, 
   {{0xf4958034,0x39aa2002,0x327b2002,0x4b8a2002}},	//   _om__lag_, _којим_, _ово__свиђа_, _којом_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xc4b4801a,0x00000000,0x00000000,0x00000000}},	//   _namngjev_del_, --, --, --, 
   {{0x5e88e002,0x00000000,0x00000000,0x00000000}},	//   _да__нас_, --, --, --, 
   {{0xf3668009,0xc2988003,0xab952003,0x42556003}},	//   _har__brug_, _འཛུལ__དེབ_, _ཉིན__ཐོ_, _བཅོས__མཐའ_, 
   {{0xe6d02037,0x02998003,0x7ba6000a,0xb28b8003}},	//   _venta__perfecci, _ཀྱི__གཏམ_, _है__अब_, _གནས__ཀྱི_, 
   {{0x93f9801f,0xf386c015,0x3497e00d,0x00000000}},	//   _turut_, _silahkan__mencoba_, _si__lo_, --, 
   {{0x3c59e015,0x6446c011,0x00000000,0x00000000}},	//   _listrik_, _galego__de_, --, --, 
   {{0x5497e00d,0xce1c6027,0x83954027,0x346b4027}},	//   _si__no_, _prázdny_, _presne_, _chcem__sa_, 
   {{0x7241800c,0x00000000,0x00000000,0x00000000}},	//   _दिहले_, --, --, --, 
   {{0x99998012,0x00000000,0x00000000,0x00000000}},	//   _ísť_, --, --, --, 
   {{0xa491201a,0x32da4012,0xd200c00e,0x6c7b000a}},	//   _er__dei_, _hoteli_, _lidi_, _प्रिन्ट__करने_, 
   {{0x07e4001c,0xd9832002,0x2ded6002,0xf383200c}},	// [0d0] _गुजरात_, _посебно_, _српски__словачки_, _साहित्य__भोजपुरी_, 
   {{0x1213800b,0xeddda003,0x6859e00e,0xe41d800f}},	//   _moshi_, _སྲིད__སྐྱོང_, _ochrana__osobních_, _azi__ukuthi_, 
   {{0x8a884039,0xcc7de03a,0xa472201a,0x926ca012}},	//   _kegiatan_, _འདིའི_, _som__dei_, _nebol_, 
   {{0x6457c020,0x6474c028,0xc861000b,0xe290e025}},	//   _མི__རྒྱལ_, _luego__de_, _gitekere_kiratang, _ligar_, 
   {{0x7417c00f,0x00000000,0x00000000,0x00000000}},	//   _kudingek, --, --, --, 
   {{0xf4912009,0x54c24009,0xf497e018,0x92796003}},	//   _at__der_, _oplysnin_om_, _um__bom_, _དྲ__སྣང_, 
   {{0x746fa012,0xf27b2009,0x325a000e,0x00000000}},	//   _pozrite__si_, _indstill, _mohl_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6d648004,0x9ba6e006,0xc697e00c,0x00000000}},	//   _iintlang_kwandule_, _སྒྱུར__ལས_, _मौजूदा__सरकार_, --, 
   {{0x79cf2003,0x00000000,0x00000000,0x00000000}},	//   _དགའི_, --, --, --, 
   {{0x23386025,0xf163c00e,0x00000000,0x00000000}},	//   _que__também_, _je__potřeba_, --, --, 
   {{0xff67e002,0x2f1c8009,0x1318a00f,0x00000000}},	//   _других_, _der__anvendes_, _yini__enye_, --, 
   {{0x6c4e000a,0x00000000,0x00000000,0x00000000}},	//   _कहते_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x28464018,0xd212e018,0x00000000,0x00000000}},	//   _qualidad, _minhas_, --, --, 
   {{0x0a4dc014,0xf422e00f,0x933cc002,0xe250e00c}},	// [0e0] _के__भाग_, _kwakuwuk, _календар_, _सुपर__पावर_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x1315601f,0x0342200a,0x0d9a8003,0x00000000}},	//   _yang__boleh_, _में__पूरी_, _གཏོང__དགོས_, --, 
   {{0x6290601d,0x4495c00d,0x00000000,0x00000000}},	//   _kanak_, _no__hay_, --, --, 
   {{0x83f8e00f,0x3795200a,0x00000000,0x00000000}},	//   _angu_, _खोजें__परिभ्रमण_, --, --, 
   {{0xfc60a028,0xc3f9e015,0x52d68012,0xa41c800f}},	//   _este__artículo_, _butuh_, _bez__predchád, _umbhalo__wosuku_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x4dc72006,0x3ee28011,0x56e5200a,0x00000000}},	//   _བསྒྱུར__བཅོས_, _adiciona_consulte_, _मूवी__मस्ती_, --, 
   {{0xc3f8e00f,0x04b7600b,0x2a75c00a,0x00000000}},	//   _engu_, _ishiraha_onu_, _उन्नाव_, --, 
   {{0xe24da029,0x2d7ee002,0x00000000,0x00000000}},	//   _འདས_, _гу_, --, --, 
   {{0x2998400e,0x4d8fe003,0x00000000,0x00000000}},	//   _domů_, _བླངས_, --, --, 
   {{0x3c72400a,0x00000000,0x00000000,0x00000000}},	//   _डाउनलोड__करें_, --, --, --, 
   {{0xc2950003,0x8be6a00a,0x397e2002,0x00000000}},	//   _བཞིན__པའི_, _हो__रही_, _групе_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x9be6e006,0x00000000,0x00000000,0x00000000}},	//   _འཕྲུལ__ལས_, --, --, --, 
   {{0x03b1a01a,0x032a0010,0x00000000,0x00000000}},	// [0f0] _les__meir_, _og__meget_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x3225400f,0xc496e00d,0xc2902007,0x79a36018}},	//   _akekho_, _no__en_, _zakat_, _ministér, 
   {{0x93f8a02c,0x2ba6200a,0x7df38002,0x00000000}},	//   _hejuru_, _है__जब_, _вредних__награда_, --, 
   {{0xa2bec003,0x00000000,0x00000000,0x00000000}},	//   _དབང__བོད_, --, --, --, 
   {{0x76874006,0x50a6200a,0x00000000,0x00000000}},	//   _བཞེངས__ཡོདཔ_, _ऊधम__सिंह_, --, --, 
   {{0x699b2011,0xa3f9000b,0x00000000,0x00000000}},	//   _maioría_, _inzu_, --, --, 
   {{0xd27f600b,0xab9c0003,0xe202000b,0xa2586003}},	//   _ibanga_, _འདུག__དེ_, _rusizi_, _དགོངས__ཚུལ_, 
   {{0x16e92006,0xa2eaa00d,0x74b1400b,0x00000000}},	//   _འཕྲུལ__སློབ_, _cuentas_, _kujya__mu_, --, 
   {{0x3480000e,0x0239000b,0xb2ace003,0x00000000}},	//   _cena__kč_, _kuba__buri_, _ཐང__འཇམ_, --, 
   {{0x986c400d,0x3bbc800b,0x23cf800e,0xba13400f}},	//   _nuestras_, _kiliziya__gatulika_, _barvy_, _ukwamuke, 
   {{0x08c72009,0x6004000c,0x8e9e6002,0x00000000}},	//   _indehold, _के__प्राचीन_, _за__корисник, --, 
   {{0xbca2a00a,0x00000000,0x00000000,0x00000000}},	//   _आप__अपने_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa2488034,0x00000000,0x00000000,0x00000000}},	//   _fram_, --, --, --, 
   {{0xeba84003,0xc556a00a,0xae572002,0x00000000}},	// [100] _ཕྱི__ཟླ_, _देश__दुनिया_, _иза_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x886f801a,0xc4a2200e,0x6742600c,0x00000000}},	//   _sunnhord, _heurece__je_, _अल्पसंख्_भासा_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x627fe00e,0x0a6e800a,0x148ca00e,0x0c78a00c}},	//   _seznam_, _करते__हुए_, _kč__bez_, _होखे__चाहे_, 
   {{0x125a801d,0x00000000,0x00000000,0x00000000}},	//   _kuala_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x22d9e018,0xa2124018,0x8b6b800d,0x00000000}},	//   _avalia__este_, _filho_, _justicia_, --, 
   {{0x75b6c022,0x7bd2a006,0xa290201d,0x00000000}},	//   _कि__भारत_, _འབད__ནི_, _zakar_, --, 
   {{0x7bbf2021,0x9201802b,0x23e0600b,0x4ec86002}},	//   _ལྷ__ཁང_, _kuri_, _igihugu__urwanda_, _то__не_, 
   {{0x3712a00a,0xf016a00e,0x2d5ae002,0x00000000}},	//   _हो__सकता_, _příslušn, _дс_, --, 
   {{0x42f40011,0x71772002,0x22ef800f,0x1e6d8002}},	//   _entrada__debes_, _место_, _inkinga_, _за__све_, 
   {{0xe495e012,0x1e6f0035,0x996e000e,0x00000000}},	//   _sa__na_, _ongcwele_, _vybrat__mobilní_, --, 
   {{0xb2126018,0x00000000,0x00000000,0x00000000}},	//   _tinha_, --, --, --, 
   {{0x6278a006,0xe25b000d,0x7f57000a,0x00000000}},	//   _བརྒྱའི__དྲན_, _hablar_, _की__मांग_, --, 
   {{0xc4426012,0x1e3b201d,0x5a7be01c,0x9d91c003}},	//   _kto_, _kepakara, _सलमान__खान_, _ཡོང__ཁུངས_, 
   {{0x43160004,0xc24da029,0x00000000,0x00000000}},	// [110] _ndiza_, _འདུ_, --, --, 
   {{0x0201802b,0x19bfc00e,0x141bc002,0xcc4f0013}},	//   _buri_, _ke__stažení_, _уколико_, _उनसे_, 
   {{0x7d6d2002,0xc8fc800e,0x8dd96003,0xc1eb0002}},	//   _шта_, _odpovědě, _སྐུ__མགྲོན_, _европе_, 
   {{0xff3ca039,0x2442402d,0x2d26000e,0xd2d8a012}},	//   _perusaha, _rtl_, _hodnocen_produktu_, _chcel_, 
   {{0xf4426004,0x027f2009,0x72d9c012,0x00000000}},	//   _nto_, _åbner_, _prvej_, --, 
   {{0x26338015,0x00000000,0x00000000,0x00000000}},	//   _maksimal_, --, --, --, 
   {{0xf3f8001d,0x24426015,0xc2668003,0x00000000}},	//   _mahu_, _ato_, _ཏན__གྱི_, --, 
   {{0x009a400e,0x00000000,0x00000000,0x00000000}},	//   _přání_, --, --, --, 
   {{0xd70d4018,0x3c9ec002,0x00000000,0x00000000}},	//   _experiên, _уместо_, --, --, 
   {{0x1c71803b,0x83426011,0x32cc000f,0x9cd36013}},	//   _पार्टी_, _navegaci_procura_, _ngaleso_, _देश__विदेश_, 
   {{0x9201001b,0x00000000,0x00000000,0x00000000}},	//   _mizi_, --, --, --, 
   {{0xd2b70002,0xba09a012,0xec97e00f,0x00000000}},	//   _paročist_dodaci_, _zodpoved, _nomuzwa__wokuthi_, --, 
   {{0x4e72e002,0x7bad0003,0xbec7601f,0xe2d8a027}},	//   _не_, _ནང__དུ_, _menyerta, _chcem_, 
   {{0xc4726012,0x66b6200c,0x00000000,0x00000000}},	//   _kto__je_, _आभासी__क्रांतिय, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x825b003c,0xc2966003,0x00000000,0x00000000}},	//   _tuzla_, _གཡུ__ཞུན_, --, --, 
   {{0x1290201d,0x2242a003,0x3c4f800a,0x00000000}},	// [120] _cakap_, _བསུ_, _वैसे_, --, 
   {{0x1379e00f,0x00000000,0x00000000,0x00000000}},	//   _umlando_, --, --, --, 
   {{0x5c07a00a,0x00000000,0x00000000,0x00000000}},	//   _कन्नौज__कुशीनगर_, --, --, --, 
   {{0x2200c011,0xa2fb000b,0x00000000,0x00000000}},	//   _galiza_, _bwa__bugomba_, --, --, 
   {{0xd2786018,0xccf3e00a,0x00000000,0x00000000}},	//   _jornal_, _राज्य__दिल्ली_, --, --, 
   {{0xc2904015,0x0c490014,0xebd2e012,0x7a31a003}},	//   _kamar_, _बूझे_, _dobre__fungovať_, _སྔ__མོའི_, 
   {{0x0c09a014,0x4e7a6002,0x00000000,0x00000000}},	//   _फरवरी__को_, _је__од_, --, --, 
   {{0x82bee03c,0xc2c92037,0x83cee009,0x00000000}},	//   _se__bilo_, _escribe__como_, _genvej_, --, 
   {{0x78198002,0x3f59800c,0x00000000,0x00000000}},	//   _пошаљи__одговор_, _के__राजधानी_, --, --, 
   {{0x9d67200a,0x32fc8009,0x8a4d400c,0xf76a000a}},	//   _अपना__ब्लॉग_, _smag_, _हो__जाई_, _उत्तराखं_बाढ़_, 
   {{0x0da26009,0x996fa00e,0x2f50a01a,0x8355a018}},	//   _tilføjet_, _na__mobilní_, _kjærleik_, _tweetar_, 
   {{0x0dd52006,0x8bccc00a,0x1e428002,0xe49e000e}},	//   _ཤོགངོ__སྤྲོད_, _मास्टरमा_का_, _је__као_, _také__na_, 
   {{0x84b84015,0x23042002,0x00000000,0x00000000}},	//   _bisa__di_, _удружења_, --, --, 
   {{0x32e34011,0x029a0003,0x00000000,0x00000000}},	//   _atendémo_pode_, _པའི__གཏམ_, --, --, 
   {{0xbeb12012,0x5fa7c011,0x8ec4200b,0x2486e01c}},	//   _porovnan, _benestar_, _kinyarwa, _मुलायम_, 
   {{0xe910400f,0x00000000,0x00000000,0x00000000}},	//   _ngeso__lengqond, --, --, --, 
   {{0xde016011,0x00000000,0x00000000,0x00000000}},	// [130] _aloxamen_turístic, --, --, --, 
   {{0x9a1b401d,0x32b46012,0xeae46002,0x00000000}},	//   _terdiri__daripada_, _konca_, _шпански__шведски_, --, 
   {{0x4847201a,0xcc76001a,0x00000000,0x00000000}},	//   _gjeldand, _nærare_, --, --, 
   {{0xa2980021,0x13b0e018,0xf552e00a,0x7ea80002}},	//   _འཇིགས__མེད_, _clique_, _से__ज्यादा_, _пријави__се_, 
   {{0xe27e8015,0x7bfca003,0x32cbe00c,0x00000000}},	//   _emang_, _ཞུ__ཁང_, _अछि__ज्योति_, --, 
   {{0xeb978014,0xe9312012,0x206d600a,0x00000000}},	//   _नाम__के_, _vložiť_, _यह__सामग्री_, --, 
   {{0x126c8012,0x502fe00d,0x9f47200a,0xe205c012}},	//   _rokoch_, _alrededo, _आपत्तिजन_लिंक_, _mesiacmi_, 
   {{0xa3e22009,0x2be92022,0x827ec016,0xd3d5600d}},	//   _indlæg__svar_, _जब__हम_, _uken_, _la__muerte_, 
   {{0xeb980022,0x9b8da003,0x00000000,0x00000000}},	//   _समय__के_, _ངས_, --, --, 
   {{0xebec6014,0x00000000,0x00000000,0x00000000}},	//   _सुविधा__के_, --, --, --, 
   {{0xb4428011,0x7429201d,0xc3208031,0x1269a006}},	//   _ata_, _tempatan_, _upaya_, _རྫོང__ཨིང_, 
   {{0x33f4000e,0xa9f66038,0xd08b200e,0xc313400c}},	//   _jestli_, _verán_, _nelíbí_, _गइल__बेसी_, 
   {{0x54b26011,0x13868012,0x00000000,0x00000000}},	//   _non__se_, _tvare_, --, --, 
   {{0x5e730002,0xe4a92018,0x00000000,0x00000000}},	//   _тек_, _compras__na_, --, --, 
   {{0xf2d82015,0x9ae92003,0x56e8e002,0xb7b7c002}},	//   _pake_, _ཅན__གློག_, _манастир, _раније_, 
   {{0xb2f9600d,0x0a64800a,0xc26c600e,0x7b73a00f}},	//   _que__puede_, _महीने__साल_, _jenom_, _ukhuluma_, 
   {{0x6394e018,0x73f8a01a,0xd9312012,0x7beae003}},	// [140] _coisas_, _etter__kvart_, _uložiť_, _འདེབས__དྲ_, 
   {{0xb0b28012,0x42ca800e,0x00000000,0x00000000}},	//   _práva__vyhraden, _řady_, --, --, 
   {{0x6a3da014,0xc2a70003,0xf2bf200b,0x00000000}},	//   _धार_, _གར__གྱི_, _no__hino_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x0ca6a022,0xc3940018,0x00000000,0x00000000}},	//   _से__कहीं_, _coisa_, --, --, 
   {{0xae82c022,0x0e426002,0x00000000,0x00000000}},	//   _के__राज्य_, _је__за_, --, --, 
   {{0x927a200f,0xabfb0003,0x00000000,0x00000000}},	//   _ensimini_, _པོ__དེ_, --, --, 
   {{0x457fc00b,0x19c4400a,0x00000000,0x00000000}},	//   _zigezweh, _सहायता__स्वशिक्ष, --, --, 
   {{0xe290c01e,0x12d9600b,0x82d8200b,0x00000000}},	//   _islama_, _bagera_, _yaje_, --, 
   {{0x3f240012,0xd30e6038,0x00000000,0x00000000}},	//   _našej_, _elabora_, --, --, 
   {{0x7371600f,0x00000000,0x00000000,0x00000000}},	//   _ezinhle__zombuso_, --, --, --, 
   {{0x8b882022,0x00000000,0x00000000,0x00000000}},	//   _मद_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x1395801a,0x737b801f,0x00000000,0x00000000}},	//   _desse_, _semalam_, --, --, 
   {{0x9442a019,0x6436600b,0xa48ac00e,0x00000000}},	//   _ntb_, _musenyer_mukuru_, _děkuji__za_, --, 
   {{0x71cb800f,0x00000000,0x00000000,0x00000000}},	//   _israyeli__wasendul, --, --, --, 
   {{0xf2d8200b,0xb3958018,0xc5ada012,0x12dea00c}},	// [150] _paje_, _nesse_, _najobľúb, _अउरी_, 
   {{0xeae52028,0x02abe020,0x63096015,0x00000000}},	//   _siguient, _རབ__གནས_, _sangat__berarti_, --, 
   {{0x538d0015,0x64b6e011,0x0a67200c,0x00000000}},	//   _properti_, _traballo__de_, _मिथिलांच_में_, --, 
   {{0x649bc011,0x00000000,0x00000000,0x00000000}},	//   _galicia__de_, --, --, --, 
   {{0xe4adc01a,0xf4918018,0x3aa6600a,0x00000000}},	//   _ikkje__er_, _em__seu_, _में__मदद_, --, 
   {{0x21b16014,0x7abbc00a,0xf491a026,0x64c32011}},	//   _प्रतिहार_, _चाहते__हैं_, _en__der_, _servizos__de_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x553ce01f,0x674c600c,0x649ce018,0x00000000}},	//   _sekirany, _पूर्वी__पाकिस्ता, _serviços__de_, --, 
   {{0xeb95c003,0x00000000,0x00000000,0x00000000}},	//   _ཉིན__མོ_, --, --, --, 
   {{0x74bcc00e,0x6259e014,0x82fcc00b,0x67614014}},	//   _jsem__si_, _यक्ष_, _rwego_, _कि__पाकिस्ता, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x93fa2018,0x075f000a,0x00000000,0x00000000}},	//   _fiquei_, _जिन्हें_, --, --, 
   {{0x7ed4e002,0xbefb202e,0x8213000e,0x2e96000a}},	//   _по_, _natjecan, _rychle_, _आगरा__इंदौर_, 
   {{0xd467e011,0xc4d58022,0xa5bb6002,0x00000000}},	//   _aínda__que_, _हैसियत_, _образова, --, 
   {{0xfc48e014,0x00000000,0x00000000,0x00000000}},	//   _संगे_, --, --, --, 
   {{0x9bcc6006,0xa2d3800b,0xf2d8e037,0x00000000}},	//   _ཐོག__ལས_, _ya__tsinze_, _bueno__malo_, --, 
   {{0x64bd4008,0x00000000,0x00000000,0x00000000}},	// [160] _logo__de_, --, --, --, 
   {{0xd2a6402e,0x00000000,0x00000000,0x00000000}},	//   _seljaci_, --, --, --, 
   {{0x4ab7e00a,0x00000000,0x00000000,0x00000000}},	//   _दिया__गया_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x73cee009,0x225a0006,0x00000000,0x00000000}},	//   _bliver_, _དཔེ__གཞི_, --, --, 
   {{0xef0f2003,0x82ffe039,0x45c8a00b,0x1294800a}},	//   _འགྲན__བསྡུར_, _sebagian__besar_, _ushakish, _ग्वालियर_, 
   {{0x1740000c,0x6735200c,0x2215200c,0xbeccc002}},	//   _करे__खातिर_, _अउर__उनका_, _अउर__उनकर_, _пројекта_, 
   {{0xf3298037,0xc346802a,0x00000000,0x00000000}},	//   _quieres__recibir_, _eller__annet_, --, --, 
   {{0x62d84018,0x2ed56002,0x027a2003,0xa30ba00b}},	//   _fale_, _ми__је_, _དུ__ཡོད_, _gisanzwe__umwaka_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x5640002b,0xee644002,0x00000000,0x00000000}},	//   _abanyarw, _тако__да_, --, --, 
   {{0x3b30c022,0x7fd4e00f,0xa28d2003,0x00000000}},	//   _पर__चर्चा_, _izingelo, _སྤྱིའི__བོད_, --, 
   {{0x0bc3800a,0xe457401a,0xe5a4000f,0x8b93200c}},	//   _रही__है_, _frå__til_, _ukuthi__unkulunk, _विषय__पे_, 
   {{0x4bcec013,0x22d78018,0xfdf5000e,0x4cf50012}},	//   _नही_, _abaixo__para_, _ostatníc, _ostatnýc, 
   {{0xa312000e,0xc2d46018,0xc299c025,0x9ab6a00c}},	//   _přístroj, _jardim_, _assim__como_, _राज__काज_, 
   {{0x62d9e028,0x23f8801d,0x27a6c003,0xe2df000a}},	//   _usted_, _akaun_, _འཇིག__རྟེན_, _इसकी_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [170] --, --, --, --, 
   {{0x8b2ee018,0x9c3b8002,0x1e9d600c,0x00000000}},	//   _merament_ilustrat, _студије_, _कवनो__हिस्_, --, 
   {{0x2386c012,0x1b62000a,0x730da00f,0x8171c00c}},	//   _dvere_, _मिलने_, _kuka__israyeli_, _तारीख__अप्रैल_, 
   {{0x42126018,0x43cf401a,0x2299c006,0xc998c00e}},	//   _minha_, _elevar_, _མཛོད__གོལ_, _bodů_, 
   {{0x32126018,0xd442c03d,0x8c07001a,0x9e2dc002}},	//   _linha_, _atd_, _tilskot_, _крају_, 
   {{0xb47f602a,0x3a9c400c,0x00000000,0x00000000}},	//   _sier__at_, _में__जवन_, --, --, 
   {{0x1be22003,0x62840015,0x2201e007,0xb061a00b}},	//   _ཀྱི__བང_, _kyuhyun_, _cuti_, _ugushyin, 
   {{0x0b326003,0xeedd0018,0xf239000f,0x7d66a00a}},	//   _འབྲེལ__གཏུགས_, _referênc, _waba__yini_, _मन__सदाबहार_, 
   {{0x7213e01d,0x66fa600c,0x92da6018,0x00000000}},	//   _perkhidm, _नारी__शक्ति_, _igreja_, --, 
   {{0xf467e01a,0x00000000,0x00000000,0x00000000}},	//   _dei__tre_, --, --, --, 
   {{0x9c4f001c,0x00000000,0x00000000,0x00000000}},	//   _उनके_, --, --, --, 
   {{0xb2fce01d,0x33f9600b,0xb63a200d,0xc48ea018}},	//   _kongsi_, _hagufi_, _habitaci, _de__às_, 
   {{0x7c08600a,0x00000000,0x00000000,0x00000000}},	//   _पुलिस__ने_, --, --, --, 
   {{0xe49fc009,0x72b4600e,0xfee30002,0xbc7dc00c}},	//   _indlæg__du_, _konce_, _днк_, _एकरा__साथे_, 
   {{0x0d8f2003,0xe46c200f,0xd62f2006,0x8b2f2003}},	//   _དགོས_, _kungenze_ukuthi_, _དགོཔ_, _དགོང_, 
   {{0x02938003,0x0457601a,0x77ea400c,0x1c74c00a}},	//   _འགུལ__གོད_, _frå__ein_, _के__सुरक्षा_, _रिश्ते_, 
   {{0xc2d8600b,0x03e6801c,0x13f4601d,0xc46d2028}},	// [180] _kane_, _उत्तराखं, _sertai_, _hacer__una_, 
   {{0x83b8e01a,0x7248801b,0x00000000,0x00000000}},	//   _frå__http_, _nyama_, --, --, 
   {{0xe6d54006,0x64c10038,0x00000000,0x00000000}},	//   _འབད__བཏུབ_, _parroqui_de_, --, --, 
   {{0x52004007,0x5422a00b,0x7290a039,0x0c0ee006}},	//   _ahli_, _hanze__imbuga_, _kabar_, _སྐབས__ལུ_, 
   {{0xca6f400a,0x7876600f,0x00000000,0x00000000}},	//   _विज्ञापन__दें_, _ngunkulu, --, --, 
   {{0xe462600f,0x00000000,0x00000000,0x00000000}},	//   _bakholel_ukuthi_, --, --, --, 
   {{0xdd2fe00e,0xe68d400c,0x7ed56002,0x00000000}},	//   _uživatel_, _पंवार_, _тој_, --, 
   {{0x3d5a6002,0xf4736024,0x00000000,0x00000000}},	//   _које_, _partizan_, --, --, 
   {{0x0bcae00a,0xebcdc013,0x00000000,0x00000000}},	//   _कहना__है_, _हमे_, --, --, 
   {{0xf292a003,0xf491e005,0x00000000,0x00000000}},	//   _སྐར__ཁུང_, _at__me_, --, --, 
   {{0x93328009,0xbfab6012,0x00000000,0x00000000}},	//   _der__findes_, _šírka_, --, --, 
   {{0x37acc003,0x62f0000b,0xf355c012,0x00000000}},	//   _དགེ__འདུན_, _inkingi_, _priemer_, --, 
   {{0x0379a01f,0x00000000,0x00000000,0x00000000}},	//   _bayaran_, --, --, --, 
   {{0x226c200d,0xf98a400e,0x00000000,0x00000000}},	//   _mejor_, _země_, --, --, 
   {{0x32236015,0x924c2003,0x00000000,0x00000000}},	//   _artikel__setiap_, _ཡོང__ཐབས_, --, --, 
   {{0x3f8e8002,0xedd7a010,0x00000000,0x00000000}},	//   _врх__стране_, _roskilde_, --, --, 
   {{0xa26dc00b,0xa201800b,0x4a3de022,0x02a3e006}},	// [190] _ministri_, _biri_, _तार_, _རྒེད__འོག_, 
   {{0x6491e018,0x4c40c011,0x00000000,0x00000000}},	//   _em__de_, _non__dispoñem, --, --, 
   {{0xf442c012,0x82886002,0x00000000,0x00000000}},	//   _ste_, _preporuk_odgovori_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x31e6c022,0x42474012,0x22a74003,0x5b9aa003}},	//   _चौधरी_, _nahlásiť_, _ཕྲེང__རིམ_, _དྲན__སོ_, 
   {{0xdb77000b,0x7bd7c003,0x00000000,0x00000000}},	//   _ikirenga_, _གསར__དྲ_, --, --, 
   {{0xfbc3400c,0xa290e00b,0x00000000,0x00000000}},	//   _कबो_, _ishaka_, --, --, 
   {{0xba0ba00f,0xf29da003,0x2201800b,0xc95ac002}},	//   _ngobuqot, _བྱེད__མཁན_, _ziri_, _који__позивају_, 
   {{0x9290c00e,0x7bfd6006,0x1404200f,0x7a59600c}},	//   _zadat_, _ཚུ__ཡང_, _okungenz, _कि__लोक_, 
   {{0xd2ca401a,0xaa17e00f,0xfa6bc002,0x5b83c003}},	//   _halde_, _legatsha_, _звезда_, _སྟོན__ྋགོང_, 
   {{0xef1be018,0xf752c002,0x00000000,0x00000000}},	//   _olá_, _референц, --, --, 
   {{0x3cb8000e,0x04b4801a,0x00000000,0x00000000}},	//   _odpovědi_, _etter__ein_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2e916002,0xaaadc00c,0xe2a3e003,0x00000000}},	//   _страница__је_, _बाड़े__अउर_, _ཀྱི__རྩམ_, --, 
   {{0x5491e009,0xa201800b,0xd2f9e018,0x9285000b}},	//   _at__se_, _riri_, _nenhuma_, _inshuro_, 
   {{0xb201801f,0xd756000c,0x00000000,0x00000000}},	//   _siri_, _चाहीं__बाकिर_, --, --, 
   {{0x8a3e000a,0x5cdae012,0x00000000,0x00000000}},	// [1a0] _बार_, _katalóg_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7290403c,0xebd8800c,0x0e84c002,0x2eaae002}},	//   _namaz_, _धार__के_, _завод__за_, _сада__је_, 
   {{0x1e292002,0x937a601d,0x824d8015,0xac69000b}},	//   _нам_, _jawatan_, _di__bagian_, _umurimo_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xf2c9800b,0xa31e000f,0xda4e200c,0x00000000}},	//   _bbc__ntabwo_, _ingcebo_, _के__नया_, --, 
   {{0x6472e025,0x9bd34006,0x49aa6002,0x4243000c}},	//   _rio__de_, _འབད__མི_, _гори_, _अगिला_, 
   {{0x025b001e,0x63f8801d,0x2290e00b,0x00000000}},	//   _tuzli_, _hujung_, _ashaka_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xb4422010,0xa617e002,0x00000000,0x00000000}},	//   _luk_, _професор, --, --, 
   {{0x72d8a00e,0x136e800f,0x00000000,0x00000000}},	//   _labe_, _engumbus_ujehova_, --, --, 
   {{0xc86c200a,0x00000000,0x00000000,0x00000000}},	//   _रहेगा_, --, --, --, 
   {{0x5ecec002,0x7b73a00f,0x6290e00b,0x0f39000e}},	//   _преко_, _ekhuluma_, _ushaka_, _milionů_, 
   {{0x7290c02d,0xd706c00c,0x57a7a003,0x00000000}},	//   _zadar_, _रहल__बिया_, _པར__བྱེད_, --, 
   {{0xfb674037,0x8e9fa011,0xfbda800c,0x00000000}},	//   _de__respuest, _tódolos_, _भाषा__से_, --, 
   {{0x3aea002e,0x00000000,0x00000000,0x00000000}},	// [1b0] _vjerojat, --, --, --, 
   {{0x22ca6010,0x8393600f,0x00000000,0x00000000}},	//   _lande_, _ngemvume__ukuze_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x4fd20002,0x00000000,0x00000000,0x00000000}},	//   _војска_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x32d8a028,0x5ef30022,0x73bd800e,0x6bdc200a}},	//   _hace_, _अधिका_, _důvodu_, _राजौरी__श्रीनगर_, 
   {{0xe7b54009,0xf36f4015,0x0290c015,0xb2b6600c}},	//   _regering, _lintasme__sangat_, _sadar_, _राजधानी__बनवलन_, 
   {{0xd442e01d,0x00000000,0x00000000,0x00000000}},	//   _ptg_, --, --, --, 
   {{0x8290a007,0x00000000,0x00000000,0x00000000}},	//   _undang_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6cdfc003,0x00000000,0x00000000,0x00000000}},	//   _བལྟས_, --, --, --, 
   {{0x0a95e00c,0xdf1d400e,0xb29c4003,0x00000000}},	//   _से__याद_, _pravděpo, _འཕྲིན__བཀའ_, --, 
   {{0x4b882021,0x00000000,0x00000000,0x00000000}},	//   _ཨམ_, --, --, --, 
   {{0x5f02c014,0x00000000,0x00000000,0x00000000}},	//   _सिद्दीकी_, --, --, --, 
   {{0x13f8a00b,0x00000000,0x00000000,0x00000000}},	//   _bacu_, --, --, --, 
   {{0xe2aec03e,0xed198019,0xc4622007,0xb2cd200f}},	//   _कहाँ_, _tjeneste_, _dibenark, _ukwenza__kanjalo_, 
   {{0x726c4025,0x53062009,0xec0a800c,0x00000000}},	// [1c0] _pelos_, _de__seneste_, _बचवन__के_, --, 
   {{0x7291e00d,0x626c6011,0xa1eb2012,0xebf2a00c}},	//   _agua_, _nenos_, _obchodné_, _नीचे__के_, 
   {{0x4f37001e,0x6443e03f,0xb388e011,0xd72e000c}},	//   _ukupno__mijenjan, _awu_, _páxina__outras_, _अउर__सीधा_, 
   {{0x22d8a00b,0x73274009,0x54ba0011,0x2496a009}},	//   _gace_, _at__levere_, _tamén__se_, _nu__kan_, 
   {{0xdbed6003,0x42e3800e,0x325e000b,0x22bb4003}},	//   _སྲི__ཞུ_, _šíření__obsahu_, _ijambo__rishya_, _ཐོ__ཤོག_, 
   {{0x0c7d8006,0x6290e00f,0x325ac011,0x1f1f400f}},	//   _ལྟོའི_, _kunazo_, _acolle_, _isikhath_esithile_, 
   {{0x725ae033,0x83f8a00b,0x00000000,0x00000000}},	//   _rofl_, _yacu_, --, --, 
   {{0x0b9cc020,0x5336400c,0x7bbfe006,0x5a4d800c}},	//   _དུས__རབ_, _से__खाली_, _ལུ__ཡང_, _के__नजर_, 
   {{0x82ccc00b,0xeb98800a,0xa21d0002,0x00000000}},	//   _imvo__imvano_, _तरह__के_, _рату_, --, 
   {{0x3a3de01c,0xe2cfc00e,0x7f072011,0xaa3e201c}},	//   _साथ_, _kancelář, _os__dereitos_, _माँ_, 
   {{0x6922200a,0x00000000,0x00000000,0x00000000}},	//   _न्यूयॉर्_नागपुर_, --, --, --, 
   {{0xb4424004,0x94920019,0xb28d0003,0x8a7be014}},	//   _kum_, _du__deg_, _བཅས__ཀྱི_, _राष्ट्र__संघ_, 
   {{0x5498e00d,0x730f6037,0x52a7e006,0x0be26003}},	//   _ya__no_, _hace__días_, _ཚན__བདག_, _ཀྱི__ནང_, 
   {{0xdcbe6002,0x27c3c00c,0x00000000,0x00000000}},	//   _даље_, _चीन__औद्योगिक_, --, --, 
   {{0xb3f9e004,0x329c0003,0x3b9ca00c,0x00000000}},	//   _mntu_, _མདོ__ཁམས_, _डिमांड__बा_, --, 
   {{0xd249400d,0x82d8c010,0x1c60a00b,0x00000000}},	//   _tiempo_, _lade_, _bivugwa_, --, 
   {{0xe4424025,0x92d9e011,0x00000000,0x00000000}},	// [1d0] _num_, _onte_, --, --, 
   {{0xebf6e014,0xe248800f,0x5be16012,0x63f8a00b}},	//   _हिंदी__के_, _isam_, _navigáci, _wacu_, 
   {{0x62be2022,0x6bd2e003,0xd618c00e,0x00000000}},	//   _चारू_, _ཐོག__ཏུ_, _spolehli, --, 
   {{0x5404801b,0x62902015,0x9388601a,0x026d400a}},	//   _ngenxa__yokuba_, _bilang_, _døydde_, _देहरादून__शिमला_, 
   {{0x0298a006,0xa290e01a,0x0c7e600c,0x00000000}},	//   _འདི__གིས_, _lagar_, _एकरा__बारे_, --, 
   {{0xe1eb200e,0xadc50002,0xd409400b,0x00000000}},	//   _obchodní_, _када__су_, _amagambo_, --, 
   {{0xba3e200a,0xbf240012,0x3eb2e00a,0xe522c002}},	//   _मां_, _vašej_, _खीरी__ललितपुर_, _свима_, 
   {{0xf2d9e015,0x00000000,0x00000000,0x00000000}},	//   _ente_, --, --, --, 
   {{0xd224c040,0x4f3e4028,0x4e1e0002,0x168d2012}},	//   _uvek_, _estrella, _приликом_, _je__komentár_, 
   {{0x8781600c,0x00000000,0x00000000,0x00000000}},	//   _मानल__जाला_, --, --, --, 
   {{0xd369a01d,0x9e40e00b,0x4670e035,0xf27ec027}},	//   _usaha__niaga_, _yarabaye_, _esihlalw, _zmena_, 
   {{0x2290e01a,0xcbcec00c,0x00000000,0x00000000}},	//   _dagar_, _अबहिन__ले_, --, --, 
   {{0x4eb8e002,0x5290e018,0x00000000,0x00000000}},	//   _ли_, _vagas_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xbc68200d,0xc250c00f,0xbb93400a,0x8c4f600a}},	//   _febrero_, _ukwethem, _नाम__पर_, _इनके_, 
   {{0x2200a00e,0x53dfa02f,0xebce2006,0x2a1e4002}},	//   _chci_, _de__dias_, _ཆུང__ཀུ_, _ла__коментар, 
   {{0x82fcc018,0x3ea72002,0x00000000,0x00000000}},	// [1e0] _meninas_, _позивају__на_, --, --, 
   {{0x24424009,0x00000000,0x00000000,0x00000000}},	//   _rum_, --, --, --, 
   {{0xab9aa003,0xfd1fa00b,0x00000000,0x00000000}},	//   _ཟིན__ཐོ_, _bantu__igiteker, --, --, 
   {{0x487d4039,0x33f8c024,0x8f686037,0x74a0601a}},	//   _महाराष्ट, _sadu_, _informac_reportar_, _og__då_, 
   {{0xab8e4021,0x00000000,0x00000000,0x00000000}},	//   _ཆས_, --, --, --, 
   {{0xee426002,0x7a420014,0xe3082011,0x6c00000a}},	//   _је__да_, _के__गठन_, _no__marco_, _साइन__अप_, 
   {{0xf471c00b,0x00000000,0x00000000,0x00000000}},	//   _ikigo__cy_, --, --, --, 
   {{0x32d8c004,0xbb3b6006,0xbf2fc006,0x2ebb4002}},	//   _wade_, _མས__དམིགས_, _ལས__འབྲུག_, _иако__је_, 
   {{0x92f38002,0x00000000,0x00000000,0x00000000}},	//   _годину_, --, --, --, 
   {{0x784b8037,0xb308001d,0x57092002,0xb278200e}},	//   _por__proporci, _terakhir__pada_, _велики_, _stejně__jako_, 
   {{0xae1fe025,0xa65aa002,0xc484000b,0xc327e028}},	//   _após_, _се__пријави_, _hagufi__aho_, _muchas__gracias_, 
   {{0xbccd4028,0x5461c00d,0x3ce5c003,0x00000000}},	//   _un__mensaje_, _aún__no_, _གཞས__འཚོལ_, --, 
   {{0x3284a014,0x00000000,0x00000000,0x00000000}},	//   _करोड़पति_, --, --, --, 
   {{0xee64c002,0x00000000,0x00000000,0x00000000}},	//   _само__да_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x02438029,0xe27a6021,0x00000000,0x00000000}},	// [1f0] _གསོ_, _ལས__སྡེ_, --, --, 
   {{0x0f23602a,0x7b92c003,0x5705800a,0x00000000}},	//   _kan__gjøre_, _ཡིག__དྲ_, _नागपुर__पटना_, --, 
   {{0x79c16018,0x00000000,0x00000000,0x00000000}},	//   _de__atendime, --, --, --, 
   {{0x7dde6002,0xa2af6003,0xebb8400c,0x5eba0002}},	//   _да__му_, _མི__བཙན_, _काइल__के_, _дошли_, 
   {{0x4a35200f,0x34424025,0x33de2002,0x00000000}},	//   _ngakolun_uhlangot, _sul_, _прве_, --, 
   {{0x430da009,0x14a2600e,0x30c80002,0x00000000}},	//   _opgaver_, _nabídce_, _за__развој_, --, 
   {{0x3994c012,0x635be00b,0xe7b8800b,0x9be9e00c}},	//   _môžu_, _sangira_, _repubuli, _जानेला__कि_, 
   {{0x32ffc033,0x641b4006,0x3d12800f,0x8295e01c}},	//   _sakrij__citiraj_, _ལུ__རྒྱལ_, _izilwane_, _स्टोरी_, 
   {{0x32912031,0xc3804009,0xab9b4003,0x00000000}},	//   _layar_, _udtryk_, _ཡིན__དེ_, --, 
   {{0x827e003f,0x22430003,0x0201e00b,0x1950a00a}},	//   _imini_, _མཆན_, _giti_, _परिवर्तन__समाज_, 
   {{0x9b934003,0xda73800c,0x00000000,0x00000000}},	//   _ཡིག__མི_, _अउर__फेर_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x3e72e002,0x7658c00f,0x00000000,0x00000000}},	//   _ме_, _izikroni, --, --, 
   {{0x827fe016,0x6ed50002,0x00000000,0x00000000}},	//   _ble__medlem_, _рок_, --, --, 
   {{0xbc800002,0x00000000,0x00000000,0x00000000}},	//   _месец_, --, --, --, 
   {{0x7c206037,0x22c3e002,0x00000000,0x00000000}},	//   _quedan__caracter, _користи_, --, --, 
   {{0x304fc00e,0x00000000,0x00000000,0x00000000}},	// [200] _šíření_, --, --, --, 
   {{0x1d9de003,0xc27e802b,0x7bd3a006,0x00000000}},	//   _ཟིན__བྲིས_, _imana_, _འཐབ__ནི_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa70f2014,0xc201e01f,0x1deb4018,0x00000000}},	//   _मनाया__जाता_, _siti_, _municípi, --, 
   {{0x52de6041,0xcfa18016,0xb4b14018,0x62f6c00a}},	//   _खाली_, _innenfor_, _descriçã, _है__गाली_, 
   {{0x8ee8200b,0x6683400a,0x1e612002,0x00000000}},	//   _adakoran, _मज़ाक_, _по__насељима_, --, 
   {{0x48d30002,0x14732009,0x00000000,0x00000000}},	//   _је__последњи_, _handelsp_med_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x12d8e009,0x2442600d,0x230c402c,0x850d0012}},	//   _dage_, _aun_, _impamvu_, _prístroj, 
   {{0x4498a002,0x00000000,0x00000000,0x00000000}},	//   _moć__re_, --, --, --, 
   {{0x44426011,0xf2b8a011,0x00000000,0x00000000}},	//   _cun_, _de__muros_, --, --, 
   {{0xb05e2012,0x5840800a,0x00000000,0x00000000}},	//   _sú__vyhraden, _से__जानकारी_, --, --, 
   {{0xe496e00e,0xd387400e,0xc37e2011,0x2bcd0003}},	//   _se__na_, _kterou_, _de__imaxes_, _གངས__ལྷ_, 
   {{0x82b8a011,0x133a0030,0x9381c002,0x92c7e018}},	//   _inc__unha_, _opće__diskusij, _українсь_прегледа, _há__comentár, 
   {{0x7eec4012,0x00000000,0x00000000,0x00000000}},	//   _iných_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xef9a600d,0xe291a031,0x6d490002,0x00000000}},	// [210] _las__palabras_, _bapak_, _врх_, --, 
   {{0x7355c02a,0x00000000,0x00000000,0x00000000}},	//   _nyheter_, --, --, --, 
   {{0x631b6033,0x24444015,0x326c400f,0xb830c003}},	//   _crna__kronika_, _gw_, _nokuphil, _གླིང__དབྱིན_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x0291a01f,0x4442801d,0x00000000,0x00000000}},	//   _tapak_, _jua_, --, --, 
   {{0xe4616009,0x9ba68003,0xebb7e00c,0x00000000}},	//   _tilbage__til_, _བྲིས__ངས_, _इनका__के_, --, 
   {{0xa316400e,0x00000000,0x00000000,0x00000000}},	//   _nelze_, --, --, --, 
   {{0x86d0001b,0x9496e00b,0xe279a006,0x00000000}},	//   _aphakami, _ku__ya_, _དེ__ཅིག_, --, 
   {{0x5053c002,0x0a218019,0x02898003,0x00000000}},	//   _године_, _forbruke, _རིག__གནས_, --, 
   {{0xd24a2006,0xd290c00f,0x088cc002,0x1a8aa012}},	//   _འགྲུལ__བསྐྱོདཔ_, _kulabo_, _већ__означен_, _upozorne, 
   {{0xb0458012,0x42d9002c,0x12d8e009,0x7331e012}},	//   _vyhraden, _maze_, _tage_, _medzinár, 
   {{0xd444402b,0x1c26e00e,0x5476400b,0xba70a00f}},	//   _rw_, _prostě_, _cane__ku_, _kungani__kubalule, 
   {{0x1248c00e,0xade1e002,0x00000000,0x00000000}},	//   _jsem_, _ко__су_, --, --, 
   {{0x6f206031,0x3460601a,0x7423200f,0x00000000}},	//   _mendukun, _døme__på_, _nje__kokuba_, --, 
   {{0x8fd8000f,0xa37a201f,0x04784039,0x34faa00c}},	//   _ezingoko, _paparan_, _hari__jam_, _करदाता_, 
   {{0x7cb96018,0x16aa8003,0x00000000,0x00000000}},	//   _de__energia_, _དང__སློབ_, --, --, 
   {{0xfb9f400c,0x00000000,0x00000000,0x00000000}},	// [220] _के__तऽ_, --, --, --, 
   {{0xf444400b,0x047bc042,0x2a3e200a,0x5df52012}},	//   _tw_, _noen__som_, _माह_, _pridajte_, 
   {{0x63fb6026,0x00000000,0x00000000,0x00000000}},	//   _den__danske_, --, --, --, 
   {{0x44992025,0x33462034,0x00000000,0x00000000}},	//   _um__dos_, _valdres_, --, --, 
   {{0xec07e014,0xaf36c002,0x00000000,0x00000000}},	//   _विस्फोट__के_, _на__то_, --, --, 
   {{0xeba58003,0xe1c2000a,0xad50a00a,0x2eddc002}},	//   _སྟེང__གི_, _पर्यटन__स्थल_, _पिथौरागढ, _нас__је_, 
   {{0xf051c002,0x12b48012,0x00000000,0x00000000}},	//   _услови_, _sekcii_, --, --, 
   {{0x03f7200b,0x9862400b,0x7bee0003,0x7d324003}},	//   _yar__akiri_, _bisobanu, _མང__དུ_, _འཕེལ__རྒྱས_, 
   {{0xfe3be011,0x7e51e01d,0x13dc000b,0xc134e003}},	//   _xuño_, _dipapar__mengguna, _ariwe_, _བར__འཁྱམས_, 
   {{0x32ca6011,0x6442a004,0xc4428025,0xf322c00b}},	//   _cando_, _kub_, _rua_, _gukora__paje_, 
   {{0xd4428025,0xebd3200a,0xb2fd800f,0x00000000}},	//   _sua_, _बलिए__के_, _menu__dlulela_, --, 
   {{0xb4420015,0xf257c009,0x54a0a012,0x631f200b}},	//   _sih_, _vælge_, _sa__dá_, _mu__bikorwa_, 
   {{0xee888002,0x00000000,0x00000000,0x00000000}},	//   _мислим__да_, --, --, --, 
   {{0xebbe2014,0xd1f0a006,0x5ceec002,0x7470200f}},	//   _युद्ध__के_, _བསྐྱོདཔ_, _града_, _esikhath_esizayo_, 
   {{0x6c77a015,0x4a05e018,0x12900025,0x00000000}},	//   _tulisan__tentang_, _embalage, _achar_, --, 
   {{0x7386801a,0xebf8c00c,0xd52f800a,0x428c8002}},	//   _kvart_, _गुरू__के_, _मैनपुरी__मेरठ_, _од__тога_, 
   {{0x4231601f,0xc257c009,0x2158200c,0x00000000}},	// [230] _bermula_, _sælge_, _एगो__गांव_, --, 
   {{0x9c9b4018,0x3c64a00e,0xc824200a,0x00000000}},	//   _suas__compras_, _situace_, _अगलीस्टो, --, 
   {{0xf2d92004,0xf4422009,0xe4836002,0xecab4011}},	//   _yaye_, _fik_, _vest__na_, _da__coruña_, 
   {{0xe3f46024,0x04422009,0x92a68003,0x00000000}},	//   _ujutru_, _gik_, _སེར__སྨད_, --, 
   {{0x6a3c4043,0xc4ac000b,0x00000000,0x00000000}},	//   _आता_, _bwite__aho_, --, --, 
   {{0xea474002,0x713dc002,0xac30c002,0x00000000}},	//   _ситуациј, _изборе_, _испред_, --, 
   {{0xe464400f,0x0964400e,0x72de6014,0x32cea00a}},	//   _kungakha_ukuthi_, _fotogale, _खाती_, _जमशेदपुर__जयपुर_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xd2b04037,0x137a601d,0x3213800f,0x00000000}},	//   _opinión__otras_, _rawatan_, _lisho_, --, 
   {{0x54342002,0x00000000,0x00000000,0x00000000}},	//   _očistite__dezinfik, --, --, --, 
   {{0x326cc004,0x00000000,0x00000000,0x00000000}},	//   _kaloku_, --, --, --, 
   {{0xec0c000c,0x00000000,0x00000000,0x00000000}},	//   _अधिकारन__के_, --, --, --, 
   {{0x537a6031,0x00000000,0x00000000,0x00000000}},	//   _wawasan_, --, --, --, 
   {{0x72e9000b,0x00000000,0x00000000,0x00000000}},	//   _itsinda_, --, --, --, 
   {{0xf753600f,0xec04000a,0x00000000,0x00000000}},	//   _nganging, _जानने__के_, --, --, 
   {{0xd6ffc00a,0x00000000,0x00000000,0x00000000}},	//   _इसका_, --, --, --, 
   {{0xa2588006,0xe2abe00e,0x00000000,0x00000000}},	// [240] _དམིགས__དོན_, _užití_, --, --, 
   {{0xb401a00d,0x00000000,0x00000000,0x00000000}},	//   _con__más_, --, --, --, 
   {{0x13000011,0xefed601a,0x42ea200f,0xbc26c00c}},	//   _citar__esta_, _brukarar_, _ngenxa__yalokhu_, _खातिर__लगातार_, 
   {{0x7419e028,0x4f55a037,0xc24e4020,0x9301200b}},	//   _de__nuevo_, _estás__comentan, _ཡཱན_, _iki__gihe_, 
   {{0xc3958018,0xc2070018,0xf625a01a,0x13e9c00b}},	//   _nossa_, _código__abaixo_, _vidaregå, _patiri__hamwe_, 
   {{0xf22a2002,0x32014018,0x00000000,0x00000000}},	//   _кога_, _aceita_, --, --, 
   {{0x5215a00e,0xa49ec018,0x00000000,0x00000000}},	//   _oddělení_, _você__vai_, --, --, 
   {{0xef1f0002,0x00000000,0x00000000,0x00000000}},	//   _кориснич_име_, --, --, --, 
   {{0x44824038,0x2c07400c,0x6e6ce002,0x00000000}},	//   _novo__da_, _तौर__पऽ_, _директор_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6bcf4013,0xdc54c00f,0x00000000,0x00000000}},	//   _श्रीनगर_, _amaqinis, --, --, 
   {{0xf87cc002,0x00000000,0x00000000,0x00000000}},	//   _поставље, --, --, --, 
   {{0x74424018,0xbcbce00f,0x24906005,0xba99e017}},	//   _mim_, _bakajesu_, _eg__og_, _náhradní_, 
   {{0x82918031,0x8492a02a,0x02a40003,0x00000000}},	//   _barat_, _er__mer_, _འདོད__ཡོད_, --, 
   {{0x64758018,0x00000000,0x00000000,0x00000000}},	//   _economia__de_, --, --, --, 
   {{0x83088015,0x5e420038,0x3df2a012,0x00000000}},	//   _jawa__barat_, _dinamiza, _aj__keď_, --, 
   {{0xe4972015,0x0cda4006,0x00000000,0x00000000}},	// [250] _ya__gan_, _པར__བླམའི_, --, --, 
   {{0x92984003,0xb4b4a00f,0x00000000,0x00000000}},	//   _ཀྱི__དུས_, _nokho__uma_, --, --, 
   {{0xf3bec01a,0x00000000,0x00000000,0x00000000}},	//   _historie__endre_, --, --, --, 
   {{0x23478018,0x5fa78018,0xb2c0200b,0x00000000}},	//   _começa_, _começar_, _ku__biro_, --, 
   {{0x0213800f,0x74b52037,0xa2da6018,0x58ba200b}},	//   _cishe_, _respalda_si_, _desejo_, _mu__majyarug, 
   {{0xf492a010,0x2c67c004,0x00000000,0x00000000}},	//   _er__der_, _malunga_, --, --, 
   {{0xe0bbc00e,0x04424025,0xbd0b000a,0x00000000}},	//   _hvězdičk, _fim_, _गया__श्रेणिया, --, 
   {{0x73384009,0x537a601d,0x6bab800a,0x00000000}},	//   _tilmeldi_indlæg_, _jawapan_, _कि__वह_, --, 
   {{0x6cb3800d,0x924d8003,0xa276c00a,0x00000000}},	//   _de__ingreso_, _སྨད_, _या__कॉमेंट_, --, 
   {{0x82710039,0x7e078002,0xc29a6018,0xb2c0a00b}},	//   _mulai__dari_, _великим__словима_, _tem__como_, _mu__rugo_, 
   {{0xa2de801c,0x72248007,0x00000000,0x00000000}},	//   _जाती_, _awak_, --, --, 
   {{0x1ea0200f,0x74138016,0x147b2002,0x00000000}},	//   _umoya__ongcwele_, _fra__nett_, _забрањен_лажно_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x17c0c002,0x42d2200f,0xc29a4018,0x7bd8c003}},	//   _poruke__reputaci, _empeleni_, _para__não_, _མིན__དྲ_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xc3930011,0x6c11a018,0x00000000,0x00000000}},	// [260] _nova__acceder_, _comprei_, --, --, 
   {{0xd4424025,0xf031800e,0x195a400f,0xa2c1c011}},	//   _sim_, _předchoz, _ezindawe, _coa__súa_, 
   {{0x3b80a00a,0x0be2e003,0x00000000,0x00000000}},	//   _खोज__परिणाम_, _གྱི__ནང_, --, --, 
   {{0x46c4400a,0x60a7c002,0x00000000,0x00000000}},	//   _बलिया__बस्ती_, _животне_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xd290400e,0xc2c12006,0xbc57e00c,0x8a61c00a}},	//   _byla_, _བསྐྲུན__འབད_, _के__साथे_, _या__फिर_, 
   {{0x9e438018,0x43960018,0x71c6400e,0x3d63800a}},	//   _atualiza, _nossos_, _dovolená_, _में__अस्वीकरण_, 
   {{0x2442c00d,0x2ebbc002,0xb2d1600d,0x00000000}},	//   _fue_, _како__је_, _no__tiene_, --, 
   {{0x2ec86002,0x3442c015,0x1c69c012,0x00000000}},	//   _то__је_, _gue_, _ktorým_, --, 
   {{0x5473600e,0xf9d02002,0x00000000,0x00000000}},	//   _zde__se_, _желим_, --, --, 
   {{0x7b6f4003,0x00000000,0x00000000,0x00000000}},	//   _ཀུན__གླེང_, --, --, --, 
   {{0xaf1be00e,0x7d92c00c,0x00000000,0x00000000}},	//   _stát_, _एजेंसी__एनआईए_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x94300002,0x00000000,0x00000000,0x00000000}},	//   _poslednj_poruka_, --, --, --, 
   {{0x72fe6019,0x1201a012,0x42bac00e,0x00000000}},	//   _norges_, _neviem_, _těch_, --, 
   {{0x54992040,0x03ea0009,0xc00e200e,0x01df000c}},	//   _pridruži_se_, _frit_, _dál__ještě_, _कृष्णदेव__उपाध्याय_, 
   {{0x84426004,0x8329e01a,0x4f2cc00f,0x00000000}},	// [270] _mio_, _på__talet_, _umthetho__kankulun, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xd2ca600b,0x00000000,0x00000000,0x00000000}},	//   _kanda_, --, --, --, 
   {{0xb1bea00a,0x82c1200a,0x00000000,0x00000000}},	//   _टाइल_, _देख__सकेंगे_, --, --, 
   {{0xbccca00a,0x9454201a,0x846e0018,0x00000000}},	//   _लिए__अपने_, _har__vorte_, _adiciona_dia_, --, 
   {{0xe302200b,0x00000000,0x00000000,0x00000000}},	//   _catholik_yabaye_, --, --, --, 
   {{0x2e2a0002,0x3681c022,0x74af8002,0x00000000}},	//   _национал, _कुणाल_, _специјал, --, 
   {{0x22b24003,0x98c5400a,0x00000000,0x00000000}},	//   _རང__ལུས_, _जौनपुर_, --, --, 
   {{0xa35e0024,0x92fd4028,0xa25b2003,0x00000000}},	//   _beograd_, _juegos_, _འགྱུར__བོད_, --, 
   {{0x4a41e014,0xfac1000c,0x00000000,0x00000000}},	//   _के__गीत_, _चाहत__रहन_, --, --, 
   {{0x5092a014,0x14426018,0x00000000,0x00000000}},	//   _शिवराज__सिंह_, _fio_, --, --, 
   {{0x2e72e002,0x00000000,0x00000000,0x00000000}},	//   _је_, --, --, --, 
   {{0x2e56e002,0xed182009,0x1a6ba019,0x3dbda018}},	//   _из_, _længere_, _oppmerks, _cadastre_, 
   {{0x72bac00e,0x3cbbc01a,0xd989e00b,0x00000000}},	//   _věci_, _spørsmål__skattar_, _mu__ntambara_, --, 
   {{0x640ea002,0x8b62200c,0x00000000,0x00000000}},	//   _арапски__белоруск, _कएलनि_, --, --, 
   {{0x62924019,0x00000000,0x00000000,0x00000000}},	//   _omtale_, --, --, --, 
   {{0x8395c009,0x00000000,0x00000000,0x00000000}},	// [280] _hovsa_, --, --, --, 
   {{0x42d98012,0x0a8ec00a,0x624b800f,0x32d14003}},	//   _okrem_, _हाल__में_, _mathewu__marku_, _རིགས__སྙན_, 
   {{0x8b64400e,0xb265c003,0xe10a200e,0x5f41c00b}},	//   _oblečení_, _ཕྱོགས__ཀྱི_, _osvětlen, _amarusha, 
   {{0xbbc7a00c,0x3baba00c,0xe2d9c00f,0xbc94200c}},	//   _कइल__जा_, _कि__एह_, _kwadinge_ukuba_, _काम__कइले_, 
   {{0xd4426025,0x49bf4009,0x00000000,0x00000000}},	//   _rio_, _efter__personer_, --, --, 
   {{0x94426011,0xebc86014,0x00000000,0x00000000}},	//   _nin_, _संस्थान__के_, --, --, 
   {{0x52590003,0xe418000f,0x00000000,0x00000000}},	//   _རྒྱ__མཚོ_, _ngiyazi__ukuthi_, --, --, 
   {{0xd492e004,0xde736002,0x00000000,0x00000000}},	//   _ke__ke_, _већ_, --, --, 
   {{0xe2d9800b,0x8f60000c,0x00000000,0x00000000}},	//   _kare_, _में__आतंकी_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xe492e03f,0xb727e011,0x05654004,0x526da015}},	//   _ke__le_, _está__dispoñib, _projekth, _depok_, 
   {{0x0442601a,0xd28b0016,0x72438003,0xa3d7000b}},	//   _ein_, _profil__finn_, _གསན_, _by__ukuri_, 
   {{0x46ff4022,0x00000000,0x00000000,0x00000000}},	//   _जामा_, --, --, --, 
   {{0x04e0800a,0x5f0e6003,0x00000000,0x00000000}},	//   _आजमगढ़__प्रतापगढ, _དཔར__སྐྲུན_, --, --, 
   {{0x52bac00e,0x93eae013,0x02ca801d,0x00000000}},	//   _něco_, _राजस्थान_, _ini__diubah_, --, 
   {{0x83958018,0x00000000,0x00000000,0x00000000}},	//   _fosse_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [290] --, --, --, --, 
   {{0x729da006,0x00000000,0x00000000,0x00000000}},	//   _འོས__གསལ_, --, --, --, 
   {{0x943a2012,0xf2796003,0x00000000,0x00000000}},	//   _obchodné__podmienk, _དེ__ཉིད_, --, --, 
   {{0x1585000e,0x247f800b,0x00000000,0x00000000}},	//   _nemůžete_, _muri__iki_, --, --, 
   {{0x5443e01a,0xeae82022,0x00000000,0x00000000}},	//   _att_, _आश्वासन_, --, --, 
   {{0x1efc600e,0x74ad801a,0x37952002,0x56152002}},	//   _prázdný_, _samla__inn_, _русија_, _русији_, 
   {{0x17a6a00e,0x00000000,0x00000000,0x00000000}},	//   _obchod__podmínky_, --, --, --, 
   {{0x69fd202f,0xa3348007,0x81b5c002,0xfc6e000f}},	//   _pagament, _profesio_yang_, _чланак_, _umariya_, 
   {{0x9443e016,0xf4988011,0x00000000,0x00000000}},	//   _ett_, _un__ano_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xddbf800a,0xa4df600e,0x00000000,0x00000000}},	//   _आगरा__आजमगढ़_, _download_předpokl, --, --, 
   {{0xc48ea011,0x00000000,0x00000000,0x00000000}},	//   _de__ás_, --, --, --, 
   {{0xd473e004,0xf396601a,0x54b62018,0xf26c4035}},	//   _nto__ke_, _fyrste_, _cadastre__se_, _zokuphil, 
   {{0xa3946004,0xe26c4032,0x068d400a,0x8477a011}},	//   _miose_, _yokuphil, _बदलाव_, _comentar_os_, 
   {{0x84778039,0xf327a00a,0x5979200e,0x3bb3e00a}},	//   _tersedia__di_, _करियर__आईटी_, _století_, _हैं__यह_, 
   {{0x84bf202a,0x00000000,0x00000000,0x00000000}},	//   _litt__mer_, --, --, --, 
   {{0xd2bc801d,0xc29d6003,0x00000000,0x00000000}},	// [2a0] _ini__kerana_, _འཕྲིན__གྱི_, --, --, 
   {{0x8612800e,0x44c42011,0x3a0ec002,0x00000000}},	//   _příspěvk, _rexistra_da_, _првом_, --, 
   {{0xf46e8009,0xc4a8800e,0x00000000,0x00000000}},	//   _frederik, _když__je_, --, --, 
   {{0x4499a011,0x0ba2c00a,0xf9a3200f,0xa2a8400e}},	//   _un__dos_, _रहा__था_, _eziyishu, _seřadit__podle_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x3443200d,0x8cbfe01e,0x58684003,0x24608011}},	//   _muy_, _mjesec__mjeseca_, _ཞུན__སྤྱི_, _notas__editar_, 
   {{0x5a3e0044,0xcbd6e003,0x86f2400a,0xd9c8e003}},	//   _मगर_, _ཆེན__པོ_, _धर्म__संसार_, _ཆེའི_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x4b0c601a,0x00000000,0x00000000,0x00000000}},	//   _personle, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa290e012,0xae322011,0x393ce00a,0x15d6800b}},	//   _priamo_, _millóns_, _दिल्ली__न्यूयॉर्, _abibumby, 
   {{0x64f1601d,0xbcb42003,0x00000000,0x00000000}},	//   _teks__disediak, _སྒོར__འཛུལ_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xe29c8011,0x4c69802c,0x00000000,0x00000000}},	//   _dúas_, _impunzi_, --, --, 
   {{0xd312000d,0x5f2ce002,0x00000000,0x00000000}},	//   _hombres_, _чланке__преко_, --, --, 
   {{0xefd7000e,0x0aaa6013,0xc491c012,0xe60a2003}},	//   _protože_, _समाचार__देश_, _ktorý__je_, _སྤྲད_, 
   {{0xdda4600e,0x00000000,0x00000000,0x00000000}},	// [2b0] _reagovat_, --, --, --, 
   {{0xcdcec014,0x477a200c,0x00000000,0x00000000}},	//   _कमाए_, _से__जुड़ल_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xf2d9002a,0x3eaaa002,0x4b9bc003,0x00000000}},	//   _mer__info_, _кликните__на_, _དེབ__ངོ_, --, 
   {{0xd249e018,0xdbd8a00a,0x00000000,0x00000000}},	//   _éum_, _लगा__रखे_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xe4732009,0xdc8e000c,0xc379a00b,0x00000000}},	//   _accepter_du_, _चेरो_, _muhango_, --, 
   {{0xb242c00a,0x5292601d,0xe29c8011,0x00000000}},	//   _पिछले_, _korang_, _túas_, --, 
   {{0x62fce016,0xc3966011,0x54a8800e,0x1deb0012}},	//   _ganger_, _cousas_, _když__se_, _obľúbený, 
   {{0xcf1b8006,0x9de7800a,0x7287e00e,0x00000000}},	//   _བརྡ__འཕྲུལ_, _फर्रूखाब_फीरोजाबा, _na__něj_, --, 
   {{0xba33000c,0x324c600c,0x82500002,0x00000000}},	//   _चलल_, _बसवलन_, _цена_, --, 
   {{0x3442a03d,0x1fd36011,0x00000000,0x00000000}},	//   _nic_, _relación, --, --, 
   {{0xf28ca037,0x00000000,0x00000000,0x00000000}},	//   _lugar__real_, --, --, --, 
   {{0x2300a007,0x584ba002,0xe41f000f,0x427a800f}},	//   _linkedin__anda_, _се__налазе_, _nje__ukuthi_, _noma__nini_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xc292601d,0x00000000,0x00000000,0x00000000}},	//   _borang_, --, --, --, 
   {{0x9442a037,0x00000000,0x00000000,0x00000000}},	// [2c0] _dic_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xd29c8011,0x00000000,0x00000000,0x00000000}},	//   _súas_, --, --, --, 
   {{0x3395800b,0xc442a015,0x72e10011,0x0bde0003}},	//   _morsi_, _wib_, _xix__digo_, _རིམ__ནང_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x63dca00b,0x02e7600f,0x00000000,0x00000000}},	//   _nubwo_, _ukuba__umuntu_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xf27a800f,0xe490e045,0x00000000,0x00000000}},	//   _noma__yini_, _cm__kg_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xcca96014,0x6f4f800f,0x8b21e00f,0x93fd400b}},	//   _तक__पहुंच_, _kwesikha, _imiphume, _garuka__hejuru_, 
   {{0x5306c033,0x0316a00f,0xfe0d2002,0x70198012}},	//   _milijuna__kuna_, _kuze__kube_, _ове_, _podmienk_používan, 
   {{0x9ba8c021,0xbc5b800a,0x00000000,0x00000000}},	//   _ནང__ལས_, _का__इंटरेस्ट_, --, --, 
   {{0x1bdee003,0x2b9d200a,0xb9998012,0x00000000}},	//   _བརྟེན__ནས_, _की__थी_, _dosť_, --, 
   {{0xd2c8800b,0x00000000,0x00000000,0x00000000}},	//   _siporo__umuco_, --, --, --, 
   {{0xd2d9c009,0xa493201a,0x10d4c037,0x00000000}},	//   _have_, _og__dei_, _inténtel, --, 
   {{0xe292400f,0x7fa24009,0xa23e4003,0x00000000}},	// [2d0] _altare_, _indenfor_, _གཟིགས__རྩོམ_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xe469601a,0x552de00f,0x00000000,0x00000000}},	//   _dei__er_, _kwangath, --, --, 
   {{0x12d9c026,0x52cae009,0x6496a012,0x00000000}},	//   _lave_, _sagde_, _prípade__že_, --, 
   {{0x927b6003,0xcca66002,0x00000000,0x00000000}},	//   _དོ__སྣང_, _постати__везе_, --, --, 
   {{0xfc98c002,0x00000000,0x00000000,0x00000000}},	//   _правопис_правила_, --, --, --, 
   {{0x6d22c00a,0x00000000,0x00000000,0x00000000}},	//   _जनवरी__दिसम्बर_, --, --, --, 
   {{0xc4b52005,0x00000000,0x00000000,0x00000000}},	//   _index__php_, --, --, --, 
   {{0x5e39601d,0xa48da01a,0xee94400a,0x00000000}},	//   _pelabura, _då__dei_, _इस__फिल्म_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x16d04003,0x0394e02c,0x1379a00b,0xabe1c003}},	//   _བཀའ__སློབ_, _menshi_, _ruhango_, _ཚུལ__དེ_, 
   {{0xeac6801a,0x3c13000c,0x00000000,0x00000000}},	//   _ansvarle, _जाला__एह_, --, --, 
   {{0x5068e024,0xec898002,0x00000000,0x00000000}},	//   _ne__preporuč, _на__пример_, --, --, 
   {{0xa3174024,0xa2a04012,0x5752c00f,0x62934003}},	//   _zvezda_, _futbal_, _izinding, _མཆོད__དཔལ_, 
   {{0x29dbc021,0x820e6002,0x998e6002,0xc08cc002}},	//   _འཐུས__མིའི_, _наша_, _наши_, _славе_, 
   {{0x4442c012,0xe2c4800e,0x3180a017,0xe3958018}},	//   _nie_, _jméno__heslo_, _úvodní__stránka_, _possa_, 
   {{0x027ba021,0x6491c011,0x731e000b,0x00000000}},	// [2e0] _དེ__ཡོད_, _venres__de_, _agaciro_, --, 
   {{0x11752014,0xf323e00b,0xbdb30009,0x4496400b}},	//   _अल्पसंख्, _software__cyangwa_, _udlandet_, _wa__bbc_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x92f5a00f,0x12b9000f,0x2bce0003,0x00000000}},	//   _le__ndaba_, _kepha__mina_, _གྱད__ལྷ_, --, 
   {{0xcc6a400e,0xcc27c00f,0x00000000,0x00000000}},	//   _kterým_, _ngaphand_kwalokho_, --, --, 
   {{0x72de800f,0xd0d32002,0xca5b000c,0x83286002}},	//   _izingane__zabo_, _власт_, _कि__भोज_, _одговор__одустани_, 
   {{0x127c200e,0x526c802c,0x44444039,0x7ea16002}},	//   _méně_, _gukora_, _jt_, _такмичи__се_, 
   {{0xf27f000b,0x9298c003,0x00000000,0x00000000}},	//   _ahantu_, _གྱི__དུས_, --, --, 
   {{0x485f6018,0x00000000,0x00000000,0x00000000}},	//   _estrelas_, --, --, --, 
   {{0x1249e02c,0x64a92011,0x00000000,0x00000000}},	//   _nyuma_, _despois__de_, --, --, 
   {{0xd4bf4004,0x045d200f,0xafd4e012,0x00000000}},	//   _noko__ke_, _ngalolo__suku_, _sprístup, --, 
   {{0x9278600e,0x92994003,0x22bc0018,0x3458e01a}},	//   _první_, _བའི__དུས_, _somente__para_, _frå__eit_, 
   {{0x368ce014,0xe456e009,0x7b9e2003,0xda33000c}},	//   _मीनार_, _postnr__by_, _ཡིན__ཡང_, _चलत_, 
   {{0x5d492002,0xcc4e400c,0x00000000,0x00000000}},	//   _при_, _गइले_, --, --, 
   {{0xe2d9c00b,0xcaa24012,0x60b0e012,0x4722400c}},	//   _yawe_, _sa__musíte_, _príležit, _जुड़ल_, 
   {{0xaacf8020,0x646ac037,0xfca08018,0x321ea00c}},	//   _ཕྱུག_, _recetas__de_, _amigo__recusar_, _के__गुंजाइश_, 
   {{0x75b7e00b,0x00000000,0x00000000,0x00000000}},	// [2f0] _barapfuy, --, --, --, 
   {{0xeb546038,0x5cee2002,0xe2e44011,0x00000000}},	//   _de__composte, _пред_, _lingua__galega_, --, 
   {{0x28c5600a,0xd99b200c,0x00000000,0x00000000}},	//   _जबलपुर_, _बा__सांच_, --, --, 
   {{0x3093400f,0xe291000b,0x00000000,0x00000000}},	//   _ofakazi__bakajeho, _kubaho_, --, --, 
   {{0x62d9e00b,0xc442c027,0x00000000,0x00000000}},	//   _bate_, _vie_, --, --, 
   {{0xc26b6003,0x22d34003,0x7c4fe00c,0x1be86003}},	//   _རྩོམ__ཡིག_, _དེང__རབས_, _एहसे_, _གང__ནས_, 
   {{0xa442c027,0x0fab600e,0x00000000,0x00000000}},	//   _tie_, _října_, --, --, 
   {{0x424e403a,0x9af52039,0xdd910006,0xc757200c}},	//   _ལྟར_, _laporkan_, _ཚུགསཔ_, _से__जादा_, 
   {{0x86ff400c,0xb5a1a035,0xee610002,0x546a200f}},	//   _जाला_, _esifanay, _иди_, _injabulo__enkulu_, 
   {{0x2eecc002,0x1329800f,0xc2d9c00b,0xfbade00c}},	//   _ово__је_, _engu__ubudala_, _wawe_, _हैसियत__से_, 
   {{0x6a8a8002,0xa3958018,0xa018800e,0xabdc4003}},	//   _август_, _nosso_, _přísluše, _རེད__དེ_, 
   {{0xd3e76037,0x00000000,0x00000000,0x00000000}},	//   _no__uses_, --, --, --, 
   {{0xf2fcc028,0x8745a00c,0x39ca4002,0x00000000}},	//   _juego_, _कहल__जाला_, _техно__почетна_, --, 
   {{0xb9ffc011,0x2200a00e,0xe45b000b,0x6297e003}},	//   _véxase__tamén_, _akci_, _impunzi__abarundi_, _འདྲི__གསར_, 
   {{0x2190a00b,0x12fcc028,0x00000000,0x00000000}},	//   _css__ntushobo, _luego_, --, --, 
   {{0x5b428006,0x00000000,0x00000000,0x00000000}},	//   _ལིཤ__རྫོང_, --, --, --, 
   {{0x4442e009,0x6464c018,0x00000000,0x00000000}},	// [300] _mig_, _são__de_, --, --, 
   {{0x7355c009,0xbc4e600c,0xa24e0003,0x00000000}},	//   _nyheder_, _कइले_, _གཞུང__བོད_, --, 
   {{0xd1f78002,0xd7536002,0x7c98800c,0x6c58800c}},	//   _ова__страница_, _други__језици_, _के__बादो_, _के__बादे_, 
   {{0x8c38000f,0x00000000,0x00000000,0x00000000}},	//   _kwezinye__izindawo_, --, --, --, 
   {{0x7bcbc00a,0x9474400b,0x3dc5e00a,0xc09a800c}},	//   _भारत__ने_, _abenyeco_bo_, _सीतापुर__सोनभद्र_, _मगही__उदास_, 
   {{0x64b7e038,0x00000000,0x00000000,0x00000000}},	//   _santiago__de_, --, --, --, 
   {{0x674ec002,0x00000000,0x00000000,0x00000000}},	//   _цркве_, --, --, --, 
   {{0xd4936004,0xa442e011,0x0eb7200a,0xa526000a}},	//   _es__ke_, _cig_, _दीपक__भारतदीप_, _बिज़नस_, 
   {{0xb442e009,0x7e518024,0xcb3e0003,0xd47fe00b}},	//   _dig_, _je__uključen_, _པོ__མཆོག_, _muri__ako_, 
   {{0xe443801e,0xefe10002,0x7ab8000e,0xd497e012}},	//   _kur_, _свој_, _odpověď_, _si__ma_, 
   {{0xe4936004,0x7ed4e002,0x772fa011,0x9e28a025}},	//   _na__le_, _им__се_, _da__asociaci, _válidos_, 
   {{0x0443800b,0x326fa00f,0xc26b6029,0x86fe000a}},	//   _mur_, _abaningi_, _རྩོམ__རིག_, _खेल__संसार_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x22cbc009,0xe2dc002e,0x221d2002,0xebb0a00a}},	//   _havde_, _dalmacij, _датум_, _लोगों__के_, 
   {{0xaccfa003,0x00000000,0x00000000,0x00000000}},	//   _མདོར_, --, --, --, 
   {{0x1767400a,0x00000000,0x00000000,0x00000000}},	//   _आपत्तिजन_शब्द_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [310] --, --, --, --, 
   {{0x54438005,0xba34e012,0x504da00a,0x00000000}},	//   _bur_, _používan_kontaktu, _पीलीभीत__फैजाबाद_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa4be201e,0x9291400f,0x3bf5a006,0xcb7d200e}},	//   _programe__za_, _angase_, _སྤ__རོ_, _finanční_, 
   {{0x84438045,0xccb4600a,0x00000000,0x00000000}},	//   _eur_, _इतिहास__देखें_, --, --, 
   {{0xa442e009,0xd28a4002,0x73db2018,0x54bb4025}},	//   _sig_, _навигаци_претрага_, _membro__gravar_, _aqui__no_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xb313400e,0x139a001a,0xebbf800c,0x00000000}},	//   _než__více_, _høyrer_, _गीत__के_, --, 
   {{0xebc14014,0x8c3c0027,0x00000000,0x00000000}},	//   _क्रांति__के_, _ceny__dopravy_, --, --, 
   {{0xf51e400f,0x2eefe002,0xd291400f,0xf33de00e}},	//   _inhliziy, _текст__је_, _ungase_, _údajů_, 
   {{0x086e600d,0x0333a009,0x00000000,0x00000000}},	//   _nuestros_, _kan__finde_, --, --, 
   {{0x9fd78012,0xeba5a003,0xb2bd2015,0xa245e006}},	//   _pretože_, _འགྱུར__ཟླ_, _topik__utama_, _སྐྲུན__རྩོམ_, 
   {{0x0397c009,0x82a70002,0x6ed4e002,0x00000000}},	//   _medarbej, _народа_, _но_, --, 
   {{0xc474602e,0xbf0e0006,0x6413a00c,0x00000000}},	//   _tko__je_, _ལྡན__འབྲུག_, _भोजपुरी__अकादमी_, --, 
   {{0x5493600e,0x028aa002,0x00000000,0x00000000}},	//   _by__se_, _би__могао_, --, --, 
   {{0x2ed58017,0x00000000,0x00000000,0x00000000}},	//   _než_, --, --, --, 
   {{0x5bee6002,0x7e96c002,0x454c200b,0x00000000}},	// [320] _зато_, _шта__се_, _bushyash, --, 
   {{0xca57e00c,0x00000000,0x00000000,0x00000000}},	//   _एह__बात_, --, --, --, 
   {{0x198b4012,0x54430018,0xecaba00d,0x9c01e00c}},	//   _prečo_, _diz_, _una__persona_, _कहनी__कि_, 
   {{0x32b5800c,0x00000000,0x00000000,0x00000000}},	//   _गांव__बसवलन_, --, --, --, 
   {{0x7be7c037,0x74430025,0xfceec002,0x00000000}},	//   _ninguna__negociac, _fiz_, _граду_, --, 
   {{0xbd8fe003,0x00000000,0x00000000,0x00000000}},	//   _བྱོས_, --, --, --, 
   {{0x8473200f,0xb51e400f,0x6efc6002,0x00000000}},	//   _ubufakaz, _enhliziy, _је__он_, --, 
   {{0xcc5a6004,0x0a53e00c,0x00000000,0x00000000}},	//   _yintoni_, _राज्यन__में_, --, --, 
   {{0x0b018009,0xe360400a,0x00000000,0x00000000}},	//   _udtrykke, _बदायूं__बरेली_, --, --, 
   {{0xe2b5c016,0x00000000,0x00000000,0x00000000}},	//   _upassend_innlegg_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x54a1a00e,0x726de00e,0x2ebfa002,0x00000000}},	//   _se__dá_, _letos_, _србија__је_, --, 
   {{0x9bda4003,0xfa84600e,0x6480200b,0x00000000}},	//   _བོད__མི_, _větší_, _muri__aka_, --, 
   {{0x7103400f,0x00000000,0x00000000,0x00000000}},	//   _udokotel, --, --, --, 
   {{0xd3868012,0x9c2c000f,0x54b1800e,0x00000000}},	//   _ktorá_, _ibhokisi__isithomb, _kteří__se_, --, 
   {{0x16284006,0x0462801a,0xd9ecc00b,0xfb9c0003}},	//   _མེདཔ_, _tilbake__ein_, _utangaza_, _དགོན__པར_, 
   {{0xc341e009,0x556ec025,0xd49b4002,0x00000000}},	// [330] _kan__lide_, _questão_, _спољашње_, --, 
   {{0xbe19e039,0x03206004,0x4399c009,0xb49dc01f}},	//   _menemuka, _omnye_, _læste_, _berkata__at_, 
   {{0xc46ec00d,0x4a3c600c,0x7443000e,0x00000000}},	//   _hacer__un_, _आवत_, _viz_, --, 
   {{0x74438028,0x6399c009,0x3256e00f,0xc47b800b}},	//   _tus_, _næste_, _abazali__bami_, _mukameny_aho_, 
   {{0xc6ff400c,0x00000000,0x00000000,0x00000000}},	//   _जादा_, --, --, --, 
   {{0xec5ae002,0x29dfe006,0xff89c002,0x00000000}},	//   _izvor__komentar, _ཟེར__མིའི_, _објаве__других_, --, 
   {{0x5ea6a02a,0xe33b4002,0x3dfa8020,0x1c66a009}},	//   _fortsatt_, _tekstova__blogu_, _འགོ__འདྲེན_, _fortsat_, 
   {{0x8419c012,0x7bf48003,0x00000000,0x00000000}},	//   _nachádza, _པར__དྲ_, --, --, 
   {{0x72978037,0xeb99e006,0x098ec002,0x626c0003}},	//   _amigo__pero_, _ཁའི__ཡི_, _радио_, _དྲོའི__གསར_, 
   {{0xe453a01a,0xc23bc011,0x00000000,0x00000000}},	//   _det__vert_, _que__máis_, --, --, 
   {{0x84420004,0x3994400e,0xaeed400c,0x00000000}},	//   _phi_, _chtěl_, _आपन__राज्य_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2395e011,0x9306200a,0x00000000,0x00000000}},	//   _cousa_, _उत्तर__काशी_, --, --, 
   {{0x3d8fe021,0xb2ca6003,0xaee2c002,0x00000000}},	//   _བྱུས_, _སོགས__ཀྱི_, _контакт_, --, 
   {{0x6c5ae011,0x944d2002,0x12da4018,0x00000000}},	//   _novos__comentar, _псовке__увредљив, _da__loja_, --, 
   {{0xb339401e,0x02908003,0x00000000,0x00000000}},	//   _je__napisao_, _བོད__གནས_, --, --, 
   {{0xf7acc00c,0x00000000,0x00000000,0x00000000}},	// [340] _कारस्तान, --, --, --, 
   {{0x4eb58002,0x00000000,0x00000000,0x00000000}},	//   _једна__од_, --, --, --, 
   {{0x9be24006,0x233cc00f,0x00000000,0x00000000}},	//   _འཚོལ__ལས_, _lesi__sihloko_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x609ea033,0xb9dbe046,0x92f0e00b,0xbe736002}},	//   _registri_korisnik_, _दान__सहायता_, _amatora__wara_, _реч_, 
   {{0x84432008,0xe27d800f,0x00000000,0x00000000}},	//   _xix_, _khona__futhi_, --, --, 
   {{0x472d8022,0x32926012,0x0e5ac00c,0x00000000}},	//   _दिखाई__देता_, _sprava_, _बैंकिंग__प्रणाली_, --, 
   {{0x127c0037,0x9293c006,0x00000000,0x00000000}},	//   _mayo__abril_, _རིམ__དུས_, --, --, 
   {{0x71fe2002,0xfc6a801c,0x9c51c012,0x6bc9c00c}},	//   _кроз_, _चेन्नई_, _dátumu_, _टैक्स__चोरन_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xc2fc6039,0xa2f7e00a,0xd2740002,0x6d462002}},	//   _dong_, _हो__जाती_, _по__извођачи, _садржи_, 
   {{0x00f08022,0xe27d400f,0x26358025,0xa2fca025}},	//   _कहावत_, _kodwa__lapho_, _econômic, _efeitos_, 
   {{0x8c38200a,0x22026010,0x00000000,0x00000000}},	//   _लखनऊ_, _årige_, --, --, 
   {{0xf2fc601a,0xf25ac012,0x794d600e,0x63f9800f}},	//   _gong_, _diely_, _ideální_, _sezulu_, 
   {{0xe290e00f,0xebdc200c,0x74ca400f,0xebed000c}},	//   _johane_, _मौजूदगी__के_, _izinto__ezibonak, _आतंकियन__के_, 
   {{0x4245a01d,0x0370400e,0x02bfa003,0x00000000}},	//   _pandu__arah_, _oblíbeno_názvu_, _དབང__གིས_, --, 
   {{0xc3f4601a,0x80330018,0x83936009,0x049d801a}},	// [350] _nyttar_, _postagen, _emnets__ejer_, _får__ein_, 
   {{0xa740000a,0xb4b22025,0x7491400b,0x00000000}},	//   _किया__जाता_, _fazer__uma_, _umwaka__wa_, --, 
   {{0x5317e00f,0xc912e03d,0xb7336002,0x7f59000c}},	//   _eduze_, _českých_, _услове__коришћењ, _के__मांग_, 
   {{0x42cac012,0x1d8fe003,0x1291e01f,0xcc46c00b}},	//   _pred_, _བྱིས_, _bahasa__melayu_, _abapolis, 
   {{0x0aace00c,0x2a1c6002,0x59aac002,0x00000000}},	//   _करे__में_, _одобри__коментар, _нових_, --, 
   {{0x12430003,0x024c400a,0x00000000,0x00000000}},	//   _ཚོས_, _शिमला_, --, --, 
   {{0x2c740047,0xa4aa4015,0xcc77400b,0xb72ba00a}},	//   _आवश्यक_, _harga__rp_, _cyumweru_, _और__सबमिट_, 
   {{0x424e4020,0x00000000,0x00000000,0x00000000}},	//   _ལྟག_, --, --, --, 
   {{0x140d2011,0x00000000,0x00000000,0x00000000}},	//   _desta__páxina_, --, --, --, 
   {{0xbc108006,0xf290c037,0x6ba68013,0x6197e002}},	//   _རིགས__ཚུ_, _bogotá_, _है__आप_, _најновиј, 
   {{0x5a3cc00c,0x2ba00012,0xf340a038,0x26b0c00a}},	//   _एकर_, _porovnať__sledovať_, _vivenda_, _हुई__सलमान_, 
   {{0xbdcf000e,0x00000000,0x00000000,0x00000000}},	//   _rychlost_, --, --, --, 
   {{0x6fe7800e,0x4bd6c006,0x0ad2c00e,0x633a200f}},	//   _svůj_, _ཤོག__ངོ_, _přidáno_, _indlela__engcono_, 
   {{0xd290e004,0xcccc800d,0x00000000,0x00000000}},	//   _yohane_, _en__nuestro_, --, --, 
   {{0xdb6e2002,0x75fbc00c,0xc737e00c,0x00000000}},	//   _лиценцом_, _बा__भारत_, _कहां__राजा_, --, 
   {{0x94b64005,0x1c4e600c,0x329d000b,0x00000000}},	//   _etter__ei_, _कइसे_, _mu__ijambo_, --, 
   {{0xa9e8e00e,0x00000000,0x00000000,0x00000000}},	// [360] _se__může_, --, --, --, 
   {{0xd2d8e00d,0x626f6003,0x00000000,0x00000000}},	//   _quiere_, _ལས__དཔལ_, --, --, 
   {{0x626de009,0xa87e2002,0xa676e00c,0x00000000}},	//   _netop_, _одлуке_, _के__नोकसान_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x0bffc00a,0x00000000,0x00000000,0x00000000}},	//   _होती__है_, --, --, --, 
   {{0xd213e00f,0x00000000,0x00000000,0x00000000}},	//   _kithi_, --, --, --, 
   {{0x5c53600b,0x42d00018,0x00000000,0x00000000}},	//   _ubutaka_, _copyrigh_ogol_, --, --, 
   {{0x6b8e4013,0xebcb6014,0x6ab56022,0x4059800c}},	//   _आप_, _राष्ट्र__के_, _आंकड़ा_, _बरिस_, 
   {{0x9467c033,0x00000000,0x00000000,0x00000000}},	//   _postove__datum_, --, --, --, 
   {{0x998aa012,0x6bd3e003,0x00000000,0x00000000}},	//   _podľa_, _ཞིག__ཏུ_, --, --, 
   {{0x4598000f,0xca618002,0x9c11800c,0x0bf2400a}},	//   _abesifaz, _приликом__писања_, _जाला__कि_, _सिलेबस__को_, 
   {{0x3b1b200f,0x92ba6025,0x00000000,0x00000000}},	//   _abaprist, _em__todo_, --, --, 
   {{0xf2946006,0x43008009,0x3f77a00f,0x00000000}},	//   _འབད__རུང_, _misbrug_, _ngicaban, --, 
   {{0xd4712011,0xfd5a6002,0x0a6d600a,0x00000000}},	//   _nunha__das_, _боље_, _ऐसे__में_, --, 
   {{0xa3e1a02f,0x6298c003,0x00000000,0x00000000}},	//   _as__suas_, _ཀྱི__བུད_, --, --, 
   {{0x44926009,0x2e93801a,0xd3848011,0x1be90003}},	//   _en__af_, _kommunan, _iconas__correo_, _སྒོ__ནས_, 
   {{0x1752000e,0x63dae00e,0x00000000,0x00000000}},	// [370] _připravi, _na__míru_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x027b2020,0x00000000,0x00000000,0x00000000}},	//   _ཏེ__ཡོད_, --, --, --, 
   {{0x0864e03c,0x2386801a,0xdfe3c00e,0x0c78e00a}},	//   _bosne__hercegov, _kvar_, _celý__článek_, _परिणाम__इसके_, 
   {{0x1925e00a,0x00000000,0x00000000,0x00000000}},	//   _हापुड़__रामपुर_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x23cf4016,0x00000000,0x00000000,0x00000000}},	//   _krever_, --, --, --, 
   {{0xbdc18003,0xd932a012,0xd5512002,0x00000000}},	//   _གནང__རོགས_, _použiť_, _нову__песму_, --, 
   {{0x6201003d,0x9b8fe003,0x00000000,0x00000000}},	//   _mobilu_, _ཤས_, --, --, 
   {{0x02432029,0xc463800e,0xb1e3c01c,0x00000000}},	//   _མོས_, _operační_, _उतारा_, --, 
   {{0xb08a0002,0x0a6ec00a,0x00000000,0x00000000}},	//   _навигаци, _वृन्दावन__में_, --, --, 
   {{0x6c620039,0x33e5200e,0x00000000,0x00000000}},	//   _masukan_, _jen__skladem_, --, --, 
   {{0xe27f603d,0xc25b4012,0xa3d2a003,0x00000000}},	//   _jedná_, _nielen_, _དྲ__འདྲེའི_, --, 
   {{0x02a8e006,0x9eb7e009,0xd398400b,0x00000000}},	//   _ཚན__ཁྱབ_, _hverdage_, _mu__murenge_, --, 
   {{0x0ceaa006,0xebad600c,0xc2b4c027,0x00000000}},	//   _མི__སྡེའི_, _उर्दू__के_, _nieco_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x92dfa00a,0xd030c00d,0x0be4a003,0x7b8ce003}},	// [380] _शादी_, _otros__países_, _རིས__བར_, _ནན_, 
   {{0xebd4a003,0x0ef9c00c,0x9047c002,0xb263a002}},	//   _རིང__གི_, _भोजपुरी__नाटक_, _законом_, _језицима__додај_, 
   {{0xe3cf600f,0xecec0003,0xdbf70003,0x00000000}},	//   _yethu__ujesu_, _ལག__ཁྱེར_, _ངོ__བོ_, --, 
   {{0xaea08007,0x4ffd600a,0x00000000,0x00000000}},	//   _linkedin__pengguna, _लड़कियों_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x8c47c00b,0x0c0fe00a,0x00000000,0x00000000}},	//   _umva__ibiganir, _रहता__है_, --, --, 
   {{0x77504003,0x00000000,0x00000000,0x00000000}},	//   _བྱུང__རྩེད_, --, --, --, 
   {{0x6279a006,0x9e5b2039,0x63f8c012,0xe6856011}},	//   _གནང__ནུག_, _perbedaa, _zmluvy_, _na__galipedi, 
   {{0x4f87e00a,0x00000000,0x00000000,0x00000000}},	//   _करें__अनुरूपता_, --, --, --, 
   {{0xcadbe003,0x00000000,0x00000000,0x00000000}},	//   _ྋརྒྱལ__མཆོག_, --, --, --, 
   {{0xba9e200c,0x00000000,0x00000000,0x00000000}},	//   _पऽ__शोध_, --, --, --, 
   {{0xcca9000a,0xb44d400b,0x5e2ae012,0x78382002}},	//   _और__देखें_, _karere__ka_, _na__základe_, _истим_, 
   {{0xc752c00f,0xe4986027,0xd752000e,0x8502800c}},	//   _izinking, _sk__na_, _připrave, _उदयनाराय_तिवारी_, 
   {{0x7c020002,0x00000000,0x00000000,0x00000000}},	//   _се__само_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xfd71e00c,0x00000000,0x00000000,0x00000000}},	//   _में__महुआ_, --, --, --, 
   {{0xaf874012,0xe48f6027,0x00000000,0x00000000}},	// [390] _košice_, _ak__by_, --, --, 
   {{0xf4848048,0x8d838012,0x3064e00f,0xfdf02003}},	//   _ऑनलाइन_, _nič_, _inqabayo, _བྱ__སྤྱོད_, 
   {{0x9242a021,0x00000000,0x00000000,0x00000000}},	//   _ཐོན_, --, --, --, 
   {{0xe544200f,0x8dc66002,0x00000000,0x00000000}},	//   _eziyisik, _аутоматс, --, --, 
   {{0xa242a003,0xc29b2018,0xaf9b800e,0x00000000}},	//   _བོད_, _sem__juros_, _seřadit_, --, 
   {{0xe444800b,0xc2636003,0x00000000,0x00000000}},	//   _ibindi__kur_, _སློབ__དེབ_, --, --, 
   {{0x52a0e006,0xfa65800e,0x00000000,0x00000000}},	//   _གཡུ__རོབ_, _dříve_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6c51e01e,0xa443800d,0x94260015,0xf9fe4025}},	//   _kantona_, _mis_, _tulisan__baru_, _casament, 
   {{0xe24e4006,0x51ade011,0x248b000b,0x00000000}},	//   _ལྟོ_, _atendémo, _nakora__iki_, --, 
   {{0x98796002,0xebb1000c,0x00000000,0x00000000}},	//   _грађевин, _कीकटन__के_, --, --, 
   {{0x9014c012,0x477b000a,0x00000000,0x00000000}},	//   _skutočno, _एनबीटी__मेरा_, --, --, 
   {{0x62936003,0xe47d400d,0xe404200f,0x00000000}},	//   _མདུན__ངོས_, _este__es_, _njengoba__ujesu_, --, 
   {{0xd2fe6009,0x9149a011,0xd75d6014,0x00000000}},	//   _bruges_, _sentímol, _गुप्तचर_, --, 
   {{0x44426004,0x19ffa002,0x8228800c,0x6dc62012}},	//   _yho_, _додај__нови_, _कालचक्र_, _ružomber, 
   {{0x32b0c02a,0x23098009,0xdb642011,0x43dd800b}},	//   _har__kommet_, _meget__mere_, _cidadáns_, _ruswa_, 
   {{0xe2b4e028,0xa3e7800e,0xec43800a,0x42d86014}},	// [3a0] _chicas_, _pátek_, _खेल__बॉलीवुड_, _रखनी_, 
   {{0x7211000f,0xe2434003,0xddae4003,0x00000000}},	//   _sikhathi_, _པོས_, _ཏུ__འབྲོག_, --, 
   {{0xf2080012,0xd08b200e,0x55aec027,0x22b7a00b}},	//   _informác, _domácí_, _výsledko, _kugira__icyo_, 
   {{0x9290a01a,0x2c772011,0x00000000,0x00000000}},	//   _vidare_, _mensaxe_, --, --, 
   {{0x52b40028,0x30490002,0x475cc00c,0x8f184002}},	//   _chica_, _периоду_, _गइल__बाड़े_, _да__ти_, 
   {{0x43dde00b,0x48dba00c,0x00000000,0x00000000}},	//   _mutwe_, _अब__भोजपुर_, --, --, 
   {{0xdfa10011,0xc242a029,0x4186800f,0x9fd08009}},	//   _servizos_, _བོན_, _lukankul, _stærkt_, 
   {{0x3cec2006,0xb7ac2021,0x9479c00b,0xec00000c}},	//   _འགྱོ__འཚོལ_, _རེ__འདོད_, _gari__ya_, _खाई__के_, 
   {{0x6e55600b,0x2beca00c,0x00000000,0x00000000}},	//   _yuko__amabombe_, _इतिहास__पऽ_, --, --, 
   {{0x6c59200c,0x0c49e00c,0x00000000,0x00000000}},	//   _के__माथे_, _पीये_, --, --, 
   {{0x8387000e,0x00000000,0x00000000,0x00000000}},	//   _která_, --, --, --, 
   {{0x3186800f,0x00000000,0x00000000,0x00000000}},	//   _kukankul, --, --, --, 
   {{0xd2fc8009,0x00000000,0x00000000,0x00000000}},	//   _fragt_, --, --, --, 
   {{0xeac0800e,0xfa52800c,0x00000000,0x00000000}},	//   _patří_, _आवें__घरन_, --, --, 
   {{0x9290a009,0x00000000,0x00000000,0x00000000}},	//   _forkert_, --, --, --, 
   {{0x034ce01d,0x1268c00f,0x00000000,0x00000000}},	//   _tinggalk_komen_, _abazali__bakho_, --, --, 
   {{0x4fe10002,0xfbe56003,0x00000000,0x00000000}},	// [3b0] _овај_, _སྐུ__པར_, --, --, 
   {{0xb218000a,0xd314800b,0x7386c012,0x5cbae00a}},	//   _स्__टाइल_, _mukiring_ukwezi_, _utorok_, _छांटें__सबसे_, 
   {{0x56dbe015,0x3f47a00e,0x5387a00e,0x00000000}},	//   _follow__spotligh, _výrobce_, _výrobci_, --, 
   {{0x6eb14011,0x7c7ba00a,0x00000000,0x00000000}},	//   _mércores_, _होने__वाले_, --, --, 
   {{0x4f4e0028,0x3237c00f,0x3f658003,0x00000000}},	//   _redes__sociales_, _ngomusa_, _སྲོལ__རྒྱུན_, --, 
   {{0xeb8c800a,0xabdcc006,0x82438006,0x73f4200e}},	//   _गई_, _ཨིན__དེ_, _ཀོཊ_, _jistě_, 
   {{0xea5aa037,0xa33aa00d,0x00000000,0x00000000}},	//   _reportar__contenid, _las__política, --, --, 
   {{0x93e3a01e,0x0a770014,0x00000000,0x00000000}},	//   _tuzlansk, _कालांतर__में_, --, --, 
   {{0x2394601a,0x00000000,0x00000000,0x00000000}},	//   _finst_, --, --, --, 
   {{0x9b8ca029,0x734c4012,0x146b800e,0xff51e00c}},	//   _བླ_, _francúzs, _většina_, _एह__साहित्य_, 
   {{0x19f64011,0xaec7c012,0x00000000,0x00000000}},	//   _entón_, _vzdialen, --, --, 
   {{0x7442800f,0x4dc26024,0xc4734011,0x00000000}},	//   _cha_, _jednosta_način_, _cada__un_, --, 
   {{0xca0f800e,0x02920011,0x00000000,0x00000000}},	//   _následuj, _espazo_, --, --, 
   {{0xe498e037,0x00000000,0x00000000,0x00000000}},	//   _categorí_es_, --, --, --, 
   {{0x33e5002d,0xeba9200c,0x43a12002,0xaa94000c}},	//   _prikaži__sakrij_, _एनआईए__के_, _отац_, _पऽ__कुछ_, 
   {{0xd690c00a,0x8285600b,0x00000000,0x00000000}},	//   _के__खिलाफ_, _ibirimo__ariko_, --, --, 
   {{0xe308401d,0xabc0200a,0xd41be012,0x34e2600a}},	// [3c0] _mengikut__negara_, _होने__की_, _musíš__najprv_, _की__स्थिति_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xec736018,0xc2534003,0xc25fe006,0xb138800e}},	//   _quartos_, _གསུམ__པའི_, _ཁའི__ཡིག_, _půjčky_, 
   {{0x22c88018,0xf345800a,0x34c5e01a,0x72fc801a}},	//   _estoque_, _बॉलीवुड__टीवी_, _ligg__på_, _blant__anna_, 
   {{0xf2cae034,0x7682600a,0x229f6003,0x00000000}},	//   _bygde_, _भिलाई_, _གཞི__རིམ_, --, 
   {{0x7c362012,0x34ba4012,0x32d9e00e,0xcccd000b}},	//   _vybrať_, _paci__sa_, _úte_, _ka__rutsiro_, 
   {{0x44444027,0x027ea006,0x08652011,0x6c00a018}},	//   _ju_, _ལུ__ཡོད_, _mantida__publicad, _acessos_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x028a8003,0xec4e600c,0x5c6f8002,0x00000000}},	//   _ཡོངས__ཁྱབ_, _कइके_, _односу_, --, 
   {{0xd33fc010,0x00000000,0x00000000,0x00000000}},	//   _der__ikke_, --, --, --, 
   {{0x84444009,0x44428004,0x00000000,0x00000000}},	//   _nu_, _pha_, --, --, 
   {{0x4282401a,0xfb9cc00c,0x00000000,0x00000000}},	//   _endre__kjelde_, _सवाल__से_, --, --, 
   {{0x72542002,0x24932019,0x76ff200a,0x12eca00e}},	//   _po__ceni_, _nå__kan_, _आगरा_, _displeje__méně_, 
   {{0xc4444005,0xbb89c00d,0xe402200e,0x6268c00f}},	//   _bu_, _noviembr, _přihlási_pokud_, _abazali__bakhe_, 
   {{0xa4b4c040,0x00000000,0x00000000,0x00000000}},	//   _noćenja_, --, --, --, 
   {{0xf442e01a,0x00000000,0x00000000,0x00000000}},	//   _òg_, --, --, --, 
   {{0xbab4600e,0xaf746012,0x00000000,0x00000000}},	// [3d0] _vlastní_, _vlastné_, --, --, 
   {{0x943b2028,0x6aaee00a,0x00000000,0x00000000}},	//   _me__gusta_, _जैसलमेर_, --, --, 
   {{0x1c8e600c,0x223ae00f,0x00000000,0x00000000}},	//   _कइगो_, _nini__nanini_, --, --, 
   {{0x8491e005,0x00000000,0x00000000,0x00000000}},	//   _at__eg_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xae00e002,0x22b98004,0xbb74600f,0x00000000}},	//   _које__су_, _setting__yiya_, _ujoshuwa_, --, 
   {{0xfb4a4037,0x00000000,0x00000000,0x00000000}},	//   _una__respuest, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x140ac01d,0x00000000,0x00000000,0x00000000}},	//   _bebas__lompat_, --, --, --, 
   {{0x247fc00b,0x00000000,0x00000000,0x00000000}},	//   _mategeko_, --, --, --, 
   {{0x00fd800c,0x00000000,0x00000000,0x00000000}},	//   _मालवा_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x83e5000b,0x00000000,0x00000000,0x00000000}},	//   _gicurasi_, --, --, --, 
   {{0x89e5400f,0xc3992009,0x6443c010,0xfaff8037}},	//   _indodana_, _måske_, _giv_, _de__linkedin_, 
   {{0x01d2c015,0x0bd50006,0x00000000,0x00000000}},	//   _berita__favoritm, _ཐབས__ལུ_, --, --, 
   {{0x9bb60003,0x14dfe018,0x00000000,0x00000000}},	//   _ནས__མི_, _seleção_, --, --, 
   {{0x12f2a00b,0x4baae00c,0x00000000,0x00000000}},	// [3e0] _amafoto__papa_, _प्रयास__चल_, --, --, 
   {{0x9b7fe020,0xf3cd000e,0x027aa006,0xf243c003}},	//   _ཞབས__དྲུང_, _osobní_, _ནི__ཨིན_, _ཞོག_, 
   {{0xa25bc003,0x00000000,0x00000000,0x00000000}},	//   _ལུས__བོད_, --, --, --, 
   {{0xd25ac005,0x9b10c020,0x10c14009,0x56a28002}},	//   _gjeld_, _གནས__གློག_, _tilladel, _нерегист, 
   {{0x547c401a,0xd32e8009,0x22d1c00f,0x00000000}},	//   _meir__om_, _som__bruger_, _kulesi__sihloko_, --, 
   {{0x0c8fa00a,0x5e142002,0x46e30011,0x5243a003}},	//   _हमारे__बारे_, _власти_, _educació_ordenaci, _གོས_, 
   {{0x34360009,0xabe0800a,0xca51200c,0x00000000}},	//   _af__dette_, _ने__की_, _शुरुआती__तौर_, --, 
   {{0x5efdc019,0x73cf002f,0x00000000,0x00000000}},	//   _på__eksterne_, _gravar_, --, --, 
   {{0x8338e016,0xe2596003,0x00000000,0x00000000}},	//   _annet__sted_, _ལྡན__རྡོ_, --, --, 
   {{0x4c4ee00c,0xd707400c,0x00000000,0x00000000}},	//   _जइसे_, _होखे__बाकिर_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xe402a011,0x52804035,0x932cc00b,0x00000000}},	//   _sen__fins_, _phakade_, _bibiliya__ivuga_, --, 
   {{0xb443e009,0xa225c012,0x00000000,0x00000000}},	//   _mit_, _čaká_, --, --, 
   {{0x72a1e003,0x00000000,0x00000000,0x00000000}},	//   _ཀྱི__ཆོས_, --, --, --, 
   {{0x64946012,0x00000000,0x00000000,0x00000000}},	// [3f0] _sa__že_, --, --, --, 
   {{0x776f6044,0xcc594012,0x38408003,0x19c3e002}},	//   _टिप्पणी_, _záujem_, _རྩོམ__འཕྲིན_, _пошаљи__нови_, 
   {{0xc25ac00f,0x04b5e005,0x00000000,0x00000000}},	//   _ejele_, _blei__det_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x946ce00b,0x8442c01d,0x41742002,0x00000000}},	//   _ariwe__ya_, _bhd_, _бесплатн, --, 
   {{0x07bb4003,0x3f5c0012,0xabec800c,0x00000000}},	//   _སྐྱབས__མགོན_, _vzťah_, _के__बढ़िया_, --, 
   {{0x2443e026,0x4a3ae00a,0x00000000,0x00000000}},	//   _dit_, _लिया__गया_, --, --, 
   {{0x3443e01a,0xb26f6002,0x00000000,0x00000000}},	//   _eit_, _сличним__именом_, --, --, 
   {{0x4a40000a,0x5e204012,0x01cfc002,0x7f14a002}},	//   _की__खबर_, _občiansk, _односе_, _поште__провера_, 
   {{0xf202600b,0x00000000,0x00000000,0x00000000}},	//   _pasika_, --, --, --, 
   {{0x1442c004,0x00000000,0x00000000,0x00000000}},	//   _khe_, --, --, --, 
   {{0x3705400c,0x00000000,0x00000000,0x00000000}},	//   _के__परमारवंश, --, --, --, 
   {{0x42bd4003,0x753e000c,0x6ed4e002,0x9ab1400c}},	//   _མེ__ལོང_, _में__सीरियल_, _мо_, _इतिहासका_लोग_, 
   {{0x6b9da00d,0x2442c025,0xf2ec4014,0xe9090002}},	//   _más__informac, _lhe_, _यासीन_, _метара_, 
   {{0x83e32007,0x72fa201a,0x00000000,0x00000000}},	//   _ke__atas_, _eit__anna_, --, --, 
   {{0xd737600e,0xbbf7c00c,0x00000000,0x00000000}},	//   _dalších_, _फुटी__सी_, --, --, 
  
   {{0x16ae8003,0x00000000,0x00000000,0x00000000}},	// [400] _ལག__སློབ_, --, --, --, 
   {{0x0291400f,0x6243a03a,0x00000000,0x00000000}},	//   _ingabe_, _ངོས_, --, --, 
   {{0xd47ba018,0x7fd2a009,0x327c000f,0x0b68c00c}},	//   _para__sua_, _glæder_, _ubaba__wethu_, _के__देशन_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7359c031,0x00000000,0x00000000,0x00000000}},	//   _sebagai__berikut_, --, --, --, 
   {{0x64be6025,0x00000000,0x00000000,0x00000000}},	//   _processo__de_, --, --, --, 
   {{0x427e6004,0x7ecec002,0x00000000,0x00000000}},	//   _ntoni_, _му__се_, --, --, 
   {{0x3e764002,0xb7cb8003,0x00000000,0x00000000}},	//   _су__на_, _ལྷ__སྨོན_, --, --, 
   {{0x2dbb8003,0xc2d9200a,0x4f006007,0xe580e00e}},	//   _དྲ__ཚིགས_, _बड़ी_, _ini__dilindun, _zavřít_, 
   {{0xc2c1803f,0x64dfe018,0xb2290002,0x00000000}},	//   _kuhlala_, _coleção_, _увредљив_вулгарне_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xf71e000a,0x82670002,0x00000000,0x00000000}},	//   _नहीं__होता_, _селу_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x325be01a,0x2a2a6003,0x8d4ca003,0x84aa600f}},	//   _skule_, _ཤེས__བྱའི_, _གཅིག__གྱུར_, _cishe__ngo_, 
   {{0x82c1c028,0x00000000,0x00000000,0x00000000}},	//   _belleza_, --, --, --, 
   {{0x6499202c,0xcfc40002,0xb2432003,0x00000000}},	// [410] _ukwezi__kwa_, _октобра__такмичи_, _མོད_, --, 
   {{0x5553600f,0x2b5fc002,0x398e2002,0x00000000}},	//   _isikhath, _условима_, _дачић_, --, 
   {{0xc752400c,0x00000000,0x00000000,0x00000000}},	//   _से__परदा_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2348200f,0x7478e00b,0x0aa7800c,0x00000000}},	//   _ukuba__enze_, _abatutsi__mu_, _गजेटियर__में_, --, 
   {{0xe259a00f,0x00000000,0x00000000,0x00000000}},	//   _ngakho__lapho_, --, --, --, 
   {{0x9c50a01c,0xdf70c002,0x00000000,0x00000000}},	//   _ट्रेन_, _услуге_, --, --, 
   {{0xb07bc024,0xeda8a002,0x22bb2028,0x14ab0016}},	//   _bezbedno, _оно__што_, _el__foro_, _trening__har_, 
   {{0x2fb62004,0x2a3de022,0x97820003,0x00000000}},	//   _upawulos_, _हवन_, _འཐབ__རྩོད_, --, 
   {{0xccf48030,0x6352e038,0x95220002,0x8460800e}},	//   _objavlji_pjesama_, _outros__artigos_, _свом_, _časy__jsou_, 
   {{0xa718a00a,0xbaa2800c,0x00000000,0x00000000}},	//   _हो__जाता_, _नइखे__मिल_, --, --, 
   {{0x23eae038,0x4b614009,0x76a6c00f,0x32e8600c}},	//   _editar_, _billeder, _izithuny, _के__बेटी_, 
   {{0xf22b4012,0xbe480038,0x00000000,0x00000000}},	//   _upraviť_, _empanada, --, --, 
   {{0x2b22600f,0x00000000,0x00000000,0x00000000}},	//   _ekuphile, --, --, --, 
   {{0x1553600f,0x32eba01d,0x00000000,0x00000000}},	//   _esikhath, _fizikal_, --, --, 
   {{0x126d000b,0x9b9f2020,0x53d9000b,0xa5ffe018}},	//   _kubona_, _སྒྲིག__ལས_, _ko__uhuru_, _solução_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [420] --, --, --, --, 
   {{0x42fde009,0x1350800b,0x7652000a,0xab750002}},	//   _bruge_, _vatikani__guhera_, _का__इतिहास_, _квалитет, 
   {{0xb10a8003,0xdc90a00a,0x0b8c8003,0x00000000}},	//   _མི__འདྲ_, _देशों_, _བག_, --, 
   {{0x34526016,0xe4b1000d,0x92e96037,0xe253200f}},	//   _annen__måte_, _puede__ser_, _taringa_, _unkulunk_futhi_, 
   {{0x7f86e002,0x0c72e003,0x00000000,0x00000000}},	//   _слободне__енциклоп, _དྲོའི_, --, --, 
   {{0xf3a3800c,0xc2d42018,0xeba86014,0xa2d9a00b}},	//   _में__भोजपुरी_, _escolha_, _अर्थव्यव_के_, _adverb_, 
   {{0xb9f4a00e,0x00000000,0x00000000,0x00000000}},	//   _najít_, --, --, --, 
   {{0xdbd94005,0xd2958006,0x7875c002,0x1dd7000c}},	//   _nordfjor, _གནས__སྐད_, _за__статисти, _भइले__संगोष्ठी_, 
   {{0xfdaac011,0x8e57c01e,0x170c400e,0x87612002}},	//   _rexistra, _bosanske_, _příležit, _двери_, 
   {{0x3233e00f,0xbe76e002,0x00000000,0x00000000}},	//   _ukuthi__ngeke_, _се__регистру, --, --, 
   {{0x82af6020,0x3e756002,0x675ce01d,0x00000000}},	//   _མི__དབང_, _скочи__на_, _kakitang, --, 
   {{0xefa4a009,0x8e55200a,0x00000000,0x00000000}},	//   _derefter_, _चाहत__बनाएं_, --, --, 
   {{0x12b06012,0xe8370002,0x00000000,0x00000000}},	//   _vidieť_, _литургиј, --, --, 
   {{0xdeb9e016,0x00000000,0x00000000,0x00000000}},	//   _gjør_, --, --, --, 
   {{0x64abc038,0x62bb401a,0x0bdea003,0xb9ca8003}},	//   _darse__de_, _er__noko_, _དེའི__ནང_, _རེའི_, 
   {{0x646da00d,0x4dae8020,0x5a32800c,0x00000000}},	//   _cantidad__de_, _དག__བཅོས_, _गईल_, --, 
   {{0x39826012,0x00000000,0x00000000,0x00000000}},	// [430] _veľkosti_, --, --, --, 
   {{0x4cec0002,0x00000000,0x00000000,0x00000000}},	//   _компаниј, --, --, --, 
   {{0xa224202a,0x1c67c00f,0x6394601d,0x05bc200c}},	//   _fikk_, _namuhla_, _ogos_, _के__बेहतर_, 
   {{0xb224202a,0x8d3c200e,0x827e601a,0x8b204003}},	//   _gikk_, _velikost_, _funne_, _མེར__སྲེག_, 
   {{0x41426002,0xd522200c,0x00000000,0x00000000}},	//   _је__доступан_, _के__घोषणा_, --, --, 
   {{0x5d80e003,0x01d6800e,0x00000000,0x00000000}},	//   _བསྟོད_, _jednání_, --, --, 
   {{0x41a76002,0xa2d9a00b,0x227f600b,0x00000000}},	//   _на__фејсбуку_, _barenga__ijana_, _ibanze_, --, 
   {{0xf9f4200e,0xe27bc003,0xd3958018,0x523b2009}},	//   _její_, _དེ__རིང_, _disso_, _højre_, 
   {{0xd2a3c003,0x00000000,0x00000000,0x00000000}},	//   _རྒྱུ__ཡིན_, --, --, --, 
   {{0xe6c8e016,0x02bca003,0x00000000,0x00000000}},	//   _vis__offentli, _པོ__ཡོད_, --, --, 
   {{0x72df000a,0x00000000,0x00000000,0x00000000}},	//   _इतनी_, --, --, --, 
   {{0x85844012,0x00000000,0x00000000,0x00000000}},	//   _fotogalé, --, --, --, 
   {{0x7978801a,0x00000000,0x00000000,0x00000000}},	//   _opningst, --, --, --, 
   {{0x5319a00f,0x576ca003,0x86340002,0x00000000}},	//   _noma__kunjalo_, _ལས__བྱེད_, _новим__чланцима_, --, 
   {{0x62e5e033,0xacb2800a,0x12db4018,0x00000000}},	//   _kronika_, _में__नहीं_, _de__loja_, --, 
   {{0xee84400e,0xd8f2400a,0x5a32800a,0x00000000}},	//   _nejvíce_, _कपूरथला__कानपुर_, _गईं_, --, 
   {{0x2442002b,0x22770002,0x1a920009,0x398ae00e}},	// [440] _iki_, _blogu__snimi_, _danmarks__største_, _peněz_, 
   {{0x623e4026,0xf244e045,0x00000000,0x00000000}},	//   _danmark_, _tým_, --, --, 
   {{0x0161000f,0x13e9400f,0x00000000,0x00000000}},	//   _ukugcwal, _ezelwe__yodwa_, --, --, 
   {{0xfb81e00a,0xad3cc00a,0x00000000,0x00000000}},	//   _असहमत_, _पुराने__पाठकों_, --, --, 
   {{0x870fc00c,0x00000000,0x00000000,0x00000000}},	//   _शाहाबाद__जिला_, --, --, --, 
   {{0xe444400e,0x63178011,0x3f4b0012,0x00000000}},	//   _ji_, _forza_, _náradie_, --, 
   {{0x03220012,0x8e8ba00a,0x00000000,0x00000000}},	//   _rýchlo_, _भारतकोश_, --, --, 
   {{0xa2438006,0x5aabc018,0x69d06002,0x00000000}},	//   _ཀོཌ_, _de__preços_, _рећи_, --, 
   {{0x3444402a,0x83062011,0x00000000,0x00000000}},	//   _oi_, _como__unha_, --, --, 
   {{0x526a800b,0x509b200c,0x00000000,0x00000000}},	//   _mbere__kugira_, _संतन__सिंह_, --, --, 
   {{0x78286002,0x00000000,0x00000000,0x00000000}},	//   _коментар_архива_, --, --, --, 
   {{0xced66012,0x54444025,0x02b16003,0xaaa6c00f}},	//   _veľmi_, _ai_, _སྤྲུལ__སྐུ_, _lebhayib, 
   {{0xd4420015,0xb374a012,0xe495600e,0x9b98200c}},	//   _dki_, _sk__ceny_, _se__zde_, _जाव__कि_, 
   {{0x8494a02a,0xc1874012,0x56d7a00a,0xb6d3400a}},	//   _og__mer_, _topovať_, _जीतिए_, _सबमिट_, 
   {{0xdff36002,0x0bcf8006,0xc6fa600c,0x37f78003}},	//   _добијте__сваки_, _རིང__ལུ_, _परदा_, _ཐང__གཞོན_, 
   {{0x94444005,0xa494a01a,0xb286200f,0x00000000}},	//   _ei_, _om__dei_, _nofakazi_, --, 
   {{0x3bfa600c,0x00000000,0x00000000,0x00000000}},	// [450] _कमजोर__बा_, --, --, --, 
   {{0xc3ea8002,0x3c7b200a,0x9a86c00c,0x0325c002}},	//   _zahtev_, _टाइप__करें_, _वाला__लोग_, _језика__захтевај_, 
   {{0xe2ba6021,0xfb9b200a,0xf4808011,0xe242a00f}},	//   _མི__སྡེ_, _तरह__से_, _polo__seu_, _futhi__lapho_, 
   {{0xebf6600c,0x00000000,0x00000000,0x00000000}},	//   _बिपाशा__के_, --, --, --, 
   {{0x7bd5a006,0xc3aa0018,0xd29a2003,0x00000000}},	//   _འོང__ནི_, _dúvida_, _གླུ__དཔེ_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xf367e039,0x0bd72006,0x023c000b,0x02aaa020}},	//   _bergabun_dengan_, _བཀོད__ལུ_, _mwaka__igihe_, _བཞེངས__ཡོད_, 
   {{0x63fce026,0x0ba5800a,0x6ba64003,0x00000000}},	//   _det__danske_, _ही__है_, _འགྱུར__ཁག_, --, 
   {{0xebc28013,0xca1f8037,0x55e22012,0x6c3a4018}},	//   _ऐसे_, _hay__algún_, _fóre__nemôžete_, _visualiz_acessos_, 
   {{0xb28f8003,0x00000000,0x00000000,0x00000000}},	//   _ཐུབ__ཀྱི_, --, --, --, 
   {{0xeb42003d,0x7290201d,0xd8ddc00a,0x9053c002}},	//   _doporuču, _kekal_, _रामपुर__कानपुर_, _новине_, 
   {{0xa3eb800e,0x0a94600a,0x0a95e00a,0x00000000}},	//   _byste_, _दिल्ली__में_, _उम्मीद_, --, 
   {{0x537f8015,0x1dcd2002,0xfa82a002,0x00000000}},	//   _jakarta_, _се__пријавил, _црвена__звезда_, --, 
   {{0x56ff200c,0x2704a00c,0x00000000,0x00000000}},	//   _अतना_, _कारस्तान_बिहार_, --, --, 
   {{0x5aefe01d,0xe4420004,0x00000000,0x00000000}},	//   _yang__berkongs, _ekh_, --, --, 
   {{0xb0cb0003,0xcc54e00a,0xab24e003,0x00000000}},	// [460] _དེ__འདྲ_, _खेल__मनोरंजन_, _སྤྲང__ཕྲུག_, --, 
   {{0x0ab14022,0x4497c00b,0x00000000,0x00000000}},	//   _लेख__में_, _za__bbc_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7baa8022,0x0aa1a00c,0x00000000,0x00000000}},	//   _कि__अब_, _में__सांप_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x4286200f,0x6c85200c,0x00000000,0x00000000}},	//   _wofakazi_, _के__संख्या_, --, --, 
   {{0xd40a0009,0x82f9801a,0xd4b5c00b,0x00000000}},	//   _markedsf_læs_, _har__laga_, _buryo__bw_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x13fd600d,0x4281e00f,0x00000000,0x00000000}},	//   _los__nuevos_, _kwezinye__izimo_, --, --, 
   {{0xcb9e8022,0xe2496039,0xc30a0015,0x373cc002}},	//   _के__ही_, _nyaman_, _luas__tanah_, _других__пратиоца_, 
   {{0x9c0e400c,0xb2a9e003,0x00000000,0x00000000}},	//   _रहले__कि_, _གི__བཀའ_, --, --, 
   {{0xbb2da002,0xebbd400c,0x00000000,0x00000000}},	//   _delatnos, _भटकल__के_, --, --, 
   {{0x80aa2018,0xc3f8800b,0x0261800f,0xdbd8001c}},	//   _mais__postagen, _makuru_, _yibo__bonke_, _अफ्रीका_, 
   {{0x72d8a00f,0x2ac7000c,0x00000000,0x00000000}},	//   _kajesu_, _ओंकारेश्_पांडेय_, --, --, 
   {{0xa315c015,0xee88e002,0x00000000,0x00000000}},	//   _kunci__sumber_, _могао__да_, --, --, 
   {{0xfb29c007,0xb9f8801a,0x4f8be018,0x00000000}},	//   _pengguna_linkedin_, _samstund, _pré_, --, 
   {{0xfb8ce029,0xe4422009,0x032c6018,0x00000000}},	// [470] _ནག_, _dkk_, _esse__produto_, --, 
   {{0x0b958006,0xe4420004,0x551f8004,0x34a2e009}},	//   _དོན__ལུ_, _ukh_, _intliziy, _op__på_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xb2baa006,0x00000000,0x00000000,0x00000000}},	//   _སར__རྣམ_, --, --, --, 
   {{0xea332049,0x00000000,0x00000000,0x00000000}},	//   _जैन_, --, --, --, 
   {{0x447fa039,0xf278602c,0x635ae00a,0x00000000}},	//   _satu__ini_, _ukuntu_, _मोहाली__लुधियाना_, --, 
   {{0x62856004,0xe310a00b,0x74b30031,0xd251c01a}},	//   _kuthixo_, _kuvuguru_ukwa_, _tidak__mau_, _og__fleire_, 
   {{0x62db6011,0x00000000,0x00000000,0x00000000}},	//   _de__pola_, --, --, --, 
   {{0x4b89200d,0x00000000,0x00000000,0x00000000}},	//   _diciembr, --, --, --, 
   {{0x25d98012,0x00000000,0x00000000,0x00000000}},	//   _napíšte_, --, --, --, 
   {{0xca3dc014,0x00000000,0x00000000,0x00000000}},	//   _सकल_, --, --, --, 
   {{0x23290028,0xb27e001a,0x48956009,0x00000000}},	//   _es__este_, _kring_, _nye__mulighed, --, 
   {{0xe2d8401a,0x0243a003,0xdbb3600c,0x00000000}},	//   _hjelpe__nynorsk_, _གོད_, _द्विवेदी__जी_, --, 
   {{0x3bee0002,0xe4bb400b,0xd4422012,0x198e0002}},	//   _мало_, _cumi__na_, _skk_, _мали_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x327f400b,0x7c35c002,0x00000000,0x00000000}},	//   _buenos_, _чланова_, --, --, 
   {{0x0315a00d,0xe2606003,0x126b400c,0x00000000}},	// [480] _de__edad_, _དགེ__རྒན_, _के__लिमिटेशन_, --, 
   {{0x5cdd2004,0x1bea0015,0x9747200c,0x71dc6002}},	//   _ukuphela__umateyu_, _tanah__bangunan_, _संस्__कृति_, _клуб_, 
   {{0xcc50a00a,0x00000000,0x00000000,0x00000000}},	//   _देखें_, --, --, --, 
   {{0x59f4600e,0xeb9b000c,0xb2f2200e,0x00000000}},	//   _není_, _बना__के_, _přitom_, --, 
   {{0x4847000b,0x55c2c002,0x8f1a4002,0x8b9ca00c}},	//   _ukoreshe_amashaki, _књиге_, _ла__си_, _के__का_, 
   {{0x44b5e030,0x02eae00f,0x379ec00e,0x3d59a018}},	//   _vrh__re_, _wonke__umuntu_, _bez__písemnéh, _exercíci, 
   {{0x3e3ce002,0x8c15c014,0xb24b0003,0x00000000}},	//   _се__на_, _स्क्रिप्, _ཉིད__ཀྱི_, --, 
   {{0xb276a011,0x3ddb8002,0x00000000,0x00000000}},	//   _da__cámara_, _поште__није_, --, --, 
   {{0x77e72002,0x92cb600e,0x75e1000c,0x00000000}},	//   _архива_, _snadno_, _करऽल__चाहत_, --, 
   {{0x244ba00b,0x00000000,0x00000000,0x00000000}},	//   _ku__rubuga_, --, --, --, 
   {{0x1254e003,0x6291000f,0x00000000,0x00000000}},	//   _བྱའི__ཁོར_, _encane_, --, --, 
   {{0xae680014,0xf538800f,0x7ba1e00c,0x7292a003}},	//   _रिश्_, _ushintsh, _एह__मत_, _བདུན__ཕྲག_, 
   {{0x8c3a0012,0x00000000,0x00000000,0x00000000}},	//   _prehľad_, --, --, --, 
   {{0xa378600b,0xedd16003,0x00000000,0x00000000}},	//   _ingamba_, _དམ__འབྲེལ_, --, --, 
   {{0x2a33a00c,0x1e000015,0xd26e800f,0x13496009}},	//   _अछि_, _kecepata, _nokuthul, _dage__siden_, 
   {{0x5317e00e,0x6480c038,0x00000000,0x00000000}},	//   _pouze_, _polo__de_, --, --, 
   {{0xe8476014,0xabfaa003,0x00000000,0x00000000}},	// [490] _मातृभाषा_, _ཐོ__ཕབ_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2e7e6002,0x00000000,0x00000000,0x00000000}},	//   _зашто__је_, --, --, --, 
   {{0xab9ec014,0x00000000,0x00000000,0x00000000}},	//   _टी__वी_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xedbd8020,0x5ba9e003,0x54e6a00c,0x00000000}},	//   _བདག__སྐྱོང_, _སྨེང__སོ_, _के__मामिला_, --, 
   {{0x63006033,0xede62002,0xd47c801d,0x92ca603d}},	//   _prije__sata_, _као__што_, _oleh__itu_, _apod_, 
   {{0x1d316020,0xc5802018,0x335f200f,0x6a614011}},	//   _གི__སྐོར_, _informaç, _kungase_, _algúns_, 
   {{0xfa6b200c,0xa2990003,0x00000000,0x00000000}},	//   _कइले__रहन_, _པའི__མཛད_, --, --, 
   {{0x6b1fa007,0x72c1e011,0x00000000,0x00000000}},	//   _kejayaan_, _publicad_lupa_, --, --, 
   {{0x79bba024,0xcd8a8003,0x00000000,0x00000000}},	//   _nameštaj_, _རེངས_, --, --, 
   {{0x3386802d,0xaa600014,0x4b93400d,0x9a93c002}},	//   _sakrij_, _कुछ__कुछ_, _haciendo_, _поделио_, 
   {{0x7284201a,0x0bada00a,0xf213200a,0x4336c00a}},	//   _på__bokmål_, _था__और_, _बिजनौर__भदोही_, _जा__सकती_, 
   {{0x44884009,0xeb98600c,0xc26d0003,0x00000000}},	//   _medlem__af_, _अकादमी__के_, _ལམ__གྱི_, --, 
   {{0x4775201a,0x72dba011,0xc750a00c,0x7be54003}},	//   _lisensen__namngjev, _da__nosa_, _से__राजा_, _ཀྱི__རང_, 
   {{0xa394c009,0xf2622002,0x00000000,0x00000000}},	//   _sidst_, _са__данас_, --, --, 
   {{0x12f4401a,0x353cc00b,0x00000000,0x00000000}},	// [4a0] _utanfor_, _bahitany, --, --, 
   {{0xf94ae027,0xfb8da003,0x00000000,0x00000000}},	//   _na__mojasvad, _གླ_, --, --, 
   {{0x5846800a,0x4476800f,0xe291800f,0x00000000}},	//   _पर__जानकारी_, _kuyi__menu_, _kuye__futhi_, --, 
   {{0x62c18037,0x7aa8e00c,0x00000000,0x00000000}},	//   _puntos__votos_, _अपरोक्ष__रूप_, --, --, 
   {{0x2c48600a,0x76620006,0x00000000,0x00000000}},	//   _लिये_, _གནང__ཡོདཔ_, --, --, 
   {{0x73400011,0xeba5e00a,0xdbe34003,0x00000000}},	//   _licenza_, _हो__गई_, _གྱི__མེ_, --, 
   {{0x2307a037,0x00000000,0x00000000,0x00000000}},	//   _duplicad_este_, --, --, --, 
   {{0x49786028,0x26802018,0xe290401d,0x00000000}},	//   _administ, _exibiçõe, _kelab_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x4b90800e,0xfbf04021,0xfbbbe014,0x82b42015}},	//   _prostřed, _གུ__རུ_, _क्षेत्र__से_, _jakarta__barat_, 
   {{0xe3f8200e,0xc2cae009,0xc4b90010,0x135ac00f}},	//   _pokud_, _kender_, _ikke__kun_, _kungani__ujehova_, 
   {{0x54a3c00b,0x00000000,0x00000000,0x00000000}},	//   _cyangwa__se_, --, --, --, 
   {{0xda3dc00c,0xf39b000c,0x00000000,0x00000000}},	//   _सकत_, _तऽ__भोजपुरी_, --, --, 
   {{0x1adc8003,0x51b8200c,0x22fce01d,0xf4d1a00a}},	//   _སྟེགས_, _लागल_, _mangsa_, _अनुरूपता__दिनांक_, 
   {{0x626ce00f,0x00000000,0x00000000,0x00000000}},	//   _kunoma_, --, --, --, 
   {{0x7bdac003,0x7e45c00b,0x249a400b,0x8acee00f}},	//   _ཞུན__དྲ_, _bigaraga, _ubushinj, _izimiso__zebhayib, 
   {{0x6c118037,0xeff8600c,0x41db0012,0x4696c00a}},	// [4b0] _los__comentar, _के__मोताबिक_, _súhlasím_, _आयुर्वे__बाजार_, 
   {{0xeb9cc00c,0x00000000,0x00000000,0x00000000}},	//   _भोजपुरी__के_, --, --, --, 
   {{0xb4426004,0xe8506011,0x00000000,0x00000000}},	//   _oko_, _algunhas_, --, --, 
   {{0xa442600b,0xfe61c025,0x3081c018,0x00000000}},	//   _nko_, _trabalha, _trabalho, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xd4426012,0x72b7c00f,0x00000000,0x00000000}},	//   _ako_, _ama__israyeli_, --, --, 
   {{0x3b8e2020,0xf277e009,0x00000000,0x00000000}},	//   _ཌན_, _en__række_, --, --, 
   {{0xeac8a008,0x2b9f200a,0xc26a8003,0x2556200b}},	//   _rosalía_, _गई__थी_, _ཙམ__གྱི_, _ryihariy, 
   {{0xe2f0600b,0x00000000,0x00000000,0x00000000}},	//   _buhinde__ukwa_, --, --, --, 
   {{0xed01801d,0x7a6e800a,0x144a8011,0xbacfc039}},	//   _maklumat_, _होते__हैं_, _páxina__foi_, _saya__menerima_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa3eae01a,0x111b800a,0x5be3e003,0x00000000}},	//   _heiter_, _इसके__अलावा_, _བཟོ__ཨེ_, --, 
   {{0xa167201a,0xbebac002,0x00000000,0x00000000}},	//   _høgskule, _могла_, --, --, 
   {{0x646ec018,0x5d97800f,0x00000000,0x00000000}},	//   _dicas__de_, _umuntu__ngamunye_, --, --, 
   {{0x9a69e014,0xf30dc007,0x8c7d600f,0xc8208003}},	//   _कुछ__लोग_, _membina_, _ukusiza_, _ཚིགས__དཀོན_, 
   {{0x9212a00e,0x0ea7c00f,0xee00a00c,0x00000000}},	//   _bych_, _usolomon, _ब्रॉडकास, --, 
   {{0x7242a003,0x00000000,0x00000000,0x00000000}},	// [4c0] _དྲང_, --, --, --, 
   {{0xe34b6018,0x65ee0011,0x00000000,0x00000000}},	//   _recebeu_, _produció, --, --, 
   {{0x048f801a,0x1c802002,0x00000000,0x00000000}},	//   _då__det_, _жене_, --, --, 
   {{0xecdd0003,0x325b401a,0x00000000,0x00000000}},	//   _གྲོང__ཁྱེར_, _dei__ikkje_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xc3f1a04a,0xe06f0030,0x00000000,0x00000000}},	//   _uburundi_, _budžetsk_izdvajan, --, --, 
   {{0xe2fde007,0x79f4a012,0x92bd000b,0x00000000}},	//   _orang__islam_, _vecí_, _muri__uganda_, --, 
   {{0x18454002,0x23bac00b,0x03d5201a,0xdc25000c}},	//   _поштанск_сандуче_, _muri__rusange_, _er__meir_, _बरकरार__रखे_, 
   {{0xe4372009,0x8870002f,0x00000000,0x00000000}},	//   _kan__blive_, _músicas_, --, --, 
   {{0x92d24028,0xd2a6801d,0x7e956002,0x00000000}},	//   _hace__años_, _akhbar_, _јер__се_, --, 
   {{0x5303e037,0x8475600e,0xb2900003,0x00000000}},	//   _se__mostrará_, _sms__ve_, _ཐབས__ཀྱི_, --, 
   {{0x1442602c,0x8312800f,0x1aacc00c,0x00000000}},	//   _uko_, _ngezilim, _चाहीं__अगर_, --, 
   {{0x34ab2030,0x00000000,0x00000000,0x00000000}},	//   _maj__vrh_, --, --, --, 
   {{0x1a232002,0x104f4018,0x00000000,0x00000000}},	//   _порекло_, _seu__endereço_, --, --, 
   {{0x9a3de04b,0xebefc022,0x9bd64006,0x00000000}},	//   _हवा_, _सिनेमा__के_, _ཤོག__མི_, --, 
   {{0x76022022,0x6400e006,0x8c2b200a,0xec90400f}},	//   _में__भारत_, _འབྲུག__རྒྱལ_, _जा__रही_, _ukukhule_kweqinis, 
   {{0x12e6400a,0x7ba32003,0xd99cc00a,0x1cd72003}},	// [4d0] _की__सूची_, _ཀྱིས__རང_, _सामने__प्रेगनें, _དོན__སྐོར_, 
   {{0x427f4028,0x7800600a,0x00000000,0x00000000}},	//   _buenas_, _बनाएं__प्लास्टि, --, --, 
   {{0x9262002a,0xc394000b,0xca33200c,0x00000000}},	//   _grønnsak, _ibisa_, _जैश_, --, 
   {{0x82fb6007,0x2b8a2002,0xc42c8009,0x00000000}},	//   _lebih__kurang_, _којој_, _læg__kurv_, --, 
   {{0xa998c012,0x339c2031,0x6a41200c,0x00000000}},	//   _tiež_, _pada__tanggal_, _के__सहेजे_, --, 
   {{0x8290c01a,0xc291400f,0x026d800f,0x00000000}},	//   _medan_, _ingane_, _kuyoba_, --, 
   {{0xcb182015,0xa07a200a,0x00000000,0x00000000}},	//   _sebagian_, _ललितपुर__वाराणसी_, --, --, 
   {{0xd3da2002,0x4a91c00c,0x00000000,0x00000000}},	//   _правилни, _ग्राम__रुद्रपुर_, --, --, 
   {{0x7101c002,0xc2a8e006,0x12fe600f,0x00000000}},	//   _свету_, _སྟོན__འབད_, _ezibalul_kakhulu_, --, 
   {{0x22de0018,0x3bf0a00c,0x643b0006,0x4db0a003}},	//   _comentár_para_, _बा__एह_, _ཨིན__རྒྱལ_, _དོན__རྐྱེན_, 
   {{0x0d79e00b,0x00000000,0x00000000,0x00000000}},	//   _we__mwungere_, --, --, --, 
   {{0xc201602f,0x33ebe01a,0xabcd200f,0x1b73e002}},	//   _abaixo_, _nytta_, _unkulunk_weqiniso_, _морају_, 
   {{0x17e24002,0xe26cc00f,0x6ea6c00e,0x143c000f}},	//   _blogu__reputaci, _yilowo_, _hmotnost_, _lo__muntu_, 
   {{0x82d8604c,0x76f9e00c,0x3847a002,0x00000000}},	//   _लागी_, _मुदा_, _је__први_, --, 
   {{0x142c6014,0xc287600f,0x00000000,0x00000000}},	//   _साइबर_, _nomkhaya__wakhe_, --, --, 
   {{0x6d8c602e,0xd2d5e00f,0x0317400d,0x224d0002}},	//   _točno_, _kulokho_, _piezas_, _се__могу_, 
   {{0x1ba06003,0x00000000,0x00000000,0x00000000}},	// [4e0] _བརྙེས__ནས_, --, --, --, 
   {{0x8dfe8024,0xb300601d,0xd45e001a,0xc5ad800a}},	//   _neverova, _senarai_, _bokmål__den_, _मिलता_, 
   {{0x48d1a018,0xe2e2c00b,0x00000000,0x00000000}},	//   _estrelas__estrelas_, _rw__igihugu_, --, --, 
   {{0xf46d4018,0x9cb5000a,0x00000000,0x00000000}},	//   _avise__me_, _करें__विशेष_, --, --, 
   {{0x527c8018,0xda572002,0xe4a2601a,0x00000000}},	//   _são__paulo_, _питања_, _attende__til_, --, 
   {{0x3f2fa00d,0xdb0d8034,0x242c400f,0x00000000}},	//   _con__nosotros_, _læreplan_, _amakrist_ekhulu_, --, 
   {{0xd355e002,0x00000000,0x00000000,0x00000000}},	//   _одјавите_, --, --, --, 
   {{0xb2fc000b,0x00000000,0x00000000,0x00000000}},	//   _ikigo_, --, --, --, 
   {{0xf743c002,0x02d9c014,0x834c200e,0x00000000}},	//   _лозинку_, _फुटी_, _cestovní_, --, 
   {{0xe26c6017,0x7301c012,0xa44ec00b,0x98434002}},	//   _brno_, _údajov_, _inzego__za_, _централн, 
   {{0xfc2b200a,0x00000000,0x00000000,0x00000000}},	//   _जा__रहे_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x3757200a,0x52824013,0x09434002,0x5d43a00e}},	//   _जा__सकता_, _धर्म__दर्शन_, _међунаро, _jak__nakoupit_, 
   {{0x652c0028,0x6da6600f,0x2a21e002,0x4348e00b}},	//   _términos_, _indodaka, _примам__коментар, _mugenzi_, 
   {{0x625b4028,0xadbe400b,0xede26002,0x00000000}},	//   _vuelve_, _ingabire_, _се__тиче_, --, 
   {{0x227ec01a,0x4493e009,0x7607c00c,0x77eb000c}},	//   _treng_, _et__af_, _के__रिपोर्ट_, _सांकृत्_, 
   {{0x6495600e,0xebb9200c,0x72ab2003,0x00000000}},	// [4f0] _se__že_, _घरी__के_, _བཞིའི__ཆོས_, --, 
   {{0x34a36009,0x82434003,0x00000000,0x00000000}},	//   _os__på_, _བྲལ_, --, --, 
   {{0xebb86022,0x00000000,0x00000000,0x00000000}},	//   _पाकिस्ता_के_, --, --, --, 
   {{0x12cbe00d,0x7337c002,0x00000000,0x00000000}},	//   _ayuda_, _живота_, --, --, 
   {{0xd27ba003,0x2b8e6003,0x00000000,0x00000000}},	//   _དེ__ཡིན_, _ཉན_, --, --, 
   {{0xe4734009,0xe34c2009,0x8275401a,0xf52e600b}},	//   _accepter__du_, _ligesom_, _og__fekk_, _abayoboz, 
   {{0xdde0c01d,0x0bc1400a,0x8a78800a,0x00000000}},	//   _ahli__mengikut_, _सकती__है_, _बनाएँ__लॉग_, --, 
   {{0xc6e9e00a,0x9705200c,0x00000000,0x00000000}},	//   _में__चुनाव_, _चलल__जवना_, --, --, 
   {{0x3be8200c,0xcb3a200c,0x00000000,0x00000000}},	//   _जरूरी__बा_, _आतंकी__संगठनन_, --, --, 
   {{0xe463600f,0x00000000,0x00000000,0x00000000}},	//   _ubone__ukuthi_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xbddc4003,0x00000000,0x00000000,0x00000000}},	//   _སྐྱོན__བརྗོད_, --, --, --, 
   {{0x9ba6c003,0xb31ca00f,0x00000000,0x00000000}},	//   _ལའི__བླ_, _ngokwenz_kanjalo_, --, --, 
   {{0x536d0030,0x7479e00b,0x00000000,0x00000000}},	//   _opštinam_pregled_, _uyu__wa_, --, --, 
   {{0x0ab64014,0xe7d0c007,0x64af4028,0x93404025}},	//   _जगत__में_, _tanggung, _dejar__de_, _poderia_, 
   {{0x3471e009,0x2b42003d,0x6394c00f,0x6a6e000a}},	//   _tæt__på_, _doporuči, _abese_, _पूरी__तरह_, 
   {{0xc26c8011,0x00000000,0x00000000,0x00000000}},	// [500] _grao_, --, --, --, 
   {{0x2eeae002,0x6492c00d,0x00000000,0x00000000}},	//   _док__је_, _tiempo__de_, --, --, 
   {{0x6c51000a,0xa3f46009,0x41c62002,0x7be5c003}},	//   _भेजें_, _bestil_, _од__година_, _པའི__རང_, 
   {{0x927ec00d,0xe46b2016,0x3a33c014,0x84a38037}},	//   _bueno_, _forumet__du_, _जनम_, _cómo__sé_, 
   {{0x3a9ba011,0x82ec600e,0x00000000,0x00000000}},	//   _xornalis, _kterých_, --, --, 
   {{0x32cb4009,0x2c0b8012,0x1f5f6002,0xadf8200c}},	//   _hedder_, _približn, _придржав_правопис, _अनुमंडल_, 
   {{0x39f52018,0x6fbae002,0x1e97200f,0x00000000}},	//   _vocês_, _датотека__везаних_, _ngomoya__ongcwele_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xc6fe600c,0x69f44012,0xba0b000a,0x00000000}},	//   _ओकरा_, _celú_, _रुद्र__प्रयाग_, --, 
   {{0x7ed2e002,0xb9264012,0x0394e00b,0x2550600e}},	//   _би__се_, _odpoveď_, _kristo_, _měsíců_, 
   {{0x73300037,0x9295e009,0x66ffc00a,0x4bf6a003}},	//   _contenid_erróneo_, _at__komme_, _इतना_, _རམ__ཞལ_, 
   {{0x5b8fe022,0x4e888002,0x00000000,0x00000000}},	//   _तप_, _да__сам_, --, --, 
   {{0x3bb08012,0x00000000,0x00000000,0x00000000}},	//   _obchodoc, --, --, --, 
   {{0x9a5ca01f,0xa490e005,0x4f38a018,0x00000000}},	//   _lebih__daripada_, _ei__ny_, _está__comentan, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x758a0012,0x00000000,0x00000000,0x00000000}},	//   _registrá, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [510] --, --, --, --, 
   {{0x1495601a,0x52902007,0x7d40400f,0x00000000}},	//   _no__med_, _mekah_, _osizini__olukhulu_, --, 
   {{0x752d600f,0xa124e002,0x00000000,0x00000000}},	//   _isinyath, _не__постоји_, --, --, 
   {{0x9be3e003,0x4a5b200a,0xe471a00b,0x615c2002}},	//   _བྱས__ཏེ_, _का__नाम_, _rya__rya_, _јуна_, 
   {{0x9a7c0012,0x00000000,0x00000000,0x00000000}},	//   _dĺžka_, --, --, --, 
   {{0x2b88e00c,0xb681a01c,0x00000000,0x00000000}},	//   _पऽ_, _क्लास_, --, --, 
   {{0x7a3e2014,0xe317400f,0x4750400c,0x00000000}},	//   _नकद_, _ngezwi_, _कइले__बाड़े_, --, 
   {{0xa496c00b,0x00000000,0x00000000,0x00000000}},	//   _ubumwe__za_, --, --, --, 
   {{0x7443e00f,0x1d8fc003,0xbc06000a,0x20e7e00a}},	//   _ihu_, _བཟོས_, _आधार__पर_, _एनबीटी_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xee2ec01d,0x23586012,0x32efa009,0x1467800f}},	//   _tanpa__kebenara, _potrebné_, _vil__gerne_, _lowo__muntu_, 
   {{0x02ece018,0x6245a025,0x62d8c025,0x62d8600e}},	//   _este__produto_, _têm_, _homens_, _konec_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x0311a00e,0x00000000,0x00000000,0x00000000}},	//   _souboru_, --, --, --, 
   {{0x6442c015,0x00000000,0x00000000,0x00000000}},	//   _oke_, --, --, --, 
   {{0xc70ba006,0xcb9f800a,0x00000000,0x00000000}},	//   _ཁང__བརྙན_, _को__ही_, --, --, 
   {{0x32fde009,0x776e0002,0x00000000,0x00000000}},	// [520] _brugt_, _obavesti, --, --, 
   {{0x8442c00f,0x7245c017,0x82634003,0x00000000}},	//   _ake_, _tím_, _དང__མཉམ_, --, 
   {{0xf35be00d,0x9495602c,0xeb5ee002,0x00000000}},	//   _ninguna_, _ni__we_, _по__извођачу_, --, 
   {{0xaf0f0028,0xfbe0200c,0x00000000,0x00000000}},	//   _cercanos_, _कि__कबो_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x3cc7600a,0x9242a021,0x51bd2002,0xed8ea009}},	//   _संपादित__करें_, _ཐིམ_, _ништа_, _ikke__længere_, 
   {{0x375e4021,0x333b001d,0x00000000,0x00000000}},	//   _ཨོ__རྒྱན_, _paparan__terbaik_, --, --, 
   {{0x7f1fe012,0x00000000,0x00000000,0x00000000}},	//   _oblečeni, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x34d5600a,0x22b06010,0x3cb18003,0x00000000}},	//   _वीडियो_, _der__kommer_, _སྒྲིག__སྲོལ_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xfdb42006,0x00000000,0x00000000,0x00000000}},	//   _ལུ__སྤྱོད_, --, --, --, 
   {{0xbb03a028,0x83aaa010,0x8b8d8003,0x00000000}},	//   _herramie, _besvare_, _ཅག_, --, 
   {{0xa5be0018,0xc9d4c012,0xfbbb000c,0x9a63a00c}},	//   _carregar__próxima_, _umiestne, _उनका__से_, _भोजपुरिय_लोग_, 
   {{0x0fbac00e,0x00000000,0x00000000,0x00000000}},	//   _zařízení_, --, --, --, 
   {{0x958e8015,0xcfbde025,0x00000000,0x00000000}},	//   _quote__original_, _três_, --, --, 
   {{0x93cca01f,0x0b2fc029,0x61efc006,0x00000000}},	// [530] _ini__tanpa_, _བཟུང_, _བཟུམ_, --, 
   {{0xa442c009,0x00000000,0x00000000,0x00000000}},	//   _ske_, --, --, --, 
   {{0xf3c3a025,0xcd59200c,0x00000000,0x00000000}},	//   _nível_, _बाड़े_, --, --, 
   {{0x2fbce018,0x00000000,0x00000000,0x00000000}},	//   _as__palavras_, --, --, --, 
   {{0x826c0022,0x43232008,0x9378c015,0x00000000}},	//   _रक्षा_, _século_, _kemarin_, --, 
   {{0x4c5c2009,0x00000000,0x00000000,0x00000000}},	//   _sætter_, --, --, --, 
   {{0xc671000f,0x00000000,0x00000000,0x00000000}},	//   _kakhudlw, --, --, --, 
   {{0xc442c016,0x42e32012,0x00000000,0x00000000}},	//   _uke_, _peniaze_, --, --, 
   {{0xd27e000b,0xd250c002,0xc2972018,0x00000000}},	//   _print_, _један_, _desculpe__não_, --, 
   {{0xcc52e022,0x00000000,0x00000000,0x00000000}},	//   _अवशेष_, --, --, --, 
   {{0xbbc8e00a,0x0dd16011,0xb1722013,0x00000000}},	//   _चंडीगढ़_, _de__interese_, _अक्सर_, --, 
   {{0x56330028,0x52802003,0x06724002,0x00000000}},	//   _bienveni, _ཡོ__རོབ_, _је__објављен_, --, 
   {{0xf526600f,0x31b8c00c,0x00000000,0x00000000}},	//   _womshado_, _राखल_, --, --, 
   {{0x1c53e018,0x427ec018,0x2f82801a,0xaa9b000a}},	//   _contato_, _itens_, _kunne__sjå_, _में__कुछ_, 
   {{0x8bdd200a,0x9c03a00c,0x00000000,0x00000000}},	//   _आज__का_, _जइसन__कि_, --, --, 
   {{0x415a200f,0x00000000,0x00000000,0x00000000}},	//   _izithomb_ezingcol, --, --, --, 
   {{0x4bfb4003,0x00000000,0x00000000,0x00000000}},	// [540] _ཨེ__ལོ_, --, --, --, 
   {{0x5615200e,0xeb100012,0xb7c8000e,0xca33a00c}},	//   _příspěve, _prostrie, _obchodní_rejstřík, _आईल_, 
   {{0xc9f8e02e,0xcbf9e00f,0x7443000f,0x00000000}},	//   _milijuna_, _izithomb, _ngemva__kokuba_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xde0ea018,0x26868022,0x84ec800a,0xb399c009}},	//   _verdinha, _खुदाई_, _की__अन्य_, _læser_, 
   {{0xf3f4601e,0xf2904007,0xab0d6011,0x00000000}},	//   _postove__stare_, _semak_, _funcións_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x53450009,0xfc75a014,0x00000000,0x00000000}},	//   _ændret_, _पाण्डव_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x8243c006,0x00000000,0x00000000,0x00000000}},	//   _ཞལམ_, --, --, --, 
   {{0xdf6c2037,0x00000000,0x00000000,0x00000000}},	//   _seleccio_denuncia, --, --, --, 
   {{0x3ae3001f,0xabd10038,0x00000000,0x00000000}},	//   _perlukan_, _este__ficheiro_, --, --, 
   {{0x549c600d,0x71ba600c,0xfd8ac003,0xa6fa600a}},	//   _yo__no_, _पड़ल_, _འཚམས_, _पड़ा_, 
   {{0xb8ae2002,0x00000000,0x00000000,0x00000000}},	//   _сматра_, --, --, --, 
   {{0xc2d84018,0xd040000f,0x62908003,0x00000000}},	//   _homem_, _embuswen, _བོད__ཕྱི_, --, 
   {{0x4bde0003,0x00000000,0x00000000,0x00000000}},	//   _ཀྱི__ལོ_, --, --, --, 
   {{0x2415a004,0xb3f84025,0x00000000,0x00000000}},	// [550] _ezi__zinto_, _comum_, --, --, 
   {{0x2302601f,0xf349200c,0x00000000,0x00000000}},	//   _kecintaa_kepada_, _लोककला__भोजपुरी_, --, --, 
   {{0x4ef8002f,0x00000000,0x00000000,0x00000000}},	//   _os__produtos_, --, --, --, 
   {{0x6847c002,0x84936005,0x00000000,0x00000000}},	//   _налази_, _er__eg_, --, --, 
   {{0x48438038,0x725a2009,0x4a57c002,0xc329e00c}},	//   _contidos_, _fortælle, _никада_, _राजपूतन_, 
   {{0xc2010040,0x2263e006,0xb27ec00d,0x00000000}},	//   _srbiju_, _འབྱུང__ཤོག_, _buena_, --, 
   {{0xe2fb2004,0x8474601a,0x4b88200c,0xc365e00f}},	//   _liphela_, _som__eg_, _नू_, _sesimiso__sezinto_, 
   {{0x9be0a00e,0x00000000,0x00000000,0x00000000}},	//   _používat_, --, --, --, 
   {{0xa4734030,0xd290001a,0xf37d2011,0xd33d001a}},	//   _izdvajan_za_, _leiar_, _de__orixe_, _vist__gonger_, 
   {{0x67aea020,0x04c2001a,0xa236800d,0xe3b70025}},	//   _དུས__སྟོན_, _vart__det_, _viaje_, _ainda__mais_, 
   {{0xfc52e005,0x00000000,0x00000000,0x00000000}},	//   _kontoen_, --, --, --, 
   {{0x1363400f,0x00000000,0x00000000,0x00000000}},	//   _kodwa__ujehova_, --, --, --, 
   {{0x024f0003,0x00000000,0x00000000,0x00000000}},	//   _གཞུང__གིས_, --, --, --, 
   {{0xc2c52020,0x00000000,0x00000000,0x00000000}},	//   _ཚུགས__པའི_, --, --, --, 
   {{0x834c201a,0xe44f601a,0xfc2e200c,0x00000000}},	//   _eigedom_, _flytta__til_, _ना__रहे_, --, 
   {{0x4290a009,0xf35ca00c,0x00000000,0x00000000}},	//   _debat_, _कईगो__भोजपुरी_, --, --, 
   {{0xb2908003,0x68098003,0x00000000,0x00000000}},	// [560] _བོད__ཀྱི_, _མོ__སྟོན_, --, --, 
   {{0x83092015,0xf2d8400e,0xa1b88012,0x00000000}},	//   _kamu__bisa_, _kolem_, _recenzií_, --, 
   {{0x82912011,0xf30a000f,0x00000000,0x00000000}},	//   _sexan_, _ke__kumelwe_, --, --, 
   {{0x049cc011,0x00000000,0x00000000,0x00000000}},	//   _aquí__teu_, --, --, --, 
   {{0xab91a00f,0x00000000,0x00000000,0x00000000}},	//   _izinqumo_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x1eaca035,0x00000000,0x00000000,0x00000000}},	//   _esithile_, --, --, --, 
   {{0x9bef200c,0x4aed8003,0x026d400e,0x22a38003}},	//   _बा__कि_, _ཕྱི__ཕྱོགས_, _jehož_, _ཀྱི__ཤོག_, 
   {{0x62900015,0xf3b68018,0x00000000,0x00000000}},	//   _sehat_, _as__imagens_, --, --, 
   {{0xd2be4020,0x64b0c011,0x35eec011,0x6ba6a00a}},	//   _རུ__རིན_, _espazos__de_, _tradució, _है__इन_, 
   {{0xb681a00a,0x00000000,0x00000000,0x00000000}},	//   _इंसान_, --, --, --, 
   {{0x08e22002,0x445de012,0x4797800c,0x628b800f}},	//   _поруке_, _už__nie_, _लिखले__बाड़े_, _izinhliz_zethu_, 
   {{0x6444401e,0xb2dd2007,0xa0742002,0x00000000}},	//   _bh_, _al__quran_, _цео__текст_, --, 
   {{0x92a06006,0xbf334006,0xf2fa800f,0x00000000}},	//   _གཙོའི__བཙག_, _ལུ__འབྲུག_, _umpristi__kumelwe_, --, 
   {{0xdd15600e,0x72436003,0x00000000,0x00000000}},	//   _porovnat_, _ཕྲག_, --, --, 
   {{0xf200c00b,0x16f96036,0x374de030,0x5f3fa015}},	//   _polisi_, _साझा_, _bih__istraživ, _tangeran, 
   {{0x431de037,0x00000000,0x00000000,0x00000000}},	// [570] _no__puedes_, --, --, --, 
   {{0xeef3000f,0x00000000,0x00000000,0x00000000}},	//   _ngakolun, --, --, --, 
   {{0xd603c002,0xe26c000f,0x00000000,0x00000000}},	//   _колико_, _usho_, --, --, 
   {{0x0866e03c,0xc44cc00e,0xb2432003,0x00000000}},	//   _bosni__hercegov, _mě_, _མིས_, --, 
   {{0x34ab2030,0x727ee00f,0x906be002,0x00000000}},	//   _apr__vrh_, _eningi_, _на__википеди, --, 
   {{0x12318002,0x00000000,0x00000000,0x00000000}},	//   _септембр, --, --, --, 
   {{0xd44cc00e,0x00000000,0x00000000,0x00000000}},	//   _ně_, --, --, --, 
   {{0x6b8e401c,0x3c0a400c,0x00000000,0x00000000}},	//   _इन_, _जात__बा_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xfe730002,0xbe0cc00f,0x00000000,0x00000000}},	//   _део_, _isilo__sasendle_, --, --, 
   {{0x0a64803c,0x5420401a,0x00000000,0x00000000}},	//   _ov__stranica_, _kommente_mest_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x326fa01a,0x00000000,0x00000000,0x00000000}},	//   _skal__ikkje_, --, --, --, 
   {{0xa1e6000a,0xee324002,0x32da0028,0x00000000}},	//   _गैलरी_, _може__да_, _deseas_, --, 
   {{0xf7c14002,0x425a400e,0xb443000f,0x86e3000f}},	//   _не__треба_, _slovníče_pojmů_, _ngemva__kokufa_, _wohlu__lwadlalw, 
   {{0x1bd08003,0x52e3e004,0xbc15e00b,0x76a98002}},	//   _ཐོག__ནས_, _lo__mntana_, _yarabaye__musenyer, _миланско_едикта_, 
   {{0x178ac002,0x00000000,0x00000000,0x00000000}},	// [580] _приватно, --, --, --, 
   {{0x34a12012,0x1b6e600b,0x00000000,0x00000000}},	//   _prihlás__sa_, _michel__djotodia_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x1e688014,0x75aa8006,0xd2de8012,0x2aa4600a}},	//   _हिस्_, _ལེནཌ_, _zdrojov_, _फतेहपुर__फर्रूखाब, 
   {{0x0bff400a,0x5b8de003,0x53242018,0x00000000}},	//   _करती__है_, _ཀར_, _operação_, --, 
   {{0xd3798012,0xdba1600b,0xee1c2003,0x00000000}},	//   _pridať_, _dushobor, _ཚེ__སྐྱེལ_, --, 
   {{0x623a400e,0x4343801a,0x00000000,0x00000000}},	//   _se__nachází_, _eit__lite_, --, --, 
   {{0x347a801a,0x00000000,0x00000000,0x00000000}},	//   _meir__enn_, --, --, --, 
   {{0x33ea000b,0x1f1f2015,0xb4abe018,0x64aa600b}},	//   _bwite_, _komunita, _você__já_, _igihe__cyo_, 
   {{0xde72e031,0x9bd9a00a,0x524b000f,0x04de0002}},	//   _एकत्र_, _कहा__कि_, _ujesu__wathi_, _би__било_, 
   {{0x2d2a8012,0xe421200b,0x00000000,0x00000000}},	//   _hodnoten_produktu_, _ico__gihugu_, --, --, 
   {{0x3400a01a,0xd27ec012,0x34af000e,0x00000000}},	//   _innhald__hopp_, _hodn_, _skladem__kč_, --, 
   {{0x12d8401f,0x9093e003,0x330ca00e,0xb24a8003}},	//   _boleh_, _ཀརྨ_, _upravit_, _ལྷག__དཀར_, 
   {{0x344cc00e,0x4c67e002,0x00000000,0x00000000}},	//   _tě_, _преглед_, --, --, 
   {{0x24744030,0x00000000,0x00000000,0x00000000}},	//   _dana__maj_, --, --, --, 
   {{0x23eac012,0x00000000,0x00000000,0x00000000}},	//   _svete_, --, --, --, 
   {{0xdc8d001e,0x689d200e,0x00000000,0x00000000}},	// [590] _svi__postovi_, _soutěže_, --, --, 
   {{0xe3028037,0x6495e00d,0xc71de00c,0x00000000}},	//   _enviar__amigos_, _lo__de_, _प्रसिद्ध__राजा_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x12cbe011,0x7b8e601c,0x00000000,0x00000000}},	//   _axuda_, _उन_, --, --, 
   {{0x62536003,0x00000000,0x00000000,0x00000000}},	//   _གླིང__གསར_, --, --, --, 
   {{0x62902028,0x00000000,0x00000000,0x00000000}},	//   _dejar_, --, --, --, 
   {{0xd2438003,0xe24da00f,0x00000000,0x00000000}},	//   _ཁྲག_, _nini__lapho_, --, --, 
   {{0x9c186011,0x54438011,0x862f800e,0x00000000}},	//   _despois_, _ós_, _své__příspěvk, --, 
   {{0x02d8401d,0x7ba06006,0xeaf54015,0xec0b8022}},	//   _komen_, _བཅོས__གང_, _lowongan_, _ईरान__के_, 
   {{0x32d8001a,0xc3e06018,0x00000000,0x00000000}},	//   _seie_, _de__acesso_, --, --, 
   {{0xb2908003,0xabbe200a,0x00000000,0x00000000}},	//   _མེད__ཀྱི_, _उपयोग__की_, --, --, 
   {{0x12934015,0x00000000,0x00000000,0x00000000}},	//   _berapa__saja_, --, --, --, 
   {{0xec0ba009,0x1724400a,0xfbc0000c,0x00000000}},	//   _egypten_, _नहीं__किया_, _करेला__तऽ_, --, 
   {{0x62fc6015,0xe47e201a,0x830e2002,0x00000000}},	//   _uang_, _beskytta__mot_, _српског__народа_, --, 
   {{0x8394e00f,0x2e9e6002,0x00000000,0x00000000}},	//   _esisha_, _вести__из_, --, --, 
   {{0x327ec016,0x04ba402a,0x53690013,0x00000000}},	//   _noen_, _hvem__som_, _संत__कबीर_, --, 
   {{0x2bd2000a,0xb4bec00f,0x00000000,0x00000000}},	// [5a0] _टेक्नोलॉ, _ngokwesi_uma_, --, --, 
   {{0x92d0e018,0x426c800f,0x00000000,0x00000000}},	//   _um__comentár, _inkolo_, --, --, 
   {{0xe4a9a01d,0x6c39400d,0x32f4c018,0x22de400d}},	//   _kedua__dua_, _descripc, _agora__seja_, _la__semana_, 
   {{0xaf538012,0xe2d86007,0x025c6003,0x79f9a003}},	//   _byť_, _konek_, _ཡོད__ཅིང_, _ལྷ__མོའི_, 
   {{0x30b7400e,0xd2fc000f,0x7f234002,0x00000000}},	//   _rozměry_, _kuyi__main_, _ознакама__по_, --, 
   {{0x5dc9a00f,0x7407c00a,0x4a7f000a,0x00000000}},	//   _ngokucop, _इन__नामस्थान_, _कहा__गया_, --, 
   {{0x3da2002a,0x00000000,0x00000000,0x00000000}},	//   _egenskap, --, --, --, 
   {{0xc30f0035,0xf47be00b,0xcedca00b,0x00000000}},	//   _emazweni_, _icyemezo__cy_, _reba__urutonde_, --, 
   {{0x730e200f,0x9ab1600c,0xc2a40003,0x00000000}},	//   _lutho__neze_, _संबंध__रहल_, _ངམ__དེབ_, --, 
   {{0xda5c000b,0x00000000,0x00000000,0x00000000}},	//   _ihiganwa_, --, --, --, 
   {{0xebf5a014,0x3334000e,0xb9e66012,0x00000000}},	//   _प्रणाली__के_, _nevíte__rady_, _sa__môže_, --, 
   {{0xc2dd001d,0x0ab2c00c,0x00000000,0x00000000}},	//   _hb__julai_, _लोग__देश_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xebc7200c,0xd26c4003,0x00000000,0x00000000}},	//   _श्रमिकन__के_, _ནས__ཀྱང_, --, --, 
   {{0xee67e01d,0x247cc00b,0x0202600b,0x644c800f}},	//   _tawaran__rundinga, _papa__ni_, _harimo_, _abantwan_bakwa_, 
   {{0x579c0003,0x22918015,0x3de20003,0x00000000}},	//   _ཆབ__སྲིད_, _peran_, _གདན__འདྲེན_, --, 
   {{0x6f43400a,0x00000000,0x00000000,0x00000000}},	// [5b0] _ज्ञानकोष__जिसका_, --, --, --, 
   {{0x60b3400c,0x00000000,0x00000000,0x00000000}},	//   _एकहू__फ़िल्म_, --, --, --, 
   {{0x6471e011,0xc2258017,0xec73c003,0xc24c2003}},	//   _febreiro__de_, _tisk_, _ཁྲིའི_, _ཉིན__གྱི_, 
   {{0x3a33c04d,0xc5f72018,0x4bde8003,0xeabb800c}},	//   _जना_, _mais__informaç, _པའི__ལོ_, _साढ़े__तीन_, 
   {{0x42a0000f,0xd250600e,0x93ea000b,0x87e52013}},	//   _kodwa__manje_, _bílé_, _kwita_, _आसाराम_, 
   {{0x0290c01d,0xe2e16012,0x52f0802f,0x00000000}},	//   _kedah_, _rovnako_, _que__utiliza_, --, 
   {{0xd47de011,0x00000000,0x00000000,0x00000000}},	//   _pola__que_, --, --, --, 
   {{0xa202600b,0x3a5d8012,0x00000000,0x00000000}},	//   _barimo_, _týždňa_, --, --, 
   {{0xa29e000f,0x49cb6006,0x00000000,0x00000000}},	//   _amajuda_, _ཨེསི_, --, --, 
   {{0x3e0d0002,0x7290401a,0xe47d4037,0x03ac0010}},	//   _ово_, _delar_, _para__tu_, _jesper_, 
   {{0x7d60a014,0x72918025,0xd31ac012,0x633a000f}},	//   _एनआईए_, _geral_, _rôzne_, _indaba__ihlelwe_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa4512012,0x00000000,0x00000000,0x00000000}},	//   _na__dovolenk, --, --, --, 
   {{0x4373803c,0x22918031,0x8ad18006,0x2f20e018}},	//   _redanje_, _pesan_, _གཡོགཔ_, _desempen, 
   {{0xf25a001a,0x0a8be00c,0x00000000,0x00000000}},	//   _heile_, _शासनकाल__में_, --, --, 
   {{0x82786002,0x4dab400f,0x00000000,0x00000000}},	//   _светског__рата_, _ezininga, --, --, 
   {{0xfee32002,0x72d8201a,0x42904025,0xb3f82012}},	// [5c0] _она_, _veke_, _pelas_, _veku_, 
   {{0xa92f2022,0x00000000,0x00000000,0x00000000}},	//   _के__इलाज_, --, --, --, 
   {{0xd2d8401a,0x52d8201a,0x7b8da003,0x00000000}},	//   _elles_, _teke_, _ངས__གླེང_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x3aa2e00b,0xc201402c,0xb27e000b,0x638fc002}},	//   _wa__ekleziya_, _bagize_, _soma__muri_, _није__присутан_, 
   {{0xeecd200f,0xb495400c,0x00000000,0x00000000}},	//   _masinyan, _कट__ब्लाउज_, --, --, 
   {{0xe2318028,0x1290c01d,0x92bc000f,0x00000000}},	//   _primero_, _kedai_, _ngeke__kusaba_, --, 
   {{0xfbdc200a,0x00000000,0x00000000,0x00000000}},	//   _फिर__से_, --, --, --, 
   {{0xa2f78018,0x326c800b,0x00000000,0x00000000}},	//   _preço__incluí_, _inkoko_, --, --, 
   {{0x425d8025,0x2cbe6002,0xdc6ba00b,0x00000000}},	//   _de__julho_, _мање_, _burundu_, --, 
   {{0xb2952006,0x00000000,0x00000000,0x00000000}},	//   _འཁོད__ཀྱི_, --, --, --, 
   {{0xa200c02e,0x8bede006,0x00000000,0x00000000}},	//   _splitu_, _བློ__ཕན_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x3be0c00c,0x00000000,0x00000000,0x00000000}},	//   _प्रमाण__बा_, --, --, --, 
   {{0x1a89c01a,0xc2ac0003,0x00000000,0x00000000}},	//   _dei__største_, _བར__གྱི_, --, --, 
   {{0xa1ea0002,0x492c200a,0x00000000,0x00000000}},	//   _ел__поште_, _ज्यादा__चर्चित_, --, --, 
   {{0xedf36006,0x0b830003,0x788d601a,0x627e600f}},	// [5d0] _ཡོངས__འབྲེལ_, _འཛིན__བཟུང_, _verksemd, _aroni_, 
   {{0x9bed6018,0xf8c9a01c,0x00000000,0x00000000}},	//   _fevereir, _मिनट_, --, --, 
   {{0x8e944002,0x42aa2003,0x00000000,0x00000000}},	//   _неопходн, _གང__ལྟར_, --, --, 
   {{0x6de64003,0xa4ede00c,0x00000000,0x00000000}},	//   _རྩེད__རིགས_, _एगो__व्यापक_, --, --, 
   {{0xb29d6011,0x00000000,0x00000000,0x00000000}},	//   _ou__preme_, --, --, --, 
   {{0xa37fc00b,0x927ee005,0x3379a00f,0xf4962010}},	//   _somalia_, _sogn_, _inkambo_, _om__der_, 
   {{0xb4986037,0x00000000,0x00000000,0x00000000}},	//   _sé__el_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x8b8e4003,0xee990015,0x631ea028,0x00000000}},	//   _ཆར_, _telah__mengupda, _haz__clic_, --, 
   {{0x5b1fc015,0xa2454003,0x00000000,0x00000000}},	//   _silahkan_, _ལྷུག__རྩོམ_, --, --, 
   {{0xd2358012,0x00000000,0x00000000,0x00000000}},	//   _hľadať_, --, --, --, 
   {{0x52a1c011,0x00000000,0x00000000,0x00000000}},	//   _pódese_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x748ba00e,0xe2d9c014,0x525d8025,0x1b50a003}},	//   _největší_, _माटी_, _de__junho_, _མཚམས__འཇོག_, 
   {{0x1429c01d,0x00000000,0x00000000,0x00000000}},	//   _tempahan_, --, --, --, 
   {{0x92c9c018,0xebb78006,0xc4a72011,0x02d70018}},	//   _nenhum__comentár, _ཁོ__གི_, _este__enderezo_, _inglês_, 
   {{0x8b244003,0x00000000,0x00000000,0x00000000}},	// [5e0] _ཡོངས__རྫོགས_, --, --, --, 
   {{0x805a200f,0x794d400a,0x00000000,0x00000000}},	//   _thesalon, _चित्रकूट_, --, --, 
   {{0x5c00a016,0x02a36003,0x5f1ba00a,0x00000000}},	//   _varslet_, _བྱས__ཡོད_, _करने__लायक_, --, 
   {{0x1280a00e,0xa25e0003,0x00000000,0x00000000}},	//   _diskuze_, _ཁག__བོད_, --, --, 
   {{0x242d200b,0xee8b4002,0x00000000,0x00000000}},	//   _uru__rubuga_, _па__да_, --, --, 
   {{0x93f84040,0xf3efa01a,0xa2a32003,0x1bbda00c}},	//   _celu_, _det__berre_, _སྤྲོད__བོད_, _कवनो__ना_, 
   {{0x15408002,0xa3f84024,0x62d84018,0x00000000}},	//   _original__postavio_, _delu_, _dele_, --, 
   {{0x134de00a,0x00000000,0x00000000,0x00000000}},	//   _अपनी__दसवीं_, --, --, --, 
   {{0xc41ba01a,0x2189600c,0x00000000,0x00000000}},	//   _som__vart_, _के__भग्नावशे, --, --, 
   {{0x02d8c018,0xb7d06009,0x00000000,0x00000000}},	//   _podem_, _tilgænge, --, --, 
   {{0xf43d000b,0x43f8e018,0x7233801d,0x0195200f}},	//   _ku__kuntu_, _algum_, _arah__cari_, _yesikhat_esigcwel, 
   {{0xa243c003,0x36dca00c,0x2bfb000c,0x00000000}},	//   _ཞིག_, _मिहिर_, _नक्शा__पऽ_, --, 
   {{0x03f4601d,0xe9f5e012,0x52e2800c,0x00000000}},	//   _pautan_, _detí_, _वंशीय_, --, 
   {{0x239b800f,0x00000000,0x00000000,0x00000000}},	//   _futhi__kungani_, --, --, --, 
   {{0xe3e3400f,0xc316e00f,0x00000000,0x00000000}},	//   _umpristi_, _uzizwa_, --, --, 
   {{0x8291c007,0xa3740007,0xb27ee00f,0x00000000}},	//   _dewan_, _masa__yang_, _iningi_, --, 
   {{0xe37fc018,0xf200e018,0x00000000,0x00000000}},	// [5f0] _palavra_, _menina_, --, --, 
   {{0x646d8008,0x0469e018,0xeb576011,0x00000000}},	//   _cantidad_de_, _conta__com_, _en__composte, --, 
   {{0xb2e1a00b,0x2096600e,0x00000000,0x00000000}},	//   _ashigiki_imico_, _telefon__slovníče, --, --, 
   {{0xb46c6018,0x52d84004,0xd52f400b,0xc2dfa00b}},	//   _com__br_, _sele_, _ubuyoboz, _abantu__bose_, 
   {{0xb31d600d,0xc291c015,0x22d84018,0x4be1e00c}},	//   _se__puede_, _hewan_, _pele_, _एह__विषय_, 
   {{0xb667e002,0x97e7e002,0x2d91e028,0xeb972003}},	//   _србији_, _србија_, _cantidad_, _ཡོང__གི_, 
   {{0xa2c68012,0xd06be00b,0x00000000,0x00000000}},	//   _súd_, _aya__marushan, --, --, 
   {{0xf33ae011,0xf200602a,0x3442803c,0x404b2018}},	//   _de__galicia_, _mulig_, _nja_, _carregan, 
   {{0xc224c012,0xa46ae025,0x00000000,0x00000000}},	//   _celkom_, _das__as_, --, --, 
   {{0x64428015,0x00000000,0x00000000,0x00000000}},	//   _aja_, --, --, --, 
   {{0xf18c200c,0x00000000,0x00000000,0x00000000}},	//   _के__बक्सर_, --, --, --, 
   {{0x9452a01a,0x00000000,0x00000000,0x00000000}},	//   _ein__viktig_, --, --, --, 
   {{0xb2486012,0x00000000,0x00000000,0x00000000}},	//   _ňom_, --, --, --, 
   {{0xa2cb001a,0xd876a003,0x00000000,0x00000000}},	//   _skal__vera_, _རྒྱས__སྒྲིག_, --, --, 
   {{0x0288e006,0x0410a01a,0x3e52e002,0x00000000}},	//   _གཡང__རྩེ_, _dei__beste_, _види__сви_, --, 
   {{0x6278400f,0x00000000,0x00000000,0x00000000}},	//   _isigijim, --, --, --, 
   {{0x14b9a019,0xc316600f,0xa9daa00f,0x72a3e003}},	// [600] _fornøyd__med_, _emibili_, _ukufinye, _གླུ__ཆོས_, 
   {{0xd1812002,0x8322a00e,0xec02000c,0x00000000}},	//   _страница_, _konstruk_dotykové_, _चुन__के_, --, 
   {{0x6f396025,0xab8e6003,0x00000000,0x00000000}},	//   _de__milhões_, _ཉར_, --, --, 
   {{0xe2780015,0x6fd96011,0x37f1e00e,0x00000000}},	//   _bisnis_, _estás__comentar_, _rozšířen, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa27fe009,0xca33600c,0x00000000,0x00000000}},	//   _grund_, _कहल_, --, --, 
   {{0x9eb30018,0xf243a003,0x00000000,0x00000000}},	//   _direitos_, _གྲུ_, --, --, 
   {{0x4b996014,0xc546c002,0xee1b8002,0x00000000}},	//   _पता__चल_, _друштва_, _су__биле_, --, 
   {{0xff65e009,0x40f2400c,0x00000000,0x00000000}},	//   _især_, _बनावे_, --, --, 
   {{0x62d86024,0x00000000,0x00000000,0x00000000}},	//   _cene_, --, --, --, 
   {{0x224c4003,0x66fae00a,0x311a800e,0x00000000}},	//   _ཆེར_, _हंसी__मज़ाक_, _čtvrtek_, --, 
   {{0xd2d9a025,0x00000000,0x00000000,0x00000000}},	//   _jovens_, --, --, --, 
   {{0x4316800f,0x6ec1c00f,0x01ce200c,0x00000000}},	//   _amabili_, _izinhlan, _के__चैनल_, --, 
   {{0x25be2002,0xa2198002,0x7b6d400c,0x00000000}},	//   _друге_, _језику_, _सांकृत्__यायन_, --, 
   {{0x2224c00e,0x02738006,0x0251600a,0x00000000}},	//   _celkem_, _ལུ__ཞབས_, _के__मामले_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [610] --, --, --, --, 
   {{0x14966009,0xd29ba003,0x2a1d600c,0x00000000}},	//   _op__med_, _ཚེས__ཀུན_, _ली__हाईकोर्ट_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xab412003,0x00000000,0x00000000,0x00000000}},	//   _འགྱུར__གསུང_, --, --, --, 
   {{0x3ce9c006,0xf27e000b,0xe2d8c01d,0x00000000}},	//   _ཞིབ__འཚོལ_, _ukine_, _moden_, --, 
   {{0xe4abe010,0xe5af6017,0x290a8012,0x00000000}},	//   _der__er_, _obchodní, _februára_, --, 
   {{0x6bca4011,0x00000000,0x00000000,0x00000000}},	//   _da__informac, --, --, --, 
   {{0x65220002,0x00000000,0x00000000,0x00000000}},	//   _свим_, --, --, --, 
   {{0x130fa011,0x00000000,0x00000000,0x00000000}},	//   _mapa__debe_, --, --, --, 
   {{0x2ec1c00f,0x00000000,0x00000000,0x00000000}},	//   _ezinhlan, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x22d8401f,0x00000000,0x00000000,0x00000000}},	//   _soleh_, --, --, --, 
   {{0x4687600a,0x7ea8e002,0xebfaa00c,0x00000000}},	//   _चुदाई_, _али__се_, _ओही__के_, --, 
   {{0xd23b4040,0x147d4028,0x00000000,0x00000000}},	//   _još__uvek_, _para__mi_, --, --, 
   {{0x6463c018,0xcdd2e017,0x00000000,0x00000000}},	//   _imagens__de_, _pánské_, --, --, 
   {{0xaba12003,0x13506007,0x00000000,0x00000000}},	//   _དུས__བབ_, _juga__boleh_, --, --, 
   {{0xb491e02a,0x927f400b,0x631e000f,0xabf0000a}},	// [620] _er__mye_, _agenga_, _engcono_, _भदोही__मऊ_, 
   {{0xd89ae00f,0x46e9200a,0x3ef9400f,0x00000000}},	//   _ngikhulu, _है__इसलिए_, _lapho__nginemin, --, 
   {{0x2226602a,0xe3eba002,0x2201a00f,0x4c77e00b}},	//   _merket_, _да__буде_, _impi_, _uburezi_, 
   {{0xa4268002,0x947cc00b,0x5dbd2002,0x00000000}},	//   _pre__minuta_, _meni__ya_, _чешки__дански_, --, 
   {{0x0ead403c,0x8bfe000f,0xe4080018,0x4c3ec008}},	//   _navođenj, _izindawo_, _muito__mais_, _de__profesor, 
   {{0x344d800e,0x39bfe00f,0x0202000f,0x02bca006}},	//   _kč_, _kwadinge, _empini_, _ཚུ__ཨིན_, 
   {{0xc243203a,0x9fab801a,0x10f52014,0x00000000}},	//   _ཟིན_, _ut__frå_, _अप्रिय_, --, 
   {{0x82fc202a,0x00000000,0x00000000,0x00000000}},	//   _innhold_, --, --, --, 
   {{0xf73ae003,0xcd79c002,0xebbda00a,0x325cc003}},	//   _རྙེད_, _између__читалаца_, _सेक्स__के_, _སྐོར__ཁམས_, 
   {{0x88c5400a,0x00000000,0x00000000,0x00000000}},	//   _जोधपुर_, --, --, --, 
   {{0x3d7ee002,0x52670002,0x2bc3a00a,0x00000000}},	//   _еу_, _њему_, _लागू__हो_, --, 
   {{0xee70a002,0x6c2ba00e,0x00000000,0x00000000}},	//   _треба__да_, _místě_, --, --, 
   {{0x8053200e,0x829d6003,0x00000000,0x00000000}},	//   _sportovn, _བྱེད__ཐུབ_, --, --, 
   {{0xe3e6e00e,0xff25602e,0xbf53401d,0x12ac800b}},	//   _být_, _profil__pošalji_, _baru__pertanya, _abagize__leta_, 
   {{0x0472e019,0xcc72e012,0x5f78400b,0x00000000}},	//   _meget__god_, _hlavná_, _abacaman, --, 
   {{0x8e154021,0xb2924019,0xfc744034,0x00000000}},	//   _བསྐྱོད_, _snakker_, _albumet_, --, 
   {{0xe443e026,0x6c0c600a,0x7edc8002,0x00000000}},	// [630] _okt_, _जोधपुर__नई_, _преводил_по_, --, 
   {{0x2477c034,0x00000000,0x00000000,0x00000000}},	//   _trygd__og_, --, --, --, 
   {{0x12d8c011,0xa2d8600d,0x7465600b,0x64b58018}},	//   _poden_, _poner_, _aba__mu_, _qualidad_de_, 
   {{0xe8e60002,0xa32ae00f,0xfdbfe006,0x7485600b}},	//   _библиогр_подаци_, _upawulu__wabhala_, _གྲུབ__འབྲེས_, _umuyoboz_wa_, 
   {{0xf6f28002,0x4bd98003,0x00000000,0x00000000}},	//   _покреће_, _རབས__ལོ_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2290c01d,0x9e7b8018,0x00000000,0x00000000}},	//   _sedar_, _preços__válidos_, --, --, 
   {{0x03206004,0x6e7a4011,0xea33600c,0x82b2a037}},	//   _kunye_, _termos__adiciona, _कहत_, _mercadol_cómo_, 
   {{0xdc9e4016,0x5d46a00b,0x1328c00f,0x00000000}},	//   _dette__forumet_, _yabaye__umupatir, _lapho__ujehova_, --, 
   {{0x030b600f,0x7eb3e002,0x00000000,0x00000000}},	//   _noma__ingabe_, _могу__се_, --, --, 
   {{0x77c9400a,0x00000000,0x00000000,0x00000000}},	//   _बांदा__बाराबंकी_, --, --, --, 
   {{0x733de009,0xcc56400a,0x92e5400f,0x00000000}},	//   _har__fået_, _खोजें_, _lesi__simo_, --, 
   {{0x926c0004,0x97292018,0x26f6e00c,0x00000000}},	//   _apho_, _ilustraç, _बोलवले_, --, 
   {{0x43312016,0x7ee3e027,0x00000000,0x00000000}},	//   _annonse__annonse_, _aký_, --, --, 
   {{0xe443e004,0x00000000,0x00000000,0x00000000}},	//   _oku_, --, --, --, 
   {{0x74b7c01f,0x8ec12002,0x5496800b,0xe44d8017}},	//   _surah__al_, _скочи_, _no__yet_, _vč_, 
   {{0x12d8a024,0x53f8a040,0xebfa0003,0xcea5a00b}},	// [640] _dece_, _decu_, _བུ__མོ_, _urutonde_, 
   {{0xeb9d400c,0x00000000,0x00000000,0x00000000}},	//   _मालवा__के_, --, --, --, 
   {{0x3ad9c00a,0xdcaae00c,0x00000000,0x00000000}},	//   _बहराइच__बागपत_, _कि__चेरो_, --, --, 
   {{0xe3eac012,0x72c76002,0x00000000,0x00000000}},	//   _sveta_, _за__децу_, --, --, 
   {{0xfd22200e,0x00000000,0x00000000,0x00000000}},	//   _se__zpět_, --, --, --, 
   {{0xcc048014,0x00000000,0x00000000,0x00000000}},	//   _कुमार__झा_, --, --, --, 
   {{0xebb7a00c,0x735fa00b,0x12de2037,0xd71b2002}},	//   _होखे__के_, _abagore_, _ver__otros_, _спорт_, 
   {{0xd6e40011,0xe442c01a,0xc3a34028,0x00000000}},	//   _ir__navegaci, _gje_, _acepto_, --, 
   {{0xdb82c002,0x42a6000f,0x934de00c,0x00000000}},	//   _poruke__tekstova_, _esibi_, _इहो__कहनी_, --, 
   {{0x8a33600a,0xdbe00009,0x2a38e002,0x9c90c009}},	//   _कहा_, _accepter, _ће__бити_, _tilfælde_, 
   {{0x32c2a01a,0xe3bc2018,0x27f2e003,0x00000000}},	//   _ein__skal_, _com__mais_, _བྱེད__ཀྱིན_, --, 
   {{0x7ab0000a,0x82436003,0xb6f1c002,0x00000000}},	//   _सकते__हैं_, _ཕྲན_, _влада__србије_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x635d0039,0xd2bca003,0x769fc002,0x00000000}},	//   _bingung_, _པོ__ཡིན_, _едикта_, --, 
   {{0x82918011,0x32c22010,0xc2f7e009,0xc32c600e}},	//   _xeral_, _der__skal_, _bedøm__firmaet_, _straně_, 
   {{0x0bdbe00a,0x7741e00a,0x00000000,0x00000000}},	//   _उपलब्ध__है_, _औज़ार__खाता_, --, --, 
   {{0xa6ffa00c,0x00000000,0x00000000,0x00000000}},	// [650] _एकरा_, --, --, --, 
   {{0x02d8e009,0x32948014,0xfbba6003,0x00000000}},	//   _nogen_, _विनोबा_, _དེ__ཚོ_, --, 
   {{0x1200e03c,0x4f20e01d,0x00000000,0x00000000}},	//   _zenica_, _perubata, --, --, 
   {{0x22488004,0x7c7ba00a,0x8bc0c00a,0x29d0c002}},	//   _kwam_, _करने__वाले_, _होने__का_, _неким_, 
   {{0x72a12012,0x5c9a6037,0x42d8e010,0xa25e4003}},	//   _pravidlá_, _noviembr_octubre_, _bogen_, _ལྕེ__བོད_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x328d6007,0x00000000,0x00000000,0x00000000}},	//   _beliau__berkata_, --, --, --, 
   {{0x940b0019,0x4443e00b,0xd288800f,0x21b9e00c}},	//   _ikke__minst_, _uku_, _iziphi__ezinye_, _भागल_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x04968038,0x04c3001a,0x52d8c015,0x244e0011}},	//   _no__teu_, _vert__det_, _gede_, _artigos__editar_, 
   {{0x82488007,0xc24c2006,0xb464200f,0x44130002}},	//   _awam_, _ཊེཊ_, _kuphela__uma_, _почела_, 
   {{0xbf64001d,0x2ba2c00c,0x00000000,0x00000000}},	//   _kemaskin, _एह__पऽ_, --, --, 
   {{0x526dc02c,0x4c3b400c,0x00000000,0x00000000}},	//   _urwo_, _ओही__तरे_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6c5d4018,0x00000000,0x00000000,0x00000000}},	//   _cartão_, --, --, --, 
   {{0x22c4000a,0x00000000,0x00000000,0x00000000}},	//   _का__इस्तेमाल_, --, --, --, 
   {{0xabc0200a,0x0be20020,0x48cca008,0x644a8028}},	// [660] _करने__की_, _འདི__ནང_, _enfermid, _imágenes__de_, 
   {{0x1328c00f,0x00000000,0x00000000,0x00000000}},	//   _futhi__ujehova_, --, --, --, 
   {{0x0b8f2013,0x92232015,0x82bb2018,0xf2a6800b}},	//   _है_, _lengkap__topik_, _em__caso_, _izaba_, 
   {{0xca4ea00a,0x00000000,0x00000000,0x00000000}},	//   _का__आयोजन_, --, --, --, 
   {{0xf2d9801a,0x00000000,0x00000000,0x00000000}},	//   _noreg_, --, --, --, 
   {{0x54aec00b,0x26224027,0x00000000,0x00000000}},	//   _hirya__no_, _narodeni, --, --, 
   {{0xe2bdc003,0x1225e00f,0xdc51e008,0x54bae009}},	//   _ཚེ__རིང_, _nsuku_, _mantida_, _tvivl__om_, 
   {{0x38282002,0x00000000,0x00000000,0x00000000}},	//   _центра_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x238e200d,0xe4b1400b,0x00000000,0x00000000}},	//   _de__acuerdo_, _ibiro__by_, --, --, 
   {{0xd2b2e006,0x89a9c00d,0x6b36a006,0x73f5c00b}},	//   _ཚན__སྐད_, _de__cualquie, _བརྡ__གཞུང_, _ibirimo__byose_, 
   {{0x9502e04e,0xc2d0200b,0x72a6800b,0x00000000}},	//   _अनुभव_, _ko__abantu_, _azaba_, --, 
   {{0xd9bf8014,0x00000000,0x00000000,0x00000000}},	//   _लक्ष्मीन, --, --, --, 
   {{0xe3ce001a,0x3310c00e,0x9b21c018,0x00000000}},	//   _driv_, _přidat__upravit_, _comprime, --, 
   {{0x62c2800c,0x00000000,0x00000000,0x00000000}},	//   _के__हुकुम_, --, --, --, 
   {{0x62d8c008,0x44956009,0x9a44400c,0x50f3c00c}},	//   _podes_, _og__af_, _बात__साफ_, _लगावल_, 
   {{0x7c51c00e,0x970fc00a,0x4ed5600a,0x00000000}},	// [670] _kultura_, _मुरादाबा_महाराजगं, _छांटें_, --, 
   {{0xa2fc201a,0xc4764037,0x91156009,0x0290e025}},	//   _innhald_, _deja__un_, _netværk_, _pegar_, 
   {{0xf4aec00a,0xb326e012,0xf2b5200e,0xdeba8002}},	//   _इसके__द्वारा_, _podmienk_predaja_, _abych_, _персијск_пољски_, 
   {{0x927f600b,0xe2438003,0x2a27a002,0x0fee4002}},	//   _uganda_, _ཁྲན_, _пријавит, _управљањ, 
   {{0xa386c025,0xb5578011,0x237d400b,0x00000000}},	//   _quer_, _de__febreiro_, _rusange_, --, 
   {{0xe3e7000e,0x00000000,0x00000000,0x00000000}},	//   _pát_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xebb36013,0x00000000,0x00000000,0x00000000}},	//   _विकिपीडि_के_, --, --, --, 
   {{0x58c6c004,0x2311800f,0xf284c003,0x00000000}},	//   _iintlang, _ngani__ngoba_, _མཆན__ཞོག_, --, 
   {{0x9278a006,0xbbefa017,0x00000000,0x00000000}},	//   _བརྒྱའི__དུས_, _pardubic, --, --, 
   {{0xaf5a2018,0x8395200e,0x00000000,0x00000000}},	//   _pesquisa, _hlasů_, --, --, 
   {{0xd628c006,0xac9a2003,0xab30c002,0x82dda00f}},	//   _གསརཔ_, _སྐུལ_, _његов_, _abanye__baye_, 
   {{0xebe8600c,0x00000000,0x00000000,0x00000000}},	//   _प्रसाद__के_, --, --, --, 
   {{0x9be5c006,0x2e324009,0x4afc2012,0x82cb600f}},	//   _སྤེལ__ལས_, _brugerna, _priezvis, _iyiphi__indlela_, 
   {{0xbc4f4013,0x23eac024,0x92f3c028,0xe410e00f}},	//   _अपने_, _svetu_, _el__nombre_, _kanjani__ukuthi_, 
   {{0x02a3e003,0x00000000,0x00000000,0x00000000}},	// [680] _ཀྱི__ཡོད_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x4200c01a,0x83c3000f,0xa6102012,0x00000000}},	//   _blei_, _ngisho__nalapho_, _hľadám_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xf291801f,0xa2bd001d,0xa335401f,0xddbe400b}},	//   _perak_, _bukan__sahaja_, _malaysia__yang_, _karidina, 
   {{0x727f000f,0x00000000,0x00000000,0x00000000}},	//   _phansi_, --, --, --, 
   {{0x4200600d,0x6a55400a,0x83866025,0x00000000}},	//   _julio_, _इस__तरह_, _pior_, --, 
   {{0x1c3f400f,0x00000000,0x00000000,0x00000000}},	//   _ngaphans, --, --, --, 
   {{0xd344400e,0x624c4003,0x3297a00d,0xc243c00f}},	//   _recenze_, _ཅེས_, _la__forma_, _umusa__wakhe_, 
   {{0xb442000f,0xf496e00d,0x0bcfe00a,0x82126018}},	//   _ami_, _no__me_, _किया__है_, _senha_, 
   {{0xe496e00d,0xb320000b,0x00000000,0x00000000}},	//   _no__le_, _ariyo_, --, --, 
   {{0x64444012,0x7c74c00a,0x2ea7a002,0x2b9d8003}},	//   _ak_, _हैं__हमने_, _чији__је_, _འདུག__ཆབ_, 
   {{0x6be0a00a,0xc291a003,0xd279a00f,0x00000000}},	//   _और__भी_, _བོན__གྱི_, _inkulumo__ethi_, --, 
   {{0xdd9a2029,0xffc5e012,0xddfa2003,0x00000000}},	//   _སྐྱེ_, _užitočné_, _སྐྱོ_, --, 
   {{0x94444009,0x92126018,0xf345800c,0x00000000}},	//   _dk_, _tenha_, _नाम__भोजपुरी_, --, 
   {{0x33ab0015,0x0c9b801a,0x9765400a,0x114dc002}},	//   _daftar__lengkap_, _dei__første_, _ब्लॉग__परिवार_, _проблема_, 
   {{0x4dc1e005,0xa24e4003,0x00000000,0x00000000}},	// [690] _politika, _ལངས_, --, --, 
   {{0x1496e009,0x00000000,0x00000000,0x00000000}},	//   _os__med_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xc764600a,0x00000000,0x00000000,0x00000000}},	//   _हिन्दी__विकिपीडि, --, --, --, 
   {{0x7a4e800a,0x8f640002,0x00000000,0x00000000}},	//   _गए__हैं_, _економиј, --, --, 
   {{0x92ba4015,0xedd62002,0xbc4f600a,0x00000000}},	//   _kondisi_, _све__што_, _आपने_, --, 
   {{0x624c4029,0xd3eae015,0x230b2012,0x127fa00e}},	//   _ཆེས_, _kontak_, _mesiacov_, _srpna_, 
   {{0xea48e00a,0x00000000,0x00000000,0x00000000}},	//   _स्टाइल__शीट_, --, --, --, 
   {{0xc2872012,0xd243a003,0x00000000,0x00000000}},	//   _funkcie_, _གིན_, --, --, 
   {{0xaa93c002,0x82ba600e,0x00000000,0x00000000}},	//   _подели_, _prodeji_, --, --, 
   {{0x5200600d,0x016e8022,0x00000000,0x00000000}},	//   _junio_, _रचनात्मक_, --, --, 
   {{0x84444027,0x7f63e031,0x00000000,0x00000000}},	//   _sk_, _kumpulka, --, --, 
   {{0xcd65600b,0x0c01000a,0x00000000,0x00000000}},	//   _byose__urupapur, _पेज__को_, --, --, 
   {{0x72d9000f,0x025a000e,0x049c000e,0xe277000f}},	//   _neze_, _tohle_, _vybírat_, _bakhe__futhi_, 
   {{0x5496e00d,0x12fe601d,0x00000000,0x00000000}},	//   _no__se_, _orang__melayu_, --, --, 
   {{0x1e7ea011,0x972c0014,0x57aca003,0x00000000}},	//   _unha__organiza, _रोड़ा_, _མི__བྱེད_, --, 
   {{0x7300a037,0x00000000,0x00000000,0x00000000}},	// [6a0] _erróneo_, --, --, --, 
   {{0x7e9a4002,0x00000000,0x00000000,0x00000000}},	//   _што__се_, --, --, --, 
   {{0xa2968003,0x00000000,0x00000000,0x00000000}},	//   _ཆོས__མཛད_, --, --, --, 
   {{0x6496e028,0xa320200b,0x120e2002,0x6cd6c002}},	//   _no__te_, _kujya_, _нама_, _српских_, 
   {{0xdc74a02a,0xc7c72018,0x1b9c201c,0x0cec2012}},	//   _forumet_, _mensagem_, _की__एक_, _fanúšiko, 
   {{0x1aa4a00b,0x00000000,0x00000000,0x00000000}},	//   _ku__birebana_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x60b6400f,0x1302a00f,0x00000000,0x00000000}},	//   _phambi__kukajeho, _kubalule_kakhulu_, --, --, 
   {{0x63f9002c,0xb6826014,0x438a4018,0x00000000}},	//   _yezu_, _झुकाव_, _simplesm, --, 
   {{0xc225600f,0x22020039,0x5dca8002,0xf8348002}},	//   _ngakho_, _posisi_, _август__јул_, _културе_, 
   {{0xcba00013,0x00000000,0x00000000,0x00000000}},	//   _एक__ही_, --, --, --, 
   {{0x6fc7800f,0x00000000,0x00000000,0x00000000}},	//   _ngokuham_kwesikha, --, --, --, 
   {{0x7274c039,0xf4182018,0x6b82e003,0xf764e013}},	//   _bisa__jadi_, _uma__conta_, _སྲིད__གཞུང_, _पार्टनर_, 
   {{0x12c84039,0xf6b7a009,0x00000000,0x00000000}},	//   _tentu__saja_, _forældre_, --, --, 
   {{0x7d5fc022,0x0a6d400a,0x00000000,0x00000000}},	//   _इकाई_, _वेबसाइट__में_, --, --, 
   {{0xc2b2000b,0x00000000,0x00000000,0x00000000}},	//   _hafi__abantu_, --, --, --, 
   {{0x921fc00e,0x00000000,0x00000000,0x00000000}},	// [6b0] _téměř_, --, --, --, 
   {{0x022ac002,0xd2270002,0x00000000,0x00000000}},	//   _могао_, _њихове_, --, --, 
   {{0x49e0c007,0x00000000,0x00000000,0x00000000}},	//   _menghant, --, --, --, 
   {{0x65764018,0x00000000,0x00000000,0x00000000}},	//   _publicaç, --, --, --, 
   {{0x1a10401f,0x4ecb001d,0x00000000,0x00000000}},	//   _malaysia_, _mesyuara, --, --, 
   {{0xd2946006,0x32438003,0x00000000,0x00000000}},	//   _ཡོངས__སྐད_, _གཡག_, --, --, 
   {{0xc33bc00f,0xd254a00b,0x00000000,0x00000000}},	//   _ngaleyo__ndlela_, _wa__kabiri_, --, --, 
   {{0xed21600b,0xc933c002,0x00000000,0x00000000}},	//   _yakomeje_, _можемо_, --, --, 
   {{0x51e1600a,0x4ee1a018,0x00000000,0x00000000}},	//   _दूसरी_, _procurar__produtos_, --, --, 
   {{0xebc9600c,0x00000000,0x00000000,0x00000000}},	//   _खराबी__के_, --, --, --, 
   {{0xe2d0200b,0xec12600c,0x00000000,0x00000000}},	//   _umva__reba_, _इंडियन__के_, --, --, 
   {{0x085de010,0x4265800f,0x97848002,0x00000000}},	//   _fotoalbu, _futhi__manje_, _белоруск_бошњачки_, --, 
   {{0x72126018,0x00000000,0x00000000,0x00000000}},	//   _tenho_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xab7b8017,0x43e76009,0x00000000,0x00000000}},	//   _rekonstr, _sæt_, --, --, 
   {{0x1eccc011,0x00000000,0x00000000,0x00000000}},	//   _ligazóns__externas_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [6c0] --, --, --, --, 
   {{0xcc60c039,0x3dfc0003,0xe244000f,0x00000000}},	//   _temukan_, _མི__དམངས_, _nendodan_yakhe_, --, 
   {{0xea892012,0x23cf8009,0xe2888003,0x0c85800c}},	//   _inzeráto, _farve_, _ལེགས__བཤད_, _के__चार्टर_, 
   {{0x53e76009,0x0e9c6002,0xba63e00a,0x5255a00a}},	//   _tæt_, _везаних__за_, _जुलाई__जून_, _बीजेपी_, 
   {{0x3aa3e00b,0x00000000,0x00000000,0x00000000}},	//   _ya__ekleziya_, --, --, --, 
   {{0xa2246040,0xd2ba6013,0x73ed000b,0xf2a30003}},	//   _skok_, _पाएं_, _gisanzwe__giharwe_, _བྱས__ཤིང_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xf2d8c02a,0x03d7201a,0xf4a5000b,0x1cfca003}},	//   _hodet_, _og__meir_, _agira__ati_, _རང__གྲོལ_, 
   {{0x3c02c003,0x6b71600c,0x00000000,0x00000000}},	//   _ཨེ__ཤེ_, _के__केतना_, --, --, 
   {{0x448cc009,0x8a4d800c,0x00000000,0x00000000}},	//   _masser__af_, _के__महल_, --, --, 
   {{0x7291801a,0x32bbc01d,0xaa77400c,0x00000000}},	//   _åra_, _ibu__bapa_, _भारत__अउर_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x4e39e029,0x12c02002,0x00000000,0x00000000}},	//   _རྒྱལ__སྤྱིའི_, _онда_, --, --, 
   {{0x92fba00b,0x761a800c,0x00000000,0x00000000}},	//   _imihoho_, _खातिर__भारत_, --, --, 
   {{0x52ae4003,0x32d9c018,0x00000000,0x00000000}},	//   _གཙོའོ__ཤེས_, _jovem_, --, --, 
   {{0x8f1fa028,0x846c6025,0x3e2de002,0x480d0003}},	//   _particip, _com__os_, _да__није_, _ཐོ__བདེན_, 
   {{0xebf7a00c,0x32dfe00c,0x00000000,0x00000000}},	// [6d0] _पुणे__के_, _शाहाबाद__गजेटियर_, --, --, 
   {{0x2ab1c004,0x3beea00c,0x00000000,0x00000000}},	//   _ngexesha_, _तऽ__एह_, --, --, 
   {{0xa46c6025,0xb985800b,0x00000000,0x00000000}},	//   _com__as_, _umukobwa_, --, --, 
   {{0xdaabc00c,0x00000000,0x00000000,0x00000000}},	//   _एहू__बेर_, --, --, --, 
   {{0x727d6012,0x00000000,0x00000000,0x00000000}},	//   _špeciáln, --, --, --, 
   {{0x726d8018,0xc0be2003,0x00000000,0x00000000}},	//   _isso_, _དང__རྒྱ_, --, --, 
   {{0x73f9800e,0x00000000,0x00000000,0x00000000}},	//   _korun_, --, --, --, 
   {{0x42d9c027,0x00000000,0x00000000,0x00000000}},	//   _novej_, --, --, --, 
   {{0x9260c00d,0x0be7e006,0xc28d2003,0x00000000}},	//   _años_, _བཟོ__ནང_, _ཆེན__གྱི_, --, 
   {{0xc4454011,0xa3a4a037,0x1224801d,0x4344c011}},	//   _deixar__un_, _febrero__enero_, _akak_, _receita__século_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x3366a015,0xb4b6a009,0x5ec20045,0x00000000}},	//   _tanggal_, _mulighed__at_, _podnikan, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6a6ee00b,0x00000000,0x00000000,0x00000000}},	//   _ubufasha_, --, --, --, 
   {{0x324ba00c,0xd7d0c002,0x00000000,0x00000000}},	//   _जिजेले_, _снаге_, --, --, 
   {{0x84bac009,0xcae70003,0x00000000,0x00000000}},	//   _lige__nu_, _སྐྱོང__མཆོག_, --, --, 
   {{0xb430a018,0xe960a00a,0x00000000,0x00000000}},	// [6e0] _desconto_, _इस__वेबसाइट_, --, --, 
   {{0xc3174024,0x55c3e00f,0x8373001a,0x3709c002}},	//   _zvezde_, _sonke__isikhath, _einaste_, _великим_, 
   {{0x6c138011,0x02ca0009,0xdb320011,0x2ecdc002}},	//   _teu__comentar, _hvid_, _unha__emprende, _их__је_, 
   {{0x1c3f8002,0x00000000,0x00000000,0x00000000}},	//   _српски__народ_, --, --, --, 
   {{0xdf9c000e,0x22de6012,0x00000000,0x00000000}},	//   _ceny__vybrané_, _prázdny__zoznam_, --, --, 
   {{0x62c7e00b,0x62e6800c,0xebd6c00c,0xa2efe00b}},	//   _ruboneka__neza_, _तलाश__जारी_, _जिजेले__के_, _ngufu_, 
   {{0x1e00e039,0x0bb9200a,0xda3da014,0x00000000}},	//   _kesehata, _हैं__और_, _धरम_, --, 
   {{0x6a3ca022,0x00000000,0x00000000,0x00000000}},	//   _रुप_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x5236c012,0x00000000,0x00000000,0x00000000}},	//   _svojom_, --, --, --, 
   {{0xc83c201a,0xad530002,0x00000000,0x00000000}},	//   _heimesid, _румунски_, --, --, 
   {{0x7394a012,0xe4786011,0x02fa400c,0x00000000}},	//   _mieste_, _xunta__es_, _गो__सत्र_, --, 
   {{0xf2430029,0x7bf9800f,0x9c19800f,0x1bace003}},	//   _མཁན_, _ngalokho_, _ngalokhu_, _ནང__ནས_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xc634a009,0x99a5e011,0x58470003,0x00000000}},	//   _nuværend, _por__primeira_, _ཏེ__སྤྱི_, --, 
   {{0x13a68011,0x62d8e009,0xebfd400c,0x1edc8016}},	//   _páxina_, _noget_, _चैनल__के_, _trenger__nærheten_, 
   {{0x127f402f,0x3c06c00c,0x00000000,0x00000000}},	// [6f0] _apenas_, _सकत__बा_, --, --, 
   {{0x6386c016,0x12a1a006,0xad4bc00f,0x00000000}},	//   _sier_, _ཤོམ__སྦེ_, _isixuku__esikhulu_, --, 
   {{0x6240200b,0x9a1dc018,0x00000000,0x00000000}},	//   _yaturiki_hafi_, _email__você_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xe2d86016,0x00000000,0x00000000,0x00000000}},	//   _innen_, --, --, --, 
   {{0x84954038,0x8253a002,0xd85aa003,0x00000000}},	//   _século__xix_, _адресе__интернет_, _བསྒྱུར__སྒྲིག_, --, 
   {{0xa320000e,0x526e000b,0x00000000,0x00000000}},	//   _výběr_, _siporo_, --, --, 
   {{0x0368c011,0x805d8012,0xc2c8000f,0x9bb90003}},	//   _linguas_, _nachádza_, _ngandlel_thile_, _དུ__མི_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x4340e015,0x00000000,0x00000000,0x00000000}},	//   _telepon_, --, --, --, 
   {{0xa8ec2002,0x831b400f,0xbe974018,0x3290e012}},	//   _условима__могући_, _amakrist_eqiniso_, _novament_desculpe_, _trnava_, 
   {{0x93c08016,0x1b37c003,0x00000000,0x00000000}},	//   _les__avisen_, _ཤེས__རྟོགས_, --, --, 
   {{0x62d8602a,0xebd3a014,0xa2836003,0x00000000}},	//   _annen_, _विरोध__के_, _མཁན__ཞིག_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xfb8dc022,0xbc75000c,0x00000000,0x00000000}},	//   _जद_, _राज्यन_, --, --, 
   {{0x42f7a011,0x00000000,0x00000000,0x00000000}},	// [700] _ás__horas_, --, --, --, 
   {{0xfe12e011,0xe28d400f,0x8f508002,0x00000000}},	//   _marca__rexistra, _hebheru_, _да__смо_, --, 
   {{0xe273e015,0x2292602c,0xd297a011,0x845ca00f}},	//   _bisa__menambah_, _gatanu_, _dos__nosos_, _ekuphile_kwethu_, 
   {{0x32fce009,0x00000000,0x00000000,0x00000000}},	//   _indhold_, --, --, --, 
   {{0x843e802a,0x3d5ea00a,0x00000000,0x00000000}},	//   _ikke__ansvar_, _भेजें__अस्वीकरण_, --, --, 
   {{0x51f4600f,0x00000000,0x00000000,0x00000000}},	//   _izithuny_zevangel, --, --, --, 
   {{0x84ff6004,0x6395200e,0x00000000,0x00000000}},	//   _elimiwey, _vlasů_, --, --, 
   {{0x13e7c00e,0xeb9fc025,0x026f6003,0xd24e4003}},	//   _mít_, _dinheiro_, _དྲ__གནས_, _རྫས_, 
   {{0x475fc00c,0x00000000,0x00000000,0x00000000}},	//   _करत__बाड़े_, --, --, --, 
   {{0x67a84012,0x00000000,0x00000000,0x00000000}},	//   _odpovedz_, --, --, --, 
   {{0x22d98009,0xdb8d603a,0x440c600e,0x00000000}},	//   _mere_, _ཙམ_, _aktuální_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xb674000f,0x00000000,0x00000000,0x00000000}},	//   _esihlokw, --, --, --, 
   {{0x4598601c,0xbc020014,0x00000000,0x00000000}},	//   _व्रत_, _फीसदी__तक_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x56146002,0xc49f0018,0x00000000,0x00000000}},	// [710] _uslovi__korišćen, _você__tem_, --, --, 
   {{0x86cba00c,0x00000000,0x00000000,0x00000000}},	//   _पसंद__नापसंद_, --, --, --, 
   {{0x92d98016,0x1bb2c00a,0xf4c7a002,0xce09e00d}},	//   _dere_, _नहीं__कर_, _са__сличним_, _la__búsqueda_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x0a8b800c,0x00000000,0x00000000,0x00000000}},	//   _मामला__में_, --, --, --, 
   {{0x3e356030,0x26798011,0x938f000e,0x3cbe0002}},	//   _koristit_programe_, _cultura__educació, _cestován, _нашег_, 
   {{0x02a46003,0x00000000,0x00000000,0x00000000}},	//   _གྱི__ཡོད_, --, --, --, 
   {{0x33f9800f,0x8290e015,0x64b40011,0x1c6d2040}},	//   _jesu_, _nggak_, _conselle_de_, _verujem_, 
   {{0x0fae0002,0x00000000,0x00000000,0x00000000}},	//   _наука_, --, --, --, 
   {{0xc2368028,0x00000000,0x00000000,0x00000000}},	//   _abajo_, --, --, --, 
   {{0x1250600e,0xc506c00a,0xa61d4003,0x92a30003}},	//   _délka_, _देवरिया__नोएडा_, _དེབ__དཔྱད_, _སྤྱོད__མིང_, 
   {{0x4317e009,0x32d98011,0x9293401a,0x32954012}},	//   _at__holde_, _nese_, _ynskjer_, _hľadanie_, 
   {{0x5eb8e002,0x22f6200c,0x00000000,0x00000000}},	//   _ни_, _के__चाहीं_, --, --, 
   {{0x32de8011,0xf5322002,0x0ef3c00f,0x00000000}},	//   _ver__foto_, _грчки__италијан, _inkosi__usolomon, --, 
   {{0x72d9800f,0x5c0b002e,0x64704018,0x6497a018}},	//   _bese_, _obiteljs, _senha__de_, _opções__de_, 
   {{0xb79ac021,0x42d9c00d,0x00000000,0x00000000}},	//   _འཐོན_, _joven_, --, --, 
   {{0x8cb7a00a,0x7e736002,0x00000000,0x00000000}},	// [720] _में__आपके_, _пет_, --, --, 
   {{0xfbe8a006,0x7de54003,0x1dac2003,0x00000000}},	//   _ཀང__པར_, _ཀྱི__ཚོགས_, _རྩོམ__བཏུས_, --, 
   {{0xb2d9801a,0xdeed0018,0x643d8020,0xe282200f}},	//   _vere_, _melhores_, _རོབ__རྒྱལ_, _njalo__lapho_, 
   {{0xc2d86016,0x00000000,0x00000000,0x00000000}},	//   _annet_, --, --, --, 
   {{0xadd98012,0xa2004012,0xf4370015,0x2b8d8003}},	//   _deň_, _boli_, _di__lintas_, _ངམ_, 
   {{0x32d98009,0xe0f88014,0x825ae00e,0xcc6f800a}},	//   _vores_, _के__सचिव_, _mailem_, _है__इसमें_, 
   {{0x332b2009,0x23f9800b,0xb3e0400e,0x452da002}},	//   _om__synes_, _yesu_, _dítě_, _са__својим_, 
   {{0x5a6b600a,0xb247000b,0x84f4800a,0x00000000}},	//   _अगर__ऐसा_, _biciwe__muri_, _इसे__स्टाइल_, --, 
   {{0x84730013,0x00000000,0x00000000,0x00000000}},	//   _अन्ना_, --, --, --, 
   {{0x23fa2015,0x12d5800e,0x94428039,0xd2a5600e}},	//   _dan__langsung_, _než__méně_, _sma_, _publikov_nebo_, 
   {{0xaa2d8038,0xfc4c000e,0x426b000f,0x00000000}},	//   _texto__está_, _střední_, _bheka__ibhokisi_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6bae800a,0xc20f8039,0x7d0b401c,0x00000000}},	//   _कोई__भी_, _sumber__berita_, _प्रबंधन_, --, 
   {{0x124c4003,0x4320200b,0xa2390002,0x00000000}},	//   _ཆེད_, _mujyi_, _току_, --, 
   {{0xbdf9c00e,0x5c56200a,0x00000000,0x00000000}},	//   _užívání_, _चुनें_, --, --, 
   {{0xb4428018,0x932ca018,0x00000000,0x00000000}},	//   _uma_, _ou__crie_, --, --, 
   {{0xcee8400f,0xc29e0003,0x62a46003,0x00000000}},	// [730] _kwakufan, _སྤྱི__པའི_, _སྲོལ__བཟོ_, --, 
   {{0xbbcd000a,0xe2f5200c,0x2c948003,0x00000000}},	//   _स्टोरी__पर_, _भोज__कहां_, _སློབ__གསོའི_, --, 
   {{0xcc57200a,0xa2aee003,0xecb04011,0x6cabe00b}},	//   _इसमें_, _བྱ__དགའ_, _na__coruña_, _muri__amerika_, 
   {{0x6f8be00e,0x00000000,0x00000000,0x00000000}},	//   _svém_, --, --, --, 
   {{0x4212a00d,0x6b8fa003,0xb4ad6012,0x5a08a00e}},	//   _fecha_, _ཡག_, _len__pre_, _nebo__zaregist, 
   {{0x633c600d,0x00000000,0x00000000,0x00000000}},	//   _es__posible_, --, --, --, 
   {{0x7361800c,0x00000000,0x00000000,0x00000000}},	//   _विकास__खाती_, --, --, --, 
   {{0xeb9ce022,0x8b540005,0x00000000,0x00000000}},	//   _प्रदेश__के_, _til__dokument, --, --, 
   {{0xebde0022,0x8f2dc031,0x4feb403d,0x00000000}},	//   _हाल__के_, _sepertin, _webových_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2350000b,0xe24e8018,0xa242e003,0xfb9f600c}},	//   _amafoto_, _comentár_aqui_, _ཐམས_, _भोजपुरी__से_, 
   {{0x6200e015,0xf297e038,0x8107e003,0x00000000}},	//   _bugil_, _dos__novos_, _ངོ__སྤྲ_, --, 
   {{0xc9f64012,0x76d0400a,0x9afc6002,0x00000000}},	//   _štát_, _जानिए_, _емаил__адресе_, --, 
   {{0x54b2c037,0x1a5fe00b,0x00000000,0x00000000}},	//   _mercadol_no_, _imperuka_, --, --, 
   {{0x4a32a00c,0x5328c02a,0xe2612018,0x00000000}},	//   _गइल_, _er__åpen_, _mãos_, --, 
   {{0x92d8c009,0x333b401a,0x6a5d600a,0x00000000}},	// [740] _inden_, _kategori_fødde_, _लाइफस्टा_अलग_, --, 
   {{0x54784037,0xbb60800a,0x00000000,0x00000000}},	//   _temas__no_, _लगाने_, --, --, 
   {{0x4a32801c,0x0e39401d,0x9783a00a,0x00000000}},	//   _खेल_, _kemahira, _यहाँ__क्या_, --, 
   {{0x4236c024,0xf45c601a,0xa3e0400e,0x0ba7e003}},	//   _nadji_, _sjå__òg_, _sítě_, _ཕྱི__ནང_, 
   {{0xc3e92018,0x00000000,0x00000000,0x00000000}},	//   _resoluçã, --, --, --, 
   {{0x2cf4c00e,0x6a4ca00c,0x00000000,0x00000000}},	//   _jiří_, _कर__जमा_, --, --, 
   {{0x0e824002,0x5ed18002,0x00000000,0x00000000}},	//   _гу__за_, _македонс_норвешки_, --, --, 
   {{0x0a6e600a,0x00000000,0x00000000,0x00000000}},	//   _रुपए__में_, --, --, --, 
   {{0xe4626019,0x5ed54025,0x3a4be00c,0x00000000}},	//   _bør__du_, _dos__clientes_, _के__लेल_, --, 
   {{0x12d8c009,0x00000000,0x00000000,0x00000000}},	//   _anden_, --, --, --, 
   {{0x533f400c,0x00000000,0x00000000,0x00000000}},	//   _ना__खाली_, --, --, --, 
   {{0xf68ca00a,0x38f4c00a,0x73470011,0x00000000}},	//   _प्यार_, _कॉमेंट्स_, _da__lingua_, --, 
   {{0xb320000b,0x83f40018,0x00000000,0x00000000}},	//   _nshya_, _postar_, --, --, 
   {{0x78c18015,0xf3270009,0x00000000,0x00000000}},	//   _dalam__tokobagu, _procent_, --, --, 
   {{0x6d1dc003,0x2e88e002,0x00000000,0x00000000}},	//   _ཆོས__འཁོར_, _могао__ла_, --, --, 
   {{0x027e401a,0xe47aa012,0x00000000,0x00000000}},	//   _namn_, _kliknite__na_, --, --, 
   {{0x5a32a022,0x04a18005,0x0bbf4003,0x5dcd800f}},	// [750] _गेल_, _når__ein_, _བརྒྱུད__ནང_, _unyaka__ngamunye_, 
   {{0x02754015,0x00000000,0x00000000,0x00000000}},	//   _pemberit_bagi_, --, --, --, 
   {{0x3b69e011,0xab8ac00f,0x0a62e00f,0x00000000}},	//   _ligazón_, _izingubo_, _ka__abrahama_, --, 
   {{0x84956005,0x32d9c02f,0x329c8003,0xd3ef200f}},	//   _og__eg_, _leve_, _མགོན__ཆེན_, _kuleyo__ndawo_, 
   {{0x823d8039,0x0e662002,0x3a38a003,0x00000000}},	//   _bagian__dari_, _канцелар_за_, _ཀེ__ཐོའི_, --, 
   {{0x35dae006,0x128f4003,0x00000000,0x00000000}},	//   _རྐྱབ_, _སྨད__བློ_, --, --, 
   {{0x7b8fc003,0x4466800f,0x6462e018,0x01dde002}},	//   _ཤག_, _ukwazisw_okwengez, _serviço__de_, _корисна__места_, 
   {{0x62898006,0x00000000,0x00000000,0x00000000}},	//   _ཚུགསཔ__བཟོ_, --, --, --, 
   {{0x8255a01e,0xc3006011,0xc27fc011,0x7ba22003}},	//   _kantonal, _datos__citar_, _vez__máis_, _བཅོས__རང_, 
   {{0x7a6e800a,0xdfd64012,0x3aa5a00a,0x00000000}},	//   _करते__हैं_, _nákupný__košík_, _औरैया__कन्नौज_, --, 
   {{0xb2d9c018,0x00000000,0x00000000,0x00000000}},	//   _deve_, --, --, --, 
   {{0x92da0024,0x1b04001f,0x848fe01a,0x00000000}},	//   _meseci_, _persekut, _då__eg_, --, 
   {{0xee638002,0x579e0003,0x00000000,0x00000000}},	//   _могућнос_да_, _གལ__སྲིད_, --, --, 
   {{0xeb164035,0x00000000,0x00000000,0x00000000}},	//   _isiprofe, --, --, --, 
   {{0xebb98006,0x00000000,0x00000000,0x00000000}},	//   _ནི__གི_, --, --, --, 
   {{0x42bd000c,0x9abd400c,0x00000000,0x00000000}},	//   _जांच__एजेंसी_, _खातिर__लोग_, --, --, 
   {{0x6e728002,0x00000000,0x00000000,0x00000000}},	// [760] _други__са_, --, --, --, 
   {{0xa25ac00e,0xa185600f,0xe4b02019,0x9fca801a}},	//   _podle_, _isibonel, _ett__år_, _kjem__frå_, 
   {{0xfa70c009,0x462ac00b,0x483e2002,0x00000000}},	//   _berlings, _umwihari, _линк_, --, 
   {{0xd167e002,0x00000000,0x00000000,0x00000000}},	//   _најбоље_, --, --, --, 
   {{0x44d68022,0x9308a018,0x00000000,0x00000000}},	//   _मैथिली_, _fale__conosco_, --, --, 
   {{0xabf0600a,0x00000000,0x00000000,0x00000000}},	//   _टिप्पणी__की_, --, --, --, 
   {{0x011a400c,0xc40ce018,0x00000000,0x00000000}},	//   _कि__मालवा_, _sua__avaliaçã, --, --, 
   {{0xc366a037,0x12fde013,0xfbdc000c,0x00000000}},	//   _escribió_, _मथुरा_, _के__लगे_, --, 
   {{0x92de6037,0x9795a00a,0xf2e1a00c,0x91b9800c}},	//   _la__cola_, _अतिथिगण__आकस्मिक_, _पढ़ीं_, _मजाल_, 
   {{0x53f40009,0xfbe30006,0xf3456012,0x4ebb2002}},	//   _postnr_, _འགོ__དང_, _súčasťou_, _блог__не_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xdbe7a002,0xfc35a014,0x00000000,0x00000000}},	//   _под__лиценцом_, _में__रहे_, --, --, 
   {{0x72d9c011,0x42d8c009,0xb2d9c018,0x5c09e012}},	//   _xoves_, _viden_, _teve_, _príspevk_bydlisko_, 
   {{0x4788000b,0x00000000,0x00000000,0x00000000}},	//   _isi__mukiring, --, --, --, 
   {{0x028d6007,0x4fc38011,0xaaaae00a,0x00000000}},	//   _perkara_, _ferramen_páxinas_, _महिलाएं_, --, 
   {{0x72d8c009,0xb315e018,0x44966009,0x4493c00f}},	//   _andet_, _usuário_, _kr__af_, _yamakris_yesigrek, 
   {{0x9420001d,0x7ee3800f,0x53ac600b,0xf448400b}},	// [770] _niaga__baru_, _esikolen, _urupfu_, _bw__umwuka_, 
   {{0xb442c012,0x01ada037,0x71fdc017,0x00000000}},	//   _sme_, _de__operacio, _pro__všechny_, --, 
   {{0xc2ca8009,0xb320a03d,0x46e3200c,0x00000000}},	//   _hvad_, _doby_, _ना__बुझाई_, --, 
   {{0x5be8e003,0x62636003,0x00000000,0x00000000}},	//   _གང__ཟག_, _དང__གསར_, --, --, 
   {{0x847fa012,0x00000000,0x00000000,0x00000000}},	//   _webnovin_sk_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa2d9e024,0x0150c00c,0xc60c600a,0x00000000}},	//   _dete_, _के__नौटंकी_, _भूचाल__सेहत_, --, 
   {{0x22918012,0xb7c40025,0x67382003,0x00000000}},	//   _teraz_, _brasilei, _གཅོད_, --, 
   {{0xebeda014,0x23af800a,0x1b97e003,0x00000000}},	//   _कर्नाटक__के_, _झूठा__लाइफस्टा, _ཁམས__ཆུ_, --, 
   {{0xc0e72009,0xa2d9801f,0x917e600f,0x00000000}},	//   _almindel, _rezeki_, _ngesikha_esifanel, --, 
   {{0xd603c022,0x00000000,0x00000000,0x00000000}},	//   _इरादा_, --, --, --, 
   {{0xfa48e018,0x64a32018,0xcb1b200f,0x00000000}},	//   _no__botão_, _através__de_, _abaphost, --, 
   {{0x93806039,0xfbbb0014,0xe83a2006,0x6e72e002}},	//   _aturan_, _पाकिस्ता_से_, _སྒྲིང__སྒྲིང_, _ре_, 
   {{0x5ea3a030,0xfbf2c003,0x00000000,0x00000000}},	//   _za__djelimič, _ཆེ__རུ_, --, --, 
   {{0xebed800c,0xb339c012,0x00000000,0x00000000}},	//   _आतंकवाद__के_, _produkto_více_, --, --, 
   {{0x92bf6018,0xa11c4028,0x00000000,0x00000000}},	//   _uma__nova_, _proveedo, --, --, 
   {{0x1d8f2029,0x6442e01f,0x1294e012,0xf4a2c018}},	// [780] _དངོས_, _mmg_, _hovorí_, _escreva__seu_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa3cf800e,0x329dc01a,0x00000000,0x00000000}},	//   _barva_, _han__ikkje_, --, --, 
   {{0xc8684003,0x93eb2012,0x00000000,0x00000000}},	//   _མའི__བསྐྱར_, _obchod__podmienk, --, --, 
   {{0xcf22e033,0x72d94009,0x63dfe010,0xba63200c}},	//   _nađi__još_, _blandt__andet_, _de__danske_, _सत्र__चलल_, 
   {{0x14b1202d,0xf231e012,0x7de5c003,0xf4382018}},	//   _postova__od_, _pridať__upraviť_, _པའི__ཚོགས_, _em__conta_, 
   {{0x43c6a012,0x00000000,0x00000000,0x00000000}},	//   _pre__vás_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x43418025,0x4248000f,0x00000000,0x00000000}},	//   _janeiro_, _izimo_, --, --, 
   {{0x7ed56002,0x00000000,0x00000000,0x00000000}},	//   _ми__се_, --, --, --, 
   {{0xd394a009,0x31d9a00a,0x00000000,0x00000000}},	//   _sidste_, _नज़र_, --, --, 
   {{0x33bb201a,0xf30d2018,0xcb71200b,0x00000000}},	//   _endra__mars_, _deverá_, _kuburana_, --, 
   {{0x927e601a,0x5af4e015,0x4a9de00a,0x00000000}},	//   _fann_, _investas, _देखा__गया_, --, 
   {{0x23090037,0x323fe00b,0x00000000,0x00000000}},	//   _vende__este_, _muri__afrika_, --, --, 
   {{0x734f6012,0x22390002,0x00000000,0x00000000}},	//   _pozemok_, _нову_, --, --, 
   {{0x225ae012,0x42d8e01a,0x42926017,0xf62c200a}},	//   _mailom_, _eigen_, _dotazy_, _अपने__कीबोर्ड_, 
   {{0x494b200f,0x5a190003,0x00000000,0x00000000}},	// [790] _thimothe, _སོག__པོའི_, --, --, 
   {{0x8dd7401a,0x00000000,0x00000000,0x00000000}},	//   _ein__kommenta, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x4f5cc00e,0x91a18002,0x11e58002,0x00000000}},	//   _jednoduš, _одговара, _будућнос, --, 
   {{0xccaec002,0x00000000,0x00000000,0x00000000}},	//   _спољашње__везе_, --, --, --, 
   {{0xd29a6003,0x00000000,0x00000000,0x00000000}},	//   _རྒོད__གུར_, --, --, --, 
   {{0xf36f2031,0xa00d400e,0x00000000,0x00000000}},	//   _tingkat_, _proveden, --, --, 
   {{0x1c024011,0xd2e8a015,0x00000000,0x00000000}},	//   _persoas_, _pikiran_, --, --, 
   {{0x23418011,0xc35c601a,0x00000000,0x00000000}},	//   _xaneiro_, _høgare_, --, --, 
   {{0x3b5ca040,0x78b1a002,0xc2480018,0x3ee9c009}},	//   _pošaljit, _под__истим_, _ruim_, _funktion, 
   {{0xe46de019,0x6b798003,0x00000000,0x00000000}},	//   _hva__er_, _དབུས__གཞུང_, --, --, 
   {{0x4d5ac002,0x6b42200f,0xec49200a,0x00000000}},	//   _човек_, _isibusis, _मौके_, --, 
   {{0x8da62003,0x00000000,0x00000000,0x00000000}},	//   _ཁྲིམས__ལུགས_, --, --, --, 
   {{0xc588c011,0x72d8401d,0xf99e200a,0x00000000}},	//   _poboació, _filem_, _है__जिसमें_, --, 
   {{0x32cac019,0xd8fd2008,0x391ca00a,0xe863c00c}},	//   _bilder_, _igualdad, _आप__साइट_, _का__मातृभाषा_, 
   {{0x7edd4002,0x00000000,0x00000000,0x00000000}},	//   _сам__се_, --, --, --, 
   {{0x86ad4014,0xd0e6c00a,0xc29e8003,0x00000000}},	// [7a0] _जन्म__स्थान_, _पानीपत_, _སྟོན__པའི_, --, 
   {{0xbd80e029,0xf2138004,0xae83a00a,0x00000000}},	//   _བརྗོད_, _xesha_, _कैसेखोजे_राज्य_, --, 
   {{0x9bada00a,0x00000000,0x00000000,0x00000000}},	//   _था__कि_, --, --, --, 
   {{0x62428029,0x6497e028,0xebf3a00c,0x5de7e00e}},	//   _བཏང_, _si__te_, _पहुंच__के_, _vytvořen__účet_, 
   {{0xf2d50016,0xd26cc00f,0xb2a3e003,0x00000000}},	//   _tillatt_, _nhlobo_, _ཀྱི__རྣམ_, --, 
   {{0x2c026018,0x9421000b,0x00000000,0x00000000}},	//   _pessoas_, _kanda__garuka_, --, --, 
   {{0x3fd18045,0xe286400f,0x00000000,0x00000000}},	//   _je__otázka_, _isikhath_lapho_, --, --, 
   {{0x8479c00f,0x00000000,0x00000000,0x00000000}},	//   _kusukela__ngo_, --, --, --, 
   {{0x5358400b,0x7bf0c00a,0x92858003,0x00000000}},	//   _abagize_, _टेक__ऑटो_, _གཡག__ཉོས_, --, 
   {{0x3321802c,0xe24d0006,0x9fc2000e,0x9ce84003}},	//   _buryo_, _ཧེང__བཀལ_, _používán, _ཤོག__དངུལ_, 
   {{0xe452600f,0x0a3e600c,0x00000000,0x00000000}},	//   _ebonisa__ukuthi_, _भरम_, --, --, 
   {{0x64444027,0x0bb3c006,0xf985c00a,0x00000000}},	//   _aj_, _ནཱ__ལུ_, _जिसमें_, --, 
   {{0x025a000f,0xce49e01d,0xf4192018,0xfe8da00e}},	//   _enhle_, _antaraba, _sua__conta_, _poškozen, 
   {{0xf4420004,0x00000000,0x00000000,0x00000000}},	//   _eli_, --, --, --, 
   {{0x3436a019,0xa3f8600e,0x84bd4039,0x00000000}},	//   _de__siste_, _minut_, _langsung__di_, --, 
   {{0xcecc2012,0x4f17c01a,0xa922e012,0x8a39e00e}},	//   _hviezdič, _kommunar_, _mapa__stránky_, _paměť_, 
   {{0xab9de006,0xc493800b,0x0b99600c,0x00000000}},	// [7b0] _མིའི__ཐོ_, _ko__iyo_, _गइल__अइसन_, --, 
   {{0x04ac8015,0xe23de00b,0x029f4003,0x00000000}},	//   _berniaga__com_, _muri__mali_, _དངོས__ཡོད_, --, 
   {{0x72e6001d,0x6d80c003,0x0a6a000c,0x00000000}},	//   _rm__juta_, _བགྲོད_, _भोजशाला_, --, 
   {{0xcb1f801d,0x0e6c2002,0x00000000,0x00000000}},	//   _bahagian_, _општине_, --, --, 
   {{0x0c5de014,0xf27c2018,0x92cae009,0x00000000}},	//   _के__जाने_, _necessár, _vinder_, --, 
   {{0x58888003,0x2ad44040,0x7e1b6039,0x44938009}},	//   _པོ__སྤྱི_, _đoković_, _ditemuka, _et__nyt_, 
   {{0x42b54028,0x2df8a002,0xd255a00b,0x332d600f}},	//   _precio_, _коментар_, _ya__kabiri_, _amalungu__omkhaya_, 
   {{0x1fb0c012,0xcbdb600c,0x00000000,0x00000000}},	//   _čítaj_, _के__ऋतु_, --, --, 
   {{0xbaec4019,0x4378600b,0x00000000,0x00000000}},	//   _mer__informas, _gufasha_, --, --, 
   {{0xda5a200c,0x00000000,0x00000000,0x00000000}},	//   _कऽ__सकत_, --, --, --, 
   {{0x53cb8028,0x524da006,0x74444025,0x00000000}},	//   _de__cerrar_, _ཧེང_, _rj_, --, 
   {{0x649c2011,0xc4b2c009,0x00000000,0x00000000}},	//   _xuño__de_, _efter__en_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x275aa04f,0xd341e011,0x00000000,0x00000000}},	//   _संस्करण_, _colexio_, --, --, 
   {{0x73aa2011,0x6c55a009,0xa3a58003,0xdc57c00a}},	//   _baixo__licenza_, _rigtige_, _བསྲེགས_, _उसमें_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x3d7a600b,0xe4bf000e,0x00000000,0x00000000}},	// [7c0] _gisanzwe__icyumwer, _naleznet_na_, --, --, 
   {{0xced7800f,0x00000000,0x00000000,0x00000000}},	//   _ngayinye_, --, --, --, 
   {{0xa2b6001a,0x4e6b0006,0x06c90002,0x22a60003}},	//   _på__skulen_, _མཛོད__བརྒྱུད_, _претражи, _མོས__ཤོག_, 
   {{0xf236c012,0x00000000,0x00000000,0x00000000}},	//   _svojim_, --, --, --, 
   {{0x825a2009,0x9351200b,0x9862600e,0x8251c00f}},	//   _fejl_, _icyo__gihe_, _zapomenu, _umyeni__wami_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x722a6002,0xb4b72018,0x1bdea00c,0x00000000}},	//   _мора_, _crie__uma_, _तक__ना_, --, 
   {{0xe3ce6012,0x13d1600b,0x00000000,0x00000000}},	//   _psov_, _bidafite__itegeko_, --, --, 
   {{0x9e13c024,0xa3db800b,0xfdf5400e,0x00000000}},	//   _dačić_, _mu__ijuru_, _ovládání_, --, 
   {{0x44abc012,0x00000000,0x00000000,0x00000000}},	//   _stránke_, --, --, --, 
   {{0xba52c011,0x7bb60003,0x00000000,0x00000000}},	//   _administ_públicas_, _ལམ__དུ_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2be3c00f,0x00000000,0x00000000,0x00000000}},	//   _isambulo_, --, --, --, 
   {{0x1e9a601a,0x00000000,0x00000000,0x00000000}},	//   _følgjand, --, --, --, 
   {{0x9c88800c,0x00000000,0x00000000,0x00000000}},	// [7d0] _दूनो_, --, --, --, 
   {{0x7bb9e003,0x00000000,0x00000000,0x00000000}},	//   _དེ__ནི_, --, --, --, 
   {{0xd3eac012,0x0452201a,0x63b3a01a,0xe283e003}},	//   _svet_, _han__henta_, _med__biletet_, _འཁྲུངས__སྐར_, 
   {{0xe290201d,0x81772014,0x9a414018,0xe240000f}},	//   _rakan_, _प्रतिरोध_, _comentár_você_, _ngo__futhi_, 
   {{0x9290401d,0x62e5e00c,0x00000000,0x00000000}},	//   _laman_, _रहल__बानी_, --, --, 
   {{0xc2a3e003,0x0ba18014,0x128fa00f,0x0beb4003}},	//   _ཀྱི__རིག_, _एच__डी_, _izwi__lakhe_, _འདིའི__ནང_, 
   {{0xf451a01e,0x1718000e,0x94332002,0x00000000}},	//   _vrijeme__posta_, _odpověz_, _су__увредљив, --, 
   {{0x84764037,0xe27f400b,0x22ebe00b,0x00000000}},	//   _lugar__ha_, _ukwa__cumi_, _onu__rujejwe_, --, 
   {{0xc3a2e00f,0x0a73200c,0xe469c00f,0x00000000}},	//   _imiphi_, _एकरा__में_, _ngokucac_ukuthi_, --, 
   {{0x04980011,0x00000000,0x00000000,0x00000000}},	//   _os__teu_, --, --, --, 
   {{0xb24ee003,0x426da003,0xe2832003,0x00000000}},	//   _རྣམས__ཀྱི_, _ཁྲིའི__འོས_, _གུང__ཁྲན_, --, 
   {{0x4f250009,0xab4aa03f,0x12c50009,0x5d050009}},	//   _billeder_, _kwathiwa_, _billede_, _billedet_, 
   {{0x8301e01d,0xa23f2003,0x00000000,0x00000000}},	//   _seramai_, _འདྲི__རྩོམ_, --, --, 
   {{0x2c06e013,0x0c126013,0x7ba28003,0x00000000}},	//   _दिए__गए_, _आता__है_, _པོའི__རང_, --, 
   {{0xb212e035,0xa6778003,0x00000000,0x00000000}},	//   _esihle_, _འམ__དཔྱད_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [7e0] --, --, --, --, 
   {{0x388dc002,0x82c90003,0x2f7d200a,0x00000000}},	//   _нерегист_пошаљи_, _སྐབས__དེར_, _संसार__क्रिकेट_, --, 
   {{0x7917e002,0x00000000,0x00000000,0x00000000}},	//   _средине_, --, --, --, 
   {{0x3a33400c,0xd2cb8012,0xc469001a,0x1d24c002}},	//   _कइल_, _dokonca_, _vart__lagt_, _свиђања__прича_, 
   {{0x7bb38003,0x00000000,0x00000000,0x00000000}},	//   _ཙམ__དུ_, --, --, --, 
   {{0xc43ca01a,0xbb932006,0xf409a00b,0x00000000}},	//   _og__vart_, _ཡིག__ཚུ_, _wihuse__inkuru_, --, 
   {{0x02de000a,0x227ec01a,0x00000000,0x00000000}},	//   _करती_, _kjend_, --, --, 
   {{0x02b84005,0x00000000,0x00000000,0x00000000}},	//   _næring__omsorg_, --, --, --, 
   {{0x3b8e8011,0x00000000,0x00000000,0x00000000}},	//   _rexistro_, --, --, --, 
   {{0xb462801d,0xa3eb801a,0x99f4200e,0x00000000}},	//   _kenalan__dan_, _flytta_, _jaké_, --, 
   {{0x8b8a2002,0x924d8029,0x2a334014,0x2ba8e003}},	//   _током_, _འཚོ_, _केर_, _སློབ__ལམ_, 
   {{0x53f9a018,0xee8b400a,0x6e0f0003,0x21c92002}},	//   _fique_, _इस__पृष्ठ_, _སོགས__ཀྱིས_, _пошту_, 
   {{0x7ef0200a,0x6a78200a,0x00000000,0x00000000}},	//   _लड़की_, _नामस्थान__लेख_, --, --, 
   {{0x6474a038,0x415fe00f,0x00000000,0x00000000}},	//   _elemento__de_, _zobulili__ezingcol, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xd78a4006,0xa201001d,0xff27e018,0x3a0c6002}},	//   _བསམ__བཀོད_, _muzik_, _comentár_enviados_, _на__који_, 
   {{0x72904007,0x8cd48012,0x00000000,0x00000000}},	// [7f0] _zaman_, _uskutočn, --, --, 
   {{0xd4424009,0x04946017,0x00000000,0x00000000}},	//   _alm_, _cz__cz_, --, --, 
   {{0x1271e003,0x8c0be002,0x00000000,0x00000000}},	//   _ཟླ__བཅུ_, _октобра_, --, --, 
   {{0x6a3de01c,0x3cc9200b,0x00000000,0x00000000}},	//   _तरह_, _ku__itariki_, --, --, 
   {{0x44b6601e,0x8c952018,0x00000000,0x00000000}},	//   _mijenjan_put_, _como__comprar_, --, --, 
   {{0xb484400a,0x4aca8003,0x00000000,0x00000000}},	//   _क्याहै_, _ལྷུག_, --, --, 
   {{0xd9d14038,0x54fb800c,0x00000000,0x00000000}},	//   _ponteved, _जयप्रकाश__नारायण_, --, --, 
   {{0xbe8f0002,0xdc684039,0x00000000,0x00000000}},	//   _али_, _dimulai_, --, --, 
   {{0x925ae009,0x0290401a,0xa2e42037,0x326c200f}},	//   _nogle_, _saman_, _algún__dato_, _kamose_, 
   {{0x0262a003,0x00000000,0x00000000,0x00000000}},	//   _གྱུར__ཡོད_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x12d8202a,0x2264a031,0xbb98a00a,0x930fa00f}},	//   _liker_, _melalui__email_, _मोबाइल__पर_, _ngale__ndaba_, 
   {{0x39f42017,0x4eb8e002,0x26a22009,0xd33ac02a}},	//   _také_, _ми_, _spørgsmå, _du__trenger_, 
   {{0xc252a003,0x2bff800c,0x00000000,0x00000000}},	//   _ཁུལ__གྱི_, _स्तर__पऽ_, --, --, 
   {{0x0212002c,0x00000000,0x00000000,0x00000000}},	//   _igihe_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
  
   {{0x53098028,0x4ae00039,0xb0f32003,0x00000000}},	// [800] _añadir_, _kabupate, _ཀྱི__འདྲ_, --, 
   {{0x2bdc000c,0x00000000,0x00000000,0x00000000}},	//   _के__एगो_, --, --, --, 
   {{0x329e4005,0x500dc012,0xe38b800e,0x00000000}},	//   _ein__ikkje_, _preveden, _dárek_, --, 
   {{0x3c94800a,0x00000000,0x00000000,0x00000000}},	//   _सबमिट__करें_, --, --, --, 
   {{0x4379600e,0x12c3a002,0x00000000,0x00000000}},	//   _poradna_, _добијте_, --, --, 
   {{0xf438a011,0x02644003,0x62d9e018,0x00000000}},	//   _en__conta_, _སློབ__གསོ_, _ontem_, --, 
   {{0x4a96600b,0x02856003,0xa48d001a,0x1a3b800e}},	//   _tanzania_, _གནང__ཡོད_, _mellom__dei_, _rozhodně_, 
   {{0xda5ec012,0x1b9b600c,0x00000000,0x00000000}},	//   _ich__vydavate, _कई__गो_, --, --, 
   {{0x524b601d,0xa26e0020,0xb2a46003,0x00000000}},	//   _tinjau__ahli_, _ཁབ__འདི_, _པའི__རྣམ_, --, 
   {{0x1bd92003,0x00000000,0x00000000,0x00000000}},	//   _བཅས__སུ_, --, --, --, 
   {{0x428ca003,0x00000000,0x00000000,0x00000000}},	//   _བཟང__སེང_, --, --, --, 
   {{0xebfc200c,0xc2018012,0x00000000,0x00000000}},	//   _करे__के_, _musia_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xb680600b,0xb1772002,0x00000000,0x00000000}},	//   _kandi__umujesui, _месту_, --, --, 
   {{0x84426015,0x00000000,0x00000000,0x00000000}},	//   _klo_, --, --, --, 
   {{0x9c69402f,0xbc01600a,0x00000000,0x00000000}},	//   _de__compras_, _ग्वालियर__चंडीगढ़_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [810] --, --, --, --, 
   {{0x02b4e003,0x00000000,0x00000000,0x00000000}},	//   _གི__སྐུ_, --, --, --, 
   {{0x36fee00a,0xc4426004,0x024e4003,0x00000000}},	//   _करना_, _olo_, _རེར_, --, 
   {{0x6d7f2002,0xc2eec00b,0x00000000,0x00000000}},	//   _јун_, _abenshi_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xeb7c200f,0x627f002c,0x625ac012,0x00000000}},	//   _kusukela_, _abandi_, _podla_, --, 
   {{0x1213a00f,0x12f6c033,0x4a3e600c,0x00000000}},	//   _kepha_, _pošalji__osobnu_, _भरल_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x82f9c016,0x00000000,0x00000000,0x00000000}},	//   _alle__kategori_, --, --, --, 
   {{0x24426004,0x1355003c,0x0ac3a022,0x82e90011}},	//   _elo_, _postignu_dogovor_, _जवाब__में_, _camiño_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xb0f0a013,0x00000000,0x00000000,0x00000000}},	//   _रेलवे_, --, --, --, 
   {{0xc6d02004,0xe4aca016,0x9367000b,0x00000000}},	//   _kuvakali, _snarvei__til_, _umugabo_, --, 
   {{0x83326004,0xd8c4e00a,0x12cb4009,0xd224800e}},	//   _ngoxa_, _कानपुर_, _sidder_, _velká_, 
   {{0x8dc06006,0xb4bcc00e,0x54986011,0x35db6018}},	//   _བརྒྱའི__རིངས_, _jsem__to_, _xa__se_, _em__visualiz, 
   {{0x844c8011,0x82bea011,0x00000000,0x00000000}},	//   _xestión_, _que__unha_, --, --, 
   {{0xd254e008,0x2e79e002,0x5ef12002,0x00000000}},	// [820] _no__artigo_, _бисте__је_, _осталих_, --, 
   {{0x92d58018,0x00000000,0x00000000,0x00000000}},	//   _conosco_, --, --, --, 
   {{0x85f9000c,0x9c06e00c,0x00000000,0x00000000}},	//   _अपरोक्ष_, _कहली__कि_, --, --, 
   {{0x725ae002,0xed8e4006,0xad0c200b,0x00000000}},	//   _đilas_, _གཞུང__སྐྱོང_, _yakorewe_, --, 
   {{0x0395c012,0x0c14600a,0x00000000,0x00000000}},	//   _časť_, _दिया__है_, --, --, 
   {{0x644da00b,0xaed52002,0x0754e018,0x00000000}},	//   _ushaka__jya_, _бог_, _uma__listagem_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x5278400f,0x00000000,0x00000000,0x00000000}},	//   _futhi__ngemva_, --, --, --, 
   {{0x1996e00c,0x00000000,0x00000000,0x00000000}},	//   _के__प्रमाण_, --, --, --, 
   {{0x7bbc6006,0x4a8ce00c,0x00000000,0x00000000}},	//   _ཡུ__ནི_, _चल__गइल_, --, --, 
   {{0xe422e015,0x2db8600f,0x782a6002,0xea19a00f}},	//   _cocok__untuk_, _izenzaka, _оставите__одговор_, _futhi__njengoba_, 
   {{0x125b8024,0x0bb44006,0x82efe01a,0xa888e002}},	//   _posle_, _ནི__ལུ_, _dei__hadde_, _фејсбук_, 
   {{0x42fcc02a,0xaa83e00f,0x92ad600f,0x3bc7c00c}},	//   _selges_, _izinhlob, _lapho__ebona_, _भइल__बा_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x8aff2003,0xc4678011,0x00000000,0x00000000}},	//   _ཟླ__དྲུག_, _aínda__non_, --, --, 
   {{0x4a4be00c,0x00000000,0x00000000,0x00000000}},	//   _हो__गइल_, --, --, --, 
   {{0x09f4200e,0xb3d76005,0x00000000,0x00000000}},	// [830] _mají_, _utdannin_trafikk_, --, --, 
   {{0x3243e03a,0x5f02c002,0x00000000,0x00000000}},	//   _ཁམས_, _школа_, --, --, 
   {{0xc9edc00d,0x2ad9600e,0x233a000b,0xdbc9400c}},	//   _requerid, _produktů__vybírejt, _muri__kongo_, _के__मौजूदगी_, 
   {{0xe46f4015,0xbe6a800e,0x62c8e00e,0xc28b800b}},	//   _jawa__timur_, _podmínky__užívání_, _prázdný__seznam_, _munani__abantu_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xb475c00f,0x0c5d800c,0x00000000,0x00000000}},	//   _ikakhulu_uma_, _के__चाहे_, --, --, 
   {{0x3afbc01d,0x00000000,0x00000000,0x00000000}},	//   _peperiks, --, --, --, 
   {{0x3bb0200c,0x00000000,0x00000000,0x00000000}},	//   _हम__एह_, --, --, --, 
   {{0x83c2a01a,0x00000000,0x00000000,0x00000000}},	//   _høve_, --, --, --, 
   {{0x0aae600c,0x00000000,0x00000000,0x00000000}},	//   _तत्वाधान__में_, --, --, --, 
   {{0xa2e6c011,0x35dd6002,0xb24d8003,0x4a81000c}},	//   _da__súa_, _подаци__други_, _སྩལ_, _भोजपुर__नाम_, 
   {{0x1443a015,0xa33a000b,0x00000000,0x00000000}},	//   _smp_, _muri__congo_, --, --, 
   {{0x0588200a,0x00000000,0x00000000,0x00000000}},	//   _लुधियाना__वडोदरा_, --, --, --, 
   {{0xc2500002,0x00000000,0x00000000,0x00000000}},	//   _века_, --, --, --, 
   {{0xbb21c012,0x12df4018,0x52e5800a,0x1d8fc003}},	//   _komplime, _na__loja_, _बाल__वाली_, _བཤེས_, 
   {{0xd49d4011,0x7e732002,0x0fafe00e,0x00000000}},	//   _páxinas__que_, _веб_, _spíše_, --, 
   {{0x2bf80022,0x846a8002,0x2524a014,0x00000000}},	// [840] _में__हम_, _povezane__vesti_, _जुड़ाव_, --, 
   {{0xf29bc012,0x5a096018,0x00000000,0x00000000}},	//   _chybu__upraviť_, _propried, --, --, 
   {{0xda4d400c,0x00000000,0x00000000,0x00000000}},	//   _कई__बेर_, --, --, --, 
   {{0xec0a8014,0x83a50016,0x124e2015,0xc209c015}},	//   _कहानी__के_, _innlegg__blir_, _follow__topic_, _simpan__mobil_, 
   {{0xbf18e006,0xf0018012,0x00000000,0x00000000}},	//   _འབྲུག__འབྲུག_, _konštruk, --, --, 
   {{0x64b36011,0xe254200b,0x00000000,0x00000000}},	//   _concello__de_, _mu__rukiko_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xb28fa00f,0x00000000,0x00000000,0x00000000}},	//   _izwi__lakho_, --, --, --, 
   {{0xbd8fc020,0xe2ac4006,0x3c0f800c,0x00000000}},	//   _བཤུས_, _གཙོའི__རིང_, _खातिर__एह_, --, 
   {{0x8cc8c002,0x295f600b,0x00000000,0x00000000}},	//   _новембар_, _bwongere, --, --, 
   {{0x12d86017,0x632b800b,0x00000000,0x00000000}},	//   _ihned_, _ka__karongi_, --, --, 
   {{0xb4b9a018,0x00000000,0x00000000,0x00000000}},	//   _mais__uma_, --, --, --, 
   {{0x3319e00e,0x00000000,0x00000000,0x00000000}},	//   _na__prodej_, --, --, --, 
   {{0x6d950002,0x00000000,0x00000000,0x00000000}},	//   _slanje__lične_, --, --, --, 
   {{0x28d9e002,0x2200601d,0xc263a00f,0xa93ac002}},	//   _категори, _isnin_, _umyeni__wakhe_, _хрватско, 
   {{0xbf530006,0x00000000,0x00000000,0x00000000}},	//   _ཨིན__འབྲུག_, --, --, --, 
   {{0xe3a3e00f,0x00000000,0x00000000,0x00000000}},	// [850] _ukuthi__ujesu_, --, --, --, 
   {{0x66d28022,0xc7e6600f,0xba33a00c,0x59cd200a}},	//   _लोगिन_, _isiqondi, _आइल_, _इंटरेस्ट__हंसमुख_, 
   {{0x93fe001a,0x00000000,0x00000000,0x00000000}},	//   _ikkje__minst_, --, --, --, 
   {{0x74810039,0x00000000,0x00000000,0x00000000}},	//   _yang__mau_, --, --, --, 
   {{0x2bf62022,0x82de2011,0x23b6e00b,0x00000000}},	//   _में__जब_, _en__unha_, _uwa__mbere_, --, 
   {{0x9e46200f,0x00000000,0x00000000,0x00000000}},	//   _namadoda, --, --, --, 
   {{0x52b8400f,0x6224c009,0x7c53c013,0x00000000}},	//   _kube__phakade_, _tjek_, _डोमेन_, --, 
   {{0x2bcc600a,0x0bf2400e,0x00000000,0x00000000}},	//   _लखनऊ__लंदन_, _ostření__fotoapar, --, --, 
   {{0x7201a025,0x00000000,0x00000000,0x00000000}},	//   _devido_, --, --, --, 
   {{0xf3fa401a,0x8d0fc011,0x00000000,0x00000000}},	//   _bakgrunn_endre_, _xustific, --, --, 
   {{0xd2e7600b,0x00000000,0x00000000,0x00000000}},	//   _urunana_, --, --, --, 
   {{0xc5a2800a,0x2b8ac002,0x09aac002,0x00000000}},	//   _पर्यटन__सेहत_, _новом_, _новим_, --, 
   {{0xfa9dc00e,0x00000000,0x00000000,0x00000000}},	//   _cz__všechna_, --, --, --, 
   {{0xebbe8003,0x00000000,0x00000000,0x00000000}},	//   _ལྷ__མོ_, --, --, --, 
   {{0x52f8a01a,0x13574011,0x00000000,0x00000000}},	//   _ein__annan_, _arredor_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xb336c00a,0x00000000,0x00000000,0x00000000}},	// [860] _लिए__यहां_, --, --, --, 
   {{0xa27e802c,0x01a2a00e,0x02b7e01a,0xa3ed2009}},	//   _ijana_, _hledání_, _år__sidan_, _gange__svar_, 
   {{0xe4744018,0x00000000,0x00000000,0x00000000}},	//   _mouse__na_, --, --, --, 
   {{0x84b0e00b,0x0383200b,0x00000000,0x00000000}},	//   _ibiteker_nta_, _binyuze_, --, --, 
   {{0x5201a00b,0x00000000,0x00000000,0x00000000}},	//   _kopi_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x427f403d,0x769e000c,0x00000000,0x00000000}},	//   _jednou_, _में__इतिहास_, --, --, 
   {{0xb4b1603c,0x85de800a,0xc715a00c,0x00000000}},	//   _postovi__dan_, _छत्तीसगढ, _कि__राजा_, --, 
   {{0x46b2e00c,0x00000000,0x00000000,0x00000000}},	//   _चहेता_, --, --, --, 
   {{0xb909000b,0xe278200e,0x00000000,0x00000000}},	//   _urubyiru, _horní_, --, --, 
   {{0x028e8019,0x9aa6400c,0x643e0002,0x1c9ee00a}},	//   _med__bruk_, _में__साफ_, _јасно_, _को__जानो_, 
   {{0x8298a003,0xc2cd6012,0xd4b9e00f,0x9196400c}},	//   _པའི__དབང_, _pre__mňa_, _yezwe__ii_, _बा__अहमदाबाद_, 
   {{0x747c001a,0x00000000,0x00000000,0x00000000}},	//   _kvar__dag_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2213e00f,0x00000000,0x00000000,0x00000000}},	//   _bethi_, --, --, --, 
   {{0x1b262035,0x00000000,0x00000000,0x00000000}},	//   _ukuphila_, --, --, --, 
   {{0x20fe2022,0xd147a00a,0x00000000,0x00000000}},	// [870] _के__गांव_, _व्यंजन_, --, --, 
   {{0x23820020,0x94ae400b,0x20890002,0x00000000}},	//   _ཤན__སྦྱར_, _ikipe__ya_, _речима_, --, 
   {{0xebc2200c,0x00000000,0x00000000,0x00000000}},	//   _अस्मिता__के_, --, --, --, 
   {{0x34c58025,0x00000000,0x00000000,0x00000000}},	//   _trabalho_, --, --, --, 
   {{0x9248c018,0x00000000,0x00000000,0x00000000}},	//   _quem_, --, --, --, 
   {{0x62018015,0x539b000b,0xe984002c,0x00000000}},	//   _musik_, _abantu__benshi_, _igikorwa_, --, 
   {{0xa2bec00f,0x00000000,0x00000000,0x00000000}},	//   _yini__eyenza_, --, --, --, 
   {{0x62df6011,0x127f400b,0xa0ba4002,0x00000000}},	//   _na__pola_, _cyenda_, _март__текст_, --, 
   {{0x032c0009,0x13df2011,0x2ac1403d,0x9201000d}},	//   _så__meget_, _esta__páxina_, _lepší_, _recibo_, 
   {{0x4f3fe012,0x4ab6a00c,0x00000000,0x00000000}},	//   _nakoniec_, _पढ़ल__गइल_, --, --, 
   {{0xecab000a,0xceb96002,0x00000000,0x00000000}},	//   _हुए__परिवर्तन_, _тих_, --, --, 
   {{0xc4a9c01e,0x52900015,0xe347c01a,0x0c0b200a}},	//   _napisao__la_, _pria_, _handlar_, _लिखा__था_, 
   {{0x32fc0038,0x00000000,0x00000000,0x00000000}},	//   _debes__estar_, --, --, --, 
   {{0x4442c011,0x03182009,0x2eea6002,0x3b7fc00b}},	//   _lle_, _at__finde_, _ако__је_, _gatulika_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xb1ea2020,0x02b0e006,0x4708000c,0xbb8d400c}},	//   _སྦོམ_, _ཐོ__གནས_, _के__सीमा_, _कत_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [880] --, --, --, --, 
   {{0x7a3d200a,0xc9f34012,0x7bea2006,0x219bc00c}},	//   _हुआ_, _prostred, _ཚང__ལར_, _के__सर्वर_, 
   {{0xa442c016,0xd2b4e003,0x4c802002,0x00000000}},	//   _ble_, _གི__སྐད_, _мене_, --, 
   {{0x425ac011,0xb4bdc01a,0x00000000,0x00000000}},	//   _fillos_, _seie__at_, --, --, 
   {{0xc442c00e,0xcc80400a,0x00000000,0x00000000}},	//   _dle_, _हेतु__देखें_, --, --, 
   {{0x920ee00e,0xd442c018,0x2ee86002,0x3a46e002}},	//   _při_, _ele_, _где__је_, _заштиту_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x1472c01a,0xca33001c,0x7ebbc002,0xb21c6012}},	//   _saman__med_, _टेक_, _како__се_, _druhej_, 
   {{0x27a12050,0x2e6cc00b,0x00000000,0x00000000}},	//   _अन्तर्रा, _gatulika__baratera, --, --, 
   {{0x12a40003,0xd20ee00e,0x03c5c009,0x7ec86002}},	//   _ཚེས__ཉིན_, _tři_, _fotoalbu_videoer_, _то__се_, 
   {{0x52fe6009,0xbe0d6017,0x8f39400c,0x00000000}},	//   _brugte_, _produktu__počtu_, _बिबिधता_, --, 
   {{0x4a3dc01c,0x5238000f,0x00000000,0x00000000}},	//   _तुम_, _ake__sithi_, --, --, 
   {{0x0a4d4022,0xb3942009,0x00000000,0x00000000}},	//   _के__देश_, _rejse_, --, --, 
   {{0x87cb6011,0x00000000,0x00000000,0x00000000}},	//   _castelán_, --, --, --, 
   {{0xa312400f,0x00000000,0x00000000,0x00000000}},	//   _kwelinye__izwe_, --, --, --, 
   {{0x5c3c400f,0x00000000,0x00000000,0x00000000}},	//   _izinceku_, --, --, --, 
   {{0xf29f8009,0x92990003,0xcb850002,0x00000000}},	// [890] _skriv__besked_, _འཛུལ__མིང_, _служба_, --, 
   {{0x6b69e011,0xe3a62004,0x3df1a00e,0xeedf000f}},	//   _ligazóns_, _ke__ukufika_, _sledovat_, _ngezinga__elithile_, 
   {{0x326ce00f,0x7dc2a015,0x129e400f,0x00000000}},	//   _jehova_, _kebijaka, _ukuphila__kwakho_, --, 
   {{0x9a3d200a,0xf57e000a,0xd60f800a,0x00000000}},	//   _हुई_, _सबसे__ज्यादा_, _की__शहादत_, --, 
   {{0x82e7800f,0x8c6f802c,0x00000000,0x00000000}},	//   _eqiniso_, _imirimo_, --, --, 
   {{0xd28da01e,0x8b9fc018,0xc287e018,0x00000000}},	//   _nja__naslov_, _banheiro_, _ele__não_, --, 
   {{0x0a3d200a,0xadde6002,0xb48de012,0x00000000}},	//   _हुए_, _да__су_, _aj__pre_, --, 
   {{0xd2f1000f,0x00000000,0x00000000,0x00000000}},	//   _yiziphi_, --, --, --, 
   {{0x42be2024,0xb3052015,0x5b6b4011,0x9b994003}},	//   _pre__dana_, _laporkan__iklan_, _en__calquera_, _ཕྲན__བུ_, 
   {{0xd307400e,0x00000000,0x00000000,0x00000000}},	//   _stránce__chyba_, --, --, --, 
   {{0xe467601a,0x00000000,0x00000000,0x00000000}},	//   _dei__til_, --, --, --, 
   {{0x4a88a00a,0x00000000,0x00000000,0x00000000}},	//   _दुनिया__खेल_, --, --, --, 
   {{0x7e72e002,0xa705a00c,0x00000000,0x00000000}},	//   _се_, _भोज__जाति_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x1d5a2002,0x00000000,0x00000000,0x00000000}},	//   _нове_, --, --, --, 
   {{0x5fe68002,0x00000000,0x00000000,0x00000000}},	//   _српску_, --, --, --, 
   {{0x3275a00f,0x8522200a,0x00000000,0x00000000}},	// [8a0] _abantu__abaningi_, _लायक__अन्य_, --, --, 
   {{0x226ce00b,0x18ce200c,0x00000000,0x00000000}},	//   _yehova_, _कीकट_, --, --, 
   {{0x58498003,0x00000000,0x00000000,0x00000000}},	//   _ཟླ__སྤྱི_, --, --, --, 
   {{0x22502002,0x00000000,0x00000000,0x00000000}},	//   _нема_, --, --, --, 
   {{0xaa140018,0xd708000c,0x00000000,0x00000000}},	//   _não__está_, _के__सीधा_, --, --, 
   {{0x227ee02a,0x83a82012,0xcaa2a00c,0x00000000}},	//   _funnet_, _sk__všetky_, _नइखे__भोज_, --, 
   {{0x42980012,0x90ae6002,0xebfa200c,0x00000000}},	//   _vďaka_, _ла__фотограф, _दूनो__के_, --, 
   {{0xa394002c,0xe2aba016,0xb46fa018,0x00000000}},	//   _afise_, _siden__innlegg_, _adiciona_em_, --, 
   {{0x23f8201d,0x00000000,0x00000000,0x00000000}},	//   _tajuk_, --, --, --, 
   {{0x63266009,0x0adda026,0x02a5e003,0x00000000}},	//   _at__vide_, _fødselsd, _ཞུས__ཡོད_, --, 
   {{0x7288a00f,0xc200c00b,0x3320800f,0x00000000}},	//   _ekhasini_, _indi_, _hhayi_, --, 
   {{0xf2d7400e,0xee3a8002,0x00000000,0x00000000}},	//   _třeba_, _рекао__да_, --, --, 
   {{0xf2e68012,0x00000000,0x00000000,0x00000000}},	//   _viac__info_, --, --, --, 
   {{0x1c160003,0xe5dc200e,0x581b000a,0x4c10000c}},	//   _སྐབས__སུ_, _vybírat__nejlepší_, _संबंधित__जानकारी_, _साहित्य__विषय_, 
   {{0x02fce019,0x00000000,0x00000000,0x00000000}},	//   _legge_, --, --, --, 
   {{0x7a68400c,0x00000000,0x00000000,0x00000000}},	//   _अउर__ओकर_, --, --, --, 
   {{0x9c48e014,0x00000000,0x00000000,0x00000000}},	// [8b0] _संडे_, --, --, --, 
   {{0x87404006,0x00000000,0x00000000,0x00000000}},	//   _ཡིག__སྣོད_, --, --, --, 
   {{0x99224014,0x72e70015,0x00000000,0x00000000}},	//   _इतिहासका, _rp__juta_, --, --, 
   {{0x1ef1e00c,0x3a79c012,0x491fa00c,0x00000000}},	//   _विश्वामि, _darček_, _से__भोजपुर_, --, 
   {{0x1452c024,0xf462201d,0x2321e017,0xb691c00c}},	//   _strana__od_, _dilog__masuk_, _boty_, _के__भाषाई_, 
   {{0x47606018,0x7b99c003,0x00000000,0x00000000}},	//   _de__seguranç, _དོན__དུ_, --, --, 
   {{0x82ed4012,0x00000000,0x00000000,0x00000000}},	//   _mesiace_, --, --, --, 
   {{0xa2612003,0x00000000,0x00000000,0x00000000}},	//   _རྒྱུས__བོད_, --, --, --, 
   {{0x329e401a,0x4389c009,0x5e7c400c,0x7bd9c003}},	//   _det__ikkje_, _søgning_, _भीष्म_, _བོད__དུ_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x4c25a011,0x0dd5c002,0x00000000,0x00000000}},	//   _obradoir, _на__територи, --, --, 
   {{0x1c39803d,0x78d0000a,0x025f8003,0x7b8c800c}},	//   _kombinac, _बच्चों_, _ཁང__གིས_, _ओऽ_, 
   {{0x72e76011,0x00000000,0x00000000,0x00000000}},	//   _xornada_, --, --, --, 
   {{0x9272402a,0x47d50002,0x833de00d,0xf2a2e003}},	//   _en__rekke_, _википода_библиогр, _la__familia_, _སྤྱོད__མཁན_, 
   {{0xd29a8003,0xd7a46002,0x00000000,0x00000000}},	//   _བོད__སྐད_, _независн, --, --, 
   {{0x3b486012,0x43360028,0x58706003,0xdcf4600e}},	//   _musíte__prihlási, _el__perfil_, _མཛོད__སྤྱི_, _úřad_, 
   {{0xa258a003,0x00000000,0x00000000,0x00000000}},	// [8c0] _རྒྱ__བོད_, --, --, --, 
   {{0x52296009,0xe9fd202c,0x1bb1e003,0x00000000}},	//   _væk_, _gatandat, _ཕྱོགས__སུ_, --, 
   {{0xf213000e,0x00000000,0x00000000,0x00000000}},	//   _bychom_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x84420011,0x929b4012,0xecbce00f,0xd493c00b}},	//   _moi_, _izbový_, _kukajesu_, _ubwoko__bw_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xcbcc6014,0xa29fa003,0x00000000,0x00000000}},	//   _उम्_, _གང__ཞིག_, --, --, 
   {{0x2befa00c,0x6bcf6003,0x00000000,0x00000000}},	//   _तऽ__हम_, _གཞན__ཁག_, --, --, 
   {{0xb2592003,0x00000000,0x00000000,0x00000000}},	//   _ཁྱེད__ཀྱི_, --, --, --, 
   {{0xa2d98017,0x3356800b,0x00000000,0x00000000}},	//   _firem_, _buhe__buryo_, --, --, 
   {{0xf373c012,0xf2c9e00b,0x068c0022,0x8252200f}},	//   _žiadne_, _vyacu__umva_, _बेताब_, _ingabe__lokhu_, 
   {{0xfb9fc00c,0x00000000,0x00000000,0x00000000}},	//   _मालवा__से_, --, --, --, 
   {{0x4141e002,0x6a64a00c,0xebf6c00c,0x00000000}},	//   _иницијат, _बहुते__बड़_, _गजेटियर__के_, --, 
   {{0x3b8ea04f,0xb310600f,0x00000000,0x00000000}},	//   _लग_, _ukuzwa_, --, --, 
   {{0x8ed5c019,0xd386e018,0x00000000,0x00000000}},	//   _kopierin, _bairro_, --, --, 
   {{0xb4444018,0xd25ee029,0x1d46c002,0x12e3000e}},	//   _em_, _ཁོར__ཡུག_, _српске_, _policie_, 
   {{0xf6c2800f,0xed98401a,0x0361a002,0xd506200b}},	// [8d0] _ujeremiy, _allereie_, _основу_, _mu__muryango_, 
   {{0xd334a009,0x426ce00f,0x9bf1c00c,0x00000000}},	//   _inkl__fragt_, _ikhono_, _नइखे__कि_, --, 
   {{0xa24cc021,0x00000000,0x00000000,0x00000000}},	//   _ཏའི_, --, --, --, 
   {{0x8496e005,0x7a29c00a,0xa2646003,0x00000000}},	//   _om__eg_, _फतेहपुर_, _སྒྲིག__འདི_, --, 
   {{0x0cb72022,0x2349400f,0x2984800a,0x00000000}},	//   _में__कहीं_, _ngendlel_efanele_, _बाराबंकी__बिजनौर_, --, 
   {{0x5442000f,0x00000000,0x00000000,0x00000000}},	//   _joh_, --, --, --, 
   {{0xebc06014,0xbd76a00e,0x00000000,0x00000000}},	//   _शक्ति__के_, _umění_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xe489c019,0xa493a01a,0x43268009,0x0299e012}},	//   _finner__du_, _på__dei_, _at__sige_, _svojím_, 
   {{0xff6ca018,0x47656018,0x00000000,0x00000000}},	//   _detalhes_, _de__fabricaç, --, --, 
   {{0x8444401d,0x13a20024,0x6420e006,0xb202000b}},	//   _rm_, _gripa_, _བརྒྱའི__རྒྱལ_, _misiri_, 
   {{0xec0ee014,0xe477e01a,0x00000000,0x00000000}},	//   _शास्त्र__के_, _omsyn__til_, --, --, 
   {{0xb2018024,0xb303a011,0xc2844018,0x544f400e}},	//   _kurir_, _desde__túa_, _ainda__não_, _ať_, 
   {{0x44b0800e,0x00000000,0x00000000,0x00000000}},	//   _můžete_, --, --, --, 
   {{0xb3232002,0x0abc8014,0x575e8003,0x00000000}},	//   _odgovora__poslednj, _अभाव__में_, _ཡང__སྲིད_, --, 
   {{0x6c6e4031,0xef51c00a,0xd467e011,0x00000000}},	//   _amerika_, _देंगे_, _coa__que_, --, 
   {{0xafe6400e,0xd14fe00c,0x00000000,0x00000000}},	// [8e0] _příspěvk_registro, _के__दरभंगा_, --, --, 
   {{0xb4444018,0xc201e009,0x2a27c002,0x00000000}},	//   _um_, _butik_, _може__бити_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x3c04400c,0x00000000,0x00000000,0x00000000}},	//   _कहवां__बा_, --, --, --, 
   {{0x44420004,0xcced8037,0x00000000,0x00000000}},	//   _yoh_, _comparti_guardar_, --, --, 
   {{0xf2a10021,0x00000000,0x00000000,0x00000000}},	//   _ཆོས__སྒར_, --, --, --, 
   {{0x74422039,0x6bab600e,0xe21bc00f,0x00000000}},	//   _kok_, _další__informac, _kwathi__lapho_, --, 
   {{0x8d492002,0x00000000,0x00000000,0x00000000}},	//   _про_, --, --, --, 
   {{0x827e801b,0xc493a019,0x1b9e200a,0xe23ca00f}},	//   _njani_, _på__vei_, _के__एक_, _encwadin_yakhe_, 
   {{0xf591c00f,0x00000000,0x00000000,0x00000000}},	//   _yonke__inhliziy, --, --, --, 
   {{0x0b6b6009,0x00000000,0x00000000,0x00000000}},	//   _annoncer, --, --, --, 
   {{0xe27e600f,0xebbb0006,0xd3454010,0x22cda00c}},	//   _indodana__yakhe_, _དེ__གི_, _ved__ikke_, _के__केहू_, 
   {{0xe28e4003,0x5fd4600e,0xa733200c,0x00000000}},	//   _གསལ__བཤད_, _obchodů_, _कइलस__एकरा_, --, 
   {{0xb2e84024,0x42314037,0x426d0018,0x00000000}},	//   _poslednj, _la__autoprom, _pacote_, --, 
   {{0x9f8be00e,0x2c75a00e,0xedd4e006,0xa303a00e}},	//   _své_, _hlavní_, _ཅི__འབྲེལ_, _opravdu_, 
   {{0x4497e009,0x00000000,0x00000000,0x00000000}},	//   _ud__af_, --, --, --, 
   {{0x48c7c014,0x52dfa037,0x32d8e009,0x00000000}},	// [8f0] _भोजपुर_, _junio__mayo_, _piger_, --, 
   {{0xc4aa0012,0x4cde2012,0x00000000,0x00000000}},	//   _prísluše, _kúpiť_, --, --, 
   {{0xf371e007,0xa25b601f,0xb873c025,0x2bc54006}},	//   _lagi__dengan_, _amalan_, _procurar_, _ཁུངས__རེ_, 
   {{0xe48e6019,0x9291a018,0x8bc0c00a,0x3bdfe00c}},	//   _da__er_, _título__comentár, _करने__का_, _से__बा_, 
   {{0xc698a012,0x2ed9c00b,0x12d90025,0x8248c012}},	//   _košíka_, _hafi__icarimwe_, _dizer_, _viem_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x9e61e012,0xd595c00e,0x00000000,0x00000000}},	//   _osôb_, _vzhledem_, --, --, 
   {{0xf33de038,0x02b2a01a,0x00000000,0x00000000}},	//   _en__galicia_, _avbryt__koplar_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x93774009,0x64bce011,0xf3f9000b,0x00000000}},	//   _vigtigst_ting_, _proxecto__de_, _zaburi_, --, 
   {{0xe3afa01e,0xeb98000c,0x151d800f,0xbcbec00a}},	//   _ispisa__čpp_, _परिचय__के_, _ngabe__ababuyek, _मां__तुझे_, 
   {{0x32d82039,0x1ecb400c,0x7bf50003,0x00000000}},	//   _paket_, _से__युद्ध_, _བར__དུ_, --, 
   {{0xf85d800f,0x00000000,0x00000000,0x00000000}},	//   _nkulunku, --, --, --, 
   {{0x98f42002,0x00000000,0x00000000,0x00000000}},	//   _академиј, --, --, --, 
   {{0x527f400d,0xb44ac01a,0x00000000,0x00000000}},	//   _fuente_, _meiner__at_, --, --, 
   {{0x730c201d,0x2445600b,0x00000000,0x00000000}},	//   _saya__kekal_, _bavuga__ko_, --, --, 
   {{0xec0d800a,0x5409200e,0x7a53000a,0x00000000}},	// [900] _बनाने__के_, _nejoblíb_výrobci_, _ये__हैं_, --, 
   {{0x19f90002,0x00000000,0x00000000,0x00000000}},	//   _сваки__нови_, --, --, --, 
   {{0x82926015,0x329f4005,0xfbb6000a,0x00000000}},	//   _desain_, _kan__ikkje_, _विकिपीडि_से_, --, 
   {{0x6ecac012,0x00000000,0x00000000,0x00000000}},	//   _webnovin, --, --, --, 
   {{0x7eaee00a,0x00000000,0x00000000,0x00000000}},	//   _सितम्बर__अगस्त_, --, --, --, 
   {{0x7bd54003,0xf446600b,0x00000000,0x00000000}},	//   _ཆེད__དུ_, _yaravuze__ati_, --, --, 
   {{0xf3fd6016,0xc27fe01a,0x329ec005,0xdb574028}},	//   _finn__flere_, _vatn_, _har__ikkje_, _dormitor, 
   {{0xc2e7800f,0x8c72a00d,0xb25a4011,0x00000000}},	//   _iqiniso_, _puertas_, _fillo_, --, 
   {{0x5ab2c01d,0x7b18a003,0xc53ea014,0xcc974002}},	//   _berkongs, _བཅུ__གཅིག_, _में__दुनिया_, _пријатељ, 
   {{0x524e8004,0x63f46018,0xf47a2010,0x42d9c009}},	//   _uyesu__wathi_, _curtir_, _info__fra_, _givet_, 
   {{0x23478012,0xc2942003,0x1c03e00c,0x3ff3200c}},	//   _čierna_, _བསལ__གྱི_, _तीन__गो_, _शासन__स्थापित_, 
   {{0xc243e006,0x46142011,0x00000000,0x00000000}},	//   _གཏང_, _avaliaci, --, --, 
   {{0x62fd200f,0x00000000,0x00000000,0x00000000}},	//   _ujohane_, --, --, --, 
   {{0xa2f1800f,0x7c078002,0x720ea00c,0x00000000}},	//   _yisiphi_, _је__само_, _अउर__दोसर_, --, 
   {{0x122b800d,0xa2f86016,0x727fe015,0x0a68a00c}},	//   _siempre_, _mms__bilde_, _ujung_, _मामिला__में_, 
   {{0x6477803c,0x6cb00024,0xf875e009,0x00000000}},	//   _informac_iz_, _kuhinjsk_aparati_, _pluspris_, --, 
   {{0x81000006,0x00000000,0x00000000,0x00000000}},	// [910] _ཎེ__གྲྭ_, --, --, --, 
   {{0xab88a003,0x00000000,0x00000000,0x00000000}},	//   _སྔོན__བྱུང_, --, --, --, 
   {{0xf4424018,0x00000000,0x00000000,0x00000000}},	//   _bom_, --, --, --, 
   {{0x6c48c00a,0xbb9a2006,0x6d918003,0x993fa00e}},	//   _होने_, _དོན__ཚུ_, _གཉིས__ཀྱིས_, _nejlepší__mobilní_, 
   {{0x14424012,0xb2fce015,0xe29f8006,0x00000000}},	//   _dom_, _share__iklan_, _སྦི__མཁར_, --, 
   {{0x36690011,0x1cd8a01d,0xd29ac00e,0x00000000}},	//   _da__foundati, _perminta_rujukan_, _děkuji_, --, 
   {{0x7835800c,0xa73e200c,0x00000000,0x00000000}},	//   _राहुल__सांकृत्_, _चेरो__जाति_, --, --, 
   {{0x8300a039,0x85fe4009,0x527a000a,0xbad30002}},	//   _tidak__bisa_, _tilmeldi, _धर्मयात्_सिनेमा_, _из__области_, 
   {{0x3ab2c01d,0xb4772009,0xb275e011,0x8264600f}},	//   _perkongs, _svært__at_, _obrigato_sitio_, _ngolunye__usuku_, 
   {{0xfb9d2006,0x00000000,0x00000000,0x00000000}},	//   _གླིང__པར_, --, --, --, 
   {{0x7b782003,0xb1770002,0xe46f601a,0x9baca003}},	//   _བགྲོ__གླེང_, _нешто_, _kva__er_, _རྩོམ__སྣ_, 
   {{0xc4052003,0x00000000,0x00000000,0x00000000}},	//   _སྡུག__བསྔལ_, --, --, --, 
   {{0x047e0002,0xd29e0002,0xea1e0002,0x8442403d}},	//   _било_, _била_, _били_, _kol_, 
   {{0x4464c009,0x3df8c002,0x00000000,0x00000000}},	//   _køb__af_, _никада__није_, --, --, 
   {{0xd493c009,0x6467c011,0x00000000,0x00000000}},	//   _på__vej_, _xornada__de_, --, --, 
   {{0x0c0d0003,0xee462002,0xcec98002,0x8bdba00c}},	//   _རྟགས__ཅན_, _желите__да_, _податков_проблем_, _के__आवे_, 
   {{0x9293000f,0x00000000,0x00000000,0x00000000}},	// [920] _nakho__konke_, --, --, --, 
   {{0x8999200e,0xe289401a,0x00000000,0x00000000}},	//   _když_, _så__mykje_, --, --, 
   {{0xe7cf0003,0x00000000,0x00000000,0x00000000}},	//   _ཟླ__བདུན_, --, --, --, 
   {{0x3494e030,0xc7e56003,0xd3ce0009,0x00000000}},	//   _pridruže_vrh_, _བཀའ__དྲིན_, _tvivl_, --, 
   {{0xf4424012,0xb2018018,0x00000000,0x00000000}},	//   _bol_, _assim_, --, --, 
   {{0x82d8401a,0xf7bc0024,0xd73ac003,0x1c69a015}},	//   _talet_, _kragujev, _འབོད_, _berisi__liputan_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xebfaa00a,0xa1028002,0x7e37401d,0xfff9800c}},	//   _देने__के_, _постоји_, _kerana__mengguna, _बलुक_, 
   {{0x8259800f,0x00000000,0x00000000,0x00000000}},	//   _izinto__ezimbi_, --, --, --, 
   {{0xc2002031,0xc4a22037,0x7ce8a00b,0x9b19c003}},	//   _laki_, _recibir__una_, _kugwanir, _ཞིབ__འཇུག_, 
   {{0x5317200f,0x689b800f,0xba3c400a,0xf1632002}},	//   _kancane_, _ikakhulu, _आया_, _буду_, 
   {{0xeda80002,0x6cede00e,0x00000000,0x00000000}},	//   _зато__што_, _telefony__samsung_, --, --, 
   {{0xebeb8014,0x76b04009,0x82d9e009,0x00000000}},	//   _कमेटी__के_, _kærlighe, _titel_, --, 
   {{0x95a2e013,0x00000000,0x00000000,0x00000000}},	//   _चाहता_, --, --, --, 
   {{0x634a0011,0xa74ba00a,0x00000000,0x00000000}},	//   _comezou_, _कहा__जाता_, --, --, 
   {{0xc2b5200a,0x00000000,0x00000000,0x00000000}},	//   _मऊ__मुजफ्फरन, --, --, --, 
   {{0x3b88000c,0x40ae2002,0x582e2002,0x4a3d400a}},	// [930] _बा_, _срба_, _срби_, _रखा_, 
   {{0xa4426004,0x7386c009,0x62d84011,0x00000000}},	//   _loo_, _sker_, _cales_, --, 
   {{0xc455000d,0xc3a6a00d,0xb310801d,0x00000000}},	//   _producto_, _la__página_, _seterusn_suka_, --, 
   {{0xa291a015,0x8410a01d,0xa2f6800c,0x7a15a003}},	//   _kapan_, _daripada__http_, _है__टुटी_, _ཀུན__དགའི_, 
   {{0x12c5001d,0x5ba06013,0xfba2c003,0x6d8fc003}},	//   _berhubun_lihat_, _है__या_, _འདྲ__པར_, _ཉིད__ཀྱིས_, 
   {{0xf24e4003,0x00000000,0x00000000,0x00000000}},	//   _རེད_, --, --, --, 
   {{0xb4a36002,0x32918015,0x4ef8e002,0x512f200a}},	//   _društvo__pre_, _saran_, _министар, _जैसलमेर__जालंधर_, 
   {{0x9386c016,0xa179c002,0x4c824012,0x00000000}},	//   _uker_, _једном_, _redakčný__systém_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x24424018,0x00000000,0x00000000,0x00000000}},	//   _uol_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x225ce003,0xa43ec002,0x00000000,0x00000000}},	//   _གཞིས__ལུས_, _јавне_, --, --, 
   {{0x524e6006,0x34998004,0xc2f02018,0xaf0ae002}},	//   _ལེབ_, _to__get_, _boa__tarde_, _али__то_, 
   {{0x9c9ac003,0xea76a00c,0x00000000,0x00000000}},	//   _འབུལ_, _कुल__तीन_, --, --, 
   {{0xebdb4014,0x7248000f,0xfb99e006,0xa2856003}},	//   _बातचीत__के_, _thim_, _ཁའི__ཡུ_, _གཞན__ཞིག_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x1690c003,0x0492000b,0xd2a00003,0xa2de200c}},	// [940] _ཡིག__སློབ_, _kugeza__ubu_, _སྤེལ__བའི_, _टुटी_, 
   {{0x125b0012,0xeda8c031,0xec05000c,0x00000000}},	//   _ďalej_, _aktivita, _जाए__के_, --, 
   {{0x97dde040,0x83202017,0x9bce6003,0x00000000}},	//   _mihajlov, _taky_, _རིག__ལས_, --, 
   {{0x7480c02c,0x3beee003,0x00000000,0x00000000}},	//   _kuva__mu_, _ཚང__མས_, --, --, 
   {{0x9b9dc006,0x00000000,0x00000000,0x00000000}},	//   _བྱུང__ལས_, --, --, --, 
   {{0xc4426011,0x74da2002,0x00000000,0x00000000}},	//   _non_, _својом_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xfaed400a,0x2201600b,0x7487a00a,0x00000000}},	//   _और__कश्मीर_, _bagira_, _सेवाएँ_, --, 
   {{0xd3082045,0x00000000,0x00000000,0x00000000}},	//   _asmira__reklama_, --, --, --, 
   {{0x72780007,0xab7e2004,0x62ca8005,0xe4acc012}},	//   _nama__cari_, _kufuneka_, _stad_, _alebo__na_, 
   {{0x02c52003,0xee8c400a,0x00000000,0x00000000}},	//   _ཁོང__གིས_, _है__पृष्ठ_, --, --, 
   {{0x23a26015,0x9776800c,0x00000000,0x00000000}},	//   _eropa_, _से__जुड़_, --, --, 
   {{0xd200400f,0x00000000,0x00000000,0x00000000}},	//   _lami_, --, --, --, 
   {{0x24508034,0xc3eec002,0x00000000,0x00000000}},	//   _varsle__meg_, _одбране_, --, --, 
   {{0xf200400f,0xa394e018,0x00000000,0x00000000}},	//   _nami_, _quiser_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [950] --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x3200400f,0x43eae009,0x94b2c011,0x00000000}},	//   _bami_, _kritik_, _datos__ou_, --, 
   {{0xaa640011,0x00000000,0x00000000,0x00000000}},	//   _non__está_, --, --, --, 
   {{0x7a70800a,0xb4f7a002,0x00000000,0x00000000}},	//   _कहते__हैं_, _метохији_, --, --, 
   {{0x16bd8012,0x9bbd8006,0x00000000,0x00000000}},	//   _prístup_, _ལུ__མི_, --, --, 
   {{0x033a400f,0x52c2800a,0xedd62003,0x00000000}},	//   _kungase__kube_, _गैलरी__सिनेमा_, _འཛིན__སྐྱོང_, --, 
   {{0xfae6e01d,0xd4adc018,0x00000000,0x00000000}},	//   _ahli__linkedin_, _serviço_, --, --, 
   {{0x6bd7a011,0x00000000,0x00000000,0x00000000}},	//   _galicia__informac, --, --, --, 
   {{0xb200400f,0xbbf4e006,0x00000000,0x00000000}},	//   _zami_, _གུ__ཚུ_, --, --, 
   {{0xb2d9800b,0xa200400f,0x137d8018,0x8221400f}},	//   _aires_, _yami_, _citado__citando_, _ukuthi__lokhu_, 
   {{0xa4428011,0xcf06e002,0xb43bc00a,0x00000000}},	//   _coa_, _остава__има_, _का__जवाब_, --, 
   {{0x6b884003,0x34acc012,0x744a400b,0x4682e00c}},	//   _རྡ_, _alebo__sa_, _abantu__mu_, _महज__फीसदी_, 
   {{0x0c74200f,0x15de8017,0x32e6800f,0x00000000}},	//   _ngenxa__yokuthi_, _zajišťuj, _kwaba__khona_, --, 
   {{0xe2004012,0x63574014,0x2f2f2006,0x4bed4003}},	//   _mali_, _नोटिस__जारी_, _ཕྱོགས__འགྲུལ_, _སྤྲེལ__ལོ_, 
   {{0xf0dde02d,0xd4686011,0x9481c00b,0x00000000}},	//   _branitel, _ata__que_, _muri__bo_, --, 
   {{0x22d8e028,0x1410a02a,0x00000000,0x00000000}},	// [960] _quiero_, _dessuten_, --, --, 
   {{0x4200400f,0x00000000,0x00000000,0x00000000}},	//   _sami_, --, --, --, 
   {{0xd16b400a,0xb3daa017,0x6a3e600c,0x7bdbe003}},	//   _पलवल__पानीपत_, _si__vybrat_, _बड़_, _མཐུད__དུ_, 
   {{0x260f403f,0x62d8800b,0x6a5d601a,0x00000000}},	//   _ezilungi, _muhezo_, _områda_, --, 
   {{0x32004015,0x32fea00f,0x00000000,0x00000000}},	//   _bali_, _sithole_, --, --, 
   {{0x8200400f,0x1488c037,0xc24ea003,0x00000000}},	//   _wami_, _recibo__mi_, _ལྡན__གྱི_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xfc56000c,0xb4bca00f,0x00000000,0x00000000}},	//   _कइलें_, _noma__uma_, --, --, 
   {{0x22c3a00f,0x368fe002,0x6488e00c,0x00000000}},	//   _sihloko_, _датотека__филма_, _के__मातृशोक_, --, 
   {{0x4a172014,0x00000000,0x00000000,0x00000000}},	//   _रुद्रपुर_, --, --, --, 
   {{0xd2d46002,0x54c1400f,0x6db0800b,0x00000000}},	//   _подели__везу_, _kuya__ku_, _yafashwe_, --, 
   {{0x75c62008,0x553ea002,0x00000000,0x00000000}},	//   _de__santiago_, _devojčic, --, --, 
   {{0x4089800f,0xa2474003,0x00000000,0x00000000}},	//   _ezinsukw_zokugcin, _ཆག__རྩོམ_, --, --, 
   {{0x89fdc011,0x3a4b800c,0x00000000,0x00000000}},	//   _orzament, _के__आपन_, --, --, 
   {{0x5adca003,0xc2614011,0xa0b22002,0x00000000}},	//   _འཛུགས_, _os__máis_, _јул__текст_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xecf1a009,0x00000000,0x00000000,0x00000000}},	// [970] _modtager, --, --, --, 
   {{0xd2f0e00e,0xbdc38031,0x5771e003,0x00000000}},	//   _kariéra__reklama_, _terimaka, _ལོ__ཕྱེད_, --, 
   {{0xe69cc00c,0x00000000,0x00000000,0x00000000}},	//   _के__परमार_, --, --, --, 
   {{0x6ef2a00a,0x00000000,0x00000000,0x00000000}},	//   _जिसका_, --, --, --, 
   {{0x33cd2034,0x12a2c006,0x527c800f,0xb2428003}},	//   _kommune__hopp_, _གཡོགཔ__ལྷན_, _ujehova__wathi_, _བཞད_, 
   {{0xf7bb2022,0x3367a011,0xae010018,0x5317e00b}},	//   _बांग्ला_, _cunha__receita_, _por__telefone_, _umubiri_, 
   {{0xebddc00a,0xd9f46012,0xa98b400f,0x6c85600f}},	//   _बनाया_, _okná_, _nomkhaya_, _komunye__nomunye_, 
   {{0x0243e03a,0x42640012,0x36f9800c,0x00000000}},	//   _གཏམ_, _úplne_, _कि__मिहिर_, --, 
   {{0x5442a03d,0x8dbce006,0x00000000,0x00000000}},	//   _moc_, _བརྒྱུད__རིངས_, --, --, 
   {{0xd39cc018,0xfbffc00c,0x78514018,0x3372c00f}},	//   _informaç_sobre_, _चैनल__से_, _associad, _ukuze__sithole_, 
   {{0x92a6e015,0x9bb1c020,0x00000000,0x00000000}},	//   _di__follow_, _ལམ__ལས_, --, --, 
   {{0x4c776015,0x08e9a012,0x0d64400e,0x00000000}},	//   _populer_, _pomôcky_, _začíná_, --, 
   {{0xa31a6012,0xfb97c003,0x00000000,0x00000000}},	//   _na__predaj_, _གཞུང__དང_, --, --, 
   {{0x0c06e012,0x00000000,0x00000000,0x00000000}},	//   _potreby_, --, --, --, 
   {{0xec36003c,0xa316e00f,0xe27c800f,0xda9ba00c}},	//   _se__komentar, _imizwa_, _kakhulu__futhi_, _जा__सकत_, 
   {{0x726f000f,0xb442a025,0x0a7a8014,0x00000000}},	//   _eziningi_, _sob_, _अहमदाबाद__में_, --, 
   {{0x8437001f,0x3b8fe003,0xd2de0013,0x279ae00a}},	// [980] _yang__betul_, _སམ_, _चुकी_, _संवाद__संस्करण_, 
   {{0x82a6c01a,0xb4be4009,0x9bf1c003,0x00000000}},	//   _tilbod_, _sige__at_, _ཆར__ཚད_, --, 
   {{0x39f4a012,0xeda88002,0x3eae0002,0x00000000}},	//   _chcú_, _тако__што_, _преведен_на_, --, 
   {{0x44262019,0xa2faa01a,0x59f4a00e,0xda9b200a}},	//   _mest__lest_, _kan__vera_, _akcí_, _निवेदन__दान_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x9ce8c003,0x0c48c00c,0x0a48000c,0x00000000}},	//   _སློབ__གཉེར_, _होले_, _बरिस__में_, --, 
   {{0xbefc2002,0x52918012,0x00000000,0x00000000}},	//   _руски_, _úrad_, --, --, 
   {{0x8b8d600c,0x6bf52003,0x00000000,0x00000000}},	//   _कऽ_, _ཚབ__ཏུ_, --, --, 
   {{0x52d8a00d,0x971ea022,0xe2e9e025,0x64b24018}},	//   _hacer_, _जुड़_, _caminho_, _mensagen_de_, 
   {{0x1455801a,0xe358200e,0x00000000,0x00000000}},	//   _eit__nytt_, _dopravní_, --, --, 
   {{0x12e0a025,0x92e4a00a,0x00000000,0x00000000}},	//   _na__hora_, _शर्ते__लागू_, --, --, 
   {{0x7b4e6027,0x00000000,0x00000000,0x00000000}},	//   _slovakia_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x32d8a011,0x5c64e00a,0x72b1c012,0x00000000}},	//   _facer_, _का__सबसे_, _dopravy__obchodu_, --, 
   {{0x6442c010,0xa7304003,0xfa468012,0x00000000}},	//   _mod_, _རིག__འགྲན_, _novembra_, --, 
   {{0x04b60015,0x00000000,0x00000000,0x00000000}},	//   _tokobagu_com_, --, --, --, 
   {{0xe380601f,0x2c49e00a,0xbbc0600a,0xb2ce000f}},	// [990] _syurga_, _पूरे_, _पृष्ठ__पर_, _le__nkinga_, 
   {{0xd473e018,0x6499e018,0x00000000,0x00000000}},	//   _acho__que_, _um__de_, --, --, 
   {{0xb3c5601a,0xc762800c,0x00000000,0x00000000}},	//   _sist__endra_, _परमारवंश_राजा_, --, --, 
   {{0xf79ee002,0x93fa602a,0x02d9a024,0x00000000}},	//   _треба_, _seg__selv_, _saveti_, --, 
   {{0x62576003,0x00000000,0x00000000,0x00000000}},	//   _གླེང__གསར_, --, --, --, 
   {{0x9300a012,0x1bd68003,0xef1a8002,0x91afe002}},	//   _príspevk_profil_, _ཡོངས__སུ_, _својој_, _здравље_, 
   {{0x4b886022,0x66ec600c,0x00000000,0x00000000}},	//   _भा_, _एह__लोगिन_, --, --, 
   {{0xaa3d6022,0xd468e011,0x049cc002,0x00000000}},	//   _दर्जा_, _hai__que_, _члана_, --, 
   {{0xca68401e,0x634f8009,0xbed58012,0xe467e009}},	//   _pridruže_lokacija_, _ikke__noget_, _veľa_, _dig__til_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7851c00c,0x00000000,0x00000000,0x00000000}},	//   _आयकर__रिटर्न_, --, --, --, 
   {{0x7ab5a00a,0x1f69e018,0x00000000,0x00000000}},	//   _करें__त्वरितवा, _tamanhos_, --, --, 
   {{0xfba2e03a,0xa1c16031,0x00000000,0x00000000}},	//   _རྒྱ__ནག_, _terendah_, --, --, 
   {{0x3fc3e011,0x00000000,0x00000000,0x00000000}},	//   _alí_, --, --, --, 
   {{0x5499e00e,0xf443e004,0x72e0a011,0x00000000}},	//   _to__se_, _olu_, _na__nosa_, --, 
   {{0x7442c016,0x825ac012,0x00000000,0x00000000}},	//   _noe_, _biele_, --, --, 
   {{0x9767600c,0xcd2dc002,0x00000000,0x00000000}},	// [9a0] _के__विद्वान_, _између__осталог_, --, --, 
   {{0x4066200c,0xeff00002,0x00000000,0x00000000}},	//   _राज्य__स्थापित_, _тешко_, --, --, 
   {{0x54a8c02e,0xebfb8006,0xf29e8020,0x1fcf0012}},	//   _prijavi__se_, _ཚུ__གི_, _རྗེ__མཁན_, _obrázok_, 
   {{0xc4956019,0x4a28a01a,0x1c04600b,0x076fe00c}},	//   _om__nye_, _på__nettstad, _kanseri_, _दरभंगा__मॉड्यूल_, 
   {{0x287b2002,0x4efb2002,0xd8348002,0x00000000}},	//   _страна_, _страни_, _култура_, --, 
   {{0x0512800f,0x5e97400e,0x0a41e00c,0x00000000}},	//   _umhlatsh, _zeptejte_, _के__खोज_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x22d9c009,0xd355c018,0x12e1600a,0x00000000}},	//   _giver_, _confira_, _दसवीं_, --, 
   {{0xbc772028,0x7200a00f,0xc27ee016,0x9321801a}},	//   _mensaje_, _kabi_, _hennes_, _og__korleis_, 
   {{0x14b7c005,0x00000000,0x00000000,0x00000000}},	//   _fram__med_, --, --, --, 
   {{0xd3136009,0xf3c60011,0xe300a011,0xe454600f}},	//   _skal__have_, _debe__darse_, _cultura__galega_, _ibonisa__ukuthi_, 
   {{0xe1a3201e,0x82162018,0xabd2200a,0x00000000}},	//   _na__vlastito, _conhecim, _पाठकों__की_, --, 
   {{0xde292002,0xf2b06012,0x00000000,0x00000000}},	//   _над_, _vedieť_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x72924018,0x50fac006,0x2ebb0002,0x00000000}},	//   _estava_, _འབདཝ_, _било__је_, --, 
   {{0xb245201a,0xee624002,0x2a3d4014,0xbba0a00c}},	//   _dømes_, _lepota__zdravlje_, _लाग_, _नवरत्न_, 
   {{0xa2628003,0x64b0c011,0x3cfd6012,0x78470002}},	// [9b0] _དང__བོད_, _praza__de_, _svoje__príspevk, _онај_, 
   {{0xbcf52022,0x00000000,0x00000000,0x00000000}},	//   _लोककला_, --, --, --, 
   {{0xcf3fa029,0xdeaba002,0xfef0c00f,0xf603c002}},	//   _ལོ__རྒྱུས_, _означен__већ_, _kwakudin, _молимо_, 
   {{0x365ec002,0x00000000,0x00000000,0x00000000}},	//   _филма_, --, --, --, 
   {{0x28ebe011,0x00000000,0x00000000,0x00000000}},	//   _coñecido_, --, --, --, 
   {{0xfcd6800b,0x00000000,0x00000000,0x00000000}},	//   _ubukungu_, --, --, --, 
   {{0xe315e018,0xf2d9c02f,0xa2670003,0x00000000}},	//   _usuários_, _tiver_, _ཡང__མེད_, --, 
   {{0x42d98015,0x2257a00e,0x4226000c,0xcb6e000c}},	//   _maret_, _cílem_, _इहे__लिखल_, _के__जइसन_, 
   {{0x5413201d,0x746e400b,0x0bb5c006,0xe3ea2009}},	//   _lihat__siapa_, _mwaka__wa_, _དེ__ལུ_, _deltag_, 
   {{0xb9e70014,0xce6ac002,0x00000000,0x00000000}},	//   _के__प्रयास_, _можда_, --, --, 
   {{0x726e0024,0x568f4015,0x00000000,0x00000000}},	//   _lepota_, _spotligh, --, --, 
   {{0x424ec020,0x1be0a014,0x7858e011,0x6c18000f}},	//   _ཨེན_, _से__ना_, _recollid, _ngaqala_, 
   {{0x7e72e002,0xde28e002,0x00000000,0x00000000}},	//   _те_, _ва_, --, --, 
   {{0xc2634006,0xf370a009,0x00000000,0x00000000}},	//   _གློག__རིག_, _kommerci_brug_, --, --, 
   {{0x27b8400e,0xae5be00a,0x00000000,0x00000000}},	//   _položek_, _अलीगढ़_, --, --, 
   {{0x44bbc009,0x9b9ac003,0x00000000,0x00000000}},	//   _brug__af_, _དུམ__བུ_, --, --, 
   {{0xfaf22012,0xe2d3000b,0x5344a038,0xd3c72027}},	// [9c0] _prihláse, _mu__rwanda_, _ourense_, _hospodár, 
   {{0x9f7c001a,0x9465200b,0xfb9f6014,0x00000000}},	//   _henta__frå_, _dioseze__ya_, _प्रदेश__से_, --, 
   {{0x43f9e015,0xa2ad6009,0x00000000,0x00000000}},	//   _fitur_, _besked__dato_, --, --, 
   {{0xe2fc6024,0x7db6c00a,0x00000000,0x00000000}},	//   _blogu_, _से__जुड़े_, --, --, 
   {{0x22ad0012,0x8682001c,0x00000000,0x00000000}},	//   _napísať_, _एकसाथ_, --, --, 
   {{0xcdce2002,0x00000000,0x00000000,0x00000000}},	//   _живе_, --, --, --, 
   {{0x2f3e200e,0xc442e009,0xec484014,0x00000000}},	//   _méně__než_, _bog_, _रोके_, --, 
   {{0x52d8e009,0x6257e006,0x00000000,0x00000000}},	//   _taget_, _ཀྲོང__གསར_, --, --, 
   {{0xb25a2003,0x1d7b200a,0x00000000,0x00000000}},	//   _ཁྲོད__ཀྱི_, _देहरादून_, --, --, 
   {{0xcdb94002,0x32636003,0x00000000,0x00000000}},	//   _последњи__пут_, _དང__ཁོང_, --, --, 
   {{0xa4ac601a,0x00000000,0x00000000,0x00000000}},	//   _innhald__gå_, --, --, --, 
   {{0xd212200f,0x13f38018,0x00000000,0x00000000}},	//   _nakho_, _compre__muitos_, --, --, 
   {{0x2497e009,0x00000000,0x00000000,0x00000000}},	//   _ud__og_, --, --, --, 
   {{0x42dea01e,0x00000000,0x00000000,0x00000000}},	//   _la__dana_, --, --, --, 
   {{0x23f9e015,0x3e43c002,0xc200a012,0x00000000}},	//   _situs_, _односу__на_, _paci_, --, 
   {{0xe29fe020,0x3201800b,0xf1770002,0x00000000}},	//   _བཞེངས__གནང_, _ebyiri_, _шест_, --, 
   {{0x63eac006,0x43c9200e,0x360ac003,0x4cdfe002}},	// [9d0] _འཕྲལ_, _pro__vás_, _འཕྲད_, _да__неће_, 
   {{0x9a6ac018,0x00000000,0x00000000,0x00000000}},	//   _como__você_, --, --, --, 
   {{0xfbc0800c,0x00000000,0x00000000,0x00000000}},	//   _कोना__से_, --, --, --, 
   {{0x425ac012,0x00000000,0x00000000,0x00000000}},	//   _biela_, --, --, --, 
   {{0xc23c800f,0x00000000,0x00000000,0x00000000}},	//   _izaga__zithi_, --, --, --, 
   {{0x90f3200a,0x7dafa003,0x0a83c00c,0x00000000}},	//   _इटावा_, _ཙམ__གྱིས_, _खजाना__में_, --, 
   {{0x92ca601d,0x00000000,0x00000000,0x00000000}},	//   _komersil__laman_, --, --, --, 
   {{0x9f82c002,0x00000000,0x00000000,0x00000000}},	//   _свака_, --, --, --, 
   {{0xee166006,0xe3234005,0xeb982012,0xa7232002}},	//   _མས__འབྲེལ_, _på__nynorsk_, _miliónov_, _потпуно_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x0ff7e025,0x1430000f,0xd6b18003,0x00000000}},	//   _de__favorito, _akukho__muntu_, _ནག__བསུབས_, --, 
   {{0x32d8e016,0x8920c014,0xa2d9a015,0x00000000}},	//   _dager_, _रामजी_, _dapet_, --, 
   {{0x02afe006,0xa71c800c,0x00000000,0x00000000}},	//   _མི__མདོ_, _कि__एकरा_, --, --, 
   {{0xb48cc018,0x6cf2e00b,0x02fd801a,0x00000000}},	//   _clique__em_, _ubutaber, _hadde__vore_, --, 
   {{0x5870c002,0x533e400c,0x00000000,0x00000000}},	//   _pevačica_, _तऽ__खाली_, --, --, 
   {{0x22fc600b,0x217dc022,0xb4b80007,0xdd44c00e}},	//   _kongo_, _भरोसा_, _quran__dan_, _obchodec_porovnat_, 
   {{0x4eb70005,0x82a8200d,0x32994003,0x00000000}},	// [9e0] _tilsette_, _el__cual_, _འབྲི__གཡག_, --, 
   {{0xb443200d,0xabb22006,0x58d9600f,0xcda10003}},	//   _hoy_, _ལག__ཆས_, _imibuzo__yesifund, _སྐྱ__རེངས_, 
   {{0x6377a00a,0xc28c4003,0x00000000,0x00000000}},	//   _लंदन__लुधियाना_, _མཁས__པའི_, --, --, 
   {{0xaac7000e,0xa358a00b,0xf20f800f,0x00000000}},	//   _zboží_, _umugore_, _ukuthi__yini_, --, 
   {{0xb4948005,0x99ce0011,0x7bfb6006,0x6b9f000c}},	//   _på__veg_, _turístic_clandest, _ཞུ__ནི_, _के__हक_, 
   {{0x32d8e009,0x04444015,0x00000000,0x00000000}},	//   _tager_, _jl_, --, --, 
   {{0xb91e0012,0x00000000,0x00000000,0x00000000}},	//   _trenčín_, --, --, --, 
   {{0x1fefe014,0x00000000,0x00000000,0x00000000}},	//   _कालांतर_, --, --, --, 
   {{0xa2fc600b,0x5320c00e,0x11afe00c,0x00000000}},	//   _congo_, _tady_, _धार्मिक__अल्पसंख्, --, 
   {{0xf2ca4009,0x0f634002,0x00000000,0x00000000}},	//   _fuld_, _персијск, --, --, 
   {{0x550aa012,0x02ca4009,0x1128400c,0x00000000}},	//   _si__môžete_, _guld_, _एकरा__अलावा_, --, 
   {{0xeaf22012,0xca572002,0x00000000,0x00000000}},	//   _prihlást, _писања_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x9bb9200a,0x6e78600e,0x00000000,0x00000000}},	//   _हैं__कि_, _pojištěn, --, --, 
   {{0x94498002,0x00000000,0x00000000,0x00000000}},	//   _na__poruka_, --, --, --, 
   {{0xf2d90018,0x6200e02b,0xb4b68007,0xd09d8003}},	//   _fazer_, _hafi_, _atas__dan_, _སྐྱ_, 
   {{0x04970009,0x533d6009,0x00000000,0x00000000}},	// [9f0] _gøre__det_, _hvert__fald_, --, --, 
   {{0xd4444038,0x6e834012,0x52eaa028,0xd2e82005}},	//   _gl_, _spoločno, _tiendas_, _her__finn_, 
   {{0x94306024,0xf3a2c016,0x00000000,0x00000000}},	//   _broj__poruka_, _drept_, --, --, 
   {{0xbea6a011,0x00000000,0x00000000,0x00000000}},	//   _elabora__empanada, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x8de18006,0x00000000,0x00000000,0x00000000}},	//   _བརྩོན__ཤུགས_, --, --, --, 
   {{0x5484e011,0x83002011,0x7a71800a,0xf7130002}},	//   _de__traballo_, _por__unha_, _रही__हैं_, _републик, 
   {{0xb4ba8015,0x00000000,0x00000000,0x00000000}},	//   _favoritm_dan_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x64432028,0x1253000f,0xef57600a,0x00000000}},	//   _soy_, _ngaso__sonke_, _मेडल__मास्टरमा, --, 
   {{0xa31fa015,0x2464c009,0x7bcd200c,0x5aa8a00a}},	//   _aja__yang_, _køb__og_, _हटे_, _आपयहांहै__होम_, 
   {{0x12aaa009,0x54d5001c,0x634c6012,0xc2b5000b}},	//   _køb_, _राशिफल_, _povedal_, _hari__abantu_, 
   {{0xfeb7c018,0x9443200d,0x00000000,0x00000000}},	//   _possível_, _voy_, --, --, 
   {{0xb4bb4018,0xed86a002,0x00000000,0x00000000}},	//   _mais__um_, _је__што_, --, --, 
   {{0xe278600f,0x22aaa009,0xd9e84002,0xc2392002}},	//   _yaphansi_, _løb_, _предавањ, _попут_, 
   {{0x0479001a,0x7d5ee00a,0x7612e00c,0x00000000}},	//   _gjer__det_, _जुड़े_, _चाहीं__भारत_, --, 
   {{0x03ab401d,0x52d9c009,0x9332002f,0x00000000}},	// [a00] _berkongs_kenalan_, _lavet_, _faixa_, --, 
   {{0x9a40600b,0x00000000,0x00000000,0x00000000}},	//   _ba__kiliziya_, --, --, --, 
   {{0x8244000d,0x39d7601a,0x00000000,0x00000000}},	//   _cómo_, _eigentle, --, --, 
   {{0xb29c6003,0x2a70a00a,0x00000000,0x00000000}},	//   _གཞིའི__དཀར_, _सिंह__नगर_, --, --, 
   {{0x3b40a012,0x472d600c,0x00000000,0x00000000}},	//   _najprv__prihlási, _पकड़ल_, --, --, 
   {{0xa396000e,0x73958018,0x9660600e,0x00000000}},	//   _napsal_, _nessa_, _podle__oblíbeno, --, 
   {{0x3e426002,0x9bfc6003,0xa3ba4018,0x8328200c}},	//   _је__на_, _མི__སྣ_, _terça__feira_, _खोजत__उहां_, 
   {{0xce83400e,0x9de2e011,0xf47d802a,0x5291600b}},	//   _společno, _pódense_, _sier__han_, _ingabo_, 
   {{0xb9f42011,0x138aa009,0x5b6f0006,0x1f59e028}},	//   _tamén_, _gør_, _ཀོཊ__རྫོང_, _respalda, 
   {{0xc278600f,0x00000000,0x00000000,0x00000000}},	//   _waphansi_, --, --, --, 
   {{0x66bf600c,0x0ec72002,0x5288a003,0x998e0002}},	//   _ओकर__विकास_, _земља_, _བཏང__སོང_, _нашим_, 
   {{0x82dde03f,0xe738c003,0xdd872002,0x00000000}},	//   _intombi_, _གློད_, _другог_, --, 
   {{0x7ebc600e,0x00000000,0x00000000,0x00000000}},	//   _přeskoči, --, --, --, 
   {{0x74962012,0x8981e00a,0x72c70003,0x00000000}},	//   _keď__si_, _सूची__वैयक्तिक_, _རིགས__གསལ_, --, 
   {{0x73c32007,0xf2542014,0x3e64c002,0x00000000}},	//   _adalah__seperti_, _चैलेंज_, _само__на_, --, 
   {{0xb7df6013,0x00000000,0x00000000,0x00000000}},	//   _कोलकाता_, --, --, --, 
   {{0x2c740013,0x00000000,0x00000000,0x00000000}},	// [a10] _वास्तु_, --, --, --, 
   {{0x7394c009,0x42fea018,0x48e2a00c,0x00000000}},	//   _bedst_, _estiver_, _ओह__भोजपुर_, --, 
   {{0xbe7f8015,0xd3958018,0x1721800c,0x28c6e00a}},	//   _dan__menemuka, _dessa_, _बाड़ी_, _रायपुर_, 
   {{0x0bd9600a,0x3a87001d,0x4283e00b,0x00000000}},	//   _गया__है_, _ternakan_, _mashuri_, --, 
   {{0x3af22012,0xfd04c02a,0x12be8012,0x32b5e00c}},	//   _prihlási, _hverandr, _zatiaľ_, _बनेगा__करोड़पति_, 
   {{0x9bd12030,0xf27f4011,0x74bdc00e,0x00000000}},	//   _finansir_političk, _axenda_, _jsme__si_, --, 
   {{0x1dbe6002,0x00000000,0x00000000,0x00000000}},	//   _републик_српске_, --, --, --, 
   {{0x6192a008,0x0f9e4002,0xf298c003,0x00000000}},	//   _autonómi, _норвешки__персијск, _འབྲི__མཁན_, --, 
   {{0x689c600f,0x00000000,0x00000000,0x00000000}},	//   _okukhulu, --, --, --, 
   {{0x026fa002,0x1bd12003,0x9880e002,0x00000000}},	//   _до__сада_, _ཐོག__མར_, _европске__уније_, --, 
   {{0x546dc034,0x00000000,0x00000000,0x00000000}},	//   _kommune__no_, --, --, --, 
   {{0xabe2a006,0x02a06006,0x00000000,0x00000000}},	//   _གྱི__ཐོ_, _སླབ__ཨིན_, --, --, 
   {{0x1bee0002,0x42354003,0x00000000,0x00000000}},	//   _народ_, _བོད__ཁྱིམ_, --, --, 
   {{0x53eaa02b,0x6273a00d,0x3be08014,0x2bc4200a}},	//   _ndetse_, _línea_, _पी__एच_, _रही__थी_, 
   {{0x94540009,0x00000000,0x00000000,0x00000000}},	//   _nordjysk, --, --, --, 
   {{0x229fe018,0xbe82e012,0x00000000,0x00000000}},	//   _projeto_, _bývanie_, --, --, 
   {{0xa201000b,0xa273a011,0xf47c000b,0x00000000}},	// [a20] _bazi_, _aínda_, _agenga__ubuzima_, --, 
   {{0xae732002,0xf2012004,0x4448a040,0x644cc018}},	//   _без_, _hayi_, _možete__da_, _endereço__de_, 
   {{0xc2a10003,0x00000000,0x00000000,0x00000000}},	//   _སྨོན__པའི_, --, --, --, 
   {{0xa6ffc051,0x4f66000f,0x00000000,0x00000000}},	//   _अर्थ_, _zombuso__kankulun, --, --, 
   {{0x1b8c8029,0x9298601d,0x00000000,0x00000000}},	//   _བང_, _pautan__laman_, --, --, 
   {{0x896d400f,0x2aa6800c,0x00000000,0x00000000}},	//   _nesikhat, _में__नगर_, --, --, 
   {{0xfe700039,0xc2ba6018,0x44b84011,0x2617c00a}},	//   _pencaria, _br__todos_, _xeral__da_, _है__क्योंकि_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xd4b74009,0x1aaa6002,0x32126018,0x64060003}},	//   _find__vej_, _председн, _banho_, _ཕྱི__རྒྱལ_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xe41ba009,0x13438009,0xb195e00f,0x00000000}},	//   _at__blive_, _seneste__dage_, _okubalul, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x93f9e00e,0xd33c8009,0x9befc003,0x4e8ae002}},	//   _datum_, _vist__gange_, _གི__ལས_, _година__од_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x72e28004,0x00000000,0x00000000,0x00000000}},	//   _kuvakali_kulo_, --, --, --, 
   {{0x72da4015,0x00000000,0x00000000,0x00000000}},	// [a30] _materi_, --, --, --, 
   {{0x3386c012,0xc770400f,0x00000000,0x00000000}},	//   _ktorej_, _okuhlang, --, --, 
   {{0xee4ec00e,0x425a6018,0x74998002,0x00000000}},	//   _bydliště_, _ogol_, _помозите_, --, 
   {{0x25ff6013,0x2244a01a,0xb224e015,0xa4b48011}},	//   _क्योंकि_, _døme_, _kanker_, _relacion_coa_, 
   {{0x8481c027,0xa3acc00f,0x00000000,0x00000000}},	//   _modrykon_sk_, _isixuku_, --, --, 
   {{0x52fd6028,0x7ea98002,0x3542e00b,0x16f20003}},	//   _imagen_, _одјавите__се_, _abantu__bahitany, _གི__སློབ_, 
   {{0xf00a0002,0x00000000,0x00000000,0x00000000}},	//   _користећ_свој_, --, --, --, 
   {{0x6ac7600e,0x594f6018,0xe1df0013,0x00000000}},	//   _další_, _carregar_, _दर्शनीय__स्थल_, --, 
   {{0x937c800b,0x00000000,0x00000000,0x00000000}},	//   _yatanze_, --, --, --, 
   {{0xb6de2002,0x00000000,0x00000000,0x00000000}},	//   _војводин, --, --, --, 
   {{0xe999400e,0xf21d0002,0x00000000,0x00000000}},	//   _dveře_, _кажу_, --, --, 
   {{0xe2ba2006,0x4200c00b,0x00000000,0x00000000}},	//   _ཤར__འུང_, _taliki_, --, --, 
   {{0x52900004,0xdb880022,0x9c9d600c,0xc6dd800c}},	//   _apha_, _मय_, _के__कवनो_, _बिहार__सरकार_, 
   {{0x9233000b,0x88128003,0x4e7d6002,0x40f2800c}},	//   _uburyo__bushya_, _ྋརྒྱལ_, _ништа__не_, _उठावल_, 
   {{0xce382007,0x9bdb4003,0x1f17c00c,0x00000000}},	//   _pengajia, _བོན__བུ_, _महर्षि__विश्वामि, --, 
   {{0x6bee6003,0x00000000,0x00000000,0x00000000}},	//   _ཟློས__གར_, --, --, --, 
   {{0x396d400f,0x11240002,0x00000000,0x00000000}},	// [a40] _yesikhat, _јединств, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x8202600f,0x7c782009,0x2bf1a00a,0x00000000}},	//   _nesimo_, _forskel_, _करें__हम_, --, 
   {{0xcc6e600f,0x0e56a002,0xe2126018,0xa2594003}},	//   _ngaphezu__kwalokho_, _коришћењ_за_, _ganhe_, _འདྲ__ཞིག_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x8386c009,0xf469e012,0xbf65a012,0x00000000}},	//   _ejer_, _aby__ste_, _overené_, --, 
   {{0x4c4e000a,0x00000000,0x00000000,0x00000000}},	//   _किये_, --, --, --, 
   {{0xa386c01a,0xe3df202f,0xb480600c,0xe4bcc00e}},	//   _gjer_, _de__mais_, _ब्लाउज_, _jsem__na_, 
   {{0x3442404a,0xb443801a,0xc6b8e00c,0x00000000}},	//   _fnl_, _kor_, _भोजपुरी__समेत_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xab88200a,0x2ebd2002,0x00000000,0x00000000}},	//   _नए_, _строго__је_, --, --, 
   {{0x23ce8012,0x926a800f,0xe24e4003,0x0f612002}},	//   _slová_, _ngakho__konke_, _རྩམ_, _остале_, 
   {{0xf34ba016,0x9281e018,0x3c48c00c,0x00000000}},	//   _ikke__tillatt_, _para__quem_, _होके_, --, 
   {{0x0d04e01a,0xa0b1e00f,0x00000000,0x00000000}},	//   _kvarandr, _kakhulu__kangango, --, --, 
   {{0x324e4003,0x00000000,0x00000000,0x00000000}},	//   _ཡའི_, --, --, --, 
   {{0x0200c007,0xc47b6011,0x5b4ac021,0xce54400f}},	//   _beliau_, _organiza_sen_, _དང__རྫོང_, _ephakeme_, 
   {{0x7205a00b,0x91bec00c,0x5302600b,0x00000000}},	// [a50] _politiki_, _चुकल_, _ifunguye__kandi_, --, 
   {{0x4c48c00c,0xffdc800b,0x00000000,0x00000000}},	//   _होखे_, _munani__abenyeco, --, --, 
   {{0x73f9e01d,0x5ceb800e,0x00000000,0x00000000}},	//   _datuk_, _stř_, --, --, 
   {{0x23f98031,0xb2be4012,0x2feaa012,0x00000000}},	//   _harus_, _napíšte__nám_, _celý__článok_, --, 
   {{0x5d780002,0xca8b200e,0x00000000,0x00000000}},	//   _који__садрже_, _sociální_, --, --, 
   {{0x92d80018,0xeba8200c,0x9bd1e00c,0x00000000}},	//   _achei_, _आतंक__के_, _बतवलन__कि_, --, 
   {{0x612d0002,0xb4438007,0x8d8f8003,0x00000000}},	//   _март_, _kos_, _ཕེབས_, --, 
   {{0x9bb88003,0x3bf0a00c,0x00000000,0x00000000}},	//   _ལྟ__བུ_, _जरुरत__बा_, --, --, 
   {{0x025a8006,0x1a1a2002,0x00000000,0x00000000}},	//   _སྐྱོང__ཞབས_, _захтевај__нови_, --, --, 
   {{0xee46e002,0x00000000,0x00000000,0x00000000}},	//   _могла__да_, --, --, --, 
   {{0xbc5e8037,0x00000000,0x00000000,0x00000000}},	//   _octubre__septiemb, --, --, --, 
   {{0xa2ca2009,0x00000000,0x00000000,0x00000000}},	//   _ældre_, --, --, --, 
   {{0x26cb200a,0x00000000,0x00000000,0x00000000}},	//   _मुखपृष्ठ__चौपाल_, --, --, --, 
   {{0x0e36c012,0x8242a003,0x00000000,0x00000000}},	//   _spracova, _ཐོར_, --, --, 
   {{0x24438011,0x4b046009,0x04b04018,0xbbcfe00c}},	//   _bos_, _selskabe, _globo__com_, _उठावल__जा_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6c84a014,0x82a8a00d,0x3a33600c,0x00000000}},	// [a60] _के__समर्थन_, _la__cual_, _छथि_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xf46ee022,0x53f98015,0x52df2018,0xc29a4006}},	//   _मध्य__प्रदेश_, _kasus_, _em__casa_, _ཐབས__འབད_, 
   {{0xc394c00f,0x6a06400e,0x00000000,0x00000000}},	//   _efesu_, _služeb_, --, --, 
   {{0x324e4020,0xc2a66003,0xfce12003,0x00000000}},	//   _རའི_, _གསོ__རིག_, _ཞི__བདེའི_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa2630003,0x4305000f,0x00000000,0x00000000}},	//   _ནང__བོད_, _namadoda_akhe_, --, --, 
   {{0x2234a01d,0x56572022,0x3e42e002,0x00000000}},	//   _dari__lebih_, _समाजसेवा_, _је__ваш_, --, 
   {{0xe41ba01a,0x34a6e00e,0x00000000,0x00000000}},	//   _som__vert_, _než__kč_, --, --, 
   {{0x9200c009,0xf300e009,0x94038018,0x239b200f}},	//   _muligt_, _fodbold_, _aplicaçã, _sika__isaya_, 
   {{0x424e6003,0xcb66e00a,0x3c09000c,0x9454600f}},	//   _ལའི_, _खोलने_, _बाड़े__एह_, _uthando__lwethu_, 
   {{0x3442600d,0x7fc8e008,0x00000000,0x00000000}},	//   _uno_, _obrigato, --, --, 
   {{0x1ba2200a,0x00000000,0x00000000,0x00000000}},	//   _भी__एक_, --, --, --, 
   {{0x27798002,0x2b8f400c,0x00000000,0x00000000}},	//   _саобраћа, _बात__पऽ_, --, --, 
   {{0x5c53800b,0x00000000,0x00000000,0x00000000}},	//   _ibitabo_, --, --, --, 
   {{0xbf028021,0x0bf64006,0xebf3e00c,0x00000000}},	//   _འབྱུང_, _ཚུ__ལུ_, _मुजाहिदी_के_, --, 
   {{0xdb884052,0xab584006,0x8b282020,0x07f2000a}},	// [a70] _भए_, _ལྟོའི__བྱུང_, _ཀྲོང_, _की__ख़बरें_, 
   {{0x22e90015,0x00000000,0x00000000,0x00000000}},	//   _bagikan_, --, --, --, 
   {{0xf2806011,0x00000000,0x00000000,0x00000000}},	//   _empanada_cunha_, --, --, --, 
   {{0x0a8f2014,0x794f000a,0x00000000,0x00000000}},	//   _बिहार__में_, _खूबसूरत_, --, --, 
   {{0x44428004,0x1a3e2022,0x8258a003,0x00000000}},	//   _mna_, _माई_, _འདྲ__མིན_, --, 
   {{0x12f58024,0x416ae00e,0xb8eae00e,0x841a2018}},	//   _miliona__evra_, _nabídka_, _nabídky_, _sua__lista_, 
   {{0x92ca4009,0x00000000,0x00000000,0x00000000}},	//   _vild_, --, --, --, 
   {{0x13aa400b,0x00000000,0x00000000,0x00000000}},	//   _byavuye_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7ca7e018,0x5a84200c,0x0341a01a,0x00000000}},	//   _produto__disponib, _परमार__वंश_, _det__vore_, --, 
   {{0x7c06200f,0x00000000,0x00000000,0x00000000}},	//   _zinsuku_, --, --, --, 
   {{0x400e2018,0x0bb0200a,0x1291000b,0x815d0002}},	//   _eletrôni, _चुनें__और_, _bibazo_, _априла_, 
   {{0x8d1e200b,0x53488018,0x624e6003,0x60d88002}},	//   _jenoside_, _de__imagem_, _ལའང_, _саопштењ, 
   {{0x43a2000b,0xf3fd001a,0x2f3dc002,0x5bc9600a}},	//   _ikipe_, _den__fyrste_, _све__до_, _त्वरितवा_आई_, 
   {{0x540aa031,0x9c0c000c,0x00000000,0x00000000}},	//   _mengatak_bahwa_, _कदम__आगे_, --, --, 
   {{0x4fd8000f,0xd1c2e00a,0x00000000,0x00000000}},	//   _esingoko, _ऑटो__वर्ल्ड_, --, --, 
   {{0x6b6e4002,0xeb8ce029,0x00000000,0x00000000}},	// [a80] _се__прокомен, _ཐང_, --, --, 
   {{0x4c3a400c,0x00000000,0x00000000,0x00000000}},	//   _एही__तरे_, --, --, --, 
   {{0xd2fd8019,0x00000000,0x00000000,0x00000000}},	//   _norge_, --, --, --, 
   {{0xe6c34002,0xc7a2601d,0x7e3be011,0x94a6200b}},	//   _порекло__презимен, _pentadbi, _tiña_, _itariki__ya_, 
   {{0xf300401d,0x00000000,0x00000000,0x00000000}},	//   _peluang__kerjaya_, --, --, --, 
   {{0x15132011,0x4aa4a00c,0xa6604003,0x22654003}},	//   _un__proxecto_, _में__आवत_, _གཞི__དཔྱད_, _གྲོས__ཆོད_, 
   {{0x1eb60019,0xda6a0024,0xe4564037,0xaa65a00a}},	//   _nærheten_, _sledeća_, _negociac_venta_, _इसके__लिए_, 
   {{0xc767a00c,0x00000000,0x00000000,0x00000000}},	//   _में__जादा_, --, --, --, 
   {{0x3e2aa00e,0x0b282003,0x00000000,0x00000000}},	//   _akční_, _ཀྲུང_, --, --, 
   {{0xa79f2003,0xdfa44009,0x734d2005,0x5386800b}},	//   _བཙོན_, _accepter_, _omsorg__trygd_, _imari_, 
   {{0x8224002b,0xa2c16012,0x00000000,0x00000000}},	//   _ariko_, _kombinác, --, --, 
   {{0x13c36011,0x00000000,0x00000000,0x00000000}},	//   _que__lles_, --, --, --, 
   {{0xe41ae015,0x00000000,0x00000000,0x00000000}},	//   _jakarta__timur_, --, --, --, 
   {{0x2201800b,0xc4ac601a,0xadc3a00b,0x027f200e}},	//   _nari_, _ein__av_, _gisirika, _psaní_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x4fe78002,0xaa5ac00a,0x00000000,0x00000000}},	//   _још__увек_, _गद्य__कोश_, --, --, 
   {{0xc2d14018,0x7dc8e00b,0x6ba4a00a,0xc255e00c}},	// [a90] _produto__não_, _kandi__yiyemeje_, _का__भी_, _होखेला_, 
   {{0xc097c002,0x8246c002,0x00000000,0x00000000}},	//   _промени_, _интернет_, --, --, 
   {{0x52ba6003,0x00000000,0x00000000,0x00000000}},	//   _མི__འཛམ_, --, --, --, 
   {{0xd48a400f,0x93fb6009,0xfc15600c,0x1315c00f}},	//   _ngakho__ke_, _sig__selv_, _रिश्__ता_, _indlela__ujehova_, 
   {{0x12f6200e,0x0bbbc00a,0x00000000,0x00000000}},	//   _úplně_, _ब्राउज़र__को_, --, --, 
   {{0xd3ea8031,0xb201800b,0xc201800b,0x00000000}},	//   _liat_, _gari_, _hasi_, --, 
   {{0xec02000c,0x720dc009,0x7c68000b,0x00000000}},	//   _लोग__के_, _opmærkso, _amaraso_, --, 
   {{0x42cac009,0x744b400b,0x00000000,0x00000000}},	//   _kendte_, _rwanda__mu_, --, --, 
   {{0x948ac018,0x5d8fc003,0x00000000,0x00000000}},	//   _entrar__ou_, _ཐེབས_, --, --, 
   {{0x05568018,0x00000000,0x00000000,0x00000000}},	//   _seu__carrinho_, --, --, --, 
   {{0xdba7a006,0xe063c002,0x00000000,0x00000000}},	//   _སྲུང__ཞུ_, _поново_, --, --, 
   {{0x5eac2019,0xd26e4006,0x1bdfe00c,0x00000000}},	//   _eksterne_, _ཁབ__སྟེ_, _बिहार__एक_, --, 
   {{0xa27ee00b,0x24bbc009,0x7af00012,0x944e000b}},	//   _tsinze_, _brug__og_, _prirodze, _ya__ruguru_, 
   {{0x4be34003,0xca17e011,0x00000000,0x00000000}},	//   _ཀྱི__ངོ_, _podería_, --, --, 
   {{0x6f8be02f,0x4f1f200a,0x00000000,0x00000000}},	//   _até_, _कॉमेंट्स__छांटें_, --, --, 
   {{0xbd8a803a,0x00000000,0x00000000,0x00000000}},	//   _རོགས_, --, --, --, 
   {{0xccffc003,0x00000000,0x00000000,0x00000000}},	// [aa0] _ཐེངས__འདིའི_, --, --, --, 
   {{0x42d9600f,0x279f2003,0x6b2a0002,0x00000000}},	//   _ngisho__noma_, _བཙུན_, _првенств, --, 
   {{0x3f308002,0x1995000c,0x00000000,0x00000000}},	//   _су__они_, _अकाट्य__प्रमाण_, --, --, 
   {{0xe204200f,0xebb8e003,0x470ec00e,0x24a8e00b}},	//   _izwi__likankul, _ལྟ__ཀུ_, _člověk_, _iravuga__ko_, 
   {{0xfbd36022,0xc2d9c024,0x1b990003,0x00000000}},	//   _भारत__से_, _savet_, _གཉིས__སུ_, --, 
   {{0x4378001e,0x6290601a,0x00000000,0x00000000}},	//   _godina__redanje_, _opna_, --, --, 
   {{0x32d9c009,0x00000000,0x00000000,0x00000000}},	//   _laver_, --, --, --, 
   {{0xe3eae019,0x00000000,0x00000000,0x00000000}},	//   _hentet_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x905c600a,0x2451400e,0x00000000,0x00000000}},	//   _समाचार__व्यापार_, _skutečně_, --, --, 
   {{0x2442c009,0xecc34011,0x00000000,0x00000000}},	//   _ind_, _de__persoal_, --, --, 
   {{0xf9f66034,0x72428003,0x00000000,0x00000000}},	//   _språk_, _དཔང_, --, --, 
   {{0x7662a012,0x74a7e00b,0x0cdee00f,0x7c0bc003}},	//   _zákonom_, _abari__mu_, _kungenxa__yokuthi_, _དབང__རང_, 
   {{0xe26b8003,0x00000000,0x00000000,0x00000000}},	//   _ནས__བཤད_, --, --, --, 
   {{0x850b2022,0xe1d82002,0x00000000,0x00000000}},	//   _के__किनारे_, _за__србију_, --, --, 
   {{0x62428006,0x5709800c,0x52bce003,0x00000000}},	//   _ནུག_, _भोजपुरी__भाषा_, _རི__འཛམ_, --, 
   {{0xb37a800e,0x6d1b2002,0x00000000,0x00000000}},	// [ab0] _nejnižší__ceny_, _сандуче__придружи, --, --, 
   {{0x6d31c004,0x799c6035,0x1c7f2025,0x00000000}},	//   _kwandule_, _ukukhule, _passado_, --, 
   {{0xe305a012,0x929ca00b,0x74abc00b,0x3cc20003}},	//   _sk__pridala_, _nyuma__yaho_, _uruhare__mu_, _དར__སྲོལ_, 
   {{0x6dfb6003,0x7231a039,0xf2b90002,0x466d600c}},	//   _འཕྲོད__བསྟེན_, _rumah__sakit_, _простори, _कबो__ज्योतिष_, 
   {{0x0f90e00c,0x00000000,0x00000000,0x00000000}},	//   _के__टक्कर_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x0ef2e011,0x7cae600a,0x00000000,0x00000000}},	//   _que__teñen_, _धर्मयात्_फोटो_, --, --, 
   {{0xa3430002,0xd0630002,0x00000000,0x00000000}},	//   _косова_, _косово_, --, --, 
   {{0x6692e014,0xb47d4025,0x0b8a6002,0x02d4600b}},	//   _के__विकास_, _para__um_, _фото_, _bagomba_, 
   {{0x83f8c01d,0x47720002,0xd842a003,0x00000000}},	//   _laluan_, _овог_, _དང__སྒྲིག_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xab1e6018,0x00000000,0x00000000,0x00000000}},	//   _pesquisa_, --, --, --, 
   {{0xa28e4003,0x00000000,0x00000000,0x00000000}},	//   _བུད__མེད_, --, --, --, 
   {{0x1ee3200a,0xc342a028,0x00000000,0x00000000}},	//   _दें__मित्र_, _leyendo_, --, --, 
   {{0x0bc4400a,0x799b800b,0x62f44015,0x74a9000b}},	//   _जाती__है_, _shakisha_, _standar_, _igira__iti_, 
   {{0x2d32600e,0x00000000,0x00000000,0x00000000}},	//   _pronájem_, --, --, --, 
   {{0x03960018,0x818a6002,0x00000000,0x00000000}},	// [ac0] _passou_, _читаоце__дневника_, --, --, 
   {{0xa442c015,0xee58c002,0x00000000,0x00000000}},	//   _ane_, _прилику__да_, --, --, 
   {{0xe25b601d,0x842fc01d,0xe28d2003,0x13564028}},	//   _soalan_, _kata__laluan_, _མཐའ__མའི_, _ustedes_, 
   {{0x0bff0003,0x00000000,0x00000000,0x00000000}},	//   _རི__སི_, --, --, --, 
   {{0xf2f2c033,0xd442c00e,0xf7d0e01d,0x00000000}},	//   _profil__pogledaj, _dne_, _sebarang__kehilang, --, 
   {{0xb409a028,0x4da9c012,0xa8e9c012,0x263fe00e}},	//   _ver__más_, _pridané_, _pridaný_, _kalendář_, 
   {{0x4ba38003,0xc43b0005,0x00000000,0x00000000}},	//   _ཕྱི__ལོ_, _er__sett_, --, --, 
   {{0x0342201a,0x00000000,0x00000000,0x00000000}},	//   _har__vore_, --, --, --, 
   {{0x00b7a00a,0x6e54400f,0xf348800e,0xd60d000c}},	//   _टीवी__गुदगुदी_, _ophakeme_, _recenzi_, _के__पटकथा_, 
   {{0xd243003a,0x74368009,0x946ba00e,0x1b8f4012}},	//   _ཚོར_, _der__bliver_, _většinou_, _striebor, 
   {{0xa3a2001a,0xebc1600c,0x00000000,0x00000000}},	//   _skipa_, _कइला__के_, --, --, 
   {{0x5c806002,0xe4b92009,0x00000000,0x00000000}},	//   _деце_, _benytter__til_, --, --, 
   {{0x74be400b,0x00000000,0x00000000,0x00000000}},	//   _imwe__mu_, --, --, --, 
   {{0x0bd24003,0x00000000,0x00000000,0x00000000}},	//   _གངས__ཅན_, --, --, --, 
   {{0x8439a00d,0x00000000,0x00000000,0x00000000}},	//   _la__lista_, --, --, --, 
   {{0xf3eac009,0x00000000,0x00000000,0x00000000}},	//   _lidt_, --, --, --, 
   {{0x0350200c,0x00000000,0x00000000,0x00000000}},	// [ad0] _चर्चा__कईनी_, --, --, --, 
   {{0x4443e018,0x00000000,0x00000000,0x00000000}},	//   _sou_, --, --, --, 
   {{0x22f9a00c,0x864e0002,0x00000000,0x00000000}},	//   _ओह__घड़ी_, _јованови, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7443e02f,0x52e9401a,0x7ba7c003,0x00000000}},	//   _vou_, _utvikla_, _རྩིས__ཁང_, --, 
   {{0x6ace4006,0x00000000,0x00000000,0x00000000}},	//   _ཡིག__གཟུག_, --, --, --, 
   {{0xe32d0037,0xd2316011,0x00000000,0x00000000}},	//   _cerrar__sesión_, _cada__artigo_, --, --, 
   {{0xa7bb803c,0x053b4018,0x3bf1200c,0x22d8000a}},	//   _poslanik_, _dimensõe, _जरूरत__बा_, _रहती_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x82f9800e,0x00000000,0x00000000,0x00000000}},	//   _přidat_, --, --, --, 
   {{0xf2f9a007,0xf789c002,0x00000000,0x00000000}},	//   _dalam__masa_, _његовог_, --, --, 
   {{0x1291600b,0x00000000,0x00000000,0x00000000}},	//   _ingano_, --, --, --, 
   {{0xee28e002,0x4245200e,0x6b66e00a,0x00000000}},	//   _га_, _námi_, _खोजने_, --, 
   {{0x32b1e013,0x52b7e018,0x1be2a013,0x9a3fc018}},	//   _जयपुर_, _de__dados_, _ने__एक_, _de__você_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xcf0ce021,0x32d1c01d,0x54b2200f,0x4bde8006}},	//   _འཕྲུལ_, _bertulis__adalah_, _njengoba__nje_, _འཐུ__ལོ_, 
   {{0x935f6007,0x00000000,0x00000000,0x00000000}},	// [ae0] _lihat__profil_, --, --, --, 
   {{0x3a33a00c,0x10656009,0x00000000,0x00000000}},	//   _अपन_, _danskern, --, --, 
   {{0x02918018,0xdcc50003,0x00000000,0x00000000}},	//   _essa_, _བདེན__བཞིའི_, --, --, 
   {{0xde27a006,0x00000000,0x00000000,0x00000000}},	//   _ལས__འཕྲོ_, --, --, --, 
   {{0x10a5c00c,0x5a6da00c,0x00000000,0x00000000}},	//   _एगो__बड़हन_, _कइल__जाव_, --, --, 
   {{0xebce8014,0xc6b3c014,0x3be3a003,0x00000000}},	//   _अध्ययन__के_, _सिंह__चौहान_, _པའི__གོ_, --, 
   {{0xc442e011,0x22ee6012,0x00000000,0x00000000}},	//   _bng_, _môžem__napísať_, --, --, 
   {{0xb2400011,0xb2c1e027,0x00000000,0x00000000}},	//   _preme__nunha_, _to__bolo_, --, --, 
   {{0x2e95c002,0x00000000,0x00000000,0x00000000}},	//   _љубави_, --, --, --, 
   {{0x0e3be011,0x00000000,0x00000000,0x00000000}},	//   _miña_, --, --, --, 
   {{0x6e2f6006,0xfe3be011,0x00000000,0x00000000}},	//   _དཔར__བསྐྲུན_, _liña_, --, --, 
   {{0xd469e024,0x00000000,0x00000000,0x00000000}},	//   _gde__su_, --, --, --, 
   {{0x64a3c037,0x00000000,0x00000000,0x00000000}},	//   _delante__de_, --, --, --, 
   {{0xc7e38014,0x64544011,0xc2432003,0x00000000}},	//   _द्विवेदी_, _espazo__de_, _མོར_, --, 
   {{0x9c53602d,0x00000000,0x00000000,0x00000000}},	//   _postova_, --, --, --, 
   {{0xe44c6002,0xe26e202a,0xfa53e012,0x90062012}},	//   _gratis__na_, _alle__innlegg_, _ponúka_, _mapa__stránok_, 
   {{0xe4b72019,0x447dc009,0x508ba00e,0x00000000}},	// [af0] _mulighet_til_, _salg__af_, _vydání_, --, 
   {{0xdd698018,0xa7b7e038,0xbc59800c,0xf2b4200b}},	//   _acessóri, _exercici, _के__शासनकाल_, _kugirang_ukine_, 
   {{0xd2432003,0x00000000,0x00000000,0x00000000}},	//   _མོལ_, --, --, --, 
   {{0xbe1c4011,0xe490601a,0xf2bb000e,0x2d6e0002}},	//   _última__modifica, _eg__er_, _galerie_, _се__може_, 
   {{0xb244200b,0x00000000,0x00000000,0x00000000}},	//   _zigezweh_misiri_, --, --, --, 
   {{0xd4198011,0x00000000,0x00000000,0x00000000}},	//   _modifica_desta_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x0db7600b,0x3d4d800b,0x7299000f,0x00000000}},	//   _umunyama, _umwaka__icyumwer, _ngenhliz_yonke_, --, 
   {{0x9c07800c,0x00000000,0x00000000,0x00000000}},	//   _बाड़े__कि_, --, --, --, 
   {{0xf3f7000e,0xcc184002,0x00000000,0x00000000}},	//   _reklamní__sdělení_, _за__разлику_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xd4b5c02f,0xadc00002,0x52a6800b,0x00000000}},	//   _clientes__que_, _која__су_, _bwabo_, --, 
   {{0xb6a3400f,0x4c550002,0xbda9200e,0x5a7e200c}},	//   _acashunw_esihlokw, _свештени, _na__světě_, _भाषा__कला_, 
   {{0x5c00600e,0x72c3e011,0x00000000,0x00000000}},	//   _měsíc_, _hai__días_, --, --, 
   {{0xf6824022,0x6a418018,0x00000000,0x00000000}},	//   _चढ़ाव_, _de__março_, --, --, 
   {{0xe2b8000a,0x22f0600f,0x00000000,0x00000000}},	//   _वहां_, _kaningi_, --, --, 
   {{0xd76ec00f,0xf23bc003,0x00000000,0x00000000}},	// [b00] _emihlang, _གཞི__འཇུམ_, --, --, 
   {{0xc4420011,0xbcbb2003,0xc3f4402c,0x6e6ec00a}},	//   _hai_, _ནང__འཛུལ_, _umutwe_, _टिप्_, 
   {{0x32a1401a,0x3cc7c00a,0x2201400b,0x00000000}},	//   _men__ikkje_, _सॉर्ट__करें_, _dufite_, --, 
   {{0xf4444005,0x9af6c009,0x176ec00f,0x00000000}},	//   _ho_, _oplevels, _imihlang, --, 
   {{0x599f000f,0x00000000,0x00000000,0x00000000}},	//   _ngokushe, --, --, --, 
   {{0x3e886002,0x544ee00b,0x8ddba006,0xcbe8400f}},	//   _да__на_, _ndetse__no_, _རིམ__ལུགས_, _ekhulwin_lokuqala_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x3444400d,0x1c96600a,0x78b2a00e,0x24420011}},	//   _lo_, _क्यों_, _nejnověj, _nai_, 
   {{0x64444004,0x6291201a,0x61be200c,0x00000000}},	//   _oo_, _lenkjer_, _खयाल_, --, 
   {{0x8fcf0012,0x00000000,0x00000000,0x00000000}},	//   _stránok_, --, --, --, 
   {{0x4572c00b,0x84c3e00b,0x00000000,0x00000000}},	//   _bwa__bushyash, _ubucuruz, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xf4b48018,0x7443200e,0x4abb400a,0x45e0600a}},	//   _estrelas__bom_, _dny_, _सेहत__हॉट_, _साहित्य__व्रत_, 
   {{0xc985002a,0x5236000f,0x0c12c00a,0x7d024003}},	//   _trakasse, _kunawo__wonke_, _इलाहाबाद__को_, _དར__རྒྱས_, 
   {{0xa4420011,0xadc64002,0x00000000,0x00000000}},	//   _fai_, _били__су_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x33200004,0xf31b800e,0x00000000,0x00000000}},	// [b10] _ndiya_, _název_, --, --, 
   {{0xb2b0e006,0x00000000,0x00000000,0x00000000}},	//   _ཐོ__ཁྱད_, --, --, --, 
   {{0xf4148018,0xf299c003,0x02b3c003,0xb8270003}},	//   _minha__conta_, _མཛོད__གླུ_, _སྦྲེལ__ཡོད_, _ཡིག__དབྱིན_, 
   {{0x14444012,0x9291e00f,0x22574003,0x00000000}},	//   _zo_, _inzalo_, _འཛུམ__བསུ_, --, 
   {{0x8c8ae00b,0x00000000,0x00000000,0x00000000}},	//   _kur__iyinkuru_, --, --, --, 
   {{0xa2434003,0xa2096003,0x00000000,0x00000000}},	//   _པོར_, _སྒྱུར__རྩོམ_, --, --, 
   {{0x8706000a,0x93f8c012,0x73dc400b,0x00000000}},	//   _खबर__संसार_, _ponuke_, _zimwe_, --, 
   {{0xf3730037,0x82c2a015,0x1a7bc002,0x00000000}},	//   _delante_, _anda__bisa_, _по__језицима_, --, 
   {{0x8b8d8003,0x00000000,0x00000000,0x00000000}},	//   _ངང_, --, --, --, 
   {{0x24420015,0xc2c72003,0xc321400c,0x74420025}},	//   _nah_, _ཚོགས__པའི_, _मंत्री__श्री_, _sai_, 
   {{0x7307e01d,0x3f272018,0xec05400c,0xdbca000c}},	//   _menyerta_juta_, _produto__consulte_, _साइबरवार__के_, _तैयार__छी_, 
   {{0xaa86a00c,0x00000000,0x00000000,0x00000000}},	//   _लिहलस__अउर_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xcb250020,0x8267400f,0x00000000,0x00000000}},	//   _ཕྱུག__མཆོག_, _ukubukwa__usuku_, --, --, 
   {{0xd4444012,0x13eb8005,0xee474002,0x00000000}},	//   _vo_, _aust_, _можете__га_, --, 
   {{0x9e61e012,0x00000000,0x00000000,0x00000000}},	//   _skôr_, --, --, --, 
   {{0xea3ec022,0x0c05a00a,0x73f4600a,0x00000000}},	// [b20] _नाई_, _गाजियाबा_गाजीपुर_, _नामस्थान_, --, 
   {{0xebbe6014,0x54ac400b,0x522ac00e,0xadd04002}},	//   _केंद्र__के_, _cyane__ku_, _věku_, _којој__су_, 
   {{0x6367c011,0x7eeae002,0xf2ae000c,0x00000000}},	//   _imprimir__caixa_, _док__се_, _किछु_, --, 
   {{0xd9b9200f,0x62cc200f,0x73c06009,0x346d2012}},	//   _kujehova_, _ngaleyo_, _seneste__nyheder_, _ktorým__sa_, 
   {{0xd4420015,0x00000000,0x00000000,0x00000000}},	//   _yah_, --, --, --, 
   {{0xa98b4012,0x6eab8002,0xda4d8002,0x00000000}},	//   _niečo_, _повезао__са_, _понедеља, --, 
   {{0x0442202d,0x9b8d8029,0xf3508009,0x19d02002}},	//   _kak_, _ཅང_, _om__brug_, _себи_, 
   {{0xf442200e,0xdb09e037,0xac4e800a,0x00000000}},	//   _jak_, _publicar__opinión_, _जिले_, --, 
   {{0xc290e02d,0xe0f3e02e,0x2442201f,0x9323001a}},	//   _dinamo_, _županije_, _mak_, _om__korleis_, 
   {{0x82f2602a,0x149fc009,0x7b9bc003,0x00000000}},	//   _jeg__hadde_, _går__kl_, _ཁུལ__དུ_, --, 
   {{0x4ceec002,0x942ae002,0x0490800e,0x00000000}},	//   _уреди_, _dezinfik_celu_, _je__pro_, --, 
   {{0x3442201d,0xa658000f,0xdfabe022,0xc35c000a}},	//   _nak_, _ezinsukw, _बत्तीसी_, _सबसे__बड़ी_, 
   {{0x32a6a005,0xfc6e600b,0xdbf5000a,0x00000000}},	//   _eg__skal_, _ikarita_, _में__कई_, --, 
   {{0x3cf10006,0x0165c00c,0xa271000f,0xb2958003}},	//   _མཛོད__འཚོལ_, _में__मालवा_, _ezweni__lonke_, _ངོས__དཀར_, 
   {{0xd2c34011,0xde6c2002,0x628ba003,0x00000000}},	//   _das__súas_, _општина_, _གནས__གསར_, --, 
   {{0x09c0e033,0x00000000,0x00000000,0x00000000}},	//   _prometna_, --, --, --, 
   {{0x0e95a025,0x00000000,0x00000000,0x00000000}},	// [b30] _destaque_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xc700200c,0x7fde600f,0x136dc00f,0x00000000}},	//   _बाद__राजा_, _ukuphila__okuphaka, _kusho__ujehova_, --, 
   {{0xc4422039,0x00000000,0x00000000,0x00000000}},	//   _gak_, --, --, --, 
   {{0xb2a4600e,0x0ab0000c,0x00000000,0x00000000}},	//   _původní_, _चर्चा__भईल_, --, --, 
   {{0xaed56002,0x5326e011,0x19a3a00e,0x00000000}},	//   _још_, _en__galego_, _doba__stažení_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x13b9c01a,0x0bf6e003,0xf284a00f,0x00000000}},	//   _dei__fleste_, _ཀུ__ཤུ_, _izindlel_zakhe_, --, 
   {{0x04422033,0x9c92000e,0x00000000,0x00000000}},	//   _kaj_, _písemnéh_souhlasu_, --, --, 
   {{0xfbd82006,0x00000000,0x00000000,0x00000000}},	//   _ཡོདཔ__དང_, --, --, --, 
   {{0x24422010,0xe4826026,0x00000000,0x00000000}},	//   _maj_, _adgang__til_, --, --, 
   {{0xfb92e012,0x523ba00b,0x00000000,0x00000000}},	//   _prenájom_, _kora__kopi_, --, --, 
   {{0xe26d0035,0xaeb8e002,0x00000000,0x00000000}},	//   _umbono_, _ци_, --, --, 
   {{0xa2d9c00f,0xac0d000a,0x4a57a018,0x508ec002}},	//   _izwe_, _देश__की_, _conheça_, _јуна__године_, 
   {{0xb6f9a047,0x5442200e,0x334fc00b,0xc243200f}},	//   _पैसा_, _pak_, _busanzwe__yitonda_, _umoya__wakhe_, 
   {{0x4c01a015,0x0355c01d,0x65c7c00f,0xebfc200c}},	//   _agustus_, _suka__komen_, _ukuthi__ibhayibh, _नैनो__के_, 
   {{0xc4b64019,0xcc802002,0x9f94400e,0xbccf800e}},	// [b40] _etter__en_, _везе_, _svého_, _svět_, 
   {{0x0c01c016,0x91d8200c,0x00000000,0x00000000}},	//   _høsten_, _हो__चुकल_, --, --, 
   {{0xb2cb401d,0xf490a016,0x2b59a00a,0x00000000}},	//   _kaedah_, _av__fra_, _फैशन_, --, 
   {{0x7a4c200c,0x00000000,0x00000000,0x00000000}},	//   _भोजपुरी__लोक_, --, --, --, 
   {{0x337f200d,0x9b8da003,0x00000000,0x00000000}},	//   _las__mujeres_, _ཆང_, --, --, 
   {{0x6457a025,0x7272a00f,0xdc50000a,0x00000000}},	//   _até__de_, _ngaleso__sikhathi_, _लिखें_, --, 
   {{0x130c0011,0x9d2c2002,0x00000000,0x00000000}},	//   _comentar_debe_, _списак_, --, --, 
   {{0xe213a00f,0x48d9a00c,0x00000000,0x00000000}},	//   _lapho_, _पुरनका__भोजपुर_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xc1012002,0xf2e7000c,0x00000000,0x00000000}},	//   _света_, _अबहीं_, --, --, 
   {{0xecbe2002,0xb7112002,0x00000000,0x00000000}},	//   _каже_, _уметничк, --, --, 
   {{0xebf9e00c,0xada40002,0x00000000,0x00000000}},	//   _कृति__के_, _којима__су_, --, --, 
   {{0xdeaca018,0x3265a002,0x4ebe0002,0xebde4003}},	//   _controle_, _фотограф_свиђа_, _нико__не_, _ལྕོག__རི_, 
   {{0x24424004,0xe98a600e,0xfbd36006,0x00000000}},	//   _lam_, _proč_, _བསམ__ལན_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x72328005,0xc4b3401a,0x49ee800b,0x00000000}},	// [b50] _bokmål_, _mykje__av_, _ukwizera_, --, 
   {{0x64752028,0x6bece003,0x00000000,0x00000000}},	//   _anuncios__de_, _སྡེ__ཁག_, --, --, 
   {{0x84424004,0x72d8a02e,0x0bdd400a,0xf469c009}},	//   _bam_, _uvjeti_, _मिलता__है_, _jeg__fik_, 
   {{0xdc01e009,0xf51bc007,0x00000000,0x00000000}},	//   _næsten_, _mengawal_, --, --, 
   {{0xad9c4002,0xb2fc201d,0xc3c92037,0x0c81600c}},	//   _могући__су_, _cikgu_, _ver__página_, _कप__कबड्डी_, 
   {{0x63574022,0x89b1a025,0x123d000b,0xe471800b}},	//   _करेले_, _atividad, _kuri__meni_, _icyo__gihugu_, 
   {{0xf4b18010,0x9adca01a,0x00000000,0x00000000}},	//   _eller__der_, _samlar__postadre, --, --, 
   {{0x2437a00b,0xb7f0c003,0x00000000,0x00000000}},	//   _catholik, _འུར__འདོན_, --, --, 
   {{0xc2b6e01e,0x0dad0018,0xaeec400b,0x00000000}},	//   _ica__vrijeme_, _quantida, _ya__software_, --, 
   {{0x04424004,0x00000000,0x00000000,0x00000000}},	//   _zam_, --, --, --, 
   {{0xf4424004,0x00000000,0x00000000,0x00000000}},	//   _yam_, --, --, --, 
   {{0xe4424031,0x02246004,0x861c000c,0x00000000}},	//   _hal_, _wonk_, _आर्थिक__ताकत_, --, 
   {{0xf29de00b,0x00000000,0x00000000,0x00000000}},	//   _imvano__umva_, --, --, --, 
   {{0xa22b2024,0x12da400b,0xce63c002,0x00000000}},	//   _promene_, _urwego_, _језици__ова_, --, 
   {{0x23ef402e,0x34424027,0x2243a020,0xd0efc006}},	//   _obitelji_, _mal_, _གོལ_, _རྒྱབ__འབྲ_, 
   {{0x43720018,0x6ca5a012,0x5311c00d,0x026c400b}},	//   _como__amigo_, _upraviť__zmazať_, _para__hacer_, _uyu__ujejwe_, 
   {{0x34b2201e,0x6b8dc020,0x00000000,0x00000000}},	// [b60] _posta__nja_, _ཀང_, --, --, 
   {{0x223ea026,0xb6dc6002,0x00000000,0x00000000}},	//   _svar__skriv_, _коришћењ, --, --, 
   {{0x846a2018,0x00000000,0x00000000,0x00000000}},	//   _bom__dia_, --, --, --, 
   {{0x57646002,0x9cdc200f,0x1764000c,0x52950003}},	//   _безбедно, _ubufakaz_bokuthi_, _इमे__भोजा_, _བཤད__སྟག_, 
   {{0xeb9c0003,0x3311c011,0x23a30002,0xfad68002}},	//   _མཆོག__གི_, _para__facer_, _фински__француск, _јануара_, 
   {{0xd4424004,0x94424038,0xebbc800a,0x00000000}},	//   _wam_, _cal_, _वेबसाइट__के_, --, 
   {{0x9c99e006,0x00000000,0x00000000,0x00000000}},	//   _རྡོར__རྗེའི_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xc25a800f,0xcc5d6018,0x3de9e003,0x00000000}},	//   _obala_, _gestão_, _སྲིད__དམངས_, --, 
   {{0xc455001d,0x829c2006,0xee88e002,0xf2dc2018}},	//   _aktiviti__dakwah_, _སྦྱར__ཚིག_, _би__да_, _por__meio_, 
   {{0xae612002,0xb2fce01a,0xbd1e800e,0x00000000}},	//   _где_, _gongen_, _ze__světa_, --, 
   {{0xf4aa2002,0x82b44002,0x00000000,0x00000000}},	//   _din__din_, _пошта__обавезно_, --, --, 
   {{0xe66c002d,0xf2e1000c,0x00000000,0x00000000}},	//   _odvjetni, _डालीं_, --, --, 
   {{0x6ba2000e,0x13fde00f,0x77f0e003,0x00000000}},	//   _případě_, _kanzima_, _རིམ__བྱོན_, --, 
   {{0xd3ea0009,0xc478a011,0xd27ee00b,0xf256e00a}},	//   _kl__læs_, _kamykaze__en_, _ikintu_, _बनाइये_, 
   {{0x6303e016,0x00000000,0x00000000,0x00000000}},	//   _les__alle_, --, --, --, 
   {{0x24438005,0x00000000,0x00000000,0x00000000}},	// [b70] _bnr_, --, --, --, 
   {{0x9a17a00f,0x94352011,0xd46aa018,0xfbc7400a}},	//   _ucabanga_, _de__feito_, _com__sua_, _पृष्ठ__से_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x54426018,0xb4a8202f,0x72f3600f,0x00000000}},	//   _nao_, _opcional_, _sengathi_, --, 
   {{0x94438053,0x00000000,0x00000000,0x00000000}},	//   _ins_, --, --, --, 
   {{0x9b58c00c,0x00000000,0x00000000,0x00000000}},	//   _रहलन_, --, --, --, 
   {{0xc4424005,0xb4352011,0xe7bb800b,0x4d13a00b}},	//   _val_, _de__xeito_, _yaturiki, _iburasir, 
   {{0xf2d4200f,0x00000000,0x00000000,0x00000000}},	//   _uma__ngabe_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7e8a804f,0x6d72600e,0x00000000,0x00000000}},	//   _प्रतिशत_, _náměstí_, --, --, 
   {{0x026cc024,0x931b8012,0x7e4da00a,0x9761400c}},	//   _hteo_, _názov_, _खाता__बनाएँ_, _बा__जवना_, 
   {{0x74370009,0x7d47a00f,0x00000000,0x00000000}},	//   _det__bliver_, _ibhabhil_elikhulu_, --, --, 
   {{0xbe3d6006,0x72fce01a,0x0a9e4014,0xa3cee00e}},	//   _ལོ__བརྒྱའི_, _songen_, _संस्कृति__में_, _provoz_, 
   {{0xec59e00a,0x00000000,0x00000000,0x00000000}},	//   _साल__पहले_, --, --, --, 
   {{0x0a3e4022,0xd44cc01d,0x00000000,0x00000000}},	//   _भजन_, _lompat__ke_, --, --, 
   {{0xc6c5e01f,0xd7982003,0x00000000,0x00000000}},	//   _sebahagi, _ཁྱོན_, --, --, 
   {{0xd2fc801f,0xe4c3a00e,0xa27c400e,0x00000000}},	// [b80] _niaga_, _přejít__na_, _vám__podle_, --, 
   {{0x8242a003,0x54438026,0x00000000,0x00000000}},	//   _ཐུབ_, _ens_, --, --, 
   {{0xe60bc00f,0x00000000,0x00000000,0x00000000}},	//   _kujehova__unkulunk, --, --, --, 
   {{0x6e53400b,0xbc75200c,0x2e6de00a,0x00000000}},	//   _amabombe_, _गोग्गल_, _अधिकारिय, --, 
   {{0x3e936002,0x00000000,0x00000000,0x00000000}},	//   _године__на_, --, --, --, 
   {{0x726ce03d,0xbae40006,0x0c4e800a,0xa4426025}},	//   _tohoto_, _བཅོས__དམིགས_, _जिसे_, _sao_, 
   {{0xeb94c022,0x7eb30011,0x65aa0018,0x5b9c2003}},	//   _दिवस__के_, _dereitos_, _promoçõe, _གསེར__རྟ_, 
   {{0x7014c037,0x43a18018,0x00000000,0x00000000}},	//   _puede__comentar_, _de__desejos_, --, --, 
   {{0x94426031,0x5d1e200b,0x00000000,0x00000000}},	//   _ban_, _genocide_, --, --, 
   {{0x5b6b8021,0xac4b200e,0x00000000,0x00000000}},	//   _སྒང__རྫོང_, _ze__produktů_, --, --, 
   {{0x52924025,0xa580800e,0x00000000,0x00000000}},	//   _citado_, _využít_, --, --, 
   {{0xc2d8c01a,0x95b1c00a,0x42724002,0x2b9a800f}},	//   _bilete_, _है__सहमत_, _због__тога_, _umnikelo_, 
   {{0x1da3200c,0x00000000,0x00000000,0x00000000}},	//   _संगोष्ठी_, --, --, --, 
   {{0xe4426015,0x34438002,0x7cc0a00a,0x92436003}},	//   _gan_, _sns_, _जाने__वाले_, _ཕུང_, 
   {{0xdf3bc015,0x3bfda006,0xeb9dc00a,0x7be72003}},	//   _kebutuha, _བོ__ཌི_, _के__इस_, _སླར__ཡང_, 
   {{0x5490000d,0xb9c0c00f,0xc2c68003,0x00000000}},	//   _el__uso_, _okudinge, _གཅིག__བོན_, --, 
   {{0x5c648028,0x7eb72002,0x00000000,0x00000000}},	// [b90] _octubre_, _наравно_, --, --, 
   {{0xae680013,0x6cbe0012,0x00000000,0x00000000}},	//   _राष्_, _predchád_súhlasu_, --, --, 
   {{0xf2d82016,0xce00c002,0x00000000,0x00000000}},	//   _øker_, _први__пут_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa9f54018,0xafe12037,0xc692000c,0x3318c012}},	//   _preço_, _el__vendedor_, _डॉ__आनंद_, _pozrieť_, 
   {{0xc4428004,0xb30fe031,0x00000000,0x00000000}},	//   _laa_, _menatap_, --, --, 
   {{0x02b4400e,0xb490e012,0xade16002,0x00000000}},	//   _vůbec_, _je__pre_, _па__су_, --, 
   {{0x427ec009,0xb275800e,0x49f7a002,0x00000000}},	//   _uden_, _napište__nám_, _државу_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x0f57e003,0x22cb400d,0x0213a035,0x15252014}},	//   _གསར__འགྱུར_, _pueden_, _lapha_, _दृढ़ता_, 
   {{0xb421e002,0x4911000e,0xac05200a,0x00000000}},	//   _ženski__poruke_, _odpovída, _जाने__की_, --, 
   {{0xf3a4e009,0x00000000,0x00000000,0x00000000}},	//   _spændend, --, --, --, 
   {{0x668c2014,0x00000000,0x00000000,0x00000000}},	//   _पुरान_, --, --, --, 
   {{0xe2266016,0x00000000,0x00000000,0x00000000}},	//   _brukes_, --, --, --, 
   {{0x5747c020,0x00000000,0x00000000,0x00000000}},	//   _དོན__སྲིད_, --, --, --, 
   {{0x23806004,0x189d200e,0x27982003,0x5c14e00e}},	//   _petros_, _soutěž_, _ཀྱིན_, _získat_, 
   {{0x47cea00b,0x2446c011,0x8cde8006,0xf34c6011}},	// [ba0] _amashaki, _galego__ir_, _གྲྭ__རྡོར_, _xuvenil_, 
   {{0xf4e58025,0x5787c003,0x3b88600c,0x00000000}},	//   _em__relação_, _བོད__སྲིད_, _बड़_, --, 
   {{0xc32e800b,0xedd86003,0x2bcc8003,0x00000000}},	//   _to__friend_, _དྲ__འབྲེལ_, _མཁན__མང_, --, 
   {{0xad80a00b,0x0aaac00c,0x6bd6e003,0x00000000}},	//   _jenoside__yakorewe_, _लोगन__में_, _འོག__ཏུ_, --, 
   {{0xc7836014,0x00000000,0x00000000,0x00000000}},	//   _प्रायोजि, --, --, --, 
   {{0xf4500011,0xb2fa600f,0xee90c002,0x0eb62002}},	//   _túa__conta_, _amahora_, _вас__да_, _систем_, 
   {{0x34b12030,0xa481c00b,0x00000000,0x00000000}},	//   _okt__vrh_, _muri__za_, --, --, 
   {{0x16f8c00a,0x33910002,0xbe172002,0x00000000}},	//   _रहता_, _ових_, _иначе_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xac3c0002,0x00000000,0x00000000,0x00000000}},	//   _пословањ, --, --, --, 
   {{0x72e1a01a,0xca77c00e,0x00000000,0x00000000}},	//   _og__anna_, _rozpětí__rozlišen, --, --, 
   {{0xa283e004,0x69fc6016,0x1999a00e,0x92ff600b}},	//   _kutheni_, _dette__nettsted, _např_, _aires__kuva_, 
   {{0xe23b0019,0x12a6c033,0xac604012,0xb2f3000f}},	//   _innlegg_, _osobnu_, _augusta_, _ngayo__dlulela_, 
   {{0x4340600b,0x00000000,0x00000000,0x00000000}},	//   _yari__yarazwi_, --, --, --, 
   {{0x48870018,0x8fd0800a,0xaf1b803d,0xb03e200c}},	//   _bom__estrelas_, _पर्यटन__समाचार_, _vaši_, _के__गवाह_, 
   {{0x4253000e,0x427e6015,0xcb92200f,0x00000000}},	//   _nejprve__přihlási, _yoona_, _okunjalo_, --, 
   {{0x42d8800c,0x00000000,0x00000000,0x00000000}},	// [bb0] _गुरूजन__आंदोलन_, --, --, --, 
   {{0x62bf400a,0x00000000,0x00000000,0x00000000}},	//   _जाएं_, --, --, --, 
   {{0x43298019,0x00000000,0x00000000,0x00000000}},	//   _et__lite_, --, --, --, 
   {{0x1fdfc00e,0x2cd6800c,0xc3f1600a,0x00000000}},	//   _vaše__jméno_, _संस्कृति__मंत्री_, _शहर__इलाहाबाद_, --, 
   {{0x52d8a02c,0x048ba00b,0x00000000,0x00000000}},	//   _indege_, _ba__uwa_, --, --, 
   {{0xd09da020,0xf2438003,0x3256400a,0x3394c015}},	//   _འབྲ_, _ཁུང_, _करेंगे_, _liputan__lengkap_, 
   {{0x26eae00a,0x08a30011,0xe43e2009,0xba3dc013}},	//   _है__लेकिन_, _ferramen_persoais_, _vil__blive_, _सजा_, 
   {{0xadc0c002,0x00000000,0x00000000,0x00000000}},	//   _који__су_, --, --, --, 
   {{0x14b46011,0x29fe2002,0x00000000,0x00000000}},	//   _foundati_inc_, _коментар_коментар, --, --, 
   {{0x74c1c00b,0x00000000,0x00000000,0x00000000}},	//   _musi__wa_, --, --, --, 
   {{0x04a98037,0x00000000,0x00000000,0x00000000}},	//   _abajo__por_, --, --, --, 
   {{0x94d0800e,0x212ba00c,0xd46ae025,0xb4a6400f}},	//   _specifik, _लालू__यादव_, _com__que_, _abangaba__ngu_, 
   {{0xaed4e002,0xa2e1c00c,0x2163c002,0x00000000}},	//   _то_, _बानीं_, _добила_, --, 
   {{0xd26c2015,0x00000000,0x00000000,0x00000000}},	//   _ruko_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x3f03a031,0xb504c00c,0x00000000,0x00000000}},	//   _terjadin, _खातिर__जुटावल_, --, --, 
   {{0x14abe037,0xbddf8004,0x00000000,0x00000000}},	// [bc0] _hablaras__con_, _ubukumka, --, --, 
   {{0x3c16800f,0xb495c014,0x00000000,0x00000000}},	//   _sobukhos, _के__सरकारी_, --, --, 
   {{0xeb8e2003,0x00000000,0x00000000,0x00000000}},	//   _ཏང_, --, --, --, 
   {{0x26d2801c,0xf243a003,0x130ec00b,0x00000000}},	//   _लेकिन_, _གུང_, _umukuru__urwego_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x54a3401a,0x00000000,0x00000000,0x00000000}},	//   _handlar__om_, --, --, --, 
   {{0xcdba2019,0x51744025,0xc8e3a009,0xf3122018}},	//   _som__allerede_, _família_, _begynder_, _para__fazer_, 
   {{0x0ad2e029,0x0f57c002,0x00000000,0x00000000}},	//   _གཏུགས_, _државе_, --, --, 
   {{0x9316c012,0xebdd6003,0x00000000,0x00000000}},	//   _medzi_, _འདི__ཡི_, --, --, 
   {{0x24e9600a,0x7291a015,0x00000000,0x00000000}},	//   _नायिका__रोमांस_, _oppa_, --, --, 
   {{0xcadde003,0xe41c600f,0x00000000,0x00000000}},	//   _དཀོན__མཆོག_, _kahle__ukuthi_, --, --, 
   {{0xb2c3600f,0x3af92012,0x00000000,0x00000000}},	//   _dlulela_, _sekcí__prihlási, --, --, 
   {{0xd442c01d,0x762ae006,0x046be009,0x00000000}},	//   _kad_, _ཡོདཔ_, _gerne__vil_, --, 
   {{0xa7a2600d,0xf0bfa00e,0x2a732002,0x00000000}},	//   _la__política_, _dnešní_, _почетка_, --, 
   {{0x843aa02f,0x00000000,0x00000000,0x00000000}},	//   _na__lista_, --, --, --, 
   {{0xe442c009,0x6adce003,0xb25f0003,0x00000000}},	//   _lad_, _སྙིགས_, _ཁྲིམས__ཀྱི_, --, 
   {{0x5317800e,0x44658031,0x0c896003,0x00000000}},	// [bd0] _verze_, _berikut__ini_, _དབྱིན__ཇིིའི_, --, 
   {{0x42c2c00d,0xf2f82010,0x00000000,0x00000000}},	//   _un__poco_, _din__lokale_, --, --, 
   {{0x6f1b8012,0x727ec012,0x00000000,0x00000000}},	//   _vašu_, _zmeny_, --, --, 
   {{0x53866034,0xba85c002,0x2265000f,0x00000000}},	//   _stord_, _одговора_, _engozini_, --, 
   {{0x0ee3e012,0x70ee2014,0x33950012,0x00000000}},	//   _iný_, _कौरव_, _vlasov_, --, 
   {{0xebc7000c,0x23f8e00b,0x00000000,0x00000000}},	//   _कन्नौज__के_, _wihuse_, --, --, 
   {{0xf80cc002,0x00000000,0x00000000,0x00000000}},	//   _слика_, --, --, --, 
   {{0x61e0200c,0x00000000,0x00000000,0x00000000}},	//   _हम__काइल_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x4f58e025,0x00000000,0x00000000,0x00000000}},	//   _atualmen, --, --, --, 
   {{0xeae04009,0x04a9e026,0x4a1f4012,0x00000000}},	//   _sundheds, _der__vil_, _životný__štýl_, --, 
   {{0xbeccc00f,0x00000000,0x00000000,0x00000000}},	//   _nezingan, --, --, --, 
   {{0xfb988006,0x777d400a,0xee6ea002,0x00000000}},	//   _ཨིནམ__དང_, _उसे__जल्द_, _сматра__да_, --, 
   {{0x0443e00b,0x00000000,0x00000000,0x00000000}},	//   _onu_, --, --, --, 
   {{0x124d8006,0xdc56e00c,0xa69b0002,0x00000000}},	//   _སྦེ_, _सवाल__पूछे_, _захтев__пријави_, --, 
   {{0x0240800f,0x00000000,0x00000000,0x00000000}},	// [be0] _esimweni_, --, --, --, 
   {{0x3259a003,0x00000000,0x00000000,0x00000000}},	//   _རྒྱ__གཡག_, --, --, --, 
   {{0x82c90011,0x38630002,0x7a49c00c,0xa28fc003}},	//   _persoais__crear_, _пошаљи_, _स्थायी__रूप_, _ཐབས__མེད_, 
   {{0x64672015,0xceaa200a,0xe5214011,0x22e0a00d}},	//   _apa__aja_, _हॉट__शॉट्_, _no__concello_, _es__para_, 
   {{0x3879c003,0x1c0ba00c,0x00000000,0x00000000}},	//   _བདེ__སྐྱིད_, _नजर__ना_, --, --, 
   {{0xaba5001c,0x02ba601f,0xb1bf400a,0x1b884003}},	//   _है__की_, _ini__ialah_, _फ़ाइल_, _ལབ_, 
   {{0x7c48400a,0x4f3f000c,0x00000000,0x00000000}},	//   _वाले_, _अबहियों_, --, --, 
   {{0x7202600b,0x68ac600a,0x00000000,0x00000000}},	//   _tariki_, _फिल्मीखब_मूवीरिव्, --, --, 
   {{0x42a9c011,0x00000000,0x00000000,0x00000000}},	//   _terá__lugar_, --, --, --, 
   {{0x2baba002,0x8200c025,0x00000000,0x00000000}},	//   _истим__условима_, _ideia_, --, --, 
   {{0x746b600b,0x00000000,0x00000000,0x00000000}},	//   _ari__mu_, --, --, --, 
   {{0x9da7801d,0x52a16003,0x00000000,0x00000000}},	//   _kerosaka, _བསྟེན__ཤེས_, --, --, 
   {{0xfba66021,0x00000000,0x00000000,0x00000000}},	//   _བྱུས__དང_, --, --, --, 
   {{0x14aaa01a,0x7aadc00a,0x7d7ee002,0x00000000}},	//   _ein__fin_, _होती__हैं_, _ћу_, --, 
   {{0xf370800c,0x00000000,0x00000000,0x00000000}},	//   _अउर__भोजपुरी_, --, --, --, 
   {{0xd3144009,0x4e8b6002,0xe230600b,0x00000000}},	//   _slet__ikke_, _на__тај_, _umujyi_, --, 
   {{0x528a000d,0x04aa201a,0x00000000,0x00000000}},	// [bf0] _más__menos_, _der__ein_, --, --, 
   {{0xc2db2011,0xb405801a,0x23954025,0x00000000}},	//   _dividido__novo_, _til__varsle_, _apesar_, --, 
   {{0xab8ca013,0x00000000,0x00000000,0x00000000}},	//   _की_, --, --, --, 
   {{0x147ec002,0x529b200d,0xdc912025,0x8c48600c}},	//   _живот_, _lo__mismo_, _começou_, _लावे_, 
   {{0xd38e4037,0xb2dbc00b,0x76a3400a,0xadb98002}},	//   _compra__sobre_, _burabone_hano_, _वर__भिलाई_, _коју__су_, 
   {{0x2668201a,0x00000000,0x00000000,0x00000000}},	//   _diskuter_samanslå, --, --, --, 
   {{0x29bce002,0x8be1800c,0x00000000,0x00000000}},	//   _коментар, _हासिल__कऽ_, --, --, 
   {{0x03ebe01a,0x12a7e00f,0x00000000,0x00000000}},	//   _eitt_, _omubi_, --, --, 
   {{0x5427c002,0x00000000,0x00000000,0x00000000}},	//   _се__повезао_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x432ca02a,0x00000000,0x00000000,0x00000000}},	//   _høy_, --, --, --, 
   {{0x64156037,0x221d0002,0x00000000,0x00000000}},	//   _mensaje__privado_, _раду_, --, --, 
   {{0x22de600c,0x00000000,0x00000000,0x00000000}},	//   _कजरी_, --, --, --, 
   {{0x2a882013,0x50e8200a,0x9ab14012,0x3c5a000a}},	//   _लाइफ_, _लाइव_, _telefón_, _प्रिंट__करें_, 
   {{0x8a47c039,0x00000000,0x00000000,0x00000000}},	//   _menerima__pemberit, --, --, --, 
   {{0x53a62015,0xab8fc00c,0x03140009,0x6e62a002}},	//   _dki__jakarta_, _हऽ_, _hvor__meget_, _заједно__са_, 
  
   {{0x232e000b,0xef77e018,0x00000000,0x00000000}},	// [c00] _mu__karere_, _peça_, --, --, 
   {{0xf442e034,0x539aa00e,0x63fda01a,0x00000000}},	//   _lag_, _město_, _ein__norsk_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xec7b8033,0xeed28002,0x54ade038,0x00000000}},	//   _nađi_, _је__био_, _descarga_pdf_, --, 
   {{0x2eaae002,0x7398400b,0x00000000,0x00000000}},	//   _она__је_, _mu__mirenge_, --, --, 
   {{0xda0aa01f,0x64708028,0x6e3ce002,0xa2cb4011}},	//   _manakala_, _aceptaci_de_, _се__са_, _que__súa_, 
   {{0x0466801a,0x7be24003,0x00000000,0x00000000}},	//   _hadde__ein_, _ཀྱི__དྲ_, --, --, 
   {{0x55468012,0x924d8020,0xd2580003,0x0bf5600a}},	//   _zobraziť_, _སྦི_, _བྱུང__བའི_, _चुका__है_, 
   {{0x52b1e00b,0x9c06600c,0x00000000,0x00000000}},	//   _imodoka_, _चाहीं__कि_, --, --, 
   {{0x6319201d,0xc2ae000f,0x166fc025,0x00000000}},	//   _ke__pandu_, _lapho__abantu_, _ninguém_, --, 
   {{0x93170012,0x00000000,0x00000000,0x00000000}},	//   _žiadny_, --, --, --, 
   {{0x7dfd600f,0x00000000,0x00000000,0x00000000}},	//   _esikhath_esidlule_, --, --, --, 
   {{0x4e920012,0x96aec003,0x00000000,0x00000000}},	//   _poškoden, _སྙིང__སྟོབས_, --, --, 
   {{0xf8d7c037,0x432b6018,0x55b3e00e,0x4f138002}},	//   _ver__mensajes_, _no__boleto_, _některýc, _не__сме_, 
   {{0x8290e00b,0xf0f0400c,0x00000000,0x00000000}},	//   _bahawe_, _उठावे_, --, --, 
   {{0xdbe1000e,0x9be2c003,0x9eb66012,0xbbb8400a}},	//   _ke__srovnání_, _ཀྱི__མི_, _prihlás_, _वेबसाइट__पर_, 
   {{0x52552006,0xe497e00b,0x00000000,0x00000000}},	// [c10] _ལེབ__དཔར_, _mu__by_, --, --, 
   {{0xf56ac00b,0x3c4d200f,0x00000000,0x00000000}},	//   _ibijyany, _amakrist_okuqala_, --, --, 
   {{0x8e3e0002,0xe276c00f,0x7237000f,0x00000000}},	//   _корисник, _intando__yakhe_, _kunayo__yonke_, --, 
   {{0xa9b2800e,0x00000000,0x00000000,0x00000000}},	//   _pro__možnost_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xf243c003,0xa978000f,0x570a0015,0x6442e010}},	//   _ཞུས_, _eminyake, _spotligh_spotligh, _sag_, 
   {{0x8c134029,0x4472c009,0x0048000a,0x00000000}},	//   _དཀར__ཆག_, _skrevet__af_, _गुदगुदी_, --, 
   {{0x54430028,0x548cc018,0x00000000,0x00000000}},	//   _haz_, _clique__no_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x832a6012,0xa2f0000b,0x9b8fe00c,0xb405c00c}},	//   _sa__bude_, _buhinzi_, _सऽ_, _जगरदेव_, 
   {{0xb27e6019,0xa12ce00c,0x00000000,0x00000000}},	//   _venn_, _अइसन__बनावल_, --, --, 
   {{0x327f803c,0xca848030,0x00000000,0x00000000}},	//   _bosne_, _okt__lokacija_, --, --, 
   {{0x82730004,0x9317800e,0x00000000,0x00000000}},	//   _ke__ngoku_, _verzi_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xf3dd8015,0x615c0002,0x78dc0002,0x00000000}},	//   _siswa_, _кућа_, _кући_, --, 
   {{0x86dfe00a,0xd3f4000e,0x00000000,0x00000000}},	//   _पर__एकसाथ_, _zeptat_, --, --, 
   {{0x8127c002,0x328fe003,0x00000000,0x00000000}},	// [c20] _дневника_, _ཐེག__ཆེན_, --, --, 
   {{0x4443200d,0xfb8fe00c,0x00000000,0x00000000}},	//   _hay_, _तऽ_, --, --, 
   {{0x1e0d2002,0xa3d0a009,0x02990003,0x00000000}},	//   _све_, _at__benytte_, _ཀྱི__གནས_, --, 
   {{0x42d8002a,0xb3eaa00d,0xf2cfc00e,0x52d8e00c}},	//   _veien_, _lo__más_, _dokonce_, _हमनी_, 
   {{0x24444033,0x34430018,0x12c6a01a,0x9aa7200a}},	//   _kn_, _faz_, _fødd_, _में__पति_, 
   {{0xc27ee02a,0xe186800f,0x73320017,0x150a6002}},	//   _finnes_, _likankul, _mpix_, _привредн, 
   {{0x9c51c01d,0x4db7e003,0x00000000,0x00000000}},	//   _tentera_, _དབུ__འབྱེད_, --, --, 
   {{0xe73fa021,0xb0238012,0xa2a48003,0x00000000}},	//   _མཐུད_, _pondelok_, _ཚང__བོད_, --, 
   {{0xaa42e00c,0x00000000,0x00000000,0x00000000}},	//   _के__अउर_, --, --, --, 
   {{0x5444401a,0x00000000,0x00000000,0x00000000}},	//   _nn_, --, --, --, 
   {{0xffe82046,0x6bf1e01d,0x7bc2a006,0x6460000f}},	//   _स्थानीय_, _berterus, _གཏང__ནི_, _kusho__ukuthini_, 
   {{0x72a4e020,0x92c6a009,0x00000000,0x00000000}},	//   _ཤིས__ཆོས_, _møde_, --, --, 
   {{0x56dc800c,0x0abdc00c,0xf4baa00e,0x00000000}},	//   _मैथिल_, _घरन__में_, _telefony__jak_, --, 
   {{0xe26d800d,0xc761200c,0x22f36009,0x0d88c006}},	//   _otro_, _में__राजा_, _jeg__havde_, _གཡུས_, 
   {{0xf4430012,0xa285200f,0xda8c2002,0x18eb000c}},	//   _raz_, _umshado_, _обавеште, _कि__कीकट_, 
   {{0x8a49000a,0x9497400c,0x00000000,0x00000000}},	//   _नाम__टाइप_, _के__डिमांड_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [c30] --, --, --, --, 
   {{0xdb29e037,0xd2d9800a,0xc28e4003,0x00000000}},	//   _públicam_opinión_, _पहली_, _གསར__པའི_, --, 
   {{0xa761800c,0xc2ae000f,0x00000000,0x00000000}},	//   _बा__एकरा_, _futhi__abantu_, --, --, 
   {{0x746ae012,0x00000000,0x00000000,0x00000000}},	//   _ako__si_, --, --, --, 
   {{0xf2c10037,0xfb14c002,0x00000000,0x00000000}},	//   _cómo__pago_, _извор_, --, --, 
   {{0xf26c2004,0x72bf400f,0x00000000,0x00000000}},	//   _ziko_, _kwa__israyeli_, --, --, 
   {{0xa0fc800c,0x7b64a003,0x00000000,0x00000000}},	//   _बनावल_, _ཁུགས__གཡུང_, --, --, 
   {{0x79ca803a,0xd26c200d,0x9bdd4006,0x00000000}},	//   _རིའི_, _hijo_, _ཨིན__མི_, --, 
   {{0x9f100034,0x0fe6a00f,0x7f66c002,0x00000000}},	//   _og__fjordane_, _ukudla__okungoko, _имала_, --, 
   {{0xcbe50014,0x932ac039,0x00000000,0x00000000}},	//   _तक__ही_, _provinsi_, --, --, 
   {{0xd248c01a,0xaad64018,0x00000000,0x00000000}},	//   _kjem_, _criança_, --, --, 
   {{0x6431e018,0xb4b0800f,0x00000000,0x00000000}},	//   _impostos__gastos_, _indodana__ka_, --, --, 
   {{0x6d6d2002,0x02638003,0x4a1e200f,0x00000000}},	//   _сте_, _ནག__གིས_, _zonke__izidalwa_, --, 
   {{0x269c400c,0x00000000,0x00000000,0x00000000}},	//   _के__बिहार_, --, --, --, 
   {{0x635f200f,0x00000000,0x00000000,0x00000000}},	//   _umngane_, --, --, --, 
   {{0x02aa8011,0x1f0ec00c,0x00000000,0x00000000}},	//   _móbil_, _कि__विश्वामि, --, --, 
   {{0x645c4011,0xafb82012,0x00000000,0x00000000}},	// [c40] _ademais__de_, _priateľa_, --, --, 
   {{0xc186800f,0xf26d600f,0x43e1800f,0x00000000}},	//   _zikankul, _umgomo_, _ezweni__elisha_, --, 
   {{0x926c2028,0x5cd3c00a,0xdbf4c003,0xe1c9000c}},	//   _dijo_, _कारण__चुनें_, _གི__གད_, _के__मिलल_, 
   {{0x09f4a018,0x64036003,0x24a94018,0x00000000}},	//   _bebê_, _འགྱུར__རྒྱལ_, _sofrer__alteraçõ, --, 
   {{0x24966030,0xd2efe00a,0xd2502002,0xd6812002}},	//   _pridruže_apr_, _उम्र_, _њега_, _унутрашњ, 
   {{0xb355e004,0x32c0c00f,0x00000000,0x00000000}},	//   _ndifuna_, _angaphez_kuka_, --, --, 
   {{0x1c90c00f,0x00000000,0x00000000,0x00000000}},	//   _umphosto_upawulu_, --, --, --, 
   {{0x0bb1000a,0x4c52400a,0x924c0003,0x00000000}},	//   _यह__है_, _अजमेर_, _ཉོས_, --, 
   {{0x74b9602a,0x4766e00c,0x00000000,0x00000000}},	//   _ikke__noe_, _करे__वाला_, --, --, 
   {{0x5186800f,0x00000000,0x00000000,0x00000000}},	//   _sikankul, --, --, --, 
   {{0xb326c00e,0x6c07800e,0x00000000,0x00000000}},	//   _hodin__více_, _odeslat_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x8a11e031,0xce292002,0xd2d8200e,0x00000000}},	//   _pemberit, _кад_, _nejen_, --, 
   {{0xd984001a,0x870e600c,0x6b408003,0x00000000}},	//   _kommente_innlegge, _के__अपना_, _འགྱུར__གཏོང_, --, 
   {{0xa599603e,0xae9ec01d,0xe6f8000a,0x00000000}},	//   _सहित_, _terma__pengguna, _लेना_, --, 
   {{0x6bd5a00e,0xac91600a,0xccbbe014,0x00000000}},	//   _více__informac, _दिनों_, _में__पहुंच_, --, 
   {{0x04a3200e,0x00000000,0x00000000,0x00000000}},	// [c50] _heureka__cz_, --, --, --, 
   {{0xeb9c200c,0x00000000,0x00000000,0x00000000}},	//   _आजमगढ़__के_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xdb064002,0x00000000,0x00000000,0x00000000}},	//   _одговори_, --, --, --, 
   {{0x85d4000f,0xe29ec002,0x00000000,0x00000000}},	//   _galathiy, _никад_, --, --, 
   {{0xa35c8007,0x5254e003,0x00000000,0x00000000}},	//   _perkara__yang_, _བཅོས__དཔར_, --, --, 
   {{0x67580018,0x4779200c,0x00000000,0x00000000}},	//   _de__divergên, _निर्धारि_सीमा_, --, --, 
   {{0x0d98c01e,0x00000000,0x00000000,0x00000000}},	//   _sallalla, --, --, --, 
   {{0xc2c36025,0xee48e002,0x00000000,0x00000000}},	//   _um__novo_, _могли__да_, --, --, 
   {{0xe9d76009,0x52d82009,0x410ca014,0x00000000}},	//   _vores__tjeneste, _vejen_, _हताशा_, --, 
   {{0xc2b4000f,0x4301e00b,0x00000000,0x00000000}},	//   _izici_, _yarazwi_, --, --, 
   {{0xba69c00b,0xd590800f,0x77daa00a,0x0c52000b}},	//   _washobor_kubikora_, _wayeseth, _पसंद__टिप्पणी_, _amateka_, 
   {{0xc26c2020,0x1cf72003,0x00000000,0x00000000}},	//   _ལྔ__པའི_, _ཆག__འབོལ_, --, --, 
   {{0xdd47a017,0x00000000,0x00000000,0x00000000}},	//   _dispozic, --, --, --, 
   {{0x5e08e007,0x849a4011,0xfba7c003,0x00000000}},	//   _hendakla, _acceder__ao_, _ཁག__དང_, --, 
   {{0x59c1800f,0x00000000,0x00000000,0x00000000}},	//   _ngemva__kwezinsu, --, --, --, 
   {{0xe442002b,0xcdc72012,0x82436003,0xf3fc000e}},	// [c60] _ibi_, _kliknite_, _ཕུན_, _procháze, 
   {{0x926c400f,0x8f052002,0x6c78e007,0x00000000}},	//   _simo_, _енциклоп_скочи_, _perdana__menteri_, --, 
   {{0xf2c88024,0xb37f800f,0x00000000,0x00000000}},	//   _devojke_, _ikhanda_, --, --, 
   {{0x9f53e01a,0x3248c00b,0x6d224006,0x00000000}},	//   _frå_, _ibiganir_bishya_, _སྐུ__འཁོར_, --, 
   {{0x2442000b,0xebbde014,0x00000000,0x00000000}},	//   _mbi_, _शब्द__के_, --, --, 
   {{0xe43ca01a,0x00000000,0x00000000,0x00000000}},	//   _og__vert_, --, --, --, 
   {{0x1478c028,0x32da400b,0x00000000,0x00000000}},	//   _problema__con_, _bitewe_, --, --, 
   {{0xbc48800c,0xc47ba00d,0x0bdb600a,0x00000000}},	//   _साथे_, _para__una_, _कहा__है_, --, 
   {{0x67a34004,0xeb322003,0x00000000,0x00000000}},	//   _bubungqi, _གི__འདུག_, --, --, 
   {{0xc26cc018,0xb2ce002a,0x7aa6800c,0x00000000}},	//   _tudo_, _du__finner_, _में__नकद_, --, 
   {{0x16d5e01f,0x7be2c003,0x1f0de00e,0xca21400f}},	//   _berbandi, _པའི__དྲ_, _cz__hodnocen, _futhi__ekugcine, 
   {{0xb2b9800a,0x93258018,0x0324200f,0x00000000}},	//   _यहां_, _de__parede_, _kuye__kwaba_, --, 
   {{0x0ab94014,0x00000000,0x00000000,0x00000000}},	//   _रुप__में_, --, --, --, 
   {{0x93e4c00e,0x133de01f,0x52eec013,0xebb5600c}},	//   _děti_, _dan__boleh_, _कबीर_, _मॉड्यूल__के_, 
   {{0x83168004,0xbb2a2020,0x00000000,0x00000000}},	//   _mfazi_, _སྒོང_, --, --, 
   {{0x44d9600c,0x00000000,0x00000000,0x00000000}},	//   _अउर__अफगानिस्, --, --, --, 
   {{0xb2248012,0x00000000,0x00000000,0x00000000}},	// [c70] _inak_, --, --, --, 
   {{0xa2bcc030,0xf4798009,0xaabc200a,0x00000000}},	//   _na__depo_, _hvad__der_, _बुशहर__ऊना_, --, 
   {{0x52924009,0x00000000,0x00000000,0x00000000}},	//   _aftale_, --, --, --, 
   {{0x9be34003,0x00000000,0x00000000,0x00000000}},	//   _པའི__མི_, --, --, --, 
   {{0x0bb1e014,0xec27a002,0x00000000,0x00000000}},	//   _में__राष्ट्री, _пример_, --, --, 
   {{0x42d84015,0x00000000,0x00000000,0x00000000}},	//   _temen_, --, --, --, 
   {{0xe25aa01a,0x7b772006,0x89e1a012,0x00000000}},	//   _tidleg_, _ཞིབ__གདོང_, _človeka_, --, 
   {{0xdfc7000e,0x8ccf800e,0x00000000,0x00000000}},	//   _článek_, _dvě_, --, --, 
   {{0x5347200c,0x5456400f,0x6646c002,0x00000000}},	//   _करे__वाली_, _amahora__adlule_, _пријава_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6429c007,0xaf8d200e,0x6e2ea002,0xa7176013}},	//   _kumpulan_, _našeho_, _вези__са_, _जल्दी_, 
   {{0x48e4a00c,0xee5ee002,0x00000000,0x00000000}},	//   _कि__भोजपुर_, _али__да_, --, --, 
   {{0x4cbe6002,0x49d0601a,0x00000000,0x00000000}},	//   _ваше_, _er__beskytta_, --, --, 
   {{0xb47b4007,0x00000000,0x00000000,0x00000000}},	//   _malaysia__dan_, --, --, --, 
   {{0xc4616016,0xf26c600b,0x11a4c040,0x00000000}},	//   _innlegg__del_, _hino_, _nikolić_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [c80] --, --, --, --, 
   {{0x624c6006,0x8af92025,0x029f8003,0x00000000}},	//   _ཇོང_, _ilustrat, _ཀྱིན__ཡོད_, --, 
   {{0x526ce038,0xb3f1600b,0x6306400a,0x00000000}},	//   _lugo_, _amabombe__abiri_, _लुधियाना_, --, 
   {{0xa608c002,0x00000000,0x00000000,0x00000000}},	//   _заједниц, --, --, --, 
   {{0xd4aba011,0xb533200f,0xa243c003,0x00000000}},	//   _persoas__que_, _okungaph, _འབོལ__རྩོམ_, --, 
   {{0x821c400f,0xa7bd400c,0x00000000,0x00000000}},	//   _omuhle_, _पर__विस्तार_, --, --, 
   {{0xdb8d400c,0x02998003,0xdd05e00b,0x2bea400a}},	//   _छी_, _པའི__གནས_, _abarorer, _बिज़नस__घर_, 
   {{0x74aba01a,0x9a6d2018,0x00000000,0x00000000}},	//   _ein__tur_, _quantida_você_, --, --, 
   {{0x6d938003,0x72fc000b,0x3304a00b,0xbc35c002}},	//   _རྣམས__ཀྱིས_, _ibigo_, _isi__yose_, _чланови_, 
   {{0xecb96003,0x073c6002,0xf495c00a,0x5a41200a}},	//   _བཀའ__ཁྲིའི_, _комуника, _के__द्वारा_, _की__जगह_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x43554025,0x644e200e,0xc7ee400b,0x00000000}},	//   _até__momento_, _případě__že_, _kiratang, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xe12d0002,0xabcb4003,0x00000000,0x00000000}},	//   _сајта_, _ཀྱང__དེ_, --, --, 
   {{0x3fcd8002,0x72c4201d,0xe301e00b,0x00000000}},	//   _од__стране_, _menerusi_, _sinai__ukwa_, --, 
   {{0xebc2600c,0x00000000,0x00000000,0x00000000}},	//   _एकरा__के_, --, --, --, 
   {{0x373a2003,0x61afe002,0x00000000,0x00000000}},	// [c90] _འགོད_, _здравља_, --, --, 
   {{0x8237800f,0x3bba400c,0x5866800b,0x00000000}},	//   _kunazo__zonke_, _जुड़ल__बा_, _majyarug, --, 
   {{0x04ab201a,0x00000000,0x00000000,0x00000000}},	//   _med__ein_, --, --, --, 
   {{0x7ab3800a,0x82bc2011,0xb0f2a003,0x00000000}},	//   _जाते__हैं_, _crear__unha_, _འདི__འདྲ_, --, 
   {{0x6c69e015,0x827d2003,0x00000000,0x00000000}},	//   _korupsi_, _བདག__དབང_, --, --, 
   {{0xb26ce00b,0x00000000,0x00000000,0x00000000}},	//   _rugo_, --, --, --, 
   {{0xe295e007,0x6dd74003,0x00000000,0x00000000}},	//   _terkini_, _ཞོད__ཀྱིས_, --, --, 
   {{0x4d93401a,0xcb8d6014,0x00000000,0x00000000}},	//   _nettstad_, _छठ_, --, --, 
   {{0x144bc02a,0x2443800b,0xa395a00e,0x75cf200c}},	//   _merket__med_, _yar_, _mobilní__telefon_, _अउर__भारत_, 
   {{0x554c200b,0xee6a0002,0xf2a70012,0x00000000}},	//   _mashyash, _могу__да_, _stavebné_, --, 
   {{0xf28e400a,0x0bbac006,0x0d37a003,0x00000000}},	//   _तस्वीरें_, _ལོ__ལུ_, _མི__འབོར_, --, 
   {{0xf3e68012,0xa25ac00e,0x00000000,0x00000000}},	//   _túto_, _zcela_, --, --, 
   {{0x7be2c003,0x0679e002,0xc35f000f,0x5311200e}},	//   _གྱི__དྲ_, _правосла, _zingase_, _pohotovo_doba_, 
   {{0x9479c01d,0xd338a037,0x00000000,0x00000000}},	//   _pada__hb_, _sitio__implica_, --, --, 
   {{0xb443801d,0x04a68008,0x00000000,0x00000000}},	//   _bas_, _artigos__por_, --, --, 
   {{0xc4438045,0x42d5c002,0x00000000,0x00000000}},	//   _cas_, _чланци_, --, --, 
   {{0xbda56006,0x0c60a01d,0x8dee000a,0x5720200a}},	// [ca0] _འདྲ__བཤུས_, _mahupun_, _दसवीं__वर्षगाँठ_, _भद्दी__भाषा_, 
   {{0x9296800f,0x682cc003,0x2eaf600a,0xf0064002}},	//   _kukho__konke_, _སྤྱིར_, _अप्रैल__मार्च_, _унесите__свој_, 
   {{0x0364801a,0x04aaa01a,0x422ce00c,0x00000000}},	//   _din__logg_, _det__ein_, _के__नक्शा_, --, 
   {{0x9bf9e00f,0x8d8a8006,0x629d4012,0x048ba00e}},	//   _isithomb, _རིངས_, _zľavy_, _kč__dph_, 
   {{0x535f000f,0xaf3a4011,0xe4694009,0x00000000}},	//   _singase_, _tecnolóx, _dkk__dkk_, --, 
   {{0x7e89c01d,0x72ece027,0x9be34003,0x6d630003}},	//   _pertanya_pekerjaa, _neviete_, _གྱི__མི_, _བཟོ__སྐྲུུན_, 
   {{0x50ebc002,0x00000000,0x00000000,0x00000000}},	//   _на__језика_, --, --, --, 
   {{0x67dcc003,0x5287a003,0x1bde600c,0x00000000}},	//   _འགན__འཛིན_, _ཚིག__གཡུ_, _दू__गो_, --, 
   {{0x2be60029,0x00000000,0x00000000,0x00000000}},	//   _སྨོན__ལམ_, --, --, --, 
   {{0xeba3a006,0x9be3c003,0x6319200b,0xe921400e}},	//   _འབྲུག__གི_, _བའི__མི_, _fdu__inkingi_, _aktivní_, 
   {{0x0f2f2009,0xc2cf2009,0xdc09200c,0x67ace006}},	//   _annoncer_, _annonce_, _काम__करे_, _གློག__གཉེན_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x53f9000b,0x00000000,0x00000000,0x00000000}},	//   _imbuga_, --, --, --, 
   {{0x2f88401a,0xa74ec002,0x23da602c,0x4cc4a00a}},	//   _vilkåra__sjå_, _права_, _wa__mbere_, _पटना__पुणे_, 
   {{0xf364a01a,0x00000000,0x00000000,0x00000000}},	//   _ein__gong_, --, --, --, 
   {{0x12e7200f,0x00000000,0x00000000,0x00000000}},	//   _kodwa__amanothi_, --, --, --, 
   {{0xe322800d,0x00000000,0x00000000,0x00000000}},	// [cb0] _la__verdad_, --, --, --, 
   {{0x613d4002,0x79e3c002,0x00000000,0x00000000}},	//   _април__март_, _долара_, --, --, 
   {{0xd4438015,0x94424015,0x5a42000c,0xd44d6028}},	//   _tas_, _bbm_, _के__खास_, _tienes__que_, 
   {{0x63ee0026,0x00000000,0x00000000,0x00000000}},	//   _der__hvor_, --, --, --, 
   {{0x63226012,0x96886012,0x0ece0018,0xc353200c}},	//   _týchto_, _reklamné__oznámeni, _indispon, _आवेला_, 
   {{0xca590012,0xbea8a00c,0x00000000,0x00000000}},	//   _inzercia_, _गइल__कुल्_, --, --, 
   {{0xe9de2028,0x01744018,0xb67fc00c,0x00000000}},	//   _contenid, _polícia_, _इयाद_, --, 
   {{0x254f8012,0xeba6a00a,0x00000000,0x00000000}},	//   _môžeme_, _प्रकार__के_, --, --, 
   {{0xd45c6011,0xa29a2006,0x02998003,0x00000000}},	//   _novidade_desta_, _ལེནཌ__ལྷོ_, _གྱི__གནས_, --, 
   {{0x2dfa2006,0xc28f4003,0x13f8a01d,0xb2990003}},	//   _འགྱོ_, _ཐུབ__པའི_, _jadual_, _ཀྱི__གནད_, 
   {{0x3fc9601a,0xbf580006,0x68c06013,0x5480600f}},	//   _artiklar_, _འདི__འབྲུག_, _नागपुर_, _muva__nje_, 
   {{0xe467602a,0x2280c003,0x02902007,0xda69e014}},	//   _bilde__til_, _ལོ__ལོར_, _jemaah_, _रविशंकर_, 
   {{0x4004a01a,0x029a0003,0x00000000,0x00000000}},	//   _relatert_artiklar_, _བའི__གནས_, --, --, 
   {{0xebfa6002,0x00000000,0x00000000,0x00000000}},	//   _najviše__komentar, --, --, --, 
   {{0x7240e00a,0x00000000,0x00000000,0x00000000}},	//   _आपयहांहै_, --, --, --, 
   {{0xe452202a,0x12666002,0x00000000,0x00000000}},	//   _ågå__til_, _словенач_шпански_, --, --, 
   {{0x67f6e022,0xc2f1400c,0x00000000,0x00000000}},	// [cc0] _के__संदर्भ_, _ओर__तेजी_, --, --, 
   {{0x59ef000b,0x00000000,0x00000000,0x00000000}},	//   _nta__gitekere, --, --, --, 
   {{0x225aa02a,0x00000000,0x00000000,0x00000000}},	//   _tidlig_, --, --, --, 
   {{0xc4ade01a,0x00000000,0x00000000,0x00000000}},	//   _eit__av_, --, --, --, 
   {{0x6b91a00f,0x00000000,0x00000000,0x00000000}},	//   _isinqumo_, --, --, --, 
   {{0x32a6c011,0x00000000,0x00000000,0x00000000}},	//   _probas_, --, --, --, 
   {{0xa3cec040,0x43966015,0x5bcdc00a,0x00000000}},	//   _čovek_, _persen_, _कुशीनगर_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x63f4603c,0x62ab4028,0xfbdaa003,0x00000000}},	//   _postao_, _de__año_, _ཐམས__ཅད_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x593ac004,0xb3b8000a,0x00000000,0x00000000}},	//   _zonke__iintlang, _दैनिक__ट्रिब्यू, --, --, 
   {{0x926d000f,0xeb9fc003,0xfbfc200c,0x3fdb200e}},	//   _kwakho__konke_, _རྒྱལ__དར_, _एही__से_, _webových__stránek_, 
   {{0x2a33001c,0x95d42015,0x67970003,0x00000000}},	//   _टीम_, _membutuh, _ཐག__གཅོད_, --, 
   {{0xb248800f,0xf2c74009,0x534b2037,0x7d7ee002}},	//   _kwami_, _måde_, _hace__meses_, _њу_, 
   {{0x0358a009,0x42a72003,0x4c46200c,0x9bcb200c}},	//   _brugere_, _སྲིད__ཇུས_, _पूरा__तरे_, _कहलन__कि_, 
   {{0xe2b6a003,0x25e9a00f,0x7dd1200a,0x00000000}},	//   _བལ__ཡུལ_, _ezisekel_ebhayibh, _दबाएं_, --, 
   {{0x9512000e,0x00000000,0x00000000,0x00000000}},	// [cd0] _průměr_, --, --, --, 
   {{0x7ab7000a,0x00000000,0x00000000,0x00000000}},	//   _रहते__हैं_, --, --, --, 
   {{0x74426004,0xfbeb000c,0x00000000,0x00000000}},	//   _obo_, _अतीत__से_, --, --, 
   {{0xc103a003,0x00000000,0x00000000,0x00000000}},	//   _ཚན__རྒྱ_, --, --, --, 
   {{0x54a54016,0x00000000,0x00000000,0x00000000}},	//   _adressa__no_, --, --, --, 
   {{0x1225e01a,0x00000000,0x00000000,0x00000000}},	//   _bruka_, --, --, --, 
   {{0x7bc32054,0x2471600b,0x00000000,0x00000000}},	//   _घरी_, _ekleziya__catholik, --, --, 
   {{0x8261e00f,0x3a55c00c,0x32c6800f,0x00000000}},	//   _kwansuku__zonke_, _के__संरक्षित_, _kuyoba__khona_, --, 
   {{0xc2c3e011,0x42cac01a,0xa3948018,0xc2d18003}},	//   _un__novo_, _suldal_, _quarta__feira_, _ཚོགས__འདུ_, 
   {{0xe280a00e,0x00000000,0x00000000,0x00000000}},	//   _diskuse_, --, --, --, 
   {{0x6f40e034,0x52bb6018,0xc4686015,0x00000000}},	//   _bakgrunn, _somente_, _mobil__serupa_, --, 
   {{0x930fe007,0xe2458012,0xc6f9400c,0x9716801c}},	//   _melihat__profil_, _témy_, _हमरा_, _है__क्या_, 
   {{0xa27f401d,0x7fe68038,0xdedb200c,0xace7a00a}},	//   _agensi_, _píxeles__píxeles_, _में__एकत्र_, _पर__फोलो_, 
   {{0x64650038,0x3948600f,0x7d064003,0xd2892003}},	//   _menú__de_, _enkonzwe, _ཡར__རྒྱས_, _བཀའ__ཁྲི_, 
   {{0x1442601e,0x00000000,0x00000000,0x00000000}},	//   _ibn_, --, --, --, 
   {{0x5e296002,0x2ba2800a,0x00000000,0x00000000}},	//   _нас_, _भी__हो_, --, --, 
   {{0x8bee6002,0x749c2002,0x00000000,0x00000000}},	// [ce0] _нато_, _члан_, --, --, 
   {{0xb2580003,0x5471a011,0x00000000,0x00000000}},	//   _དུས__ཀྱི_, _establec_no_, --, --, 
   {{0xe2d86017,0x0c6fc017,0x7bfd0003,0x00000000}},	//   _idnes_, _požadova_vlastnos, _སི__དྲ_, --, 
   {{0x236c600f,0x131fc00b,0x025f001d,0x9a4ac00c}},	//   _kungani_, _kuntu__yicisha_, _sila__klik_, _साफ__साफ_, 
   {{0x32824005,0x0480001a,0xbb8d4003,0x00000000}},	//   _eg__ikkje_, _vere__ein_, _པེ_, --, 
   {{0x736ba016,0x2be38003,0x00000000,0x00000000}},	//   _til__ring_, _ཀྱི__ཉི_, --, --, 
   {{0x3451a00b,0xc6e72011,0x747fc00e,0x1291400e}},	//   _ubuzima__bwite_, _inscrici, _jste__si_, _kalhoty_, 
   {{0x9db14028,0xbc7f4018,0x00000000,0x00000000}},	//   _lenguaje_, _versão_, --, --, 
   {{0x96fe2013,0xcbf9800f,0xdbff600c,0x00000000}},	//   _क्या_, _kwalokho_, _पंडित__जी_, --, 
   {{0x53ea8009,0x00000000,0x00000000,0x00000000}},	//   _skat_, --, --, --, 
   {{0x1af04003,0x6588e018,0x544ba00b,0x6779c00c}},	//   _གླེང__སྟེགས_, _obrigató, _ku__kibuga_, _अउर__पाकिस्ता, 
   {{0xebc3800c,0x0288a003,0x01f7800e,0xebc3600c}},	//   _भोज__के_, _ཞིག__གིས_, _některé_, _ओकरा__के_, 
   {{0x5443e01d,0x97f26012,0x04aba01a,0x00000000}},	//   _kat_, _možnosť_, _kan__ein_, --, 
   {{0xeefbc002,0xe2c7200e,0x00000000,0x00000000}},	//   _ствари_, _ráda_, --, --, 
   {{0x9c120003,0x00000000,0x00000000,0x00000000}},	//   _དཀར__དམ_, --, --, --, 
   {{0x0f82400e,0x00000000,0x00000000,0x00000000}},	//   _přihlašt, --, --, --, 
   {{0x6d8ae003,0xa4428012,0x04ab201a,0x320f4014}},	// [cf0] _རྣམས_, _iba_, _har__ein_, _गुंजाइश_, 
   {{0x48cf8018,0xa24cc020,0xb2920003,0x00000000}},	//   _produto__estrelas_, _ཏོང_, _འོད__དཀར_, --, 
   {{0x5312e008,0x8212c018,0xec036014,0x7306800b}},	//   _para__obter_, _melhor_, _घटना__के_, _boko__haram_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x82cea039,0x7df14015,0x17c6400a,0x0e898002}},	//   _yang__bisa_, _serta__kebijaka, _इन्हें_, _за__рад_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x92b9e01a,0x4abca002,0x00000000,0x00000000}},	//   _endeleg_, _министар_, --, --, 
   {{0xace1c00a,0xc0e8e006,0x8311800e,0x2356800c}},	//   _साल__जानेंभवि, _པཱན__རྒྱ_, _odebrat_, _लोक__संगीत_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2442802c,0xcc6ee034,0x1aacc00c,0x00000000}},	//   _aba_, _fjorden_, _उम्__मीद_, --, 
   {{0xa366800a,0xe45c200e,0x9f70c018,0x12a1a003}},	//   _राष्__ट्रीय_, _zpět__na_, _de__qualquer_, _འཛིན__ལྷན_, 
   {{0xa394a009,0x6c114006,0xd44da018,0x1de94003}},	//   _bedste_, _གཅིག__ཁར_, _usando__sua_, _བློ__གྲོས_, 
   {{0x7443e039,0x5c800002,0xd282a003,0xd77ac002}},	//   _mau_, _десет_, _གཏམ__དཔེ_, _за__приватиз, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xe26ce00b,0x00000000,0x00000000,0x00000000}},	//   _kigo_, --, --, --, 
   {{0x02de000f,0x00000000,0x00000000,0x00000000}},	//   _kulokhu_, --, --, --, 
   {{0x27c6400a,0x8a7ca00a,0xc8cdc018,0x00000000}},	// [d00] _उन्हें_, _पहली__बार_, _prefeitu, --, 
   {{0x8e35a006,0x126c801d,0xc6fa600a,0xfba40003}},	//   _ནང__བསྐྱོད_, _aktiviti_, _पहला_, _སྒྲིག__པར_, 
   {{0xd2cf8012,0x19a22009,0x00000000,0x00000000}},	//   _kancelár, _overvågn, --, --, 
   {{0xc969604c,0x0dd6400f,0x00000000,0x00000000}},	//   _साँझ_, _umxhwele_, --, --, 
   {{0x5c26c016,0x7c89200c,0x6c49200c,0x00000000}},	//   _bli__varslet_, _बादो_, _बादे_, --, 
   {{0xfb542003,0x00000000,0x00000000,0x00000000}},	//   _ཏུ__གླིང_, --, --, --, 
   {{0x952d8002,0xc3ab8012,0x526ce00b,0x00000000}},	//   _између_, _najviac_, _bigo_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xb3076009,0x2f8d200e,0x00000000,0x00000000}},	//   _aalborg_, _vašeho_, --, --, 
   {{0x41d8401c,0x00000000,0x00000000,0x00000000}},	//   _शेयर_, --, --, --, 
   {{0x2278e019,0x4be14003,0x8acac003,0x00000000}},	//   _som__kommer_, _ཆོས__ངོ_, _སྲེག_, --, 
   {{0x47692014,0xd1440022,0xd46c2025,0xc4eaa00a}},	//   _के__निर्माण_, _जासूसी_, _pessoas__que_, _बस्ती__बहराइच_, 
   {{0xdc17a018,0x3255000c,0x00000000,0x00000000}},	//   _tópico_, _लागेला_, --, --, 
   {{0x30678002,0x00000000,0x00000000,0x00000000}},	//   _развој_, --, --, --, 
   {{0x3c690037,0x82ac2012,0x0ab9200c,0x00000000}},	//   _carrito_, _sa__stal_, _खतरा__में_, --, 
   {{0x6442801b,0x39b50002,0xa2d46011,0x3b8f000c}},	//   _uba_, _uveče__uveče_, _axudas_, _मिलल__बा_, 
   {{0xaf7aa00e,0x00000000,0x00000000,0x00000000}},	// [d10] _upozorně, --, --, --, 
   {{0xf3d6a01a,0x24c6c002,0x4bb6800c,0x64764018}},	//   _er__berre_, _називи__датотека_, _के__भुगतान_, _julho__de_, 
   {{0x834c801d,0xeba1c00a,0x00000000,0x00000000}},	//   _yang__berbeza_, _भी__इस_, --, --, 
   {{0x3ed58009,0xe2e8800b,0x00000000,0x00000000}},	//   _udviklin, _guteza__imbere_, --, --, 
   {{0xd4b86011,0x00000000,0x00000000,0x00000000}},	//   _xeito__que_, --, --, --, 
   {{0xcc8a8002,0x00000000,0x00000000,0x00000000}},	//   _уреди__везе_, --, --, --, 
   {{0xea3d8003,0x84bd2011,0xe2f5a00b,0x00000000}},	//   _སོ__སོའི_, _conxunto_, _burundi__ukwa_, --, 
   {{0x8e2d0002,0x526d000d,0xd2d8a012,0x00000000}},	//   _број_, _hizo_, _odber_, --, 
   {{0x926ce038,0xca396009,0x00000000,0x00000000}},	//   _vigo_, _lokale__søgetjen, --, --, 
   {{0x4e51001f,0x832b600e,0x00000000,0x00000000}},	//   _sembahya, _se__bude_, --, --, 
   {{0x1029e00a,0x0442e018,0x2b8d8003,0x00000000}},	//   _एंड__स्पाइसी_, _acordo__com_, _ཁེ_, --, 
   {{0x88610010,0xdb08000f,0x00000000,0x00000000}},	//   _tilbyder_, _watshela_, --, --, 
   {{0x7b300002,0x52500002,0x00000000,0x00000000}},	//   _село_, _села_, --, --, 
   {{0xd33f0009,0x00000000,0x00000000,0x00000000}},	//   _søg__efter_, --, --, --, 
   {{0xb2430016,0x14bb8012,0x45dc800a,0xa2642003}},	//   _innlegg__klikk_, _práva__sú_, _संसार__व्रत_, _ཅན__ཞིག_, 
   {{0x527f4028,0x126d8004,0x0436a02a,0x32d8e005}},	//   _tienes_, _buso_, _de__beste_, _vegen_, 
   {{0x7da8a003,0xb261800b,0x73958025,0xc266400c}},	// [d20] _གྲོས__ཚོགས_, _karindwi_, _passa_, _के__मिलेला_, 
   {{0x23e72012,0xe46fa018,0x00000000,0x00000000}},	//   _táto_, _adiciona_na_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xd477600d,0x4c49800c,0xf212e025,0x00000000}},	//   _dijo__que_, _पावे_, _senhor_, --, 
   {{0xcc49e00c,0x00000000,0x00000000,0x00000000}},	//   _नामे_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xecfbe002,0x1339400f,0xa0898002,0x00000000}},	//   _лажнх__података_, _yini__ujehova_, _заштићен, --, 
   {{0x527f001d,0xfad2000b,0xb297a009,0xd720000c}},	//   _mudah__alih_, _abateget, _esbjerg_, _आलेख__कतना_, 
   {{0xbac5a03c,0xb85ca037,0x1c0dc00e,0x00000000}},	//   _iz__sarajeva_, _está__duplicad, _nejprve_, --, 
   {{0x683d000e,0x61d9400c,0xd4a5000a,0x00000000}},	//   _osobních_, _हमार_, _अन्य__भाषाएँ_, --, 
   {{0x73e7a025,0x3b8fe00c,0xec01400c,0xf386c011}},	//   _no__brasil_, _दू_, _संबंध__के_, _quere_, 
   {{0x51dfc014,0x3bec800c,0x00000000,0x00000000}},	//   _आयकर_, _चुकल__बा_, --, --, 
   {{0x1271201a,0x2a6b8012,0x6291a00b,0x00000000}},	//   _ei__rekkje_, _sa__musíš_, _ndwara_, --, 
   {{0x8394600b,0x9bd4800a,0x00000000,0x00000000}},	//   _cyose_, _महोबा__मिर्जापु, --, --, 
   {{0xe1c50002,0x00000000,0x00000000,0x00000000}},	//   _на__путу_, --, --, --, 
   {{0x0a71600a,0xb6576002,0x00000000,0x00000000}},	//   _करने__में_, _ваше__поштанск, --, --, 
   {{0xfc314012,0x00000000,0x00000000,0x00000000}},	// [d30] _detské_, --, --, --, 
   {{0x45cf600b,0x7bd3c006,0xed4c2002,0x00000000}},	//   _inkuru__zigezweh, _གསལ__ལག_, _бугарски_, --, 
   {{0x1b2ac003,0x00000000,0x00000000,0x00000000}},	//   _སྲིང_, --, --, --, 
   {{0x4802600b,0x4e778002,0x00000000,0x00000000}},	//   _shakisha__amashaki, _један__од_, --, --, 
   {{0x7394600b,0xaf20c027,0x00000000,0x00000000}},	//   _byose_, _osvetlen, --, --, 
   {{0x49f64018,0x00000000,0x00000000,0x00000000}},	//   _estão_, --, --, --, 
   {{0xa2fdc01d,0x2944c00f,0xd27ee01a,0x53244011}},	//   _orang__ramai_, _izimfane, _eigne_, _de__hoxe_, 
   {{0xd8bb601d,0xd288e006,0x00000000,0x00000000}},	//   _kebenara_bertulis_, _བདག__རིན_, --, --, 
   {{0x882a0028,0xf0dba014,0x846a200f,0x84a5800e}},	//   _la__aceptaci, _जहरीली_, _izithomb_zobulili_, _vybírejt_ve_, 
   {{0x92ebc011,0xc400c002,0x0e872002,0x00000000}},	//   _na__rúa_, _једне_, _службени__гласник_, --, 
   {{0xa2ebc011,0xef1aa018,0x00000000,0x00000000}},	//   _na__súa_, _mais__vendidos_, --, --, 
   {{0xd3a8c015,0x00000000,0x00000000,0x00000000}},	//   _semarang_, --, --, --, 
   {{0xf67f6015,0x44b0c009,0x17c9a011,0x52500002}},	//   _peneliti, _nogle__af_, _da__provinci, _тела_, 
   {{0x338c2002,0x00000000,0x00000000,0x00000000}},	//   _људе_, --, --, --, 
   {{0x1249000b,0x00000000,0x00000000,0x00000000}},	//   _mpamvu_, --, --, --, 
   {{0x9fe12002,0xb2ebc011,0x3188000e,0x00000000}},	//   _своје_, _na__túa_, _příspěvk_stránka_, --, 
   {{0x5f1f2012,0xa74ce00a,0x00000000,0x00000000}},	// [d40] _obmedzen, _ने__दिया_, --, --, 
   {{0x868c400c,0x00000000,0x00000000,0x00000000}},	//   _तइयार_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xcc1f000a,0x0a2a4006,0x00000000,0x00000000}},	//   _व्यापार__मनोरंजन_, _བཟོ__ནིའི_, --, --, 
   {{0xb444402c,0xf201402b,0xf2ed600c,0x00000000}},	//   _ka_, _mugihe_, _के__चीनी_, --, 
   {{0x740b401f,0x00000000,0x00000000,0x00000000}},	//   _kuala__lumpur_, --, --, --, 
   {{0xd394c00d,0x2b4b8035,0xb461a003,0x00000000}},	//   _eres_, _okuthiwa_, _བཅོས__དམིཊ_, --, 
   {{0x5ab4c018,0x00000000,0x00000000,0x00000000}},	//   _os__preços_, --, --, --, 
   {{0xf345600b,0x93c5e02a,0x00000000,0x00000000}},	//   _share__tweet_, _sist__endret_, --, --, 
   {{0x154d8012,0x2c8b400e,0x00000000,0x00000000}},	//   _prevádzk, _kuchyně_, --, --, 
   {{0xbf5e6006,0x61ba600c,0xacaba00a,0x00000000}},	//   _གང__འབྱུང_, _पहिल_, _करें__नीचे_, --, 
   {{0xecf4000a,0xaa3de00c,0x00000000,0x00000000}},	//   _भोपाल__मुम्बई_, _सभक_, --, --, 
   {{0x2444402c,0x29fe6025,0x00000000,0x00000000}},	//   _ba_, _economia_, --, --, 
   {{0xa2d86012,0x00000000,0x00000000,0x00000000}},	//   _menej_, --, --, --, 
   {{0x5291403f,0x53958018,0xa7ed600f,0x0c6a0014}},	//   _umfazi_, _passo_, _sicabang, _कबड्डी_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7607800c,0x00000000,0x00000000,0x00000000}},	// [d50] _अपेक्षित__सफलता_, --, --, --, 
   {{0xbcb5401e,0xffa18012,0x814e8037,0x6b528006}},	//   _prikaži__postove_, _priestor_, _confiabl, _ཟམ__སྨོང_, 
   {{0xe4420012,0xa24bc019,0x4a76c00a,0x00000000}},	//   _ich_, _jeg__fikk_, _संसार__खेल_, --, 
   {{0xc4b4a00e,0x00000000,0x00000000,0x00000000}},	//   _výsuvné__operační_, --, --, --, 
   {{0x9444402c,0xf27ec009,0xe8c6200b,0x00000000}},	//   _ya_, _endnu_, _abaturag, --, 
   {{0x84444004,0xe4800037,0x00000000,0x00000000}},	//   _xa_, _proporci_tu_, --, --, 
   {{0xeb9e800c,0x293b200b,0xaf3fe025,0xdb8ac002}},	//   _हाईकोर्ट__के_, _ibimenye, _joão_, _новог_, 
   {{0x12f9a00f,0x00000000,0x00000000,0x00000000}},	//   _ujehova_, --, --, --, 
   {{0x368c801c,0xc348e02c,0x00000000,0x00000000}},	//   _पंजाब_, _ingenzi_, --, --, 
   {{0xcbb46012,0xa2a66011,0x4fbe000a,0x00000000}},	//   _reagovať_, _proba_, _बरेली__बुलंदशहर_, --, 
   {{0xd4c0400f,0x00000000,0x00000000,0x00000000}},	//   _ababuyek_banganak, --, --, --, 
   {{0x34444012,0x644a6037,0x00000000,0x00000000}},	//   _sa_, _cuotas__de_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x413c6027,0x4e7f6002,0xbb8a0002,0x00000000}},	//   _predpokl, _страница__од_, _потом_, --, 
   {{0x6444400d,0x346d4024,0x158a4009,0x00000000}},	//   _va_, _novom__sadu_, _gennemfø, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xcf716012,0x142ee028,0x00000000,0x00000000}},	// [d60] _veľké_, _añadido_, --, --, 
   {{0xa32ba00b,0x00000000,0x00000000,0x00000000}},	//   _mu__buhe_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa25b0003,0x00000000,0x00000000,0x00000000}},	//   _འགྱུར__བཙན_, --, --, --, 
   {{0x0be2c003,0xa6678014,0xe341200c,0x00000000}},	//   _ཤེས__རབ_, _नोकसान_, _खबर__कहां_, --, 
   {{0x5730e00c,0x48838002,0x00000000,0x00000000}},	//   _अगर__रउरा_, _иностран, --, --, 
   {{0x4471800b,0x00000000,0x00000000,0x00000000}},	//   _buboneka__bbc_, --, --, --, 
   {{0xebfe0006,0xd23f200c,0x00000000,0x00000000}},	//   _སི__གི_, _बिलियन__डॉलर_, --, --, 
   {{0x6baa200a,0xb0746009,0x4c684015,0x1212c00e}},	//   _यह__भी_, _redaktio, _memulai_, _mnohem_, 
   {{0x6b280003,0xd81aa003,0xecc80003,0x00000000}},	//   _གཏོང_, _དྲག__གནོན_, _གཏོར_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x4606c006,0xca5fc00a,0x00000000,0x00000000}},	//   _ལར__རྒྱབ_, _परिवार__टेक_, --, --, 
   {{0x52d80034,0xc462c037,0xb3958018,0x2be8e003}},	//   _seier_, _implica__la_, _passe_, _གང__མང_, 
   {{0x1befc00c,0x00000000,0x00000000,0x00000000}},	//   _करीब__गो_, --, --, --, 
   {{0x7eac200f,0x52d5e00f,0x4e394018,0x9c4e000c}},	//   _kungani__kufanele_, _yilokho_, _esportes_, _कऽके_, 
   {{0xfbbb800a,0x814a800a,0x13efc003,0x00000000}},	//   _जल्द__से_, _मई__अप्रैल_, _བསྩལ_, --, 
   {{0x2bc0000c,0x00000000,0x00000000,0x00000000}},	// [d70] _कइसे__हो_, --, --, --, 
   {{0xc3954012,0x29e7a00e,0xef084002,0xb3f9a00b}},	//   _miesto_, _automati_ostření_, _претеће__расистич, _umwuga_, 
   {{0xc4422009,0x7dc7c002,0x00000000,0x00000000}},	//   _fck_, _би__требало_, --, --, 
   {{0x7254c00e,0xc28c6018,0x7b97a014,0x0bb8e003}},	//   _měl_, _mas__não_, _के__डर_, _ཉི__ཤུ_, 
   {{0xb4ad6009,0x922ca00b,0x00000000,0x00000000}},	//   _ind__at_, _jya__kuri_, --, --, 
   {{0x0b9e6006,0x62c7200e,0x66e92006,0x00000000}},	//   _འབྲུག__ལུ_, _rádi_, _སྤྲོད__གྲུབ_, --, 
   {{0x7a75000a,0x5e2cc002,0x6d9de003,0x00000000}},	//   _रहे__हैं_, _владе_, _ཁྱེད__ཀྱིས_, --, 
   {{0xaf982002,0x00000000,0x00000000,0x00000000}},	//   _међутим_, --, --, --, 
   {{0x8290c00f,0x00000000,0x00000000,0x00000000}},	//   _ehlane_, --, --, --, 
   {{0x53116019,0xdad64018,0xb254e003,0x5c0de002}},	//   _gule__sider_, _crianças_, _སེམས__ཀྱི_, _опширниј, 
   {{0x00114045,0x52d88013,0x7db5c003,0x00000000}},	//   _produkto, _देती_, _དབུ__བརྙེས_, --, 
   {{0xd349402a,0x84ae0012,0x00000000,0x00000000}},	//   _vet__ikke_, _správne_, --, --, 
   {{0x02b58012,0x71e6c009,0xb2318002,0x7eb8e002}},	//   _marca_, _overblik_, _песму__додај_, _ри_, 
   {{0xebbe6014,0xcff9e018,0x00000000,0x00000000}},	//   _नीति__के_, _frete__grátis_, --, --, 
   {{0x3a11e025,0x00000000,0x00000000,0x00000000}},	//   _garantia_, --, --, --, 
   {{0x7a6f400a,0xe200400e,0x0dbf600a,0x00000000}},	//   _सकती__हैं_, _kolik_, _कुशीनगर__कासगंज_, --, 
   {{0x237ea03c,0xe9f94014,0x6443200b,0x00000000}},	// [d80] _bir__izaberi_, _दुर्योधन_, _iby_, --, 
   {{0x9d4e800e,0xeac80003,0x00000000,0x00000000}},	//   _předmět_, _གཏུག_, --, --, 
   {{0x6456a011,0x22f8a002,0x00000000,0x00000000}},	//   _dispoñem_de_, _разговор, --, --, 
   {{0xebe2400a,0x00000000,0x00000000,0x00000000}},	//   _ने__इस_, --, --, --, 
   {{0x668a2021,0x2ee94002,0x1ba5a00c,0x92980003}},	//   _སྡེབ_, _кад__је_, _कि__ना_, _ཀྱི__དཀའ_, 
   {{0xb264401a,0x00000000,0x00000000,0x00000000}},	//   _truleg_, --, --, --, 
   {{0x32e9601d,0xd2558045,0x00000000,0x00000000}},	//   _sesiapa_, _problémo, --, --, 
   {{0x560fc003,0x00000000,0x00000000,0x00000000}},	//   _བསྡད_, --, --, --, 
   {{0x68204006,0x00000000,0x00000000,0x00000000}},	//   _བརྙན__སྟོན_, --, --, --, 
   {{0x426de017,0xf768800c,0xea68e00a,0x00000000}},	//   _tuto_, _के__मुस्लिम_, _जल्द__हटा_, --, 
   {{0xa3958002,0x00000000,0x00000000,0x00000000}},	//   _komentar__beograd_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x4442401d,0xcb5e600c,0x00000000,0x00000000}},	//   _mcm_, _वाली__मेहरारू_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xab8f8021,0x928f000b,0x83404009,0xfc17e002}},	//   _སྤ_, _urukiko_, _du__søger_, _правила_, 
   {{0xa177c009,0x9c57a00a,0x49d66002,0xabfd800a}},	// [d90] _uddannel, _गैजेट_, _књижевно, _दिखने__की_, 
   {{0x63e7800e,0x00000000,0x00000000,0x00000000}},	//   _této_, --, --, --, 
   {{0x4a9fc00a,0x94b28011,0xbccc600a,0x00000000}},	//   _सिनेमा__हॉट_, _por__iso_, _कॉमेंट__अपने_, --, 
   {{0x92f9800f,0x0af52015,0x92d8201a,0x3269a002}},	//   _umkhaya_, _referens, _veker_, _је__рекао_, 
   {{0x8444401e,0x00000000,0x00000000,0x00000000}},	//   _alejhi__ve_, --, --, --, 
   {{0x9bc44020,0xfa3c200e,0xfc7fa025,0x00000000}},	//   _གནང__མི_, _září_, _existem_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xe2d98015,0x407dc002,0x4f5ec00f,0xa6778002}},	//   _keren_, _програма_, _indodana__kankulun, _канцелар, 
   {{0x12842028,0x6cd94002,0x00000000,0x00000000}},	//   _archivo_, _друштвен, --, --, 
   {{0x83a9201d,0x00000000,0x00000000,0x00000000}},	//   _sebarang_, --, --, --, 
   {{0xfcd0600a,0xcee7c002,0xc2d90014,0x9bd8c00a}},	//   _चंडीगढ़__चेन्नई_, _југослав, _बेसी_, _हमीरपुर_, 
   {{0xe4b38018,0x2456400b,0x41e2000a,0x6476c018}},	//   _podem__ser_, _mushya__ba_, _कैमरा_, _junho__de_, 
   {{0x9a4bc01d,0x1768c008,0xf35ba00f,0x8a9ba00a}},	//   _diambil__daripada_, _de__actuació, _okubukek_ngayo_, _में__कहा_, 
   {{0x535be004,0x323b800e,0x00000000,0x00000000}},	//   _nangona_, _zájem_, --, --, 
   {{0x546ce00b,0x00000000,0x00000000,0x00000000}},	//   _ejo__ku_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x62c32009,0xf2d9801d,0xd2132018,0x9cdfa011}},	// [da0] _sælges_, _lesen_, _fechar_, _resposta__escribe_, 
   {{0xd27ec00d,0x02a3e006,0x928e8003,0x00000000}},	//   _viene_, _འདི__ཨིན_, _སོང__གངས_, --, 
   {{0x3464401a,0x2a07800f,0x00000000,0x00000000}},	//   _frå__på_, _ukubukwa_, --, --, 
   {{0xb27ec00d,0x26e7a00a,0x00000000,0x00000000}},	//   _tiene_, _है__जबकि_, --, --, 
   {{0xebae000c,0x00000000,0x00000000,0x00000000}},	//   _सब्सिडी__के_, --, --, --, 
   {{0x0b302002,0x9446a00e,0x724e4003,0x00000000}},	//   _него_, _klasické__klávesni, _ལྕེ_, --, 
   {{0xf435c024,0xe0e8e009,0x86f9600a,0x00000000}},	//   _veličinu__slova_, _oprindel, _देना_, --, 
   {{0xb3f46004,0xf4738009,0x00000000,0x00000000}},	//   _ukutya_, _nogen__der_, --, --, 
   {{0x9a234018,0x5253000f,0x00000000,0x00000000}},	//   _que__você_, _unkulunk_wathi_, --, --, 
   {{0x92428006,0x52dde00d,0xb1416014,0x00000000}},	//   _བཙག_, _el__tema_, _बाबूजी_, --, 
   {{0x12e12012,0x8b4d6021,0xf2ea600f,0x00000000}},	//   _nahlásiť__chybu_, _ཁང__བཞེངས_, _futhi__kumelwe_, --, 
   {{0x6c49c022,0x1bc3601c,0x00000000,0x00000000}},	//   _माथे_, _करो_, --, --, 
   {{0x4f070012,0x5dc86003,0x00000000,0x00000000}},	//   _dispozíc, _ཞོག__བསྟོད_, --, --, 
   {{0x23db602c,0xe493200b,0xf799400a,0x00000000}},	//   _ya__mbere_, _ko__ari_, _कौशांबी__गाजियाबा, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x20432002,0x00000000,0x00000000,0x00000000}},	//   _на__своју_, --, --, --, 
   {{0x4236600f,0xac55e009,0x32152002,0x00000000}},	// [db0] _manje_, _modtage_, _се__свиђа_, --, 
   {{0x326d000b,0xf27f600e,0x34396009,0x98e2c002}},	//   _wabona_, _hodně_, _en__rigtig_, _могуће_, 
   {{0xb2ca6006,0x00000000,0x00000000,0x00000000}},	//   _དབང__རྣམ_, --, --, --, 
   {{0x524d803a,0x746d4037,0x17c54002,0x0d8cc003}},	//   _སོང_, _email__si_, _има__право_, _སྒྲོལ_, 
   {{0x03f9a01d,0xca7c400c,0x00000000,0x00000000}},	//   _jepun_, _कालीन__भोज_, --, --, 
   {{0x0bf7600a,0x2a55800f,0x04d1a00a,0x00000000}},	//   _में__है_, _ukwesaba_, _प्रतापगढ, --, 
   {{0x65054018,0x7b920003,0x1d1fa003,0xce2cc002}},	//   _enquanto_, _གཙུག__ལག_, _ཀྱི__སྐོར_, _млади_, 
   {{0x9444c01d,0xb3c86009,0x425ca018,0x2d372002}},	//   _hb__pukul_, _farver_, _da__minha_, _за__српски_, 
   {{0xf236c012,0x4bdd400c,0x3e45c00b,0x00000000}},	//   _svojho_, _के__तरे_, _bagaraga, --, 
   {{0x6468e012,0x2256e00c,0xaee9e013,0x00000000}},	//   _ale__aj_, _मानेला_, _बाइक_, --, 
   {{0xf2bb8024,0x644ce011,0xd344a00b,0x84704002}},	//   _nedelje_, _páxina__de_, _murenge_, _помозите__побољшањ, 
   {{0x02e3400e,0x00000000,0x00000000,0x00000000}},	//   _prvním_, --, --, --, 
   {{0x3a4b800a,0x92506017,0x00000000,0x00000000}},	//   _की__मदद_, _bílá_, --, --, 
   {{0xc2978024,0x3316600b,0xf451e002,0xeb0fe00d}},	//   _na__veoma_, _hanze_, _kuću__din_, _las__siguient, 
   {{0x2236600f,0xd4ace00d,0x32e1c00f,0x00000000}},	//   _kanje_, _con__su_, _isikhath_esiningi_, --, 
   {{0xf9e6000f,0xc2904003,0x00000000,0x00000000}},	//   _kungenze, _བོད__པའི_, --, --, 
   {{0xd681600a,0xae45c00b,0x00000000,0x00000000}},	// [dc0] _खिलाफ_, _yagaraga, --, --, 
   {{0x2e85a037,0x624da003,0x00000000,0x00000000}},	//   _si__hablaras_, _ཧོང_, --, --, 
   {{0xb38f800b,0x00000000,0x00000000,0x00000000}},	//   _ishyaka_, --, --, --, 
   {{0xdaab200e,0xe2f5001a,0x00000000,0x00000000}},	//   _množství_, _siter__denne_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xb40e4011,0x7478c00b,0x00000000,0x00000000}},	//   _ensinanz, _umukuru__wa_, --, --, 
   {{0xd2538003,0xe4a2000b,0x00000000,0x00000000}},	//   _ཡོད__ཀྱང_, _akaba__ari_, --, --, 
   {{0xa2a52003,0x00000000,0x00000000,0x00000000}},	//   _མང__ཞིག_, --, --, --, 
   {{0x92a6c012,0x32646045,0xf2da601a,0x145f4012}},	//   _treba_, _poslal_, _skreiv_, _členom__od_, 
   {{0xbc37a017,0x02b4800b,0xd290c012,0x54dfa00a}},	//   _české_, _vyacu_, _sklade_, _व्यंजन__नायिका_, 
   {{0x9303401a,0xd294a003,0x00000000,0x00000000}},	//   _kva__skjer_, _འགྲོ__བའི_, --, --, 
   {{0x12ffc02a,0x3e99800b,0x9c01a00c,0x1b2a8003}},	//   _denne__siden_, _byatumye_, _जाई__कि_, _ལྡོང_, 
   {{0x0214a00a,0x00000000,0x00000000,0x00000000}},	//   _सी__चैनल_, --, --, --, 
   {{0x41458002,0x00000000,0x00000000,0x00000000}},	//   _фејсбуку_, --, --, --, 
   {{0xc599400a,0x0288e039,0xa2cf600b,0x00000000}},	//   _सेहत_, _melayani_, _amafoto__gutora_, --, 
   {{0x0228a019,0x23fca01a,0x2c486002,0x00000000}},	// [dd0] _søke_, _det__finst_, _функцион, --, 
   {{0xa7cb4038,0x00000000,0x00000000,0x00000000}},	//   _de__subvenci, --, --, --, 
   {{0xbcb7a00a,0x00000000,0x00000000,0x00000000}},	//   _में__अपने_, --, --, --, 
   {{0x5473400e,0x00000000,0x00000000,0x00000000}},	//   _pro__psy_, --, --, --, 
   {{0x881ac003,0xc29b4006,0x62ada00f,0x00000000}},	//   _འདྲི_, _འཕེལ__གཏང_, _futhi__ngani_, --, 
   {{0x127b4012,0x6da08029,0x00000000,0x00000000}},	//   _komentár, _བསྟེན_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa0630002,0x00000000,0x00000000,0x00000000}},	//   _готово_, --, --, --, 
   {{0x949fa018,0x0bf2e00a,0x00000000,0x00000000}},	//   _cartão__ou_, _जम्मू__और_, --, --, 
   {{0x32a58011,0x5b4fc015,0x620c8018,0x6278a00e}},	//   _de__xullo_, _pencaria_silahkan_, _adicioná_, _telefony__nokia_, 
   {{0x4d0ac002,0x73948007,0x6b8f800a,0x00000000}},	//   _učlanjen_, _asas_, _बाद__भी_, --, 
   {{0x033ca00f,0xe488c009,0x00000000,0x00000000}},	//   _isikhath_eside_, _finder__du_, --, --, 
   {{0x12ac6025,0x29d32002,0xd2b8600e,0x00000000}},	//   _de__são_, _писања__коментар, _přesto_, --, 
   {{0x32bec018,0x00000000,0x00000000,0x00000000}},	//   _que__seja_, --, --, --, 
   {{0x927b4018,0xe470a00b,0xd46de011,0x8b2a8003}},	//   _comentár, _adakoran_na_, _dicir__que_, _རྡུང_, 
   {{0xf2004035,0xd2cae012,0x36950012,0x432ba00b}},	//   _leli_, _pridal_, _oddeleni, _mu__bihe_, 
   {{0x82ac200d,0x00000000,0x00000000,0x00000000}},	// [de0] _lo__cual_, --, --, --, 
   {{0x05f6a00e,0x00000000,0x00000000,0x00000000}},	//   _se__nacházít, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x72d86015,0x22e2a018,0x12a3e003,0x00000000}},	//   _bener_, _ir__para_, _གྲུ__ཆུང_, --, 
   {{0x932ba02c,0xf1ea8003,0x54b1200f,0x00000000}},	//   _mu__gihe_, _ལྡུམ_, _ngaphamb_nje_, --, 
   {{0xa301001d,0x2eee6002,0xe28ac00f,0x00000000}},	//   _telah__berada_, _је__до_, _kujehova__futhi_, --, 
   {{0x2f376002,0x829cc002,0xd4c6c00a,0x0385800f}},	//   _од__до_, _preporuč_odgovori_, _त्योहार__धर्म_, _ukuba__senze_, 
   {{0x92d8600d,0x9ba4c021,0x32b6000f,0x00000000}},	//   _tener_, _ཟེར__མི_, _kuba__khona_, --, 
   {{0xec050014,0x6ece2002,0xeb9d400c,0x00000000}},	//   _सोच__के_, _грчки_, _हरवला__के_, --, 
   {{0x314e400e,0x00000000,0x00000000,0x00000000}},	//   _dlouhodo, --, --, --, 
   {{0x6340e018,0xc303a00b,0x344e8012,0xca37800a}},	//   _cabeça_, _kwa__kane_, _eú_, _मेरठ__रांची_, 
   {{0x721c0010,0xa253a003,0x143c8002,0x00000000}},	//   _århus_, _ཡིག__འདི_, _домаћинс, --, 
   {{0x52d98024,0xf3ff602b,0xedc68003,0x4bd0c003}},	//   _mesec_, _ubuzima_, _འབད__བརྩོན_, _དགུང__ལོ_, 
   {{0x3c890002,0x00000000,0x00000000,0x00000000}},	//   _различит, --, --, --, 
   {{0xb2988003,0x5b8e6003,0x00000000,0x00000000}},	//   _པའི__བཀའ_, _ཇེ_, --, --, 
   {{0xe29da020,0x2094600e,0x23a28031,0x00000000}},	//   _འཚོལ__ཞིབ_, _nabízí_, _ucap_, --, 
   {{0x2c01a00c,0xcd2fa00b,0x05bb4003,0x00000000}},	// [df0] _कवनो__एगो_, _rurafunz_ibiteker, _ལུཌ__བཙུཌ_, --, 
   {{0x2681e00a,0x00000000,0x00000000,0x00000000}},	//   _चौपाल_, --, --, --, 
   {{0xb8e84002,0x00000000,0x00000000,0x00000000}},	//   _предузећ, --, --, --, 
   {{0xccc76018,0x44e7a00c,0x4f64e00f,0x00000000}},	//   _ruim__título_, _भारत__अफगानिस्, _emehlwen_kankulun, --, 
   {{0x64b6e015,0x83a2c011,0x00000000,0x00000000}},	//   _mengomen_isi_, _atopar_, --, --, 
   {{0xbf584006,0xc2856004,0x00000000,0x00000000}},	//   _ཕྱུག__འབྲུག_, _kathixo_, --, --, 
   {{0x144e8012,0xb3f9e01d,0x5b628002,0x00000000}},	//   _sú_, _petua_, _медицинс, --, 
   {{0x7bde000c,0x7599e012,0x00000000,0x00000000}},	//   _ओह__घरी_, _prihláse_registrá, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xc2904003,0xa3ea000b,0x00000000,0x00000000}},	//   _མེད__པའི_, _imiti_, --, --, 
   {{0xd2c2e01a,0x04802018,0x00000000,0x00000000}},	//   _det__gjeld_, _edição__por_, --, --, 
   {{0x8f06a012,0x244e800d,0x00000000,0x00000000}},	//   _súvisiac, _tú_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xb313001a,0xf29e6006,0x647a0025,0x36f6000c}},	//   _skal__vere_, _ཨིན__རུང_, _necessid_de_, _परमारवंश, 
   {{0x34ac801a,0x1927c00c,0x00000000,0x00000000}},	//   _med__eit_, _के__वंशज_, --, --, 
   {{0xb200401d,0xee934002,0xc7762003,0x00000000}},	//   _polis_, _сам__да_, _རེངས__བརྙན_, --, 
   {{0xe8442002,0xef50800f,0x00000000,0x00000000}},	// [e00] _ипак_, _esivela__kunkulun, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2259c006,0x342b600f,0x3b2aa002,0x00000000}},	//   _གདོང__ཤོག_, _injabulo_, _миланско, --, 
   {{0xeddce006,0xce0ec01d,0x00000000,0x00000000}},	//   _ལུ__འབྲེལ_, _terengga, --, --, 
   {{0x0b59600c,0x00000000,0x00000000,0x00000000}},	//   _देशन_, --, --, --, 
   {{0x78792002,0x00000000,0x00000000,0x00000000}},	//   _детаље_, --, --, --, 
   {{0x50b54002,0xe2922003,0x0f4b0002,0x00000000}},	//   _до__године_, _སྐལ__བཟང_, _енглески__фински_, --, 
   {{0x6c3a8037,0xe4866009,0x3224c00e,0x00000000}},	//   _tu__comentar, _genvej__til_, _velkou_, --, 
   {{0x2e226013,0x00000000,0x00000000,0x00000000}},	//   _इंदौर_, --, --, --, 
   {{0x72006002,0x5ba1602c,0x6758200c,0x00000000}},	//   _ceni_, _bishobor, _क्षेत्री_भासा_, --, 
   {{0x6b8e603a,0x8f67400b,0xd9e2e00b,0x7d7ee002}},	//   _ཉེ_, _yawe__adakoran, _buboneka_, _му_, 
   {{0xeef12002,0x7c0c600c,0x00000000,0x00000000}},	//   _име_, _बाकिर__अब_, --, --, 
   {{0x29456037,0xf476c002,0x00000000,0x00000000}},	//   _alquiler_, _мултимед, --, --, 
   {{0x835e6015,0x00000000,0x00000000,0x00000000}},	//   _pengikut__lainnya_, --, --, --, 
   {{0xc200a015,0x02640015,0xbeda6011,0x34ac001a}},	//   _mobil_, _berarti__bagi_, _veciños_, _det__eit_, 
   {{0xec07600c,0xf292a009,0x00000000,0x00000000}},	//   _सीमा__के_, _eniro__krak_, --, --, 
   {{0x3bcc600a,0x13ac600f,0x00000000,0x00000000}},	// [e10] _इसी_, _ikuphi_, --, --, 
   {{0xebc4a003,0x00000000,0x00000000,0x00000000}},	//   _གནང__གི_, --, --, --, 
   {{0xeeba601a,0x00000000,0x00000000,0x00000000}},	//   _sjølv_, --, --, --, 
   {{0xf40c4012,0x62572014,0xee9a000a,0x00000000}},	//   _aktuálne_, _विवेकी_, _विकिपीडि_मुक्त_, --, 
   {{0x94bee00b,0xbd2c8016,0x10f0c00f,0x00000000}},	//   _mashyash_ya_, _utviklet_, _izwi__likajeho, --, 
   {{0x224de021,0x8491e02f,0x00000000,0x00000000}},	//   _ཤོག_, _voltar__ao_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x73eb8011,0x0d25400b,0x42a6c006,0x00000000}},	//   _editar__fonte_, _mwungere_, _ཤིས__འོས_, --, 
   {{0xc2684025,0xe46c6009,0xd38fa00f,0x00000000}},	//   _produção_, _mig__til_, _eyishumi_, --, 
   {{0x0ea14002,0x3205a00e,0xf2b48012,0x00000000}},	//   _одељење__за_, _všichni_, _sekcie_, --, 
   {{0x246e201a,0x1d202003,0x00000000,0x00000000}},	//   _skattar__og_, _པའི__སྐོར_, --, --, 
   {{0x7a066012,0x00000000,0x00000000,0x00000000}},	//   _stiahnut, --, --, --, 
   {{0xbbf9e006,0x1297e01d,0x4bcc600a,0x00000000}},	//   _མི__ཚུ_, _kekal__dilog_, _उसी_, --, 
   {{0xabe4c00a,0x70af400f,0x00000000,0x00000000}},	//   _है__इसे_, _usuku__lukajeho, --, --, 
   {{0xb79ac003,0x0ef00002,0x00000000,0x00000000}},	//   _འདོན_, _здраво__нов_, --, --, 
   {{0x89e8600e,0x64448006,0xc1b7c002,0x00000000}},	//   _samozřej, _རའི__རྒྱལ_, _николић_, --, 
   {{0xd9e2e00b,0xe4ba000b,0x28cf2002,0x00000000}},	// [e20] _ruboneka_, _ibikorwa__by_, _одржана_, --, 
   {{0xa200c00e,0x1ea10002,0x00000000,0x00000000}},	//   _hodin_, _жао__нам_, --, --, 
   {{0xe2c32009,0x28916018,0xfab4200c,0x32ea400f}},	//   _fælles_, _de__qualidad, _ठोस__कदम_, _izinto__ezinhle_, 
   {{0x5492a00b,0x624f000f,0xdc76e00c,0x5bf04003}},	//   _na__css_, _ka__amakhasi_, _माल्ला_, _ཐད__ཀར_, 
   {{0xe3aea002,0xb2990003,0x00000000,0x00000000}},	//   _не__буде_, _བའི__བཀའ_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x926ba00b,0x00000000,0x00000000,0x00000000}},	//   _ibiri__kuri_, --, --, --, 
   {{0x14ace028,0x00000000,0x00000000,0x00000000}},	//   _con__mi_, --, --, --, 
   {{0xd320a012,0xbe5d6018,0x00000000,0x00000000}},	//   _keby_, _desculpe_, --, --, 
   {{0xc273c030,0x00000000,0x00000000,0x00000000}},	//   _slavo__kukić_, --, --, --, 
   {{0xf26ce00f,0xaf884012,0xe28e600f,0x00000000}},	//   _nanoma_, _agentúra_, _kankulun_futhi_, --, 
   {{0xabcc601c,0x2175e018,0x42984002,0x00000000}},	//   _इसे_, _notícia_, _због__чега_, --, 
   {{0x2a6c800e,0x5f53c002,0x00000000,0x00000000}},	//   _se__musíš_, _додатни_, --, --, 
   {{0x7bd54003,0x2e19c002,0x00000000,0x00000000}},	//   _བཀའ__ཤག_, _дневник_, --, --, 
   {{0xebbd200c,0x00000000,0x00000000,0x00000000}},	//   _ओकरे__के_, --, --, --, 
   {{0xcd88203a,0xbcc82003,0x00000000,0x00000000}},	//   _གཞིས_, _གཞིར_, --, --, 
   {{0x93974009,0x55d10012,0x00000000,0x00000000}},	// [e30] _samarbej, _nemôžete_, --, --, 
   {{0x882a8006,0x47622002,0x00000000,0x00000000}},	//   _མེད__སེངྒེ_, _став_, --, --, 
   {{0x12334004,0x04be600e,0x00000000,0x00000000}},	//   _ibhayibh_ithi_, _této__stránce_, --, --, 
   {{0x73032005,0x6bb58013,0x00000000,0x00000000}},	//   _siste__åra_, _कुछ__भी_, --, --, 
   {{0x02ed6007,0xf4ab801a,0x130e4018,0x6336e00a}},	//   _perkara__perkara_, _har__òg_, _jogador_, _स्ट्रिक्_राखी_, 
   {{0x6a95000b,0x4967600b,0x6627600b,0x00000000}},	//   _aho__ubufasha_, _minisite, _minisiti, --, 
   {{0xebdfa00c,0x4a63a002,0x00000000,0x00000000}},	//   _पी__के_, _за__слање_, --, --, 
   {{0xbbcc600a,0x00000000,0x00000000,0x00000000}},	//   _उसे_, --, --, --, 
   {{0x932a602e,0x8e296002,0x00000000,0x00000000}},	//   _vidi__profil_, _рат_, --, --, 
   {{0x02364015,0xa31e801f,0x172ee00c,0x00000000}},	//   _namja_, _pelajar__yang_, _कोना__कोना_, --, 
   {{0xc46fe019,0x14e2200a,0x00000000,0x00000000}},	//   _noe__av_, _औरैया_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x4e60e002,0x7b954006,0x4342a018,0x6c6ba015}},	//   _од_, _དོན__ལག_, _fazendo_, _setiap__masukan_, 
   {{0x2f8be012,0xf596c002,0x00000000,0x00000000}},	//   _aké_, _имамо_, --, --, 
   {{0x3855e006,0x00000000,0x00000000,0x00000000}},	//   _བརྒྱུད__འཕྲིན_, --, --, --, 
   {{0xf201e009,0xc2a1c00a,0x00000000,0x00000000}},	//   _altid_, _बिलासपुर_, --, --, 
   {{0xd2940003,0x00000000,0x00000000,0x00000000}},	// [e40] _འོན__ཀྱང_, --, --, --, 
   {{0xfc67200f,0x7e79e002,0x00000000,0x00000000}},	//   _nomuzwa_, _бисте__се_, --, --, 
   {{0x1e292002,0x5aba0024,0xe280000f,0x00000000}},	//   _као_, _proverit, _ngendoda_yakhe_, --, 
   {{0x7bee2002,0x8dce2002,0x00000000,0x00000000}},	//   _тамо_, _тиме_, --, --, 
   {{0x3c05a00c,0x00000000,0x00000000,0x00000000}},	//   _कारण__बा_, --, --, --, 
   {{0x83002016,0x7af74012,0x9278400b,0x4724600c}},	//   _ansvar__innhold_, _verejnos, _utangaza__kuri_, _आवे__वाला_, 
   {{0xff7be002,0x00000000,0x00000000,0x00000000}},	//   _се__других_, --, --, --, 
   {{0x7457001f,0xd32d001a,0xa94a2002,0x1269400c}},	//   _kenal__minta_, _som__ligg_, _светог_, _कऽ__दीहलस_, 
   {{0x3472000b,0x2f6cc00c,0x00000000,0x00000000}},	//   _ku__rupapuro_, _विद्वान__लेखक_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xd476c01b,0xfa5b400c,0x00000000,0x00000000}},	//   _wathi__ke_, _कऽ__पाई_, --, --, 
   {{0xced60045,0x3223200c,0x00000000,0x00000000}},	//   _možno_, _रामजी__चौधरी_, --, --, 
   {{0xa331601d,0xe320c012,0xeba3c00c,0x4933000c}},	//   _kerosaka_yang_, _kedy_, _दरभंगा__के_, _के__एहिजा_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x23b9c015,0x9bd8e00c,0x00000000,0x00000000}},	//   _berbagi__simpan_, _हिस्__सा_, --, --, 
   {{0xebf0800a,0xd4b3e018,0x00000000,0x00000000}},	//   _खोजने__के_, _esqueceu__sua_, --, --, 
   {{0x4200a012,0x726d8010,0x57ed600f,0x00000000}},	// [e50] _veci_, _sprog_, _bacabang, --, 
   {{0xab996006,0x00000000,0x00000000,0x00000000}},	//   _དྲན__ཆས_, --, --, --, 
   {{0xe290c01e,0x66574012,0xf7644002,0x00000000}},	//   _allaha_, _súčasnos, _пратиоца__покреће_, --, 
   {{0x62d5e00f,0x2ac70017,0x00000000,0x00000000}},	//   _nalokho_, _menší_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xcadc6028,0xe3a58018,0x422ac002,0x00000000}},	//   _imágenes_, _quanto__mais_, _новац_, --, 
   {{0xe236201a,0x94ace005,0x32f6c018,0x2bee0002}},	//   _mykje_, _med__ei_, _não__pode_, _лако_, 
   {{0x59f9402a,0xd27e801f,0x526dc003,0x00000000}},	//   _upassend, _ngan_, _དང__ཤེས_, --, 
   {{0x5e13c024,0xeb97e014,0x5146000a,0x7259a003}},	//   _vučić_, _शराब__के_, _पर__लाइव_, _གསུང__ཆོས_, 
   {{0x027e8015,0xa2dea011,0xe31dc00f,0x0ef10002}},	//   _agan_, _as__nosas_, _kubalule_ukuba_, _гмо_, 
   {{0xbbba6006,0x5b300002,0x50b4a002,0x00000000}},	//   _དེ__ཚུ_, _ћемо_, _прошле__године_, --, 
   {{0x06a6e01c,0x8324e012,0xedff8003,0x00000000}},	//   _गिरफ्तार_, _ak__chceš_, _ངོས__འབྲེལ_, --, 
   {{0x0e28e002,0x944f0025,0x34ac801a,0x829e8003}},	//   _за_, _há_, _har__eit_, _གང__ཐུབ_, 
   {{0x32488012,0x41ea0002,0x00000000,0x00000000}},	//   _takmer_, _милошеви, --, --, 
   {{0xb44f0018,0xa443e01b,0xe4428007,0xaf0c8003}},	//   _já_, _obu_, _sesuai__untuk_, _རྒྱུར_, 
   {{0x224e4020,0xa2c7400e,0x8cf4a003,0x00000000}},	//   _འོང_, _týden_, _དུ__གྱུར_, --, 
   {{0xd44f0018,0xbf244012,0x5aff6009,0x529ac00f}},	// [e60] _lá_, _práve_, _overveje, _yomhlaba__wonke_, 
   {{0x7b5f2002,0x8495c00c,0xeb59c00c,0x00000000}},	//   _историја_, _के__तिवारी_, _भइलन_, --, 
   {{0x82fb8009,0x9342c011,0x00000000,0x00000000}},	//   _geografi_sted_, _facendo_, --, --, 
   {{0xc2d9801d,0xbceaa013,0x00000000,0x00000000}},	//   _mesej_, _सितम्बर_, --, --, 
   {{0x73f40015,0x529e6003,0x00000000,0x00000000}},	//   _justru_, _བརླག__སོང_, --, --, 
   {{0x230f601d,0x81c92002,0x00000000,0x00000000}},	//   _dipapar_, _пошта_, --, --, 
   {{0x224be011,0x94ac6005,0x33c96018,0x00000000}},	//   _de__galiza_, _det__ei_, _nada__consta_, --, 
   {{0x32ad2003,0x024c4003,0xd6752006,0x6679c00a}},	//   _བང__ཆེན_, _ཅིང_, _འབད__དགོཔ_, _बेहद_, 
   {{0x7320c00e,0xd31a2028,0x00000000,0x00000000}},	//   _tedy_, _este__anuncio_, --, --, 
   {{0xf9a36012,0x00000000,0x00000000,0x00000000}},	//   _kuchyňa_, --, --, --, 
   {{0x0f220030,0x81eb6006,0x00000000,0x00000000}},	//   _obavezno__navođenj, _ཨིནམ_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xe8a0a00c,0x00000000,0x00000000,0x00000000}},	//   _अन्तर्रा_मातृभाषा_, --, --, --, 
   {{0x324e4003,0xb79a2029,0x31216012,0x52da200e}},	//   _ཡོང_, _སྨོན_, _štvrtok_, _kč__cena_, 
   {{0x12d5e00f,0x8296800f,0x005a600c,0x00000000}},	//   _yalokho_, _kwazo__zonke_, _ना__बलुक_, --, 
   {{0x9277c00b,0x00000000,0x00000000,0x00000000}},	//   _kiratang_kuri_, --, --, --, 
   {{0xcf904018,0x8b8ee006,0x9d06a00c,0x00000000}},	// [e70] _grátis_, _ཎེ_, _के__नामकरण_, --, 
   {{0x649a4011,0x1d054003,0xc29dc020,0x17218012}},	//   _máis__de_, _ངོ__རྒོལ_, _གིས__འབད_, _niekoľko_, 
   {{0x9333200a,0x00000000,0x00000000,0x00000000}},	//   _ने__अपनी_, --, --, --, 
   {{0xe493e01a,0x00000000,0x00000000,0x00000000}},	//   _ho__er_, --, --, --, 
   {{0x12918024,0xc2660037,0x00000000,0x00000000}},	//   _evra_, _palabras__abajo_, --, --, 
   {{0x32d98033,0x144f0017,0x00000000,0x00000000}},	//   _cerek_, _pá_, --, --, 
   {{0xa264601a,0x22d90018,0x00000000,0x00000000}},	//   _skulen_, _vezes_, --, --, 
   {{0x8f35000d,0x0443e02b,0x4395e039,0x00000000}},	//   _reportar_, _ubu_, _trus_, --, 
   {{0x22c42038,0x5395e01d,0x83f9801d,0x1bd0e011}},	//   _uso__para_, _urus_, _teruk_, _compañei, 
   {{0x544f0018,0x00000000,0x00000000,0x00000000}},	//   _tá_, --, --, --, 
   {{0xc27ee009,0x00000000,0x00000000,0x00000000}},	//   _kvinde_, --, --, --, 
   {{0xabe1a006,0x6c1b2008,0x324e6003,0xe3762013}},	//   _གཟུགས__ཕབ_, _últimos__comentar, _རོང_, _राखी__सावंत_, 
   {{0x0471c008,0xaaf7e00f,0x534c8018,0x00000000}},	//   _fornecid_por_, _zonke__izinhlob, _na__imagem_, --, 
   {{0xee60e002,0x00000000,0x00000000,0x00000000}},	//   _или__да_, --, --, --, 
   {{0xa2428029,0x3dda4016,0x83a24003,0xaa418011}},	//   _བཙན_, _brukerna, _འགྲེམས_, _de__verán_, 
   {{0xfe296002,0xfc7a800a,0x00000000,0x00000000}},	//   _вас_, _अन्य__खबरें_, --, --, 
   {{0x2466600b,0x00000000,0x00000000,0x00000000}},	// [e80] _bbc__ko_, --, --, --, 
   {{0x215c600e,0xa456e01a,0x00000000,0x00000000}},	//   _speciáln, _frå__dei_, --, --, 
   {{0x927c6009,0x10f94011,0x24994009,0x00000000}},	//   _forskell, _proxecto, _børn__og_, --, 
   {{0x824de006,0x8baf0002,0x00000000,0x00000000}},	//   _ཤོམ_, _адреса_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x22c9e00e,0x0480a00a,0x00000000,0x00000000}},	//   _nakonec_, _भाषाओं_, --, --, 
   {{0x8b8d601c,0x4e86e002,0x424d8003,0x00000000}},	//   _का_, _се__не_, _སོན_, --, 
   {{0x03ee801a,0xa387e039,0x846a6012,0xe31fc025}},	//   _ein__stor_, _putri_, _cas__sk_, _situação_, 
   {{0x400ac00e,0x2fb4000e,0x321c600b,0x3b8e400c}},	//   _několik_, _říjen_, _bishwe_, _बात__बा_, 
   {{0x653e4022,0x0248000b,0x1bd98003,0x00000000}},	//   _के__करीब_, _irimo_, _བོད__ནས_, --, 
   {{0x3ea3a002,0x00000000,0x00000000,0x00000000}},	//   _притисни_на_, --, --, --, 
   {{0x5988600b,0x00000000,0x00000000,0x00000000}},	//   _ibiherut, --, --, --, 
   {{0xb2584003,0x96598037,0xf40a400f,0x79ea6012}},	//   _གློག__ཀླད_, _otras__categorí, _izinhliz, _poľovníc, 
   {{0x5f1a6021,0xb46e6009,0x6d7ee002,0x54bc600c}},	//   _དཔེ__སྐྲུན_, _mig__at_, _ју_, _उभरत__आर्थिक_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6e6de010,0xb2a0400b,0xb457c018,0x4b4ca00c}},	//   _københav, _gahuza__amakuru_, _chegada__em_, _दरभंगा__मधुबनी_, 
   {{0x82d9c018,0x448cc012,0x00000000,0x00000000}},	// [e90] _devem_, _otázka__nie_, --, --, 
   {{0x82588006,0x075a6022,0x3273a01a,0x7ed16002}},	//   _བཤུས__དབང_, _पाक्षिक_, _vidaregå_skule_, _надам__се_, 
   {{0xb316e004,0xbcc6600c,0x00000000,0x00000000}},	//   _ilizwe_, _साथे__साथे_, --, --, 
   {{0x154f400f,0x00000000,0x00000000,0x00000000}},	//   _umshumay, --, --, --, 
   {{0xb4a68044,0x5628000f,0xcecf600e,0x6249a003}},	//   _स्वास्थ्, _eningizi, _sociální, _ཡིག__གསར_, 
   {{0x93736011,0x00000000,0x00000000,0x00000000}},	//   _sistema__espazos_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x54d7404c,0x00000000,0x00000000,0x00000000}},	//   _मामिला_, --, --, --, 
   {{0xa27ec009,0x7ed66012,0x64b9e011,0x00000000}},	//   _igen_, _koľko_, _ensinanz_de_, --, 
   {{0x9969c034,0xc50f600c,0x00000000,0x00000000}},	//   _mest__kommente, _आभासी__दुनिया_, --, --, 
   {{0x144f4019,0x7201000e,0xbcfe0009,0xa3a9e025}},	//   _nå_, _mezi_, _flexbloc_flexbloc, _segunda__feira_, 
   {{0x6201000f,0x42500009,0x23e70009,0x5292400e}},	//   _lezi_, _at__skrive_, _at__læse_, _vltava_, 
   {{0x8eb8e002,0x3f43c009,0x00000000,0x00000000}},	//   _си_, _børnene_, --, --, 
   {{0xa996400e,0x5394c004,0xe2698006,0x28390002}},	//   _může_, _uyesu_, _སྒྲུབ__སྡེ_, _последња_, 
   {{0x96590031,0x46f9e01c,0x1460e01a,0xd4d9e00a}},	//   _di__indonesi, _मेरा_, _samband__med_, _मेरठ_, 
   {{0x744f401a,0x48a9e018,0x02a6000f,0x11c3c002}},	//   _då_, _ótimo__estrelas_, _uma__umuntu_, _помоћи_, 
   {{0x4ef2600f,0x828d0016,0x839b4011,0x00000000}},	// [ea0] _kankulun, _blir__kontroll, _réxime_, --, 
   {{0xf3f40009,0x23f46018,0x00000000,0x00000000}},	//   _udstyr_, _listum_, --, --, 
   {{0xa4444004,0x547d4009,0xd4ad6018,0x6257e003}},	//   _ib_, _mere__om_, _diz__que_, _གློག__ཞགས_, 
   {{0x9444401d,0x5d37800b,0x8996400e,0x00000000}},	//   _hb_, _umupatir, _kůže_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7ee86002,0x0325a01a,0x42a06012,0x00000000}},	//   _где__се_, _ha__vore_, _hodnotiť__firmu_, --, 
   {{0xec0aa022,0x64b84011,0x62a68009,0xc3efc003}},	//   _राज्य__के_, _xeral__de_, _skabe_, _བསྔལ_, 
   {{0x62fd2008,0x4442000b,0x23940018,0x00000000}},	//   _aplicar_, _ndi_, _avise_, --, 
   {{0x12b3e00e,0x00000000,0x00000000,0x00000000}},	//   _že__jsem_, --, --, --, 
   {{0x09f9c009,0x9200201d,0x1cf00003,0xed80e002}},	//   _opdatere, _enjin_, _གློད__གྲོལ_, _бошњачки__бугарски_, 
   {{0xd26de028,0x00000000,0x00000000,0x00000000}},	//   _estoy_, --, --, --, 
   {{0x42fce019,0xd47d6007,0xfe72001c,0x00000000}},	//   _gangen_, _seseoran_itu_, _वित्त_, --, 
   {{0x57b6401d,0x3cdb6012,0x62a10003,0x00000000}},	//   _seseteng, _od__príspevk, _བྱོལ__གསར_, --, 
   {{0x26b5202e,0x1b9a6003,0x00000000,0x00000000}},	//   _milanovi, _ཉེར__ལྔ_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x64444004,0x7a0c8002,0x4a72c00a,0x00000000}},	//   _eb_, _од__којих_, _वाराणसी__संत_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [eb0] --, --, --, --, 
   {{0x03eae011,0x2ba8c00a,0x00000000,0x00000000}},	//   _moitas_, _कर__दी_, --, --, 
   {{0xe44f4037,0xefe9000c,0xcf122012,0x00000000}},	//   _usando__tu_, _मोताबिक_, _rýchlosť_, --, 
   {{0x64b6c02f,0x00000000,0x00000000,0x00000000}},	//   _dias__de_, --, --, --, 
   {{0x94ace005,0x0a66201d,0x0bc0600a,0x00000000}},	//   _har__ei_, _bertangg_terhadap_, _बच्चों__को_, --, 
   {{0xe2f2800f,0x00000000,0x00000000,0x00000000}},	//   _ukuze__ubone_, --, --, --, 
   {{0xbcb1c00e,0x231b2009,0xe4446005,0x00000000}},	//   _na__heurece_, _denne__artikel_, _viss__du_, --, 
   {{0x22d5000e,0x627ec009,0x42666003,0xebe06003}},	//   _vše_, _ugen_, _སྲིང__འགན_, _སྐུ__ཡི_, 
   {{0x08dac00b,0x77790012,0x00000000,0x00000000}},	//   _imiryang, _užitočné__neužitoč, --, --, 
   {{0xc29b000f,0x00000000,0x00000000,0x00000000}},	//   _umbhalo__waphansi_, --, --, --, 
   {{0xe46de02a,0x33d4001a,0x00000000,0x00000000}},	//   _hva__du_, _eg__trur_, --, --, 
   {{0x44444017,0xe468600f,0x8464c025,0x00000000}},	//   _sb_, _singaqin_ukuthi_, _são__os_, --, 
   {{0x2b8c801c,0x42002031,0x33d8000b,0x00000000}},	//   _गए_, _bikin_, _yezu__kristu_, --, 
   {{0xf2266009,0xb3f46019,0xbba3c00a,0x8c916013}},	//   _besked_, _setter_, _अब__तक_, _अपलोड_, 
   {{0xe25a001a,0xc40a401d,0x6232600b,0xebb8e014}},	//   _heilt_, _dalam__tempoh_, _icarimwe__hafi_, _समाधान__के_, 
   {{0xfbbd0006,0x9ff8800a,0x00000000,0x00000000}},	//   _ཡི__གུ_, _के__मुताबिक_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [ec0] --, --, --, --, 
   {{0x64444004,0x7ae5e002,0x22a6c00e,0xdc25a00b}},	//   _ub_, _фебруар__јануар_, _aneb_, _gutangir, 
   {{0x0c5e2019,0x83d9a01a,0x00000000,0x00000000}},	//   _bestill_, _den__einaste_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xf47c600b,0x120ea015,0x68942027,0x4929200c}},	//   _icyumwer_cya_, _sumber__topic_, _prevodov, _पऽ__भोजपुर_, 
   {{0x3b7c8006,0x32a06002,0x00000000,0x00000000}},	//   _བརྩི__སྲུང_, _црна__гора_, --, --, 
   {{0xf3d0c018,0x7ee8e002,0x00000000,0x00000000}},	//   _sua__compra_, _се__по_, --, --, 
   {{0x3d8ce021,0x0e296002,0x2443800b,0x00000000}},	//   _འཁྱོལ_, _мај_, _hcr_, --, 
   {{0xec03e014,0xf2bde00e,0x00000000,0x00000000}},	//   _कुमार__के_, _rozdíl_, --, --, 
   {{0xc30b601f,0x00000000,0x00000000,0x00000000}},	//   _suami__isteri_, --, --, --, 
   {{0xb47bc037,0xb9dec002,0x00000000,0x00000000}},	//   _real__el_, _utorak__neregist, --, --, 
   {{0x52d9c039,0x02d66037,0xe6d32002,0x21b9e00a}},	//   _cewek_, _tu__cuenta_, _послове_, _मेडल_, 
   {{0x182ce006,0x00000000,0x00000000,0x00000000}},	//   _འཁྲིལ_, --, --, --, 
   {{0xabeb000a,0xebe06006,0x5a43200c,0x00000000}},	//   _पल__की_, _སྐུ__རི_, _के__जगह_, --, 
   {{0x32fde00b,0x00000000,0x00000000,0x00000000}},	//   _mbuga_, --, --, --, 
   {{0xe438a028,0x68ea400b,0x00000000,0x00000000}},	//   _en__venta_, _umushing, --, --, 
   {{0xa475001a,0x00000000,0x00000000,0x00000000}},	// [ed0] _alle__dei_, --, --, --, 
   {{0x2b93400c,0x798ae002,0xec05800c,0x00000000}},	//   _नाम__पऽ_, _животне__средине_, _बाई__के_, --, 
   {{0x344f8018,0x4c91a00b,0x4929a00c,0x00000000}},	//   _né_, _gucyura__impunzi_, _बा__भोजपुर_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x3401400b,0x1382c00a,0x00000000,0x00000000}},	//   _afise__amjwi_, _जौनपुर__मथुरा_, --, --, 
   {{0x9fab200e,0x22d98009,0xc3d6400c,0x6a31c00c}},	//   _nemovito, _jeres_, _खयाल__आवेला_, _सहेजे_, 
   {{0xf48de012,0x6ca0200a,0xd38c0002,0x00000000}},	//   _ak__ste_, _बोकारो__भुवनेश्_, _јуче_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xec04e022,0x124de003,0x00000000,0x00000000}},	//   _जनता__के_, _ཤོད_, --, --, 
   {{0xa2bfc011,0x724e4003,0x00000000,0x00000000}},	//   _que__sexa_, _ཡོམ_, --, --, 
   {{0x54bcc00e,0x135bc00b,0x00000000,0x00000000}},	//   _jsem__se_, _kongera_, --, --, 
   {{0xf48be015,0x73eae008,0x23dce01d,0xee94c002}},	//   _lintas__me_, _montes_, _haiwan_, _требало__да_, 
   {{0x8e56e002,0xb453202a,0xb6abc00b,0x52d9e01f}},	//   _уз_, _gjør__at_, _yitonda__ashigiki, _tetek_, 
   {{0x7b75e003,0x1312200a,0x7c31400a,0x00000000}},	//   _དཔྱད__གླེང_, _कोलकाता__ग्वालियर_, _प्रतापगढ_पीलीभीत_, --, 
   {{0xa3e72012,0xbab3800c,0x00000000,0x00000000}},	//   _ešte_, _दर्जा__मिल_, --, --, 
   {{0x8442200b,0x124cc006,0x1c0c000a,0xcddc200e}},	//   _adj_, _ཌིག_, _लिए__एक_, _cz__počet_, 
   {{0xf24c0003,0xe04d600e,0x1b8ca00c,0x00000000}},	// [ee0] _ཉིད_, _prohlíže, _कए_, --, 
   {{0x0c5be002,0xc8112029,0x00000000,0x00000000}},	//   _ekstovi_, _བསྐྱར_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xf34ce01a,0xac08800f,0x00000000,0x00000000}},	//   _første__gong_, _kankulun_weqiniso_, --, --, 
   {{0x844f800d,0x2252e009,0x31b9600c,0x00000000}},	//   _sé_, _bestyrel, _देखल_, --, 
   {{0xb2e5000b,0x00000000,0x00000000,0x00000000}},	//   _wa__kigali_, --, --, --, 
   {{0xde24600a,0x2da8e01d,0x00000000,0x00000000}},	//   _बढ़िया__आपत्तिजन, _kesihata, --, --, 
   {{0xee71c002,0xf472c00a,0x99aea00e,0xcbd7c01c}},	//   _како__да_, _पन्ने_, _současné__době_, _आरोपी_, 
   {{0x862ac01a,0xd2414012,0xcf508002,0x00000000}},	//   _navigeri, _napísať__asmira_, _да__има_, --, 
   {{0x944f800e,0xee7e6002,0x5cb3a00a,0xe4042025}},	//   _té_, _то__да_, _पसंद__सबसे_, _por__mais_, 
   {{0xd972c028,0xe316800f,0x63d68002,0x00000000}},	//   _opinione, _izazi_, _европско, --, 
   {{0xe5e82002,0x00000000,0x00000000,0x00000000}},	//   _италијан_македонс, --, --, --, 
   {{0x7a3d2013,0x32d9802a,0x43f5c038,0xf2ca6009}},	//   _हैं_, _leser_, _datos__acerca_, _imod_, 
   {{0x9c600033,0x0713400b,0xee74e002,0x00000000}},	//   _profil__postova_, _rusizi__bahungiy, _дневника__да_, --, 
   {{0xfbc08014,0xf2996003,0x00000000,0x00000000}},	//   _शब्द__से_, _འབྲི__གུང_, --, --, 
   {{0x1c630018,0xc4912018,0x00000000,0x00000000}},	//   _assunto_, _duração_, --, --, 
   {{0xe5cf0002,0x00000000,0x00000000,0x00000000}},	// [ef0] _општинск, --, --, --, 
   {{0x34c3601a,0x37b32011,0x4bc3c00c,0x8cf42003}},	//   _talet__på_, _deputaci, _कवनो__शक_, _ཏུ__གྱུར_, 
   {{0x124c003a,0x0c752015,0x53f98031,0x53f4601a}},	//   _ཉིན_, _seluler_, _yesus_, _bustad_, 
   {{0xb293e003,0x74bf800c,0x00000000,0x00000000}},	//   _དགོས__ཀྱི_, _में__समाधान_, --, --, 
   {{0xb2a5000a,0x00000000,0x00000000,0x00000000}},	//   _है__उन्होंने_, --, --, --, 
   {{0x26cba00c,0x00000000,0x00000000,0x00000000}},	//   _ओतनहीं__बिहार_, --, --, --, 
   {{0xcb8dc022,0x00000000,0x00000000,0x00000000}},	//   _झा_, --, --, --, 
   {{0x95fea002,0x00000000,0x00000000,0x00000000}},	//   _учествов, --, --, --, 
   {{0x4394a009,0xab93a003,0xe236000f,0x025c000c}},	//   _rejser_, _རང__བྱུང_, _bheka__futhi_, _के__हरवला_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x726e6017,0x00000000,0x00000000,0x00000000}},	//   _motoru_, --, --, --, 
   {{0x0abbc014,0xb28e800a,0xd2392002,0x2d3a800c}},	//   _शोध__में_, _वाराणसी__वाशिंगटन_, _форум_, _नाम__कठमउग_, 
   {{0xee28e002,0xd2e6802a,0x2316000b,0x1bb2000a}},	//   _да_, _kvinnen_, _byiza_, _भुवनेश्__वर_, 
   {{0x54a7c037,0xe27ee02b,0xa475601a,0x8220600e}},	//   _erróneo__no_, _izindi_, _seier__ved_, _současné_, 
   {{0x1307c01d,0xac87a00a,0x00000000,0x00000000}},	//   _sarawak_, _तस्__वीरें_, --, --, 
   {{0xc782a046,0xd457601a,0xdc522011,0x06f6600a}},	//   _नीति__विकिपीडि, _frå__den_, _contén_, _लेख__संवाद_, 
   {{0xe428200f,0x5986e00c,0x00000000,0x00000000}},	// [f00] _libonisa__ukuthi_, _गंगेश__गुंजन_, --, --, 
   {{0x72c42009,0x32fc400d,0x53c24018,0x00000000}},	//   _indlæg_, _un__hombre_, _veja__oferta_, --, 
   {{0xb28ca00a,0x1c5d600e,0x50752002,0xeb1ae00e}},	//   _उन्होंने_, _nebo__prostě_, _из__године_, _na__základě_, 
   {{0x1248c024,0xdcadc00b,0x00000000,0x00000000}},	//   _vreme_, _imiyobor, --, --, 
   {{0x5e9fa018,0xfbeae006,0x1467e010,0x2311600b}},	//   _verdinha_menciona, _འཕྲུལ__དང_, _dag__kl_, _ukwa__gatanu_, 
   {{0x72dd000d,0x3346e011,0x9bfe400a,0x774d800a}},	//   _de__agua_, _non__pode_, _जून__मई_, _मे__लिखा_, 
   {{0x144fc00e,0x00000000,0x00000000,0x00000000}},	//   _jí_, --, --, --, 
   {{0xf4856018,0x00000000,0x00000000,0x00000000}},	//   _faça__seu_, --, --, --, 
   {{0x634ce018,0x00000000,0x00000000,0x00000000}},	//   _dias__úteis_, --, --, --, 
   {{0xc3cf8026,0xa44fa018,0x524aa012,0x88ebe012}},	//   _kurv_, _dê_, _reagovať__nevhodné_, _topánky_, 
   {{0x544fc00e,0xc2cf600b,0x2d48e002,0x00000000}},	//   _ní_, _ubutunga_hagati_, _др_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x547e4026,0x900a0002,0xb29e2003,0x00000000}},	//   _tale__om_, _википеди, _སྲིད__ཀྱི_, --, 
   {{0x92368012,0x00000000,0x00000000,0x00000000}},	//   _vraj_, --, --, --, 
   {{0x4442600e,0xd3694015,0xf5be2002,0x00000000}},	//   _kdo_, _inggris_, _друга_, --, 
   {{0x4ea3e02f,0xebf3c00e,0x0fdd400e,0x6a47800c}},	//   _produtos_, _kč__obchodec, _velikost__displeje_, _रिटर्न__जमा_, 
   {{0xed6c2002,0xbc070019,0xec06e014,0x00000000}},	// [f10] _celu__kuću_, _ønsket_, _काफी__हद_, --, 
   {{0xb248c011,0x00000000,0x00000000,0x00000000}},	//   _preme_, --, --, --, 
   {{0x2b8fc00a,0x7247a003,0x00000000,0x00000000}},	//   _थी_, _ཚུལ__ཁྲིམས_, --, --, 
   {{0x1243e029,0xec62800b,0x33038011,0x00000000}},	//   _གཙང_, _ujejwe__amatora_, _nenos__nenas_, --, 
   {{0x93f5200f,0xb4894037,0x62c5c00c,0x34bf000c}},	//   _united__states_, _admite__el_, _अध्__यक्ष_, _काहेंकि_, 
   {{0xaebda012,0x29dac00e,0x00000000,0x00000000}},	//   _hodnoten, _na__mapě_, --, --, 
   {{0xc2fb600f,0xb4946012,0x1dd54003,0x00000000}},	//   _bathola_, _sa__pre_, _མཚན__དངོས_, --, 
   {{0xee2a6015,0x00000000,0x00000000,0x00000000}},	//   _mengupda, --, --, --, 
   {{0xe3fc2012,0x00000000,0x00000000,0x00000000}},	//   _príspevk_tomto_, --, --, --, 
   {{0xfbc5000c,0x00000000,0x00000000,0x00000000}},	//   _एकरा__से_, --, --, --, 
   {{0x4224c01a,0xfdd5800f,0x00000000,0x00000000}},	//   _gjekk_, _ukuhlaka, --, --, 
   {{0x7399a00e,0xee0be003,0x444da00e,0x00000000}},	//   _místa_, _འབྲེལ__འབྲེལ_, _přírodní_, --, 
   {{0xec83200c,0x00000000,0x00000000,0x00000000}},	//   _गइल__रहीं_, --, --, --, 
   {{0x52494032,0x48b98002,0x29fb4003,0x00000000}},	//   _ngemva_, _последњи_, _ལྟ__བུའི_, --, 
   {{0x0ca0e009,0x9be0c003,0x00000000,0x00000000}},	//   _dette__websted_, _འཇུ__མི_, --, --, 
   {{0xcb256012,0x6de0e020,0x00000000,0x00000000}},	//   _porovnať_, _གྱི__འཐུས_, --, --, 
   {{0xe9eaa032,0x72c9c006,0x00000000,0x00000000}},	// [f20] _njengoba_, _སྔགས__ཆོས_, --, --, 
   {{0xa3f0201a,0x6bfe800c,0x00000000,0x00000000}},	//   _eit__svar_, _एकत्र__धन_, --, --, 
   {{0x2c8f6022,0xee350011,0x04ad201a,0x00000000}},	//   _इंडो_, _mellores_, _att__ein_, --, 
   {{0x1394e031,0x00000000,0x00000000,0x00000000}},	//   _sensor_, --, --, --, 
   {{0xee41a002,0x02a6e018,0x00000000,0x00000000}},	//   _право__да_, _exibir_, --, --, 
   {{0x7e7a000f,0x00000000,0x00000000,0x00000000}},	//   _futhi__kufanele_, --, --, --, 
   {{0xf201801b,0x00000000,0x00000000,0x00000000}},	//   _yesi_, --, --, --, 
   {{0x5527a002,0x00000000,0x00000000,0x00000000}},	//   _молимо__читаоце_, --, --, --, 
   {{0xc0eb6003,0x03084018,0x4e508002,0xb2948003}},	//   _བོད__རྒྱ_, _proteção_, _што__сам_, _རབས__ཀྱི_, 
   {{0x12fb600f,0x00000000,0x00000000,0x00000000}},	//   _wathola_, --, --, --, 
   {{0x133f6009,0xe0f9e011,0x42550003,0x4a334002}},	//   _den__anden_, _traxecto, _བུ__ཁྱིམ_, _инвестиц, 
   {{0xebde6014,0xe4acc030,0x22326028,0xb47b000f}},	//   _बिहार__के_, _ostalog__na_, _miembro_, _kuthiwan_uma_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x5b8fa021,0x34a4e012,0x2a59a00e,0x3554e00f}},	//   _ཧེ_, _čo__sa_, _cz__značky_, _ukukhath, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xb48e6009,0x6c82a039,0xfa23e00f,0x0abaa00c}},	// [f30] _af__at_, _info__tentang_, _ukucinde, _जवना__में_, 
   {{0x33868012,0x9fbf201a,0x3daea006,0x00000000}},	//   _ktorí_, _sosiale__tenester_, _སྐྱོར__ཐེངས_, --, 
   {{0x124e4003,0x00000000,0x00000000,0x00000000}},	//   _འོན_, --, --, --, 
   {{0x9c69e033,0x777ca00a,0x8b64e002,0xbd6d2002}},	//   _još__postova_, _अलीगढ़__आगरा_, _на__форуму_, _сто_, 
   {{0x0224c02a,0xf48e6009,0x02a70003,0xf386600b}},	//   _sjekk_, _af__et_, _རང__མོས_, _ukora_, 
   {{0x7da0a003,0x00000000,0x00000000,0x00000000}},	//   _འགྱུར__ཁུགས_, --, --, --, 
   {{0x1bee0002,0xa288200a,0x62a12003,0x00000000}},	//   _како_, _अपना__कॉमेंट_, _བསུབས__བཏང_, --, 
   {{0xbbcea00a,0x3b7d800a,0x00000000,0x00000000}},	//   _किया__जा_, _तुझे__प्रणाम_, --, --, 
   {{0xb303600e,0xf9ffa00e,0xe28dc003,0x9bd9400a}},	//   _kč__více_, _moderní_, _ཐུན__མོང_, _आई__आर_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x9ad28028,0x33f8e012,0xb7928011,0x8e530002}},	//   _contrase, _ponuky_, _contrasi, _је__забрањен, 
   {{0x32926003,0xa862c00a,0x00000000,0x00000000}},	//   _ཞིང__ཆེན_, _करेगा_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x96fa400c,0x6d7f2002,0x00000000,0x00000000}},	//   _पइसा_, _суд_, --, --, 
   {{0x76d7e00a,0x02d9e016,0xc48e2028,0xee474002}},	//   _चाहिए_, _heter_, _este__producto_, _можете__да_, 
   {{0x5d3d200e,0x78156002,0x00000000,0x00000000}},	//   _aplikace_, _статисти, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [f40] --, --, --, --, 
   {{0xc442803d,0x4e320002,0xc4bc601a,0xa2a80003}},	//   _zda_, _се__приликом_, _eitt__av_, _བབ__བོད_, 
   {{0x7475a02a,0x21f58004,0x0386000b,0x54ee2014}},	//   _saker__les_, _imizekel, _akiri_, _में__आर्थिक_, 
   {{0x0467601a,0x00000000,0x00000000,0x00000000}},	//   _dei__som_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x422a2002,0x22fe600a,0x00000000,0x00000000}},	//   _тога_, _की__जरूरत_, --, --, 
   {{0xebc0a00a,0x9315e00f,0x00000000,0x00000000}},	//   _होने__के_, _ehholo__lombuso_, --, --, 
   {{0x7d2b0003,0x00000000,0x00000000,0x00000000}},	//   _གིས__རྒྱས_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x397d402d,0x5442801e,0x00000000,0x00000000}},	//   _uvjeti__korišten, _sda_, --, --, 
   {{0x127f4025,0x00000000,0x00000000,0x00000000}},	//   _não__são_, --, --, --, 
   {{0x6d9c200f,0x00000000,0x00000000,0x00000000}},	//   _inselele_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa112600f,0x00000000,0x00000000,0x00000000}},	//   _ngokujul, --, --, --, 
   {{0xb449c018,0xc0a6e003,0x00000000,0x00000000}},	//   _enviar__um_, _ཉིན__རྒྱ_, --, --, 
   {{0x12f68011,0x00000000,0x00000000,0x00000000}},	//   _súa__obra_, --, --, --, 
   {{0x34b5a00e,0x5ac9200a,0x00000000,0x00000000}},	// [f50] _dph__kč_, _कॉमन्स__ऍट्रीब्य, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6d94c003,0x00000000,0x00000000,0x00000000}},	//   _ལགས__ཀྱིས_, --, --, --, 
   {{0xdb8c6002,0xd290a00f,0xe421200f,0x00000000}},	//   _povređen, _indaba_, _ucabanga__ukuthi_, --, 
   {{0x4654c037,0xbc0c2014,0x12d8e00b,0x1246a00e}},	//   _tu__direcció, _दूर__तक_, _guhera_, _nahlásit_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x1248c00b,0x00000000,0x00000000,0x00000000}},	//   _igomba_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x32658011,0x42a6800b,0x00000000,0x00000000}},	//   _aplicar__termos_, _ukaba_, --, --, 
   {{0x127f0010,0xb290e00b,0x222ea00f,0xfc00200c}},	//   _blandt_, _yohana_, _kanjani__lokho_, _पीये__से_, 
   {{0x5c61c00a,0x00000000,0x00000000,0x00000000}},	//   _कर__सकते_, --, --, --, 
   {{0xa2a68020,0xee9ac002,0x00000000,0x00000000}},	//   _རང__དོན_, _тј__остављањ, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x8543e039,0x5371c00f,0xe232c00f,0x00000000}},	//   _berhasil_, _kancane__kancane_, _imiyalo__yakhe_, --, 
   {{0xfde2401d,0xd4b9c024,0xd9ec4028,0x00000000}},	//   _perniaga_perminta, _smajliji__su_, _colombia_, --, 
   {{0x0c000006,0x0709000c,0x9248c00b,0x00000000}},	//   _སི__སི_, _के__पूरा_, _agomba_, --, 
   {{0x0bfee00a,0x00000000,0x00000000,0x00000000}},	// [f60] _जुड़ता__है_, --, --, --, 
   {{0xfcbb801a,0x00000000,0x00000000,0x00000000}},	//   _med__kontoen_, --, --, --, 
   {{0x7bc2a00a,0x92aea018,0x994f800c,0x00000000}},	//   _गयी_, _entrega__nada_, _कुछ__इतिहासका, --, 
   {{0xb2d90018,0x22e4202f,0x5bc8800a,0x00000000}},	//   _buceta_, _se__para_, _हॉलीवुड_, --, 
   {{0x0482801a,0x9225a003,0x00000000,0x00000000}},	//   _vore__ein_, _རྒྱུགས__འཛུམ_, --, --, 
   {{0xf312000b,0xc5326002,0xf47ea009,0xc2578003}},	//   _byose__cyangwa_, _септемба, _hvor__der_, _གསེར__གྱི_, 
   {{0x1315a007,0xdc3c400f,0x3d13000b,0xd6b8c00b}},	//   _memberi_, _izinsuku_, _bikomeye_, _mutagati, 
   {{0x6de7e002,0x42e7a00c,0x00000000,0x00000000}},	//   _је__више_, _के__रोजी_, --, --, 
   {{0x6201c025,0x49b0c002,0x9be7e003,0x00000000}},	//   _envie_, _црној__гори_, _བྱེད__མི_, --, 
   {{0x679a2021,0xe404a018,0x78b62002,0xf061c00a}},	//   _སྟོན_, _ver__mais_, _попуните__детаље_, _हादसे_, 
   {{0x52d9e010,0x84b4e011,0x7ddf6003,0x00000000}},	//   _aften_, _son__os_, _མཐུན__ཚོགས_, --, 
   {{0xfe870011,0xe27e802c,0x22d9002c,0xc38c2002}},	//   _de__xuño_, _abana_, _kubera_, _путем_, 
   {{0xf46f8004,0x8dac4018,0xff21000e,0x5ea16002}},	//   _loo__nto_, _não__encontra, _rovněž_, _код__нас_, 
   {{0x840b0038,0xa4b4e011,0x52ba200e,0xd248c00b}},	//   _desde__http_, _son__as_, _předem_, _ugomba_, 
   {{0x635be00b,0xd48da018,0xf981800b,0xc2d72011}},	//   _ikigega_, _de__sua_, _abahamya_, _descarga_como_, 
   {{0xd2fce01a,0xb4cf4002,0x7321e03d,0x62aa0003}},	//   _gonger_, _за__време_, _lety_, _གི__བསམ_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [f70] --, --, --, --, 
   {{0x644ac025,0x00000000,0x00000000,0x00000000}},	//   _depois__de_, --, --, --, 
   {{0x8cb3400a,0x00000000,0x00000000,0x00000000}},	//   _रोहतक__लखनऊ_, --, --, --, 
   {{0x528b800f,0x00000000,0x00000000,0x00000000}},	//   _inhliziy_yethu_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xfbc6200c,0xfbc6000c,0x00000000,0x00000000}},	//   _भोज__से_, _ओकरा__से_, --, --, 
   {{0xb201e012,0xd472000a,0x028be00f,0x5175c018}},	//   _deti_, _महीने_, _omunye__umuntu_, _vitória_, 
   {{0x49f64012,0x00000000,0x00000000,0x00000000}},	//   _štýl_, --, --, --, 
   {{0xa442c023,0x04992028,0x8a26c014,0x47b92011}},	//   _fdd_, _personaj, _जयप्रकाश_, _personax, 
   {{0x8500a00a,0xd24c4003,0xc43d200b,0xf245a00f}},	//   _क्रिकेट__अन्य_, _ཡོང__བའི_, _ku__bantu_, _ezweni__lesithem, 
   {{0xd373800e,0x9f734018,0x00000000,0x00000000}},	//   _redakce_, _em__qualquer_, --, --, 
   {{0x0b99e00a,0xe442c00e,0xe442000f,0x0709000c}},	//   _की__ओर_, _jde_, _okusho__ukuthi_, _के__पंडा_, 
   {{0x31d9c002,0x00000000,0x00000000,0x00000000}},	//   _његове_, --, --, --, 
   {{0xebc2a013,0x8fed0002,0x00000000,0x00000000}},	//   _गये_, _изрази_, --, --, 
   {{0x1c596007,0xc3526009,0xc4a1c019,0x00000000}},	//   _peluang_, _tilføj_, _vært__en_, --, 
   {{0x2442c00b,0x92fcc028,0xdc41a00a,0x00000000}},	//   _nde_, _su__nombre_, _हैं__स्ट्रिक्, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [f80] --, --, --, --, 
   {{0x5442c004,0xf258e003,0x00000000,0x00000000}},	//   _ade_, _གཞུང__སྲི_, --, --, 
   {{0x82138012,0x8a570012,0x9b67600c,0x00000000}},	//   _najnovši, _domáce_, _के__लोगन_, --, 
   {{0x646ae012,0x3200201d,0xb2b3a014,0x8f4b2009}},	//   _ako__aj_, _sijil_, _निपुण_, _rejsepla, 
   {{0x9fe7800e,0x3b8fe003,0x00000000,0x00000000}},	//   _dnů_, _ཤེ_, --, --, 
   {{0xfa3d4022,0x6496c012,0x00000000,0x00000000}},	//   _रहन_, _hmotnosť_, --, --, 
   {{0x3dd9201d,0xa097c002,0xa0928002,0x00000000}},	//   _berkenaa, _промене_, _август__текст_, --, 
   {{0xb442c040,0x5b5f6002,0x9a56200c,0xfc806002}},	//   _gde_, _climatec, _कर__रहल_, _веће_, 
   {{0x38a9a003,0xc3ebe00b,0x05c06018,0x00000000}},	//   _བརྙན__འཕྲིན_, _umuti_, _maravilh, --, 
   {{0xe442c00e,0x52b8200d,0x62aae003,0xae880015}},	//   _zde_, _al__menos_, _གི__གསར_, _baca__selengka, 
   {{0x0c774009,0xbbcb600c,0x00000000,0x00000000}},	//   _websted_, _इहां__तक_, --, --, 
   {{0x63208015,0x1deb200c,0x82bf2011,0xc6914025}},	//   _biaya_, _साहित्य__संगोष्ठी_, _cada__unha_, _prática_, 
   {{0xa442001a,0xd327a012,0x7473600e,0x8ade800f}},	//   _dei_, _na__pokeci_, _pokud__si_, _lwezincw_zebhayib, 
   {{0x9633400e,0x5d140003,0x00000000,0x00000000}},	//   _oblíbeno, _འདུར__རྒྱུགས_, --, --, 
   {{0x92c7c009,0x72e1c00f,0x92dec00f,0x9d5ae002}},	//   _sådan_, _ka__israyeli_, _namadoda__amadala_, _рс_, 
   {{0x708a8002,0x421b000a,0x00000000,0x00000000}},	//   _својих_, _ऍट्रीब्य_शेयर_, --, --, 
   {{0x74b6400b,0x00550018,0x00000000,0x00000000}},	// [f90] _mujyi__wa_, _passagen, --, --, 
   {{0xaa3ce01c,0xc44ee037,0x944f400b,0x00000000}},	//   _शहर_, _nombre__del_, _matora__ya_, --, 
   {{0xe427200f,0x72a7c002,0xdfcb2011,0xf80dc00f}},	//   _khumbula__ukuthi_, _закона_, _dos__servizos_, _abonakal_esidlang, 
   {{0x0c1d0012,0x238a0012,0x1e31e01a,0x00000000}},	//   _napísal_, _fóre_, _sjølvste, --, 
   {{0xc25b2003,0x82372006,0x39efa003,0xc25fc00a}},	//   _བསྡུར__གྱི_, _ཡོདཔ__ཨིནམ_, _དང__དེའི_, _मुजफ्फरन, 
   {{0xa2bf8011,0xcfe68003,0x00000000,0x00000000}},	//   _que__ligan_, _བྱ__སྒྱུ_, --, --, 
   {{0x1073400f,0xdc17800c,0x00000000,0x00000000}},	//   _likajeho, _हासिल__करे_, --, --, 
   {{0x9442c009,0xe23c000f,0x00000000,0x00000000}},	//   _ude_, _kahle__futhi_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x5290001d,0x6321a012,0x00000000,0x00000000}},	//   _nuha_, _dopyt_, --, --, 
   {{0x0aafc00a,0x42a72009,0x00000000,0x00000000}},	//   _लिए__खोज_, _websted__uden_, --, --, 
   {{0xc4420019,0x02914026,0xf224e016,0xd3860011}},	//   _vei_, _adgang_, _lenkes_, _muros__elabora_, 
   {{0xda142012,0xe4534012,0x00000000,0x00000000}},	//   _rekonštr, _prejsť__na_, --, --, 
   {{0xa4420015,0x66ff200a,0x74444018,0xb48ac018}},	//   _deh_, _आपका_, _vc_, _entrar__em_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xf2a6600f,0x746ee00b,0x00000000,0x00000000}},	// [fa0] _ujobe_, _byo__mu_, --, --, 
   {{0xf4a34017,0xf2284002,0x8e3d2003,0xebc7200c}},	//   _počasí_, _је__данас_, _དྲིལ__བསྒྲགས_, _युवकन__के_, 
   {{0xf073400f,0x0f77e018,0x00000000,0x00000000}},	//   _zikajeho, _faço_, --, --, 
   {{0x3453800b,0x2eb8e002,0x00000000,0x00000000}},	//   _uru__rupapuro_, _када__је_, --, --, 
   {{0xaae62047,0x4499a018,0xba9c000c,0x0b3d8002}},	//   _उद्योग_, _avaliaçã_dos_, _में__आइल_, _конферен, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x22f6a039,0xf475200b,0x00000000,0x00000000}},	//   _bahan__bakar_, _igikombe__cy_, --, --, 
   {{0x32902032,0xe4b9e01a,0xec01200c,0x00000000}},	//   _kuka_, _knytt__til_, _देवे__के_, --, 
   {{0xb495e02a,0xf46ec002,0x1c39a013,0xee6b000e}},	//   _så__mye_, _према_, _हरियाणा_, _příspěvk_bydliště_, 
   {{0x43e12018,0x00000000,0x00000000,0x00000000}},	//   _de__nossos_, --, --, --, 
   {{0xd2d9e009,0x8073400f,0x0495000e,0xe45a600f}},	//   _efter_, _sikajeho, _se__pro_, _ubonisa__ukuthi_, 
   {{0xff47a00c,0x2295a003,0x53128002,0xb7954003}},	//   _भोजपुरी__साहित्य_, _གནས__སྤོ_, _је__потребно_, _ཤེས__འདོད_, 
   {{0x2ba5e00a,0xfa0ec002,0x00000000,0x00000000}},	//   _हो__गए_, _првог_, --, --, 
   {{0x2387e015,0xc47ac009,0x7e91e00e,0x00000000}},	//   _istri_, _have__en_, _editovat_, --, 
   {{0x9290201a,0x7200601d,0xe4b7201a,0x0a9b600c}},	//   _auka_, _minit_, _kvart__år_, _आईएम__में_, 
   {{0x54a3200b,0xf2a62039,0x37d0c002,0x00000000}},	//   _cyangwa__css_, _tombol_, _многи_, --, 
   {{0x62458018,0x9322001a,0x06fe2013,0x00000000}},	// [fb0] _para__adicioná_, _på__korleis_, _कैसा_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x3e590007,0x0a6c000c,0x00000000,0x00000000}},	//   _perbinca, _खुशी__में_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x3e5e2002,0xaec7c002,0x42b4000b,0x00000000}},	//   _пријави__на_, _александ, _kwica_, --, 
   {{0x143b8019,0x00000000,0x00000000,0x00000000}},	//   _et__nytt_, --, --, --, 
   {{0x32e6e02a,0xc15c0002,0x8804400e,0x07de8002}},	//   _det__noen_, _пута_, _určitě_, _тренутно_, 
   {{0xf4422009,0x84394012,0x1dacc003,0x00000000}},	//   _hej_, _na__tejto_, _འཁྱེར_, --, 
   {{0x5eec600e,0x00000000,0x00000000,0x00000000}},	//   _svých_, --, --, --, 
   {{0x14422045,0xe423600f,0x00000000,0x00000000}},	//   _jej_, _futhi__ukuthi_, --, --, 
   {{0x2e702002,0x6a3cc014,0x00000000,0x00000000}},	//   _свој__коментар_, _एहि_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x8eb8e002,0x00000000,0x00000000,0x00000000}},	//   _ти_, --, --, --, 
   {{0x54422027,0x7f444002,0x00000000,0x00000000}},	//   _nej_, _енциклоп, --, --, 
   {{0x638aa009,0x1fd5400e,0x7445600f,0x00000000}},	//   _gøre_, _předevší, _uma__kudingek, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xce0d2002,0xebb06003,0x70e6a00c,0x00000000}},	// [fc0] _ова_, _ཡང__དག_, _मारीशस_, --, 
   {{0x02e96022,0x7427e00b,0x42d9600b,0x6127c002}},	//   _सत्र_, _barakome_inyuma_, _kugera_, _београда_, 
   {{0xb4422005,0x9443200e,0x527f600d,0x62ee002c}},	//   _tek_, _kdy_, _cuanto_, _nyinshi_, 
   {{0xa290e024,0x124da006,0x00000000,0x00000000}},	//   _dinara_, _ཧིང_, --, --, 
   {{0x4bddc006,0x00000000,0x00000000,0x00000000}},	//   _གསོལ__ལོ_, --, --, --, 
   {{0xaba5c003,0x00000000,0x00000000,0x00000000}},	//   _འགྱུར__ཕབ_, --, --, --, 
   {{0x23f9000b,0x5478c00e,0x00000000,0x00000000}},	//   _rubuga_, _bych__se_, --, --, 
   {{0x2200401d,0x28dc402c,0xd3ff600b,0x7250a003}},	//   _bilik_, _umuryang, _yawe__uburyo_, _དོན__གསལ_, 
   {{0x846e8004,0xa6b50025,0x00000000,0x00000000}},	//   _mio__mio_, _resistên, --, --, 
   {{0x59878012,0x8326400d,0x00000000,0x00000000}},	//   _páči_, _la__mujer_, --, --, 
   {{0x5c48e00a,0x22430003,0xda4ce00a,0x30e7400f}},	//   _सकते_, _མཇལ_, _के__दिन_, _kofakazi__bakajeho, 
   {{0x6a56200a,0x00000000,0x00000000,0x00000000}},	//   _कर__रहा_, --, --, --, 
   {{0x3371800b,0xf1772002,0xc479600d,0x94080018}},	//   _ibibera__hanze_, _вести_, _mapa__del_, _palavras__chave_, 
   {{0x8291a00b,0x67ed4012,0x00000000,0x00000000}},	//   _imvano_, _futbalov, --, --, 
   {{0x7ca3801e,0x62df600a,0x0cf8e002,0xa5a6800a}},	//   _političk_partije_, _आपकी_, _тј_, _चाहती_, 
   {{0x64424025,0xb24e200b,0xd2cda01a,0x00000000}},	//   _nem_, _bo__muri_, _du__finn_, --, 
   {{0x72904025,0xb3d3200b,0x1275600e,0x5e922002}},	// [fd0] _numa_, _mu__mahanga_, _tak__jsem_, _портала_, 
   {{0xc3566018,0xe848e012,0x00000000,0x00000000}},	//   _receber_, _ochrana__osobných_, --, --, 
   {{0xa4424018,0xd4422009,0x327f6018,0x00000000}},	//   _bem_, _vej_, _quanto_, --, 
   {{0xc2314018,0xb77ce00b,0x00000000,0x00000000}},	//   _botão__abaixo_, _abavandi, --, --, 
   {{0x02d8202a,0x82902015,0x6687c00a,0xb4422012}},	//   _saken_, _gimana_, _की__पसंद_, _tej_, 
   {{0xa2ee000b,0xf2c2201a,0xfc16a00c,0x00000000}},	//   _byinshi_, _det__heile_, _बिया__तऽ_, --, 
   {{0x62992003,0x238a8002,0x2ece8009,0x00000000}},	//   _བའི__བཟོ_, _француск, _gennemsn, --, 
   {{0x6d968016,0xc6b2600c,0x822ea00f,0x00000000}},	//   _nettsted_, _बहुते_, _kanjani__lokhu_, --, 
   {{0x0250c002,0x52678003,0x00000000,0x00000000}},	//   _седам_, _དམ__དྲག_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6a484025,0x0e2dc015,0x00000000,0x00000000}},	//   _de__pagament, _dengan__pengikut_, --, --, 
   {{0xc284c018,0xb4a46002,0xec1cc00f,0xc0c72003}},	//   _páginas__como_, _hronika__pre_, _lobukris, _ནས__རྒྱ_, 
   {{0x575fe022,0xc2b8a003,0x54f1200c,0x91c9400c}},	//   _विस्फोट_, _ཎི__འུར_, _एह__मामिला_, _के__बढ़ल_, 
   {{0x93eb400f,0x4c9fe00d,0x7305000e,0xa4dcc00f}},	//   _upetru_, _la__última_, _mi__líbí_, _yini__ongayenz, 
   {{0x5442401d,0xc3eac037,0x00000000,0x00000000}},	//   _mel_, _cuotas_, --, --, 
   {{0x6290401f,0xd3dca011,0x00000000,0x00000000}},	//   _mula_, _máis__sobre_, --, --, 
   {{0x325e6006,0x3481c012,0x9bda6003,0x728a2003}},	// [fe0] _རྫོང__ཁའི_, _registro_sa_, _ངའི__ལས_, _སྐད__གསན_, 
   {{0xb4424017,0xa2d42024,0xd46e6011,0x823b8018}},	//   _sem_, _večernje_, _nas__que_, _email__senha_, 
   {{0x5175e018,0x12be4018,0x00000000,0x00000000}},	//   _notícias_, _nossa__loja_, --, --, 
   {{0x0a3e400c,0x4a6be011,0x00000000,0x00000000}},	//   _भईल_, _sitio__estás_, --, --, 
   {{0x32854005,0xe4424018,0x9a472003,0x3e16a002}},	//   _er__ikkje_, _vem_, _འཇམ__དབྱངས_, _свиђа__ово_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xc4424018,0x9920600e,0xa045600a,0x2ec0c002}},	//   _tem_, _mobilní_, _टैबलेट_, _ту__је_, 
   {{0xed8f6035,0x3266401a,0xb450c009,0x00000000}},	//   _kuhlanga, _som__ikkje_, _muligt__at_, --, 
   {{0xb3266002,0xb9d7400e,0xc2580003,0x00000000}},	//   _prva__poslednj, _užívání__kontaktu, _གྱུར__གྱི_, --, 
   {{0x12480032,0x2ed5e002,0x0aa5800a,0x00000000}},	//   _isimo_, _ко__је_, _में__हुए_, --, 
   {{0x8280400f,0x217a0014,0x00000000,0x00000000}},	//   _ujakobe_, _भग्नावशे, --, --, 
   {{0x98dac00a,0x0f782002,0x00000000,0x00000000}},	//   _जम्मू__जमशेदपुर_, _текста_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xae7d4011,0x32b7400f,0x7beb8003,0x00000000}},	//   _de__millóns_, _abangaph_kuka_, _ངག__རང_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x4c6d2011,0xc490e01a,0x4f23800f,0x71e8c00c}},	//   _ligazóns__última_, _ei__av_, _umoya__kankulun, _के__दोसर_, 
   {{0xbbbc600a,0x32a6401a,0x527e800f,0x00000000}},	// [ff0] _होने__पर_, _vil__ikkje_, _obani_, --, 
   {{0xff298027,0x4c524014,0x00000000,0x00000000}},	//   _bratisla, _जयदेव_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2f77e018,0x00000000,0x00000000,0x00000000}},	//   _faça_, --, --, --, 
   {{0x6bc3e018,0x00000000,0x00000000,0x00000000}},	//   _opções_, --, --, --, 
   {{0x73c20016,0xaa58a025,0x00000000,0x00000000}},	//   _mer__nyheter_, _pergunta_, --, --, 
   {{0x9a3d400c,0x00000000,0x00000000,0x00000000}},	//   _रहल_, --, --, --, 
   {{0xd4426024,0xbc1cc00f,0x83a24015,0xa4820012}},	//   _deo_, _yobukris, _telp_, _zodpoved_za_, 
   {{0x9290e00b,0xb200201d,0x8246c002,0xebcb200c}},	//   _munani_, _sikit_, _одмах_, _गोग्गल__के_, 
   {{0x3a8ca009,0xf2f0a01a,0x8248a003,0x00000000}},	//   _artiklen_, _høg_, _ཡིག__ཐོག_, --, 
   {{0x92fd4028,0xc2ca6018,0x92d4a00f,0x00000000}},	//   _elegir_, _aceitar__como_, _bonke__labo_, --, 
   {{0xf386c01a,0x9dda6006,0xf17ce00c,0xe48fe01a}},	//   _gjere_, _རྒྱབ__ཁུངས_, _बक्सर_, _då__er_, 
   {{0x02674003,0x2a5f8002,0x00000000,0x00000000}},	//   _བཟོས__ཡོད_, _могу__бити_, --, --, 
   {{0x026e000b,0x00000000,0x00000000,0x00000000}},	//   _raporo_, --, --, --, 
   {{0x14426010,0x2eebc002,0xddea800a,0x00000000}},	//   _hen_, _нам__је_, _लगे__आपत्तिजन, --, 
  
   {{0x2e502006,0x3a4d800c,0x00000000,0x00000000}},	// [1000] _འཛུལ__འགྱོ_, _के__मदद_, --, --, 
   {{0x52906033,0x3442600e,0x3a4f402b,0xb647a00a}},	//   _kuna_, _jen_, _ekleziya_, _बागपत__बांदा_, 
   {{0x4722600c,0x22bb2003,0x6394600b,0xcb052002}},	//   _बाड़े_, _མི__རབས_, _rwose_, _коришћењ_прочитај, 
   {{0x54426012,0x1c290011,0x00000000,0x00000000}},	//   _len_, _das__persoas_, --, --, 
   {{0x7be1a003,0x6494a00b,0xb473800f,0x00000000}},	//   _འདི__ནི_, _ku__isi_, _phaphama__ka_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x52b14037,0xf3cec010,0x32a5c01a,0x00000000}},	//   _mostrará_, _selvom_, _var__ikkje_, --, 
   {{0x8e5d6006,0x00000000,0x00000000,0x00000000}},	//   _གནས__བསྐྱོད_, --, --, --, 
   {{0xb4426038,0xb2ca800b,0xf442600d,0x00000000}},	//   _ben_, _stade_, _veo_, --, 
   {{0x43caa037,0xc4426017,0x00000000,0x00000000}},	//   _septiemb_agosto_, _cen_, --, --, 
   {{0x0c7dc020,0x5bfea018,0x86ed8005,0x7beb6003}},	//   _སྡེའི_, _sua__opinião_, _oldid__kategori, _གང__ཡང_, 
   {{0x2a40600c,0x00000000,0x00000000,0x00000000}},	//   _रहल__अछि_, --, --, --, 
   {{0x7ec8e002,0x22a7e00f,0x374c4003,0xd2b72002}},	//   _регистру_се_, _ukube_, _དབུ__ཁྲིད_, _другим_, 
   {{0x39fe002f,0xebe1c00a,0x00000000,0x00000000}},	//   _novament, _आप__इस_, --, --, 
   {{0xdcca0002,0xbbe1000b,0x3539a002,0x00000000}},	//   _јануар__децембар_, _musenyer, _на__балкану_, --, 
   {{0xd24de003,0x0242000a,0x0c536011,0x14296018}},	//   _ཤིག_, _मामले_, _xustiza_, _favorito_clique_, 
   {{0x2c6a0002,0x00000000,0x00000000,0x00000000}},	// [1010] _средстав, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa2f0a009,0x0f172003,0x00000000,0x00000000}},	//   _søg_, _མདོར__བསྡུས_, --, --, 
   {{0x9a8da037,0xf9200002,0x4340a002,0x00000000}},	//   _una__pregunta_, _одржавањ, _скорашњи__чланци_, --, 
   {{0xf24da003,0xc2404014,0x00000000,0x00000000}},	//   _སྲི_, _मुजफ्फरप, --, --, 
   {{0x8c14c00b,0xb3e5600e,0xa7124018,0x00000000}},	//   _munani__ibiganir, _dětí_, _construç, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xc4426011,0x00000000,0x00000000,0x00000000}},	//   _sen_, --, --, --, 
   {{0xf2e50011,0x62002039,0xd2e1001d,0x00000000}},	//   _xénero_, _pikir_, _kerana__mereka_, --, 
   {{0x13eae025,0x00000000,0x00000000,0x00000000}},	//   _muitos_, --, --, --, 
   {{0xf236c002,0x2480c034,0x03ea6009,0x5bf80012}},	//   _tanjug_, _sogn__og_, _flot_, _bydlisko_, 
   {{0x5a4bc00a,0xd207e002,0xd76f8006,0x00000000}},	//   _की__मौत_, _ауторств, _ལུ__བཀོད_, --, 
   {{0x1a6e600e,0x2ec5c002,0x00000000,0x00000000}},	//   _perfektn_recenzí_, _главни_, --, --, 
   {{0x83ea0018,0x00000000,0x00000000,0x00000000}},	//   _muito_, --, --, --, 
   {{0xc27d0006,0x7c6e400e,0x00000000,0x00000000}},	//   _ལཱ__འབད_, _června_, --, --, 
   {{0x55e42002,0x00000000,0x00000000,0x00000000}},	//   _спам_, --, --, --, 
   {{0xb3f8400d,0x64172015,0x3a43400c,0x00000000}},	// [1020] _salud_, _konsumen_, _के__जवन_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x8251800a,0x00000000,0x00000000,0x00000000}},	//   _चैनल__उपकरण_, --, --, --, 
   {{0xb469e012,0xa277e00f,0x3ce8800c,0x00000000}},	//   _aby__sme_, _inhliziy_yami_, _श्रमिकन_, --, 
   {{0xd4b7c01d,0x24ac001a,0xcdf06012,0x00000000}},	//   _versi__ke_, _ikkje__kan_, _predávaj, --, 
   {{0x6207800b,0x82e8c00c,0xe2a82003,0x00000000}},	//   _abantu__bari_, _के__बोली_, _ཆར__ཞོད_, --, 
   {{0xb458c018,0x00000000,0x00000000,0x00000000}},	//   _com__desconto_, --, --, --, 
   {{0x3488601a,0xe2b7000f,0x00000000,0x00000000}},	//   _sida__på_, _mathewu__johane_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xf290a01b,0xa957201a,0xba3d400c,0x00000000}},	//   _kuba_, _ønskjer_, _रहत_, --, 
   {{0x84438009,0x5a55a013,0x00000000,0x00000000}},	//   _mdr_, _उस__समय_, --, --, 
   {{0x12a6000b,0xf24e6006,0x85d88027,0x046ea01a}},	//   _ntushobo_kubona_, _ལིཤ_, _slovensk_republik, _seg__ein_, 
   {{0x0b01000b,0x9a502014,0xe417200f,0x5464c00e}},	//   _ukoreshe, _कि__चीन_, _bacabang_ukuthi_, _komentář_se_, 
   {{0xda3e0013,0x378be002,0x00000000,0x00000000}},	//   _बहन_, _написани__великим_, --, --, 
   {{0xc450c02a,0xd2c84011,0x6d258002,0x00000000}},	//   _profil__en_, _nas__súas_, _присутан__придружи, --, 
   {{0xaf02c002,0x00000000,0x00000000,0x00000000}},	//   _школи_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [1030] --, --, --, --, 
   {{0xf2936003,0x248fc012,0x00000000,0x00000000}},	//   _ཞིག__རེད_, _zatvoriť_, --, --, 
   {{0x427f600d,0x1a3e600a,0x7290a01d,0xa2a7e004}},	//   _cuando_, _मैं_, _cuba_, _akuba_, 
   {{0x8224c00e,0xe2b9e003,0x00000000,0x00000000}},	//   _funkce_, _བསྒྲགས__སྐར_, --, --, 
   {{0xebed8014,0xfaf46002,0x029d0006,0x8493a00a}},	//   _संस्कृति__के_, _активнос, _སྒར__སྐུ_, _की__तैयारी_, 
   {{0x52fce01a,0x00000000,0x00000000,0x00000000}},	//   _songar_, --, --, --, 
   {{0x82ca6009,0x746ee018,0x00000000,0x00000000}},	//   _hunde_, _pra__mim_, --, --, 
   {{0x1400c002,0x00000000,0x00000000,0x00000000}},	//   _једно_, --, --, --, 
   {{0x43e7000b,0x7a5c400a,0x00000000,0x00000000}},	//   _ku__munsi_, _फैजाबाद__फतेहपुर_, --, --, 
   {{0x62aaa009,0xa38aa009,0x92de000c,0x0b9aa00a}},	//   _købe_, _køre_, _कहनी_, _की__और_, 
   {{0xc471e019,0x33038009,0xf25b401a,0x46fea00a}},	//   _mye__av_, _bruge__vores_, _spelte_, _जैसा_, 
   {{0x6a3d400a,0x33208004,0x85d5800b,0x42dea00f}},	//   _रहा_, _phaya_, _yatangiy, _oshade__naye_, 
   {{0x6ee2e002,0xe2a54012,0x00000000,0x00000000}},	//   _он_, _svojich_, --, --, 
   {{0x1bd4a00c,0x00000000,0x00000000,0x00000000}},	//   _कहलनि__जे_, --, --, --, 
   {{0x3556c00a,0x00000000,0x00000000,0x00000000}},	//   _असहमत__बढ़िया_, --, --, --, 
   {{0xf2a7e00f,0x00000000,0x00000000,0x00000000}},	//   _ihubo_, --, --, --, 
   {{0x527f600e,0x00000000,0x00000000,0x00000000}},	// [1040] _vodní_, --, --, --, 
   {{0xf00bc002,0x72b46012,0x0467e009,0x29ed400a}},	//   _prijavi__komentar_, _dvoch_, _dig__som_, _का__प्रयोग_, 
   {{0x6a328022,0x2b954006,0x00000000,0x00000000}},	//   _गौर_, _དོན__ལམ_, --, --, 
   {{0x447c4040,0xa290a00b,0xe2db800f,0x00000000}},	//   _html__kod_, _vuba_, _kudingek_ukuba_, --, 
   {{0x547f4009,0x00000000,0x00000000,0x00000000}},	//   _vide__om_, --, --, --, 
   {{0xc29e4018,0x00000000,0x00000000,0x00000000}},	//   _incluí__taxas_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x5f3ac002,0x7be30003,0x00000000,0x00000000}},	//   _није__ни_, _བཙོན__ཁང_, --, --, 
   {{0x4f24000e,0xba3e2002,0xd3c42005,0x72b12006}},	//   _našem_, _sreda__neregist, _svar__avbryt_, _རྗེའི__ཆོས_, 
   {{0xc2d9600b,0x00000000,0x00000000,0x00000000}},	//   _kugeza_, --, --, --, 
   {{0x7278400f,0x30e7c00f,0x029b4003,0x00000000}},	//   _omunye_, _lofakazi__bakajeho, _སྐུ__ཞབས_, --, 
   {{0x0bab8002,0x00000000,0x00000000,0x00000000}},	//   _више__него_, --, --, --, 
   {{0xf442c012,0x12d8a00d,0x6893a00e,0x8316e005}},	//   _ked_, _hacen_, _provozov, _eg__hadde_, 
   {{0x1971000e,0xe3066015,0x43c8000b,0x00000000}},	//   _stažení_, _topik__kata_, _uwo__munsi_, --, 
   {{0xd218a00a,0xb28ee025,0x824c0003,0x00000000}},	//   _पृष्ठ__हमारे_, _nós__temos_, _ནགས__ཕྲན_, --, 
   {{0x7486c014,0x99c08012,0xf290800b,0xebcde00a}},	//   _निशानी_, _priemyse, _kikaba_, _तस्_, 
   {{0x9442a012,0x74ad600b,0x00000000,0x00000000}},	// [1050] _vec_, _mbere__mu_, --, --, 
   {{0xdb0ac01a,0x4d9ac006,0x00000000,0x00000000}},	//   _vanskele, _ཉམས__བཅོས_, --, --, 
   {{0x4c4f200a,0xb2b0000e,0x00000000,0x00000000}},	//   _उसने_, _vědět_, --, --, 
   {{0xbc0d2022,0x62904025,0x127ec00f,0x3c61000b}},	//   _देर__तक_, _cima_, _isonto_, _kurusha_, 
   {{0x7f6d200a,0x547ec005,0x00000000,0x00000000}},	//   _पोस्ट__लिखकर_, _ofte__om_, --, --, 
   {{0xd9f42012,0xbedc600d,0xf991c002,0xedcf0002}},	//   _majú_, _acciones_, _здравств, _након__што_, 
   {{0xfafb400e,0x653b400e,0xe2a70002,0x00000000}},	//   _žádné_, _žádný_, _часова_, --, 
   {{0x49d7001a,0x9290c00d,0x4232000b,0x00000000}},	//   _nettstad, _duda_, _akamaro_, --, 
   {{0xca3e6022,0x4299e003,0x00000000,0x00000000}},	//   _बनि_, _གསལ__ལྟར_, --, --, 
   {{0xc442c004,0xaa3e400a,0x7a42c00a,0x00000000}},	//   _hee_, _कविता__कोश_, _के__कवि_, --, 
   {{0xebfa000c,0x00000000,0x00000000,0x00000000}},	//   _लोगन__के_, --, --, --, 
   {{0x025b6018,0x00000000,0x00000000,0x00000000}},	//   _avalia_, --, --, --, 
   {{0x12aee018,0x047c4018,0x22ec600e,0x4e086003}},	//   _em__são_, _ogol__com_, _zrušit__vše_, _པར__བརྟེན_, 
   {{0x08b9800d,0xafe74003,0x2c7b400a,0x00000000}},	//   _de__nuestros_, _བྱ__རྒྱུ_, _लाइव__होते_, --, 
   {{0xaf226018,0x1bc8200c,0x00000000,0x00000000}},	//   _analisar_, _काहे__ना_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xc3416009,0x0a7ba00c,0x00000000,0x00000000}},	// [1060] _ind__eller_, _इयाद__में_, --, --, 
   {{0xe2230018,0xc550800f,0x00000000,0x00000000}},	//   _muitos__ganhe_, _ethembek_neqonday, --, --, 
   {{0x24b3c01a,0xbe9aa002,0x8464200f,0x81f1000c}},	//   _noreg__og_, _лозинку__регистру, _ukuphila__kwethu_, _कतना__पढ़ल_, 
   {{0x5ebec037,0x7442c038,0xed03601d,0xb4626009}},	//   _mostrará__públicam, _cee_, _matlamat_, _betyder__at_, 
   {{0x326cc024,0x3394c00b,0x00000000,0x00000000}},	//   _delovi_, _twese_, --, --, 
   {{0xba390002,0x3f506002,0x5243000f,0x00000000}},	//   _četvrtak__neregist, _да__им_, _umhlaba__wonke_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x94bbc009,0x00000000,0x00000000,0x00000000}},	//   _krak__dk_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x533a2037,0xebe9800c,0xe4bb0012,0x6aa9c002}},	//   _sesión__cambiar_, _आन्दोलन__के_, _recenzia__na_, _недеље_, 
   {{0x42dec013,0xae19a00e,0x00000000,0x00000000}},	//   _जैसी_, _je__zakázáno_, --, --, 
   {{0x0458e01a,0xc2b7801d,0xced52002,0x00000000}},	//   _frå__det_, _terma__terma_, _год_, --, 
   {{0x92d80018,0x34b1000e,0x00000000,0x00000000}},	//   _crie_, _obchodu__kč_, --, --, 
   {{0x60d7c002,0x89cfe012,0xc2978003,0x1ee9400c}},	//   _neregist_korisnik_, _stretnut, _དྲུང__བོན_, _चाहे__संस्_, 
   {{0x524f8002,0x8bfc6012,0x00000000,0x00000000}},	//   _оставите_, _priateľo, --, --, 
   {{0x92ad0002,0xd0f80006,0x62b32014,0x3a2dc002}},	//   _нису_, _ཚན__བརྡ_, _हुकुम_, _оних__који_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [1070] --, --, --, --, 
   {{0x2f24600e,0x5651c00e,0x00000000,0x00000000}},	//   _část_, _nejčteně, --, --, 
   {{0x34bba01d,0x27216011,0x32af2003,0xabc5e00a}},	//   _sama__ada_, _reservad_descrici, _པཎ__ཆེན_, _शहीदों__की_, 
   {{0x6290401d,0x33eae025,0x96606014,0xeffe200a}},	//   _sila_, _muitas_, _प्रसून_, _खिलाड़ी_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xb46aa018,0x5d7f800f,0xdcac2015,0x72430003}},	//   _com__uma_, _ngamunye_, _yogyakar, _དགོས__ཁྲིམས_, 
   {{0x4f5cc01d,0xe2a76006,0xac18a002,0x00000000}},	//   _inggeris_, _ཤོས__ཅིག_, _манифест, --, 
   {{0xa3ea0018,0xa8ea4005,0x427ea012,0x5a5d6012}},	//   _muita_, _forsking, _jednej_, _európa_, 
   {{0xca6a600a,0xa9de4003,0x00000000,0x00000000}},	//   _ताकि__कोई_, _དབྱིན__ཇིའི_, --, --, 
   {{0x7217800f,0xc43e200b,0x00000000,0x00000000}},	//   _ngokuvam, _mu__bantu_, --, --, 
   {{0x12fe400b,0x00000000,0x00000000,0x00000000}},	//   _ukwa__cyenda_, --, --, --, 
   {{0xd9d1a02d,0xa6dec004,0x32d5a015,0x00000000}},	//   _kolovoza_, _yiya__kwipheph, _spotligh_adalah_, --, 
   {{0x8c86a00a,0x00000000,0x00000000,0x00000000}},	//   _जिसमें__अनर्गल_, --, --, --, 
   {{0x7be7a006,0x00000000,0x00000000,0x00000000}},	//   _བཟོ__ནི_, --, --, --, 
   {{0x726c6003,0x00000000,0x00000000,0x00000000}},	//   _ནས__གསལ_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [1080] --, --, --, --, 
   {{0xf229c00e,0x3693200c,0x00000000,0x00000000}},	//   _díky_, _के__एहसास_, --, --, 
   {{0x1290600f,0x92e26024,0xde292002,0x3237801a}},	//   _mina_, _odgovori__prijavi_, _дан_, _byrja_, 
   {{0x238a000e,0x3bf0400c,0x874ce00a,0x00000000}},	//   _fóru_, _में__बा_, _कानपुर__कोटा_, --, 
   {{0x83ea6011,0xff184002,0x6495200b,0x2e04e011}},	//   _xunta_, _да__би_, _kw__isi_, _as__activida, 
   {{0x6ac1400c,0x4ec74002,0x3ed56002,0x00000000}},	//   _सबसे__बड़_, _разлику__од_, _њој_, --, 
   {{0x7290e011,0x22dcc031,0x00000000,0x00000000}},	//   _auga_, _di__bidang_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xbbb2400c,0x00000000,0x00000000,0x00000000}},	//   _गीतन__पर_, --, --, --, 
   {{0x1a6aa00c,0xe317a00b,0x00000000,0x00000000}},	//   _सब्सिडी_, _sota__ugye_, --, --, 
   {{0x71862002,0x00000000,0x00000000,0x00000000}},	//   _економск, --, --, --, 
   {{0x4ae9c002,0x5103801f,0xfddba003,0x3bce200a}},	//   _политика_, _mahkamah_, _ཞིབ__འཕྲོས_, _मस्_, 
   {{0xe2d1a005,0xce47c002,0x04f2800e,0x00000000}},	//   _nynorsk_, _проблем_, _na__stránce_, --, 
   {{0x95c04030,0x14776009,0x00000000,0x00000000}},	//   _uz__obavezno_, _samarbej_med_, --, --, 
   {{0x34ae801a,0x82fc600d,0xebe22014,0x4f666009}},	//   _att__eit_, _tenga_, _मई__के_, _dræbt_, 
   {{0xe290600b,0x5d886003,0x12b02012,0xe2e7800f}},	//   _zina_, _ཞུགས_, _porovnať__tovar_, _yini__ukuba_, 
   {{0x83948035,0x833ee00f,0x2002a00e,0x00000000}},	// [1090] _kwase_, _yeka__indlela_, _nemáš__jméno_, --, 
   {{0x83eac026,0xe19b2012,0x00000000,0x00000000}},	//   _slet_, _zvieratá_, --, --, 
   {{0xa38aa009,0x74ba4028,0xb4722012,0x252f400b}},	//   _børn_, _como__si_, _skúsenos, _umuyoboz, 
   {{0x14768011,0xe321e00b,0xe353000b,0x00000000}},	//   _veces__ver_, _bityo_, _mudasobw_yawe_, --, 
   {{0xbdd4000f,0x1ca7800a,0x00000000,0x00000000}},	//   _ezihluka, _और__उसके_, --, --, 
   {{0xc28fe025,0x83eae015,0xabf0e00e,0x8c0cc00f}},	//   _que__não_, _kantor_, _více__požadova, _izimpend_zemibuzo_, 
   {{0x33806038,0xd295200e,0x00000000,0x00000000}},	//   _ferrol_, _apple__nebo_, --, --, 
   {{0x4be9e003,0x0c7c6003,0xcc56c00f,0x00000000}},	//   _རྗེ__ཆེ_, _གཙོའོ_, _wokushum_ngombuso_, --, 
   {{0x48d48036,0xb442e034,0x92f14005,0x6895a00e}},	//   _चर्चित_, _veg_, _låg_, _potřeby_, 
   {{0xb291001b,0x7bdce022,0x024e4003,0x4268e005}},	//   _kuza_, _पलायन_, _ཡིས_, _det__blei_, 
   {{0x4464c00b,0x33cc000f,0xfc66a009,0x9a3e600a}},	//   _bbc__bbc_, _ujesu__kristu_, _hurtigt_, _मैच_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xf2918004,0x00000000,0x00000000,0x00000000}},	//   _unyana_, --, --, --, 
   {{0xb406e002,0x94ba4018,0x00000000,0x00000000}},	//   _profil__poruke_, _juros__ou_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x8289c00f,0x00000000,0x00000000,0x00000000}},	//   _inhliziy_yakho_, --, --, --, 
   {{0x3956a00a,0x00000000,0x00000000,0x00000000}},	// [10a0] _करें__कॉमेंट्स_, --, --, --, 
   {{0x24430012,0x00000000,0x00000000,0x00000000}},	//   _cez_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x46e06007,0x54430018,0x93b9000e,0x00000000}},	//   _linkedin__perjanji, _fez_, _srovnat_, --, 
   {{0x44a2001f,0x02ca6018,0x00000000,0x00000000}},	//   _perkara__ini_, _fundo_, --, --, 
   {{0xefb10002,0x0b8f801c,0x2443e00b,0x54554011}},	//   _pošaljit_komentar_, _था_, _fdu_, _cun__lector_, 
   {{0x6be1e011,0xedbc8003,0x7dd1e00a,0xf4768009}},	//   _ligazón__informac, _ཡོད__འབྲེལ_, _बनाएँ_, _noget__der_, 
   {{0xa6f84055,0xf24e4003,0x64078015,0x5ca1200c}},	//   _शंका_, _རྒུ_, _dukungan_, _गूढ़__रहस्यन_, 
   {{0x8d704002,0x3387a012,0x9e80e00c,0x00000000}},	//   _reputaci_moć_, _napr_, _के__जिक्र_, --, 
   {{0x63ea6011,0xa2f16009,0x00000000,0x00000000}},	//   _xunto_, _læg_, --, --, 
   {{0x1291201b,0x1526800a,0x8fdd2018,0x00000000}},	//   _buya_, _एटा__औरैया_, _conhecer_, --, 
   {{0x02f1401a,0xe2d8e010,0x00000000,0x00000000}},	//   _såg_, _sagen_, --, --, 
   {{0x3b940002,0x5307e02f,0x42cb4028,0xc290a00b}},	//   _komentar_pošaljit, _seu__nome_, _puedes_, _niba_, 
   {{0x1302601f,0x54c3400e,0x9b68e00c,0x00000000}},	//   _ini__boleh_, _jedná__se_, _गो__लोगन_, --, 
   {{0xedf7c006,0x1db5a009,0xaddf2012,0x00000000}},	//   _གཉེན__འབྲེལ_, _brøndby_, _dobrý__deň_, --, 
   {{0x0290a00b,0x1b87a003,0xb386c01a,0xfc66a037}},	// [10b0] _biba_, _སྐུ__ཕྲེང_, _gjera_, _otro__artículo_, 
   {{0xa2fc4016,0x00000000,0x00000000,0x00000000}},	//   _selge_, --, --, --, 
   {{0xa3878012,0xc2a9a00e,0x12e1000b,0xef240012}},	//   _tasr_, _článků_, _na__leta_, _našom_, 
   {{0x344b600b,0x00000000,0x00000000,0x00000000}},	//   _gihugu__ca_, --, --, --, 
   {{0x9f678015,0xdd8bc002,0xb2914009,0xe267a003}},	//   _bukan__mengomen, _измењена_, _udgave_, _ཁག__ཅིག_, 
   {{0x90674013,0x00000000,0x00000000,0x00000000}},	//   _झांसी_, --, --, --, 
   {{0xfb8e800c,0x00000000,0x00000000,0x00000000}},	//   _लए_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xca33600a,0x22a62009,0x0a54400a,0xd09cc003}},	//   _किए_, _lækker_, _ही__में_, _བསྟན__བཀྲ_, 
   {{0x048e6005,0x4ad9c00c,0x00000000,0x00000000}},	//   _eg__vil_, _के__डुमरांव_, --, --, 
   {{0x0f09601d,0x00000000,0x00000000,0x00000000}},	//   _amerika__syarikat_, --, --, --, 
   {{0x413b0002,0x00000000,0x00000000,0x00000000}},	//   _опет_, --, --, --, 
   {{0x62fc6028,0xb710800a,0x00000000,0x00000000}},	//   _tengo_, _भिलाई__भोपाल_, --, --, 
   {{0x5e68c02f,0x8394e009,0xe289c00f,0xf2f8600b}},	//   _menciona, _uanset_, _inhliziy_yakhe_, _urunana__umva_, 
   {{0x53ea6039,0xd47fa011,0x8364c016,0xe01b8009}},	//   _quote_, _unha__das_, _alt__innhold_, _tjeneste_accepter_, 
   {{0xa2ef8024,0x72b3201d,0x63eb0012,0x9a9fe00e}},	//   _pogledaj__javni_, _pilihan__raya_, _piatok_, _slouží_, 
   {{0x8a17600c,0x1bb66003,0x00000000,0x00000000}},	// [10c0] _हार्डकोर_, _ཁོ__ནས_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x327f6018,0x4290a025,0x6226601a,0xf4962009}},	//   _quando_, _fica_, _kyrkja_, _ud__fra_, 
   {{0x61e7a00e,0x00000000,0x00000000,0x00000000}},	//   _nachází_, --, --, --, 
   {{0xb33bc00f,0x3d5a2002,0xea7c200b,0x00000000}},	//   _ukubukwa__amahora_, _којем_, _ukwa__gatandat, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xcbed000a,0x00000000,0x00000000,0x00000000}},	//   _पर__ही_, --, --, --, 
   {{0x3e0be00b,0xeedba00e,0x00000000,0x00000000}},	//   _komeza__ushakire_, _těhotens, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xcd39e00b,0x83b9e00c,0x6b62000c,0x00000000}},	//   _urupapur, _सीधा__संबंध_, _केतना_, --, 
   {{0x02bb4012,0xe45b600e,0x00000000,0x00000000}},	//   _má__rokov_, _mohou__být_, --, --, 
   {{0x02a00003,0x00000000,0x00000000,0x00000000}},	//   _བཞིན__ཡོད_, --, --, --, 
   {{0xfbdae034,0x7444400b,0x822b4012,0x00000000}},	//   _tilgjeng_lisensen_, _umwe__mu_, _poradiť_, --, 
   {{0x2309c018,0xc9d7401a,0x02018015,0xd3a22031}},	//   _também_, _offentle, _kirim_, _tampak_, 
   {{0x048ea01a,0x28ed200a,0xc6e80012,0x00000000}},	//   _ha__ein_, _रांची__रायपुर_, _vložiť__košíka_, --, 
   {{0x0bbae00a,0xdfe4a014,0x2260801f,0xa2a2e003}},	//   _हुआ__है_, _सिंहासन__बत्तीसी_, _kerja__kerja_, _སྤྲོད__བཙན_, 
   {{0x269ca003,0xd4706018,0x00000000,0x00000000}},	// [10d0] _སླེབས_, _assim__que_, --, --, 
   {{0xa248c003,0x3c6f000e,0x00000000,0x00000000}},	//   _ཡིག__བོད_, _frekvenc_procesor, --, --, 
   {{0x02c4a011,0x9632e011,0x927de003,0xc34de003}},	//   _ademais_, _coñeceme, _དམངས__གཙོ_, _འདྲའི_, 
   {{0x16d1200c,0x00000000,0x00000000,0x00000000}},	//   _खातिर_, --, --, --, 
   {{0xbf02e020,0xc3e10025,0xdd82e003,0x993e000f}},	//   _འབྲུག_, _de__seus_, _འབྲོག_, _unembeza_, 
   {{0x34b36016,0xb3e7c009,0xebbfa00c,0x00000000}},	//   _innhold__på_, _sætte_, _तरे__के_, --, 
   {{0x82fc6009,0x12ca001d,0x00000000,0x00000000}},	//   _penge_, _mohd_, --, --, 
   {{0xe2d88028,0x00000000,0x00000000,0x00000000}},	//   _mejores_, --, --, --, 
   {{0x036a600b,0xd29e0011,0x536c4017,0x00000000}},	//   _mu__kwezi_, _teu__datos_, _mobilní__verze_, --, 
   {{0x449fc009,0xe4bdc00b,0x00000000,0x00000000}},	//   _indlæg__af_, _ijwi__ry_, --, --, 
   {{0xdc3da02a,0x229a002f,0x492a000c,0x00000000}},	//   _fornøyd_, _mínima__para_, _से__निपटे_, --, 
   {{0x2309e018,0xada16002,0x8aa9a01c,0x00000000}},	//   _enviados__este_, _јер__су_, _मंगलवार_, --, 
   {{0x5387e00b,0xfba14003,0x00000000,0x00000000}},	//   _uhuru_, _བྲིས__ལི_, --, --, 
   {{0x5ddf800b,0x00000000,0x00000000,0x00000000}},	//   _byose__bidafite_, --, --, --, 
   {{0xb38b6009,0x00000000,0x00000000,0x00000000}},	//   _værd_, --, --, --, 
   {{0x272e8030,0x8a33e00a,0x528ba006,0x00000000}},	//   _zoran__bibanovi, _जिस_, _གནས__གཡུ_, --, 
   {{0x6e8aa018,0x00000000,0x00000000,0x00000000}},	// [10e0] _nossos__estoques_, --, --, --, 
   {{0x72db801a,0x9a97a00c,0x00000000,0x00000000}},	//   _mellom__anna_, _चल__रहल_, --, --, 
   {{0x4edc4002,0x324c8002,0x84a7c012,0x00000000}},	//   _више__од_, _август__свиђа_, _obchodu__sk_, --, 
   {{0xc27ec034,0x2290c01a,0x2446e01a,0x4458000e}},	//   _byen_, _sida_, _bustad__og_, _obchodů__nejnižší_, 
   {{0x6bb52020,0xa2d82009,0xe24de003,0xd982e00b}},	//   _ལས__ཡར_, _cykel_, _ཤིན_, _ubuhamya_, 
   {{0x09cf2006,0x72cac00d,0xc242a003,0x00000000}},	//   _ནིའི_, _pueda_, _བབས_, --, 
   {{0x0231800f,0x9248e00e,0x73eae01d,0x00000000}},	//   _izimiso_, _kromě_, _hantar_, --, 
   {{0x9a56a00c,0x00000000,0x00000000,0x00000000}},	//   _हो__रहल_, --, --, --, 
   {{0x3290c005,0xd3ea800b,0x00000000,0x00000000}},	//   _tida_, _atatu_, --, --, 
   {{0x124ec006,0xdfec2011,0xcc7e801a,0xbb63c012}},	//   _ཨིང_, _de__servizos_, _innspel_, _banská__bystrica_, 
   {{0xa2a00003,0x00000000,0x00000000,0x00000000}},	//   _བྱོལ__བོད_, --, --, --, 
   {{0x42bb0024,0xc2988003,0x9999000e,0x00000000}},	//   _mesec__dana_, _རྒྱུ__མཚན_, _telefony__mobilní_, --, 
   {{0xe2d86009,0x00000000,0x00000000,0x00000000}},	//   _erne_, --, --, --, 
   {{0xa30cc015,0x1290c003,0x755ba00b,0xd1f50002}},	//   _berbagai__sumber_, _ལུགས__ཆེད_, _umuvugiz, _смрт_, 
   {{0x7f86e00a,0x8e98600b,0x7254000f,0x00000000}},	//   _कार्रवाई_, _ku__mugaraga, _ngayo__yonke_, --, 
   {{0x52cd200f,0x82aa0003,0x4a46200c,0x00000000}},	//   _uma__kunjalo_, _གི__ཐོག_, _चढ़ाव__भरल_, --, 
   {{0xf440c01e,0x00000000,0x00000000,0x00000000}},	// [10f0] _lokacija__sarajevo_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7cce000a,0x00000000,0x00000000,0x00000000}},	//   _संसार__फोटो_, --, --, --, 
   {{0xd2ca6015,0x00000000,0x00000000,0x00000000}},	//   _bunda_, --, --, --, 
   {{0xd26e8003,0xd387400d,0x726c800b,0xbe0f8003}},	//   _དྲ__བའི_, _muerte_, _yakoze_, _དགའ__རོགས_, 
   {{0x641e6009,0x33eac018,0x92018015,0xfc464014}},	//   _er__blevet_, _frete_, _fisik_, _में__मनाया_, 
   {{0x127f6040,0xdc762002,0xd86f201f,0x9a3ca013}},	//   _slanje_, _децембар_, _yang__bermaksu, _रेप_, 
   {{0x4c7c400d,0x38686012,0x0a6de00a,0x2fedc01f}},	//   _muestra_, _vzdeláva, _भ्रमण__खोज_, _menyokon, 
   {{0xfe8f0002,0x49fda00f,0x00000000,0x00000000}},	//   _или_, _uhlangot, --, --, 
   {{0x1bee0006,0x248a6009,0xb385600a,0x00000000}},	//   _གྲོགས__རམ_, _logget__ind_, _ट्रिब्यू, --, 
   {{0x5c7c400d,0x6e0c6002,0xe5c4000f,0x00000000}},	//   _nuestra_, _прегледа_преводе_, _lapho__unkulunk, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x72b7400f,0x00000000,0x00000000,0x00000000}},	//   _bakwa__israyeli_, --, --, --, 
   {{0xd354400e,0x8dda4002,0x00000000,0x00000000}},	//   _ostatníc_recenze_, _се__аутоматс, --, --, 
   {{0x02e28018,0x544e400e,0x00000000,0x00000000}},	//   _sobre__produto_, _přihlási_se_, --, --, 
   {{0xa2688020,0xfdc6200f,0x00000000,0x00000000}},	//   _རྫོང__འདི_, _ngemva__kweminya, --, --, 
   {{0xf405001d,0x46b3c00a,0x00000000,0x00000000}},	// [1100] _profil__penuh_, _भयंकर__चुदाई_, --, --, 
   {{0x74444009,0xedb7c006,0x7e0d6002,0xfad58003}},	//   _ud_, _ལས__རྟགས_, _ову_, _ཉེན__རྟོག_, 
   {{0xf3478012,0x446a6011,0xb2d8200b,0x00000000}},	//   _týždeň_, _través__da_, _nimero_, --, 
   {{0x04b34017,0xbe0fa01f,0xb27ee00e,0x00000000}},	//   _idnes__cz_, _di__peringka, _zimní_, --, 
   {{0x44dfe012,0xa91fe012,0x6495a00b,0x00000000}},	//   _tejto__stránke_, _tejto__stránky_, _mu__isi_, --, 
   {{0xfe7ca015,0x7d67e002,0xa3d9800b,0x00000000}},	//   _sistem__pencaria, _требало_, _umupira__amaguru_, --, 
   {{0x3c4f000a,0xb266c014,0x42a70018,0x0303400c}},	//   _इससे_, _के__निदेशक_, _acabei_, _एह__सत्र_, 
   {{0xc3ea600e,0xcb8d6029,0x65bb200a,0x34c4e010}},	//   _proto_, _ཚབ_, _रायपुर__रोहतक_, _varer__på_, 
   {{0x4641c00b,0x00000000,0x00000000,0x00000000}},	//   _icyo__ushakish, --, --, --, 
   {{0x9330a00a,0x76fec00a,0x5290e01a,0xcf8de00a}},	//   _ज्योतिष__धर्मयात्, _कहना_, _eiga_, _बल्कि_, 
   {{0x84438016,0xfbd18003,0x0f48a00f,0x00000000}},	//   _mer_, _ཞིག__དང_, _kodwa__kuthiwan, --, 
   {{0x39d70002,0x00000000,0x00000000,0x00000000}},	//   _увредљив_који_, --, --, --, 
   {{0x2f58800a,0xee3f4002,0xab30c003,0xede2c003}},	//   _आईटी__क्रिकेट_, _значи__да_, _ཁྱབ__གསུང_, _གཟེངས__རྟགས_, 
   {{0xd2626021,0xe2b5c00e,0x398b400e,0x232ba00b}},	//   _དང__དཔེ_, _najdete_, _vidět_, _pagi__iwacu_, 
   {{0x1ccaa00b,0xed75801d,0x9e8f400e,0x97060018}},	//   _wa__dioseze_, _mengguna_maklumat_, _neomezen, _reproduç, 
   {{0xc3e82018,0x38e6801c,0xfdd4a003,0x00000000}},	//   _os__dois_, _न्यूयॉर्, _བཀོལ__སྤྱོད_, --, 
   {{0x408f6018,0xebbfa00c,0x00000000,0x00000000}},	// [1110] _mensagem__bookmark_, _बने__के_, --, --, 
   {{0x32ed800f,0x00000000,0x00000000,0x00000000}},	//   _ukuba__khona_, --, --, --, 
   {{0x628d2003,0xc17b0002,0x00000000,0x00000000}},	//   _ཆེན__གསར_, _европи_, --, --, 
   {{0x52cac028,0x81c3c002,0x00000000,0x00000000}},	//   _puedo_, _говори_, --, --, 
   {{0xe2920015,0x5c690037,0xeb32e028,0x62c7c00f}},	//   _jepang_, _cerrado_, _el__siguient, _leli__gama_, 
   {{0xd9f4200e,0x00000000,0x00000000,0x00000000}},	//   _jaký_, --, --, --, 
   {{0x6443801d,0x9d30000f,0x48d2200c,0x00000000}},	//   _kes_, _ubungane_, _निपटे_, --, 
   {{0x3e0d0002,0x00000000,0x00000000,0x00000000}},	//   _сви_, --, --, --, 
   {{0x030d2016,0xe46f6009,0x62366027,0xebc82003}},	//   _hele__saken_, _sig__til_, _tvoje_, _བདག__གི_, 
   {{0x9291803f,0x53f8e018,0x4ff50002,0x00000000}},	//   _musa_, _água_, _се__овај_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x62910004,0xaa52c018,0x23e86018,0xc2cac01a}},	//   _liza_, _você__está_, _decoraçã, _budde_, 
   {{0x529e0002,0x00000000,0x00000000,0x00000000}},	//   _нисам_, --, --, --, 
   {{0xe26c601d,0x22e6c00c,0x00000000,0x00000000}},	//   _umno_, _चाहीं_, --, --, 
   {{0x24814002,0x00000000,0x00000000,0x00000000}},	//   _американ, --, --, --, 
   {{0xe4438034,0x327b201a,0xdc23a002,0x00000000}},	//   _ser_, _heller__ikkje_, _новости_, --, 
   {{0x8d96a005,0xaef3800c,0x00000000,0x00000000}},	// [1120] _milliona, _पृथ्वीसि, --, --, 
   {{0x65840002,0x66e6600c,0xe3f4400f,0x7b9ae003}},	//   _на__овом_, _रविशंकर__प्रसाद_, _ngokwesi_cabanga_, _བསྐྱར__དུ_, 
   {{0x8fc74036,0xad838040,0xc983a00b,0xb2da6018}},	//   _समाचार_, _reč_, _amahanga_, _aquele_, 
   {{0x52366027,0x4e292002,0x12a5e006,0x00000000}},	//   _svoje_, _сам_, _འཕེལ__ལྷན_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xe48f6028,0x5291201b,0xe399a00e,0x0e4ca039}},	//   _de__tu_, _liya_, _místo_, _pelayana, 
   {{0x813e6012,0x00000000,0x00000000,0x00000000}},	//   _svietidl, --, --, --, 
   {{0x14450033,0x4291003f,0x72912004,0xf3ea602b}},	//   _mlađim__od_, _ziza_, _niya_, _kuntu_, 
   {{0xad84c00f,0xc432c00a,0x00000000,0x00000000}},	//   _genesise_, _कानपुर__इलाहाबाद_, --, --, 
   {{0xbde6c012,0x34aae009,0x9ba24003,0x00000000}},	//   _nájdete_, _opmærkso_på_, _ནོར__བུ_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x14ad001a,0x6a56a00a,0xe24e4003,0xf4aa8018}},	//   _ikkje__har_, _हो__रहा_, _རྒན_, _deixe__seu_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xe4438026,0x1a5d2026,0xd443a018,0x00000000}},	//   _ses_, _der__også_, _cep_, --, 
   {{0x24bbc00b,0x00000000,0x00000000,0x00000000}},	//   _yatangaj_ko_, --, --, --, 
   {{0x7de38003,0x02f0c002,0x00000000,0x00000000}},	//   _རྒྱས__ཚོགས_, _на__мрежи_, --, --, 
   {{0xb24e4029,0x00000000,0x00000000,0x00000000}},	// [1130] _ཡིད_, --, --, --, 
   {{0xb2cac00d,0x3291201b,0x32d8c011,0xb4666011}},	//   _puede_, _ziya_, _orde_, _decembro_, 
   {{0x32d0001e,0xf4438011,0x22912004,0x00000000}},	//   _redanje__autor_, _tes_, _yiya_, --, 
   {{0xd200a01a,0x04308018,0xd3626011,0xabe1e006}},	//   _fleire_, _página__tente_, _no__ámbito_, _འཕྲིན__ཨང_, 
   {{0x72f88015,0x64624012,0x00000000,0x00000000}},	//   _kamar__mandi_, _nás__ak_, --, --, 
   {{0x9034400a,0x99572009,0x00000000,0x00000000}},	//   _गैलरी__समाचार_, _blandt__millione, --, --, 
   {{0xd521400a,0x00000000,0x00000000,0x00000000}},	//   _मुम्बई__मेरठ_, --, --, --, 
   {{0x8dd1800a,0xe3666012,0x00000000,0x00000000}},	//   _बनाएं_, _prejsť_, --, --, 
   {{0x534d2011,0x52aaa009,0x00000000,0x00000000}},	//   _sair__cambiar_, _købt_, --, --, 
   {{0xc291203f,0xb341a01a,0x00000000,0x00000000}},	//   _siya_, _det__vere_, --, --, 
   {{0xedff2003,0xd2c06025,0x00000000,0x00000000}},	//   _བགྲོ_, _médio_, --, --, 
   {{0x8f79200b,0x00000000,0x00000000,0x00000000}},	//   _umucaman, --, --, --, 
   {{0x12926015,0x00000000,0x00000000,0x00000000}},	//   _wisata_, --, --, --, 
   {{0x4e736002,0xd3f46016,0x1281e012,0x34bf0012}},	//   _јер_, _sitter_, _pridať__komentár, _zaregist_sa_, 
   {{0x800f8011,0x03f6200a,0x00000000,0x00000000}},	//   _correo__obrigato, _प्रदेश__उत्तराखं, --, --, 
   {{0x7325c00f,0x00000000,0x00000000,0x00000000}},	//   _kubonaka_sengathi_, --, --, --, 
   {{0xedbd0014,0x0f29e003,0x572e200c,0x00000000}},	// [1140] _दुर्योधन, _རྩོམ__འགྱུར_, _अपना__भाषा_, --, 
   {{0x53e96015,0xc834c00f,0x00000000,0x00000000}},	//   _menambah__wawasan_, _izimfund, --, --, 
   {{0xd24e4003,0xb469601a,0xfbacc003,0x00000000}},	//   _ཡིན_, _dei__to_, _ཅན__དང_, --, 
   {{0x6bdd000a,0xe3458012,0x222b4012,0x00000000}},	//   _यदि__आप_, _predmet_, _zoradiť_, --, 
   {{0x7f57400c,0x00000000,0x00000000,0x00000000}},	//   _जिनगी_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xf4ad001a,0xdb3e2012,0xf3d1400b,0x00000000}},	//   _ikkje__var_, _hodnotiť_, _ubutwari_, --, 
   {{0xf2428003,0x00000000,0x00000000,0x00000000}},	//   _བཅར_, --, --, --, 
   {{0xddaa0006,0x00000000,0x00000000,0x00000000}},	//   _ལྟོ__ཡོངས_, --, --, --, 
   {{0x39ebc002,0xdc092011,0x00000000,0x00000000}},	//   _коментар_који_, _tempada_, --, --, 
   {{0x41290002,0x029b8018,0x3a3c800c,0x30e8c00f}},	//   _доступан_, _boleto__bancário_, _लेल_, _nofakazi__bakajeho, 
   {{0x1bf12022,0xa2824030,0x00000000,0x00000000}},	//   _में__ना_, _pregled__budžetsk, --, --, 
   {{0xc20e2002,0xf2a6c003,0x6468200b,0x02bda03d}},	//   _када_, _བཞུགས__སྒར_, _murwa__mukuru_, _náhradní__díly_, 
   {{0x026c800f,0x82a86006,0x00000000,0x00000000}},	//   _jakobe_, _ཚན__ཚིག_, --, --, 
   {{0x8bcca013,0x753be018,0x00000000,0x00000000}},	//   _लगी_, _sugestõe, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x74426004,0xf2df400a,0x22b9c028,0x630a000b}},	// [1150] _mfo_, _आईटी_, _el__mejor_, _ibyo__ushaka_, 
   {{0x75e3a00e,0x0fef800c,0x00000000,0x00000000}},	//   _nejvyšší_, _शाहाबाद_, --, --, 
   {{0x22010040,0x025a000f,0x7cc7000f,0x00000000}},	//   _srbija_, _kahle_, _ndodana__yomuntu_, --, 
   {{0x14ab800b,0x00000000,0x00000000,0x00000000}},	//   _mbere__uko_, --, --, --, 
   {{0x0aa1a022,0x32e8400f,0x92e1400f,0x947e800b}},	//   _इतिहास__में_, _kudinga_, _kwenzeka__kanjani_, _kuri__iyi_, 
   {{0x387ce006,0x00000000,0x00000000,0x00000000}},	//   _འགྲུལ__འཕྲིན_, --, --, --, 
   {{0x598de004,0x612d6002,0x00000000,0x00000000}},	//   _ngokomze, _сајт_, --, --, 
   {{0x43d26030,0xd26e0003,0x00000000,0x00000000}},	//   _za__stranke_, _ཉེ__བའི_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xd2c1a011,0xfbe2400a,0x5bc3a00c,0x00000000}},	//   _os__nosos_, _तो__उस_, _आजु_, --, 
   {{0x2a3c800a,0x00000000,0x00000000,0x00000000}},	//   _लें_, --, --, --, 
   {{0xa465e030,0x72670002,0x00000000,0x00000000}},	//   _partije__bih_, _децу_, --, --, 
   {{0xf596c00f,0x00000000,0x00000000,0x00000000}},	//   _lesi__seluleko_, --, --, --, 
   {{0x8378e031,0xa3cea012,0x00000000,0x00000000}},	//   _silakan_, _začiatku_, --, --, 
   {{0xe3166015,0xdd8da00e,0x32d98012,0x00000000}},	//   _pribadi_, _televize_, _marec_, --, 
   {{0xd036c027,0x9291c02c,0xfe284015,0xcd838012}},	//   _ubytovan, _kuwa_, _otomatis_, _voči_, 
   {{0x03b8400b,0x79cb200a,0x00000000,0x00000000}},	// [1160] _yabwiye_, _चंदौली__चित्रकूट_, --, --, 
   {{0x0c67600a,0xe473a01a,0x93dd000f,0x01e3c002}},	//   _है__इसके_, _framsida__til_, _wezwe_, _се__односе_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xdbea200a,0x2b212002,0x00000000,0x00000000}},	//   _खबर__जानने_, _је__видели_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x8177401b,0xc3dd000f,0x2e21000a,0xea2f8002}},	//   _kulandel, _zezwe_, _जालौन_, _да__дели_, 
   {{0x6e2ee002,0x4ccf800e,0xb3dd000f,0x93348037}},	//   _за__више_, _opět_, _yezwe_, _de__taringa_, 
   {{0x92c7c003,0x00000000,0x00000000,0x00000000}},	//   _དེང__དུས_, --, --, --, 
   {{0x7586a00f,0x00000000,0x00000000,0x00000000}},	//   _lokho__okushiwo_, --, --, --, 
   {{0x9705800c,0x6307000c,0x00000000,0x00000000}},	//   _लेल__तैयार_, _कइले__बानी_, --, --, 
   {{0x4c65a01d,0x32afa003,0x841d0009,0x128bc00f}},	//   _justeru_, _གལ__ཆེན_, _en__genvej_, _bobabili_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x9be80006,0xefe68002,0x00000000,0x00000000}},	//   _འབྱོན__མི_, _стећи__свој_, --, --, 
   {{0x62f0a00b,0x1c01200e,0x2bc1000a,0x6b3bc003}},	//   _cyangwa__neza_, _prostor_, _लाइफ__स्_, _གད__སྙིགས_, 
   {{0xb38b602a,0xd9b9200f,0x0086c00e,0xac67800f}},	//   _vært_, _nojehova_, _nábytek_, _iphutha_, 
   {{0x0c4f000a,0x226cc00b,0x00000000,0x00000000}},	//   _इसके_, _nanone_, --, --, 
   {{0xc442800f,0x944c200b,0xabff000c,0xd276200f}},	// [1170] _ifa_, _mu__bihugu_, _आईएम_, _engu__uthi_, 
   {{0x1eb3001d,0x02bbe015,0x0f69001f,0x5b310006}},	//   _perminta_kepakara, _mandi__dalam_, _sepatutn, _ཡིག__རྫོང_, 
   {{0xa28a001d,0x64560012,0x00000000,0x00000000}},	//   _rundinga_usaha_, _prihlási_ak_, --, --, 
   {{0x73eac012,0x6292401f,0x00000000,0x00000000}},	//   _preto_, _petang_, --, --, 
   {{0xb4b16026,0x00000000,0x00000000,0x00000000}},	//   _ved__at_, --, --, --, 
   {{0xe44c202c,0x00000000,0x00000000,0x00000000}},	//   _mu__gihugu_, --, --, --, 
   {{0x7238c00e,0x00000000,0x00000000,0x00000000}},	//   _něj_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xbef8601d,0x01416022,0x00000000,0x00000000}},	//   _akan__menyerta, _नौटंकी_, --, --, 
   {{0xbad18021,0x3443e004,0x6450c00d,0x9cb1c00c}},	//   _དམིགས_, _get_, _nombre__de_, _में__बोले_, 
   {{0x52018039,0x72df0013,0x00000000,0x00000000}},	//   _mirip_, _उनकी_, --, --, 
   {{0x09a40002,0x7379e00f,0xbb5ec00c,0x00000000}},	//   _април_, _yilapho_, _कहलन_, --, 
   {{0x02ca000f,0x84f7800a,0x9ca5000b,0x59dcc002}},	//   _eside_, _है__अन्य_, _muri__gahunda_, _последиц, 
   {{0x9fb6600e,0x7ac3400c,0xc2684003,0x7ba7c003}},	//   _právě_, _ऐतिहासिक__रूप_, _ནམ__མཁའ_, _ཕྱི__དྲ_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xe2a04004,0x2a73200a,0x42cac012,0x00000000}},	//   _bubungqi_kuzo_, _सुझाव__विज्ञापन_, _vtedy_, --, 
   {{0x7e0d2002,0xe42aa00f,0x7bc8a00c,0x00000000}},	// [1180] _два_, _kubonisa__ukuthi_, _कवन__डर_, --, 
   {{0xfccf800e,0x4257e00e,0xb499e002,0x00000000}},	//   _zpět_, _půl_, _породице_, --, 
   {{0xe443e009,0xff83c002,0x00000000,0x00000000}},	//   _ret_, _бисте__слали_, --, --, 
   {{0xb342a01a,0x5720a014,0x00000000,0x00000000}},	//   _kan__vere_, _संस्कृत__भाषा_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xee030003,0x6e426002,0x2f162002,0x00000000}},	//   _ཚོར__འབྲེལ_, _је__са_, _доћи__до_, --, 
   {{0x2443e02a,0xdbad4003,0x00000000,0x00000000}},	//   _vet_, _ལྗོངས__ཕོ_, --, --, 
   {{0x39aa6002,0xbb468024,0x222a6002,0x00000000}},	//   _који_, _privatna_, _која_, --, 
   {{0xe4b1600b,0x00000000,0x00000000,0x00000000}},	//   _ihiganwa__rya_, --, --, --, 
   {{0x148f600d,0x2300600c,0x00000000,0x00000000}},	//   _de__mi_, _के__जरूरत_, --, --, 
   {{0xc2870003,0x738b601a,0x00000000,0x00000000}},	//   _དགའི__ཟིན_, _særs_, --, --, 
   {{0x1c4f200a,0x0a95c014,0x00000000,0x00000000}},	//   _उसके_, _जद__में_, --, --, 
   {{0x32d8400e,0x42d24012,0x64b36028,0x1300600c}},	//   _jsme_, _pred__dňami_, _perfecci_de_, _के__जरुरत_, 
   {{0xb4716009,0xa1c74002,0x00000000,0x00000000}},	//   _sig__at_, _да__примам_, --, --, 
   {{0x32c7201a,0x00000000,0x00000000,0x00000000}},	//   _fødde_, --, --, --, 
   {{0xb7ad4011,0x00000000,0x00000000,0x00000000}},	//   _obxectiv, --, --, --, 
   {{0x13e3a01a,0x00000000,0x00000000,0x00000000}},	// [1190] _av__desse_, --, --, --, 
   {{0x9ee1e00f,0xfbe5c012,0x9066200a,0x00000000}},	//   _ingxenye_, _priestor, _चुनाव__व्यापार_, --, 
   {{0xdc4e603e,0x00000000,0x00000000,0x00000000}},	//   _खाने_, --, --, --, 
   {{0x9bbfa006,0x7466c018,0x5af36003,0x91b8000c}},	//   _བརྒྱུད__མི_, _dezembro_, _སྒྲིག__འཛུགས_, _लीहल_, 
   {{0xd3796003,0x00000000,0x00000000,0x00000000}},	//   _དྲ__རྒྱའི_, --, --, --, 
   {{0x163f0012,0x34afa016,0x51800003,0x00000000}},	//   _komentár_, _mer__vis_, _བསྒྲིགས_, --, 
   {{0x0443e008,0x93f8c00f,0xf28ae01a,0x9c08c003}},	//   _teu_, _edlule_, _som__samlar_, _དམག__མི_, 
   {{0x848be00a,0x00000000,0x00000000,0x00000000}},	//   _प्रश्न__देवनागरी_, --, --, --, 
   {{0x3291800b,0xaba68006,0x9db4200f,0xc4b3e011}},	//   _misa_, _རྩིས__ཐོ_, _okungena, _posta__en_, 
   {{0x02f18011,0x3387400d,0xc200800b,0x1376c002}},	//   _unha__marca_, _suerte_, _mukino_, _српској_, 
   {{0x43f16009,0xe5cb600f,0x026e4003,0xcaa7600c}},	//   _din__søgning_, _kokuhlon_unkulunk, _དང__ལྷག_, _एगो__बात_, 
   {{0x1399e01d,0x0b97a012,0x00000000,0x00000000}},	//   _kerjaya__tawaran_, _zdieľať_, --, --, 
   {{0xb29e2003,0x1a52c008,0x7bdfe003,0x00000000}},	//   _བྱེད__ཀྱི_, _escribe__aquí_, _ཁྱིམ__ཁང_, --, 
   {{0xc46be00f,0x02a5e00f,0xe282000f,0x5a9f800c}},	//   _eneminya_engu_, _iminyaka__eminingi_, _wakhe__futhi_, _पऽ__नजर_, 
   {{0x82918015,0x32918018,0x748f6012,0xcb23a00a}},	//   _bisa_, _essas_, _ak__si_, _आकस्मिक__उपयोगकर्, 
   {{0x1413801d,0x4d352002,0xae8d2002,0x00000000}},	//   _kristian_, _везе__уреди_, _за__младе_, --, 
   {{0x3313c012,0x00000000,0x00000000,0x00000000}},	// [11a0] _odobrať__všetko_, --, --, --, 
   {{0xd2a30003,0xcae54006,0x00000000,0x00000000}},	//   _ཀྱི__སྐད_, _ལེབ__གྲོགས_, --, --, 
   {{0x2ef4c002,0x2467a01a,0x00000000,0x00000000}},	//   _које__је_, _dei__kan_, --, --, 
   {{0xa9f66018,0x00000000,0x00000000,0x00000000}},	//   _serão_, --, --, --, 
   {{0xc3d60011,0x6996200f,0xcb62e012,0xebcac00c}},	//   _recibe__aviso_, _ukuhlola_, _registro_porovnať_, _बाबू__के_, 
   {{0x330d201d,0x00000000,0x00000000,0x00000000}},	//   _pelayar_, --, --, --, 
   {{0xac6c4045,0xa3ea4015,0x4d5a6002,0x5c0a2003}},	//   _dakujem_, _kebijaka_privasi_, _горе_, _ཚིགས__ཨེ_, 
   {{0x02ca6009,0x6c770002,0x00000000,0x00000000}},	//   _trods_, _оних_, --, --, 
   {{0x7950600f,0x00000000,0x00000000,0x00000000}},	//   _esilande, --, --, --, 
   {{0xb29ce01a,0x321c6009,0xec0bc00c,0x00000000}},	//   _navigeri_søk_, _aarhus_, _करावे__के_, --, 
   {{0xeb37a003,0x02a78003,0xdfc2e002,0x00000000}},	//   _མི__འདུག_, _རང__གིས_, _француск_немачки_, --, 
   {{0x76be4012,0xa48f601a,0x00000000,0x00000000}},	//   _súťaž_, _ei__tid_, --, --, 
   {{0xf29fa009,0x00000000,0x00000000,0x00000000}},	//   _finansie_info_, --, --, --, 
   {{0x7d8ca00f,0x3c72c003,0xfb92e003,0x00000000}},	//   _esidlule_, _བཅུའི_, _ཡིག__ནག_, --, 
   {{0x67d0c002,0x5874e00f,0x02914006,0x00000000}},	//   _много_, _izinkulu, _འབདཝ__ཨིན_, --, 
   {{0xe80e800a,0x4e19000c,0x00000000,0x00000000}},	//   _देखें__क्रियाएँ_, _उद्बोधन_, --, --, 
   {{0x83f8600e,0x3a3ec00c,0x00000000,0x00000000}},	// [11b0] _jsou_, _नहि_, --, --, 
   {{0x3c80c00a,0x00000000,0x00000000,0x00000000}},	//   _कैसे__करें_, --, --, --, 
   {{0x8224201a,0x3e016002,0x00000000,0x00000000}},	//   _fekk_, _izveštaj, --, --, 
   {{0x0c41a019,0x5ec20002,0x00000000,0x00000000}},	//   _kjærligh, _војске_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xfbe1000c,0x9368400b,0x00000000,0x00000000}},	//   _बिहार__से_, _yatanze__imihoho_, --, --, 
   {{0x3da90039,0x2fffc00f,0xc316000b,0xcf578002}},	//   _fasilita, _kwakukho, _mwiza_, _такмичи_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x841ba002,0xb181a00e,0x00000000,0x00000000}},	//   _sve__vesti_, _nákupní_, --, --, 
   {{0x29f96009,0x00000000,0x00000000,0x00000000}},	//   _relatere, --, --, --, 
   {{0x55f52018,0x0990c00f,0x00000000,0x00000000}},	//   _diferenç, _imikhuba_, --, --, 
   {{0x52924004,0x830f601d,0xd470e018,0xa2da600b}},	//   _mntana_, _berbeza_, _tem__que_, _kureba_, 
   {{0x024ec006,0x1316000b,0x00000000,0x00000000}},	//   _ཨིན_, _bwiza_, --, --, 
   {{0xb323e01a,0x12f7800e,0x00000000,0x00000000}},	//   _denne__gongen_, _hmotnost__méně_, --, --, 
   {{0xa26c0012,0x00000000,0x00000000,0x00000000}},	//   _dlho_, --, --, --, 
   {{0xe2bec022,0x0b9be00c,0x00000000,0x00000000}},	//   _कहां_, _के__ओर_, --, --, 
   {{0x92378015,0xe4522009,0xfaabe012,0x00000000}},	// [11c0] _menemuka_topik_, _sidste__år_, _základné_, --, 
   {{0x64c5e009,0x2ba4200c,0x00000000,0x00000000}},	//   _lige__så_, _अर्थव्यव_पऽ_, --, --, 
   {{0xad28c01a,0x1b35400f,0x26bce002,0x00000000}},	//   _liknande_, _ukuthi__ukuphila_, _разговор_, --, 
   {{0x3307400d,0x00000000,0x00000000,0x00000000}},	//   _que__hace_, --, --, --, 
   {{0xd444403f,0x82cac002,0x00000000,0x00000000}},	//   _ke_, _sreda_, --, --, 
   {{0x5dc8e00b,0x93eac018,0x00000000,0x00000000}},	//   _inshinga, _preta_, --, --, 
   {{0xa2aa0003,0x2c24800c,0x7706400a,0x38628003}},	//   _གི__བོད_, _से__एगो_, _मज़ाक__विचार_, _བཟང__འཕྲིན_, 
   {{0x7669a046,0xde07600b,0x7b7ec003,0x00000000}},	//   _सम्पादन__इतिहास_, _ba__karidina, _པའི__གླེང_, --, 
   {{0x465be002,0x00000000,0x00000000,0x00000000}},	//   _албански__арапски_, --, --, --, 
   {{0xc321600d,0xf371001f,0x00000000,0x00000000}},	//   _gracias_, _atas__dengan_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xfbac2022,0xff9ea012,0xd46ae025,0x00000000}},	//   _माध्यम__से_, _okres__bratisla, _com__ele_, --, 
   {{0x531ec019,0xe4686009,0x45a9000e,0xc4ade005}},	//   _egentlig_, _tilføj__til_, _formulář_, _drive__av_, 
   {{0x5eb68017,0xea66600a,0x465ba00f,0x6da08003}},	//   _zobrazit_, _इसके__बाद_, _amakrist_agcotshi, _རྒྱ__རིགས_, 
   {{0x1e19c002,0xd2c78006,0x7c7c401a,0x00000000}},	//   _београд_, _ཚོགས__ཁྲི_, _startar_, --, 
   {{0x74444004,0x2b8e403a,0x0bd26003,0x3c5b600f}},	//   _ee_, _ཆབ_, _ཀླད__ནང_, _komunye_, 
   {{0x22ba400d,0xfbc3200a,0xe1e2800c,0xa9488002}},	// [11d0] _la__mejor_, _होने__से_, _जेकरा_, _унесите_, 
   {{0x2d8fa003,0x00000000,0x00000000,0x00000000}},	//   _ཚིགས_, --, --, --, 
   {{0x628ca00b,0x00000000,0x00000000,0x00000000}},	//   _abahutu_, --, --, --, 
   {{0x94704024,0x625a401a,0x7e50e00f,0x04696027}},	//   _privatna__poruka_, _samla_, _amaphuzu_, _aby__som_, 
   {{0xb444400b,0x6c5b600f,0x599b800f,0x00000000}},	//   _ye_, _nomunye_, _abakhule, --, 
   {{0x0bad4020,0x00000000,0x00000000,0x00000000}},	//   _ཁབ__ནང_, --, --, --, 
   {{0x2342001a,0xb47da00a,0x00000000,0x00000000}},	//   _ein__liten_, _पन्ना_, --, --, 
   {{0x93422011,0x2972600e,0x00000000,0x00000000}},	//   _goberno_, _ostření_, --, --, 
   {{0x21d6400a,0x00000000,0x00000000,0x00000000}},	//   _का__मेडल_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xfdf40037,0xc5cb4018,0xba1e0002,0x7dcfc003}},	//   _tiempo__aproxima, _de__informaç, _чини_, _གཏམ__ཚོགས_, 
   {{0xa3e58012,0x00000000,0x00000000,0x00000000}},	//   _vyhraden_vykonáva_, --, --, --, 
   {{0x2e28e002,0x1b2f8029,0xa289c003,0x00000000}},	//   _ла_, _ཕྲེང_, _རིང__བོད_, --, 
   {{0x13268009,0x7be26006,0xdf82c002,0x191fc003}},	//   _at__tage_, _དྲུང__ངག_, _сваки_, _བརླག_, 
   {{0xc2eec012,0x00000000,0x00000000,0x00000000}},	//   _sa__však_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x24b1801e,0x42728012,0x00000000,0x00000000}},	// [11e0] _stare__svi_, _jún_, --, --, 
   {{0x1a52000b,0xab7ea012,0x92428003,0x00000000}},	//   _birebana_, _sukromna_, _བཅོ_, --, 
   {{0x40e3c00f,0xfc0a800c,0x4c08a00c,0x00000000}},	//   _ezingcol, _पटना__से_, _कवना__तरे_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x82678002,0x3287401a,0x12a66009,0x00000000}},	//   _dan__sati_, _og__ikkje_, _højere_, --, 
   {{0x92aca006,0x42502002,0x00000000,0x00000000}},	//   _སྡེ__སྦི_, _чега_, --, --, 
   {{0x76c9000e,0x0e782002,0x00000000,0x00000000}},	//   _součástí_, _центар__за_, --, --, 
   {{0xebc0a00a,0xb994c012,0xebf64014,0x00000000}},	//   _करने__के_, _môže_, _संगीत__के_, --, 
   {{0xb181a012,0xa15cc002,0x0a71000a,0x00000000}},	//   _nákupný_, _љубав_, _वर्ष__में_, --, 
   {{0x47f92002,0x16032002,0x00000000,0x00000000}},	//   _велике_, _толико_, --, --, 
   {{0x6e9e6018,0xa4bd000a,0x00000000,0x00000000}},	//   _deve__adiciona, _पृष्ठ__स्थायी_, --, --, 
   {{0x0bdd8006,0xea38a006,0x00000000,0x00000000}},	//   _འདི__ལུ_, _མར__ཐཱའི_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x52e9001d,0x32266015,0xa7e7c002,0x00000000}},	//   _syaitan_, _berkas_, _србима_, --, 
   {{0xaacf8003,0xd4902018,0x197e2002,0x6be4000a}},	//   _ཕྲུག_, _em__sua_, _група_, _कॉमेंट__खोजने_, 
   {{0x3291e034,0x0d35c002,0x00000000,0x00000000}},	//   _lita_, _на__косову_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [11f0] --, --, --, --, 
   {{0xbbae4003,0x00000000,0x00000000,0x00000000}},	//   _དྲང__སྲོང_, --, --, --, 
   {{0xc49e2011,0xebc8200c,0x00000000,0x00000000}},	//   _teu__enderezo_, _गाधिवंश__के_, --, --, 
   {{0xa4444015,0x1be72013,0x00000000,0x00000000}},	//   _gambar__rp_, _और__एक_, --, --, 
   {{0x382e2002,0xc338a03d,0x80ec4009,0x20ae2002}},	//   _први_, _zdraví_, _bedømmel, _прва_, 
   {{0x2dc56015,0x00000000,0x00000000,0x00000000}},	//   _semoga__bermanfa, --, --, --, 
   {{0xe4a12037,0x0bee0002,0x4291000b,0x8bcc400a}},	//   _escribe__tu_, _иако_, _gacaca_, _आती_, 
   {{0x6648e00b,0xaf4f800b,0x00000000,0x00000000}},	//   _yishingi, _ubushaka, --, --, 
   {{0x2b9f2014,0x0515000a,0x00000000,0x00000000}},	//   _के__स्_, _वडोदरा_, --, --, 
   {{0xd49a6011,0x00000000,0x00000000,0x00000000}},	//   _galicia__que_, --, --, --, 
   {{0x3493e034,0xe2e9c011,0x00000000,0x00000000}},	//   _bygger__på_, _as__túas_, --, --, 
   {{0xc300601a,0xec0ae00c,0x9a8ea00f,0xe82c6002}},	//   _samband_, _ममता__के_, _noma__ngaphezu, _поставља, 
   {{0x6f9a200f,0x00000000,0x00000000,0x00000000}},	//   _ngemva__kwesikha, --, --, --, 
   {{0x1f072018,0xa09d8003,0x7470e00b,0x2edbc002}},	//   _disponív, _སྨྲ_, _iyi__si_, _све__је_, 
   {{0x2c3e8033,0x644ee008,0x92dec012,0x00000000}},	//   _se__komentir, _lector__de_, _pánske_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x630e800f,0x4ec72002,0x8cba200a,0x00000000}},	// [1200] _ezizweni_, _земљи_, _दिसम्बर__नवम्बर_, --, 
   {{0xec4e000c,0x225b401a,0x5d4e800e,0x7479400f}},	//   _काहे_, _spelar_, _přesně_, _kungase__kudingek, 
   {{0x6c3b6012,0x00000000,0x00000000,0x00000000}},	//   _súhlasu_, --, --, --, 
   {{0x2bccc00c,0xa291e012,0x170ea012,0x00000000}},	//   _एगो_, _sita_, _začiatok_, --, 
   {{0x5f9c6037,0xfbf1c00c,0xf5fe4013,0x00000000}},	//   _ofensivo__publicar_, _बा__तऽ_, _कीबोर्ड_, --, 
   {{0xd2e9c011,0xa387e00b,0xd2a38003,0x8f538002}},	//   _as__súas_, _ijuru_, _པའི__སྐད_, _ми__смо_, 
   {{0x52a68018,0x828e2003,0xee378002,0x00000000}},	//   _pelo__menos_, _གཞས__ཚིག_, _успео__да_, --, 
   {{0xe39aa00e,0x5320a012,0x8bdb400a,0xc3e32018}},	//   _města_, _izby_, _आपत्ति__का_, _em__nossa_, 
   {{0x32a8e011,0x5fc40012,0x00000000,0x00000000}},	//   _en__acolle_, _šírenie_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x42984012,0x00000000,0x00000000,0x00000000}},	//   _dňami_, --, --, --, 
   {{0xea3dc022,0x2c06000c,0x00000000,0x00000000}},	//   _सेफ_, _आधार__पऽ_, --, --, 
   {{0xc295c021,0x00000000,0x00000000,0x00000000}},	//   _བསྟུན__པའི_, --, --, --, 
   {{0xe396000e,0x00000000,0x00000000,0x00000000}},	//   _napsat_, --, --, --, 
   {{0x93eb800d,0x7c108002,0xd3b08011,0x00000000}},	//   _gusta_, _не__само_, _teu__correo_, --, 
   {{0xa28fc003,0x9bdea006,0x00000000,0x00000000}},	//   _བོད__དོན_, _མཛོད__ལས_, --, --, 
   {{0xc2a8e003,0x57564003,0x2eebe002,0x00000000}},	// [1210] _ཤེས__རིག_, _ཁྲིམས__སྲིད_, _изјавио__је_, --, 
   {{0x24c2401a,0xa3f3a005,0xfbcc4013,0xb051e002}},	//   _vatn__og_, _ved__svar_, _आते_, _освоји_, 
   {{0x1bf58015,0xd396600f,0x3342e00e,0x8baa200c}},	//   _luas__bangunan_, _akusho_, _vnitřní_, _कि__का_, 
   {{0x52366012,0x3c03a00c,0x00000000,0x00000000}},	//   _svoju_, _लोग__एह_, --, --, 
   {{0xe422e015,0x42b0600d,0x1657c00b,0x00000000}},	//   _email__untuk_, _muy__bien_, _umuryang_abibumby, --, 
   {{0x760d6011,0x48f92011,0xb46c6018,0x00000000}},	//   _ecolóxic, _dereitos__reservad, _com__em_, --, 
   {{0xdda3a003,0x00000000,0x00000000,0x00000000}},	//   _ཁམས__སྐྱེ_, --, --, --, 
   {{0xed93602d,0x43432009,0xa2aa8003,0x00000000}},	//   _listopad_, _anmeld__misbrug_, _པར__བོད_, --, 
   {{0x4163c002,0x67e3c002,0x6689c00c,0x00000000}},	//   _година_, _години_, _के__पसंद_, --, 
   {{0xe9a5e012,0xfde5e012,0x00000000,0x00000000}},	//   _diskusia_, _diskusie_, --, --, 
   {{0xec0b600c,0x426e800f,0x00000000,0x00000000}},	//   _राजा__के_, _kube__manje_, --, --, 
   {{0x94b72015,0xdd0c000b,0x53700002,0x32914018}},	//   _topik__apa_, _abantu__abarorer, _википеди_слободне_, _safada_, 
   {{0x5d4fa00e,0x3ceaa003,0x00000000,0x00000000}},	//   _včetně_, _འགུལ__འཚོལ_, --, --, 
   {{0xe26e600b,0x99e3c012,0xcb8c8003,0x874f200a}},	//   _serivisi_, _zoradiť__podľa_, _ནོ_, _पिथौरागढ_पौड़ी_, 
   {{0x7474600b,0xe230600f,0x00000000,0x00000000}},	//   _bahungiy_mu_, _lapho__kufika_, --, --, 
   {{0xebe8a006,0x63fa400b,0xe42ca00f,0x62bf200c}},	//   _སྐྲུན__གི_, _gutuma_, _qiniseka__ukuthi_, _अहां_, 
   {{0x025aa01d,0x8bba4006,0xd204c00f,0xf178400a}},	// [1220] _majlis_, _ལས__ཁས_, _yesibili_, _फिरोज़पु_बठिंडा_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa3966007,0x3468c01a,0x00000000,0x00000000}},	//   _kursus_, _sjå__på_, --, --, 
   {{0x62da4018,0x04912017,0x00000000,0x00000000}},	//   _úteis_, _vč__dph_, --, --, 
   {{0xa4cb8013,0x00000000,0x00000000,0x00000000}},	//   _चाहिये_, --, --, --, 
   {{0xf2da600d,0xc290e018,0xfdfe4003,0xb89c4003}},	//   _prueba_, _seu__não_, _གཞོན__སྐྱེས_, _ཚིགས__འབྲི_, 
   {{0xe0c1c002,0xea77600c,0xee9ec002,0x00000000}},	//   _услове_, _गइल__होई_, _хоће__да_, --, 
   {{0x4ec26002,0xb46c6018,0x8fe8a00f,0xc54ac00a}},	//   _свиђа__ми_, _com__um_, _izinto__ezingoko, _लखनऊ__दुनिया_, 
   {{0xac4e8014,0xdd904003,0x00000000,0x00000000}},	//   _जाले_, _ཁྱབ__ཁོངས_, --, --, 
   {{0x2cf70014,0xa24b4003,0x00000000,0x00000000}},	//   _रेल__मंत्री_, _ཉིན__བོད_, --, --, 
   {{0x8d95e003,0x00000000,0x00000000,0x00000000}},	//   _གཞུང__ལུགས_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xb522c018,0xb2c9e01d,0x936ee01a,0x029a0006}},	//   _nome__opcional_, _dengan__resolusi_, _artikkel_bygger_, _སྦས__གནས_, 
   {{0x627e201a,0xd3dd8018,0xadb4e002,0x00000000}},	//   _rekna_, _além__disso_, _али__су_, --, 
   {{0xe0ecc00e,0xec58e00a,0x00000000,0x00000000}},	//   _hodnocen_hvězdičk, _के__पहले_, --, --, 
   {{0x8309a015,0x14242007,0x73190012,0xd2670002}},	// [1230] _juga__bisa_, _ini__sesuai_, _osobných__údajov_, _везу_, 
   {{0xc3508016,0x00000000,0x00000000,0x00000000}},	//   _bruk__annet_, --, --, --, 
   {{0xf4b66018,0x00000000,0x00000000,0x00000000}},	//   _muito__bom_, --, --, --, 
   {{0xb386e011,0xd29fc003,0x00000000,0x00000000}},	//   _venres_, _བློན__ཁྲི_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x8a78e00a,0xe4b0e009,0x814dc002,0x62cdc002}},	//   _उन्होंने__कहा_, _vej__til_, _избори_, _избора_, 
   {{0x07820014,0x234c800f,0x00000000,0x00000000}},	//   _लाभार्थि, _kufanele__sibe_, --, --, 
   {{0x0c4e2014,0x1b94c00a,0xd2a38003,0x00000000}},	//   _चाहे_, _अलग__दिखने_, _གྱི__སྐད_, --, 
   {{0xd4906025,0x938b2010,0x00000000,0x00000000}},	//   _em__que_, _søren_, --, --, 
   {{0xddae201d,0xad320011,0xb2f8a00f,0xc2ad0006}},	//   _mengikut_, _calidade_, _noma__ubani_, _འབྲེལ__འབད_, 
   {{0xe38c2002,0x3d64000b,0x4b984003,0xfd18e00c}},	//   _буде_, _giharwe__icyumwer, _གླིང__ལོ_, _के__महुआ_, 
   {{0xfb64a034,0xe606000f,0xee67000c,0x00000000}},	//   _lisensen_, _lokho__unkulunk, _खातिर__पर्यटको_, --, 
   {{0xc77d200c,0x8734000c,0x00000000,0x00000000}},	//   _बाकिर__ओकरा_, _कवनो__अपना_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x8c7f400b,0x00000000,0x00000000,0x00000000}},	//   _cumi__ibiganir, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xb712a011,0x00000000,0x00000000,0x00000000}},	// [1240] _dispoñib, --, --, --, 
   {{0xc6d1c004,0xa541000c,0x00000000,0x00000000}},	//   _ziya__kuvakali, _संडे__इंडियन_, --, --, 
   {{0x14bd0011,0x2b81a012,0x00000000,0x00000000}},	//   _proxecto_, _sledovať_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x0a83c014,0x0bcda00a,0xe6364011,0xc42e400f}},	//   _काम__में_, _मित्र__को_, _galipedi, _eminyake_engu_, 
   {{0xa2ab0003,0x00000000,0x00000000,0x00000000}},	//   _བར__བོད_, --, --, --, 
   {{0x210be00c,0x12982003,0x00000000,0x00000000}},	//   _के__बसावल_, _ཕྲུག__ནགས_, --, --, 
   {{0xb3cec01a,0x05000002,0x62cf000e,0x00000000}},	//   _gjev_, _није__било_, _na__seznam_, --, 
   {{0x5ddbc012,0x00000000,0x00000000,0x00000000}},	//   _základe_, --, --, --, 
   {{0x52428021,0x12ec0002,0x00000000,0x00000000}},	//   _དཔར_, _углавном_, --, --, 
   {{0x12c56038,0xc2b0e018,0x21dfe00c,0x00000000}},	//   _comentar__esta_, _eu__não_, _उनकर_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xfbdfe012,0x3253000f,0xfd8fc003,0x00000000}},	//   _aplikáci, _unkulunk_wethu_, _དྲིས_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xe25a401a,0x0490201a,0x626dc02c,0xb202400b}},	//   _kalla_, _at__ein_, _imvo_, _patiri_, 
   {{0xc468e02a,0x72d7000e,0xd2b20003,0x00000000}},	//   _deg__en_, _kč__obchodu_, _རི__བའི_, --, 
   {{0x450fa01d,0x5a51a00f,0xa2504020,0xb278e00b}},	// [1250] _komersil_, _mayelana_, _ཚན__རྩོམ_, _miliyoni_, 
   {{0x0d73c002,0x02d40003,0x00000000,0x00000000}},	//   _територи, _དཀར__ལྷག_, --, --, 
   {{0x1d8fe003,0xd200c01d,0x3b538037,0x0a56c00c}},	//   _བྲིས_, _talian_, _página__completa_, _कर__में_, 
   {{0xe496e00d,0x00000000,0x00000000,0x00000000}},	//   _no__es_, --, --, --, 
   {{0x947f800b,0x00000000,0x00000000,0x00000000}},	//   _muri__iyi_, --, --, --, 
   {{0x2b9c800a,0x2ef9c002,0x00000000,0x00000000}},	//   _के__घर_, _недавно_, --, --, 
   {{0xe2fea00f,0x8ec46011,0x00000000,0x00000000}},	//   _bathole_, _liñas_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xf491801b,0xd473a018,0x37c7c002,0x00000000}},	//   _le__nto_, _sexta__das_, _називи_, --, 
   {{0x23382009,0xbb616012,0xebe30003,0xe46ea01a}},	//   _læs__mere_, _bystrica_, _ཕྲུག__གི_, _tilskot__til_, 
   {{0xcc4e8048,0xc4b2401a,0x030fc00f,0x00000000}},	//   _जाते_, _nokre__av_, _sombuso_, --, 
   {{0xea66e00a,0x821fa00b,0x6226600c,0x00000000}},	//   _उसके__बाद_, _munani__michel_, _में__खयाल_, --, 
   {{0xc498e00d,0x00000000,0x00000000,0x00000000}},	//   _categorí_en_, --, --, --, 
   {{0xa290e01d,0x9a474018,0x298e0002,0x59df2012}},	//   _sahaja_, _se__você_, _затим_, _známemu_, 
   {{0x14980012,0x00000000,0x00000000,0x00000000}},	//   _to__čo_, --, --, --, 
   {{0x5a4dc00c,0x00000000,0x00000000,0x00000000}},	//   _के__मौत_, --, --, --, 
   {{0x2a1e6002,0xb291a012,0x00000000,0x00000000}},	// [1260] _бити_, _tovaru_, --, --, 
   {{0x83540012,0x00000000,0x00000000,0x00000000}},	//   _všetky_, --, --, --, 
   {{0x6b00a002,0x43224012,0x2855200b,0xe2afe003}},	//   _септемба_август_, _štyri_, _nama__idasanzw, _བླ__མའི_, 
   {{0x7b882013,0x2b5b400a,0x00000000,0x00000000}},	//   _ने_, _जानो__पर्यटन_, --, --, 
   {{0x8f1be002,0xa25a400e,0x00000000,0x00000000}},	//   _од__њих_, _než__hodin_, --, --, 
   {{0x8290c01e,0x3320400e,0x0dc8200a,0xf200400e}},	//   _allahu_, _byly_, _रुपए_, _byli_, 
   {{0x5b924021,0x82e3c00b,0x00000000,0x00000000}},	//   _གི__རྫོང_, _muri__yombi_, --, --, 
   {{0x22aee01e,0x7988602a,0x0c14a00a,0x00000000}},	//   _ve__sellem_, _innholde, _दिया__था_, --, 
   {{0xf427c011,0xb3cfa028,0xd396400e,0x00000000}},	//   _todo__texto_, _leer__más_, _zkuste_, --, 
   {{0x5b6e200f,0xd46f0027,0x0166000b,0x32b6800f}},	//   _ukuthola_, _tak__ako_, _ubushobo, _kube__khona_, 
   {{0xd37fc008,0xd477801d,0xe2428029,0x75258018}},	//   _comarca_, _pukul__ptg_, _བཅད_, _aparelho_, 
   {{0x2681800c,0x00000000,0x00000000,0x00000000}},	//   _रचनाक_, --, --, --, 
   {{0x7438a011,0x0b24800c,0x00000000,0x00000000}},	//   _en__canto_, _लोक__संस्कृति_, --, --, 
   {{0x28a48014,0x00000000,0x00000000,0x00000000}},	//   _कौन__बनेगा_, --, --, --, 
   {{0x1f94400e,0xeb99c022,0x645d0018,0x00000000}},	//   _jméno_, _परिषद__के_, _navegaçã, --, 
   {{0xd47a200b,0x00000000,0x00000000,0x00000000}},	//   _uburenga_bw_, --, --, --, 
   {{0x4b67c00c,0xd395600f,0xc2990003,0x00000000}},	// [1270] _के__शासन_, _amasha_, _འདོད__པའི_, --, 
   {{0x2dacc01d,0x9b3ba003,0xf1f28002,0x00000000}},	//   _perniaga, _གཡུང__དྲུང_, _више__вести_, --, 
   {{0x20eec022,0x4dad201d,0xbf006012,0xe2d90012}},	//   _गांव_, _kesilapa, _na__porovnan, _chcela_, 
   {{0x5d726002,0x5242a003,0x00000000,0x00000000}},	//   _да__их_, _དུར_, --, --, 
   {{0x005de00c,0x00000000,0x00000000,0x00000000}},	//   _नइखे__बलुक_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xb990a008,0x8a56200a,0xef11000a,0x00000000}},	//   _para__imprimir_, _इस__पेज_, _जीतिए__मास्टरमा, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xae030012,0xec09e00c,0xc28e6003,0x00000000}},	//   _každý__deň_, _प्रथम__के_, _གཏམ__ཡིག_, --, 
   {{0xe2a1000b,0x018c6022,0xfb7b2003,0x627b2003}},	//   _bbc__izindi_, _सरोवर_, _ཀའི__སྟེང_, _གཙང__བཟོ_, 
   {{0xd3404024,0x00000000,0x00000000,0x00000000}},	//   _nedelja_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x827e2045,0x6bdde003,0x1d094003,0x00000000}},	//   _pekne_, _ཤིན__ཏུ_, _ཞི__རྒོལ_, --, 
   {{0x3998a004,0x4778a032,0x26bb400c,0x00000000}},	//   _ngokwene, _ngokweng, _मेहरारू__बिहार_, --, 
   {{0xda000015,0x56628002,0x00000000,0x00000000}},	//   _kayaknya_, _проблем__спам_, --, --, 
   {{0xc3448019,0xe27d800f,0x53088011,0xaee3000a}},	//   _blant__annet_, _kodwa__futhi_, _publicad_nome_, _अम्बेडकर_अलीगढ़_, 
   {{0x3a3de022,0x6ad6e00e,0xe42ba00f,0x00000000}},	// [1280] _देस_, _předchoz_další_, _wabonisa__ukuthi_, --, 
   {{0xffa5401d,0x8ff96011,0xf3ea8012,0x00000000}},	//   _disember_, _aloxamen, _zajtra_, --, 
   {{0xe5b3e00e,0x04aa601a,0x92a04003,0xe200800b}},	//   _nejlepší_, _ein__som_, _ཆག__གཙོ_, _rukiko_, 
   {{0x7a6ea00c,0x00000000,0x00000000,0x00000000}},	//   _युवा__कवि_, --, --, --, 
   {{0x4394e00f,0xa21c203d,0xbdc5a009,0xebf0e00c}},	//   _elisha_, _druhé_, _indlæg__tilmeldt_, _गरीब__के_, 
   {{0xb4976013,0x626c6004,0x5bb9c002,0x00000000}},	//   _जम्मू_, _kuloo_, _математи, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x846fc00e,0x6bc1400a,0x324e4003,0x00000000}},	//   _tomto__webu_, _करते__थे_, _རམས_, --, 
   {{0x900a000a,0xa29e2003,0x00000000,0x00000000}},	//   _होम__समाचार_, _བཅུ__འདི_, --, --, 
   {{0x32ca8017,0x6bdd400a,0x00000000,0x00000000}},	//   _snad_, _के__सभी_, --, --, 
   {{0xe489403c,0xe9954009,0x00000000,0x00000000}},	//   _natrag__na_, _projekte, --, --, 
   {{0x0be18006,0x00000000,0x00000000,0x00000000}},	//   _རྟེན__རབ_, --, --, --, 
   {{0x63954024,0x67dd600c,0x00000000,0x00000000}},	//   _umesto_, _शोध__संस्थान_, --, --, 
   {{0x0406c016,0x00000000,0x00000000,0x00000000}},	//   _kontroll_før_, --, --, --, 
   {{0xd30c801d,0xe2cf600b,0xa9c66002,0x228ea002}},	//   _setakat_, _muri__ukwa_, _одговора__унесите_, _додај__нову_, 
   {{0x27e64022,0xc46c4016,0x1cde6003,0x00000000}},	//   _शिवराज_, _klage__en_, _ཚོའི__སྐོར_, --, 
   {{0x5c61a00a,0x00000000,0x00000000,0x00000000}},	// [1290] _को__अपडेट_, --, --, --, 
   {{0x92f44011,0x00000000,0x00000000,0x00000000}},	//   _dixital_, --, --, --, 
   {{0xd3276009,0x748a400b,0xf2ac2003,0x00000000}},	//   _at__have_, _hagati__mu_, _བར__ཞོག_, --, 
   {{0xe490e01a,0x00000000,0x00000000,0x00000000}},	//   _ei__du_, --, --, --, 
   {{0xd2d8601e,0x1be4600c,0x00000000,0x00000000}},	//   _opštinam, _से__गो_, --, --, 
   {{0x9b4b0006,0x17700006,0xc2726006,0x46852002}},	//   _པོ__འཇིགས_, _ལུ__མཆོད_, _ཡུ__ནའི_, _русије_, 
   {{0x6dea2002,0x13276009,0xee93a00f,0xcc0e800a}},	//   _јул__јун_, _at__lave_, _ngomthan, _पहले__ही_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x246cc00b,0xbba0c01c,0xebfbc00a,0x00000000}},	//   _avuga__ko_, _है__ये_, _यूपी__के_, --, 
   {{0xb2e3000b,0xa4aae019,0xe2cb001f,0x179a2003}},	//   _buenos__aires_, _det__ble_, _luar__negara_, _སྤུན_, 
   {{0xe3010009,0x00000000,0x00000000,0x00000000}},	//   _tilbage_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xbdc66002,0x8bc6c00a,0x00000000,0x00000000}},	//   _lak__jednosta, _सिद्धार्_का_, --, --, 
   {{0x13c7400b,0xe283000f,0x00000000,0x00000000}},	//   _ka__ruhango_, _yakhe__futhi_, --, --, 
   {{0xd2fe6009,0x66b94014,0xa3968002,0x00000000}},	//   _bruger_, _के__बहुत_, _са__косова_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x53cba039,0xb3fa400b,0x00000000,0x00000000}},	// [12a0] _di__jakarta_, _bituma_, --, --, 
   {{0xca32a014,0xcc2a6002,0xc0ee6003,0x3d9fc003}},	//   _गढ़_, _историјс, _གིས__རྒྱ_, _བརྗེ_, 
   {{0x62d8c026,0xca3de014,0x00000000,0x00000000}},	//   _lyder_, _देल_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xe0208030,0x13eac00f,0x00000000,0x00000000}},	//   _opštinam_izdvajan, _inothi_, --, --, 
   {{0xc44f601e,0xd6f8a014,0xb291e01d,0x3adc6012}},	//   _postao__la_, _सीधा_, _ustaz_, _vrátane_, 
   {{0xd316e004,0x847ae012,0xf251c003,0x00000000}},	//   _ilizwi_, _azet__sk_, _ཡིན__ཟེར_, --, 
   {{0x22c72009,0x62da6018,0xc2ab8003,0x00000000}},	//   _møder_, _direto_, _རབ__ཟིན_, --, 
   {{0x7335c037,0x00000000,0x00000000,0x00000000}},	//   _dato__erróneo_, --, --, --, 
   {{0xc3056015,0x1468a01a,0xd2eb2045,0x82912011}},	//   _tidur__kamar_, _dei__har_, _samozrej, _deixar__unha_, 
   {{0x6471e011,0x00000000,0x00000000,0x00000000}},	//   _decembro__de_, --, --, --, 
   {{0xf468c015,0x7ba58003,0x72fe801a,0x00000000}},	//   _topic__kamu_, _སྐོར__དྲ_, _eller__anna_, --, 
   {{0x23088018,0x59bf400e,0x026f2003,0x48d2200c}},	//   _aqui__para_, _naleznet, _སྐབས__གསུམ_, _नाम__भोजपुर_, 
   {{0xb650200d,0x1be6a013,0xebcf400c,0x0d00800e}},	//   _ubicació, _से__एक_, _बनावे__के_, _podmínek_, 
   {{0xc2780039,0x00000000,0x00000000,0x00000000}},	//   _pengirim, --, --, --, 
   {{0x322ee002,0xc2b72014,0x00000000,0x00000000}},	//   _pre__godinu_, _क्रिएटिव_, --, --, 
   {{0xe378000f,0x2178000f,0x00000000,0x00000000}},	// [12b0] _cabanga_, _cabangel, --, --, 
   {{0x1b5ec022,0xeaa8601a,0x9988601a,0x6aa4800e}},	//   _कमान_, _innhalds, _innhalde, _si__nevíte_, 
   {{0xca3de00a,0xcd5d0002,0x02428003,0x00000000}},	//   _दें_, _читалаца_, _འཕྲིན__གསུམ_, --, 
   {{0xe2d8c034,0xada66002,0x826c6003,0x00000000}},	//   _tyder_, _што__су_, _ལམ__ཚིག_, --, 
   {{0x0f75003f,0x0a56400a,0x00000000,0x00000000}},	//   _kwabafun, _है__में_, --, --, 
   {{0x3493a019,0x00000000,0x00000000,0x00000000}},	//   _og__hva_, --, --, --, 
   {{0xcd7f0002,0xa26b8003,0x930fc00f,0x6493a01a}},	//   _пут_, _ནས__བོད_, _lombuso_, _og__kva_, 
   {{0x73fa602d,0xc27fa011,0xa442c009,0x52b34005}},	//   _udruge_, _obter__máis_, _uge_, _milliona_kroner_, 
   {{0xf9f64018,0x4b990003,0xacf2a006,0x64af6018}},	//   _botão_, _གཞུང__ངོ_, _ཕྱིར__སྤེལ_, _gosta__de_, 
   {{0xa2cac03d,0x74b5a00b,0xb67a6011,0xe75aa00c}},	//   _hned_, _baratera_mu_, _comentar__copyrigh, _पऽ__हमला_, 
   {{0xe25ea006,0x5ee3600e,0x377ec003,0x00000000}},	//   _ལེན__འཐབ_, _spokojen, _མིང__འགོད_, --, 
   {{0x0318e030,0x1316400f,0x72bfc00c,0x00000000}},	//   _vlastito_siteu_, _nambili_, _इहां_, --, 
   {{0x1e28e002,0xf9d00002,0x00000000,0x00000000}},	//   _ка_, _жели_, --, --, 
   {{0x685ba002,0xa3e32018,0x716ba025,0x00000000}},	//   _се__налази_, _em__nosso_, _memória_, --, 
   {{0xbcec2006,0x904d0002,0x00000000,0x00000000}},	//   _འགྱོ__འཛུལ_, _фотограф, --, --, 
   {{0xf34a6028,0xe3894012,0x00000000,0x00000000}},	//   _el__juego_, _nebude__dobre_, --, --, 
   {{0xa71d800a,0x00000000,0x00000000,0x00000000}},	// [12c0] _यहां__क्लिक_, --, --, --, 
   {{0xe2a92006,0xa735c00a,0x1be1000a,0x00000000}},	//   _ཚན__ཞིབ_, _पर__क्लिक_, _संपादन__कर_, --, 
   {{0xdb8c8048,0xb27ee018,0x7b798003,0x62ad0003}},	//   _ऑफ_, _painel_, _ནུའི__གླེང_, _ཆེ__བསམ_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7e036040,0xc192a012,0xf468a01a,0xc2cd200b}},	//   _uključen_, _zmazať__topovať_, _dei__var_, _bw__imana_, 
   {{0xf7134002,0x00000000,0x00000000,0x00000000}},	//   _сандуче__покреће_, --, --, --, 
   {{0x1aa4e00a,0x82f5600f,0x00000000,0x00000000}},	//   _लेकिन__अगर_, _ngayiphi__indlela_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xbbf42037,0x7a0f0003,0x00000000,0x00000000}},	//   _diciembr_noviembr, _གངས__རིའི_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x4476800b,0x0be82003,0x00000000,0x00000000}},	//   _rwego__rwo_, _སྟོན__ནང_, --, --, 
   {{0x52dc601a,0x4fe9a014,0x448e6009,0xebff0014}},	//   _måndag_, _ब्लास्ट_, _af__ok_, _चर्चा__के_, 
   {{0xaa692014,0x00000000,0x00000000,0x00000000}},	//   _बहुत__देर_, --, --, --, 
   {{0xf490a02a,0x84782002,0x33f96018,0x00000000}},	//   _av__din_, _осим_, _alguem_, --, 
   {{0x0490a01a,0x0f01a029,0x00000000,0x00000000}},	//   _av__ein_, _བསྡུས_, --, --, 
   {{0xebbc8022,0x3fbc4011,0x41698009,0xde4de027}},	//   _वर्ग__के_, _cambios__relacion, _brugsvil, _nohavice_, 
   {{0x8205a031,0x13a2202f,0xab91e018,0xf34a800c}},	// [12d0] _memiliki_, _compre_, _gravar__registro_, _के__भोजपुरी_, 
   {{0x1b8c8014,0xb2e82009,0x2b5e200c,0xd2cbe00e}},	//   _गो_, _tænker_, _कइलन_, _soud_, 
   {{0x730fc00f,0xda65e00b,0x1d70e00c,0x00000000}},	//   _zombuso_, _icyo__utangaza_, _भाग्यविध, --, 
   {{0xa2798021,0x3e23e002,0x00000000,0x00000000}},	//   _ནི__འདི_, _то__није_, --, --, 
   {{0xea3de056,0x99eac00f,0x8c11c00b,0x5504800b}},	//   _देत_, _izindaba_, _bishya__ibiganir, _umutungo_, 
   {{0x3bb8e006,0xd2d3401d,0x9b830006,0x00000000}},	//   _ནི__མས_, _dikenali_, _འཛིན__དྲུང_, --, 
   {{0xf491e027,0x00000000,0x00000000,0x00000000}},	//   _by__ste_, --, --, --, 
   {{0x4c658009,0x0229c009,0x82bfe00c,0x00000000}},	//   _indtast_, _lækre_, _उहां_, --, 
   {{0xb4b44018,0x14b20018,0x00000000,0x00000000}},	//   _produto__em_, _produto__foi_, --, --, 
   {{0xa259800f,0xe431800f,0x328e600f,0x00000000}},	//   _akukho__lutho_, _kuyiqini_ukuthi_, _kodwa__ngeke_, --, 
   {{0x04b1a01a,0x40d84002,0x00000000,0x00000000}},	//   _til__ein_, _васпитањ, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x1ba7200a,0x3c62400a,0x00000000,0x00000000}},	//   _है__एक_, _अप__करें_, --, --, 
   {{0x53054018,0x00000000,0x00000000,0x00000000}},	//   _menciona_citado_, --, --, --, 
   {{0xda3e200c,0x9cbe6002,0xc0ca2003,0x00000000}},	//   _फेर_, _наше_, _ནི__རྒྱ_, --, 
   {{0x03e8a012,0x929aa003,0x00000000,0x00000000}},	//   _všetky__časy_, _བཟོད__གངས_, --, --, 
   {{0xf242a00f,0x4c07c006,0x00000000,0x00000000}},	// [12e0] _ezimbili_, _རྟགས__ལོ_, --, --, 
   {{0x8ca8a00a,0x00000000,0x00000000,0x00000000}},	//   _मथुरा__लखनऊ_, --, --, --, 
   {{0x12d98018,0xd140800c,0x728c2003,0x00000000}},	//   _esse_, _दरभंगा_, _ཆེད__གོམ_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xc0536018,0xfbfca00c,0x00000000,0x00000000}},	//   _mensagen, _लोगन__से_, --, --, 
   {{0x0b8ca01c,0x1469c01a,0x537c0011,0xebafc00c}},	//   _को_, _endra__kl_, _servizos__sociais_, _अमीरन__के_, 
   {{0x326c2004,0x029a8006,0xb63b2017,0xf493800b}},	//   _koko_, _ཡོདཔ__ཨིན_, _vyšší_, _yagize__ati_, 
   {{0x3dce6002,0xe247000f,0x72738011,0xbd5a6002}},	//   _није_, _ibhayibh_lithi_, _vén_, _хоће_, 
   {{0x0c6f602f,0x92cac035,0x72cda003,0x00000000}},	//   _estrela_, _eyodwa_, _ཐུགས__རྗེ_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xf236c015,0x926c000b,0xebcf8002,0x702ec00c}},	//   _produksi_, _roho_, _је__имао_, _अउर__तर्क_, 
   {{0x626c201a,0x64bb402f,0x3df04006,0xc297a018}},	//   _noko_, _mais__de_, _ཆས__རྩིས_, _adiciona_como_, 
   {{0xc209000e,0x8435800c,0x00000000,0x00000000}},	//   _porovnán, _के__खराबी_, --, --, 
   {{0xf2f3e01d,0x22be600c,0xd4a00002,0x00000000}},	//   _didapati_, _केहू_, _на__расну_, --, 
   {{0x12d8a00f,0xa85ee018,0x00000000,0x00000000}},	//   _kujesu_, _forneced, --, --, 
   {{0xc493e019,0x6ba5a00e,0x2279400f,0x00000000}},	//   _et__av_, _přístup_, _lesi__simiso_, --, 
   {{0xc0ca2003,0x22cb601a,0x00000000,0x00000000}},	// [12f0] _དྲ__རྒྱ_, _staden_, --, --, 
   {{0x13a22007,0x00000000,0x00000000,0x00000000}},	//   _lompat_, --, --, --, 
   {{0x5480e01d,0x535fc002,0x00000000,0x00000000}},	//   _alamat__mel_, _допринос_нормално, --, --, 
   {{0x64598030,0xe4986009,0xfa3e400c,0x244d600b}},	//   _bih__postao_, _nu__er_, _भइल_, _rubuga__ba_, 
   {{0x72f38009,0x6bb74003,0x00000000,0x00000000}},	//   _udgivet_, _ལམ__ཁག_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x126c2004,0x63e1001d,0x00000000,0x00000000}},	//   _yoko_, _hb__ogos_, --, --, 
   {{0x7260a003,0x00000000,0x00000000,0x00000000}},	//   _སྙིང__རྗེ_, --, --, --, 
   {{0xb46ae027,0x8e47c00b,0x00000000,0x00000000}},	//   _ako__to_, _yaravuze_, --, --, 
   {{0xd34a8009,0x12ad200e,0x72434003,0x5be28002}},	//   _forsiden__lige_, _když__jsem_, _བུར_, _херцегов, 
   {{0x04aae01a,0xce6fe00a,0x00000000,0x00000000}},	//   _ein__god_, _शॉट्_, --, --, 
   {{0x17a0800e,0xb5f9600a,0xe6c8a014,0x00000000}},	//   _podmínky_, _त्योहार_, _सुनि_, --, 
   {{0xc711e00a,0x00000000,0x00000000,0x00000000}},	//   _भद्दी_, --, --, --, 
   {{0x32bb6004,0x62c94006,0x0fa2801d,0x2459201a}},	//   _ke__kaloku_, _གསརཔ__བཟོ_, _lihat__seterusn, _frå__og_, 
   {{0x08dce031,0x00000000,0x00000000,0x00000000}},	//   _tergantu, --, --, --, 
   {{0x9c812037,0x33436025,0x8bcc400c,0xcbdd8003}},	//   _opinión__escribe_, _governo_, _आके_, _མགོན__པོ_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [1300] --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x326c2004,0xc26c2015,0x00000000,0x00000000}},	//   _timoti_, _toko_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x0a3e4014,0x9a59a00c,0x00000000,0x00000000}},	//   _भेल_, _कऽ__रहल_, --, --, 
   {{0xee08c002,0xd79f8029,0x00000000,0x00000000}},	//   _фебруар_, _ཕྱིན_, --, --, 
   {{0x7adb4012,0x00000000,0x00000000,0x00000000}},	//   _vyššie_, --, --, --, 
   {{0x23ea0011,0x00000000,0x00000000,0x00000000}},	//   _os__dous_, --, --, --, 
   {{0x42772003,0x32d04003,0xa386400b,0xc49aa00e}},	//   _ཇི__ལྟར_, _ཚོགས__ཆེན_, _fdlr_, _což__je_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x1752a00a,0x32258015,0xaaf3a00e,0x0bc0800a}},	//   _ने__किया_, _merk_, _srovnat__zboží_, _मूवीरिव्_और_, 
   {{0x623b200c,0x00000000,0x00000000,0x00000000}},	//   _बा__हमार_, --, --, --, 
   {{0xda3e6014,0x4ba44003,0x00000000,0x00000000}},	//   _बेर_, _རྒྱ__ཆེ_, --, --, 
   {{0x83236008,0x34962012,0xd4b2800b,0x00000000}},	//   _de__nomes_, _keď__sa_, _muryango_, --, 
   {{0x430d201f,0xd34c8039,0x2ea18002,0x515c2002}},	//   _pelajar_, _yang__berbeda_, _колико__је_, _јула_, 
   {{0x84be2011,0x827ee02c,0x5165400a,0x00000000}},	//   _consulte__os_, _ibintu_, _कॉमेंट__लाइव_, --, 
   {{0x6e19c00b,0x00000000,0x00000000,0x00000000}},	// [1310] _rw__ishiraha, --, --, --, 
   {{0xda57a00a,0x00000000,0x00000000,0x00000000}},	//   _रिव्यू__तोल_, --, --, --, 
   {{0x3e64c002,0x00000000,0x00000000,0x00000000}},	//   _теме__на_, --, --, --, 
   {{0xc20b8015,0x43ca000b,0x00000000,0x00000000}},	//   _minggu__hari_, _uyu__munsi_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x48fa2018,0x44938012,0xfc64a00b,0x00000000}},	//   _direitos__reservad, _komentár__nie_, _werurwe_, --, 
   {{0x6bd74037,0x1a542009,0x04bf000e,0x00000000}},	//   _tu__informac, _læs__også_, _čeho__vybírat_, --, 
   {{0xabcaa011,0x00000000,0x00000000,0x00000000}},	//   _uso__ficheiro_, --, --, --, 
   {{0x92780039,0x00000000,0x00000000,0x00000000}},	//   _mengirim, --, --, --, 
   {{0x8ef10002,0x7292600b,0x5e9c6002,0x16fb200a}},	//   _смо_, _gasana_, _овог__портала_, _अगस्त__जुलाई_, 
   {{0x726cc004,0xcc7e600d,0x246dc034,0x828c201a}},	//   _koloni_, _nuestro_, _kommune__og_, _ein__slik_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x127b600e,0x01d92013,0x00000000,0x00000000}},	//   _komentář, _भीतर_, --, --, 
   {{0x54980016,0x6adca00c,0x00000000,0x00000000}},	//   _forespør_om_, _समूचा_, --, --, 
   {{0x626c4004,0xcf0d4029,0xb9916012,0x00000000}},	//   _molo_, _རྒྱུས_, _riešenie_, --, 
   {{0x526c400f,0xa27f600f,0x32c6e003,0x1ba42003}},	//   _lolo_, _amanga_, _རིགས__གཞན_, _དུས__སུ_, 
   {{0xc386201a,0xf328a03c,0x479fc003,0x4ba6e003}},	// [1320] _nokre_, _na__jezeru_, _བདེན_, _རྒྱུས__ལོ_, 
   {{0xac61600d,0x8bcc600c,0xf5734002,0x00000000}},	//   _alguien_, _आवे_, _репрезен, --, 
   {{0xa4a9e015,0xa301801d,0x00000000,0x00000000}},	//   _gan__ane_, _sahaja__yang_, --, --, 
   {{0x8efd6022,0x3e210002,0x00000000,0x00000000}},	//   _धमाका_, _се__ово_, --, --, 
   {{0xb26c4012,0x3830c003,0xafe9c003,0x00000000}},	//   _bolo_, _གསུང__འཕྲིན_, _ཞུ__རྒྱུ_, --, 
   {{0xac9fe003,0x00000000,0x00000000,0x00000000}},	//   _བྱོལ_, --, --, --, 
   {{0xf79fa003,0x2f1b8012,0xe320a028,0xfba94003}},	//   _མདུན_, _vaša_, _precios_, _ཁྲིམས__ཆད_, 
   {{0xbcc8600e,0x00000000,0x00000000,0x00000000}},	//   _světa_, --, --, --, 
   {{0x8250c00a,0xb201000b,0xba73200c,0x00000000}},	//   _सकेंगे_, _biciwe_, _भोज__शोध_, --, 
   {{0x38752006,0x9c67800b,0x93f6800e,0x768b8006}},	//   _གསོལ__བརྩི_, _gahunda_, _registro_srovnat_, _སྦེ__ཡོདཔ_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x44444009,0xc20d2011,0x573fe003,0x0c48e022}},	//   _af_, _máis_, _བྱེད_, _सुने_, 
   {{0x0cd92015,0x6e532007,0x5252c028,0x82da400b}},	//   _melalui__seluler_, _sumbanga, _se__limita_, _gitero_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x72d9e00e,0x5f25a018,0x0e8be002,0x00000000}},	//   _jste_, _selecion, _конкурс__за_, --, 
   {{0xb47de02a,0x101fa018,0xcaaae00a,0xd2570003}},	//   _hvor__mye_, _endereço_, _महिलाओं_, _གླེང__མོལ_, 
   {{0x82436003,0xa0418012,0x00000000,0x00000000}},	// [1330] _ཕུལ_, _doručeni, --, --, 
   {{0x0a9a400c,0x00000000,0x00000000,0x00000000}},	//   _मद__में_, --, --, --, 
   {{0x13f0a011,0xda53000a,0xea00200f,0x00000000}},	//   _da__páxina_, _औरफोटोधम_जोश_, _ujesu__wabonisa_, --, 
   {{0x6964a00e,0x71d8a00a,0x00000000,0x00000000}},	//   _využití_, _सीकर_, --, --, 
   {{0xf4926019,0x0a804022,0x00000000,0x00000000}},	//   _av__et_, _असल__में_, --, --, 
   {{0x1797e014,0x00000000,0x00000000,0x00000000}},	//   _शिवमंदिर_, --, --, --, 
   {{0x130d2015,0x046b600b,0xa26aa003,0x00000000}},	//   _pelapor_, _ari__yo_, _རྩོམ__འདི_, --, 
   {{0x22d9201a,0x832ca02a,0xbd8d400b,0x00000000}},	//   _seinare_, _høyt_, _demokara, --, 
   {{0x22d9e012,0x3b4a8021,0x820e6002,0x198ac012}},	//   _este_, _དང__སྲུང_, _рата_, _hneď_, 
   {{0xfc754018,0xb2a68007,0x00000000,0x00000000}},	//   _algumas_, _adab_, --, --, 
   {{0xc2a66025,0x55fd4011,0x00000000,0x00000000}},	//   _globo_, _suxestió, --, --, 
   {{0xd283c004,0x2284a021,0xb44f2003,0x00000000}},	//   _okokuba_, _འཁྲུངས__རབས_, _དམིཊ_, --, 
   {{0xfb22a006,0x00000000,0x00000000,0x00000000}},	//   _གཞི__བཙུགས_, --, --, --, 
   {{0xb201c035,0x0cca001d,0xca32a014,0x00000000}},	//   _izwi_, _nama__pertama_, _कोस_, --, 
   {{0xd1c5e00a,0xf2fce015,0x55a2a057,0x00000000}},	//   _सेहत__व्यंजन_, _pengen_, _sk__slovensk, --, 
   {{0xcab52009,0x00000000,0x00000000,0x00000000}},	//   _indkøbsk, --, --, --, 
   {{0x1304e007,0x6e3fc002,0xd2ae401d,0xa202400f}},	// [1340] _tak__boleh_, _складу__са_, _maklumat__lanjut_, _ezwini_, 
   {{0xe5b18012,0x0b8ca003,0xeb392003,0x00000000}},	//   _technoló, _བལ_, _པོ__འདུག_, --, 
   {{0xa258e006,0x78ab2018,0x5a29c00f,0x00000000}},	//   _ཏའི__ཝཱན_, _aviso__prévio_, _uma__kwenzeka_, --, 
   {{0xc234e01d,0x93bf2009,0x0bcde00a,0x00000000}},	//   _buat__kali_, _erhverv_, _गाजीपुर_, --, 
   {{0xa2fca038,0x00000000,0x00000000,0x00000000}},	//   _queixas_, --, --, --, 
   {{0xabf5000e,0xdf69c002,0x00000000,0x00000000}},	//   _produktů_, _немачки_, --, --, 
   {{0x434c2030,0x96efe011,0x6bd48013,0x00000000}},	//   _lud__zbunjen_, _páxinas__especiai, _फिर__भी_, --, 
   {{0x02726003,0xa303e016,0xe5c2000f,0x04ad401a}},	//   _ཟླ__ཚེས_, _les__hele_, _kunalokh, _rekna__som_, 
   {{0x73bcc015,0x01012002,0x7a72400a,0x00000000}},	//   _menerima__syarat_, _свети_, _जाती__हैं_, --, 
   {{0x7fe4c00a,0xcbcc6003,0x00000000,0x00000000}},	//   _पर__कार्रवाई_, _བཟང__པོ_, --, --, 
   {{0x5d362002,0x00000000,0x00000000,0x00000000}},	//   _садрже_, --, --, --, 
   {{0xaa32a013,0x00000000,0x00000000,0x00000000}},	//   _कोश_, --, --, --, 
   {{0x9bdde003,0x00000000,0x00000000,0x00000000}},	//   _ཀྱི__ལས_, --, --, --, 
   {{0xe2cb400f,0x00000000,0x00000000,0x00000000}},	//   _oyedwa_, --, --, --, 
   {{0xb25b401a,0x6a33600a,0x52d7e00e,0x00000000}},	//   _mogleg_, _चूत_, _naše__cena_, --, 
   {{0xf268800f,0xa28c4003,0x00000000,0x00000000}},	//   _okuningi_, _ཆེན__བོད_, --, --, 
   {{0xa2116004,0x64b8e01a,0x00000000,0x00000000}},	// [1350] _ngakumbi_, _ikkje__så_, --, --, 
   {{0x34b8e01a,0x00000000,0x00000000,0x00000000}},	//   _ikkje__på_, --, --, --, 
   {{0x22da400b,0x00000000,0x00000000,0x00000000}},	//   _intego_, --, --, --, 
   {{0xe497e00d,0x13f2600b,0x00000000,0x00000000}},	//   _si__es_, _amashuri_, --, --, 
   {{0x6b884029,0xa898c002,0xea07400f,0x00000000}},	//   _ལྟ_, _чланак__доставље, _ukuzamaz_komhlaba_, --, 
   {{0x5396600f,0x84b0e01d,0x16e04003,0x00000000}},	//   _omusha_, _sdn__bhd_, _ཀྱི__སློབ_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2fcde012,0xb4b20009,0x040f0018,0x00000000}},	//   _článok_, _til__dig_, _segunda__sexta_, --, 
   {{0xe2438003,0x54254002,0x14ab4011,0x00000000}},	//   _ཁུལ_, _dezinfik, _persoas__con_, --, 
   {{0x3ba5800a,0x3cb1c003,0x00000000,0x00000000}},	//   _है__जो_, _ཡུལ__འཚོལ_, --, --, 
   {{0xe4774045,0x0bb58003,0xa52a2002,0x725c4003}},	//   _tento__rok_, _ནས__བར_, _је__веома_, _སྟོང__ཕྲག_, 
   {{0x84d6c00c,0xa28c4003,0x6a56600c,0x6316600c}},	//   _एह__क्षेत्र_, _ཆེན__དོན_, _एह__लेख_, _करत__बानी_, 
   {{0x4d5a0002,0x00000000,0x00000000,0x00000000}},	//   _поред_, --, --, --, 
   {{0x2e296002,0xfa8a8002,0x4cfdc002,0x55100002}},	//   _баш_, _августа_, _последњи, _песме_, 
   {{0x12d40012,0xf8fbc027,0x00000000,0x00000000}},	//   _ľudí_, _mojasvad, --, --, 
   {{0xc47ec011,0xe2d0800a,0x00000000,0x00000000}},	//   _hoxe__en_, _वेब__ब्राउज़र_, --, --, 
   {{0x82016015,0xfb0ae011,0xc9f2400f,0xe08ae011}},	// [1360] _bagian_, _conselle, _ekugcine, _concello, 
   {{0x32a3a004,0xd471e038,0x00000000,0x00000000}},	//   _emva__koko_, _nos__que_, --, --, 
   {{0x9412a015,0xd4c2a00b,0x82e6000b,0x990e2002}},	//   _com__buat_, _urutonde__rw_, _wa__gatatu_, _одлука_, 
   {{0x4aea6016,0xc46a6011,0x00000000,0x00000000}},	//   _fortelle, _hai__un_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xe4420004,0xb2996015,0x4627e00f,0xb39bc01a}},	//   _mzi_, _simpan__iklan_, _agcotshi, _frå__andre_, 
   {{0xf2366012,0xb4b8a018,0xe442200e,0x59eb400b}},	//   _svoj_, _como__uma_, _pojmů__pokud_, _nyarwand, 
   {{0x2ec76002,0x00000000,0x00000000,0x00000000}},	//   _ти__је_, --, --, --, 
   {{0x3323a009,0x52ca4009,0x42976006,0x00000000}},	//   _af__vores_, _fald_, _ཤོག__ལྟག_, --, 
   {{0x7baf8003,0x7471e027,0x00000000,0x00000000}},	//   _དང__རང_, _sme__si_, --, --, 
   {{0x2442000b,0x421c600b,0x00000000,0x00000000}},	//   _azi_, _mushya_, --, --, 
   {{0xb480800b,0x02366012,0x829f800f,0x1819e00a}},	//   _kuri__uyu_, _tvoj_, _ezizweni__zonke_, _प्रोफेशन_, 
   {{0x829e2006,0x1a420014,0x12e8e00c,0x7bb1a003}},	//   _རྗེ__དབང_, _के__कुल_, _के__पाती_, _ལག__ཁང_, 
   {{0xd40ee00e,0x8a92c00a,0x00000000,0x00000000}},	//   _telefony__zkuste_, _ने__फिर_, --, --, 
   {{0x64420004,0xb2f5600e,0xd491a02f,0x6ef6e002}},	//   _ezi_, _mpix__více_, _na__sua_, _променио__насловну_, 
   {{0x3a3c400c,0x726ca003,0xf65c8002,0x00000000}},	//   _आपन_, _ནང__ཆོས_, _успела__молимо_, --, 
   {{0xef65e019,0x1c87200e,0x921c600b,0xc2572003}},	// [1370] _klær_, _musíš__nejprve_, _bushya_, _དུས__དེབ_, 
   {{0x72d1e020,0x2067c00c,0xceaac00c,0x4d882003}},	//   _དཀར__ཆོས_, _आभासी_, _के__प्रतापी_, _གཙོས_, 
   {{0x2afe8015,0x00000000,0x00000000,0x00000000}},	//   _aparteme, --, --, --, 
   {{0xe3696018,0xa1f10003,0x00000000,0x00000000}},	//   _não__recebeu_, _ཡིག__རྩོམ_, --, --, 
   {{0xe68d600c,0x9a754018,0x00000000,0x00000000}},	//   _परमार_, _novohamb, --, --, 
   {{0x5709400c,0x00000000,0x00000000,0x00000000}},	//   _के__भाषा_, --, --, --, 
   {{0x43cfe00f,0x00000000,0x00000000,0x00000000}},	//   _emuva_, --, --, --, 
   {{0xc243c029,0x53954012,0xb052200e,0x00000000}},	//   _ཟུར_, _miesta_, _prohláše, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x8a75c018,0x244fe00b,0xa583a002,0x6296c003}},	//   _ações_, _bavuze__ko_, _текстова__преведен, _གཟིགས__ཕྱི_, 
   {{0x5f3a4031,0x75a94014,0x3be22003,0x00000000}},	//   _transfer_, _के__भारत_, _འཕྲིན__ལེ_, --, 
   {{0x42932006,0x22614006,0x00000000,0x00000000}},	//   _ལུགས__ཨེན_, _དབྱེ__རིམ_, --, --, 
   {{0x52ff8030,0xec0d2014,0x9535c002,0x32a60003}},	//   _odobrenj_takođe_, _संविधान__के_, _комуника_између_, _མོས__སྙན_, 
   {{0xfed50002,0xebbc400c,0x00000000,0x00000000}},	//   _док_, _नकदी__के_, --, --, 
   {{0xba2f800c,0xc28fa003,0x00000000,0x00000000}},	//   _से__प्रयास_, _ཕེབས__པའི_, --, --, 
   {{0x2e8c8018,0xd45be01a,0x87d1800a,0x346c200f}},	//   _se__cadastra, _sjå__den_, _शर्तें__गोपनीयता_, _ukristu__jesu_, 
   {{0xaf364016,0x426ca011,0x5492400c,0x00000000}},	// [1380] _gjøres_, _pobo_, _कबो__मुंबई_, --, 
   {{0xb2728002,0x00000000,0x00000000,0x00000000}},	//   _београдс, --, --, --, 
   {{0x927f402a,0xd2ca6009,0x00000000,0x00000000}},	//   _trener_, _mand_, --, --, 
   {{0xad83a006,0x9bcae00c,0x00000000,0x00000000}},	//   _སྒྲོམ_, _चलते__लोगन_, --, --, 
   {{0x0386001a,0x8063c002,0x918f0002,0x00000000}},	//   _meir_, _поводом_, _на__сајту_, --, 
   {{0xc0c9a003,0x00000000,0x00000000,0x00000000}},	//   _ཏུ__རྒྱ_, --, --, --, 
   {{0x146ce034,0x23162018,0xa2e1200a,0x00000000}},	//   _mai__kl_, _em__estoque_, _ट्रीय_, --, 
   {{0x1028a00a,0x00000000,0x00000000,0x00000000}},	//   _सुबह_, --, --, --, 
   {{0xe40b8002,0x4b760012,0x00000000,0x00000000}},	//   _ujutru__ujutru_, _európske, --, --, 
   {{0xaf1b8012,0xcbf1e00e,0x6251400f,0xb0f98003}},	//   _naša_, _spotřebi, _unkulunk_wakho_, _གང__འདྲ_, 
   {{0xf38b000c,0x00000000,0x00000000,0x00000000}},	//   _आज__भोजपुरी_, --, --, --, 
   {{0xf26cc00e,0xe31d2037,0xe2bac00e,0x00000000}},	//   _budou_, _no__vende_, _věc_, --, 
   {{0xa3ea602a,0x3bc3200c,0x00000000,0x00000000}},	//   _fant_, _जारी__बा_, --, --, 
   {{0x6290c00f,0xfc59000e,0x00000000,0x00000000}},	//   _nalabo_, _filtr__parametr, --, --, 
   {{0x426ca00d,0xd1ff201e,0x62da400b,0x02b04018}},	//   _poco_, _sljedeća__prikaži_, _inteko_, _hardmob_, 
   {{0x0ec40011,0xf2fea00b,0xe4b16009,0x234ae00f}},	//   _mañá_, _uruhare_, _ret__til_, _watch__tower_, 
   {{0x7493800b,0xcbbd200c,0x00000000,0x00000000}},	// [1390] _ko__uwo_, _कुल्__ही_, --, --, 
   {{0x922b400e,0xb27e800e,0x00000000,0x00000000}},	//   _někdy_, _denně_, --, --, 
   {{0x26e72011,0xb5dd0002,0xf26c000f,0x00000000}},	//   _descrici, _поштанск, _akufanel_yini_, --, 
   {{0x5478e00a,0x0a94200f,0x5c03200a,0x00000000}},	//   _दिल्ली__मुंबई_, _eziyisit, _गाली__या_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xb386803c,0x1cfdc002,0x9f35601a,0x00000000}},	//   _bajram_, _прича_, _tilsvara, --, 
   {{0xd38ea017,0x00000000,0x00000000,0x00000000}},	//   _ubytován, --, --, --, 
   {{0xc2014018,0x14adc018,0x24b5c01a,0xd3aae00b}},	//   _digite_, _serviços_, _skule__og_, _kandi__uburyo_, 
   {{0xc4a4e012,0xf9aac002,0x7ba52003,0x00000000}},	//   _čo__je_, _позив_, _འགྱུར__དྲ_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa3ea602a,0x43d44009,0x62ca6009,0x00000000}},	//   _vant_, _mest__læste_, _vand_, --, 
   {{0x5debc00a,0xade16002,0x00000000,0x00000000}},	//   _टिप्पणिय, _ли__су_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xe4790018,0x44742018,0x00000000,0x00000000}},	//   _deve__ser_, _detalhes__da_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xe386a027,0xb387000e,0xac5aa00a,0xa4bdc002}},	//   _dobre_, _vybrat_, _को__नहीं_, _изгледа_, 
   {{0x12a6c012,0x12c6801f,0x6c48600a,0x3ee7c002}},	// [13a0] _alebo_, _ensiklop_bebas_, _रखने_, _југослов, 
   {{0x97580014,0xc75d402b,0x00000000,0x00000000}},	//   _विद्वान_, _kugirang, --, --, 
   {{0x0e79a002,0x00000000,0x00000000,0x00000000}},	//   _сектор__за_, --, --, --, 
   {{0x5498200b,0xe27fa016,0x826a8006,0x5ed0e00e}},	//   _ya__css_, _åpne_, _ཅིག__ཨིནམ_, _rady__zeptejte_, 
   {{0x7ee94002,0x00000000,0x00000000,0x00000000}},	//   _кад__се_, --, --, --, 
   {{0xebb7600c,0xc2564006,0xc44a401a,0xfefaa002}},	//   _अफगानिस्_के_, _དགོ__པའི_, _bilete__av_, _који__би_, 
   {{0x93b10011,0x78552002,0xd714c00c,0xe27f600b}},	//   _servizo_, _имају_, _रहे__बाकिर_, _mwanya_, 
   {{0x82caa039,0x4c02c00c,0x00000000,0x00000000}},	//   _kita__bisa_, _कवनो__तरे_, --, --, 
   {{0x325d8011,0xd3dc200f,0xd337600b,0xf292c003}},	//   _así__mesmo_, _yakwa_, _mu__buhinde_, _རེད__ཟེར_, 
   {{0x03ea8039,0x1c87400c,0x00000000,0x00000000}},	//   _saat_, _कहत__रहले_, --, --, 
   {{0x93ce0009,0x27de800b,0x00000000,0x00000000}},	//   _bliv_, _idasanzw, --, --, 
   {{0x0a73c00c,0x00000000,0x00000000,0x00000000}},	//   _कवन__कवन_, --, --, --, 
   {{0xfa1c0034,0xe1dfc013,0x00000000,0x00000000}},	//   _andre__språk_, _आमिर_, --, --, 
   {{0xfc0b2014,0xb302a00b,0x00000000,0x00000000}},	//   _रुप__से_, _umubare_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xda3c000a,0x2c4ca00e,0x00000000,0x00000000}},	//   _ऊपर_, _partneři_, --, --, 
   {{0x9bde6003,0xb281a00a,0x00000000,0x00000000}},	// [13b0] _པའི__ལས_, _प्लास्टि_सिलेबस_, --, --, 
   {{0x4405000e,0x00000000,0x00000000,0x00000000}},	//   _nejnižší_, --, --, --, 
   {{0x8352800c,0x525be025,0x3cd6200a,0xec0b0014}},	//   _के__संबंध_, _paulo_, _संपर्क__करें_, _शोध__के_, 
   {{0x6349200b,0x547d402f,0xe4696012,0x530ba00a}},	//   _yishingi_ibibera_, _para__se_, _iba__na_, _होने__वाली_, 
   {{0xf443e015,0xba4c200c,0x1b93200c,0x00000000}},	//   _bgt_, _के__शोध_, _नाम__ना_, --, 
   {{0xdc57800c,0x00000000,0x00000000,0x00000000}},	//   _के__लेके_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x5ae20025,0x6e6c402a,0xe493800e,0x2108a00c}},	//   _interess, _du__spørsmål_, _šíření__či_, _एह__गांव_, 
   {{0x1f92a002,0xd491e038,0xec7d600d,0x295d601a}},	//   _pol__muški_, _na__que_, _persona_, _personar_, 
   {{0x8256c006,0xcb5ea00c,0xfc07a00c,0x16e0c003}},	//   _སེངྒེ__དབང_, _जइसन_, _गइल__रहे_, _པའི__སློབ_, 
   {{0xd62ec006,0xe3c8e018,0x00000000,0x00000000}},	//   _ཡིག__གསརཔ_, _atualiza_mais_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x22292009,0xee72e002,0x00000000,0x00000000}},	//   _løkke_, _ве_, --, --, 
   {{0x6b3e2003,0x00000000,0x00000000,0x00000000}},	//   _རྒྱ__གཞུང_, --, --, --, 
   {{0x7be90021,0xc9b1400e,0xbe714012,0xf248001a}},	//   _སྟོན__ཁང_, _ostatní_, _ostatné_, _heime_, 
   {{0x026ce018,0xb443e035,0xb22ea037,0xe2c6a003}},	//   _jogo_, _ngu_, _contacta_enviar_, _བསྐལ__བཟང_, 
   {{0x3ce9e012,0x00000000,0x00000000,0x00000000}},	// [13c0] _pridala__príspevk, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xc200a030,0x6e388018,0x00000000,0x00000000}},	//   _kukić_, _estoques_, --, --, 
   {{0x4ed24002,0x22524003,0x00000000,0x00000000}},	//   _да__ће_, _ཡིན__ཞེས_, --, --, 
   {{0x5224c039,0x84258011,0x625fc003,0x00000000}},	//   _efek_, _pola__xunta_, _རྩོམ__བསམ_, --, 
   {{0xc2d38039,0x00000000,0x00000000,0x00000000}},	//   _dari__berbagai_, --, --, --, 
   {{0x020e6002,0x00000000,0x00000000,0x00000000}},	//   _маја_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x1212801f,0x82258012,0x00000000,0x00000000}},	//   _shah_, _dosky_, --, --, 
   {{0x0085801f,0xc26ce02f,0x590d2002,0x00000000}},	//   _juta__profesio, _fogo_, _португал, --, 
   {{0x327f8009,0x19f64018,0x57932003,0x7adae00c}},	//   _gerne_, _então_, _འཛིན__བྱེད_, _अठवां__अनुसूची_, 
   {{0x0b3c200b,0x1bb9e003,0x4263a00a,0x00000000}},	//   _neza__ukoreshe, _དེ__ནས_, _हरदोई__हाथरस_, --, 
   {{0x8ae6a01d,0x0c728006,0xda332013,0x00000000}},	//   _parlimen_, _བླམའི_, _जोश_, --, 
   {{0x0491a01a,0x00000000,0x00000000,0x00000000}},	//   _er__ein_, --, --, --, 
   {{0xe26ce011,0x73862009,0x00000000,0x00000000}},	//   _xogo_, _sejr_, --, --, 
   {{0x7291800b,0x1dd84002,0xce1ae002,0x00000000}},	// [13d0] _ibyaha_, _захваљуј, _искључив, --, 
   {{0x0472a01a,0x76ed600a,0x9a65e00c,0x00000000}},	//   _som__ein_, _वैयक्तिक__औज़ार_, _गणराज्य__चीन_, --, 
   {{0x825e6003,0x00000000,0x00000000,0x00000000}},	//   _ཁང__དབུ_, --, --, --, 
   {{0xf424e013,0xa8fac00c,0xb2670002,0x00000000}},	//   _हिमाचल__प्रदेश_, _ओरिएंटेड_, _чему_, --, 
   {{0x4861a00f,0xbf8be012,0x244ee00d,0xb46be00e}},	//   _izincwad, _iné_, _un__saludo_, _jak__to_, 
   {{0x2a224027,0x937d800e,0x971b0002,0xac09a00b}},	//   _poradňa_, _třetí_, _укупно_, _ikoranab, 
   {{0x9999000e,0x4eef6016,0xaa180002,0x51d9a00a}},	//   _dobře_, _selvsagt_, _исто_, _फीचर_, 
   {{0x88dc2002,0xea32a013,0x00000000,0x00000000}},	//   _вучић_, _कोच_, --, --, 
   {{0x9473c025,0xb2a20003,0x00000000,0x00000000}},	//   _login__ou_, _འདེམས__ཀྱི_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x94426004,0x74ae4030,0xc5cd4018,0x00000000}},	//   _ezo_, _stranke__po_, _as__informaç, --, 
   {{0xe42f200f,0x00000000,0x00000000,0x00000000}},	//   _lisitshe_ukuthi_, --, --, --, 
   {{0x4816200b,0x0abe000a,0x2379402b,0xa7a52002}},	//   _mugihe__amashaki, _मामले__में_, _urwanda_, _пре__свега_, 
   {{0xb4abe015,0x6e290002,0x5517a002,0x00000000}},	//   _bermanfa_dan_, _чак_, _је__променио_, --, 
   {{0x327e6002,0x00000000,0x00000000,0x00000000}},	//   _новом__саду_, --, --, --, 
   {{0x3253e00f,0x00000000,0x00000000,0x00000000}},	//   _futhi__ngeke_, --, --, --, 
   {{0x8c6d6002,0x00000000,0x00000000,0x00000000}},	// [13e0] _до__октобра_, --, --, --, 
   {{0x126d800d,0x9bdec006,0xc5d2e011,0x26f2e00a}},	//   _otros_, _རྐྱབ__མི_, _da__poboació, _था__लेकिन_, 
   {{0x4def2012,0xcb97a012,0x00000000,0x00000000}},	//   _zaujímav, _objednať_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x19f4e00e,0x434b8009,0x5388602a,0x22b6000b}},	//   _deník_, _at__bruge_, _høyere_, _ba__yehova_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x868d801a,0x02b9e00f,0x9bdee003,0x00000000}},	//   _gøymde__kategori, _akekho__umuntu_, _བའི__ལས_, --, 
   {{0xec09e00c,0xd232a002,0x00000000,0x00000000}},	//   _जवना__के_, _годину__дана_, --, --, 
   {{0xf4aa6005,0xc220c012,0xc33ba00f,0xecee4003}},	//   _kontoen__din_, _dámske_, _simiso__sezinto_, _ཆོས__འཕེལ_, 
   {{0x3492400d,0xf328c012,0x722a0002,0x00000000}},	//   _es__muy_, _na__mape_, _дошао_, --, 
   {{0x03d3001a,0xf9b4200f,0x00000000,0x00000000}},	//   _ei__stor_, _ifa__lomhlaba_, --, --, 
   {{0x630ec028,0x09f4e00e,0x0b8d4003,0xb59de00f}},	//   _tambien_, _ceník_, _ཕལ_, _ngokusuk_enhliziy, 
   {{0x52e8e009,0x9c150003,0xec37e002,0x00000000}},	//   _dit__navn_, _དེང__སང_, _народу_, --, 
   {{0xf316800f,0x52a0600e,0x00000000,0x00000000}},	//   _ababili_, _soubor_, --, --, 
   {{0x36e08012,0x8a7f400c,0x00000000,0x00000000}},	//   _sprava__priateli, _काव्य__आदि_, --, --, 
   {{0x83eae009,0x06d1a00c,0x772d600c,0x00000000}},	//   _haft_, _अबहिन_, _के__गूढ़_, --, 
   {{0x04b2201a,0xbc4f400a,0xe2696003,0x00000000}},	// [13f0] _var__ein_, _अगले_, _ཁང__སྐར_, --, 
   {{0x9a262051,0x6442803f,0x00000000,0x00000000}},	//   _उपलब्ध_, _iza_, --, --, 
   {{0x04632018,0xfbf0600c,0x00000000,0x00000000}},	//   _contato__com_, _कहीं__तऽ_, --, --, 
   {{0xf202601d,0xdf36a019,0xeb98800c,0xfbee2003}},	//   _carian_, _kjører_, _ओहिजा__के_, _སྟེགས__པར_, 
   {{0x3bdbe00a,0x8470e00c,0x00000000,0x00000000}},	//   _तो__यह_, _गो__पांडुलिप, --, --, 
   {{0x8449e012,0xbf20c00b,0x0e89c00a,0x00000000}},	//   _pravda__sk_, _ubutunga, _बेहतरीन_, --, 
   {{0xec00600c,0x2bba0003,0x00000000,0x00000000}},	//   _लोगिन__के_, _དེ__བས_, --, --, 
   {{0xc442803f,0x2420000b,0x00000000,0x00000000}},	//   _oza_, _ibi__wihuse_, --, --, 
   {{0x115fc002,0x00000000,0x00000000,0x00000000}},	//   _односи_, --, --, --, 
   {{0x546f2016,0xcf33c028,0x43b9a03d,0x00000000}},	//   _varslet__om_, _presenta, _serveru_, --, 
   {{0xe4428004,0xd2cc0009,0x91872002,0x72d1e003}},	//   _aza_, _at__kunne_, _без__обзира_, _ཁྱད__ཆོས_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x19f66025,0x92ab200b,0xf34c000c,0x00000000}},	//   _porém_, _yobowe__umukuru_, _गो__भोजपुरी_, --, 
   {{0xe27f600b,0x84a82009,0x00000000,0x00000000}},	//   _rwanda_, _kontakt__os_, --, --, 
   {{0x2442803f,0x6e100006,0x326d6006,0x728aa00f}},	//   _eza_, _ཁྱད__རིགས_, _ནག__སོག_, _leso__sikhathi_, 
   {{0x153cc00f,0x474ec002,0xd26ee00f,0x00000000}},	//   _kuyilaph, _црква_, _ungunkul, --, 
  
   {{0x826ba02e,0x0c16400a,0x0bff8014,0x00000000}},	// [1400] _sveučili, _व्यापार__करियर_, _से__पूछताछ_, --, 
   {{0x9442002b,0x9ce5e00c,0x00000000,0x00000000}},	//   _iyi_, _से__कवनो_, --, --, 
   {{0x6847600e,0xcc7f600b,0x00000000,0x00000000}},	//   _dalšího_, _rutsiro_, --, --, 
   {{0x03950012,0xf27f000f,0x2460c011,0xd2b10003}},	//   _časti_, _abangu_, _tamén__editar_, _ཞི__བའི_, 
   {{0x6c622012,0xa3946011,0x00000000,0x00000000}},	//   _pozrite_, _luns_, --, --, 
   {{0x1467801a,0x0711000a,0x00000000,0x00000000}},	//   _endra__mai_, _कर__लिया_, --, --, 
   {{0x12e8601d,0x1c102002,0x00000000,0x00000000}},	//   _baginda_, _фејсбуку__како_, --, --, 
   {{0xf2d8200b,0x2358001d,0x32a12006,0x3686400a}},	//   _kamere_, _sesuai__dipapar_, _དྲུང__ཆེན_, _बीबीसी__हिंदी_, 
   {{0xdc49200a,0x03ce8012,0x00000000,0x00000000}},	//   _बड़े_, _stave_, --, --, 
   {{0x5c5d8022,0xf2ce203c,0x62b6c01a,0xf709a013}},	//   _के__चलते_, _navođenj_izvora_, _endra__lenkjer_, _मर्द_, 
   {{0x5236c01d,0x00000000,0x00000000,0x00000000}},	//   _projek_, --, --, --, 
   {{0x046be019,0x630de00b,0xd0fe8014,0x7373200b}},	//   _hva__som_, _ibibera_, _के__अभाव_, _giharwe_, 
   {{0xa29ca012,0x6c5a4007,0x97f26012,0x0e80600c}},	//   _zľava_, _menteri_, _veľkosť_, _बहुत__महत्वपूर, 
   {{0xca32a01c,0x00000000,0x00000000,0x00000000}},	//   _कोई_, --, --, --, 
   {{0x53dc0039,0x33cf400d,0x00000000,0x00000000}},	//   _bahwa_, _jueves_, --, --, 
   {{0x84444005,0xebda8006,0x0b5f000c,0xd2a10006}},	//   _eg_, _ཞུན__དག_, _अइसन_, _ཆོས__སྐད_, 
   {{0x2442801b,0xb450e00b,0x00000000,0x00000000}},	// [1410] _uza_, _hejuru__to_, --, --, 
   {{0x33e3a019,0x00000000,0x00000000,0x00000000}},	//   _av__disse_, --, --, --, 
   {{0x92a6400b,0x628cc003,0x8c57e00c,0x0c48600c}},	//   _zombi_, _ཤོག__ངོས_, _के__देखे_, _रखले_, 
   {{0x92e6600e,0xd444402d,0xe4080015,0xe821200b}},	//   _více__zadat_, _zg_, _serupa__untuk_, _abiri__yaturiki, 
   {{0xbc48e048,0xaf510013,0x00000000,0x00000000}},	//   _तुझे_, _होंगे_, --, --, 
   {{0x1a87800c,0x00000000,0x00000000,0x00000000}},	//   _कि__सब्सिडी_, --, --, --, 
   {{0x771b200a,0x3546c002,0x00000000,0x00000000}},	//   _का__कहना_, _друштво_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x13a3401a,0x433fc016,0x3cb2a00a,0x00000000}},	//   _innbyggj, _flere__saker_, _टिप्पणी__करें_, --, 
   {{0x14742016,0x67720002,0xe9dd6002,0x00000000}},	//   _forbehol_oss_, _свог_, _поједина, --, 
   {{0xa434e002,0x00000000,0x00000000,0x00000000}},	//   _sati__minuta_, --, --, --, 
   {{0x92abe00d,0x5239001d,0x8445000b,0x52faa00a}},	//   _de__años_, _urus__janji_, _zayo__uru_, _लखीमपुर__खीरी_, 
   {{0x6747c002,0x00000000,0x00000000,0x00000000}},	//   _милиона_, --, --, --, 
   {{0xb394802f,0xd2aa2003,0x7cc5200f,0x00000000}},	//   _duas_, _གང__ཡིན_, _enye__incwadi_, --, 
   {{0x2e28801a,0x42b7c00b,0xd349e009,0x00000000}},	//   _framleis_, _inyuma__yuko_, _vil__have_, --, 
   {{0xb224800e,0x86b0e00f,0xfb81e003,0x67cf800b}},	//   _velký_, _intukuth, _གངས__ལྗོངས_, _umushiki, 
   {{0x63dc200f,0x13f2c009,0xd256c003,0xda80c00e}},	// [1420] _bakwa_, _det__gør_, _འོས__འདེམས_, _konečně_, 
   {{0x14ad6009,0xd0f10006,0x00000000,0x00000000}},	//   _maj__kl_, _སྟེ__བཀྲ_, --, --, 
   {{0xa2ba8020,0xb24a4007,0xa575a018,0x9cbe600c}},	//   _མི__འདི_, _resolusi_, _utilizaç, _अइसन__कवनो_, 
   {{0xb47bc018,0xe4b98012,0xcc86a00c,0x00000000}},	//   _de__desconto_, _skočiť__na_, _के__पूर्वज_, --, 
   {{0x341a000f,0x00000000,0x00000000,0x00000000}},	//   _ukufinye_kodwa_, --, --, --, 
   {{0xe4926028,0xa377c012,0xc733c00c,0x5c0ca003}},	//   _en__tu_, _športové_, _अउर__ओकरा_, _ཚོགས__ཨེ_, 
   {{0x1308201d,0x00000000,0x00000000,0x00000000}},	//   _terus__lihat_, --, --, --, 
   {{0x54b70012,0xec01200c,0x00000000,0x00000000}},	//   _môžete_, _ऋगवेद__के_, --, --, 
   {{0x02b9a018,0x00000000,0x00000000,0x00000000}},	//   _com__essa_, --, --, --, 
   {{0x9304201d,0xa4456038,0x00000000,0x00000000}},	//   _mengguna_laman_, _editar__as_, --, --, 
   {{0xa3948025,0xa421801d,0x4ea18002,0x00000000}},	//   _suas_, _pelawat__about_, _нов__сам_, --, 
   {{0x8256a00f,0x2303200c,0x00000000,0x00000000}},	//   _elihunyu_ngokuthi_, _का__चाहीं_, --, --, 
   {{0x5229001d,0xf9f66018,0x4cc9e00c,0x4ecc8002}},	//   _rujukan__saling_, _visão_, _पहुंचल__होखे_, _одустали__од_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xb278601a,0x00000000,0x00000000,0x00000000}},	//   _vatnet_, --, --, --, 
   {{0xd3e54037,0x91eac003,0x23d8c002,0x00000000}},	//   _aprende__sobre_, _འཛུམ_, _на__српском_, --, 
   {{0x03eae00f,0x7291800b,0x1afc400e,0x6330400c}},	// [1430] _izitha_, _icyaha_, _zajímavé_, _खोज__शुरू_, 
   {{0x9bd96020,0x00000000,0x00000000,0x00000000}},	//   _རབས__ལས_, --, --, --, 
   {{0xc3042019,0xfaa7000a,0xe43ec002,0x00000000}},	//   _noe__annet_, _अच्छी_, _јавно_, --, 
   {{0x32246004,0x9291e01f,0x126d0012,0xd1dea00c}},	//   _ngok_, _akta_, _nebolo_, _जेकर_, 
   {{0xa7e4e018,0x733fe00e,0x00000000,0x00000000}},	//   _companhi, _ještě__jste_, --, --, 
   {{0x34952019,0x00000000,0x00000000,0x00000000}},	//   _om__hva_, --, --, --, 
   {{0x32916015,0x1cc58015,0xae1ce018,0x6495201a}},	//   _dijual__rumah_, _masukan__inputan_, _pergunta, _om__kva_, 
   {{0x62fb801f,0xacae0005,0x00000000,0x00000000}},	//   _kanak__kanak_, _forsking_, --, --, 
   {{0xc4438018,0x0750000a,0x035e800e,0x4b9e2006}},	//   _às_, _से__लिया_, _zahradní_, _དབྱིན__ལོ_, 
   {{0x33a2e00f,0x667d200c,0x00000000,0x00000000}},	//   _iziphi_, _क्रांतिय, --, --, 
   {{0x0bd14021,0xa25a0009,0x3492001a,0xa2438003}},	//   _ལུགས__ནང_, _spil_, _av__eit_, _གནའ_, 
   {{0xe291c00b,0x1dd0c00b,0x00000000,0x00000000}},	//   _ukwa_, _igikombe_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x059c003d,0xcad2e00b,0x00000000,0x00000000}},	//   _souhlasí, _mu__gisagara_, --, --, 
   {{0x9c8e000c,0xb442c00e,0x6d5f200b,0xc2428003}},	//   _कवनो_, _lze_, _serivisi__ishinzwe_, _དགར_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x0c49200a,0xec02400c,0x7ee9400a,0x00000000}},	// [1440] _मुझे_, _अपराधियन__के_, _सड़क_, --, 
   {{0xae2e4009,0x2afb8030,0xa3baa009,0x0495200f}},	//   _danmarks_, _zbunjen__normalan_, _alm__pris_, _no__eva_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xd2fc6009,0x4a74e00e,0xd381a037,0x1378000b}},	//   _gange_, _zprávy_, _pregunta_aprende_, _rubanza_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x699d0004,0x00000000,0x00000000,0x00000000}},	//   _kwakhona_, --, --, --, 
   {{0x34b3001a,0x7d24a00b,0x7eee6002,0x4f6e000f}},	//   _til__eit_, _yiyemeje__kugwanir, _је__по_, _israyeli__kankulun, 
   {{0x89726002,0x00000000,0x00000000,0x00000000}},	//   _редакциј, --, --, --, 
   {{0x43cc800b,0x00000000,0x00000000,0x00000000}},	//   _buri__munsi_, --, --, --, 
   {{0x65a1e00a,0x00000000,0x00000000,0x00000000}},	//   _रोहतक_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xda74e045,0x925a2019,0x0a72800c,0x9a5b400e}},	//   _správy_, _samliv_, _नगरी__में_, _jiných_, 
   {{0xc2cba00b,0x24b8401a,0x00000000,0x00000000}},	//   _neza__niba_, _talet__og_, --, --, 
   {{0xe413401e,0x2ccae003,0x4d4e8002,0x00000000}},	//   _bez__odobrenj, _རྒུ__མདོའི_, _референц_уреди_, --, 
   {{0x7f660018,0x00000000,0x00000000,0x00000000}},	//   _acabamen, --, --, --, 
   {{0x32d46018,0xb252a00b,0x00000000,0x00000000}},	//   _ajudar_, _ko__muri_, --, --, 
   {{0x6423800b,0x00000000,0x00000000,0x00000000}},	// [1450] _rya__boston_, --, --, --, 
   {{0x6ed90011,0x00000000,0x00000000,0x00000000}},	//   _accións_, --, --, --, 
   {{0x330d0018,0xa4a1001a,0x0b58a003,0x447de01c}},	//   _recados_, _når__dei_, _ནས__བཟུང_, _यमुना_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x3e386002,0xa252c037,0x0f9a0018,0x75ec8029}},	//   _bonitetn_izveštaj, _se__admite_, _dúvidas_, _སྐྱབས_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x0bd9c00a,0x00000000,0x00000000,0x00000000}},	//   _गया__था_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x4442c01b,0x73542011,0xc2aa8003,0x6389600f}},	//   _uze_, _galegas_, _གི__ཟིན_, _akuyona_, 
   {{0x1ba96039,0xd278600e,0x00000000,0x00000000}},	//   _karyawan_, _levné_, --, --, 
   {{0xe2510003,0x00000000,0x00000000,0x00000000}},	//   _ཡིན__ནའང_, --, --, --, 
   {{0xa26d8011,0xe1772002,0x3453600f,0x00000000}},	//   _noso_, _често_, _ukuthi__lo_, --, 
   {{0x43b6e018,0x0bcd200c,0x00000000,0x00000000}},	//   _orçament, _उदास__है_, --, --, 
   {{0xd386c00d,0x00000000,0x00000000,0x00000000}},	//   _leer_, --, --, --, 
   {{0x2375600c,0x00000000,0x00000000,0x00000000}},	//   _कवनो__कानून_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xaea3000f,0x0ed6e01a,0x00000000,0x00000000}},	// [1460] _usathane_, _ansvarle_redaktør_, --, --, 
   {{0x546d4037,0x5481c00e,0x00000000,0x00000000}},	//   _email__no_, _registro_se_, --, --, 
   {{0x2f1b8012,0x00000000,0x00000000,0x00000000}},	//   _vyše_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xf386c005,0x6ad24013,0xe5fe000f,0x00000000}},	//   _endre_, _बच्चे_, _ngoba__unkulunk, --, 
   {{0x4442400e,0xab8ec021,0x00000000,0x00000000}},	//   _byl_, _ཏོ_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x64424027,0x81f2a00a,0x00000000,0x00000000}},	//   _tym_, _एक__दूसरे_, --, --, 
   {{0x545f600e,0x8bef200c,0x00000000,0x00000000}},	//   _už__se_, _बा__का_, --, --, 
   {{0x170d800c,0x00000000,0x00000000,0x00000000}},	//   _के__कोना_, --, --, --, 
   {{0xe979a00e,0x3653c003,0x00000000,0x00000000}},	//   _bydlení_, _མཇལ__འཕྲད_, --, --, 
   {{0xfe8f4002,0xf26c601a,0xb481800b,0x00000000}},	//   _до__краја_, _enno_, _muri__uyu_, --, 
   {{0xfb1c2028,0xc456401a,0x02670002,0x00000000}},	//   _respuest, _skrive__av_, _делу_, --, 
   {{0xac5da01c,0xb25be003,0x9946c00a,0x1ade600f}},	//   _भी__नहीं_, _སྒེར__ཀྱི_, _जालौन__जौनपुर_, _iselulek_sebhayib, 
   {{0x39c6a00a,0x00000000,0x00000000,0x00000000}},	//   _क्रियेटि_कॉमन्स_, --, --, --, 
   {{0xe2b18012,0x13f9000f,0x00000000,0x00000000}},	//   _pridala_, _umbusi_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [1470] --, --, --, --, 
   {{0xede6c003,0xfbc3200a,0x00000000,0x00000000}},	//   _རང__སྐྱོང_, _करने__से_, --, --, 
   {{0xb48da025,0x4ec8e012,0x9f9b001a,0x8616c00e}},	//   _de__uma_, _zariaden, _tenester_, _zpracová, 
   {{0x4224c00f,0x9394c00d,0xf229c009,0x00000000}},	//   _bheka_, _pues_, _række_, --, 
   {{0x0ab38022,0x06f8200a,0x00000000,0x00000000}},	//   _वर्तमान__में_, _लिया_, --, --, 
   {{0xe9c2e024,0xda55a00b,0xc7e9800a,0x00000000}},	//   _vrednost, _ibiherut_kuvuguru, _मेरठ__मुरादाबा, --, 
   {{0x2301401f,0x92e9400c,0x00000000,0x00000000}},	//   _bergantu_kepada_, _के__नगरी_, --, --, 
   {{0x5442600b,0x00000000,0x00000000,0x00000000}},	//   _byo_, --, --, --, 
   {{0x6442600b,0xc394600d,0x1c15a003,0x0a84800c}},	//   _cyo_, _dios_, _རོགས__རམ_, _हजार__साल_, 
   {{0xa4020012,0x00000000,0x00000000,0x00000000}},	//   _dovolenk, --, --, --, 
   {{0xe3946018,0x32b8000f,0x00000000,0x00000000}},	//   _fios_, _abantu__abadala_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x13cf400d,0x5a32801c,0x8493a00b,0x0dfb8003}},	//   _nuevos_, _ऐसा_, _ko__nta_, _བྱ__དགོས_, 
   {{0x52bb0009,0x66db600c,0x9506200b,0xb7a3400e}},	//   _seneste_, _से__विकास_, _ibirimwo_, _podle__zkušenos, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xb3484015,0x00000000,0x00000000,0x00000000}},	//   _koneksi_, --, --, --, 
   {{0xabcdc022,0xa646c002,0xf26da018,0xaa01400f}},	// [1480] _सकी_, _пријави_, _topo_, _banganak_ukufinye, 
   {{0x84e9c00c,0x00000000,0x00000000,0x00000000}},	//   _एगो__प्रांत_, --, --, --, 
   {{0xa2e0a00c,0x2dd3c003,0x00000000,0x00000000}},	//   _देखीं_, _ཆུབ__སེམས_, --, --, 
   {{0x92d52018,0x4c48c00a,0x00000000,0x00000000}},	//   _mãe_, _रखें_, --, --, 
   {{0xe344000b,0x57904003,0x934e0018,0xcc6a600f}},	//   _amashaki_yawe_, _ཀྱི__སྲིད_, _edição_, _kumuntu_, 
   {{0xaa280037,0x231f2015,0x35a94012,0xf48e200a}},	//   _lugar__está_, _isi__artikel_, _formulár_, _खत्म_, 
   {{0x52a90011,0x6d2ee00b,0x00000000,0x00000000}},	//   _polo__menos_, _icyizere_, --, --, 
   {{0x7afd8012,0xd26dc012,0x0f60c017,0x34886010}},	//   _prípade_, _prvom_, _displeje_, _mere__på_, 
   {{0xe2572003,0x8bef8003,0x00000000,0x00000000}},	//   _དབུ__མའི_, _སྲོལ__ཆག_, --, --, 
   {{0x1492600d,0x00000000,0x00000000,0x00000000}},	//   _en__mi_, --, --, --, 
   {{0xc71ba003,0xe3f3600b,0xe468600f,0x00000000}},	//   _དྲ__བརྙན_, _tangaje__icese_, _kusho__ukuthi_, --, 
   {{0x3bd00020,0x69f7a017,0xe449600f,0xf144000c}},	//   _སྟག__ཚང_, _dodavate, _wayazi__ukuthi_, _में__जहरीली_, 
   {{0xe3946008,0x6bb22012,0xd796800b,0x00000000}},	//   _fins_, _stiahnuť_, _ryihariy_ribireng, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x4e38e031,0xe344a03d,0xcf248012,0x8c4f600c}},	//   _perawata, _baterie_, _je__veľmi_, _अतने_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6225e02e,0x00000000,0x00000000,0x00000000}},	// [1490] _nitko_, --, --, --, 
   {{0x54428015,0x00000000,0x00000000,0x00000000}},	//   _iya_, --, --, --, 
   {{0x94926005,0x32e4c018,0xf526c002,0xa78b400a}},	//   _av__ei_, _ou__seja_, _италијан, _हैं__विस्तार_, 
   {{0x94808013,0x8048600c,0x46a5400b,0x00000000}},	//   _हिमाचल_, _औद्योगिक__क्रांति_, _kurushah, --, 
   {{0x7290201d,0x434a800b,0x6442800b,0xd98e0002}},	//   _semasa_, _yarazwi__cane_, _jya_, _наших_, 
   {{0xe21c8002,0x439fc034,0x8bf62006,0x00000000}},	//   _да__бисте_, _på__engelsk_, _རམ__ཕན_, --, 
   {{0x8270602e,0x00000000,0x00000000,0x00000000}},	//   _prije__sati_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x0aac400a,0x00000000,0x00000000,0x00000000}},	//   _खोलने__में_, --, --, --, 
   {{0xe68f2006,0xf2b1e03f,0xadc7c002,0xc25c0003}},	//   _བཏུབ_, _yindoda_, _како__су_, _སྒེར__གྱི_, 
   {{0xd442802c,0xd7082018,0x58f4e012,0x00000000}},	//   _aya_, _impressã, _všetkým_, --, 
   {{0xe442800b,0xadd46002,0xe222c00f,0x91f52002}},	//   _bya_, _то__су_, _ukuthi__lapho_, _смрти_, 
   {{0xf442800b,0x00000000,0x00000000,0x00000000}},	//   _cya_, --, --, --, 
   {{0x72c1a00b,0x00000000,0x00000000,0x00000000}},	//   _ya__yobowe_, --, --, --, 
   {{0x94b36005,0x5acdc013,0xabd3c00a,0x00000000}},	//   _til__ei_, _भाजपा_, _सावंत__की_, --, 
   {{0xf2bb600f,0xeb954003,0x00000000,0x00000000}},	//   _kumelwe_, _ཁྲན__ཏང_, --, --, 
   {{0x6c06600a,0xfe372035,0xd478400b,0xd290202c}},	// [14a0] _किसी__भी_, _kungakha, _rwego__rw_, _bamaze_, 
   {{0x4460c00f,0x91d4600c,0x00000000,0x00000000}},	//   _okwengez, _कऽ__लीहल_, --, --, 
   {{0xc3eb801a,0xc38b2009,0x82ab2009,0x00000000}},	//   _vart_, _kørte_, _købte_, --, 
   {{0x846e800e,0xcaaa600c,0x00000000,0x00000000}},	//   _paměť__ram_, _एही__बात_, --, --, 
   {{0xfc0e000c,0xe4930012,0x00000000,0x00000000}},	//   _राजा__से_, _uložiť__na_, --, --, 
   {{0x02cae009,0xf2a52003,0xa5a6800e,0x00000000}},	//   _fundet_, _སྐྱེ__རྒུ_, _připomín, --, 
   {{0xeb990003,0x12ab2009,0xe248800d,0x00000000}},	//   _གཞུང__གི_, _løbet_, _llama_, --, 
   {{0x623fe00e,0x00000000,0x00000000,0x00000000}},	//   _podle__čeho_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7422000b,0xcb264002,0x00000000,0x00000000}},	//   _yicisha__bugufi_, _не__можете_, --, --, 
   {{0x2bcde056,0x92c14018,0x00000000,0x00000000}},	//   _हवे_, _abaixo__comentár, --, --, 
   {{0x32b48012,0xe4780016,0x4ecd0002,0x53b8000e}},	//   _viac_, _innholde_er_, _одустани__од_, _provozu_, 
   {{0x3b94c00c,0x2aab0012,0x00000000,0x00000000}},	//   _रहल__बा_, _množstvo_, --, --, 
   {{0xad7ee002,0x79764018,0x52006015,0xf32de009}},	//   _су_, _atendime, _senin_, _den__måde_, 
   {{0xd44bc002,0x00000000,0x00000000,0x00000000}},	//   _изборима_, --, --, --, 
   {{0x1442801b,0x3248000f,0xe7f2600f,0x00000000}},	// [14b0] _uya_, _ulimi_, _amazwi__acashunw, --, 
   {{0xd242a006,0x00000000,0x00000000,0x00000000}},	//   _བླམ_, --, --, --, 
   {{0xac606011,0xee54600f,0x00000000,0x00000000}},	//   _algunha_, _olwandle_, --, --, 
   {{0xe897801d,0x424c6003,0xb069e002,0x00000000}},	//   _kali__terakhir_, _ཇུས_, _политика__приват_, --, 
   {{0x7b8ca003,0x1144e037,0x00000000,0x00000000}},	//   _དྲ_, _por__inténtel, --, --, 
   {{0xe376c002,0xeb96c014,0x00000000,0x00000000}},	//   _српског_, _दक्षिण__के_, --, --, 
   {{0x8226601a,0x00000000,0x00000000,0x00000000}},	//   _kyrkje_, --, --, --, 
   {{0xd2576003,0x00000000,0x00000000,0x00000000}},	//   _གླེང__ཀུན_, --, --, --, 
   {{0x228f800e,0x00000000,0x00000000,0x00000000}},	//   _takové_, --, --, --, 
   {{0xf2c94018,0xc3f8200f,0xacf0a00a,0xba4aa002}},	//   _suporte_, _nomusa_, _पाठकों_, _идиоми__види_, 
   {{0x17d5c00f,0x93c5800e,0x00000000,0x00000000}},	//   _amaphoyi, _vypadá_, --, --, 
   {{0xebe36015,0x49dc200c,0x00000000,0x00000000}},	//   _komentar, _काफी__समानता_, --, --, 
   {{0x02ace006,0x00000000,0x00000000,0x00000000}},	//   _སྟེ__ཡོད_, --, --, --, 
   {{0xa3ce400b,0x00000000,0x00000000,0x00000000}},	//   _kumva_, --, --, --, 
   {{0x649cc037,0x0b9e200a,0x00000000,0x00000000}},	//   _inténtel_de_, _एक__और_, --, --, 
   {{0x34f7e00c,0x00000000,0x00000000,0x00000000}},	//   _आजु__स्थिति_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [14c0] --, --, --, --, 
   {{0xa316c012,0x00000000,0x00000000,0x00000000}},	//   _naozaj_, --, --, --, 
   {{0xf2502002,0xf221c00a,0x00000000,0x00000000}},	//   _жена_, _फ़रवरी__जनवरी_, --, --, 
   {{0xe496c030,0x03b66011,0x7be46006,0xdd478002}},	//   _pridruže_okt_, _outras__linguas_, _བཙུགས__ནི_, _животу_, 
   {{0xe6496012,0x00000000,0x00000000,0x00000000}},	//   _pracovný, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x33cf400d,0xe2c3000b,0x00000000,0x00000000}},	//   _nuevas_, _idasanzw_ukwa_, --, --, 
   {{0xf26d8038,0xf3a3c00c,0x00000000,0x00000000}},	//   _muros_, _अउरी__भोजपुरी_, --, --, 
   {{0x4b15a003,0x00000000,0x00000000,0x00000000}},	//   _གཞས__ལྷུག_, --, --, --, 
   {{0xc3330011,0x2425800f,0x9a9b200c,0x0292400b}},	//   _imaxes_, _lezi__zinto_, _जा__रहल_, _matayo_, 
   {{0xd5fda014,0x7ae2a019,0x00000000,0x00000000}},	//   _पटकथा_, _viktigst, --, --, 
   {{0x438ca025,0x6367000b,0x2276a002,0x00000000}},	//   _de__janeiro_, _boston__ikigega_, _октобар__нема_, --, 
   {{0x54bae009,0x66248011,0x00000000,0x00000000}},	//   _godt__om_, _tecnolox, --, --, 
   {{0xbc10e022,0x70b22012,0xd3dfc009,0x2c00400c}},	//   _जहां__तक_, _reštaurá, _de__sidste_, _खाती__एगो_, 
   {{0xc26d8018,0x1280a016,0xac26c00a,0x00000000}},	//   _juros_, _brukere_, _उदयपुर__कपूरथला_, --, 
   {{0xc25ec006,0x4255000b,0x80ff600a,0x00000000}},	//   _ལེན__འབད_, _papa__mushya_, _सोनभद्र__शाहजहाँप, --, 
   {{0x547f2011,0x9414201d,0x3474601a,0xef3a0002}},	// [14d0] _unha__vez_, _nak__buat_, _dei__på_, _припадни, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xc320a00e,0x00000000,0x00000000,0x00000000}},	//   _nebyl_, --, --, --, 
   {{0xe455600f,0x00000000,0x00000000,0x00000000}},	//   _wachaza__ukuthi_, --, --, --, 
   {{0xebb60038,0x888c800a,0x00000000,0x00000000}},	//   _da__historia_, _पौड़ी__बागेश्वर_, --, --, 
   {{0xda76600a,0x3200c01f,0x930e4011,0xa313a00c}},	//   _हॉट__एंड_, _sedia_, _engadir_, _अपना__असली_, 
   {{0x66af2022,0x6200401f,0x37f1a003,0x00000000}},	//   _अतीत_, _belia_, _འགྲོ__བཞིན_, --, 
   {{0x93e3e00e,0xbd6a0009,0x722a0009,0x6fd88018}},	//   _zadat__rozpětí_, _tilmeldt_, _tilmeld_, _comentár_até_, 
   {{0x62428006,0x04876022,0xdbaa2002,0x00000000}},	//   _དགོ_, _अंदाजा_, _парламен, --, 
   {{0x638bc026,0x655a2028,0xd2ea801d,0xf1f8800f}},	//   _været_, _los__términos_, _dialami__kerana_, _wakhulum, 
   {{0x1c4d8011,0x8af38011,0x652dc00f,0xa200c012}},	//   _de__persoas_, _estranxe, _ngenkath, _koniec_, 
   {{0x238ca011,0xa598c00a,0x2dd6a00b,0x104d2002}},	//   _de__xaneiro_, _मंच__बिज़नस_, _abajejwe_, _врсте_, 
   {{0xa3fb4009,0x8442c00b,0x522a0002,0x00000000}},	//   _den__bedste_, _jye_, _пола_, --, 
   {{0xb442c016,0x9b9fc021,0xa711e00a,0x768e6018}},	//   _mye_, _སྐྱོང__ལས_, _कर__दिया_, _profissi, 
   {{0x6b480003,0xa664a012,0x2d14a002,0x00000000}},	//   _ནག__གཞུང_, _služieb_, _руски__српски_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6d23e012,0x0bb2e00c,0x00000000,0x00000000}},	// [14e0] _ponúkame_, _एगो__राष्ट्री, --, --, 
   {{0x24aaa01a,0xf351200e,0xe2438003,0x00000000}},	//   _ein__kan_, _osobních__údajů_, _ཀླུ_, --, 
   {{0x0ce1a018,0x00000000,0x00000000,0x00000000}},	//   _estrelas__estrela_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa386c00d,0xe9472002,0x1442c00b,0x6fb9a00f}},	//   _enero_, _питање_, _cye_, _emuva__kwesikha, 
   {{0x24aa2010,0xca11600b,0x00000000,0x00000000}},	//   _der__kan_, _barakome, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xbe0b0006,0x184cc006,0xff238007,0x34ace00d}},	//   _བརྒྱའི_, _དང__འཁྲིལ_, _cemerlan, _con__lo_, 
   {{0x7e74a01d,0xfb234039,0xa3870012,0x00000000}},	//   _peluang__pekerjaa, _dibangun_, _pozri_, --, 
   {{0x24798034,0x9471c00b,0xeb1fc003,0x2eae4002}},	//   _litterat_og_, _imico__ya_, _བྱས__འདུག_, _тако__је_, 
   {{0x6275200f,0x00000000,0x00000000,0x00000000}},	//   _zonke__lezi_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x9967402a,0x48674009,0x3a60a028,0xbd23e00b}},	//   _mulighet, _mulighed, _sueños_, _umusarur, 
   {{0xc4afc01a,0x0fd9800f,0x4af78003,0x7b8fc013}},	//   _delar__av_, _okungoko, _ལྷོ__ཕྱོགས_, _सच_, 
   {{0xbab8201a,0x00000000,0x00000000,0x00000000}},	//   _meir__informas, --, --, --, 
   {{0xdebd600f,0x00000000,0x00000000,0x00000000}},	// [14f0] _izingxen, --, --, --, 
   {{0x0442c00b,0x00000000,0x00000000,0x00000000}},	//   _rye_, --, --, --, 
   {{0x2dd8a003,0x925ac011,0xbc4a200c,0x0dfc0003}},	//   _བཅུ__གཉིས_, _mellor_, _शासनकाल_, _མི__དགོས_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x826e8003,0x3de36003,0x00000000,0x00000000}},	//   _དྲ__ཐོག_, _འདྲི__དམངས_, --, --, 
   {{0x128c0002,0x3b9e200c,0xbb88c01c,0xeb1a4003}},	//   _profil__slanje_, _के__एह_, _प्_, _རེད__འདུག_, 
   {{0xd3ea8015,0xe2e7000f,0x8664400e,0x00000000}},	//   _obat_, _imibhalo__yaphansi_, _přidala__příspěvk, --, 
   {{0x1a5c601d,0x2e7a000a,0x3520e00c,0x00000000}},	//   _di__malaysia_, _अमरोहा__जालौन_, _बा__काहेंकि_, --, 
   {{0xfea68002,0x00000000,0x00000000,0x00000000}},	//   _расистич_или_, --, --, --, 
   {{0x7712e00c,0x00000000,0x00000000,0x00000000}},	//   _शब्दन_, --, --, --, 
   {{0xf330e00e,0x00000000,0x00000000,0x00000000}},	//   _vloženo_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x84270011,0x3b94c00c,0x579fc003,0x00000000}},	//   _polo__tanto_, _साफ__बा_, _སྤྱོད__བྱེད_, --, 
   {{0x73f46016,0xd2c20011,0x1645a012,0x00000000}},	//   _bosted_, _os__datos_, _pridať__komentár_, --, 
   {{0x830aa015,0x75ad4014,0x228b8003,0x00000000}},	//   _langsung__bisa_, _भी__भारत_, _ཆེད__མཁས_, --, 
   {{0x89594049,0x5db3e006,0xe1ab200f,0x163f2012}},	//   _वैयक्तिक_, _ལུ__འབྱོན_, _igama__likankul, _kalendár_, 
   {{0x73cec028,0x1ca18018,0x2a60c002,0x4bf64037}},	// [1500] _nuevo_, _em__contato_, _неће__бити_, _enero__diciembr, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x50b62002,0x506d2002,0x00000000,0x00000000}},	//   _од__године_, _је__године_, --, --, 
   {{0xa3ebe019,0x0a138018,0x00000000,0x00000000}},	//   _satt_, _não__será_, --, --, 
   {{0xb9932011,0x6243a00c,0x00000000,0x00000000}},	//   _lupa__imprimir_, _लिहलस_, --, --, 
   {{0x4ed26002,0xd2a0000f,0xa462001a,0x23648012}},	//   _да__не_, _ngojesu_, _før__dei_, _rozšíren, 
   {{0x3d00800b,0x00000000,0x00000000,0x00000000}},	//   _icyumwer, --, --, --, 
   {{0x63910002,0xcbcf2014,0x00000000,0x00000000}},	//   _свих_, _रणनीतिक_, --, --, 
   {{0xc2f3a007,0x768c400a,0x00000000,0x00000000}},	//   _seorang__lelaki_, _हिसार_, --, --, 
   {{0xca67200d,0x00000000,0x00000000,0x00000000}},	//   _el__problema_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xd4754004,0x5249200e,0x1bdf8003,0x00000000}},	//   _ngoko__ke_, _přihláše, _ངོས__ནས_, --, 
   {{0x3da78012,0x22b68016,0x444ac008,0xdc2ca009}},	//   _keď_, _privat__melding_, _artigo__da_, _dk__accepter, 
   {{0x6a9b200a,0x00000000,0x00000000,0x00000000}},	//   _जा__रहा_, --, --, --, 
   {{0xc251c003,0x84936009,0x3ae2400c,0x00000000}},	//   _ཡིན__པའི_, _er__nu_, _के__चर्चा_, --, 
   {{0x33ea801d,0xda01a00b,0xf5a1000e,0xb563c002}},	//   _ubat_, _imbaraga_, _vynikají, _агенција_, 
   {{0x79cd200b,0x00000000,0x00000000,0x00000000}},	// [1510] _bishobok_shakisha_, --, --, --, 
   {{0x4e19200b,0xbc03000c,0x00000000,0x00000000}},	//   _ubuzima__busanzwe_, _बानीं__जा_, --, --, 
   {{0xf492001a,0xe2ac800f,0x00000000,0x00000000}},	//   _er__òg_, _abanye__ukuba_, --, --, 
   {{0x0473a009,0x00000000,0x00000000,0x00000000}},	//   _anvendes__som_, --, --, --, 
   {{0x73a86037,0xc25c8003,0x5084800c,0x00000000}},	//   _si__quieres_, _སྐོར__གྱི_, _प्रसाद__सिंह_, --, 
   {{0x6dcc6003,0xafd10003,0x22ada003,0x00000000}},	//   _གོམ__བགྲོད_, _པའི__རྒྱུ_, _ཐང__ཡོན_, --, 
   {{0xebbbc00c,0xd3d8a00c,0x2274a003,0x00000000}},	//   _चोरी__के_, _मुजाहिदी, _ཕལ__ཆེར_, --, 
   {{0x1c90a007,0xd478e00a,0x0ba74013,0x00000000}},	//   _sekurang_, _दिन__महीने_, _है__वो_, --, 
   {{0xb4ba4025,0xd73fc003,0xf2bfa012,0xb30de00e}},	//   _como__um_, _བཟོད_, _náhradné__diely_, _os__více_, 
   {{0x12fa8008,0x0a79a022,0x00000000,0x00000000}},	//   _con__esta_, _नेपाल__में_, --, --, 
   {{0xebb0200c,0x00000000,0x00000000,0x00000000}},	//   _रहस्यन__के_, --, --, --, 
   {{0x05ad600c,0x00000000,0x00000000,0x00000000}},	//   _के__खोजत_, --, --, --, 
   {{0xabba4006,0xd6dce00c,0x00000000,0x00000000}},	//   _ལས__ཚན_, _बाकिर_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x22a84003,0xfc72e003,0x00000000,0x00000000}},	//   _ཚད__གཞི_, _བདེའི_, --, --, 
   {{0x52a6400e,0xb0c7c002,0x00000000,0x00000000}},	//   _volby_, _линије_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [1520] --, --, --, --, 
   {{0xeef2600f,0xe46ae027,0x00000000,0x00000000}},	//   _kunkulun, _ako__na_, --, --, 
   {{0x5ae30009,0x00000000,0x00000000,0x00000000}},	//   _vigtigst, --, --, --, 
   {{0x93660019,0xebe3a014,0xb2e0a00b,0x00000000}},	//   _offentli_profil_, _ले__के_, _ukwa__karindwi_, --, 
   {{0xd11c6012,0x00000000,0x00000000,0x00000000}},	//   _dôležité_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xf2d1200b,0xa2b00003,0x00000000,0x00000000}},	//   _igomba__kuba_, _རྩ__དོན_, --, --, 
   {{0xb26c200e,0xb3dde00b,0x00000000,0x00000000}},	//   _jako_, _natwe_, --, --, 
   {{0xb386c01a,0xcda7800e,0xec05400c,0xfbd1200c}},	//   _endra_, _teď_, _उपाध्याय__के_, _अछि__से_, 
   {{0xd28ae01a,0x5470600f,0x3fae8012,0x00000000}},	//   _som__gjeld_, _uma__nje_, _obyvateľ, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x3bd9a011,0x54afc011,0x4314e018,0x00000000}},	//   _de__rexistro_, _ficheiro__uso_, _negócios_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x56d22047,0xdc5c8022,0x828ba006,0xa2e1e00c}},	//   _दैनिक_, _बलदेव_, _ཨིང__ཚིག_, _नइखीं_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x52006015,0xbbfb800d,0xf4bda009,0xabc2800c}},	//   _menit_, _septiemb, _hvis__der_, _ओही_, 
   {{0xbd20600a,0x00000000,0x00000000,0x00000000}},	// [1530] _या__व्यक्तिग, --, --, --, 
   {{0x4207a006,0xfc49200c,0x92d88012,0x8201c00b}},	//   _དཔལ__འཛོམས_, _बाटे_, _ihneď_, _ubuhinzi_, 
   {{0x0186800f,0x12e5800b,0x00000000,0x00000000}},	//   _bakankul, _wa__leta_, --, --, 
   {{0x346ae012,0x00000000,0x00000000,0x00000000}},	//   _ako__sa_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xd47f6011,0x84912018,0x99a1e00e,0x324c6003}},	//   _polo__que_, _coração_, _nejoblíb_mobilní_, _ཆུབ_, 
   {{0x7c39a00e,0xc2924003,0xc298a003,0x00000000}},	//   _सम्पादन_, _འདས__པའི_, _པའི__དེབ_, --, 
   {{0xbe5f0009,0x00000000,0x00000000,0x00000000}},	//   _specielt_, --, --, --, 
   {{0xe2a6001a,0xfa0fe015,0xc7a2200a,0x9a4d600c}},	//   _endre__denne_, _manajeme, _ज्ञानकोष__विकिपीडि, _गो__लोग_, 
   {{0xda1c8011,0x79cfc00f,0x87cd4002,0x0d696002}},	//   _de__ponteved, _osemusha_, _сопствен, _представ_тј_, 
   {{0x3493001a,0x9466201d,0xd768800c,0x00000000}},	//   _er__eit_, _julai__pukul_, _के__मान्यता_, --, 
   {{0x33de2005,0x738bc009,0xf477200b,0x8919a002}},	//   _meny__hopp_, _hårdt_, _gihe__cya_, _александ_вучић_, 
   {{0x8280c018,0x9b9d8003,0x00000000,0x00000000}},	//   _utiliza__conhecim, _ཡོད__ཚད_, --, --, 
   {{0x3474001a,0xbab5200a,0x8c59200c,0x00000000}},	//   _som__eit_, _स्थल__मां_, _के__नइखे_, --, 
   {{0x3297e006,0x00000000,0x00000000,0x00000000}},	//   _བཅས__རའི_, --, --, --, 
   {{0x9b976022,0x00000000,0x00000000,0x00000000}},	//   _के__मन_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [1540] --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x4372803d,0x7a57200e,0xec0c0014,0x00000000}},	//   _katalog_, _peníze_, _दौर__के_, --, 
   {{0x8ed52002,0x4d5a2002,0x00000000,0x00000000}},	//   _том_, _коме_, --, --, 
   {{0x89d3801a,0x00000000,0x00000000,0x00000000}},	//   _på__vilkåra_, --, --, --, 
   {{0xfc22e005,0x5b57c006,0x1beca00a,0x00000000}},	//   _oppslags, _ལས__རྫོང_, _पर__एक_, --, 
   {{0x42010040,0xa2534003,0x2665800e,0x42cae018}},	//   _srbije_, _ཡོད__མེད_, _děkujeme_, _sair__mudar_, 
   {{0xa1acc00e,0x00000000,0x00000000,0x00000000}},	//   _pondělí_, --, --, --, 
   {{0xebe32022,0x00000000,0x00000000,0x00000000}},	//   _तक__के_, --, --, --, 
   {{0x8d492002,0xe29b6020,0x6658800b,0x00000000}},	//   _три_, _བཙུགས__གནང_, _ntabwo__yishingi, --, 
   {{0x93cec00d,0xc2b3e018,0xd88ca003,0x00000000}},	//   _nueva_, _se__não_, _གོ__སྒྲིག_, --, 
   {{0x0a8ee00c,0x00000000,0x00000000,0x00000000}},	//   _संगोष्ठी__में_, --, --, --, 
   {{0xa6f90013,0x00000000,0x00000000,0x00000000}},	//   _दिया_, --, --, --, 
   {{0x23328011,0x00000000,0x00000000,0x00000000}},	//   _imaxe_, --, --, --, 
   {{0xa23a2003,0x00000000,0x00000000,0x00000000}},	//   _མཐུད__རྩོམ_, --, --, --, 
   {{0xcb7c600f,0x00000000,0x00000000,0x00000000}},	//   _ekhulu__lokuqala_, --, --, --, 
   {{0x22bdc00d,0x00000000,0x00000000,0x00000000}},	// [1550] _lo__mejor_, --, --, --, 
   {{0x9b42c00f,0x00000000,0x00000000,0x00000000}},	//   _ababonis, --, --, --, 
   {{0xb2438003,0x67dfe004,0x92430003,0x72640017}},	//   _ཀླད_, _zibe__bubungqi, _མགོ_, _poslat_, 
   {{0x7a9c800a,0x5837c002,0x00000000,0x00000000}},	//   _चुके__हैं_, _налазе_, --, --, 
   {{0x1c538011,0x00000000,0x00000000,0x00000000}},	//   _contido_, --, --, --, 
   {{0xbc07400a,0xa315e018,0xc6c0000c,0x00000000}},	//   _तौर__पर_, _horário_, _खाती__सरकार_, --, 
   {{0x2c45400a,0x00000000,0x00000000,0x00000000}},	//   _सहारनपुर__सिद्धार्, --, --, --, 
   {{0x226fc00b,0xca4d800c,0x00000000,0x00000000}},	//   _imbuga__zayo_, _के__भोज_, --, --, 
   {{0xc4438038,0xea14c009,0x8757600a,0x4497a025}},	//   _ás_, _forbruge, _और__अपना_, _criação_, 
   {{0x23a2e00f,0x33f8600e,0x712d0002,0xf3ce6018}},	//   _iyiphi_, _dvou_, _зашто_, _prova_, 
   {{0x3305000b,0x6707800c,0x00000000,0x00000000}},	//   _izindi__mbuga_, _के__रचना_, --, --, 
   {{0xc2d8200b,0x5340c00c,0xa298c003,0x00000000}},	//   _komeza_, _उसकी__मगही_, _ཀྱི__མེད_, --, 
   {{0xd26c4039,0x4e28e002,0x34b3801a,0xd942e012}},	//   _kalo_, _па_, _var__eit_, _vyhlásen, 
   {{0x23a68012,0x513f600f,0xc25aa003,0xac68000b}},	//   _je__potrebné_, _ethempel, _ཡུལ__གྱི_, _bihumbi_, 
   {{0xf26c4012,0x75c5401f,0xc03f600d,0x1387a018}},	//   _malo_, _memboleh, _los__producto, _livros_, 
   {{0x22302018,0x90372012,0xbe21600a,0x424da003}},	//   _seu__email_, _cestovan, _नच__बलिए_, _ཧོར_, 
   {{0x92f7a004,0x226b8009,0x02d18018,0x00000000}},	// [1560] _liphela__zibe_, _misbrug__skriv_, _descriçã_produto_, --, 
   {{0x02018010,0x44302025,0x00000000,0x00000000}},	//   _årig_, _processo_, --, --, 
   {{0x8468401d,0x8497a011,0x0387e018,0xc888e002}},	//   _kehilang_atau_, _de__xestión_, _couro_, _наставни, 
   {{0xf303e037,0x3cec4006,0x00000000,0x00000000}},	//   _regístra, _སླབ__སྲོལ_, --, --, 
   {{0x42d82011,0xd2b62002,0x224e0003,0x00000000}},	//   _comeza_, _још__један_, _དཔར__གཞི_, --, 
   {{0xf3aa0037,0x00000000,0x00000000,0x00000000}},	//   _en__ninguna_, --, --, --, 
   {{0x23f8600e,0x2e706002,0x2ec64002,0x00000000}},	//   _svou_, _је__из_, _ју__је_, --, 
   {{0x4d9d6003,0x00000000,0x00000000,0x00000000}},	//   _བསྐྱར__བཅོས_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x3675600f,0x7473e012,0x74ab001a,0xebaea00a}},	//   _ngokugcw, _ste__si_, _ein__dag_, _क्रिकेट__के_, 
   {{0x68c38018,0x00000000,0x00000000,0x00000000}},	//   _pesquisa__realizad, --, --, --, 
   {{0x3a2e2018,0x123be00e,0xe46b600b,0xf9f22002}},	//   _tente__novament, _můj_, _ari__na_, _порука_, 
   {{0x5a4be00c,0xe0bea00a,0x00000000,0x00000000}},	//   _हो__ऐसा_, _हाथरस__हापुड़_, --, --, 
   {{0x2ea6a00b,0x00000000,0x00000000,0x00000000}},	//   _icarimwe_, --, --, --, 
   {{0xccee2002,0x72c8800b,0xa26c2003,0x00000000}},	//   _град_, _kane__gasana_, _ཅི__ཞིག_, --, 
   {{0x64746018,0x00000000,0x00000000,0x00000000}},	//   _carrinho__de_, --, --, --, 
   {{0x1b65a033,0x5473a01a,0xaef3c022,0xd863201a}},	// [1570] _coolinar, _sjølv__om_, _इलाका_, _spennand, 
   {{0xd4ae0009,0x548d600f,0xde8ce002,0x00000000}},	//   _udgivet__den_, _ngemva__nje_, _је__већ_, --, 
   {{0xeadac003,0x3a452002,0xa45b000f,0x00000000}},	//   _ཡོད__འདུག_, _izveštaj_, _izidingo_, --, 
   {{0xdeea002a,0x34aa0016,0x92b96011,0xb4b0400f}},	//   _som__gjør_, _flere__enn_, _conta__nova_, _ezingaba__ngu_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x5eefc022,0x00000000,0x00000000,0x00000000}},	//   _आतंक_, --, --, --, 
   {{0xee3d800e,0xc415a014,0x0ab1400a,0x834e000b}},	//   _přejít_, _के__शानदार_, _जीवन__में_, _bo__hambere_, 
   {{0xc2ace020,0xee304002,0x00000000,0x00000000}},	//   _འཕྲུལ__རིག_, _каже__да_, --, --, 
   {{0xb52b201c,0x015b600f,0x00000000,0x00000000}},	//   _का__कारण_, _esigcwel, --, --, 
   {{0x99e5001a,0x00000000,0x00000000,0x00000000}},	//   _og__kyrkjede, --, --, --, 
   {{0xb2e6a01a,0x00000000,0x00000000,0x00000000}},	//   _ein__venn_, --, --, --, 
   {{0xa292c003,0xc4b88011,0x00000000,0x00000000}},	//   _གིས__བོད_, _como__non_, --, --, 
   {{0xe291002c,0x9be6c006,0x72df2025,0x00000000}},	//   _yabaye_, _རའི__མི_, _em__geral_, --, 
   {{0xb22a2002,0x00000000,0x00000000,0x00000000}},	//   _доба_, --, --, --, 
   {{0xcc31a00a,0x4303200f,0x12d7000e,0x7253c00b}},	//   _ने__बताया_, _marku__luka_, _všechny__komentář, _mu__muji_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [1580] --, --, --, --, 
   {{0xa248001a,0x3aa90002,0x00000000,0x00000000}},	//   _heim_, _решење_, --, --, 
   {{0xd20e2002,0xeba6c00a,0x026c600d,0x00000000}},	//   _дана_, _है__इस_, _mano_, --, 
   {{0x02d36003,0x9b9ca00c,0x00000000,0x00000000}},	//   _དགའ__ཡོད_, _के__कि_, --, --, 
   {{0x6bd7600b,0x9387e017,0xac0e0003,0x7617c00c}},	//   _niba__washobor, _petr_, _ཚིགས__དེ_, _कइके__रिपोर्ट_, 
   {{0x25c2c002,0x1480a00a,0x00000000,0x00000000}},	//   _књига_, _युवाओं_, --, --, 
   {{0x4e296002,0xe2b8000b,0x00000000,0x00000000}},	//   _тај_, _leta__rwanda_, --, --, 
   {{0x7ec04002,0xd45b202f,0x00000000,0x00000000}},	//   _су__се_, _será__que_, --, --, 
   {{0x027f400d,0x4b2a0003,0x53de4018,0x8b9f4002}},	//   _cuenta_, _སྙིང_, _avaliaçõ, _уз__помоћ_, 
   {{0xe27f2028,0x0323600f,0x00000000,0x00000000}},	//   _el__primero_, _ukuzipha_okubi_, --, --, 
   {{0xfe6ae006,0x91ee4018,0x00000000,0x00000000}},	//   _གྱི__བསྒྱུར_, _promoção_, --, --, 
   {{0x4670000a,0x046d601a,0x1e888002,0x32942003}},	//   _दर्शन__ज्योतिष_, _kva__som_, _да__нам_, _བཅའ__སོག_, 
   {{0xbcf42012,0x00000000,0x00000000,0x00000000}},	//   _septembr, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x738b2005,0x6ba8e006,0x82de000f,0x00000000}},	//   _førde_, _སྨོང__གར_, _yilokhu_, --, 
   {{0x2be9800c,0x00000000,0x00000000,0x00000000}},	//   _कि__एगो_, --, --, --, 
   {{0xeb8e600a,0xec036007,0x0480c037,0x172e400c}},	// [1590] _इस_, _kampung_, _pregunte_por_, _रहल__बाड़ी_, 
   {{0xb44b8004,0x7ba5a003,0x00000000,0x00000000}},	//   _lo__mntu_, _བྲིས__དྲ_, --, --, 
   {{0x9493601a,0xc5d0e00f,0x00000000,0x00000000}},	//   _er__ei_, _ubuqotho_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2c734003,0x8aa9a00f,0x9bc8a00c,0xed270002}},	//   _མདོའི_, _ngokusob, _बाड़ी__सऽ_, _сасвим_, 
   {{0xe3eaa009,0x94746005,0x00000000,0x00000000}},	//   _indtil_, _som__ei_, --, --, 
   {{0xb32c802d,0xb47e4037,0xca4b600a,0xb2018025}},	//   _se__putem_, _autoprom_el_, _की__बात_, _teria_, 
   {{0xc37ca00b,0xc2d4a012,0x00000000,0x00000000}},	//   _yasabye_, _alebo__jeho_, --, --, 
   {{0x47102003,0x00000000,0x00000000,0x00000000}},	//   _ནང__བསྟན_, --, --, --, 
   {{0xc2644003,0x12596003,0x00000000,0x00000000}},	//   _རྒྱ__ཡིག_, _དོན__ཆེད_, --, --, 
   {{0xaa7da012,0x00000000,0x00000000,0x00000000}},	//   _pričom_, --, --, --, 
   {{0x0ed5800e,0xc3c1c030,0x2f2b200e,0x00000000}},	//   _již_, _po__kantonim, _více__než_, --, 
   {{0xfb8e600a,0x25502002,0x00000000,0x00000000}},	//   _उस_, _неколико_, --, --, 
   {{0x9399e025,0x00000000,0x00000000,0x00000000}},	//   _até__agora_, --, --, --, 
   {{0x57e6001c,0x00000000,0x00000000,0x00000000}},	//   _शाहरुख_, --, --, --, 
   {{0x8b8ac002,0x84b6e00a,0x82384002,0xa2a0a003}},	//   _помоћ_, _शर्तें_, _овај__чланак_, _ངོས__འདི_, 
   {{0x40f56002,0x00000000,0x00000000,0x00000000}},	// [15a0] _презимен_срба_, --, --, --, 
   {{0x74746027,0x7bd70003,0x00000000,0x00000000}},	//   _som__si_, _སྙན__ངག_, --, --, 
   {{0xfc06a00a,0x54d4e01d,0xfafa401f,0x00000000}},	//   _सहमत__असहमत_, _anda__bersetuj, _pengurus, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x0fea402e,0xac0ea00e,0xfbdba00c,0x00000000}},	//   _dubrovač, _více__frekvenc, _के__इहो_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x92d7802a,0x00000000,0x00000000,0x00000000}},	//   _gjelder_, --, --, --, 
   {{0x76f8200a,0x41b8200c,0x1598200c,0x00000000}},	//   _लिखा_, _लिखल_, _लिखत_, --, 
   {{0x6225800f,0x125ac01a,0x92cae009,0x00000000}},	//   _marku_, _vanleg_, _hendes_, --, 
   {{0xd2d7801a,0x00000000,0x00000000,0x00000000}},	//   _kjelder_, --, --, --, 
   {{0xacefe003,0xf0f5a006,0x64746018,0x00000000}},	//   _འདོན__སྤེལ_, _རྗོད__སྒྲ_, _listagem__de_, --, 
   {{0x8bf2c00c,0x00000000,0x00000000,0x00000000}},	//   _बांग्लाद_का_, --, --, --, 
   {{0xe4444004,0x14bb2030,0x00000000,0x00000000}},	//   _az_, _siteu__bez_, --, --, 
   {{0x54b3200b,0xd9016014,0x64b52025,0x04ad6027}},	//   _abarorer_ku_, _बहुसंख्य, _confirma_de_, _že__som_, 
   {{0x0444403d,0xeb094011,0x00000000,0x00000000}},	//   _cz_, _composte, --, --, 
   {{0x84b4c015,0x94b4602f,0x00000000,0x00000000}},	//   _topic__di_, _por__ou_, --, --, 
   {{0x03958034,0xeb8e000f,0xbc39c012,0x12904003}},	// [15b0] _viss_, _yiqiniso_, _detská_, _དམིཊ__བསལ_, 
   {{0x52d8c040,0xa52d600f,0xf469a00b,0x00000000}},	//   _ovde_, _izinyath, _igice__cya_, --, 
   {{0x0a63a011,0x380da002,0x00000000,0x00000000}},	//   _non__será_, _средства_, --, --, 
   {{0x1be08003,0x00000000,0x00000000,0x00000000}},	//   _དངོས__སུ_, --, --, --, 
   {{0xd1c9e037,0x94b3e005,0xec53602f,0x4451c00e}},	//   _sobre__mercadol, _var__ei_, _certeza_, _nahoru__re_, 
   {{0x4cfb2014,0x00000000,0x00000000,0x00000000}},	//   _के__प्रमोशन_, --, --, --, 
   {{0x62588006,0x3510a025,0xdcb0400f,0x00000000}},	//   _སྒོང__ཐུང_, _de__trabalho_, _zonke__izinsuku_, --, 
   {{0xe81f600b,0xb13d4034,0x6499e012,0x00000000}},	//   _murongo__ukurangi, _og__regional, _ak__už_, --, 
   {{0x26ff2058,0xa442801b,0x02ec6009,0x12900018}},	//   _अथवा_, _nxa_, _sociale_, _olha_, 
   {{0x5e9d0002,0xa26e8003,0x22bbc00b,0x22a5c003}},	//   _око_, _ནི__བོད_, _rujejwe_, _འཕེལ__རིམ_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x8f788012,0x3c83400a,0x9aa9000a,0x00000000}},	//   _skúste_, _अपलोड__करें_, _तहत__उपलब्ध_, --, 
   {{0xa0920038,0x1ed4e002,0x00000000,0x00000000}},	//   _de__ferramen, _во_, --, --, 
   {{0xc3850037,0x54bf000e,0x87bfc025,0xdb67c00a}},	//   _erróneo__gracias_, _zaregist_se_, _próprio_, _जानने_, 
   {{0xd5a7600a,0x00000000,0x00000000,0x00000000}},	//   _चाहते_, --, --, --, 
   {{0xfb132009,0x38c90002,0x00000000,0x00000000}},	//   _hinanden_, _превод__пошаљи_, --, --, 
   {{0x1aabe00e,0x00000000,0x00000000,0x00000000}},	// [15c0] _základní_, --, --, --, 
   {{0x2a3dc00a,0x00000000,0x00000000,0x00000000}},	//   _सपा_, --, --, --, 
   {{0x2e73604e,0x336b6009,0x0bfb0006,0x00000000}},	//   _मार्च_, _til__salg_, _རྩ__ཅན_, --, 
   {{0x7eb8e002,0x00000000,0x00000000,0x00000000}},	//   _када__се_, --, --, --, 
   {{0x4f184002,0x00000000,0x00000000,0x00000000}},	//   _да__ли_, --, --, --, 
   {{0x6ba8c020,0xf8c86002,0xe177a002,0xdd230012}},	//   _རྫོང__ཁག_, _финансиј, _србију_, _položiek_, 
   {{0x0bd40011,0xa132a012,0x00000000,0x00000000}},	//   _páxina__elemento_, _reklamné_, --, --, 
   {{0xa2f10024,0x13ea202a,0xe4b46028,0x2423e011}},	//   _životne__sredine_, _økt_, _por__tu_, _externas__editar_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x0b9ea00a,0x2b8e2003,0x00000000,0x00000000}},	//   _थी__और_, _ཊི_, --, --, 
   {{0x7e71001c,0xe132a00e,0x30ed400f,0x00000000}},	//   _अगस्त_, _reklamní_, _wofakazi__bakajeho, --, 
   {{0xbf472006,0x7eac2002,0xe291200a,0x93f9000b}},	//   _སྣང__འབྱུང_, _пријавит_се_, _ब्राउज़र_, _imbuto_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x9c54a00a,0xb72d600c,0x8a79000c,0x00000000}},	//   _सोलन__हमीरपुर_, _अलगा__अलगा_, _ओकर__लाभ_, --, 
   {{0x0493a01a,0xebbbc022,0xbd7ee002,0xa26e8003}},	//   _og__ein_, _आदमी__के_, _ту_, _དུ__བོད_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xc0a2603c,0xf2f0a009,0x00000000,0x00000000}},	// [15d0] _vrh__prethodn, _søge_, --, --, 
   {{0xc26cc011,0xf460400e,0x00000000,0x00000000}},	//   _nado_, _nás__jak_, --, --, 
   {{0xa2cbe018,0x00000000,0x00000000,0x00000000}},	//   _ajuda_, --, --, --, 
   {{0xf7984002,0xa3fb000b,0x8316c00e,0x89f6600e}},	//   _си__лозинку_, _igihugu__afise_, _zboží__odebrat_, _zpráv_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xafb96012,0xe4aba012,0xbcd50003,0x00000000}},	//   _môže__byť_, _späť__na_, _མང__གཙོའི_, --, 
   {{0x77ffc002,0xb249e00f,0x047a4018,0x21fcc00c}},	//   _одговор_, _udumo_, _similare_por_, _कि__उनकर_, 
   {{0xe9d7202d,0x00000000,0x00000000,0x00000000}},	//   _listopad, --, --, --, 
   {{0xaf422012,0xf4a2a009,0xa2824018,0x54132002}},	//   _opäť_, _når__der_, _incluí_, _почетак_, 
   {{0x8bf5a00c,0x00000000,0x00000000,0x00000000}},	//   _में__का_, --, --, --, 
   {{0x826f6006,0x00000000,0x00000000,0x00000000}},	//   _ནི__ཀོཊ_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x63438012,0xb254200b,0xebe8c00c,0x00000000}},	//   _členom_, _ku__musi_, _सितंबर__के_, --, 
   {{0x33a1200d,0x00000000,0x00000000,0x00000000}},	//   _méxico_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x32568012,0xab8b4012,0x8f79e012,0x00000000}},	// [15e0] _júl_, _profil__sukromna_, _veľká_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x246c000b,0x80e6e003,0x00000000,0x00000000}},	//   _abahamya__ba_, _འཛིན__གྲྭ_, --, --, 
   {{0xe232601a,0xc46ce011,0x1f12601a,0x00000000}},	//   _følgje_, _foi__un_, _følgjer_, --, 
   {{0x328b401a,0x00000000,0x00000000,0x00000000}},	//   _vi__ikkje_, --, --, --, 
   {{0x73b2000f,0xa2b1c003,0xc275a003,0x00000000}},	//   _kube__yilapho_, _གར__ལྷོ_, _ལོ__པའི_, --, 
   {{0x64040014,0x4624600e,0x533b8002,0xe44b000f}},	//   _अकादमी_, _bohužel_, _могућнос, _phakathi__neminyak, 
   {{0xd44a0039,0xa46dc00b,0x347ac012,0x00000000}},	//   _karena__itu_, _mbuga__za_, _ktorých__sa_, --, 
   {{0x4c806002,0x29fae002,0xc42fc00f,0x14aba01a}},	//   _неће_, _промени__коментар, _iminyaka__engu_, _ein__har_, 
   {{0x83f82002,0x7ba8000a,0x927b2015,0xe44a600f}},	//   _ostale__vesti_, _है__तो_, _adalah__topik_, _ukwazi__ukuthi_, 
   {{0x13d14012,0x00000000,0x00000000,0x00000000}},	//   _partneri_, --, --, --, 
   {{0xf2e40018,0x00000000,0x00000000,0x00000000}},	//   _mais__info_, --, --, --, 
   {{0x14ab2010,0x64804011,0x1d9c4003,0x00000000}},	//   _der__har_, _unha__de_, _དོན__དངོས_, --, 
   {{0xd4f4a018,0xc31a0009,0x00000000,0x00000000}},	//   _acompanh, _du__kender_, --, --, 
   {{0xfbba2006,0x00000000,0x00000000,0x00000000}},	//   _ལས__པར_, --, --, --, 
   {{0xec612038,0x00000000,0x00000000,0x00000000}},	//   _coruña_, --, --, --, 
   {{0x2f6fc018,0x0e9e8002,0xbbc5200a,0x00000000}},	// [15f0] _palavras_, _агенција__за_, _स्थान__पर_, --, 
   {{0x460de009,0x9c23000e,0xf46f600b,0x2bcd0003}},	//   _udfordri, _poprvé_, _icyemezo_, _བཟང__ཉི_, 
   {{0x4443e009,0xf329e012,0xb458c03d,0x5e81000c}},	//   _nyt_, _súbory_, _odeslání_, _भोजपुरी__काव्य_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x525ac02a,0x00000000,0x00000000,0x00000000}},	//   _vanlig_, --, --, --, 
   {{0xb6d7e002,0x94a3a00b,0xd3750009,0xf2d5200e}},	//   _србије_, _amatora__ya_, _opret__bruger_, _všem_, 
   {{0xcb6ba01d,0xb3cfe011,0x93bc0012,0x00000000}},	//   _di__bahagian_, _crtvg_, _dôvodu_, --, 
   {{0x1b8e603a,0x1bab2013,0x92cae01d,0x32cae02f}},	//   _ཇི_, _का__एक_, _kualiti_, _vendas_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xd2904011,0x994be00e,0xce6ca002,0x00000000}},	//   _illa_, _samsung__mobilní_, _то__значи_, --, 
   {{0x06b1200a,0x00000000,0x00000000,0x00000000}},	//   _जुड़े__बदलाव_, --, --, --, 
   {{0x52d9a02a,0x0bba2006,0x7a90400b,0x00000000}},	//   _åpen_, _ལས__ཕར_, _indirimb, --, 
   {{0x9320000f,0xebcc400c,0xe46be00e,0x4f2e0002}},	//   _ngiye_, _कहां__के_, _jak__na_, _мисли_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xaad1e014,0x00000000,0x00000000,0x00000000}},	//   _कल्चर_, --, --, --, 
   {{0xd387c025,0x41744012,0x00000000,0x00000000}},	// [1600] _livre_, _galéria_, --, --, 
   {{0xa2434003,0x57f6000a,0x5490600e,0x00000000}},	//   _བྱས_, _की__जानकारी_, _hlasován_se_, --, 
   {{0x633ec011,0x00000000,0x00000000,0x00000000}},	//   _ás__veces_, --, --, --, 
   {{0xa3106012,0x26e4c014,0x00000000,0x00000000}},	//   _verzia_, _से__बिहार_, --, --, 
   {{0x02cee015,0xc2984003,0xebc5200c,0x00000000}},	//   _com__gambar_, _བྱས__པའི_, _रहे__के_, --, 
   {{0x0b886006,0x8a3da022,0xd428200f,0x00000000}},	//   _ལུ_, _नतीजा_, _inkosi__yakwa_, --, 
   {{0x53430025,0x7368e018,0x00000000,0x00000000}},	//   _direito_, _você__poderá_, --, --, 
   {{0x9290400d,0xea6b8002,0xcdf42002,0x00000000}},	//   _ella_, _су__били_, _регионал, --, 
   {{0x0b62400a,0xe2bbc015,0x20ca4002,0x00000000}},	//   _बनाने_, _mandi__sejak_, _запослен, --, 
   {{0x4278202c,0xeec5c032,0x00000000,0x00000000}},	//   _mu__mwaka_, _ngezinye_, --, --, 
   {{0xba02e046,0xe2cf800f,0x1ba10003,0x00000000}},	//   _सहायता__सहायता_, _kumelwe__ukuba_, _དུས__ནས_, --, 
   {{0xd394e01d,0x5334e00a,0x00000000,0x00000000}},	//   _rahsia_, _यहाँ__जाएँ_, --, --, 
   {{0xebf0e022,0x8486c00a,0x41ed400e,0x75182002}},	//   _इतिहास__के_, _पुराने_, _formulář, _словенск, 
   {{0x346b6012,0xce172002,0xd9abc018,0xf12d2002}},	//   _aby__sa_, _значи_, _produtos__similare, _марта_, 
   {{0x5d7f2002,0x00000000,0x00000000,0x00000000}},	//   _јул_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xe46ac00e,0x00000000,0x00000000,0x00000000}},	// [1610] _recenze__na_, --, --, --, 
   {{0x021c8002,0x5aa3800a,0x00000000,0x00000000}},	//   _објављен, _नीचे__नजर_, --, --, 
   {{0x8756e022,0xb48f6018,0x6bc7000a,0x00000000}},	//   _से__अपना_, _de__em_, _अगर__आप_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7c0c4003,0x00000000,0x00000000,0x00000000}},	//   _ཁུང__དྲ_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x035f000f,0x597f6018,0x82ff200e,0xfbdca00c}},	//   _bangase_, _possível__carregar_, _počet__jader_, _के__रहे_, 
   {{0x2d9ca003,0x00000000,0x00000000,0x00000000}},	//   _ཁྲིད__རྗེས_, --, --, --, 
   {{0x6a6c200a,0xa506c002,0x00000000,0x00000000}},	//   _हेतु__लेख_, _турски__украјинс, --, --, 
   {{0x2394e00f,0x71cda00e,0xfa4da00e,0x0385801d}},	//   _ngisho_, _všechny_, _všechna_, _ianya__percuma_, 
   {{0x7e4b0032,0x0a5ac022,0x04ad6005,0x02936003}},	//   _kufanele_, _कि__देश_, _ikkje__det_, _ཆགས__ཡོད_, 
   {{0xd3e18018,0x5b7b0006,0x00000000,0x00000000}},	//   _opinião__sobre_, _གིས__རྫོང_, --, --, 
   {{0xc424801a,0xe2ca8039,0x1267e009,0x834f600b}},	//   _sida__vart_, _apalagi_, _din__bolig_, _ku__rwego_, 
   {{0xc2526006,0x920a000b,0xc2c34026,0xbf3d4018}},	//   _བཏུབ__པའི_, _guhera__kuri_, _nielsen_, _taxas__impostos_, 
   {{0x64218030,0xa2072012,0x5c702009,0x224e6003}},	//   _about__postao_, _rôznych_, _selskab_, _རོལ_, 
   {{0x53f8803f,0x30698045,0x3c82e003,0x7eebc002}},	//   _yokuba_, _pripojen, _གསུམ__བཅུའི_, _нам__се_, 
   {{0xcb88e01c,0xf41d601a,0x00000000,0x00000000}},	// [1620] _पल_, _dessutan_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x4b9f2003,0xcacae003,0x00000000,0x00000000}},	//   _སྒྲིག__ལོ_, _རྙོག_, --, --, 
   {{0x7bee2002,0x8b8fe013,0xf011e00e,0xccb8a00e}},	//   _само_, _दो_, _potřebuj, _kč__doprava_, 
   {{0xb48f6025,0x526d200d,0x00000000,0x00000000}},	//   _de__um_, _mayo_, --, --, 
   {{0xf3696018,0x64bcc00b,0x53c7000e,0xe455c00b}},	//   _imagens_, _umutekan_kw_, _dotykové__klasické_, _rishya__ry_, 
   {{0x535ca00c,0x46b5000f,0x00000000,0x00000000}},	//   _सकेला_, _ayimfihl_azokweqi, --, --, 
   {{0x224e6029,0xd3bda012,0xd3870015,0x00000000}},	//   _ལོར_, _chcete__pridať_, _pabrik_, --, 
   {{0x02c1e00e,0x9b9ee003,0x00000000,0x00000000}},	//   _to__bylo_, _བཙུཌ__ཏེ_, --, --, 
   {{0x4eb3e002,0x69172002,0x00000000,0x00000000}},	//   _која__ће_, _далеко_, --, --, 
   {{0xaa33800c,0x02936003,0xe5c5600b,0x00000000}},	//   _अउर_, _ཞིག__ཡོད_, _imibereh, --, 
   {{0x6c462012,0x26fe600a,0x726b400b,0x25f8e00b}},	//   _zmazať_, _हैं__लेकिन_, _amjwi__akwiye_, _ariko__mukameny, 
   {{0xf3328016,0x00000000,0x00000000,0x00000000}},	//   _om__trening_, --, --, --, 
   {{0x6473600d,0x00000000,0x00000000,0x00000000}},	//   _venta__de_, --, --, --, 
   {{0xbe8ce002,0x00000000,0x00000000,0x00000000}},	//   _је__реч_, --, --, --, 
   {{0x046de02a,0xf15f800f,0x00000000,0x00000000}},	//   _noe__som_, _umfoweth_, --, --, 
   {{0x7a3dc03b,0xd6f9e014,0x19bf202a,0x9487e022}},	// [1630] _संग_, _बिया_, _meldinge, _डिमांड_, 
   {{0x226d202b,0xb453c009,0x92cc600e,0x6be16003}},	//   _zayo_, _måde__at_, _mpix__zadat_, _རོབ__ཏུ_, 
   {{0x03b5a033,0x9242803a,0xb4ab200f,0x00000000}},	//   _lokacija__zagreb_, _དཀའ_, _kakhulu__uma_, --, 
   {{0x8a468015,0x54d92011,0x2255a022,0x00000000}},	//   _buat__pemberit, _pdf__versión_, _परिदृश्य_, --, 
   {{0xe310800f,0x00000000,0x00000000,0x00000000}},	//   _ujehova__ukuba_, --, --, --, 
   {{0xce538002,0x973ae029,0xc2d42018,0x00000000}},	//   _везе__ова_, _རྩོད_, _recusar__como_, --, 
   {{0x237b800f,0x00000000,0x00000000,0x00000000}},	//   _ukuthi__kungani_, --, --, --, 
   {{0xc2ca6011,0x3db1800b,0xa02b601a,0x00000000}},	//   _dende_, _gisanzwe_, _hordalan_fylkesko, --, 
   {{0x626f8003,0xe47f200e,0xe45a0012,0x00000000}},	//   _དྲ__ངོས_, _nakoupit__na_, _odpoveď__na_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x773ae003,0x00000000,0x00000000,0x00000000}},	//   _རྩེད_, --, --, --, 
   {{0xc2e70019,0x8a0c6006,0x76df000a,0x00000000}},	//   _det__finnes_, _རྐྱངམ_, _शीट__सीएसएस_, --, 
   {{0x22da602c,0xd2da000f,0x5089c002,0x7c890002}},	//   _karere_, _impela_, _језика_, _нове__теме_, 
   {{0x1e8c0022,0x16ab2003,0x00000000,0x00000000}},	//   _के__महत्व_, _ཇིིའི__སློབ_, --, --, 
   {{0x268ce022,0x7aa5600a,0xd470c00b,0x00000000}},	//   _बिहार_, _में__हैं_, _urukiko__rw_, --, 
   {{0xc4b7c011,0xaa33a00c,0x00000000,0x00000000}},	// [1640] _digo__en_, _आउर_, --, --, 
   {{0xdd3fe024,0x75abe00a,0xab98000a,0x7344a00b}},	//   _očistite_, _की__चाहत_, _तरह__की_, _mirenge_, 
   {{0xe1f7a00e,0x00000000,0x00000000,0x00000000}},	//   _nejlepší, --, --, --, 
   {{0xe1b9a00c,0x0c10c003,0x2048a00a,0xb599a00c}},	//   _मिलल_, _ཚོགས__ནང_, _कासगंज__कौशांबी_, _मिलत_, 
   {{0xb41dc002,0x445e4011,0xff81e00a,0x00000000}},	//   _lične__poruke_, _día__da_, _तरीके_, --, 
   {{0xc745c003,0x1b9ae003,0x5254a00b,0x0bd4e00c}},	//   _ཡིག__མཛོད_, _མཆོག__ནས_, _mu__mugi_, _दोसर__देशन_, 
   {{0xba48800f,0x0b884003,0x227c6002,0x00000000}},	//   _jeremiya_, _རྔ_, _игра_, --, 
   {{0xe2428021,0x73bec00f,0xca3c6014,0x00000000}},	//   _བཀལ_, _udeveli_, _उठत_, --, 
   {{0xd598000f,0x0347202c,0x00000000,0x00000000}},	//   _owesifaz, _kumenya_, --, --, 
   {{0x7f79e017,0x4a460014,0xb29b8003,0x00000000}},	//   _možná_, _विधान__सभा_, _ཤེལ__དཀར_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa211e00a,0x120e2002,0x3d9ac003,0x00000000}},	//   _फोटो__गैलरी_, _тада_, _དྲན__ཐེངས_, --, 
   {{0x32fd8019,0x00000000,0x00000000,0x00000000}},	//   _rediger_, --, --, --, 
   {{0x4be3a003,0x00000000,0x00000000,0x00000000}},	//   _སྟོན__ལོ_, --, --, --, 
   {{0xf444400b,0xfc0d2022,0x00000000,0x00000000}},	//   _cy_, _देर__से_, --, --, 
   {{0x5a3aa012,0x00000000,0x00000000,0x00000000}},	//   _alebo__zaregist, --, --, --, 
   {{0xb40aa037,0xe3f5e00f,0x6146c00a,0x00000000}},	// [1650] _hace__más_, _kungani__ujesu_, _जाएंगे_, --, 
   {{0xcdff401a,0xd2b0e01a,0x74aac00b,0xd36f8002}},	//   _hendinga, _det__kjem_, _murenge__wa_, _гламоч__октобар_, 
   {{0xa316000f,0x7c58200c,0x00000000,0x00000000}},	//   _usizi_, _शामिल__भइले_, --, --, 
   {{0x2c7e200b,0x530ba00a,0x00000000,0x00000000}},	//   _amasomo_, _करने__वाली_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x9290201d,0x00000000,0x00000000,0x00000000}},	//   _sukan_, --, --, --, 
   {{0x041f401d,0xcfd30002,0x00000000,0x00000000}},	//   _sunting__pautan_, _демократ, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x5b56c006,0x328c601a,0x00000000,0x00000000}},	//   _ནི__རྫོང_, _avgifter__skule_, --, --, 
   {{0xf4760002,0x6270e012,0x850ac00c,0xb770e00e}},	//   _ceni__din_, _napríkla, _के__साहित्यक, _rejstřík, 
   {{0xd2ca003f,0x44a8001d,0x00000000,0x00000000}},	//   _elide_, _sebelum__ini_, --, --, 
   {{0xf291c01b,0xb74ea003,0x00000000,0x00000000}},	//   _emva_, _གླེང__འདོད_, --, --, 
   {{0xbdc96003,0xebcb600c,0x00000000,0x00000000}},	//   _ཆེད__བརྗོད_, _चौहान__के_, --, --, 
   {{0x671d800a,0x00000000,0x00000000,0x00000000}},	//   _देखें__आपका_, --, --, --, 
   {{0xa4b4203c,0x7910200f,0xa84f8012,0x00000000}},	//   _autor__ica_, _inkazimu, _mimoriad, --, 
   {{0x1cbf0007,0xc38bc009,0xc4d74014,0x00000000}},	//   _dan__peluang_, _mærke_, _हैकिंग_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [1660] --, --, --, --, 
   {{0x0c82801a,0xd2ab4012,0x00000000,0x00000000}},	//   _inneheld_, _výber_, --, --, 
   {{0x824d003c,0xe3542011,0x9983000e,0x00000000}},	//   _prikaz__ispisa_, _galegos_, _výrobci__mobilní_, --, 
   {{0xf2fde009,0xa2904015,0x00000000,0x00000000}},	//   _brug_, _cuman_, --, --, 
   {{0x2ed24002,0x048d6019,0x9c38400e,0x4d16c010}},	//   _да__је_, _de__som_, _souhlasu_, _venligst_, 
   {{0xe4ade03c,0x92d0601a,0xdf3a2018,0xb9652009}},	//   _staviti__na_, _korleis_, _as__melhores_, _alligeve, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xdd9e202a,0x0257000e,0xe24e4006,0x00000000}},	//   _kosthold_, _dál_, _འུང_, --, 
   {{0x3c88a00f,0x34606012,0x349ba03d,0x12898003}},	//   _esihlalw_sobukhos, _nachádza_sa_, _je__kč_, _ཀླད__གཙང_, 
   {{0x43f9000f,0x346be027,0x00000000,0x00000000}},	//   _umbuso_, _kde__sa_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x1eb16008,0x2b88c003,0x00000000,0x00000000}},	//   _externas_, _ཨུ_, --, --, 
   {{0xa3f94007,0xa26f6006,0x83f76018,0xee7ee002}},	//   _kepada__semua_, _ནི__ཀོཌ_, _podem__sofrer_, _регистру_да_, 
   {{0x5f4be039,0xf291c00b,0x3468a015,0x0b9ae006}},	//   _bergabun, _umva_, _gak__ada_, _ཝཱན__ཀམ_, 
   {{0x31fde00c,0x00000000,0x00000000,0x00000000}},	//   _अरिंदम__चौधरी_, --, --, --, 
   {{0x93144018,0x3dbae002,0x0bb88003,0x00000000}},	//   _relógio_, _за__које_, _དྲ__བར_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [1670] --, --, --, --, 
   {{0x7409601d,0x9300c00b,0x8304a00e,0xfc0c800c}},	//   _mengguna_versi_, _mbere__umukuru_, _mobilu__přidat_, _जवना__से_, 
   {{0x7387c025,0xc4b8a011,0xea8ec003,0x2df24003}},	//   _livro_, _enderezo__non_, _རིའི__རྒྱང_, _གི__རྗེས_, 
   {{0xdc148006,0x82412018,0x9304400f,0x7c72000a}},	//   _གསརཔ__ཞུ_, _sua__senha_, _yonke__indawo_, _पढ़ें__सम्पादन_, 
   {{0x438e800b,0x7a008003,0x00000000,0x00000000}},	//   _kubona__ibiri_, _ལྷ__དགའི_, --, --, 
   {{0xb470a018,0x00000000,0x00000000,0x00000000}},	//   _tem__uma_, --, --, --, 
   {{0x6bd62011,0x00000000,0x00000000,0x00000000}},	//   _máis__informac, --, --, --, 
   {{0x4ac04011,0xc4a3200c,0x1069c012,0x00000000}},	//   _trátase_, _ओंकारेश्, _prepojen, --, 
   {{0x6bfa4051,0xbdcec002,0x4461e037,0x0bc8800c}},	//   _नियम_, _видео_, _opinión__hay_, _के__विडंबने_, 
   {{0xccc1000a,0x00000000,0x00000000,0x00000000}},	//   _नगर__चम्पावत_, --, --, --, 
   {{0xf348e00b,0xd7816003,0x00000000,0x00000000}},	//   _bagenzi_, _སྐད__འབོད_, --, --, 
   {{0x8a4c8014,0x22f9e01f,0x5265000c,0xb6fee014}},	//   _के__लाभ_, _merujuk__kepada_, _भोजपुरी__सिनेमा_, _छपरा_, 
   {{0x420d4013,0xe251400a,0x00000000,0x00000000}},	//   _अन्ना__हजारे_, _मिलेगा_, --, --, 
   {{0x4a52200a,0xfb9b000c,0x00000000,0x00000000}},	//   _आईटी__खेल_, _ओहिजा__से_, --, --, 
   {{0x2eea6002,0xe433e00f,0x00000000,0x00000000}},	//   _био__је_, _yini__ukuthi_, --, --, 
   {{0x92df401c,0x6edf800a,0x00000000,0x00000000}},	//   _अपनी_, _बागेश्वर__रुद्र_, --, --, 
   {{0xec8fe00c,0x00000000,0x00000000,0x00000000}},	// [1680] _एकरो_, --, --, --, 
   {{0x4b8ee003,0x00000000,0x00000000,0x00000000}},	//   _ཎི_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xc4b36011,0x02cde012,0xf27d8003,0xee5ee002}},	//   _galipedi_en_, _na__stenu_, _དམངས__གླུ_, _зна__да_, 
   {{0x42cb001a,0xaef7c00a,0xf317000c,0x00000000}},	//   _stader_, _जिसके_, _अउर__पढ़ीं_, --, 
   {{0x648e4028,0xfaffe018,0x00000000,0x00000000}},	//   _precio__de_, _imóveis_, --, --, 
   {{0x2cace00a,0xaac3c00a,0x85522002,0x87d58002}},	//   _का__उपयोग_, _प्रमुख__शहर_, _уопште_, _младих_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x3497200e,0xc48da011,0xa386002c,0x00000000}},	//   _kč__kč_, _de__non_, _ibiro_, --, 
   {{0x9278a037,0x00000000,0x00000000,0x00000000}},	//   _pago__recibo_, --, --, --, 
   {{0x0494600b,0xdb052037,0x00000000,0x00000000}},	//   _li__li_, _una__opinión_, --, --, 
   {{0xd2438003,0x74300004,0x62cc2009,0x82cc2009}},	//   _ཀྱང_, _emva__kokuba_, _gælder_, _vælger_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xbbe22006,0x3303600f,0x00000000,0x00000000}},	//   _འདི__ཚུ_, _kusukela__ngaleso_, --, --, 
   {{0x1307001d,0x00000000,0x00000000,0x00000000}},	//   _solat__sunat_, --, --, --, 
   {{0xe469000f,0x00000000,0x00000000,0x00000000}},	//   _uyazi__ukuthi_, --, --, --, 
   {{0x52cc2009,0x5c0e6022,0xfcd38002,0x00000000}},	// [1690] _sælger_, _सामने__आई_, _коментар__овде_, --, 
   {{0x4290a01a,0x82dfa011,0x696e800f,0x00000000}},	//   _brukast_, _en__xeral_, _ezindabe, --, 
   {{0x2166000b,0x0beec002,0x00000000,0x00000000}},	//   _ntushobo, _закон_, --, --, 
   {{0x1a204047,0x00000000,0x00000000,0x00000000}},	//   _फेसबुक_, --, --, --, 
   {{0xc2600006,0x00000000,0x00000000,0x00000000}},	//   _བཅོས__འབད_, --, --, --, 
   {{0x3dbde00b,0x1b9bc003,0x026d8006,0x00000000}},	//   _ushakire_, _ཡིན__པས_, _ཁོ__གིས_, --, 
   {{0x7dd7c011,0xb30e401d,0x29d00002,0xf249201a}},	//   _lingüíst, _peratus_, _неки_, _dei__ulike_, 
   {{0x2e826002,0xec4fc00c,0x00000000,0x00000000}},	//   _пошто__је_, _आवें_, --, --, 
   {{0x226d800b,0x837b8027,0x2470c00b,0x00000000}},	//   _maso_, _skladom_, _ivuga__ko_, --, 
   {{0xfbe76003,0x4ffa8002,0x00000000,0x00000000}},	//   _སྐྱེད__དང_, _је__овај_, --, --, 
   {{0xfab46007,0x63f9400d,0xd295c003,0x00000000}},	//   _linkedin_, _alguna_, _འཛིན__བདེ_, --, 
   {{0xa4ba0010,0xe40c200e,0xabd1200e,0xe45a2012}},	//   _tjeneste_ved_, _může__být_, _mezináro, _nájdete__na_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xc470e00f,0x00000000,0x00000000,0x00000000}},	//   _oneminya_engu_, --, --, --, 
   {{0xc470e00f,0x00000000,0x00000000,0x00000000}},	//   _kweminya_engu_, --, --, --, 
   {{0xc26e4003,0x6291400b,0xebc0400a,0x00000000}},	//   _དང__རིག_, _kagame_, _वर्ष__के_, --, 
   {{0x525ac02a,0x00000000,0x00000000,0x00000000}},	// [16a0] _tallet_, --, --, --, 
   {{0x9290c01d,0x6466600e,0xeeb12009,0x22cac00f}},	//   _melaka_, _tím__že_, _danskere_, _owodwa_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xddf24002,0x63bc800b,0x4676c00b,0x00000000}},	//   _пут__измењена_, _abandi__barenga_, _rw__itangiri, --, 
   {{0x421d8022,0x00000000,0x00000000,0x00000000}},	//   _नक्शा_, --, --, --, 
   {{0x6d83c029,0x346a400b,0x00000000,0x00000000}},	//   _སྐྱོན_, _ibisa__nk_, --, --, 
   {{0x97a5e038,0x0ac2200c,0xe2f6600b,0x00000000}},	//   _parroqui, _जिला__में_, _imihoho__ukwa_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xc2640003,0x02ab2009,0x00000000,0x00000000}},	//   _དབྱིན__ཡིག_, _løber_, --, --, 
   {{0x0a148002,0x92da400e,0x427ba003,0x730d2007}},	//   _мај__април_, _letech_, _དེ__ལྟར_, _pelacur_, 
   {{0x1308c00f,0x54b9801a,0x4a15c00b,0x00000000}},	//   _ukuthi__ujehova_, _legg__att_, _urubanza_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xf3f9a00b,0x5102e00e,0x124e6003,0x00000000}},	//   _umwuka_, _nejčastě, _རུས_, --, 
   {{0x88624003,0x1bbee003,0x00000000,0x00000000}},	//   _བཅར__འདྲི_, _ལོ__ནས_, --, --, 
   {{0xe3f46035,0xf9e4e025,0x00000000,0x00000000}},	//   _ukuthi_, _divulgad, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [16b0] --, --, --, --, 
   {{0x0f97c009,0xe9288002,0xa293400c,0x00000000}},	//   _med__annoncer_, _центар_, _किशोर__अपराधियन_, --, 
   {{0x4290201f,0x12e7000b,0xf24fe00b,0x00000000}},	//   _cukai_, _za__leta_, _na__polisi_, --, 
   {{0x02d80004,0x22aaa00b,0xfee86002,0x00000000}},	//   _ithe_, _muri__icyo_, _испод__или_, --, 
   {{0xe2a2a016,0x32abc003,0x00000000,0x00000000}},	//   _flere__innlegg_, _པར__ཁམས_, --, --, 
   {{0xf2ab2009,0x338b2009,0x73ea0011,0xbba0400a}},	//   _køber_, _kører_, _moita_, _इस__पर_, 
   {{0x07e4a00a,0x63ea0011,0xebabc012,0xfa290018}},	//   _ख़बरें_, _loita_, _fungovať_, _meses__atrás_, 
   {{0xd34aa011,0x7386c009,0x8716800a,0x00000000}},	//   _esta__cambios_, _uger_, _देंगे__अपना_, --, 
   {{0x22920007,0xdc0f6018,0x00000000,0x00000000}},	//   _kepada_, _seja__primeiro_, --, --, 
   {{0xd2eba016,0x526de012,0xfdf6800a,0xdde6a003}},	//   _trenger_, _predchád, _सुल्तानप_सहारनपुर_, _བྱོན__ཡོངས_, 
   {{0xcf178006,0x549c2037,0x00000000,0x00000000}},	//   _དཔར__འཕྲུལ_, _artículo__no_, --, --, 
   {{0xd3e7200e,0x00000000,0x00000000,0x00000000}},	//   _prostě__zkuste_, --, --, --, 
   {{0x92a6200d,0x1a3ce00a,0x0254800b,0x00000000}},	//   _nombre_, _वीं_, _ku__giti_, --, 
   {{0x17512003,0x00000000,0x00000000,0x00000000}},	//   _ཡུམ__མཆོད_, --, --, --, 
   {{0x32a6200d,0x2c99e019,0x7127e002,0x00000000}},	//   _hombre_, _naturlig_, _сарадњу_, --, 
   {{0xec0e2014,0x00000000,0x00000000,0x00000000}},	//   _महत्व__के_, --, --, --, 
   {{0xa36b401a,0xc2594020,0xbe62e002,0x2c9da00c}},	// [16c0] _til__innhald_, _འབྲུག__པའི_, _регистру, _के__कईगो_, 
   {{0x0a85e022,0x12676002,0xa2348003,0x5d008003}},	//   _साहित्य__में_, _међу_, _སྙན__རྩོམ_, _རྒྱུགས_, 
   {{0x53ea6004,0x62b1e00f,0xf94ca00a,0x00000000}},	//   _umntu_, _engaphez_kwengu_, _की__जांच_, --, 
   {{0xa2a3e021,0x00000000,0x00000000,0x00000000}},	//   _མཛོད__འདི_, --, --, --, 
   {{0x2dd0c003,0x00000000,0x00000000,0x00000000}},	//   _ལག__འཁྱེལ_, --, --, --, 
   {{0xc2fe400b,0x3c114003,0x00000000,0x00000000}},	//   _amahame_, _ཚོགས__ཚང_, --, --, 
   {{0x4da3e003,0xe2ad6003,0x00000000,0x00000000}},	//   _འབྱེད_, _རྡོ__རིང_, --, --, 
   {{0x2e3b000b,0x00000000,0x00000000,0x00000000}},	//   _baratera, --, --, --, 
   {{0xb9f4000a,0x00000000,0x00000000,0x00000000}},	//   _का__प्रयास_, --, --, --, 
   {{0x12afe003,0xe3fde00f,0x00000000,0x00000000}},	//   _མི__ཚོས_, _wabona__ukuthi_, --, --, 
   {{0xccad4003,0x30ee400f,0xe5a28002,0xb0bd8003}},	//   _ཟླ__འདིའི_, _yofakazi__bakajeho, _не__знам_, _དང__འདྲ_, 
   {{0x88506003,0x00000000,0x00000000,0x00000000}},	//   _ཨེ__སེངྒེ_, --, --, --, 
   {{0x046e2037,0xc7ea4014,0x727e001a,0x00000000}},	//   _las__por_, _के__संरक्षण_, _éin_, --, 
   {{0xf238a00e,0x00000000,0x00000000,0x00000000}},	//   _nějak_, --, --, --, 
   {{0x33358018,0x1be18003,0xc0f48006,0xefa1200a}},	//   _você__pode_, _བྱས__ནས_, _མཛོད__རྒྱ_, _हटा__देंगे_, 
   {{0xcdbba00d,0x8afe6006,0x00000000,0x00000000}},	//   _búsqueda_, _ལས__གཡོགཔ_, --, --, 
   {{0xd496e00b,0x00000000,0x00000000,0x00000000}},	// [16d0] _ku__bw_, --, --, --, 
   {{0x93540002,0xf251e002,0x00000000,0x00000000}},	//   _за__годину_, _странице_, --, --, 
   {{0xc2d80004,0x1260a006,0x2439e012,0xebd2a00c}},	//   _uthe_, _བཟུམ__སྦེ_, _na__svete_, _इलाका__के_, 
   {{0x4755000c,0x00000000,0x00000000,0x00000000}},	//   _तय__सीमा_, --, --, --, 
   {{0x5df5e00e,0x3e3fa002,0x6bd86003,0x00000000}},	//   _představ, _уследе__на_, _འཆར__ཁག_, --, 
   {{0x046ee027,0x00000000,0x00000000,0x00000000}},	//   _tak__som_, --, --, --, 
   {{0xcc1ec00a,0xebe9600c,0x8a4ce00a,0x00000000}},	//   _संसार__मनोरंजन_, _तिवारी__के_, _कई__बार_, --, 
   {{0x547cc008,0x52906004,0xd930e002,0x00000000}},	//   _onde__se_, _kulaa_, _етничку__мржњу_, --, 
   {{0xbf0a2014,0x00000000,0x00000000,0x00000000}},	//   _मुख्__यमंत्री_, --, --, --, 
   {{0x3a466022,0x8287a00f,0x00000000,0x00000000}},	//   _संरक्षित_, _lokhu__kusho_, --, --, 
   {{0x1c4f8011,0xa387e027,0x147c0009,0x863f600e}},	//   _as__persoas_, _nitra_, _skal__hen_, _předmět__příspěvk, 
   {{0x63070015,0xd46c6018,0x06bc400b,0x93076012}},	//   _makasih_, _disse__que_, _bahungiy, _byt__izbový_, 
   {{0x163f200e,0x1ed4e002,0x00000000,0x00000000}},	//   _komentář_, _го_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x62436029,0x00000000,0x00000000,0x00000000}},	//   _ཕྱི_, --, --, --, 
   {{0xe31f600f,0x00000000,0x00000000,0x00000000}},	// [16e0] _ukuphila__kwabo_, --, --, --, 
   {{0x347c8009,0x9be1e006,0xace50002,0x00000000}},	//   _mere__her_, _འཐེན__མི_, _амерички_, --, 
   {{0x0da40030,0x32cde02a,0x3bc28013,0x00000000}},	//   _opšte__opće_, _er__noen_, _ओशो_, --, 
   {{0x9a548003,0x2edd6002,0x00000000,0x00000000}},	//   _བསྟོད__དབྱངས_, _године__је_, --, --, 
   {{0x49462002,0x00000000,0x00000000,0x00000000}},	//   _захтеви_, --, --, --, 
   {{0x64b2400d,0x4eb4a002,0x0abba014,0x00000000}},	//   _condicio_de_, _који__ће_, _भोपाल__में_, --, 
   {{0xe357800f,0xd198e002,0x00000000,0x00000000}},	//   _izifiso_, _порука__страница_, --, --, 
   {{0x7ba90013,0xee48a002,0x00000000,0x00000000}},	//   _हो__तो_, _желим__да_, --, --, 
   {{0xc290601d,0x2c4f8025,0x3348201a,0x00000000}},	//   _julai_, _as__pessoas_, _vil__seie_, --, 
   {{0xbd04c00c,0x00000000,0x00000000,0x00000000}},	//   _भोजपुरी__लोककला_, --, --, --, 
   {{0x22e66024,0x0c65a00a,0x00000000,0x00000000}},	//   _planeta_, _दर्शाव__पढ़ें_, --, --, 
   {{0x4351a018,0xec0e0014,0x2b9f200c,0x00000000}},	//   _um__amigo_, _लाख__के_, _के__हम_, --, 
   {{0xbf5c400f,0xb483600f,0xa27e000c,0x00000000}},	//   _nabangan, _unkulunk_ka_, _करत__लिखले_, --, 
   {{0xd480e018,0xf478c00b,0x8a8d0011,0x00000000}},	//   _tudo__que_, _gihe__cy_, _praza__pública_, --, 
   {{0x92626021,0x00000000,0x00000000,0x00000000}},	//   _དང__ཐབས_, --, --, --, 
   {{0x4f968011,0x72a2200f,0x00000000,0x00000000}},	//   _páxinas_, _ngezindl_eziningi_, --, --, 
   {{0x9c8e6033,0xeba10014,0x00000000,0x00000000}},	// [16f0] _korisnik__postova_, _सम्मान__के_, --, --, 
   {{0x7be7a003,0x00000000,0x00000000,0x00000000}},	//   _འཕྲིན__ཁང_, --, --, --, 
   {{0x22480002,0xb4902018,0x00000000,0x00000000}},	//   _snimi_, _em__uma_, --, --, 
   {{0xdce3c016,0x1db92002,0x00000000,0x00000000}},	//   _til__forumet_, _пријавил, --, --, 
   {{0x99f6400e,0x67a26012,0x12c3e002,0x00000000}},	//   _zatím_, _spotrebi, _користе_, --, 
   {{0x02cde006,0x0477e002,0x00000000,0x00000000}},	//   _ཅིག__ཨིན_, _касније_, --, --, 
   {{0x6470e011,0x9316c045,0xd2fce01a,0x00000000}},	//   _servizo__de_, _tiez_, _pengar_, --, 
   {{0xcbfa0003,0x00000000,0x00000000,0x00000000}},	//   _ཐེ__ཝན_, --, --, --, 
   {{0xc26de025,0xbba8a00a,0x00000000,0x00000000}},	//   _fato_, _कीबोर्ड__पर_, --, --, 
   {{0xda29a015,0x72a6200e,0x00000000,0x00000000}},	//   _bisa__mendapat, _recenzí__obchodu_, --, --, 
   {{0x446e000b,0x846b6012,0x00000000,0x00000000}},	//   _hamagara__bbc_, _sa__nachádza, --, --, 
   {{0x12902018,0x00000000,0x00000000,0x00000000}},	//   _loja_, --, --, --, 
   {{0x72902012,0x4adf8003,0xea73400c,0x00000000}},	//   _roka_, _ནུབ__ཕྱོགས_, _एकरा__बाद_, --, 
   {{0x73684007,0x2b96c00c,0x00000000,0x00000000}},	//   _seperti__berikut_, _मिल__पा_, --, --, 
   {{0x8f57401a,0x00000000,0x00000000,0x00000000}},	//   _samanhen, --, --, --, 
   {{0x02a2c006,0x2f0c200f,0x00000000,0x00000000}},	//   _ཕྱུག__སྐུ_, _ngemva__kwezinya, --, --, 
   {{0xedc2a002,0x4c7d200e,0xe3fe600f,0x00000000}},	// [1700] _то__што_, _operační__systém_, _kodwa__ujesu_, --, 
   {{0xff89200a,0xbc742028,0x00000000,0x00000000}},	//   _रोमांस__साहित्य_, _saludos_, --, --, 
   {{0x0bf24006,0x22ab0012,0x00000000,0x00000000}},	//   _ཆས__ནང_, _súbor_, --, --, 
   {{0x538fc011,0x9284000f,0x07f7200c,0x00000000}},	//   _de__ourense_, _izingane__zakho_, _असली__लाभार्थि, --, 
   {{0x5a60a018,0xebcc2014,0xebcd8014,0x4459000b}},	//   _preços_, _अंग्रेजी__के_, _भाग__के_, _uburyo__bwo_, 
   {{0x9716e00f,0x68472002,0x00000000,0x00000000}},	//   _iqiniso__liwukuth, _знају_, --, --, 
   {{0x6922600c,0x00000000,0x00000000,0x00000000}},	//   _ओहिजा_, --, --, --, 
   {{0x09738015,0xf3232037,0x0d3a0025,0x00000000}},	//   _berpikir_, _artículo__quedan_, _contrári, --, 
   {{0xd30b2002,0xa26de00e,0xa2af8003,0x738bc01a}},	//   _октобар_, _tato_, _མི__བོད_, _lærar_, 
   {{0x32cac00e,0xfd184012,0x72904015,0xa2676003}},	//   _prodej_, _odpovede_, _jumat_, _ཕན__ཚུན_, 
   {{0xeba62014,0x546cc037,0x1ba1602c,0x00000000}},	//   _कर__के_, _madre__no_, _bashobor, --, 
   {{0x7495600b,0x78596015,0xd2a7e006,0x0b96a00a}},	//   _ko__mu_, _tokobagu, _ཚན__དཔེ_, _पर्यटन__और_, 
   {{0x35be2002,0x00000000,0x00000000,0x00000000}},	//   _други_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x858ac00f,0x01772002,0x84956009,0xeb01c003}},	//   _ngezinye__izikhath, _места_, _og__nu_, _གནང__འདུག_, 
   {{0x4290400f,0x6257c00e,0x22b5600f,0x00000000}},	//   _noma_, _díl_, _ngelinye__ilanga_, --, 
   {{0x144f400b,0x7c73c00f,0x00000000,0x00000000}},	// [1710] _kenyatta__ariwe_, _ujosefa_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x76450022,0x26716030,0xb8ccc025,0xa3fcc009}},	//   _के__इतिहास_, _opštinsk_službeni, _necessid, _det__bedste_, 
   {{0xed6d2002,0x92904038,0x00000000,0x00000000}},	//   _што_, _coma_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6738c003,0x00000000,0x00000000,0x00000000}},	//   _གསོད_, --, --, --, 
   {{0xd290400b,0x046c602a,0x9c994037,0x1335c00f}},	//   _goma_, _gjøre__det_, _segurida_escribe_, _ngokuthi__ujehova_, 
   {{0xec36a012,0xc2d8c00f,0x1430e007,0x8ea28002}},	//   _kategóri, _kulesi_, _diaktifk, _фотограф_корисник, 
   {{0x4c57000a,0x00000000,0x00000000,0x00000000}},	//   _इनमें_, --, --, --, 
   {{0xf863e00d,0x92b5e006,0x12644006,0xca4f000a}},	//   _artículo, _སྡེའི__སྒོ_, _བཀྲིས__སྒང_, _का__कोई_, 
   {{0x92fd6016,0xe290400d,0x00000000,0x00000000}},	//   _legger_, _hola_, --, --, 
   {{0x3e28e002,0x8350600b,0x03f0200e,0xfe5b2002}},	//   _на_, _mu__rwego_, _všechny__časy_, _странке_, 
   {{0x6ba1600b,0x2380602f,0x00000000,0x00000000}},	//   _washobor, _carros_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xe403e00f,0x00000000,0x00000000,0x00000000}},	//   _yakhe__ujesu_, --, --, --, 
   {{0xe4cea011,0x62fcc02a,0x252ea011,0x00000000}},	// [1720] _concello_, _velger_, _consello_, --, 
   {{0x9290400b,0x00000000,0x00000000,0x00000000}},	//   _soma_, --, --, --, 
   {{0x0b54c019,0x73f8e012,0x7bddc003,0xc256e00c}},	//   _eksterne__nettside, _ponuka_, _ཀྱི__ལག_, _मिलेला_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x82904012,0x00000000,0x00000000,0x00000000}},	//   _bola_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xb2b4002c,0xebd3800c,0x00000000,0x00000000}},	//   _imico_, _गढ़__के_, --, --, 
   {{0xd459200b,0xebe22003,0x00000000,0x00000000}},	//   _uburyo__bwa_, _རྒྱུ__དར_, --, --, 
   {{0x92a54003,0xe2ed600c,0x7619400e,0xee972002}},	//   _མང__གཙོ_, _के__काफी_, _ceny__nejvyšší_, _можемо__да_, 
   {{0x436be015,0x3ecc200a,0x00000000,0x00000000}},	//   _sejak__minggu_, _और__पोस्ट_, --, --, 
   {{0xd44fa018,0x00000000,0x00000000,0x00000000}},	//   _dê__sua_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x32fcc016,0xa5a98002,0xb01ba012,0x00000000}},	//   _selger_, _организа, _sa__registro, --, 
   {{0xac08600a,0x82fd401a,0x01b9c00c,0x00000000}},	//   _बारे__मे_, _leggje_, _भटकल_, --, 
   {{0xc2cb402d,0xb457c018,0x4d9a2003,0x00000000}},	//   _tjedan_, _ganhe__desconto_, _ཡོད__སྟབས_, --, 
   {{0x8f02c002,0x62c06025,0x6810e003,0x00000000}},	// [1730] _школе_, _média_, _བརྒྱབ_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xe4b86002,0x900b600a,0xf3242018,0x00000000}},	//   _vesti__na_, _संसार__समाचार_, _de__fazer_, --, 
   {{0x6bc2e00a,0xa2cb6012,0x00000000,0x00000000}},	//   _क्या__आप_, _svadba_, --, --, 
   {{0x62904011,0xd71fa059,0xadf6e002,0xb2c8e002}},	//   _pola_, _उद्देश्य, _док__су_, _на__челу_, 
   {{0x22b7c01a,0x00000000,0x00000000,0x00000000}},	//   _denne__sida_, --, --, --, 
   {{0xcb99000a,0x0aa6800c,0x00000000,0x00000000}},	//   _साथ__ही_, _में__भईल_, --, --, 
   {{0x32f0a01a,0x1b8fa003,0x00000000,0x00000000}},	//   _høgt_, _ཧི_, --, --, 
   {{0xd4956008,0x6468602f,0x00000000,0x00000000}},	//   _no__que_, _dia__de_, --, --, 
   {{0x0ba9e006,0xc0a7e00a,0x00000000,0x00000000}},	//   _ཨེསི__སི_, _योगदान__प्रयोगपृ, --, --, 
   {{0xc2d6e00e,0x3495001a,0xf24f8019,0x32b7c01a}},	//   _před_, _og__eit_, _er__mulig_, _denne__tida_, 
   {{0xa30dc019,0xbba0c00a,0xa390e00e,0x00000000}},	//   _alvorlig_, _उस__पर_, _čtyři_, --, 
   {{0xfb8d2004,0x9366600c,0x6abe6002,0x00000000}},	//   _ukufika__ukuphela_, _हितैषी_, _извештај, --, 
   {{0x02ca800d,0xb74f8002,0x00000000,0x00000000}},	//   _edad_, _републик_србије_, --, --, 
   {{0x03c58002,0x00000000,0x00000000,0x00000000}},	//   _по__основу_, --, --, --, 
   {{0x13dde037,0x348ac012,0x94194002,0x00000000}},	//   _tu__madre_, _ktorá__sa_, _савремен, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [1740] --, --, --, --, 
   {{0x8bf8e020,0x6326a019,0x4db48003,0x00000000}},	//   _གེ__སར_, _en__annen_, _དེར__བརྟེན_, --, 
   {{0x6c4e000a,0x12fce02a,0x00000000,0x00000000}},	//   _करने_, _penger_, --, --, 
   {{0xc32c200b,0x00000000,0x00000000,0x00000000}},	//   _wa__kane_, --, --, --, 
   {{0xe3f20037,0x00000000,0x00000000,0x00000000}},	//   _compra__venta_, --, --, --, 
   {{0xb3eb8012,0x122d600e,0x52434006,0x2a18c002}},	//   _meste_, _témata_, _པཱན_, _испод_, 
   {{0x32abc009,0x7515800f,0xa2700003,0xa2428003}},	//   _håber_, _okushiwo_, _དེ__བོད_, _བཟའ_, 
   {{0x447a0039,0x1fe12002,0xa9f58012,0xd4950025}},	//   _saat__ini_, _своју_, _bazár_, _no__rio_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x53f94018,0x42d8c025,0x3400c002,0x8b97800c}},	//   _alguma_, _boleto_, _једну_, _के__मद_, 
   {{0xc2b5e018,0x00000000,0x00000000,0x00000000}},	//   _ou__não_, --, --, --, 
   {{0x62ca0011,0x00000000,0x00000000,0x00000000}},	//   _poida_, --, --, --, 
   {{0xfb928003,0xc4990026,0x1296600e,0x00000000}},	//   _ཡིག__དང_, _adgangsk, _já__jsem_, --, 
   {{0x8b7ec008,0x5be8e003,0x00000000,0x00000000}},	//   _cualific, _བཞུགས__སོ_, --, --, 
   {{0x0495201a,0x508ca012,0x5fefe011,0x00000000}},	//   _om__ein_, _nábytok_, _elección, --, 
   {{0xda93400b,0xc291800e,0x00000000,0x00000000}},	//   _ukurangi_ihiganwa_, _stran_, --, --, 
   {{0x4460600e,0x9329a002,0x00000000,0x00000000}},	// [1750] _příspěvk_re_, _прегледа, --, --, 
   {{0x027e800b,0x00000000,0x00000000,0x00000000}},	//   _cyane_, --, --, --, 
   {{0x3beec002,0x63eb8009,0x00000000,0x00000000}},	//   _након_, _heste_, --, --, 
   {{0xc293a003,0x52f4800b,0x00000000,0x00000000}},	//   _དགོས__པའི_, _mwaka__kandi_, --, --, 
   {{0x2c8a000a,0x00000000,0x00000000,0x00000000}},	//   _कार्रवाई__करते_, --, --, --, 
   {{0x7f53e01a,0xe23e400f,0xb29d0003,0x00000000}},	//   _hjå_, _nje__lapho_, _སྲས__ཀྱི_, --, 
   {{0xd2896006,0xec85200f,0x4a7aa00c,0x00000000}},	//   _ཡོངས__དཔེ_, _ebandlen_lobukris, _ओकर__नाम_, --, 
   {{0xe3eae011,0x82a3a011,0xc2264009,0xda3e600c}},	//   _moitos_, _direcció_xeral_, _smukke_, _खास__अंश_, 
   {{0x17162022,0x6984a012,0x9bf4200a,0xea74400c}},	//   _गद्दी_, _použitie_, _लेकर__मन_, _ओकरा__बाद_, 
   {{0xa493e00f,0x00000000,0x00000000,0x00000000}},	//   _of__the_, --, --, --, 
   {{0x4386002b,0x00000000,0x00000000,0x00000000}},	//   _ibiri_, --, --, --, 
   {{0x226c0018,0x53ea0011,0xfc99001a,0x44c40009}},	//   _acho_, _moito_, _frie__oppslags, _pluspris__kr_, 
   {{0x824d4003,0x12930003,0xc4e4e00c,0x00000000}},	//   _དཔར__ཐུབ_, _བཤད__ཉིན_, _के__हैसियत_, --, 
   {{0x1414800f,0x3ca5c00e,0x5276c003,0x00000000}},	//   _kangcono_, _jader__procesor, _ནས__ཤེས_, --, 
   {{0xca1b200e,0xd3434011,0x00000000,0x00000000}},	//   _rozlišen, _deseño_, --, --, 
   {{0x84952025,0x4d910002,0x00000000,0x00000000}},	//   _no__dia_, _црне__горе_, --, --, 
   {{0xdbe04022,0xb28ce045,0xcb1ae012,0xb7f7e002}},	// [1760] _से__भर_, _archív_, _činnosť_, _највећи_, 
   {{0xf2906039,0x4290601d,0x6465c018,0x32caa00f}},	//   _mulai_, _pulak_, _acima__de_, _amanothi__wohlu_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x43eae018,0xd2fd6009,0x00000000,0x00000000}},	//   _pontos_, _undgå_, --, --, 
   {{0x676a000c,0x00000000,0x00000000,0x00000000}},	//   _के__संस्कार_, --, --, --, 
   {{0x89cfa003,0xebe9200c,0x8be9c00a,0x00000000}},	//   _ཚོའི_, _मत__के_, _देहरादून__नैनीताल_, --, 
   {{0xe44ee01a,0x00000000,0x00000000,0x00000000}},	//   _vidare__til_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x0c51a00a,0xc090c018,0xf2b5a003,0x00000000}},	//   _पढ़ें_, _registro__mensagen, _གི__རེད_, --, 
   {{0x73a2c01f,0x0f5da003,0x00000000,0x00000000}},	//   _lumpur_, _ནུའི__འགྱུར_, --, --, 
   {{0x2e966002,0x5479001a,0xe669800e,0xa295c003}},	//   _он__је_, _kommente_no_, _zveřejně, _འཆི__མེད_, 
   {{0x4352200d,0x527e6004,0xc39ea009,0xc29e0003}},	//   _un__amigo_, _eyona_, _betyder_, _སྲིད__པའི_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2f53e01a,0xf290a004,0x00000000,0x00000000}},	//   _sjå_, _noba_, --, --, 
   {{0x82f16009,0x6c7ac00e,0x4227c002,0x5cc2c002}},	//   _vægt_, _na__místě_, _другог__светског_, _подршку_, 
   {{0xd4646009,0xeb99e00a,0x02c66031,0x04648009}},	//   _synes__godt_, _की__गई_, _hari__dalam_, _gør__det_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [1770] --, --, --, --, 
   {{0x4290a015,0x5a33e00c,0x7ba4c003,0x00000000}},	//   _coba_, _जाव_, _དབང__གླེང_, --, 
   {{0xf317e015,0x00000000,0x00000000,0x00000000}},	//   _berbagi_, --, --, --, 
   {{0xd675001a,0x00000000,0x00000000,0x00000000}},	//   _verdskri, --, --, --, 
   {{0xcc21203c,0x3348a009,0x02ae0006,0x00000000}},	//   _mjeseca__mjeseci_, _til__vores_, _ཆེ__གིས_, --, 
   {{0x22390002,0x9bbe4006,0xf2ada00b,0x00000000}},	//   _могу_, _བརྒྱའི__ལས_, _bugomba__kuba_, --, 
   {{0x82a56011,0x4c34600c,0x00000000,0x00000000}},	//   _das__iconas_, _एही__विषय_, --, --, 
   {{0x6292600b,0x2eb4e010,0x2726600b,0x00000000}},	//   _yesaya_, _anvendes_, _muri__mudasobw, --, 
   {{0x764ec006,0x126fe00b,0xc0ede003,0x47330002}},	//   _ཡང__ཡོདཔ_, _ibi__igomba_, _རེད__རྒྱ_, _правила__строго_, 
   {{0x02a6800f,0x4302e028,0xce32e007,0x00000000}},	//   _ubaba_, _el__precio_, _menggala, --, 
   {{0x127f8039,0xb9fe402f,0x00000000,0x00000000}},	//   _karna_, _merament, --, --, 
   {{0xe291c005,0x7c0e2003,0xe9d7c00a,0x7ecca002}},	//   _elva_, _ཁོང__ནི_, _शिमला__सिरमौर_, _којим__се_, 
   {{0xc3de4018,0x00000000,0x00000000,0x00000000}},	//   _avaliaçã, --, --, --, 
   {{0xeba1c00c,0x3e296002,0x8de0c002,0x7c724002}},	//   _प्लेयर__के_, _ваш_, _ће__аутоматс, _број__чланова_, 
   {{0xd292601d,0xd4d10013,0x00000000,0x00000000}},	//   _kerana_, _साहित्य__धर्म_, --, --, 
   {{0xe3eae004,0x7019c038,0xd0b5c00c,0xcf00400a}},	//   _ndithi_, _poder__comentar_, _ध्रुपद_, _अंग्रेज़, 
   {{0x226d200b,0x99f4c012,0x93650015,0x14600018}},	// [1780] _ibyo_, _budú_, _tamu__tulisan_, _não__foi_, 
   {{0x727e8004,0x53cea00f,0xb47f000f,0xb6ee000c}},	//   _nyana_, _emsebenz_wokushum, _angaba__ngu_, _कि__वैदिक_, 
   {{0xf6bec014,0x00000000,0x00000000,0x00000000}},	//   _उतार__चढ़ाव_, --, --, --, 
   {{0x0bd1e013,0x2493200b,0x1314201a,0x22d9000e}},	//   _करियर_, _ni__iki_, _mest__lese_, _docela_, 
   {{0x6e92e018,0x83056015,0x9aad4002,0xafbe800e}},	//   _amigo__adiciona, _pemberit_saya_, _је__поделио_, _sdílet_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xabb0200a,0x8447c00e,0x236e200f,0x00000000}},	//   _लोगों__की_, _na__webu_, _ka__isaya_, --, 
   {{0x7767400a,0x00000000,0x00000000,0x00000000}},	//   _से__जल्द_, --, --, --, 
   {{0xa236c012,0xeba90003,0x146b201a,0x00000000}},	//   _svojej_, _ཁག__གི_, _endre__har_, --, 
   {{0x19e0200f,0x00000000,0x00000000,0x00000000}},	//   _kusobala_, --, --, --, 
   {{0xe0c92002,0x7469e00b,0x022c8018,0x46b0e00b}},	//   _погледај_услове_, _bamwe__mu_, _câmera_, _muslim__brotherh, 
   {{0x0a6e0014,0x7495e012,0x00000000,0x00000000}},	//   _सत्र__में_, _sa__mu_, --, --, 
   {{0x227bc00f,0x00000000,0x00000000,0x00000000}},	//   _kodwa__lokho_, --, --, --, 
   {{0x1326e009,0x125f200f,0x00000000,0x00000000}},	//   _en__anden_, _ezwini__lakhe_, --, --, 
   {{0x17b32040,0x4a4d4022,0x56d64002,0xa30f600b}},	//   _reputaci, _के__तार_, _одговор__нерегист, _urubuga_, 
   {{0x0a15200f,0xc3ea0012,0xa3eb0004,0x62d5a01a}},	//   _abrahama_, _tohto_, _ndathi_, _ikkje__noko_, 
   {{0x0eba402a,0xc2d0e00b,0x11d0e00e,0xdc6e0018}},	// [1790] _gjøre_, _telefoni_, _telefony_, _escreva_, 
   {{0xd290201f,0x00000000,0x00000000,0x00000000}},	//   _sukar_, --, --, --, 
   {{0x94956005,0x00000000,0x00000000,0x00000000}},	//   _og__ei_, --, --, --, 
   {{0xead60012,0x44b5c012,0x00000000,0x00000000}},	//   _spravoda_licencia_, _batérie_, --, --, 
   {{0x1268200b,0xd279c003,0x00000000,0x00000000}},	//   _ya__moshi_, _གནང__བའི_, --, --, 
   {{0x22ca8009,0x1fd08037,0xa3f8800b,0xec0e2003}},	//   _plads_, _estoy__respalda, _ishuri_, _ཁོག__གི_, 
   {{0x54bdc00e,0xd0f5a012,0x00000000,0x00000000}},	//   _jsme__se_, _najstarš, --, --, 
   {{0xc2544020,0x62cb0015,0x00000000,0x00000000}},	//   _ལེན__པའི_, _saja__berapa_, --, --, 
   {{0x8290c018,0x00000000,0x00000000,0x00000000}},	//   _foda_, --, --, --, 
   {{0x3bdf2006,0xa9954012,0x00000000,0x00000000}},	//   _གོལ__ཌན_, _päť_, --, --, 
   {{0xc2a1c006,0xfbfa6003,0x00000000,0x00000000}},	//   _ཤོམ__འབད_, _མྱ__ངན_, --, --, 
   {{0x7477400b,0x2276a00b,0x00000000,0x00000000}},	//   _bari__mu_, _wabona__ibyo_, --, --, 
   {{0x93ea0005,0xe425200f,0x9a3dc00a,0x04ad400b}},	//   _veit_, _kusobala__ukuthi_, _थीं_, _mbere__yo_, 
   {{0x44010034,0xa2d8000b,0x00000000,0x00000000}},	//   _expand__menu_, _buhe_, --, --, 
   {{0xd464800e,0x00000000,0x00000000,0x00000000}},	//   _uložit__ke_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [17a0] --, --, --, --, 
   {{0x9b2f2003,0x00000000,0x00000000,0x00000000}},	//   _དཔུང_, --, --, --, 
   {{0xf2d4a002,0xd22f200f,0x00000000,0x00000000}},	//   _četvrtak__izvor_, _lapho__ethi_, --, --, 
   {{0x6ceb4013,0x00000000,0x00000000,0x00000000}},	//   _दिसम्बर_, --, --, --, 
   {{0xfd77e002,0xd4906025,0x00000000,0x00000000}},	//   _програм_, _já__que_, --, --, 
   {{0xe495e012,0x00000000,0x00000000,0x00000000}},	//   _sa__tu_, --, --, --, 
   {{0x744d600f,0x00000000,0x00000000,0x00000000}},	//   _kuleli__zwe_, --, --, --, 
   {{0xe2ca4005,0x00000000,0x00000000,0x00000000}},	//   _volda_, --, --, --, 
   {{0x348c6024,0xfb856037,0x00000000,0x00000000}},	//   _naprednj, _cancelar__respuest, --, --, 
   {{0x92cbc018,0x02ab4003,0x00000000,0x00000000}},	//   _educação_, _གི__གཏམ_, --, --, 
   {{0x9a3de014,0xd0a42006,0x00000000,0x00000000}},	//   _दीं_, _ཁའི__བརྡ_, --, --, 
   {{0xd34f800b,0xe291c01a,0x2aa6800a,0xc479c00e}},	//   _print__page_, _utval_, _मनोरंजन__लाइफ_, _ceny__ze_, 
   {{0x7df10003,0x00000000,0x00000000,0x00000000}},	//   _མང__ཚོགས_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7dea6003,0x63a9801a,0xdc658009,0xa2d8201a}},	//   _སྤྱི__ཚོགས_, _elevane_, _rigtigt_, _auke_, 
   {{0x32d8c00f,0x7cbd800c,0xc25ac003,0x00000000}},	//   _kulezi_, _सांस्कृत_संध्या_, _བརྩམས__པའི_, --, 
   {{0xc2be0018,0xf4a4e009,0x00000000,0x00000000}},	// [17b0] _você__não_, _indtast__din_, --, --, 
   {{0xc4d74022,0xb39f600e,0x00000000,0x00000000}},	//   _मिथिला_, _porovnat__ceny_, --, --, 
   {{0xe2428029,0x54290015,0x1c658009,0xda374003}},	//   _བཟང_, _original__posted_, _vigtigt_, _པོ__ཆེའི_, 
   {{0x9e9ec002,0x00000000,0x00000000,0x00000000}},	//   _дакле_, --, --, --, 
   {{0x1dd0a003,0x447d4012,0xc25a2003,0x00000000}},	//   _ལག__འཁྱེར_, _hore__re_, _འབྲོག__པའི_, --, 
   {{0x59d96018,0x38d9e002,0x00000000,0x00000000}},	//   _diretame, _занимљив, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xd30f6015,0x4e90000b,0x00000000,0x00000000}},	//   _berbeda_, _victoire_, --, --, 
   {{0x3394800b,0xdc76400c,0x01dc0002,0x00000000}},	//   _amaso_, _भीष्मक_, _клуба_, --, 
   {{0x03ea600b,0xe37b0018,0x4bcde00c,0x52b6201d}},	//   _konti_, _espaço_, _तरे_, _abu__nuha_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xc28d800f,0xc0c2e00f,0x8d8f600f,0xf39d000b}},	//   _mathewu_, _ukulalel, _inhlanga, _yatangaj, 
   {{0x4a33e05a,0x4bccc006,0x24d50013,0x4b36200c}},	//   _जात_, _ལུགས__ལོ_, _विडियो_, _मधुबनी_, 
   {{0x1643400e,0xfbb3c003,0xc296e003,0x00000000}},	//   _přidat__komentář_, _དར__དང_, _འཛིན__གྱི_, --, 
   {{0x62b2a00b,0x4387400d,0x00000000,0x00000000}},	//   _barapfuy_abandi_, _cuerpo_, --, --, 
   {{0xbf118006,0x924a400f,0xe2a16003,0x00000000}},	//   _བསྐྱོདཔ__འབྲུག_, _eksodusi_, _ཐག__བཅད_, --, 
   {{0x4394600f,0xd2c4000b,0x3b4b800b,0x7e9e2002}},	// [17c0] _umose_, _friend__print_, _ubutumwa_, _налази__се_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2439e024,0xab9a000a,0x9bcc0003,0x2212800e}},	//   _na__svetu_, _शहर__की_, _ཁོངས__མི_, _takhle_, 
   {{0x7ef4c002,0x770f600a,0x00000000,0x00000000}},	//   _које__се_, _जल्द_, --, --, 
   {{0x623a8015,0x418fa002,0x00000000,0x00000000}},	//   _foto__bugil_, _пет__година_, --, --, 
   {{0x3c3de00a,0x00000000,0x00000000,0x00000000}},	//   _सदाबहार__आयुर्वे_, --, --, --, 
   {{0xebb9e003,0x2b65e01a,0x50088011,0x81110006}},	//   _དེ__དག_, _tidlegar, _relacion_páxinas_, _སྔགས__གྲྭ_, 
   {{0xa2900018,0xee764002,0x29aa6002,0x00000000}},	//   _criar_, _су__га_, _доћи_, --, 
   {{0xa3f8a039,0xfc08a014,0x4230e01a,0x0369e00a}},	//   _gedung_, _राजनीति__से_, _som__blei_, _निर्वाचि_विषयवस्त, 
   {{0x944e400b,0x1bb5e003,0x00000000,0x00000000}},	//   _taliki__ya_, _གཅིག__མཚུངས_, --, --, 
   {{0x647dc011,0x0a97a00c,0x9caae00c,0x00000000}},	//   _orde__de_, _बोलियन__में_, _कि__कवनो_, --, 
   {{0x7acac003,0xa243c006,0x00000000,0x00000000}},	//   _འཇིག_, _ཝཱན_, --, --, 
   {{0x7b9c0003,0x00000000,0x00000000,0x00000000}},	//   _མོའི__ལག_, --, --, --, 
   {{0x1290601d,0x0ba0a00a,0x00000000,0x00000000}},	//   _sunat_, _थे__और_, --, --, 
   {{0xe357603f,0x00000000,0x00000000,0x00000000}},	//   _ukufika_, --, --, --, 
   {{0x33ea4009,0x12aea006,0xb8bca002,0xfcfc8002}},	//   _nemt_, _ཌན__ཌིག_, _викимеди_остава_, _сам__овде_, 
   {{0xa20d2012,0x0bea4003,0x00000000,0x00000000}},	// [17d0] _pracovné_, _བྱོལ__ནང_, --, --, 
   {{0x0ab6400c,0x023f600f,0x00000000,0x00000000}},	//   _देशन__में_, _kuze__kufike_, --, --, 
   {{0x12caa02e,0x43876018,0x8394600d,0x00000000}},	//   _hajduk_, _quarto_, _ojos_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xe20d200e,0x16e20002,0x00000000,0x00000000}},	//   _pracovní_, _резултат, --, --, 
   {{0x6bb70011,0x5b1fc01d,0x00000000,0x00000000}},	//   _as__ligazóns_, _kelantan_, --, --, 
   {{0x74428012,0x00000000,0x00000000,0x00000000}},	//   _ťa_, --, --, --, 
   {{0x42c18012,0x9291e025,0x00000000,0x00000000}},	//   _žilina_, _atual_, --, --, 
   {{0x68e1c002,0xa26f8003,0x00000000,0x00000000}},	//   _стање_, _ཏེ__བོད_, --, --, 
   {{0xe012001e,0xebe98003,0x00000000,0x00000000}},	//   _izdvajan, _ངག__གི_, --, --, 
   {{0x67ba0021,0xca4d600c,0x52728012,0x00000000}},	//   _རྫོང__དཔོན_, _के__बात_, _júna_, --, 
   {{0xcb32a003,0x0d8ac003,0x00000000,0x00000000}},	//   _གྲོངས_, _འཇགས_, --, --, 
   {{0x9e8fa002,0x54ba4018,0x00000000,0x00000000}},	//   _на__крају_, _juros__no_, --, --, 
   {{0x936f600e,0x0294800f,0x7bd98006,0x87090002}},	//   _rozpětí_, _ofakazi_, _འཇའ__ཤར_, _четири_, 
   {{0xe3c3e00f,0x00000000,0x00000000,0x00000000}},	//   _lapho__ujesu_, --, --, --, 
   {{0x799cc00f,0x8308400f,0x00000000,0x00000000}},	//   _amanye__amakrist, _phakathi__naleso_, --, --, 
   {{0x642a000f,0x00000000,0x00000000,0x00000000}},	// [17e0] _isimo__sezulu_, --, --, --, 
   {{0xd291800d,0x6f8be00e,0xc2cae012,0xb6d6e002}},	//   _otras_, _části_, _pridaj_, _београду_, 
   {{0x6fd7002f,0x1841200a,0x00000000,0x00000000}},	//   _de__até_, _कुल्लू__कांगड़ा_, --, --, 
   {{0xebf64014,0x00000000,0x00000000,0x00000000}},	//   _गांव__के_, --, --, --, 
   {{0xc28a2006,0xb290e01d,0xbb8fc00c,0x2307200a}},	//   _བཙག__འཐུ_, _jugak_, _सँ_, _बिलासपुर__मंडी_, 
   {{0xf412803c,0x1cb2803c,0xba72803c,0x1dffc031}},	//   _sarajevo_, _sarajevu_, _sarajeva_, _ketentua, 
   {{0x2c4e0013,0x5178a035,0x12626002,0xb464e00e}},	//   _करते_, _zevangel, _евра_, _odpověz__to_, 
   {{0x82544006,0x92eb6018,0xa046400e,0x51e7201c}},	//   _རྒྱན__དབང_, _produto__comentár, _zeměděls, _आखिरी_, 
   {{0x93e50012,0x9fa50012,0x6c68000f,0xfc0e000c}},	//   _podmienk, _podmieno, _izimpawu_, _जादा__से_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xec05c01a,0x3cce200f,0x00000000,0x00000000}},	//   _viktigas, _iqiniso__lokuthi_, --, --, 
   {{0x22916003,0x6275e003,0xcaade00c,0x00000000}},	//   _བརྗོད__གཞི_, _ལོ__གསར_, _इहो__बात_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xd1fc800c,0x00000000,0x00000000,0x00000000}},	//   _के__सहारा_, --, --, --, 
   {{0x64926027,0x6294800f,0xb59e200a,0xb70e200c}},	//   _je__aj_, _ufakazi_, _कीमत_, _के__गाना_, 
   {{0xb8798003,0x00000000,0x00000000,0x00000000}},	//   _ཚོས__དབྱིན_, --, --, --, 
   {{0x632c400e,0x32626003,0xca16200b,0x92e1000f}},	// [17f0] _těchto_, _དང__བཅས_, _ingaruka_, _ukuze__athole_, 
   {{0xb2680028,0x838b800f,0x00000000,0x00000000}},	//   _del__sitio_, _ekhasini__ukuze_, --, --, 
   {{0xc48ec037,0xb491200f,0xf589800f,0x00000000}},	//   _limita__la_, _ke__uma_, _umngane__womshado_, --, 
   {{0xd2d06016,0xe496601a,0x32a68035,0x00000000}},	//   _uten__avtale_, _høve__til_, _ababi_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x14058018,0xd2e1000f,0x8bde4003,0x00000000}},	//   _ou__clique_, _ukuze__uthole_, _གཞོན__ནུ_, --, 
   {{0x0d864008,0xb3ea6025,0x00000000,0x00000000}},	//   _interese_, _ponto_, --, --, 
   {{0x69f4a012,0x2b5e000c,0x00000000,0x00000000}},	//   _hodín_, _गीतन_, --, --, 
   {{0xf36f801d,0x00000000,0x00000000,0x00000000}},	//   _bersetuj_dengan_, --, --, --, 
   {{0x7298a021,0xc0abc002,0x179fa003,0x87e56003}},	//   _ཚུལ__གསལ_, _се__промени_, _མངོན_, _བཀའ__བློན_, 
   {{0xd26c4024,0xe9f5c027,0x6a5e600a,0x00000000}},	//   _belog_, _prvé_, _यह__लेख_, --, 
   {{0x9310000b,0x9c890011,0x03cec01a,0x2e28e002}},	//   _ukwa__munani_, _ver__despois_, _gjeve_, _ма_, 
   {{0xbff40009,0x04976033,0x73f9600b,0x0b60a002}},	//   _oplysnin, _pronađi__sve_, _bugufi_, _админист, 
   {{0x2e320037,0x00000000,0x00000000,0x00000000}},	//   _hablaras_, --, --, --, 
   {{0x19186014,0xc2eee01a,0x00000000,0x00000000}},	//   _वंशज_, _kvifor_, --, --, 
  
   {{0xb964a03d,0x8594e00f,0xee8a400a,0x00000000}},	// [1800] _použití_, _onkulunk, _की__फिल्म_, --, 
   {{0x7291801f,0xa487201a,0x68a50009,0x52d8c00f}},	//   _surah_, _oppslags_gå_, _desværre_, _kuleli_, 
   {{0x9387603c,0xaaf04003,0x00000000,0x00000000}},	//   _bošnjačk, _སློབ__ཕྲུག_, --, --, 
   {{0xd4c04011,0x029d8006,0x00000000,0x00000000}},	//   _http__gl_, _དགོཔ__ཨིན_, --, --, 
   {{0x4a4e2022,0x24758030,0x04690019,0xca4ec00e}},	//   _के__नाम_, _dana__apr_, _ble__det_, _pokud__nemáš_, 
   {{0x72d4601a,0x7cf5a00a,0xf2ee800f,0x8eb96002}},	//   _tysdag_, _ऑटो__फोटो_, _njengoba__kwenza_, _циљ_, 
   {{0x378ec003,0x00000000,0x00000000,0x00000000}},	//   _འགོ__ཁྲིད_, --, --, --, 
   {{0x0200c00d,0x19646003,0x00000000,0x00000000}},	//   _nadie_, _མིང__བརླག_, --, --, 
   {{0xa3bba00b,0x0d24e017,0x0679400d,0x00000000}},	//   _indwara_, _dámské_, _miércole, --, 
   {{0x1495e012,0xf683c002,0x00000000,0x00000000}},	//   _sa__mi_, _објављен_молимо_, --, --, 
   {{0xdb938030,0xafd5a003,0x00000000,0x00000000}},	//   _pjesama__tekstova_, _བྱེད__རྒྱུ_, --, --, 
   {{0x6290e01d,0xd4784004,0x0e292002,0x4bf1a003}},	//   _bahawa_, _ngoku__ke_, _рад_, _གལ__ཆེ_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xe68a6002,0xb46aa018,0x00000000,0x00000000}},	//   _организо, _perfeito_, --, --, 
   {{0xe47a4009,0xedfb4003,0x1493800b,0x00000000}},	//   _hvad__er_, _ཤུ__རྟགས_, _ni__uko_, --, 
   {{0x93eb801a,0x00000000,0x00000000,0x00000000}},	//   _vorte_, --, --, --, 
   {{0x9a3e4022,0x00000000,0x00000000,0x00000000}},	// [1810] _भीम_, --, --, --, 
   {{0x82900011,0x127fe015,0x6260000c,0x00000000}},	//   _unha_, _hyung_, _कऽ__लिहलस_, --, 
   {{0x386d8028,0x9201a01a,0xa39ae00c,0x00000000}},	//   _consejos_, _utvida_, _इतिहास__प्रसिद्ध_, --, 
   {{0x6c02a013,0xd71a4002,0x00000000,0x00000000}},	//   _लॉग__इन_, _приватиз, --, --, 
   {{0x1b9d4003,0xf4d6801c,0x00000000,0x00000000}},	//   _ཡོད__པས_, _नोकिया_, --, --, 
   {{0x92f8401d,0xf3320011,0xbba1400a,0x39138002}},	//   _dalam__laman_, _orixe_, _है__पर_, _кликните_, 
   {{0xd290203f,0x0a844022,0x00000000,0x00000000}},	//   _inja_, _भवन__में_, --, --, 
   {{0x92c7c018,0x4c5f800a,0x65af2002,0x00000000}},	//   _comentár_comentár, _शहर__अजमेर_, _споразум, --, 
   {{0xbd37000f,0x63cbc00b,0xc5050002,0x00000000}},	//   _abangane_, _igiteker_ikigega_, _википеди_такмичењ, --, 
   {{0xe451e024,0xe594e00f,0xd4a16018,0xccc9e00b}},	//   _poruke__na_, _unkulunk, _escreva__sua_, _ku__cyumweru_, 
   {{0x633ea00f,0x7da1a003,0x00000000,0x00000000}},	//   _umphosto_ujohane_, _བརྙེས_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x3d838040,0x42d8000b,0x7a6ac00c,0x00000000}},	//   _reči_, _bihe_, _रहे__ओकर_, --, 
   {{0x8237e024,0xcdce6002,0x00000000,0x00000000}},	//   _promena_, _пише_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2eb98002,0x5253200c,0x00000000,0x00000000}},	//   _била__је_, _के__हरवलन_, --, --, 
   {{0x85b0a00b,0x7ab34002,0x00000000,0x00000000}},	// [1820] _abasirik, _индустри, --, --, 
   {{0x32250007,0xd26a2002,0x00000000,0x00000000}},	//   _adakah_, _је__један_, --, --, 
   {{0xbb88e01c,0x2905400a,0x90ec000a,0x00000000}},	//   _पर_, _चेन्नई__जबलपुर_, _जौनपुर__झांसी_, --, 
   {{0xc290c00d,0x8495e027,0x00000000,0x00000000}},	//   _dudas_, _sa__ti_, --, --, 
   {{0xe4764037,0x627f400f,0x75acc00c,0x00000000}},	//   _lugar__es_, _kwengu_, _नवरतन_, --, 
   {{0x92cae009,0xd991c002,0x00000000,0x00000000}},	//   _findes_, _уследе_, --, --, 
   {{0x149d8012,0xb296a012,0x4eb4a002,0x00000000}},	//   _rodinný__dom_, _sa__nám_, _који__не_, --, 
   {{0xb4726018,0xc2b8400a,0x6204000e,0x00000000}},	//   _tem__um_, _पानीपत__बिलासपुर_, _probíhá_, --, 
   {{0xfa662002,0x00000000,0x00000000,0x00000000}},	//   _минута_, --, --, --, 
   {{0x4a87e00f,0xd288600f,0xdfc9c002,0x00000000}},	//   _ngezinga_, _okuhlang_nakho_, _новембра_, --, 
   {{0x3bdd2006,0x4290c02f,0xe4ade00e,0x1c12600a}},	//   _ཨིན__མས_, _mudar_, _jen__na_, _विचार__एक_, 
   {{0xca3d800a,0xe2c8400e,0x208aa00c,0x00000000}},	//   _ऐसा__कोई_, _vytvořit_, _आजु__आभासी_, --, 
   {{0x84586012,0x7ab4e00c,0x00000000,0x00000000}},	//   _izbový__byt_, _सीधा__नकद_, --, --, 
   {{0x9acac03a,0x967ca02d,0xb01ca00e,0x00000000}},	//   _འཇུག_, _se__registri, _se__registro, --, 
   {{0x02438003,0xa3b34037,0x79f5e012,0x885d6025}},	//   _གཟའ_, _crear__alerta_, _autá_, _brinqued, 
   {{0xc2832003,0xec67800b,0x72e18012,0x14b02011}},	//   _མཁན__གྱི_, _tsinze__amatora_, _sk__obchodu_, _non__foi_, 
   {{0xf9afa00c,0x00000000,0x00000000,0x00000000}},	// [1830] _राष्ट्री_जांच_, --, --, --, 
   {{0x6eca200f,0x00000000,0x00000000,0x00000000}},	//   _imininin, --, --, --, 
   {{0x87280014,0x3b63401a,0x13f5a011,0x32a14003}},	//   _सफलता__हासिल_, _oppretta_, _na__páxina_, _ངོས__རྟག_, 
   {{0x63280009,0x0bc06011,0x7498600a,0x4a6cc00c}},	//   _er__noget_, _da__publicac, _भी__संपादन_, _पकड़ल__गइल_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xed86a024,0x00000000,0x00000000,0x00000000}},	//   _vrednost_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x3b88000a,0x94ad201a,0xa3556018,0xfdb3800f}},	//   _यह_, _eit__par_, _cabelos_, _wesifaza, 
   {{0x99f5a00e,0xb655e00b,0x563f800b,0x00000000}},	//   _navíc_, _umujesui, _ikinyarw, --, 
   {{0xa2cb4012,0x7286800f,0x5b8ca003,0x00000000}},	//   _predaj_, _intsha__eningi_, _པཎ_, --, 
   {{0x1f5d8002,0x73eb8017,0x1a4c000a,0x00000000}},	//   _на__иконицу_, _odst_, _है__अगर_, --, 
   {{0xe354201d,0xe495e009,0x3296a012,0x00000000}},	//   _selepas_, _op__til_, _sa__vám_, --, 
   {{0xd2008004,0xc24ce003,0x00000000,0x00000000}},	//   _uthixo_, _བརྟན__གྱི_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xd2936003,0x00000000,0x00000000,0x00000000}},	//   _ཞིག__ཡིན_, --, --, --, 
   {{0x3a42403d,0xe2d2200e,0x00000000,0x00000000}},	//   _je__také_, _se__jedná_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [1840] --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2dd7601d,0x52cb8034,0x1f24801a,0x00000000}},	//   _janji__perniaga, _jorda_, _sjølve_, --, 
   {{0x34560012,0x4c736028,0xf32f000c,0xbc334025}},	//   _prihlási_sa_, _podrás_, _आज__उसकी_, _benefíci, 
   {{0x94702018,0x53cd000b,0x00000000,0x00000000}},	//   _uma__boa_, _mu__gutanga_, --, --, 
   {{0x31ed0012,0xad7de002,0x00000000,0x00000000}},	//   _formulár, _португал_румунски_, --, --, 
   {{0xc2266015,0x6a7ea012,0x4eaa8002,0x57f8000c}},	//   _terbaru__kali_, _vášho_, _једну__од_, _के__जानकारी_, 
   {{0xc231800f,0x0e392007,0x02ff601a,0x1c4e000a}},	//   _isimiso_, _kebangsa, _til__saman_, _चुने_, 
   {{0x4291800b,0xab9e2003,0x00000000,0x00000000}},	//   _kora_, _པོ__བྱུང_, --, --, 
   {{0xfc5bc004,0xc4e20011,0x1d8ec003,0x00000000}},	//   _kakuhle_, _obrigato_enderezo_, _ཡིག__གྲོས_, --, 
   {{0x0684200d,0xde748002,0x84ff400c,0x00000000}},	//   _traducci, _случају_, _भोजपुर__क्षेत्र_, --, 
   {{0xba1e2002,0xb471202f,0x00000000,0x00000000}},	//   _види_, _que__ela_, --, --, 
   {{0xfed52002,0xf4be8018,0x63eb8018,0x7f20e006}},	//   _код_, _nome__seu_, _gosta_, _སྦྱོང__སྒྲུབ_, 
   {{0xa3d92009,0x72d8a00e,0x00000000,0x00000000}},	//   _om__svar_, _ruce_, --, --, 
   {{0x4923a00c,0x00000000,0x00000000,0x00000000}},	//   _एहिजा_, --, --, --, 
   {{0x7bd8e003,0x3cf72003,0x49c7c002,0x00000000}},	//   _གསར__ཁང_, _ཆག__འཚོལ_, _напада_, --, 
   {{0x34aea019,0xa2520003,0x00000000,0x00000000}},	// [1850] _mer__enn_, _འདུག__བོད_, --, --, 
   {{0x7d8c0012,0xb373e012,0x00000000,0x00000000}},	//   _počas_, _zadajte_, --, --, 
   {{0x1bdd4006,0xa290e011,0xb2976003,0x00000000}},	//   _ཨིན__པས_, _augas_, _རྒྱས__ཀྱི_, --, 
   {{0x3acb200c,0x27262002,0x00000000,0x00000000}},	//   _मोहर्रम_, _текстова_, --, --, 
   {{0xebeec002,0x00000000,0x00000000,0x00000000}},	//   _налог_, --, --, --, 
   {{0xc3f8c03d,0x5b1d2011,0x6d0fa00e,0x99f9600b}},	//   _budu_, _calquera_, _stránkác, _gushyira_, 
   {{0xd2c7001f,0xc3954018,0x00000000,0x00000000}},	//   _mana__mana_, _acesso_, --, --, 
   {{0xd2488004,0x8b8f000c,0x534c400b,0x00000000}},	//   _ngam_, _बात__पे_, _umviriza__kandi_, --, 
   {{0xbbf56014,0xf469a009,0x73eac009,0x00000000}},	//   _अच्__छा_, _dem__der_, _fedt_, --, 
   {{0xb2d6e00e,0x5b7c2025,0x00000000,0x00000000}},	//   _přes_, _reconhec, --, --, 
   {{0xca00e015,0x2277200e,0x00000000,0x00000000}},	//   _surabaya_, _oblíbené_, --, --, 
   {{0x72918011,0xd26dc02c,0x2290e00d,0xa22a0002}},	//   _nosa_, _ubwo_, _jugar_, _посао_, 
   {{0x29da0024,0x048f6005,0xa2520003,0x00000000}},	//   _subotica_, _ei__god_, _འདུག__དོན_, --, 
   {{0xb26c800e,0x5b19401d,0x04b9001a,0x00000000}},	//   _nahoru_, _kewangan_, _finn__ein_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xb399000d,0x6366c002,0x0469a002,0xc291800d}},	//   _más_, _ponedelj, _dodaci__gratis_, _cosa_, 
   {{0x0ba26013,0x226d200b,0x00000000,0x00000000}},	// [1860] _रहा__है_, _icyo_, --, --, 
   {{0xcc66c02a,0x1449800b,0xd482e00b,0x00000000}},	//   _knyttet_, _imbere__uko_, _ubuyoboz_bw_, --, 
   {{0x42026018,0xa2bbc01a,0x00000000,0x00000000}},	//   _equipe_, _nyhende_, --, --, 
   {{0x84866014,0xebea2022,0x89f66018,0xff926002}},	//   _तिवारी_, _मन__के_, _terça_, _одговорн, 
   {{0x048f6027,0x92e1200f,0x0598a00a,0x00000000}},	//   _ja__som_, _kule__ndaba_, _सूरत_, --, 
   {{0x2f286018,0x00000000,0x00000000,0x00000000}},	//   _escolher_, --, --, --, 
   {{0xec0a2014,0x1a3e6014,0x00000000,0x00000000}},	//   _विजय__के_, _मीद_, --, --, 
   {{0x72906005,0x7395002f,0xc4b2a016,0x747a600f}},	//   _anna_, _brasil_, _til__mms_, _leli__zwe_, 
   {{0xc2e56015,0x3328a009,0x00000000,0x00000000}},	//   _rp__kamar_, _du__vores_, --, --, 
   {{0xe3f8c00e,0x931a0009,0x00000000,0x00000000}},	//   _dlouho_, _du__finder_, --, --, 
   {{0x92a6600f,0x6200a007,0x72be400f,0x74bca00b}},	//   _kanjani_, _habib_, _esihlokw_ekhasini_, _mwungere__wa_, 
   {{0xd4246015,0x00000000,0x00000000,0x00000000}},	//   _ketentua_serta_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x72efe012,0x2210a00f,0x00000000,0x00000000}},	//   _už__reklamu_, _ukuthi__lesi_, --, --, 
   {{0x8376c002,0x00000000,0x00000000,0x00000000}},	//   _простор_, --, --, --, 
   {{0x2ba32014,0x53206015,0x13daa00e,0x0fb7200e}},	//   _भी__हम_, _nanya_, _ve__tvaru_, _rozlišen_displeje_, 
   {{0x0320601d,0x00000000,0x00000000,0x00000000}},	// [1870] _ianya_, --, --, --, 
   {{0xb349a01a,0x1097c00f,0x5fcc600e,0x00000000}},	//   _vil__vere_, _igama__likajeho, _číst_, --, 
   {{0xc48e6009,0x9cf74014,0x8bb9a003,0x119e000e}},	//   _af__en_, _नामकरण_, _ཉེ__ཆར_, _správně_, 
   {{0x57cb200a,0x69f5c012,0x00000000,0x00000000}},	//   _खेल__भविष्य_, _prvá_, --, --, 
   {{0x0cdda003,0x8bbda006,0x7b07c002,0x00000000}},	//   _མང__གཙོའོ_, _ལུ__ཕན_, _патријар, --, 
   {{0xc344c017,0x00000000,0x00000000,0x00000000}},	//   _inzerce_, --, --, --, 
   {{0x12c20039,0x00000000,0x00000000,0x00000000}},	//   _soalnya_, --, --, --, 
   {{0xa2b00003,0x00000000,0x00000000,0x00000000}},	//   _ོད__བོད_, --, --, --, 
   {{0xbec02002,0x6daae002,0x5efd2018,0x00000000}},	//   _фејсбук__регистру, _на__врх_, _nossos__clientes_, --, 
   {{0x22004019,0x84b1c014,0x4b196015,0x00000000}},	//   _nylig_, _मनोज__तिवारी_, _keuangan_, --, 
   {{0x2a156003,0x92242019,0xa291a028,0x6c6aa014}},	//   _བོད__མིའི_, _rekke_, _ropa_, _विनोबा__भावे_, 
   {{0xefa72015,0x1e28e002,0x3c4e000a,0x547f200e}},	//   _komentar_, _ја_, _करके_, _zeptejte__se_, 
   {{0xc8414020,0xf2126038,0xa3be800b,0x00000000}},	//   _ལོ__བརྒྱ_, _cunha_, _kandi__afise_, --, 
   {{0x0495e027,0xfbd98003,0xfd1dc002,0x00000000}},	//   _potrebuj, _བོད__དང_, _краља_, --, 
   {{0x24fa000a,0x8d98c00e,0x525e6003,0xb29e0003}},	//   _की__हत्या_, _rozpětí__velikost_, _ཁང__བདག_, _ཤེས__ཀྱི_, 
   {{0x82f72015,0x72622018,0xab142003,0x00000000}},	//   _dan__bisa_, _eu__tenho_, _གངས__ཕྲུག_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [1880] --, --, --, --, 
   {{0x3445400f,0x00000000,0x00000000,0x00000000}},	//   _kakhulu__kodwa_, --, --, --, 
   {{0x39d02002,0xbddb4003,0x4a7e400e,0x00000000}},	//   _мени_, _འགྲེལ__བརྗོད_, _hlavní__zprávy_, --, 
   {{0x823d8015,0xc2fb000b,0x00000000,0x00000000}},	//   _kumpulka_dari_, _gushaka_, --, --, 
   {{0x2bd82003,0x4e5a4003,0x00000000,0x00000000}},	//   _སོང__ངམ_, _བཀའ__བརྒྱུད_, --, --, 
   {{0xb49ea00b,0x948d4027,0xc2564003,0x00000000}},	//   _akarere__ka_, _aj__tak_, _ཅེས__པའི_, --, 
   {{0x02fe801b,0x4285e002,0x42126018,0xfedb6002}},	//   _kuthiwe_, _na__nadji_, _julho_, _не__би_, 
   {{0x50dd600f,0x62dde00b,0x00000000,0x00000000}},	//   _izindlel, _karongi_, --, --, 
   {{0x8254a006,0x00000000,0x00000000,0x00000000}},	//   _ཁའི__ཚིག_, --, --, --, 
   {{0x92918015,0x5496e00b,0x9bf22003,0x00000000}},	//   _rusak_, _no__ku_, _གལ__ཏེ_, --, 
   {{0xbe10a002,0xfa5e8016,0x7ba3c003,0x951ca00b}},	//   _нови__превод_, _her__ågå_, _ཡུལ__དུ_, _hakoresh, 
   {{0x44716011,0x7496e00b,0x66072007,0xa2d8601a}},	//   _que__lle_, _no__mu_, _sekurang__kurangny, _eine_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x1494000b,0x5c02e014,0x225ac012,0x00000000}},	//   _nk__uko_, _में__संयुक्त_, _okolie_, --, 
   {{0x62984003,0xf740400a,0x3b58a00c,0x00000000}},	//   _ཀྱི__བསམ_, _गाजियाबा, _संतन_, --, 
   {{0xf467201d,0xdaf50002,0x00000000,0x00000000}},	// [1890] _tidak__mahu_, _службе_, --, --, 
   {{0xd47c0016,0x32652006,0x81e1000c,0x62af0003}},	//   _innenrik, _ཟེར__སླབ_, _ठुमरी_, _བྱ__དྲན_, 
   {{0xd4bc0012,0xa9f6400e,0x2576c00b,0x00000000}},	//   _viac__ako_, _přední_, _itegeko__ryihariy, --, 
   {{0x7291c01a,0xd4716018,0x647dc011,0x9f40e012}},	//   _lova_, _que__ele_, _xullo__de_, _autorské__práva_, 
   {{0x9f786012,0x545d0015,0xe3c86018,0xf496e02f}},	//   _všetky__práva_, _quote__quote_, _encontra_mais_, _se__eu_, 
   {{0xec0f2003,0xf098400c,0x00000000,0x00000000}},	//   _ཁོང__གི_, _मातृभाषा__दिवस_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xfebce040,0xd213200d,0x92dee01d,0x02a7600f}},	//   _verovatn, _muchas_, _ke__laman_, _lapho__umuntu_, 
   {{0x1b1f600f,0x7253a003,0x00000000,0x00000000}},	//   _isifundo__sebhayib, _ཡོད__གསལ_, --, --, 
   {{0xe3fc8018,0x00000000,0x00000000,0x00000000}},	//   _saiba__mais_, --, --, --, 
   {{0x337b800e,0xbcd02009,0x52126018,0xa486c00b}},	//   _skladem_, _flexbloc, _junho_, _ingabo__za_, 
   {{0xfc47a00c,0xeba8200c,0x00000000,0x00000000}},	//   _आवत__रहे_, _ओह__के_, --, --, 
   {{0x3073400f,0xe834c00f,0x00000000,0x00000000}},	//   _bakajeho, _izimpend, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x19aa2002,0x9254c006,0x27ba400b,0x022a2002}},	//   _нови_, _ཁའི__མིང_, _gukuriki, _нова_, 
   {{0xa1f78012,0xa2b10003,0xe45e400f,0xe23fc00f}},	//   _najlepši, _པོ__བོད_, _akungaba_ukuthi_, _ngo__lapho_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [18a0] --, --, --, --, 
   {{0x7291c004,0xf46a0019,0x839d401a,0xd3c1c012}},	//   _lowa_, _hei__jeg_, _og__eigedom_, _osobné_, 
   {{0xac46200b,0x00000000,0x00000000,0x00000000}},	//   _igipolis, --, --, --, 
   {{0xc49f6037,0x898a8012,0x3e268002,0x00000000}},	//   _escribe__una_, _tlač_, _је__ово_, --, 
   {{0xaac7e00e,0xb491e018,0x6bc7c00a,0x7563800a}},	//   _kteří_, _em__um_, _रहे__थे_, _कांगड़ा__चम्बा_, 
   {{0x3c4ee00a,0x4679e00b,0x00000000,0x00000000}},	//   _करें_, _by__umwihari, --, --, 
   {{0x85240012,0xc6336017,0x2131000c,0x00000000}},	//   _ktorého_, _oblíbený, _भोजपुर__गांव_, --, 
   {{0x82afe006,0xc47a4011,0xd29fc00f,0xaf224002}},	//   _མི__ཚིག_, _nado__en_, _ukuthi__indaba_, _су__то_, 
   {{0x525b0015,0xac9e200a,0x00000000,0x00000000}},	//   _publik_, _तो__नहीं_, --, --, 
   {{0x8aad6007,0xea7ea012,0xfefc8002,0x00000000}},	//   _berkesan_, _nášho_, _је__она_, --, 
   {{0xd3996009,0x3b9c6009,0x62cf8012,0xf8226012}},	//   _læs_, _fortsætt, _obdobie_, _prehráva, 
   {{0x53cfe00e,0x00000000,0x00000000,0x00000000}},	//   _začátku_, --, --, --, 
   {{0x5291e031,0xcca88018,0x0a45600a,0x129d800b}},	//   _kota_, _de__gestão_, _फिल्म__में_, _wa__nyuma_, 
   {{0xdf2d6025,0x00000000,0x00000000,0x00000000}},	//   _através_, --, --, --, 
   {{0xd27ee01a,0xf1de801c,0x4155000c,0x509b000c}},	//   _meiner_, _टीचर_, _आयोग__बनावे_, _कुणाल__सिंह_, 
   {{0xf606205b,0xaa73a00e,0x00000000,0x00000000}},	//   _प्रतिक्र, _podívejt, --, --, 
   {{0x22fce015,0xb497e019,0xd6dee00a,0x6a9b000a}},	// [18b0] _banget_, _si__at_, _की__कोशिश_, _फिल्टर__लगा_, 
   {{0xbeed0018,0xee83400a,0xe0f12014,0x00000000}},	//   _mulheres_, _के__सदस्य_, _कुंवर_, --, 
   {{0x1c60a01f,0x4a4ba00b,0xfea9600c,0x00000000}},	//   _rujukan_, _perezida_, _से__कार्यक्र, --, 
   {{0x8048200a,0x9a77401c,0x00000000,0x00000000}},	//   _संस्करण__दर्शाव_, _देखभाल_, --, --, 
   {{0xf2efc011,0xb491e012,0x00000000,0x00000000}},	//   _galicia_, _by__sme_, --, --, 
   {{0x76710006,0x00000000,0x00000000,0x00000000}},	//   _འབད__ཡོདཔ_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xd47ea011,0x8b202003,0x00000000,0x00000000}},	//   _senón__que_, _རིས__ཀློག_, --, --, 
   {{0xd496e011,0xa9f66009,0x6469e011,0x14b0a011}},	//   _xa__que_, _besøg_, _ata__de_, _non__son_, 
   {{0xeb8e801c,0x02ca6009,0x23280019,0x72d9200a}},	//   _वे_, _finde_, _en__liten_, _मूवी_, 
   {{0x72dda018,0x5a802009,0x3496801a,0xb2c1600f}},	//   _por__isso_, _hovsa__finansie, _om__eit_, _ukuphila__kwami_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa2eea02e,0xbed76011,0x00000000,0x00000000}},	//   _štimac_, _xornadas_, --, --, 
   {{0xa3ac6025,0x00000000,0x00000000,0x00000000}},	//   _roupas_, --, --, --, 
   {{0x3494202a,0x00000000,0x00000000,0x00000000}},	//   _på__hva_, --, --, --, 
   {{0x6eee4025,0x34c76009,0x6494201a,0xeba7200c}},	//   _milhões_, _klik__på_, _på__kva_, _एह__के_, 
   {{0x92d8200b,0xcb03c002,0xd39f2018,0x9fe9200a}},	// [18c0] _kamena_, _можете_, _dúvidas__sobre_, _मुताबिक_, 
   {{0xcc6fa018,0xfd66600b,0x00000000,0x00000000}},	//   _padrão_, _kuba__ifunguye_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xd291e00b,0xe2a90003,0x5f1ea00f,0x00000000}},	//   _sota_, _བྱེད__ཡུལ_, _ngezikha_ezithile_, --, 
   {{0x6bbae006,0x00000000,0x00000000,0x00000000}},	//   _དེ__ཁར_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x853ae004,0x12736009,0x4291801d,0x583a0003}},	//   _kulo__elimiwey, _mænd_, _surau_, _དང__སྤྱི_, 
   {{0x8627402f,0x00000000,0x00000000,0x00000000}},	//   _aplicati, --, --, --, 
   {{0xb1456012,0xd491c00b,0x00000000,0x00000000}},	//   _špeciali, _ubwami__bw_, --, --, 
   {{0x2eb3e002,0x425aa01a,0x00000000,0x00000000}},	//   _која__је_, _kjelde_, --, --, 
   {{0xd2246019,0xebd0000c,0x02ca200e,0x43ea2012}},	//   _tenke_, _वंश__के_, _nikdo_, _nikto_, 
   {{0x5b5b4006,0x1ee32002,0x8b02e002,0x00000000}},	//   _ལུ__རྫོང_, _оне_, _форуму_, --, 
   {{0xfc922002,0x00000000,0x00000000,0x00000000}},	//   _овде_, --, --, --, 
   {{0x22d8a017,0xe538400f,0x00000000,0x00000000}},	//   _sice_, _abantu__abangaph, --, --, 
   {{0x2e2dc002,0x00000000,0x00000000,0x00000000}},	//   _броја_, --, --, --, 
   {{0x2cd6c002,0xc2d8c009,0x0e56c002,0x3376c002}},	//   _српски_, _lide_, _српска_, _српско_, 
   {{0x72a86009,0x0307c01d,0x88198011,0x00000000}},	// [18d0] _en__lille_, _maklumat__dalam_, _en__castelán_, --, 
   {{0x2212a00d,0x00000000,0x00000000,0x00000000}},	//   _mucho_, --, --, --, 
   {{0x763b200b,0x00000000,0x00000000,0x00000000}},	//   _mpuzamah, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x3794a00c,0x00000000,0x00000000,0x00000000}},	//   _अउर__शास्त्र_, --, --, --, 
   {{0x84a34005,0xda95e00a,0x1b622013,0x00000000}},	//   _når__eg_, _और__दिन_, _कितना_, --, 
   {{0xe4b36009,0x0284800f,0x00000000,0x00000000}},	//   _plads__til_, _akubona__bonke_, --, --, 
   {{0xaa406018,0x7594e01a,0xc2d88013,0x294ba00a}},	//   _de__preço_, _hovudsak, _धोनी_, _इलाहाबाद__उदयपुर_, 
   {{0xda56400b,0xedb7e003,0x00000000,0x00000000}},	//   _ubufasha__buboneka_, _གཞུང__འབྲེལ_, --, --, 
   {{0x07280002,0x6891e00f,0xfd2ec00b,0xf2d8c00a}},	//   _због_, _kwakungu, _ifunguye_, _हंसी_, 
   {{0x3bfdc00c,0x933d200a,0x00000000,0x00000000}},	//   _आइल__बा_, _पर__अपनी_, --, --, 
   {{0x1f09200f,0x00000000,0x00000000,0x00000000}},	//   _lapho__sibheken, --, --, --, 
   {{0x52728037,0xa2df2031,0x00000000,0x00000000}},	//   _julio__junio_, _mengerti_, --, --, 
   {{0xb472e025,0x00000000,0x00000000,0x00000000}},	//   _que__em_, --, --, --, 
   {{0x4bb3e009,0x4871000c,0xbf82c002,0x00000000}},	//   _se__billeder, _दीपेंद्र_, _сваке_, --, 
   {{0x93874016,0x9f5da01f,0x00000000,0x00000000}},	//   _endret_, _pelancon, --, --, 
   {{0xf3eae039,0x9be36006,0xb4704018,0x33f3400f}},	// [18e0] _lintas_, _སྐྲུན__ལས_, _entre__em_, _kokubili_, 
   {{0xca3e200a,0x00000000,0x00000000,0x00000000}},	//   _जिसका__कोई_, --, --, --, 
   {{0xff8be018,0xc386c00d,0x621d2006,0xfddf0006}},	//   _além_, _ayer_, _དེ__བཟུམ_, _སྟོན__སྤྱོད_, 
   {{0x36f8a00a,0x546dc00f,0x625e6003,0x00000000}},	//   _होना_, _adamu__no_, _སྟེར__བཟོ_, --, 
   {{0x22d9200a,0xdbda2003,0x00000000,0x00000000}},	//   _मंडी_, _རྣམ__ཐར_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x62d8c010,0xfbdba038,0x00000000,0x00000000}},	//   _vide_, _alumnado_, --, --, 
   {{0xde5d6012,0xc328202a,0x1b8ca013,0x12eb200a}},	//   _nehnuteľ, _et__annet_, _क्_, _स्थायी__कड़ी_, 
   {{0xe2d8c011,0xb2126011,0x349e200e,0x00000000}},	//   _galega_, _nunha_, _od__kč_, --, 
   {{0x0bd9e003,0x1b2ec00a,0x00000000,0x00000000}},	//   _བོད__ནང_, _झांसी__देवरिया_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x728f0006,0x2212e018,0x16ec600c,0x00000000}},	//   _གསལ__ཕུག_, _ganhar_, _के__नोटिस_, --, 
   {{0xa611e00e,0x00000000,0x00000000,0x00000000}},	//   _problémů_, --, --, --, 
   {{0x55ca400f,0xf325600e,0x825da00c,0x00000000}},	//   _ngesinye__isikhath, _je__třeba_, _के__पहिला_, --, 
   {{0xc413600f,0x2ec44002,0xb472e025,0x00000000}},	//   _yingakho_, _којој__је_, _que__um_, --, 
   {{0xd2ad4045,0x21d9600c,0x00000000,0x00000000}},	// [18f0] _autorské_zákona_, _दूसर_, --, --, 
   {{0xa4a9a01a,0xe2cfc00b,0x00000000,0x00000000}},	//   _der__dei_, _gasana__igihugu_, --, --, 
   {{0xf50e6014,0x6bbc200a,0x1c60200f,0x2bdae003}},	//   _भी__ज्यादा_, _अपने__आप_, _kabusha_, _བརྗོད__མང_, 
   {{0xa4b66018,0x8b9ce012,0x00000000,0x00000000}},	//   _muito__bem_, _jedného_, --, --, 
   {{0x8c76c013,0x00000000,0x00000000,0x00000000}},	//   _नवम्बर_, --, --, --, 
   {{0x02126011,0x9ebee034,0x00000000,0x00000000}},	//   _dunha_, _fjordane_, --, --, 
   {{0xd200a01d,0xc253e003,0x0a80400c,0x518e800f}},	//   _hadith_, _མིའི__ཐོབ_, _भोजपुर__में_, _yini__okufanel, 
   {{0xfac7200e,0x00000000,0x00000000,0x00000000}},	//   _společně_, --, --, --, 
   {{0xe316a00b,0xf3e78012,0x00000000,0x00000000}},	//   _umujesui_imbere_, _dátum_, --, --, 
   {{0xe332e02f,0x024ca014,0xeea5c002,0x00000000}},	//   _baixar_, _हरवला_, _томе__да_, --, 
   {{0x54604028,0x00000000,0x00000000,0x00000000}},	//   _sólo__se_, --, --, --, 
   {{0xc751805c,0x0526e018,0xcbe74013,0x00000000}},	//   _विकिपीडि, _carrinho_, _पल__पल_, --, 
   {{0xf9f4600e,0xfe72e002,0x00000000,0x00000000}},	//   _nyní_, _де_, --, --, 
   {{0x0275600a,0x00000000,0x00000000,0x00000000}},	//   _मंडी__शिमला_, --, --, --, 
   {{0x239fa00b,0x12a78012,0x00000000,0x00000000}},	//   _cy__amafoto_, _farby_, --, --, 
   {{0xc3740015,0xb6b3c00f,0x4be7c00c,0x7bb4e003}},	//   _jawa__tengah_, _zokuziph, _एह__तरे_, _ནམ__ཡང_, 
   {{0x3395e00f,0x69f4a009,0x6298400b,0xbdef4003}},	// [1900] _umusa_, _bedøm_, _ngo__kuko_, _སྐྱེལ__བྱོས_, 
   {{0xd2d8e009,0x0399a018,0x3ec72002,0x19f66011}},	//   _lige_, _mês_, _земље_, _porén_, 
   {{0x43eb8018,0x00000000,0x00000000,0x00000000}},	//   _gosto_, --, --, --, 
   {{0xf7bda003,0x00000000,0x00000000,0x00000000}},	//   _བྱོས__མདུན_, --, --, --, 
   {{0xc4d6e014,0x00000000,0x00000000,0x00000000}},	//   _बिलियन_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xd48cc002,0x00000000,0x00000000,0x00000000}},	//   _učlanjen__pol_, --, --, --, 
   {{0xcbad2003,0xa38c2002,0x00000000,0x00000000}},	//   _དང__པོ_, _руке_, --, --, 
   {{0x62b1c006,0xa23c0003,0x00000000,0x00000000}},	//   _ཆས__ཇོང_, _གཞི__རྩོམ_, --, --, 
   {{0x1496e00e,0x62d8e01a,0x444fe009,0x72e1a00f}},	//   _se__mi_, _eige_, _resten__af_, _amazwi__kajesu_, 
   {{0x5cc2e017,0x00000000,0x00000000,0x00000000}},	//   _český_, --, --, --, 
   {{0x1389800f,0x5c67800b,0x00000000,0x00000000}},	//   _imiyalo_, _inkunga_, --, --, 
   {{0x2496e00b,0x44fb0012,0xa40a2018,0x12e1a012}},	//   _se__ni_, _na__stránke_, _economiz, _neužitoč_toto_, 
   {{0x7ba6a030,0x00000000,0x00000000,0x00000000}},	//   _komentar_čitanja_, --, --, --, 
   {{0x5c26401e,0xa26a000f,0xec6d8017,0x6e916018}},	//   _postovi__pridruže, _ejerusal, _zahrada_, _foi__adiciona, 
   {{0x06f86014,0x00000000,0x00000000,0x00000000}},	//   _मुंबई__पुलिस_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [1910] --, --, --, --, 
   {{0x2db76003,0xe26a000f,0x2afbe00a,0x8241200f}},	//   _ཟླ__གཉིས_, _ijerusal, _इलाहाबाद__उन्नाव_, _futhi__lokhu_, 
   {{0xc273a01d,0x00000000,0x00000000,0x00000000}},	//   _peribadi_, --, --, --, 
   {{0x0ac0a00c,0x00000000,0x00000000,0x00000000}},	//   _वाली__बाई_, --, --, --, 
   {{0x9f7c2017,0xb4b2a025,0x4ab8a00e,0x00000000}},	//   _všechna__práva_, _por__uma_, _místní_, --, 
   {{0x42d8e009,0x2200200f,0x4cf5801a,0xed8fa029}},	//   _sige_, _simiso_, _deltakar, _མཛེས_, 
   {{0x9e25c015,0x12d8e009,0x00000000,0x00000000}},	//   _konfirma, _pige_, --, --, 
   {{0x82d9801b,0x033ee00c,0x1dba6002,0x00000000}},	//   _kuse_, _टुटी__फुटी_, _почетком_, --, 
   {{0xb4598025,0x00000000,0x00000000,0x00000000}},	//   _está__em_, --, --, --, 
   {{0xeeb90002,0x7e76e00e,0x2e97e002,0x00000000}},	//   _био_, _klikněte_, _којима__је_, --, 
   {{0xae19e015,0x821ca00e,0x0859e01d,0x2b78e00c}},	//   _selengka, _během_, _selangor_, _ओह__गीतन_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xfebba00e,0xebab400a,0x59fba00e,0xe73ba00e}},	//   _dětské_, _कि__इस_, _dětský_, _dětská_, 
   {{0x92d9003f,0xc4bde00a,0x00000000,0x00000000}},	//   _nize_, _नोएडा_, --, --, 
   {{0x2a8b4016,0x05a4000e,0x00000000,0x00000000}},	//   _vennligs, _nacházít, --, --, 
   {{0x32ca801f,0xec5c6022,0x62b9c00e,0xfe0d2002}},	//   _tiada_, _संदेह_, _víc_, _сва_, 
   {{0xebcf600c,0x00000000,0x00000000,0x00000000}},	// [1920] _किला__के_, --, --, --, 
   {{0xcc90e011,0x8a3c200a,0x92e8a00c,0x00000000}},	//   _dos__centros_, _एटा_, _के__धरती_, --, 
   {{0xe3eb801a,0xd2d54024,0xb291600b,0x36cee012}},	//   _vert_, _devojka_, _kigali_, _priateli, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xbf5e2006,0xabd2c006,0x9967c00e,0x26e8c00b}},	//   _སྟོན__འབྲུག_, _འབད__དེ_, _nářadí_, _mudasobw, 
   {{0x0ccac003,0x00000000,0x00000000,0x00000000}},	//   _འབོར_, --, --, --, 
   {{0xaee8e002,0xb297a00e,0x00000000,0x00000000}},	//   _се__то_, _se__nám_, --, --, 
   {{0x895ea00d,0x514ee00f,0x8a80c027,0x00000000}},	//   _cualquie, _okufanel, _tehotens, --, 
   {{0x42d9000f,0x6f03600e,0x52b8e003,0x00000000}},	//   _yize_, _rozpětí__hmotnost_, _རྡ__སའི_, --, 
   {{0xa2b40006,0x00000000,0x00000000,0x00000000}},	//   _རེ__དོན_, --, --, --, 
   {{0x714ee00f,0xe4aee027,0x00000000,0x00000000}},	//   _akufanel, _len__na_, --, --, 
   {{0x0e292002,0x00000000,0x00000000,0x00000000}},	//   _сад_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x04618028,0x1f77a00f,0xcead8002,0x00000000}},	//   _gracias__por_, _imicaban, _политича, --, 
   {{0xe36f4004,0x34ac201d,0x00000000,0x00000000}},	//   _elimiwey_liphela_, _sedia__ada_, --, --, 
   {{0xe2d9003f,0x83948018,0x00000000,0x00000000}},	//   _size_, _umas_, --, --, 
   {{0xb2904031,0xe3eb8002,0xc2710009,0x53de2002}},	// [1930] _iklan_, _vest_, _til__butik_, _србе_, 
   {{0xb50c6011,0xa2ca6018,0x00000000,0x00000000}},	//   _febreiro_, _vindo_, --, --, 
   {{0xebe8e018,0x00000000,0x00000000,0x00000000}},	//   _vermelho_, --, --, --, 
   {{0x73286009,0x1e72c00a,0x00000000,0x00000000}},	//   _et__andet_, _सॉर्ट_, --, --, 
   {{0x2294e01d,0xa4aee012,0x5379000c,0x00000000}},	//   _laluan__anda_, _len__za_, _कऽ__सकेला_, --, 
   {{0x34b86009,0x4058a002,0xfb14c002,0x00000000}},	//   _ind__på_, _електрон, _избор_, --, 
   {{0xe31e6011,0xd2b5e00b,0x00000000,0x00000000}},	//   _traído__desde_, _umuco_, --, --, 
   {{0xa3ea801d,0x8c49c002,0x00000000,0x00000000}},	//   _dasar__privasi_, _једног_, --, --, 
   {{0x8a9c600e,0xbbb5e00a,0x00000000,0x00000000}},	//   _způsobem_, _लिंक__पर_, --, --, 
   {{0xa2d4600b,0x00000000,0x00000000,0x00000000}},	//   _bugomba_, --, --, --, 
   {{0xab4f8028,0x00000000,0x00000000,0x00000000}},	//   _la__posición_, --, --, --, 
   {{0x348cc012,0x32480018,0x3297a00e,0x7ea64002}},	//   _ktoré__sa_, _acima_, _se__vám_, _придружи_се_, 
   {{0x2d208012,0xa48fc012,0x00000000,0x00000000}},	//   _vyhľadáv, _vytvoriť_, --, --, 
   {{0x12902005,0x71eac003,0xc2d4600b,0x00000000}},	//   _saka_, _འབུམ_, _tugomba_, --, 
   {{0x229b6002,0xf7bc200c,0x00000000,0x00000000}},	//   _август__нема_, _के__कारस्तान, --, --, 
   {{0xac59000e,0xb2d5800a,0x00000000,0x00000000}},	//   _hlavně_, _उपकरण__यहाँ_, --, --, 
   {{0x0290200d,0xb256c003,0x00000000,0x00000000}},	// [1940] _baja_, _སེངྒེ__དཀར_, --, --, 
   {{0xca76800b,0x12902028,0xd464801a,0xc4b1c00d}},	//   _ijana__barakome, _caja_, _engelsk__den_, _tiene__un_, 
   {{0xc24de003,0x00000000,0x00000000,0x00000000}},	//   _བསྟན__གྱི_, --, --, --, 
   {{0x7299a003,0x7eb92002,0x1ba68003,0x02992003}},	//   _གྱི__གསལ_, _тим_, _དབང__རླུང_, _ཀྱི__གསོ_, 
   {{0x7b97600c,0x02fd6025,0xb19ae00a,0x00000000}},	//   _के__मत_, _viagem_, _स्वशिक्ष_अक्सर_, --, 
   {{0xc4b74028,0x00000000,0x00000000,0x00000000}},	//   _clic__en_, --, --, --, 
   {{0x09f4e00d,0xd3738019,0x72d1001a,0x6717e002}},	//   _quién_, _ikke__lenger_, _om__trong_, _факултет, 
   {{0xc4aa601a,0x9224c00a,0x729a2003,0x00000000}},	//   _ein__del_, _पुणे__पलवल_, _བའི__གསལ_, --, 
   {{0x82866002,0x00000000,0x00000000,0x00000000}},	//   _брзе__интернет_, --, --, --, 
   {{0xe463402a,0xfbdfe003,0x00000000,0x00000000}},	//   _innlegg__er_, _ངེས__པར_, --, --, 
   {{0x5b288003,0x92fde00b,0x00000000,0x00000000}},	//   _ྋགོང_, _ivuga_, --, --, 
   {{0x64324033,0x5045600c,0x00000000,0x00000000}},	//   _profil__korisnik, _सीरियल__ब्लास्ट_, --, --, 
   {{0xada24006,0x4fd9800b,0x00000000,0x00000000}},	//   _ལྡེ__སྒྲོམ_, _minispoc_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x52976006,0x00000000,0x00000000,0x00000000}},	//   _ཤོག__ལེབ_, --, --, --, 
   {{0x12902031,0x00000000,0x00000000,0x00000000}},	//   _saja_, --, --, --, 
   {{0xa029600a,0x00000000,0x00000000,0x00000000}},	// [1950] _सलाह_, --, --, --, 
   {{0x1f288002,0x00000000,0x00000000,0x00000000}},	//   _правопис, --, --, --, 
   {{0xfc07e025,0xac2ba00c,0xa94a800f,0x00000000}},	//   _vários_, _जा__सकी_, _ukungabi__nabulung, --, 
   {{0xc4712011,0x12fde02c,0x0bdea003,0x00000000}},	//   _que__non_, _avuga_, _འགོད__ནང_, --, 
   {{0xca41a014,0xaa760013,0xb28da00f,0x00000000}},	//   _के__आयोजन_, _नवीनतम_, _ukuthi__ubani_, --, 
   {{0x65c4a03f,0x0395403d,0x00000000,0x00000000}},	//   _isiphelo_, _česku_, --, --, 
   {{0x6472200d,0x2c35000c,0x00000000,0x00000000}},	//   _derechos__de_, _में__एगो_, --, --, 
   {{0xcf53400a,0x00000000,0x00000000,0x00000000}},	//   _जाएगा_, --, --, --, 
   {{0xa98ec002,0x5a4c200c,0x00000000,0x00000000}},	//   _назив_, _के__एकर_, --, --, 
   {{0x92e94039,0x77c8c012,0xc2916018,0x00000000}},	//   _artinya_, _poisteni, _bem__como_, --, 
   {{0x0cbce00f,0x00000000,0x00000000,0x00000000}},	//   _sikajesu_, --, --, --, 
   {{0x393b401a,0x44b4c009,0x33f8e00b,0x00000000}},	//   _framtida_, _løbet__af_, _gahuza_, --, 
   {{0xb633800a,0x00000000,0x00000000,0x00000000}},	//   _व्रत__त्योहार_, --, --, --, 
   {{0xb9a7e030,0xc29fc012,0x727ee01a,0xdba88003}},	//   _zabranje_koristit, _mňa_, _hennar_, _ཁྲིམས__ཐག_, 
   {{0xc2904012,0x00000000,0x00000000,0x00000000}},	//   _mala_, --, --, --, 
   {{0xa2b0a003,0x00000000,0x00000000,0x00000000}},	//   _མི__ཞིག_, --, --, --, 
   {{0xd3550028,0xb419a014,0xb47c400e,0x00000000}},	// [1960] _recetas_, _पूरब_, _bylo__to_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xb2b22007,0x00000000,0x00000000,0x00000000}},	//   _cari__orang_, --, --, --, 
   {{0x64966018,0x00000000,0x00000000,0x00000000}},	//   _pontos__de_, --, --, --, 
   {{0x2ed54002,0xca7e800c,0x00000000,0x00000000}},	//   _па__је_, _कवन__भोज_, --, --, 
   {{0x329fc012,0x5499e00f,0x1324400f,0x00000000}},	//   _dňa_, _cabanga__nje_, _nje__ujehova_, --, 
   {{0x33276011,0x621da006,0xebd6200c,0x00000000}},	//   _gl__index_, _དོ__བཟུམ_, _विश्वामि_के_, --, 
   {{0xfdce6002,0xc764200c,0x00000000,0x00000000}},	//   _биће_, _कभी__हमरा_, --, --, 
   {{0x8326601a,0xc488400e,0xa2b0a003,0x4431800b}},	//   _av__talet_, _která__je_, _བུ__ཞིག_, _mu__mutwe_, 
   {{0x085dc002,0x00000000,0x00000000,0x00000000}},	//   _означен_, --, --, --, 
   {{0x293b401a,0xcbb4000c,0x00000000,0x00000000}},	//   _framsida_, _आगे__ही_, --, --, 
   {{0xfbb5400c,0x00000000,0x00000000,0x00000000}},	//   _हऽ__तऽ_, --, --, --, 
   {{0xd480e00a,0xde3b000b,0x00000000,0x00000000}},	//   _भाषाएँ_, _burasira, --, --, 
   {{0xc2da401d,0x1c2ba022,0x39e42002,0xbdc9800a}},	//   _isteri_, _जा__सके_, _људи__који_, _बलिए_, 
   {{0x325e0018,0xa3eaa018,0x328c000b,0x00000000}},	//   _você__aceita_, _avaliaçã_suas_, _gusaba__ijambo_, --, 
   {{0x8ac82003,0xc2a8a006,0x897f600f,0x00000000}},	//   _ཀློག_, _སྐྲུན__འབད_, _umphakat, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [1970] --, --, --, --, 
   {{0x37854003,0x7a62800a,0x629a2003,0x00000000}},	//   _གསར__འགོད_, _नहीं__हैं_, _ཚོར__གསར_, --, 
   {{0x95e0c012,0xb6504012,0xa048600a,0x2ec26002}},	//   _literatú, _ďakujeme_, _वडोदरा__वाराणसी_, _данас__је_, 
   {{0x32ca601d,0x826c0018,0xd2d7800f,0x00000000}},	//   _minda_, _olhos_, _ujehova__ungunkul, --, 
   {{0xf8632019,0x2d7c8002,0x2d47c00e,0xfbbda006}},	//   _spennend, _не__може_, _nejoblíb, _ལུ__པར_, 
   {{0xfc10a022,0xdde1000a,0x00000000,0x00000000}},	//   _लाख__से_, _कोई__आपत्तिजन, --, --, 
   {{0x5284000f,0x6ed8e018,0x00000000,0x00000000}},	//   _ngokushe_ngemva_, _produto__adiciona, --, --, 
   {{0xf27e201a,0x00000000,0x00000000,0x00000000}},	//   _namnet_, --, --, --, 
   {{0x62ca6025,0x2eff2002,0xd9cde00f,0xb3f8c00f}},	//   _ainda_, _доступан__под_, _abafowet, _kalula_, 
   {{0x37cd0003,0x426c201a,0xebdf200f,0x00000000}},	//   _དེ__བཞིན_, _nokon_, _umusa__wothando_, --, 
   {{0xd2cae01d,0x82da400f,0x026c0012,0x00000000}},	//   _oleh__kerana_, _esteri_, _mohol_, --, 
   {{0x9492a012,0x00000000,0x00000000,0x00000000}},	//   _komentár_tak_, --, --, --, 
   {{0x72bfc00f,0x06f9a00c,0x00000000,0x00000000}},	//   _sakwa__israyeli_, _पंडा_, --, --, 
   {{0x42128017,0xc5b7a00a,0x26d8e00c,0xf6b5400c}},	//   _praha_, _मनोरंजन__सेहत_, _के__नीति_, _अपना__किताब_, 
   {{0x5488400e,0x32cbe00e,0x8fc3e00e,0x00000000}},	//   _která__se_, _soudu_, _říj_, --, 
   {{0x6212000f,0x22b4800b,0x00000000,0x00000000}},	//   _isihe_, _iwacu_, --, --, 
   {{0xace4e003,0xce14a012,0xec4e0013,0x00000000}},	// [1980] _བཙན__བྱོལ_, _zamestna, _चुके_, --, 
   {{0xb481000f,0x02ca600b,0x00000000,0x00000000}},	//   _engaba__ngu_, _bindi_, --, --, 
   {{0xd2906007,0x644c4028,0x1735800c,0x00000000}},	//   _mana_, _cuenta__de_, _देखे__खातिर_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xf26c0018,0x9b58000c,0x9ceee00c,0x00000000}},	//   _meio_, _लोगन_, _ना__कवनो_, --, 
   {{0x2eb4a002,0x341f600b,0x1478c012,0x52580003}},	//   _који__је_, _rupapuro_, _nie__sú_, _ལོང__ཤེས_, 
   {{0xa46a6010,0x00000000,0x00000000,0x00000000}},	//   _jeg__ved_, --, --, --, 
   {{0x5069200a,0x00000000,0x00000000,0x00000000}},	//   _सुखबीर__सिंह_, --, --, --, 
   {{0x2290600b,0x7c89c012,0x727fa00f,0xe3f40018}},	//   _bana_, _si__vybrať_, _izinto__eziningi_, _gostei_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x746be00b,0x00000000,0x00000000,0x00000000}},	//   _bimwe__mu_, --, --, --, 
   {{0x7497e00b,0x8cc5000c,0x00000000,0x00000000}},	//   _mu__mu_, _खतरा__नइखे_, --, --, 
   {{0x64344006,0x7b774002,0x5780000c,0xd6cd6012}},	//   _ཆེན__འཕྲལ_, _презимен_село_, _नकद__हस्तांतर, _vybaveni, 
   {{0xec7ac044,0x00000000,0x00000000,0x00000000}},	//   _परिवर्तन_, --, --, --, 
   {{0x6294a003,0x00000000,0x00000000,0x00000000}},	//   _རབས__གསར_, --, --, --, 
   {{0x5260a003,0x00000000,0x00000000,0x00000000}},	//   _རྩོམ__གཡུ_, --, --, --, 
   {{0x02d9e00a,0x6695c003,0xdc35400e,0xb46b200f}},	// [1990] _पूरी_, _དོན__གྲུབ_, _městě_, _kepha__uma_, 
   {{0xfee04022,0x9b630002,0x00000000,0x00000000}},	//   _चित्रकला, _дански__енглески_, --, --, 
   {{0x6b530039,0x7a32e00c,0xdbed0006,0xe386c012}},	//   _yang__tersedia_, _ओकर_, _ཀམ__བོ_, _ktorom_, 
   {{0xf2e6600b,0xa4aaa01a,0xa3b00012,0x39a30002}},	//   _cyangwa_, _med__dei_, _vykonáva_, _ивица__дачић_, 
   {{0x7bbaa00a,0x00000000,0x00000000,0x00000000}},	//   _सिंह__ने_, --, --, --, 
   {{0x73eac012,0xd4480017,0x6c54a011,0x32ec8012}},	//   _tieto_, _dobrý__den_, _descrici_comentar, _športy_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x59a84011,0xec12c003,0x437f800b,0x00000000}},	//   _lonxitud, _དཀར__མོ_, _muhanda_, --, 
   {{0xfc26c018,0xf285000f,0x73334018,0xbdfee00a}},	//   _avançada_, _abantu__abangu_, _porto__alegre_, _फिल्मीखब, 
   {{0x4d2e6002,0xc3f8400f,0x026c0012,0xcecd000e}},	//   _član__učlanjen_, _uhlu_, _neho_, _inzerátů_, 
   {{0xfcc04012,0xf22f800f,0x2be62003,0x1d620002}},	//   _najväčši, _futhi__yini_, _གཙོའི__ལམ_, _овде__нове_, 
   {{0xd379e018,0x5c654004,0x6b61c00a,0x33074011}},	//   _tamanho_, _umateyu_, _देखने_, _que__facer_, 
   {{0xfbdae003,0x00000000,0x00000000,0x00000000}},	//   _རྣམ__པར_, --, --, --, 
   {{0x67682022,0x12b6000e,0x00000000,0x00000000}},	//   _में__उनका_, _procesor_méně_, --, --, 
   {{0x42d98018,0x2eed8002,0x9c088002,0x00000000}},	//   _esses_, _потребно__је_, _традициј, --, 
   {{0x1e8c4014,0x00000000,0x00000000,0x00000000}},	//   _के__पुत्र_, --, --, --, 
   {{0x0a33600c,0x00000000,0x00000000,0x00000000}},	// [19a0] _कवन_, --, --, --, 
   {{0xe2a32003,0x02710006,0x0e546018,0x8378000c}},	//   _བློ__བཟང_, _དེ__གིས_, _processa, _कवनो__संबंध_, 
   {{0xe4bac01a,0xe4494012,0x00000000,0x00000000}},	//   _finn__du_, _témy__tomto_, --, --, 
   {{0xd26e0025,0x11e2802a,0xa4aa201a,0x815c0002}},	//   _depois_, _vi__forbehol, _det__dei_, _редакциј_дневника_, 
   {{0x3f6b2002,0x70fb000c,0xa4c7e002,0x00000000}},	//   _стране_, _के__परीक्षा_, _метохије_, --, 
   {{0x323a6012,0x02d2a006,0x09100002,0x32c1400f}},	//   _môj_, _གཅིག__ཨིན_, _шовинист_поруке_, _ezingaph_kuka_, 
   {{0x0249801d,0x4862400b,0x00000000,0x00000000}},	//   _rasmi_, _gusobanu, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xf8672037,0x026c2004,0x8485c005,0x00000000}},	//   _mensajes_, _meko_, _trur__eg_, --, 
   {{0xf744600a,0xbfe10002,0x00000000,0x00000000}},	//   _वाले__प्रश्न_, _овој_, --, --, 
   {{0x52b40024,0x31350045,0x00000000,0x00000000}},	//   _blic_, _partnero, --, --, 
   {{0x58862025,0xed14c002,0x1c53800b,0x00000000}},	//   _conhecid, _садрже__псовке_, _ibitero_, --, 
   {{0x0267a01e,0x129e800b,0x00000000,0x00000000}},	//   _sallalla_alejhi_, _ya__nyuma_, --, --, 
   {{0x12d44012,0xc296a009,0xc2b7e018,0x00000000}},	//   _ľudia_, _udskriv_, _de__tudo_, --, 
   {{0xec126022,0xc3eac012,0x7e1ba015,0xe276a00f}},	//   _बाबा__के_, _siete_, _disewaka, _injongo__yakhe_, 
   {{0x326c001d,0x14aae01a,0x00000000,0x00000000}},	//   _johor_, _ein__med_, --, --, 
   {{0xf22be00b,0x63960018,0x00000000,0x00000000}},	// [19b0] _css__mugihe_, _nossas_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xb491e00d,0x099e000f,0x583c000c,0x00000000}},	//   _el__el_, _akukhona_, _नई__जानकारी_, --, 
   {{0xf213e01b,0xf28d0016,0x5863c002,0x00000000}},	//   _kuthe_, _det__lenkes_, _долази_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x03ea600b,0x2ee04002,0x00000000,0x00000000}},	//   _bintu_, _подели__је_, --, --, 
   {{0x33e1c002,0x00000000,0x00000000,0x00000000}},	//   _републич, --, --, --, 
   {{0x12d8c04b,0x8213800f,0x29f5c012,0x00000000}},	//   _होती_, _kusho_, _prvý_, --, 
   {{0xdc7e601a,0xbd5a000e,0xe86a400c,0x4bec4003}},	//   _hausten_, _světě_, _अंतर्राष_मातृभाषा_, _རང__ལོ_, 
   {{0xedc58020,0x00000000,0x00000000,0x00000000}},	//   _ལུས__འབྲེལ_, --, --, --, 
   {{0x8293e006,0x670d800c,0x00000000,0x00000000}},	//   _ལེགས__ཤོམ_, _के__खतरा_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xfeb8e002,0x00000000,0x00000000,0x00000000}},	//   _ви_, --, --, --, 
   {{0xc3492015,0x00000000,0x00000000,0x00000000}},	//   _info__terbaru_, --, --, --, 
   {{0xf3eb201a,0xf1b5e002,0x00000000,0x00000000}},	//   _knytt_, _стандард, --, --, 
   {{0xc2f98035,0x977bc00f,0xcc12e003,0xe3e8200b}},	//   _kukhona_, _ngojehov, _དཀར__པོ_, _mu__minsi_, 
   {{0xa2d9a015,0x0edbe018,0x00000000,0x00000000}},	// [19c0] _tipe_, _conteúdo_, --, --, 
   {{0x1290c01d,0x0a8b6022,0x2ead6002,0xf201c025}},	//   _melayu_, _विश्व__में_, _коју__је_, _havia_, 
   {{0x17efc003,0x9b91e006,0xf4a6a012,0x00000000}},	//   _ཀྱི__སྔོན_, _ཞིནམ__ལས_, _zabudli__ste_, --, 
   {{0x248ea005,0xd212800b,0x00000000,0x00000000}},	//   _eg__kan_, _isaha_, --, --, 
   {{0xa1632002,0x00000000,0x00000000,0x00000000}},	//   _којима_, --, --, --, 
   {{0xca1e2002,0x00000000,0x00000000,0x00000000}},	//   _живи_, --, --, --, 
   {{0x52b82011,0xfceaa011,0xb4b36025,0x00000000}},	//   _de__lugo_, _non__existen_, _ser__um_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa248001d,0xa472e02a,0x497a2012,0x2200800b}},	//   _negara__lagi_, _som__ble_, _ďalší_, _inkiko_, 
   {{0xd3f9a032,0x00000000,0x00000000,0x00000000}},	//   _siqu_, --, --, --, 
   {{0xbf058002,0x00000000,0x00000000,0x00000000}},	//   _не__зна_, --, --, --, 
   {{0xddbaa00a,0x8480800b,0x6780400c,0x00000000}},	//   _आपत्तिजन, _kuri__uru_, _चाहे__उनका_, --, 
   {{0x3495600b,0x9ceb8003,0x00000000,0x00000000}},	//   _ni__nk_, _མཆོད__འབུལ_, --, --, 
   {{0x0e94e002,0x18e3a02a,0xef4e2002,0x6f452002}},	//   _јун__мај_, _begynner_, _политичк, _немачки__грчки_, 
   {{0x24950030,0xbf874024,0x82708003,0xa4600018}},	//   _pridruže_maj_, _mašine_, _དེ__མིན_, _não__vai_, 
   {{0x324de029,0xc470602a,0x00000000,0x00000000}},	//   _སྙན_, _seg__en_, --, --, 
   {{0xddfac006,0x83f9c00b,0x1c9da00c,0x00000000}},	// [19d0] _འཕྲོ_, _kivu_, _के__कइगो_, --, 
   {{0xf2cbc00a,0x672ec00c,0x00000000,0x00000000}},	//   _ब्लॉग__बनाइये_, _कवनो__भासा_, --, --, 
   {{0xdc854011,0xd496c00b,0x00000000,0x00000000}},	//   _informac_mantida_, _ubumwe__bw_, --, --, 
   {{0x6b80200e,0x00000000,0x00000000,0x00000000}},	//   _informac, --, --, --, 
   {{0x0a98800e,0x00000000,0x00000000,0x00000000}},	//   _luxusní_, --, --, --, 
   {{0xc971400e,0x4c842002,0x00000000,0x00000000}},	//   _řešení_, _турски_, --, --, 
   {{0xb316800b,0x00000000,0x00000000,0x00000000}},	//   _amaze_, --, --, --, 
   {{0x14972012,0xdb9c000a,0xdadca003,0x00000000}},	//   _ktoré__sú_, _के__कई_, _འཚོགས_, --, 
   {{0x127ec004,0xc2704031,0x14324012,0x00000000}},	//   _ngonje_, _bagi__kami_, _ak__máte_, --, 
   {{0x3cc4000a,0x926c4015,0xd3ea0008,0xa37f200f}},	//   _क्लिक__करें_, _nomor_, _os__teus_, _yamanga_, 
   {{0xe4a4c004,0x225e4006,0x425b200e,0x00000000}},	//   _ngubani__na_, _རྫོང__གཞི_, _styl_, --, 
   {{0x83f3c00f,0x45e7c006,0x24b0200b,0x62548003}},	//   _zobulili_, _དངུལ__རྒྱབ_, _bigaraga_ko_, _བཏུས__གསར_, 
   {{0x2de4e003,0x00000000,0x00000000,0x00000000}},	//   _བྱེད__སྟངས_, --, --, --, 
   {{0x12486004,0xd228a00b,0xc6f9e013,0x00000000}},	//   _ubomi_, _cya__kabiri_, _बढ़ा_, --, 
   {{0xc6f4a022,0x00000000,0x00000000,0x00000000}},	//   _में__सरकार_, --, --, --, 
   {{0x8a4ee013,0xb239800b,0xbc44400a,0x00000000}},	//   _एक__बार_, _buri__muri_, _गोरखपुर__चंदौली_, --, 
   {{0x6475c018,0x00000000,0x00000000,0x00000000}},	// [19e0] _jogos__de_, --, --, --, 
   {{0x0aa64022,0x00000000,0x00000000,0x00000000}},	//   _में__देश_, --, --, --, 
   {{0x226ca015,0xb0ec0002,0xc11de00e,0x00000000}},	//   _cocok_, _на__навигаци, _důležité_, --, 
   {{0x73790018,0x72d9c00b,0x00000000,0x00000000}},	//   _você__precisa_, _niwe_, --, --, 
   {{0x644c000c,0xf450001a,0xb6fce00f,0x5753800a}},	//   _साहित्य__अकादमी_, _utvide__han_, _emibhalw, _लिखकर__जीतिए_, 
   {{0xebdb0003,0x3214400c,0x00000000,0x00000000}},	//   _ཐོབ__ཐང_, _गइल__बाउर_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x34af6012,0x0aa36014,0x025fc003,0x00000000}},	//   _že__sa_, _बांग्लाद_में_, _མཐོང__རིས_, --, 
   {{0x1d1a4012,0xe3948015,0x09da4012,0x824de003}},	//   _ďalšie_, _sukses_, _ďalšia_, _སྙམ_, 
   {{0x82c92038,0x9ba32003,0x00000000,0x00000000}},	//   _para__unha_, _རྒྱ__མི_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x68dfa009,0x00000000,0x00000000,0x00000000}},	//   _pågælden, --, --, --, 
   {{0x9ab6a037,0xd2d9c018,0x22592003,0x00000000}},	//   _tu__pregunta_, _tive_, _ཟུར__མཆན_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6465c018,0x00000000,0x00000000,0x00000000}},	//   _recados__de_, --, --, --, 
   {{0xda56600a,0x00000000,0x00000000,0x00000000}},	//   _है__यदि_, --, --, --, 
   {{0x91e1401c,0x00000000,0x00000000,0x00000000}},	// [19f0] _हमारी_, --, --, --, 
   {{0x9ba14006,0xa1c70012,0xa4aaa01a,0x71d9600c}},	//   _སྐོར__ལས_, _hviezdič_recenzií_, _har__dei_, _दोसर_, 
   {{0x72fa0009,0x0ecc400c,0x00000000,0x00000000}},	//   _tilmeldt__indlæg_, _काफी__महत्वपूर, --, --, 
   {{0x926c000e,0x82d9a002,0x00000000,0x00000000}},	//   _mohou_, _uspeh_, --, --, 
   {{0x426c4025,0xa4910004,0xa50ca00f,0x19fa0018}},	//   _pelo_, _ke__loo_, _izithelo_, _jogadore, 
   {{0x8ab3602c,0x6dd10003,0x00000000,0x00000000}},	//   _ibikores, _སྐད__རིགས_, --, --, 
   {{0xec118022,0x92bc800f,0xe4744018,0x00000000}},	//   _आदि__के_, _uzizwa__kanjani_, _inserido_, --, 
   {{0xa28bc00a,0x00000000,0x00000000,0x00000000}},	//   _रहे__कॉमेंट_, --, --, --, 
   {{0x826c4012,0xd7610014,0x2e7d4002,0x00000000}},	//   _telo_, _में__सीधा_, _коме__је_, --, 
   {{0xcabc600c,0x33f9e031,0x126ac00c,0x00000000}},	//   _राजा__भोज_, _gitu_, _राष्ट्री_पर्व_, --, 
   {{0x023aa009,0x386a8006,0xe23d8011,0x2b9c6003}},	//   _høj_, _མཁར__འཕྲིན_, _unha__serie_, _དངུལ__སྔ_, 
   {{0xc29e0003,0x00000000,0x00000000,0x00000000}},	//   _བྱེད__པའི_, --, --, --, 
   {{0x82722019,0x39f34012,0x4225801a,0x00000000}},	//   _en__slik_, _spoločen, _merka_, --, 
   {{0x4290e00d,0x00000000,0x00000000,0x00000000}},	//   _haga_, --, --, --, 
   {{0xb2b4401a,0x7cbf200c,0x00000000,0x00000000}},	//   _til__dømes_, _अउर__फोटो_, --, --, 
   {{0xc26c4011,0x1b7a0003,0x00000000,0x00000000}},	//   _polos_, _རྒྱང__སྲིང_, --, --, 
   {{0xba1a4028,0xddf6c002,0x129a600f,0x00000000}},	// [1a00] _descuent, _грађана_, _ngaphezu__kwakho_, --, 
   {{0x8290e01a,0xa2a9e006,0x946b600b,0x00000000}},	//   _laga_, _སྣོད__འདི_, _ari__we_, --, 
   {{0x226c6012,0xebde200c,0x84086012,0x9a7a600f}},	//   _meno_, _संगोष्ठी__के_, _taliansk, _emihlang_yebandla_, 
   {{0xecb6a033,0xb307a010,0x9f80001a,0x00000000}},	//   _korisnik_nađi_, _nye__varer_, _seg__frå_, --, 
   {{0xb859801a,0xb448801f,0x1a72600c,0xea222002}},	//   _innanfor_, _lelaki__dan_, _कवनो__ठोस_, _српски__језик_, 
   {{0xb776400e,0x231fe018,0x8503400e,0x00000000}},	//   _zkušenos, _abaixo__este_, _naprosto_, --, 
   {{0xf9b60012,0x00000000,0x00000000,0x00000000}},	//   _predplat, --, --, --, 
   {{0xa291800f,0xabd4a003,0x00000000,0x00000000}},	//   _wayazi_, _གནས__བབ_, --, --, 
   {{0x1edb4002,0x00000000,0x00000000,0x00000000}},	//   _адреса__ел_, --, --, --, 
   {{0xc24da006,0x0befa006,0x7c122003,0x00000000}},	//   _འཐུ_, _གི__རབ_, _དཀའ__ངལ_, --, 
   {{0xfded200f,0x9cbe0002,0x00000000,0x00000000}},	//   _lona__wesifaza, _нашем_, --, --, 
   {{0x92a70016,0x2e232002,0x02b72002,0x00000000}},	//   _jobber_, _оставите__коментар_, _другом_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x425ac01b,0x13456045,0x33b48008,0x0a64e00a}},	//   _uzele_, _zvýrazni, _enciclop_libre_, _संबंधित__खोज_, 
   {{0x6f33200b,0x00000000,0x00000000,0x00000000}},	//   _ubufaran, --, --, --, 
   {{0xd2d9201c,0x82982003,0x8b20e00f,0x00000000}},	//   _मोदी_, _ཀྱི__ཐོག_, _izifundo__zebhayib, --, 
   {{0xfe6c600c,0x00000000,0x00000000,0x00000000}},	// [1a10] _ओह__कार्यक्र, --, --, --, 
   {{0x4225e02e,0x7b28c003,0x822f8002,0x7eac2028}},	//   _netko_, _གླེང_, _pre__sati_, _recomien, 
   {{0x99f3400e,0x9cef600c,0xe35ac002,0x00000000}},	//   _společen, _पऽ__कवनो_, _уторак_, --, 
   {{0x22e8a00f,0x4b0fc00c,0x00000000,0x00000000}},	//   _abaholi__benkolo_, _इलाका__डुमरांव_, --, --, 
   {{0xf4692009,0xcc59400a,0xb47b6018,0x00000000}},	//   _andre__der_, _के__पीछे_, _inserido__em_, --, 
   {{0x4266e006,0x9baf4009,0xca6ac012,0xd240800c}},	//   _ཞལ__འཛོམས_, _oversætt, _ak__nemáš_, _बा__जेकर_, 
   {{0xd30fc01d,0xba22c011,0x00000000,0x00000000}},	//   _carian__nama_, _que__tamén_, --, --, 
   {{0xc23aa009,0x025e0003,0x00000000,0x00000000}},	//   _tøj_, _ཕྱི__ཚེས_, --, --, 
   {{0xa213e00f,0x7278202a,0x50430002,0x00000000}},	//   _lutho_, _åpner_, _на__овај_, --, 
   {{0x6b8fe01c,0x4c74c037,0x998e0002,0x8bb0c00a}},	//   _थे_, _lenguaje__ofensivo_, _начин_, _लोगों__का_, 
   {{0x026c2012,0xabbf4003,0x625fe00e,0xd8340003}},	//   _rokov_, _ལེ__ཚན_, _heureka__mobilu_, _མིའི__སྒྲིག_, 
   {{0x22910004,0x00000000,0x00000000,0x00000000}},	//   _laza_, --, --, --, 
   {{0x825a800d,0x0b9c800a,0xd1d8a00a,0x00000000}},	//   _cual_, _की__है_, _होकर_, --, 
   {{0xe23a600e,0xea3d200a,0x00000000,0x00000000}},	//   _vyzkouše, _हटा_, --, --, 
   {{0x26f8a00a,0x72f1e011,0x5228c00a,0xf460c00f}},	//   _होगा_, _os__días_, _मार्च__फ़रवरी_, _ngiqinis_ngithi_, 
   {{0xb3a24015,0x8334e015,0x944fc00b,0xf3eae00f}},	//   _sampe_, _pukul__melalui_, _tariki__ya_, _ngithi_, 
   {{0x82910004,0xd2b52037,0x00000000,0x00000000}},	// [1a20] _baza_, _caracter_tiempo_, --, --, 
   {{0x5b86a011,0x8017000a,0x926b8003,0x00000000}},	//   _coñecer_, _दर्शाव_, _ནས__དུས_, --, 
   {{0x49ebc009,0x12e2000f,0x326c4045,0x3a33e00c}},	//   _undersøg, _ngenxa__yalokho_, _domov_, _जवन_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x1bf4e00c,0x00000000,0x00000000,0x00000000}},	//   _में__गो_, --, --, --, 
   {{0x449b201f,0x00000000,0x00000000,0x00000000}},	//   _dipapark, --, --, --, 
   {{0x8e6ea012,0x5b8d0014,0xc2932012,0x00000000}},	//   _určite_, _छल_, _neskôr_, --, 
   {{0x1ebdc00e,0x1bfc0006,0x00000000,0x00000000}},	//   _hodnocen, _མེ__མར_, --, --, 
   {{0x34208009,0xffc08009,0x425b001a,0x0bf8e00a}},	//   _hjælper_, _hjælpe_, _fjaler_, _ने__अमिताभ_, 
   {{0xc7324011,0x00000000,0x00000000,0x00000000}},	//   _de__inscrici, --, --, --, 
   {{0x7291203f,0x00000000,0x00000000,0x00000000}},	//   _baya_, --, --, --, 
   {{0xb26ca012,0xc2a6c01d,0xc7292002,0x7c0e6006}},	//   _lebo_, _nombor_, _добро_, _ཚུགས__ནི_, 
   {{0xc47dc02a,0x625a8018,0xd6962006,0x964d8008}},	//   _noen__av_, _qual_, _ཐོ__གསརཔ_, _oldid__categorí, 
   {{0xd26ca00e,0xa45ba002,0x00000000,0x00000000}},	//   _nebo_, _комунист, --, --, 
   {{0x03ea001d,0xbdaf6007,0x0bc3e013,0xa2a24011}},	//   _iaitu_, _ensiklop, _क्या__है_, _que__aínda_, 
   {{0x92910004,0x3f99200d,0x6212c00e,0xe47ac00e}},	//   _saza_, _los__usuarios_, _čeho_, _nebo__na_, 
   {{0x0bfc6006,0x646a6012,0x00000000,0x00000000}},	// [1a30] _རི__ཟམ_, _tým__že_, --, --, 
   {{0x66ac2012,0x2cc4c00e,0x1bd90003,0x00000000}},	//   _pôžičky_, _na__hlavní_, _ཞགས__ཀེ_, --, 
   {{0xe291203f,0x03ea400e,0x898aa00e,0x00000000}},	//   _yaya_, _filtr_, _sobě_, --, 
   {{0xd2910004,0xd394e01d,0xd2cae011,0xa297c003}},	//   _waza_, _kanser_, _poidan_, _ཚུལ__བོད_, 
   {{0x6afdc00b,0xe200c00e,0x00000000,0x00000000}},	//   _uhuru__kenyatta_, _velice_, --, --, 
   {{0xfbd6600a,0xd1a8e00c,0x00000000,0x00000000}},	//   _साथ__लगे_, _में__दरभंगा_, --, --, 
   {{0xa68d200e,0x00000000,0x00000000,0x00000000}},	//   _vlastnos_automati, --, --, --, 
   {{0x42f1201a,0xb1ffc002,0x8d17600e,0x00000000}},	//   _høgre_, _именом_, _dalším_, --, 
   {{0x826ca00f,0xd13aa00f,0x2caee00a,0x00000000}},	//   _yebo_, _yini__umphumel, _देखें__उपयोग_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa2a66003,0xd2d6800b,0x5c55e00a,0x1def800a}},	//   _རང__བཙན_, _ry__ibanga_, _की__सबसे_, _लखनऊ__देहरादून_, 
   {{0x227fe012,0x54c0401a,0x00000000,0x00000000}},	//   _zoznam_, _http__nn_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x1bf7000a,0xaf4be002,0x00000000,0x00000000}},	//   _में__एक_, _има__још_, --, --, 
   {{0xa3dfc009,0x00000000,0x00000000,0x00000000}},	//   _de__bedste_, --, --, --, 
   {{0xd709c002,0x00000000,0x00000000,0x00000000}},	//   _језици_, --, --, --, 
   {{0x03ea0015,0x5b9cc006,0x472fe00c,0x00000000}},	// [1a40] _yaitu_, _རོ__རྫོང_, _रहे__वाला_, --, 
   {{0x6394c010,0xc4918037,0x83242012,0x18b26008}},	//   _danske_, _posición__en_, _ak__chcete_, _de__solicitu, 
   {{0x0ddaa018,0xec00800c,0x00000000,0x00000000}},	//   _uma__quantida, _चोरन__के_, --, --, 
   {{0xc29c4003,0x9d5a2002,0xed00e00a,0x00000000}},	//   _ཞེས__པའི_, _томе_, _अन्तिम__परिवर्तन_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xf2970002,0x721c4035,0x4ed52002,0xb2e2400a}},	//   _nadji__info_, _okuhle_, _тог_, _तकनीक_, 
   {{0x04bd401a,0x67062022,0xb316800b,0x00000000}},	//   _noko__som_, _आर्थिक__विकास_, _amazu_, --, 
   {{0x4e27e006,0x52d82009,0xbbfa2003,0x00000000}},	//   _རྒྱལ__བརྒྱུད_, _anmeld_, _མི__ཕམ_, --, 
   {{0x8d3fa002,0xf3f8802b,0x64310006,0x5b812006}},	//   _децембар__новембар_, _inkuru_, _འབད__རྒྱལ_, _མཛོད__རྫོང_, 
   {{0x7b8ca029,0xab74200a,0x00000000,0x00000000}},	//   _དུ_, _की__कहानी_, --, --, 
   {{0xc201c012,0xe27c200f,0x6fde0018,0x1b23a002}},	//   _robiť_, _kakhulu__lapho_, _primeiro__comentar_, _није__успела_, 
   {{0x1ef12002,0xdc49000a,0x00000000,0x00000000}},	//   _остали_, _बनने_, --, --, 
   {{0xa27e800b,0x64bfc011,0x00000000,0x00000000}},	//   _bwana_, _xoves__de_, --, --, 
   {{0xc2334011,0x232aa010,0xb3eb8027,0x00000000}},	//   _hai__máis_, _og__mere_, _torty_, --, 
   {{0x42d8c00a,0x00000000,0x00000000,0x00000000}},	//   _होगी_, --, --, --, 
   {{0x53cec015,0x9bdfe006,0xb258a00b,0x00000000}},	//   _trovit_, _ཤུལ__ལས_, _wo__muri_, --, 
   {{0xa2626003,0xb0d30002,0x00000000,0x00000000}},	// [1a50] _དང__དགའ_, _глас_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa31f8011,0x8c34800c,0x00000000,0x00000000}},	//   _de__axudas_, _में__आके_, --, --, 
   {{0x99caa020,0x44760011,0xa2924003,0x7813800c}},	//   _ལུའི_, _notifica_dos_, _རེད__བོད_, _साइबर__सुरक्षा_, 
   {{0xe201e015,0xebd3600c,0x22a7600c,0x00000000}},	//   _arti_, _हमरा__के_, _तक__पहुंचल_, --, 
   {{0x64b7202f,0x00000000,0x00000000,0x00000000}},	//   _clientes__de_, --, --, --, 
   {{0x2e10e016,0x0492a01a,0x936f000c,0x00000000}},	//   _adressea, _må__ein_, _अप्रिय__हितैषी_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x02b18006,0x4df2e005,0x02c5a006,0x3736200e}},	//   _ཚུ__གིས_, _studenta, _དུག__མདོ_, _písemnéh, 
   {{0xfb7a2011,0x2a0ce002,0x00000000,0x00000000}},	//   _presenza_, _слали__коментар, --, --, 
   {{0x3473400b,0x38a84020,0x00000000,0x00000000}},	//   _ushakire__hagufi_, _དགའ__སྐྱིད_, --, --, 
   {{0x92b80038,0xea964009,0xe1d3a00f,0x00000000}},	//   _de__vigo_, _ejendoms, _ezwini__likankul, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2326e00e,0x54bca00d,0x00000000,0x00000000}},	//   _soubory_, _la__versión_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x0f31e007,0x923b0012,0x860c800c,0x84982018}},	//   _seterusn, _máj_, _सुखदा_, _um__dia_, 
   {{0x22a68028,0x62c1c028,0x668a4009,0x2ddf0003}},	// [1a60] _este__foro_, _en__línea_, _pludseli, _དབྱངས__སེམས_, 
   {{0x6442002c,0xec60e015,0xae71e00c,0x00000000}},	//   _iri_, _suka__komentar, _कुल्ह_, --, 
   {{0x6fd98018,0xc4b02011,0x4f822002,0x00000000}},	//   _em__até_, _non__hai_, _увек_, --, 
   {{0x4b7cc011,0x0c0b8006,0x00000000,0x00000000}},	//   _recoñece, _ནུག__ལུ_, --, --, 
   {{0x04916027,0x00000000,0x00000000,0x00000000}},	//   _by__som_, --, --, --, 
   {{0xaaa8200a,0xd719e027,0x00000000,0x00000000}},	//   _आपका__शहर_, _komuniká, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xe3ce0009,0xe2990006,0x93eaa01d,0x00000000}},	//   _blive_, _པའི__མངའ_, _diubah__buat_, --, 
   {{0x2c1e002f,0x332aa009,0x0363a00f,0x00000000}},	//   _simples_, _og__vores_, _abanye__bangase_, --, 
   {{0xd0fb200f,0x204fc002,0x6ae9c002,0x00000000}},	//   _umphumel, _односно_, _полиција_, --, 
   {{0x9bb1601e,0xa723800c,0x00000000,0x00000000}},	//   _za__političk, _अनार्य__जाति_, --, --, 
   {{0x473d401a,0x34ab600f,0x00000000,0x00000000}},	//   _namngjev, _ujehova__uye_, --, --, 
   {{0xb3f3e019,0xc3faa002,0x6cf0600a,0x00000000}},	//   _med__våre_, _истражив, _ऊना__कुल्लू_, --, 
   {{0x0bc6e00a,0xfbf8c014,0x00000000,0x00000000}},	//   _होता__है_, _गांव__से_, --, --, 
   {{0xc38b0011,0x0bcb8006,0xe155c00f,0x00000000}},	//   _alta__acceder_, _ཐུང__ལུ_, _lwadlalw_abonakal, --, 
   {{0x127ee00f,0x977be00a,0x00000000,0x00000000}},	//   _isintu_, _लिए__झूठा_, --, --, 
   {{0xc2852003,0x8cb1200c,0x00000000,0x00000000}},	// [1a70] _གཞན__གྱི_, _बा__अतने_, --, --, 
   {{0x42920015,0x8c3f400b,0x24dcc002,0x00000000}},	//   _sepatu_, _reba__ibiganir, _мултимед_датотека_, --, 
   {{0xc4906019,0xe4572012,0x4198a002,0x00000000}},	//   _ha__en_, _vykonáva__ich_, _преговор, --, 
   {{0xe24da020,0x8298a003,0xb4c44002,0x00000000}},	//   _འཐབ_, _པའི__ཐོག_, _то__време_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xdd84a009,0x126c401d,0x9344a009,0x71b5a012}},	//   _oprettet_, _dilog_, _oprette_, _najčítan, 
   {{0x4b60200c,0x894e200c,0x00000000,0x00000000}},	//   _लिखनी_, _उनका__वंशजन_, --, --, 
   {{0x6236e01d,0x53806028,0x4312800f,0x41b9c00c}},	//   _tinjau_, _cerrar_, _umninima_onke_, _बोलल_, 
   {{0x534b800d,0xccb1e008,0x62b52009,0x2bdf4003}},	//   _la__imagen_, _de__centros_, _succes_, _མའི__ལམ_, 
   {{0xc3c10011,0xc46be00e,0x34ab400b,0x00000000}},	//   _queixas__aviso_, _jak__je_, _igihugu__ca_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xe213e00f,0xd4420012,0x44aa6009,0xeeb72009}},	//   _futhi_, _pri_, _del__af_, _værelser_, 
   {{0x5497e00b,0x225ea003,0x2b0f000c,0x00000000}},	//   _bitanduk, _ཕྱེད__ཀའི_, _आनंद__पांडेय_, --, 
   {{0x1394c011,0x227f600e,0x00000000,0x00000000}},	//   _lles_, _zadní_, --, --, 
   {{0xd7382003,0x8386001a,0x74bf200b,0x00000000}},	//   _ཁྲོད_, _deira_, _umupatir_mu_, --, 
   {{0x14420012,0xfa3de013,0x00000000,0x00000000}},	//   _tri_, _सिर_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [1a80] --, --, --, --, 
   {{0xf3b3400c,0x00000000,0x00000000,0x00000000}},	//   _उपाध्याय__भोजपुरी_, --, --, --, 
   {{0xc2ca600b,0x00000000,0x00000000,0x00000000}},	//   _bandi_, --, --, --, 
   {{0xbbe62006,0xb2b4601d,0x8a97400a,0x00000000}},	//   _སེར__ཚུ_, _punca_, _और__फिर_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xe827e038,0xc40d800a,0xa26bc00a,0xebfb400c}},	//   _centros__educativ, _इंदौर__इलाहाबाद_, _उस__कॉमेंट_, _राजपूतन__के_, 
   {{0x72fd800f,0xb46ec002,0xc3402005,0xc4998011}},	//   _isithomb_ekhasini_, _време_, _det__frie_, _galicia__hai_, 
   {{0xeba9a00c,0x2bbf400c,0x587b8003,0x00000000}},	//   _कऽ__के_, _भोज__पऽ_, _མང__སྤྱི_, --, 
   {{0xa48f6027,0x0c54800c,0x00000000,0x00000000}},	//   _aj__ja_, _शराब__पीये_, --, --, 
   {{0x24464033,0x7b948006,0x773bc00a,0x00000000}},	//   _cijena__kn_, _བསྒྲགས__གདོང_, _अहमदाबाद__आगरा_, --, 
   {{0x326ce018,0xedb5a006,0xae774014,0x00000000}},	//   _jogos_, _བརྟན__འབྲེལ_, _के__रिश्_, --, 
   {{0x73960018,0x2291a02a,0x7498e00b,0x00000000}},	//   _possui_, _utvalg_, _ya__mu_, --, 
   {{0xe48f6027,0xabdb6021,0x00000000,0x00000000}},	//   _aj__na_, _བཀོད__དེ_, --, --, 
   {{0x70202011,0x8fd8c00e,0x546b600e,0x532e000b}},	//   _votar__comentar_, _návštěvn, _aby__se_, _mu__turere_, 
   {{0xd4adc00f,0xd212e018,0x00000000,0x00000000}},	//   _khona__ke_, _nenhum_, --, --, 
   {{0x546be00e,0x7ba2c00f,0x00000000,0x00000000}},	//   _jak__se_, _lapho__ekhuluma_, --, --, 
   {{0x62984003,0x00000000,0x00000000,0x00000000}},	// [1a90] _གཙོ__ངོས_, --, --, --, 
   {{0x4eb60009,0x00000000,0x00000000,0x00000000}},	//   _kæreste_, --, --, --, 
   {{0xebc3c022,0xc2258015,0x64c2c00d,0xb3abe01a}},	//   _डॉलर__के_, _meski_, _ciudad__de_, _dei__andre_, 
   {{0xb642200b,0xc29e400f,0x828bc01a,0x8a3c2002}},	//   _ashigiki, _ukuphila__kwakhe_, _han__fekk_, _аутор_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xefe6c002,0xcc69000b,0x00000000,0x00000000}},	//   _против_, _umuriro_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xb4702002,0x00000000,0x00000000,0x00000000}},	//   _pre__dan_, --, --, --, 
   {{0x24742016,0xfb9be003,0xe4098018,0x13e7201a}},	//   _oss__sms_, _ཡིན__པར_, _leia__mais_, _på__desse_, 
   {{0x2a63400a,0x126ce011,0x8ea7e009,0xb4c3a00a}},	//   _में__विज्ञापन_, _xogos_, _oversigt_, _मास्टरमा_क्याहै_, 
   {{0x14426012,0xf2afe003,0x726d000f,0xf3a0000e}},	//   _čo_, _རང__ཉིད_, _lezo_, _sdělení_, 
   {{0x57fda012,0x12c60012,0x00000000,0x00000000}},	//   _spôsobom_, _článok__sekcii_, --, --, 
   {{0x998aa00e,0x026d0011,0x64d3000f,0x00000000}},	//   _době_, _mozos_, _indlela__okubukek, --, 
   {{0xaa3d4013,0xe2266019,0x348f6012,0x67c9c034}},	//   _लिए_, _bruker_, _ak__sa_, _kystdepa_fornying, 
   {{0xeba8a00c,0x0eafc01a,0x994b600a,0x00000000}},	//   _धन__के_, _opplevin, _इलाहाबाद__जौनपुर_, --, 
   {{0x22918015,0xa26ce015,0x00ebe018,0xacf0c003}},	// [1aa0] _para_, _bogor_, _lançamen, _འབོད__སྐུལ_, 
   {{0xdacf2020,0x447b8011,0x046be00e,0xfee04002}},	//   _བཙུག_, _historia__da_, _ano__ne_, _што__би_, 
   {{0x44986027,0x4fe9c00a,0x00000000,0x00000000}},	//   _to__nie_, _फैजाबाद_, --, --, 
   {{0x2bf00022,0x2c57c00a,0x9291800b,0xba46e002}},	//   _ना__हो_, _के__लिये_, _wara_, _заштите_, 
   {{0xf5eee00e,0x00000000,0x00000000,0x00000000}},	//   _rozpětí__konstruk, --, --, --, 
   {{0x0313a00f,0x4714a018,0x1c48000c,0x00000000}},	//   _kwaze__kwaba_, _manutenç, _रहले_, --, 
   {{0x246b802a,0x00000000,0x00000000,0x00000000}},	//   _jeg__vet_, --, --, --, 
   {{0xbb8d0006,0xab99c003,0x00000000,0x00000000}},	//   _ཚུ_, _དོན__དེ_, --, --, 
   {{0x19f8600e,0x0ec44011,0xf2a60009,0x1480601a}},	//   _recenzí_, _teñen_, _mere__info_, _vere__med_, 
   {{0x32ca0005,0x32502002,0x02a16003,0x00000000}},	//   _php__title_, _рекао_, _འདིའི__ཚེས_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xe45fa012,0x66b42003,0x00000000,0x00000000}},	//   _ponúkame__na_, _ལྟ__གྲུབ_, --, --, 
   {{0x37382029,0x3291a01d,0xb44e0031,0x829e6002}},	//   _ཁྲིད_, _bapa_, _syarat__dan_, _лица_, 
   {{0x54a06037,0xb6d9e00f,0xbdc7c002,0x00000000}},	//   _escribe__las_, _ukwazisw, _превод_, --, 
   {{0xc332601a,0x52ddc00e,0x00000000,0x00000000}},	//   _heile__landet_, _předpokl_doba_, --, --, 
   {{0xdc5de018,0x8bdc000a,0x7eef4002,0x00000000}},	//   _contém_, _लगाया_, _побољшањ_веб_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [1ab0] --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x4a6c600c,0x00000000,0x00000000,0x00000000}},	//   _कइल__गइल_, --, --, --, 
   {{0xacad000b,0x00000000,0x00000000,0x00000000}},	//   _muri__afurika_, --, --, --, 
   {{0xd5988004,0x00000000,0x00000000,0x00000000}},	//   _zobukumk, --, --, --, 
   {{0xc31ba009,0x00000000,0x00000000,0x00000000}},	//   _og__hvad_, --, --, --, 
   {{0xc3ea602b,0x09f5a00e,0x9455600b,0x00000000}},	//   _bantu_, _nevím_, _nshuro__ya_, --, 
   {{0x7a57c002,0xc5c6c00a,0xadf46002,0x8cec2002}},	//   _динара_, _टाइल__सेहत_, _где__су_, _епископ_, 
   {{0x23ec0008,0x1e47e00e,0x79a30012,0x00000000}},	//   _editar__editar_, _zpravoda, _obľúbené_, --, 
   {{0x65220002,0xb2ca6009,0x00000000,0x00000000}},	//   _овом_, _fandt_, --, --, 
   {{0x80af2012,0x7d9e602b,0x56f8200c,0x00000000}},	//   _sa__nachádza_, _yiyemeje_, _रउरा_, --, 
   {{0xa982600e,0x4aca600c,0xb1c7600a,0x0d25a003}},	//   _možnost_, _डुमरांव_, _बदलाव__फ़ाइल_, _པའི__ཕྱིར_, 
   {{0x1291a02b,0x3dd88003,0x4ef0e002,0xdbbac003}},	//   _papa_, _སྨན__རྩིས_, _км_, _དེ__ཙམ_, 
   {{0x03dc600c,0x00000000,0x00000000,0x00000000}},	//   _अकादमी__मध्यप्रद, --, --, --, 
   {{0x1450e040,0xc28aa003,0x00000000,0x00000000}},	//   _poruka__od_, _གནས__བབས_, --, --, 
   {{0xac620009,0x00000000,0x00000000,0x00000000}},	//   _desuden_, --, --, --, 
   {{0xae47e012,0x6499600e,0x00000000,0x00000000}},	// [1ac0] _spravoda, _ať__už_, --, --, 
   {{0x66904006,0x0c48000a,0x8a514003,0x00000000}},	//   _ཡིག__སྡེབ_, _वहीं_, _ཁོང__ཚོའི_, --, 
   {{0xfc56600a,0x7cd6a00f,0x08660002,0x00000000}},	//   _खबरें_, _indodana__yomuntu_, _ваш__блог_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xbc906013,0xa224c00e,0x60892002,0xfb328003}},	//   _वालों_, _řekl_, _већина_, _གཟེངས_, 
   {{0x005ea008,0x00000000,0x00000000,0x00000000}},	//   _formació_profesio, --, --, --, 
   {{0xf491e01a,0xb4b46025,0x5df04003,0xc391a018}},	//   _at__ho_, _por__um_, _བྱ__འཕྲོད_, _para__página_, 
   {{0x018ca00f,0x3ed56002,0x00000000,0x00000000}},	//   _abantu__bakankul, _мој_, --, --, 
   {{0xcbeea003,0xda588012,0xed988012,0x3c988012}},	//   _མང__པོ_, _recenzia_, _recenzie_, _recenziu_, 
   {{0xe235801f,0xed9c0012,0x62ad600b,0xa329801d}},	//   _pukul__pagi_, _odpoveda, _umva__imvo_, _ramai__yang_, 
   {{0x148fa005,0xc27fc011,0x82a82002,0x8a4e400c}},	//   _eg__har_, _moito__máis_, _обавезно_, _के__पता_, 
   {{0xebbf8003,0xab8d2003,0x8eb7e00e,0x42506002}},	//   _ལོ__ཟླ_, _མུ_, _zajímavo, _деца_, 
   {{0xc3940018,0x82e5c00f,0x12c3800e,0x00000000}},	//   _dois_, _emazweni__amaningi_, _psaní__komentář, --, 
   {{0x7bb90020,0xec54800f,0x00000000,0x00000000}},	//   _ལམ__རང_, _kweqinis, --, --, 
   {{0xdcbe6002,0x00000000,0x00000000,0x00000000}},	//   _даје_, --, --, --, 
   {{0x9b8d4029,0x8334e039,0x73a26009,0x00000000}},	//   _བུ_, _baru__melalui_, _krop_, --, 
   {{0xa876400f,0xa252c003,0x00000000,0x00000000}},	// [1ad0] _njengomu, _ཡོད__བོད_, --, --, 
   {{0x72fae01d,0x6290c039,0xbfc5800a,0x00000000}},	//   _lebih__juta_, _pelaku_, _पाठक__सर्कल_, --, 
   {{0xc3566031,0x02918018,0x00000000,0x00000000}},	//   _sebesar_, _bancário_, --, --, 
   {{0x22246004,0x053fc00a,0x6df1e003,0x00000000}},	//   _ngoko_, _नोएडा__प्रतापगढ, _གི__རིགས_, --, 
   {{0xebf04014,0xa258a003,0x00000000,0x00000000}},	//   _फ़िल्म__के_, _འབྱུང__བོད_, --, --, 
   {{0x3224c00f,0x8981e009,0x2d0f000a,0x180cc002}},	//   _ngeke_, _opskrift, _इस__प्रकार_, _слике_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xf46c0018,0x3c48000a,0x2379c018,0x8a4b400a}},	//   _com__seu_, _रहते_, _produto__também_, _की__तरफ_, 
   {{0xebad0003,0x5e71a002,0x00000000,0x00000000}},	//   _དག__གི_, _снимци__здраво_, --, --, 
   {{0xc708200c,0x9bad0003,0x246ec02c,0xddc1a009}},	//   _के__राजा_, _དང__མི_, _kandi__ko_, _svar__oprettet_, 
   {{0xfc27a00d,0x02722003,0x00000000,0x00000000}},	//   _artículo_, _ཡང__ཡོད_, --, --, 
   {{0x64b7e038,0x12cf4037,0x00000000,0x00000000}},	//   _preto__de_, _de__archivo_, --, --, 
   {{0x92c7c00c,0x00000000,0x00000000,0x00000000}},	//   _के__लागू_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x593a000f,0x4295800b,0x00000000,0x00000000}},	//   _elilodwa_, _ababyeyi_, --, --, 
   {{0xe291c039,0x7681200a,0xe5802002,0x00000000}},	//   _jawa_, _औज़ार_, _знам_, --, 
   {{0x1cb1000a,0x5236c00b,0xa38c400b,0x00000000}},	// [1ae0] _करें__उसके_, _wanjye_, _munani__somalia_, --, 
   {{0xac60a00a,0x620ec00b,0x1526000c,0x70dcc00c}},	//   _ही__नहीं_, _ibihumbi_, _में__पिछड़_, _घोषणा__कइलस_, 
   {{0x7491e02a,0x026d8011,0xd3948025,0x00000000}},	//   _er__noe_, _foron_, _quase_, --, 
   {{0x6417a006,0x00000000,0x00000000,0x00000000}},	//   _ལས__འཕྲལ_, --, --, --, 
   {{0x9b3de011,0x12c50009,0x00000000,0x00000000}},	//   _enerxía_, _kender__blandt_, --, --, 
   {{0xf48fa01a,0x00000000,0x00000000,0x00000000}},	//   _eg__var_, --, --, --, 
   {{0x7202601d,0xe2760012,0xa2984003,0x00000000}},	//   _tarikh_, _starostl, _ཀྱི__བོད_, --, 
   {{0x0442600e,0x00000000,0x00000000,0x00000000}},	//   _pro_, --, --, --, 
   {{0xfc11a00a,0x00000000,0x00000000,0x00000000}},	//   _मदद__से_, --, --, --, 
   {{0xc26de033,0xe4494004,0xb3af6019,0x546be00e}},	//   _diskutan_broj_, _nabani__na_, _hadde__vært_, _kde__se_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xf2e8c018,0x93e5c002,0x00000000,0x00000000}},	//   _quem__somos_, _увредљив, --, --, 
   {{0x2ed52002,0x1314e018,0x8291c018,0x00000000}},	//   _под_, _negócio_, _tava_, --, 
   {{0x6c4b4011,0x00000000,0x00000000,0x00000000}},	//   _existen__comentar, --, --, --, 
   {{0x447ba030,0x4dea4003,0x7013c037,0x23cec00d}},	//   _komentar_re_, _བཟོ__བཅོས_, _gusta__comentar_, _lleva_, 
   {{0x64b86018,0x00000000,0x00000000,0x00000000}},	//   _muito__de_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [1af0] --, --, --, --, 
   {{0x7ad68002,0xcf3d2002,0x00000000,0x00000000}},	//   _јануар_, _дневника__има_, --, --, 
   {{0x52d8c011,0x125ac028,0x00000000,0x00000000}},	//   _galego_, _piel_, --, --, 
   {{0x0ee34018,0x16da000f,0x00000000,0x00000000}},	//   _em__destaque_, _amaphuth, --, --, 
   {{0x87490012,0xd6e0e00c,0xe4b1800b,0x00000000}},	//   _budúcnos, _के__कोशिश_, _ukine__ibi_, --, 
   {{0x7dcc6002,0x00000000,0x00000000,0x00000000}},	//   _су__му_, --, --, --, 
   {{0xa2b22003,0x22990003,0x00000000,0x00000000}},	//   _པོ__ཞིག_, _གསར__ཤོག_, --, --, 
   {{0x327ee00f,0xb224803f,0xad85000a,0x00000000}},	//   _ezingu_, _ngako_, _नैनीताल__पिथौरागढ, --, 
   {{0xd4968012,0x00000000,0x00000000,0x00000000}},	//   _sk__ako_, --, --, --, 
   {{0x53ba800c,0x00000000,0x00000000,0x00000000}},	//   _जा__सकेला_, --, --, --, 
   {{0xbf664006,0x7a7e0012,0x02b20006,0x00000000}},	//   _གར__འབྲུག_, _cieľom_, _པོ__གིས_, --, 
   {{0x14b36009,0xe847e018,0x00000000,0x00000000}},	//   _okt__kl_, _cartões_, --, --, 
   {{0x2ed4e002,0x0f612003,0x00000000,0x00000000}},	//   _до_, _དྲུག__འགྱུར_, --, --, 
   {{0x12d8a00e,0x3bd2e00d,0x4f50600e,0x7f362002}},	//   _akce_, _verdader, _měsíce_, _заиста_, 
   {{0xc2da6015,0x34634016,0x5578400e,0xd73ec00c}},	//   _karena_, _innlegg__kp_, _poslední, _बा__बाकिर_, 
   {{0x4a56a00a,0x00000000,0x00000000,0x00000000}},	//   _अन्य__खेल_, --, --, --, 
   {{0xcef12002,0x00000000,0x00000000,0x00000000}},	// [1b00] _има_, --, --, --, 
   {{0xdf3b8037,0x3a43200c,0x00000000,0x00000000}},	//   _nombre__segurida, _के__जनम_, --, --, 
   {{0xe41a2015,0xa3cec00e,0xa2382003,0xc467e01a}},	//   _mendapat_daftar_, _sleva_, _དཔྱད__རྩོམ_, _dei__nye_, 
   {{0xf245000f,0x7cedc00f,0x00000000,0x00000000}},	//   _izinceku__zakhe_, _ngezwi__elikhulu_, --, --, 
   {{0x3ec7000d,0x56f9e022,0x00000000,0x00000000}},	//   _nosotros_, _मोटा_, --, --, 
   {{0x086e000d,0x00000000,0x00000000,0x00000000}},	//   _trabajar_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x72fce011,0x220c6009,0x724d8003,0x00000000}},	//   _lingua_, _præsenta_skriv_, _འཇུ_, --, 
   {{0xc2c86012,0x994b800e,0x00000000,0x00000000}},	//   _rozmery_, _nokia__mobilní_, --, --, 
   {{0xa26de045,0x1de5e003,0x8292400b,0x00000000}},	//   _potom_, _པའི__བྱིས_, _satani_, --, 
   {{0x8c08202b,0x8ec4600d,0x5db3e00b,0xbbff800a}},	//   _ibiganir, _baños_, _bidafite_, _स्तर__पर_, 
   {{0x94428025,0xc2de000a,0x00000000,0x00000000}},	//   _pra_, _किसी_, --, --, 
   {{0x1c98c003,0x00000000,0x00000000,0x00000000}},	//   _གྲོལ_, --, --, --, 
   {{0x44aae009,0x00000000,0x00000000,0x00000000}},	//   _den__af_, --, --, --, 
   {{0xe2598006,0x424a8037,0xebed0003,0x00000000}},	//   _ཁྲི__མངའ_, _agosto__julio_, _ཐང__གི_, --, 
   {{0x3470e012,0xc9ffe037,0xc470a011,0x7bd1c003}},	//   _tak__sa_, _búsqueda, _que__hai_, _བཙན__དྲ_, 
   {{0x6dd78003,0x3a4da002,0x00000000,0x00000000}},	// [1b10] _བོད__རིགས_, _навигаци_мени_, --, --, 
   {{0x6752c00f,0x00000000,0x00000000,0x00000000}},	//   _izinyang, --, --, --, 
   {{0x0bbb400a,0x00000000,0x00000000,0x00000000}},	//   _हुआ__था_, --, --, --, 
   {{0x5776c006,0xda632022,0xd27dc003,0x00000000}},	//   _གསང__སྲིད_, _फेस्टिवल_, _བཏང__བའི_, --, 
   {{0x646c6025,0x92c7e003,0x2604800c,0x00000000}},	//   _com__de_, _ཚོགས__གཙོ_, _के__प्रतिहार, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x16fec013,0xd26d8011,0x00000000,0x00000000}},	//   _किया_, _nosos_, --, --, 
   {{0x55fec040,0xa2562003,0xc2964003,0xa27a400a}},	//   _korišćen, _ཀྱིས__བོད_, _ངོས__ཟིན_, _कोई__कॉमेंट_, 
   {{0x34bb8009,0x42b84003,0x00000000,0x00000000}},	//   _klik__her_, _གོ__ལའི_, --, --, 
   {{0x326d800f,0x00000000,0x00000000,0x00000000}},	//   _leso_, --, --, --, 
   {{0x63b7e009,0x237a601d,0xe301800b,0x0d6d2002}},	//   _sådan__får_, _kawalan_, _barareng_ukwa_, _итд_, 
   {{0xe453600f,0x729dc003,0x00000000,0x00000000}},	//   _ukuthi__le_, _མགོན__འཇུ_, --, --, 
   {{0xc0222011,0xa470a011,0x00000000,0x00000000}},	//   _administ_electrón, _que__fai_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x21e1e002,0xc4b8e011,0x00000000,0x00000000}},	//   _права__задржана_, _subscrib_ás_, --, --, 
   {{0x8341400e,0x00000000,0x00000000,0x00000000}},	// [1b20] _stejně_, --, --, --, 
   {{0x6cafe018,0xe442a00b,0x00000000,0x00000000}},	//   _no__cartão_, _drc_, --, --, 
   {{0x0472e00d,0x62990003,0x00000000,0x00000000}},	//   _que__yo_, _གསར__ཤོས_, --, --, 
   {{0xb232803c,0x00000000,0x00000000,0x00000000}},	//   _februara__godine_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x526e0012,0x1a0b000e,0x13f8e012,0x787d0018}},	//   _šport_, _vložit_, _ponuku_, _prévio_, 
   {{0x13868012,0xb27ee02a,0xab93e008,0x44964008}},	//   _ktoré_, _finner_, _dividido_, _século__xx_, 
   {{0x226da040,0xfb24801d,0x00000000,0x00000000}},	//   _lepo_, _dilarang__linkedin_, --, --, 
   {{0xc473c009,0x5b8e000f,0x00000000,0x00000000}},	//   _endnu__en_, _beqiniso_, --, --, 
   {{0xdb9a4003,0x2469e009,0x00000000,0x00000000}},	//   _དོན__མེ_, _dig__og_, --, --, 
   {{0x64786011,0x0c07e00a,0x13574013,0xd44f200b}},	//   _xunta__de_, _लगता__है_, _ज्ञानकोष_, _bushya__bwa_, 
   {{0x0bb4e00a,0x00000000,0x00000000,0x00000000}},	//   _नहीं__था_, --, --, --, 
   {{0x729f6028,0x00000000,0x00000000,0x00000000}},	//   _tarjeta_, --, --, --, 
   {{0x720a000a,0x00000000,0x00000000,0x00000000}},	//   _सलेम__सागर_, --, --, --, 
   {{0xa26da030,0xa7b6c002,0xfe8a0011,0x8b4c6006}},	//   _depo_, _сва__права_, _en__liña_, _རྫོང__བཞེངས_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xe2260015,0x2242e020,0x0a0b000e,0x00000000}},	// [1b30] _kaskus_, _ནངས_, _uložit_, --, 
   {{0xac71a019,0x737a6039,0x1355e015,0x12afe00f}},	//   _startet_, _jawaban_, _sekedar_, _engcono__kakhulu_, 
   {{0xb493600d,0x827b600c,0x00000000,0x00000000}},	//   _es__el_, _के__रक्षा_, --, --, 
   {{0xab8e000f,0x13960009,0x00000000,0x00000000}},	//   _weqiniso_, _masser_, --, --, 
   {{0xa7604002,0x930b8018,0x00000000,0x00000000}},	//   _ауторств_делити_, _um__pouco_, --, --, 
   {{0x60b2600e,0x7984a00b,0x669c400c,0x00000000}},	//   _práva__vyhrazen, _abakobwa_, _ओर__धेयान_, --, 
   {{0x230e0007,0x0242e006,0x00000000,0x00000000}},	//   _apabila_, _ཐངས_, --, --, 
   {{0xc9c64025,0x0875e011,0xcc622014,0x0462e00e}},	//   _apresent, _persoais_, _के__अवशेष_, _telefony__filtr_, 
   {{0x133f600e,0x00000000,0x00000000,0x00000000}},	//   _nemají_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x0347a00f,0x2bec2002,0x00000000,0x00000000}},	//   _ukuba__kube_, _на__којој_, --, --, 
   {{0xe2888020,0x00000000,0x00000000,0x00000000}},	//   _མཛད__གནང_, --, --, --, 
   {{0xac5a6011,0x2d9e600e,0x6b95a00a,0xaf3dc002}},	//   _pode__subscrib, _zkuste__nejoblíb, _की__भी_, _све__то_, 
   {{0xa058000a,0xab9d000a,0x128ce003,0x00000000}},	//   _वापस_, _साल__की_, _ཆུང__ཆུང_, --, 
   {{0xa3b8801e,0x72728003,0x00000000,0x00000000}},	//   _stranica__natrag_, _ཟླ__མིག_, --, --, 
   {{0xe290c01d,0xb9d02002,0x7163a002,0x00000000}},	// [1b40] _jumaat_, _вези_, _на__свету_, --, 
   {{0x6442002b,0xd30d401d,0xf28d800b,0xd366601a}},	//   _isi_, _pesakit_, _muhezo__vatikani_, _ikkje__lenger_, 
   {{0x32d3e00b,0xcfc0a00e,0x00000000,0x00000000}},	//   _ya__buenos_, _obrázek_, --, --, 
   {{0xce292002,0x00000000,0x00000000,0x00000000}},	//   _вам_, --, --, --, 
   {{0x7442000e,0xc2d5a00b,0xd262200b,0x3ba4600a}},	//   _jsi_, _ry__imana_, _muri__irak_, _का__यह_, 
   {{0x6301e015,0x55a5a00a,0x00000000,0x00000000}},	//   _berarti_, _वेबसाइटो, --, --, 
   {{0x73afc019,0x62ca601f,0x2ed56002,0x00000000}},	//   _håper_, _pandu_, _јој_, --, 
   {{0xc3d9c019,0x4b9dc003,0xdc6fe00b,0x4cb8c00e}},	//   _du__bør_, _བྱུང__ལོ_, _itorero_, _odpovědí_, 
   {{0x9298a006,0x24124015,0x02b42015,0xd5bd800d}},	//   _པའི__ཐོན_, _bagi__simpan_, _jakarta__pusat_, _el__servicio_, 
   {{0xfba9a00c,0x00000000,0x00000000,0x00000000}},	//   _एह__से_, --, --, --, 
   {{0xa298c003,0x00000000,0x00000000,0x00000000}},	//   _པའི__བོད_, --, --, --, 
   {{0x1c77000b,0x475ce00b,0xeed5800e,0x25b6a00b}},	//   _dioseze_, _mukiring, _muže_, _hakoresh_amategek, 
   {{0xdb92600e,0x1c1d0012,0x00000000,0x00000000}},	//   _srovnání_, _štandard, --, --, 
   {{0x9f5c8008,0x00000000,0x00000000,0x00000000}},	//   _de__contrata, --, --, --, 
   {{0x24420004,0xf283c00f,0x843e800e,0x251c000a}},	//   _esi_, _yilowo__nalowo_, _které__jsou_, _धमाल__विडियो_, 
   {{0x204ba03e,0x6d106006,0x530e000b,0xb259a00b}},	//   _सामग्री_, _བརྒྱ__འཁོར_, _bugufi__kandi_, _yo__muri_, 
   {{0x03c38018,0x00000000,0x00000000,0x00000000}},	// [1b50] _passe__mouse_, --, --, --, 
   {{0x8f424011,0xc2568018,0x00000000,0x00000000}},	//   _clandest_kamykaze_, _um__único_, --, --, 
   {{0xd2d98009,0xa36a0039,0xa226601a,0x65a7800a}},	//   _opret_, _iklan__yang_, _brukar_, _मिर्जापु_रायबरेली_, 
   {{0xb442c012,0x00000000,0x00000000,0x00000000}},	//   _pre_, --, --, --, 
   {{0xb95a400f,0xf291e012,0x6259e003,0x2c4d600c}},	//   _eqiniswe, _dizajn_, _ཡིད__ཆེས_, _खातिर__एगो_, 
   {{0xe470e00f,0x7236c00b,0x00000000,0x00000000}},	//   _yeka__ukuthi_, _yanjye_, --, --, 
   {{0xd7e72006,0x52cb802f,0x2ae3a003,0x00000000}},	//   _གནས__དགོན_, _maioria_, _གསེར__མདོག_, --, 
   {{0x80b46003,0xaa42e018,0x00000000,0x00000000}},	//   _སློབ__གྲྭ_, _em__preço_, --, --, 
   {{0xc236c01d,0x76c7a00a,0xc315600a,0x00000000}},	//   _imej_, _हैदराबाद__हिसार_, _चम्बा__बिलासपुर_, --, 
   {{0x82246004,0xd659e011,0xc3450012,0x00000000}},	//   _ngoku_, _orixinal_, _všetci_, --, 
   {{0x52ebc009,0x5444c01f,0x00000000,0x00000000}},	//   _kvinder_, _berjangk, --, --, 
   {{0x73948011,0x5ac1a00a,0xb24da003,0xf2900025}},	//   _coas_, _विचार__मंच_, _འབའ_, _acha_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x42cb400e,0xe2b46025,0xec11600c,0xd949800a}},	//   _hledat_, _troca_, _जिला__के_, _लाइसेंस_, 
   {{0x1c5f402e,0x84b1a01e,0xd46be00e,0x36e14002}},	//   _obitelj_, _kur__ana_, _každý__den_, _под__називом_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xf03de018,0xca9b000a,0x00000000,0x00000000}},	// [1b60] _anúncio_, _में__कोई_, --, --, 
   {{0x3dd7e006,0x7d56800e,0x00000000,0x00000000}},	//   _མཐར__འཁྱོལ_, _pořád_, --, --, 
   {{0x2399c00e,0x00000000,0x00000000,0x00000000}},	//   _véčka__výsuvné_, --, --, --, 
   {{0x37074018,0x00000000,0x00000000,0x00000000}},	//   _instalaç, --, --, --, 
   {{0xc48a400e,0x00000000,0x00000000,0x00000000}},	//   _které__je_, --, --, --, 
   {{0x24b3200b,0xd24da003,0x00000000,0x00000000}},	//   _karidina_ba_, _འབར_, --, --, 
   {{0xee296002,0x00000000,0x00000000,0x00000000}},	//   _бар_, --, --, --, 
   {{0x743d800f,0x5598000c,0x00000000,0x00000000}},	//   _igama__lesigrek, _लउकत_, --, --, 
   {{0x63ce8030,0x5753a003,0x531e000c,0x00000000}},	//   _slavo_, _གླེང__བྱེད_, _काम__वाली_, --, 
   {{0xc49a8009,0x00000000,0x00000000,0x00000000}},	//   _søgetjen_en_, --, --, --, 
   {{0x626fa01d,0x0bcc8006,0x00000000,0x00000000}},	//   _malaysia__tinjau_, _ཐོག__ལུ_, --, --, 
   {{0x8f706018,0x00000000,0x00000000,0x00000000}},	//   _peças_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa254000a,0x0ab70014,0x670c800a,0x00000000}},	//   _कॉमेंट_, _आखिर__में_, _शहर__आपका_, --, 
   {{0xdc49e04b,0x2382c00a,0x6495e012,0x00000000}},	//   _पैसे_, _लाइफस्टा, _sa__aj_, --, 
   {{0x426de027,0x00000000,0x00000000,0x00000000}},	//   _leto_, --, --, --, 
   {{0x646ce038,0x911d802e,0x7c51c00a,0x00000000}},	// [1b70] _foi__de_, _na__sadržaj_, _बातें_, --, 
   {{0x34b9a030,0x0b07200e,0x00000000,0x00000000}},	//   _sarajevo__vrh_, _kuchyňsk, --, --, 
   {{0x47154018,0x00000000,0x00000000,0x00000000}},	//   _seguranç, --, --, --, 
   {{0x0a80200a,0x227f600e,0xe2910003,0xa3648003}},	//   _बाजार__में_, _jedné_, _དཔྱད__ཞིབ_, _སློབ__གྲྭའི_, 
   {{0x873a2021,0xa3324039,0x321c600b,0x00000000}},	//   _སྣོད_, _informas_yang_, _rishya_, --, 
   {{0xb479601a,0x00000000,0x00000000,0x00000000}},	//   _gjer__at_, --, --, --, 
   {{0x447e6018,0xae69401d,0x4c75e012,0x00000000}},	//   _atenção_, _oleh__pengguna, _napriek_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x0a5de022,0x8a3ee00a,0xa2512006,0xd4f96012}},	//   _कार्यक्र_में_, _फिर_, _བརྡ__དོན_, _peňazí_, 
   {{0x548a400e,0x00000000,0x00000000,0x00000000}},	//   _které__se_, --, --, --, 
   {{0x66d24014,0xebc4400c,0x00000000,0x00000000}},	//   _जिकिर_, _माटी__के_, --, --, 
   {{0xa298c003,0x00000000,0x00000000,0x00000000}},	//   _གྱི__བོད_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x8a70800a,0x8cee0002,0x00000000,0x00000000}},	//   _कैसे__टाइप_, _хрватске_, --, --, 
   {{0xc25ac009,0x7bf70003,0xcce6400c,0x00000000}},	//   _mellem_, _གི__རང_, _कबो__दिल्ली_, --, 
   {{0x1c53602e,0x472f400c,0x00000000,0x00000000}},	// [1b80] _sustava_, _रहल__बाड़े_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x9f9b000a,0x1c9f2003,0xae8cc00c,0x00000000}},	//   _करें__प्रिन्ट_, _བཀོལ_, _ओह__कुल्ह_, --, 
   {{0xf77ee00a,0x62574003,0xf2648003,0x00000000}},	//   _से__जुड़े_, _དུས__དྲན_, _ཡུལ__ཤུལ_, --, 
   {{0xcba06021,0x925ac01a,0x00000000,0x00000000}},	//   _རྒྱལ__པོ_, _spela_, --, --, 
   {{0xecc82029,0x00000000,0x00000000,0x00000000}},	//   _ཁྱེར_, --, --, --, 
   {{0xebad8003,0x33430011,0x00000000,0x00000000}},	//   _ནག__གི_, _dereito_, --, --, 
   {{0x53962015,0x0cd3e002,0x00000000,0x00000000}},	//   _simpan__properti_, _косову_, --, --, 
   {{0xd317e00f,0x7c124003,0x00000000,0x00000000}},	//   _umuzi_, _དཀར__དྲ_, --, --, 
   {{0xdf10c024,0x329f4006,0x00000000,0x00000000}},	//   _predsedn, _རིམ__རྟག_, --, --, 
   {{0xa2930006,0xd4712018,0x3225800e,0x00000000}},	//   _ནིའི__དོན_, _uma__das_, _desky_, --, 
   {{0x9b400002,0x00000000,0x00000000,0x00000000}},	//   _енглески_, --, --, --, 
   {{0x16c44004,0xd28e4035,0x00000000,0x00000000}},	//   _likathix, _naphezu_, --, --, 
   {{0x12f12022,0xc3948045,0xa3b6e01a,0xc704a003}},	//   _जरुरत_, _čase_, _som__gjer_, _གློག__བརྙན_, 
   {{0xc5590002,0xc253a003,0x00000000,0x00000000}},	//   _октобар__септемба, _གསུམ__གྱི_, --, --, 
   {{0x9bad8003,0x00000000,0x00000000,0x00000000}},	//   _ནང__མི_, --, --, --, 
   {{0x4ead8015,0x976de002,0x58314002,0xfbe26003}},	// [1b90] _lintasme_, _прегледа_, _или__притисни, _བྱས__པར_, 
   {{0x547dc038,0x23f8c00d,0x9cf6600c,0x628d800b}},	//   _foto__no_, _saludo_, _में__कवनो_, _imikino_, 
   {{0x603da00d,0x00000000,0x00000000,0x00000000}},	//   _direccio, --, --, --, 
   {{0x22f9200e,0x1da1e003,0xe25ae00e,0x08644002}},	//   _odebrat__vše_, _དགེ__བཤེས_, _pohled_, _универзи, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x4451200e,0x6b4c000e,0x00000000,0x00000000}},	//   _případně_, _vytvořen, --, --, 
   {{0x442f000f,0x92d2e011,0xa26dc00e,0xb33c200e}},	//   _main__menu_, _ás__todo_, _hodin__hodin_, _nejvyšší__ceny_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xb2590006,0xf567c002,0x00000000,0x00000000}},	//   _འབྲ__དཀར_, _постани__преводил, --, --, 
   {{0xf3a2e00f,0xc4b6a01c,0x00000000,0x00000000}},	//   _isiphi_, _सप्ताह_, --, --, 
   {{0x03eb801d,0xece9c002,0x6b9ee006,0x00000000}},	//   _parti_, _података_, _སེམས__ཁར_, --, 
   {{0xc47e0011,0x38874003,0x00000000,0x00000000}},	//   _pero__non_, _ཐང__དབྱིག_, --, --, 
   {{0x6a83200b,0xc6be4012,0x00000000,0x00000000}},	//   _kenyatta_, _súťaže_, --, --, 
   {{0x3dea6006,0x7356601d,0xec0ae00c,0xd5f4a012}},	//   _སྟོན__དམངས_, _sebenar_, _भोपाल__के_, _zamestná, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xb4668009,0xe314c015,0x9471e00b,0x00000000}},	//   _tilmeld__dig_, _inputan__mengenai_, _mu__kiganiro_, --, 
   {{0x0f24000e,0xc2c8e003,0x00000000,0x00000000}},	// [1ba0] _ovšem_, _བརྙན__དེབ_, --, --, 
   {{0xc2c9001d,0x3b284003,0x83d9601d,0x00000000}},	//   _dengan__terma_, _མྱོང_, _terhadap__sebarang_, --, 
   {{0xc387000e,0x6fa4e045,0xdf696014,0xbc6b600c}},	//   _které_, _používan, _में__अंग्रेजी_, _चेम्बर_, 
   {{0x0492a05d,0x2bb9e003,0x22d3a037,0x00000000}},	//   _es__por_, _ལས__མང_, _del__foro_, --, 
   {{0xc2820006,0xec0ca00a,0x8bde8003,0x55b3c002}},	//   _བསྐྱོད__འབད_, _पहले__के_, _ལྟའི__ཆར_, _структур, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x4e74e002,0x00000000,0x00000000,0x00000000}},	//   _се__од_, --, --, --, 
   {{0x43946019,0x83966011,0xaaa1400a,0x3f64a012}},	//   _tross_, _persoa_, _आपके__शहर_, _čítať_, 
   {{0xbbbda022,0xa342800b,0x00000000,0x00000000}},	//   _अंत__तक_, _ku__ngufu_, --, --, 
   {{0xd3b54002,0xd269800b,0x7150000f,0x00000000}},	//   _налог__одјавите_, _igihe__yari_, _wasendul, --, 
   {{0x99f3a01f,0x64ad4011,0xac5d800e,0xc48ac012}},	//   _daripada_, _xaneiro__de_, _alespoň_, _ktorá__je_, 
   {{0x64730038,0xc6dd400a,0x1a77000a,0x1e3d0002}},	//   _emprende_de_, _बारिश_, _चौपाल__हाल_, _се__као_, 
   {{0xe4b6c02a,0xb2a7200e,0x00000000,0x00000000}},	//   _sider__er_, _kdyby_, --, --, 
   {{0x94426008,0x2f4ca00a,0x00000000,0x00000000}},	//   _iso_, _हिसार__क्रिकेट_, --, --, 
   {{0x5b7b0006,0x3c0da00c,0x00000000,0x00000000}},	//   _ཨིན__རྫོང_, _मिलत__बा_, --, --, 
   {{0x52bac003,0x00000000,0x00000000,0x00000000}},	//   _མི__ཤེས_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [1bb0] --, --, --, --, 
   {{0x52af400a,0x75c9a00c,0x00000000,0x00000000}},	//   _जाएँ_, _कि__नवरतन_, --, --, 
   {{0xeee6801a,0xe386000b,0x00000000,0x00000000}},	//   _seg__sjølv_, _igira_, --, --, 
   {{0xebe7800a,0xc49bc038,0x00000000,0x00000000}},	//   _मनोरंजन__बॉलीवुड_, _galicia__en_, --, --, 
   {{0x930c0011,0x00000000,0x00000000,0x00000000}},	//   _un__pouco_, --, --, --, 
   {{0x83966018,0x51dc0011,0xb273200f,0x00000000}},	//   _pessoa_, _aviso__atendémo, _abantu__bazo_, --, 
   {{0x73eb8015,0x6c61600a,0x944ee00e,0xebe6400c}},	//   _kartu_, _को__भेजें_, _souvisej, _नौसेना__के_, 
   {{0xe731e00c,0x4934200c,0x00000000,0x00000000}},	//   _साइबर__हमला_, _एही__भोजपुर_, --, --, 
   {{0xd98bc00e,0x00000000,0x00000000,0x00000000}},	//   _nově_, --, --, --, 
   {{0x42420004,0x6ee30002,0xb5d2a00f,0x10172018}},	//   _ukumkani_, _оно_, _ngesikha_esifanay, _suas__dúvidas_, 
   {{0x0d54800a,0x00000000,0x00000000,0x00000000}},	//   _कासगंज_, --, --, --, 
   {{0x7bdcc003,0x327ec01a,0x9c6a600f,0x6386000b}},	//   _བོད__རང_, _kven_, _komuntu_, _agira_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x04a1200b,0x9a68a00c,0x00000000,0x00000000}},	//   _gahunda__yo_, _अउर__चीन_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x1345a00a,0x9d0e600c,0x00000000,0x00000000}},	//   _दिक्चालन__सूची_, _चाहे__कवनो_, --, --, 
   {{0xcc6a600f,0x73878028,0xab80c003,0x00000000}},	// [1bc0] _nomuntu_, _perro_, _དངོས__བྱུང_, --, 
   {{0x592c0002,0x00000000,0x00000000,0x00000000}},	//   _пољски__португал, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x82da602a,0x3ba4e00a,0xa63b400e,0x7c9e800b}},	//   _årene_, _कि__यह_, _státní_, _ibirimwo__burundi_, 
   {{0x0e932002,0x00000000,0x00000000,0x00000000}},	//   _захтеви__за_, --, --, --, 
   {{0xd24da021,0x13a38012,0xa493e02a,0x0e3ce002}},	//   _འབག_, _topovať__zvýrazni, _og__ble_, _се__за_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xcfb50018,0xe867c002,0x12d90025,0x00000000}},	//   _início_, _држава_, _cabelo_, --, 
   {{0x36bb402c,0x32a6800f,0x00000000,0x00000000}},	//   _abarwany, _umthetho__kamose_, --, --, 
   {{0xf62c0018,0x1ce8a003,0x00000000,0x00000000}},	//   _condiçõe, _རྒྱའི__སྐོར_, --, --, 
   {{0x3492e004,0xf4908018,0x91ef400c,0x4249400e}},	//   _ke__lo_, _comentár_seu_, _के__उतार_, _pojmů_, 
   {{0x7c6a600f,0x00000000,0x00000000,0x00000000}},	//   _yomuntu_, --, --, --, 
   {{0x4260a012,0x83bba002,0x00000000,0x00000000}},	//   _sledovať__nahlásiť_, _констант, --, --, 
   {{0x232c2009,0x5911400f,0x39832002,0x00000000}},	//   _se__mere_, _isimo__sengqond, _почетна_, --, 
   {{0xf387801a,0xf37b000c,0x64380003,0x8b884003}},	//   _berre_, _भइल__भोजपुरी_, _བོད__རྒྱལ_, _ཡས_, 
   {{0x733aa019,0x00000000,0x00000000,0x00000000}},	//   _du__kjenner_, --, --, --, 
   {{0x93fa600b,0x3db24018,0x00000000,0x00000000}},	// [1bd0] _garuka_, _escreveu_, --, --, 
   {{0xc05fe022,0x00000000,0x00000000,0x00000000}},	//   _उदास_, --, --, --, 
   {{0x2e496006,0x2bdaa006,0x32c3000f,0x00000000}},	//   _མཐུད__འགྱོ_, _མེད__གེ_, _kusaba__khona_, --, 
   {{0xb3f40019,0x801a6040,0x00000000,0x00000000}},	//   _har__vært_, _vojvodin, --, --, 
   {{0x52b46012,0x00000000,0x00000000,0x00000000}},	//   _troch_, --, --, --, 
   {{0xfefd0002,0x00000000,0x00000000,0x00000000}},	//   _управо_, --, --, --, 
   {{0x0494201a,0x72d54009,0x24012012,0x6dc9e00a}},	//   _på__ein_, _fået_, _tomto__fóre_, _बनिए_, 
   {{0x42496012,0x82d54009,0xc2930006,0x00000000}},	//   _najmä_, _gået_, _མཐུད__ཞུན_, --, 
   {{0xb250a00b,0x00000000,0x00000000,0x00000000}},	//   _na__gari_, --, --, --, 
   {{0x6b6e2003,0x64b2a00b,0x00000000,0x00000000}},	//   _རིག__གཞུང_, _kwezi__kwa_, --, --, 
   {{0xd2da6028,0x52568012,0x1c6a600f,0x00000000}},	//   _pareja_, _júla_, _somuntu_, --, 
   {{0xd0d88003,0x6de7c002,0x00000000,0x00000000}},	//   _རིག__བཀྲ_, _заборави_сте_, --, --, 
   {{0x228f400b,0xdb99400e,0x4afb2012,0x00000000}},	//   _bbc__icyo_, _požadavk, _zverejne, --, 
   {{0x649fa018,0x8254c00e,0x00000000,0x00000000}},	//   _cartão__de_, _měla_, --, --, 
   {{0xec70200a,0xf497e025,0x00000000,0x00000000}},	//   _महीने__पहले_, _relação_, --, --, 
   {{0xc26ca025,0x00000000,0x00000000,0x00000000}},	//   _ficou_, --, --, --, 
   {{0xf4268011,0x54b90011,0xe5688002,0x00000000}},	// [1be0] _unha__conta_, _como__pdf_, _македонс, --, 
   {{0xe6e90006,0x00000000,0x00000000,0x00000000}},	//   _འཚོལ__བཏུབ_, --, --, --, 
   {{0x92c1c011,0xcf21c011,0xa2b32003,0x00000000}},	//   _mellora_, _mellorar_, _མོ__ཞིག_, --, 
   {{0xebcb6022,0x1b2a8003,0x83e66011,0x00000000}},	//   _सरकार__के_, _རླུང_, _de__réxime_, --, 
   {{0x422a200e,0x00000000,0x00000000,0x00000000}},	//   _přihlási, --, --, --, 
   {{0xa31e001d,0x4f186002,0x00000000,0x00000000}},	//   _sesiapa__yang_, _да__ми_, --, --, 
   {{0x321c600b,0x00000000,0x00000000,0x00000000}},	//   _bishya_, --, --, --, 
   {{0x39c9e00b,0xee764002,0x82518003,0x00000000}},	//   _ishobora_, _су__да_, _ནམས__ཕུན_, --, 
   {{0x32eba02a,0x12c6400d,0xf4ac8009,0x3527000a}},	//   _utenfor_, _incluye_, _har__set_, _अजमेर__अमृतसर_, 
   {{0x3c8ac012,0xf27a600b,0x00000000,0x00000000}},	//   _príspevk, _vatikani_, --, --, 
   {{0xcf536020,0x5bd1a00c,0x00000000,0x00000000}},	//   _སྐད__སྒྱུར_, _आंदोलन__डॉ_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x348f0012,0xda3c200a,0x09d6200b,0x00000000}},	//   _páči__sa_, _एंड_, _interine, --, 
   {{0x7c8ac012,0xa4ad201a,0x482ec002,0x00000000}},	//   _príspevo, _men__dei_, _србин_, --, 
   {{0xa38a8018,0x04d9600c,0x8cfee00a,0x00000000}},	//   _fórum_, _ईद__मुबारक_, _फ़ाइल__अपलोड_, --, 
   {{0xeee6400a,0x00000000,0x00000000,0x00000000}},	//   _मास्टरमा, --, --, --, 
   {{0x646d6008,0xc2a80003,0x23eb6025,0x00000000}},	// [1bf0] _lei__de_, _འཕྲིན__ཡིག_, _quatro_, --, 
   {{0xe887a009,0x00000000,0x00000000,0x00000000}},	//   _chokolad, --, --, --, 
   {{0x2db84003,0xceace002,0x00000000,0x00000000}},	//   _དེ__རྗེས_, _користит, --, --, 
   {{0x22e7a011,0x00000000,0x00000000,0x00000000}},	//   _acceder__para_, --, --, --, 
   {{0xeca1600a,0x00000000,0x00000000,0x00000000}},	//   _से__पहले_, --, --, --, 
   {{0x929c8011,0xc4a5a037,0x92a58003,0x8248600e}},	//   _rúa_, _mi__producto_, _མདོ__སྨད_, _veřejnos, 
   {{0xa29c8011,0x1c674019,0x902b6002,0xcb4f6003}},	//   _súa_, _opptatt_, _из__википеди, _དཀའ__རྙོག_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6461c00d,0x8981e01a,0xfc4e6018,0x00000000}},	//   _más__de_, _vilkåra_, _busca__avançada_, --, 
   {{0xee9d0002,0xd2a7801d,0xaa42c00c,0x00000000}},	//   _ако_, _herba_, _के__कहर_, --, 
   {{0xa2f4e01d,0xd097e002,0x00000000,0x00000000}},	//   _melalui__mudah_, _времена_, --, --, 
   {{0x147bc02e,0xb29c8011,0x2cdea00f,0xec7e4018}},	//   _komentar__od_, _túa_, _izikhulu_, _adesivo_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x32a6000f,0xfb8a6003,0x00000000,0x00000000}},	//   _ngibe_, _བོད__ལྗོངས_, --, --, 
   {{0xf9c9e00b,0x00000000,0x00000000,0x00000000}},	//   _ushobora_, --, --, --, 
   {{0xcf01a012,0x1be18003,0x00000000,0x00000000}},	//   _hodnoten_hviezdič, _འདི__ནས_, --, --, 
  
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [1c00] --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xf2964039,0x00000000,0x00000000,0x00000000}},	//   _ini__semoga_, --, --, --, 
   {{0x6254c00e,0x2bc1a00a,0xccc32012,0x00000000}},	//   _mělo_, _लाइव__हो_, _sk__doprava_, --, 
   {{0xfaeb801d,0x3289400f,0x00000000,0x00000000}},	//   _sokongan_, _endabeni_, --, --, 
   {{0x02fae00f,0x874ec002,0x00000000,0x00000000}},	//   _kodwa__ingabe_, _цркви_, --, --, 
   {{0x0b9e800a,0x72ff000f,0x04978002,0xd2b78002}},	//   _गई__है_, _izithomb_ekhasini_, _је__било_, _је__била_, 
   {{0x6490c018,0xa2b7a012,0x00000000,0x00000000}},	//   _comentár_de_, _tovar__odobrať_, --, --, 
   {{0xd9f4e012,0xb292400b,0xa2040012,0x9eb62002}},	//   _minút_, _ubwami_, _požiadav, _система_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x22c5a016,0x1b8fe00c,0x00000000,0x00000000}},	//   _reglene_, _सभ_, --, --, 
   {{0xee3e8002,0x00000000,0x00000000,0x00000000}},	//   _време__да_, --, --, --, 
   {{0x1ed2600a,0x0aa6600c,0xaa95600c,0x00000000}},	//   _द्वारा__सॉर्ट_, _टक्कर__में_, _बा__अउर_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6045800e,0x00000000,0x00000000,0x00000000}},	//   _vyhrazen, --, --, --, 
   {{0x6341600b,0x6248c01a,0x5bb62003,0x57f94002}},	//   _barenga_, _sommar_, _དེ__ཨེ_, _притисни, 
   {{0x03f4002e,0x8256000d,0x00000000,0x00000000}},	// [1c10] _sustav_, _sólo_, --, --, 
   {{0x926f8021,0x56832014,0x00000000,0x00000000}},	//   _ལས__དུས_, _लाचार_, --, --, 
   {{0xf439e009,0x0bc1000a,0x00000000,0x00000000}},	//   _er__lidt_, _मंगलवार__को_, --, --, 
   {{0x39b96002,0x00000000,0x00000000,0x00000000}},	//   _материја, --, --, --, 
   {{0xb261e003,0x39e36002,0x12a64002,0x00000000}},	//   _རྒྱུས__ཀྱི_, _оне__који_, _резултат_, --, 
   {{0x9dbd200b,0x00000000,0x00000000,0x00000000}},	//   _gushyira, --, --, --, 
   {{0xf251e003,0xbe03e012,0x00000000,0x00000000}},	//   _གི__ལྡུམ_, _keďže_, --, --, 
   {{0x1ba90003,0x02946006,0xc48c6009,0x3212a018}},	//   _རྗེས__སུ_, _འབད__ཡོད_, _af__dem_, _manhã_, 
   {{0xfb9d6003,0x00000000,0x00000000,0x00000000}},	//   _ཡོད__པར_, --, --, --, 
   {{0x0f1b6012,0x07fc0002,0x00000000,0x00000000}},	//   _odporúča, _блог_, --, --, 
   {{0xcc44000f,0x9aac0002,0x00000000,0x00000000}},	//   _ngemva__kwalokho_, _своје__адресе_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x4443a00e,0x3431200c,0xc79cc00b,0x00000000}},	//   _srp_, _में__प्रत्यक्, _umva__kugirang, --, 
   {{0x32cfc004,0x4443e017,0x721d200f,0x00000000}},	//   _zobukumk_ziya_, _čt_, _naleso__sikhathi_, --, 
   {{0x26228045,0x738c0002,0x2eaaa002,0x00000000}},	//   _organizá, _куће_, _лозинку__је_, --, 
   {{0x4fe0000e,0x00000000,0x00000000,0x00000000}},	//   _kvůli_, --, --, --, 
   {{0xeb9b0003,0x6e0ca00e,0x00000000,0x00000000}},	// [1c20] _ནམས__ཚེ_, _vlastně_, --, --, 
   {{0x3778e00a,0x00000000,0x00000000,0x00000000}},	//   _सामग्री__क्रियेटि, --, --, --, 
   {{0xc27f6004,0x00000000,0x00000000,0x00000000}},	//   _okanye_, --, --, --, 
   {{0xd442c002,0x7c48e00a,0x00000000,0x00000000}},	//   _rsd_, _हमने_, --, --, 
   {{0xae436022,0x225ac01e,0xe468c009,0xa368a01d}},	//   _बांग्लाद, _sellem_, _hjælp__til_, _percuma__sebagai_, 
   {{0xd2ad402e,0x0b16c03c,0xce55a03c,0x8cc8c03a}},	//   _objavlje_prije_, _sarajevs, _islamske_, _གྱུར_, 
   {{0x0442c00b,0x134e000f,0x00000000,0x00000000}},	//   _ese_, _eziyishu_nambili_, --, --, 
   {{0x81e1c00a,0x122b000b,0x1e4d0002,0x00000000}},	//   _दूसरे_, _ukomeye_, _шта__нам_, --, 
   {{0x54a3e01d,0xd3d86012,0x00000000,0x00000000}},	//   _bersetuj, _heureka__pridať_, --, --, 
   {{0x0de9e003,0x102a000d,0xe82c0012,0x0dce8002}},	//   _བྱེད__དགོས_, _del__país_, _osobných_, _одељење_, 
   {{0x67b14021,0x4a3cc011,0x00000000,0x00000000}},	//   _ཁྲི__འཛིན_, _na__actualid, --, --, 
   {{0xa455e02e,0x2e846002,0xf4ace01a,0x8e45c00b}},	//   _poruku__za_, _рекао__је_, _har__me_, _mugaraga, 
   {{0x31fda00e,0x00000000,0x00000000,0x00000000}},	//   _vyhledáv, --, --, --, 
   {{0xbab18002,0x00000000,0x00000000,0x00000000}},	//   _области_, --, --, --, 
   {{0xc0894037,0xb301600a,0x6c91c00a,0x00000000}},	//   _términos__condicio, _से__यहाँ_, _बालों_, --, 
   {{0x473be003,0x00000000,0x00000000,0x00000000}},	//   _ཐུབ__བསྟན_, --, --, --, 
   {{0xd4536005,0x4cc8000e,0x0730400a,0x00000000}},	// [1c30] _alt__godt_, _změny_, _राज्य__उत्तर_, --, 
   {{0x5bb7603c,0xec49800a,0x6e45c00b,0x00000000}},	//   _pridruže, _पहले_, _kugaraga, --, 
   {{0xc3e4c005,0x0387e01a,0x0d2d800e,0x6f244012}},	//   _kl__tekst_, _betre_, _napište_, _práca_, 
   {{0x9442e00b,0x0bc4600d,0xd5666009,0x00000000}},	//   _msf_, _la__publicac, _europæis, --, 
   {{0xfbb84006,0xd4946009,0xab9b6003,0x4278c003}},	//   _ནི__དང_, _kr__alm_, _ཡིན__ནམ_, _ཏཱ__ལའི_, 
   {{0xebd2a003,0x00000000,0x00000000,0x00000000}},	//   _ཞིག__གི_, --, --, --, 
   {{0x9c898033,0x64686011,0x00000000,0x00000000}},	//   _broj__postova_, _xestión__de_, --, --, 
   {{0x0292601d,0xbf54a00b,0x64a06012,0x00000000}},	//   _tetamu_, _kugwanir_ubutunga, _sa__už_, --, 
   {{0x5d1c000e,0xe5ce400f,0x00000000,0x00000000}},	//   _nakoupit_, _ukwesaba__unkulunk, --, --, 
   {{0xeaa90002,0x00000000,0x00000000,0x00000000}},	//   _за__превођењ, --, --, --, 
   {{0x84b14012,0x00000000,0x00000000,0x00000000}},	//   _bazar__sk_, --, --, --, 
   {{0xa273a027,0xc2996003,0x00000000,0x00000000}},	//   _zakázané_, _མཛོད__ཟིན_, --, --, 
   {{0xd4420004,0xa3868012,0xfd09800c,0x52786025}},	//   _aph_, _ktorú_, _महुआ_, _alunos_, 
   {{0x6bee0002,0x72f12009,0x9e924037,0x1005e00e}},	//   _тако_, _bøger_, _otras__pregunta, _rozpětí__pohotovo, 
   {{0x6e2d2002,0x24a5200b,0x00000000,0x00000000}},	//   _крај_, _bivugwa__ko_, --, --, 
   {{0xb4748018,0xbd2a800f,0xfaa2a00c,0x4e7fc002}},	//   _publicad_em_, _abafundi__bakajesu_, _नइखे__भइल_, _адресе__ће_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [1c40] --, --, --, --, 
   {{0xb2a6801b,0xa2b38003,0x526c0003,0x2ee7e002}},	//   _ngaba_, _སུ__བོད_, _རྒྱུས__འཛམ_, _заштићен_је_, 
   {{0x9243e003,0xd3eac012,0xebbd4014,0x00000000}},	//   _གངས_, _azet_, _सत्र__के_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xb46fa018,0x00000000,0x00000000,0x00000000}},	//   _criar__uma_, --, --, --, 
   {{0x898ee002,0x00000000,0x00000000,0x00000000}},	//   _нови__захтев_, --, --, --, 
   {{0xebab600a,0x5a4a200e,0x00000000,0x00000000}},	//   _कि__वे_, _to__není_, --, --, 
   {{0x2493600b,0x00000000,0x00000000,0x00000000}},	//   _na__ko_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x9f072018,0x00000000,0x00000000,0x00000000}},	//   _os__direitos_, --, --, --, 
   {{0x3493600d,0x942b0039,0x00000000,0x00000000}},	//   _es__lo_, _rumah__baru_, --, --, 
   {{0xe5c8c01b,0xa443c00b,0x00000000,0x00000000}},	//   _intaneth, _frw_, --, --, 
   {{0x82f12009,0x5493601a,0x00000000,0x00000000}},	//   _søger_, _er__no_, --, --, 
   {{0xd48ca009,0xc31fc024,0x62608003,0x00000000}},	//   _af__den_, _crvene__zvezde_, _རྩོམ__གཞས_, --, 
   {{0x73eb8009,0x84bc0027,0x9a4a800a,0x00000000}},	//   _marts_, _mojasvad_sk_, _की__हुई_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x1be54014,0x33f6400f,0x00000000,0x00000000}},	// [1c50] _से__कर_, _inkosi__udavide_, --, --, 
   {{0x147fa01e,0x27efc00c,0x8e39a002,0x19db4002}},	//   _historij, _मुख्यमंत_शिवराज_, _забрањен, _корупциј, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x9e1ba01d,0xb3aea00e,0xc2744011,0x00000000}},	//   _atau__kerosaka, _jak__vybrat_, _artigo__novo_, --, 
   {{0xb4b4e028,0xb97ac012,0xbea42014,0xa63de00f}},	//   _ver__el_, _ďalších_, _यमंत्री_, _kuyiqini, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x62d92014,0x42bde017,0x2834a00f,0x12204002}},	//   _बानी_, _prodám_, _ngomqond, _словачки__словенач, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7b0ba003,0x00000000,0x00000000,0x00000000}},	//   _མིག__གཅིག_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x0aae4022,0x00000000,0x00000000,0x00000000}},	//   _खोज__में_, --, --, --, 
   {{0x93284016,0x00000000,0x00000000,0x00000000}},	//   _fullsten_profil_, --, --, --, 
   {{0xeef2600f,0x344f4018,0x00000000,0x00000000}},	//   _nonkulun, _adicioná__lo_, --, --, 
   {{0xb2cca02a,0xebca600c,0xf8f48012,0x00000000}},	//   _en__venn_, _जाति__के_, _všetkých_, --, 
   {{0x863b400e,0x138dc012,0x1738800c,0xbf41c002}},	//   _právní_, _navyše_, _रोके__खातिर_, _обавезе_, 
   {{0xbb542024,0xb2454012,0x471f800c,0x00000000}},	//   _forumu__privatna_, _týmto_, _बहुते__सारा_, --, 
   {{0xeee9202e,0xfa9e6014,0xac6f600b,0xd2676003}},	// [1c60] _diskutan, _प्राचीन__काल_, _afurika_, _དམ__བཅའ_, 
   {{0x02d9200f,0xb1e1a012,0xf42b600b,0x00000000}},	//   _inceku_, _niektoré_, _na__rimwe_, --, 
   {{0x12fc800f,0xc1084012,0xb7c22011,0xf343800a}},	//   _izaga_, _užívateľ, _usuario__contrasi, _मस्ती__हंसी_, 
   {{0x6ba9e006,0xced5800e,0x8fb4e037,0x00000000}},	//   _སྒྲོམ__ནཱ_, _což_, _respuest_reportar_, --, 
   {{0xaca24021,0x8242a003,0x00000000,0x00000000}},	//   _ཁྱབ__སྤེལ_, _དེར_, --, --, 
   {{0xee3ce002,0x0254c00e,0x62596003,0x00000000}},	//   _се__да_, _měli_, _རེའི__གསར_, --, 
   {{0xb4746045,0xf39b600f,0x00000000,0x00000000}},	//   _som__to_, _ukuxoxa_, --, --, 
   {{0xa6b0a012,0x527a6003,0x00000000,0x00000000}},	//   _október_, _ལས__འཆར_, --, --, 
   {{0xab56c01d,0x34d0001a,0x00000000,0x00000000}},	//   _sentiasa_, _ekstern__artikkel_, --, --, 
   {{0x3471e012,0x00000000,0x00000000,0x00000000}},	//   _sme__sa_, --, --, --, 
   {{0x6477a025,0xa01bc002,0x00000000,0x00000000}},	//   _milhões__de_, _проверит_своје_, --, --, 
   {{0x03536018,0x00000000,0x00000000,0x00000000}},	//   _de__proteção_, --, --, --, 
   {{0xb47e4009,0x3374200b,0x00000000,0x00000000}},	//   _uden__at_, _ku__buryo_, --, --, 
   {{0x6b8ee03a,0x94ad0019,0xe2d4600d,0x52d98017}},	//   _ཏུ_, _gir__deg_, _verdad_, _plzeň_, 
   {{0x8e0f0006,0x00000000,0x00000000,0x00000000}},	//   _རིངས__ལུགས_, --, --, --, 
   {{0x229ce006,0x9ee3e00e,0x4f0ce018,0x7bb88003}},	//   _རེས__ནངས_, _prý_, _estoque__produtos_, _ནས__རང_, 
   {{0x33958005,0x82946003,0x2bb8400c,0x00000000}},	// [1c70] _voss_, _དེའི__ཐོག_, _एकरो__पऽ_, --, 
   {{0x82a66029,0x3467600b,0x8b6e200f,0x77ae400c}},	//   _རང__དབང_, _niba__bishobok, _ukuthula_, _से__प्रमाणित_, 
   {{0xc4926019,0x3c592014,0x93d7400b,0xdc0fa00f}},	//   _av__en_, _के__मिले_, _abatutsi_, _ukutadis, 
   {{0xb618c002,0x4f6a601a,0x2184400f,0x00000000}},	//   _заједнич, _om__kommunar_, _ibhabhil, --, 
   {{0x937b6031,0x7ef3200a,0xb2778012,0x69f9a002}},	//   _padahal_, _लिखकर_, _účtovníc, _професио, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa2d1a012,0xc877c00e,0xda1ee018,0x00000000}},	//   _človek_, _říká_, _licença_, --, 
   {{0x7443e01a,0xc9f48012,0x00000000,0x00000000}},	//   _tru_, _ušetríte_, --, --, 
   {{0x8443e00b,0x92f9a004,0x0263a003,0x0716000a}},	//   _uru_, _uyehova_, _བྱུང__ཡོད_, _का__फंडा_, 
   {{0xec106022,0xc2924016,0x5304400b,0x245d2018}},	//   _विकास__के_, _antall_, _ekleziya__kandi_, _alteraçõ, 
   {{0x23cec00e,0x89ca002f,0x22922003,0x8486400a}},	//   _slevy_, _encontra_, _གུར__ཀུམ_, _तैयारी_, 
   {{0x7c7ee034,0xc28e200f,0xeafb400e,0xff24c002}},	//   _romsdal_, _ukuthi__abantu_, _krásné_, _требало__би_, 
   {{0xefeb805c,0x3ef0e002,0x72c2c00f,0x5b7c0006}},	//   _सामाजिक_, _им_, _yakwa__israyeli_, _རིམ__རྫོང_, 
   {{0x6dce6002,0xa9c0e00e,0x00000000,0x00000000}},	//   _више_, _zejména_, --, --, 
   {{0x0b8d4013,0xe449e016,0x0c48400a,0x5c57e00a}},	//   _और_, _lenkes__til_, _लेने_, _के__सबसे_, 
   {{0xeea1c002,0x5a6e600c,0x00000000,0x00000000}},	//   _као__да_, _कएल__गेल_, --, --, 
   {{0xa242000c,0x2485600a,0x00000000,0x00000000}},	// [1c80] _द्वारा__फरवरी_, _शिकायत_, --, --, 
   {{0x945e6012,0x7bbaa003,0x00000000,0x00000000}},	//   _prievidz, _ལས__ཁང_, --, --, 
   {{0x8337400c,0x00000000,0x00000000,0x00000000}},	//   _पर__बोली_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7ed24002,0x1adf6033,0x42b6200f,0x00000000}},	//   _да__се_, _osobama__mlađim_, _mathewu__luka_, --, 
   {{0xc8386018,0x7e8d6002,0x2251800c,0x00000000}},	//   _comparti_mensagem_, _ће__се_, _पहुंचल_, --, 
   {{0x846fc012,0x7bb7e00a,0x8c55200a,0x00000000}},	//   _čas__sk_, _सिरमौर__सोलन_, _जालंधर__पटियाला_, --, 
   {{0xff01c002,0x00000000,0x00000000,0x00000000}},	//   _како__би_, --, --, --, 
   {{0xc24da006,0xdaf3a02a,0xd2e3e012,0xcf33a01a}},	//   _འབད_, _endringe, _ktorých_, _endringa, 
   {{0x5a3ce022,0xf41aa012,0x00000000,0x00000000}},	//   _वंश_, _napriek__tomu_, --, --, 
   {{0x6bcde00a,0xae0d2002,0xd9c2600a,0x00000000}},	//   _सभी_, _две_, _अलाइक__लाइसेंस_, --, 
   {{0xc26dc015,0x42e0600e,0x6683e00c,0xfc48e00c}},	//   _siwon_, _jednoho_, _धेयान_, _हमरे_, 
   {{0xaba78006,0x6bae600a,0x3e856002,0x00000000}},	//   _རྫོང__དེ_, _जाएँ__भ्रमण_, _обзира__на_, --, 
   {{0x9f3b6015,0xf2a6800f,0x246b400b,0xab76200c}},	//   _mengomen, _ngabe_, _icese__ko_, _के__कहानी_, 
   {{0x124dc015,0x137ea00a,0x00000000,0x00000000}},	//   _di__topic_, _मुक्त__ज्ञानकोष_, --, --, 
   {{0x739ec01e,0x3ff7c00e,0x00000000,0x00000000}},	//   _tjedna__mjesec_, _mapa__stránek_, --, --, 
   {{0xa3208004,0xe4c14002,0x7ff92014,0xeaca2003}},	// [1c90] _kwaye_, _skok__na_, _वंशावली_, _འགོག_, 
   {{0x148ce009,0x8dbb6003,0x00000000,0x00000000}},	//   _af__med_, _དུ__ཕེབས_, --, --, 
   {{0x02d18018,0xee7bc002,0x2a736011,0xcbcde00a}},	//   _como__avalia_, _март__фебруар_, _ningunha_, _तभी_, 
   {{0x22b3c01a,0x00000000,0x00000000,0x00000000}},	//   _lenkjer__sida_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xf393000c,0x04692018,0x00000000,0x00000000}},	//   _से__भोजपुरी_, _conforto_, --, --, 
   {{0x01cca015,0x528b001c,0x00000000,0x00000000}},	//   _favoritm, _किशोरी_, --, --, 
   {{0x6275400f,0x00000000,0x00000000,0x00000000}},	//   _umngane__wakho_, --, --, --, 
   {{0x1225a00e,0x00000000,0x00000000,0x00000000}},	//   _mobilní__telefony_, --, --, --, 
   {{0x052f402f,0x00000000,0x00000000,0x00000000}},	//   _respeito_, --, --, --, 
   {{0x825d000f,0xe48a601a,0x00000000,0x00000000}},	//   _nsuku__zonke_, _koplar__til_, --, --, 
   {{0x9298c003,0x47e6e01c,0x00000000,0x00000000}},	//   _ཀྱི__མིང_, _हेडलाइन्, --, --, 
   {{0xfeb8e002,0x9f538012,0x00000000,0x00000000}},	//   _би_, _mať_, --, --, 
   {{0x6257200e,0xc2b3c003,0x1ec6c002,0xa2942003}},	//   _dále_, _ཚན__རིག_, _садржај_, _དབུས__བོད_, 
   {{0x026f000f,0x99fe4018,0x00000000,0x00000000}},	//   _eminingi_, _curitiba_, --, --, 
   {{0x203de018,0x8c806002,0x00000000,0x00000000}},	//   _anúncios_, _ћете_, --, --, 
   {{0x2a33600c,0x828f000b,0x00000000,0x00000000}},	// [1ca0] _करब_, _umukino_, --, --, 
   {{0x34916027,0x00000000,0x00000000,0x00000000}},	//   _by__mal_, --, --, --, 
   {{0x39b9200f,0x00000000,0x00000000,0x00000000}},	//   _kajehova_, --, --, --, 
   {{0x4354c00d,0xa3276011,0xa3cec02f,0x00000000}},	//   _tenemos_, _suxestió_queixas_, _talvez_, --, 
   {{0xc46a2018,0x9c572018,0x0f538012,0x1e8ca00a}},	//   _das__às_, _para__compras_, _dať_, _के__पूर्व_, 
   {{0xd254c00e,0xc275400f,0xdbcde00c,0x00000000}},	//   _tělo_, _umngane__wakhe_, _सभे_, --, 
   {{0x6b41203d,0x6c3ce00a,0x00000000,0x00000000}},	//   _pravidla_, _वाशिंगटन__श्रीनगर_, --, --, 
   {{0xf3f96025,0xc470c009,0x00000000,0x00000000}},	//   _alguns_, _sådan__en_, --, --, 
   {{0xb611e00f,0x745b400b,0x00000000,0x00000000}},	//   _ukulandi, _umujyi__wa_, --, --, 
   {{0x3fc0a00e,0xfa13a00f,0x00000000,0x00000000}},	//   _stránek_, _uma__kungenze, --, --, 
   {{0x9dfee037,0xd356a00d,0x227a2007,0xe485c00b}},	//   _el__lenguaje_, _obtener_, _adalah__lebih_, _ijambo__ry_, 
   {{0x2ab0e014,0x3159400e,0x00000000,0x00000000}},	//   _पांडेय_, _doplňky_, --, --, 
   {{0x67d64003,0x00000000,0x00000000,0x00000000}},	//   _འགྲེམས__སྟོན_, --, --, --, 
   {{0xb4444018,0xe54f200f,0x6479e025,0x00000000}},	//   _br_, _ukuhluph, _ponto__de_, --, 
   {{0x7756603d,0x23eae015,0xaca2200a,0x00000000}},	//   _प्रमाणित_, _banten_, _से__नहीं_, --, 
   {{0x5b8c800c,0x6499601e,0x00000000,0x00000000}},	//   _ओह_, _za__bh_, --, --, 
   {{0x8553600f,0xd84be01d,0xe4a2c00b,0xc408800b}},	// [1cb0] _izikhath, _bertulis_, _ibibazo__by_, _ni__ukuvuga_, 
   {{0xe47ac00b,0x0ca8800a,0x00000000,0x00000000}},	//   _umuco__wo_, _पटियाला__पठानकोट_, --, --, 
   {{0xc45f2037,0x92cde011,0x7bb7e003,0x8bc0e003}},	//   _cerrado__la_, _unha__nova_, _ཅི__ཡང_, _ལྷ__སར_, 
   {{0x5439c011,0xb7a34003,0x1a19c011,0x73a5200e}},	//   _traballo_, _ཉིན__འདོན_, _traballa_, _volný__čas_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7980600e,0x72428003,0xc30e400c,0x00000000}},	//   _péče_, _ཐེག_, _अउर__बेसी_, --, 
   {{0xf20ec002,0x2a7f8012,0x35220002,0x00000000}},	//   _данас_, _môžem_, _овим_, --, 
   {{0x2e0ce00f,0x00000000,0x00000000,0x00000000}},	//   _nabesifa, --, --, --, 
   {{0xebb36014,0x75b9e006,0x00000000,0x00000000}},	//   _गंगा__के_, _ཐཱའི__ལེནཌ_, --, --, 
   {{0x734a8024,0xf300c00e,0xd2a6000c,0x3292400b}},	//   _nedelju_, _redakci_, _महापात्र, _butare_, 
   {{0xaa792022,0x00000000,0x00000000,0x00000000}},	//   _काम__करत_, --, --, --, 
   {{0xc4444045,0xd2490014,0x31b9e00a,0xb83e6003}},	//   _sr_, _राष्ट्री_स्तर_, _मॉडल_, _སྦྱོང__དབྱིན_, 
   {{0xf3778009,0x4553600f,0xde27e00e,0x00000000}},	//   _vores__brug_, _ezikhath, _nápověda_, --, 
   {{0xe202600b,0x00000000,0x00000000,0x00000000}},	//   _birimo_, --, --, --, 
   {{0x0c08e00a,0xa30f800f,0x3245a00e,0x00000000}},	//   _सकता__है_, _imibono_, _tímto_, --, 
   {{0x82bba039,0x3abce00c,0x00000000,0x00000000}},	// [1cc0] _ini__bisa_, _खातिर__आपन_, --, --, 
   {{0xa383000a,0x00000000,0x00000000,0x00000000}},	//   _अब__मनुष्यों_, --, --, --, 
   {{0xd35f200b,0x940a800f,0x52f90002,0x00000000}},	//   _tangaje_, _ngenhliz, _потребно_, --, 
   {{0xf4bd4009,0x8a5d600e,0x4718a00c,0x01e6a00c}},	//   _skriv__et_, _zpráva_, _एह__किला_, _महुआ__चैनल_, 
   {{0x2395e011,0xbbf6c00a,0x00000000,0x00000000}},	//   _dous_, _अभी__तक_, --, --, 
   {{0x8c61202e,0x8b81a006,0x22e6000b,0x00000000}},	//   _tisuća_, _གིས__བཞེངས_, _wa__gatanu_, --, 
   {{0x1f4f800f,0x2401200e,0x81e18013,0x00000000}},	//   _ngesikha, _tomto__fóru_, _नौकरी_, --, 
   {{0x84348011,0x494ae019,0x00000000,0x00000000}},	//   _da__xunta_, _sammenhe, --, --, 
   {{0x427ec003,0x00000000,0x00000000,0x00000000}},	//   _ལོ__ཉེར_, --, --, --, 
   {{0xd316800e,0x427ea01a,0xa442800b,0x8460000c}},	//   _praze_, _kjende_, _rpa_, _पांडुलिप, 
   {{0x22bb4020,0x7497600b,0x3a54400c,0x00000000}},	//   _མི__ལེན_, _mukuru__wa_, _इस्तेमाल__कइल_, --, 
   {{0xeb694022,0x32912005,0x7b59800c,0x00000000}},	//   _के__बयान_, _øya_, _यायन_, --, 
   {{0x926ce01a,0xfc08c00a,0x00000000,0x00000000}},	//   _difor_, _डायरी__आज_, --, --, 
   {{0xe759c00a,0x2aa0c00a,0x00000000,0x00000000}},	//   _फिल्मों_, _कबीर__नगर_, --, --, 
   {{0x04b0801a,0x00000000,0x00000000,0x00000000}},	//   _eller__ein_, --, --, --, 
   {{0x7fd9e015,0xc25ac01a,0x00000000,0x00000000}},	//   _kami__kumpulka, _spelt_, --, --, 
   {{0xa241e00a,0xc272a012,0x00000000,0x00000000}},	// [1cd0] _बिजली_, _upraviť__obchod_, --, --, 
   {{0x361ee011,0xeb93800c,0xd2576009,0x3bc2400c}},	//   _foundati, _बात__के_, _vælg_, _गइल__बा_, 
   {{0xf33b200c,0xf2be4012,0x9b9bc00a,0x76f9a00a}},	//   _भोजपुरी_, _predám_, _बताया__कि_, _माना_, 
   {{0x645b000f,0x00000000,0x00000000,0x00000000}},	//   _isidingo_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x729dc01d,0xac48800a,0x00000000,0x00000000}},	//   _pelbagai_, _देने_, --, --, 
   {{0x341b000b,0xdc48400c,0x00000000,0x00000000}},	//   _bbc__gahuza_, _लेवे_, --, --, 
   {{0x0ba8c006,0x7ae52014,0x00000000,0x00000000}},	//   _ནང__ལུ_, _कृष्णदेव_, --, --, 
   {{0x0237401e,0x92da600e,0xa772c002,0x00000000}},	//   _alejhi_, _hotelu_, _свега_, --, 
   {{0x9bdc2003,0xd4bc4011,0x6002400e,0x9bcd4003}},	//   _རེད__དམ_, _non__só_, _počtu__obchodů_, _གཏམ__བུ_, 
   {{0x0bfce003,0x9aa9e00a,0x33f8800f,0x00000000}},	//   _ཐོ__འམ_, _अपनी__राय_, _umhubi_, --, 
   {{0x5236400a,0x87cbc002,0x00000000,0x00000000}},	//   _भविष्य__दर्शन_, _сваког_, --, --, 
   {{0x97a6c009,0x92dee00f,0x72566003,0x00000000}},	//   _ændringe, _ungaphen_kanjani_, _གྲུབ__བྲག_, --, 
   {{0xb8474028,0x00000000,0x00000000,0x00000000}},	//   _duplicad, --, --, --, 
   {{0xe47a6005,0x1ee1400e,0x2abd400a,0xc7f0000c}},	//   _tekst__er_, _veškeré_, _तोल__मोल_, _के__दूसरका_, 
   {{0x5443800b,0x325b6004,0xebad8035,0x8a1e6002}},	// [1ce0] _css_, _ngaloo_, _wothando_, _нити_, 
   {{0xfbdd8003,0x00000000,0x00000000,0x00000000}},	//   _གཞི__དང_, --, --, --, 
   {{0xe2dac00b,0x00000000,0x00000000,0x00000000}},	//   _bw__igihugu_, --, --, --, 
   {{0x7b734014,0xebf6a00a,0x00000000,0x00000000}},	//   _अप्रकाशि, _में__इस_, --, --, 
   {{0xe240000c,0x17252018,0x00000000,0x00000000}},	//   _भोजपुरिय, _montagem_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa78b6011,0x6a4c0022,0xb2432003,0x93170011}},	//   _fins__política_, _के__रुप_, _མེར_, _grazas_, 
   {{0x3248800f,0x68d1a00f,0x00000000,0x00000000}},	//   _adamu_, _lokhu__kozokubu, --, --, 
   {{0xf29f601d,0xf27ba003,0x4d8f600f,0xda04800a}},	//   _kerjaya_, _དེ__རེད_, _emhlanga, _फीरोजाबा_बदायूं_, 
   {{0x92908015,0x3a3d200a,0x00000000,0x00000000}},	//   _bekasi_, _हूँ_, --, --, 
   {{0x42e0401f,0x2ed4e002,0x00000000,0x00000000}},	//   _abdullah_, _им__је_, --, --, 
   {{0xac4a4013,0x00000000,0x00000000,0x00000000}},	//   _नहीं_, --, --, --, 
   {{0x41d0e002,0x00000000,0x00000000,0x00000000}},	//   _светског_, --, --, --, 
   {{0x84232002,0x7a42a00c,0x9e74000a,0x00000000}},	//   _najnovij_vesti_, _के__कमल_, _लखनऊ__लखीमपुर_, --, 
   {{0xe387601a,0x6a50e00e,0x84262022,0x7ad0800e}},	//   _starta_, _nevíte_, _खराबी_, _systém__starší_, 
   {{0x9410e040,0xc4790011,0x1bbee003,0x00000000}},	//   _još__poruka_, _sbernard_en_, _བརྒྱུད__ནས_, --, 
   {{0x3248403d,0x629f601d,0x16f82013,0xc242a029}},	// [1cf0] _velmi_, _berjaya_, _लगता_, _དེས_, 
   {{0xd224800b,0x1353a018,0x00000000,0x00000000}},	//   _irak_, _quantida_mínima_, --, --, 
   {{0x22eee004,0x00000000,0x00000000,0x00000000}},	//   _phantsi_, --, --, --, 
   {{0xf2248009,0x7a65000a,0x7c48e00a,0x37be600a}},	//   _krak_, _आते__हैं_, _हमसे_, _गैंगरेप_, 
   {{0x422aa00e,0x82dfc002,0xa288c003,0x00000000}},	//   _někdo_, _одбора_, _ཞིག__ཆགས_, --, 
   {{0x5c0b600b,0x00000000,0x00000000,0x00000000}},	//   _umupira_, --, --, --, 
   {{0x4a3d200a,0xadafe00c,0x00000000,0x00000000}},	//   _हूं_, _तत्कालीन__राष्ट्रप, --, --, 
   {{0xc473600e,0x00000000,0x00000000,0x00000000}},	//   _pokud__je_, --, --, --, 
   {{0x1919a022,0x06f0600a,0x00000000,0x00000000}},	//   _सिंहासन_, _आपके__सुझाव_, --, --, 
   {{0x23170011,0x00000000,0x00000000,0x00000000}},	//   _prazas_, --, --, --, 
   {{0xc312e039,0x00000000,0x00000000,0x00000000}},	//   _oleh__karena_, --, --, --, 
   {{0x62634003,0x00000000,0x00000000,0x00000000}},	//   _དང__ཕྱི_, --, --, --, 
   {{0x348e2015,0x72c3400f,0x00000000,0x00000000}},	//   _ga__ada_, _zakwa__israyeli_, --, --, 
   {{0xfb9d200c,0x00000000,0x00000000,0x00000000}},	//   _के__जद_, --, --, --, 
   {{0xde7ca018,0x24acc034,0x63cec027,0x93e8e018}},	//   _mensagen_verdinha, _medie__og_, _slovan_, _devoluçõ, 
   {{0x5406e01d,0x17a8c002,0x00000000,0x00000000}},	//   _kepakara_urus_, _особа_, --, --, 
   {{0x6b752003,0x2e96c002,0x00000000,0x00000000}},	// [1d00] _བོད__གཞུང_, _шта__је_, --, --, 
   {{0xd2fce01a,0x32bea012,0xc3f46015,0x22b90018}},	//   _ligg_, _všetko_, _partai_, _busca__para_, 
   {{0xe201e02f,0x946be015,0x00000000,0x00000000}},	//   _aqui_, _mengupda_sistem_, --, --, 
   {{0x3200a00e,0xeb95e00c,0x00000000,0x00000000}},	//   _jejich_, _मिला__के_, --, --, 
   {{0x5b9f4003,0xfbe1e003,0x00000000,0x00000000}},	//   _ཡོན__ཏན_, _རྒྱུ__དང_, --, --, 
   {{0x22b8000b,0x00000000,0x00000000,0x00000000}},	//   _meni__ibanze_, --, --, --, 
   {{0x4c49400a,0xebdde00a,0x9b200003,0x0ba6600c}},	//   _हमें_, _दी__गई_, _བཙོན__འཇུག_, _एह__ओर_, 
   {{0x2f326002,0xa2cae005,0xb213e004,0x6366200b}},	//   _делити__под_, _bygd_, _wath_, _abagabo_, 
   {{0x329ae003,0x83c12012,0x00000000,0x00000000}},	//   _རིན__ཆེན_, _nemajú_, --, --, 
   {{0xf424800b,0x83e3a010,0x00000000,0x00000000}},	//   _afise__ubuzima_, _en__masse_, --, --, 
   {{0xc491e028,0x39e46002,0xcc71801c,0x00000000}},	//   _el__la_, _они__који_, _फिल्टर_, --, 
   {{0x198e2002,0x020e2002,0x749b600b,0x00000000}},	//   _ради_, _рада_, _wo__mu_, --, 
   {{0xc2e26024,0xa2a8a006,0x1807a025,0xc275c011}},	//   _od__prva_, _བཟོ__འདི_, _tópicos_, _con__máis_, 
   {{0x5473600e,0xbbb4400a,0x00000000,0x00000000}},	//   _pokud__se_, _हैं__ये_, --, --, 
   {{0x635a0011,0x946d2018,0x944ac01d,0x00000000}},	//   _pódense__aplicar_, _não__há_, _kerana__ia_, --, 
   {{0x6201400b,0x04b9800e,0xa161e002,0x00000000}},	//   _bafite_, _distribu_cz_, _да__постоји_, --, 
   {{0x84b3601e,0x0a396014,0xd939600c,0xe28a8003}},	// [1d10] _kur__an_, _सांप_, _सांच_, _བཤད__གནང_, 
   {{0x6490c037,0xbfd6e00c,0x00000000,0x00000000}},	//   _juegos__de_, _के__बातचीत_, --, --, 
   {{0xc49b4011,0xf1c28002,0x00000000,0x00000000}},	//   _aquí__non_, _да__буду_, --, --, 
   {{0x0b8f8029,0x00000000,0x00000000,0x00000000}},	//   _ཤུ_, --, --, --, 
   {{0x4b8c8029,0x8424e016,0x21332012,0x00000000}},	//   _ཐད_, _oss__retten_, _kvalitné_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7ba88003,0x00000000,0x00000000,0x00000000}},	//   _ཁང__དུ_, --, --, --, 
   {{0x6b5a6002,0x00000000,0x00000000,0x00000000}},	//   _прокомен, --, --, --, 
   {{0x72982003,0xec04a00c,0x12d8800c,0x7a83c00c}},	//   _རྩལ__གསལ_, _संदेह__के_, _सगरी_, _हमरा__दिल_, 
   {{0xc2bb400b,0x74396002,0x00000000,0x00000000}},	//   _css__niba_, _претходн, --, --, 
   {{0x72b4600e,0x7e188002,0x00000000,0x00000000}},	//   _líbí_, _posetila, --, --, 
   {{0x29c5e002,0x229dc038,0xee686002,0x8a4d400c}},	//   _нема__коментар, _ría_, _кажу__да_, _के__तरफ_, 
   {{0xd3890009,0xb4532011,0x912d0002,0x8a572002}},	//   _kommenta_skrevet_, _deste__xeito_, _сајту_, _хиљада_, 
   {{0xc2dc4018,0xc46e600e,0x00000000,0x00000000}},	//   _produto__como_, _kdo__je_, --, --, 
   {{0xa31e0039,0xf2a68003,0x00000000,0x00000000}},	//   _lengkap__yang_, _སེར__ཤུལ_, --, --, 
   {{0x4bb14003,0x00000000,0x00000000,0x00000000}},	//   _ནས__ལོ_, --, --, --, 
   {{0x6b8c8020,0xe7d0c031,0xb2294040,0x1304001d}},	// [1d20] _ནཱ_, _lingkung, _dve__godine_, _pekerjaa_lihat_, 
   {{0xc435e037,0x00832037,0xbe69a00a,0x4b596013}},	//   _de__cuotas_, _amigos__seleccio, _मस्ती__फिल्मीखब, _साइन_, 
   {{0x02258004,0x9ffde034,0x32562002,0x4860a00f}},	//   _marko_, _fylkesko, _становни, _izinguqu, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x5e642037,0xb48d6018,0x9bd40006,0xbbfcc00a}},	//   _públicam, _de__sem_, _ཡོདཔ__ལས_, _हुए__उसे_, 
   {{0xebd4000c,0xa22a2002,0x7be88003,0x00000000}},	//   _धरम__के_, _бога_, _གང__དུ_, --, 
   {{0x82d8c01d,0x00000000,0x00000000,0x00000000}},	//   _selesa_, --, --, --, 
   {{0x24088015,0x82e2e03d,0x1316400f,0x00000000}},	//   _bisa__langsung_, _dotykové_, _kanjani__ujehova_, --, 
   {{0x6133200e,0xac9f2038,0x0fd2a009,0x6a7d000b}},	//   _kvalitní_, _ao__sistema_, _kræver_, _hamagara_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x826fa00f,0xec07000a,0x9a33400a,0x4724800c}},	//   _amaningi_, _कड़ी__इस_, _औरत_, _बहुत__सारा_, 
   {{0x825a000f,0x00000000,0x00000000,0x00000000}},	//   _bazo__zonke_, --, --, --, 
   {{0xc2a58006,0xe4b8000e,0x00000000,0x00000000}},	//   _བཙུགས__འབད_, _odpověď__na_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xba6c000e,0x7495600d,0xb3ac800a,0x00000000}},	//   _přímo_, _ir__al_, _मथुरा__मैनपुरी_, --, 
   {{0x1b8fa029,0x22d88019,0x7c48800c,0x84c22012}},	//   _སུ_, _sakene_, _देवे_, _porovnan_sk_, 
   {{0xd454601a,0x8509a00a,0x00000000,0x00000000}},	// [1d30] _eit__godt_, _सबसे__पुराने_, --, --, 
   {{0xf2926012,0x92994003,0x00000000,0x00000000}},	//   _strane_, _གྱི__མིང_, --, --, 
   {{0x69c3600f,0xe387e00f,0x1dfb200a,0x53da600b}},	//   _ngempela_, _petru_, _टिहरी__देहरादून_, _mu__mpera_, 
   {{0x33f4602d,0xa992801a,0xbc5fa00a,0xd4ac001a}},	//   _tvrtke_, _opphavle, _को__अपने_, _fødde__den_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xb25c4003,0x00000000,0x00000000,0x00000000}},	//   _ལུས__མེར_, --, --, --, 
   {{0x1c9ae003,0xd73ae003,0x9f6d400a,0x00000000}},	//   _རྒོལ_, _རྒོད_, _बीबीसी__लिंक_, --, 
   {{0x3291e01d,0x00000000,0x00000000,0x00000000}},	//   _aduan_, --, --, --, 
   {{0xaa33605e,0x1c4f400f,0x52fd6018,0xb486a018}},	//   _करत_, _upawulu_, _imagem_, _produtos__em_, 
   {{0xc443e01f,0xc41b4012,0x00000000,0x00000000}},	//   _isu_, _kuchynsk, --, --, 
   {{0x23d0000f,0x329e0002,0xc1b9a00c,0x00000000}},	//   _abamemez, _њима_, _मारल_, --, 
   {{0x2bebe02e,0xaa406018,0x00000000,0x00000000}},	//   _komentir, _divergên_preço_, --, --, 
   {{0xb73ae006,0x32650006,0xdddb4003,0x670c200c}},	//   _རྒེད_, _ཁྱོད__རའི_, _ངོས__ཁོངས_, _लाभ__उनका_, 
   {{0x38dc2002,0xe9d0c002,0x00000000,0x00000000}},	//   _људи_, _језик_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x12ef800f,0x00000000,0x00000000,0x00000000}},	//   _sonke__isintu_, --, --, --, 
   {{0x3dce4006,0x44956011,0xc9f1c009,0x00000000}},	// [1d40] _འབད__ཚུགས_, _se__lle_, _søgetjen, --, 
   {{0x32948003,0x00000000,0x00000000,0x00000000}},	//   _གཞི__གཞན_, --, --, --, 
   {{0x62f20012,0x3495801a,0x00000000,0x00000000}},	//   _nasleduj, _på__eit_, --, --, 
   {{0xe303200d,0x4a24e018,0x00000000,0x00000000}},	//   _las__mejores_, _que__estão_, --, --, 
   {{0x1a218003,0x651ac00a,0x9495600e,0x00000000}},	//   _གཞོན__ནུའི_, _गाजीपुर__गोंडा_, _se__ale_, --, 
   {{0x02f76039,0xec0b200c,0x0bb9c00a,0x01ce600c}},	//   _menikah_, _उपाय__के_, _देती__है_, _भोजपुरी__चैनल_, 
   {{0xd96ba00e,0x64c34011,0xe2500003,0x326c600d}},	//   _uživatel, _galega__de_, _གསུང__བཤད_, _manos_, 
   {{0x145ce037,0x4f04800f,0x8856200c,0x00000000}},	//   _acordar__con_, _umbuso__kankulun, _के__श्रृंखला_, --, 
   {{0x629bc003,0x11efc018,0x4c48800c,0x7434400f}},	//   _རེད__ཅེས_, _formação_, _देले_, _usathane__udeveli_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x3a0e2002,0x42bbc012,0x842c8002,0x00000000}},	//   _врло_, _čierne_, _побољшањ, --, 
   {{0x0f318012,0xe0922002,0x00000000,0x00000000}},	//   _priemern, _покушате__поново_, --, --, 
   {{0xc4ae6040,0x00000000,0x00000000,0x00000000}},	//   _kod__je_, --, --, --, 
   {{0xb4922015,0x59ef6003,0x7b9fc003,0x00000000}},	//   _me__dan_, _དང__པོའི_, _རྒྱལ__དྲ_, --, 
   {{0x22ab0015,0x82b02037,0x347c6009,0x00000000}},	//   _bandung_, _confiabl_cómo_, _sig__på_, --, 
   {{0x8213000b,0x242a2015,0xaf336031,0x00000000}},	//   _michel_, _rumah__dijual_, _konsulta, --, 
   {{0xa27e801a,0x1d0f2003,0x00000000,0x00000000}},	// [1d50] _utan_, _ཆགས__སྐོར_, --, --, 
   {{0xc1b9600f,0x00000000,0x00000000,0x00000000}},	//   _izinceku__zikankul, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xc46e6012,0x9be32022,0xc2370018,0x5efd8002}},	//   _nie__je_, _तक__कि_, _opcional__digite_, _покрајин, 
   {{0x282ba011,0xdfe2000e,0x00000000,0x00000000}},	//   _recoñece_comparti, _přístupn, --, --, 
   {{0xe95d4009,0x34882019,0x7d028002,0x00000000}},	//   _lejlighe, _oppmerks_på_, _информат, --, 
   {{0xfbeb2022,0x13f30018,0x121e000f,0xd9cb400b}},	//   _तब__से_, _lista__negra_, _osukwini_, _gusohora_, 
   {{0x9b9ca003,0x00000000,0x00000000,0x00000000}},	//   _ཡོད__དམ_, --, --, --, 
   {{0x7a87e00a,0x00000000,0x00000000,0x00000000}},	//   _हंसमुख__हैं_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x8a85800a,0x00000000,0x00000000,0x00000000}},	//   _उन्नाव__एटा_, --, --, --, 
   {{0x92bb0008,0xf3302011,0xebef200c,0x3a70a014}},	//   _en__vigo_, _de__xénero_, _बा__के_, _रचनाकार__अपन_, 
   {{0x2fdb000f,0xbf684006,0xf46f200b,0x00000000}},	//   _umphosto, _ཆས__འབྲུག_, _page__inkuru_, --, 
   {{0x6eba0002,0xebe66018,0x5b67e002,0x52500002}},	//   _после_, _tendênci, _највише_, _петак_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xaf7ae029,0xe91ae003,0xea7ae029,0xb4748028}},	//   _རྒྱུ_, _རྒྱག_, _རྒྱང_, _publicad_el_, 
   {{0x02b5a003,0x0ba8c006,0xe4b5e00b,0x00000000}},	// [1d60] _གི__ཡོད_, _ཁབ__ལུ_, _bahitany_na_, --, 
   {{0x22e20009,0x5bf6e006,0x00000000,0x00000000}},	//   _igennem_, _གི__ཧེ_, --, --, 
   {{0x81122027,0x50d7e012,0x00000000,0x00000000}},	//   _pravdepo, _dodávate, --, --, 
   {{0x0a49c022,0xf3f4601a,0x8472e011,0x00000000}},	//   _दिल__में_, _fortel_, _que__xa_, --, 
   {{0xa1c92002,0xea33600c,0x00000000,0x00000000}},	//   _поште_, _करस_, --, --, 
   {{0x334c0018,0xdf412018,0x00000000,0x00000000}},	//   _futebol_, _os__melhores_, --, --, 
   {{0x0452e02a,0x332b601a,0x82862037,0x644ba00b}},	//   _gjør__det_, _nn__index_, _operacio_sólo_, _ibanze__jya_, 
   {{0xec782011,0xec02000c,0x9bce4003,0x00000000}},	//   _persoal_, _इतिहासका_के_, _མཆན__བུ_, --, 
   {{0x0a6a2022,0x12c3c024,0x34a2a00e,0xd30f600f}},	//   _क्षेत्र__में_, _milijard_evra_, _za__kč_, _ukubusa_, 
   {{0x735f2015,0x00000000,0x00000000,0x00000000}},	//   _donghae_, --, --, --, 
   {{0xf2110013,0x00000000,0x00000000,0x00000000}},	//   _हरिद्वार_, --, --, --, 
   {{0xb26a600b,0xc4b9c00e,0x00000000,0x00000000}},	//   _akiri__patiri_, _jako__je_, --, --, 
   {{0x3375200b,0x00000000,0x00000000,0x00000000}},	//   _mu__buryo_, --, --, --, 
   {{0xf3ae8037,0x3aa76002,0x00000000,0x00000000}},	//   _pero__delante_, _за__заштиту_, --, --, 
   {{0x33eb4009,0x12d98014,0x53f8c015,0xf6696011}},	//   _rigtig_, _पाती_, _solusi_, _da__exposici, 
   {{0xd2c82013,0x52f2000e,0x8bc2a00c,0x00000000}},	//   _अक्टूबर_, _skladem__cena_, _हैक__कऽ_, --, 
   {{0x6aabc00b,0x93bee018,0xc067a002,0x00000000}},	// [1d70] _buboneka__hamagara_, _móveis_, _развоја_, --, 
   {{0x14702002,0x0bce8006,0xd14c8009,0x00000000}},	//   _veoma__lak_, _བའད__ལུ_, _om__forhandl, --, 
   {{0xd9e2c00b,0x00000000,0x00000000,0x00000000}},	//   _kuvuguru, --, --, --, 
   {{0x9316c011,0xbc62a00e,0xce9b800c,0x00000000}},	//   _prezo_, _heurece_, _प्रतापी_, --, 
   {{0xb2254012,0x00000000,0x00000000,0x00000000}},	//   _niekto_, --, --, --, 
   {{0x0a6ee014,0x62d1c037,0xec782018,0xd4c2a00b}},	//   _युद्ध__में_, _hace__año_, _pessoal_, _urupapur_rw_, 
   {{0x848ce02c,0xe47b4037,0xe4b8e01a,0x6fe0000e}},	//   _kugira__ngo_, _mapa__es_, _kjem__til_, _ve__svém_, 
   {{0x229d6006,0x8e326015,0x839b000c,0x00000000}},	//   _མཐུད__འོང_, _kualitas_, _से__संबंध_, --, 
   {{0x228b2012,0xc298c003,0xd3a2a012,0xc288a003}},	//   _poslať_, _ཀྱི__ཟིན_, _najprv_, _བཙན__གྱི_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x937b0035,0xdca0000c,0xa6f8400c,0x00000000}},	//   _intando_, _से__लेके_, _एतना_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xd2500002,0x5e28e002,0xa65e0002,0x0b300002}},	//   _дела_, _ра_, _филм_, _дело_, 
   {{0xeb948022,0x93168011,0xc2ff400b,0x4aac200c}},	//   _रात__के_, _praza_, _ibi__komeza_, _दीहल__गइल_, 
   {{0x2b8f803a,0xf3ee601a,0xe2520003,0x4c50400a}},	//   _སྔ_, _òg__endre_, _བསྐྱར__ཞིབ_, _बुलंदशहर__बलिया_, 
   {{0x5a328013,0x5c88e00c,0x1a524018,0x4344200f}},	//   _खुद_, _सेहो_, _você__terá_, _kanye__naye_, 
   {{0x56f9a022,0xd278e01a,0x00000000,0x00000000}},	// [1d80] _मादा_, _som__kjem_, --, --, 
   {{0x6b97a014,0x00000000,0x00000000,0x00000000}},	//   _के__भी_, --, --, --, 
   {{0xe307801d,0x00000000,0x00000000,0x00000000}},	//   _hisap__konek_, --, --, --, 
   {{0x544dc024,0xc453201a,0x700ec012,0x00000000}},	//   _za__decu_, _han__vart_, _vytvoren, --, 
   {{0xc493600d,0x12998006,0xb29c6003,0xc2900018}},	//   _es__un_, _ཞལམ__སྒང_, _འཚོལ__དཀར_, _meia_, 
   {{0xa32f201d,0x00000000,0x00000000,0x00000000}},	//   _dikenali__sebagai_, --, --, --, 
   {{0x19ddc011,0x00000000,0x00000000,0x00000000}},	//   _ás__novidade, --, --, --, 
   {{0xd2888003,0xa2408003,0x00000000,0x00000000}},	//   _ཞིག__ཀྱང_, _ཀྱི__རྩོམ_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xc3e4c00e,0x444b200f,0xe68b800e,0x00000000}},	//   _pět_, _kozokubu_emuva_, _kancelář_, --, 
   {{0x2d5a2002,0xb3ea8015,0x4f1b602f,0x00000000}},	//   _може_, _dokter_, _novos__produtos_, --, 
   {{0x52024018,0xcbddc00a,0x4e5b201d,0x12a60025}},	//   _ótimo_, _बताया_, _perbezaa, _saiba_, 
   {{0xe5fd800f,0x8af5200e,0xfbf94003,0x00000000}},	//   _ujehova__unkulunk, _napříkla, _བུ__དང_, --, 
   {{0x0bc6e00a,0xd2902015,0x0cb5600a,0xa5f38002}},	//   _करता__है_, _lokal_, _पूछे__जाने_, _болести_, 
   {{0x9d592022,0x7bd1600a,0x00000000,0x00000000}},	//   _राजभाषा_, _सलमान__ने_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xccb5800a,0x00000000,0x00000000,0x00000000}},	// [1d90] _क्रियाएँ__खोजें_, --, --, --, 
   {{0xcaf6e002,0x187e0009,0x679c400c,0x00000000}},	//   _mop__paročist, _træning_, _से__पाकिस्ता, --, 
   {{0xb496e025,0x00000000,0x00000000,0x00000000}},	//   _se__em_, --, --, --, 
   {{0xec0b200a,0x00000000,0x00000000,0x00000000}},	//   _वालों__के_, --, --, --, 
   {{0xa9ba2004,0x93eaa015,0x9be78006,0xc3fa400b}},	//   _kayehova_, _gambar__buat_, _འཁྲིལ__ཏེ_, _pawulo_, 
   {{0x225ac004,0x8d42c002,0x00000000,0x00000000}},	//   _imele_, _информац, --, --, 
   {{0xc249801d,0x52a34011,0x64854018,0x12d4200e}},	//   _terma_, _procedem, _apesar__de_, _telefony__apple_, 
   {{0x1208000f,0x00000000,0x00000000,0x00000000}},	//   _ngithi__kini_, --, --, --, 
   {{0xc27ec02a,0xeaa36013,0x5ef42028,0x6ac82006}},	//   _uten_, _अच्छा_, _archivos_, _གཟུག_, 
   {{0x2d69800f,0x00000000,0x00000000,0x00000000}},	//   _akumelwe_, --, --, --, 
   {{0x99f4a018,0x526cc025,0x9495e005,0x4231200e}},	//   _você_, _dados_, _på__ei_, _sekcí__přihlási, 
   {{0x284b0009,0x7d9bc003,0x92c90002,0x00000000}},	//   _sommerhu, _ཕུན__ཚོགས_, _на__тему_, --, 
   {{0x42cac019,0x00000000,0x00000000,0x00000000}},	//   _bildet_, --, --, --, 
   {{0x137b0025,0x00000000,0x00000000,0x00000000}},	//   _citando_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x42252009,0x9b8d600a,0x00000000,0x00000000}},	//   _tryk_, _छह_, --, --, 
   {{0x33e4a00e,0x4503200e,0x46e7c002,0x00000000}},	// [1da0] _dětmi_, _se__můžete_, _разлога_, --, 
   {{0x398b4024,0x9c68000f,0x00000000,0x00000000}},	//   _uveče_, _bokuthi_, --, --, 
   {{0x87676022,0x00000000,0x00000000,0x00000000}},	//   _में__अपना_, --, --, --, 
   {{0x2d8f2029,0xc2520003,0xf2b62003,0x00000000}},	//   _དབུས_, _དགོན__པའི_, _པར__འོད_, --, 
   {{0xec68000f,0x92026012,0x7ed24002,0x00000000}},	//   _wokuthi_, _firiem_, _да__те_, --, 
   {{0x62d94025,0xa167c002,0x00000000,0x00000000}},	//   _defesa_, _примам_, --, --, 
   {{0xb9d5204f,0xa47a003c,0xcb8d0003,0xc3ac600e}},	//   _सहायता_, _reprezen_bih_, _ཟད_, _koupit_, 
   {{0x49d0400e,0x00000000,0x00000000,0x00000000}},	//   _vzdělává, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x0c68000f,0x24ab800b,0xc4438015,0xdb45a003}},	//   _yokuthi_, _igihe__yar_, _kpr_, _ཅེས__གསུངས_, 
   {{0x22df2018,0x00000000,0x00000000,0x00000000}},	//   _voltar__para_, --, --, --, 
   {{0xacd1800a,0x086b600a,0x00000000,0x00000000}},	//   _जानेंभवि, _प्रमुख__ख़बरें_, --, --, 
   {{0x745a600b,0x00000000,0x00000000,0x00000000}},	//   _umutwe__wa_, --, --, --, 
   {{0xee35000d,0xebcf800c,0xc2622006,0x00000000}},	//   _millones_, _भोजपुर__के_, _ནའི__ཊེཊ_, --, 
   {{0x629c4006,0x0fc4600f,0x0c6a6012,0xaa8a800a}},	//   _སྐྱིད__དཔལ_, _ongokomo, _hlavné_, _से__कुछ_, 
   {{0x579d4003,0xe2d8400e,0x00000000,0x00000000}},	//   _སྤེལ__བྱེད_, _zapomenu_heslo_, --, --, 
   {{0x73c0c00b,0xac68000f,0x5a5e600e,0x00000000}},	// [1db0] _ibiganir_byose_, _sokuthi_, _vydáno_, --, 
   {{0xa872c002,0x547e0002,0x0a79600c,0x00000000}},	//   _могући_, _њихов_, _के__भोजशाला_, --, 
   {{0xb2ad600d,0x72bae00e,0x00000000,0x00000000}},	//   _que__tiene_, _příliš_, --, --, 
   {{0x83432022,0x5a9d600c,0x00000000,0x00000000}},	//   _संबंध_, _देखल__जाव_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7443800b,0x00000000,0x00000000,0x00000000}},	//   _fpr_, --, --, --, 
   {{0xba3cc031,0x92902035,0xb32d001d,0x42902018}},	//   _शोध_, _yeka_, _komen__kongsi_, _lojas_, 
   {{0x3ee30002,0xdc48400c,0xda35200b,0x1283a012}},	//   _они_, _लेके_, _muri__bibiliya_, _odpoveď__toto_, 
   {{0x6af2200f,0x00000000,0x00000000,0x00000000}},	//   _abafowab, --, --, --, 
   {{0x048e0009,0x19994012,0xd332002f,0x824f8003}},	//   _af__det_, _dieťa_, _deixe_, _འཇུག__ཐུབ_, 
   {{0xe1e4e00a,0x228d800f,0x00000000,0x00000000}},	//   _फोटो__धमाल_, _benkolo_, --, --, 
   {{0x69f66018,0x00000000,0x00000000,0x00000000}},	//   _março_, --, --, --, 
   {{0x0c6a0002,0xd299a006,0x0378801f,0x00000000}},	//   _представ, _པའི__ཁྲི_, _kenalan_, --, 
   {{0x4d9fa00e,0xa8dfa00e,0xb0b4e012,0x00000000}},	//   _nějaké_, _nějaký_, _licencia__vyhraden, --, 
   {{0x341e4002,0x00000000,0x00000000,0x00000000}},	//   _освоји__једну_, --, --, --, 
   {{0x3493e019,0xc4b8401a,0xeacbc00e,0xebafe00c}},	//   _avisen__på_, _laga__av_, _základě_, _नारायण__के_, 
   {{0x6290201a,0x00000000,0x00000000,0x00000000}},	// [1dc0] _veka_, --, --, --, 
   {{0x031d601f,0x92dd600b,0xee59e002,0xfbb9c003}},	//   _percuma_, _akwiye__kuva_, _иконицу__да_, _དེ__དང_, 
   {{0x42902028,0xc29fc011,0xb365800f,0x12cf600b}},	//   _deja_, _feijóo_, _imigomo_, _muri__leta_, 
   {{0xb480c009,0x345b8012,0x00000000,0x00000000}},	//   _ting__at_, _prihlást_sa_, --, --, 
   {{0xa373e01d,0x94994007,0x7d22e018,0x00000000}},	//   _maklumat__yang_, _memapark, _pagsegur, --, 
   {{0xc463402a,0xa290a015,0x9414e00e,0xf4778009}},	//   _innlegg__av_, _terkait_, _pro__děti_, _søger__der_, 
   {{0xc394a00e,0x8bdec003,0x00000000,0x00000000}},	//   _nejsou_, _བའི__ལང_, --, --, 
   {{0x687e0012,0x2376c002,0xcccfa002,0x1cd6c002}},	//   _prehliad, _српском_, _по__ознакама_, _српским_, 
   {{0x6f39601d,0x9b946006,0x1568c00b,0x00000000}},	//   _terutama, _ཨིནམ__ལས_, _kubwiriz, --, 
   {{0xec0b8006,0x00000000,0x00000000,0x00000000}},	//   _ཕྱག__ལཱ_, --, --, --, 
   {{0x72dc2011,0xc252a00b,0x00000000,0x00000000}},	//   _de__auga_, _ko__hari_, --, --, 
   {{0x634b001a,0x00000000,0x00000000,0x00000000}},	//   _biletet_, --, --, --, 
   {{0xc200c015,0x12a16003,0x00000000,0x00000000}},	//   _miliar_, _ཚུལ__ཆེད_, --, --, 
   {{0x2f0ce020,0x7f46a006,0xa46c200e,0x12aea00e}},	//   _འགྲུལ_, _ཐུང__སྒྲུབ_, _předpokl, _doba__méně_, 
   {{0x6c49200a,0x0a154006,0xa2d5a011,0x3f15a00f}},	//   _मेरे_, _འབད__ནིའི_, _para__súa_, _nendodan, 
   {{0x32902018,0x3bb9000a,0xc3c1a018,0x00000000}},	//   _seja_, _हैं__जो_, _sem__aviso_, --, 
   {{0x382ae006,0xa3efc009,0xd3876018,0x00000000}},	// [1dd0] _དྲན__བརྩི_, _spørgsmå_svar_, _quarta_, --, 
   {{0xd757c00c,0x00000000,0x00000000,0x00000000}},	//   _विद्वान__शामिल_, --, --, --, 
   {{0x62902018,0x9347a00a,0xab010002,0x00000000}},	//   _veja_, _में__अपनी_, _подели__подели_, --, 
   {{0xc7666014,0xa7f44027,0x00000000,0x00000000}},	//   _में__गंगा_, _vykonáva, --, --, 
   {{0xd2e22002,0x4ccac003,0x47cac006,0x5d8ac003}},	//   _večernje__novosti_, _འདིར_, _འདྲཝ_, _འདིས_, 
   {{0x4286800e,0x566fa00e,0x0da9200f,0x00000000}},	//   _zprávy__domova_, _poslední__příspěve, _yini__okumelwe_, --, 
   {{0x04a86018,0x8e922002,0x00000000,0x00000000}},	//   _postado__por_, _потребе_, --, --, 
   {{0x6d74800f,0x00000000,0x00000000,0x00000000}},	//   _ngena__ngemvume_, --, --, --, 
   {{0x0282e034,0x05a9c002,0x00000000,0x00000000}},	//   _menu__item_, _великог_, --, --, 
   {{0x42b50016,0x33cb8011,0x7a6d600a,0xabc50003}},	//   _bildene_, _de__ferrol_, _हुए__हैं_, _བཀག__ཉར_, 
   {{0xb3f9600e,0x726d000b,0xe8faa00a,0x00000000}},	//   _velmi__dobrý_, _yobowe_, _मेरा__प्रोफाइल_, --, 
   {{0x02b62003,0xd252a00b,0x00000000,0x00000000}},	//   _གླ__ཡོད_, _ko__yari_, --, --, 
   {{0xc2994003,0x0dea2003,0xe04d2002,0x00000000}},	//   _པའི__ཟིན_, _བཟོ__དགོས_, _врста_, --, 
   {{0xb2888003,0xd79fa012,0x1befa00c,0xb2598013}},	//   _ཆགས__ཀྱི_, _podujati, _बा__जे_, _वाशिंगटन_, 
   {{0xa2bb2006,0x8e296002,0x00000000,0x00000000}},	//   _པོ__ཏའི_, _наш_, --, --, 
   {{0xbee32002,0xdc90800e,0x00000000,0x00000000}},	//   _зна_, _vše__heureka_, --, --, 
   {{0x4620200b,0x249c2002,0x00000000,0x00000000}},	// [1de0] _itangiri, _план_, --, --, 
   {{0x6ff24018,0x4e9a4002,0x00000000,0x00000000}},	//   _curtir__comentar_, _што__ће_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x02ce000b,0x00000000,0x00000000,0x00000000}},	//   _muri__sinai_, --, --, --, 
   {{0x66f9e00c,0x0344a01a,0x1eb0800b,0x00000000}},	//   _भासा_, _attende_, _umurenge_, --, 
   {{0x2ecec002,0xd2e3c00b,0xb20e800b,0xb866e00a}},	//   _му__је_, _buhinde_, _munani__misiri_, _करेगी_, 
   {{0x52026012,0xb31ba012,0xfc23200c,0x00000000}},	//   _mesiac_, _rýchle_, _तक__रहे_, --, 
   {{0xba9ba022,0x74366009,0x00000000,0x00000000}},	//   _में__काम_, _der__blev_, --, --, 
   {{0x84760027,0x00000000,0x00000000,0x00000000}},	//   _cena__eur_, --, --, --, 
   {{0x6cbd4014,0x95dfc003,0x00000000,0x00000000}},	//   _कथा__संग्रह_, _བསླབ_, --, --, 
   {{0x5378a01d,0x00000000,0x00000000,0x00000000}},	//   _bekalan_, --, --, --, 
   {{0xde398015,0xa2410003,0x00000000,0x00000000}},	//   _penasara, _པའི__རྩོམ_, --, --, 
   {{0x68020006,0xc2498024,0x7956e012,0x00000000}},	//   _པར__སྟོན_, _pesme_, _najlacne, --, 
   {{0x3a60a00c,0x00000000,0x00000000,0x00000000}},	//   _आके__आपन_, --, --, --, 
   {{0xc6c10006,0x42e88018,0x00000000,0x00000000}},	//   _ཕན__འདེབས_, _cozinha_, --, --, 
   {{0xd290401d,0x547f000b,0x00000000,0x00000000}},	//   _solat_, _ukwakira__ku_, --, --, 
   {{0x8641e01d,0x771e000c,0x00000000,0x00000000}},	// [1df0] _perkahwi, _गूढ़_, --, --, 
   {{0x4d492002,0x39ea400f,0x00000000,0x00000000}},	//   _пре_, _umoya__kajehova_, --, --, 
   {{0x5b7e8006,0xd2926018,0x4c83200c,0x00000000}},	//   _ཆོས__རྫོང_, _gerais_, _गइल__होखे_, --, 
   {{0xf1ba604c,0x005a600c,0xf2ca800f,0x7bb98003}},	//   _पावल_, _पावस_, _ukuthi__kumelwe_, _ཁོ__རང_, 
   {{0x12904018,0x63ea801f,0xdbf7e00c,0x00000000}},	//   _pela_, _doktor_, _लागू__करे_, --, 
   {{0x9593600b,0x00000000,0x00000000,0x00000000}},	//   _ribireng_hakoresh, --, --, --, 
   {{0x14cba002,0x00000000,0x00000000,0x00000000}},	//   _документ, --, --, --, 
   {{0x226ec015,0x7bab800a,0x6d20200b,0x00000000}},	//   _lowongan__kerja_, _लोगों__ने_, _ishinzwe_, --, 
   {{0xc952c01a,0xf4a88018,0x00000000,0x00000000}},	//   _lærarar_, _informe__seu_, --, --, 
   {{0xa2d5800e,0x031d0018,0x2636200c,0x00000000}},	//   _všech_, _deste__produto_, _अउर__शायदे_, --, 
   {{0xbbcea006,0x13eb4027,0xa428800b,0x00000000}},	//   _གཞན__ཚུ_, _vsetko_, _yari__afite_, --, 
   {{0x14b66009,0x00000000,0x00000000,0x00000000}},	//   _nyt__kl_, --, --, --, 
   {{0x1386c028,0x1c41400f,0xa2bd400f,0x00000000}},	//   _madre_, _izinto__ezinkulu_, _ngo__kuya_, --, 
   {{0x53f8201f,0x2c6fa00b,0x00000000,0x00000000}},	//   _semula_, _ibirimo_, --, --, 
   {{0x9be90044,0xc428800a,0xea3e4013,0x0c06200b}},	//   _अमेरिकी_, _इटावा__इलाहाबाद_, _भूल_, _ibisasu_, 
   {{0x92904011,0x73eb402a,0x00000000,0x00000000}},	//   _polas_, _godtar_, --, --, 
   {{0x0316000f,0x3a3ce00a,0x00000000,0x00000000}},	// [1e00] _usizo_, _वोट_, --, --, 
   {{0x9929c00e,0x0bbc600a,0x00000000,0x00000000}},	//   _značky__mobilní_, _रविवार__को_, --, --, 
   {{0xf2906012,0x00000000,0x00000000,0x00000000}},	//   _mena_, --, --, --, 
   {{0x89f4a012,0x2859e00e,0x00000000,0x00000000}},	//   _robí_, _jakékoli, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xf313e039,0xc24e4003,0x00000000,0x00000000}},	//   _mencoba_, _འུར_, --, --, 
   {{0x2243c003,0x0d69800f,0xe2926011,0x329bc012}},	//   _ཞེས_, _okumelwe_, _xerais_, _niekedy_, 
   {{0xebb0e00c,0xb200e012,0xca672002,0x00000000}},	//   _रामायण__के_, _meniny_, _знања_, --, 
   {{0x2e726022,0xb59bc015,0xc4952011,0x6a28a002}},	//   _इंद्र_, _dibutuhk, _se__non_, _директор, 
   {{0xaa3d205e,0x3431600b,0x549c600b,0xfbda200c}},	//   _होत_, _bishobok, _yo__ku_, _करा__से_, 
   {{0x4ba06011,0x9320c015,0x7470600b,0x00000000}},	//   _licenza__recoñece, _proyek_, _kimwe__mu_, --, 
   {{0x749c600b,0x1bb5200c,0xce612002,0x00000000}},	//   _yo__mu_, _अतने__ना_, _иде_, --, 
   {{0x1bcc400a,0xec2ae01a,0xd045400b,0x29b3000b}},	//   _आने_, _dei__viktigas, _marushan, _mu__bwongere, 
   {{0x700a0002,0x00000000,0x00000000,0x00000000}},	//   _викимеди, --, --, --, 
   {{0x5c680035,0xc2994003,0xfbe3a00c,0x2d20200b}},	//   _nokuthi_, _གྱི__ཟིན_, _ही__रहे_, _ushinzwe_, 
   {{0xd4b7a004,0x9bc52014,0x7c48800c,0x93b6000b}},	//   _kwandule__ke_, _रहे__कि_, _देके_, _iravuga_, 
   {{0xdb8d8003,0x00000000,0x00000000,0x00000000}},	// [1e10] _གད_, --, --, --, 
   {{0x648e6009,0xe24a8018,0xf42bc00f,0x7c49600c}},	//   _af__de_, _clique__aqui_, _incazelo_, _भइले_, 
   {{0x7aa6a014,0xc299c003,0x00000000,0x00000000}},	//   _के__सम्मान_, _བའི__ཟིན_, --, --, 
   {{0x44ae8009,0x64996008,0xe2dda00d,0x84a44012}},	//   _seneste__nyt_, _condició_de_, _por__otro_, _neobmedz, 
   {{0x8c488022,0xc295a018,0xeff0800e,0x00000000}},	//   _देखे_, _com__juros_, _nemáš__přihlašo, --, 
   {{0xaf470037,0x1456a00f,0xea9b0012,0x2301000b}},	//   _interesa_cercanos_, _lawo__mazwi_, _príspevk_inzeráto, _ako__karere_, 
   {{0xb2a38003,0x73f9a00b,0x00000000,0x00000000}},	//   _སྤོ__དཀར_, _bavuze_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xbfeba00a,0x13b6000b,0x00000000,0x00000000}},	//   _मुलाकात_, _aravuga_, --, --, 
   {{0x32d9c00f,0x207da002,0x00000000,0x00000000}},	//   _ezinhle_, _коментар_користећ, --, --, 
   {{0xcbb0a003,0x00000000,0x00000000,0x00000000}},	//   _ཡག__པོ_, --, --, --, 
   {{0x6492a00d,0x00000000,0x00000000,0x00000000}},	//   _búsqueda__de_, --, --, --, 
   {{0x6273c009,0x427ea009,0x00000000,0x00000000}},	//   _længe_, _odense_, --, --, 
   {{0x87c74012,0x6b074027,0x5248600b,0xa2410003}},	//   _pripravi, _priprave, _ngoma_, _གྱི__རྩོམ_, 
   {{0xe3f9a02b,0xaeeee002,0x00000000,0x00000000}},	//   _yavuze_, _је__још_, --, --, 
   {{0x6cfa6002,0x50c92002,0x00000000,0x00000000}},	//   _придружи, _две__године_, --, --, 
   {{0x57a4a00a,0x00000000,0x00000000,0x00000000}},	// [1e20] _मुद्रण__निर्यात_, --, --, --, 
   {{0xa387400d,0x00000000,0x00000000,0x00000000}},	//   _fuerza_, --, --, --, 
   {{0x74b4c00b,0x00000000,0x00000000,0x00000000}},	//   _moshi__mu_, --, --, --, 
   {{0xd3ea0025,0x00000000,0x00000000,0x00000000}},	//   _jeito_, --, --, --, 
   {{0xb3eac02f,0x00000000,0x00000000,0x00000000}},	//   _voltar_, --, --, --, 
   {{0xcc774014,0x53184018,0x00000000,0x00000000}},	//   _पूर्वज_, _válidos__somente_, --, --, 
   {{0x22498015,0x1254e006,0xcb390003,0x62cfc00e}},	//   _resmi_, _ཡིག__ཨིང_, _གེ__མཆོག_, _později_, 
   {{0x84ac6005,0x00000000,0x00000000,0x00000000}},	//   _det__eg_, --, --, --, 
   {{0xc4b4c019,0x29f58011,0x6a5d6012,0xf2530003}},	//   _siden__av_, _xosé_, _apríla_, _ཡོད__མཁན_, 
   {{0x0eae001d,0xf2a7600b,0xcbe0000a,0x00000000}},	//   _syarikat_, _ntabwo_, _हाल__ही_, --, 
   {{0x5915000e,0x3292600b,0xab0ce00f,0x1a95800c}},	//   _další__články_, _batatu_, _iqiniso__lebhayib, _बा__अगर_, 
   {{0x020e2002,0x6a964022,0x42fca007,0x627e801d}},	//   _сада_, _से__बढ़_, _nasihat_, _puan_, 
   {{0xe25ac004,0xb42a802e,0xd9d2600b,0x0958000a}},	//   _umele_, _sve__poruke_, _gukomeza_, _कैसेखोजे, 
   {{0x5bb8c013,0x00000000,0x00000000,0x00000000}},	//   _शब्द__या_, --, --, --, 
   {{0x55b6600b,0x073fc029,0x73574028,0xfc0f200a}},	//   _amashaki_mashyash, _བསོད_, _agregar_, _पहले__से_, 
   {{0x7a692022,0xc978600e,0x9b8d2003,0x00000000}},	//   _अनुसूची_, _policist, _མྱ_, --, 
   {{0x03ed2012,0x8cf1a00e,0x6cab0037,0x2fab600a}},	// [1e30] _kozmetik, _přehled_, _completa__descripc, _दर्शन__क्रिकेट_, 
   {{0x52d9200c,0x3079400f,0x6efc600a,0x00000000}},	//   _मगही_, _abantu__bakajeho, _देखकर_, --, 
   {{0x626c6012,0xe480402a,0x00000000,0x00000000}},	//   _áno_, _sted__er_, --, --, 
   {{0x0a3e405f,0xb3ea0011,0x9e6b000b,0x00000000}},	//   _बंद_, _xeito_, _mwaka__yarabaye_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6fc4600f,0x00000000,0x00000000,0x00000000}},	//   _engokomo, --, --, --, 
   {{0x5a49c00a,0xca4ac00a,0x00000000,0x00000000}},	//   _की__वजह_, _राय__दें_, --, --, 
   {{0x6b98a00a,0x1ad20014,0x8aab800c,0x00000000}},	//   _को__भी_, _खर्चा_, _फ़िल्मन_, --, 
   {{0x250ac00c,0x7709c002,0x95a9c002,0x00000000}},	//   _मिथिलांच, _једини_, _једино_, --, 
   {{0x347c600e,0xf4dc2002,0x00000000,0x00000000}},	//   _srovnání__kč_, _још__мултимед, --, --, 
   {{0x9400c002,0x00000000,0x00000000,0x00000000}},	//   _једна_, --, --, --, 
   {{0x6b15e031,0x6bd8200a,0x64ba0011,0xbfc0403d}},	//   _tersedia_, _आज__भी_, _obxectiv_de_, _produktu__perfektn, 
   {{0x8a87400a,0x1fd2a009,0x00000000,0x00000000}},	//   _ने__कहा_, _træner_, --, --, 
   {{0xa2538003,0x0aacc00c,0x00000000,0x00000000}},	//   _བཟུང__བྱས_, _सांच__में_, --, --, 
   {{0xf400a002,0xe290a00b,0xbd9fe01a,0xb29bc00a}},	//   _datum__upisa_, _reba_, _oppgåver_, _विशेषाधि_निवेदन_, 
   {{0xf290a012,0x0480c018,0x00000000,0x00000000}},	//   _seba_, _sexo__com_, --, --, 
   {{0x0290a024,0x00000000,0x00000000,0x00000000}},	// [1e40] _deca_, --, --, --, 
   {{0xf2bca003,0xd2f6e00c,0x077f0002,0x00000000}},	//   _པོ__རེད_, _कर__चोरी_, _нормално_комуника, --, 
   {{0x9ba06002,0x00000000,0x00000000,0x00000000}},	//   _инфо_, --, --, --, 
   {{0x8b8d4029,0x134b402d,0x3bb5e00c,0x0d02400e}},	//   _བྱ_, _nitko__nije_, _कइले__बा_, _nejlépe_, 
   {{0x72428029,0x3491c012,0x740d000e,0x43566018}},	//   _དམར_, _ktorý__sa_, _francouz, _desejos_, 
   {{0x5289a021,0xf38b0018,0x00000000,0x00000000}},	//   _མངའ__བདག_, _recados__imagens_, --, --, 
   {{0x02e0e00b,0xb2890003,0x00000000,0x00000000}},	//   _ibiganir_vyacu_, _ཀླད__ཀྱི_, --, --, 
   {{0x2495600b,0x2b2a600a,0xb357800f,0x52af8006}},	//   _ni__ko_, _गुदगुदी__पर्यटन_, _isifiso_, _མི__དུག_, 
   {{0xc81fc034,0xd58fa015,0x9df5a003,0x00000000}},	//   _er__tilgjeng, _sertifik, _མི__གྲངས_, --, 
   {{0xf3f1c00f,0xd2d88012,0x7c4e800a,0x00000000}},	//   _iselulek, _pokeci_, _चलें_, --, 
   {{0x1493201a,0x8385600a,0xfa9ca00c,0x00000000}},	//   _me__har_, _चम्पावत__चमोली_, _एगो__कदम_, --, 
   {{0x52cac00f,0x94600018,0x00000000,0x00000000}},	//   _eceleni_, _não__sei_, --, --, 
   {{0x9a99e012,0xc2ed000c,0x00000000,0x00000000}},	//   _náhradné_, _के__खुशी_, --, --, 
   {{0xb3032011,0x86446035,0x2386a009,0xfb93a003}},	//   _comparti_igual_, _ngokwesi, _aldrig_, _གཞུང__ལན_, 
   {{0x8d378040,0x5daaa00b,0x00000000,0x00000000}},	//   _moć_, _imyigara, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x82da601a,0xd147c002,0x02772003,0x00000000}},	// [1e50] _noregs_, _написао_, _ནས__ཡོད_, --, 
   {{0x437a6045,0x538fa005,0x00000000,0x00000000}},	//   _zadarmo_, _til__meny_, --, --, 
   {{0x24416012,0x929ca003,0x00000000,0x00000000}},	//   _vo__svete_, _བཅུའི__དུས_, --, --, 
   {{0x5e4a2009,0x00000000,0x00000000,0x00000000}},	//   _præsenta, --, --, --, 
   {{0xf290c015,0xc2d9e00d,0x84538009,0x00000000}},	//   _beda_, _mejorar_, _har__haft_, --, 
   {{0x2290a003,0x00000000,0x00000000,0x00000000}},	//   _དཔྱད__གཞི_, --, --, --, 
   {{0x96336012,0xac40200e,0xcb96400a,0x00000000}},	//   _oznámeni, _seznam__produktů_, _वेबसाइट__खोलने_, --, 
   {{0x0495600b,0x203c4002,0x48dda00a,0x00000000}},	//   _ni__yo_, _користећ, _पिछलीस्ट, --, 
   {{0x2ff8200c,0x00000000,0x00000000,0x00000000}},	//   _के__स्थापना_, --, --, --, 
   {{0x4392c010,0x244b200b,0x00000000,0x00000000}},	//   _en__adresse_, _ku__nshuro_, --, --, 
   {{0x53f46026,0xc2024012,0xb932a012,0x4f57000f}},	//   _hurtig_, _fotiek_, _zrušiť_, _injongo__kankulun, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x3f12e009,0x42d9c02c,0x54440018,0x00000000}},	//   _studeren, _imwe_, _de__água_, --, 
   {{0x4b562002,0x00000000,0x00000000,0x00000000}},	//   _информац_политика_, --, --, --, 
   {{0x247c403c,0x00000000,0x00000000,0x00000000}},	//   _onaj__ko_, --, --, --, 
   {{0xe2ff0011,0x93ea4008,0x6b62400a,0xe76b8003}},	//   _comentar__desde_, _celta_, _मैंने_, _དྲ__མཐུད_, 
   {{0x93eae004,0x62016035,0xa641e01d,0x00000000}},	// [1e60] _gqitha_, _amakhasi_, _berkahwi, --, 
   {{0x42ca0037,0xfea30002,0x07e54003,0x00000000}},	//   _este__lugar_, _се__или_, _འཇམ__མགོན_, --, 
   {{0x48fe200c,0x00000000,0x00000000,0x00000000}},	//   _भोज__भोजपुर_, --, --, --, 
   {{0xa27ec00d,0x00000000,0x00000000,0x00000000}},	//   _buen_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x949ce009,0x026c400e,0xf493201a,0xe5d16012}},	//   _at__få_, _bylo_, _ho__var_, _nemôže_, 
   {{0xa49ce009,0x4661400e,0x50bbc00a,0x00000000}},	//   _at__gå_, _zaměstna, _जालंधर_, --, 
   {{0x54af600e,0xd30f802b,0x00000000,0x00000000}},	//   _že__se_, _ibibazo_, --, --, 
   {{0x1290c045,0x89462002,0x00000000,0x00000000}},	//   _teda_, _захтев_, --, --, 
   {{0x74444009,0x1224801a,0x62f42009,0x44a92011}},	//   _op_, _rekkje_, _at__skabe_, _despois__da_, 
   {{0x3bcf200c,0x7067e00c,0x00000000,0x00000000}},	//   _भईल__एह_, _एहसास__कइलस_, --, --, 
   {{0x5d33a034,0x3eb96002,0x16fe200c,0x2e68e00a}},	//   _menneske_, _бих_, _कोना_, _सेक्_, 
   {{0x7c9cc00b,0x3343000e,0x00000000,0x00000000}},	//   _rujejwe__kwubahir, _svatební_, --, --, 
   {{0xb47da025,0x6b2a2006,0x5a7da00f,0x4307200f}},	//   _que__já_, _སྨོང_, _ukwazisa_, _endlini__ngendlu_, 
   {{0xf66a6008,0x1903800e,0xeda22002,0x00000000}},	//   _de__exposici, _školní_, _постао_, --, 
   {{0x2be9c003,0x00000000,0x00000000,0x00000000}},	//   _སྤེན__ཉི_, --, --, --, 
   {{0x9741e002,0x00000000,0x00000000,0x00000000}},	// [1e70] _основне_, --, --, --, 
   {{0x7201a00b,0x2273c009,0x9c5d2018,0x84ad6005}},	//   _akwiye_, _tænke_, _postado_, _kan__eg_, 
   {{0x5968000d,0xbca3200a,0x00000000,0x00000000}},	//   _reciente, _ने__अपने_, --, --, 
   {{0x51f44027,0x449a001d,0x00000000,0x00000000}},	//   _nevhodné_, _berasask, --, --, 
   {{0x83ea2012,0x927ec011,0xb4b18011,0x44a90011}},	//   _tejto_, _quen_, _de__decembro_, _desta__cun_, 
   {{0x84ace005,0xfc47400e,0x00000000,0x00000000}},	//   _har__eg_, _různé_, --, --, 
   {{0x846f2019,0x945d2018,0x12d90018,0x21ccc002}},	//   _les__mer_, _alteraçã, _receba_, _задржана_, 
   {{0xc152a012,0x3e2cc002,0x6477e012,0x00000000}},	//   _októbra_, _влада_, _úspešne_, --, 
   {{0x0bb0000a,0xb4b2c009,0xfbfa4006,0x2bdf601a}},	//   _लोगों__को_, _efter__at_, _ཚུ__དང_, _kommunar__diskuter, 
   {{0x3798203a,0x3cc0e003,0x2b07c002,0x00000000}},	//   _གཞོན_, _དཔྱད__གཞིའི_, _видели_, --, 
   {{0x96fea00a,0x00000000,0x00000000,0x00000000}},	//   _झूठा_, --, --, --, 
   {{0xa4444015,0xef422012,0x5e626012,0x00000000}},	//   _rp_, _späť_, _kvôli_, --, 
   {{0xc3a2201d,0x00000000,0x00000000,0x00000000}},	//   _tempoh_, --, --, --, 
   {{0xfdd04003,0xb9f5e00e,0x00000000,0x00000000}},	//   _བེད__སྤྱོད_, _poté_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x1cc3c037,0xebaf000c,0x3e260003,0x825a200f}},	// [1e80] _ni__ofertes_, _लक्ष्मण__के_, _དུ__འགྲོ_, _inceku__yakho_, 
   {{0x6212c018,0xb27f4028,0x0257c00e,0x00000000}},	//   _mulher_, _tienda_, _díly_, --, 
   {{0x82e5e039,0x03ac6015,0x00000000,0x00000000}},	//   _lainnya_, _maupun_, --, --, 
   {{0xfcf1800b,0x9a9f0002,0x32cf600c,0x00000000}},	//   _igiteker, _адресе_, _गजेटियर_, --, 
   {{0xb22f8012,0xb3368018,0xea50c00b,0x00000000}},	//   _pre__deti_, _você__deve_, _wa__gatandat, --, 
   {{0xea3d200c,0xf248a003,0x00000000,0x00000000}},	//   _होई_, _ཡིག__བཅར_, --, --, 
   {{0x17f4c003,0x00000000,0x00000000,0x00000000}},	//   _མཚོ__སྔོན_, --, --, --, 
   {{0x228ec002,0xfb8e600c,0x00000000,0x00000000}},	//   _тражи_, _इह_, --, --, 
   {{0x12b8a012,0xbbe34003,0x00000000,0x00000000}},	//   _prihlási_alebo_, _པའི__ཕམ_, --, --, 
   {{0xc2918025,0x00000000,0x00000000,0x00000000}},	//   _foram_, --, --, --, 
   {{0xc493600d,0x5d12e002,0x4e820002,0x00626012}},	//   _es__la_, _их_, _ја__сам_, _zoznam__produkto, 
   {{0xec07c00c,0x749ce00b,0x00000000,0x00000000}},	//   _हमनी__के_, _zo__mu_, --, --, 
   {{0xe3ea6028,0xec0a400a,0x9176000a,0x8db98002}},	//   _venta_, _कॉमेंट__के_, _अमृतसर__अहमदाबाद_, _википода, 
   {{0x57472003,0x00000000,0x00000000,0x00000000}},	//   _གཏུག__བྱེད_, --, --, --, 
   {{0x5413c002,0x5492400b,0x00000000,0x00000000}},	//   _повезао_, _kugeza__ku_, --, --, 
   {{0xd290e00d,0x00000000,0x00000000,0x00000000}},	//   _hogar_, --, --, --, 
   {{0x24ad6009,0x00000000,0x00000000,0x00000000}},	// [1e90] _ind__og_, --, --, --, 
   {{0x9875200a,0x0243a003,0x00000000,0x00000000}},	//   _जमशेदपुर_, _ངེད_, --, --, 
   {{0xbd600008,0x00000000,0x00000000,0x00000000}},	//   _comunida_autónoma_, --, --, --, 
   {{0x7416000b,0xd2edc00a,0x00000000,0x00000000}},	//   _rupapuro__byose_, _होने__पाएं_, --, --, 
   {{0x23048011,0xa8eac002,0x00000000,0x00000000}},	//   _poder__votar_, _на__фејсбук_, --, --, 
   {{0xf2ae6002,0x819da037,0xf2842002,0x00000000}},	//   _izvor__tanjug_, _es__confiabl, _вероватн, --, 
   {{0xa493600b,0xebbcc003,0x4345201d,0x990c800e}},	//   _na__za_, _ལི__ཐང_, _khidmat_, _úvodní_, 
   {{0xfa056012,0x00000000,0x00000000,0x00000000}},	//   _lepšie_, --, --, --, 
   {{0xc4604018,0x00000000,0x00000000,0x00000000}},	//   _não__tem_, --, --, --, 
   {{0x446e801d,0xc271e003,0xf290e018,0x00000000}},	//   _laman__ini_, _ཟླ__བཞི_, _jogar_, --, 
   {{0x5291000b,0x829ce006,0x0255c002,0x7aa8800a}},	//   _meza_, _ཞབས__ཏོག_, _бити__објављен, _देते__हैं_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6e28e002,0x5704400c,0xe2428003,0x00000000}},	//   _са_, _हस्तांतर, _ནའང_, --, 
   {{0x6291002b,0xab4b4011,0xd3b9602f,0x88dfc00a}},	//   _neza_, _unha__resposta_, _para__entrar_, _जालंधर__जोधपुर_, 
   {{0x34936027,0x7bdd400c,0x23ea000b,0xb46d2009}},	//   _by__sa_, _दक्षिण__एशिया_, _ifite_, _vigtigt__at_, 
   {{0xf292002d,0x747fe00b,0x37d6c003,0x00000000}},	//   _srpanj_, _muri__uwo_, _གནང__བཞིན_, --, 
   {{0x42e10034,0xbf348009,0x4504200e,0x00000000}},	// [1ea0] _sogndal_, _prøvet_, _si__můžete_, --, 
   {{0x3236201a,0x34746027,0x16ec4022,0x7387800e}},	//   _ikkje_, _som__sa_, _के__मंदिर_, _více__mpix_, 
   {{0xc290c007,0x2303001d,0x64ba4018,0x1200c009}},	//   _lelaki_, _pelawat_, _juros__de_, _boliga_, 
   {{0xd0c38002,0x00000000,0x00000000,0x00000000}},	//   _технолог, --, --, --, 
   {{0x327ea00e,0x00000000,0x00000000,0x00000000}},	//   _denní_, --, --, --, 
   {{0xbcc0a00a,0xc2fda018,0x2cf60003,0x00000000}},	//   _श्रेणिया, _aceitar_, _དྲ__སྒོར_, --, 
   {{0xaeee6002,0x48592018,0x38298003,0x00000000}},	//   _је__то_, _correios_, _ཡིག__འཕྲིན_, --, 
   {{0xa3ea000b,0x86606014,0x00000000,0x00000000}},	//   _afite_, _नापसंद_, --, --, 
   {{0xe4b1000b,0x00000000,0x00000000,0x00000000}},	//   _iterambe_ry_, --, --, --, 
   {{0x2e956002,0x2b6be018,0x00000000,0x00000000}},	//   _јер__је_, _gostaria_, --, --, 
   {{0xebbfc022,0x174ec002,0x61e7401c,0x00000000}},	//   _सिंह__के_, _право_, _चेहरे_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xebaa200e,0x2bbaa003,0x9102000a,0xa420001a}},	//   _obchodec, _བརྒྱུད__ལམ_, _आजमगढ़__इटावा_, _vart__skipa_, 
   {{0x438fe004,0x02e6a00b,0xb9d96002,0x00000000}},	//   _oonyana_, _cyane__cyane_, _шиптарск, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xfbdda003,0xcbd4200f,0xf243c003,0x00000000}},	//   _གཏུགས__པར_, _ngombuso_, _ཞེན_, --, 
   {{0xf2cae009,0x9931a00c,0x6bb8a00c,0x62882003}},	// [1eb0] _mindst_, _के__इतिहासका, _ओइसे__भी_, _འཇམ__དཔལ_, 
   {{0xf4a4c00b,0x8b2f8002,0x00000000,0x00000000}},	//   _ikibazo__cy_, _историје_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x526c800e,0x7be58003,0x00000000,0x00000000}},	//   _pokoje_, _མདོ__ངག_, --, --, 
   {{0x8742800a,0x00000000,0x00000000,0x00000000}},	//   _बनिए__अपना_, --, --, --, 
   {{0xe3ea000b,0x00000000,0x00000000,0x00000000}},	//   _ufite_, --, --, --, 
   {{0xd3eda00e,0x72a3e00e,0x00000000,0x00000000}},	//   _kosmetik, _by__měl_, --, --, 
   {{0xfe1c6011,0x00000000,0x00000000,0x00000000}},	//   _estar__rexistra, --, --, --, 
   {{0x0f0cc029,0x3b96a011,0x00000000,0x00000000}},	//   _འགྱུར_, _especiai_ligazón_, --, --, 
   {{0xc453a01a,0xe366e018,0x00000000,0x00000000}},	//   _det__vart_, _semelhan_baixar_, --, --, 
   {{0x113c0012,0x3be6a00c,0xd7522002,0x00000000}},	//   _posledné_, _से__एह_, _сајта__корисна_, --, 
   {{0xf30b0031,0xac300002,0x00000000,0x00000000}},	//   _serupa__dengan_, _четвртак_, --, --, 
   {{0x5ed4e002,0x2e39e018,0x9ff8200a,0xd46ba011}},	//   _ко_, _cadastra, _वाराणसी_, _mentres__que_, 
   {{0x6ba7000a,0xb31f200e,0xbae84002,0x2bc2e00a}},	//   _है__वह_, _produktů__více_, _од__одговора_, _किए__गए_, 
   {{0x513c000e,0x99f7400b,0x00000000,0x00000000}},	//   _poslední_, _kiliziya_, --, --, 
   {{0xaacb601a,0x7c02c006,0x00000000,0x00000000}},	//   _sommaren_, _ཨེ__ཤར_, --, --, 
   {{0x2395e01b,0xbd36800f,0x73f9200b,0x00000000}},	// [1ec0] _ukusa_, _ezincane_, _incuti_, --, 
   {{0x023aa00b,0x8c8fa00c,0x00000000,0x00000000}},	//   _hamwe__igihe_, _काम__नइखे_, --, --, 
   {{0xda33c022,0x547ac00e,0x00000000,0x00000000}},	//   _जड़_, _nebo__se_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xb9d22002,0x53fa602e,0xef02e003,0xe822e006}},	//   _neregist, _udruga_, _སྒྲུང_, _སྒྲིང_, 
   {{0x7613000b,0xf320a00f,0x731fc003,0x00000000}},	//   _barenga__barapfuy, _noma__ngabe_, _བསྟར_, --, 
   {{0x1e656015,0x3ed1800f,0x9ba44003,0x00000000}},	//   _dan__ketentua, _ngezikha, _ཁང__ལས_, --, 
   {{0x43ea6011,0x9582800b,0x00000000,0x00000000}},	//   _xente_, _iyinkuru__ibirimwo_, --, --, 
   {{0xf3a5601a,0xb22ac002,0xbbcc000c,0x4ed56002}},	//   _kjelder__endre_, _додај_, _ईहे_, _ли__ће_, 
   {{0x147d2040,0x00000000,0x00000000,0x00000000}},	//   _često__postavlj, --, --, --, 
   {{0x07342022,0x03ea6018,0xff47600c,0x00000000}},	//   _दिल्ली__पुलिस_, _tente_, _के__संविधान_, --, 
   {{0x6b8ea00a,0xa2912011,0xf48e201a,0x00000000}},	//   _वह_, _sexa_, _då__han_, --, 
   {{0x22742037,0xcac6e002,0x00000000,0x00000000}},	//   _nuevo__email_, _аутоматс_постати_, --, --, 
   {{0x72dda060,0x00000000,0x00000000,0x00000000}},	//   _खोजी_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xbfb6000e,0xb4a32018,0x00000000,0x00000000}},	//   _ještě_, _escreva__um_, --, --, 
   {{0x693fe01a,0xd294e003,0x00000000,0x00000000}},	// [1ed0] _tenester__rettsleg, _ཤིག__ཡིན_, --, --, 
   {{0x2473200b,0x0248000b,0x00000000,0x00000000}},	//   _uko__aba_, _hari__igihe_, --, --, 
   {{0xcadbc00c,0x00000000,0x00000000,0x00000000}},	//   _मेहरारू_, --, --, --, 
   {{0x3b2ac00c,0x00000000,0x00000000,0x00000000}},	//   _से__चर्चा_, --, --, --, 
   {{0x6436a00e,0x23ad600b,0x00000000,0x00000000}},	//   _na__této_, _bwa__mbere_, --, --, 
   {{0xb2b9c00e,0x00000000,0x00000000,0x00000000}},	//   _více_, --, --, --, 
   {{0x229ae006,0xebffc00c,0x86b5e002,0x00000000}},	//   _ཐོན__རིམ_, _ब्लास्ट__के_, _стратеги, --, 
   {{0x827ea00f,0xeea2e00f,0x5151800f,0x5bdd000c}},	//   _konke__lokhu_, _uhulumen, _zonke__izindlel, _के__गंभीरता_, 
   {{0x3354800d,0x23996009,0x12aac012,0x00000000}},	//   _mujeres_, _læse_, _vôbec_, --, 
   {{0x0a800014,0xee30a002,0x00000000,0x00000000}},	//   _आंदोलन__में_, _жели__да_, --, --, 
   {{0x4e73e00a,0xd7c92002,0x00000000,0x00000000}},	//   _मुफ्त_, _партизан, --, --, 
   {{0x146f8011,0xfc86a014,0x69dd000e,0x3253a00b}},	//   _ligan__con_, _के__पूर्वी_, _stáhnout_, _ku__kazi_, 
   {{0xc29b6003,0x9f5a001a,0xfbafc00a,0x42a36003}},	//   _བོད__ཡིག_, _bilete__frå_, _हम__उस_, _འདི__ལྟར_, 
   {{0x9aac2011,0x3e4cc003,0x00000000,0x00000000}},	//   _poderán_, _བསྒྲིགས__འགྲོ_, --, --, 
   {{0x5225600e,0x7e8b000f,0x00000000,0x00000000}},	//   _reakce_, _ingabe__kufanele_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xd1e1200a,0xe23c200f,0x00000000,0x00000000}},	// [1ee0] _हमारे_, _inkonzo__yakhe_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x427ec00d,0xabe0a02a,0xf02ac010,0x00000000}},	//   _bien_, _nyhetsbr, _frederik_, --, 
   {{0xb495e027,0xac12e006,0x527ec012,0x00000000}},	//   _sa__to_, _ཏོག__ཏོ_, _cien_, --, 
   {{0x0bfac006,0x00000000,0x00000000,0x00000000}},	//   _ཚུ__ནང_, --, --, --, 
   {{0x02a46003,0x00000000,0x00000000,0x00000000}},	//   _ཆབ__མདོ_, --, --, --, 
   {{0xdd624002,0x9989c012,0x00000000,0x00000000}},	//   _način__očistite_, _záhrada_, --, --, 
   {{0x3094000e,0xa3fb0003,0x00000000,0x00000000}},	//   _nabízíme_, _མེར__བསྲེགས_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x13b16030,0x7eb3e002,0x2e9c0002,0x00000000}},	//   _tekstova__ostalog_, _која__се_, _добављен_из_, --, 
   {{0x525d601d,0x9386a009,0x00000000,0x00000000}},	//   _sebagai__ahli_, _vejret_, --, --, 
   {{0xa426c015,0xa0472002,0x942cc00f,0xafea6003}},	//   _kamar__tidur_, _текст_, _umphosto_upetru_, _བསྒྲིག__རྒྱུ_, 
   {{0x26f02061,0x7bbca020,0x7ba5e006,0x00000000}},	//   _प्रवेश_, _བསྐྱོད__ལག_, _འབྲུག__ཤར_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xb329a01a,0x5962803d,0x48d7200c,0x00000000}},	//   _må__vere_, _cvičení_, _के__भोजपुर_, --, 
   {{0x72d7c00f,0x58530018,0x74be601a,0x74b12018}},	//   _umqondo_, _assuntos_, _til__då_, _descriça, 
   {{0xc6c48003,0x00000000,0x00000000,0x00000000}},	// [1ef0] _ལན__འདེབས_, --, --, --, 
   {{0x03ea601a,0x0fe80013,0x51e7400a,0x00000000}},	//   _henta_, _संपादित_, _फ़रवरी_, --, 
   {{0xc29f6039,0xe2daa012,0x2c6a400e,0x11ef400a}},	//   _berbagai_, _doplnky_, _kterém_, _मोल__ऐप्स_, 
   {{0x04b38018,0x00000000,0x00000000,0x00000000}},	//   _comparti_com_, --, --, --, 
   {{0xd290601a,0x3a3dc022,0x00000000,0x00000000}},	//   _innan_, _सघन_, --, --, 
   {{0x8186800f,0x22a6600f,0x82af8003,0x00000000}},	//   _nakakhul, _uyoba_, _མི__ཐུབ_, --, 
   {{0x1b9b6006,0xf67ee018,0x00000000,0x00000000}},	//   _རྒྱལ__ལྔ_, _preços__condiçõe, --, --, 
   {{0x3b8ec00c,0xe2d82025,0xa472800e,0x00000000}},	//   _एह_, _hoje_, _příběh_, --, 
   {{0x071f4030,0x00000000,0x00000000,0x00000000}},	//   _je__objavlji, --, --, --, 
   {{0x245b600b,0x129ea00b,0xe2bf201d,0x00000000}},	//   _yavuze__ko_, _gutora__papa_, _rakan__rakan_, --, 
   {{0xec7b8018,0x00000000,0x00000000,0x00000000}},	//   _com__certeza_, --, --, --, 
   {{0xd2ae6012,0xb022200a,0x00000000,0x00000000}},	//   _zmeniť_, _सिद्धार्_सीतापुर_, --, --, 
   {{0xe394c00f,0x64ba6011,0x0eb8e002,0x00000000}},	//   _ujesu_, _enderezo__de_, _ди_, --, 
   {{0x7c74601a,0x5290601a,0x00000000,0x00000000}},	//   _særleg_, _annan_, --, --, 
   {{0x8c51e004,0x00000000,0x00000000,0x00000000}},	//   _umntana_, --, --, --, 
   {{0xfe6ca018,0x00000000,0x00000000,0x00000000}},	//   _opiniões_, --, --, --, 
   {{0x9aeb2003,0x0bff800a,0x00000000,0x00000000}},	// [1f00] _ནང__འཇུག_, _खुद__को_, --, --, 
   {{0xfb802006,0x7f1f000f,0x00000000,0x00000000}},	//   _འཕེལ__གླིང_, _futhi__ngokuqin, --, --, 
   {{0x6351201a,0x00000000,0x00000000,0x00000000}},	//   _nynorsk__gjennom_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x23444009,0x6fa44009,0x6d844009,0x00000000}},	//   _arbejde_, _arbejder_, _arbejdet_, --, 
   {{0xeae3a003,0x00000000,0x00000000,0x00000000}},	//   _བཟོས__འདུག_, --, --, --, 
   {{0x1309601d,0x8493e00d,0x00000000,0x00000000}},	//   _anda__boleh_, _me__ha_, --, --, 
   {{0x3d36800f,0xe294a012,0x12e5a002,0x00000000}},	//   _izingane_, _meno__heslo_, _милиона__евра_, --, 
   {{0xc9f4c00e,0x4f39e01d,0xc48f6012,0x00000000}},	//   _lidé_, _memulaka, _ak__je_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x22d8401a,0xf226c00a,0xebd6800c,0x00000000}},	//   _kome_, _प्रयाग__हरिद्वार_, _उहा__के_, --, 
   {{0xf2dde002,0x00000000,0x00000000,0x00000000}},	//   _petak__izvor_, --, --, --, 
   {{0xedbae003,0xf0c4c002,0x1e268002,0x54c0801a}},	//   _དེབ__སྐྱེལ_, _додатни__услови_, _је__све_, _sunnhord_no_, 
   {{0xd2dfe012,0x00000000,0x00000000,0x00000000}},	//   _na__sklade_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x02b3e025,0x6e24c021,0x7073400f,0x7ec44002}},	//   _produto_, _བསྐྲུན_, _lukajeho, _којој__се_, 
   {{0xaea7a00c,0x00000000,0x00000000,0x00000000}},	// [1f10] _अपना__राज्य_, --, --, --, 
   {{0xd467a033,0x6bba4014,0x3e88e002,0x00000000}},	//   _tematski__alati_, _शुरूआती_, _односе__на_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x0bbd4006,0x670cc018,0x6282800f,0x00000000}},	//   _ལུ__ནང_, _divergên, _abaholi_, --, 
   {{0x6073400f,0xf2ad6006,0x00000000,0x00000000}},	//   _kukajeho, _སྤྱོད__ཤུལ_, --, --, 
   {{0xd25ac004,0x00000000,0x00000000,0x00000000}},	//   _kweli_, --, --, --, 
   {{0xa2918011,0x00000000,0x00000000,0x00000000}},	//   _nosas_, --, --, --, 
   {{0x6de58003,0xd498e011,0xa2bdc012,0x647b2018}},	//   _སྤྱི__འཐུས_, _máis__que_, _pokiaľ_, _controle__de_, 
   {{0xe2ca401a,0xa29a2003,0x00000000,0x00000000}},	//   _heldt_, _ཁྱེར__བོད_, --, --, 
   {{0x6316001d,0x00000000,0x00000000,0x00000000}},	//   _saiz_, --, --, --, 
   {{0xfbfac003,0xe47cc00d,0x1925e003,0xab7f4003}},	//   _པོ__དང_, _esta__es_, _ཡིག__བརླག_, _བའི__གསུང_, 
   {{0x938d6011,0x00000000,0x00000000,0x00000000}},	//   _de__goberno_, --, --, --, 
   {{0x3ea06002,0xd073400f,0x00000000,0x00000000}},	//   _иди__на_, _bukajeho, --, --, 
   {{0x7e7c4002,0x00000000,0x00000000,0x00000000}},	//   _може__се_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x73f84035,0x1c66c011,0x00000000,0x00000000}},	//   _lolu_, _mentres_, --, --, 
   {{0x7472c01c,0xe7542002,0x5471e00f,0x00000000}},	// [1f20] _करीना_, _вулгарне__претеће_, _lapho__nje_, --, 
   {{0x3dd9200b,0xaa44a037,0x3540400c,0x00000000}},	//   _cya__gisanzwe_, _ofertes__pregunte, _एगो__बढ़िया_, --, 
   {{0xa291801a,0xb0fe2002,0xbbcc600c,0x00000000}},	//   _vera_, _социјалн, _इहे_, --, 
   {{0x4f2b600f,0x8c7a200c,0x00000000,0x00000000}},	//   _ongcwele__kankulun, _अइसन__नइखे_, --, --, 
   {{0x528b600e,0xa2026003,0x7ba56003,0x6be2000a}},	//   _pomocí_, _སྒྲུང__རྩོམ_, _ཁྱེད__རང_, _तो__आप_, 
   {{0xebd7e014,0x00000000,0x00000000,0x00000000}},	//   _भाषा__के_, --, --, --, 
   {{0x632c200b,0x8bd1001c,0x00000000,0x00000000}},	//   _mu__muhezo_, _भारत__का_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x382a0003,0x6da78003,0x00000000,0x00000000}},	//   _ཡུག__འཕྲིན_, _རྩོམ__རིགས_, --, --, 
   {{0xaa9f2002,0xf291800d,0x00000000,0x00000000}},	//   _прокомен_подели_, _cosas_, --, --, 
   {{0x6e22600d,0xf4742002,0x00000000,0x00000000}},	//   _miembros_, _сличним_, --, --, 
   {{0xfa330036,0x59c2c012,0xebf18014,0x00000000}},	//   _चयन_, _odpovedz__páči_, _श्रृंखला__के_, --, 
   {{0xf2670002,0x00000000,0x00000000,0x00000000}},	//   _веку_, --, --, --, 
   {{0xe47a4009,0x3b97600c,0x628e0003,0x00000000}},	//   _hvad__du_, _के__बा_, _སྤྱིའི__གསར_, --, 
   {{0x3f9e2037,0xb2dfa00c,0x00000000,0x00000000}},	//   _sus__usuarios_, _वंशी_, --, --, 
   {{0x6e98601a,0xabe22003,0x00000000,0x00000000}},	// [1f30] _rettsleg_spørsmål_, _རྒྱུ__དེ_, --, --, 
   {{0x8387802f,0x93f6600b,0x3386c00b,0x00000000}},	//   _carro_, _igiteker_share_, _nzeri_, --, 
   {{0x4a1d8006,0x42b8e012,0x43a32012,0x00000000}},	//   _ཨེན__ཨེསི_, _tých_, _televízi, --, 
   {{0x5288a006,0xb4ac200f,0xbee3e00e,0x00000000}},	//   _འབད__དཔར_, _kodwa__uma_, _svým_, --, 
   {{0xb4b78018,0x7bdfc003,0x00000000,0x00000000}},	//   _realizad_em_, _གིས__རང_, --, --, 
   {{0xd9daa031,0x825c0006,0x72baa00f,0x00000000}},	//   _ternyata_, _སྒེར__གསང_, _ibhokisi__ekhasini_, --, 
   {{0x6224e02a,0xa2e3a00b,0x00000000,0x00000000}},	//   _tenker_, _ku__kibazo_, --, --, 
   {{0x8699e01a,0x6398a019,0x527ee003,0x027fa003}},	//   _til__navigeri, _høst_, _ལྷ__སའི_, _ལྷ__རྩེ_, 
   {{0xb3868012,0x03c38002,0xa2d7a011,0xc2cb4012}},	//   _ktorý_, _на__основу_, _pola__súa_, _predam_, 
   {{0x8616e009,0x7e97e002,0x416f200f,0x82aa6003}},	//   _vejledni, _којима__се_, _ayisikho, _པར__དབང_, 
   {{0x5410a01a,0xab42200f,0xe4ca6018,0x62a6800b}},	//   _dei__mest_, _izibusis, _avaliaçã_inserido_, _byabo_, 
   {{0x431e8004,0x0352c00c,0x72a6800b,0xedf08003}},	//   _namhlanj, _करेला_, _cyabo_, _མཉམ__འབྲེལ_, 
   {{0x4f9d2012,0x00000000,0x00000000,0x00000000}},	//   _najkrajš, --, --, --, 
   {{0x03eb2025,0x22ca6009,0x33432018,0x2a56a00c}},	//   _sexta_, _kendt_, _desenho_, _खोजी__टीम_, 
   {{0x63f46009,0x645a2008,0x124d8003,0x86fe201c}},	//   _har__været_, _autónoma__de_, _འགའ_, _कोटा_, 
   {{0xab980038,0x8c49c00c,0x44da2002,0x00000000}},	//   _ficheiro_, _नइखे_, _својим_, --, 
   {{0x0476c011,0x00000000,0x00000000,0x00000000}},	// [1f40] _envía__teu_, --, --, --, 
   {{0x5264e00c,0x00000000,0x00000000,0x00000000}},	//   _के__सिनेमा_, --, --, --, 
   {{0xf9f4600e,0x00000000,0x00000000,0x00000000}},	//   _jiné_, --, --, --, 
   {{0x42d98002,0x0c0a8006,0x00000000,0x00000000}},	//   _ocenite_, _ལྟག__ལུ_, --, --, 
   {{0xa28e2003,0x0e774002,0x00000000,0x00000000}},	//   _བསམ__ཚུལ_, _служба__за_, --, --, 
   {{0x7f65800f,0xde0d600e,0x4cd8c002,0x00000000}},	//   _okuphaka, _předplat, _поруке__неће_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x21464013,0x00000000,0x00000000,0x00000000}},	//   _दिसंबर_, --, --, --, 
   {{0x53f8200f,0x5236000e,0x8c07e018,0xb481401a}},	//   _kamuva_, _stahován, _várias_, _utan__at_, 
   {{0x04a3400e,0xb2b24012,0x97596022,0x00000000}},	//   _stránce_, _predaja_, _साक्ष्य_, --, 
   {{0xe23f800b,0x00000000,0x00000000,0x00000000}},	//   _muri__rusizi_, --, --, --, 
   {{0xbbcca013,0x00000000,0x00000000,0x00000000}},	//   _वही_, --, --, --, 
   {{0xe2d86018,0x8264a00f,0x00000000,0x00000000}},	//   _fone_, _ungeze__lokhu_, --, --, 
   {{0xc29aa00c,0xaa40a00e,0x00000000,0x00000000}},	//   _से__पहिले_, _rozpětí__distribu, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x12128015,0xa48fa01a,0xb2da0015,0x10ab000b}},	//   _udah_, _at__dei_, _sepeda_, _kwubahir_umutekan, 
   {{0xa2d18009,0x00000000,0x00000000,0x00000000}},	// [1f50] _på__grund_, --, --, --, 
   {{0x7354c028,0x00000000,0x00000000,0x00000000}},	//   _quieres_, --, --, --, 
   {{0xbb19601f,0x6a9ee00a,0x00000000,0x00000000}},	//   _kerajaan_, _यादृच्छि_लेख_, --, --, 
   {{0xf53fe002,0x00000000,0x00000000,0x00000000}},	//   _адресу_, --, --, --, 
   {{0x8297e006,0x00000000,0x00000000,0x00000000}},	//   _ལུའི__ཚིག_, --, --, --, 
   {{0xc29b2003,0x00000000,0x00000000,0x00000000}},	//   _བསོད__ནམས_, --, --, --, 
   {{0x9ef4801d,0x00000000,0x00000000,0x00000000}},	//   _saling__berhubun, --, --, --, 
   {{0x5cb52037,0xf580800e,0x59c2e00b,0xb47b200a}},	//   _ha__cerrado_, _použít_, _gitekere, _लेख__योगदान_, 
   {{0x99f4602a,0x82d8600d,0x00000000,0x00000000}},	//   _ennå_, _pone_, --, --, 
   {{0xca3e400c,0x0b092022,0x7b29c018,0xdfce400e}},	//   _भोज_, _और__संस्कृति_, _justiça_, _nákupní__košík_, 
   {{0x351c400f,0xae05801d,0x7a32a00c,0x00000000}},	//   _inkulumo_, _kenderaa, _कएल_, --, 
   {{0xfb962022,0xd231e018,0x3c02000c,0x00000000}},	//   _बात__से_, _recebeu__nenhum_, _लिखल__बा_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xd34d8003,0x84444025,0xd0e8e00f,0x00000000}},	//   _རྒྱའི_, _pq_, _amavidiy_ayimfihl, --, 
   {{0x828fa006,0x550d800a,0x7c74601a,0x7a558012}},	//   _མེད__དབང_, _टीम__इंडिया_, _dårleg_, _na__stiahnut, 
   {{0xc84c600e,0x127e8017,0xeb96000c,0x00000000}},	//   _způsob_, _volný_, _मान__के_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [1f60] --, --, --, --, 
   {{0xf45f400b,0xf4c0801a,0x83056011,0x7bc5800c}},	//   _ikigega__cy_, _vart__han_, _secretar_xeral_, _रहे__अब_, 
   {{0xca4fe00c,0x5a3ca00c,0x64bbc025,0x00000000}},	//   _मिहिर__भोज_, _रउआ_, _meio__de_, --, 
   {{0x9bca6006,0x00000000,0x00000000,0x00000000}},	//   _ཐུག__ལས_, --, --, --, 
   {{0xd9f7a00b,0xd977e00f,0x00000000,0x00000000}},	//   _bibiliya_, _emshadwe, --, --, 
   {{0x825ac01d,0x00000000,0x00000000,0x00000000}},	//   _emel_, --, --, --, 
   {{0x826e0007,0xf3ae601a,0x00000000,0x00000000}},	//   _kenal__dari_, _endre__endre_, --, --, 
   {{0x324d8006,0xebd0a00c,0x00000000,0x00000000}},	//   _སླབ_, _भावे__के_, --, --, 
   {{0x4b8ec003,0xdb8ba003,0x2a9ec00c,0x00000000}},	//   _ཏཱ_, _ཞེས__གསུངས_, _जाइत__अछि_, --, 
   {{0xc2d8a00f,0x00000000,0x00000000,0x00000000}},	//   _jobe_, --, --, --, 
   {{0x9a336014,0x22fde01a,0x211b400a,0x00000000}},	//   _काज_, _ved__sida_, _सभी__एनबीटी_, --, 
   {{0xad904006,0x00000000,0x00000000,0x00000000}},	//   _ཡིག__སྔགས_, --, --, --, 
   {{0x42010028,0x00000000,0x00000000,0x00000000}},	//   _cocina_, --, --, --, 
   {{0xde922002,0x3889e002,0xd67d800c,0x00000000}},	//   _портал_, _последње_, _आपन__इरादा_, --, 
   {{0x249d2002,0x7e5a200f,0x513c0012,0x1230600b}},	//   _датотека_, _ukuthi__kufanele_, _posledný_, _nyamara_, 
   {{0x02d8c025,0x7cca2003,0x00000000,0x00000000}},	//   _ordem_, _སྟེར_, --, --, 
   {{0x9cc38012,0x00000000,0x00000000,0x00000000}},	// [1f70] _detský_, --, --, --, 
   {{0x4e1aa011,0x00000000,0x00000000,0x00000000}},	//   _recibir__notifica, --, --, --, 
   {{0x34428016,0x9a2dc018,0x00000000,0x00000000}},	//   _hva_, _para__você_, --, --, 
   {{0x6466003c,0x6442801a,0x9245e00e,0x8455e009}},	//   _vrh__postao_, _kva_, _dům_, _hjælper__os_, 
   {{0xa524200e,0x7a94c00c,0x00000000,0x00000000}},	//   _přípravk, _बा__ओकर_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x1291c012,0x62c9c003,0x6bdc200a,0x8246c00e}},	//   _tovar_, _བརྙན__གསར_, _ने__भी_, _něm_, 
   {{0x8bccc00c,0xa2efa018,0x00000000,0x00000000}},	//   _एही_, _bem__vindo_, --, --, 
   {{0x632dc002,0x00000000,0x00000000,0x00000000}},	//   _пољоприв, --, --, --, 
   {{0x0290c01a,0xf4508012,0x00000000,0x00000000}},	//   _sidan_, _skutočne_, --, --, 
   {{0x96310028,0x8eb96002,0x00000000,0x00000000}},	//   _la__categorí, _њих_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x92aae018,0xad7d2011,0x22e9c002,0x5789c002}},	//   _seu__comentár, _de__calidade_, _његова_, _његово_, 
   {{0x739aa011,0x3bcdc01c,0x00000000,0x00000000}},	//   _véxase_, _सनी_, --, --, 
   {{0x6326001a,0x8279400f,0x00000000,0x00000000}},	//   _på__garden_, _umphefum_wami_, --, --, 
   {{0xda64800b,0x00000000,0x00000000,0x00000000}},	//   _rupapuro__ruboneka_, --, --, --, 
   {{0x9197c002,0x00000000,0x00000000,0x00000000}},	// [1f80] _такође_, --, --, --, 
   {{0x63d84009,0x66504012,0x0be4e00a,0x53d6a00f}},	//   _at__gøre_, _ďakujem_, _बनाइये__और_, _umsebenz_wokushum, 
   {{0x7291e00b,0xcb3a0003,0x00000000,0x00000000}},	//   _reta_, _ཆེ__མཆོག_, --, --, 
   {{0xcbcb6009,0x1141000a,0x00000000,0x00000000}},	//   _erhvervs, _न्यूज़_, --, --, 
   {{0x7343200d,0x60b48018,0x7ed54002,0x00000000}},	//   _derecho_, _tráfego_, _па__се_, --, 
   {{0x52748018,0x00000000,0x00000000,0x00000000}},	//   _estrelas__ótimo_, --, --, --, 
   {{0x82d8200d,0x383c4003,0x92a78012,0xe4602028}},	//   _mujer_, _རླུང__འཕྲིན_, _farba_, _qué__es_, 
   {{0xa290e011,0x7bbb8003,0xd2506002,0xfbe80003}},	//   _ligan_, _དུ__རང_, _већа_, _བྱེད__པར_, 
   {{0x2212200f,0x62504024,0xc496a011,0x00000000}},	//   _lokho_, _ne__bojim_, _xa__non_, --, 
   {{0x3bf0600a,0x329da00b,0x00000000,0x00000000}},	//   _में__यह_, _uko__wabona_, --, --, 
   {{0x4212200f,0x00000000,0x00000000,0x00000000}},	//   _nokho_, --, --, --, 
   {{0xf7f12002,0x00000000,0x00000000,0x00000000}},	//   _истина_, --, --, --, 
   {{0xe2d8c039,0x42d8a00e,0x64b86002,0xe494603d}},	//   _kode_, _roce_, _vesti__iz_, _cz__na_, 
   {{0x8be6200a,0x92d96012,0x7bd5c003,0x00000000}},	//   _कर__रही_, _videá_, _ཀུམ__དྲ_, --, 
   {{0x32438020,0x645be018,0x47c8a002,0x0a09e012}},	//   _ཁའི_, _condiçõe_de_, _библиогр, _prešov_, 
   {{0xd469a01a,0x5470e00e,0xc244a00e,0xc242a006}},	//   _vart__sist_, _tak__se_, _upravit__obchod_, _བའད_, 
   {{0x0290600b,0xa2002028,0x32e50009,0xbddd8003}},	// [1f90] _sinai_, _admite_, _levere__vores_, _ངོས__རོགས_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7ec26002,0xb498e018,0x127ae006,0x00000000}},	//   _данас__се_, _ou__em_, _དེ__སྦེ_, --, 
   {{0xf39b6015,0x00000000,0x00000000,0x00000000}},	//   _jakarta__selatan_, --, --, --, 
   {{0xc2cb801a,0xe9d4800f,0x4386800b,0x00000000}},	//   _verda_, _ukulunga_, _byari_, --, 
   {{0x9387e011,0xf261e01a,0x29cfe003,0x6cbaa00e}},	//   _catro_, _sjølvsag, _བུའི_, _udělat_, 
   {{0xca488014,0xaa4cc00c,0xd4b36025,0x00000000}},	//   _खास__तौर_, _के__दर्जा_, _dizer__que_, --, 
   {{0xaee9a032,0x0457c011,0x32d12006,0x00000000}},	//   _ngokuqon, _vindeiro_, _ཕུག__འཇའ_, --, 
   {{0x1a58e01d,0xe7b4c00b,0xd2890003,0x00000000}},	//   _rakyat__malaysia_, _ukurangi, _བཏང__སྟེ_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2c75e00a,0x00000000,0x00000000,0x00000000}},	//   _स्पाइसी__सिद्धार्, --, --, --, 
   {{0x19ff800e,0x1a9c0014,0x09cae003,0xa2b40009}},	//   _hvězdičk_recenzí_, _में__अगर_, _ལྟའི_, _sundhed_, 
   {{0xcd030031,0x5470a018,0xab8f0003,0x00000000}},	//   _terlihat_, _uma__vez_, _ོད_, --, 
   {{0x9c68000f,0x0bd2e012,0x5386800b,0x12b66003}},	//   _yikuphi_, _komentov_zdieľať_, _cyari_, _ཆུ__སྒང_, 
   {{0xf7d8200c,0x00000000,0x00000000,0x00000000}},	//   _आतंकियन_, --, --, --, 
   {{0x6df6e021,0x00000000,0x00000000,0x00000000}},	//   _བྱ__རིགས_, --, --, --, 
   {{0x4a32a013,0xc256c006,0xc4750015,0x6f03a012}},	// [1fa0] _गया_, _འཕྲལ__གྱི_, _properti__serupa_, _veľký_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x44af8015,0xe863c002,0xef1bc003,0xb2c6e003}},	//   _iklan__ini_, _подаци_, _བྱིས__སྒྲུང_, _རིགས__ཀྱི_, 
   {{0x52d8c045,0xfb550011,0xdb3b8002,0x00000000}},	//   _budem_, _da__conselle, _складу_, --, 
   {{0x42f72037,0x49f4c01a,0xaf344002,0x0363a00e}},	//   _del__lugar_, _endå_, _да__то_, _národní_, 
   {{0x7eb4a002,0xebd8600c,0x17f7a00e,0x1bca0003}},	//   _који__се_, _भासा__के_, _obchodní__podmínky_, _གཏན__ནས_, 
   {{0x9fa5001a,0xfd068003,0xfbcc600c,0x00000000}},	//   _og__frå_, _བྱ__འགུལ_, _इहो_, --, 
   {{0x5200202c,0xb9f5c012,0x63f60003,0xb287e00f}},	//   _kuki_, _novú_, _ལྡན__རྒྱལ_, _isibonel_esihle_, 
   {{0xfbe6200a,0x00000000,0x00000000,0x00000000}},	//   _कर__रहे_, --, --, --, 
   {{0xacdfc006,0xf2906003,0x6733000c,0x00000000}},	//   _མངའ__གསོལ_, _བརྗོད__བཅར_, _कवनो__खतरा_, --, 
   {{0x3712200a,0x00000000,0x00000000,0x00000000}},	//   _कर__सकता_, --, --, --, 
   {{0xa4ac601a,0xe3f86039,0x63e3e002,0x00000000}},	//   _ein__ny_, _mulus_, _пројекат_, --, 
   {{0x67d54021,0x930e0011,0x00000000,0x00000000}},	//   _བདག__འཛིན_, _espazos_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x1c90a00a,0x9b8ca003,0x00000000,0x00000000}},	//   _दोनों_, _དྷ_, --, --, 
   {{0x53eb8012,0x3e0ee01a,0x4243a003,0x463b6006}},	// [1fb0] _mesto_, _forfatta, _ངའི_, _སྤྲོད__རྒྱབ_, 
   {{0xebf8c00c,0x47d88002,0xdf01e003,0x00000000}},	//   _तर्क__के_, _читалаца__овог_, _བསྐུར_, --, 
   {{0x63cf4009,0xb497e00d,0xf4afc02a,0x00000000}},	//   _blevet_, _si__el_, _laste__opp_, --, 
   {{0xb2f5a018,0xfedc6028,0x0be0800a,0x82a6600e}},	//   _digite__código_, _opciones_, _दी__है_, _osob_, 
   {{0x6387000e,0xc2686018,0x7df9400c,0x00000000}},	//   _který_, _estrela__ruim_, _मजूमदार_, --, 
   {{0x0278600f,0xc375c018,0x00000000,0x00000000}},	//   _umuntu_, _próxima__página_, --, --, 
   {{0xc256c003,0x00000000,0x00000000,0x00000000}},	//   _རྒྱལ__གྱི_, --, --, --, 
   {{0x9f25a018,0x00000000,0x00000000,0x00000000}},	//   _qualquer_, --, --, --, 
   {{0x33dc200b,0x00000000,0x00000000,0x00000000}},	//   _amjwi_, --, --, --, 
   {{0xdea4000e,0x00000000,0x00000000,0x00000000}},	//   _řízení_, --, --, --, 
   {{0x27bda02a,0xbc9a2037,0x00000000,0x00000000}},	//   _ytterlig, _marzo__febrero_, --, --, 
   {{0xec32e002,0x7200200b,0x64b50028,0xb32a400e}},	//   _tanjug__komentar, _muji_, _privacid_de_, _displeje__více_, 
   {{0xbc86c02d,0x83c9a007,0x6e28e002,0xa485c018}},	//   _sve__postove_, _pada__teks_, _та_, _aceita__as_, 
   {{0xf35d6002,0x5428000c,0xafb2e012,0x1335c00f}},	//   _pol__ženski_, _जहरीली__शराब_, _musí__byť_, _yebo__ujehova_, 
   {{0x933fa019,0x4afbe00f,0x00000000,0x00000000}},	//   _det__gjelder_, _abagcots, --, --, 
   {{0xb6e8800f,0x4617e002,0x00000000,0x00000000}},	//   _uthole__ukwazisw, _арапски_, --, --, 
   {{0x83eb802f,0x00000000,0x00000000,0x00000000}},	// [1fc0] _perto_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa442001b,0x4c61a00b,0xe310800f,0x5f430002}},	//   _kwi_, _akarere_, _kakhulu__ukuba_, _чланцима__преко_, 
   {{0x09f4c00e,0x90448011,0xf27a0003,0x7a11e003}},	//   _lidí_, _de__aloxamen, _གནང__མཁན_, _ཆེན__མོའི_, 
   {{0x1442c012,0x648c2018,0x1c622015,0x00000000}},	//   _dve_, _além__de_, _inputan_, --, 
   {{0x62b84003,0x00000000,0x00000000,0x00000000}},	//   _ཆེ__ཤོས_, --, --, --, 
   {{0x4a73600a,0x4d5a6002,0x9ba2400c,0x00000000}},	//   _किया__गया_, _моје_, _वाला__लोगन_, --, 
   {{0xebeda00c,0x23946018,0xee646002,0xfd26600c}},	//   _सब__के_, _série_, _мора__да_, _कि__महुआ_, 
   {{0x5b21601d,0xc2ca800e,0x5e8be002,0x00000000}},	//   _telah__berkongs, _řada_, _од__нас_, --, 
   {{0x31ea600a,0x42d8e00a,0x3496e00d,0xacd64003}},	//   _एक__नज़र_, _सकती_, _no__lo_, _འགྲེམས__སྤེལ_, 
   {{0x7294200f,0xd34e8030,0x93b06018,0x4c384012}},	//   _israyeli_, _kantonim_opštinam, _última__edição_, _banská_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x8c4f600a,0x9c8f600a,0x7bc28013,0x22434003}},	//   _आपके_, _आपको_, _ऑटो_, _པའམ_, 
   {{0xa490201a,0x00000000,0x00000000,0x00000000}},	//   _av__dei_, --, --, --, 
   {{0x8be7c003,0x43eb801a,0x00000000,0x00000000}},	// [1fd0] _ཤེས__བྱ_, _verte_, --, --, 
   {{0xf272001d,0xac68400f,0xebc5a00c,0x00000000}},	//   _penuh__carian_, _yimuphi_, _विक्रमाद_के_, --, 
   {{0xabe0a009,0xef63a015,0xe316800b,0xce61800f}},	//   _nyhedsbr, _surat__elektron, _akazi_, _ukubheka, 
   {{0x52da6024,0x6473c028,0x106e600a,0xec01400c}},	//   _meseca_, _juego__de_, _झारखण्ड_, _कालचक्र__के_, 
   {{0xe200402b,0xc46e0011,0x23ae600b,0xe4fb8013}},	//   _cumi_, _enderezo_, _cya__mbere_, _गिरावट_, 
   {{0xd494c00b,0x00000000,0x00000000,0x00000000}},	//   _urwego__rw_, --, --, --, 
   {{0x39e72002,0xcf24c00e,0x0496e018,0x42d7800b}},	//   _заједно_, _vaší_, _ou__com_, _mu__mashuri_, 
   {{0xeec0c04f,0x13996009,0xa254a00e,0x00000000}},	//   _विशेष__पृष्ठ_, _læst_, _dělat_, --, 
   {{0xc36e2030,0x00000000,0x00000000,0x00000000}},	//   _kantonim, --, --, --, 
   {{0x921f003c,0x9bb18006,0x9495e009,0x2f99600a}},	//   _mjeseci__godina_, _ཁས__མི_, _på__dk_, _स्पाइसी__क्रिकेट_, 
   {{0xc2550003,0xb487400c,0x00000000,0x00000000}},	//   _ཐོའི__ཟིན_, _बढ़ावे_, --, --, 
   {{0x4e72e002,0xa4b1201a,0xa28bc003,0x302b6002}},	//   _ће_, _til__dei_, _གོད__ཆགས_, _допринос, 
   {{0x9c3dc030,0xd34f8002,0x0a7ba00e,0x3c02800c}},	//   _istraživ_finansir, _новембар__октобар_, _klávesni_véčka_, _लागल__बा_, 
   {{0x65972022,0xea88600b,0x00000000,0x00000000}},	//   _में__करीब_, _bushyash_burabone, --, --, 
   {{0xa295802d,0xec536018,0x4bc42012,0x00000000}},	//   _tematski_, _gostosa_, _dekoráci, --, 
   {{0x7496e00e,0x00000000,0x00000000,0x00000000}},	//   _se__po_, --, --, --, 
   {{0x027ea03d,0x3c4e400a,0xb2388018,0x23eb8018}},	// [1fe0] _jednom_, _कैसे_, _primeiro__enviar_, _teste_, 
   {{0xedff401d,0xe4bd8018,0xd42a800f,0x70146002}},	//   _rundinga, _consulte__nos_, _somuntu__siqu_, _уреди__викимеди, 
   {{0xbb970006,0x2bb4800a,0x00000000,0x00000000}},	//   _མི__སྒོང_, _नहीं__हो_, --, --, 
   {{0xb496e00e,0xac13e006,0x00000000,0x00000000}},	//   _se__to_, _ཏོང__ཏོ_, --, --, 
   {{0x9290600e,0x00000000,0x00000000,0x00000000}},	//   _jinak_, --, --, --, 
   {{0xf2308018,0x32b92003,0xbab4000c,0x00000000}},	//   _seu__login_, _མི__ཆོག_, _खातिर__काम_, --, 
   {{0xa240a00c,0x00000000,0x00000000,0x00000000}},	//   _लिखले_, --, --, --, 
   {{0x8290001d,0x00000000,0x00000000,0x00000000}},	//   _sihat_, --, --, --, 
   {{0xb073803c,0x3a6ee00c,0x00000000,0x00000000}},	//   _bosansko, _चारू__जना_, --, --, 
   {{0x6e0e2006,0xee154003,0x00000000,0x00000000}},	//   _རིགས__འཐུས_, _དཀར__མཛེས_, --, --, 
   {{0xaf172005,0x00000000,0x00000000,0x00000000}},	//   _hordalan, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x0a4e600c,0x00000000,0x00000000,0x00000000}},	//   _एनआईए__खोज_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xe27c800f,0xd9ffa00e,0x5c9de00a,0x00000000}},	//   _ujehova__futhi_, _hudební_, _नए__सबसे_, --, 
   {{0xc2968003,0x00000000,0x00000000,0x00000000}},	// [1ff0] _འཛིན__པའི_, --, --, --, 
   {{0xeb26c00f,0xcd54200b,0x00000000,0x00000000}},	//   _phaphama_, _gutanga__ibiteker, --, --, 
   {{0xef82400e,0x00000000,0x00000000,0x00000000}},	//   _přihlašo, --, --, --, 
   {{0x52d92011,0xc25ea00f,0x02eec00b,0x9baaa002}},	//   _hoxe_, _dlulela__kuyi_, _akenshi_, _србин__инфо_, 
   {{0xc470e018,0xc3218011,0x00000000,0x00000000}},	//   _que__tem_, _máis__tarde_, --, --, 
   {{0x44bb2015,0xd240a014,0x8270401a,0x9454c00b}},	//   _situs__ini_, _लिहले_, _eg__fekk_, _yakorewe__abatutsi_, 
   {{0x330fc012,0xcc85c00c,0x1b98200c,0x00000000}},	//   _sukromna__sprava_, _के__दिल्ली_, _के__ना_, --, 
   {{0x1290a025,0xee30c002,0x00000000,0x00000000}},	//   _ficam_, _овде__да_, --, --, 
   {{0xcf666009,0x4874c00f,0xebba200a,0x32c5201a}},	//   _hjælp_, _ngonkulu, _हैं__इस_, _vanlege_, 
   {{0xebe18003,0x2a782002,0x90570002,0x00000000}},	//   _འདི__དག_, _муслиман, _сви__изрази_, --, 
   {{0x0a4d800c,0x00000000,0x00000000,0x00000000}},	//   _भोजपुरी__में_, --, --, --, 
   {{0x2442e038,0x0290201a,0x7f0b6002,0x00000000}},	//   _tvg_, _likar_, _извођачи_по_, --, 
   {{0x2ea8e002,0x62f84009,0x00000000,0x00000000}},	//   _али__је_, _at__købe_, --, --, 
   {{0x8bcd401c,0xb488a00f,0x00000000,0x00000000}},	//   _रही_, _ngakho__uma_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
  
  };
  // table_hash = 981b-55ce, unused_entries = 14207 (43.36%)

static const uint32 kDistinctOcta0122SizeOne = 98; // Bucket count one-lang
static const uint32 kDistinctOcta0122IndSize = 98; // Largest subscript
extern const uint32 kDistinctOctaIndSize = kDistinctOcta0122IndSize; // Source-agnostic named constant
static const uint32 kDistinctOcta0122Ind[kDistinctOcta0122IndSize] = {
  // [0000]
  0x00000000, 0x00000000, 0x00001706, 0x00002a06,   // -- --  sr.un.un_400 bo.un.un_400 
  0x00003406, 0x00003303, 0x00003906, 0x00001e01,   // xh.un.un_400 nn.un.un_300  dz.un.un_400 ms.un.un_200 
  0x00001901, 0x00000206, 0x00000906, 0x00005506,   // gl.un.un_200 da.un.un_400  hi.un.un_400 rw.un.un_400 
  0x00001306, 0x00000b01, 0x00000d06, 0x00003506,   // bh.un.un_400 es.un.un_200  cs.un.un_400 zu.un.un_400 
  // [0010]
  0x00000203, 0x00001906, 0x00002d06, 0x00000903,   // da.un.un_300 gl.un.un_400  sk.un.un_400 hi.un.un_300 
  0x00001303, 0x00001c06, 0x00000806, 0x00000d03,   // bh.un.un_300 id.un.un_400  no.un.un_400 cs.un.un_300 
  0x00000a06, 0x00000801, 0x00003306, 0x00003403,   // pt.un.un_400 no.un.un_200  nn.un.un_400 xh.un.un_300 
  0x00000901, 0x00001e06, 0x00003203, 0x00001e03,   // hi.un.un_200 ms.un.un_400  bs.un.un_300 ms.un.un_300 
  // [0020]
  0x00003903, 0x00003901, 0x00001301, 0x00005903,   // dz.un.un_300 dz.un.un_200  bh.un.un_200 rn.un.un_300 
  0x00001703, 0x00000a03, 0x00000201, 0x00002d03,   // sr.un.un_300 pt.un.un_300  da.un.un_200 sk.un.un_300 
  0x00000b03, 0x00002a01, 0x00000803, 0x00005503,   // es.un.un_300 bo.un.un_200  no.un.un_300 rw.un.un_300 
  0x00005501, 0x00001603, 0x00001601, 0x00000a01,   // rw.un.un_200 hr.un.un_300  hr.un.un_200 pt.un.un_200 
  // [0030]
  0x00003206, 0x00001c01, 0x00003503, 0x00001606,   // bs.un.un_400 id.un.un_200  zu.un.un_300 hr.un.un_400 
  0x00003301, 0x00003501, 0x09000d09, 0x00000b06,   // nn.un.un_200 zu.un.un_200  ne.hi.un_440 es.un.un_400 
  0x00001903, 0x00001c03, 0x00002a03, 0x09000d02,   // gl.un.un_300 id.un.un_300  bo.un.un_300 ne.hi.un_220 
  0x00003201, 0x00000d01, 0x09000d05, 0x00003401,   // bs.un.un_200 cs.un.un_200  ne.hi.un_330 xh.un.un_200 
  // [0040]
  0x00001701, 0x13001c04, 0x08003308, 0x09001c07,   // sr.un.un_200 mr.bh.un_320  nn.no.un_430 mr.hi.un_420 
  0x09000d04, 0x00002d01, 0x09000d07, 0x091c0da4,   // ne.hi.un_320 sk.un.un_200  ne.hi.un_420 ne.mr.hi_433 
  0x09001c09, 0x09001c02, 0x00005901, 0x09001c08,   // mr.hi.un_440 mr.hi.un_220  rn.un.un_200 mr.hi.un_430 
  0x13000d09, 0x13000d08, 0x090d1ca4, 0x09000d08,   // ne.bh.un_440 ne.bh.un_430  mr.ne.hi_433 ne.hi.un_430 
  // [0050]
  0x13000d02, 0x091c0d08, 0x13000d07, 0x00005906,   // ne.bh.un_220 ne.mr.hi_443  ne.bh.un_420 rn.un.un_400 
  0x13001c05, 0x130d1c02, 0x13001c09, 0x0d002d09,   // mr.bh.un_330 mr.ne.bh_222  mr.bh.un_440 sk.cs.un_440 
  0x0d001c08, 0x13000d05, 0x13001c02, 0x0d001c07,   // mr.ne.un_430 ne.bh.un_330  mr.bh.un_220 mr.ne.un_420 
  0x091c0d07, 0x0a000b08, 0x13001c08, 0x09001c05,   // ne.mr.hi_432 es.pt.un_430  mr.bh.un_430 mr.hi.un_330 
  // [0060] --- double_langprob_start=0062 ---
  0x13000d04, 0x091c0d55,                           // ne.bh.un_320 ne.mr.hi_442  
                                                    // 
  };

//  COMPILE_ASSERT(98 <= 8192, k_indirectbits_too_small);

extern const CLD2TableSummary kDistinctOcta_obj = {
  kDistinctOcta0122,
  kDistinctOcta0122Ind,
  kDistinctOcta0122SizeOne,
  kDistinctOcta0122Size,
  kDistinctOcta0122KeyMask,
  kDistinctOcta0122BuildDate,
  kDistinctOcta0122RecognizedLangScripts,
};

static const uint32 kDistinctOcta0122_2Size = 0;    // Bucket count
static const uint32 kDistinctOcta0122_2KeyMask = 0xffffffff;    // Mask hash key

// NOTE: Some compilers will not allow an array of structs to have a constant
//       size of zero. Thus, we tell the code that the size is zero, but
//       actually allocate a single element array that will never be read.
//       More info: https://code.google.com/p/cld2/issues/detail?id=9
static const IndirectProbBucket4 kDistinctOcta0122_2[1] = {
  // hash_indirect[4], tokens[4] in UTF-8
  {0x00000000,0x00000000,0x00000000,0x00000000} // UNUSED, see above!
  };
  // table_hash = ffff-ffff, unused_entries = 0 (0.00%)

static const uint32 kDistinctOcta0122_2SizeOne = 2; // Bucket count one-lang
static const uint32 kDistinctOcta0122_2IndSize = 2; // Largest subscript
extern const uint32 kDistinctOcta2IndSize = kDistinctOcta0122_2IndSize; // Source-agnostic named constant
static const uint32 kDistinctOcta0122_2Ind[kDistinctOcta0122_2IndSize] = {
  // [0000] --- double_langprob_start=0002 ---
  0x00000000, 0x00000000,                           // -- --  
                                                    // 
  };

extern const CLD2TableSummary kDistinctOcta_obj2 = {
  kDistinctOcta0122_2,
  kDistinctOcta0122_2Ind,
  kDistinctOcta0122_2SizeOne,
  kDistinctOcta0122_2Size,
  kDistinctOcta0122_2KeyMask,
  kDistinctOcta0122BuildDate,
  kDistinctOcta0122RecognizedLangScripts,
};

}       // End namespace CLD2

// End of generated tables
