/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.dictionary.CatalogRowFactory;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.SubCheckConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SubConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SubKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SystemColumn;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.catalog.SystemColumnImpl;

public class SYSCONSTRAINTSRowFactory
extends CatalogRowFactory {
    private static final String TABLENAME_STRING = "SYSCONSTRAINTS";
    protected static final int SYSCONSTRAINTS_COLUMN_COUNT = 7;
    protected static final int SYSCONSTRAINTS_CONSTRAINTID = 1;
    protected static final int SYSCONSTRAINTS_TABLEID = 2;
    protected static final int SYSCONSTRAINTS_CONSTRAINTNAME = 3;
    protected static final int SYSCONSTRAINTS_TYPE = 4;
    protected static final int SYSCONSTRAINTS_SCHEMAID = 5;
    protected static final int SYSCONSTRAINTS_STATE = 6;
    protected static final int SYSCONSTRAINTS_REFERENCECOUNT = 7;
    protected static final int SYSCONSTRAINTS_INDEX1_ID = 0;
    protected static final int SYSCONSTRAINTS_INDEX2_ID = 1;
    protected static final int SYSCONSTRAINTS_INDEX3_ID = 2;
    private static final boolean[] uniqueness = new boolean[]{true, true, false};
    private static final int[][] indexColumnPositions = new int[][]{{1}, {3, 5}, {2}};
    private static final String[][] indexColumnNames = new String[][]{{"CONSTRAINTID"}, {"CONSTRAINTNAME", "SCHEMAID"}, {"TABLEID"}};
    private static final String[] uuids = new String[]{"8000002f-00d0-fd77-3ed8-000a0a0b1900", "80000036-00d0-fd77-3ed8-000a0a0b1900", "80000031-00d0-fd77-3ed8-000a0a0b1900", "80000033-00d0-fd77-3ed8-000a0a0b1900", "80000035-00d0-fd77-3ed8-000a0a0b1900"};

    public SYSCONSTRAINTSRowFactory(UUIDFactory uUIDFactory, ExecutionFactory executionFactory, DataValueFactory dataValueFactory, boolean bl) {
        super(uUIDFactory, executionFactory, dataValueFactory, bl);
        this.initInfo(7, TABLENAME_STRING, indexColumnPositions, indexColumnNames, uniqueness, uuids);
    }

    public ExecRow makeRow(TupleDescriptor tupleDescriptor, TupleDescriptor tupleDescriptor2) throws StandardException {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        boolean bl = true;
        int n = 0;
        if (tupleDescriptor != null) {
            ConstraintDescriptor constraintDescriptor = (ConstraintDescriptor)tupleDescriptor;
            UUID uUID = constraintDescriptor.getUUID();
            string2 = uUID.toString();
            uUID = constraintDescriptor.getTableId();
            string3 = uUID.toString();
            string4 = constraintDescriptor.getConstraintName();
            int n2 = constraintDescriptor.getConstraintType();
            switch (n2) {
                case 2: {
                    string = "P";
                    break;
                }
                case 3: {
                    string = "U";
                    break;
                }
                case 4: {
                    string = "C";
                    break;
                }
                case 6: {
                    string = "F";
                    break;
                }
            }
            string5 = constraintDescriptor.getSchemaDescriptor().getUUID().toString();
            bl = constraintDescriptor.isEnabled();
            n = constraintDescriptor.getReferenceCount();
        }
        ExecRow execRow = this.getExecutionFactory().getValueRow(7);
        execRow.setColumn(1, this.dvf.getCharDataValue(string2));
        execRow.setColumn(2, this.dvf.getCharDataValue(string3));
        execRow.setColumn(3, this.dvf.getVarcharDataValue(string4));
        execRow.setColumn(4, this.dvf.getCharDataValue(string));
        execRow.setColumn(5, this.dvf.getCharDataValue(string5));
        execRow.setColumn(6, this.dvf.getCharDataValue(bl ? "E" : "D"));
        execRow.setColumn(7, this.dvf.getDataValue(n));
        return execRow;
    }

    public ExecIndexRow buildEmptyIndexRow(int n, RowLocation rowLocation) throws StandardException {
        int n2 = this.getIndexColumnCount(n);
        ExecIndexRow execIndexRow = this.getExecutionFactory().getIndexableRow(n2 + 1);
        execIndexRow.setColumn(n2 + 1, rowLocation);
        switch (n) {
            case 0: {
                execIndexRow.setColumn(1, this.getDataValueFactory().getCharDataValue(null));
                break;
            }
            case 1: {
                execIndexRow.setColumn(1, this.getDataValueFactory().getVarcharDataValue(null));
                execIndexRow.setColumn(2, this.getDataValueFactory().getCharDataValue(null));
                break;
            }
            case 2: {
                execIndexRow.setColumn(1, this.getDataValueFactory().getCharDataValue(null));
                break;
            }
            default: {
                return null;
            }
        }
        return execIndexRow;
    }

    public TupleDescriptor buildDescriptor(ExecRow execRow, TupleDescriptor tupleDescriptor, DataDictionary dataDictionary) throws StandardException {
        boolean bl;
        ConstraintDescriptor constraintDescriptor = null;
        TableDescriptor tableDescriptor = null;
        int n = -1;
        int[] nArray = null;
        UUID uUID = null;
        SubConstraintDescriptor subConstraintDescriptor = (SubConstraintDescriptor)tupleDescriptor;
        DataDescriptorGenerator dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
        DataValueDescriptor dataValueDescriptor = execRow.getColumn(1);
        String string = dataValueDescriptor.getString();
        UUID uUID2 = this.getUUIDFactory().recreateUUID(string);
        dataValueDescriptor = execRow.getColumn(2);
        String string2 = dataValueDescriptor.getString();
        UUID uUID3 = this.getUUIDFactory().recreateUUID(string2);
        if (subConstraintDescriptor != null) {
            tableDescriptor = subConstraintDescriptor.getTableDescriptor();
        }
        if (tableDescriptor == null) {
            tableDescriptor = dataDictionary.getTableDescriptor(uUID3);
        }
        dataValueDescriptor = execRow.getColumn(3);
        String string3 = dataValueDescriptor.getString();
        dataValueDescriptor = execRow.getColumn(4);
        String string4 = dataValueDescriptor.getString();
        boolean bl2 = false;
        switch (string4.charAt(0)) {
            case 'P': {
                n = 2;
                bl2 = true;
            }
            case 'U': {
                if (!bl2) {
                    n = 3;
                    bl2 = true;
                }
            }
            case 'F': {
                ConglomerateDescriptor conglomerateDescriptor;
                if (!bl2) {
                    n = 6;
                }
                if ((conglomerateDescriptor = tableDescriptor.getConglomerateDescriptor(((SubKeyConstraintDescriptor)tupleDescriptor).getIndexId())) == null) {
                    tableDescriptor = dataDictionary.getTableDescriptor(uUID3);
                    if (subConstraintDescriptor != null) {
                        subConstraintDescriptor.setTableDescriptor(tableDescriptor);
                    }
                    conglomerateDescriptor = tableDescriptor.getConglomerateDescriptor(((SubKeyConstraintDescriptor)tupleDescriptor).getIndexId());
                }
                nArray = conglomerateDescriptor.getIndexDescriptor().baseColumnPositions();
                uUID = ((SubKeyConstraintDescriptor)tupleDescriptor).getKeyConstraintId();
                nArray = conglomerateDescriptor.getIndexDescriptor().baseColumnPositions();
                break;
            }
            case 'C': {
                n = 4;
                break;
            }
        }
        dataValueDescriptor = execRow.getColumn(5);
        String string5 = dataValueDescriptor.getString();
        UUID uUID4 = this.getUUIDFactory().recreateUUID(string5);
        SchemaDescriptor schemaDescriptor = dataDictionary.getSchemaDescriptor(uUID4, null);
        dataValueDescriptor = execRow.getColumn(6);
        String string6 = dataValueDescriptor.getString();
        switch (string6.charAt(0)) {
            case 'E': {
                bl = true;
                break;
            }
            case 'D': {
                bl = false;
                break;
            }
            default: {
                bl = true;
            }
        }
        dataValueDescriptor = execRow.getColumn(7);
        int n2 = dataValueDescriptor.getInt();
        switch (n) {
            case 2: {
                constraintDescriptor = dataDescriptorGenerator.newPrimaryKeyConstraintDescriptor(tableDescriptor, string3, false, false, nArray, uUID2, ((SubKeyConstraintDescriptor)tupleDescriptor).getIndexId(), schemaDescriptor, bl, n2);
                break;
            }
            case 3: {
                constraintDescriptor = dataDescriptorGenerator.newUniqueConstraintDescriptor(tableDescriptor, string3, false, false, nArray, uUID2, ((SubKeyConstraintDescriptor)tupleDescriptor).getIndexId(), schemaDescriptor, bl, n2);
                break;
            }
            case 6: {
                constraintDescriptor = dataDescriptorGenerator.newForeignKeyConstraintDescriptor(tableDescriptor, string3, false, false, nArray, uUID2, ((SubKeyConstraintDescriptor)tupleDescriptor).getIndexId(), schemaDescriptor, uUID, bl, ((SubKeyConstraintDescriptor)tupleDescriptor).getRaDeleteRule(), ((SubKeyConstraintDescriptor)tupleDescriptor).getRaUpdateRule());
                break;
            }
            case 4: {
                constraintDescriptor = dataDescriptorGenerator.newCheckConstraintDescriptor(tableDescriptor, string3, false, false, uUID2, ((SubCheckConstraintDescriptor)tupleDescriptor).getConstraintText(), ((SubCheckConstraintDescriptor)tupleDescriptor).getReferencedColumnsDescriptor(), schemaDescriptor, bl);
            }
        }
        return constraintDescriptor;
    }

    protected UUID getConstraintId(ExecRow execRow) throws StandardException {
        DataValueDescriptor dataValueDescriptor = execRow.getColumn(1);
        String string = dataValueDescriptor.getString();
        return this.getUUIDFactory().recreateUUID(string);
    }

    protected String getConstraintName(ExecRow execRow) throws StandardException {
        DataValueDescriptor dataValueDescriptor = execRow.getColumn(3);
        String string = dataValueDescriptor.getString();
        return string;
    }

    protected UUID getSchemaId(ExecRow execRow) throws StandardException {
        DataValueDescriptor dataValueDescriptor = execRow.getColumn(5);
        String string = dataValueDescriptor.getString();
        return this.getUUIDFactory().recreateUUID(string);
    }

    protected UUID getTableId(ExecRow execRow) throws StandardException {
        DataValueDescriptor dataValueDescriptor = execRow.getColumn(2);
        String string = dataValueDescriptor.getString();
        return this.getUUIDFactory().recreateUUID(string);
    }

    protected int getConstraintType(ExecRow execRow) throws StandardException {
        int n;
        DataValueDescriptor dataValueDescriptor = execRow.getColumn(4);
        String string = dataValueDescriptor.getString();
        switch (string.charAt(0)) {
            case 'P': {
                n = 2;
                break;
            }
            case 'U': {
                n = 3;
                break;
            }
            case 'C': {
                n = 4;
                break;
            }
            case 'F': {
                n = 6;
                break;
            }
            default: {
                n = -1;
            }
        }
        return n;
    }

    public SystemColumn[] buildColumnList() {
        int n = 0;
        SystemColumn[] systemColumnArray = new SystemColumn[7];
        systemColumnArray[n++] = new SystemColumnImpl(this.convertIdCase("CONSTRAINTID"), 1, 0, 0, false, "CHAR", true, 36);
        systemColumnArray[n++] = new SystemColumnImpl(this.convertIdCase("TABLEID"), 2, 0, 0, false, "CHAR", true, 36);
        systemColumnArray[n++] = new SystemColumnImpl(this.convertIdCase("CONSTRAINTNAME"), 3, false);
        systemColumnArray[n++] = new SystemColumnImpl(this.convertIdCase("TYPE"), 4, 0, 0, false, "CHAR", true, 1);
        systemColumnArray[n++] = new SystemColumnImpl(this.convertIdCase("SCHEMAID"), 5, 0, 0, false, "CHAR", true, 36);
        systemColumnArray[n++] = new SystemColumnImpl(this.convertIdCase("STATE"), 6, 0, 0, false, "CHAR", true, 1);
        systemColumnArray[n++] = new SystemColumnImpl(this.convertIdCase("REFERENCECOUNT"), 7, 0, 0, false, "INTEGER", true, 1);
        return systemColumnArray;
    }
}

