/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import javax.ws.rs.client.CompletionStageRxInvoker;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.client.WebClient;

public class CompletionStageRxInvokerImpl
implements CompletionStageRxInvoker {
    private WebClient wc;
    private ExecutorService ex;

    CompletionStageRxInvokerImpl(WebClient wc, ExecutorService ex) {
        this.ex = ex;
        this.wc = wc;
    }

    @Override
    public CompletionStage<Response> get() {
        return this.get(Response.class);
    }

    @Override
    public <T> CompletionStage<T> get(Class<T> responseType) {
        return this.method("GET", (Class)responseType);
    }

    @Override
    public <T> CompletionStage<T> get(GenericType<T> responseType) {
        return this.method("GET", (GenericType)responseType);
    }

    @Override
    public CompletionStage<Response> put(Entity<?> entity) {
        return this.put((Entity)entity, Response.class);
    }

    @Override
    public <T> CompletionStage<T> put(Entity<?> entity, Class<T> responseType) {
        return this.method("PUT", (Entity)entity, (Class)responseType);
    }

    @Override
    public <T> CompletionStage<T> put(Entity<?> entity, GenericType<T> responseType) {
        return this.method("PUT", (Entity)entity, (GenericType)responseType);
    }

    @Override
    public CompletionStage<Response> post(Entity<?> entity) {
        return this.post((Entity)entity, Response.class);
    }

    @Override
    public <T> CompletionStage<T> post(Entity<?> entity, Class<T> responseType) {
        return this.method("POST", (Entity)entity, (Class)responseType);
    }

    @Override
    public <T> CompletionStage<T> post(Entity<?> entity, GenericType<T> responseType) {
        return this.method("POST", (Entity)entity, (GenericType)responseType);
    }

    @Override
    public CompletionStage<Response> delete() {
        return this.delete(Response.class);
    }

    @Override
    public <T> CompletionStage<T> delete(Class<T> responseType) {
        return this.method("DELETE", (Class)responseType);
    }

    @Override
    public <T> CompletionStage<T> delete(GenericType<T> responseType) {
        return this.method("DELETE", (GenericType)responseType);
    }

    @Override
    public CompletionStage<Response> head() {
        return this.method("HEAD");
    }

    @Override
    public CompletionStage<Response> options() {
        return this.options(Response.class);
    }

    @Override
    public <T> CompletionStage<T> options(Class<T> responseType) {
        return this.method("OPTIONS", (Class)responseType);
    }

    @Override
    public <T> CompletionStage<T> options(GenericType<T> responseType) {
        return this.method("OPTIONS", (GenericType)responseType);
    }

    @Override
    public CompletionStage<Response> trace() {
        return this.trace(Response.class);
    }

    @Override
    public <T> CompletionStage<T> trace(Class<T> responseType) {
        return this.method("TRACE", (Class)responseType);
    }

    @Override
    public <T> CompletionStage<T> trace(GenericType<T> responseType) {
        return this.method("TRACE", (GenericType)responseType);
    }

    @Override
    public CompletionStage<Response> method(String name) {
        return this.method(name, Response.class);
    }

    @Override
    public CompletionStage<Response> method(String name, Entity<?> entity) {
        return this.method(name, (Entity)entity, Response.class);
    }

    @Override
    public <T> CompletionStage<T> method(String name, Entity<?> entity, Class<T> responseType) {
        if (this.ex == null) {
            return CompletableFuture.supplyAsync(() -> this.wc.sync().method(name, entity, responseType));
        }
        return CompletableFuture.supplyAsync(() -> this.wc.sync().method(name, entity, responseType), this.ex);
    }

    @Override
    public <T> CompletionStage<T> method(String name, Entity<?> entity, GenericType<T> responseType) {
        if (this.ex == null) {
            return CompletableFuture.supplyAsync(() -> this.wc.sync().method(name, entity, responseType));
        }
        return CompletableFuture.supplyAsync(() -> this.wc.sync().method(name, entity, responseType), this.ex);
    }

    @Override
    public <T> CompletionStage<T> method(String name, Class<T> responseType) {
        if (this.ex == null) {
            return CompletableFuture.supplyAsync(() -> this.wc.sync().method(name, responseType));
        }
        return CompletableFuture.supplyAsync(() -> this.wc.sync().method(name, responseType), this.ex);
    }

    @Override
    public <T> CompletionStage<T> method(String name, GenericType<T> responseType) {
        if (this.ex == null) {
            return CompletableFuture.supplyAsync(() -> this.wc.sync().method(name, responseType));
        }
        return CompletableFuture.supplyAsync(() -> this.wc.sync().method(name, responseType), this.ex);
    }
}

