/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.util;

import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.JavaUtils;

public final class PackageUtils {
    private PackageUtils() {
    }

    static String getPackageName(String className) {
        int pos = className.lastIndexOf(46);
        if (pos != -1) {
            return className.substring(0, pos);
        }
        return "";
    }

    public static String getPackageName(Class<?> clazz) {
        String className = clazz.getName();
        if (className.startsWith("[L")) {
            className = className.substring(2);
        }
        return PackageUtils.getPackageName(className);
    }

    public static String getSharedPackageName(List<Class<?>> classes) {
        if (classes.isEmpty()) {
            return "";
        }
        ArrayList<List<String>> lParts = new ArrayList<List<String>>(classes.size());
        ArrayList currentParts = new ArrayList();
        for (Class<?> cls : classes) {
            if (Proxy.isProxyClass(cls)) continue;
            lParts.add(StringUtils.getParts(PackageUtils.getPackageName(cls), "\\."));
        }
        for (int i = 0; i < ((List)lParts.get(0)).size(); ++i) {
            int j;
            for (j = 1; j < lParts.size() && i <= ((List)lParts.get(j)).size() - 1 && ((String)((List)lParts.get(j)).get(i)).equals(((List)lParts.get(0)).get(i)); ++j) {
            }
            if (j != lParts.size()) break;
            currentParts.add(((List)lParts.get(j - 1)).get(i));
        }
        StringBuilder sb = new StringBuilder();
        for (String part : currentParts) {
            if (sb.length() > 0) {
                sb.append(".");
            }
            sb.append(part);
        }
        return sb.toString();
    }

    public static String parsePackageName(String namespace, String defaultPackageName) {
        String packageName;
        String string = packageName = defaultPackageName != null && defaultPackageName.trim().length() > 0 ? defaultPackageName : null;
        if (packageName == null) {
            packageName = PackageUtils.getPackageNameByNameSpaceURI(namespace);
        }
        return packageName;
    }

    public static String getPackageNameByNameSpaceURI(String nameSpaceURI) {
        List<String> r;
        String domain;
        String lastToken;
        List<String> tokens;
        int idx = nameSpaceURI.indexOf(58);
        String scheme = "";
        if (idx >= 0 && ("http".equalsIgnoreCase(scheme = nameSpaceURI.substring(0, idx)) || "urn".equalsIgnoreCase(scheme))) {
            nameSpaceURI = nameSpaceURI.substring(idx + 1);
        }
        if ((tokens = PackageUtils.tokenize(nameSpaceURI, "/: ")).isEmpty()) {
            return null;
        }
        if (tokens.size() > 1 && (idx = (lastToken = tokens.get(tokens.size() - 1)).lastIndexOf(46)) > 0) {
            lastToken = lastToken.substring(0, idx);
            tokens.set(tokens.size() - 1, lastToken);
        }
        if ((idx = (domain = tokens.get(0)).indexOf(58)) >= 0) {
            domain = domain.substring(0, idx);
        }
        if ("www".equalsIgnoreCase((r = PackageUtils.reverse(PackageUtils.tokenize(domain, "urn".equals(scheme) ? ".-" : "."))).get(r.size() - 1))) {
            r.remove(r.size() - 1);
        }
        tokens.addAll(1, r);
        tokens.remove(0);
        for (int i = 0; i < tokens.size(); ++i) {
            String token = tokens.get(i);
            if (PackageUtils.containsReservedKeywords(token = PackageUtils.removeIllegalIdentifierChars(token))) {
                token = '_' + token;
            }
            tokens.set(i, token.toLowerCase());
        }
        return PackageUtils.combine(tokens, '.');
    }

    private static List<String> tokenize(String str, String sep) {
        StringTokenizer tokens = new StringTokenizer(str, sep);
        ArrayList<String> r = new ArrayList<String>();
        while (tokens.hasMoreTokens()) {
            r.add(tokens.nextToken());
        }
        return r;
    }

    private static <T> List<T> reverse(List<T> a) {
        ArrayList<T> r = new ArrayList<T>();
        for (int i = a.size() - 1; i >= 0; --i) {
            r.add(a.get(i));
        }
        return r;
    }

    private static String removeIllegalIdentifierChars(String token) {
        StringBuilder newToken = new StringBuilder();
        for (int i = 0; i < token.length(); ++i) {
            char c = token.charAt(i);
            if (i == 0 && !Character.isJavaIdentifierStart(c)) {
                newToken.append("_" + c);
                continue;
            }
            if (!Character.isJavaIdentifierPart(c)) {
                newToken.append('_');
                continue;
            }
            newToken.append(c);
        }
        return newToken.toString();
    }

    private static String combine(List<?> r, char sep) {
        StringBuilder buf = new StringBuilder(r.get(0).toString());
        for (int i = 1; i < r.size(); ++i) {
            buf.append(sep);
            buf.append(r.get(i));
        }
        return buf.toString();
    }

    private static boolean containsReservedKeywords(String token) {
        return JavaUtils.isJavaKeyword(token);
    }

    public static String getNamespace(String packageName) {
        String[] tokens;
        if (packageName == null || packageName.length() == 0) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(packageName, ".");
        if (tokenizer.countTokens() == 0) {
            tokens = new String[]{};
        } else {
            tokens = new String[tokenizer.countTokens()];
            for (int i = tokenizer.countTokens() - 1; i >= 0; --i) {
                tokens[i] = tokenizer.nextToken();
            }
        }
        StringBuilder namespace = new StringBuilder("http://");
        String dot = "";
        for (int i = 0; i < tokens.length; ++i) {
            if (i == 1) {
                dot = ".";
            }
            namespace.append(dot + tokens[i]);
        }
        namespace.append('/');
        return namespace.toString();
    }
}

