package App::randquote;

use 5.010001;
use strict;
use warnings;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2023-08-26'; # DATE
our $DIST = 'App-randquote'; # DIST
our $VERSION = '0.001'; # VERSION

our %SPEC;

$SPEC{randquote} = {
    v => 1.1,
    summary => 'Print a random quote',
    args => {
    },
};
sub randquote {
    require Role::Tiny;
    require Role::TinyCommons::Collection::PickItems::Iterator;
    require TableData::Quote::JamesFT;

    my %args = @_;

    my $td = TableData::Quote::JamesFT->new;
    Role::Tiny->apply_roles_to_object($td, "Role::TinyCommons::Collection::PickItems::Iterator");
    my @rows = $td->pick_items(n=>1);
    [200, "OK", qq("$rows[0][0]" -- $rows[0][1])];
}

1;
# ABSTRACT: Print a random quote

__END__

=pod

=encoding UTF-8

=head1 NAME

App::randquote - Print a random quote

=head1 VERSION

This document describes version 0.001 of App::randquote (from Perl distribution App-randquote), released on 2023-08-26.

=head1 SYNOPSIS

See the included L<randquote> script.

=head1 DESCRIPTION

This is a simple demo for L<TableData> and L<TableData::Quote::JamesFT>.

=head1 FUNCTIONS


=head2 randquote

Usage:

 randquote() -> [$status_code, $reason, $payload, \%result_meta]

Print a random quote.

This function is not exported.

No arguments.

Returns an enveloped result (an array).

First element ($status_code) is an integer containing HTTP-like status code
(200 means OK, 4xx caller error, 5xx function error). Second element
($reason) is a string containing error message, or something like "OK" if status is
200. Third element ($payload) is the actual result, but usually not present when enveloped result is an error response ($status_code is not 2xx). Fourth
element (%result_meta) is called result metadata and is optional, a hash
that contains extra information, much like how HTTP response headers provide additional metadata.

Return value:  (any)

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/App-randquote>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-App-randquote>.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2023 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=App-randquote>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
