# Generated by default/object.tt
package Paws::SecurityHub::WorkflowUpdate;
  use Moose;
  has Status => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::WorkflowUpdate

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::WorkflowUpdate object:

  $service_obj->Method(Att1 => { Status => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::WorkflowUpdate object:

  $result = $service_obj->Method(...);
  $result->Att1->Status

=head1 DESCRIPTION

Used to update information about the investigation into the finding.

=head1 ATTRIBUTES


=head2 Status => Str

The status of the investigation into the finding. The allowed values
are the following.

=over

=item *

C<NEW> - The initial state of a finding, before it is reviewed.

Security Hub also resets C<WorkFlowStatus> from C<NOTIFIED> or
C<RESOLVED> to C<NEW> in the following cases:

=over

=item *

The record state changes from C<ARCHIVED> to C<ACTIVE>.

=item *

The compliance status changes from C<PASSED> to either C<WARNING>,
C<FAILED>, or C<NOT_AVAILABLE>.

=back

=item *

C<NOTIFIED> - Indicates that you notified the resource owner about the
security issue. Used when the initial reviewer is not the resource
owner, and needs intervention from the resource owner.

=item *

C<RESOLVED> - The finding was reviewed and remediated and is now
considered resolved.

=item *

C<SUPPRESSED> - The finding will not be reviewed again and will not be
acted upon.

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

