# Generated by default/object.tt
package Paws::SecurityHub::SensitiveDataDetections;
  use Moose;
  has Count => (is => 'ro', isa => 'Int');
  has Occurrences => (is => 'ro', isa => 'Paws::SecurityHub::Occurrences');
  has Type => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::SensitiveDataDetections

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::SensitiveDataDetections object:

  $service_obj->Method(Att1 => { Count => $value, ..., Type => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::SensitiveDataDetections object:

  $result = $service_obj->Method(...);
  $result->Att1->Count

=head1 DESCRIPTION

The list of detected instances of sensitive data.

=head1 ATTRIBUTES


=head2 Count => Int

The total number of occurrences of sensitive data that were detected.


=head2 Occurrences => L<Paws::SecurityHub::Occurrences>

Details about the sensitive data that was detected.


=head2 Type => Str

The type of sensitive data that was detected. For example, the type
might indicate that the data is an email address.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

