# Generated by default/object.tt
package Paws::IoTSiteWise::PutAssetPropertyValueEntry;
  use Moose;
  has AssetId => (is => 'ro', isa => 'Str', request_name => 'assetId', traits => ['NameInRequest']);
  has EntryId => (is => 'ro', isa => 'Str', request_name => 'entryId', traits => ['NameInRequest'], required => 1);
  has PropertyAlias => (is => 'ro', isa => 'Str', request_name => 'propertyAlias', traits => ['NameInRequest']);
  has PropertyId => (is => 'ro', isa => 'Str', request_name => 'propertyId', traits => ['NameInRequest']);
  has PropertyValues => (is => 'ro', isa => 'ArrayRef[Paws::IoTSiteWise::AssetPropertyValue]', request_name => 'propertyValues', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTSiteWise::PutAssetPropertyValueEntry

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTSiteWise::PutAssetPropertyValueEntry object:

  $service_obj->Method(Att1 => { AssetId => $value, ..., PropertyValues => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTSiteWise::PutAssetPropertyValueEntry object:

  $result = $service_obj->Method(...);
  $result->Att1->AssetId

=head1 DESCRIPTION

Contains a list of value updates for an asset property in the list of
asset entries consumed by the BatchPutAssetPropertyValue
(https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchPutAssetPropertyValue.html)
API operation.

=head1 ATTRIBUTES


=head2 AssetId => Str

The ID of the asset to update.


=head2 B<REQUIRED> EntryId => Str

The user specified ID for the entry. You can use this ID to identify
which entries failed.


=head2 PropertyAlias => Str

The property alias that identifies the property, such as an OPC-UA
server data stream path (for example,
C</company/windfarm/3/turbine/7/temperature>). For more information,
see Mapping industrial data streams to asset properties
(https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html)
in the I<AWS IoT SiteWise User Guide>.


=head2 PropertyId => Str

The ID of the asset property for this entry.


=head2 B<REQUIRED> PropertyValues => ArrayRef[L<Paws::IoTSiteWise::AssetPropertyValue>]

The list of property values to upload. You can specify up to 10
C<propertyValues> array elements.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTSiteWise>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

