# Generated by default/object.tt
package Paws::IoTSiteWise::Aggregates;
  use Moose;
  has Average => (is => 'ro', isa => 'Num', request_name => 'average', traits => ['NameInRequest']);
  has Count => (is => 'ro', isa => 'Num', request_name => 'count', traits => ['NameInRequest']);
  has Maximum => (is => 'ro', isa => 'Num', request_name => 'maximum', traits => ['NameInRequest']);
  has Minimum => (is => 'ro', isa => 'Num', request_name => 'minimum', traits => ['NameInRequest']);
  has StandardDeviation => (is => 'ro', isa => 'Num', request_name => 'standardDeviation', traits => ['NameInRequest']);
  has Sum => (is => 'ro', isa => 'Num', request_name => 'sum', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTSiteWise::Aggregates

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTSiteWise::Aggregates object:

  $service_obj->Method(Att1 => { Average => $value, ..., Sum => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTSiteWise::Aggregates object:

  $result = $service_obj->Method(...);
  $result->Att1->Average

=head1 DESCRIPTION

Contains the (pre-calculated) aggregate values for an asset property.

=head1 ATTRIBUTES


=head2 Average => Num

The average (mean) value of the time series over a time interval
window.


=head2 Count => Num

The count of data points in the time series over a time interval
window.


=head2 Maximum => Num

The maximum value of the time series over a time interval window.


=head2 Minimum => Num

The minimum value of the time series over a time interval window.


=head2 StandardDeviation => Num

The standard deviation of the time series over a time interval window.


=head2 Sum => Num

The sum of the time series over a time interval window.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTSiteWise>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

