# Generated by default/object.tt
package Paws::CognitoIdp::EventRiskType;
  use Moose;
  has CompromisedCredentialsDetected => (is => 'ro', isa => 'Bool');
  has RiskDecision => (is => 'ro', isa => 'Str');
  has RiskLevel => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CognitoIdp::EventRiskType

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CognitoIdp::EventRiskType object:

  $service_obj->Method(Att1 => { CompromisedCredentialsDetected => $value, ..., RiskLevel => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CognitoIdp::EventRiskType object:

  $result = $service_obj->Method(...);
  $result->Att1->CompromisedCredentialsDetected

=head1 DESCRIPTION

The event risk type.

=head1 ATTRIBUTES


=head2 CompromisedCredentialsDetected => Bool

Indicates whether compromised credentials were detected during an
authentication event.


=head2 RiskDecision => Str

The risk decision.


=head2 RiskLevel => Str

The risk level.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CognitoIdp>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

