/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.core.GenericCollectionTypeResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapFactoryBean
extends AbstractFactoryBean<Map> {
    private Map<?, ?> sourceMap;
    private Class targetMapClass;

    public void setSourceMap(Map sourceMap) {
        this.sourceMap = sourceMap;
    }

    public void setTargetMapClass(Class targetMapClass) {
        if (targetMapClass == null) {
            throw new IllegalArgumentException("'targetMapClass' must not be null");
        }
        if (!Map.class.isAssignableFrom(targetMapClass)) {
            throw new IllegalArgumentException("'targetMapClass' must implement [java.util.Map]");
        }
        this.targetMapClass = targetMapClass;
    }

    @Override
    public Class<Map> getObjectType() {
        return Map.class;
    }

    @Override
    protected Map createInstance() {
        if (this.sourceMap == null) {
            throw new IllegalArgumentException("'sourceMap' is required");
        }
        LinkedHashMap result = null;
        result = this.targetMapClass != null ? (LinkedHashMap)BeanUtils.instantiateClass(this.targetMapClass) : new LinkedHashMap(this.sourceMap.size());
        Class<?> keyType = null;
        Class<?> valueType = null;
        if (this.targetMapClass != null) {
            keyType = GenericCollectionTypeResolver.getMapKeyType(this.targetMapClass);
            valueType = GenericCollectionTypeResolver.getMapValueType(this.targetMapClass);
        }
        if (keyType != null || valueType != null) {
            TypeConverter converter = this.getBeanTypeConverter();
            for (Map.Entry<?, ?> entry : this.sourceMap.entrySet()) {
                Object convertedKey = converter.convertIfNecessary(entry.getKey(), keyType);
                Object convertedValue = converter.convertIfNecessary(entry.getValue(), valueType);
                result.put(convertedKey, convertedValue);
            }
        } else {
            result.putAll(this.sourceMap);
        }
        return result;
    }
}

