/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client.blueprint;

import java.util.List;
import javax.xml.namespace.QName;
import org.apache.aries.blueprint.ParserContext;
import org.apache.aries.blueprint.mutable.MutableBeanMetadata;
import org.apache.aries.blueprint.mutable.MutableCollectionMetadata;
import org.apache.aries.blueprint.mutable.MutablePassThroughMetadata;
import org.apache.cxf.configuration.blueprint.SimpleBPBeanDefinitionParser;
import org.apache.cxf.jaxrs.blueprint.JAXRSServerFactoryBeanDefinitionParser;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.model.UserResource;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.osgi.service.blueprint.reflect.Target;
import org.w3c.dom.Element;

public class JAXRSClientFactoryBeanDefinitionParser
extends SimpleBPBeanDefinitionParser {
    public JAXRSClientFactoryBeanDefinitionParser() {
        super(JAXRSClientFactoryBean.class);
    }

    @Override
    public String getFactorySuffix() {
        return ".proxyFactory";
    }

    @Override
    public String getFactoryCreateType(Element element) {
        return Client.class.getName();
    }

    @Override
    protected boolean hasBusProperty() {
        return true;
    }

    @Override
    protected void mapAttribute(MutableBeanMetadata bean, Element e, String name, String val, ParserContext context) {
        if ("serviceName".equals(name)) {
            QName q = this.parseQName(e, val);
            bean.addProperty(name, this.createValue(context, q));
        } else {
            this.mapToProperty(bean, name, val, context);
        }
    }

    @Override
    protected void mapElement(ParserContext ctx, MutableBeanMetadata bean, Element el, String name) {
        if ("properties".equals(name) || "headers".equals(name)) {
            bean.addProperty(name, this.parseMapData(ctx, (ComponentMetadata)bean, el));
        } else if ("executor".equals(name)) {
            this.setFirstChildAsProperty(el, ctx, bean, "serviceFactory.executor");
        } else if ("binding".equals(name)) {
            this.setFirstChildAsProperty(el, ctx, bean, "bindingConfig");
        } else if ("inInterceptors".equals(name) || "inFaultInterceptors".equals(name) || "outInterceptors".equals(name) || "outFaultInterceptors".equals(name)) {
            bean.addProperty(name, this.parseListData(ctx, (ComponentMetadata)bean, el));
        } else if ("features".equals(name) || "providers".equals(name) || "schemaLocations".equals(name) || "modelBeans".equals(name)) {
            bean.addProperty(name, this.parseListData(ctx, (ComponentMetadata)bean, el));
        } else if ("model".equals(name)) {
            List<UserResource> resources = ResourceUtils.getResourcesFromElement(el);
            MutableCollectionMetadata list = (MutableCollectionMetadata)ctx.createMetadata(MutableCollectionMetadata.class);
            list.setCollectionClass(List.class);
            for (UserResource res : resources) {
                MutablePassThroughMetadata factory = (MutablePassThroughMetadata)ctx.createMetadata(MutablePassThroughMetadata.class);
                factory.setObject(new JAXRSServerFactoryBeanDefinitionParser.PassThroughCallable<UserResource>(res));
                MutableBeanMetadata resourceBean = (MutableBeanMetadata)ctx.createMetadata(MutableBeanMetadata.class);
                resourceBean.setFactoryComponent((Target)factory);
                resourceBean.setFactoryMethod("call");
                list.addValue((Metadata)resourceBean);
            }
            bean.addProperty("modelBeans", (Metadata)list);
        } else {
            this.setFirstChildAsProperty(el, ctx, bean, name);
        }
    }
}

