/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.time;

import edu.stanford.nlp.ie.NumberNormalizer;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.tokensregex.CoreMapExpressionExtractor;
import edu.stanford.nlp.ling.tokensregex.MatchedExpression;
import edu.stanford.nlp.pipeline.ChunkAnnotationUtils;
import edu.stanford.nlp.time.EnglishTimeExpressionPatterns;
import edu.stanford.nlp.time.GenericTimeExpressionPatterns;
import edu.stanford.nlp.time.Options;
import edu.stanford.nlp.time.SUTime;
import edu.stanford.nlp.time.TimeAnnotations;
import edu.stanford.nlp.time.TimeExpression;
import edu.stanford.nlp.time.TimeExpressionExtractor;
import edu.stanford.nlp.time.TimeExpressionPatterns;
import edu.stanford.nlp.time.Timex;
import edu.stanford.nlp.util.CoreMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TimeExpressionExtractorImpl
implements TimeExpressionExtractor {
    protected static final Logger logger = Logger.getLogger(TimeExpressionExtractorImpl.class.getName());
    TimeExpressionPatterns timexPatterns;
    CoreMapExpressionExtractor expressionExtractor;
    Options options;

    public TimeExpressionExtractorImpl() {
        this.init(new Options());
    }

    public TimeExpressionExtractorImpl(String name, Properties props) {
        this.init(name, props);
    }

    @Override
    public void init(String name, Properties props) {
        this.init(new Options(name, props));
    }

    @Override
    public void init(Options options) {
        this.options = options;
        if (options.verbose) {
            logger.setLevel(Level.FINE);
        } else {
            logger.setLevel(Level.SEVERE);
        }
        NumberNormalizer.setVerbose(options.verbose);
        this.timexPatterns = options.grammarFilename != null ? new GenericTimeExpressionPatterns(options) : new EnglishTimeExpressionPatterns(options);
        this.expressionExtractor = this.timexPatterns.createExtractor();
        this.expressionExtractor.setLogger(logger);
    }

    @Override
    public List<CoreMap> extractTimeExpressionCoreMaps(CoreMap annotation, String docDate) {
        SUTime.TimeIndex timeIndex = new SUTime.TimeIndex();
        return this.extractTimeExpressionCoreMaps(annotation, docDate, timeIndex);
    }

    public List<CoreMap> extractTimeExpressionCoreMaps(CoreMap annotation, String docDate, SUTime.TimeIndex timeIndex) {
        List<TimeExpression> timeExpressions = this.extractTimeExpressions(annotation, docDate);
        return this.toCoreMaps(annotation, timeExpressions, timeIndex);
    }

    private List<CoreMap> toCoreMaps(CoreMap annotation, List<TimeExpression> timeExpressions, SUTime.TimeIndex timeIndex) {
        if (timeExpressions == null) {
            return null;
        }
        ArrayList<CoreMap> coreMaps = new ArrayList<CoreMap>(timeExpressions.size());
        for (TimeExpression te : timeExpressions) {
            Timex timex;
            Map<String, String> timexAttributes;
            String text;
            CoreMap cm;
            block8: {
                cm = te.getAnnotation();
                SUTime.Temporal temporal = te.getTemporal();
                if (temporal == null) continue;
                String origText = (String)annotation.get(CoreAnnotations.TextAnnotation.class);
                text = (String)cm.get(CoreAnnotations.TextAnnotation.class);
                if (origText != null) {
                    ChunkAnnotationUtils.annotateChunkText(cm, annotation);
                    text = (String)cm.get(CoreAnnotations.TextAnnotation.class);
                }
                try {
                    SUTime.Range rangeTemporal;
                    timexAttributes = temporal.getTimexAttributes(timeIndex);
                    if (!this.options.includeRange || (rangeTemporal = temporal.getRange()) == null) break block8;
                    timexAttributes.put("range", rangeTemporal.toString());
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Failed to get attributes from " + text + ", timeIndex " + timeIndex, e);
                    continue;
                }
            }
            try {
                timex = Timex.fromMap(text, timexAttributes);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to process " + text + " with attributes " + timexAttributes, e);
                continue;
            }
            cm.set(TimeAnnotations.TimexAnnotation.class, timex);
            if (timex != null) {
                coreMaps.add(cm);
                continue;
            }
            logger.warning("No timex expression for: " + text);
        }
        return coreMaps;
    }

    public List<TimeExpression> extractTimeExpressions(CoreMap annotation, String docDateStr) {
        TimeExpression childTe;
        List children;
        List<CoreMap> mergedNumbers = NumberNormalizer.findAndMergeNumbers(annotation);
        annotation.set(CoreAnnotations.NumerizedTokensAnnotation.class, mergedNumbers);
        SUTime.Time docDate = SUTime.parseDateTime(docDateStr);
        List matchedExpressions = this.expressionExtractor.extractExpressions(annotation);
        ArrayList<TimeExpression> timeExpressions = new ArrayList<TimeExpression>(matchedExpressions.size());
        for (MatchedExpression expr : matchedExpressions) {
            if (expr instanceof TimeExpression) {
                timeExpressions.add((TimeExpression)expr);
                continue;
            }
            timeExpressions.add(new TimeExpression(expr));
        }
        if (timeExpressions != null) {
            this.resolveTimeExpressions(annotation, timeExpressions, docDate);
        }
        if (this.options.restrictToTimex3) {
            ArrayList<TimeExpression> kept = new ArrayList<TimeExpression>(timeExpressions.size());
            for (TimeExpression te : timeExpressions) {
                if (te.getTemporal() != null && te.getTemporal().getTimexValue() != null) {
                    kept.add(te);
                    continue;
                }
                children = (List)te.getAnnotation().get(TimeExpression.ChildrenAnnotation.class);
                if (children == null) continue;
                for (CoreMap child : children) {
                    childTe = (TimeExpression)child.get(TimeExpression.Annotation.class);
                    if (childTe == null) continue;
                    this.resolveTimeExpression(annotation, childTe, docDate);
                    if (childTe.getTemporal() == null || childTe.getTemporal().getTimexValue() == null) continue;
                    kept.add(childTe);
                }
            }
            timeExpressions = kept;
        }
        if (this.options.includeNested) {
            ArrayList<TimeExpression> nestedTimeExpressions = new ArrayList<TimeExpression>();
            for (TimeExpression te : timeExpressions) {
                if (!te.isIncludeNested() || (children = (List)te.getAnnotation().get(TimeExpression.ChildrenAnnotation.class)) == null) continue;
                for (CoreMap child : children) {
                    childTe = (TimeExpression)child.get(TimeExpression.Annotation.class);
                    if (childTe == null) continue;
                    nestedTimeExpressions.add(childTe);
                }
            }
            this.resolveTimeExpressions(annotation, nestedTimeExpressions, docDate);
            timeExpressions.addAll(nestedTimeExpressions);
        }
        Collections.sort(timeExpressions, MatchedExpression.EXPR_TOKEN_OFFSETS_NESTED_FIRST_COMPARATOR);
        if (timeExpressions != null) {
            this.resolveTimeExpressions(annotation, timeExpressions, docDate);
        }
        return timeExpressions;
    }

    private void resolveTimeExpression(CoreMap annotation, TimeExpression te, SUTime.Time docDate) {
        SUTime.Temporal temporal = te.getTemporal();
        if (temporal != null) {
            try {
                int flags = this.timexPatterns.determineRelFlags(annotation, te);
                SUTime.Temporal grounded = temporal.resolve(docDate, flags);
                if (grounded == null) {
                    logger.warning("Error resolving " + temporal + ", using docDate=" + docDate);
                }
                if (grounded != temporal) {
                    te.origTemporal = temporal;
                    te.setTemporal(grounded);
                }
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "Error resolving " + temporal, ex);
            }
        }
    }

    private void resolveTimeExpressions(CoreMap annotation, List<TimeExpression> timeExpressions, SUTime.Time docDate) {
        for (TimeExpression te : timeExpressions) {
            this.resolveTimeExpression(annotation, te, docDate);
        }
    }
}

