#
# (c) Jan Gehring <jan.gehring@gmail.com>
#
# vim: set ts=2 sw=2 tw=0:
# vim: set expandtab:

package Rex::Test::Base::has_file_content;

use strict;
use warnings;

our $VERSION = '1.7.0_02'; # TRIAL VERSION

use Rex -base;
use base qw(Rex::Test::Base);

sub new {
  my $that  = shift;
  my $proto = ref($that) || $that;
  my $self  = {@_};

  bless( $self, $proto );

  my ( $pkg, $file ) = caller(0);

  return $self;
}

sub run_test {
  my ( $self, $file, $wanted_content ) = @_;
  my $content = cat $file;

  $self->ok( $content eq $wanted_content, "File $file has content: $content" );
}

1;
